/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.ameta;

import com.oracle.graal.pointsto.meta.AnalysisField;
import com.oracle.svm.core.BuildPhaseProvider;
import com.oracle.svm.hosted.SVMHost;
import com.oracle.svm.hosted.meta.SharedConstantFieldProvider;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaField;
import org.graalvm.compiler.core.common.spi.ConstantFieldProvider;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

@Platforms(value={Platform.HOSTED_ONLY.class})
public class AnalysisConstantFieldProvider
extends SharedConstantFieldProvider {
    public AnalysisConstantFieldProvider(MetaAccessProvider metaAccess, SVMHost hostVM) {
        super(metaAccess, hostVM);
    }

    @Override
    public <T> T readConstantField(ResolvedJavaField f, ConstantFieldProvider.ConstantFieldTool<T> analysisTool) {
        AnalysisField field = (AnalysisField)f;
        if (SVMHost.isUnknownObjectField((ResolvedJavaField)field) || SVMHost.isUnknownPrimitiveField(field)) {
            return null;
        }
        T foldedValue = super.readConstantField((ResolvedJavaField)field, analysisTool);
        if (foldedValue != null && !BuildPhaseProvider.isAnalysisFinished()) {
            field.registerAsFolded(AnalysisConstantFieldProvider.nonNullReason(analysisTool.getReason()));
        }
        return foldedValue;
    }

    @Override
    protected AnalysisField asAnalysisField(ResolvedJavaField field) {
        return (AnalysisField)field;
    }

    private static Object nonNullReason(Object reason) {
        return reason == null ? "Unknown constant fold location." : reason;
    }
}

