/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted;

import com.oracle.svm.core.feature.AutomaticallyRegisteredFeature;
import com.oracle.svm.core.feature.InternalFeature;
import com.oracle.svm.core.jdk.SystemInOutErrSupport;
import com.oracle.svm.hosted.NativeImageSystemIOWrappers;
import java.io.InputStream;
import java.io.PrintStream;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.hosted.Feature;

@AutomaticallyRegisteredFeature
public class SystemInOutErrFeature
implements InternalFeature {
    private final InputStream hostedIn = System.in;
    private final PrintStream hostedOut;
    private final PrintStream hostedErr;
    private SystemInOutErrSupport runtime;

    public SystemInOutErrFeature() {
        NativeImageSystemIOWrappers wrappers = NativeImageSystemIOWrappers.singleton();
        this.hostedOut = wrappers.outWrapper;
        this.hostedErr = wrappers.errWrapper;
    }

    public void afterRegistration(Feature.AfterRegistrationAccess access) {
        this.runtime = new SystemInOutErrSupport();
        ImageSingletons.add(SystemInOutErrSupport.class, (Object)this.runtime);
    }

    public void duringSetup(Feature.DuringSetupAccess access) {
        NativeImageSystemIOWrappers.singleton().verifySystemOutErrReplacement();
        access.registerObjectReplacer(this::replaceStreams);
    }

    public void cleanup() {
        NativeImageSystemIOWrappers.singleton().verifySystemOutErrReplacement();
    }

    Object replaceStreams(Object object) {
        if (object == this.hostedIn) {
            return this.runtime.in();
        }
        if (object == this.hostedOut) {
            return this.runtime.out();
        }
        if (object == this.hostedErr) {
            return this.runtime.err();
        }
        return object;
    }
}

