/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted;

import com.oracle.svm.core.SubstrateTargetDescription;
import com.oracle.svm.core.feature.AutomaticallyRegisteredFeature;
import com.oracle.svm.core.feature.InternalFeature;
import com.oracle.svm.core.riscv64.RISCV64CPUFeatureAccess;
import com.oracle.svm.core.riscv64.RISCV64LibCHelper;
import com.oracle.svm.hosted.CPUFeatureAccessFeatureBase;
import com.oracle.svm.hosted.FeatureImpl;
import com.oracle.svm.util.ReflectionUtil;
import java.lang.reflect.Method;
import java.util.EnumSet;
import jdk.vm.ci.code.Architecture;
import org.graalvm.compiler.core.riscv64.RISCV64ReflectionUtil;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.hosted.Feature;

@AutomaticallyRegisteredFeature
@Platforms(value={Platform.RISCV64.class})
class RISCV64CPUFeatureAccessFeature
extends CPUFeatureAccessFeatureBase
implements InternalFeature {
    RISCV64CPUFeatureAccessFeature() {
    }

    public void beforeAnalysis(Feature.BeforeAnalysisAccess arg) {
        SubstrateTargetDescription targetDescription = (SubstrateTargetDescription)((Object)ImageSingletons.lookup(SubstrateTargetDescription.class));
        Method getFeatures = ReflectionUtil.lookupMethod(Architecture.class, (String)"getFeatures", (Class[])new Class[0]);
        Object buildtimeCPUFeatures = RISCV64ReflectionUtil.invokeMethod((Method)getFeatures, (Object)targetDescription.arch, (Object[])new Object[0]);
        Class riscv64CPUFeature = RISCV64ReflectionUtil.lookupClass((boolean)false, (String)"jdk.vm.ci.riscv64.RISCV64$CPUFeature");
        Method values = ReflectionUtil.lookupMethod((Class)riscv64CPUFeature, (String)"values", (Class[])new Class[0]);
        Method initializeCPUFeatureAccessData = ReflectionUtil.lookupMethod(CPUFeatureAccessFeatureBase.class, (String)"initializeCPUFeatureAccessData", (Class[])new Class[]{Enum[].class, EnumSet.class, Class.class, FeatureImpl.BeforeAnalysisAccessImpl.class});
        RISCV64ReflectionUtil.invokeMethod((Method)initializeCPUFeatureAccessData, (Object)this, (Object[])new Object[]{RISCV64ReflectionUtil.invokeMethod((Method)values, null, (Object[])new Object[0]), buildtimeCPUFeatures, RISCV64LibCHelper.CPUFeatures.class, arg});
    }

    @Override
    protected RISCV64CPUFeatureAccess createCPUFeatureAccessSingleton(EnumSet<?> buildtimeCPUFeatures, int[] offsets, byte[] errorMessageBytes, byte[] buildtimeFeatureMaskBytes) {
        return new RISCV64CPUFeatureAccess(buildtimeCPUFeatures, offsets, errorMessageBytes, buildtimeFeatureMaskBytes);
    }
}

