/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.posix.linux;

import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.config.ConfigurationValues;
import com.oracle.svm.core.config.ObjectLayout;
import com.oracle.svm.core.feature.AutomaticallyRegisteredFeature;
import com.oracle.svm.core.feature.InternalFeature;
import com.oracle.svm.core.locks.ClassInstanceReplacer;
import com.oracle.svm.core.locks.VMSemaphore;
import com.oracle.svm.core.posix.PosixVMSemaphoreSupport;
import com.oracle.svm.core.posix.headers.Semaphore;
import com.oracle.svm.core.posix.linux.LinuxVMSemaphore;
import com.oracle.svm.core.posix.linux.LinuxVMSemaphoreSupport;
import jdk.vm.ci.meta.JavaKind;
import org.graalvm.compiler.core.common.NumUtil;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.c.struct.SizeOf;
import org.graalvm.nativeimage.hosted.Feature;
import org.graalvm.word.WordFactory;

@AutomaticallyRegisteredFeature
final class LinuxVMSemaphoreFeature
implements InternalFeature {
    private final ClassInstanceReplacer<VMSemaphore, VMSemaphore> semaphoreReplacer = new ClassInstanceReplacer<VMSemaphore, VMSemaphore>(VMSemaphore.class){

        @Override
        protected VMSemaphore createReplacement(VMSemaphore source) {
            return new LinuxVMSemaphore();
        }
    };

    LinuxVMSemaphoreFeature() {
    }

    public boolean isInConfiguration(Feature.IsInConfigurationAccess access) {
        return SubstrateOptions.MultiThreaded.getValue();
    }

    public void duringSetup(Feature.DuringSetupAccess access) {
        ImageSingletons.add(PosixVMSemaphoreSupport.class, (Object)new LinuxVMSemaphoreSupport());
        access.registerObjectReplacer(this.semaphoreReplacer);
    }

    public void beforeCompilation(Feature.BeforeCompilationAccess access) {
        int wordSize = ConfigurationValues.getTarget().wordSize;
        assert (wordSize == 8 || wordSize == 4) : "Unsupported architecture bit width";
        int alignment = wordSize == 8 ? wordSize : 2 * wordSize;
        ObjectLayout layout = ConfigurationValues.getObjectLayout();
        int baseOffset = layout.getArrayBaseOffset(JavaKind.Byte);
        int nextIndex = NumUtil.roundUp((int)baseOffset, (int)alignment) - baseOffset;
        LinuxVMSemaphore[] semaphores = this.semaphoreReplacer.getReplacements().toArray(new LinuxVMSemaphore[0]);
        int semaphoreSize = NumUtil.roundUp((int)SizeOf.get(Semaphore.sem_t.class), (int)alignment);
        for (LinuxVMSemaphore semaphore : semaphores) {
            long offset = layout.getArrayElementOffset(JavaKind.Byte, nextIndex);
            assert (offset % (long)alignment == 0L);
            semaphore.structOffset = WordFactory.unsigned((long)offset);
            nextIndex += semaphoreSize;
        }
        LinuxVMSemaphoreSupport semaphoreSupport = (LinuxVMSemaphoreSupport)PosixVMSemaphoreSupport.singleton();
        semaphoreSupport.semaphores = semaphores;
        semaphoreSupport.semaphoreStructs = new byte[nextIndex];
    }
}

