/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.posix;

import com.oracle.svm.core.RegisterDumper;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.c.function.CEntryPointOptions;
import com.oracle.svm.core.graal.stackvalue.UnsafeStackValue;
import com.oracle.svm.core.headers.LibC;
import com.oracle.svm.core.heap.RestrictHeapAccess;
import com.oracle.svm.core.option.HostedOptionKey;
import com.oracle.svm.core.posix.PosixUtils;
import com.oracle.svm.core.posix.headers.Pthread;
import com.oracle.svm.core.posix.headers.Signal;
import com.oracle.svm.core.posix.headers.Time;
import com.oracle.svm.core.sampler.SubstrateSigprofHandler;
import com.oracle.svm.core.util.VMError;
import org.graalvm.nativeimage.IsolateThread;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.StackValue;
import org.graalvm.nativeimage.c.function.CEntryPoint;
import org.graalvm.nativeimage.c.function.CEntryPointLiteral;
import org.graalvm.nativeimage.c.function.CodePointer;
import org.graalvm.nativeimage.c.struct.SizeOf;
import org.graalvm.nativeimage.c.type.VoidPointer;
import org.graalvm.word.Pointer;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordFactory;

public class PosixSubstrateSigprofHandler
extends SubstrateSigprofHandler {
    private static final CEntryPointLiteral<Signal.AdvancedSignalDispatcher> advancedSignalDispatcher = CEntryPointLiteral.create(PosixSubstrateSigprofHandler.class, (String)"dispatch", (Class[])new Class[]{Integer.TYPE, Signal.siginfo_t.class, Signal.ucontext_t.class});

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public PosixSubstrateSigprofHandler() {
    }

    @CEntryPoint(include=CEntryPoint.NotIncludedAutomatically.class, publishAs=CEntryPoint.Publish.NotPublished)
    @CEntryPointOptions(prologue=CEntryPointOptions.NoPrologue.class, epilogue=CEntryPointOptions.NoEpilogue.class)
    @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, reason="Must not allocate in sigprof signal handler.")
    @Uninterruptible(reason="Signal handler may only execute uninterruptible code.")
    private static void dispatch(int signalNumber, Signal.siginfo_t sigInfo, Signal.ucontext_t uContext) {
        if (PosixSubstrateSigprofHandler.tryEnterIsolate()) {
            CodePointer ip = (CodePointer)RegisterDumper.singleton().getIP(uContext);
            Pointer sp = (Pointer)RegisterDumper.singleton().getSP(uContext);
            PosixSubstrateSigprofHandler.tryUninterruptibleStackWalk(ip, sp);
        }
    }

    private static void registerSigprofSignal(Signal.AdvancedSignalDispatcher dispatcher) {
        VMError.guarantee(SubstrateOptions.EnableSignalHandling.getValue(), "Trying to install a signal handler while signal handling is disabled.");
        int structSigActionSize = SizeOf.get(Signal.sigaction.class);
        Signal.sigaction structSigAction = (Signal.sigaction)UnsafeStackValue.get(structSigActionSize);
        LibC.memset(structSigAction, WordFactory.signed((int)0), WordFactory.unsigned((int)structSigActionSize));
        structSigAction.sa_flags(Signal.SA_SIGINFO() | Signal.SA_NODEFER() | Signal.SA_RESTART());
        structSigAction.sa_sigaction(dispatcher);
        Signal.sigaction(Signal.SignalEnum.SIGPROF.getCValue(), structSigAction, (Signal.sigaction)WordFactory.nullPointer());
    }

    @Override
    protected void updateInterval() {
        PosixSubstrateSigprofHandler.updateInterval(this.newIntervalMillis);
    }

    private static void updateInterval(long ms) {
        Time.itimerval newValue = UnsafeStackValue.get(Time.itimerval.class);
        newValue.it_value().set_tv_sec(ms / 1000L);
        newValue.it_value().set_tv_usec(ms % 1000L * 1000L);
        newValue.it_interval().set_tv_sec(ms / 1000L);
        newValue.it_interval().set_tv_usec(ms % 1000L * 1000L);
        int status = Time.NoTransitions.setitimer(Time.TimerTypeEnum.ITIMER_PROF, newValue, (Time.itimerval)WordFactory.nullPointer());
        PosixUtils.checkStatusIs0(status, "setitimer(which, newValue, oldValue): wrong arguments.");
    }

    @Override
    protected void installSignalHandler() {
        PosixSubstrateSigprofHandler.registerSigprofSignal((Signal.AdvancedSignalDispatcher)advancedSignalDispatcher.getFunctionPointer());
        this.updateInterval();
    }

    @Override
    protected void uninstallSignalHandler() {
        PosixSubstrateSigprofHandler.updateInterval(0L);
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    protected UnsignedWord createNativeThreadLocal() {
        Pthread.pthread_key_tPointer key = (Pthread.pthread_key_tPointer)StackValue.get(Pthread.pthread_key_tPointer.class);
        PosixUtils.checkStatusIs0(Pthread.pthread_key_create(key, WordFactory.nullPointer()), "pthread_key_create(key, keyDestructor): failed.");
        return key.read();
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    protected void deleteNativeThreadLocal(UnsignedWord key) {
        int resultCode = Pthread.pthread_key_delete((Pthread.pthread_key_t)key);
        PosixUtils.checkStatusIs0(resultCode, "pthread_key_delete(key): failed.");
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    protected void setNativeThreadLocalValue(UnsignedWord key, IsolateThread value) {
        int resultCode = Pthread.pthread_setspecific((Pthread.pthread_key_t)key, (VoidPointer)value);
        PosixUtils.checkStatusIs0(resultCode, "pthread_setspecific(key, value): wrong arguments.");
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    protected IsolateThread getNativeThreadLocalValue(UnsignedWord key) {
        return (IsolateThread)Pthread.pthread_getspecific((Pthread.pthread_key_t)key);
    }

    public static class Options {
        public static final HostedOptionKey<Boolean> SignalHandlerBasedExecutionSampler = new HostedOptionKey<Boolean>(false);
    }
}

