/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.option;

import com.oracle.svm.common.option.LocatableOption;
import com.oracle.svm.common.option.MultiOptionValue;
import com.oracle.svm.core.option.OptionOrigin;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.util.ClassUtil;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.graalvm.collections.Pair;

public abstract class LocatableMultiOptionValue<T>
implements MultiOptionValue<T> {
    protected static final String NO_DELIMITER = "";
    private final String delimiter;
    private final Class<T> valueType;
    private final List<Pair<T, String>> values;

    private LocatableMultiOptionValue(Class<T> valueType, String delimiter, List<T> defaults) {
        this.valueType = valueType;
        this.delimiter = delimiter;
        this.values = new ArrayList<Pair<T, String>>();
        this.values.addAll(defaults.stream().map(val -> Pair.createLeft((Object)val)).collect(Collectors.toList()));
    }

    private LocatableMultiOptionValue(LocatableMultiOptionValue<T> other) {
        this.valueType = other.valueType;
        this.delimiter = other.delimiter;
        this.values = new ArrayList<Pair<T, String>>(other.values);
    }

    public Class<T> getValueType() {
        return this.valueType;
    }

    public String getDelimiter() {
        return this.delimiter;
    }

    public void valueUpdate(Object value) {
        Class<?> rawValueElementType;
        Object rawValue = LocatableOption.rawValue((Object)value);
        String origin = LocatableOption.valueOrigin((Object)value);
        Class<?> rawValueClass = rawValue.getClass();
        boolean multipleElements = rawValueClass.isArray();
        Class<?> clazz = rawValueElementType = multipleElements ? rawValueClass.getComponentType() : rawValueClass;
        if (!this.valueType.isAssignableFrom(rawValueElementType)) {
            VMError.shouldNotReachHere("Cannot update LocatableMultiOptionValue of type " + this.valueType + " with value of type " + rawValueElementType);
        }
        if (multipleElements) {
            for (Object singleRawValue : (Object[])rawValue) {
                this.values.add(Pair.create(this.valueType.cast(singleRawValue), (Object)origin));
            }
        } else {
            this.values.add(Pair.create(this.valueType.cast(rawValue), (Object)origin));
        }
    }

    public List<T> values() {
        return this.getValuesWithOrigins().map(Pair::getLeft).collect(Collectors.toList());
    }

    public Optional<T> lastValue() {
        return this.lastValueWithOrigin().map(Pair::getLeft);
    }

    public Optional<Pair<T, OptionOrigin>> lastValueWithOrigin() {
        if (this.values.isEmpty()) {
            return Optional.empty();
        }
        Pair<T, String> pair = this.values.get(this.values.size() - 1);
        return Optional.of(Pair.create((Object)pair.getLeft(), (Object)OptionOrigin.from((String)pair.getRight())));
    }

    public Stream<Pair<T, OptionOrigin>> getValuesWithOrigins() {
        if (this.values.isEmpty()) {
            return Stream.empty();
        }
        return this.values.stream().map(pair -> Pair.create((Object)pair.getLeft(), (Object)OptionOrigin.from((String)pair.getRight())));
    }

    public String toString() {
        return "<" + ClassUtil.getUnqualifiedName(this.valueType).toLowerCase() + ">*";
    }

    public static final class Paths
    extends LocatableMultiOptionValue<Path> {
        private Paths(Paths other) {
            super(other);
        }

        public MultiOptionValue<Path> createCopy() {
            return new Paths(this);
        }

        private Paths(String delimiter, List<Path> defaultPaths) {
            super(Path.class, delimiter, defaultPaths);
        }

        public static Paths build() {
            return new Paths(LocatableMultiOptionValue.NO_DELIMITER, List.of());
        }

        public static Paths buildWithCommaDelimiter() {
            return new Paths(",", List.of());
        }

        public static Paths buildWithCustomDelimiter(String delimiter) {
            return new Paths(delimiter, List.of());
        }

        public static Paths buildWithDefaults(Path ... defaultPaths) {
            return new Paths(LocatableMultiOptionValue.NO_DELIMITER, List.of(defaultPaths));
        }
    }

    public static final class Strings
    extends LocatableMultiOptionValue<String> {
        private Strings(Strings other) {
            super(other);
        }

        public MultiOptionValue<String> createCopy() {
            return new Strings(this);
        }

        private Strings(String delimiter, List<String> defaultStrings) {
            super(String.class, delimiter, defaultStrings);
        }

        public static Strings build() {
            return new Strings(LocatableMultiOptionValue.NO_DELIMITER, List.of());
        }

        public static Strings buildWithCommaDelimiter() {
            return new Strings(",", List.of());
        }

        public static Strings buildWithDefaults(String ... defaultStrings) {
            return new Strings(LocatableMultiOptionValue.NO_DELIMITER, List.of(defaultStrings));
        }
    }
}

