/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jfr;

import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.jfr.JfrBuffer;
import com.oracle.svm.core.jfr.JfrBufferAccess;
import com.oracle.svm.core.jfr.JfrNativeEventWriterData;
import com.oracle.svm.core.jfr.SubstrateJVM;
import org.graalvm.word.Pointer;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordFactory;

public final class JfrNativeEventWriterDataAccess {
    private JfrNativeEventWriterDataAccess() {
    }

    @Uninterruptible(reason="Accesses a JFR buffer", callerMustBe=true)
    public static void initialize(JfrNativeEventWriterData data, JfrBuffer buffer) {
        if (buffer.isNonNull()) {
            assert (JfrBufferAccess.verify(buffer));
            data.setJfrBuffer(buffer);
            data.setStartPos(buffer.getCommittedPos());
            data.setCurrentPos(buffer.getCommittedPos());
            data.setEndPos(JfrBufferAccess.getDataEnd(buffer));
        } else {
            data.setJfrBuffer((JfrBuffer)WordFactory.nullPointer());
            data.setStartPos((Pointer)WordFactory.nullPointer());
            data.setCurrentPos((Pointer)WordFactory.nullPointer());
            data.setEndPos((Pointer)WordFactory.nullPointer());
        }
    }

    @Uninterruptible(reason="Accesses a JFR buffer", callerMustBe=true)
    public static void initializeThreadLocalNativeBuffer(JfrNativeEventWriterData data) {
        JfrBuffer nativeBuffer = SubstrateJVM.getThreadLocal().getNativeBuffer();
        JfrNativeEventWriterDataAccess.initialize(data, nativeBuffer);
    }

    @Uninterruptible(reason="Accesses a native JFR buffer.", callerMustBe=true)
    public static boolean verify(JfrNativeEventWriterData data) {
        if (data.isNull() || !JfrBufferAccess.verify(data.getJfrBuffer())) {
            return false;
        }
        JfrBuffer buffer = data.getJfrBuffer();
        Pointer dataStart = JfrBufferAccess.getDataStart(buffer);
        Pointer dataEnd = JfrBufferAccess.getDataEnd(buffer);
        return data.getStartPos() == buffer.getCommittedPos() && (data.getEndPos() == dataEnd || data.getEndPos().isNull()) && data.getCurrentPos().aboveOrEqual((UnsignedWord)dataStart) && data.getCurrentPos().belowOrEqual((UnsignedWord)dataEnd) && data.getCurrentPos().aboveOrEqual((UnsignedWord)data.getStartPos());
    }
}

