/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jfr;

import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.jfr.JfrBuffer;
import com.oracle.svm.core.jfr.JfrBufferNode;
import com.oracle.svm.core.thread.NativeSpinLockUtils;
import com.oracle.svm.core.thread.VMOperation;
import org.graalvm.nativeimage.CurrentIsolate;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.IsolateThread;
import org.graalvm.nativeimage.c.struct.SizeOf;
import org.graalvm.nativeimage.c.type.CIntPointer;
import org.graalvm.nativeimage.impl.UnmanagedMemorySupport;
import org.graalvm.word.Pointer;
import org.graalvm.word.PointerBase;
import org.graalvm.word.WordFactory;

public final class JfrBufferNodeAccess {
    private JfrBufferNodeAccess() {
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static JfrBufferNode allocate(JfrBuffer buffer) {
        JfrBufferNode node = (JfrBufferNode)((UnmanagedMemorySupport)ImageSingletons.lookup(UnmanagedMemorySupport.class)).malloc(SizeOf.unsigned(JfrBufferNode.class));
        if (node.isNonNull()) {
            node.setBuffer(buffer);
            node.setNext((JfrBufferNode)WordFactory.nullPointer());
            node.setLockOwner((IsolateThread)WordFactory.nullPointer());
            NativeSpinLockUtils.initialize(JfrBufferNodeAccess.ptrToLock(node));
        }
        return node;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static void free(JfrBufferNode node) {
        ((UnmanagedMemorySupport)ImageSingletons.lookup(UnmanagedMemorySupport.class)).free((PointerBase)node);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static JfrBuffer getBuffer(JfrBufferNode node) {
        assert (JfrBufferNodeAccess.isLockedByCurrentThread(node) || VMOperation.isInProgressAtSafepoint());
        return node.getBuffer();
    }

    @Uninterruptible(reason="Locking without transition requires that the whole critical section is uninterruptible.", callerMustBe=true)
    public static boolean tryLock(JfrBufferNode node) {
        assert (node.isNonNull());
        if (NativeSpinLockUtils.tryLock(JfrBufferNodeAccess.ptrToLock(node))) {
            JfrBufferNodeAccess.setLockOwner(node);
            return true;
        }
        return false;
    }

    @Uninterruptible(reason="Locking without transition requires that the whole critical section is uninterruptible.", callerMustBe=true)
    public static void lockNoTransition(JfrBufferNode node) {
        assert (node.isNonNull());
        NativeSpinLockUtils.lockNoTransition(JfrBufferNodeAccess.ptrToLock(node));
        JfrBufferNodeAccess.setLockOwner(node);
    }

    @Uninterruptible(reason="Locking without transition requires that the whole critical section is uninterruptible.", callerMustBe=true)
    public static void unlock(JfrBufferNode node) {
        assert (node.isNonNull());
        assert (JfrBufferNodeAccess.isLockedByCurrentThread(node));
        node.setLockOwner((IsolateThread)WordFactory.nullPointer());
        NativeSpinLockUtils.unlock(JfrBufferNodeAccess.ptrToLock(node));
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static boolean isLockedByCurrentThread(JfrBufferNode node) {
        assert (CurrentIsolate.getCurrentThread().isNonNull());
        return node.isNonNull() && node.getLockOwner() == CurrentIsolate.getCurrentThread();
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static void setLockOwner(JfrBufferNode node) {
        assert (node.getLockOwner().isNull());
        node.setLockOwner(CurrentIsolate.getCurrentThread());
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static CIntPointer ptrToLock(JfrBufferNode node) {
        return (CIntPointer)((Pointer)node).add(JfrBufferNode.offsetOfLock());
    }
}

