/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jdk;

import com.oracle.svm.core.jdk.ClassLoaderSupport;
import java.util.HashMap;
import java.util.concurrent.ConcurrentHashMap;
import org.graalvm.nativeimage.hosted.FieldValueTransformer;

class PackageFieldTransformer
implements FieldValueTransformer {
    PackageFieldTransformer() {
    }

    public Object transform(Object receiver, Object originalValue) {
        assert (receiver instanceof ClassLoader);
        boolean useConcurrentHashMap = originalValue instanceof ConcurrentHashMap;
        ConcurrentHashMap<String, Package> packages = ClassLoaderSupport.getRegisteredPackages((ClassLoader)receiver);
        if (packages == null) {
            return useConcurrentHashMap ? new ConcurrentHashMap() : new HashMap();
        }
        return useConcurrentHashMap ? packages : new HashMap<String, Package>(packages);
    }
}

