/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jdk;

import com.oracle.svm.core.util.VMError;
import com.oracle.svm.util.ReflectionUtil;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import jdk.internal.loader.ClassLoaderValue;
import jdk.internal.module.ServicesCatalog;
import org.graalvm.nativeimage.hosted.FieldValueTransformer;

final class ClassLoaderValueMapFieldValueTransformer
implements FieldValueTransformer {
    ClassLoaderValueMapFieldValueTransformer() {
    }

    public Object transform(Object receiver, Object originalValue) {
        if (originalValue == null) {
            return null;
        }
        ConcurrentHashMap original = (ConcurrentHashMap)originalValue;
        List<ClassLoaderValue> clvs = Arrays.asList((ClassLoaderValue)ReflectionUtil.readField(ServicesCatalog.class, (String)"CLV", null), (ClassLoaderValue)ReflectionUtil.readField(ModuleLayer.class, (String)"CLV", null));
        ConcurrentHashMap res = new ConcurrentHashMap();
        for (ClassLoaderValue clv : clvs) {
            if (clv == null) {
                throw VMError.shouldNotReachHere("Field must not be null. Please check what changed in the JDK.");
            }
            Object catalog = original.get(clv);
            if (catalog == null) continue;
            res.put(clv, catalog);
        }
        return res;
    }
}

