/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.handles;

import java.lang.ref.WeakReference;
import jdk.internal.misc.Unsafe;
import org.graalvm.nativeimage.ObjectHandle;
import org.graalvm.nativeimage.ObjectHandles;
import org.graalvm.word.ComparableWord;
import org.graalvm.word.SignedWord;
import org.graalvm.word.WordBase;
import org.graalvm.word.WordFactory;

public final class ObjectHandlesImpl
implements ObjectHandles {
    private static final int MAX_FIRST_BUCKET_CAPACITY = 1024;
    private final SignedWord rangeMin;
    private final SignedWord rangeMax;
    private final SignedWord nullHandle;
    private final Object[][] buckets;
    private volatile long unusedHandleSearchIndex = 0L;
    static final /* synthetic */ boolean $assertionsDisabled;

    public ObjectHandlesImpl() {
        this(WordFactory.signed((int)1), WordFactory.signed((long)Long.MAX_VALUE), WordFactory.signed((int)0));
    }

    public ObjectHandlesImpl(SignedWord rangeMin, SignedWord rangeMax, SignedWord nullHandle) {
        if (!($assertionsDisabled || rangeMin.lessThan(rangeMax) && rangeMax.rawValue() - rangeMin.rawValue() >= 0L)) {
            throw new AssertionError((Object)"rangeMin < rangeMax and range must fit in positive long range");
        }
        if (!($assertionsDisabled || nullHandle.lessThan(rangeMin) || nullHandle.greaterThan(rangeMax))) {
            throw new AssertionError((Object)"null handle must not be part of range");
        }
        this.rangeMin = rangeMin;
        this.rangeMax = rangeMax;
        this.nullHandle = nullHandle;
        long maxIndex = this.toIndex((WordBase)rangeMax);
        int lastBucketIndex = ObjectHandlesImpl.getBucketIndex(maxIndex);
        int lastBucketCapacity = ObjectHandlesImpl.getIndexInBucket(maxIndex) + 1;
        this.buckets = new Object[lastBucketIndex + 1][];
        int firstBucketCapacity = 1024;
        if (lastBucketIndex == 0) {
            firstBucketCapacity = lastBucketCapacity;
        }
        this.buckets[0] = new Object[firstBucketCapacity];
    }

    public boolean isInRange(ObjectHandle handle) {
        return handle.rawValue() >= this.rangeMin.rawValue() && handle.rawValue() <= this.rangeMax.rawValue();
    }

    private static long toIndex(int bucketIndex, int indexInBucket) {
        int bucketBit = 1024 << bucketIndex;
        long displacedIndex = bucketBit + indexInBucket;
        return displacedIndex - 1024L;
    }

    private ObjectHandle toHandle(int bucketIndex, int indexInBucket) {
        long index = ObjectHandlesImpl.toIndex(bucketIndex, indexInBucket);
        return (ObjectHandle)this.rangeMin.add(WordFactory.signed((long)index));
    }

    private long toIndex(WordBase handle) {
        return handle.rawValue() - this.rangeMin.rawValue();
    }

    private static int getBucketIndex(long index) {
        long displacedIndex = 1024L + index;
        return Long.numberOfLeadingZeros(1024L) - Long.numberOfLeadingZeros(displacedIndex);
    }

    private static int getIndexInBucket(long index) {
        long displacedIndex = 1024L + index;
        long bucketBit = Long.highestOneBit(displacedIndex);
        return Math.toIntExact(bucketBit ^ displacedIndex);
    }

    private static long getObjectArrayByteOffset(int index) {
        return Unsafe.getUnsafe().arrayBaseOffset(Object[].class) + index * Unsafe.getUnsafe().arrayIndexScale(Object[].class);
    }

    private Object[] getBucket(int bucketIndex) {
        Object[] bucket = this.buckets[bucketIndex];
        if (bucket == null) {
            bucket = (Object[])Unsafe.getUnsafe().getObjectVolatile(this.buckets, ObjectHandlesImpl.getObjectArrayByteOffset(bucketIndex));
        }
        return bucket;
    }

    /*
     * Unable to fully structure code
     */
    public ObjectHandle create(Object obj) {
        if (obj == null) {
            return (ObjectHandle)this.nullHandle;
        }
        block0: while (true) {
            startIndex = this.unusedHandleSearchIndex;
            startBucketIndex = ObjectHandlesImpl.getBucketIndex(startIndex);
            startIndexInBucket = ObjectHandlesImpl.getIndexInBucket(startIndex);
            bucketIndex = startBucketIndex;
            indexInBucket = startIndexInBucket;
            lastExistingBucketIndex = -1;
            bucket = this.getBucket(bucketIndex);
            while (true) {
                if (indexInBucket < bucket.length) {
                    if (bucket[indexInBucket] == null && Unsafe.getUnsafe().compareAndSetObject(bucket, ObjectHandlesImpl.getObjectArrayByteOffset(indexInBucket), null, obj)) {
                        newSearchIndexInBucket = indexInBucket + 1 < bucket.length ? indexInBucket + 1 : indexInBucket;
                        this.unusedHandleSearchIndex = ObjectHandlesImpl.toIndex(bucketIndex, newSearchIndexInBucket);
                        return this.toHandle(bucketIndex, indexInBucket);
                    }
                    if (bucketIndex != startBucketIndex || ++indexInBucket != startIndexInBucket) continue;
                    if (!ObjectHandlesImpl.$assertionsDisabled && lastExistingBucketIndex == -1) {
                        throw new AssertionError();
                    }
                    maxIndex = this.toIndex((WordBase)this.rangeMax);
                    if (lastExistingBucketIndex == ObjectHandlesImpl.getBucketIndex(maxIndex)) {
                        throw new IllegalStateException("Handle space exhausted");
                    }
                    newBucketIndex = lastExistingBucketIndex + 1;
                    if (this.getBucket(newBucketIndex) != null) continue block0;
                    newBucketCapacity = 1024 << newBucketIndex;
                    if (newBucketIndex == ObjectHandlesImpl.getBucketIndex(maxIndex)) {
                        newBucketCapacity = ObjectHandlesImpl.getIndexInBucket(maxIndex) + 1;
                    }
                    newBucket = new Object[newBucketCapacity];
                    Unsafe.getUnsafe().putObjectVolatile(newBucket, ObjectHandlesImpl.getObjectArrayByteOffset(0), obj);
                    if (Unsafe.getUnsafe().compareAndSetObject(this.buckets, ObjectHandlesImpl.getObjectArrayByteOffset(newBucketIndex), null, newBucket)) ** break;
                    continue block0;
                    this.unusedHandleSearchIndex = ObjectHandlesImpl.toIndex(newBucketIndex, 1);
                    return this.toHandle(newBucketIndex, 0);
                }
                if ((bucket = this.getBucket(++bucketIndex)) == null) {
                    lastExistingBucketIndex = bucketIndex - 1;
                    bucketIndex = 0;
                    bucket = this.getBucket(bucketIndex);
                }
                indexInBucket = 0;
            }
            break;
        }
    }

    public ObjectHandle createWeak(Object obj) {
        return this.create(new HandleWeakReference<Object>(obj));
    }

    public <T> T get(ObjectHandle handle) {
        Object obj = this.doGet(handle);
        if (obj instanceof HandleWeakReference) {
            obj = ((HandleWeakReference)obj).get();
        }
        return (T)obj;
    }

    private Object doGet(ObjectHandle handle) {
        if (handle.equal((ComparableWord)this.nullHandle)) {
            return null;
        }
        if (!this.isInRange(handle)) {
            throw new IllegalArgumentException("Invalid handle");
        }
        long index = this.toIndex((WordBase)handle);
        Object[] bucket = this.getBucket(ObjectHandlesImpl.getBucketIndex(index));
        if (bucket == null) {
            throw new IllegalArgumentException("Invalid handle");
        }
        int indexInBucket = ObjectHandlesImpl.getIndexInBucket(index);
        return Unsafe.getUnsafe().getObjectVolatile(bucket, ObjectHandlesImpl.getObjectArrayByteOffset(indexInBucket));
    }

    public boolean isWeak(ObjectHandle handle) {
        return this.doGet(handle) instanceof HandleWeakReference;
    }

    public void destroy(ObjectHandle handle) {
        if (handle.equal((ComparableWord)this.nullHandle)) {
            return;
        }
        if (!this.isInRange(handle)) {
            throw new IllegalArgumentException("Invalid handle");
        }
        long index = this.toIndex((WordBase)handle);
        Object[] bucket = this.getBucket(ObjectHandlesImpl.getBucketIndex(index));
        if (bucket == null) {
            throw new IllegalArgumentException("Invalid handle");
        }
        int indexInBucket = ObjectHandlesImpl.getIndexInBucket(index);
        Unsafe.getUnsafe().putObjectRelease(bucket, ObjectHandlesImpl.getObjectArrayByteOffset(indexInBucket), null);
    }

    public void destroyWeak(ObjectHandle handle) {
        this.destroy(handle);
    }

    public long computeCurrentCount() {
        long count = 0L;
        int bucketIndex = 0;
        Object[] bucket = this.getBucket(bucketIndex);
        while (bucket != null) {
            for (int i = 0; i < bucket.length; ++i) {
                if (bucket[i] == null) continue;
                ++count;
            }
            bucket = this.getBucket(++bucketIndex);
        }
        return count;
    }

    public long computeCurrentCapacity() {
        long capacity = 0L;
        int bucketIndex = 0;
        Object[] bucket = this.getBucket(bucketIndex);
        while (bucket != null) {
            capacity += (long)bucket.length;
            bucket = this.getBucket(++bucketIndex);
        }
        return capacity;
    }

    static {
        boolean bl = $assertionsDisabled = !ObjectHandlesImpl.class.desiredAssertionStatus();
        if (!$assertionsDisabled && Integer.lowestOneBit(1024) != 1024) {
            throw new AssertionError();
        }
    }

    private static final class HandleWeakReference<T>
    extends WeakReference<T> {
        HandleWeakReference(T referent) {
            super(referent);
        }
    }
}

