/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.graal.snippets.aarch64;

import com.oracle.svm.core.graal.nodes.VaListInitializationNode;
import com.oracle.svm.core.graal.nodes.VaListNextArgNode;
import com.oracle.svm.core.graal.snippets.NodeLoweringProvider;
import com.oracle.svm.core.graal.snippets.SubstrateTemplates;
import com.oracle.svm.core.util.VMError;
import java.util.Map;
import jdk.vm.ci.meta.JavaKind;
import org.graalvm.compiler.api.replacements.Snippet;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.nodes.FixedNode;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.spi.CoreProviders;
import org.graalvm.compiler.nodes.spi.LoweringTool;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.compiler.phases.util.Providers;
import org.graalvm.compiler.replacements.SnippetTemplate;
import org.graalvm.compiler.replacements.Snippets;
import org.graalvm.word.LocationIdentity;
import org.graalvm.word.Pointer;
import org.graalvm.word.WordBase;

final class PosixAArch64VaListSnippets
extends SubstrateTemplates
implements Snippets {
    private static final int GP_OFFSET_LOCATION = 24;
    private static final int MAX_GP_OFFSET = 0;
    private static final int FP_OFFSET_LOCATION = 28;
    private static final int MAX_FP_OFFSET = 0;
    private static final int STACK_AREA_LOCATION = 0;
    private static final int STACK_AREA_GP_ALIGNMENT = 8;
    private static final int STACK_AREA_FP_ALIGNMENT = 8;
    private static final int GP_TOP_LOCATION = 8;
    private static final int FP_TOP_LOCATION = 16;
    private final SnippetTemplate.SnippetInfo vaListInitialization;
    private final SnippetTemplate.SnippetInfo vaArgDouble;
    private final SnippetTemplate.SnippetInfo vaArgFloat;
    private final SnippetTemplate.SnippetInfo vaArgLong;
    private final SnippetTemplate.SnippetInfo vaArgInt;

    @Snippet
    protected static Pointer vaListInitializationSnippet(Pointer vaList) {
        return vaList;
    }

    @Snippet(allowMissingProbabilities=true)
    protected static double vaArgDoubleSnippet(Pointer vaList) {
        int fpOffset = vaList.readInt(28);
        if (fpOffset < 0) {
            Pointer regSaveArea = (Pointer)vaList.readWord(16);
            double v = regSaveArea.readDouble(fpOffset);
            vaList.writeInt(28, fpOffset + 16);
            return v;
        }
        Pointer overflowArgArea = (Pointer)vaList.readWord(0);
        double v = overflowArgArea.readDouble(0);
        vaList.writeWord(0, (WordBase)overflowArgArea.add(8));
        return v;
    }

    @Snippet
    protected static float vaArgFloatSnippet(Pointer vaList) {
        return (float)PosixAArch64VaListSnippets.vaArgDoubleSnippet(vaList);
    }

    @Snippet(allowMissingProbabilities=true)
    protected static long vaArgLongSnippet(Pointer vaList) {
        int gpOffset = vaList.readInt(24);
        if (gpOffset < 0) {
            Pointer regSaveArea = (Pointer)vaList.readWord(8);
            long v = regSaveArea.readLong(gpOffset);
            vaList.writeInt(24, gpOffset + 8);
            return v;
        }
        Pointer overflowArgArea = (Pointer)vaList.readWord(0);
        long v = overflowArgArea.readLong(0);
        vaList.writeWord(0, (WordBase)overflowArgArea.add(8));
        return v;
    }

    @Snippet
    protected static int vaArgIntSnippet(Pointer vaList) {
        return (int)PosixAArch64VaListSnippets.vaArgLongSnippet(vaList);
    }

    public static void registerLowerings(OptionValues options, Providers providers, Map<Class<? extends Node>, NodeLoweringProvider<?>> lowerings) {
        new PosixAArch64VaListSnippets(options, providers, lowerings);
    }

    private PosixAArch64VaListSnippets(OptionValues options, Providers providers, Map<Class<? extends Node>, NodeLoweringProvider<?>> lowerings) {
        super(options, providers);
        lowerings.put(VaListInitializationNode.class, new VaListInitializationSnippetsLowering());
        lowerings.put(VaListNextArgNode.class, new VaListSnippetsLowering());
        this.vaListInitialization = this.snippet(providers, PosixAArch64VaListSnippets.class, "vaListInitializationSnippet", new LocationIdentity[0]);
        this.vaArgDouble = this.snippet(providers, PosixAArch64VaListSnippets.class, "vaArgDoubleSnippet", new LocationIdentity[0]);
        this.vaArgFloat = this.snippet(providers, PosixAArch64VaListSnippets.class, "vaArgFloatSnippet", new LocationIdentity[0]);
        this.vaArgLong = this.snippet(providers, PosixAArch64VaListSnippets.class, "vaArgLongSnippet", new LocationIdentity[0]);
        this.vaArgInt = this.snippet(providers, PosixAArch64VaListSnippets.class, "vaArgIntSnippet", new LocationIdentity[0]);
    }

    protected class VaListInitializationSnippetsLowering
    implements NodeLoweringProvider<VaListInitializationNode> {
        protected VaListInitializationSnippetsLowering() {
        }

        @Override
        public void lower(VaListInitializationNode node, LoweringTool tool) {
            SnippetTemplate.Arguments args = new SnippetTemplate.Arguments(PosixAArch64VaListSnippets.this.vaListInitialization, node.graph().getGuardsStage(), tool.getLoweringStage());
            args.add("vaList", (Object)node.getVaList());
            PosixAArch64VaListSnippets.this.template((CoreProviders)tool, (ValueNode)node, args).instantiate(tool.getMetaAccess(), (FixedNode)node, SnippetTemplate.DEFAULT_REPLACER, args);
        }
    }

    protected class VaListSnippetsLowering
    implements NodeLoweringProvider<VaListNextArgNode> {
        protected VaListSnippetsLowering() {
        }

        @Override
        public void lower(VaListNextArgNode node, LoweringTool tool) {
            SnippetTemplate.Arguments args = new SnippetTemplate.Arguments(switch (node.getStackKind()) {
                case JavaKind.Double -> PosixAArch64VaListSnippets.this.vaArgDouble;
                case JavaKind.Float -> PosixAArch64VaListSnippets.this.vaArgFloat;
                case JavaKind.Long -> PosixAArch64VaListSnippets.this.vaArgLong;
                case JavaKind.Int -> PosixAArch64VaListSnippets.this.vaArgInt;
                default -> throw VMError.shouldNotReachHere();
            }, node.graph().getGuardsStage(), tool.getLoweringStage());
            args.add("vaList", (Object)node.getVaList());
            PosixAArch64VaListSnippets.this.template((CoreProviders)tool, (ValueNode)node, args).instantiate(tool.getMetaAccess(), (FixedNode)node, SnippetTemplate.DEFAULT_REPLACER, args);
        }
    }
}

