/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.genscavenge;

import com.oracle.svm.core.genscavenge.AdaptiveWeightedAverage;

class AdaptivePaddedAverage
extends AdaptiveWeightedAverage {
    private final int padding;
    private final boolean noZeroDeviations;
    private double paddedAverage;
    private double deviation;

    AdaptivePaddedAverage(double weight, int padding) {
        this(weight, padding, false);
    }

    AdaptivePaddedAverage(double weight, int padding, boolean noZeroDeviations) {
        super(weight);
        this.padding = padding;
        this.noZeroDeviations = noZeroDeviations;
    }

    @Override
    public void sample(double value) {
        super.sample(value);
        double average = super.getAverage();
        if (value != 0.0 || !this.noZeroDeviations) {
            this.deviation = this.computeAdaptiveAverage(Math.abs(value - average), this.deviation);
        }
        this.paddedAverage = average + (double)this.padding * this.deviation;
    }

    public double getPaddedAverage() {
        return this.paddedAverage;
    }

    public double getDeviation() {
        return this.deviation;
    }
}

