/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.code;

import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.c.NonmovableArrays;
import com.oracle.svm.core.code.CodeInfoAccess;
import com.oracle.svm.core.code.CodeInfoImpl;
import com.oracle.svm.core.code.UntetheredCodeInfo;
import com.oracle.svm.core.deopt.SubstrateInstalledCode;
import org.graalvm.nativeimage.c.function.CodePointer;
import org.graalvm.word.UnsignedWord;

public final class UntetheredCodeInfoAccess {
    private UntetheredCodeInfoAccess() {
    }

    @Uninterruptible(reason="Must prevent the GC from freeing the CodeInfo object.")
    public static Object getTetherUnsafe(UntetheredCodeInfo info) {
        return UntetheredCodeInfoAccess.getObjectFieldUnsafe(info, 0);
    }

    @Uninterruptible(reason="Must prevent the GC from freeing the CodeInfo object.", callerMustBe=true)
    public static CodePointer getCodeStart(UntetheredCodeInfo info) {
        return UntetheredCodeInfoAccess.cast(info).getCodeStart();
    }

    @Uninterruptible(reason="Must prevent the GC from freeing the CodeInfo object.", callerMustBe=true)
    public static CodePointer getCodeEnd(UntetheredCodeInfo info) {
        CodeInfoImpl codeInfo = UntetheredCodeInfoAccess.cast(info);
        return (CodePointer)((UnsignedWord)codeInfo.getCodeStart()).add(codeInfo.getCodeSize());
    }

    @Uninterruptible(reason="Must prevent the GC from freeing the CodeInfo object.", callerMustBe=true)
    public static UnsignedWord getCodeSize(UntetheredCodeInfo info) {
        return UntetheredCodeInfoAccess.cast(info).getCodeSize();
    }

    @Uninterruptible(reason="Must prevent the GC from freeing the CodeInfo object.", callerMustBe=true)
    public static int getTier(UntetheredCodeInfo info) {
        return UntetheredCodeInfoAccess.cast(info).getTier();
    }

    @Uninterruptible(reason="Must prevent the GC from freeing the CodeInfo object.", callerMustBe=true)
    public static <T> T getObjectFieldUnsafe(UntetheredCodeInfo info, int index) {
        return (T)NonmovableArrays.getObject(UntetheredCodeInfoAccess.cast(info).getObjectFields(), index);
    }

    @Uninterruptible(reason="Must prevent the GC from freeing the CodeInfo object.", callerMustBe=true)
    public static int getState(UntetheredCodeInfo info) {
        return UntetheredCodeInfoAccess.cast(info).getState();
    }

    @Uninterruptible(reason="Must prevent the GC from freeing the CodeInfo object.", callerMustBe=true)
    public static boolean isAlive(UntetheredCodeInfo info) {
        return CodeInfoAccess.isAliveState(UntetheredCodeInfoAccess.cast(info).getState());
    }

    @Uninterruptible(reason="Must prevent the GC from freeing the CodeInfo object.", callerMustBe=true)
    public static String getName(UntetheredCodeInfo info) {
        return (String)UntetheredCodeInfoAccess.getObjectFieldUnsafe(info, 1);
    }

    @Uninterruptible(reason="Must prevent the GC from freeing the CodeInfo object.", callerMustBe=true)
    public static SubstrateInstalledCode getInstalledCode(UntetheredCodeInfo info) {
        return (SubstrateInstalledCode)UntetheredCodeInfoAccess.getObjectFieldUnsafe(info, 2);
    }

    @Uninterruptible(reason="Must prevent the GC from freeing the CodeInfo object.", callerMustBe=true)
    private static CodeInfoImpl cast(UntetheredCodeInfo info) {
        assert (info.isNonNull());
        return (CodeInfoImpl)info;
    }
}

