/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.code;

import com.oracle.svm.core.code.FrameInfoEncoder;
import com.oracle.svm.core.code.FrameInfoQueryResult;
import java.util.Objects;
import jdk.vm.ci.meta.JavaConstant;

class FrameInfoVerifier {
    FrameInfoVerifier() {
    }

    protected static void verifyFrames(FrameInfoEncoder.FrameData expectedData, FrameInfoQueryResult expectedTopFrame, FrameInfoQueryResult actualTopFrame) {
        FrameInfoQueryResult expectedFrame = expectedTopFrame;
        FrameInfoQueryResult actualFrame = actualTopFrame;
        while (expectedFrame != null) {
            assert (actualFrame != null);
            assert (expectedFrame.isDeoptEntry() == actualFrame.isDeoptEntry());
            assert (expectedFrame.hasLocalValueInfo() == actualFrame.hasLocalValueInfo());
            if (expectedFrame.hasLocalValueInfo()) {
                assert (expectedFrame.getEncodedBci() == actualFrame.getEncodedBci());
                assert (expectedFrame.getMethodId() == actualFrame.getMethodId());
                assert (expectedFrame.getDeoptMethod() == null && actualFrame.getDeoptMethod() == null || expectedFrame.getDeoptMethod() != null && expectedFrame.getDeoptMethod().equals(actualFrame.getDeoptMethod()));
                assert (expectedFrame.getDeoptMethodOffset() == actualFrame.getDeoptMethodOffset());
                assert (expectedFrame.getNumLocals() == actualFrame.getNumLocals());
                assert (expectedFrame.getNumStack() == actualFrame.getNumStack());
                assert (expectedFrame.getNumLocks() == actualFrame.getNumLocks());
                FrameInfoVerifier.verifyValues(expectedFrame.getValueInfos(), actualFrame.getValueInfos());
                assert (expectedFrame.getVirtualObjects() == expectedTopFrame.getVirtualObjects());
                assert (actualFrame.getVirtualObjects() == actualTopFrame.getVirtualObjects());
            }
            assert (Objects.equals(expectedFrame.getSourceClass(), actualFrame.getSourceClass()));
            assert (Objects.equals(expectedFrame.getSourceMethodName(), actualFrame.getSourceMethodName()));
            assert (expectedFrame.getSourceLineNumber() == actualFrame.getSourceLineNumber());
            assert (expectedFrame.getMethodId() == actualFrame.getMethodId());
            assert (expectedFrame.sourceClassIndex == actualFrame.sourceClassIndex);
            assert (expectedFrame.sourceMethodNameIndex == actualFrame.sourceMethodNameIndex);
            expectedFrame = expectedFrame.caller;
            actualFrame = actualFrame.caller;
        }
        assert (actualFrame == null);
        if (actualTopFrame.hasLocalValueInfo()) {
            assert (expectedData.virtualObjects.length == actualTopFrame.virtualObjects.length);
            for (int i = 0; i < expectedData.virtualObjects.length; ++i) {
                FrameInfoVerifier.verifyValues(expectedData.virtualObjects[i], actualTopFrame.virtualObjects[i]);
            }
        }
    }

    private static void verifyValues(FrameInfoQueryResult.ValueInfo[] expectedValues, FrameInfoQueryResult.ValueInfo[] actualValues) {
        assert (expectedValues.length == actualValues.length);
        for (int i = 0; i < expectedValues.length; ++i) {
            FrameInfoQueryResult.ValueInfo expectedValue = expectedValues[i];
            FrameInfoQueryResult.ValueInfo actualValue = actualValues[i];
            assert (expectedValue.type == actualValue.type);
            assert (expectedValue.kind.equals((Object)actualValue.kind));
            assert (expectedValue.isCompressedReference == actualValue.isCompressedReference);
            assert (expectedValue.isEliminatedMonitor == actualValue.isEliminatedMonitor);
            assert (expectedValue.data == actualValue.data);
            FrameInfoVerifier.verifyConstant(expectedValue.value, actualValue.value);
        }
    }

    protected static void verifyConstant(JavaConstant expectedConstant, JavaConstant actualConstant) {
        if (expectedConstant != null && expectedConstant.getJavaKind().isPrimitive()) {
            assert (FrameInfoEncoder.encodePrimitiveConstant(expectedConstant) == FrameInfoEncoder.encodePrimitiveConstant(actualConstant));
        } else assert (Objects.equals(expectedConstant, actualConstant)) : " Constants are not equal: expected=" + expectedConstant + " actual=" + actualConstant;
    }
}

