/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.c;

import com.oracle.svm.core.c.CGlobalData;
import com.oracle.svm.core.c.CGlobalDataImpl;
import com.oracle.svm.core.config.ConfigurationValues;
import com.oracle.svm.core.util.Utf8;
import java.nio.ByteBuffer;
import java.util.function.IntSupplier;
import java.util.function.Supplier;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.word.PointerBase;
import org.graalvm.word.WordBase;

@Platforms(value={Platform.HOSTED_ONLY.class})
public final class CGlobalDataFactory {
    public static <T extends PointerBase> CGlobalData<T> forSymbol(String symbolName) {
        return new CGlobalDataImpl(symbolName);
    }

    public static <T extends PointerBase> CGlobalData<T> forSymbol(String symbolName, boolean nonConstant) {
        return new CGlobalDataImpl(symbolName, nonConstant);
    }

    public static <T extends PointerBase> CGlobalData<T> createCString(String content) {
        return CGlobalDataFactory.createCString(content, null);
    }

    public static <T extends PointerBase> CGlobalData<T> createCString(String content, String symbolName) {
        return new CGlobalDataImpl(symbolName, () -> Utf8.stringToUtf8(content, true));
    }

    public static <T extends PointerBase> CGlobalData<T> createBytes(IntSupplier sizeSupplier) {
        return CGlobalDataFactory.createBytes(sizeSupplier, null);
    }

    public static <T extends PointerBase> CGlobalData<T> createBytes(IntSupplier sizeSupplier, String symbolName) {
        return new CGlobalDataImpl(symbolName, sizeSupplier);
    }

    public static <T extends PointerBase> CGlobalData<T> createBytes(Supplier<byte[]> contentSupplier) {
        return CGlobalDataFactory.createBytes(contentSupplier, null);
    }

    public static <T extends PointerBase> CGlobalData<T> createBytes(Supplier<byte[]> contentSupplier, String symbolName) {
        return new CGlobalDataImpl(symbolName, contentSupplier);
    }

    public static <T extends PointerBase> CGlobalData<T> createWord(WordBase initialValue) {
        return CGlobalDataFactory.createWord(initialValue, null);
    }

    public static <T extends PointerBase> CGlobalData<T> createWord(WordBase initialValue, String symbolName) {
        return CGlobalDataFactory.createWord(initialValue, symbolName, false);
    }

    public static <T extends PointerBase> CGlobalData<T> createWord(WordBase initialValue, String symbolName, boolean nonConstant) {
        Supplier<byte[]> supplier = () -> {
            assert (ConfigurationValues.getTarget().wordSize == 8);
            return ByteBuffer.allocate(8).order(ConfigurationValues.getTarget().arch.getByteOrder()).putLong(initialValue.rawValue()).array();
        };
        return new CGlobalDataImpl(symbolName, supplier, nonConstant);
    }

    public static <T extends PointerBase> CGlobalData<T> createWord() {
        return CGlobalDataFactory.createWord((String)null);
    }

    public static <T extends PointerBase> CGlobalData<T> createWord(String symbolName) {
        return new CGlobalDataImpl(symbolName, () -> ConfigurationValues.getTarget().wordSize);
    }

    private CGlobalDataFactory() {
    }
}

