/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.allocationprofile;

import com.oracle.svm.core.allocationprofile.AllocationCounter;
import com.oracle.svm.core.jdk.RuntimeSupport;
import com.oracle.svm.core.log.Log;
import com.oracle.svm.core.option.HostedOptionKey;
import com.oracle.svm.core.option.RuntimeOptionKey;
import com.oracle.svm.core.util.MetricsLogUtils;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicReference;

public final class AllocationSite {
    private static final ConcurrentMap<AllocationSite, AllocationSite> sites = new ConcurrentHashMap<AllocationSite, AllocationSite>();
    private final String siteName;
    private final String className;
    private final AtomicReference<AllocationCounter> firstCounter;
    private long cachedCount;
    private long cachedSize;
    private static final Comparator<AllocationSite> sitesComparator;
    private static final Comparator<AllocationCounter> counterComparator;

    public static AllocationSite lookup(String siteName, String className) {
        return sites.computeIfAbsent(new AllocationSite(siteName, className), key -> key);
    }

    private AllocationSite(String siteName, String className) {
        this.siteName = siteName;
        this.className = className;
        this.firstCounter = new AtomicReference();
    }

    public AllocationCounter createCounter(String counterName) {
        AllocationCounter counter;
        while (!this.firstCounter.compareAndSet((counter = new AllocationCounter(counterName, this.firstCounter.get())).getNext(), counter)) {
        }
        return counter;
    }

    public String toString() {
        return this.siteName + " : " + this.className;
    }

    public boolean equals(Object obj) {
        if (obj instanceof AllocationSite) {
            AllocationSite other = (AllocationSite)obj;
            return this.className.equals(other.className) && this.siteName.equals(other.siteName);
        }
        return false;
    }

    public int hashCode() {
        return this.className.hashCode() ^ this.siteName.hashCode();
    }

    public static List<AllocationSite> getSites() {
        ArrayList<AllocationSite> sortedSites = new ArrayList<AllocationSite>();
        for (AllocationSite site : sites.keySet()) {
            long totalCount = 0L;
            long totalSize = 0L;
            for (AllocationCounter counter = site.firstCounter.get(); counter != null; counter = counter.getNext()) {
                totalCount += counter.getCount();
                totalSize += counter.getSize();
            }
            site.cachedCount = totalCount;
            site.cachedSize = totalSize;
            if (totalSize < (long)Options.AllocationProfilingThreshold.getValue().intValue()) continue;
            sortedSites.add(site);
        }
        sortedSites.sort(sitesComparator);
        return sortedSites;
    }

    public static RuntimeSupport.Hook getShutdownHook() {
        return isFirstIsolate -> AllocationSite.dumpProfilingResults();
    }

    public static void dumpProfilingResults() {
        AllocationSite.dumpProfilingResults(Log.log());
    }

    public static void dumpProfilingResults(Log log) {
        assert (Options.AllocationProfiling.getValue().booleanValue());
        long totalAllocatedSize = 0L;
        long totalAllocatedObjectCnt = 0L;
        List<AllocationSite> sortedSites = AllocationSite.getSites();
        ArrayList<AllocationCounter> counters = new ArrayList<AllocationCounter>();
        log.string("Allocation site;Allocation class;Allocation count;Allocation size in bytes").newline();
        DecimalFormat grpFormatter = new DecimalFormat("###,###,###,###");
        for (AllocationSite site : sortedSites) {
            log.string(site.siteName).string(";").string(site.className).string(";").string(grpFormatter.format(site.cachedCount)).string(";").string(grpFormatter.format(site.cachedSize)).newline();
            for (AllocationCounter counter = site.firstCounter.get(); counter != null; counter = counter.getNext()) {
                totalAllocatedSize += counter.getSize();
                totalAllocatedObjectCnt += counter.getCount();
                if (counter.getSize() < (long)Options.AllocationProfilingThreshold.getValue().intValue() || !Options.PrintDetailedAllocationProfiling.getValue().booleanValue()) continue;
                counters.add(counter);
            }
            if (!Options.PrintDetailedAllocationProfiling.getValue().booleanValue()) continue;
            counters.sort(counterComparator);
            for (AllocationCounter counter : counters) {
                log.string(";").string(counter.getName()).string(";").string(grpFormatter.format(counter.getCount())).string(";").string(grpFormatter.format(counter.getSize())).newline();
            }
            counters.clear();
        }
        MetricsLogUtils.logSection("Counters summary");
        MetricsLogUtils.logMemoryMetric("Total memory:", totalAllocatedSize);
        MetricsLogUtils.logCounterMetric("Total object:", totalAllocatedObjectCnt);
    }

    static {
        AllocationSite.lookup("__unused_to_make_counter_types_reachable__", "__").createCounter("__");
        sitesComparator = new Comparator<AllocationSite>(){

            @Override
            public int compare(AllocationSite o1, AllocationSite o2) {
                return Long.compare(o2.cachedSize, o1.cachedSize);
            }
        };
        counterComparator = (o1, o2) -> Long.compare(o2.getSize(), o1.getSize());
    }

    public static class Options {
        public static final HostedOptionKey<Boolean> AllocationProfiling = new HostedOptionKey<Boolean>(false);
        public static final RuntimeOptionKey<Integer> AllocationProfilingThreshold = new RuntimeOptionKey<Integer>(Integer.valueOf(0x100000), new RuntimeOptionKey.RuntimeOptionKeyFlag[0]);
        public static final RuntimeOptionKey<Boolean> PrintDetailedAllocationProfiling = new RuntimeOptionKey<Boolean>(Boolean.valueOf(true), new RuntimeOptionKey.RuntimeOptionKeyFlag[0]);
    }
}

