/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core;

import com.oracle.svm.core.SubstrateGCOptions;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.c.CGlobalData;
import com.oracle.svm.core.c.CGlobalDataFactory;
import com.oracle.svm.core.c.function.CEntryPointCreateIsolateParameters;
import com.oracle.svm.core.feature.AutomaticallyRegisteredImageSingleton;
import com.oracle.svm.core.headers.LibC;
import com.oracle.svm.core.option.RuntimeOptionKey;
import com.oracle.svm.core.util.VMError;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import org.graalvm.compiler.api.replacements.Fold;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.StackValue;
import org.graalvm.nativeimage.c.type.CCharPointer;
import org.graalvm.nativeimage.c.type.CCharPointerPointer;
import org.graalvm.nativeimage.c.type.CIntPointer;
import org.graalvm.nativeimage.c.type.CLongPointer;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordFactory;

@AutomaticallyRegisteredImageSingleton
public class IsolateArgumentParser {
    private static final RuntimeOptionKey<?>[] OPTIONS = new RuntimeOptionKey[]{SubstrateGCOptions.MinHeapSize, SubstrateGCOptions.MaxHeapSize, SubstrateGCOptions.MaxNewSize, SubstrateOptions.ConcealedOptions.AutomaticReferenceHandling, SubstrateOptions.ConcealedOptions.UsePerfData};
    private static final int OPTION_COUNT = OPTIONS.length;
    private static final CGlobalData<CCharPointer> OPTION_NAMES = CGlobalDataFactory.createBytes(IsolateArgumentParser::createOptionNames);
    private static final CGlobalData<CIntPointer> OPTION_NAME_POSITIONS = CGlobalDataFactory.createBytes(IsolateArgumentParser::createOptionNamePosition);
    private static final CGlobalData<CCharPointer> OPTION_TYPES = CGlobalDataFactory.createBytes(IsolateArgumentParser::createOptionTypes);
    private static final CGlobalData<CLongPointer> HOSTED_VALUES = CGlobalDataFactory.createBytes(IsolateArgumentParser::createHostedValues);
    private static final long[] PARSED_OPTION_VALUES = new long[OPTION_COUNT];
    private static final int K = 1024;
    private static final int M = 0x100000;
    private static final int G = 0x40000000;
    private static final int T = 0;

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public IsolateArgumentParser() {
    }

    @Fold
    public static IsolateArgumentParser singleton() {
        return (IsolateArgumentParser)ImageSingletons.lookup(IsolateArgumentParser.class);
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    private static byte[] createOptionNames() {
        StringBuilder options = new StringBuilder();
        for (int i = 0; i < OPTION_COUNT; ++i) {
            options.append(OPTIONS[i].getName());
            options.append("\u0000");
        }
        return options.toString().getBytes(StandardCharsets.ISO_8859_1);
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    private static byte[] createOptionNamePosition() {
        byte[] result = new byte[4 * OPTION_COUNT];
        ByteBuffer buffer = ByteBuffer.wrap(result).order(ByteOrder.nativeOrder());
        buffer.putInt(0);
        byte[] optionNames = IsolateArgumentParser.createOptionNames();
        for (int i = 0; i < optionNames.length; ++i) {
            if (optionNames[i] != 0 || i + 1 >= optionNames.length) continue;
            buffer.putInt(i + 1);
        }
        return result;
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    private static byte[] createOptionTypes() {
        byte[] result = new byte[1 * OPTION_COUNT];
        ByteBuffer buffer = ByteBuffer.wrap(result).order(ByteOrder.nativeOrder());
        for (int i = 0; i < OPTION_COUNT; ++i) {
            Class optionValueType = OPTIONS[i].getDescriptor().getOptionValueType();
            buffer.put(OptionValueType.fromClass(optionValueType));
        }
        return result;
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    private static byte[] createHostedValues() {
        byte[] result = new byte[8 * OPTION_COUNT];
        ByteBuffer buffer = ByteBuffer.wrap(result).order(ByteOrder.nativeOrder());
        for (int i = 0; i < OPTION_COUNT; ++i) {
            long value = IsolateArgumentParser.toLong(OPTIONS[i].getHostedValue());
            buffer.putLong(value);
        }
        return result;
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    private static long toLong(Object value) {
        if (value instanceof Boolean) {
            return (Boolean)value != false ? 1L : 0L;
        }
        if (value instanceof Integer) {
            return ((Integer)value).intValue();
        }
        if (value instanceof Long) {
            return (Long)value;
        }
        throw VMError.shouldNotReachHere("Unexpected option value: " + value);
    }

    @Uninterruptible(reason="Still being initialized.")
    public static void parse(CEntryPointCreateIsolateParameters parameters, CLongPointer parsedArgs) {
        IsolateArgumentParser.initialize(parsedArgs);
        if (!LibC.isSupported()) {
            return;
        }
        int argc = 0;
        CCharPointerPointer argv = (CCharPointerPointer)WordFactory.nullPointer();
        if (parameters.isNonNull() && parameters.version() >= 3 && parameters.getArgv().isNonNull()) {
            argc = parameters.getArgc();
            argv = parameters.getArgv();
        }
        CLongPointer numericValue = (CLongPointer)StackValue.get((int)8);
        for (int i = 1; i < argc; ++i) {
            CCharPointer tail;
            CCharPointer arg = argv.read(i);
            if (!arg.isNonNull() || !(tail = IsolateArgumentParser.matchPrefix(arg)).isNonNull()) continue;
            CCharPointer xOptionTail = IsolateArgumentParser.matchXOption(tail);
            if (xOptionTail.isNonNull()) {
                IsolateArgumentParser.parseXOption(parsedArgs, numericValue, xOptionTail);
                continue;
            }
            CCharPointer xxOptionTail = IsolateArgumentParser.matchXXOption(tail);
            if (!xxOptionTail.isNonNull()) continue;
            IsolateArgumentParser.parseXXOption(parsedArgs, numericValue, xxOptionTail);
        }
    }

    @Uninterruptible(reason="Thread state not yet set up.")
    public void persistOptions(CLongPointer parsedArgs) {
        for (int i = 0; i < OPTION_COUNT; ++i) {
            IsolateArgumentParser.PARSED_OPTION_VALUES[i] = parsedArgs.read(i);
        }
    }

    public void verifyOptionValues() {
        for (int i = 0; i < OPTION_COUNT; ++i) {
            IsolateArgumentParser.validate(OPTIONS[i], IsolateArgumentParser.getOptionValue(i));
        }
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static boolean getBooleanOptionValue(int index) {
        return PARSED_OPTION_VALUES[index] == 1L;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static int getIntOptionValue(int index) {
        return (int)PARSED_OPTION_VALUES[index];
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static long getLongOptionValue(int index) {
        return PARSED_OPTION_VALUES[index];
    }

    private static Object getOptionValue(int index) {
        Class optionValueType = OPTIONS[index].getDescriptor().getOptionValueType();
        long value = PARSED_OPTION_VALUES[index];
        if (optionValueType == Boolean.class) {
            assert (value == 0L || value == 1L);
            return value == 1L;
        }
        if (optionValueType == Integer.class) {
            return (int)value;
        }
        if (optionValueType == Long.class) {
            return value;
        }
        throw VMError.shouldNotReachHere("Option value has unexpected type: " + optionValueType);
    }

    private static void validate(RuntimeOptionKey<?> option, Object oldValue) {
        Object newValue;
        if (option.hasBeenSet() && ((newValue = option.getValue()) == null || !newValue.equals(oldValue))) {
            throw new IllegalArgumentException("The option '" + option.getName() + "' can't be changed after isolate creation. Old value: " + oldValue + ", new value: " + newValue);
        }
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static void initialize(CLongPointer parsedArgs) {
        for (int i = 0; i < OPTION_COUNT; ++i) {
            parsedArgs.write(i, HOSTED_VALUES.get().read(i));
        }
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static CCharPointer matchPrefix(CCharPointer arg) {
        if (arg.read(0) == 45) {
            return arg.addressOf(1);
        }
        return (CCharPointer)WordFactory.nullPointer();
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static CCharPointer matchXOption(CCharPointer arg) {
        if (arg.read(0) == 88 && arg.read(1) == 109) {
            return arg.addressOf(2);
        }
        return (CCharPointer)WordFactory.nullPointer();
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static CCharPointer matchXXOption(CCharPointer arg) {
        if (arg.read(0) == 88 && arg.read(1) == 88 && arg.read(2) == 58) {
            return arg.addressOf(3);
        }
        return (CCharPointer)WordFactory.nullPointer();
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static void parseXOption(CLongPointer parsedArgs, CLongPointer numericValue, CCharPointer tail) {
        byte kind = tail.read();
        if (kind == 115 && IsolateArgumentParser.parseNumericXOption(tail.addressOf(1), numericValue)) {
            parsedArgs.write(IsolateArgumentParser.getOptionIndex(SubstrateGCOptions.MinHeapSize), numericValue.read());
        } else if (kind == 120 && IsolateArgumentParser.parseNumericXOption(tail.addressOf(1), numericValue)) {
            parsedArgs.write(IsolateArgumentParser.getOptionIndex(SubstrateGCOptions.MaxHeapSize), numericValue.read());
        } else if (kind == 110 && IsolateArgumentParser.parseNumericXOption(tail.addressOf(1), numericValue)) {
            parsedArgs.write(IsolateArgumentParser.getOptionIndex(SubstrateGCOptions.MaxNewSize), numericValue.read());
        }
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static void parseXXOption(CLongPointer parsedArgs, CLongPointer numericValue, CCharPointer tail) {
        byte firstChar = tail.read();
        if (firstChar == 43 || firstChar == 45) {
            boolean value = firstChar == 43;
            for (int i = 0; i < OPTION_COUNT; ++i) {
                int pos = OPTION_NAME_POSITIONS.get().read(i);
                CCharPointer optionName = OPTION_NAMES.get().addressOf(pos);
                if (OPTION_TYPES.get().read(i) != OptionValueType.Boolean || !IsolateArgumentParser.matches(tail.addressOf(1), optionName)) continue;
                parsedArgs.write(i, value ? 1L : 0L);
                break;
            }
        } else {
            for (int i = 0; i < OPTION_COUNT; ++i) {
                int pos = OPTION_NAME_POSITIONS.get().read(i);
                CCharPointer optionName = OPTION_NAMES.get().addressOf(pos);
                if (!OptionValueType.isNumeric(OPTION_TYPES.get().read(i)) || !IsolateArgumentParser.parseNumericXXOption(tail, optionName, numericValue)) continue;
                parsedArgs.write(i, numericValue.read());
                break;
            }
        }
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static boolean parseNumericXXOption(CCharPointer input, CCharPointer optionName, CLongPointer result) {
        CCharPointer tail = IsolateArgumentParser.startsWith(input, optionName);
        if (tail.isNull() || tail.read() != 61) {
            return false;
        }
        return IsolateArgumentParser.parseNumericXOption(tail.addressOf(1), result);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static boolean parseNumericXOption(CCharPointer string, CLongPointer result) {
        CCharPointer pos = string;
        boolean negativeValue = false;
        if (pos.read() == 45) {
            negativeValue = true;
            pos = pos.addressOf(1);
        }
        if (!IsolateArgumentParser.atojulong(pos, result)) {
            return false;
        }
        if (negativeValue) {
            result.write(-result.read());
        }
        return true;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static boolean atojulong(CCharPointer s, CLongPointer result) {
        int modifier;
        if (LibC.isdigit(s.read()) == 0) {
            return false;
        }
        CCharPointerPointer tailPtr = (CCharPointerPointer)StackValue.get(CCharPointer.class);
        UnsignedWord n = LibC.strtoull(s, tailPtr, 10);
        if (LibC.errno() != 0) {
            return false;
        }
        CCharPointer tail = tailPtr.read();
        if (tail == s || LibC.strlen(tail).aboveThan(1)) {
            return false;
        }
        switch (tail.read()) {
            case 84: 
            case 116: {
                modifier = 0;
                break;
            }
            case 71: 
            case 103: {
                modifier = 0x40000000;
                break;
            }
            case 77: 
            case 109: {
                modifier = 0x100000;
                break;
            }
            case 75: 
            case 107: {
                modifier = 1024;
                break;
            }
            case 0: {
                modifier = 1;
                break;
            }
            default: {
                return false;
            }
        }
        UnsignedWord value = n.multiply(modifier);
        if (IsolateArgumentParser.checkForOverflow(value, n, modifier)) {
            return false;
        }
        result.write(value.rawValue());
        return true;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static boolean checkForOverflow(UnsignedWord value, UnsignedWord n, long modifier) {
        return value.unsignedDivide(WordFactory.unsigned((long)modifier)) != n;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static boolean matches(CCharPointer input, CCharPointer expected) {
        CCharPointer tail = IsolateArgumentParser.startsWith(input, expected);
        return tail.isNonNull() && tail.read() == 0;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static CCharPointer startsWith(CCharPointer input, CCharPointer prefix) {
        int i = 0;
        while (prefix.read(i) != 0 && input.read(i) == prefix.read(i)) {
            ++i;
        }
        if (prefix.read(i) == 0) {
            return input.addressOf(i);
        }
        return (CCharPointer)WordFactory.nullPointer();
    }

    @Fold
    public static int getOptionIndex(RuntimeOptionKey<?> key) {
        for (int i = 0; i < OPTIONS.length; ++i) {
            if (OPTIONS[i] != key) continue;
            return i;
        }
        throw VMError.shouldNotReachHere("Could not find option " + key.getName() + " in the options array.");
    }

    @Fold
    public static int getStructSize() {
        return 8 * OPTION_COUNT;
    }

    private static class OptionValueType {
        public static byte Boolean = 1;
        public static byte Integer = (byte)2;
        public static byte Long = (byte)3;

        private OptionValueType() {
        }

        public static byte fromClass(Class<?> c) {
            if (c == Boolean.class) {
                return Boolean;
            }
            if (c == Integer.class) {
                return Integer;
            }
            if (c == Long.class) {
                return Long;
            }
            throw VMError.shouldNotReachHere("Option value has unexpected type: " + c);
        }

        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        public static boolean isNumeric(byte optionValueType) {
            return optionValueType == Integer || optionValueType == Long;
        }
    }
}

