/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core;

import com.oracle.svm.core.CPUFeatureAccess;
import com.oracle.svm.core.c.CGlobalData;
import com.oracle.svm.core.c.CGlobalDataFactory;
import com.oracle.svm.core.util.VMError;
import java.util.EnumSet;
import java.util.List;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.c.type.CCharPointer;
import org.graalvm.word.Pointer;

public abstract class CPUFeatureAccessImpl
implements CPUFeatureAccess {
    private final EnumSet<?> buildtimeCPUFeatures;
    protected static final CGlobalData<CCharPointer> BUILDTIME_CPU_FEATURE_MASK = CGlobalDataFactory.createBytes(() -> ((CPUFeatureAccessImpl)ImageSingletons.lookup(CPUFeatureAccess.class)).buildtimeFeatureMask);
    protected static final CGlobalData<CCharPointer> IMAGE_CPU_FEATURE_ERROR_MSG = CGlobalDataFactory.createBytes(() -> ((CPUFeatureAccessImpl)ImageSingletons.lookup(CPUFeatureAccess.class)).cpuFeatureErrorMessage);
    @Platforms(value={Platform.HOSTED_ONLY.class})
    private final byte[] cpuFeatureErrorMessage;
    @Platforms(value={Platform.HOSTED_ONLY.class})
    private final byte[] buildtimeFeatureMask;
    private final int[] cpuFeatureEnumToStructOffsets;

    @Platforms(value={Platform.HOSTED_ONLY.class})
    protected CPUFeatureAccessImpl(EnumSet<?> buildtimeCPUFeatures, int[] offsets, byte[] errorMessageBytes, byte[] buildtimeFeatureMaskBytes) {
        GraalError.guarantee((errorMessageBytes[errorMessageBytes.length - 1] == 0 ? 1 : 0) != 0, (String)"error message not zero-terminated");
        GraalError.guarantee((buildtimeFeatureMaskBytes.length % 8 == 0 ? 1 : 0) != 0, (String)"build-time feature mask byte array not a multiple of 64 bits");
        this.cpuFeatureEnumToStructOffsets = offsets;
        this.cpuFeatureErrorMessage = errorMessageBytes;
        this.buildtimeFeatureMask = buildtimeFeatureMaskBytes;
        this.buildtimeCPUFeatures = EnumSet.copyOf(buildtimeCPUFeatures);
    }

    @Override
    public EnumSet<?> buildtimeCPUFeatures() {
        return this.buildtimeCPUFeatures;
    }

    protected boolean isFeaturePresent(Enum<?> feature, Pointer cpuFeatures, List<String> unknownFeatures) {
        VMError.guarantee(this.cpuFeatureEnumToStructOffsets != null);
        int offset = this.cpuFeatureEnumToStructOffsets[feature.ordinal()];
        if (offset < 0) {
            unknownFeatures.add(feature.name());
            return false;
        }
        return cpuFeatures.readByte(offset) != 0;
    }
}

