/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.objectfile.macho;

import com.oracle.objectfile.BuildDependency;
import com.oracle.objectfile.ElementImpl;
import com.oracle.objectfile.LayoutDecision;
import com.oracle.objectfile.LayoutDecisionMap;
import com.oracle.objectfile.ObjectFile;
import com.oracle.objectfile.io.AssemblyBuffer;
import com.oracle.objectfile.macho.MachOObjectFile;
import com.oracle.objectfile.macho.MachORelocationElement;
import com.oracle.objectfile.macho.MachORelocationInfo;
import java.nio.ByteBuffer;
import java.util.EnumSet;
import java.util.Map;
import java.util.Objects;

public class MachOUserDefinedSection
extends MachOObjectFile.MachOSection
implements ObjectFile.RelocatableSectionImpl {
    protected ElementImpl impl;

    @Override
    public ElementImpl getImpl() {
        return this.impl;
    }

    MachOUserDefinedSection(MachOObjectFile owner, String name, int alignment, MachOObjectFile.Segment64Command segment, MachOObjectFile.SectionType type, ElementImpl impl) {
        this(owner, name, alignment, segment, type, impl, EnumSet.noneOf(MachOObjectFile.SectionFlag.class));
        this.impl = impl;
    }

    MachOUserDefinedSection(MachOObjectFile owner, String name, int alignment, MachOObjectFile.Segment64Command segment, MachOObjectFile.SectionType type, ElementImpl impl, EnumSet<MachOObjectFile.SectionFlag> flags) {
        MachOObjectFile machOObjectFile = owner;
        Objects.requireNonNull(machOObjectFile);
        super(machOObjectFile, name, alignment, segment, type, flags);
        this.impl = impl;
    }

    public void setImpl(ElementImpl impl) {
        this.impl = impl;
    }

    @Override
    public Iterable<BuildDependency> getDependencies(Map<ObjectFile.Element, LayoutDecisionMap> decisions) {
        return this.impl.getDependencies(decisions);
    }

    @Override
    public int getOrDecideOffset(Map<ObjectFile.Element, LayoutDecisionMap> alreadyDecided, int offsetHint) {
        int implOffset = this.impl.getOrDecideOffset(alreadyDecided, offsetHint);
        ObjectFile.Segment ourSegment = this.getSegment();
        ObjectFile.Segment prevSegment = null;
        ObjectFile.Segment firstSegment = this.getOwner().getSegments().iterator().next();
        for (ObjectFile.Segment s : this.getOwner().getSegments()) {
            if (s == ourSegment) break;
            prevSegment = s;
        }
        if (this.getSegment().get(0) == this && prevSegment != null && prevSegment.getName().equals("__TEXT")) {
            assert (prevSegment == firstSegment);
            if (implOffset < this.getOwner().getPageSize()) {
                return ObjectFile.nextIntegerMultipleWithCongruence(this.getOwner().getPageSize(), this.impl.getAlignment(), implOffset, this.getOwner().getPageSize());
            }
        } else if (this.getSegment().get(0) == this && ourSegment == firstSegment && implOffset < this.getOwner().getPageSize()) {
            return this.getOwner().getPageSize();
        }
        return implOffset;
    }

    @Override
    public int getOrDecideSize(Map<ObjectFile.Element, LayoutDecisionMap> alreadyDecided, int sizeHint) {
        return this.impl.getOrDecideSize(alreadyDecided, sizeHint);
    }

    @Override
    public byte[] getOrDecideContent(Map<ObjectFile.Element, LayoutDecisionMap> alreadyDecided, byte[] contentHint) {
        return this.impl.getOrDecideContent(alreadyDecided, contentHint);
    }

    @Override
    public int getOrDecideVaddr(Map<ObjectFile.Element, LayoutDecisionMap> alreadyDecided, int vaddrHint) {
        int implVaddr = this.impl.getOrDecideVaddr(alreadyDecided, vaddrHint);
        Object offsetObj = alreadyDecided.get(this).getDecidedValue(LayoutDecision.Kind.OFFSET);
        assert (offsetObj != null);
        assert (offsetObj instanceof Integer);
        if (this.getSegment() == this.getOwner().getSegments().iterator().next() && this.getSegment().get(0) == this && implVaddr < this.getOwner().getPageSize()) {
            return ObjectFile.nextIntegerMultipleWithCongruence(this.getOwner().getPageSize(), this.impl.getAlignment(), (Integer)offsetObj, this.getOwner().getPageSize());
        }
        return implVaddr;
    }

    @Override
    public int getMemSize(Map<ObjectFile.Element, LayoutDecisionMap> alreadyDecided) {
        return this.impl.getMemSize(alreadyDecided);
    }

    @Override
    public LayoutDecisionMap getDecisions(LayoutDecisionMap copyingIn) {
        return this.impl.getDecisions(copyingIn);
    }

    @Override
    public MachORelocationElement getOrCreateRelocationElement(long addend) {
        return this.getOwner().getOrCreateRelocationElement();
    }

    private static void handleAMD64RelocationAddend(AssemblyBuffer sbb, ObjectFile.RelocationKind k, long addend) {
        int length = ObjectFile.RelocationKind.getRelocationSize(k);
        long desiredInlineAddendValue = addend;
        if (ObjectFile.RelocationKind.isPCRelative(k)) {
            desiredInlineAddendValue += (long)length;
        }
        sbb.writeTruncatedLong(desiredInlineAddendValue, length);
    }

    private void handleAArch64RelocationAddend(MachORelocationElement el, AssemblyBuffer sbb, int offset, ObjectFile.RelocationKind k, String symbolName, long addend) {
        switch (k) {
            case DIRECT_4: 
            case DIRECT_8: {
                sbb.writeTruncatedLong(addend, ObjectFile.RelocationKind.getRelocationSize(k));
                break;
            }
            case AARCH64_R_AARCH64_ADR_PREL_PG_HI21: 
            case AARCH64_R_AARCH64_LDST64_ABS_LO12_NC: 
            case AARCH64_R_AARCH64_LDST32_ABS_LO12_NC: 
            case AARCH64_R_AARCH64_LDST16_ABS_LO12_NC: 
            case AARCH64_R_AARCH64_LDST8_ABS_LO12_NC: 
            case AARCH64_R_AARCH64_ADD_ABS_LO12_NC: {
                if (addend == 0L) break;
                el.add(MachORelocationInfo.createARM64RelocAddend(el, this, offset, symbolName, addend));
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected relocation kind");
            }
        }
    }

    @Override
    public void markRelocationSite(int offset, ByteBuffer bb, ObjectFile.RelocationKind k, String symbolName, long addend) {
        MachORelocationElement el = this.getOrCreateRelocationElement(addend);
        AssemblyBuffer sbb = new AssemblyBuffer(bb);
        sbb.setByteOrder(this.getOwner().getByteOrder());
        sbb.pushSeek(offset);
        switch (this.getOwner().cpuType) {
            case X86_64: {
                MachOUserDefinedSection.handleAMD64RelocationAddend(sbb, k, addend);
                break;
            }
            case ARM64: {
                this.handleAArch64RelocationAddend(el, sbb, offset, k, symbolName, addend);
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected CPU Type");
            }
        }
        assert (symbolName != null);
        this.flags.add(MachOObjectFile.SectionFlag.EXT_RELOC);
        sbb.pop();
        el.add(MachORelocationInfo.createRelocation(el, this, offset, k, symbolName));
    }
}

