/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.pointsto.meta;

import com.oracle.graal.pointsto.ObjectScanner;
import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.graal.pointsto.meta.AnalysisUniverse;
import com.oracle.graal.pointsto.util.AnalysisFuture;
import com.oracle.graal.pointsto.util.ConcurrentLightHashSet;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Executable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import jdk.vm.ci.code.BytecodePosition;
import jdk.vm.ci.meta.ModifiersProvider;
import org.graalvm.nativeimage.hosted.Feature;

public abstract class AnalysisElement
implements AnnotatedElement {
    private static final AtomicReferenceFieldUpdater<AnalysisElement, Object> reachableNotificationsUpdater = AtomicReferenceFieldUpdater.newUpdater(AnalysisElement.class, Object.class, "elementReachableNotifications");
    private volatile Object elementReachableNotifications;

    public abstract AnnotatedElement getWrapped();

    protected abstract AnalysisUniverse getUniverse();

    @Override
    public final boolean isAnnotationPresent(Class<? extends Annotation> annotationClass) {
        return this.getUniverse().getAnnotationExtractor().hasAnnotation(this.getWrapped(), annotationClass);
    }

    @Override
    public final <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
        return (T)this.getUniverse().getAnnotationExtractor().extractAnnotation(this.getWrapped(), annotationClass, false);
    }

    @Override
    public final <T extends Annotation> T getDeclaredAnnotation(Class<T> annotationClass) {
        return (T)this.getUniverse().getAnnotationExtractor().extractAnnotation(this.getWrapped(), annotationClass, true);
    }

    @Override
    public final Annotation[] getAnnotations() {
        return this.getUniverse().getAnnotationExtractor().extractAnnotations(this.getWrapped(), false);
    }

    @Override
    public final Annotation[] getDeclaredAnnotations() {
        return this.getUniverse().getAnnotationExtractor().extractAnnotations(this.getWrapped(), true);
    }

    public void registerReachabilityNotification(ElementNotification notification) {
        ConcurrentLightHashSet.addElement(this, reachableNotificationsUpdater, notification);
    }

    public void notifyReachabilityCallback(AnalysisUniverse universe, ElementNotification notification) {
        notification.notifyCallback(universe, this);
        ConcurrentLightHashSet.removeElement(this, reachableNotificationsUpdater, notification);
    }

    protected void notifyReachabilityCallbacks(AnalysisUniverse universe, List<AnalysisFuture<Void>> futures) {
        ConcurrentLightHashSet.forEach(this, reachableNotificationsUpdater, c -> futures.add(c.notifyCallback(universe, this)));
        ConcurrentLightHashSet.removeElementIf(this, reachableNotificationsUpdater, ElementNotification::isNotified);
    }

    boolean isValidReason(Object reason) {
        if (reason == null) {
            return false;
        }
        if (reason instanceof String) {
            return !((String)reason).isEmpty();
        }
        return reason instanceof AnalysisElement || reason instanceof ModifiersProvider || reason instanceof ObjectScanner.ScanReason || reason instanceof BytecodePosition;
    }

    public abstract boolean isReachable();

    protected abstract void onReachable();

    public boolean isTriggered() {
        return this.isReachable();
    }

    private static void execute(AnalysisUniverse universe, Runnable task) {
        universe.getBigbang().postTask(d -> task.run());
    }

    private static void execute(AnalysisUniverse universe, AnalysisFuture<?> task) {
        universe.getBigbang().postTask(d -> task.ensureDone());
    }

    public static final class ElementNotification {
        private final Consumer<Feature.DuringAnalysisAccess> callback;
        private final AtomicReference<AnalysisFuture<Void>> notified = new AtomicReference();

        public ElementNotification(Consumer<Feature.DuringAnalysisAccess> callback) {
            this.callback = callback;
        }

        public boolean isNotified() {
            return this.notified.get() != null;
        }

        AnalysisFuture<Void> notifyCallback(AnalysisUniverse universe, AnalysisElement triggeredElement) {
            assert (triggeredElement.isTriggered());
            AnalysisFuture<Void> existing = this.notified.get();
            if (existing != null) {
                return existing;
            }
            AnalysisFuture<Void> newValue = new AnalysisFuture<Void>(() -> {
                this.callback.accept(universe.getConcurrentAnalysisAccess());
                return null;
            });
            existing = this.notified.compareAndExchange(null, newValue);
            if (existing != null) {
                return existing;
            }
            AnalysisElement.execute(universe, newValue);
            return newValue;
        }
    }

    public static final class MethodOverrideReachableNotification {
        private final BiConsumer<Feature.DuringAnalysisAccess, Executable> callback;
        private final Set<AnalysisMethod> seenOverride = ConcurrentHashMap.newKeySet();

        public MethodOverrideReachableNotification(BiConsumer<Feature.DuringAnalysisAccess, Executable> callback) {
            this.callback = callback;
        }

        public void notifyCallback(AnalysisUniverse universe, AnalysisMethod reachableOverride) {
            Executable javaMethod;
            assert (reachableOverride.isReachable());
            if (this.seenOverride.add(reachableOverride) && (javaMethod = reachableOverride.getJavaMethod()) != null) {
                AnalysisElement.execute(universe, () -> this.callback.accept(universe.getConcurrentAnalysisAccess(), javaMethod));
            }
        }
    }

    public static final class SubtypeReachableNotification {
        private final BiConsumer<Feature.DuringAnalysisAccess, Class<?>> callback;
        private final Map<AnalysisType, AnalysisFuture<Void>> seenSubtypes = new ConcurrentHashMap<AnalysisType, AnalysisFuture<Void>>();

        public SubtypeReachableNotification(BiConsumer<Feature.DuringAnalysisAccess, Class<?>> callback) {
            this.callback = callback;
        }

        public AnalysisFuture<Void> notifyCallback(AnalysisUniverse universe, AnalysisType reachableSubtype) {
            assert (reachableSubtype.isReachable());
            return this.seenSubtypes.computeIfAbsent(reachableSubtype, k -> {
                AnalysisFuture<Void> newValue = new AnalysisFuture<Void>(() -> {
                    this.callback.accept(universe.getConcurrentAnalysisAccess(), reachableSubtype.getJavaClass());
                    return null;
                });
                AnalysisElement.execute(universe, newValue);
                return newValue;
            });
        }
    }
}

