/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.pointsto.heap;

import java.util.Objects;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaType;
import jdk.vm.ci.meta.VMConstant;
import org.graalvm.compiler.core.common.type.CompressibleConstant;
import org.graalvm.compiler.core.common.type.TypedConstant;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

@Platforms(value={Platform.HOSTED_ONLY.class})
public abstract class ImageHeapConstant
implements JavaConstant,
TypedConstant,
CompressibleConstant,
VMConstant {
    protected ResolvedJavaType type;
    protected final JavaConstant hostedObject;
    protected final int identityHashCode;
    protected final boolean compressed;

    ImageHeapConstant(ResolvedJavaType type, JavaConstant object, int identityHashCode, boolean compressed) {
        this.type = type;
        this.hostedObject = object;
        this.identityHashCode = identityHashCode;
        this.compressed = compressed;
    }

    static int createIdentityHashCode(JavaConstant object) {
        if (object == null) {
            return System.identityHashCode(new Object());
        }
        return -1;
    }

    public int getIdentityHashCode() {
        if (this.hostedObject != null) {
            if (this.hostedObject.isNull()) {
                return 0;
            }
            return ((TypedConstant)this.hostedObject).getIdentityHashCode();
        }
        assert (this.identityHashCode > 0) : "The Java HotSpot VM only returns positive numbers for the identity hash code, so we want to have the same restriction on Substrate VM in order to not surprise users";
        return this.identityHashCode;
    }

    public JavaConstant getHostedObject() {
        return this.hostedObject;
    }

    public JavaKind getJavaKind() {
        return JavaKind.Object;
    }

    public boolean isNull() {
        return false;
    }

    public boolean isDefaultForKind() {
        return false;
    }

    public ResolvedJavaType getType(MetaAccessProvider provider) {
        return this.type;
    }

    public void setType(ResolvedJavaType type) {
        this.type = type;
    }

    public Object asBoxedPrimitive() {
        return null;
    }

    public int asInt() {
        return 0;
    }

    public boolean asBoolean() {
        return false;
    }

    public long asLong() {
        return 0L;
    }

    public float asFloat() {
        return 0.0f;
    }

    public double asDouble() {
        return 0.0;
    }

    public boolean isCompressed() {
        return this.compressed;
    }

    public String toValueString() {
        return this.type.getName();
    }

    public boolean equals(Object o) {
        if (o instanceof ImageHeapConstant) {
            ImageHeapConstant other = (ImageHeapConstant)o;
            return Objects.equals(this.type, other.type) && Objects.equals(this.hostedObject, other.hostedObject);
        }
        return false;
    }

    public int hashCode() {
        return this.hostedObject != null ? this.hostedObject.hashCode() : 0;
    }
}

