if type -q flatpak
    # Set XDG_DATA_DIRS to include Flatpak installations

    set -x --path XDG_DATA_DIRS $XDG_DATA_DIRS

    # set TZDIR to our setup-timezone directory
    # see https://gitlab.alpinelinux.org/alpine/aports/-/issues/14844
    if test -d /etc/zoneinfo
        # this directory only exists if setup-timezone was run to add one timezone and not add tzdata.
        # unconditionally setting it would break things when it does not exist, so make sure it does.
        # if it does not exist, then /etc/localtime is going to be pointing to /usr/share/zoneinfo.
        set -l contents (command ls -A /etc/zoneinfo)
        # it can also be empty. don't export it then
        if test -n "$contents"
            set -x TZDIR /etc/zoneinfo
        end
    end

    set -q XDG_DATA_DIRS[1]; or set XDG_DATA_DIRS /usr/local/share /usr/share
    set -q XDG_DATA_HOME; or set -l XDG_DATA_HOME $HOME/.local/share

    set -l installations $XDG_DATA_HOME/flatpak
    begin
        set -le G_MESSAGES_DEBUG
        set -lx GIO_USE_VFS local
        set installations $installations (flatpak --installations)
    end

    for dir in {$installations[-1..1]}/exports/share
        if not contains $dir $XDG_DATA_DIRS
            set -p XDG_DATA_DIRS $dir
        end
    end
end
