#!/usr/bin/python3
# -*- coding: utf-8 -*-
# (c) B.Kerler 2018-2021 GPLv3 License
ErrorCodes = {
    0x0: "OK",
    # COMMON
    0x3E8: "STOP",  # 1000
    0x3E9: "UNDEFINED_ERROR",
    0x3EA: "INVALID_ARGUMENTS",
    0x3EB: "INVALID_BBCHIP_TYPE",
    0x3EC: "INVALID_EXT_CLOCK",
    0x3ED: "INVALID_BMTSIZE",
    0x3EE: "GET_DLL_VER_FAIL",
    0x3EF: "INVALID_BUF",
    0x3F0: "BUF_IS_NULL",
    0x3F1: "BUF_LEN_IS_ZERO",
    0x3F2: "BUF_SIZE_TOO_SMALL",
    0x3F3: "NOT_ENOUGH_STORAGE_SPACE",
    0x3F4: "NOT_ENOUGH_MEMORY",
    0x3F5: "COM_PORT_OPEN_FAIL",
    0x3F6: "COM_PORT_SET_TIMEOUT_FAIL",
    0x3F7: "COM_PORT_SET_STATE_FAIL",
    0x3F8: "COM_PORT_PURGE_FAIL",
    0x3F9: "FILEPATH_NOT_SPECIFIED_YET",
    0x3FA: "UNKNOWN_TARGET_BBCHIP",
    0x3FB: "SKIP_BBCHIP_HW_VER_CHECK",
    0x3FC: "UNSUPPORTED_VER_OF_BOOT_ROM",
    0x3FD: "UNSUPPORTED_VER_OF_BOOTLOADER",
    0x3FE: "UNSUPPORTED_VER_OF_DA",
    0x3FF: "UNSUPPORTED_VER_OF_SEC_INFO",
    0x400: "UNSUPPORTED_VER_OF_ROM_INFO",
    0x401: "SEC_INFO_NOT_FOUND",
    0x402: "ROM_INFO_NOT_FOUND",
    0x403: "CUST_PARA_NOT_SUPPORTED",
    0x404: "CUST_PARA_WRITE_LEN_INCONSISTENT",
    0x405: "SEC_RO_NOT_SUPPORTED",
    0x406: "SEC_RO_WRITE_LEN_INCONSISTENT",
    0x407: "ADDR_N_LEN_NOT_32BITS_ALIGNMENT",
    0x408: "UART_CHKSUM_ERROR",
    0x409: "EMMC_FLASH_BOOT",
    0x40A: "NOR_FLASH_BOOT",
    0x40B: "NAND_FLASH_BOOT",
    0x40C: "UNSUPPORTED_VER_OF_EMI_INFO",
    0x40D: "PART_NO_VALID_TABLE",
    0x40E: "PART_NO_SPACE_FOUND",
    0x40F: "UNSUPPORTED_VER_OF_SEC_CFG",
    0x410: "UNSUPPORTED_OPERATION",
    0x411: "CHKSUM_ERROR",
    0x412: "TIMEOUT",
    # BROM
    0x7D0: "SET_META_REG_FAIL",
    0x7D1: "SET_FLASHTOOL_REG_FAIL",
    0x7D2: "SET_REMAP_REG_FAIL",
    0x7D3: "SET_EMI_FAIL",
    0x7D4: "DOWNLOAD_DA_FAIL",
    0x7D5: "CMD_STARTCMD_FAIL",
    0x7D6: "CMD_STARTCMD_TIMEOUT",
    0x7D7: "CMD_JUMP_FAIL",
    0x7D8: "CMD_WRITE16_MEM_FAIL",
    0x7D9: "CMD_READ16_MEM_FAIL",
    0x7DA: "CMD_WRITE16_REG_FAIL",
    0x7DB: "CMD_READ16_REG_FAIL",
    0x7DC: "CMD_CHKSUM16_MEM_FAIL",
    0x7DD: "CMD_WRITE32_MEM_FAIL",
    0x7DE: "CMD_READ32_MEM_FAIL",
    0x7DF: "CMD_WRITE32_REG_FAIL",
    0x7E0: "CMD_READ32_REG_FAIL",
    0x7E1: "CMD_CHKSUM32_MEM_FAIL",
    0x7E2: "JUMP_TO_META_MODE_FAIL",
    0x7E3: "WR16_RD16_MEM_RESULT_DIFF",
    0x7E4: "CHKSUM16_MEM_RESULT_DIFF",
    0x7E5: "BBCHIP_HW_VER_INCORRECT",
    0x7E6: "FAIL_TO_GET_BBCHIP_HW_VER",
    0x7E7: "AUTOBAUD_FAIL",
    0x7E8: "SPEEDUP_BAUDRATE_FAIL",
    0x7E9: "LOCK_POWERKEY_FAIL",
    0x7EA: "WM_APP_MSG_OUT_OF_RANGE",
    0x7EB: "NOT_SUPPORT_MT6205B",
    0x7EC: "EXCEED_MAX_DATA_BLOCKS",
    0x7ED: "EXTERNAL_SRAM_DETECTION_FAIL",
    0x7EE: "EXTERNAL_DRAM_DETECTION_FAIL",
    0x7EF: "GET_FW_VER_FAIL",
    0x7F0: "CONNECT_TO_BOOTLOADER_FAIL",
    0x7F1: "CMD_SEND_DA_FAIL",
    0x7F2: "CMD_SEND_DA_CHKSUM_DIFF",
    0x7F3: "CMD_JUMP_DA_FAIL",
    0x7F4: "CMD_JUMP_BL_FAIL",
    0x7F5: "EFUSE_REG_NO_MATCH_WITH_TARGET",
    0x7F6: "EFUSE_WRITE_TIMEOUT",
    0x7F7: "EFUSE_DATA_PROCESS_ERROR",
    0x7F8: "EFUSE_BLOW_ERROR",
    0x7F9: "EFUSE_ALREADY_BROKEN",
    0x7FA: "EFUSE_BLOW_PARTIAL",
    0x7FB: "SEC_VER_FAIL",
    0x7FC: "PL_SEC_VER_FAIL",
    0x7FD: "SET_WATCHDOG_FAIL",
    0x7FE: "EFUSE_VALUE_IS_NOT_ZERO",
    0x7FF: "EFUSE_WRITE_TIMEOUT_WITHOUT_EFUSE_VERIFY",
    0x800: "EFUSE_UNKNOW_EXCEPTION_WITHOUT_EFUSE_VERIFY",
    # DA error
    0xBB8: "INT_RAM_ERROR",
    0xBB9: "EXT_RAM_ERROR",
    0xBBA: "SETUP_DRAM_FAIL",
    0xBBB: "SETUP_PLL_ERR",
    0xBBC: "SETUP_EMI_PLL_ERR",
    0xBBD: "DRAM_ABNORMAL_TYPE_SETTING",
    0xBBE: "DRAMC_RANK0_CALIBRATION_FAILED",
    0xBBF: "DRAMC_RANK1_CALIBRATION_FAILED",
    0xBC0: "DRAM_NOT_SUPPORT",
    0xBC1: "RAM_FLOARTING",
    0xBC2: "RAM_UNACCESSABLE",
    0xBC3: "RAM_ERROR",
    0xBC4: "DEVICE_NOT_FOUND",
    0xBC5: "NOR_UNSUPPORTED_DEV_ID",
    0xBC6: "NAND_UNSUPPORTED_DEV_ID",
    0xBC7: "NOR_FLASH_NOT_FOUND",
    0xBC8: "NAND_FLASH_NOT_FOUND",
    0xBC9: "SOC_CHECK_FAIL",
    0xBCA: "NOR_PROGRAM_FAILED",
    0xBCB: "NOR_ERASE_FAILED",
    0xBCC: "NAND_PAGE_PROGRAM_FAILED",
    0xBCD: "NAND_SPARE_PROGRAM_FAILED",
    0xBCE: "NAND_HW_COPYBACK_FAILED",
    0xBCF: "NAND_ERASE_FAILED",
    0xBD0: "TIMEOUT",
    0xBD1: "IN_PROGRESS",
    0xBD2: "SUPERAND_ONLY_SUPPORT_PAGE_READ",
    0xBD3: "SUPERAND_PAGE_PRGRAM_NOT_SUPPORT",
    0xBD4: "SUPERAND_SPARE_PRGRAM_NOT_SUPPORT",
    0xBD5: "SUPERAND_COPYBACK_NOT_SUPPORT",
    0xBD6: "NOR_CMD_SEQUENCE_ERR",
    0xBD7: "NOR_BLOCK_IS_LOCKED",
    0xBD8: "NAND_BLOCK_IS_LOCKED",
    0xBD9: "NAND_BLOCK_DATA_UNSTABLE",
    0xBDA: "NOR_BLOCK_DATA_UNSTABLE",
    0xBDB: "NOR_VPP_RANGE_ERR",
    0xBDC: "INVALID_BEGIN_ADDR",
    0xBDD: "NOR_INVALID_ERASE_BEGIN_ADDR",
    0xBDE: "NOR_INVALID_READ_BEGIN_ADDR",
    0xBDF: "NOR_INVALID_PROGRAM_BEGIN_ADDR",
    0xBE0: "INVALID_RANGE",
    0xBE1: "NOR_PROGRAM_AT_ODD_ADDR",
    0xBE2: "NOR_PROGRAM_WITH_ODD_LENGTH",
    0xBE3: "NOR_BUFPGM_NO_SUPPORT",
    0xBE4: "NAND_UNKNOWN_ERR",
    0xBE5: "NAND_BAD_BLOCK",
    0xBE6: "NAND_ECC_1BIT_CORRECT",
    0xBE7: "NAND_ECC_2BITS_ERR",
    0xBE8: "NAND_SPARE_CHKSUM_ERR",
    0xBE9: "NAND_HW_COPYBACK_DATA_INCONSISTENT",
    0xBEA: "NAND_INVALID_PAGE_INDEX",
    0xBEB: "NFI_NOT_SUPPORT",
    0xBEC: "NFI_CS1_NOT_SUPPORT",
    0xBED: "NFI_16BITS_IO_NOT_SUPPORT",
    0xBEE: "NFB_BOOTLOADER_NOT_EXIST",
    0xBEF: "NAND_NO_GOOD_BLOCK",
    0xBF0: "NAND_UBIIMG_NOT_SPARSEIMAGE",
    0xBF1: "BOOTLOADER_IS_TOO_LARGE",
    0xBF2: "SIBLEY_REWRITE_OBJ_MODE_REGION",
    0xBF3: "SIBLEY_WRITE_B_HALF_IN_CTRL_MODE_REGION",
    0xBF4: "SIBLEY_ILLEGAL_CMD",
    0xBF5: "SIBLEY_PROGRAM_AT_THE_SAME_REGIONS",
    0xBF6: "UART_GET_DATA_TIMEOUT",
    0xBF7: "UART_GET_CHKSUM_LSB_TIMEOUT",
    0xBF8: "UART_GET_CHKSUM_MSB_TIMEOUT",
    0xBF9: "UART_DATA_CKSUM_ERROR",
    0xBFA: "UART_RX_BUF_FULL",
    0xBFB: "UART_RX_BUF_NOT_ENOUGH",
    0xBFC: "FLASH_RECOVERY_BUF_NOT_ENOUGH",
    0xBFD: "HANDSET_SEC_INFO_NOT_FOUND",
    0xBFE: "HANDSET_SEC_INFO_MAC_VERIFY_FAIL",
    0xBFF: "HANDSET_ROM_INFO_NOT_FOUND",
    0xC00: "HANDSET_FAT_INFO_NOT_FOUND",
    0xC01: "OPERATION_UNSUPPORT_FOR_NFB",
    0xC02: "BYPASS_POST_PROCESS",
    0xC03: "NOR_OTP_NOT_SUPPORT",
    0xC04: "NOR_OTP_EXIST",
    0xC05: "NOR_OTP_LOCKED",
    0xC06: "NOR_OTP_GETSIZE_FAIL",
    0xC07: "NOR_OTP_READ_FAIL",
    0xC08: "NOR_OTP_PROGRAM_FAIL",
    0xC09: "NOR_OTP_LOCK_FAIL",
    0xC0A: "NOR_OTP_LOCK_CHECK_STATUS_FAIL",
    0xC0B: "BLANK_FLASH",
    0xC0C: "CODE_AREA_IS_BLANK",
    0xC0D: "SEC_RO_AREA_IS_BLANK",
    0xC0E: "NOR_OTP_UNLOCKED",
    0xC0F: "UNSUPPORTED_BBCHIP",
    0xC10: "FAT_NOT_EXIST",
    0xC11: "EXT_SRAM_NOT_FOUND",
    0xC12: "EXT_DRAM_NOT_FOUND",
    0xC13: "MT_PIN_LOW",
    0xC14: "MT_PIN_HIGH",
    0xC15: "MT_PIN_SHORT",
    0xC16: "MT_BUS_ERROR",
    0xC17: "MT_ADDR_NOT_2BYTE_ALIGNMENT",
    0xC18: "MT_ADDR_NOT_4BYTE_ALIGNMENT",
    0xC19: "MT_SIZE_NOT_2BYTE_ALIGNMENT",
    0xC1A: "MT_SIZE_NOT_4BYTE_ALIGNMENT",
    0xC1B: "MT_DEDICATED_PATTERN_ERROR",
    0xC1C: "MT_INC_PATTERN_ERROR",
    0xC1D: "MT_DEC_PATTERN_ERROR",
    0xC1E: "NFB_BLOCK_0_IS_BAD",
    0xC1F: "CUST_PARA_AREA_IS_BLANK",
    0xC20: "ENTER_RELAY_MODE_FAIL",
    0xC21: "ENTER_RELAY_MODE_IS_FORBIDDEN_AFTER_META",
    0xC22: "NAND_PAGE_READ_FAILED",
    0xC23: "NAND_IMAGE_BLOCK_NO_EXIST",
    0xC24: "NAND_IMAGE_LIST_NOT_EXIST",
    0xC25: "MBA_RESOURCE_NO_EXIST_IN_TARGET",
    0xC26: "MBA_PROJECT_VERSION_NO_MATCH_WITH_TARGET",
    0xC27: "MBA_UPDATING_RESOURCE_NO_EXIST_IN_TARGET",
    0xC28: "MBA_UPDATING_RESOURCE_SIZE_EXCEED_IN_TARGET",
    0xC29: "NAND_BIN_SIZE_EXCEED_MAX_SIZE",
    0xC2A: "NAND_EXCEED_CONTAINER_LIMIT",
    0xC2B: "NAND_REACH_END_OF_FLASH",
    0xC2C: "NAND_OTP_NOT_SUPPORT",
    0xC2D: "NAND_OTP_EXIST",
    0xC2E: "NAND_OTP_LOCKED",
    0xC2F: "NAND_OTP_LOCK_FAIL",
    0xC30: "NAND_OTP_UNLOCKED",
    0xC31: "OTP_NOT_SUPPORT",
    0xC32: "OTP_EXIST",
    0xC33: "OTP_LOCKED",
    0xC34: "OTP_GETSIZE_FAIL",
    0xC35: "OTP_READ_FAIL",
    0xC36: "OTP_PROGRAM_FAIL",
    0xC37: "OTP_LOCK_FAIL",
    0xC38: "OTP_LOCK_CHECK_STATUS_FAIL",
    0xC39: "OTP_UNLOCKED",
    0xC3A: "SEC_RO_ILLEGAL_MAGIC_TAIL",
    0xC3B: "HANDSET_FOTA_INFO_NOT_FOUND",
    0xC3C: "HANDSET_UA_INFO_NOT_FOUND",
    0xC3D: "SB_FSM_INVALID_INFO",
    0xC3E: "NFB_TARGET_DUAL_BL_PAIRED_VERSION_NOT_MATCHED_WITH_MAUI",
    0xC3F: "NFB_TARGET_DUAL_BL_FEATURE_COMBINATION_NOT_MATCHED_WITH_MAUI",
    0xC40: "NFB_TARGET_IS_SINGLE_BL_BUT_PC_NOT",
    0xC41: "NFB_TARGET_IS_DUAL_BL_BUT_PC_NOT",
    0xC42: "NOR_TARGET_BL_PAIRED_VERSION_NOT_MATCHED_WITH_MAUI",
    0xC43: "NOR_TARGET_BL_FEATURE_COMBINATION_NOT_MATCHED_WITH_MAUI",
    0xC44: "NOR_TARGET_IS_NOT_NEW_BL_BUT_PC_IS",
    0xC45: "NOR_TARGET_IS_NEW_BL_BUT_PC_NOT",
    0xC46: "DOWNLOAD_BOOTLOADER_FLASH_DEV_IS_NONE",
    0xC47: "DOWNLOAD_BOOTLOADER_FLASH_DEV_IS_NOT_SUPPORTED",
    0xC48: "DOWNLOAD_BOOTLOADER_BEGIN_ADDR_OVERLAPS_WITH_PREVIOUS_BOUNDARY",
    0xC49: "UPDATE_BOOTLOADER_EXIST_MAGIC_NOT_MATCHED",
    0xC4A: "UPDATE_BOOTLOADER_FILE_TYPE_NOT_MATCHED",
    0xC4B: "UPDATE_BOOTLOADER_FILE_SIZE_EXCEEDS_BOUNDARY_ADDR",
    0xC4C: "UPDATE_BOOTLOADER_BEGIN_ADDR_NOT_MATCHED",
    0xC4D: "EMMC_FLASH_NOT_FOUND",
    0xC4E: "EMMC_FW_VER_CHECK_FAIL",
    0xC4F: "SDMMC_FLASH_NOT_FOUND",
    0xC50: "SDMMC_CONFIG_FAILED",
    0xC51: "SDMMC_READ_FAILED",
    0xC52: "SDMMC_WRITE_FAILED",
    0xC53: "SDMMC_ERR_CRC",
    0xC54: "SDMMC_ERR_TIMEOUT",
    0xC55: "SDMMC_UNSUPPORTED",
    0xC56: "DSPBL_CHECK_PLATFORM_FAILED",
    0xC57: "UFS_FLASH_NOT_FOUND",
    0xC58: "UFS_CONFIG_FAILED",
    0xC59: "UFS_READ_FAILED",
    0xC5A: "UFS_WRITE_FAILED",
    0xC5B: "UFS_ERR_TIMEOUT",
    0xC5C: "UFS_UNSUPPORTED",
    0xC5D: "UFS_OTP_NOT_SUPPORT",
    0xC5E: "UFS_OTP_EXIST",
    0xC5F: "UFS_OTP_LOCKED",
    0xC60: "UFS_OTP_LOCK_FAIL",
    0xC61: "UFS_OTP_UNLOCKED",
    0xC62: "HANDSET_SEC_CFG_NOT_FOUND",
    0xC63: "EMMC_OTP_NOT_SUPPORT",
    0xC64: "EMMC_OTP_EXIST",
    0xC65: "EMMC_OTP_LOCKED",
    0xC66: "EMMC_OTP_LOCK_FAIL",
    0xC67: "EMMC_OTP_UNLOCKED",
    0xC68: "READ_IMEI_PID_SWV_NOT_SUPPORT",
    0xC69: "NFI_EMPTY_PAGE",
    0xC6A: "INVALID_STORAGE_TYPE",
    0xC6B: "SEND_CMD_FAIL",
    0xC6C: "READ_CMD_ACK_FAIL",
    0xC6D: "READ_FLASH_STATUS_INFO_FAIL",
    0xC6E: "PL_VALIDATION_FAIL",
    0xC6F: "STORAGE_NOT_MATCH",
    0xC70: "CHIP_TYPE_NOT_MATCH",
    0xC71: "EXCEED_MAX_PARTITION_COUNT",
    # SECURITY
    0x1770: "CALLBACK_SLA_CHALLENGE_FAIL",
    0x1771: "SLA_WRONG_AUTH_FILE",
    0x1772: "SLA_INVALID_AUTH_FILE",
    0x1773: "SLA_CHALLENGE_FAIL",
    0x1774: "SLA_FAIL",
    0x1775: "DAA_FAIL",
    0x1776: "SBC_FAIL",
    0x1777: "SF_SECURE_VER_CHECK_FAIL",
    0x1778: "SF_HANDSET_SECURE_CUSTOM_NAME_NOT_MATCH",
    0x1779: "SF_FTCFG_LOCKDOWN",
    0x177A: "SF_CODE_DOWNLOAD_FORBIDDEN",
    0x177B: "SF_CODE_READBACK_FORBIDDEN",
    0x177C: "SF_CODE_FORMAT_FORBIDDEN",
    0x177D: "SF_SEC_RO_DOWNLOAD_FORBIDDEN",
    0x177E: "SF_SEC_RO_READBACK_FORBIDDEN",
    0x177F: "SF_SEC_RO_FORMAT_FORBIDDEN",
    0x1780: "SF_FAT_DOWNLOAD_FORBIDDEN",
    0x1781: "SF_FAT_READBACK_FORBIDDEN",
    0x1782: "SF_FAT_FORMAT_FORBIDDEN",
    0x1783: "SF_RESTRICTED_AREA_ACCESS_FORBIDDEN",
    0x1784: "SECURE_CUSTOM_NAME_NOT_MATCH_BETWEEN_AUTH_AND_DL_HANDLE",
    0x1785: "DOWNLOAD_FILE_IS_CORRUPTED",
    0x1786: "NOT_SUPPORT",
    0x1787: "BOOTLOADER_IMAGE_SIGNATURE_FAIL",
    0x1788: "BOOTLOADER_ELDER_SW_VERSION_CANNOT_BE_DOWNLOADED",
    0x1789: "BOOTLOADER_IMAGE_NO_SIGNATURE",
    0x178A: "BOOTLOADER_CORRUPTED_SCATTER_FILE",
    0x178B: "SECURE_USB_DL_NO_MAUI_IN_SCATTER_FILE",
    0x178C: "SEND_CERT_FAIL",
    0x178D: "SEND_AUTH_FAIL",
    0x178E: "GET_SEC_CONFIG_FAIL",
    0x178F: "GET_ME_ID_FAIL",
    0x1790: "GET_HW_SW_VER_FAIL",
    0x1791: "GET_HW_CODE_FAIL",
    0x1792: "ROM_INFO_NOT_FOUND",
    0x1793: "ROM_INFO_ID_MISMATCH",
    0x1794: "SEC_CTRL_ID_MISMATCH",
    0x1795: "SEC_KEY_ID_MISMATCH",
    0x1796: "SECURE_USB_DL_FAIL",
    0x1797: "SECURE_USB_DL_CHECK_TARGET_STATUS_FAIL",
    0x1798: "SECURE_USB_DL_SEND_CHIP_STATUS_FAIL",
    0x1799: "SECURE_USB_DL_DISABLED",
    0x179A: "SECURE_USB_DL_ENABLED",
    0x179B: "SECURE_USB_DL_IMAGE_PUBLIC_N_KEY_READ_FAIL",
    0x179C: "SECURE_USB_DL_IMAGE_PUBLIC_E_KEY_READ_FAIL",
    0x179D: "SECURE_USB_DL_IMAGE_SIGN_HEADER_NOT_FOUND",
    0x179E: "SECURE_USB_DL_IMGAE_SIGNATURE_VERIFY_FAIL",
    0x179F: "SECURE_USB_DL_IMAGE_HASH_FAIL",
    0x17A0: "SECURE_USB_DL_IMAGE_NOT_FOUND",
    0x17A1: "SECURE_USB_DL_INVALID_IMAGE_ARGUMENT",
    0x17A2: "SECURE_USB_DL_IMAGE_INFO_CHECK_CMD_INIT_FAIL",
    0x17A3: "SECURE_USB_DL_IMAGE_INFO_CHECK_CMD_WRITE_IMAGE_NAME_FAIL",
    0x17A4: "SECURE_USB_DL_IMAGE_INFO_CHECK_CMD_WRITE_IMAGE_NAME_LEN_FAIL",
    0x17A5: "SECURE_USB_DL_IMAGE_INFO_CHECK_CMD_WRITE_TYPE_FAIL",
    0x17A6: "SECURE_USB_DL_IMAGE_INFO_CHECK_CMD_WRITE_HEADER_FAIL",
    0x17A7: "SECURE_USB_DL_IMAGE_INFO_CHECK_CMD_WRITE_IMAGE_OFFSET_FAIL",
    0x17A8: "SECURE_USB_DL_IMAGE_INFO_CHECK_CMD_WRITE_SIGNATURE_HASH_FAIL",
    0x17A9: "SECURE_USB_DL_IMAGE_INFO_CHECK_CMD_GET_CHECK_RESULT_FAIL",
    0x17AA: "SECURE_USB_DL_IMAGE_INFO_CHECK_CMD_DOWNLOAD_IMAGE_INVALID",
    0x17AB: "SECURE_USB_DL_IMAGE_INFO_CHECK_CMD_UNKNOWN_CHECK_RESULT",
    0x17AC: "SECURE_USB_DL_IMAGE_INFO_CHECK_CMD_WRONG_OPERATION",
    0x17AD: "SECURE_USB_DL_IMAGE_INFO_CHECK_CMD_INVALID_HEADER_LENGTH",
    0x17AE: "SECURE_USB_DL_IMAGE_INFO_CHECK_CMD_INVALID_IMAGE_OFFSET",
    0x17AF: "SECURE_USB_DL_IMAGE_INFO_CHECK_CMD_INVALID_SIGNATURE_LENGTH",
    0x17F0: "SECURE_USB_DL_IMAGE_INFO_CHECK_CMD_SIGNATURE_LENGTH_TOO_LARGE",
    0x17F1: "SECURE_USB_DL_IMAGE_INFO_CHECK_CMD_IMAGE_NAME_LENGTH_TOO_LONG",
    0x17F2: "SECURE_USB_DL_IMAGE_INFO_CHECK_CMD_EXT_HEADER_TOO_LARGE",
    0x17F3: "SECURE_USB_DL_IMAGE_INFO_CHECK_CMD_EXT_HEADER_OFFSET_INVALID",
    0x17F4: "SECURE_USB_DL_IMAGE_INFO_CHECK_CMD_EXT_HEADER_SELF_COPY_FAIL",
    0x17F5: "SEC_CFG_NOT_EXIST",
    0x17F6: "SEC_CFG_WRITE_CMD_INIT_FAIL",
    0x17F7: "SEC_CFG_WRONG_MAGIC_NUMBER",
    0x17F8: "SEC_CFG_IS_FULL_CANNOT_ADD_NEW_IMAGE",
    0x17F9: "SEC_CFG_IMAGE_NOT_FOUND_SO_CANNOT_UPDATE",
    0x17FA: "SEC_CFG_IMAGE_CUST_NAME_MISMATCH",
    0x17FB: "SEC_CFG_IMAGE_CANNOT_ROLL_BACK_SW_LOAD",
    0x17FC: "SEC_CFG_IMAGE_EXIST_CANNOT_CREATE_MEW_FILE",
    0x17FD: "SEC_CFG_WRITE_FAIL_CFG_NOT_EXIST",
    0x17FE: "SEC_CFG_WRITE_FAIL_MAGIC_INCORRECT",
    0x17FF: "SEC_CFG_WRITE_FAIL_CANNOT_WRITE_TO_FIRST_BLOCK",
    0x1800: "SEC_CFG_WRITE_FAIL_YAFFS2_POST_PROCESS_FAIL",
    0x1801: "SEC_CFG_WRITE_FAIL_NAND_DEVICE",
    0x1802: "SEC_CFG_WRITE_FAIL_CANNOT_READ_BACK",
    0x1803: "SEC_CFG_WRITE_FAIL_READ_BACK_MAGIC_INCORRECT",
    0x1804: "SEC_CFG_WRITE_FAIL_READ_BACK_ID_INCORRECT",
    0x1805: "SEC_CFG_WRITE_FAIL_READ_BACK_STATUS_INCORRECT",
    0x1806: "SEC_CFG_WRITE_FAIL_READ_BACK_END_PATTERN_INCORRECT",
    0x1807: "SEC_CFG_WRITE_FAIL_SEC_CFG_CANNOT_OVERWRITE_NEXT_PARTITION",
    0x1808: "SEC_CFG_WRITE_FAIL_NAND_NOT_DETECTED",
    0x1809: "SEC_CFG_WRITE_FAIL_EMMC_NOT_DETECTED",
    0x180a: "SEC_CFG_WRITE_FAIL_EMMC_DEVICE",
    0x180b: "SEC_CFG_WRITE_FAIL_NAND_PAGE_SIZE_NOT_SUPPORT",
    0x180c: "SEC_CFG_WRITE_FAIL_NAND_FIND_GOOD_BLK_FAIL",
    0x180d: "SEC_CFG_WRITE_FAIL_NAND_ERASE_FAIL",
    0x180e: "SEC_CFG_WRITE_FAIL_UNKNOWN_DEVIE_TYPE",
    0x180f: "SEC_CFG_READ_FAIL_NAND_NOT_DETECTED",
    0x1810: "SEC_CFG_READ_FAIL_EMMC_NOT_DETECTED",
    0x1811: "SEC_CFG_READ_FAIL_EMMC_DEVICE",
    0x1812: "SEC_CFG_READ_FAIL_NAND_PAGE_SIZE_NOT_SUPPORT",
    0x1813: "SEC_CFG_READ_FAIL_NAND_FIND_GOOD_BLK_FAIL",
    0x1814: "SEC_CFG_READ_FAIL_UNKNOWN_DEVIE_TYPE",
    0x1815: "SEC_CFG_READ_FAIL_NAND_LOGICAL_READ_FAIL",
    0x1816: "SEC_CFG_EXT_REGION_SPACE_OVERFLOW",
    0x1817: "SECURE_USB_DL_ROM_INFO_UPDATE_REQUEST_FAIL",
    0x1818: "SECURE_USB_DL_DA_RETURN_INVALID_TYPE",
    0x1819: "SECURE_USB_DL_MOVE_IMAGE_HEADER_TO_END_FAIL",
    0x181a: "SECURE_USB_DL_NO_NEED_TO_MOVE_IMAGE_HEADER",
    0x181b: "SECURE_USB_DL_NO_NEED_TO_REMOVE_IMAGE_HEADER_AND_SIG",
    0x181c: "CIPHER_DATA_UNALIGNED",
    0x181d: "CIPHER_MODE_INVALID",
    0x181e: "CIPHER_KEY_INVALID",
    0x181f: "CIPHER_INIT_FAIL",
    0x1820: "CIPHER_ROM_NOT_LOADED",
    0x1821: "CIPHER_DEC_FAIL",
    0x1822: "CIPHER_ENC_TEST_FAIL",
    0x1823: "AES_VER_INVALID",
    0x1824: "INVALID_IMGDEC_CFG",
    0x1825: "IMGDEC_INVALID_FORCE_DEC_PARAM",
    0x1826: "IMGDEC_INVALID_AES_KEY_SIZE",
    0x1827: "IMGDEC_FAIL_IMAGE_NOT_ENCRYPTED",
    0x1828: "IMGDEC_INIT_FAIL_FTH_IS_NULL",
    0x1829: "IMGDEC_INIT_FAIL_DECH_IS_NULL",
    0x182a: "INIDEC_FAIL_INI_NOT_ENCRYPTED",
    0x182b: "INIDEC_INVALID_AES_KEY_SIZE",
    0x182c: "INVALID_PROJECT",
    0x182d: "SECRO_ANTICLONE_LENGTH_INVALID",
    0x182e: "SECRO_HASH_INCORRECT",
    0x182f: "SECRO_ENCRYPT_FAIL",
    0x1830: "AC_REGION_NOT_FOUND_IN_SECROIMG",

    # common

    0x1b58: "EPP_FAIL",
    0x1b59: "EPP_EXT_DRAM_NOT_FOUND",
    0x1b5a: "EPP_EXT_DRAM_INIT_FAIL",
    0x1b5b: "EPP_NO_EMI_CONFIG_PARAM_FAIL",
    0x2711: "PL_MODE_UNSUPPORTED",
    0x2712: "PL_MODE_FORBIDDEN",
    0x2713: "PL_MODE_INVALID_ARGUMETS",
    0x2714: "PL_READ_FAIL",
    0x2715: "PL_WRITE_FAIL",
    0x2716: "PL_READ_TIMEOUT",
    0x2717: "PL_WRITE_TIMEOUT",
    0x2718: "PL_DISC_CMD_NEEDED",

    0x1000: "CRYPTO_INIT_FAIL",
    0x1001: "CRYPTO_DEINIT_FAIL",
    0x1002: "CRYPTO_MODE_INVALID",
    0x1003: "CRYPTO_KEY_INVALID",
    0x1004: "CRYPTO_DATA_UNALIGNED",
    0X1005: "CRYPTO_SEEK_LEN_ERROR",
    0x1D00: "ADDRESS_TOO_HIGH_80000000",
    0x1D01: "ADDRESS_TOO_HIGH_40000000",
    0x1D02: "INVALID_ADDRESS",
    0x1D0C: "",
    0x1D0D: "SLA_ERROR",
    0x1D0E: "DA_OVERLAP",
    0x1D0F: "DA_INVALID_JUMP_ADDR",
    0x1D10: "DA_EXCEED_MAX_DA_BLOCKS",
    0x1D11: "DA_ADDR_NOT_16BITS_ALIGNED",
    0x1D12: "DA_INVALID_ADDR_AND_LEN",
    0x1D13: "DA_LEN_IS_ZERO",
    0x1D14: "DA_SIG_LEN_EXCEED_DA_LEN",
    0x1D15: "DA_SIG_LEN_IS_ZERO_AND_DAA_ACTIVE",
    0x1D16: "DA_NOT_EXIST",
    0x1D17: "DA_BLOCKS_INCONSISTENT_WITH_TOOL_AUTH",
    0x1D21: "DA_VERSION_NOT_SUPPORTED",
    0x2000: "AUTH_IMAGE_VERIFY_FAIL",
    0x2001: "DA_IMAGE_SIG_VERIFY_FAIL",
    0x2002: "DA_IMAGE_NO_MEM_FAIL",
    0x2003: "DA_INIT_KEY_FAIL",
    0x2004: "IMG_INIT_KEY_FAIL",
    0x2005: "HASH_IMAGE_FAIL",
    0x2006: "DA_RELOCATE_SIZE_NOT_ENOUGH",
    0x3000: "LIB_SEC_CFG_NOT_EXIST",
    0x3001: "LIB_VER_INVALID",
    0x3002: "LIB_SEC_CFG_ERASE_FAIL",
    0x3003: "LIB_SEC_CFG_CANNOT_WRITE",
    0x3004: "LIB_SEC_CFG_END_PATTERN_NOT_EXIST",
    0x3005: "LIB_SEC_CFG_STATUS_INVALID",
    0x3006: "LIB_SEC_CFG_READ_SIZE_NOT_ENOUGH",
    0x3007: "LIB_SEC_CFG_RSA_KEY_INIT_FAIL",
    0x4000: "IMG_VERIFY_THIS_IMG_INFO_NOT_EXIST",
    0x4001: "IMG_VERIFY_HASH_COMPARE_FAIL",
    0x4002: "IMG_VERIFY_NO_SPACE_ADD_IMG_INFO",
    0x4003: "SEC_DL_TOKEN_NOT_FOUND_IN_IMG",
    0x4004: "SEC_DL_FLOW_ERROR",
    0x4005: "IMG_VERIFY_INVALID_IMG_INFO_ATTR",
    0x4006: "IMG_SECROIMG_NOT_FOUND",
    0x4007: "IMG_READ_FAIL",
    0x4008: "IMG_VERIFY_SIGNATURE_FAIL",
    0x4009: "IMG_SIGN_FORMAT_NOT_MATCH",
    0x400A: "IMG_EXTENSION_HDR_NOT_FOUND",
    0x400B: "IMG_EXTENSION_MAGIC_WRONG",
    0x400C: "IMG_EXTENSION_TYPE_NOT_SUPPORT",
    0x400D: "IMG_EXTENSION_HASH_CAL_FAIL",
    0x5000: "IMG_LOCK_TABLE_NOT_EXIST",
    0x5001: "IMG_LOCK_ALL_LOCK",
    0x5002: "IMG_LOCK_NO_SPACE_ADD_LOCK_INFO",
    0x5003: "IMG_LOCK_THIS_IMG_INFO_NOT_EXIST",
    0x5004: "IMG_LOCK_MAGIC_ERROR",
    0x6000: "SBC_KEY_NOT_FOUND",
    0x6001: "BR_SEC_CFG_NOT_FOUND",
    0x7000: "REGION_INVALID_INCLUDE",
    0x7001: "REGION_INVALID_OVERLAP",
    0x7002: "REGION_INVALID_OVERFLOW",
    0x7003: "DA_INVALID_LOCATION",
    0x7004: "DA_INVALID_LENGTH",
    0x7015: "DAA_Security_Error_Signature",
    0x7017: "DAA_Security_Error",
    0x7024: "DAA_SIG_VERIFY_FAILED",
    0x8000: "INVALID_SIG_SZ",
    0x8001: "INVALID_PADDING_SZ",
    0x9000: "SW_ID_MISMATCH",
    0x9001: "INVALID_IMG_TYPE",
    0x9002: "BUF_NOT_ENOUGH_FOR_CERT",
    0x9003: "IMG_NOT_FOUND",
    0x9004: "IMG_HDR_HASH_VFY_FAIL",
    0x9005: "IMG_HASH_VFY_FAIL",
    0x9006: "INVALID_OID_SZ",
    0x9007: "INVALID_OID_BUF_SZ",
    0x9008: "END_OF_CERT",
    0x9009: "CERT_OBJ_ID_NOT_MATCH",
    0x900a: "CERT_OBJ_SZ_NOT_MATCH",
    0x900b: "CERT_TRAVERSE_UNKNOWN_MODE",
    0x900c: "INVALID_OID_IDX",
    0x900d: "OID_NOT_FOUND",
    0x900e: "OBJ_NOT_FOUND",
    0x900f: "E_KEY_LEN_NOT_MATCH",
    0x9010: "E_KEY_NOT_MATCH",
    0x9011: "N_KEY_LEN_NOT_MATCH",
    0x9012: "N_KEY_NOT_MATCH",
    0x9013: "PUBK_AUTH_FAIL",
    0x9014: "INVALID_IMG_HDR",
    0x9015: "NOT_EXPECTED_IMG",
    0xA000: "CERT_IMG_VER_NOT_SYNC",
    0xA001: "IMAGE_IMG_VER_NOT_SYNC",
    0xA002: "IMG_VER_ROLLBACK",
    0xA003: "OTP_FIELD_NOT_ENOUGH",
    0xA004: "OTP_REG_BIT_CONFIG_WRONG",
    0xA005: "OTP_WRITE_FAIL"
}

COMMON = 1
AUTHENTICATION = 2
LIBRARY = 3
DEV_HW = 4
FUNCTION = 5
BROM = 6
DA = 7
PRELOADER = 8

SUCCESS = (0 << 30)
INFO = (1 << 30)
WARNING = (2 << 30)
ERROR = (3 << 30)

ErrorCodes_XFlash = {
    0: "OK",
    0xc0010001: "Error",
    0xc0010002: "Abort",
    0xc0010003: "Unsupported command",
    0xc0010004: "Unsupported ctrl code",
    0xc0010005: "Protocol error",
    0xc0010006: "Protocol buffer overflow",
    0xc0010007: "Insufficient buffer",
    0xc0010008: "USB SCAN error",
    0xc0010009: "Invalid hsession",
    0xc001000A: "Invalid session",
    0xc001000B: "Invalid stage",
    0xc001000C: "Not implemented",
    0xc001000D: "File not found",
    0xc001000E: "Open file error",
    0xc001000F: "Write file error",
    0xc0010010: "Read file error",
    0xc0010011: "Create File error / Unsupported Version",
    0xc0020001: "Rom info not found",
    0xc0020002: "Cust name not found",
    0xc0020003: "Device not supported",
    0xc0020004: "DL forbidden",
    0xc0020005: "Img too large",
    0xc0020006: "PL verify fail",
    0xc0020007: "Image verify fail",
    0xc0020008: "Hash operation fail",
    0xc0020009: "Hash binding check fail",
    0xc002000a: "Invalid buf",
    0xc002000b: "Binding hash not available",
    0xc002000c: "Write data not allowed",
    0xc002000d: "Format not allowed",
    0xc002000e: "SV5 public key auth failed",
    0xc002000f: "SV5 hash verify failed",
    0xc0020010: "SV5 RSA OP failed",
    0xc0020011: "SV5 RSA verify failed",
    0xc0020012: "SV5 GFH not found",
    0xc0020013: "Cert1 invalid",
    0xc0020014: "Cert2 invalid",
    0xc0020015: "Imghdr invalid",
    0xc0020016: "Sig size invalid",
    0xc0020017: "RSA pss op fail",
    0xc0020018: "Cert auth failed",
    0xc0020019: "Public key auth mismatch n size",
    0xc002001a: "Public key auth mismatch e size",
    0xc002001b: "Public key auth mismatch n",
    0xc002001c: "Public key auth mismatch e",
    0xc002001d: "Public key auth mismatch hash",
    0xc002001e: "Cert obj not found",
    0xc002001f: "Cert oid not found",
    0xc0020020: "Cert out of range",
    0xc0020021: "Oid doesn't match",
    0xc0020022: "Length doesn't match",
    0xc0020023: "ASN1 unknown op",
    0xc0020024: "OID index out of range",
    0xc0020025: "OID too large",
    0xc0020026: "Public key size mismatch",
    0xc0020027: "SWID mismatch",
    0xc0020028: "Hash size mismatch",
    0xc0020029: "IMGHDR type mismatch",
    0xc002002a: "IMG type mismatch",
    0xc002002b: "IMGHDR hash verify failed",
    0xc002002c: "IMG has verify failed",
    0xc002002d: "Anti rollback violation",
    0xc002002e: "SECCFG not found",
    0xc002002f: "SECCFG magic incorrect",
    0xc0020030: "SECCFG invalid",
    0xc0020031: "Cipher mode invalid",
    0xc0020032: "Cipher key invalid",
    0xc0020033: "Cipher data unaligned",
    0xc0020034: "GFH file info not found",
    0xc0020035: "GFH anti clone not found",
    0xc0020036: "GFH sec cfg not found",
    0xc0020037: "Unsupported source type",
    0xc0020038: "Cust name mismatch",
    0xc0020039: "Invalid address",
    0xc0020040: "Certificate version not synced",
    0xc0020041: "Signature not synced",
    0xc0020042: "Ext AllInOne Signature rejected",
    0xc0020043: "Ext AllInOne Signature missing",
    0xc0020044: "Comm Key is not set",
    0xc0020045: "DevInfo Check failed",
    0xc0020046: "Bootimg count overflow",
    0xc0020047: "Signature not found",
    0xc0020048: "Bootimg special handle",
    0xc0020049: "Remote Seucrity policy disabled",
    0xc002004A: "RSA OAEP fail",
    0xc002004B: "Insufficient buffer",
    0xc002004C: "DA Anti-Rollback error",
    0xc002004D: "Get OTP value fail",
    0xc002004E: "Invalid unit size",
    0xc002004F: "Invalid group idx",
    0xc0020050: "Img version overflow",
    0xc0020051: "Otp table not initialized",
    0xc0020052: "Invalid Partition name",
    0xc0020053: "DA version Anti-Rollback error",
    0xc0020054: "Invalid msg size",
    0xc0020055: "Security level unsupported",
    0xc0020056: "Security level mismatch",
    0xc0020057: "Fault injection error",
    0xc0020058: "Public Key hash group invalid - too many root keys",
    0xc0020059: "Security level too large",
    0xc002005a: "Security config is formatted",
    0xc002005b: "Security config unknown error",
    0xc002005c: "Lockstate seccfg fail",
    0xc002005d: "Lockstate custom fail",
    0xc002005e: "Lockstate inconsistent",
    0xc0030001: "Scatter file invalid",
    0xc0030002: "DA file invalid",
    0xc0030003: "DA selection error",
    0xc0030004: "Preloader invalid",
    0xc0030005: "EMI hdr invalid",
    0xc0030006: "Storage mismatch",
    0xc0030007: "Invalid parameters",
    0xc0030008: "Invalid GPT",
    0xc0030009: "Invalid PMT",
    0xc003000a: "Layout changed",
    0xc003000b: "Invalid format param",
    0xc003000c: "Unknown storage section type",
    0xc003000d: "Unknown scatter field",
    0xc003000e: "Partition tbl doesn't exist",
    0xc003000f: "Scatter hw chip id mismatch",
    0xc0030010: "SEC cert file not found",
    0xc0030011: "SEC auth file not found",
    0xc0030012: "SEC auth file needed",
    0xc0030013: "EMI containter file not found",
    0xc0030014: "Scatter file not found",
    0xc0030015: "Xml file op error",
    0xc0030016: "Unsupported page size",
    0xc0030017: "EMI info length offset invalid",
    0xc0030018: "EMI info length invalid",
    0xc0040001: "Unsupported operation",
    0xc0040002: "Thread error",
    0xc0040003: "Checksum error",
    0xc0040004: "Unknown sparse",
    0xc0040005: "Unknown sparse chunk type",
    0xc0040006: "Partition not found",
    0xc0040007: "Read parttbl failed",
    0xc0040008: "Exceeded max partition number",
    0xc0040009: "Unknown storage type",
    0xc004000A: "Dram Test failed",
    0xc004000b: "Exceed available range",
    0xc004000c: "Write sparse image failed",
    0xc0040030: "MMC error",
    0xc0040040: "Nand error",
    0xc0040041: "Nand in progress",
    0xc0040042: "Nand timeout",
    0xc0040043: "Nand bad block",
    0xc0040044: "Nand erase failed",
    0xc0040045: "Nand page program failed",
    0xc0040050: "EMI setting version error",
    0xc0040060: "UFS error",
    0xc0040100: "DA OTP not supported",
    0xc0040102: "DA OTP lock failed",
    0xc0040200: "EFUSE unknown error",
    0xc0040201: "EFUSE write timeout without verify",
    0xc0040202: "EFUSE blown",
    0xc0040203: "EFUSE revert bit",
    0xc0040204: "EFUSE blown partly",
    0xc0040205: "EFUSE invalid argument",
    0xc0040206: "EFUSE value is not zero",
    0xc0040207: "EFUSE blown incorrect data",
    0xc0040208: "EFUSE broken",
    0xc0040209: "EFUSE blow error",
    0xc004020A: "EFUSE data process error",
    0xc004020B: "EFUSE unlock bpkey error",
    0xc004020C: "EFUSE create list error",
    0xc004020D: "EFUSE write register error",
    0xc004020E: "EFUSE padding type mismatch",
    0xc0050001: "Device ctrl exception",
    0xc0050002: "Shutdown Cmd exception",
    0xc0050003: "Download exception",
    0xc0050004: "Upload exception",
    0xc0050005: "Ext Ram exception",
    0xc0050006: "Notify Switch Usb Speed exception",
    0xc0050007: "Read data exception",
    0xc0050008: "Write data exception",
    0xc0050009: "Format exception",
    0xc005000A: "OTP operation exception",
    0xc005000B: "Switch usb exception",
    0xc005000C: "Write efuse exception",
    0xc005000D: "Read efuse exception",
    0xc0060001: "Brom start cmd/connect not preloader failed",
    0xc0060002: "Brom get bbchip hw ver failed",
    0xc0060003: "Brom cmd send da failed",
    0xc0060004: "Brom cmd jump da failed",
    0xc0060005: "Brom cmd failed",
    0xc0060006: "Brom stage callback failed",
    0xc0070001: "DA Version mismatch",
    0xc0070002: "DA not found",
    0xc0070003: "DA section not found",
    0xc0070004: "DA hash mismatch",
    0xc0070005: "DA exceed max num"
}


class ErrorHandler:
    def __init__(self):
        self.ec = ErrorCodes
        self.xec = ErrorCodes_XFlash

    def status(self, status):
        if status in self.ec:
            return self.ec[status] + " (" + hex(status) + ")"
        if status in self.xec:
            return self.xec[status] + " (" + hex(status) + ")"
        return "Unknown: " + hex(status)
