#############################################################################
#
# MODULE:   	Grass Compilation
# AUTHOR(S):	Original author unknown - probably CERL
#		Markus Neteler - Germany/Italy - neteler@itc.it
#   	    	Justin Hickey - Thailand - jhickey@hpcc.nectec.or.th
#   	    	Huidae Cho - Korea - grass4u@gmail.com
#   	    	Eric G. Miller - egm2@jps.net
# PURPOSE:  	The source file for this Makefile is in src/CMD/head/head.in.
#		It is the top part of a file called make.rules which is used
#		for compiling all GRASS modules. This part of the file provides
#		make variables that are dependent on the results of the
#		configure script.
# COPYRIGHT:    (C) 2000 by the GRASS Development Team
#
#               This program is free software under the GNU General Public
#   	    	License (>=v2). Read the file COPYING that comes with GRASS
#   	    	for details.
#
#############################################################################

############################## Make Variables ###############################

CC                  = gcc
CXX                 = g++
LEX                 = flex
YACC                = bison -y
PERL                = /usr/bin/perl
AR                  = ar
RANLIB              = ranlib
MKDIR               = mkdir -p
CHMOD               = chmod
INSTALL             = /usr/bin/install -c
INSTALL_DATA        = ${INSTALL} -m 644

prefix              = /usr/lib
exec_prefix         = ${prefix}
ARCH                = x86_64-alpine-linux-musl
UNIX_BIN            = ${exec_prefix}/bin
INST_DIR            = ${prefix}/grass83

GRASS_HOME          = /usr/lib/grass83
RUN_GISBASE         = /usr/lib/grass83

GRASS_VERSION_MAJOR = 8
GRASS_VERSION_MINOR = 3
GRASS_VERSION_RELEASE = 2
GRASS_VERSION_DATE  = 2024
GRASS_VERSION_GIT   = exported

STRIPFLAG           = 
LD_SEARCH_FLAGS     = -Wl,-rpath-link,${LIB_RUNTIME_DIR} -Wl,-rpath,${INST_DIR}/lib
LD_LIBRARY_PATH_VAR = LD_LIBRARY_PATH

#generate static (ST) or shared (SH)
GRASS_LIBRARY_TYPE  = shlib

#static libs:
STLIB_LD            = ${AR} cr
STLIB_PREFIX        = lib
STLIB_SUFFIX        = .a

#shared libs
SHLIB_PREFIX        = lib
SHLIB_LD            = gcc -shared
SHLIB_LDX           = g++ -shared
SHLIB_LDFLAGS       = -Wl,-soname,$(notdir $@)
SHLIB_CFLAGS        = -fPIC
SHLIB_SUFFIX        = .so
EXE                 = 

DEFAULT_DATABASE    =
DEFAULT_LOCATION    =

CPPFLAGS            = 
CFLAGS              = -Os -fstack-clash-protection -Wformat -Werror=format-security -fno-plt 
CXXFLAGS            = -Os -fstack-clash-protection -Wformat -Werror=format-security -D_GLIBCXX_ASSERTIONS=1 -D_LIBCPP_ENABLE_THREAD_SAFETY_ANNOTATIONS=1 -D_LIBCPP_ENABLE_HARDENED_MODE=1 -fno-plt
INCLUDE_DIRS        = 
LINK_FLAGS          = -Wl,--as-needed,-O1,--sort-common -Wl,-z,pack-relative-relocs -Wl,--export-dynamic

DLLIB               = 
XCFLAGS             = 
XLIBPATH            = 
XLIB                =  -lX11
XEXTRALIBS          = 
USE_X11             = 1

MATHLIB             = 
ICONVLIB            = 
INTLLIB             = -lintl
SOCKLIB             = 

#ZLIB:
ZLIB                =  -lz 
ZLIBINCPATH         = 
ZLIBLIBPATH         = 

#BZIP2:
BZIP2LIB            =  -lbz2 
BZIP2INCPATH        = 
BZIP2LIBPATH        = 

#ZSTD:
ZSTDLIB             =  -lzstd 
ZSTDINCPATH         = 
ZSTDLIBPATH         = 

DBMIEXTRALIB        = 

#readline
READLINEINCPATH     = 
READLINELIBPATH     = 
READLINELIB         =  -lreadline 
HISTORYLIB          =  -lhistory 

#PostgreSQL:
PQINCPATH           =  -I/usr/include/postgresql
PQLIBPATH           = 
PQLIB               =  -lpq 
USE_POSTGRES        = 1

#MySQL:
MYSQLINCPATH        =  -I/usr/include/mysql/
MYSQLLIBPATH        = 
MYSQLLIB            =  -lmysqlclient 
MYSQLDLIB           = 

#SQLite:
SQLITEINCPATH       = 
SQLITELIBPATH       = 
SQLITELIB           =  -lsqlite3 

#ODBC:
ODBCINC             = 
ODBCLIB             =  -lodbc 

#Image formats:
PNGINC              = -I/usr/include/libpng16
PNGLIB              = -L/usr/lib -lpng16 -lz
USE_PNG             = 1

TIFFINCPATH         = 
TIFFLIBPATH         = 
TIFFLIB             =  -ltiff 

#openGL files for NVIZ/r3.showdspf
OPENGLINC           = 
OPENGLLIB           =   -lGL 
OPENGLULIB          =   -lGLU 
OPENGL_X11          = 1
OPENGL_AQUA         = 
OPENGL_WINDOWS      = 
USE_OPENGL          = 1

#FFTW:
FFTWINC             = 
FFTWLIB             =  -lfftw3 

#LAPACK/BLAS stuff for gmath lib:
BLASLIB             = -lopenblas
BLASINC             = 
LAPACKLIB           =  -llapack 
LAPACKINC           = 

#GDAL/OGR
GDALLIBS            = -L/usr/lib -lgdal
GDALCFLAGS          = -I/usr/include
USE_GDAL            = 1
USE_OGR             = 1

#NetCDF
NETCDFLIBS          = -L/usr/lib -lnetcdf
NETCDFCFLAGS        = -I/usr/include
USE_NETCDF          = 1

#LAS LiDAR through libLAS
LASLIBS             = 
LASCFLAGS           = 
LASINC              = 
USE_LIBLAS          = 

#LAS LiDAR through PDAL
PDALLIBS             = -lpdalcpp -lgdal -lxml2
PDALINC              = -I/usr/include/pdal -I/usr/include/libxml2
USE_PDAL             = 1

#GEOS
GEOSLIBS            = -L/usr/lib -lgeos_c -lgeos_c 
GEOSCFLAGS          = -I/usr/include
USE_GEOS            = 1

#FreeType:
FTINC               = -I/usr/include/freetype2 -I/usr/include/libpng16
FTLIB               = -lfreetype -lfreetype 

#PROJ.4:
PROJINC             = 
PROJLIB             =  -lproj 
PROJSHARE           = /usr/share/proj

#OPENDWG:
OPENDWGINCPATH      = 
OPENDWGLIBPATH      = 
OPENDWGLIB          = 
USE_OPENDWG         = 

#cairo
CAIROINC                  = -I/usr/include/cairo -I/usr/include/freetype2 -I/usr/include/libpng16 -I/usr/include/pixman-1
CAIROLIB                  = -L/lib -lz -lpng16 -lfontconfig -lfreetype -lXext -lcairo -lXrender -lX11 -lfontconfig 
USE_CAIRO                 = 1
CAIRO_HAS_XRENDER         = 1
CAIRO_HAS_XRENDER_SURFACE = 1

#Python
PYTHON              = python3

#regex
REGEXINCPATH        = 
REGEXLIBPATH        = 
REGEXLIB            =  
USE_REGEX           = 1

#pthreads
PTHREADINCPATH      = 
PTHREADLIBPATH      = 
PTHREADLIB          =  
USE_PTHREAD         = 1

#OpenMP
OPENMP_INCPATH      = 
OPENMP_LIBPATH      = 
OPENMP_LIB          =  -lgomp 
OPENMP_CFLAGS       = -fopenmp
USE_OPENMP          = 1

#OpenCL
OCLINCPATH          = 
OCLLIBPATH          = 
OCLLIB              =  -lOpenCL 
USE_OPENCL          = 1

#i18N
HAVE_NLS            = 1

#Large File Support (LFS)
USE_LARGEFILES      = 1
LFS_CFLAGS          = 

#BSD sockets
HAVE_SOCKET         = 1

MINGW		    = 
WINDRES		    = 
MACOSX_APP	    = 
MACOSX_ARCHS        = 
MACOSX_SDK          = 

# Cross compilation
CROSS_COMPILING     = 
