# Copyright (C) 2022 The Qt Company Ltd.
# SPDX-License-Identifier: LicenseRef-Qt-Commercial OR LGPL-3.0-only OR GPL-2.0-only OR GPL-3.0-only
from __future__ import annotations

"""
This file contains the exact signatures for all functions in module
PySide6.QtQuick, except for defaults which are replaced by "...".
"""

# Module `PySide6.QtQuick`

import PySide6.QtQuick
import PySide6.QtCore
import PySide6.QtGui
import PySide6.QtOpenGL
import PySide6.QtQml

import enum
from typing import Any, ClassVar, Dict, List, Optional, Sequence, Tuple, Union, overload
from PySide6.QtCore import Signal
from shiboken6 import Shiboken


NoneType = type(None)


class QIntList(object): ...


class QQuickAsyncImageProvider(PySide6.QtQuick.QQuickImageProvider):

    def __init__(self) -> None: ...

    def requestImageResponse(self, id: str, requestedSize: PySide6.QtCore.QSize) -> PySide6.QtQuick.QQuickImageResponse: ...


class QQuickFramebufferObject(PySide6.QtQuick.QQuickItem):

    mirrorVerticallyChanged  : ClassVar[Signal] = ... # mirrorVerticallyChanged(bool)
    textureFollowsItemSizeChanged: ClassVar[Signal] = ... # textureFollowsItemSizeChanged(bool)

    class Renderer(Shiboken.Object):

        def __init__(self) -> None: ...

        def createFramebufferObject(self, size: PySide6.QtCore.QSize) -> PySide6.QtOpenGL.QOpenGLFramebufferObject: ...
        def framebufferObject(self) -> PySide6.QtOpenGL.QOpenGLFramebufferObject: ...
        def invalidateFramebufferObject(self) -> None: ...
        def render(self) -> None: ...
        def synchronize(self, arg__1: PySide6.QtQuick.QQuickFramebufferObject) -> None: ...
        def update(self) -> None: ...


    def __init__(self, parent: Optional[PySide6.QtQuick.QQuickItem] = ...) -> None: ...

    def createRenderer(self) -> PySide6.QtQuick.QQuickFramebufferObject.Renderer: ...
    def geometryChange(self, newGeometry: Union[PySide6.QtCore.QRectF, PySide6.QtCore.QRect], oldGeometry: Union[PySide6.QtCore.QRectF, PySide6.QtCore.QRect]) -> None: ...
    def isTextureProvider(self) -> bool: ...
    def mirrorVertically(self) -> bool: ...
    def releaseResources(self) -> None: ...
    def setMirrorVertically(self, enable: bool) -> None: ...
    def setTextureFollowsItemSize(self, follows: bool) -> None: ...
    def textureFollowsItemSize(self) -> bool: ...
    def textureProvider(self) -> PySide6.QtQuick.QSGTextureProvider: ...
    def updatePaintNode(self, arg__1: PySide6.QtQuick.QSGNode, arg__2: PySide6.QtQuick.QQuickItem.UpdatePaintNodeData) -> PySide6.QtQuick.QSGNode: ...


class QQuickGraphicsConfiguration(Shiboken.Object):

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, other: PySide6.QtQuick.QQuickGraphicsConfiguration) -> None: ...

    @staticmethod
    def __copy__() -> None: ...
    def deviceExtensions(self) -> List[PySide6.QtCore.QByteArray]: ...
    def isAutomaticPipelineCacheEnabled(self) -> bool: ...
    def isDebugLayerEnabled(self) -> bool: ...
    def isDebugMarkersEnabled(self) -> bool: ...
    def isDepthBufferEnabledFor2D(self) -> bool: ...
    def pipelineCacheLoadFile(self) -> str: ...
    def pipelineCacheSaveFile(self) -> str: ...
    @staticmethod
    def preferredInstanceExtensions() -> List[PySide6.QtCore.QByteArray]: ...
    def prefersSoftwareDevice(self) -> bool: ...
    def setAutomaticPipelineCache(self, enable: bool) -> None: ...
    def setDebugLayer(self, enable: bool) -> None: ...
    def setDebugMarkers(self, enable: bool) -> None: ...
    def setDepthBufferFor2D(self, enable: bool) -> None: ...
    def setDeviceExtensions(self, extensions: Sequence[PySide6.QtCore.QByteArray]) -> None: ...
    def setPipelineCacheLoadFile(self, filename: str) -> None: ...
    def setPipelineCacheSaveFile(self, filename: str) -> None: ...
    def setPreferSoftwareDevice(self, enable: bool) -> None: ...
    def setTimestamps(self, enable: bool) -> None: ...
    def timestampsEnabled(self) -> bool: ...


class QQuickGraphicsDevice(Shiboken.Object):

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, other: PySide6.QtQuick.QQuickGraphicsDevice) -> None: ...

    @staticmethod
    def __copy__() -> None: ...
    @staticmethod
    def fromOpenGLContext(context: PySide6.QtGui.QOpenGLContext) -> PySide6.QtQuick.QQuickGraphicsDevice: ...
    def isNull(self) -> bool: ...


class QQuickImageProvider(PySide6.QtQml.QQmlImageProviderBase):

    def __init__(self, type: PySide6.QtQml.QQmlImageProviderBase.ImageType, flags: PySide6.QtQml.QQmlImageProviderBase.Flag = ...) -> None: ...

    def flags(self) -> PySide6.QtQml.QQmlImageProviderBase.Flag: ...
    def imageType(self) -> PySide6.QtQml.QQmlImageProviderBase.ImageType: ...
    def requestImage(self, id: str, size: PySide6.QtCore.QSize, requestedSize: PySide6.QtCore.QSize) -> PySide6.QtGui.QImage: ...
    def requestPixmap(self, id: str, size: PySide6.QtCore.QSize, requestedSize: PySide6.QtCore.QSize) -> PySide6.QtGui.QPixmap: ...
    def requestTexture(self, id: str, size: PySide6.QtCore.QSize, requestedSize: PySide6.QtCore.QSize) -> PySide6.QtQuick.QQuickTextureFactory: ...


class QQuickImageResponse(PySide6.QtCore.QObject):

    finished                 : ClassVar[Signal] = ... # finished()

    def __init__(self) -> None: ...

    def cancel(self) -> None: ...
    def errorString(self) -> str: ...
    def textureFactory(self) -> PySide6.QtQuick.QQuickTextureFactory: ...


class QQuickItem(PySide6.QtCore.QObject, PySide6.QtQml.QQmlParserStatus):

    activeFocusChanged       : ClassVar[Signal] = ... # activeFocusChanged(bool)
    activeFocusOnTabChanged  : ClassVar[Signal] = ... # activeFocusOnTabChanged(bool)
    antialiasingChanged      : ClassVar[Signal] = ... # antialiasingChanged(bool)
    baselineOffsetChanged    : ClassVar[Signal] = ... # baselineOffsetChanged(double)
    childrenChanged          : ClassVar[Signal] = ... # childrenChanged()
    childrenRectChanged      : ClassVar[Signal] = ... # childrenRectChanged(QRectF)
    clipChanged              : ClassVar[Signal] = ... # clipChanged(bool)
    containmentMaskChanged   : ClassVar[Signal] = ... # containmentMaskChanged()
    enabledChanged           : ClassVar[Signal] = ... # enabledChanged()
    focusChanged             : ClassVar[Signal] = ... # focusChanged(bool)
    heightChanged            : ClassVar[Signal] = ... # heightChanged()
    implicitHeightChanged    : ClassVar[Signal] = ... # implicitHeightChanged()
    implicitWidthChanged     : ClassVar[Signal] = ... # implicitWidthChanged()
    opacityChanged           : ClassVar[Signal] = ... # opacityChanged()
    paletteChanged           : ClassVar[Signal] = ... # paletteChanged()
    paletteCreated           : ClassVar[Signal] = ... # paletteCreated()
    parentChanged            : ClassVar[Signal] = ... # parentChanged(QQuickItem*)
    rotationChanged          : ClassVar[Signal] = ... # rotationChanged()
    scaleChanged             : ClassVar[Signal] = ... # scaleChanged()
    smoothChanged            : ClassVar[Signal] = ... # smoothChanged(bool)
    stateChanged             : ClassVar[Signal] = ... # stateChanged(QString)
    transformOriginChanged   : ClassVar[Signal] = ... # transformOriginChanged(TransformOrigin)
    visibleChanged           : ClassVar[Signal] = ... # visibleChanged()
    visibleChildrenChanged   : ClassVar[Signal] = ... # visibleChildrenChanged()
    widthChanged             : ClassVar[Signal] = ... # widthChanged()
    windowChanged            : ClassVar[Signal] = ... # windowChanged(QQuickWindow*)
    xChanged                 : ClassVar[Signal] = ... # xChanged()
    yChanged                 : ClassVar[Signal] = ... # yChanged()
    zChanged                 : ClassVar[Signal] = ... # zChanged()

    class Flag(enum.Flag):

        ItemClipsChildrenToShape : QQuickItem.Flag = ... # 0x1
        ItemAcceptsInputMethod   : QQuickItem.Flag = ... # 0x2
        ItemIsFocusScope         : QQuickItem.Flag = ... # 0x4
        ItemHasContents          : QQuickItem.Flag = ... # 0x8
        ItemAcceptsDrops         : QQuickItem.Flag = ... # 0x10
        ItemIsViewport           : QQuickItem.Flag = ... # 0x20
        ItemObservesViewport     : QQuickItem.Flag = ... # 0x40

    class ItemChange(enum.Enum):

        ItemChildAddedChange     : QQuickItem.ItemChange = ... # 0x0
        ItemChildRemovedChange   : QQuickItem.ItemChange = ... # 0x1
        ItemSceneChange          : QQuickItem.ItemChange = ... # 0x2
        ItemVisibleHasChanged    : QQuickItem.ItemChange = ... # 0x3
        ItemParentHasChanged     : QQuickItem.ItemChange = ... # 0x4
        ItemOpacityHasChanged    : QQuickItem.ItemChange = ... # 0x5
        ItemActiveFocusHasChanged: QQuickItem.ItemChange = ... # 0x6
        ItemRotationHasChanged   : QQuickItem.ItemChange = ... # 0x7
        ItemAntialiasingHasChanged: QQuickItem.ItemChange = ... # 0x8
        ItemDevicePixelRatioHasChanged: QQuickItem.ItemChange = ... # 0x9
        ItemEnabledHasChanged    : QQuickItem.ItemChange = ... # 0xa

    class TransformOrigin(enum.Enum):

        TopLeft                  : QQuickItem.TransformOrigin = ... # 0x0
        Top                      : QQuickItem.TransformOrigin = ... # 0x1
        TopRight                 : QQuickItem.TransformOrigin = ... # 0x2
        Left                     : QQuickItem.TransformOrigin = ... # 0x3
        Center                   : QQuickItem.TransformOrigin = ... # 0x4
        Right                    : QQuickItem.TransformOrigin = ... # 0x5
        BottomLeft               : QQuickItem.TransformOrigin = ... # 0x6
        Bottom                   : QQuickItem.TransformOrigin = ... # 0x7
        BottomRight              : QQuickItem.TransformOrigin = ... # 0x8

    class UpdatePaintNodeData(Shiboken.Object):

        def __init__(self, UpdatePaintNodeData: PySide6.QtQuick.QQuickItem.UpdatePaintNodeData) -> None: ...

        @staticmethod
        def __copy__() -> None: ...


    def __init__(self, parent: Optional[PySide6.QtQuick.QQuickItem] = ...) -> None: ...

    def acceptHoverEvents(self) -> bool: ...
    def acceptTouchEvents(self) -> bool: ...
    def acceptedMouseButtons(self) -> PySide6.QtCore.Qt.MouseButton: ...
    def activeFocusOnTab(self) -> bool: ...
    def antialiasing(self) -> bool: ...
    def baselineOffset(self) -> float: ...
    def boundingRect(self) -> PySide6.QtCore.QRectF: ...
    def childAt(self, x: float, y: float) -> PySide6.QtQuick.QQuickItem: ...
    def childItems(self) -> List[PySide6.QtQuick.QQuickItem]: ...
    def childMouseEventFilter(self, arg__1: PySide6.QtQuick.QQuickItem, arg__2: PySide6.QtCore.QEvent) -> bool: ...
    def childrenRect(self) -> PySide6.QtCore.QRectF: ...
    def classBegin(self) -> None: ...
    def clip(self) -> bool: ...
    def clipRect(self) -> PySide6.QtCore.QRectF: ...
    def componentComplete(self) -> None: ...
    def containmentMask(self) -> PySide6.QtCore.QObject: ...
    def contains(self, point: Union[PySide6.QtCore.QPointF, PySide6.QtCore.QPoint, PySide6.QtGui.QPainterPath.Element]) -> bool: ...
    def cursor(self) -> PySide6.QtGui.QCursor: ...
    def dragEnterEvent(self, arg__1: PySide6.QtGui.QDragEnterEvent) -> None: ...
    def dragLeaveEvent(self, arg__1: PySide6.QtGui.QDragLeaveEvent) -> None: ...
    def dragMoveEvent(self, arg__1: PySide6.QtGui.QDragMoveEvent) -> None: ...
    def dropEvent(self, arg__1: PySide6.QtGui.QDropEvent) -> None: ...
    def dumpItemTree(self) -> None: ...
    def ensurePolished(self) -> None: ...
    def event(self, arg__1: PySide6.QtCore.QEvent) -> bool: ...
    def filtersChildMouseEvents(self) -> bool: ...
    def flags(self) -> PySide6.QtQuick.QQuickItem.Flag: ...
    def focusInEvent(self, arg__1: PySide6.QtGui.QFocusEvent) -> None: ...
    def focusOutEvent(self, arg__1: PySide6.QtGui.QFocusEvent) -> None: ...
    @overload
    def forceActiveFocus(self) -> None: ...
    @overload
    def forceActiveFocus(self, reason: PySide6.QtCore.Qt.FocusReason) -> None: ...
    def geometryChange(self, newGeometry: Union[PySide6.QtCore.QRectF, PySide6.QtCore.QRect], oldGeometry: Union[PySide6.QtCore.QRectF, PySide6.QtCore.QRect]) -> None: ...
    def grabMouse(self) -> None: ...
    @overload
    def grabToImage(self, callback: Union[PySide6.QtQml.QJSValue, PySide6.QtQml.QJSValue.SpecialValue, bool, str, bytes, float, int], targetSize: PySide6.QtCore.QSize = ...) -> bool: ...
    @overload
    def grabToImage(self, targetSize: PySide6.QtCore.QSize = ...) -> Tuple[PySide6.QtQuick.QQuickItemGrabResult]: ...
    def grabTouchPoints(self, ids: Sequence[int]) -> None: ...
    def hasActiveFocus(self) -> bool: ...
    def hasFocus(self) -> bool: ...
    def height(self) -> float: ...
    def heightValid(self) -> bool: ...
    def hoverEnterEvent(self, event: PySide6.QtGui.QHoverEvent) -> None: ...
    def hoverLeaveEvent(self, event: PySide6.QtGui.QHoverEvent) -> None: ...
    def hoverMoveEvent(self, event: PySide6.QtGui.QHoverEvent) -> None: ...
    def implicitHeight(self) -> float: ...
    def implicitWidth(self) -> float: ...
    def inputMethodEvent(self, arg__1: PySide6.QtGui.QInputMethodEvent) -> None: ...
    def inputMethodQuery(self, query: PySide6.QtCore.Qt.InputMethodQuery) -> Any: ...
    def isAncestorOf(self, child: PySide6.QtQuick.QQuickItem) -> bool: ...
    def isComponentComplete(self) -> bool: ...
    def isEnabled(self) -> bool: ...
    def isFocusScope(self) -> bool: ...
    def isTextureProvider(self) -> bool: ...
    def isUnderMouse(self) -> bool: ...
    def isVisible(self) -> bool: ...
    def itemTransform(self, arg__1: PySide6.QtQuick.QQuickItem) -> Tuple[bool, PySide6.QtGui.QTransform]: ...
    def keepMouseGrab(self) -> bool: ...
    def keepTouchGrab(self) -> bool: ...
    def keyPressEvent(self, event: PySide6.QtGui.QKeyEvent) -> None: ...
    def keyReleaseEvent(self, event: PySide6.QtGui.QKeyEvent) -> None: ...
    @overload
    def mapFromGlobal(self, point: Union[PySide6.QtCore.QPointF, PySide6.QtCore.QPoint, PySide6.QtGui.QPainterPath.Element]) -> PySide6.QtCore.QPointF: ...
    @overload
    def mapFromGlobal(self, x: float, y: float) -> PySide6.QtCore.QPointF: ...
    @overload
    def mapFromItem(self, item: PySide6.QtQuick.QQuickItem, point: Union[PySide6.QtCore.QPointF, PySide6.QtCore.QPoint, PySide6.QtGui.QPainterPath.Element]) -> PySide6.QtCore.QPointF: ...
    @overload
    def mapFromItem(self, item: PySide6.QtQuick.QQuickItem, rect: Union[PySide6.QtCore.QRectF, PySide6.QtCore.QRect]) -> PySide6.QtCore.QRectF: ...
    @overload
    def mapFromItem(self, item: PySide6.QtQuick.QQuickItem, x: float, y: float) -> PySide6.QtCore.QPointF: ...
    @overload
    def mapFromItem(self, item: PySide6.QtQuick.QQuickItem, x: float, y: float, width: float, height: float) -> PySide6.QtCore.QRectF: ...
    def mapFromScene(self, point: Union[PySide6.QtCore.QPointF, PySide6.QtCore.QPoint, PySide6.QtGui.QPainterPath.Element]) -> PySide6.QtCore.QPointF: ...
    def mapRectFromItem(self, item: PySide6.QtQuick.QQuickItem, rect: Union[PySide6.QtCore.QRectF, PySide6.QtCore.QRect]) -> PySide6.QtCore.QRectF: ...
    def mapRectFromScene(self, rect: Union[PySide6.QtCore.QRectF, PySide6.QtCore.QRect]) -> PySide6.QtCore.QRectF: ...
    def mapRectToItem(self, item: PySide6.QtQuick.QQuickItem, rect: Union[PySide6.QtCore.QRectF, PySide6.QtCore.QRect]) -> PySide6.QtCore.QRectF: ...
    def mapRectToScene(self, rect: Union[PySide6.QtCore.QRectF, PySide6.QtCore.QRect]) -> PySide6.QtCore.QRectF: ...
    @overload
    def mapToGlobal(self, point: Union[PySide6.QtCore.QPointF, PySide6.QtCore.QPoint, PySide6.QtGui.QPainterPath.Element]) -> PySide6.QtCore.QPointF: ...
    @overload
    def mapToGlobal(self, x: float, y: float) -> PySide6.QtCore.QPointF: ...
    @overload
    def mapToItem(self, item: PySide6.QtQuick.QQuickItem, point: Union[PySide6.QtCore.QPointF, PySide6.QtCore.QPoint, PySide6.QtGui.QPainterPath.Element]) -> PySide6.QtCore.QPointF: ...
    @overload
    def mapToItem(self, item: PySide6.QtQuick.QQuickItem, rect: Union[PySide6.QtCore.QRectF, PySide6.QtCore.QRect]) -> PySide6.QtCore.QRectF: ...
    @overload
    def mapToItem(self, item: PySide6.QtQuick.QQuickItem, x: float, y: float) -> PySide6.QtCore.QPointF: ...
    @overload
    def mapToItem(self, item: PySide6.QtQuick.QQuickItem, x: float, y: float, width: float, height: float) -> PySide6.QtCore.QRectF: ...
    def mapToScene(self, point: Union[PySide6.QtCore.QPointF, PySide6.QtCore.QPoint, PySide6.QtGui.QPainterPath.Element]) -> PySide6.QtCore.QPointF: ...
    def mouseDoubleClickEvent(self, event: PySide6.QtGui.QMouseEvent) -> None: ...
    def mouseMoveEvent(self, event: PySide6.QtGui.QMouseEvent) -> None: ...
    def mousePressEvent(self, event: PySide6.QtGui.QMouseEvent) -> None: ...
    def mouseReleaseEvent(self, event: PySide6.QtGui.QMouseEvent) -> None: ...
    def mouseUngrabEvent(self) -> None: ...
    def nextItemInFocusChain(self, forward: bool = ...) -> PySide6.QtQuick.QQuickItem: ...
    def opacity(self) -> float: ...
    def parentItem(self) -> PySide6.QtQuick.QQuickItem: ...
    def polish(self) -> None: ...
    def position(self) -> PySide6.QtCore.QPointF: ...
    def releaseResources(self) -> None: ...
    def resetAntialiasing(self) -> None: ...
    def resetHeight(self) -> None: ...
    def resetWidth(self) -> None: ...
    def rotation(self) -> float: ...
    def scale(self) -> float: ...
    def scopedFocusItem(self) -> PySide6.QtQuick.QQuickItem: ...
    def setAcceptHoverEvents(self, enabled: bool) -> None: ...
    def setAcceptTouchEvents(self, accept: bool) -> None: ...
    def setAcceptedMouseButtons(self, buttons: PySide6.QtCore.Qt.MouseButton) -> None: ...
    def setActiveFocusOnTab(self, arg__1: bool) -> None: ...
    def setAntialiasing(self, arg__1: bool) -> None: ...
    def setBaselineOffset(self, arg__1: float) -> None: ...
    def setClip(self, arg__1: bool) -> None: ...
    def setContainmentMask(self, mask: PySide6.QtCore.QObject) -> None: ...
    def setCursor(self, cursor: Union[PySide6.QtGui.QCursor, PySide6.QtCore.Qt.CursorShape, PySide6.QtGui.QPixmap]) -> None: ...
    def setEnabled(self, arg__1: bool) -> None: ...
    def setFiltersChildMouseEvents(self, filter: bool) -> None: ...
    def setFlag(self, flag: PySide6.QtQuick.QQuickItem.Flag, enabled: bool = ...) -> None: ...
    def setFlags(self, flags: PySide6.QtQuick.QQuickItem.Flag) -> None: ...
    @overload
    def setFocus(self, arg__1: bool) -> None: ...
    @overload
    def setFocus(self, focus: bool, reason: PySide6.QtCore.Qt.FocusReason) -> None: ...
    def setHeight(self, arg__1: float) -> None: ...
    def setImplicitHeight(self, arg__1: float) -> None: ...
    def setImplicitSize(self, arg__1: float, arg__2: float) -> None: ...
    def setImplicitWidth(self, arg__1: float) -> None: ...
    def setKeepMouseGrab(self, arg__1: bool) -> None: ...
    def setKeepTouchGrab(self, arg__1: bool) -> None: ...
    def setOpacity(self, arg__1: float) -> None: ...
    def setParentItem(self, parent: PySide6.QtQuick.QQuickItem) -> None: ...
    def setPosition(self, arg__1: Union[PySide6.QtCore.QPointF, PySide6.QtCore.QPoint, PySide6.QtGui.QPainterPath.Element]) -> None: ...
    def setRotation(self, arg__1: float) -> None: ...
    def setScale(self, arg__1: float) -> None: ...
    def setSize(self, size: Union[PySide6.QtCore.QSizeF, PySide6.QtCore.QSize]) -> None: ...
    def setSmooth(self, arg__1: bool) -> None: ...
    def setState(self, arg__1: str) -> None: ...
    def setTransformOrigin(self, arg__1: PySide6.QtQuick.QQuickItem.TransformOrigin) -> None: ...
    def setTransformOriginPoint(self, arg__1: Union[PySide6.QtCore.QPointF, PySide6.QtCore.QPoint, PySide6.QtGui.QPainterPath.Element]) -> None: ...
    def setVisible(self, arg__1: bool) -> None: ...
    def setWidth(self, arg__1: float) -> None: ...
    def setX(self, arg__1: float) -> None: ...
    def setY(self, arg__1: float) -> None: ...
    def setZ(self, arg__1: float) -> None: ...
    def size(self) -> PySide6.QtCore.QSizeF: ...
    def smooth(self) -> bool: ...
    def stackAfter(self, arg__1: PySide6.QtQuick.QQuickItem) -> None: ...
    def stackBefore(self, arg__1: PySide6.QtQuick.QQuickItem) -> None: ...
    def state(self) -> str: ...
    def textureProvider(self) -> PySide6.QtQuick.QSGTextureProvider: ...
    def touchEvent(self, event: PySide6.QtGui.QTouchEvent) -> None: ...
    def touchUngrabEvent(self) -> None: ...
    def transformOrigin(self) -> PySide6.QtQuick.QQuickItem.TransformOrigin: ...
    def transformOriginPoint(self) -> PySide6.QtCore.QPointF: ...
    def ungrabMouse(self) -> None: ...
    def ungrabTouchPoints(self) -> None: ...
    def unsetCursor(self) -> None: ...
    def update(self) -> None: ...
    def updateInputMethod(self, queries: PySide6.QtCore.Qt.InputMethodQuery = ...) -> None: ...
    def updatePaintNode(self, arg__1: PySide6.QtQuick.QSGNode, arg__2: PySide6.QtQuick.QQuickItem.UpdatePaintNodeData) -> PySide6.QtQuick.QSGNode: ...
    def updatePolish(self) -> None: ...
    def viewportItem(self) -> PySide6.QtQuick.QQuickItem: ...
    def wheelEvent(self, event: PySide6.QtGui.QWheelEvent) -> None: ...
    def width(self) -> float: ...
    def widthValid(self) -> bool: ...
    def window(self) -> PySide6.QtQuick.QQuickWindow: ...
    def x(self) -> float: ...
    def y(self) -> float: ...
    def z(self) -> float: ...


class QQuickItemGrabResult(PySide6.QtCore.QObject):

    ready                    : ClassVar[Signal] = ... # ready()
    def event(self, arg__1: PySide6.QtCore.QEvent) -> bool: ...
    def image(self) -> PySide6.QtGui.QImage: ...
    @overload
    def saveToFile(self, fileName: str) -> bool: ...
    @overload
    def saveToFile(self, fileName: Union[PySide6.QtCore.QUrl, str]) -> bool: ...
    def url(self) -> PySide6.QtCore.QUrl: ...


class QQuickPaintedItem(PySide6.QtQuick.QQuickItem):

    contentsScaleChanged     : ClassVar[Signal] = ... # contentsScaleChanged()
    contentsSizeChanged      : ClassVar[Signal] = ... # contentsSizeChanged()
    fillColorChanged         : ClassVar[Signal] = ... # fillColorChanged()
    renderTargetChanged      : ClassVar[Signal] = ... # renderTargetChanged()
    textureSizeChanged       : ClassVar[Signal] = ... # textureSizeChanged()

    class PerformanceHint(enum.Flag):

        FastFBOResizing          : QQuickPaintedItem.PerformanceHint = ... # 0x1

    class RenderTarget(enum.Enum):

        Image                    : QQuickPaintedItem.RenderTarget = ... # 0x0
        FramebufferObject        : QQuickPaintedItem.RenderTarget = ... # 0x1
        InvertedYFramebufferObject: QQuickPaintedItem.RenderTarget = ... # 0x2


    def __init__(self, parent: Optional[PySide6.QtQuick.QQuickItem] = ...) -> None: ...

    def antialiasing(self) -> bool: ...
    def contentsBoundingRect(self) -> PySide6.QtCore.QRectF: ...
    def contentsScale(self) -> float: ...
    def contentsSize(self) -> PySide6.QtCore.QSize: ...
    def fillColor(self) -> PySide6.QtGui.QColor: ...
    def isTextureProvider(self) -> bool: ...
    def mipmap(self) -> bool: ...
    def opaquePainting(self) -> bool: ...
    def paint(self, painter: PySide6.QtGui.QPainter) -> None: ...
    def performanceHints(self) -> PySide6.QtQuick.QQuickPaintedItem.PerformanceHint: ...
    def releaseResources(self) -> None: ...
    def renderTarget(self) -> PySide6.QtQuick.QQuickPaintedItem.RenderTarget: ...
    def resetContentsSize(self) -> None: ...
    def setAntialiasing(self, enable: bool) -> None: ...
    def setContentsScale(self, arg__1: float) -> None: ...
    def setContentsSize(self, arg__1: PySide6.QtCore.QSize) -> None: ...
    def setFillColor(self, arg__1: Union[PySide6.QtGui.QColor, PySide6.QtGui.QRgba64, Any, PySide6.QtCore.Qt.GlobalColor, str, int]) -> None: ...
    def setMipmap(self, enable: bool) -> None: ...
    def setOpaquePainting(self, opaque: bool) -> None: ...
    def setPerformanceHint(self, hint: PySide6.QtQuick.QQuickPaintedItem.PerformanceHint, enabled: bool = ...) -> None: ...
    def setPerformanceHints(self, hints: PySide6.QtQuick.QQuickPaintedItem.PerformanceHint) -> None: ...
    def setRenderTarget(self, target: PySide6.QtQuick.QQuickPaintedItem.RenderTarget) -> None: ...
    def setTextureSize(self, size: PySide6.QtCore.QSize) -> None: ...
    def textureProvider(self) -> PySide6.QtQuick.QSGTextureProvider: ...
    def textureSize(self) -> PySide6.QtCore.QSize: ...
    def update(self, rect: PySide6.QtCore.QRect = ...) -> None: ...
    def updatePaintNode(self, arg__1: PySide6.QtQuick.QSGNode, arg__2: PySide6.QtQuick.QQuickItem.UpdatePaintNodeData) -> PySide6.QtQuick.QSGNode: ...


class QQuickRenderControl(PySide6.QtCore.QObject):

    renderRequested          : ClassVar[Signal] = ... # renderRequested()
    sceneChanged             : ClassVar[Signal] = ... # sceneChanged()

    def __init__(self, parent: Optional[PySide6.QtCore.QObject] = ...) -> None: ...

    def beginFrame(self) -> None: ...
    def endFrame(self) -> None: ...
    def initialize(self) -> bool: ...
    def invalidate(self) -> None: ...
    def polishItems(self) -> None: ...
    def prepareThread(self, targetThread: PySide6.QtCore.QThread) -> None: ...
    def render(self) -> None: ...
    def renderWindow(self, offset: PySide6.QtCore.QPoint) -> PySide6.QtGui.QWindow: ...
    @staticmethod
    def renderWindowFor(win: PySide6.QtQuick.QQuickWindow, offset: Optional[PySide6.QtCore.QPoint] = ...) -> PySide6.QtGui.QWindow: ...
    def samples(self) -> int: ...
    def setSamples(self, sampleCount: int) -> None: ...
    def sync(self) -> bool: ...
    def window(self) -> PySide6.QtQuick.QQuickWindow: ...


class QQuickRenderTarget(Shiboken.Object):

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, other: PySide6.QtQuick.QQuickRenderTarget) -> None: ...

    @staticmethod
    def __copy__() -> None: ...
    def devicePixelRatio(self) -> float: ...
    @staticmethod
    def fromOpenGLRenderBuffer(renderbufferId: int, pixelSize: PySide6.QtCore.QSize, sampleCount: int = ...) -> PySide6.QtQuick.QQuickRenderTarget: ...
    @overload
    @staticmethod
    def fromOpenGLTexture(textureId: int, format: int, pixelSize: PySide6.QtCore.QSize, sampleCount: int = ...) -> PySide6.QtQuick.QQuickRenderTarget: ...
    @overload
    @staticmethod
    def fromOpenGLTexture(textureId: int, pixelSize: PySide6.QtCore.QSize, sampleCount: int = ...) -> PySide6.QtQuick.QQuickRenderTarget: ...
    @staticmethod
    def fromPaintDevice(device: PySide6.QtGui.QPaintDevice) -> PySide6.QtQuick.QQuickRenderTarget: ...
    def isNull(self) -> bool: ...
    def mirrorVertically(self) -> bool: ...
    def setDevicePixelRatio(self, ratio: float) -> None: ...
    def setMirrorVertically(self, enable: bool) -> None: ...


class QQuickTextDocument(PySide6.QtCore.QObject):

    def __init__(self, parent: PySide6.QtQuick.QQuickItem) -> None: ...

    def textDocument(self) -> PySide6.QtGui.QTextDocument: ...


class QQuickTextureFactory(PySide6.QtCore.QObject):

    def __init__(self) -> None: ...

    def createTexture(self, window: PySide6.QtQuick.QQuickWindow) -> PySide6.QtQuick.QSGTexture: ...
    def image(self) -> PySide6.QtGui.QImage: ...
    def textureByteCount(self) -> int: ...
    @staticmethod
    def textureFactoryForImage(image: Union[PySide6.QtGui.QImage, str]) -> PySide6.QtQuick.QQuickTextureFactory: ...
    def textureSize(self) -> PySide6.QtCore.QSize: ...


class QQuickTransform(PySide6.QtCore.QObject):

    def __init__(self, parent: Optional[PySide6.QtCore.QObject] = ...) -> None: ...

    def appendToItem(self, arg__1: PySide6.QtQuick.QQuickItem) -> None: ...
    def applyTo(self, matrix: Union[PySide6.QtGui.QMatrix4x4, PySide6.QtGui.QTransform]) -> None: ...
    def prependToItem(self, arg__1: PySide6.QtQuick.QQuickItem) -> None: ...
    def update(self) -> None: ...


class QQuickView(PySide6.QtQuick.QQuickWindow):

    statusChanged            : ClassVar[Signal] = ... # statusChanged(QQuickView::Status)

    class ResizeMode(enum.Enum):

        SizeViewToRootObject     : QQuickView.ResizeMode = ... # 0x0
        SizeRootObjectToView     : QQuickView.ResizeMode = ... # 0x1

    class Status(enum.Enum):

        Null                     : QQuickView.Status = ... # 0x0
        Ready                    : QQuickView.Status = ... # 0x1
        Loading                  : QQuickView.Status = ... # 0x2
        Error                    : QQuickView.Status = ... # 0x3


    @overload
    def __init__(self, engine: PySide6.QtQml.QQmlEngine, parent: PySide6.QtGui.QWindow) -> None: ...
    @overload
    def __init__(self, parent: Optional[PySide6.QtGui.QWindow] = ...) -> None: ...
    @overload
    def __init__(self, source: Union[PySide6.QtCore.QUrl, str], parent: Optional[PySide6.QtGui.QWindow] = ...) -> None: ...
    @overload
    def __init__(self, source: Union[PySide6.QtCore.QUrl, str], renderControl: PySide6.QtQuick.QQuickRenderControl) -> None: ...

    def engine(self) -> PySide6.QtQml.QQmlEngine: ...
    def errors(self) -> List[PySide6.QtQml.QQmlError]: ...
    def initialSize(self) -> PySide6.QtCore.QSize: ...
    def keyPressEvent(self, arg__1: PySide6.QtGui.QKeyEvent) -> None: ...
    def keyReleaseEvent(self, arg__1: PySide6.QtGui.QKeyEvent) -> None: ...
    def mouseMoveEvent(self, arg__1: PySide6.QtGui.QMouseEvent) -> None: ...
    def mousePressEvent(self, arg__1: PySide6.QtGui.QMouseEvent) -> None: ...
    def mouseReleaseEvent(self, arg__1: PySide6.QtGui.QMouseEvent) -> None: ...
    def resizeEvent(self, arg__1: PySide6.QtGui.QResizeEvent) -> None: ...
    def resizeMode(self) -> PySide6.QtQuick.QQuickView.ResizeMode: ...
    def rootContext(self) -> PySide6.QtQml.QQmlContext: ...
    def rootObject(self) -> PySide6.QtQuick.QQuickItem: ...
    def setContent(self, url: Union[PySide6.QtCore.QUrl, str], component: PySide6.QtQml.QQmlComponent, item: PySide6.QtCore.QObject) -> None: ...
    def setInitialProperties(self, initialProperties: Dict[str, Any]) -> None: ...
    def setResizeMode(self, arg__1: PySide6.QtQuick.QQuickView.ResizeMode) -> None: ...
    def setSource(self, arg__1: Union[PySide6.QtCore.QUrl, str]) -> None: ...
    def sizeHint(self) -> PySide6.QtCore.QSize: ...
    def source(self) -> PySide6.QtCore.QUrl: ...
    def status(self) -> PySide6.QtQuick.QQuickView.Status: ...
    def timerEvent(self, arg__1: PySide6.QtCore.QTimerEvent) -> None: ...


class QQuickWindow(PySide6.QtGui.QWindow):

    activeFocusItemChanged   : ClassVar[Signal] = ... # activeFocusItemChanged()
    afterAnimating           : ClassVar[Signal] = ... # afterAnimating()
    afterFrameEnd            : ClassVar[Signal] = ... # afterFrameEnd()
    afterRenderPassRecording : ClassVar[Signal] = ... # afterRenderPassRecording()
    afterRendering           : ClassVar[Signal] = ... # afterRendering()
    afterSynchronizing       : ClassVar[Signal] = ... # afterSynchronizing()
    beforeFrameBegin         : ClassVar[Signal] = ... # beforeFrameBegin()
    beforeRenderPassRecording: ClassVar[Signal] = ... # beforeRenderPassRecording()
    beforeRendering          : ClassVar[Signal] = ... # beforeRendering()
    beforeSynchronizing      : ClassVar[Signal] = ... # beforeSynchronizing()
    closing                  : ClassVar[Signal] = ... # closing(QQuickCloseEvent*)
    colorChanged             : ClassVar[Signal] = ... # colorChanged(QColor)
    frameSwapped             : ClassVar[Signal] = ... # frameSwapped()
    paletteChanged           : ClassVar[Signal] = ... # paletteChanged()
    paletteCreated           : ClassVar[Signal] = ... # paletteCreated()
    sceneGraphAboutToStop    : ClassVar[Signal] = ... # sceneGraphAboutToStop()
    sceneGraphError          : ClassVar[Signal] = ... # sceneGraphError(QQuickWindow::SceneGraphError,QString)
    sceneGraphInitialized    : ClassVar[Signal] = ... # sceneGraphInitialized()
    sceneGraphInvalidated    : ClassVar[Signal] = ... # sceneGraphInvalidated()

    class CreateTextureOption(enum.Flag):

        TextureHasAlphaChannel   : QQuickWindow.CreateTextureOption = ... # 0x1
        TextureHasMipmaps        : QQuickWindow.CreateTextureOption = ... # 0x2
        TextureOwnsGLTexture     : QQuickWindow.CreateTextureOption = ... # 0x4
        TextureCanUseAtlas       : QQuickWindow.CreateTextureOption = ... # 0x8
        TextureIsOpaque          : QQuickWindow.CreateTextureOption = ... # 0x10

    class RenderStage(enum.Enum):

        BeforeSynchronizingStage : QQuickWindow.RenderStage = ... # 0x0
        AfterSynchronizingStage  : QQuickWindow.RenderStage = ... # 0x1
        BeforeRenderingStage     : QQuickWindow.RenderStage = ... # 0x2
        AfterRenderingStage      : QQuickWindow.RenderStage = ... # 0x3
        AfterSwapStage           : QQuickWindow.RenderStage = ... # 0x4
        NoStage                  : QQuickWindow.RenderStage = ... # 0x5

    class SceneGraphError(enum.Enum):

        ContextNotAvailable      : QQuickWindow.SceneGraphError = ... # 0x1

    class TextRenderType(enum.Enum):

        QtTextRendering          : QQuickWindow.TextRenderType = ... # 0x0
        NativeTextRendering      : QQuickWindow.TextRenderType = ... # 0x1


    @overload
    def __init__(self, parent: Optional[PySide6.QtGui.QWindow] = ...) -> None: ...
    @overload
    def __init__(self, renderControl: PySide6.QtQuick.QQuickRenderControl) -> None: ...

    def accessibleRoot(self) -> PySide6.QtGui.QAccessibleInterface: ...
    def activeFocusItem(self) -> PySide6.QtQuick.QQuickItem: ...
    def beginExternalCommands(self) -> None: ...
    def closeEvent(self, arg__1: PySide6.QtGui.QCloseEvent) -> None: ...
    def color(self) -> PySide6.QtGui.QColor: ...
    def contentItem(self) -> PySide6.QtQuick.QQuickItem: ...
    def createRectangleNode(self) -> PySide6.QtQuick.QSGRectangleNode: ...
    @overload
    def createTextureFromImage(self, image: Union[PySide6.QtGui.QImage, str]) -> PySide6.QtQuick.QSGTexture: ...
    @overload
    def createTextureFromImage(self, image: Union[PySide6.QtGui.QImage, str], options: PySide6.QtQuick.QQuickWindow.CreateTextureOption) -> PySide6.QtQuick.QSGTexture: ...
    def effectiveDevicePixelRatio(self) -> float: ...
    def endExternalCommands(self) -> None: ...
    def event(self, arg__1: PySide6.QtCore.QEvent) -> bool: ...
    def exposeEvent(self, arg__1: PySide6.QtGui.QExposeEvent) -> None: ...
    def focusInEvent(self, arg__1: PySide6.QtGui.QFocusEvent) -> None: ...
    def focusObject(self) -> PySide6.QtCore.QObject: ...
    def focusOutEvent(self, arg__1: PySide6.QtGui.QFocusEvent) -> None: ...
    def grabWindow(self) -> PySide6.QtGui.QImage: ...
    @staticmethod
    def graphicsApi() -> PySide6.QtQuick.QSGRendererInterface.GraphicsApi: ...
    def graphicsConfiguration(self) -> PySide6.QtQuick.QQuickGraphicsConfiguration: ...
    def graphicsDevice(self) -> PySide6.QtQuick.QQuickGraphicsDevice: ...
    @staticmethod
    def hasDefaultAlphaBuffer() -> bool: ...
    def hideEvent(self, arg__1: PySide6.QtGui.QHideEvent) -> None: ...
    def incubationController(self) -> PySide6.QtQml.QQmlIncubationController: ...
    def isPersistentGraphics(self) -> bool: ...
    def isPersistentSceneGraph(self) -> bool: ...
    def isSceneGraphInitialized(self) -> bool: ...
    def keyPressEvent(self, arg__1: PySide6.QtGui.QKeyEvent) -> None: ...
    def keyReleaseEvent(self, arg__1: PySide6.QtGui.QKeyEvent) -> None: ...
    def mouseDoubleClickEvent(self, arg__1: PySide6.QtGui.QMouseEvent) -> None: ...
    def mouseGrabberItem(self) -> PySide6.QtQuick.QQuickItem: ...
    def mouseMoveEvent(self, arg__1: PySide6.QtGui.QMouseEvent) -> None: ...
    def mousePressEvent(self, arg__1: PySide6.QtGui.QMouseEvent) -> None: ...
    def mouseReleaseEvent(self, arg__1: PySide6.QtGui.QMouseEvent) -> None: ...
    def releaseResources(self) -> None: ...
    def renderTarget(self) -> PySide6.QtQuick.QQuickRenderTarget: ...
    def rendererInterface(self) -> PySide6.QtQuick.QSGRendererInterface: ...
    def resizeEvent(self, arg__1: PySide6.QtGui.QResizeEvent) -> None: ...
    @staticmethod
    def sceneGraphBackend() -> str: ...
    def scheduleRenderJob(self, job: PySide6.QtCore.QRunnable, schedule: PySide6.QtQuick.QQuickWindow.RenderStage) -> None: ...
    def setColor(self, color: Union[PySide6.QtGui.QColor, PySide6.QtGui.QRgba64, Any, PySide6.QtCore.Qt.GlobalColor, str, int]) -> None: ...
    @staticmethod
    def setDefaultAlphaBuffer(useAlpha: bool) -> None: ...
    @staticmethod
    def setGraphicsApi(api: PySide6.QtQuick.QSGRendererInterface.GraphicsApi) -> None: ...
    def setGraphicsConfiguration(self, config: PySide6.QtQuick.QQuickGraphicsConfiguration) -> None: ...
    def setGraphicsDevice(self, device: PySide6.QtQuick.QQuickGraphicsDevice) -> None: ...
    def setPersistentGraphics(self, persistent: bool) -> None: ...
    def setPersistentSceneGraph(self, persistent: bool) -> None: ...
    def setRenderTarget(self, target: PySide6.QtQuick.QQuickRenderTarget) -> None: ...
    @staticmethod
    def setSceneGraphBackend(backend: str) -> None: ...
    @staticmethod
    def setTextRenderType(renderType: PySide6.QtQuick.QQuickWindow.TextRenderType) -> None: ...
    def showEvent(self, arg__1: PySide6.QtGui.QShowEvent) -> None: ...
    def tabletEvent(self, arg__1: PySide6.QtGui.QTabletEvent) -> None: ...
    @staticmethod
    def textRenderType() -> PySide6.QtQuick.QQuickWindow.TextRenderType: ...
    def update(self) -> None: ...
    def wheelEvent(self, arg__1: PySide6.QtGui.QWheelEvent) -> None: ...


class QSGBasicGeometryNode(PySide6.QtQuick.QSGNode):

    def __init__(self, type: PySide6.QtQuick.QSGNode.NodeType) -> None: ...

    def clipList(self) -> PySide6.QtQuick.QSGClipNode: ...
    def geometry(self) -> PySide6.QtQuick.QSGGeometry: ...
    def matrix(self) -> PySide6.QtGui.QMatrix4x4: ...
    def setGeometry(self, geometry: PySide6.QtQuick.QSGGeometry) -> None: ...
    def setRendererClipList(self, c: PySide6.QtQuick.QSGClipNode) -> None: ...
    def setRendererMatrix(self, m: Union[PySide6.QtGui.QMatrix4x4, PySide6.QtGui.QTransform]) -> None: ...


class QSGClipNode(PySide6.QtQuick.QSGBasicGeometryNode):

    def __init__(self) -> None: ...

    def clipRect(self) -> PySide6.QtCore.QRectF: ...
    def isRectangular(self) -> bool: ...
    def setClipRect(self, arg__1: Union[PySide6.QtCore.QRectF, PySide6.QtCore.QRect]) -> None: ...
    def setIsRectangular(self, rectHint: bool) -> None: ...


class QSGDynamicTexture(PySide6.QtQuick.QSGTexture):

    def __init__(self) -> None: ...

    def updateTexture(self) -> bool: ...


class QSGFlatColorMaterial(PySide6.QtQuick.QSGMaterial):

    def __init__(self) -> None: ...

    def color(self) -> PySide6.QtGui.QColor: ...
    def compare(self, other: PySide6.QtQuick.QSGMaterial) -> int: ...
    def createShader(self, renderMode: PySide6.QtQuick.QSGRendererInterface.RenderMode) -> PySide6.QtQuick.QSGMaterialShader: ...
    def setColor(self, color: Union[PySide6.QtGui.QColor, PySide6.QtGui.QRgba64, Any, PySide6.QtCore.Qt.GlobalColor, str, int]) -> None: ...
    def type(self) -> PySide6.QtQuick.QSGMaterialType: ...


class QSGGeometry(Shiboken.Object):

    class Attribute(Shiboken.Object):

        @overload
        def __init__(self) -> None: ...
        @overload
        def __init__(self, Attribute: PySide6.QtQuick.QSGGeometry.Attribute) -> None: ...

        @staticmethod
        def __copy__() -> None: ...
        @staticmethod
        def create(pos: int, tupleSize: int, primitiveType: int, isPosition: bool = ...) -> PySide6.QtQuick.QSGGeometry.Attribute: ...
        @staticmethod
        def createWithAttributeType(pos: int, tupleSize: int, primitiveType: int, attributeType: PySide6.QtQuick.QSGGeometry.AttributeType) -> PySide6.QtQuick.QSGGeometry.Attribute: ...

    class AttributeSet(Shiboken.Object):

        @overload
        def __init__(self) -> None: ...
        @overload
        def __init__(self, AttributeSet: PySide6.QtQuick.QSGGeometry.AttributeSet) -> None: ...

        @staticmethod
        def __copy__() -> None: ...

    class AttributeType(enum.Enum):

        UnknownAttribute         : QSGGeometry.AttributeType = ... # 0x0
        PositionAttribute        : QSGGeometry.AttributeType = ... # 0x1
        ColorAttribute           : QSGGeometry.AttributeType = ... # 0x2
        TexCoordAttribute        : QSGGeometry.AttributeType = ... # 0x3
        TexCoord1Attribute       : QSGGeometry.AttributeType = ... # 0x4
        TexCoord2Attribute       : QSGGeometry.AttributeType = ... # 0x5

    class ColoredPoint2D(Shiboken.Object):

        @overload
        def __init__(self) -> None: ...
        @overload
        def __init__(self, ColoredPoint2D: PySide6.QtQuick.QSGGeometry.ColoredPoint2D) -> None: ...

        @staticmethod
        def __copy__() -> None: ...
        def set(self, nx: float, ny: float, nr: int, ng: int, nb: int, na: int) -> None: ...

    class DataPattern(enum.Enum):

        AlwaysUploadPattern      : QSGGeometry.DataPattern = ... # 0x0
        StreamPattern            : QSGGeometry.DataPattern = ... # 0x1
        DynamicPattern           : QSGGeometry.DataPattern = ... # 0x2
        StaticPattern            : QSGGeometry.DataPattern = ... # 0x3

    class DrawingMode(enum.IntEnum):

        DrawPoints               : QSGGeometry.DrawingMode = ... # 0x0
        DrawLines                : QSGGeometry.DrawingMode = ... # 0x1
        DrawLineLoop             : QSGGeometry.DrawingMode = ... # 0x2
        DrawLineStrip            : QSGGeometry.DrawingMode = ... # 0x3
        DrawTriangles            : QSGGeometry.DrawingMode = ... # 0x4
        DrawTriangleStrip        : QSGGeometry.DrawingMode = ... # 0x5
        DrawTriangleFan          : QSGGeometry.DrawingMode = ... # 0x6

    class Point2D(Shiboken.Object):

        @overload
        def __init__(self) -> None: ...
        @overload
        def __init__(self, Point2D: PySide6.QtQuick.QSGGeometry.Point2D) -> None: ...

        @staticmethod
        def __copy__() -> None: ...
        def set(self, nx: float, ny: float) -> None: ...

    class TexturedPoint2D(Shiboken.Object):

        @overload
        def __init__(self) -> None: ...
        @overload
        def __init__(self, TexturedPoint2D: PySide6.QtQuick.QSGGeometry.TexturedPoint2D) -> None: ...

        @staticmethod
        def __copy__() -> None: ...
        def set(self, nx: float, ny: float, ntx: float, nty: float) -> None: ...

    class Type(enum.Enum):

        ByteType                 : QSGGeometry.Type = ... # 0x1400
        UnsignedByteType         : QSGGeometry.Type = ... # 0x1401
        ShortType                : QSGGeometry.Type = ... # 0x1402
        UnsignedShortType        : QSGGeometry.Type = ... # 0x1403
        IntType                  : QSGGeometry.Type = ... # 0x1404
        UnsignedIntType          : QSGGeometry.Type = ... # 0x1405
        FloatType                : QSGGeometry.Type = ... # 0x1406
        Bytes2Type               : QSGGeometry.Type = ... # 0x1407
        Bytes3Type               : QSGGeometry.Type = ... # 0x1408
        Bytes4Type               : QSGGeometry.Type = ... # 0x1409
        DoubleType               : QSGGeometry.Type = ... # 0x140a


    def __init__(self, attribs: PySide6.QtQuick.QSGGeometry.AttributeSet, vertexCount: int, indexCount: int = ..., indexType: int = ...) -> None: ...

    def allocate(self, vertexCount: int, indexCount: int = ...) -> None: ...
    def attributeCount(self) -> int: ...
    def attributes(self) -> PySide6.QtQuick.QSGGeometry.Attribute: ...
    @staticmethod
    def defaultAttributes_ColoredPoint2D() -> PySide6.QtQuick.QSGGeometry.AttributeSet: ...
    @staticmethod
    def defaultAttributes_Point2D() -> PySide6.QtQuick.QSGGeometry.AttributeSet: ...
    @staticmethod
    def defaultAttributes_TexturedPoint2D() -> PySide6.QtQuick.QSGGeometry.AttributeSet: ...
    def drawingMode(self) -> int: ...
    def indexCount(self) -> int: ...
    def indexData(self) -> int: ...
    def indexDataAsUInt(self) -> List[int]: ...
    def indexDataAsUShort(self) -> List[int]: ...
    def indexDataPattern(self) -> PySide6.QtQuick.QSGGeometry.DataPattern: ...
    def indexType(self) -> int: ...
    def lineWidth(self) -> float: ...
    def markIndexDataDirty(self) -> None: ...
    def markVertexDataDirty(self) -> None: ...
    def setDrawingMode(self, mode: int) -> None: ...
    def setIndexDataPattern(self, p: PySide6.QtQuick.QSGGeometry.DataPattern) -> None: ...
    def setLineWidth(self, w: float) -> None: ...
    def setVertexDataAsPoint2D(self, points: Sequence[PySide6.QtQuick.QSGGeometry.Point2D]) -> None: ...
    def setVertexDataPattern(self, p: PySide6.QtQuick.QSGGeometry.DataPattern) -> None: ...
    def sizeOfIndex(self) -> int: ...
    def sizeOfVertex(self) -> int: ...
    @staticmethod
    def updateColoredRectGeometry(g: PySide6.QtQuick.QSGGeometry, rect: Union[PySide6.QtCore.QRectF, PySide6.QtCore.QRect]) -> None: ...
    @staticmethod
    def updateRectGeometry(g: PySide6.QtQuick.QSGGeometry, rect: Union[PySide6.QtCore.QRectF, PySide6.QtCore.QRect]) -> None: ...
    @staticmethod
    def updateTexturedRectGeometry(g: PySide6.QtQuick.QSGGeometry, rect: Union[PySide6.QtCore.QRectF, PySide6.QtCore.QRect], sourceRect: Union[PySide6.QtCore.QRectF, PySide6.QtCore.QRect]) -> None: ...
    def vertexCount(self) -> int: ...
    def vertexData(self) -> int: ...
    def vertexDataAsColoredPoint2D(self) -> PySide6.QtQuick.QSGGeometry.ColoredPoint2D: ...
    def vertexDataAsPoint2D(self) -> object: ...
    def vertexDataAsTexturedPoint2D(self) -> PySide6.QtQuick.QSGGeometry.TexturedPoint2D: ...
    def vertexDataPattern(self) -> PySide6.QtQuick.QSGGeometry.DataPattern: ...


class QSGGeometryNode(PySide6.QtQuick.QSGBasicGeometryNode):

    def __init__(self) -> None: ...

    def activeMaterial(self) -> PySide6.QtQuick.QSGMaterial: ...
    def inheritedOpacity(self) -> float: ...
    def material(self) -> PySide6.QtQuick.QSGMaterial: ...
    def opaqueMaterial(self) -> PySide6.QtQuick.QSGMaterial: ...
    def renderOrder(self) -> int: ...
    def setInheritedOpacity(self, opacity: float) -> None: ...
    def setMaterial(self, material: PySide6.QtQuick.QSGMaterial) -> None: ...
    def setOpaqueMaterial(self, material: PySide6.QtQuick.QSGMaterial) -> None: ...
    def setRenderOrder(self, order: int) -> None: ...


class QSGMaterial(Shiboken.Object):

    class Flag(enum.Flag):

        Blending                 : QSGMaterial.Flag = ... # 0x1
        RequiresDeterminant      : QSGMaterial.Flag = ... # 0x2
        RequiresFullMatrixExceptTranslate: QSGMaterial.Flag = ... # 0x6
        RequiresFullMatrix       : QSGMaterial.Flag = ... # 0xe
        CustomCompileStep        : QSGMaterial.Flag = ... # 0x10
        NoBatching               : QSGMaterial.Flag = ... # 0x10


    def __init__(self) -> None: ...

    def compare(self, other: PySide6.QtQuick.QSGMaterial) -> int: ...
    def createShader(self, renderMode: PySide6.QtQuick.QSGRendererInterface.RenderMode) -> PySide6.QtQuick.QSGMaterialShader: ...
    def flags(self) -> PySide6.QtQuick.QSGMaterial.Flag: ...
    def setFlag(self, flags: PySide6.QtQuick.QSGMaterial.Flag, on: bool = ...) -> None: ...
    def type(self) -> PySide6.QtQuick.QSGMaterialType: ...


class QSGMaterialShader(Shiboken.Object):

    class Flag(enum.Flag):

        UpdatesGraphicsPipelineState: QSGMaterialShader.Flag = ... # 0x1

    class RenderState(Shiboken.Object):

        class DirtyState(enum.Flag):

            DirtyMatrix              : QSGMaterialShader.RenderState.DirtyState = ... # 0x1
            DirtyOpacity             : QSGMaterialShader.RenderState.DirtyState = ... # 0x2
            DirtyCachedMaterialData  : QSGMaterialShader.RenderState.DirtyState = ... # 0x4
            DirtyAll                 : QSGMaterialShader.RenderState.DirtyState = ... # 0xffff


        @overload
        def __init__(self) -> None: ...
        @overload
        def __init__(self, RenderState: PySide6.QtQuick.QSGMaterialShader.RenderState) -> None: ...

        @staticmethod
        def __copy__() -> None: ...
        def combinedMatrix(self) -> PySide6.QtGui.QMatrix4x4: ...
        def determinant(self) -> float: ...
        def devicePixelRatio(self) -> float: ...
        def deviceRect(self) -> PySide6.QtCore.QRect: ...
        def dirtyStates(self) -> PySide6.QtQuick.QSGMaterialShader.RenderState.DirtyState: ...
        def isMatrixDirty(self) -> bool: ...
        def isOpacityDirty(self) -> bool: ...
        def modelViewMatrix(self) -> PySide6.QtGui.QMatrix4x4: ...
        def opacity(self) -> float: ...
        def projectionMatrix(self) -> PySide6.QtGui.QMatrix4x4: ...
        def uniformData(self) -> PySide6.QtCore.QByteArray: ...
        def viewportRect(self) -> PySide6.QtCore.QRect: ...

    class Stage(enum.Enum):

        VertexStage              : QSGMaterialShader.Stage = ... # 0x0
        FragmentStage            : QSGMaterialShader.Stage = ... # 0x1


    def __init__(self) -> None: ...

    def combinedImageSamplerCount(self, binding: int) -> int: ...
    def flags(self) -> PySide6.QtQuick.QSGMaterialShader.Flag: ...
    def setFlag(self, flags: PySide6.QtQuick.QSGMaterialShader.Flag, on: bool = ...) -> None: ...
    def setFlags(self, flags: PySide6.QtQuick.QSGMaterialShader.Flag) -> None: ...
    def setShaderFileName(self, stage: PySide6.QtQuick.QSGMaterialShader.Stage, filename: str) -> None: ...
    def updateUniformData(self, state: PySide6.QtQuick.QSGMaterialShader.RenderState, newMaterial: PySide6.QtQuick.QSGMaterial, oldMaterial: PySide6.QtQuick.QSGMaterial) -> bool: ...


class QSGMaterialType(Shiboken.Object):

    def __init__(self) -> None: ...


class QSGNode(Shiboken.Object):

    class DirtyStateBit(enum.Flag):

        DirtyUsePreprocess       : QSGNode.DirtyStateBit = ... # 0x2
        DirtySubtreeBlocked      : QSGNode.DirtyStateBit = ... # 0x80
        DirtyMatrix              : QSGNode.DirtyStateBit = ... # 0x100
        DirtyNodeAdded           : QSGNode.DirtyStateBit = ... # 0x400
        DirtyNodeRemoved         : QSGNode.DirtyStateBit = ... # 0x800
        DirtyGeometry            : QSGNode.DirtyStateBit = ... # 0x1000
        DirtyMaterial            : QSGNode.DirtyStateBit = ... # 0x2000
        DirtyOpacity             : QSGNode.DirtyStateBit = ... # 0x4000
        DirtyForceUpdate         : QSGNode.DirtyStateBit = ... # 0x8000
        DirtyPropagationMask     : QSGNode.DirtyStateBit = ... # 0xc500

    class Flag(enum.Flag):

        OwnedByParent            : QSGNode.Flag = ... # 0x1
        UsePreprocess            : QSGNode.Flag = ... # 0x2
        OwnsGeometry             : QSGNode.Flag = ... # 0x10000
        OwnsMaterial             : QSGNode.Flag = ... # 0x20000
        OwnsOpaqueMaterial       : QSGNode.Flag = ... # 0x40000
        IsVisitableNode          : QSGNode.Flag = ... # 0x1000000

    class NodeType(enum.Enum):

        BasicNodeType            : QSGNode.NodeType = ... # 0x0
        GeometryNodeType         : QSGNode.NodeType = ... # 0x1
        TransformNodeType        : QSGNode.NodeType = ... # 0x2
        ClipNodeType             : QSGNode.NodeType = ... # 0x3
        OpacityNodeType          : QSGNode.NodeType = ... # 0x4
        RootNodeType             : QSGNode.NodeType = ... # 0x5
        RenderNodeType           : QSGNode.NodeType = ... # 0x6


    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, type: PySide6.QtQuick.QSGNode.NodeType) -> None: ...

    def appendChildNode(self, node: PySide6.QtQuick.QSGNode) -> None: ...
    def childAtIndex(self, i: int) -> PySide6.QtQuick.QSGNode: ...
    def childCount(self) -> int: ...
    def clearDirty(self) -> None: ...
    def dirtyState(self) -> PySide6.QtQuick.QSGNode.DirtyStateBit: ...
    def firstChild(self) -> PySide6.QtQuick.QSGNode: ...
    def flags(self) -> PySide6.QtQuick.QSGNode.Flag: ...
    def insertChildNodeAfter(self, node: PySide6.QtQuick.QSGNode, after: PySide6.QtQuick.QSGNode) -> None: ...
    def insertChildNodeBefore(self, node: PySide6.QtQuick.QSGNode, before: PySide6.QtQuick.QSGNode) -> None: ...
    def isSubtreeBlocked(self) -> bool: ...
    def lastChild(self) -> PySide6.QtQuick.QSGNode: ...
    def markDirty(self, bits: PySide6.QtQuick.QSGNode.DirtyStateBit) -> None: ...
    def nextSibling(self) -> PySide6.QtQuick.QSGNode: ...
    def parent(self) -> PySide6.QtQuick.QSGNode: ...
    def prependChildNode(self, node: PySide6.QtQuick.QSGNode) -> None: ...
    def preprocess(self) -> None: ...
    def previousSibling(self) -> PySide6.QtQuick.QSGNode: ...
    def removeAllChildNodes(self) -> None: ...
    def removeChildNode(self, node: PySide6.QtQuick.QSGNode) -> None: ...
    def reparentChildNodesTo(self, newParent: PySide6.QtQuick.QSGNode) -> None: ...
    def setFlag(self, arg__1: PySide6.QtQuick.QSGNode.Flag, arg__2: bool = ...) -> None: ...
    def setFlags(self, arg__1: PySide6.QtQuick.QSGNode.Flag, arg__2: bool = ...) -> None: ...
    def type(self) -> PySide6.QtQuick.QSGNode.NodeType: ...


class QSGOpacityNode(PySide6.QtQuick.QSGNode):

    def __init__(self) -> None: ...

    def combinedOpacity(self) -> float: ...
    def isSubtreeBlocked(self) -> bool: ...
    def opacity(self) -> float: ...
    def setCombinedOpacity(self, opacity: float) -> None: ...
    def setOpacity(self, opacity: float) -> None: ...


class QSGOpaqueTextureMaterial(PySide6.QtQuick.QSGMaterial):

    def __init__(self) -> None: ...

    def anisotropyLevel(self) -> PySide6.QtQuick.QSGTexture.AnisotropyLevel: ...
    def compare(self, other: PySide6.QtQuick.QSGMaterial) -> int: ...
    def createShader(self, renderMode: PySide6.QtQuick.QSGRendererInterface.RenderMode) -> PySide6.QtQuick.QSGMaterialShader: ...
    def filtering(self) -> PySide6.QtQuick.QSGTexture.Filtering: ...
    def horizontalWrapMode(self) -> PySide6.QtQuick.QSGTexture.WrapMode: ...
    def mipmapFiltering(self) -> PySide6.QtQuick.QSGTexture.Filtering: ...
    def setAnisotropyLevel(self, level: PySide6.QtQuick.QSGTexture.AnisotropyLevel) -> None: ...
    def setFiltering(self, filteringType: PySide6.QtQuick.QSGTexture.Filtering) -> None: ...
    def setHorizontalWrapMode(self, mode: PySide6.QtQuick.QSGTexture.WrapMode) -> None: ...
    def setMipmapFiltering(self, filteringType: PySide6.QtQuick.QSGTexture.Filtering) -> None: ...
    def setTexture(self, texture: PySide6.QtQuick.QSGTexture) -> None: ...
    def setVerticalWrapMode(self, mode: PySide6.QtQuick.QSGTexture.WrapMode) -> None: ...
    def texture(self) -> PySide6.QtQuick.QSGTexture: ...
    def type(self) -> PySide6.QtQuick.QSGMaterialType: ...
    def verticalWrapMode(self) -> PySide6.QtQuick.QSGTexture.WrapMode: ...


class QSGRectangleNode(PySide6.QtQuick.QSGGeometryNode):

    def __init__(self) -> None: ...

    def color(self) -> PySide6.QtGui.QColor: ...
    def rect(self) -> PySide6.QtCore.QRectF: ...
    def setColor(self, color: Union[PySide6.QtGui.QColor, PySide6.QtGui.QRgba64, Any, PySide6.QtCore.Qt.GlobalColor, str, int]) -> None: ...
    @overload
    def setRect(self, rect: Union[PySide6.QtCore.QRectF, PySide6.QtCore.QRect]) -> None: ...
    @overload
    def setRect(self, x: float, y: float, w: float, h: float) -> None: ...


class QSGRenderNode(PySide6.QtQuick.QSGNode):

    class RenderState(Shiboken.Object):

        def __init__(self) -> None: ...

        def clipRegion(self) -> PySide6.QtGui.QRegion: ...
        def get(self, state: bytes) -> int: ...
        def projectionMatrix(self) -> PySide6.QtGui.QMatrix4x4: ...
        def scissorEnabled(self) -> bool: ...
        def scissorRect(self) -> PySide6.QtCore.QRect: ...
        def stencilEnabled(self) -> bool: ...
        def stencilValue(self) -> int: ...

    class RenderingFlag(enum.Flag):

        BoundedRectRendering     : QSGRenderNode.RenderingFlag = ... # 0x1
        DepthAwareRendering      : QSGRenderNode.RenderingFlag = ... # 0x2
        OpaqueRendering          : QSGRenderNode.RenderingFlag = ... # 0x4
        NoExternalRendering      : QSGRenderNode.RenderingFlag = ... # 0x8

    class StateFlag(enum.Flag):

        DepthState               : QSGRenderNode.StateFlag = ... # 0x1
        StencilState             : QSGRenderNode.StateFlag = ... # 0x2
        ScissorState             : QSGRenderNode.StateFlag = ... # 0x4
        ColorState               : QSGRenderNode.StateFlag = ... # 0x8
        BlendState               : QSGRenderNode.StateFlag = ... # 0x10
        CullState                : QSGRenderNode.StateFlag = ... # 0x20
        ViewportState            : QSGRenderNode.StateFlag = ... # 0x40
        RenderTargetState        : QSGRenderNode.StateFlag = ... # 0x80


    def __init__(self) -> None: ...

    def changedStates(self) -> PySide6.QtQuick.QSGRenderNode.StateFlag: ...
    def clipList(self) -> PySide6.QtQuick.QSGClipNode: ...
    def flags(self) -> PySide6.QtQuick.QSGRenderNode.RenderingFlag: ...
    def inheritedOpacity(self) -> float: ...
    def matrix(self) -> PySide6.QtGui.QMatrix4x4: ...
    def prepare(self) -> None: ...
    def projectionMatrix(self) -> PySide6.QtGui.QMatrix4x4: ...
    def rect(self) -> PySide6.QtCore.QRectF: ...
    def releaseResources(self) -> None: ...
    def render(self, state: PySide6.QtQuick.QSGRenderNode.RenderState) -> None: ...


class QSGRendererInterface(Shiboken.Object):

    class GraphicsApi(enum.Enum):

        Unknown                  : QSGRendererInterface.GraphicsApi = ... # 0x0
        Software                 : QSGRendererInterface.GraphicsApi = ... # 0x1
        OpenVG                   : QSGRendererInterface.GraphicsApi = ... # 0x2
        OpenGL                   : QSGRendererInterface.GraphicsApi = ... # 0x3
        OpenGLRhi                : QSGRendererInterface.GraphicsApi = ... # 0x3
        Direct3D11               : QSGRendererInterface.GraphicsApi = ... # 0x4
        Direct3D11Rhi            : QSGRendererInterface.GraphicsApi = ... # 0x4
        Vulkan                   : QSGRendererInterface.GraphicsApi = ... # 0x5
        VulkanRhi                : QSGRendererInterface.GraphicsApi = ... # 0x5
        Metal                    : QSGRendererInterface.GraphicsApi = ... # 0x6
        MetalRhi                 : QSGRendererInterface.GraphicsApi = ... # 0x6
        Null                     : QSGRendererInterface.GraphicsApi = ... # 0x7
        NullRhi                  : QSGRendererInterface.GraphicsApi = ... # 0x7
        Direct3D12               : QSGRendererInterface.GraphicsApi = ... # 0x8

    class RenderMode(enum.Enum):

        RenderMode2D             : QSGRendererInterface.RenderMode = ... # 0x0
        RenderMode2DNoDepthBuffer: QSGRendererInterface.RenderMode = ... # 0x1
        RenderMode3D             : QSGRendererInterface.RenderMode = ... # 0x2

    class Resource(enum.Enum):

        DeviceResource           : QSGRendererInterface.Resource = ... # 0x0
        CommandQueueResource     : QSGRendererInterface.Resource = ... # 0x1
        CommandListResource      : QSGRendererInterface.Resource = ... # 0x2
        PainterResource          : QSGRendererInterface.Resource = ... # 0x3
        RhiResource              : QSGRendererInterface.Resource = ... # 0x4
        RhiSwapchainResource     : QSGRendererInterface.Resource = ... # 0x5
        RhiRedirectCommandBuffer : QSGRendererInterface.Resource = ... # 0x6
        RhiRedirectRenderTarget  : QSGRendererInterface.Resource = ... # 0x7
        PhysicalDeviceResource   : QSGRendererInterface.Resource = ... # 0x8
        OpenGLContextResource    : QSGRendererInterface.Resource = ... # 0x9
        DeviceContextResource    : QSGRendererInterface.Resource = ... # 0xa
        CommandEncoderResource   : QSGRendererInterface.Resource = ... # 0xb
        VulkanInstanceResource   : QSGRendererInterface.Resource = ... # 0xc
        RenderPassResource       : QSGRendererInterface.Resource = ... # 0xd
        RedirectPaintDevice      : QSGRendererInterface.Resource = ... # 0xe
        GraphicsQueueFamilyIndexResource: QSGRendererInterface.Resource = ... # 0xf
        GraphicsQueueIndexResource: QSGRendererInterface.Resource = ... # 0x10

    class ShaderCompilationType(enum.Flag):

        RuntimeCompilation       : QSGRendererInterface.ShaderCompilationType = ... # 0x1
        OfflineCompilation       : QSGRendererInterface.ShaderCompilationType = ... # 0x2

    class ShaderSourceType(enum.Flag):

        ShaderSourceString       : QSGRendererInterface.ShaderSourceType = ... # 0x1
        ShaderSourceFile         : QSGRendererInterface.ShaderSourceType = ... # 0x2
        ShaderByteCode           : QSGRendererInterface.ShaderSourceType = ... # 0x4

    class ShaderType(enum.Enum):

        UnknownShadingLanguage   : QSGRendererInterface.ShaderType = ... # 0x0
        GLSL                     : QSGRendererInterface.ShaderType = ... # 0x1
        HLSL                     : QSGRendererInterface.ShaderType = ... # 0x2
        RhiShader                : QSGRendererInterface.ShaderType = ... # 0x3


    def __init__(self) -> None: ...

    @overload
    def getResource(self, window: PySide6.QtQuick.QQuickWindow, resource: PySide6.QtQuick.QSGRendererInterface.Resource) -> int: ...
    @overload
    def getResource(self, window: PySide6.QtQuick.QQuickWindow, resource: bytes) -> int: ...
    def graphicsApi(self) -> PySide6.QtQuick.QSGRendererInterface.GraphicsApi: ...
    @staticmethod
    def isApiRhiBased(api: PySide6.QtQuick.QSGRendererInterface.GraphicsApi) -> bool: ...
    def shaderCompilationType(self) -> PySide6.QtQuick.QSGRendererInterface.ShaderCompilationType: ...
    def shaderSourceType(self) -> PySide6.QtQuick.QSGRendererInterface.ShaderSourceType: ...
    def shaderType(self) -> PySide6.QtQuick.QSGRendererInterface.ShaderType: ...


class QSGSimpleRectNode(PySide6.QtQuick.QSGGeometryNode):

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, rect: Union[PySide6.QtCore.QRectF, PySide6.QtCore.QRect], color: Union[PySide6.QtGui.QColor, PySide6.QtGui.QRgba64, Any, PySide6.QtCore.Qt.GlobalColor, str, int]) -> None: ...

    def color(self) -> PySide6.QtGui.QColor: ...
    def rect(self) -> PySide6.QtCore.QRectF: ...
    def setColor(self, color: Union[PySide6.QtGui.QColor, PySide6.QtGui.QRgba64, Any, PySide6.QtCore.Qt.GlobalColor, str, int]) -> None: ...
    @overload
    def setRect(self, rect: Union[PySide6.QtCore.QRectF, PySide6.QtCore.QRect]) -> None: ...
    @overload
    def setRect(self, x: float, y: float, w: float, h: float) -> None: ...


class QSGSimpleTextureNode(PySide6.QtQuick.QSGGeometryNode):

    class TextureCoordinatesTransformFlag(enum.Flag):

        NoTransform              : QSGSimpleTextureNode.TextureCoordinatesTransformFlag = ... # 0x0
        MirrorHorizontally       : QSGSimpleTextureNode.TextureCoordinatesTransformFlag = ... # 0x1
        MirrorVertically         : QSGSimpleTextureNode.TextureCoordinatesTransformFlag = ... # 0x2


    def __init__(self) -> None: ...

    def filtering(self) -> PySide6.QtQuick.QSGTexture.Filtering: ...
    def ownsTexture(self) -> bool: ...
    def rect(self) -> PySide6.QtCore.QRectF: ...
    def setFiltering(self, filtering: PySide6.QtQuick.QSGTexture.Filtering) -> None: ...
    def setOwnsTexture(self, owns: bool) -> None: ...
    @overload
    def setRect(self, rect: Union[PySide6.QtCore.QRectF, PySide6.QtCore.QRect]) -> None: ...
    @overload
    def setRect(self, x: float, y: float, w: float, h: float) -> None: ...
    @overload
    def setSourceRect(self, r: Union[PySide6.QtCore.QRectF, PySide6.QtCore.QRect]) -> None: ...
    @overload
    def setSourceRect(self, x: float, y: float, w: float, h: float) -> None: ...
    def setTexture(self, texture: PySide6.QtQuick.QSGTexture) -> None: ...
    def setTextureCoordinatesTransform(self, mode: PySide6.QtQuick.QSGSimpleTextureNode.TextureCoordinatesTransformFlag) -> None: ...
    def sourceRect(self) -> PySide6.QtCore.QRectF: ...
    def texture(self) -> PySide6.QtQuick.QSGTexture: ...
    def textureCoordinatesTransform(self) -> PySide6.QtQuick.QSGSimpleTextureNode.TextureCoordinatesTransformFlag: ...


class QSGTexture(PySide6.QtCore.QObject):

    class AnisotropyLevel(enum.Enum):

        AnisotropyNone           : QSGTexture.AnisotropyLevel = ... # 0x0
        Anisotropy2x             : QSGTexture.AnisotropyLevel = ... # 0x1
        Anisotropy4x             : QSGTexture.AnisotropyLevel = ... # 0x2
        Anisotropy8x             : QSGTexture.AnisotropyLevel = ... # 0x3
        Anisotropy16x            : QSGTexture.AnisotropyLevel = ... # 0x4

    class Filtering(enum.Enum):

        None_                    : QSGTexture.Filtering = ... # 0x0
        Nearest                  : QSGTexture.Filtering = ... # 0x1
        Linear                   : QSGTexture.Filtering = ... # 0x2

    class WrapMode(enum.Enum):

        Repeat                   : QSGTexture.WrapMode = ... # 0x0
        ClampToEdge              : QSGTexture.WrapMode = ... # 0x1
        MirroredRepeat           : QSGTexture.WrapMode = ... # 0x2


    def __init__(self) -> None: ...

    def anisotropyLevel(self) -> PySide6.QtQuick.QSGTexture.AnisotropyLevel: ...
    def comparisonKey(self) -> int: ...
    def convertToNormalizedSourceRect(self, rect: Union[PySide6.QtCore.QRectF, PySide6.QtCore.QRect]) -> PySide6.QtCore.QRectF: ...
    def filtering(self) -> PySide6.QtQuick.QSGTexture.Filtering: ...
    def hasAlphaChannel(self) -> bool: ...
    def hasMipmaps(self) -> bool: ...
    def horizontalWrapMode(self) -> PySide6.QtQuick.QSGTexture.WrapMode: ...
    def isAtlasTexture(self) -> bool: ...
    def mipmapFiltering(self) -> PySide6.QtQuick.QSGTexture.Filtering: ...
    def normalizedTextureSubRect(self) -> PySide6.QtCore.QRectF: ...
    def resolveInterface(self, name: bytes, revision: int) -> int: ...
    def setAnisotropyLevel(self, level: PySide6.QtQuick.QSGTexture.AnisotropyLevel) -> None: ...
    def setFiltering(self, filter: PySide6.QtQuick.QSGTexture.Filtering) -> None: ...
    def setHorizontalWrapMode(self, hwrap: PySide6.QtQuick.QSGTexture.WrapMode) -> None: ...
    def setMipmapFiltering(self, filter: PySide6.QtQuick.QSGTexture.Filtering) -> None: ...
    def setVerticalWrapMode(self, vwrap: PySide6.QtQuick.QSGTexture.WrapMode) -> None: ...
    def textureSize(self) -> PySide6.QtCore.QSize: ...
    def verticalWrapMode(self) -> PySide6.QtQuick.QSGTexture.WrapMode: ...


class QSGTextureMaterial(PySide6.QtQuick.QSGOpaqueTextureMaterial):

    def __init__(self) -> None: ...

    def createShader(self, renderMode: PySide6.QtQuick.QSGRendererInterface.RenderMode) -> PySide6.QtQuick.QSGMaterialShader: ...
    def type(self) -> PySide6.QtQuick.QSGMaterialType: ...


class QSGTextureProvider(PySide6.QtCore.QObject):

    textureChanged           : ClassVar[Signal] = ... # textureChanged()

    def __init__(self) -> None: ...

    def texture(self) -> PySide6.QtQuick.QSGTexture: ...


class QSGTransformNode(PySide6.QtQuick.QSGNode):

    def __init__(self) -> None: ...

    def combinedMatrix(self) -> PySide6.QtGui.QMatrix4x4: ...
    def matrix(self) -> PySide6.QtGui.QMatrix4x4: ...
    def setCombinedMatrix(self, matrix: Union[PySide6.QtGui.QMatrix4x4, PySide6.QtGui.QTransform]) -> None: ...
    def setMatrix(self, matrix: Union[PySide6.QtGui.QMatrix4x4, PySide6.QtGui.QTransform]) -> None: ...


class QSGVertexColorMaterial(PySide6.QtQuick.QSGMaterial):

    def __init__(self) -> None: ...

    def compare(self, other: PySide6.QtQuick.QSGMaterial) -> int: ...
    def createShader(self, renderMode: PySide6.QtQuick.QSGRendererInterface.RenderMode) -> PySide6.QtQuick.QSGMaterialShader: ...
    def type(self) -> PySide6.QtQuick.QSGMaterialType: ...


class QSharedPointer_QQuickItemGrabResult(Shiboken.Object):

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, pointee: PySide6.QtQuick.QQuickItemGrabResult) -> None: ...

    @staticmethod
    def __copy__() -> None: ...
    @staticmethod
    def __dir__() -> None: ...
    def data(self) -> PySide6.QtQuick.QQuickItemGrabResult: ...
    @overload
    def reset(self) -> None: ...
    @overload
    def reset(self, t: PySide6.QtQuick.QQuickItemGrabResult) -> None: ...


# eof
