
#ifndef KOMPAREDIFF2_EXPORT_H
#define KOMPAREDIFF2_EXPORT_H

#ifdef KOMPAREDIFF2_STATIC_DEFINE
#  define KOMPAREDIFF2_EXPORT
#  define KOMPAREDIFF2_NO_EXPORT
#else
#  ifndef KOMPAREDIFF2_EXPORT
#    ifdef komparediff2_EXPORTS
        /* We are building this library */
#      define KOMPAREDIFF2_EXPORT __attribute__((visibility("default")))
#    else
        /* We are using this library */
#      define KOMPAREDIFF2_EXPORT __attribute__((visibility("default")))
#    endif
#  endif

#  ifndef KOMPAREDIFF2_NO_EXPORT
#    define KOMPAREDIFF2_NO_EXPORT __attribute__((visibility("hidden")))
#  endif
#endif

#ifndef KOMPAREDIFF2_DECL_DEPRECATED
#  define KOMPAREDIFF2_DECL_DEPRECATED __attribute__ ((__deprecated__))
#endif

#ifndef KOMPAREDIFF2_DECL_DEPRECATED_EXPORT
#  define KOMPAREDIFF2_DECL_DEPRECATED_EXPORT KOMPAREDIFF2_EXPORT KOMPAREDIFF2_DECL_DEPRECATED
#endif

#ifndef KOMPAREDIFF2_DECL_DEPRECATED_NO_EXPORT
#  define KOMPAREDIFF2_DECL_DEPRECATED_NO_EXPORT KOMPAREDIFF2_NO_EXPORT KOMPAREDIFF2_DECL_DEPRECATED
#endif

#if 0 /* DEFINE_NO_DEPRECATED */
#  ifndef KOMPAREDIFF2_NO_DEPRECATED
#    define KOMPAREDIFF2_NO_DEPRECATED
#  endif
#endif
#include <komparediff2_version.h>

#define KOMPAREDIFF2_DECL_DEPRECATED_TEXT(text) __attribute__ ((__deprecated__(text)))

#if defined(KOMPAREDIFF2_NO_DEPRECATED)
#  undef KOMPAREDIFF2_DEPRECATED
#  define KOMPAREDIFF2_DEPRECATED_EXPORT KOMPAREDIFF2_EXPORT
#  define KOMPAREDIFF2_DEPRECATED_NO_EXPORT KOMPAREDIFF2_NO_EXPORT
#elif defined(KOMPAREDIFF2_NO_DEPRECATED_WARNINGS)
#  define KOMPAREDIFF2_DEPRECATED
#  define KOMPAREDIFF2_DEPRECATED_EXPORT KOMPAREDIFF2_EXPORT
#  define KOMPAREDIFF2_DEPRECATED_NO_EXPORT KOMPAREDIFF2_NO_EXPORT
#else
#  define KOMPAREDIFF2_DEPRECATED KOMPAREDIFF2_DECL_DEPRECATED
#  define KOMPAREDIFF2_DEPRECATED_EXPORT KOMPAREDIFF2_DECL_DEPRECATED_EXPORT
#  define KOMPAREDIFF2_DEPRECATED_NO_EXPORT KOMPAREDIFF2_DECL_DEPRECATED_NO_EXPORT
#endif

/* Build was done with the API removed deprecated before: 5.4.0 */
#define KOMPAREDIFF2_EXCLUDE_DEPRECATED_BEFORE_AND_AT 0x50400

#ifdef KOMPAREDIFF2_DISABLE_DEPRECATED_BEFORE_AND_AT
#  if KOMPAREDIFF2_DISABLE_DEPRECATED_BEFORE_AND_AT < KOMPAREDIFF2_EXCLUDE_DEPRECATED_BEFORE_AND_AT
#    undef KOMPAREDIFF2_DISABLE_DEPRECATED_BEFORE_AND_AT
#    define KOMPAREDIFF2_DISABLE_DEPRECATED_BEFORE_AND_AT KOMPAREDIFF2_EXCLUDE_DEPRECATED_BEFORE_AND_AT
#  endif
#endif

#define KOMPAREDIFF2_BUILD_DEPRECATED_SINCE(major, minor) (((major<<16)|(minor<<8)) > KOMPAREDIFF2_EXCLUDE_DEPRECATED_BEFORE_AND_AT)

#ifdef KOMPAREDIFF2_NO_DEPRECATED
#  define KOMPAREDIFF2_DISABLE_DEPRECATED_BEFORE_AND_AT KOMPAREDIFF2_VERSION
#endif
#ifdef KOMPAREDIFF2_NO_DEPRECATED_WARNINGS
#  define KOMPAREDIFF2_DEPRECATED_WARNINGS_SINCE 0
#endif

#ifndef KOMPAREDIFF2_DEPRECATED_WARNINGS_SINCE
#  ifdef KOMPAREDIFF2_DISABLE_DEPRECATED_BEFORE_AND_AT
#    define KOMPAREDIFF2_DEPRECATED_WARNINGS_SINCE KOMPAREDIFF2_DISABLE_DEPRECATED_BEFORE_AND_AT
#  else
#    define KOMPAREDIFF2_DEPRECATED_WARNINGS_SINCE KOMPAREDIFF2_VERSION
#  endif
#endif

#ifndef KOMPAREDIFF2_DISABLE_DEPRECATED_BEFORE_AND_AT
#  define KOMPAREDIFF2_DISABLE_DEPRECATED_BEFORE_AND_AT 0x50400
#endif

#ifdef KOMPAREDIFF2_DEPRECATED
#  define KOMPAREDIFF2_ENABLE_DEPRECATED_SINCE(major, minor) (((major<<16)|(minor<<8)) > KOMPAREDIFF2_DISABLE_DEPRECATED_BEFORE_AND_AT)
#else
#  define KOMPAREDIFF2_ENABLE_DEPRECATED_SINCE(major, minor) 0
#endif

#if KOMPAREDIFF2_DEPRECATED_WARNINGS_SINCE >= 0x50400
#  define KOMPAREDIFF2_DEPRECATED_VERSION_5_4(text) KOMPAREDIFF2_DECL_DEPRECATED_TEXT(text)
#else
#  define KOMPAREDIFF2_DEPRECATED_VERSION_5_4(text)
#endif
#define KOMPAREDIFF2_DEPRECATED_VERSION_5(minor, text)      KOMPAREDIFF2_DEPRECATED_VERSION_5_##minor(text)
#define KOMPAREDIFF2_DEPRECATED_VERSION(major, minor, text) KOMPAREDIFF2_DEPRECATED_VERSION_##major(minor, "Since "#major"."#minor". " text)
#define KOMPAREDIFF2_DEPRECATED_VERSION_BELATED(major, minor, textmajor, textminor, text) KOMPAREDIFF2_DEPRECATED_VERSION_##major(minor, "Since "#textmajor"."#textminor". " text)
#if defined(__cpp_enumerator_attributes) && __cpp_enumerator_attributes >= 201411
#  define KOMPAREDIFF2_ENUMERATOR_DEPRECATED_VERSION(major, minor, text) KOMPAREDIFF2_DEPRECATED_VERSION(major, minor, text)
#  define KOMPAREDIFF2_ENUMERATOR_DEPRECATED_VERSION_BELATED(major, minor, textmajor, textminor, text) KOMPAREDIFF2_DEPRECATED_VERSION_BELATED(major, minor, textmajor, textminor, text)
#else
#  define KOMPAREDIFF2_ENUMERATOR_DEPRECATED_VERSION(major, minor, text)
#  define KOMPAREDIFF2_ENUMERATOR_DEPRECATED_VERSION_BELATED(major, minor, textmajor, textminor, text)
#endif

#endif /* KOMPAREDIFF2_EXPORT_H */
