/** @license


 SoundManager 2: JavaScript Sound for the Web
 ----------------------------------------------
 http://schillmania.com/projects/soundmanager2/

 Copyright (c) 2007, Scott Schiller. All rights reserved.
 Code provided under the BSD License:
 http://schillmania.com/projects/soundmanager2/license.txt

 V2.97a.20130324 ("Mahalo" Edition)
*/
(function(m,g){function ba(ba,qa){function ca(a){return c.preferFlash&&A&&!c.ignoreFlash&&c.flash[a]!==g&&c.flash[a]}function s(a){return function(d){var e=this._s;!e||!e._a?(e&&e.id?c._wD(e.id+": Ignoring "+d.type):c._wD(ob+"Ignoring "+d.type),d=null):d=a.call(this,d);return d}}this.setupOptions={url:ba||null,flashVersion:8,debugMode:!0,debugFlash:!1,useConsole:!0,consoleOnly:!0,waitForWindowLoad:!1,bgColor:"#ffffff",useHighPerformance:!1,flashPollingInterval:null,html5PollingInterval:null,flashLoadTimeout:1E3,
wmode:null,allowScriptAccess:"always",useFlashBlock:!1,useHTML5Audio:!0,html5Test:/^(probably|maybe)$/i,preferFlash:!0,noSWFCache:!1};this.defaultOptions={autoLoad:!1,autoPlay:!1,from:null,loops:1,onid3:null,onload:null,whileloading:null,onplay:null,onpause:null,onresume:null,whileplaying:null,onposition:null,onstop:null,onfailure:null,onfinish:null,multiShot:!0,multiShotEvents:!1,position:null,pan:0,stream:!0,to:null,type:null,usePolicyFile:!1,volume:100};this.flash9Options={isMovieStar:null,usePeakData:!1,
useWaveformData:!1,useEQData:!1,onbufferchange:null,ondataerror:null};this.movieStarOptions={bufferTime:3,serverURL:null,onconnect:null,duration:null};this.audioFormats={mp3:{type:['audio/mpeg; codecs\x3d"mp3"',"audio/mpeg","audio/mp3","audio/MPA","audio/mpa-robust"],required:!0},mp4:{related:["aac","m4a","m4b"],type:['audio/mp4; codecs\x3d"mp4a.40.2"',"audio/aac","audio/x-m4a","audio/MP4A-LATM","audio/mpeg4-generic"],required:!1},ogg:{type:["audio/ogg; codecs\x3dvorbis"],required:!1},opus:{type:["audio/ogg; codecs\x3dopus",
"audio/opus"],required:!1},wav:{type:['audio/wav; codecs\x3d"1"',"audio/wav","audio/wave","audio/x-wav"],required:!1}};this.movieID="sm2-container";this.id=qa||"sm2movie";this.debugID="soundmanager-debug";this.debugURLParam=/([#?&])debug=1/i;this.versionNumber="V2.97a.20130324";this.altURL=this.movieURL=this.version=null;this.enabled=this.swfLoaded=!1;this.oMC=null;this.sounds={};this.soundIDs=[];this.didFlashBlock=this.muted=!1;this.filePattern=null;this.filePatterns={flash8:/\.mp3(\?.*)?$/i,flash9:/\.mp3(\?.*)?$/i};
this.features={buffering:!1,peakData:!1,waveformData:!1,eqData:!1,movieStar:!1};this.sandbox={type:null,types:{remote:"remote (domain-based) rules",localWithFile:"local with file access (no internet access)",localWithNetwork:"local with network (internet access only, no local access)",localTrusted:"local, trusted (local+internet access)"},description:null,noRemote:null,noLocal:null};this.html5={usingFlash:null};this.flash={};this.ignoreFlash=this.html5Only=!1;var Qa,c=this,Ra=null,l=null,ob="HTML5::",
B,u=navigator.userAgent,S=m.location.href.toString(),h=document,ra,Sa,sa,p,D=[],ta=!0,y,T=!1,U=!1,q=!1,t=!1,da=!1,n,pb=0,V,x,ua,L,va,J,M,N,Ta,wa,ea,G,fa,xa,O,ya,W,ga,ha,P,Ua,za,Va=["log","info","warn","error"],Wa,Aa,Xa,X=null,Ba=null,r,Ca,Q,Ya,ia,ja,R,v,Y=!1,Da=!1,Za,$a,ab,ka=0,Z=null,la,K=[],C=null,bb,ma,$,H,Ea,Fa,cb,w,db=Array.prototype.slice,E=!1,Ga,A,Ha,eb,F,fb,Ia,na,oa=u.match(/(ipad|iphone|ipod)/i),gb=u.match(/android/i),I=u.match(/msie/i),qb=u.match(/webkit/i),Ja=u.match(/safari/i)&&!u.match(/chrome/i),
Ka=u.match(/opera/i),La=u.match(/(mobile|pre\/|xoom)/i)||oa||gb,Ma=!S.match(/usehtml5audio/i)&&!S.match(/sm2\-ignorebadua/i)&&Ja&&!u.match(/silk/i)&&u.match(/OS X 10_6_([3-7])/i),hb=m.console!==g&&console.log!==g,Na=h.hasFocus!==g?h.hasFocus():null,pa=Ja&&(h.hasFocus===g||!h.hasFocus()),ib=!pa,jb=/(mp3|mp4|mpa|m4a|m4b)/i,aa=h.location?h.location.protocol.match(/http/i):null,kb=!aa?"http://":"",lb=/^\s*audio\/(?:x-)?(?:mpeg4|aac|flv|mov|mp4||m4v|m4a|m4b|mp4v|3gp|3g2)\s*(?:$|;)/i,mb="mpeg4 aac flv mov mp4 m4v f4v m4a m4b mp4v 3gp 3g2".split(" "),
rb=RegExp("\\.("+mb.join("|")+")(\\?.*)?$","i");this.mimePattern=/^\s*audio\/(?:x-)?(?:mp(?:eg|3))\s*(?:$|;)/i;this.useAltURL=!aa;var Oa;try{Oa=Audio!==g&&(Ka&&opera!==g&&10>opera.version()?new Audio(null):new Audio).canPlayType!==g}catch(sb){Oa=!1}this.hasHTML5=Oa;this.setup=function(a){var d=!c.url;a!==g&&(q&&C&&c.ok()&&(a.flashVersion!==g||a.url!==g||a.html5Test!==g))&&R(r("setupLate"));ua(a);d&&(W&&a.url!==g)&&c.beginDelayedInit();!W&&(a.url!==g&&"complete"===h.readyState)&&setTimeout(O,1);return c};
this.supported=this.ok=function(){return C?q&&!t:c.useHTML5Audio&&c.hasHTML5};this.getMovie=function(c){return B(c)||h[c]||m[c]};this.createSound=function(a,d){function e(){f=ia(f);c.sounds[f.id]=new Qa(f);c.soundIDs.push(f.id);return c.sounds[f.id]}var b,f;b=null;b="soundManager.createSound(): "+r(!q?"notReady":"notOK");if(!q||!c.ok())return R(b),!1;d!==g&&(a={id:a,url:d});f=x(a);f.url=la(f.url);f.id.toString().charAt(0).match(/^[0-9]$/)&&c._wD("soundManager.createSound(): "+r("badID",f.id),2);c._wD("soundManager.createSound(): "+
f.id+" ("+f.url+")",1);if(v(f.id,!0))return c._wD("soundManager.createSound(): "+f.id+" exists",1),c.sounds[f.id];ma(f)?(b=e(),c._wD(f.id+": Using HTML5"),b._setup_html5(f)):(8<p&&(null===f.isMovieStar&&(f.isMovieStar=!(!f.serverURL&&!(f.type&&f.type.match(lb)||f.url.match(rb)))),f.isMovieStar&&(c._wD("soundManager.createSound(): using MovieStar handling"),1<f.loops&&n("noNSLoop"))),f=ja(f,"soundManager.createSound(): "),b=e(),8===p?l._createSound(f.id,f.loops||1,f.usePolicyFile):(l._createSound(f.id,
f.url,f.usePeakData,f.useWaveformData,f.useEQData,f.isMovieStar,f.isMovieStar?f.bufferTime:!1,f.loops||1,f.serverURL,f.duration||null,f.autoPlay,!0,f.autoLoad,f.usePolicyFile),f.serverURL||(b.connected=!0,f.onconnect&&f.onconnect.apply(b))),!f.serverURL&&(f.autoLoad||f.autoPlay)&&b.load(f));!f.serverURL&&f.autoPlay&&b.play();return b};this.destroySound=function(a,d){if(!v(a))return!1;var e=c.sounds[a],b;e._iO={};e.stop();e.unload();for(b=0;b<c.soundIDs.length;b++)if(c.soundIDs[b]===a){c.soundIDs.splice(b,
1);break}d||e.destruct(!0);delete c.sounds[a];return!0};this.load=function(a,d){return!v(a)?!1:c.sounds[a].load(d)};this.unload=function(a){return!v(a)?!1:c.sounds[a].unload()};this.onposition=this.onPosition=function(a,d,e,b){return!v(a)?!1:c.sounds[a].onposition(d,e,b)};this.clearOnPosition=function(a,d,e){return!v(a)?!1:c.sounds[a].clearOnPosition(d,e)};this.start=this.play=function(a,d){var e=!1;return!q||!c.ok()?(R("soundManager.play(): "+r(!q?"notReady":"notOK")),e):!v(a)?(d instanceof Object||
(d={url:d}),d&&d.url&&(c._wD('soundManager.play(): attempting to create "'+a+'"',1),d.id=a,e=c.createSound(d).play()),e):c.sounds[a].play(d)};this.setPosition=function(a,d){return!v(a)?!1:c.sounds[a].setPosition(d)};this.stop=function(a){if(!v(a))return!1;c._wD("soundManager.stop("+a+")",1);return c.sounds[a].stop()};this.stopAll=function(){var a;c._wD("soundManager.stopAll()",1);for(a in c.sounds)c.sounds.hasOwnProperty(a)&&c.sounds[a].stop()};this.pause=function(a){return!v(a)?!1:c.sounds[a].pause()};
this.pauseAll=function(){var a;for(a=c.soundIDs.length-1;0<=a;a--)c.sounds[c.soundIDs[a]].pause()};this.resume=function(a){return!v(a)?!1:c.sounds[a].resume()};this.resumeAll=function(){var a;for(a=c.soundIDs.length-1;0<=a;a--)c.sounds[c.soundIDs[a]].resume()};this.togglePause=function(a){return!v(a)?!1:c.sounds[a].togglePause()};this.setPan=function(a,d){return!v(a)?!1:c.sounds[a].setPan(d)};this.setVolume=function(a,d){return!v(a)?!1:c.sounds[a].setVolume(d)};this.mute=function(a){var d=0;a instanceof
String&&(a=null);if(a){if(!v(a))return!1;c._wD('soundManager.mute(): Muting "'+a+'"');return c.sounds[a].mute()}c._wD("soundManager.mute(): Muting all sounds");for(d=c.soundIDs.length-1;0<=d;d--)c.sounds[c.soundIDs[d]].mute();return c.muted=!0};this.muteAll=function(){c.mute()};this.unmute=function(a){a instanceof String&&(a=null);if(a){if(!v(a))return!1;c._wD('soundManager.unmute(): Unmuting "'+a+'"');return c.sounds[a].unmute()}c._wD("soundManager.unmute(): Unmuting all sounds");for(a=c.soundIDs.length-
1;0<=a;a--)c.sounds[c.soundIDs[a]].unmute();c.muted=!1;return!0};this.unmuteAll=function(){c.unmute()};this.toggleMute=function(a){return!v(a)?!1:c.sounds[a].toggleMute()};this.getMemoryUse=function(){var c=0;l&&8!==p&&(c=parseInt(l._getMemoryUse(),10));return c};this.disable=function(a){var d;a===g&&(a=!1);if(t)return!1;t=!0;n("shutdown",1);for(d=c.soundIDs.length-1;0<=d;d--)Wa(c.sounds[c.soundIDs[d]]);V(a);w.remove(m,"load",M);return!0};this.canPlayMIME=function(a){var d;c.hasHTML5&&(d=$({type:a}));
!d&&C&&(d=a&&c.ok()?!!(8<p&&a.match(lb)||a.match(c.mimePattern)):null);return d};this.canPlayURL=function(a){var d;c.hasHTML5&&(d=$({url:a}));!d&&C&&(d=a&&c.ok()?!!a.match(c.filePattern):null);return d};this.canPlayLink=function(a){return a.type!==g&&a.type&&c.canPlayMIME(a.type)?!0:c.canPlayURL(a.href)};this.getSoundById=function(a,d){if(!a)throw Error("soundManager.getSoundById(): sID is null/_undefined");var e=c.sounds[a];!e&&!d&&c._wD('"'+a+'" is an invalid sound ID.',2);return e};this.onready=
function(a,d){if("function"===typeof a)q&&c._wD(r("queue","onready")),d||(d=m),va("onready",a,d),J();else throw r("needFunction","onready");return!0};this.ontimeout=function(a,d){if("function"===typeof a)q&&c._wD(r("queue","ontimeout")),d||(d=m),va("ontimeout",a,d),J({type:"ontimeout"});else throw r("needFunction","ontimeout");return!0};this._writeDebug=function(a,d){var e,b;if(!c.debugMode)return!1;if(hb&&c.useConsole){if(d&&"object"===typeof d)console.log(a,d);else if(Va[d]!==g)console[Va[d]](a);
else console.log(a);if(c.consoleOnly)return!0}e=B("soundmanager-debug");if(!e)return!1;b=h.createElement("div");0===++pb%2&&(b.className="sm2-alt");d=d===g?0:parseInt(d,10);b.appendChild(h.createTextNode(a));d&&(2<=d&&(b.style.fontWeight="bold"),3===d&&(b.style.color="#ff3333"));e.insertBefore(b,e.firstChild);return!0};-1!==S.indexOf("sm2-debug\x3dalert")&&(this._writeDebug=function(c){m.alert(c)});this._wD=this._writeDebug;this._debug=function(){var a,d;n("currentObj",1);a=0;for(d=c.soundIDs.length;a<
d;a++)c.sounds[c.soundIDs[a]]._debug()};this.reboot=function(a,d){c.soundIDs.length&&c._wD("Destroying "+c.soundIDs.length+" SMSound objects...");var e,b,f;for(e=c.soundIDs.length-1;0<=e;e--)c.sounds[c.soundIDs[e]].destruct();if(l)try{I&&(Ba=l.innerHTML),X=l.parentNode.removeChild(l),n("flRemoved")}catch(g){n("badRemove",2)}Ba=X=C=l=null;c.enabled=W=q=Y=Da=T=U=t=E=c.swfLoaded=!1;c.soundIDs=[];c.sounds={};if(a)D=[];else for(e in D)if(D.hasOwnProperty(e)){b=0;for(f=D[e].length;b<f;b++)D[e][b].fired=
!1}d||c._wD("soundManager: Rebooting...");c.html5={usingFlash:null};c.flash={};c.html5Only=!1;c.ignoreFlash=!1;m.setTimeout(function(){xa();d||c.beginDelayedInit()},20);return c};this.reset=function(){n("reset");return c.reboot(!0,!0)};this.getMoviePercent=function(){return l&&"PercentLoaded"in l?l.PercentLoaded():null};this.beginDelayedInit=function(){da=!0;O();setTimeout(function(){if(Da)return!1;ha();fa();return Da=!0},20);N()};this.destruct=function(){c._wD("soundManager.destruct()");c.disable(!0)};
Qa=function(a){var d,e,b=this,f,m,nb,k,h,q,s=!1,z=[],u=0,Pa,w,t=null;e=d=null;this.sID=this.id=a.id;this.url=a.url;this._iO=this.instanceOptions=this.options=x(a);this.pan=this.options.pan;this.volume=this.options.volume;this.isHTML5=!1;this._a=null;this.id3={};this._debug=function(){c._wD(b.id+": Merged options:",b.options)};this.load=function(a){var d=null,e;a!==g?b._iO=x(a,b.options):(a=b.options,b._iO=a,t&&t!==b.url&&(n("manURL"),b._iO.url=b.url,b.url=null));b._iO.url||(b._iO.url=b.url);b._iO.url=
la(b._iO.url);e=b.instanceOptions=b._iO;c._wD(b.id+": load ("+e.url+")");if(e.url===b.url&&0!==b.readyState&&2!==b.readyState)return n("onURL",1),3===b.readyState&&e.onload&&na(b,function(){e.onload.apply(b,[!!b.duration])}),b;b.loaded=!1;b.readyState=1;b.playState=0;b.id3={};if(ma(e))d=b._setup_html5(e),d._called_load?c._wD(b.id+": Ignoring request to load again"):(b._html5_canplay=!1,b.url!==e.url&&(c._wD(n("manURL")+": "+e.url),b._a.src=e.url,b.setPosition(0)),b._a.autobuffer="auto",b._a.preload=
"auto",b._a._called_load=!0,e.autoPlay&&b.play());else try{b.isHTML5=!1,b._iO=ja(ia(e)),e=b._iO,8===p?l._load(b.id,e.url,e.stream,e.autoPlay,e.usePolicyFile):l._load(b.id,e.url,!!e.stream,!!e.autoPlay,e.loops||1,!!e.autoLoad,e.usePolicyFile)}catch(f){n("smError",2),y("onload",!1),P({type:"SMSOUND_LOAD_JS_EXCEPTION",fatal:!0})}b.url=e.url;return b};this.unload=function(){0!==b.readyState&&(c._wD(b.id+": unload()"),b.isHTML5?(k(),b._a&&(b._a.pause(),Ea(b._a,"about:blank"),t="about:blank")):8===p?l._unload(b.id,
"about:blank"):l._unload(b.id),f());return b};this.destruct=function(a){c._wD(b.id+": Destruct");b.isHTML5?(k(),b._a&&(b._a.pause(),Ea(b._a),E||nb(),b._a._s=null,b._a=null)):(b._iO.onfailure=null,l._destroySound(b.id));a||c.destroySound(b.id,!0)};this.start=this.play=function(a,d){var e,f,k=!0,k=null;e=b.id+": play(): ";d=d===g?!0:d;a||(a={});b.url&&(b._iO.url=b.url);b._iO=x(b._iO,b.options);b._iO=x(a,b._iO);b._iO.url=la(b._iO.url);b.instanceOptions=b._iO;if(b._iO.serverURL&&!b.connected)return b.getAutoPlay()||
(c._wD(e+" Netstream not connected yet - setting autoPlay"),b.setAutoPlay(!0)),b;ma(b._iO)&&(b._setup_html5(b._iO),h());1===b.playState&&!b.paused&&((f=b._iO.multiShot)?c._wD(e+"Already playing (multi-shot)",1):(c._wD(e+"Already playing (one-shot)",1),k=b));if(null!==k)return k;a.url&&a.url!==b.url&&b.load(b._iO);b.loaded?c._wD(e.substr(0,e.lastIndexOf(":"))):0===b.readyState?(c._wD(e+"Attempting to load"),b.isHTML5||(b._iO.autoPlay=!0),b.load(b._iO),b.instanceOptions=b._iO):2===b.readyState?(c._wD(e+
"Could not load - exiting",2),k=b):c._wD(e+"Loading - attempting to play...");if(null!==k)return k;!b.isHTML5&&(9===p&&0<b.position&&b.position===b.duration)&&(c._wD(e+"Sound at end, resetting to position:0"),a.position=0);if(b.paused&&0<=b.position&&(!b._iO.serverURL||0<b.position))c._wD(e+"Resuming from paused state",1),b.resume();else{b._iO=x(a,b._iO);if(null!==b._iO.from&&null!==b._iO.to&&0===b.instanceCount&&0===b.playState&&!b._iO.serverURL){f=function(){b._iO=x(a,b._iO);b.play(b._iO)};if(b.isHTML5&&
!b._html5_canplay)c._wD(e+"Beginning load for from/to case"),b.load({oncanplay:f}),k=!1;else if(!b.isHTML5&&!b.loaded&&(!b.readyState||2!==b.readyState))c._wD(e+"Preloading for from/to case"),b.load({onload:f}),k=!1;if(null!==k)return k;b._iO=w()}c._wD(e+"Starting to play");(!b.instanceCount||b._iO.multiShotEvents||!b.isHTML5&&8<p&&!b.getAutoPlay())&&b.instanceCount++;b._iO.onposition&&0===b.playState&&q(b);b.playState=1;b.paused=!1;b.position=b._iO.position!==g&&!isNaN(b._iO.position)?b._iO.position:
0;b.isHTML5||(b._iO=ja(ia(b._iO)));b._iO.onplay&&d&&(b._iO.onplay.apply(b),s=!0);b.setVolume(b._iO.volume,!0);b.setPan(b._iO.pan,!0);b.isHTML5?(h(),e=b._setup_html5(),b.setPosition(b._iO.position),e.play()):(k=l._start(b.id,b._iO.loops||1,9===p?b.position:b.position/1E3,b._iO.multiShot||!1),9===p&&!k&&(c._wD(e+"No sound hardware, or 32-sound ceiling hit"),b._iO.onplayerror&&b._iO.onplayerror.apply(b)))}return b};this.stop=function(a){var d=b._iO;1===b.playState&&(c._wD(b.id+": stop()"),b._onbufferchange(0),
b._resetOnPosition(0),b.paused=!1,b.isHTML5||(b.playState=0),Pa(),d.to&&b.clearOnPosition(d.to),b.isHTML5?b._a&&(a=b.position,b.setPosition(0),b.position=a,b._a.pause(),b.playState=0,b._onTimer(),k()):(l._stop(b.id,a),d.serverURL&&b.unload()),b.instanceCount=0,b._iO={},d.onstop&&d.onstop.apply(b));return b};this.setAutoPlay=function(a){c._wD(b.id+": Autoplay turned "+(a?"on":"off"));b._iO.autoPlay=a;b.isHTML5||(l._setAutoPlay(b.id,a),a&&(!b.instanceCount&&1===b.readyState)&&(b.instanceCount++,c._wD(b.id+
": Incremented instance count to "+b.instanceCount)))};this.getAutoPlay=function(){return b._iO.autoPlay};this.setPosition=function(a){a===g&&(a=0);var d=b.isHTML5?Math.max(a,0):Math.min(b.duration||b._iO.duration,Math.max(a,0));b.position=d;a=b.position/1E3;b._resetOnPosition(b.position);b._iO.position=d;if(b.isHTML5){if(b._a)if(b._html5_canplay){if(b._a.currentTime!==a){c._wD(b.id+": setPosition("+a+")");try{b._a.currentTime=a,(0===b.playState||b.paused)&&b._a.pause()}catch(e){c._wD(b.id+": setPosition("+
a+") failed: "+e.message,2)}}}else c._wD(b.id+": setPosition("+a+"): Cannot seek yet, sound not ready")}else a=9===p?b.position:a,b.readyState&&2!==b.readyState&&l._setPosition(b.id,a,b.paused||!b.playState,b._iO.multiShot);b.isHTML5&&b.paused&&b._onTimer(!0);return b};this.pause=function(a){if(b.paused||0===b.playState&&1!==b.readyState)return b;c._wD(b.id+": pause()");b.paused=!0;b.isHTML5?(b._setup_html5().pause(),k()):(a||a===g)&&l._pause(b.id,b._iO.multiShot);b._iO.onpause&&b._iO.onpause.apply(b);
return b};this.resume=function(){var a=b._iO;if(!b.paused)return b;c._wD(b.id+": resume()");b.paused=!1;b.playState=1;b.isHTML5?(b._setup_html5().play(),h()):(a.isMovieStar&&!a.serverURL&&b.setPosition(b.position),l._pause(b.id,a.multiShot));!s&&a.onplay?(a.onplay.apply(b),s=!0):a.onresume&&a.onresume.apply(b);return b};this.togglePause=function(){c._wD(b.id+": togglePause()");if(0===b.playState)return b.play({position:9===p&&!b.isHTML5?b.position:b.position/1E3}),b;b.paused?b.resume():b.pause();
return b};this.setPan=function(a,c){a===g&&(a=0);c===g&&(c=!1);b.isHTML5||l._setPan(b.id,a);b._iO.pan=a;c||(b.pan=a,b.options.pan=a);return b};this.setVolume=function(a,d){a===g&&(a=100);d===g&&(d=!1);b.isHTML5?b._a&&(b._a.volume=Math.max(0,Math.min(1,a/100))):l._setVolume(b.id,c.muted&&!b.muted||b.muted?0:a);b._iO.volume=a;d||(b.volume=a,b.options.volume=a);return b};this.mute=function(){b.muted=!0;b.isHTML5?b._a&&(b._a.muted=!0):l._setVolume(b.id,0);return b};this.unmute=function(){b.muted=!1;var a=
b._iO.volume!==g;b.isHTML5?b._a&&(b._a.muted=!1):l._setVolume(b.id,a?b._iO.volume:b.options.volume);return b};this.toggleMute=function(){return b.muted?b.unmute():b.mute()};this.onposition=this.onPosition=function(a,c,d){z.push({position:parseInt(a,10),method:c,scope:d!==g?d:b,fired:!1});return b};this.clearOnPosition=function(b,a){var c;b=parseInt(b,10);if(isNaN(b))return!1;for(c=0;c<z.length;c++)if(b===z[c].position&&(!a||a===z[c].method))z[c].fired&&u--,z.splice(c,1)};this._processOnPosition=function(){var a,
c;a=z.length;if(!a||!b.playState||u>=a)return!1;for(a-=1;0<=a;a--)c=z[a],!c.fired&&b.position>=c.position&&(c.fired=!0,u++,c.method.apply(c.scope,[c.position]));return!0};this._resetOnPosition=function(b){var a,c;a=z.length;if(!a)return!1;for(a-=1;0<=a;a--)c=z[a],c.fired&&b<=c.position&&(c.fired=!1,u--);return!0};w=function(){var a=b._iO,d=a.from,e=a.to,f,g;g=function(){c._wD(b.id+': "To" time of '+e+" reached.");b.clearOnPosition(e,g);b.stop()};f=function(){c._wD(b.id+': Playing "from" '+d);if(null!==
e&&!isNaN(e))b.onPosition(e,g)};null!==d&&!isNaN(d)&&(a.position=d,a.multiShot=!1,f());return a};q=function(){var a,c=b._iO.onposition;if(c)for(a in c)if(c.hasOwnProperty(a))b.onPosition(parseInt(a,10),c[a])};Pa=function(){var a,c=b._iO.onposition;if(c)for(a in c)c.hasOwnProperty(a)&&b.clearOnPosition(parseInt(a,10))};h=function(){b.isHTML5&&Za(b)};k=function(){b.isHTML5&&$a(b)};f=function(a){a||(z=[],u=0);s=!1;b._hasTimer=null;b._a=null;b._html5_canplay=!1;b.bytesLoaded=null;b.bytesTotal=null;b.duration=
b._iO&&b._iO.duration?b._iO.duration:null;b.durationEstimate=null;b.buffered=[];b.eqData=[];b.eqData.left=[];b.eqData.right=[];b.failures=0;b.isBuffering=!1;b.instanceOptions={};b.instanceCount=0;b.loaded=!1;b.metadata={};b.readyState=0;b.muted=!1;b.paused=!1;b.peakData={left:0,right:0};b.waveformData={left:[],right:[]};b.playState=0;b.position=null;b.id3={}};f();this._onTimer=function(a){var c,f=!1,g={};if(b._hasTimer||a){if(b._a&&(a||(0<b.playState||1===b.readyState)&&!b.paused))c=b._get_html5_duration(),
c!==d&&(d=c,b.duration=c,f=!0),b.durationEstimate=b.duration,c=1E3*b._a.currentTime||0,c!==e&&(e=c,f=!0),(f||a)&&b._whileplaying(c,g,g,g,g);return f}};this._get_html5_duration=function(){var a=b._iO;return(a=b._a&&b._a.duration?1E3*b._a.duration:a&&a.duration?a.duration:null)&&!isNaN(a)&&Infinity!==a?a:null};this._apply_loop=function(b,a){!b.loop&&1<a&&c._wD("Note: Native HTML5 looping is infinite.",1);b.loop=1<a?"loop":""};this._setup_html5=function(a){a=x(b._iO,a);var c=E?Ra:b._a,d=decodeURI(a.url),
e;E?d===decodeURI(Ga)&&(e=!0):d===decodeURI(t)&&(e=!0);if(c){if(c._s)if(E)c._s&&(c._s.playState&&!e)&&c._s.stop();else if(!E&&d===decodeURI(t))return b._apply_loop(c,a.loops),c;e||(f(!1),c.src=a.url,Ga=t=b.url=a.url,c._called_load=!1)}else b._a=a.autoLoad||a.autoPlay?new Audio(a.url):Ka&&10>opera.version()?new Audio(null):new Audio,c=b._a,c._called_load=!1,E&&(Ra=c);b.isHTML5=!0;b._a=c;c._s=b;m();b._apply_loop(c,a.loops);a.autoLoad||a.autoPlay?b.load():(c.autobuffer=!1,c.preload="auto");return c};
m=function(){if(b._a._added_events)return!1;var a;b._a._added_events=!0;for(a in F)F.hasOwnProperty(a)&&b._a&&b._a.addEventListener(a,F[a],!1);return!0};nb=function(){var a;c._wD(b.id+": Removing event listeners");b._a._added_events=!1;for(a in F)F.hasOwnProperty(a)&&b._a&&b._a.removeEventListener(a,F[a],!1)};this._onload=function(a){var d=!!a||!b.isHTML5&&8===p&&b.duration;a=b.id+": ";c._wD(a+(d?"onload()":"Failed to load? - "+b.url),d?1:2);!d&&!b.isHTML5&&(!0===c.sandbox.noRemote&&c._wD(a+r("noNet"),
1),!0===c.sandbox.noLocal&&c._wD(a+r("noLocal"),1));b.loaded=d;b.readyState=d?3:2;b._onbufferchange(0);b._iO.onload&&na(b,function(){b._iO.onload.apply(b,[d])});return!0};this._onbufferchange=function(a){if(0===b.playState||a&&b.isBuffering||!a&&!b.isBuffering)return!1;b.isBuffering=1===a;b._iO.onbufferchange&&(c._wD(b.id+": Buffer state change: "+a),b._iO.onbufferchange.apply(b));return!0};this._onsuspend=function(){b._iO.onsuspend&&(c._wD(b.id+": Playback suspended"),b._iO.onsuspend.apply(b));return!0};
this._onfailure=function(a,d,e){b.failures++;c._wD(b.id+": Failures \x3d "+b.failures);if(b._iO.onfailure&&1===b.failures)b._iO.onfailure(b,a,d,e);else c._wD(b.id+": Ignoring failure")};this._onfinish=function(){var a=b._iO.onfinish;b._onbufferchange(0);b._resetOnPosition(0);if(b.instanceCount&&(b.instanceCount--,b.instanceCount||(Pa(),b.playState=0,b.paused=!1,b.instanceCount=0,b.instanceOptions={},b._iO={},k(),b.isHTML5&&(b.position=0)),(!b.instanceCount||b._iO.multiShotEvents)&&a))c._wD(b.id+": onfinish()"),
na(b,function(){a.apply(b)})};this._whileloading=function(a,c,d,e){var f=b._iO;b.bytesLoaded=a;b.bytesTotal=c;b.duration=Math.floor(d);b.bufferLength=e;b.durationEstimate=!b.isHTML5&&!f.isMovieStar?f.duration?b.duration>f.duration?b.duration:f.duration:parseInt(b.bytesTotal/b.bytesLoaded*b.duration,10):b.duration;b.isHTML5||(b.buffered=[{start:0,end:b.duration}]);(3!==b.readyState||b.isHTML5)&&f.whileloading&&f.whileloading.apply(b)};this._whileplaying=function(a,c,d,e,f){var k=b._iO;if(isNaN(a)||
null===a)return!1;b.position=Math.max(0,a);b._processOnPosition();!b.isHTML5&&8<p&&(k.usePeakData&&(c!==g&&c)&&(b.peakData={left:c.leftPeak,right:c.rightPeak}),k.useWaveformData&&(d!==g&&d)&&(b.waveformData={left:d.split(","),right:e.split(",")}),k.useEQData&&(f!==g&&f&&f.leftEQ)&&(a=f.leftEQ.split(","),b.eqData=a,b.eqData.left=a,f.rightEQ!==g&&f.rightEQ&&(b.eqData.right=f.rightEQ.split(","))));1===b.playState&&(!b.isHTML5&&(8===p&&!b.position&&b.isBuffering)&&b._onbufferchange(0),k.whileplaying&&
k.whileplaying.apply(b));return!0};this._oncaptiondata=function(a){c._wD(b.id+": Caption data received.");b.captiondata=a;b._iO.oncaptiondata&&b._iO.oncaptiondata.apply(b,[a])};this._onmetadata=function(a,d){c._wD(b.id+": Metadata received.");var e={},f,g;f=0;for(g=a.length;f<g;f++)e[a[f]]=d[f];b.metadata=e;b._iO.onmetadata&&b._iO.onmetadata.apply(b)};this._onid3=function(a,d){c._wD(b.id+": ID3 data received.");var e=[],f,g;f=0;for(g=a.length;f<g;f++)e[a[f]]=d[f];b.id3=x(b.id3,e);b._iO.onid3&&b._iO.onid3.apply(b)};
this._onconnect=function(a){a=1===a;c._wD(b.id+": "+(a?"Connected.":"Failed to connect? - "+b.url),a?1:2);if(b.connected=a)b.failures=0,v(b.id)&&(b.getAutoPlay()?b.play(g,b.getAutoPlay()):b._iO.autoLoad&&b.load()),b._iO.onconnect&&b._iO.onconnect.apply(b,[a])};this._ondataerror=function(a){0<b.playState&&(c._wD(b.id+": Data error: "+a),b._iO.ondataerror&&b._iO.ondataerror.apply(b))};this._debug()};ga=function(){return h.body||h._docElement||h.getElementsByTagName("div")[0]};B=function(a){return h.getElementById(a)};
x=function(a,d){var e=a||{},b,f;b=d===g?c.defaultOptions:d;for(f in b)b.hasOwnProperty(f)&&e[f]===g&&(e[f]="object"!==typeof b[f]||null===b[f]?b[f]:x(e[f],b[f]));return e};na=function(a,c){!a.isHTML5&&8===p?m.setTimeout(c,0):c()};L={onready:1,ontimeout:1,defaultOptions:1,flash9Options:1,movieStarOptions:1};ua=function(a,d){var e,b=!0,f=d!==g,h=c.setupOptions;if(a===g){b=[];for(e in h)h.hasOwnProperty(e)&&b.push(e);for(e in L)L.hasOwnProperty(e)&&("object"===typeof c[e]?b.push(e+": {...}"):c[e]instanceof
Function?b.push(e+": function() {...}"):b.push(e));c._wD(r("setup",b.join(", ")));return!1}for(e in a)if(a.hasOwnProperty(e))if("object"!==typeof a[e]||null===a[e]||a[e]instanceof Array||a[e]instanceof RegExp)f&&L[d]!==g?c[d][e]=a[e]:h[e]!==g?(c.setupOptions[e]=a[e],c[e]=a[e]):L[e]===g?(R(r(c[e]===g?"setupUndef":"setupError",e),2),b=!1):c[e]instanceof Function?c[e].apply(c,a[e]instanceof Array?a[e]:[a[e]]):c[e]=a[e];else if(L[e]===g)R(r(c[e]===g?"setupUndef":"setupError",e),2),b=!1;else return ua(a[e],
e);return b};w=function(){function a(a){a=db.call(a);var b=a.length;e?(a[1]="on"+a[1],3<b&&a.pop()):3===b&&a.push(!1);return a}function c(a,d){var g=a.shift(),k=[b[d]];if(e)g[k](a[0],a[1]);else g[k].apply(g,a)}var e=m.attachEvent,b={add:e?"attachEvent":"addEventListener",remove:e?"detachEvent":"removeEventListener"};return{add:function(){c(a(arguments),"add")},remove:function(){c(a(arguments),"remove")}}}();F={abort:s(function(){c._wD(this._s.id+": abort")}),canplay:s(function(){var a=this._s,d;if(a._html5_canplay)return!0;
a._html5_canplay=!0;c._wD(a.id+": canplay");a._onbufferchange(0);d=a._iO.position!==g&&!isNaN(a._iO.position)?a._iO.position/1E3:null;if(a.position&&this.currentTime!==d){c._wD(a.id+": canplay: Setting position to "+d);try{this.currentTime=d}catch(e){c._wD(a.id+": canplay: Setting position of "+d+" failed: "+e.message,2)}}a._iO._oncanplay&&a._iO._oncanplay()}),canplaythrough:s(function(){var a=this._s;a.loaded||(a._onbufferchange(0),a._whileloading(a.bytesLoaded,a.bytesTotal,a._get_html5_duration()),
a._onload(!0))}),ended:s(function(){var a=this._s;c._wD(a.id+": ended");a._onfinish()}),error:s(function(){c._wD(this._s.id+": HTML5 error, code "+this.error.code);this._s._onload(!1)}),loadeddata:s(function(){var a=this._s;c._wD(a.id+": loadeddata");!a._loaded&&!Ja&&(a.duration=a._get_html5_duration())}),loadedmetadata:s(function(){c._wD(this._s.id+": loadedmetadata")}),loadstart:s(function(){c._wD(this._s.id+": loadstart");this._s._onbufferchange(1)}),play:s(function(){c._wD(this._s.id+": play()");
this._s._onbufferchange(0)}),playing:s(function(){c._wD(this._s.id+": playing");this._s._onbufferchange(0)}),progress:s(function(a){var d=this._s,e,b,f;e=0;var g="progress"===a.type,h=a.target.buffered,k=a.loaded||0,m=a.total||1;d.buffered=[];if(h&&h.length){e=0;for(b=h.length;e<b;e++)d.buffered.push({start:1E3*h.start(e),end:1E3*h.end(e)});e=1E3*(h.end(0)-h.start(0));k=e/(1E3*a.target.duration);if(g&&1<h.length){f=[];b=h.length;for(e=0;e<b;e++)f.push(1E3*a.target.buffered.start(e)+"-"+1E3*a.target.buffered.end(e));
c._wD(this._s.id+": progress, timeRanges: "+f.join(", "))}g&&!isNaN(k)&&c._wD(this._s.id+": progress, "+Math.floor(100*k)+"% loaded")}isNaN(k)||(d._onbufferchange(0),d._whileloading(k,m,d._get_html5_duration()),k&&(m&&k===m)&&F.canplaythrough.call(this,a))}),ratechange:s(function(){c._wD(this._s.id+": ratechange")}),suspend:s(function(a){var d=this._s;c._wD(this._s.id+": suspend");F.progress.call(this,a);d._onsuspend()}),stalled:s(function(){c._wD(this._s.id+": stalled")}),timeupdate:s(function(){this._s._onTimer()}),
waiting:s(function(){var a=this._s;c._wD(this._s.id+": waiting");a._onbufferchange(1)})};ma=function(a){return a.serverURL||a.type&&ca(a.type)?!1:a.type?$({type:a.type}):$({url:a.url})||c.html5Only};Ea=function(a,c){a&&(a.src=c,a._called_load=!1);E&&(Ga=null)};$=function(a){if(!c.useHTML5Audio||!c.hasHTML5)return!1;var d=a.url||null;a=a.type||null;var e=c.audioFormats,b;if(a&&c.html5[a]!==g)return c.html5[a]&&!ca(a);if(!H){H=[];for(b in e)e.hasOwnProperty(b)&&(H.push(b),e[b].related&&(H=H.concat(e[b].related)));
H=RegExp("\\.("+H.join("|")+")(\\?.*)?$","i")}b=d?d.toLowerCase().match(H):null;!b||!b.length?a&&(d=a.indexOf(";"),b=(-1!==d?a.substr(0,d):a).substr(6)):b=b[1];b&&c.html5[b]!==g?d=c.html5[b]&&!ca(b):(a="audio/"+b,d=c.html5.canPlayType({type:a}),d=(c.html5[b]=d)&&c.html5[a]&&!ca(a));return d};cb=function(){function a(a){var b,e,f=b=!1;if(!d||"function"!==typeof d.canPlayType)return b;if(a instanceof Array){b=0;for(e=a.length;b<e;b++)if(c.html5[a[b]]||d.canPlayType(a[b]).match(c.html5Test))f=!0,c.html5[a[b]]=
!0,c.flash[a[b]]=!!a[b].match(jb);b=f}else a=d&&"function"===typeof d.canPlayType?d.canPlayType(a):!1,b=!(!a||!a.match(c.html5Test));return b}if(!c.useHTML5Audio||!c.hasHTML5)return!1;var d=Audio!==g?Ka&&10>opera.version()?new Audio(null):new Audio:null,e,b,f={},h;h=c.audioFormats;for(e in h)if(h.hasOwnProperty(e)&&(b="audio/"+e,f[e]=a(h[e].type),f[b]=f[e],e.match(jb)?(c.flash[e]=!0,c.flash[b]=!0):(c.flash[e]=!1,c.flash[b]=!1),h[e]&&h[e].related))for(b=h[e].related.length-1;0<=b;b--)f["audio/"+h[e].related[b]]=
f[e],c.html5[h[e].related[b]]=f[e],c.flash[h[e].related[b]]=f[e];f.canPlayType=d?a:null;c.html5=x(c.html5,f);return!0};G={notReady:"Unavailable - wait until onready() has fired.",notOK:"Audio support is not available.",domError:"soundManagerexception caught while appending SWF to DOM.",spcWmode:"Removing wmode, preventing known SWF loading issue(s)",swf404:"soundManager: Verify that %s is a valid path.",tryDebug:"Try soundManager.debugFlash \x3d true for more security details (output goes to SWF.)",
checkSWF:"See SWF output for more debug info.",localFail:"soundManager: Non-HTTP page ("+h.location.protocol+" URL?) Review Flash player security settings for this special case:\nhttp://www.macromedia.com/support/documentation/en/flashplayer/help/settings_manager04.html\nMay need to add/allow path, eg. c:/sm2/ or /users/me/sm2/",waitFocus:"soundManager: Special case: Waiting for SWF to load with window focus...",waitForever:"soundManager: Waiting indefinitely for Flash (will recover if unblocked)...",
waitSWF:"soundManager: Waiting for 100% SWF load...",needFunction:"soundManager: Function object expected for %s",badID:'Warning: Sound ID "%s" should be a string, starting with a non-numeric character',currentObj:"soundManager: _debug(): Current sound objects",waitOnload:"soundManager: Waiting for window.onload()",docLoaded:"soundManager: Document already loaded",onload:"soundManager: initComplete(): calling soundManager.onload()",onloadOK:"soundManager.onload() complete",didInit:"soundManager: init(): Already called?",
secNote:"Flash security note: Network/internet URLs will not load due to security restrictions. Access can be configured via Flash Player Global Security Settings Page: http://www.macromedia.com/support/documentation/en/flashplayer/help/settings_manager04.html",badRemove:"soundManager: Failed to remove Flash node.",shutdown:"soundManager.disable(): Shutting down",queue:"soundManager: Queueing %s handler",smError:"SMSound.load(): Exception: JS-Flash communication failed, or JS error.",fbTimeout:"No flash response, applying .swf_timedout CSS...",
fbLoaded:"Flash loaded",flRemoved:"soundManager: Flash movie removed.",fbHandler:"soundManager: flashBlockHandler()",manURL:"SMSound.load(): Using manually-assigned URL",onURL:"soundManager.load(): current URL already assigned.",badFV:'soundManager.flashVersion must be 8 or 9. "%s" is invalid. Reverting to %s.',as2loop:"Note: Setting stream:false so looping can work (flash 8 limitation)",noNSLoop:"Note: Looping not implemented for MovieStar formats",needfl9:"Note: Switching to flash 9, required for MP4 formats.",
mfTimeout:"Setting flashLoadTimeout \x3d 0 (infinite) for off-screen, mobile flash case",needFlash:"soundManager: Fatal error: Flash is needed to play some required formats, but is not available.",gotFocus:"soundManager: Got window focus.",policy:"Enabling usePolicyFile for data access",setup:"soundManager.setup(): allowed parameters: %s",setupError:'soundManager.setup(): "%s" cannot be assigned with this method.',setupUndef:'soundManager.setup(): Could not find option "%s"',setupLate:"soundManager.setup(): url, flashVersion and html5Test property changes will not take effect until reboot().",
noURL:"soundManager: Flash URL required. Call soundManager.setup({url:...}) to get started.",sm2Loaded:"SoundManager 2: Ready.",reset:"soundManager.reset(): Removing event callbacks",mobileUA:"Mobile UA detected, preferring HTML5 by default.",globalHTML5:"Using singleton HTML5 Audio() pattern for this device."};r=function(){var a=db.call(arguments),c=a.shift(),c=G&&G[c]?G[c]:"",e,b;if(c&&a&&a.length){e=0;for(b=a.length;e<b;e++)c=c.replace("%s",a[e])}return c};ia=function(a){8===p&&(1<a.loops&&a.stream)&&
(n("as2loop"),a.stream=!1);return a};ja=function(a,d){if(a&&!a.usePolicyFile&&(a.onid3||a.usePeakData||a.useWaveformData||a.useEQData))c._wD((d||"")+r("policy")),a.usePolicyFile=!0;return a};R=function(a){console!==g&&console.warn!==g?console.warn(a):c._wD(a)};ra=function(){return!1};Wa=function(a){for(var c in a)a.hasOwnProperty(c)&&"function"===typeof a[c]&&(a[c]=ra)};Aa=function(a){a===g&&(a=!1);(t||a)&&c.disable(a)};Xa=function(a){var d=null;if(a)if(a.match(/\.swf(\?.*)?$/i)){if(d=a.substr(a.toLowerCase().lastIndexOf(".swf?")+
4))return a}else a.lastIndexOf("/")!==a.length-1&&(a+="/");a=(a&&-1!==a.lastIndexOf("/")?a.substr(0,a.lastIndexOf("/")+1):"./")+c.movieURL;c.noSWFCache&&(a+="?ts\x3d"+(new Date).getTime());return a};wa=function(){p=parseInt(c.flashVersion,10);8!==p&&9!==p&&(c._wD(r("badFV",p,8)),c.flashVersion=p=8);var a=c.debugMode||c.debugFlash?"_debug.swf":".swf";c.useHTML5Audio&&(!c.html5Only&&c.audioFormats.mp4.required&&9>p)&&(c._wD(r("needfl9")),c.flashVersion=p=9);c.version=c.versionNumber+(c.html5Only?" (HTML5-only mode)":
9===p?" (AS3/Flash 9)":" (AS2/Flash 8)");8<p?(c.defaultOptions=x(c.defaultOptions,c.flash9Options),c.features.buffering=!0,c.defaultOptions=x(c.defaultOptions,c.movieStarOptions),c.filePatterns.flash9=RegExp("\\.(mp3|"+mb.join("|")+")(\\?.*)?$","i"),c.features.movieStar=!0):c.features.movieStar=!1;c.filePattern=c.filePatterns[8!==p?"flash9":"flash8"];c.movieURL=(8===p?"soundmanager2.swf":"soundmanager2_flash9.swf").replace(".swf",a);c.features.peakData=c.features.waveformData=c.features.eqData=8<
p};Ua=function(a,c){if(!l)return!1;l._setPolling(a,c)};za=function(){c.debugURLParam.test(S)&&(c.debugMode=!0);if(B(c.debugID))return!1;var a,d,e,b;if(c.debugMode&&!B(c.debugID)&&(!hb||!c.useConsole||!c.consoleOnly)){a=h.createElement("div");a.id=c.debugID+"-toggle";d={position:"fixed",bottom:"0px",right:"0px",width:"1.2em",height:"1.2em",lineHeight:"1.2em",margin:"2px",textAlign:"center",border:"1px solid #999",cursor:"pointer",background:"#fff",color:"#333",zIndex:10001};a.appendChild(h.createTextNode("-"));
a.onclick=Ya;a.title="Toggle SM2 debug console";u.match(/msie 6/i)&&(a.style.position="absolute",a.style.cursor="hand");for(b in d)d.hasOwnProperty(b)&&(a.style[b]=d[b]);d=h.createElement("div");d.id=c.debugID;d.style.display=c.debugMode?"block":"none";if(c.debugMode&&!B(a.id)){try{e=ga(),e.appendChild(a)}catch(f){throw Error(r("domError")+" \n"+f.toString());}e.appendChild(d)}}};v=this.getSoundById;n=function(a,d){return!a?"":c._wD(r(a),d)};Ya=function(){var a=B(c.debugID),d=B(c.debugID+"-toggle");
if(!a)return!1;ta?(d.innerHTML="+",a.style.display="none"):(d.innerHTML="-",a.style.display="block");ta=!ta};y=function(a,c,e){if(m.sm2Debugger!==g)try{sm2Debugger.handleEvent(a,c,e)}catch(b){}return!0};Q=function(){var a=[];c.debugMode&&a.push("sm2_debug");c.debugFlash&&a.push("flash_debug");c.useHighPerformance&&a.push("high_performance");return a.join(" ")};Ca=function(){var a=r("fbHandler"),d=c.getMoviePercent(),e={type:"FLASHBLOCK"};if(c.html5Only)return!1;c.ok()?(c.didFlashBlock&&c._wD(a+": Unblocked"),
c.oMC&&(c.oMC.className=[Q(),"movieContainer","swf_loaded"+(c.didFlashBlock?" swf_unblocked":"")].join(" "))):(C&&(c.oMC.className=Q()+" movieContainer "+(null===d?"swf_timedout":"swf_error"),c._wD(a+": "+r("fbTimeout")+(d?" ("+r("fbLoaded")+")":""))),c.didFlashBlock=!0,J({type:"ontimeout",ignoreInit:!0,error:e}),P(e))};va=function(a,c,e){D[a]===g&&(D[a]=[]);D[a].push({method:c,scope:e||null,fired:!1})};J=function(a){a||(a={type:c.ok()?"onready":"ontimeout"});if(!q&&a&&!a.ignoreInit||"ontimeout"===
a.type&&(c.ok()||t&&!a.ignoreInit))return!1;var d={success:a&&a.ignoreInit?c.ok():!t},e=a&&a.type?D[a.type]||[]:[],b=[],f,d=[d],g=C&&!c.ok();a.error&&(d[0].error=a.error);a=0;for(f=e.length;a<f;a++)!0!==e[a].fired&&b.push(e[a]);if(b.length){a=0;for(f=b.length;a<f;a++)b[a].scope?b[a].method.apply(b[a].scope,d):b[a].method.apply(this,d),g||(b[a].fired=!0)}return!0};M=function(){m.setTimeout(function(){c.useFlashBlock&&Ca();J();"function"===typeof c.onload&&(n("onload",1),c.onload.apply(m),n("onloadOK",
1));c.waitForWindowLoad&&w.add(m,"load",M)},1)};Ha=function(){if(A!==g)return A;var a=!1,c=navigator,e=c.plugins,b,f=m.ActiveXObject;if(e&&e.length)(c=c.mimeTypes)&&(c["application/x-shockwave-flash"]&&c["application/x-shockwave-flash"].enabledPlugin&&c["application/x-shockwave-flash"].enabledPlugin.description)&&(a=!0);else if(f!==g&&!u.match(/MSAppHost/i)){try{b=new f("ShockwaveFlash.ShockwaveFlash")}catch(h){}a=!!b}return A=a};bb=function(){var a,d,e=c.audioFormats;if(oa&&u.match(/os (1|2|3_0|3_1)/i))c.hasHTML5=
!1,c.html5Only=!0,c.oMC&&(c.oMC.style.display="none");else if(c.useHTML5Audio){if(!c.html5||!c.html5.canPlayType)c._wD("SoundManager: No HTML5 Audio() support detected."),c.hasHTML5=!1;Ma&&c._wD("soundManager: Note: Buggy HTML5 Audio in Safari on this OS X release, see https://bugs.webkit.org/show_bug.cgi?id\x3d32159 - "+(!A?" would use flash fallback for MP3/MP4, but none detected.":"will use flash fallback for MP3/MP4, if available"),1)}if(c.useHTML5Audio&&c.hasHTML5)for(d in e)if(e.hasOwnProperty(d)&&
(e[d].required&&!c.html5.canPlayType(e[d].type)||c.preferFlash&&(c.flash[d]||c.flash[e[d].type])))a=!0;c.ignoreFlash&&(a=!1);c.html5Only=c.hasHTML5&&c.useHTML5Audio&&!a;return!c.html5Only};la=function(a){var d,e,b=0;if(a instanceof Array){d=0;for(e=a.length;d<e;d++)if(a[d]instanceof Object){if(c.canPlayMIME(a[d].type)){b=d;break}}else if(c.canPlayURL(a[d])){b=d;break}a[b].url&&(a[b]=a[b].url);a=a[b]}return a};Za=function(a){a._hasTimer||(a._hasTimer=!0,!La&&c.html5PollingInterval&&(null===Z&&0===
ka&&(Z=setInterval(ab,c.html5PollingInterval)),ka++))};$a=function(a){a._hasTimer&&(a._hasTimer=!1,!La&&c.html5PollingInterval&&ka--)};ab=function(){var a;if(null!==Z&&!ka)return clearInterval(Z),Z=null,!1;for(a=c.soundIDs.length-1;0<=a;a--)c.sounds[c.soundIDs[a]].isHTML5&&c.sounds[c.soundIDs[a]]._hasTimer&&c.sounds[c.soundIDs[a]]._onTimer()};P=function(a){a=a!==g?a:{};"function"===typeof c.onerror&&c.onerror.apply(m,[{type:a.type!==g?a.type:null}]);a.fatal!==g&&a.fatal&&c.disable()};eb=function(){if(!Ma||
!Ha())return!1;var a=c.audioFormats,d,e;for(e in a)if(a.hasOwnProperty(e)&&("mp3"===e||"mp4"===e))if(c._wD("soundManager: Using flash fallback for "+e+" format"),c.html5[e]=!1,a[e]&&a[e].related)for(d=a[e].related.length-1;0<=d;d--)c.html5[a[e].related[d]]=!1};this._setSandboxType=function(a){var d=c.sandbox;d.type=a;d.description=d.types[d.types[a]!==g?a:"unknown"];"localWithFile"===d.type?(d.noRemote=!0,d.noLocal=!1,n("secNote",2)):"localWithNetwork"===d.type?(d.noRemote=!1,d.noLocal=!0):"localTrusted"===
d.type&&(d.noRemote=!1,d.noLocal=!1)};this._externalInterfaceOK=function(a,d){if(c.swfLoaded)return!1;var e;y("swf",!0);y("flashtojs",!0);c.swfLoaded=!0;pa=!1;Ma&&eb();if(!d||d.replace(/\+dev/i,"")!==c.versionNumber.replace(/\+dev/i,""))return e='soundManager: Fatal: JavaScript file build "'+c.versionNumber+'" does not match Flash SWF build "'+d+'" at '+c.url+". Ensure both are up-to-date.",setTimeout(function(){throw Error(e);},0),!1;setTimeout(sa,I?100:1)};ha=function(a,d){function e(){var a=[],
b,d=[];b="SoundManager "+c.version+(!c.html5Only&&c.useHTML5Audio?c.hasHTML5?" + HTML5 audio":", no HTML5 audio support":"");c.html5Only?c.html5PollingInterval&&a.push("html5PollingInterval ("+c.html5PollingInterval+"ms)"):(c.preferFlash&&a.push("preferFlash"),c.useHighPerformance&&a.push("useHighPerformance"),c.flashPollingInterval&&a.push("flashPollingInterval ("+c.flashPollingInterval+"ms)"),c.html5PollingInterval&&a.push("html5PollingInterval ("+c.html5PollingInterval+"ms)"),c.wmode&&a.push("wmode ("+
c.wmode+")"),c.debugFlash&&a.push("debugFlash"),c.useFlashBlock&&a.push("flashBlock"));a.length&&(d=d.concat([a.join(" + ")]));c._wD(b+(d.length?" + "+d.join(", "):""),1);fb()}function b(a,b){return'\x3cparam name\x3d"'+a+'" value\x3d"'+b+'" /\x3e'}if(T&&U)return!1;if(c.html5Only)return wa(),e(),c.oMC=B(c.movieID),sa(),U=T=!0,!1;var f=d||c.url,m=c.altURL||f,l=ga(),k=Q(),p=null,p=h.getElementsByTagName("html")[0],n,s,q,p=p&&p.dir&&p.dir.match(/rtl/i);a=a===g?c.id:a;wa();c.url=Xa(aa?f:m);d=c.url;c.wmode=
!c.wmode&&c.useHighPerformance?"transparent":c.wmode;if(null!==c.wmode&&(u.match(/msie 8/i)||!I&&!c.useHighPerformance)&&navigator.platform.match(/win32|win64/i))K.push(G.spcWmode),c.wmode=null;l={name:a,id:a,src:d,quality:"high",allowScriptAccess:c.allowScriptAccess,bgcolor:c.bgColor,pluginspage:kb+"www.macromedia.com/go/getflashplayer",title:"JS/Flash audio component (SoundManager 2)",type:"application/x-shockwave-flash",wmode:c.wmode,hasPriority:"true"};c.debugFlash&&(l.FlashVars="debug\x3d1");
c.wmode||delete l.wmode;if(I)f=h.createElement("div"),s=['\x3cobject id\x3d"'+a+'" data\x3d"'+d+'" type\x3d"'+l.type+'" title\x3d"'+l.title+'" classid\x3d"clsid:D27CDB6E-AE6D-11cf-96B8-444553540000" codebase\x3d"'+kb+'download.macromedia.com/pub/shockwave/cabs/flash/swflash.cab#version\x3d6,0,40,0"\x3e',b("movie",d),b("AllowScriptAccess",c.allowScriptAccess),b("quality",l.quality),c.wmode?b("wmode",c.wmode):"",b("bgcolor",c.bgColor),b("hasPriority","true"),c.debugFlash?b("FlashVars",l.FlashVars):
"","\x3c/object\x3e"].join("");else for(n in f=h.createElement("embed"),l)l.hasOwnProperty(n)&&f.setAttribute(n,l[n]);za();k=Q();if(l=ga())if(c.oMC=B(c.movieID)||h.createElement("div"),c.oMC.id)q=c.oMC.className,c.oMC.className=(q?q+" ":"movieContainer")+(k?" "+k:""),c.oMC.appendChild(f),I&&(n=c.oMC.appendChild(h.createElement("div")),n.className="sm2-object-box",n.innerHTML=s),U=!0;else{c.oMC.id=c.movieID;c.oMC.className="movieContainer "+k;n=k=null;c.useFlashBlock||(c.useHighPerformance?k={position:"fixed",
width:"8px",height:"8px",bottom:"0px",left:"0px",overflow:"hidden"}:(k={position:"absolute",width:"6px",height:"6px",top:"-9999px",left:"-9999px"},p&&(k.left=Math.abs(parseInt(k.left,10))+"px")));qb&&(c.oMC.style.zIndex=1E4);if(!c.debugFlash)for(q in k)k.hasOwnProperty(q)&&(c.oMC.style[q]=k[q]);try{I||c.oMC.appendChild(f),l.appendChild(c.oMC),I&&(n=c.oMC.appendChild(h.createElement("div")),n.className="sm2-object-box",n.innerHTML=s),U=!0}catch(t){throw Error(r("domError")+" \n"+t.toString());}}T=
!0;e();return!0};fa=function(){if(c.html5Only)return ha(),!1;if(l)return!1;if(!c.url)return n("noURL"),!1;l=c.getMovie(c.id);l||(X?(I?c.oMC.innerHTML=Ba:c.oMC.appendChild(X),X=null,T=!0):ha(c.id,c.url),l=c.getMovie(c.id));"function"===typeof c.oninitmovie&&setTimeout(c.oninitmovie,1);Ia();return!0};N=function(){setTimeout(Ta,1E3)};Ta=function(){var a,d=!1;if(!c.url||Y)return!1;Y=!0;w.remove(m,"load",N);if(pa&&!Na)return n("waitFocus"),!1;q||(a=c.getMoviePercent(),0<a&&100>a&&(d=!0));setTimeout(function(){a=
c.getMoviePercent();if(d)return Y=!1,c._wD(r("waitSWF")),m.setTimeout(N,1),!1;q||(c._wD("soundManager: No Flash response within expected time. Likely causes: "+(0===a?"SWF load failed, ":"")+"Flash blocked or JS-Flash security error."+(c.debugFlash?" "+r("checkSWF"):""),2),!aa&&a&&(n("localFail",2),c.debugFlash||n("tryDebug",2)),0===a&&c._wD(r("swf404",c.url),1),y("flashtojs",!1,": Timed out"+aa?" (Check flash security or flash blockers)":" (No plugin/missing SWF?)"));!q&&ib&&(null===a?c.useFlashBlock||
0===c.flashLoadTimeout?(c.useFlashBlock&&Ca(),n("waitForever")):(n("waitForever"),J({type:"ontimeout",ignoreInit:!0})):0===c.flashLoadTimeout?n("waitForever"):Aa(!0))},c.flashLoadTimeout)};ea=function(){if(Na||!pa)return w.remove(m,"focus",ea),!0;Na=ib=!0;n("gotFocus");Y=!1;N();w.remove(m,"focus",ea);return!0};Ia=function(){K.length&&(c._wD("SoundManager 2: "+K.join(" "),1),K=[])};fb=function(){Ia();var a,d=[];if(c.useHTML5Audio&&c.hasHTML5){for(a in c.audioFormats)c.audioFormats.hasOwnProperty(a)&&
d.push(a+" \x3d "+c.html5[a]+(!c.html5[a]&&A&&c.flash[a]?" (using flash)":c.preferFlash&&c.flash[a]&&A?" (preferring flash)":!c.html5[a]?" ("+(c.audioFormats[a].required?"required, ":"")+"and no flash support)":""));c._wD("SoundManager 2 HTML5 support: "+d.join(", "),1)}};V=function(a){if(q)return!1;if(c.html5Only)return n("sm2Loaded"),q=!0,M(),y("onload",!0),!0;var d=!0,e;if(!c.useFlashBlock||!c.flashLoadTimeout||c.getMoviePercent())q=!0,t&&(e={type:!A&&C?"NO_FLASH":"INIT_TIMEOUT"});c._wD("SoundManager 2 "+
(t?"failed to load":"loaded")+" ("+(t?"Flash security/load error":"OK")+")",t?2:1);t||a?(c.useFlashBlock&&c.oMC&&(c.oMC.className=Q()+" "+(null===c.getMoviePercent()?"swf_timedout":"swf_error")),J({type:"ontimeout",error:e,ignoreInit:!0}),y("onload",!1),P(e),d=!1):y("onload",!0);t||(c.waitForWindowLoad&&!da?(n("waitOnload"),w.add(m,"load",M)):(c.waitForWindowLoad&&da&&n("docLoaded"),M()));return d};Sa=function(){var a,d=c.setupOptions;for(a in d)d.hasOwnProperty(a)&&(c[a]===g?c[a]=d[a]:c[a]!==d[a]&&
(c.setupOptions[a]=c[a]))};sa=function(){if(q)return n("didInit"),!1;if(c.html5Only)return q||(w.remove(m,"load",c.beginDelayedInit),c.enabled=!0,V()),!0;fa();try{l._externalInterfaceTest(!1),Ua(!0,c.flashPollingInterval||(c.useHighPerformance?10:50)),c.debugMode||l._disableDebug(),c.enabled=!0,y("jstoflash",!0),c.html5Only||w.add(m,"unload",ra)}catch(a){return c._wD("js/flash exception: "+a.toString()),y("jstoflash",!1),P({type:"JS_TO_FLASH_EXCEPTION",fatal:!0}),Aa(!0),V(),!1}V();w.remove(m,"load",
c.beginDelayedInit);return!0};O=function(){if(W)return!1;W=!0;Sa();za();var a=null,a=null,d=m.console!==g&&"function"===typeof console.log,e=S.toLowerCase();-1!==e.indexOf("sm2-usehtml5audio\x3d")&&(a="1"===e.charAt(e.indexOf("sm2-usehtml5audio\x3d")+18),d&&console.log((a?"Enabling ":"Disabling ")+"useHTML5Audio via URL parameter"),c.setup({useHTML5Audio:a}));-1!==e.indexOf("sm2-preferflash\x3d")&&(a="1"===e.charAt(e.indexOf("sm2-preferflash\x3d")+16),d&&console.log((a?"Enabling ":"Disabling ")+"preferFlash via URL parameter"),
c.setup({preferFlash:a}));!A&&c.hasHTML5&&(c._wD("SoundManager: No Flash detected"+(!c.useHTML5Audio?", enabling HTML5.":". Trying HTML5-only mode."),1),c.setup({useHTML5Audio:!0,preferFlash:!1}));cb();c.html5.usingFlash=bb();C=c.html5.usingFlash;!A&&C&&(K.push(G.needFlash),c.setup({flashLoadTimeout:1}));h.removeEventListener&&h.removeEventListener("DOMContentLoaded",O,!1);fa();return!0};Fa=function(){"complete"===h.readyState&&(O(),h.detachEvent("onreadystatechange",Fa));return!0};ya=function(){da=
!0;w.remove(m,"load",ya)};xa=function(){if(La&&((!c.setupOptions.useHTML5Audio||c.setupOptions.preferFlash)&&K.push(G.mobileUA),c.setupOptions.useHTML5Audio=!0,c.setupOptions.preferFlash=!1,oa||gb&&!u.match(/android\s2\.3/i)))K.push(G.globalHTML5),oa&&(c.ignoreFlash=!0),E=!0};xa();Ha();w.add(m,"focus",ea);w.add(m,"load",N);w.add(m,"load",ya);h.addEventListener?h.addEventListener("DOMContentLoaded",O,!1):h.attachEvent?h.attachEvent("onreadystatechange",Fa):(y("onload",!1),P({type:"NO_DOM2_EVENTS",
fatal:!0}))}var qa=null;if(void 0===m.SM2_DEFER||!SM2_DEFER)qa=new ba;m.SoundManager=ba;m.soundManager=qa})(window);