/*
 * Copyright (C) 2007-2018 Siemens AG
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published
 * by the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

/*******************************************************************
 *
 * @author Daniel.Peintner.EXT@siemens.com
 * @version 0.9.4 
 * @contact Richard.Kuntschke@siemens.com
 *
 * <p>Code generated by EXIdizer</p>
 * <p>Schema: V2G_CI_MsgDef.xsd</p>
 *
 *
 ********************************************************************/



/**
 * \file 	EXIDatatypes.h
 * \brief 	Datatype definitions and structs for given XML Schema definitions and initialization methods
 *
 */

#ifndef EXI_iso2_DATATYPES_H
#define EXI_iso2_DATATYPES_H

#ifdef __cplusplus
extern "C" {
#endif

#define SUPPORT_YES 1
#define SUPPORT_NO 2
#define DEPLOY_ISO2_CODEC SUPPORT_NO
#define DEPLOY_ISO2_CODEC_FRAGMENT SUPPORT_NO

#if DEPLOY_ISO2_CODEC == SUPPORT_YES

#include <stdint.h>

#include "EXITypes.h"


/* Datatype definitions and structs for given XML Schema definitions */

#define UNION_YES 1
#define UNION_NO 2
#define SAVE_MEMORY_WITH_UNNAMED_UNION UNION_YES

/* Note: Please find below a list of occurrence limits that have been applied */
/* Limit occurrence of element "urn:iso:15118:2:2016:MsgDataTypes":SensorPosition from 255 to 5 (see #define iso2SensorOrderListType_SensorPosition_ARRAY_SIZE) */
/* Limit occurrence of element "urn:iso:15118:2:2016:MsgDataTypes":MeasurementData from 255 to 5 (see #define iso2MeasurementDataListType_MeasurementData_ARRAY_SIZE) */
/* Limit occurrence of element "http://www.w3.org/2000/09/xmldsig#":XPath from unbounded to 1 (see #define iso2TransformType_XPath_ARRAY_SIZE) */
/* Limit occurrence of element "http://www.w3.org/2000/09/xmldsig#":SPKISexp from unbounded to 1 (see #define iso2SPKIDataType_SPKISexp_ARRAY_SIZE) */
/* Limit occurrence of element "urn:iso:15118:2:2016:MsgDataTypes":MagneticVectorSetup from 255 to 5 (see #define iso2MagneticVectorSetupListType_MagneticVectorSetup_ARRAY_SIZE) */
/* Limit occurrence of element "http://www.w3.org/2000/09/xmldsig#":X509IssuerSerial from unbounded to 1 (see #define iso2X509DataType_X509IssuerSerial_ARRAY_SIZE) */
/* Limit occurrence of element "http://www.w3.org/2000/09/xmldsig#":X509SKI from unbounded to 1 (see #define iso2X509DataType_X509SKI_ARRAY_SIZE) */
/* Limit occurrence of element "http://www.w3.org/2000/09/xmldsig#":X509SubjectName from unbounded to 1 (see #define iso2X509DataType_X509SubjectName_ARRAY_SIZE) */
/* Limit occurrence of element "http://www.w3.org/2000/09/xmldsig#":X509Certificate from unbounded to 1 (see #define iso2X509DataType_X509Certificate_ARRAY_SIZE) */
/* Limit occurrence of element "http://www.w3.org/2000/09/xmldsig#":X509CRL from unbounded to 1 (see #define iso2X509DataType_X509CRL_ARRAY_SIZE) */
/* Limit occurrence of element "http://www.w3.org/2000/09/xmldsig#":SignatureProperty from unbounded to 1 (see #define iso2SignaturePropertiesType_SignatureProperty_ARRAY_SIZE) */
/* Limit occurrence of element "http://www.w3.org/2000/09/xmldsig#":Transform from unbounded to 1 (see #define iso2TransformsType_Transform_ARRAY_SIZE) */
/* Limit occurrence of element "urn:iso:15118:2:2016:MsgDataTypes":Sensor from 255 to 5 (see #define iso2SensorListType_Sensor_ARRAY_SIZE) */
/* Limit occurrence of element "http://www.w3.org/2000/09/xmldsig#":Reference from unbounded to 1 (see #define iso2ManifestType_Reference_ARRAY_SIZE) */
/* Limit occurrence of element "urn:iso:15118:2:2016:MsgDataTypes":SensorMeasurements from 255 to 5 (see #define iso2SensorPackageType_SensorMeasurements_ARRAY_SIZE) */
/* Limit occurrence of element "urn:iso:15118:2:2016:MsgDataTypes":ProfileEntry from unbounded to 24 (see #define iso2ChargingProfileType_ProfileEntry_ARRAY_SIZE) */
/* Limit occurrence of element "urn:iso:15118:2:2016:MsgDataTypes":SalesTariffEntry from unbounded to 5 (see #define iso2SalesTariffType_SalesTariffEntry_ARRAY_SIZE) */
/* Limit occurrence of element "http://www.w3.org/2000/09/xmldsig#":Reference from unbounded to 1 (see #define iso2SignedInfoType_Reference_ARRAY_SIZE) */
/* Limit occurrence of element "urn:iso:15118:2:2016:MsgDataTypes":MagneticVector from 255 to 5 (see #define iso2MagneticVectorListType_MagneticVector_ARRAY_SIZE) */
/* Limit occurrence of element "urn:iso:15118:2:2016:MsgDataTypes":ParameterSet from 255 to 5 (see #define iso2ServiceParameterListType_ParameterSet_ARRAY_SIZE) */
/* Limit occurrence of element "urn:iso:15118:2:2016:MsgDataTypes":PMaxScheduleEntry from unbounded to 5 (see #define iso2PMaxScheduleType_PMaxScheduleEntry_ARRAY_SIZE) */
/* Limit occurrence of element "urn:iso:15118:2:2016:MsgDataTypes":SensorPackage from 255 to 5 (see #define iso2SensorPackageListType_SensorPackage_ARRAY_SIZE) */
/* Limit occurrence of element "http://www.w3.org/2000/09/xmldsig#":KeyName from unbounded to 1 (see #define iso2KeyInfoType_KeyName_ARRAY_SIZE) */
/* Limit occurrence of element "http://www.w3.org/2000/09/xmldsig#":KeyValue from unbounded to 1 (see #define iso2KeyInfoType_KeyValue_ARRAY_SIZE) */
/* Limit occurrence of element "http://www.w3.org/2000/09/xmldsig#":RetrievalMethod from unbounded to 1 (see #define iso2KeyInfoType_RetrievalMethod_ARRAY_SIZE) */
/* Limit occurrence of element "http://www.w3.org/2000/09/xmldsig#":X509Data from unbounded to 1 (see #define iso2KeyInfoType_X509Data_ARRAY_SIZE) */
/* Limit occurrence of element "http://www.w3.org/2000/09/xmldsig#":PGPData from unbounded to 1 (see #define iso2KeyInfoType_PGPData_ARRAY_SIZE) */
/* Limit occurrence of element "http://www.w3.org/2000/09/xmldsig#":SPKIData from unbounded to 1 (see #define iso2KeyInfoType_SPKIData_ARRAY_SIZE) */
/* Limit occurrence of element "http://www.w3.org/2000/09/xmldsig#":MgmtData from unbounded to 1 (see #define iso2KeyInfoType_MgmtData_ARRAY_SIZE) */
/* Limit occurrence of element "http://www.w3.org/2000/09/xmldsig#":Object from unbounded to 1 (see #define iso2SignatureType_Object_ARRAY_SIZE) */


/* Complex type name='http://www.w3.org/2000/09/xmldsig#,RSAKeyValueType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("http://www.w3.org/2000/09/xmldsig#":Modulus,"http://www.w3.org/2000/09/xmldsig#":Exponent)',  derivedBy='RESTRICTION'.  */
#define iso2RSAKeyValueType_Modulus_BYTES_SIZE 350 
#define iso2RSAKeyValueType_Exponent_BYTES_SIZE 350 
struct iso2RSAKeyValueType {
	/* element: "http://www.w3.org/2000/09/xmldsig#":Modulus, http://www.w3.org/2000/09/xmldsig#,CryptoBinary */
	struct {
		uint8_t bytes[iso2RSAKeyValueType_Modulus_BYTES_SIZE];
		uint16_t bytesLen;
	}  Modulus ;
	/* element: "http://www.w3.org/2000/09/xmldsig#":Exponent, http://www.w3.org/2000/09/xmldsig#,CryptoBinary */
	struct {
		uint8_t bytes[iso2RSAKeyValueType_Exponent_BYTES_SIZE];
		uint16_t bytesLen;
	}  Exponent ;
};

/* Complex type name='urn:iso:15118:2:2016:MsgDataTypes,MeterInfoType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgDataTypes":MeterID,"urn:iso:15118:2:2016:MsgDataTypes":MeterReadingCharged{0-1},"urn:iso:15118:2:2016:MsgDataTypes":MeterReadingDischarged{0-1},"urn:iso:15118:2:2016:MsgDataTypes":SigMeterReading{0-1},"urn:iso:15118:2:2016:MsgDataTypes":MeterStatus{0-1},"urn:iso:15118:2:2016:MsgDataTypes":TMeter{0-1})',  derivedBy='RESTRICTION'.  */
#define iso2MeterInfoType_MeterID_CHARACTERS_SIZE 32 + EXTRA_CHAR /* XML schema facet maxLength for urn:iso:15118:2:2016:MsgDataTypes,meterIDType is 32 */
#define iso2MeterInfoType_SigMeterReading_BYTES_SIZE 64 /* XML schema facet maxLength for urn:iso:15118:2:2016:MsgDataTypes,sigMeterReadingType is 64 */
struct iso2MeterInfoType {
	/* element: "urn:iso:15118:2:2016:MsgDataTypes":MeterID, urn:iso:15118:2:2016:MsgDataTypes,meterIDType */
	struct {
		exi_string_character_t characters[iso2MeterInfoType_MeterID_CHARACTERS_SIZE];
		uint16_t charactersLen;
	}  MeterID ;
	/* element: "urn:iso:15118:2:2016:MsgDataTypes":MeterReadingCharged, http://www.w3.org/2001/XMLSchema,unsignedLong */
	uint64_t MeterReadingCharged ;
	unsigned int MeterReadingCharged_isUsed:1;
	/* element: "urn:iso:15118:2:2016:MsgDataTypes":MeterReadingDischarged, http://www.w3.org/2001/XMLSchema,unsignedLong */
	uint64_t MeterReadingDischarged ;
	unsigned int MeterReadingDischarged_isUsed:1;
	/* element: "urn:iso:15118:2:2016:MsgDataTypes":SigMeterReading, urn:iso:15118:2:2016:MsgDataTypes,sigMeterReadingType */
	struct {
		uint8_t bytes[iso2MeterInfoType_SigMeterReading_BYTES_SIZE];
		uint16_t bytesLen;
	}  SigMeterReading ;
	unsigned int SigMeterReading_isUsed:1;
	/* element: "urn:iso:15118:2:2016:MsgDataTypes":MeterStatus, urn:iso:15118:2:2016:MsgDataTypes,meterStatusType */
	int16_t MeterStatus ;
	unsigned int MeterStatus_isUsed:1;
	/* element: "urn:iso:15118:2:2016:MsgDataTypes":TMeter, http://www.w3.org/2001/XMLSchema,long */
	int64_t TMeter ;
	unsigned int TMeter_isUsed:1;
};

/* Complex type name='urn:iso:15118:2:2016:MsgDataTypes,ServiceType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgDataTypes":ServiceID,"urn:iso:15118:2:2016:MsgDataTypes":FreeService)',  derivedBy='RESTRICTION'.  */
struct iso2ServiceType {
	/* element: "urn:iso:15118:2:2016:MsgDataTypes":ServiceID, urn:iso:15118:2:2016:MsgDataTypes,serviceIDType */
	uint16_t ServiceID ;
	/* element: "urn:iso:15118:2:2016:MsgDataTypes":FreeService, http://www.w3.org/2001/XMLSchema,boolean */
	int FreeService ;
};

typedef enum {
	iso2vehicleSpaceType_AutoParking = 0,
	iso2vehicleSpaceType_MVGuideManual = 1,
	iso2vehicleSpaceType_Manual = 2
} iso2vehicleSpaceType;

/* Complex type name='urn:iso:15118:2:2016:MsgDataTypes,ServiceListType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgDataTypes":Service{1-8})',  derivedBy='RESTRICTION'.  */
#define iso2ServiceListType_Service_ARRAY_SIZE 8
struct iso2ServiceListType {
	/* element: "urn:iso:15118:2:2016:MsgDataTypes":Service, Complex type name='urn:iso:15118:2:2016:MsgDataTypes,ServiceType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgDataTypes":ServiceID,"urn:iso:15118:2:2016:MsgDataTypes":FreeService)',  derivedBy='RESTRICTION'.  */
	struct {
		struct iso2ServiceType array[iso2ServiceListType_Service_ARRAY_SIZE];
		uint16_t arrayLen;
	} Service;
};

typedef enum {
	iso2operationModeType_Ready = 0,
	iso2operationModeType_NotReady = 1
} iso2operationModeType;

/* Complex type name='urn:iso:15118:2:2016:MsgDataTypes,MagneticVectorSetupType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgDataTypes":GAID,"urn:iso:15118:2:2016:MsgDataTypes":FrequencyChannel)',  derivedBy='RESTRICTION'.  */
#define iso2MagneticVectorSetupType_GAID_CHARACTERS_SIZE 50 + EXTRA_CHAR 
struct iso2MagneticVectorSetupType {
	/* element: "urn:iso:15118:2:2016:MsgDataTypes":GAID, http://www.w3.org/2001/XMLSchema,ID */
	struct {
		exi_string_character_t characters[iso2MagneticVectorSetupType_GAID_CHARACTERS_SIZE];
		uint16_t charactersLen;
	}  GAID ;
	/* element: "urn:iso:15118:2:2016:MsgDataTypes":FrequencyChannel, http://www.w3.org/2001/XMLSchema,unsignedInt */
	uint32_t FrequencyChannel ;
};

/* Complex type name='urn:iso:15118:2:2016:MsgDataTypes,RelativeTimeIntervalType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgDataTypes":start,"urn:iso:15118:2:2016:MsgDataTypes":duration{0-1})',  derivedBy='RESTRICTION'.  */
struct iso2RelativeTimeIntervalType {
	/* element: "urn:iso:15118:2:2016:MsgDataTypes":start, urn:iso:15118:2:2016:MsgDataTypes,#AnonType_startRelativeTimeIntervalType */
	uint32_t start ;
	/* element: "urn:iso:15118:2:2016:MsgDataTypes":duration, urn:iso:15118:2:2016:MsgDataTypes,#AnonType_durationRelativeTimeIntervalType */
	uint32_t duration ;
	unsigned int duration_isUsed:1;
};

/* Complex type name='urn:iso:15118:2:2016:MsgDataTypes,EVFinePositioningParametersType',  base type name='anyType',  content type='EMPTY',  isAbstract='true',  hasTypeId='false',  final='0',  block='0',  derivedBy='RESTRICTION'.  */
struct iso2EVFinePositioningParametersType {
	int noContent; /* avoid warning */
};

/* Complex type name='http://www.w3.org/2000/09/xmldsig#,ObjectType',  base type name='anyType',  content type='MIXED',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='((WC[##any])){0-UNBOUNDED}',  derivedBy='RESTRICTION'.  */
#define iso2ObjectType_Id_CHARACTERS_SIZE 50 + EXTRA_CHAR 
#define iso2ObjectType_MimeType_CHARACTERS_SIZE 50 + EXTRA_CHAR 
#define iso2ObjectType_Encoding_CHARACTERS_SIZE 50 + EXTRA_CHAR 
#define iso2ObjectType_ANY_CHARACTERS_SIZE 50 + EXTRA_CHAR 
struct iso2ObjectType {
	/* attribute: Id {http://www.w3.org/2001/XMLSchema,ID} */
	struct {
		exi_string_character_t characters[iso2ObjectType_Id_CHARACTERS_SIZE];
		uint16_t charactersLen;
	}  Id ;
	unsigned int Id_isUsed:1;
	/* attribute: MimeType {http://www.w3.org/2001/XMLSchema,string} */
	struct {
		exi_string_character_t characters[iso2ObjectType_MimeType_CHARACTERS_SIZE];
		uint16_t charactersLen;
	}  MimeType ;
	unsigned int MimeType_isUsed:1;
	/* attribute: Encoding {http://www.w3.org/2001/XMLSchema,anyURI} */
	struct {
		exi_string_character_t characters[iso2ObjectType_Encoding_CHARACTERS_SIZE];
		uint16_t charactersLen;
	}  Encoding ;
	unsigned int Encoding_isUsed:1;
	/* element: WC[##any] */
	struct {
		exi_string_character_t characters[iso2ObjectType_ANY_CHARACTERS_SIZE];
		uint16_t charactersLen;
	}  ANY ;
	unsigned int ANY_isUsed:1;
};

/* Complex type name='urn:iso:15118:2:2016:MsgDataTypes,SensorOrderListType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgDataTypes":SensorPosition{1-255})',  derivedBy='RESTRICTION'.  */
#define iso2SensorOrderListType_SensorPosition_ARRAY_SIZE 5
struct iso2SensorOrderListType {
	/* element: "urn:iso:15118:2:2016:MsgDataTypes":SensorPosition, http://www.w3.org/2001/XMLSchema,unsignedByte */
	struct {
		uint8_t array[iso2SensorOrderListType_SensorPosition_ARRAY_SIZE];
		uint16_t arrayLen;
	} SensorPosition;
};

/* Complex type name='urn:iso:15118:2:2016:MsgDataTypes,MeasurementDataListType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgDataTypes":MeasurementData{1-255})',  derivedBy='RESTRICTION'.  */
#define iso2MeasurementDataListType_MeasurementData_ARRAY_SIZE 5
struct iso2MeasurementDataListType {
	/* element: "urn:iso:15118:2:2016:MsgDataTypes":MeasurementData, http://www.w3.org/2001/XMLSchema,unsignedShort */
	struct {
		uint16_t array[iso2MeasurementDataListType_MeasurementData_ARRAY_SIZE];
		uint16_t arrayLen;
	} MeasurementData;
};

/* Complex type name='http://www.w3.org/2000/09/xmldsig#,SignaturePropertyType',  base type name='anyType',  content type='MIXED',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='((WC[##other:"http://www.w3.org/2000/09/xmldsig#"])){1-UNBOUNDED}',  derivedBy='RESTRICTION'.  */
#define iso2SignaturePropertyType_Target_CHARACTERS_SIZE 50 + EXTRA_CHAR 
#define iso2SignaturePropertyType_Id_CHARACTERS_SIZE 50 + EXTRA_CHAR 
#define iso2SignaturePropertyType_ANY_CHARACTERS_SIZE 50 + EXTRA_CHAR 
struct iso2SignaturePropertyType {
	/* attribute: Target {http://www.w3.org/2001/XMLSchema,anyURI} */
	struct {
		exi_string_character_t characters[iso2SignaturePropertyType_Target_CHARACTERS_SIZE];
		uint16_t charactersLen;
	}  Target ;
	/* attribute: Id {http://www.w3.org/2001/XMLSchema,ID} */
	struct {
		exi_string_character_t characters[iso2SignaturePropertyType_Id_CHARACTERS_SIZE];
		uint16_t charactersLen;
	}  Id ;
	unsigned int Id_isUsed:1;
	/* element: WC[##other:"http://www.w3.org/2000/09/xmldsig#"] */
	struct {
		exi_string_character_t characters[iso2SignaturePropertyType_ANY_CHARACTERS_SIZE];
		uint16_t charactersLen;
	}  ANY ;
	unsigned int ANY_isUsed:1;
};

/* Complex type name='http://www.w3.org/2000/09/xmldsig#,TransformType',  base type name='anyType',  content type='MIXED',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='((WC[##other:"http://www.w3.org/2000/09/xmldsig#"])|"http://www.w3.org/2000/09/xmldsig#":XPath){0-UNBOUNDED}',  derivedBy='RESTRICTION'.  */
#define iso2TransformType_Algorithm_CHARACTERS_SIZE 65 + EXTRA_CHAR 
#define iso2TransformType_ANY_CHARACTERS_SIZE 50 + EXTRA_CHAR 
#define iso2TransformType_XPath_CHARACTERS_SIZE 50 + EXTRA_CHAR 
#define iso2TransformType_XPath_ARRAY_SIZE 1
struct iso2TransformType {
	/* attribute: Algorithm {http://www.w3.org/2001/XMLSchema,anyURI} */
	struct {
		exi_string_character_t characters[iso2TransformType_Algorithm_CHARACTERS_SIZE];
		uint16_t charactersLen;
	}  Algorithm ;
	/* element: WC[##other:"http://www.w3.org/2000/09/xmldsig#"] */
	struct {
		exi_string_character_t characters[iso2TransformType_ANY_CHARACTERS_SIZE];
		uint16_t charactersLen;
	}  ANY ;
	unsigned int ANY_isUsed:1;
	/* element: "http://www.w3.org/2000/09/xmldsig#":XPath, http://www.w3.org/2001/XMLSchema,string */
	struct {
		struct {
			exi_string_character_t characters[iso2TransformType_XPath_CHARACTERS_SIZE];
			uint16_t charactersLen;
		}  array[iso2TransformType_XPath_ARRAY_SIZE];
		uint16_t arrayLen;
	} XPath;
};

typedef enum {
	iso2EVSENotificationType_StopCharging = 0,
	iso2EVSENotificationType_ReNegotiation = 1
} iso2EVSENotificationType;

/* Complex type name='urn:iso:15118:2:2016:MsgDataTypes,EMAIDType',  base type name='eMAIDType',  content type='SIMPLE',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  derivedBy='EXTENSION'.  */
#define iso2EMAIDType_Id_CHARACTERS_SIZE 50 + EXTRA_CHAR 
#define iso2EMAIDType_CONTENT_CHARACTERS_SIZE 50 + EXTRA_CHAR 
struct iso2EMAIDType {
	/* attribute: Id {http://www.w3.org/2001/XMLSchema,ID} */
	struct {
		exi_string_character_t characters[iso2EMAIDType_Id_CHARACTERS_SIZE];
		uint16_t charactersLen;
	}  Id ;
	/* simple content: urn:iso:15118:2:2016:MsgDataTypes,eMAIDType */
	struct {
		exi_string_character_t characters[iso2EMAIDType_CONTENT_CHARACTERS_SIZE];
		uint16_t charactersLen;
	}  CONTENT ;
};

/* Complex type name='http://www.w3.org/2000/09/xmldsig#,DSAKeyValueType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='(("http://www.w3.org/2000/09/xmldsig#":P,"http://www.w3.org/2000/09/xmldsig#":Q){0-1},"http://www.w3.org/2000/09/xmldsig#":G{0-1},"http://www.w3.org/2000/09/xmldsig#":Y,"http://www.w3.org/2000/09/xmldsig#":J{0-1},("http://www.w3.org/2000/09/xmldsig#":Seed,"http://www.w3.org/2000/09/xmldsig#":PgenCounter){0-1})',  derivedBy='RESTRICTION'.  */
#define iso2DSAKeyValueType_P_BYTES_SIZE 350 
#define iso2DSAKeyValueType_Q_BYTES_SIZE 350 
#define iso2DSAKeyValueType_G_BYTES_SIZE 350 
#define iso2DSAKeyValueType_Y_BYTES_SIZE 350 
#define iso2DSAKeyValueType_J_BYTES_SIZE 350 
#define iso2DSAKeyValueType_Seed_BYTES_SIZE 350 
#define iso2DSAKeyValueType_PgenCounter_BYTES_SIZE 350 
struct iso2DSAKeyValueType {
	/* element: "http://www.w3.org/2000/09/xmldsig#":P, http://www.w3.org/2000/09/xmldsig#,CryptoBinary */
	struct {
		uint8_t bytes[iso2DSAKeyValueType_P_BYTES_SIZE];
		uint16_t bytesLen;
	}  P ;
	unsigned int P_isUsed:1;
	/* element: "http://www.w3.org/2000/09/xmldsig#":Q, http://www.w3.org/2000/09/xmldsig#,CryptoBinary */
	struct {
		uint8_t bytes[iso2DSAKeyValueType_Q_BYTES_SIZE];
		uint16_t bytesLen;
	}  Q ;
	unsigned int Q_isUsed:1;
	/* element: "http://www.w3.org/2000/09/xmldsig#":G, http://www.w3.org/2000/09/xmldsig#,CryptoBinary */
	struct {
		uint8_t bytes[iso2DSAKeyValueType_G_BYTES_SIZE];
		uint16_t bytesLen;
	}  G ;
	unsigned int G_isUsed:1;
	/* element: "http://www.w3.org/2000/09/xmldsig#":Y, http://www.w3.org/2000/09/xmldsig#,CryptoBinary */
	struct {
		uint8_t bytes[iso2DSAKeyValueType_Y_BYTES_SIZE];
		uint16_t bytesLen;
	}  Y ;
	/* element: "http://www.w3.org/2000/09/xmldsig#":J, http://www.w3.org/2000/09/xmldsig#,CryptoBinary */
	struct {
		uint8_t bytes[iso2DSAKeyValueType_J_BYTES_SIZE];
		uint16_t bytesLen;
	}  J ;
	unsigned int J_isUsed:1;
	/* element: "http://www.w3.org/2000/09/xmldsig#":Seed, http://www.w3.org/2000/09/xmldsig#,CryptoBinary */
	struct {
		uint8_t bytes[iso2DSAKeyValueType_Seed_BYTES_SIZE];
		uint16_t bytesLen;
	}  Seed ;
	unsigned int Seed_isUsed:1;
	/* element: "http://www.w3.org/2000/09/xmldsig#":PgenCounter, http://www.w3.org/2000/09/xmldsig#,CryptoBinary */
	struct {
		uint8_t bytes[iso2DSAKeyValueType_PgenCounter_BYTES_SIZE];
		uint16_t bytesLen;
	}  PgenCounter ;
	unsigned int PgenCounter_isUsed:1;
};

/* Complex type name='urn:iso:15118:2:2016:MsgDataTypes,EntryType',  base type name='anyType',  content type='ELEMENT',  isAbstract='true',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgDataTypes":RelativeTimeInterval)',  derivedBy='RESTRICTION'.  */
struct iso2EntryType {
	/* element: "urn:iso:15118:2:2016:MsgDataTypes":RelativeTimeInterval, Complex type name='urn:iso:15118:2:2016:MsgDataTypes,RelativeTimeIntervalType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgDataTypes":start,"urn:iso:15118:2:2016:MsgDataTypes":duration{0-1})',  derivedBy='RESTRICTION'.  */
	struct iso2RelativeTimeIntervalType RelativeTimeInterval ;
};

typedef enum {
	iso2valueType_bool = 0,
	iso2valueType_byte = 1,
	iso2valueType_short = 2,
	iso2valueType_int = 3,
	iso2valueType_physicalValue = 4,
	iso2valueType_string = 5
} iso2valueType;

/* Complex type name='urn:iso:15118:2:2016:MsgBody,V2GRequestType',  base type name='anyType',  content type='EMPTY',  isAbstract='true',  hasTypeId='false',  final='0',  block='0',  derivedBy='RESTRICTION'.  */
struct iso2V2GRequestType {
	int noContent; /* avoid warning */
};

/* Complex type name='urn:iso:15118:2:2016:MsgDataTypes,EVSEEnergyTransferParameterType',  base type name='anyType',  content type='EMPTY',  isAbstract='true',  hasTypeId='false',  final='0',  block='0',  derivedBy='RESTRICTION'.  */
struct iso2EVSEEnergyTransferParameterType {
	int noContent; /* avoid warning */
};

/* Complex type name='urn:iso:15118:2:2016:MsgBody,MeteringReceiptReqType',  base type name='BodyBaseType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgBody":SessionID,"urn:iso:15118:2:2016:MsgBody":SAScheduleTupleID{0-1},"urn:iso:15118:2:2016:MsgBody":MeterInfo)',  derivedBy='EXTENSION'.  */
#define iso2MeteringReceiptReqType_Id_CHARACTERS_SIZE 50 + EXTRA_CHAR 
#define iso2MeteringReceiptReqType_SessionID_BYTES_SIZE 8 /* XML schema facet maxLength for urn:iso:15118:2:2016:MsgDataTypes,sessionIDType is 8 */
struct iso2MeteringReceiptReqType {
	/* attribute: Id {http://www.w3.org/2001/XMLSchema,ID} */
	struct {
		exi_string_character_t characters[iso2MeteringReceiptReqType_Id_CHARACTERS_SIZE];
		uint16_t charactersLen;
	}  Id ;
	/* element: "urn:iso:15118:2:2016:MsgBody":SessionID, urn:iso:15118:2:2016:MsgDataTypes,sessionIDType */
	struct {
		uint8_t bytes[iso2MeteringReceiptReqType_SessionID_BYTES_SIZE];
		uint16_t bytesLen;
	}  SessionID ;
	/* element: "urn:iso:15118:2:2016:MsgBody":SAScheduleTupleID, urn:iso:15118:2:2016:MsgDataTypes,SAIDType */
	uint8_t SAScheduleTupleID ;
	unsigned int SAScheduleTupleID_isUsed:1;
	/* element: "urn:iso:15118:2:2016:MsgBody":MeterInfo, Complex type name='urn:iso:15118:2:2016:MsgDataTypes,MeterInfoType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgDataTypes":MeterID,"urn:iso:15118:2:2016:MsgDataTypes":MeterReadingCharged{0-1},"urn:iso:15118:2:2016:MsgDataTypes":MeterReadingDischarged{0-1},"urn:iso:15118:2:2016:MsgDataTypes":SigMeterReading{0-1},"urn:iso:15118:2:2016:MsgDataTypes":MeterStatus{0-1},"urn:iso:15118:2:2016:MsgDataTypes":TMeter{0-1})',  derivedBy='RESTRICTION'.  */
	struct iso2MeterInfoType MeterInfo ;
};

/* Complex type name='http://www.w3.org/2000/09/xmldsig#,KeyValueType',  base type name='anyType',  content type='MIXED',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("http://www.w3.org/2000/09/xmldsig#":DSAKeyValue|"http://www.w3.org/2000/09/xmldsig#":RSAKeyValue|(WC[##other:"http://www.w3.org/2000/09/xmldsig#"]))',  derivedBy='RESTRICTION'.  */
#define iso2KeyValueType_ANY_CHARACTERS_SIZE 50 + EXTRA_CHAR 
struct iso2KeyValueType {
	/* element: "http://www.w3.org/2000/09/xmldsig#":DSAKeyValue, Complex type name='http://www.w3.org/2000/09/xmldsig#,DSAKeyValueType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='(("http://www.w3.org/2000/09/xmldsig#":P,"http://www.w3.org/2000/09/xmldsig#":Q){0-1},"http://www.w3.org/2000/09/xmldsig#":G{0-1},"http://www.w3.org/2000/09/xmldsig#":Y,"http://www.w3.org/2000/09/xmldsig#":J{0-1},("http://www.w3.org/2000/09/xmldsig#":Seed,"http://www.w3.org/2000/09/xmldsig#":PgenCounter){0-1})',  derivedBy='RESTRICTION'.  */
	struct iso2DSAKeyValueType DSAKeyValue ;
	unsigned int DSAKeyValue_isUsed:1;
	/* element: "http://www.w3.org/2000/09/xmldsig#":RSAKeyValue, Complex type name='http://www.w3.org/2000/09/xmldsig#,RSAKeyValueType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("http://www.w3.org/2000/09/xmldsig#":Modulus,"http://www.w3.org/2000/09/xmldsig#":Exponent)',  derivedBy='RESTRICTION'.  */
	struct iso2RSAKeyValueType RSAKeyValue ;
	unsigned int RSAKeyValue_isUsed:1;
	/* element: WC[##other:"http://www.w3.org/2000/09/xmldsig#"] */
	struct {
		exi_string_character_t characters[iso2KeyValueType_ANY_CHARACTERS_SIZE];
		uint16_t charactersLen;
	}  ANY ;
	unsigned int ANY_isUsed:1;
};

typedef enum {
	iso2EVCheckInStatusType_CheckIn = 0,
	iso2EVCheckInStatusType_Processing = 1,
	iso2EVCheckInStatusType_Completed = 2
} iso2EVCheckInStatusType;

typedef enum {
	iso2mechanicalChargingDeviceStatusType_Home = 0,
	iso2mechanicalChargingDeviceStatusType_Moving = 1,
	iso2mechanicalChargingDeviceStatusType_EndPosition = 2
} iso2mechanicalChargingDeviceStatusType;

/* Complex type name='urn:iso:15118:2:2016:MsgBody,BodyBaseType',  base type name='anyType',  content type='EMPTY',  isAbstract='true',  hasTypeId='false',  final='0',  block='0',  derivedBy='RESTRICTION'.  */
struct iso2BodyBaseType {
	int noContent; /* avoid warning */
};

/* Complex type name='urn:iso:15118:2:2016:MsgBody,AuthorizationReqType',  base type name='BodyBaseType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgBody":GenChallenge{0-1})',  derivedBy='EXTENSION'.  */
#define iso2AuthorizationReqType_Id_CHARACTERS_SIZE 50 + EXTRA_CHAR 
#define iso2AuthorizationReqType_GenChallenge_BYTES_SIZE 16 /* XML schema facet length for urn:iso:15118:2:2016:MsgDataTypes,genChallengeType is 16 */
struct iso2AuthorizationReqType {
	/* attribute: Id {http://www.w3.org/2001/XMLSchema,ID} */
	struct {
		exi_string_character_t characters[iso2AuthorizationReqType_Id_CHARACTERS_SIZE];
		uint16_t charactersLen;
	}  Id ;
	unsigned int Id_isUsed:1;
	/* element: "urn:iso:15118:2:2016:MsgBody":GenChallenge, urn:iso:15118:2:2016:MsgDataTypes,genChallengeType */
	struct {
		uint8_t bytes[iso2AuthorizationReqType_GenChallenge_BYTES_SIZE];
		uint16_t bytesLen;
	}  GenChallenge ;
	unsigned int GenChallenge_isUsed:1;
};

/* Complex type name='http://www.w3.org/2000/09/xmldsig#,SPKIDataType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("http://www.w3.org/2000/09/xmldsig#":SPKISexp,(WC[##other:"http://www.w3.org/2000/09/xmldsig#"]){0-1}){1-UNBOUNDED}',  derivedBy='RESTRICTION'.  */
#define iso2SPKIDataType_SPKISexp_BYTES_SIZE 350 
#define iso2SPKIDataType_SPKISexp_ARRAY_SIZE 1
#define iso2SPKIDataType_ANY_CHARACTERS_SIZE 50 + EXTRA_CHAR 
struct iso2SPKIDataType {
	/* element: "http://www.w3.org/2000/09/xmldsig#":SPKISexp, http://www.w3.org/2001/XMLSchema,base64Binary */
	struct {
		struct {
			uint8_t bytes[iso2SPKIDataType_SPKISexp_BYTES_SIZE];
			uint16_t bytesLen;
		}  array[iso2SPKIDataType_SPKISexp_ARRAY_SIZE];
		uint16_t arrayLen;
	} SPKISexp;
	/* element: WC[##other:"http://www.w3.org/2000/09/xmldsig#"] */
	struct {
		exi_string_character_t characters[iso2SPKIDataType_ANY_CHARACTERS_SIZE];
		uint16_t charactersLen;
	}  ANY ;
	unsigned int ANY_isUsed:1;
};

/* Complex type name='http://www.w3.org/2000/09/xmldsig#,SignatureMethodType',  base type name='anyType',  content type='MIXED',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("http://www.w3.org/2000/09/xmldsig#":HMACOutputLength{0-1},(WC[##other:"http://www.w3.org/2000/09/xmldsig#"]){0-UNBOUNDED})',  derivedBy='RESTRICTION'.  */
#define iso2SignatureMethodType_Algorithm_CHARACTERS_SIZE 65 + EXTRA_CHAR 
#define iso2SignatureMethodType_ANY_CHARACTERS_SIZE 50 + EXTRA_CHAR 
struct iso2SignatureMethodType {
	/* attribute: Algorithm {http://www.w3.org/2001/XMLSchema,anyURI} */
	struct {
		exi_string_character_t characters[iso2SignatureMethodType_Algorithm_CHARACTERS_SIZE];
		uint16_t charactersLen;
	}  Algorithm ;
	/* element: "http://www.w3.org/2000/09/xmldsig#":HMACOutputLength, http://www.w3.org/2000/09/xmldsig#,HMACOutputLengthType */
	int64_t HMACOutputLength ;
	unsigned int HMACOutputLength_isUsed:1;
	/* element: WC[##other:"http://www.w3.org/2000/09/xmldsig#"] */
	struct {
		exi_string_character_t characters[iso2SignatureMethodType_ANY_CHARACTERS_SIZE];
		uint16_t charactersLen;
	}  ANY ;
	unsigned int ANY_isUsed:1;
};

/* Complex type name='urn:iso:15118:2:2016:MsgBody,WeldingDetectionReqType',  base type name='BodyBaseType',  content type='EMPTY',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  derivedBy='EXTENSION'.  */
struct iso2WeldingDetectionReqType {
	int noContent; /* avoid warning */
};

/* Complex type name='urn:iso:15118:2:2016:MsgBody,SessionSetupReqType',  base type name='BodyBaseType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgBody":EVCCID)',  derivedBy='EXTENSION'.  */
#define iso2SessionSetupReqType_EVCCID_BYTES_SIZE 6 /* XML schema facet maxLength for urn:iso:15118:2:2016:MsgDataTypes,evccIDType is 6 */
struct iso2SessionSetupReqType {
	/* element: "urn:iso:15118:2:2016:MsgBody":EVCCID, urn:iso:15118:2:2016:MsgDataTypes,evccIDType */
	struct {
		uint8_t bytes[iso2SessionSetupReqType_EVCCID_BYTES_SIZE];
		uint16_t bytesLen;
	}  EVCCID ;
};

typedef enum {
	iso2chargeProgressType_Start = 0,
	iso2chargeProgressType_Stop = 1,
	iso2chargeProgressType_Renegotiate = 2
} iso2chargeProgressType;

/* Complex type name='http://www.w3.org/2000/09/xmldsig#,CanonicalizationMethodType',  base type name='anyType',  content type='MIXED',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='((WC[##any]){0-UNBOUNDED})',  derivedBy='RESTRICTION'.  */
#define iso2CanonicalizationMethodType_Algorithm_CHARACTERS_SIZE 65 + EXTRA_CHAR 
#define iso2CanonicalizationMethodType_ANY_CHARACTERS_SIZE 50 + EXTRA_CHAR 
struct iso2CanonicalizationMethodType {
	/* attribute: Algorithm {http://www.w3.org/2001/XMLSchema,anyURI} */
	struct {
		exi_string_character_t characters[iso2CanonicalizationMethodType_Algorithm_CHARACTERS_SIZE];
		uint16_t charactersLen;
	}  Algorithm ;
	/* element: WC[##any] */
	struct {
		exi_string_character_t characters[iso2CanonicalizationMethodType_ANY_CHARACTERS_SIZE];
		uint16_t charactersLen;
	}  ANY ;
	unsigned int ANY_isUsed:1;
};

/* Complex type name='urn:iso:15118:2:2016:MsgDataTypes,PhysicalValueType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgDataTypes":Exponent,"urn:iso:15118:2:2016:MsgDataTypes":Value)',  derivedBy='RESTRICTION'.  */
struct iso2PhysicalValueType {
	/* element: "urn:iso:15118:2:2016:MsgDataTypes":Exponent, urn:iso:15118:2:2016:MsgDataTypes,exponentType */
	int8_t Exponent ;
	/* element: "urn:iso:15118:2:2016:MsgDataTypes":Value, http://www.w3.org/2001/XMLSchema,short */
	int16_t Value ;
};

/* Complex type name='urn:iso:15118:2:2016:MsgBody,SystemStatusReqType',  base type name='BodyBaseType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgBody":OperationMode,"urn:iso:15118:2:2016:MsgBody":EVMechanicalChargingDeviceStatus)',  derivedBy='EXTENSION'.  */
struct iso2SystemStatusReqType {
	/* element: "urn:iso:15118:2:2016:MsgBody":OperationMode, urn:iso:15118:2:2016:MsgDataTypes,operationModeType */
	iso2operationModeType OperationMode ;
	/* element: "urn:iso:15118:2:2016:MsgBody":EVMechanicalChargingDeviceStatus, urn:iso:15118:2:2016:MsgDataTypes,mechanicalChargingDeviceStatusType */
	iso2mechanicalChargingDeviceStatusType EVMechanicalChargingDeviceStatus ;
};

/* Complex type name='urn:iso:15118:2:2016:MsgDataTypes,EVSEFinePositioningSetupParametersType',  base type name='anyType',  content type='EMPTY',  isAbstract='true',  hasTypeId='false',  final='0',  block='0',  derivedBy='RESTRICTION'.  */
struct iso2EVSEFinePositioningSetupParametersType {
	int noContent; /* avoid warning */
};

/* Complex type name='urn:iso:15118:2:2016:MsgDataTypes,EVSEFinePositioningParametersType',  base type name='anyType',  content type='EMPTY',  isAbstract='true',  hasTypeId='false',  final='0',  block='0',  derivedBy='RESTRICTION'.  */
struct iso2EVSEFinePositioningParametersType {
	int noContent; /* avoid warning */
};

typedef enum {
	iso2FODStatusType_ObjectOnPad = 0,
	iso2FODStatusType_PadClear = 1,
	iso2FODStatusType_UnknownError = 2
} iso2FODStatusType;

typedef enum {
	iso2costKindType_relativePricePercentage = 0,
	iso2costKindType_RenewableGenerationPercentage = 1,
	iso2costKindType_CarbonDioxideEmission = 2
} iso2costKindType;

/* Complex type name='http://www.w3.org/2000/09/xmldsig#,DigestMethodType',  base type name='anyType',  content type='MIXED',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='((WC[##other:"http://www.w3.org/2000/09/xmldsig#"]){0-UNBOUNDED})',  derivedBy='RESTRICTION'.  */
#define iso2DigestMethodType_Algorithm_CHARACTERS_SIZE 65 + EXTRA_CHAR 
#define iso2DigestMethodType_ANY_CHARACTERS_SIZE 50 + EXTRA_CHAR 
struct iso2DigestMethodType {
	/* attribute: Algorithm {http://www.w3.org/2001/XMLSchema,anyURI} */
	struct {
		exi_string_character_t characters[iso2DigestMethodType_Algorithm_CHARACTERS_SIZE];
		uint16_t charactersLen;
	}  Algorithm ;
	/* element: WC[##other:"http://www.w3.org/2000/09/xmldsig#"] */
	struct {
		exi_string_character_t characters[iso2DigestMethodType_ANY_CHARACTERS_SIZE];
		uint16_t charactersLen;
	}  ANY ;
	unsigned int ANY_isUsed:1;
};

/* Complex type name='urn:iso:15118:2:2016:MsgDataTypes,TargetPositionType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgDataTypes":TargetOffsetX,"urn:iso:15118:2:2016:MsgDataTypes":TargetOffsetY)',  derivedBy='RESTRICTION'.  */
struct iso2TargetPositionType {
	/* element: "urn:iso:15118:2:2016:MsgDataTypes":TargetOffsetX, http://www.w3.org/2001/XMLSchema,unsignedShort */
	uint16_t TargetOffsetX ;
	/* element: "urn:iso:15118:2:2016:MsgDataTypes":TargetOffsetY, http://www.w3.org/2001/XMLSchema,unsignedShort */
	uint16_t TargetOffsetY ;
};

typedef enum {
	iso2EVOperationType_Charge = 0,
	iso2EVOperationType_BPT = 1
} iso2EVOperationType;

/* Complex type name='urn:iso:15118:2:2016:MsgDataTypes,DC_EVChargeParameterType',  base type name='EVEnergyTransferParameterType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='(("urn:iso:15118:2:2016:MsgDataTypes":DepartureTime),("urn:iso:15118:2:2016:MsgDataTypes":EVMaximumChargePower{0-1},"urn:iso:15118:2:2016:MsgDataTypes":EVMinimumChargePower{0-1},"urn:iso:15118:2:2016:MsgDataTypes":EVMaximumChargeCurrent,"urn:iso:15118:2:2016:MsgDataTypes":EVMinimumChargeCurrent,"urn:iso:15118:2:2016:MsgDataTypes":EVMaximumVoltage,"urn:iso:15118:2:2016:MsgDataTypes":EVTargetEnergyRequest{0-1},"urn:iso:15118:2:2016:MsgDataTypes":EVMaximumEnergyRequest{0-1},"urn:iso:15118:2:2016:MsgDataTypes":EVMinimumEnergyRequest{0-1},"urn:iso:15118:2:2016:MsgDataTypes":CurrentSOC{0-1},"urn:iso:15118:2:2016:MsgDataTypes":TargetSOC{0-1},"urn:iso:15118:2:2016:MsgDataTypes":BulkSOC{0-1}))',  derivedBy='EXTENSION'.  */
struct iso2DC_EVChargeParameterType {
	/* element: "urn:iso:15118:2:2016:MsgDataTypes":DepartureTime, http://www.w3.org/2001/XMLSchema,unsignedInt */
	uint32_t DepartureTime ;
	/* element: "urn:iso:15118:2:2016:MsgDataTypes":EVMaximumChargePower, Complex type name='urn:iso:15118:2:2016:MsgDataTypes,PhysicalValueType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgDataTypes":Exponent,"urn:iso:15118:2:2016:MsgDataTypes":Value)',  derivedBy='RESTRICTION'.  */
	struct iso2PhysicalValueType EVMaximumChargePower ;
	unsigned int EVMaximumChargePower_isUsed:1;
	/* element: "urn:iso:15118:2:2016:MsgDataTypes":EVMinimumChargePower, Complex type name='urn:iso:15118:2:2016:MsgDataTypes,PhysicalValueType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgDataTypes":Exponent,"urn:iso:15118:2:2016:MsgDataTypes":Value)',  derivedBy='RESTRICTION'.  */
	struct iso2PhysicalValueType EVMinimumChargePower ;
	unsigned int EVMinimumChargePower_isUsed:1;
	/* element: "urn:iso:15118:2:2016:MsgDataTypes":EVMaximumChargeCurrent, Complex type name='urn:iso:15118:2:2016:MsgDataTypes,PhysicalValueType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgDataTypes":Exponent,"urn:iso:15118:2:2016:MsgDataTypes":Value)',  derivedBy='RESTRICTION'.  */
	struct iso2PhysicalValueType EVMaximumChargeCurrent ;
	/* element: "urn:iso:15118:2:2016:MsgDataTypes":EVMinimumChargeCurrent, Complex type name='urn:iso:15118:2:2016:MsgDataTypes,PhysicalValueType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgDataTypes":Exponent,"urn:iso:15118:2:2016:MsgDataTypes":Value)',  derivedBy='RESTRICTION'.  */
	struct iso2PhysicalValueType EVMinimumChargeCurrent ;
	/* element: "urn:iso:15118:2:2016:MsgDataTypes":EVMaximumVoltage, Complex type name='urn:iso:15118:2:2016:MsgDataTypes,PhysicalValueType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgDataTypes":Exponent,"urn:iso:15118:2:2016:MsgDataTypes":Value)',  derivedBy='RESTRICTION'.  */
	struct iso2PhysicalValueType EVMaximumVoltage ;
	/* element: "urn:iso:15118:2:2016:MsgDataTypes":EVTargetEnergyRequest, Complex type name='urn:iso:15118:2:2016:MsgDataTypes,PhysicalValueType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgDataTypes":Exponent,"urn:iso:15118:2:2016:MsgDataTypes":Value)',  derivedBy='RESTRICTION'.  */
	struct iso2PhysicalValueType EVTargetEnergyRequest ;
	unsigned int EVTargetEnergyRequest_isUsed:1;
	/* element: "urn:iso:15118:2:2016:MsgDataTypes":EVMaximumEnergyRequest, Complex type name='urn:iso:15118:2:2016:MsgDataTypes,PhysicalValueType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgDataTypes":Exponent,"urn:iso:15118:2:2016:MsgDataTypes":Value)',  derivedBy='RESTRICTION'.  */
	struct iso2PhysicalValueType EVMaximumEnergyRequest ;
	unsigned int EVMaximumEnergyRequest_isUsed:1;
	/* element: "urn:iso:15118:2:2016:MsgDataTypes":EVMinimumEnergyRequest, Complex type name='urn:iso:15118:2:2016:MsgDataTypes,PhysicalValueType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgDataTypes":Exponent,"urn:iso:15118:2:2016:MsgDataTypes":Value)',  derivedBy='RESTRICTION'.  */
	struct iso2PhysicalValueType EVMinimumEnergyRequest ;
	unsigned int EVMinimumEnergyRequest_isUsed:1;
	/* element: "urn:iso:15118:2:2016:MsgDataTypes":CurrentSOC, urn:iso:15118:2:2016:MsgDataTypes,percentValueType */
	int8_t CurrentSOC ;
	unsigned int CurrentSOC_isUsed:1;
	/* element: "urn:iso:15118:2:2016:MsgDataTypes":TargetSOC, urn:iso:15118:2:2016:MsgDataTypes,percentValueType */
	int8_t TargetSOC ;
	unsigned int TargetSOC_isUsed:1;
	/* element: "urn:iso:15118:2:2016:MsgDataTypes":BulkSOC, urn:iso:15118:2:2016:MsgDataTypes,percentValueType */
	int8_t BulkSOC ;
	unsigned int BulkSOC_isUsed:1;
};

/* Complex type name='urn:iso:15118:2:2016:MsgBody,ServiceDetailReqType',  base type name='BodyBaseType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgBody":ServiceID)',  derivedBy='EXTENSION'.  */
struct iso2ServiceDetailReqType {
	/* element: "urn:iso:15118:2:2016:MsgBody":ServiceID, urn:iso:15118:2:2016:MsgDataTypes,serviceIDType */
	uint16_t ServiceID ;
};

/* Complex type name='urn:iso:15118:2:2016:MsgBody,PreChargeReqType',  base type name='BodyBaseType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgBody":EVTargetVoltage,"urn:iso:15118:2:2016:MsgBody":EVTargetCurrent)',  derivedBy='EXTENSION'.  */
struct iso2PreChargeReqType {
	/* element: "urn:iso:15118:2:2016:MsgBody":EVTargetVoltage, Complex type name='urn:iso:15118:2:2016:MsgDataTypes,PhysicalValueType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgDataTypes":Exponent,"urn:iso:15118:2:2016:MsgDataTypes":Value)',  derivedBy='RESTRICTION'.  */
	struct iso2PhysicalValueType EVTargetVoltage ;
	/* element: "urn:iso:15118:2:2016:MsgBody":EVTargetCurrent, Complex type name='urn:iso:15118:2:2016:MsgDataTypes,PhysicalValueType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgDataTypes":Exponent,"urn:iso:15118:2:2016:MsgDataTypes":Value)',  derivedBy='RESTRICTION'.  */
	struct iso2PhysicalValueType EVTargetCurrent ;
};

typedef enum {
	iso2serviceCategoryType_EVCharging = 0,
	iso2serviceCategoryType_Internet = 1,
	iso2serviceCategoryType_ContractCertificate = 2,
	iso2serviceCategoryType_OtherCustom = 3
} iso2serviceCategoryType;

/* Complex type name='urn:iso:15118:2:2016:MsgDataTypes,CartesianCoordinatesType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgDataTypes":XCoordinate,"urn:iso:15118:2:2016:MsgDataTypes":YCoordinate,"urn:iso:15118:2:2016:MsgDataTypes":ZCoordinate)',  derivedBy='RESTRICTION'.  */
struct iso2CartesianCoordinatesType {
	/* element: "urn:iso:15118:2:2016:MsgDataTypes":XCoordinate, http://www.w3.org/2001/XMLSchema,short */
	int16_t XCoordinate ;
	/* element: "urn:iso:15118:2:2016:MsgDataTypes":YCoordinate, http://www.w3.org/2001/XMLSchema,short */
	int16_t YCoordinate ;
	/* element: "urn:iso:15118:2:2016:MsgDataTypes":ZCoordinate, http://www.w3.org/2001/XMLSchema,short */
	int16_t ZCoordinate ;
};

/* Complex type name='urn:iso:15118:2:2016:MsgDataTypes,SubCertificatesType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgDataTypes":Certificate{1-4})',  derivedBy='RESTRICTION'.  */
#define iso2SubCertificatesType_Certificate_BYTES_SIZE 800 /* XML schema facet maxLength for urn:iso:15118:2:2016:MsgDataTypes,certificateType is 800 */
#define iso2SubCertificatesType_Certificate_ARRAY_SIZE 4
struct iso2SubCertificatesType {
	/* element: "urn:iso:15118:2:2016:MsgDataTypes":Certificate, urn:iso:15118:2:2016:MsgDataTypes,certificateType */
	struct {
		struct {
		uint8_t bytes[iso2SubCertificatesType_Certificate_BYTES_SIZE];
		uint16_t bytesLen;
	}  array[iso2SubCertificatesType_Certificate_ARRAY_SIZE];
		uint16_t arrayLen;
	} Certificate;
};

typedef enum {
	iso2parkingMethodType_AutoParking = 0,
	iso2parkingMethodType_MVGuideManual = 1,
	iso2parkingMethodType_Manual = 2
} iso2parkingMethodType;

/* Complex type name='urn:iso:15118:2:2016:MsgDataTypes,EVEnergyTransferParameterType',  base type name='anyType',  content type='ELEMENT',  isAbstract='true',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgDataTypes":DepartureTime)',  derivedBy='RESTRICTION'.  */
struct iso2EVEnergyTransferParameterType {
	/* element: "urn:iso:15118:2:2016:MsgDataTypes":DepartureTime, http://www.w3.org/2001/XMLSchema,unsignedInt */
	uint32_t DepartureTime ;
};

/* Complex type name='urn:iso:15118:2:2016:MsgDataTypes,ContractSignatureEncryptedPrivateKeyType',  base type name='encryptedPrivateKeyType',  content type='SIMPLE',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  derivedBy='EXTENSION'.  */
#define iso2ContractSignatureEncryptedPrivateKeyType_Id_CHARACTERS_SIZE 50 + EXTRA_CHAR 
#define iso2ContractSignatureEncryptedPrivateKeyType_CONTENT_BYTES_SIZE 350
struct iso2ContractSignatureEncryptedPrivateKeyType {
	/* attribute: Id {http://www.w3.org/2001/XMLSchema,ID} */
	struct {
		exi_string_character_t characters[iso2ContractSignatureEncryptedPrivateKeyType_Id_CHARACTERS_SIZE];
		uint16_t charactersLen;
	}  Id ;
	/* simple content: urn:iso:15118:2:2016:MsgDataTypes,encryptedPrivateKeyType */
	struct {
		uint8_t bytes[iso2ContractSignatureEncryptedPrivateKeyType_CONTENT_BYTES_SIZE];
		uint16_t bytesLen;
	}  CONTENT ;
};

/* Complex type name='urn:iso:15118:2:2016:MsgDataTypes,MagneticVectorSetupListType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgDataTypes":MagneticVectorSetup{1-255})',  derivedBy='RESTRICTION'.  */
#define iso2MagneticVectorSetupListType_MagneticVectorSetup_ARRAY_SIZE 5
struct iso2MagneticVectorSetupListType {
	/* element: "urn:iso:15118:2:2016:MsgDataTypes":MagneticVectorSetup, Complex type name='urn:iso:15118:2:2016:MsgDataTypes,MagneticVectorSetupType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgDataTypes":GAID,"urn:iso:15118:2:2016:MsgDataTypes":FrequencyChannel)',  derivedBy='RESTRICTION'.  */
	struct {
		struct iso2MagneticVectorSetupType array[iso2MagneticVectorSetupListType_MagneticVectorSetup_ARRAY_SIZE];
		uint16_t arrayLen;
	} MagneticVectorSetup;
};

typedef enum {
	iso2responseCodeType_OK = 0,
	iso2responseCodeType_OK_NewSessionEstablished = 1,
	iso2responseCodeType_OK_OldSessionJoined = 2,
	iso2responseCodeType_OK_CertificateExpiresSoon = 3,
	iso2responseCodeType_OK_IsolationValid = 4,
	iso2responseCodeType_OK_IsolationWarning = 5,
	iso2responseCodeType_WARNING_CertificateExpired = 6,
	iso2responseCodeType_WARNING_NoCertificateAvailable = 7,
	iso2responseCodeType_WARNING_CertValidationError = 8,
	iso2responseCodeType_WARNING_CertVerificationError = 9,
	iso2responseCodeType_WARNING_ContractCanceled = 10,
	iso2responseCodeType_FAILED = 11,
	iso2responseCodeType_FAILED_SequenceError = 12,
	iso2responseCodeType_FAILED_ServiceIDInvalid = 13,
	iso2responseCodeType_FAILED_UnknownSession = 14,
	iso2responseCodeType_FAILED_ServiceSelectionInvalid = 15,
	iso2responseCodeType_FAILED_SignatureError = 16,
	iso2responseCodeType_FAILED_PaymentSelectionInvalid = 17,
	iso2responseCodeType_FAILED_ChallengeInvalid = 18,
	iso2responseCodeType_FAILED_WrongChargeParameter = 19,
	iso2responseCodeType_FAILED_IsolationFault = 20,
	iso2responseCodeType_FAILED_PowerDeliveryNotApplied = 21,
	iso2responseCodeType_FAILED_TariffSelectionInvalid = 22,
	iso2responseCodeType_FAILED_ChargingProfileInvalid = 23,
	iso2responseCodeType_FAILED_MeteringSignatureNotValid = 24,
	iso2responseCodeType_FAILED_NoChargeServiceSelected = 25,
	iso2responseCodeType_FAILED_WrongEnergyTransferMode = 26,
	iso2responseCodeType_FAILED_ContactorError = 27,
	iso2responseCodeType_FAILED_CertificateRevoked = 28,
	iso2responseCodeType_FAILED_CertificateNotYetValid = 29
} iso2responseCodeType;

/* Complex type name='http://www.w3.org/2000/09/xmldsig#,X509IssuerSerialType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("http://www.w3.org/2000/09/xmldsig#":X509IssuerName,"http://www.w3.org/2000/09/xmldsig#":X509SerialNumber)',  derivedBy='RESTRICTION'.  */
#define iso2X509IssuerSerialType_X509IssuerName_CHARACTERS_SIZE 50 + EXTRA_CHAR 
struct iso2X509IssuerSerialType {
	/* element: "http://www.w3.org/2000/09/xmldsig#":X509IssuerName, http://www.w3.org/2001/XMLSchema,string */
	struct {
		exi_string_character_t characters[iso2X509IssuerSerialType_X509IssuerName_CHARACTERS_SIZE];
		uint16_t charactersLen;
	}  X509IssuerName ;
	/* element: "http://www.w3.org/2000/09/xmldsig#":X509SerialNumber, http://www.w3.org/2001/XMLSchema,integer */
	int64_t X509SerialNumber ;
};

typedef enum {
	iso2chargingSessionType_Terminate = 0,
	iso2chargingSessionType_Pause = 1
} iso2chargingSessionType;

typedef enum {
	iso2EVSEProcessingType_Finished = 0,
	iso2EVSEProcessingType_Ongoing = 1,
	iso2EVSEProcessingType_Ongoing_WaitingForCustomerInteraction = 2
} iso2EVSEProcessingType;

typedef enum {
	iso2paymentOptionType_Contract = 0,
	iso2paymentOptionType_ExternalPayment = 1
} iso2paymentOptionType;

typedef enum {
	iso2EVSECheckOutStatusType_Scheduled = 0,
	iso2EVSECheckOutStatusType_Completed = 1
} iso2EVSECheckOutStatusType;

/* Complex type name='http://www.w3.org/2000/09/xmldsig#,PGPDataType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='(("http://www.w3.org/2000/09/xmldsig#":PGPKeyID,"http://www.w3.org/2000/09/xmldsig#":PGPKeyPacket{0-1},(WC[##other:"http://www.w3.org/2000/09/xmldsig#"]){0-UNBOUNDED})|("http://www.w3.org/2000/09/xmldsig#":PGPKeyPacket,(WC[##other:"http://www.w3.org/2000/09/xmldsig#"]){0-UNBOUNDED}))',  derivedBy='RESTRICTION'.  */
#define iso2PGPDataType_PGPKeyID_BYTES_SIZE 350 
#define iso2PGPDataType_PGPKeyPacket_BYTES_SIZE 350 
#define iso2PGPDataType_ANY_CHARACTERS_SIZE 50 + EXTRA_CHAR 
struct iso2PGPDataType {
	/* element: "http://www.w3.org/2000/09/xmldsig#":PGPKeyID, http://www.w3.org/2001/XMLSchema,base64Binary */
	struct {
		uint8_t bytes[iso2PGPDataType_PGPKeyID_BYTES_SIZE];
		uint16_t bytesLen;
	}  PGPKeyID ;
	unsigned int PGPKeyID_isUsed:1;
	/* element: "http://www.w3.org/2000/09/xmldsig#":PGPKeyPacket, http://www.w3.org/2001/XMLSchema,base64Binary */
	struct {
		uint8_t bytes[iso2PGPDataType_PGPKeyPacket_BYTES_SIZE];
		uint16_t bytesLen;
	}  PGPKeyPacket ;
	unsigned int PGPKeyPacket_isUsed:1;
	/* element: WC[##other:"http://www.w3.org/2000/09/xmldsig#"] */
	struct {
		exi_string_character_t characters[iso2PGPDataType_ANY_CHARACTERS_SIZE];
		uint16_t charactersLen;
	}  ANY ;
	unsigned int ANY_isUsed:1;
};

/* Complex type name='urn:iso:15118:2:2016:MsgDataTypes,ServiceIDListType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgDataTypes":ServiceID{1-10})',  derivedBy='RESTRICTION'.  */
#define iso2ServiceIDListType_ServiceID_ARRAY_SIZE 10
struct iso2ServiceIDListType {
	/* element: "urn:iso:15118:2:2016:MsgDataTypes":ServiceID, urn:iso:15118:2:2016:MsgDataTypes,serviceIDType */
	struct {
		uint16_t array[iso2ServiceIDListType_ServiceID_ARRAY_SIZE];
		uint16_t arrayLen;
	} ServiceID;
};

/* Complex type name='urn:iso:15118:2:2016:MsgDataTypes,EVFinePositioningSetupParametersType',  base type name='anyType',  content type='EMPTY',  isAbstract='true',  hasTypeId='false',  final='0',  block='0',  derivedBy='RESTRICTION'.  */
struct iso2EVFinePositioningSetupParametersType {
	int noContent; /* avoid warning */
};

typedef enum {
	iso2EVCheckOutStatusType_CheckOut = 0,
	iso2EVCheckOutStatusType_Processing = 1,
	iso2EVCheckOutStatusType_Completed = 2
} iso2EVCheckOutStatusType;

/* Complex type name='urn:iso:15118:2:2016:MsgDataTypes,SensorType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgDataTypes":SensorID,"urn:iso:15118:2:2016:MsgDataTypes":SensorPosition,"urn:iso:15118:2:2016:MsgDataTypes":SensorOrientation)',  derivedBy='RESTRICTION'.  */
struct iso2SensorType {
	/* element: "urn:iso:15118:2:2016:MsgDataTypes":SensorID, http://www.w3.org/2001/XMLSchema,unsignedByte */
	uint8_t SensorID ;
	/* element: "urn:iso:15118:2:2016:MsgDataTypes":SensorPosition, Complex type name='urn:iso:15118:2:2016:MsgDataTypes,CartesianCoordinatesType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgDataTypes":XCoordinate,"urn:iso:15118:2:2016:MsgDataTypes":YCoordinate,"urn:iso:15118:2:2016:MsgDataTypes":ZCoordinate)',  derivedBy='RESTRICTION'.  */
	struct iso2CartesianCoordinatesType SensorPosition ;
	/* element: "urn:iso:15118:2:2016:MsgDataTypes":SensorOrientation, Complex type name='urn:iso:15118:2:2016:MsgDataTypes,CartesianCoordinatesType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgDataTypes":XCoordinate,"urn:iso:15118:2:2016:MsgDataTypes":YCoordinate,"urn:iso:15118:2:2016:MsgDataTypes":ZCoordinate)',  derivedBy='RESTRICTION'.  */
	struct iso2CartesianCoordinatesType SensorOrientation ;
};

/* Complex type name='http://www.w3.org/2000/09/xmldsig#,SignatureValueType',  base type name='base64Binary',  content type='SIMPLE',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  derivedBy='EXTENSION'.  */
#define iso2SignatureValueType_Id_CHARACTERS_SIZE 50 + EXTRA_CHAR 
#define iso2SignatureValueType_CONTENT_BYTES_SIZE 350
struct iso2SignatureValueType {
	/* attribute: Id {http://www.w3.org/2001/XMLSchema,ID} */
	struct {
		exi_string_character_t characters[iso2SignatureValueType_Id_CHARACTERS_SIZE];
		uint16_t charactersLen;
	}  Id ;
	unsigned int Id_isUsed:1;
	/* simple content: http://www.w3.org/2001/XMLSchema,base64Binary */
	struct {
		uint8_t bytes[iso2SignatureValueType_CONTENT_BYTES_SIZE];
		uint16_t bytesLen;
	}  CONTENT ;
};

/* Complex type name='urn:iso:15118:2:2016:MsgBody,CableCheckReqType',  base type name='BodyBaseType',  content type='EMPTY',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  derivedBy='EXTENSION'.  */
struct iso2CableCheckReqType {
	int noContent; /* avoid warning */
};

typedef enum {
	iso2electricalChargingDeviceStatusType_Connected = 0,
	iso2electricalChargingDeviceStatusType_Disconnected = 1
} iso2electricalChargingDeviceStatusType;

/* Complex type name='urn:iso:15118:2:2016:MsgDataTypes,SelectedServiceType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgDataTypes":ServiceID,"urn:iso:15118:2:2016:MsgDataTypes":ParameterSetID)',  derivedBy='RESTRICTION'.  */
struct iso2SelectedServiceType {
	/* element: "urn:iso:15118:2:2016:MsgDataTypes":ServiceID, urn:iso:15118:2:2016:MsgDataTypes,serviceIDType */
	uint16_t ServiceID ;
	/* element: "urn:iso:15118:2:2016:MsgDataTypes":ParameterSetID, http://www.w3.org/2001/XMLSchema,unsignedShort */
	uint16_t ParameterSetID ;
};

typedef enum {
	iso2EVSEErrorCodeType_RESSTemperatureInhibit = 0,
	iso2EVSEErrorCodeType_ChargerConnectorLockFault = 1,
	iso2EVSEErrorCodeType_ChargingCurrentdifferential = 2,
	iso2EVSEErrorCodeType_ChargingVoltageOutOfRange = 3,
	iso2EVSEErrorCodeType_ChargingSystemIncompatibility = 4,
	iso2EVSEErrorCodeType_Reserved_A = 5,
	iso2EVSEErrorCodeType_Reserved_B = 6,
	iso2EVSEErrorCodeType_Reserved_C = 7
} iso2EVSEErrorCodeType;

/* Complex type name='urn:iso:15118:2:2016:MsgDataTypes,DiffieHellmanPublickeyType',  base type name='dHpublickeyType',  content type='SIMPLE',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  derivedBy='EXTENSION'.  */
#define iso2DiffieHellmanPublickeyType_Id_CHARACTERS_SIZE 50 + EXTRA_CHAR 
#define iso2DiffieHellmanPublickeyType_CONTENT_BYTES_SIZE 350
struct iso2DiffieHellmanPublickeyType {
	/* attribute: Id {http://www.w3.org/2001/XMLSchema,ID} */
	struct {
		exi_string_character_t characters[iso2DiffieHellmanPublickeyType_Id_CHARACTERS_SIZE];
		uint16_t charactersLen;
	}  Id ;
	/* simple content: urn:iso:15118:2:2016:MsgDataTypes,dHpublickeyType */
	struct {
		uint8_t bytes[iso2DiffieHellmanPublickeyType_CONTENT_BYTES_SIZE];
		uint16_t bytesLen;
	}  CONTENT ;
};

/* Complex type name='urn:iso:15118:2:2016:MsgDataTypes,EVSEStatusType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgDataTypes":NotificationMaxDelay,"urn:iso:15118:2:2016:MsgDataTypes":EVSENotification)',  derivedBy='RESTRICTION'.  */
struct iso2EVSEStatusType {
	/* element: "urn:iso:15118:2:2016:MsgDataTypes":NotificationMaxDelay, http://www.w3.org/2001/XMLSchema,unsignedShort */
	uint16_t NotificationMaxDelay ;
	/* element: "urn:iso:15118:2:2016:MsgDataTypes":EVSENotification, urn:iso:15118:2:2016:MsgDataTypes,EVSENotificationType */
	iso2EVSENotificationType EVSENotification ;
};

typedef enum {
	iso2EVErrorCodeType_RESSTemperatureInhibit = 0,
	iso2EVErrorCodeType_EVShiftPosition = 1,
	iso2EVErrorCodeType_ChargerConnectorLockFault = 2,
	iso2EVErrorCodeType_EVRESSMalfunction = 3,
	iso2EVErrorCodeType_ChargingCurrentdifferential = 4,
	iso2EVErrorCodeType_ChargingVoltageOutOfRange = 5,
	iso2EVErrorCodeType_ChargingSystemIncompatibility = 6,
	iso2EVErrorCodeType_Reserved_A = 7,
	iso2EVErrorCodeType_Reserved_B = 8,
	iso2EVErrorCodeType_Reserved_C = 9
} iso2EVErrorCodeType;

/* Complex type name='urn:iso:15118:2:2016:MsgBody,AuthorizationResType',  base type name='V2GResponseType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='(("urn:iso:15118:2:2016:MsgBody":ResponseCode,"urn:iso:15118:2:2016:MsgBody":EVSEStatus{0-1}),("urn:iso:15118:2:2016:MsgBody":EVSEProcessing))',  derivedBy='EXTENSION'.  */
struct iso2AuthorizationResType {
	/* element: "urn:iso:15118:2:2016:MsgBody":ResponseCode, urn:iso:15118:2:2016:MsgDataTypes,responseCodeType */
	iso2responseCodeType ResponseCode ;
	/* element: "urn:iso:15118:2:2016:MsgBody":EVSEStatus, Complex type name='urn:iso:15118:2:2016:MsgDataTypes,EVSEStatusType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgDataTypes":NotificationMaxDelay,"urn:iso:15118:2:2016:MsgDataTypes":EVSENotification)',  derivedBy='RESTRICTION'.  */
	struct iso2EVSEStatusType EVSEStatus ;
	unsigned int EVSEStatus_isUsed:1;
	/* element: "urn:iso:15118:2:2016:MsgBody":EVSEProcessing, urn:iso:15118:2:2016:MsgDataTypes,EVSEProcessingType */
	iso2EVSEProcessingType EVSEProcessing ;
};

/* Complex type name='urn:iso:15118:2:2016:MsgDataTypes,MV_EVSEFinePositioningSetupParametersType',  base type name='EVSEFinePositioningSetupParametersType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgDataTypes":FrequencyChannel{0-1},"urn:iso:15118:2:2016:MsgDataTypes":MagneticVectorSetupList{0-1})',  derivedBy='EXTENSION'.  */
struct iso2MV_EVSEFinePositioningSetupParametersType {
	/* element: "urn:iso:15118:2:2016:MsgDataTypes":FrequencyChannel, http://www.w3.org/2001/XMLSchema,unsignedInt */
	uint32_t FrequencyChannel ;
	unsigned int FrequencyChannel_isUsed:1;
	/* element: "urn:iso:15118:2:2016:MsgDataTypes":MagneticVectorSetupList, Complex type name='urn:iso:15118:2:2016:MsgDataTypes,MagneticVectorSetupListType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgDataTypes":MagneticVectorSetup{1-255})',  derivedBy='RESTRICTION'.  */
	struct iso2MagneticVectorSetupListType MagneticVectorSetupList ;
	unsigned int MagneticVectorSetupList_isUsed:1;
};

/* Complex type name='http://www.w3.org/2000/09/xmldsig#,X509DataType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='(("http://www.w3.org/2000/09/xmldsig#":X509IssuerSerial|"http://www.w3.org/2000/09/xmldsig#":X509SKI|"http://www.w3.org/2000/09/xmldsig#":X509SubjectName|"http://www.w3.org/2000/09/xmldsig#":X509Certificate|"http://www.w3.org/2000/09/xmldsig#":X509CRL|(WC[##other:"http://www.w3.org/2000/09/xmldsig#"]))){1-UNBOUNDED}',  derivedBy='RESTRICTION'.  */
#define iso2X509DataType_X509IssuerSerial_ARRAY_SIZE 1
#define iso2X509DataType_X509SKI_BYTES_SIZE 350 
#define iso2X509DataType_X509SKI_ARRAY_SIZE 1
#define iso2X509DataType_X509SubjectName_CHARACTERS_SIZE 50 + EXTRA_CHAR 
#define iso2X509DataType_X509SubjectName_ARRAY_SIZE 1
#define iso2X509DataType_X509Certificate_BYTES_SIZE 350 
#define iso2X509DataType_X509Certificate_ARRAY_SIZE 1
#define iso2X509DataType_X509CRL_BYTES_SIZE 350 
#define iso2X509DataType_X509CRL_ARRAY_SIZE 1
#define iso2X509DataType_ANY_CHARACTERS_SIZE 50 + EXTRA_CHAR 
struct iso2X509DataType {
	/* element: "http://www.w3.org/2000/09/xmldsig#":X509IssuerSerial, Complex type name='http://www.w3.org/2000/09/xmldsig#,X509IssuerSerialType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("http://www.w3.org/2000/09/xmldsig#":X509IssuerName,"http://www.w3.org/2000/09/xmldsig#":X509SerialNumber)',  derivedBy='RESTRICTION'.  */
	struct {
		struct iso2X509IssuerSerialType array[iso2X509DataType_X509IssuerSerial_ARRAY_SIZE];
		uint16_t arrayLen;
	} X509IssuerSerial;
	/* element: "http://www.w3.org/2000/09/xmldsig#":X509SKI, http://www.w3.org/2001/XMLSchema,base64Binary */
	struct {
		struct {
			uint8_t bytes[iso2X509DataType_X509SKI_BYTES_SIZE];
			uint16_t bytesLen;
		}  array[iso2X509DataType_X509SKI_ARRAY_SIZE];
		uint16_t arrayLen;
	} X509SKI;
	/* element: "http://www.w3.org/2000/09/xmldsig#":X509SubjectName, http://www.w3.org/2001/XMLSchema,string */
	struct {
		struct {
			exi_string_character_t characters[iso2X509DataType_X509SubjectName_CHARACTERS_SIZE];
			uint16_t charactersLen;
		}  array[iso2X509DataType_X509SubjectName_ARRAY_SIZE];
		uint16_t arrayLen;
	} X509SubjectName;
	/* element: "http://www.w3.org/2000/09/xmldsig#":X509Certificate, http://www.w3.org/2001/XMLSchema,base64Binary */
	struct {
		struct {
			uint8_t bytes[iso2X509DataType_X509Certificate_BYTES_SIZE];
			uint16_t bytesLen;
		}  array[iso2X509DataType_X509Certificate_ARRAY_SIZE];
		uint16_t arrayLen;
	} X509Certificate;
	/* element: "http://www.w3.org/2000/09/xmldsig#":X509CRL, http://www.w3.org/2001/XMLSchema,base64Binary */
	struct {
		struct {
			uint8_t bytes[iso2X509DataType_X509CRL_BYTES_SIZE];
			uint16_t bytesLen;
		}  array[iso2X509DataType_X509CRL_ARRAY_SIZE];
		uint16_t arrayLen;
	} X509CRL;
	/* element: WC[##other:"http://www.w3.org/2000/09/xmldsig#"] */
	struct {
		exi_string_character_t characters[iso2X509DataType_ANY_CHARACTERS_SIZE];
		uint16_t charactersLen;
	}  ANY ;
	unsigned int ANY_isUsed:1;
};

/* Complex type name='urn:iso:15118:2:2016:MsgBody,DC_BidirectionalControlResType',  base type name='V2GResponseType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='(("urn:iso:15118:2:2016:MsgBody":ResponseCode,"urn:iso:15118:2:2016:MsgBody":EVSEStatus{0-1}),("urn:iso:15118:2:2016:MsgBody":EVSEPresentCurrent,"urn:iso:15118:2:2016:MsgBody":EVSEPresentVoltage,"urn:iso:15118:2:2016:MsgBody":EVSEPowerLimitAchieved,"urn:iso:15118:2:2016:MsgBody":EVSECurrentLimitAchieved,"urn:iso:15118:2:2016:MsgBody":EVSEVoltageLimitAchieved,"urn:iso:15118:2:2016:MsgBody":EVSEMaximumChargePower{0-1},"urn:iso:15118:2:2016:MsgBody":EVSEMaximumDischargePower{0-1},"urn:iso:15118:2:2016:MsgBody":EVSEMaximumChargeCurrent{0-1},"urn:iso:15118:2:2016:MsgBody":EVSEMaximumDischargeCurrent{0-1},"urn:iso:15118:2:2016:MsgBody":EVSEMaximumVoltage{0-1},"urn:iso:15118:2:2016:MsgBody":EVSEMinimumVoltage{0-1},"urn:iso:15118:2:2016:MsgBody":EVSEID,"urn:iso:15118:2:2016:MsgBody":SAScheduleTupleID{0-1},"urn:iso:15118:2:2016:MsgBody":MeterInfo{0-1},"urn:iso:15118:2:2016:MsgBody":ReceiptRequired{0-1}))',  derivedBy='EXTENSION'.  */
#define iso2DC_BidirectionalControlResType_EVSEID_CHARACTERS_SIZE 37 + EXTRA_CHAR /* XML schema facet maxLength for urn:iso:15118:2:2016:MsgDataTypes,evseIDType is 37 */
struct iso2DC_BidirectionalControlResType {
	/* element: "urn:iso:15118:2:2016:MsgBody":ResponseCode, urn:iso:15118:2:2016:MsgDataTypes,responseCodeType */
	iso2responseCodeType ResponseCode ;
	/* element: "urn:iso:15118:2:2016:MsgBody":EVSEStatus, Complex type name='urn:iso:15118:2:2016:MsgDataTypes,EVSEStatusType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgDataTypes":NotificationMaxDelay,"urn:iso:15118:2:2016:MsgDataTypes":EVSENotification)',  derivedBy='RESTRICTION'.  */
	struct iso2EVSEStatusType EVSEStatus ;
	unsigned int EVSEStatus_isUsed:1;
	/* element: "urn:iso:15118:2:2016:MsgBody":EVSEPresentCurrent, Complex type name='urn:iso:15118:2:2016:MsgDataTypes,PhysicalValueType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgDataTypes":Exponent,"urn:iso:15118:2:2016:MsgDataTypes":Value)',  derivedBy='RESTRICTION'.  */
	struct iso2PhysicalValueType EVSEPresentCurrent ;
	/* element: "urn:iso:15118:2:2016:MsgBody":EVSEPresentVoltage, Complex type name='urn:iso:15118:2:2016:MsgDataTypes,PhysicalValueType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgDataTypes":Exponent,"urn:iso:15118:2:2016:MsgDataTypes":Value)',  derivedBy='RESTRICTION'.  */
	struct iso2PhysicalValueType EVSEPresentVoltage ;
	/* element: "urn:iso:15118:2:2016:MsgBody":EVSEPowerLimitAchieved, http://www.w3.org/2001/XMLSchema,boolean */
	int EVSEPowerLimitAchieved ;
	/* element: "urn:iso:15118:2:2016:MsgBody":EVSECurrentLimitAchieved, http://www.w3.org/2001/XMLSchema,boolean */
	int EVSECurrentLimitAchieved ;
	/* element: "urn:iso:15118:2:2016:MsgBody":EVSEVoltageLimitAchieved, http://www.w3.org/2001/XMLSchema,boolean */
	int EVSEVoltageLimitAchieved ;
	/* element: "urn:iso:15118:2:2016:MsgBody":EVSEMaximumChargePower, Complex type name='urn:iso:15118:2:2016:MsgDataTypes,PhysicalValueType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgDataTypes":Exponent,"urn:iso:15118:2:2016:MsgDataTypes":Value)',  derivedBy='RESTRICTION'.  */
	struct iso2PhysicalValueType EVSEMaximumChargePower ;
	unsigned int EVSEMaximumChargePower_isUsed:1;
	/* element: "urn:iso:15118:2:2016:MsgBody":EVSEMaximumDischargePower, Complex type name='urn:iso:15118:2:2016:MsgDataTypes,PhysicalValueType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgDataTypes":Exponent,"urn:iso:15118:2:2016:MsgDataTypes":Value)',  derivedBy='RESTRICTION'.  */
	struct iso2PhysicalValueType EVSEMaximumDischargePower ;
	unsigned int EVSEMaximumDischargePower_isUsed:1;
	/* element: "urn:iso:15118:2:2016:MsgBody":EVSEMaximumChargeCurrent, Complex type name='urn:iso:15118:2:2016:MsgDataTypes,PhysicalValueType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgDataTypes":Exponent,"urn:iso:15118:2:2016:MsgDataTypes":Value)',  derivedBy='RESTRICTION'.  */
	struct iso2PhysicalValueType EVSEMaximumChargeCurrent ;
	unsigned int EVSEMaximumChargeCurrent_isUsed:1;
	/* element: "urn:iso:15118:2:2016:MsgBody":EVSEMaximumDischargeCurrent, Complex type name='urn:iso:15118:2:2016:MsgDataTypes,PhysicalValueType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgDataTypes":Exponent,"urn:iso:15118:2:2016:MsgDataTypes":Value)',  derivedBy='RESTRICTION'.  */
	struct iso2PhysicalValueType EVSEMaximumDischargeCurrent ;
	unsigned int EVSEMaximumDischargeCurrent_isUsed:1;
	/* element: "urn:iso:15118:2:2016:MsgBody":EVSEMaximumVoltage, Complex type name='urn:iso:15118:2:2016:MsgDataTypes,PhysicalValueType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgDataTypes":Exponent,"urn:iso:15118:2:2016:MsgDataTypes":Value)',  derivedBy='RESTRICTION'.  */
	struct iso2PhysicalValueType EVSEMaximumVoltage ;
	unsigned int EVSEMaximumVoltage_isUsed:1;
	/* element: "urn:iso:15118:2:2016:MsgBody":EVSEMinimumVoltage, Complex type name='urn:iso:15118:2:2016:MsgDataTypes,PhysicalValueType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgDataTypes":Exponent,"urn:iso:15118:2:2016:MsgDataTypes":Value)',  derivedBy='RESTRICTION'.  */
	struct iso2PhysicalValueType EVSEMinimumVoltage ;
	unsigned int EVSEMinimumVoltage_isUsed:1;
	/* element: "urn:iso:15118:2:2016:MsgBody":EVSEID, urn:iso:15118:2:2016:MsgDataTypes,evseIDType */
	struct {
		exi_string_character_t characters[iso2DC_BidirectionalControlResType_EVSEID_CHARACTERS_SIZE];
		uint16_t charactersLen;
	}  EVSEID ;
	/* element: "urn:iso:15118:2:2016:MsgBody":SAScheduleTupleID, urn:iso:15118:2:2016:MsgDataTypes,SAIDType */
	uint8_t SAScheduleTupleID ;
	unsigned int SAScheduleTupleID_isUsed:1;
	/* element: "urn:iso:15118:2:2016:MsgBody":MeterInfo, Complex type name='urn:iso:15118:2:2016:MsgDataTypes,MeterInfoType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgDataTypes":MeterID,"urn:iso:15118:2:2016:MsgDataTypes":MeterReadingCharged{0-1},"urn:iso:15118:2:2016:MsgDataTypes":MeterReadingDischarged{0-1},"urn:iso:15118:2:2016:MsgDataTypes":SigMeterReading{0-1},"urn:iso:15118:2:2016:MsgDataTypes":MeterStatus{0-1},"urn:iso:15118:2:2016:MsgDataTypes":TMeter{0-1})',  derivedBy='RESTRICTION'.  */
	struct iso2MeterInfoType MeterInfo ;
	unsigned int MeterInfo_isUsed:1;
	/* element: "urn:iso:15118:2:2016:MsgBody":ReceiptRequired, http://www.w3.org/2001/XMLSchema,boolean */
	int ReceiptRequired ;
	unsigned int ReceiptRequired_isUsed:1;
};

/* Complex type name='urn:iso:15118:2:2016:MsgDataTypes,CostType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgDataTypes":costKind,"urn:iso:15118:2:2016:MsgDataTypes":amount)',  derivedBy='RESTRICTION'.  */
struct iso2CostType {
	/* element: "urn:iso:15118:2:2016:MsgDataTypes":costKind, urn:iso:15118:2:2016:MsgDataTypes,costKindType */
	iso2costKindType costKind ;
	/* element: "urn:iso:15118:2:2016:MsgDataTypes":amount, Complex type name='urn:iso:15118:2:2016:MsgDataTypes,PhysicalValueType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgDataTypes":Exponent,"urn:iso:15118:2:2016:MsgDataTypes":Value)',  derivedBy='RESTRICTION'.  */
	struct iso2PhysicalValueType amount ;
};

/* Complex type name='urn:iso:15118:2:2016:MsgBody,ChargingStatusResType',  base type name='V2GResponseType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='(("urn:iso:15118:2:2016:MsgBody":ResponseCode,"urn:iso:15118:2:2016:MsgBody":EVSEStatus{0-1}),("urn:iso:15118:2:2016:MsgBody":EVSEID,"urn:iso:15118:2:2016:MsgBody":SAScheduleTupleID{0-1},"urn:iso:15118:2:2016:MsgBody":MeterInfo{0-1},"urn:iso:15118:2:2016:MsgBody":ReceiptRequired{0-1},"urn:iso:15118:2:2016:MsgBody":EVSETargetPower{0-1}))',  derivedBy='EXTENSION'.  */
#define iso2ChargingStatusResType_EVSEID_CHARACTERS_SIZE 37 + EXTRA_CHAR /* XML schema facet maxLength for urn:iso:15118:2:2016:MsgDataTypes,evseIDType is 37 */
struct iso2ChargingStatusResType {
	/* element: "urn:iso:15118:2:2016:MsgBody":ResponseCode, urn:iso:15118:2:2016:MsgDataTypes,responseCodeType */
	iso2responseCodeType ResponseCode ;
	/* element: "urn:iso:15118:2:2016:MsgBody":EVSEStatus, Complex type name='urn:iso:15118:2:2016:MsgDataTypes,EVSEStatusType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgDataTypes":NotificationMaxDelay,"urn:iso:15118:2:2016:MsgDataTypes":EVSENotification)',  derivedBy='RESTRICTION'.  */
	struct iso2EVSEStatusType EVSEStatus ;
	unsigned int EVSEStatus_isUsed:1;
	/* element: "urn:iso:15118:2:2016:MsgBody":EVSEID, urn:iso:15118:2:2016:MsgDataTypes,evseIDType */
	struct {
		exi_string_character_t characters[iso2ChargingStatusResType_EVSEID_CHARACTERS_SIZE];
		uint16_t charactersLen;
	}  EVSEID ;
	/* element: "urn:iso:15118:2:2016:MsgBody":SAScheduleTupleID, urn:iso:15118:2:2016:MsgDataTypes,SAIDType */
	uint8_t SAScheduleTupleID ;
	unsigned int SAScheduleTupleID_isUsed:1;
	/* element: "urn:iso:15118:2:2016:MsgBody":MeterInfo, Complex type name='urn:iso:15118:2:2016:MsgDataTypes,MeterInfoType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgDataTypes":MeterID,"urn:iso:15118:2:2016:MsgDataTypes":MeterReadingCharged{0-1},"urn:iso:15118:2:2016:MsgDataTypes":MeterReadingDischarged{0-1},"urn:iso:15118:2:2016:MsgDataTypes":SigMeterReading{0-1},"urn:iso:15118:2:2016:MsgDataTypes":MeterStatus{0-1},"urn:iso:15118:2:2016:MsgDataTypes":TMeter{0-1})',  derivedBy='RESTRICTION'.  */
	struct iso2MeterInfoType MeterInfo ;
	unsigned int MeterInfo_isUsed:1;
	/* element: "urn:iso:15118:2:2016:MsgBody":ReceiptRequired, http://www.w3.org/2001/XMLSchema,boolean */
	int ReceiptRequired ;
	unsigned int ReceiptRequired_isUsed:1;
	/* element: "urn:iso:15118:2:2016:MsgBody":EVSETargetPower, Complex type name='urn:iso:15118:2:2016:MsgDataTypes,PhysicalValueType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgDataTypes":Exponent,"urn:iso:15118:2:2016:MsgDataTypes":Value)',  derivedBy='RESTRICTION'.  */
	struct iso2PhysicalValueType EVSETargetPower ;
	unsigned int EVSETargetPower_isUsed:1;
};

/* Complex type name='urn:iso:15118:2:2016:MsgDataTypes,AC_EVChargeParameterType',  base type name='EVEnergyTransferParameterType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='(("urn:iso:15118:2:2016:MsgDataTypes":DepartureTime),("urn:iso:15118:2:2016:MsgDataTypes":EVMaximumChargePower,"urn:iso:15118:2:2016:MsgDataTypes":EVMaximumChargeCurrent,"urn:iso:15118:2:2016:MsgDataTypes":EVMinimumChargeCurrent,"urn:iso:15118:2:2016:MsgDataTypes":EVTargetEnergyRequest{0-1},"urn:iso:15118:2:2016:MsgDataTypes":EVMaximumEnergyRequest{0-1},"urn:iso:15118:2:2016:MsgDataTypes":EVMinimumEnergyRequest{0-1},"urn:iso:15118:2:2016:MsgDataTypes":EVMaximumVoltage))',  derivedBy='EXTENSION'.  */
struct iso2AC_EVChargeParameterType {
	/* element: "urn:iso:15118:2:2016:MsgDataTypes":DepartureTime, http://www.w3.org/2001/XMLSchema,unsignedInt */
	uint32_t DepartureTime ;
	/* element: "urn:iso:15118:2:2016:MsgDataTypes":EVMaximumChargePower, Complex type name='urn:iso:15118:2:2016:MsgDataTypes,PhysicalValueType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgDataTypes":Exponent,"urn:iso:15118:2:2016:MsgDataTypes":Value)',  derivedBy='RESTRICTION'.  */
	struct iso2PhysicalValueType EVMaximumChargePower ;
	/* element: "urn:iso:15118:2:2016:MsgDataTypes":EVMaximumChargeCurrent, Complex type name='urn:iso:15118:2:2016:MsgDataTypes,PhysicalValueType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgDataTypes":Exponent,"urn:iso:15118:2:2016:MsgDataTypes":Value)',  derivedBy='RESTRICTION'.  */
	struct iso2PhysicalValueType EVMaximumChargeCurrent ;
	/* element: "urn:iso:15118:2:2016:MsgDataTypes":EVMinimumChargeCurrent, Complex type name='urn:iso:15118:2:2016:MsgDataTypes,PhysicalValueType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgDataTypes":Exponent,"urn:iso:15118:2:2016:MsgDataTypes":Value)',  derivedBy='RESTRICTION'.  */
	struct iso2PhysicalValueType EVMinimumChargeCurrent ;
	/* element: "urn:iso:15118:2:2016:MsgDataTypes":EVTargetEnergyRequest, Complex type name='urn:iso:15118:2:2016:MsgDataTypes,PhysicalValueType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgDataTypes":Exponent,"urn:iso:15118:2:2016:MsgDataTypes":Value)',  derivedBy='RESTRICTION'.  */
	struct iso2PhysicalValueType EVTargetEnergyRequest ;
	unsigned int EVTargetEnergyRequest_isUsed:1;
	/* element: "urn:iso:15118:2:2016:MsgDataTypes":EVMaximumEnergyRequest, Complex type name='urn:iso:15118:2:2016:MsgDataTypes,PhysicalValueType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgDataTypes":Exponent,"urn:iso:15118:2:2016:MsgDataTypes":Value)',  derivedBy='RESTRICTION'.  */
	struct iso2PhysicalValueType EVMaximumEnergyRequest ;
	unsigned int EVMaximumEnergyRequest_isUsed:1;
	/* element: "urn:iso:15118:2:2016:MsgDataTypes":EVMinimumEnergyRequest, Complex type name='urn:iso:15118:2:2016:MsgDataTypes,PhysicalValueType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgDataTypes":Exponent,"urn:iso:15118:2:2016:MsgDataTypes":Value)',  derivedBy='RESTRICTION'.  */
	struct iso2PhysicalValueType EVMinimumEnergyRequest ;
	unsigned int EVMinimumEnergyRequest_isUsed:1;
	/* element: "urn:iso:15118:2:2016:MsgDataTypes":EVMaximumVoltage, Complex type name='urn:iso:15118:2:2016:MsgDataTypes,PhysicalValueType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgDataTypes":Exponent,"urn:iso:15118:2:2016:MsgDataTypes":Value)',  derivedBy='RESTRICTION'.  */
	struct iso2PhysicalValueType EVMaximumVoltage ;
};

/* Complex type name='urn:iso:15118:2:2016:MsgDataTypes,AC_EVSEBidirectionalParameterType',  base type name='AC_EVSEChargeParameterType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='(("urn:iso:15118:2:2016:MsgDataTypes":EVSEMaximumChargeCurrent,"urn:iso:15118:2:2016:MsgDataTypes":EVSENominalVoltage,"urn:iso:15118:2:2016:MsgDataTypes":EVSENominalFrequency),("urn:iso:15118:2:2016:MsgDataTypes":EVSEMaximumDischargeCurrent,"urn:iso:15118:2:2016:MsgDataTypes":EVSENominalFrequency))',  derivedBy='EXTENSION'.  */
struct iso2AC_EVSEBidirectionalParameterType {
	/* element: "urn:iso:15118:2:2016:MsgDataTypes":EVSEMaximumChargeCurrent, Complex type name='urn:iso:15118:2:2016:MsgDataTypes,PhysicalValueType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgDataTypes":Exponent,"urn:iso:15118:2:2016:MsgDataTypes":Value)',  derivedBy='RESTRICTION'.  */
	struct iso2PhysicalValueType EVSEMaximumChargeCurrent ;
	/* element: "urn:iso:15118:2:2016:MsgDataTypes":EVSENominalVoltage, Complex type name='urn:iso:15118:2:2016:MsgDataTypes,PhysicalValueType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgDataTypes":Exponent,"urn:iso:15118:2:2016:MsgDataTypes":Value)',  derivedBy='RESTRICTION'.  */
	struct iso2PhysicalValueType EVSENominalVoltage ;
	/* element: "urn:iso:15118:2:2016:MsgDataTypes":EVSENominalFrequency, Complex type name='urn:iso:15118:2:2016:MsgDataTypes,PhysicalValueType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgDataTypes":Exponent,"urn:iso:15118:2:2016:MsgDataTypes":Value)',  derivedBy='RESTRICTION'.  */
	struct iso2PhysicalValueType EVSENominalFrequency ;
	/* element: "urn:iso:15118:2:2016:MsgDataTypes":EVSEMaximumDischargeCurrent, Complex type name='urn:iso:15118:2:2016:MsgDataTypes,PhysicalValueType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgDataTypes":Exponent,"urn:iso:15118:2:2016:MsgDataTypes":Value)',  derivedBy='RESTRICTION'.  */
	struct iso2PhysicalValueType EVSEMaximumDischargeCurrent ;
};

/* Complex type name='urn:iso:15118:2:2016:MsgBody,VehicleCheckOutResType',  base type name='V2GResponseType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='(("urn:iso:15118:2:2016:MsgBody":ResponseCode,"urn:iso:15118:2:2016:MsgBody":EVSEStatus{0-1}),("urn:iso:15118:2:2016:MsgBody":EVSECheckOutStatus))',  derivedBy='EXTENSION'.  */
struct iso2VehicleCheckOutResType {
	/* element: "urn:iso:15118:2:2016:MsgBody":ResponseCode, urn:iso:15118:2:2016:MsgDataTypes,responseCodeType */
	iso2responseCodeType ResponseCode ;
	/* element: "urn:iso:15118:2:2016:MsgBody":EVSEStatus, Complex type name='urn:iso:15118:2:2016:MsgDataTypes,EVSEStatusType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgDataTypes":NotificationMaxDelay,"urn:iso:15118:2:2016:MsgDataTypes":EVSENotification)',  derivedBy='RESTRICTION'.  */
	struct iso2EVSEStatusType EVSEStatus ;
	unsigned int EVSEStatus_isUsed:1;
	/* element: "urn:iso:15118:2:2016:MsgBody":EVSECheckOutStatus, urn:iso:15118:2:2016:MsgDataTypes,EVCheckOutStatusType */
	iso2EVCheckOutStatusType EVSECheckOutStatus ;
};

/* Complex type name='urn:iso:15118:2:2016:MsgBody,CableCheckResType',  base type name='V2GResponseType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='(("urn:iso:15118:2:2016:MsgBody":ResponseCode,"urn:iso:15118:2:2016:MsgBody":EVSEStatus{0-1}),("urn:iso:15118:2:2016:MsgBody":EVSEProcessing))',  derivedBy='EXTENSION'.  */
struct iso2CableCheckResType {
	/* element: "urn:iso:15118:2:2016:MsgBody":ResponseCode, urn:iso:15118:2:2016:MsgDataTypes,responseCodeType */
	iso2responseCodeType ResponseCode ;
	/* element: "urn:iso:15118:2:2016:MsgBody":EVSEStatus, Complex type name='urn:iso:15118:2:2016:MsgDataTypes,EVSEStatusType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgDataTypes":NotificationMaxDelay,"urn:iso:15118:2:2016:MsgDataTypes":EVSENotification)',  derivedBy='RESTRICTION'.  */
	struct iso2EVSEStatusType EVSEStatus ;
	unsigned int EVSEStatus_isUsed:1;
	/* element: "urn:iso:15118:2:2016:MsgBody":EVSEProcessing, urn:iso:15118:2:2016:MsgDataTypes,EVSEProcessingType */
	iso2EVSEProcessingType EVSEProcessing ;
};

/* Complex type name='urn:iso:15118:2:2016:MsgBody,ServiceDiscoveryReqType',  base type name='BodyBaseType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgBody":SupportedServiceIDs{0-1})',  derivedBy='EXTENSION'.  */
struct iso2ServiceDiscoveryReqType {
	/* element: "urn:iso:15118:2:2016:MsgBody":SupportedServiceIDs, Complex type name='urn:iso:15118:2:2016:MsgDataTypes,ServiceIDListType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgDataTypes":ServiceID{1-10})',  derivedBy='RESTRICTION'.  */
	struct iso2ServiceIDListType SupportedServiceIDs ;
	unsigned int SupportedServiceIDs_isUsed:1;
};

/* Complex type name='http://www.w3.org/2000/09/xmldsig#,SignaturePropertiesType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("http://www.w3.org/2000/09/xmldsig#":SignatureProperty{1-UNBOUNDED})',  derivedBy='RESTRICTION'.  */
#define iso2SignaturePropertiesType_Id_CHARACTERS_SIZE 50 + EXTRA_CHAR 
#define iso2SignaturePropertiesType_SignatureProperty_ARRAY_SIZE 1
struct iso2SignaturePropertiesType {
	/* attribute: Id {http://www.w3.org/2001/XMLSchema,ID} */
	struct {
		exi_string_character_t characters[iso2SignaturePropertiesType_Id_CHARACTERS_SIZE];
		uint16_t charactersLen;
	}  Id ;
	unsigned int Id_isUsed:1;
	/* element: "http://www.w3.org/2000/09/xmldsig#":SignatureProperty, Complex type name='http://www.w3.org/2000/09/xmldsig#,SignaturePropertyType',  base type name='anyType',  content type='MIXED',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='((WC[##other:"http://www.w3.org/2000/09/xmldsig#"])){1-UNBOUNDED}',  derivedBy='RESTRICTION'.  */
	struct {
		struct iso2SignaturePropertyType array[iso2SignaturePropertiesType_SignatureProperty_ARRAY_SIZE];
		uint16_t arrayLen;
	} SignatureProperty;
};

/* Complex type name='urn:iso:15118:2:2016:MsgDataTypes,PMaxScheduleEntryType',  base type name='EntryType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='(("urn:iso:15118:2:2016:MsgDataTypes":RelativeTimeInterval),("urn:iso:15118:2:2016:MsgDataTypes":PMax{1-3}))',  derivedBy='EXTENSION'.  */
#define iso2PMaxScheduleEntryType_PMax_ARRAY_SIZE 3
struct iso2PMaxScheduleEntryType {
	/* element: "urn:iso:15118:2:2016:MsgDataTypes":RelativeTimeInterval, Complex type name='urn:iso:15118:2:2016:MsgDataTypes,RelativeTimeIntervalType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgDataTypes":start,"urn:iso:15118:2:2016:MsgDataTypes":duration{0-1})',  derivedBy='RESTRICTION'.  */
	struct iso2RelativeTimeIntervalType RelativeTimeInterval ;
	/* element: "urn:iso:15118:2:2016:MsgDataTypes":PMax, Complex type name='urn:iso:15118:2:2016:MsgDataTypes,PhysicalValueType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgDataTypes":Exponent,"urn:iso:15118:2:2016:MsgDataTypes":Value)',  derivedBy='RESTRICTION'.  */
	struct {
		struct iso2PhysicalValueType array[iso2PMaxScheduleEntryType_PMax_ARRAY_SIZE];
		uint16_t arrayLen;
	} PMax;
};

/* Complex type name='urn:iso:15118:2:2016:MsgBody,VehicleCheckInReqType',  base type name='BodyBaseType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgBody":EVCheckInStatus,"urn:iso:15118:2:2016:MsgBody":ParkingMethod{0-1})',  derivedBy='EXTENSION'.  */
struct iso2VehicleCheckInReqType {
	/* element: "urn:iso:15118:2:2016:MsgBody":EVCheckInStatus, urn:iso:15118:2:2016:MsgDataTypes,EVCheckInStatusType */
	iso2EVCheckInStatusType EVCheckInStatus ;
	/* element: "urn:iso:15118:2:2016:MsgBody":ParkingMethod, urn:iso:15118:2:2016:MsgDataTypes,parkingMethodType */
	iso2parkingMethodType ParkingMethod ;
	unsigned int ParkingMethod_isUsed:1;
};

/* Complex type name='urn:iso:15118:2:2016:MsgBody,ConnectChargingDeviceResType',  base type name='V2GResponseType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='(("urn:iso:15118:2:2016:MsgBody":ResponseCode,"urn:iso:15118:2:2016:MsgBody":EVSEStatus{0-1}),("urn:iso:15118:2:2016:MsgBody":EVSEProcessing,"urn:iso:15118:2:2016:MsgBody":EVSEElectricalChargingDeviceStatus,"urn:iso:15118:2:2016:MsgBody":EVSEMechanicalChargingDeviceStatus))',  derivedBy='EXTENSION'.  */
struct iso2ConnectChargingDeviceResType {
	/* element: "urn:iso:15118:2:2016:MsgBody":ResponseCode, urn:iso:15118:2:2016:MsgDataTypes,responseCodeType */
	iso2responseCodeType ResponseCode ;
	/* element: "urn:iso:15118:2:2016:MsgBody":EVSEStatus, Complex type name='urn:iso:15118:2:2016:MsgDataTypes,EVSEStatusType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgDataTypes":NotificationMaxDelay,"urn:iso:15118:2:2016:MsgDataTypes":EVSENotification)',  derivedBy='RESTRICTION'.  */
	struct iso2EVSEStatusType EVSEStatus ;
	unsigned int EVSEStatus_isUsed:1;
	/* element: "urn:iso:15118:2:2016:MsgBody":EVSEProcessing, urn:iso:15118:2:2016:MsgDataTypes,EVSEProcessingType */
	iso2EVSEProcessingType EVSEProcessing ;
	/* element: "urn:iso:15118:2:2016:MsgBody":EVSEElectricalChargingDeviceStatus, urn:iso:15118:2:2016:MsgDataTypes,electricalChargingDeviceStatusType */
	iso2electricalChargingDeviceStatusType EVSEElectricalChargingDeviceStatus ;
	/* element: "urn:iso:15118:2:2016:MsgBody":EVSEMechanicalChargingDeviceStatus, urn:iso:15118:2:2016:MsgDataTypes,mechanicalChargingDeviceStatusType */
	iso2mechanicalChargingDeviceStatusType EVSEMechanicalChargingDeviceStatus ;
};

/* Complex type name='urn:iso:15118:2:2016:MsgBody,WeldingDetectionResType',  base type name='V2GResponseType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='(("urn:iso:15118:2:2016:MsgBody":ResponseCode,"urn:iso:15118:2:2016:MsgBody":EVSEStatus{0-1}),("urn:iso:15118:2:2016:MsgBody":EVSEPresentVoltage))',  derivedBy='EXTENSION'.  */
struct iso2WeldingDetectionResType {
	/* element: "urn:iso:15118:2:2016:MsgBody":ResponseCode, urn:iso:15118:2:2016:MsgDataTypes,responseCodeType */
	iso2responseCodeType ResponseCode ;
	/* element: "urn:iso:15118:2:2016:MsgBody":EVSEStatus, Complex type name='urn:iso:15118:2:2016:MsgDataTypes,EVSEStatusType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgDataTypes":NotificationMaxDelay,"urn:iso:15118:2:2016:MsgDataTypes":EVSENotification)',  derivedBy='RESTRICTION'.  */
	struct iso2EVSEStatusType EVSEStatus ;
	unsigned int EVSEStatus_isUsed:1;
	/* element: "urn:iso:15118:2:2016:MsgBody":EVSEPresentVoltage, Complex type name='urn:iso:15118:2:2016:MsgDataTypes,PhysicalValueType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgDataTypes":Exponent,"urn:iso:15118:2:2016:MsgDataTypes":Value)',  derivedBy='RESTRICTION'.  */
	struct iso2PhysicalValueType EVSEPresentVoltage ;
};

/* Complex type name='urn:iso:15118:2:2016:MsgBody,SessionStopResType',  base type name='V2GResponseType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgBody":ResponseCode,"urn:iso:15118:2:2016:MsgBody":EVSEStatus{0-1})',  derivedBy='EXTENSION'.  */
struct iso2SessionStopResType {
	/* element: "urn:iso:15118:2:2016:MsgBody":ResponseCode, urn:iso:15118:2:2016:MsgDataTypes,responseCodeType */
	iso2responseCodeType ResponseCode ;
	/* element: "urn:iso:15118:2:2016:MsgBody":EVSEStatus, Complex type name='urn:iso:15118:2:2016:MsgDataTypes,EVSEStatusType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgDataTypes":NotificationMaxDelay,"urn:iso:15118:2:2016:MsgDataTypes":EVSENotification)',  derivedBy='RESTRICTION'.  */
	struct iso2EVSEStatusType EVSEStatus ;
	unsigned int EVSEStatus_isUsed:1;
};

/* Complex type name='urn:iso:15118:2:2016:MsgBody,VehicleCheckInResType',  base type name='V2GResponseType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='(("urn:iso:15118:2:2016:MsgBody":ResponseCode,"urn:iso:15118:2:2016:MsgBody":EVSEStatus{0-1}),("urn:iso:15118:2:2016:MsgBody":VehicleSpace,"urn:iso:15118:2:2016:MsgBody":TargetOffset{0-1}))',  derivedBy='EXTENSION'.  */
struct iso2VehicleCheckInResType {
	/* element: "urn:iso:15118:2:2016:MsgBody":ResponseCode, urn:iso:15118:2:2016:MsgDataTypes,responseCodeType */
	iso2responseCodeType ResponseCode ;
	/* element: "urn:iso:15118:2:2016:MsgBody":EVSEStatus, Complex type name='urn:iso:15118:2:2016:MsgDataTypes,EVSEStatusType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgDataTypes":NotificationMaxDelay,"urn:iso:15118:2:2016:MsgDataTypes":EVSENotification)',  derivedBy='RESTRICTION'.  */
	struct iso2EVSEStatusType EVSEStatus ;
	unsigned int EVSEStatus_isUsed:1;
	/* element: "urn:iso:15118:2:2016:MsgBody":VehicleSpace, http://www.w3.org/2001/XMLSchema,unsignedShort */
	uint16_t VehicleSpace ;
	/* element: "urn:iso:15118:2:2016:MsgBody":TargetOffset, Complex type name='urn:iso:15118:2:2016:MsgDataTypes,TargetPositionType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgDataTypes":TargetOffsetX,"urn:iso:15118:2:2016:MsgDataTypes":TargetOffsetY)',  derivedBy='RESTRICTION'.  */
	struct iso2TargetPositionType TargetOffset ;
	unsigned int TargetOffset_isUsed:1;
};

/* Complex type name='urn:iso:15118:2:2016:MsgDataTypes,AC_EVBidirectionalParameterType',  base type name='AC_EVChargeParameterType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='((("urn:iso:15118:2:2016:MsgDataTypes":DepartureTime),("urn:iso:15118:2:2016:MsgDataTypes":EVMaximumChargePower,"urn:iso:15118:2:2016:MsgDataTypes":EVMaximumChargeCurrent,"urn:iso:15118:2:2016:MsgDataTypes":EVMinimumChargeCurrent,"urn:iso:15118:2:2016:MsgDataTypes":EVTargetEnergyRequest{0-1},"urn:iso:15118:2:2016:MsgDataTypes":EVMaximumEnergyRequest{0-1},"urn:iso:15118:2:2016:MsgDataTypes":EVMinimumEnergyRequest{0-1},"urn:iso:15118:2:2016:MsgDataTypes":EVMaximumVoltage)),("urn:iso:15118:2:2016:MsgDataTypes":EVMaximumDischargePower,"urn:iso:15118:2:2016:MsgDataTypes":EVMaximumDischargeCurrent,"urn:iso:15118:2:2016:MsgDataTypes":EVMinimumDischargeCurrent))',  derivedBy='EXTENSION'.  */
struct iso2AC_EVBidirectionalParameterType {
	/* element: "urn:iso:15118:2:2016:MsgDataTypes":DepartureTime, http://www.w3.org/2001/XMLSchema,unsignedInt */
	uint32_t DepartureTime ;
	/* element: "urn:iso:15118:2:2016:MsgDataTypes":EVMaximumChargePower, Complex type name='urn:iso:15118:2:2016:MsgDataTypes,PhysicalValueType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgDataTypes":Exponent,"urn:iso:15118:2:2016:MsgDataTypes":Value)',  derivedBy='RESTRICTION'.  */
	struct iso2PhysicalValueType EVMaximumChargePower ;
	/* element: "urn:iso:15118:2:2016:MsgDataTypes":EVMaximumChargeCurrent, Complex type name='urn:iso:15118:2:2016:MsgDataTypes,PhysicalValueType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgDataTypes":Exponent,"urn:iso:15118:2:2016:MsgDataTypes":Value)',  derivedBy='RESTRICTION'.  */
	struct iso2PhysicalValueType EVMaximumChargeCurrent ;
	/* element: "urn:iso:15118:2:2016:MsgDataTypes":EVMinimumChargeCurrent, Complex type name='urn:iso:15118:2:2016:MsgDataTypes,PhysicalValueType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgDataTypes":Exponent,"urn:iso:15118:2:2016:MsgDataTypes":Value)',  derivedBy='RESTRICTION'.  */
	struct iso2PhysicalValueType EVMinimumChargeCurrent ;
	/* element: "urn:iso:15118:2:2016:MsgDataTypes":EVTargetEnergyRequest, Complex type name='urn:iso:15118:2:2016:MsgDataTypes,PhysicalValueType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgDataTypes":Exponent,"urn:iso:15118:2:2016:MsgDataTypes":Value)',  derivedBy='RESTRICTION'.  */
	struct iso2PhysicalValueType EVTargetEnergyRequest ;
	unsigned int EVTargetEnergyRequest_isUsed:1;
	/* element: "urn:iso:15118:2:2016:MsgDataTypes":EVMaximumEnergyRequest, Complex type name='urn:iso:15118:2:2016:MsgDataTypes,PhysicalValueType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgDataTypes":Exponent,"urn:iso:15118:2:2016:MsgDataTypes":Value)',  derivedBy='RESTRICTION'.  */
	struct iso2PhysicalValueType EVMaximumEnergyRequest ;
	unsigned int EVMaximumEnergyRequest_isUsed:1;
	/* element: "urn:iso:15118:2:2016:MsgDataTypes":EVMinimumEnergyRequest, Complex type name='urn:iso:15118:2:2016:MsgDataTypes,PhysicalValueType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgDataTypes":Exponent,"urn:iso:15118:2:2016:MsgDataTypes":Value)',  derivedBy='RESTRICTION'.  */
	struct iso2PhysicalValueType EVMinimumEnergyRequest ;
	unsigned int EVMinimumEnergyRequest_isUsed:1;
	/* element: "urn:iso:15118:2:2016:MsgDataTypes":EVMaximumVoltage, Complex type name='urn:iso:15118:2:2016:MsgDataTypes,PhysicalValueType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgDataTypes":Exponent,"urn:iso:15118:2:2016:MsgDataTypes":Value)',  derivedBy='RESTRICTION'.  */
	struct iso2PhysicalValueType EVMaximumVoltage ;
	/* element: "urn:iso:15118:2:2016:MsgDataTypes":EVMaximumDischargePower, Complex type name='urn:iso:15118:2:2016:MsgDataTypes,PhysicalValueType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgDataTypes":Exponent,"urn:iso:15118:2:2016:MsgDataTypes":Value)',  derivedBy='RESTRICTION'.  */
	struct iso2PhysicalValueType EVMaximumDischargePower ;
	/* element: "urn:iso:15118:2:2016:MsgDataTypes":EVMaximumDischargeCurrent, Complex type name='urn:iso:15118:2:2016:MsgDataTypes,PhysicalValueType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgDataTypes":Exponent,"urn:iso:15118:2:2016:MsgDataTypes":Value)',  derivedBy='RESTRICTION'.  */
	struct iso2PhysicalValueType EVMaximumDischargeCurrent ;
	/* element: "urn:iso:15118:2:2016:MsgDataTypes":EVMinimumDischargeCurrent, Complex type name='urn:iso:15118:2:2016:MsgDataTypes,PhysicalValueType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgDataTypes":Exponent,"urn:iso:15118:2:2016:MsgDataTypes":Value)',  derivedBy='RESTRICTION'.  */
	struct iso2PhysicalValueType EVMinimumDischargeCurrent ;
};

/* Complex type name='urn:iso:15118:2:2016:MsgDataTypes,ConsumptionCostType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgDataTypes":startValue,"urn:iso:15118:2:2016:MsgDataTypes":Cost{1-3})',  derivedBy='RESTRICTION'.  */
#define iso2ConsumptionCostType_Cost_ARRAY_SIZE 3
struct iso2ConsumptionCostType {
	/* element: "urn:iso:15118:2:2016:MsgDataTypes":startValue, Complex type name='urn:iso:15118:2:2016:MsgDataTypes,PhysicalValueType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgDataTypes":Exponent,"urn:iso:15118:2:2016:MsgDataTypes":Value)',  derivedBy='RESTRICTION'.  */
	struct iso2PhysicalValueType startValue ;
	/* element: "urn:iso:15118:2:2016:MsgDataTypes":Cost, Complex type name='urn:iso:15118:2:2016:MsgDataTypes,CostType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgDataTypes":costKind,"urn:iso:15118:2:2016:MsgDataTypes":amount)',  derivedBy='RESTRICTION'.  */
	struct {
		struct iso2CostType array[iso2ConsumptionCostType_Cost_ARRAY_SIZE];
		uint16_t arrayLen;
	} Cost;
};

/* Complex type name='urn:iso:15118:2:2016:MsgDataTypes,PaymentOptionListType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgDataTypes":PaymentOption{1-2})',  derivedBy='RESTRICTION'.  */
#define iso2PaymentOptionListType_PaymentOption_ARRAY_SIZE 2
struct iso2PaymentOptionListType {
	/* element: "urn:iso:15118:2:2016:MsgDataTypes":PaymentOption, urn:iso:15118:2:2016:MsgDataTypes,paymentOptionType */
	struct {
		iso2paymentOptionType array[iso2PaymentOptionListType_PaymentOption_ARRAY_SIZE];
		uint16_t arrayLen;
	} PaymentOption;
};

/* Complex type name='http://www.w3.org/2000/09/xmldsig#,TransformsType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("http://www.w3.org/2000/09/xmldsig#":Transform{1-UNBOUNDED})',  derivedBy='RESTRICTION'.  */
#define iso2TransformsType_Transform_ARRAY_SIZE 1
struct iso2TransformsType {
	/* element: "http://www.w3.org/2000/09/xmldsig#":Transform, Complex type name='http://www.w3.org/2000/09/xmldsig#,TransformType',  base type name='anyType',  content type='MIXED',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='((WC[##other:"http://www.w3.org/2000/09/xmldsig#"])|"http://www.w3.org/2000/09/xmldsig#":XPath){0-UNBOUNDED}',  derivedBy='RESTRICTION'.  */
	struct {
		struct iso2TransformType array[iso2TransformsType_Transform_ARRAY_SIZE];
		uint16_t arrayLen;
	} Transform;
};

/* Complex type name='urn:iso:15118:2:2016:MsgDataTypes,ParameterType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgDataTypes":boolValue|"urn:iso:15118:2:2016:MsgDataTypes":byteValue|"urn:iso:15118:2:2016:MsgDataTypes":shortValue|"urn:iso:15118:2:2016:MsgDataTypes":intValue|"urn:iso:15118:2:2016:MsgDataTypes":physicalValue|"urn:iso:15118:2:2016:MsgDataTypes":stringValue)',  derivedBy='RESTRICTION'.  */
#define iso2ParameterType_Name_CHARACTERS_SIZE 50 + EXTRA_CHAR 
#define iso2ParameterType_stringValue_CHARACTERS_SIZE 50 + EXTRA_CHAR 
struct iso2ParameterType {
	/* attribute: Name {http://www.w3.org/2001/XMLSchema,string} */
	struct {
		exi_string_character_t characters[iso2ParameterType_Name_CHARACTERS_SIZE];
		uint16_t charactersLen;
	}  Name ;
	/* element: "urn:iso:15118:2:2016:MsgDataTypes":boolValue, http://www.w3.org/2001/XMLSchema,boolean */
	int boolValue ;
	unsigned int boolValue_isUsed:1;
	/* element: "urn:iso:15118:2:2016:MsgDataTypes":byteValue, http://www.w3.org/2001/XMLSchema,byte */
	int8_t byteValue ;
	unsigned int byteValue_isUsed:1;
	/* element: "urn:iso:15118:2:2016:MsgDataTypes":shortValue, http://www.w3.org/2001/XMLSchema,short */
	int16_t shortValue ;
	unsigned int shortValue_isUsed:1;
	/* element: "urn:iso:15118:2:2016:MsgDataTypes":intValue, http://www.w3.org/2001/XMLSchema,int */
	int32_t intValue ;
	unsigned int intValue_isUsed:1;
	/* element: "urn:iso:15118:2:2016:MsgDataTypes":physicalValue, Complex type name='urn:iso:15118:2:2016:MsgDataTypes,PhysicalValueType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgDataTypes":Exponent,"urn:iso:15118:2:2016:MsgDataTypes":Value)',  derivedBy='RESTRICTION'.  */
	struct iso2PhysicalValueType physicalValue ;
	unsigned int physicalValue_isUsed:1;
	/* element: "urn:iso:15118:2:2016:MsgDataTypes":stringValue, http://www.w3.org/2001/XMLSchema,string */
	struct {
		exi_string_character_t characters[iso2ParameterType_stringValue_CHARACTERS_SIZE];
		uint16_t charactersLen;
	}  stringValue ;
	unsigned int stringValue_isUsed:1;
};

/* Complex type name='urn:iso:15118:2:2016:MsgBody,SessionStopReqType',  base type name='BodyBaseType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgBody":ChargingSession)',  derivedBy='EXTENSION'.  */
struct iso2SessionStopReqType {
	/* element: "urn:iso:15118:2:2016:MsgBody":ChargingSession, urn:iso:15118:2:2016:MsgDataTypes,chargingSessionType */
	iso2chargingSessionType ChargingSession ;
};

/* Complex type name='urn:iso:15118:2:2016:MsgDataTypes,SensorMeasurementsType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgDataTypes":SensorID,"urn:iso:15118:2:2016:MsgDataTypes":EffectiveRadiatedPower,"urn:iso:15118:2:2016:MsgDataTypes":MeasurementDataList)',  derivedBy='RESTRICTION'.  */
struct iso2SensorMeasurementsType {
	/* element: "urn:iso:15118:2:2016:MsgDataTypes":SensorID, http://www.w3.org/2001/XMLSchema,unsignedByte */
	uint8_t SensorID ;
	/* element: "urn:iso:15118:2:2016:MsgDataTypes":EffectiveRadiatedPower, http://www.w3.org/2001/XMLSchema,byte */
	int8_t EffectiveRadiatedPower ;
	/* element: "urn:iso:15118:2:2016:MsgDataTypes":MeasurementDataList, Complex type name='urn:iso:15118:2:2016:MsgDataTypes,MeasurementDataListType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgDataTypes":MeasurementData{1-255})',  derivedBy='RESTRICTION'.  */
	struct iso2MeasurementDataListType MeasurementDataList ;
};

/* Complex type name='urn:iso:15118:2:2016:MsgDataTypes,DC_EVSEChargeParameterType',  base type name='EVSEEnergyTransferParameterType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgDataTypes":EVSEMaximumChargePower,"urn:iso:15118:2:2016:MsgDataTypes":EVSEMaximumChargeCurrent,"urn:iso:15118:2:2016:MsgDataTypes":EVSEMinimumChargeCurrent,"urn:iso:15118:2:2016:MsgDataTypes":EVSEMaximumVoltage,"urn:iso:15118:2:2016:MsgDataTypes":EVSEMinimumVoltage,"urn:iso:15118:2:2016:MsgDataTypes":EVSECurrentRegulationTolerance{0-1},"urn:iso:15118:2:2016:MsgDataTypes":EVSEPeakCurrentRipple,"urn:iso:15118:2:2016:MsgDataTypes":EVSEEnergyToBeDelivered{0-1})',  derivedBy='EXTENSION'.  */
struct iso2DC_EVSEChargeParameterType {
	/* element: "urn:iso:15118:2:2016:MsgDataTypes":EVSEMaximumChargePower, Complex type name='urn:iso:15118:2:2016:MsgDataTypes,PhysicalValueType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgDataTypes":Exponent,"urn:iso:15118:2:2016:MsgDataTypes":Value)',  derivedBy='RESTRICTION'.  */
	struct iso2PhysicalValueType EVSEMaximumChargePower ;
	/* element: "urn:iso:15118:2:2016:MsgDataTypes":EVSEMaximumChargeCurrent, Complex type name='urn:iso:15118:2:2016:MsgDataTypes,PhysicalValueType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgDataTypes":Exponent,"urn:iso:15118:2:2016:MsgDataTypes":Value)',  derivedBy='RESTRICTION'.  */
	struct iso2PhysicalValueType EVSEMaximumChargeCurrent ;
	/* element: "urn:iso:15118:2:2016:MsgDataTypes":EVSEMinimumChargeCurrent, Complex type name='urn:iso:15118:2:2016:MsgDataTypes,PhysicalValueType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgDataTypes":Exponent,"urn:iso:15118:2:2016:MsgDataTypes":Value)',  derivedBy='RESTRICTION'.  */
	struct iso2PhysicalValueType EVSEMinimumChargeCurrent ;
	/* element: "urn:iso:15118:2:2016:MsgDataTypes":EVSEMaximumVoltage, Complex type name='urn:iso:15118:2:2016:MsgDataTypes,PhysicalValueType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgDataTypes":Exponent,"urn:iso:15118:2:2016:MsgDataTypes":Value)',  derivedBy='RESTRICTION'.  */
	struct iso2PhysicalValueType EVSEMaximumVoltage ;
	/* element: "urn:iso:15118:2:2016:MsgDataTypes":EVSEMinimumVoltage, Complex type name='urn:iso:15118:2:2016:MsgDataTypes,PhysicalValueType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgDataTypes":Exponent,"urn:iso:15118:2:2016:MsgDataTypes":Value)',  derivedBy='RESTRICTION'.  */
	struct iso2PhysicalValueType EVSEMinimumVoltage ;
	/* element: "urn:iso:15118:2:2016:MsgDataTypes":EVSECurrentRegulationTolerance, Complex type name='urn:iso:15118:2:2016:MsgDataTypes,PhysicalValueType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgDataTypes":Exponent,"urn:iso:15118:2:2016:MsgDataTypes":Value)',  derivedBy='RESTRICTION'.  */
	struct iso2PhysicalValueType EVSECurrentRegulationTolerance ;
	unsigned int EVSECurrentRegulationTolerance_isUsed:1;
	/* element: "urn:iso:15118:2:2016:MsgDataTypes":EVSEPeakCurrentRipple, Complex type name='urn:iso:15118:2:2016:MsgDataTypes,PhysicalValueType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgDataTypes":Exponent,"urn:iso:15118:2:2016:MsgDataTypes":Value)',  derivedBy='RESTRICTION'.  */
	struct iso2PhysicalValueType EVSEPeakCurrentRipple ;
	/* element: "urn:iso:15118:2:2016:MsgDataTypes":EVSEEnergyToBeDelivered, Complex type name='urn:iso:15118:2:2016:MsgDataTypes,PhysicalValueType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgDataTypes":Exponent,"urn:iso:15118:2:2016:MsgDataTypes":Value)',  derivedBy='RESTRICTION'.  */
	struct iso2PhysicalValueType EVSEEnergyToBeDelivered ;
	unsigned int EVSEEnergyToBeDelivered_isUsed:1;
};

/* Complex type name='urn:iso:15118:2:2016:MsgDataTypes,CertificateChainType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgDataTypes":Certificate,"urn:iso:15118:2:2016:MsgDataTypes":SubCertificates{0-1})',  derivedBy='RESTRICTION'.  */
#define iso2CertificateChainType_Id_CHARACTERS_SIZE 50 + EXTRA_CHAR 
#define iso2CertificateChainType_Certificate_BYTES_SIZE 800 /* XML schema facet maxLength for urn:iso:15118:2:2016:MsgDataTypes,certificateType is 800 */
struct iso2CertificateChainType {
	/* attribute: Id {http://www.w3.org/2001/XMLSchema,ID} */
	struct {
		exi_string_character_t characters[iso2CertificateChainType_Id_CHARACTERS_SIZE];
		uint16_t charactersLen;
	}  Id ;
	unsigned int Id_isUsed:1;
	/* element: "urn:iso:15118:2:2016:MsgDataTypes":Certificate, urn:iso:15118:2:2016:MsgDataTypes,certificateType */
	struct {
		uint8_t bytes[iso2CertificateChainType_Certificate_BYTES_SIZE];
		uint16_t bytesLen;
	}  Certificate ;
	/* element: "urn:iso:15118:2:2016:MsgDataTypes":SubCertificates, Complex type name='urn:iso:15118:2:2016:MsgDataTypes,SubCertificatesType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgDataTypes":Certificate{1-4})',  derivedBy='RESTRICTION'.  */
	struct iso2SubCertificatesType SubCertificates ;
	unsigned int SubCertificates_isUsed:1;
};

/* Complex type name='urn:iso:15118:2:2016:MsgDataTypes,WPT_EVChargeParameterType',  base type name='EVEnergyTransferParameterType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='(("urn:iso:15118:2:2016:MsgDataTypes":DepartureTime),("urn:iso:15118:2:2016:MsgDataTypes":EVMaximumPower,"urn:iso:15118:2:2016:MsgDataTypes":EVMinimumPower,"urn:iso:15118:2:2016:MsgDataTypes":EVTargetEnergyRequest{0-1},"urn:iso:15118:2:2016:MsgDataTypes":EVMaximumEnergyRequest{0-1},"urn:iso:15118:2:2016:MsgDataTypes":EVMinimumEnergyRequest{0-1}))',  derivedBy='EXTENSION'.  */
struct iso2WPT_EVChargeParameterType {
	/* element: "urn:iso:15118:2:2016:MsgDataTypes":DepartureTime, http://www.w3.org/2001/XMLSchema,unsignedInt */
	uint32_t DepartureTime ;
	/* element: "urn:iso:15118:2:2016:MsgDataTypes":EVMaximumPower, Complex type name='urn:iso:15118:2:2016:MsgDataTypes,PhysicalValueType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgDataTypes":Exponent,"urn:iso:15118:2:2016:MsgDataTypes":Value)',  derivedBy='RESTRICTION'.  */
	struct iso2PhysicalValueType EVMaximumPower ;
	/* element: "urn:iso:15118:2:2016:MsgDataTypes":EVMinimumPower, Complex type name='urn:iso:15118:2:2016:MsgDataTypes,PhysicalValueType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgDataTypes":Exponent,"urn:iso:15118:2:2016:MsgDataTypes":Value)',  derivedBy='RESTRICTION'.  */
	struct iso2PhysicalValueType EVMinimumPower ;
	/* element: "urn:iso:15118:2:2016:MsgDataTypes":EVTargetEnergyRequest, Complex type name='urn:iso:15118:2:2016:MsgDataTypes,PhysicalValueType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgDataTypes":Exponent,"urn:iso:15118:2:2016:MsgDataTypes":Value)',  derivedBy='RESTRICTION'.  */
	struct iso2PhysicalValueType EVTargetEnergyRequest ;
	unsigned int EVTargetEnergyRequest_isUsed:1;
	/* element: "urn:iso:15118:2:2016:MsgDataTypes":EVMaximumEnergyRequest, Complex type name='urn:iso:15118:2:2016:MsgDataTypes,PhysicalValueType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgDataTypes":Exponent,"urn:iso:15118:2:2016:MsgDataTypes":Value)',  derivedBy='RESTRICTION'.  */
	struct iso2PhysicalValueType EVMaximumEnergyRequest ;
	unsigned int EVMaximumEnergyRequest_isUsed:1;
	/* element: "urn:iso:15118:2:2016:MsgDataTypes":EVMinimumEnergyRequest, Complex type name='urn:iso:15118:2:2016:MsgDataTypes,PhysicalValueType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgDataTypes":Exponent,"urn:iso:15118:2:2016:MsgDataTypes":Value)',  derivedBy='RESTRICTION'.  */
	struct iso2PhysicalValueType EVMinimumEnergyRequest ;
	unsigned int EVMinimumEnergyRequest_isUsed:1;
};

/* Complex type name='urn:iso:15118:2:2016:MsgBody,DisconnectChargingDeviceReqType',  base type name='BodyBaseType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgBody":EVElectricalChargingDeviceStatus,"urn:iso:15118:2:2016:MsgBody":EVMechanicalChargingDeviceStatus)',  derivedBy='EXTENSION'.  */
struct iso2DisconnectChargingDeviceReqType {
	/* element: "urn:iso:15118:2:2016:MsgBody":EVElectricalChargingDeviceStatus, urn:iso:15118:2:2016:MsgDataTypes,electricalChargingDeviceStatusType */
	iso2electricalChargingDeviceStatusType EVElectricalChargingDeviceStatus ;
	/* element: "urn:iso:15118:2:2016:MsgBody":EVMechanicalChargingDeviceStatus, urn:iso:15118:2:2016:MsgDataTypes,mechanicalChargingDeviceStatusType */
	iso2mechanicalChargingDeviceStatusType EVMechanicalChargingDeviceStatus ;
};

/* Complex type name='urn:iso:15118:2:2016:MsgBody,MeteringReceiptResType',  base type name='V2GResponseType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgBody":ResponseCode,"urn:iso:15118:2:2016:MsgBody":EVSEStatus{0-1})',  derivedBy='EXTENSION'.  */
struct iso2MeteringReceiptResType {
	/* element: "urn:iso:15118:2:2016:MsgBody":ResponseCode, urn:iso:15118:2:2016:MsgDataTypes,responseCodeType */
	iso2responseCodeType ResponseCode ;
	/* element: "urn:iso:15118:2:2016:MsgBody":EVSEStatus, Complex type name='urn:iso:15118:2:2016:MsgDataTypes,EVSEStatusType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgDataTypes":NotificationMaxDelay,"urn:iso:15118:2:2016:MsgDataTypes":EVSENotification)',  derivedBy='RESTRICTION'.  */
	struct iso2EVSEStatusType EVSEStatus ;
	unsigned int EVSEStatus_isUsed:1;
};

/* Complex type name='urn:iso:15118:2:2016:MsgBody,SessionSetupResType',  base type name='V2GResponseType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='(("urn:iso:15118:2:2016:MsgBody":ResponseCode,"urn:iso:15118:2:2016:MsgBody":EVSEStatus{0-1}),("urn:iso:15118:2:2016:MsgBody":EVSEID,"urn:iso:15118:2:2016:MsgBody":EVSETimeStamp{0-1}))',  derivedBy='EXTENSION'.  */
#define iso2SessionSetupResType_EVSEID_CHARACTERS_SIZE 37 + EXTRA_CHAR /* XML schema facet maxLength for urn:iso:15118:2:2016:MsgDataTypes,evseIDType is 37 */
struct iso2SessionSetupResType {
	/* element: "urn:iso:15118:2:2016:MsgBody":ResponseCode, urn:iso:15118:2:2016:MsgDataTypes,responseCodeType */
	iso2responseCodeType ResponseCode ;
	/* element: "urn:iso:15118:2:2016:MsgBody":EVSEStatus, Complex type name='urn:iso:15118:2:2016:MsgDataTypes,EVSEStatusType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgDataTypes":NotificationMaxDelay,"urn:iso:15118:2:2016:MsgDataTypes":EVSENotification)',  derivedBy='RESTRICTION'.  */
	struct iso2EVSEStatusType EVSEStatus ;
	unsigned int EVSEStatus_isUsed:1;
	/* element: "urn:iso:15118:2:2016:MsgBody":EVSEID, urn:iso:15118:2:2016:MsgDataTypes,evseIDType */
	struct {
		exi_string_character_t characters[iso2SessionSetupResType_EVSEID_CHARACTERS_SIZE];
		uint16_t charactersLen;
	}  EVSEID ;
	/* element: "urn:iso:15118:2:2016:MsgBody":EVSETimeStamp, http://www.w3.org/2001/XMLSchema,long */
	int64_t EVSETimeStamp ;
	unsigned int EVSETimeStamp_isUsed:1;
};

/* Complex type name='http://www.w3.org/2000/09/xmldsig#,ReferenceType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("http://www.w3.org/2000/09/xmldsig#":Transforms{0-1},"http://www.w3.org/2000/09/xmldsig#":DigestMethod,"http://www.w3.org/2000/09/xmldsig#":DigestValue)',  derivedBy='RESTRICTION'.  */
#define iso2ReferenceType_Id_CHARACTERS_SIZE 50 + EXTRA_CHAR 
#define iso2ReferenceType_URI_CHARACTERS_SIZE 50 + EXTRA_CHAR 
#define iso2ReferenceType_Type_CHARACTERS_SIZE 50 + EXTRA_CHAR 
#define iso2ReferenceType_DigestValue_BYTES_SIZE 350 
struct iso2ReferenceType {
	/* attribute: Id {http://www.w3.org/2001/XMLSchema,ID} */
	struct {
		exi_string_character_t characters[iso2ReferenceType_Id_CHARACTERS_SIZE];
		uint16_t charactersLen;
	}  Id ;
	unsigned int Id_isUsed:1;
	/* attribute: URI {http://www.w3.org/2001/XMLSchema,anyURI} */
	struct {
		exi_string_character_t characters[iso2ReferenceType_URI_CHARACTERS_SIZE];
		uint16_t charactersLen;
	}  URI ;
	unsigned int URI_isUsed:1;
	/* attribute: Type {http://www.w3.org/2001/XMLSchema,anyURI} */
	struct {
		exi_string_character_t characters[iso2ReferenceType_Type_CHARACTERS_SIZE];
		uint16_t charactersLen;
	}  Type ;
	unsigned int Type_isUsed:1;
	/* element: "http://www.w3.org/2000/09/xmldsig#":Transforms, Complex type name='http://www.w3.org/2000/09/xmldsig#,TransformsType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("http://www.w3.org/2000/09/xmldsig#":Transform{1-UNBOUNDED})',  derivedBy='RESTRICTION'.  */
	struct iso2TransformsType Transforms ;
	unsigned int Transforms_isUsed:1;
	/* element: "http://www.w3.org/2000/09/xmldsig#":DigestMethod, Complex type name='http://www.w3.org/2000/09/xmldsig#,DigestMethodType',  base type name='anyType',  content type='MIXED',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='((WC[##other:"http://www.w3.org/2000/09/xmldsig#"]){0-UNBOUNDED})',  derivedBy='RESTRICTION'.  */
	struct iso2DigestMethodType DigestMethod ;
	/* element: "http://www.w3.org/2000/09/xmldsig#":DigestValue, http://www.w3.org/2000/09/xmldsig#,DigestValueType */
	struct {
		uint8_t bytes[iso2ReferenceType_DigestValue_BYTES_SIZE];
		uint16_t bytesLen;
	}  DigestValue ;
};

/* Complex type name='urn:iso:15118:2:2016:MsgDataTypes,SensorListType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgDataTypes":Sensor{1-255})',  derivedBy='RESTRICTION'.  */
#define iso2SensorListType_Sensor_ARRAY_SIZE 5
struct iso2SensorListType {
	/* element: "urn:iso:15118:2:2016:MsgDataTypes":Sensor, Complex type name='urn:iso:15118:2:2016:MsgDataTypes,SensorType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgDataTypes":SensorID,"urn:iso:15118:2:2016:MsgDataTypes":SensorPosition,"urn:iso:15118:2:2016:MsgDataTypes":SensorOrientation)',  derivedBy='RESTRICTION'.  */
	struct {
		struct iso2SensorType array[iso2SensorListType_Sensor_ARRAY_SIZE];
		uint16_t arrayLen;
	} Sensor;
};

/* Complex type name='urn:iso:15118:2:2016:MsgDataTypes,LFA_EVFinePositioningSetupParametersType',  base type name='EVFinePositioningSetupParametersType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgDataTypes":NumberOfSensors,"urn:iso:15118:2:2016:MsgDataTypes":SensorList,"urn:iso:15118:2:2016:MsgDataTypes":SensorOrder,"urn:iso:15118:2:2016:MsgDataTypes":SignalPulseDuration,"urn:iso:15118:2:2016:MsgDataTypes":SignalSeparationTime,"urn:iso:15118:2:2016:MsgDataTypes":PackageSeparationTime,"urn:iso:15118:2:2016:MsgDataTypes":AlignmentOffset)',  derivedBy='EXTENSION'.  */
struct iso2LFA_EVFinePositioningSetupParametersType {
	/* element: "urn:iso:15118:2:2016:MsgDataTypes":NumberOfSensors, http://www.w3.org/2001/XMLSchema,unsignedByte */
	uint8_t NumberOfSensors ;
	/* element: "urn:iso:15118:2:2016:MsgDataTypes":SensorList, Complex type name='urn:iso:15118:2:2016:MsgDataTypes,SensorListType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgDataTypes":Sensor{1-255})',  derivedBy='RESTRICTION'.  */
	struct iso2SensorListType SensorList ;
	/* element: "urn:iso:15118:2:2016:MsgDataTypes":SensorOrder, Complex type name='urn:iso:15118:2:2016:MsgDataTypes,SensorOrderListType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgDataTypes":SensorPosition{1-255})',  derivedBy='RESTRICTION'.  */
	struct iso2SensorOrderListType SensorOrder ;
	/* element: "urn:iso:15118:2:2016:MsgDataTypes":SignalPulseDuration, http://www.w3.org/2001/XMLSchema,unsignedByte */
	uint8_t SignalPulseDuration ;
	/* element: "urn:iso:15118:2:2016:MsgDataTypes":SignalSeparationTime, http://www.w3.org/2001/XMLSchema,unsignedByte */
	uint8_t SignalSeparationTime ;
	/* element: "urn:iso:15118:2:2016:MsgDataTypes":PackageSeparationTime, http://www.w3.org/2001/XMLSchema,unsignedByte */
	uint8_t PackageSeparationTime ;
	/* element: "urn:iso:15118:2:2016:MsgDataTypes":AlignmentOffset, http://www.w3.org/2001/XMLSchema,unsignedShort */
	uint16_t AlignmentOffset ;
};

/* Complex type name='urn:iso:15118:2:2016:MsgDataTypes,WPT_EVSEChargeParameterType',  base type name='EVSEEnergyTransferParameterType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgDataTypes":EVSEMaximumPower,"urn:iso:15118:2:2016:MsgDataTypes":EVSEMinimumPower)',  derivedBy='EXTENSION'.  */
struct iso2WPT_EVSEChargeParameterType {
	/* element: "urn:iso:15118:2:2016:MsgDataTypes":EVSEMaximumPower, Complex type name='urn:iso:15118:2:2016:MsgDataTypes,PhysicalValueType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgDataTypes":Exponent,"urn:iso:15118:2:2016:MsgDataTypes":Value)',  derivedBy='RESTRICTION'.  */
	struct iso2PhysicalValueType EVSEMaximumPower ;
	/* element: "urn:iso:15118:2:2016:MsgDataTypes":EVSEMinimumPower, Complex type name='urn:iso:15118:2:2016:MsgDataTypes,PhysicalValueType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgDataTypes":Exponent,"urn:iso:15118:2:2016:MsgDataTypes":Value)',  derivedBy='RESTRICTION'.  */
	struct iso2PhysicalValueType EVSEMinimumPower ;
};

/* Complex type name='urn:iso:15118:2:2016:MsgDataTypes,ParameterSetType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgDataTypes":ParameterSetID,"urn:iso:15118:2:2016:MsgDataTypes":Parameter{1-16})',  derivedBy='RESTRICTION'.  */
#define iso2ParameterSetType_Parameter_ARRAY_SIZE 16
struct iso2ParameterSetType {
	/* element: "urn:iso:15118:2:2016:MsgDataTypes":ParameterSetID, http://www.w3.org/2001/XMLSchema,unsignedShort */
	uint16_t ParameterSetID ;
	/* element: "urn:iso:15118:2:2016:MsgDataTypes":Parameter, Complex type name='urn:iso:15118:2:2016:MsgDataTypes,ParameterType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgDataTypes":boolValue|"urn:iso:15118:2:2016:MsgDataTypes":byteValue|"urn:iso:15118:2:2016:MsgDataTypes":shortValue|"urn:iso:15118:2:2016:MsgDataTypes":intValue|"urn:iso:15118:2:2016:MsgDataTypes":physicalValue|"urn:iso:15118:2:2016:MsgDataTypes":stringValue)',  derivedBy='RESTRICTION'.  */
	struct {
		struct iso2ParameterType array[iso2ParameterSetType_Parameter_ARRAY_SIZE];
		uint16_t arrayLen;
	} Parameter;
};

/* Complex type name='urn:iso:15118:2:2016:MsgBody,PaymentDetailsResType',  base type name='V2GResponseType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='(("urn:iso:15118:2:2016:MsgBody":ResponseCode,"urn:iso:15118:2:2016:MsgBody":EVSEStatus{0-1}),("urn:iso:15118:2:2016:MsgBody":GenChallenge,"urn:iso:15118:2:2016:MsgBody":EVSETimeStamp))',  derivedBy='EXTENSION'.  */
#define iso2PaymentDetailsResType_GenChallenge_BYTES_SIZE 16 /* XML schema facet length for urn:iso:15118:2:2016:MsgDataTypes,genChallengeType is 16 */
struct iso2PaymentDetailsResType {
	/* element: "urn:iso:15118:2:2016:MsgBody":ResponseCode, urn:iso:15118:2:2016:MsgDataTypes,responseCodeType */
	iso2responseCodeType ResponseCode ;
	/* element: "urn:iso:15118:2:2016:MsgBody":EVSEStatus, Complex type name='urn:iso:15118:2:2016:MsgDataTypes,EVSEStatusType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgDataTypes":NotificationMaxDelay,"urn:iso:15118:2:2016:MsgDataTypes":EVSENotification)',  derivedBy='RESTRICTION'.  */
	struct iso2EVSEStatusType EVSEStatus ;
	unsigned int EVSEStatus_isUsed:1;
	/* element: "urn:iso:15118:2:2016:MsgBody":GenChallenge, urn:iso:15118:2:2016:MsgDataTypes,genChallengeType */
	struct {
		uint8_t bytes[iso2PaymentDetailsResType_GenChallenge_BYTES_SIZE];
		uint16_t bytesLen;
	}  GenChallenge ;
	/* element: "urn:iso:15118:2:2016:MsgBody":EVSETimeStamp, http://www.w3.org/2001/XMLSchema,long */
	int64_t EVSETimeStamp ;
};

/* Complex type name='urn:iso:15118:2:2016:MsgBody,AC_BidirectionalControlResType',  base type name='V2GResponseType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='(("urn:iso:15118:2:2016:MsgBody":ResponseCode,"urn:iso:15118:2:2016:MsgBody":EVSEStatus{0-1}),("urn:iso:15118:2:2016:MsgBody":EVSEProcessing,"urn:iso:15118:2:2016:MsgBody":EVSETargetPower,"urn:iso:15118:2:2016:MsgBody":EVSETargetReactivePower,"urn:iso:15118:2:2016:MsgBody":EVSEID,"urn:iso:15118:2:2016:MsgBody":SAScheduleTupleID{0-1},"urn:iso:15118:2:2016:MsgBody":MeterInfo{0-1},"urn:iso:15118:2:2016:MsgBody":ReceiptRequired{0-1}))',  derivedBy='EXTENSION'.  */
#define iso2AC_BidirectionalControlResType_EVSEID_CHARACTERS_SIZE 37 + EXTRA_CHAR /* XML schema facet maxLength for urn:iso:15118:2:2016:MsgDataTypes,evseIDType is 37 */
struct iso2AC_BidirectionalControlResType {
	/* element: "urn:iso:15118:2:2016:MsgBody":ResponseCode, urn:iso:15118:2:2016:MsgDataTypes,responseCodeType */
	iso2responseCodeType ResponseCode ;
	/* element: "urn:iso:15118:2:2016:MsgBody":EVSEStatus, Complex type name='urn:iso:15118:2:2016:MsgDataTypes,EVSEStatusType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgDataTypes":NotificationMaxDelay,"urn:iso:15118:2:2016:MsgDataTypes":EVSENotification)',  derivedBy='RESTRICTION'.  */
	struct iso2EVSEStatusType EVSEStatus ;
	unsigned int EVSEStatus_isUsed:1;
	/* element: "urn:iso:15118:2:2016:MsgBody":EVSEProcessing, urn:iso:15118:2:2016:MsgDataTypes,EVSEProcessingType */
	iso2EVSEProcessingType EVSEProcessing ;
	/* element: "urn:iso:15118:2:2016:MsgBody":EVSETargetPower, Complex type name='urn:iso:15118:2:2016:MsgDataTypes,PhysicalValueType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgDataTypes":Exponent,"urn:iso:15118:2:2016:MsgDataTypes":Value)',  derivedBy='RESTRICTION'.  */
	struct iso2PhysicalValueType EVSETargetPower ;
	/* element: "urn:iso:15118:2:2016:MsgBody":EVSETargetReactivePower, Complex type name='urn:iso:15118:2:2016:MsgDataTypes,PhysicalValueType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgDataTypes":Exponent,"urn:iso:15118:2:2016:MsgDataTypes":Value)',  derivedBy='RESTRICTION'.  */
	struct iso2PhysicalValueType EVSETargetReactivePower ;
	/* element: "urn:iso:15118:2:2016:MsgBody":EVSEID, urn:iso:15118:2:2016:MsgDataTypes,evseIDType */
	struct {
		exi_string_character_t characters[iso2AC_BidirectionalControlResType_EVSEID_CHARACTERS_SIZE];
		uint16_t charactersLen;
	}  EVSEID ;
	/* element: "urn:iso:15118:2:2016:MsgBody":SAScheduleTupleID, urn:iso:15118:2:2016:MsgDataTypes,SAIDType */
	uint8_t SAScheduleTupleID ;
	unsigned int SAScheduleTupleID_isUsed:1;
	/* element: "urn:iso:15118:2:2016:MsgBody":MeterInfo, Complex type name='urn:iso:15118:2:2016:MsgDataTypes,MeterInfoType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgDataTypes":MeterID,"urn:iso:15118:2:2016:MsgDataTypes":MeterReadingCharged{0-1},"urn:iso:15118:2:2016:MsgDataTypes":MeterReadingDischarged{0-1},"urn:iso:15118:2:2016:MsgDataTypes":SigMeterReading{0-1},"urn:iso:15118:2:2016:MsgDataTypes":MeterStatus{0-1},"urn:iso:15118:2:2016:MsgDataTypes":TMeter{0-1})',  derivedBy='RESTRICTION'.  */
	struct iso2MeterInfoType MeterInfo ;
	unsigned int MeterInfo_isUsed:1;
	/* element: "urn:iso:15118:2:2016:MsgBody":ReceiptRequired, http://www.w3.org/2001/XMLSchema,boolean */
	int ReceiptRequired ;
	unsigned int ReceiptRequired_isUsed:1;
};

/* Complex type name='urn:iso:15118:2:2016:MsgBody,VehicleCheckOutReqType',  base type name='BodyBaseType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgBody":EVCheckOutStatus,"urn:iso:15118:2:2016:MsgBody":CheckOutTime)',  derivedBy='EXTENSION'.  */
struct iso2VehicleCheckOutReqType {
	/* element: "urn:iso:15118:2:2016:MsgBody":EVCheckOutStatus, urn:iso:15118:2:2016:MsgDataTypes,EVCheckOutStatusType */
	iso2EVCheckOutStatusType EVCheckOutStatus ;
	/* element: "urn:iso:15118:2:2016:MsgBody":CheckOutTime, http://www.w3.org/2001/XMLSchema,unsignedLong */
	uint64_t CheckOutTime ;
};

/* Complex type name='urn:iso:15118:2:2016:MsgBody,AlignmentCheckResType',  base type name='V2GResponseType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='(("urn:iso:15118:2:2016:MsgBody":ResponseCode,"urn:iso:15118:2:2016:MsgBody":EVSEStatus{0-1}),("urn:iso:15118:2:2016:MsgBody":EVSEProcessing,"urn:iso:15118:2:2016:MsgBody":AlignmentCheckParameters{0-1}))',  derivedBy='EXTENSION'.  */
struct iso2AlignmentCheckResType {
	/* element: "urn:iso:15118:2:2016:MsgBody":ResponseCode, urn:iso:15118:2:2016:MsgDataTypes,responseCodeType */
	iso2responseCodeType ResponseCode ;
	/* element: "urn:iso:15118:2:2016:MsgBody":EVSEStatus, Complex type name='urn:iso:15118:2:2016:MsgDataTypes,EVSEStatusType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgDataTypes":NotificationMaxDelay,"urn:iso:15118:2:2016:MsgDataTypes":EVSENotification)',  derivedBy='RESTRICTION'.  */
	struct iso2EVSEStatusType EVSEStatus ;
	unsigned int EVSEStatus_isUsed:1;
	/* element: "urn:iso:15118:2:2016:MsgBody":EVSEProcessing, urn:iso:15118:2:2016:MsgDataTypes,EVSEProcessingType */
	iso2EVSEProcessingType EVSEProcessing ;
	/* element: "urn:iso:15118:2:2016:MsgBody":AlignmentCheckParameters, Complex type name='urn:iso:15118:2:2016:MsgDataTypes,ParameterSetType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgDataTypes":ParameterSetID,"urn:iso:15118:2:2016:MsgDataTypes":Parameter{1-16})',  derivedBy='RESTRICTION'.  */
	struct iso2ParameterSetType AlignmentCheckParameters ;
	unsigned int AlignmentCheckParameters_isUsed:1;
};

/* Complex type name='urn:iso:15118:2:2016:MsgDataTypes,MinimumPMaxRequestType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgDataTypes":MinimumPMaxScheduleEntry{1-3})',  derivedBy='RESTRICTION'.  */
#define iso2MinimumPMaxRequestType_MinimumPMaxScheduleEntry_ARRAY_SIZE 3
struct iso2MinimumPMaxRequestType {
	/* element: "urn:iso:15118:2:2016:MsgDataTypes":MinimumPMaxScheduleEntry, Complex type name='urn:iso:15118:2:2016:MsgDataTypes,PMaxScheduleEntryType',  base type name='EntryType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='(("urn:iso:15118:2:2016:MsgDataTypes":RelativeTimeInterval),("urn:iso:15118:2:2016:MsgDataTypes":PMax{1-3}))',  derivedBy='EXTENSION'.  */
	struct {
		struct iso2PMaxScheduleEntryType array[iso2MinimumPMaxRequestType_MinimumPMaxScheduleEntry_ARRAY_SIZE];
		uint16_t arrayLen;
	} MinimumPMaxScheduleEntry;
};

/* Complex type name='urn:iso:15118:2:2016:MsgBody,DisconnectChargingDeviceResType',  base type name='V2GResponseType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='(("urn:iso:15118:2:2016:MsgBody":ResponseCode,"urn:iso:15118:2:2016:MsgBody":EVSEStatus{0-1}),("urn:iso:15118:2:2016:MsgBody":EVSEProcessing,"urn:iso:15118:2:2016:MsgBody":EVSEElectricalChargingDeviceStatus,"urn:iso:15118:2:2016:MsgBody":EVSEMechanicalChargingDeviceStatus))',  derivedBy='EXTENSION'.  */
struct iso2DisconnectChargingDeviceResType {
	/* element: "urn:iso:15118:2:2016:MsgBody":ResponseCode, urn:iso:15118:2:2016:MsgDataTypes,responseCodeType */
	iso2responseCodeType ResponseCode ;
	/* element: "urn:iso:15118:2:2016:MsgBody":EVSEStatus, Complex type name='urn:iso:15118:2:2016:MsgDataTypes,EVSEStatusType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgDataTypes":NotificationMaxDelay,"urn:iso:15118:2:2016:MsgDataTypes":EVSENotification)',  derivedBy='RESTRICTION'.  */
	struct iso2EVSEStatusType EVSEStatus ;
	unsigned int EVSEStatus_isUsed:1;
	/* element: "urn:iso:15118:2:2016:MsgBody":EVSEProcessing, urn:iso:15118:2:2016:MsgDataTypes,EVSEProcessingType */
	iso2EVSEProcessingType EVSEProcessing ;
	/* element: "urn:iso:15118:2:2016:MsgBody":EVSEElectricalChargingDeviceStatus, urn:iso:15118:2:2016:MsgDataTypes,electricalChargingDeviceStatusType */
	iso2electricalChargingDeviceStatusType EVSEElectricalChargingDeviceStatus ;
	/* element: "urn:iso:15118:2:2016:MsgBody":EVSEMechanicalChargingDeviceStatus, urn:iso:15118:2:2016:MsgDataTypes,mechanicalChargingDeviceStatusType */
	iso2mechanicalChargingDeviceStatusType EVSEMechanicalChargingDeviceStatus ;
};

/* Complex type name='urn:iso:15118:2:2016:MsgBody,PaymentDetailsReqType',  base type name='BodyBaseType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgBody":eMAID,"urn:iso:15118:2:2016:MsgBody":ContractSignatureCertChain)',  derivedBy='EXTENSION'.  */
#define iso2PaymentDetailsReqType_eMAID_CHARACTERS_SIZE 15 + EXTRA_CHAR /* XML schema facet maxLength for urn:iso:15118:2:2016:MsgDataTypes,eMAIDType is 15 */
struct iso2PaymentDetailsReqType {
	/* element: "urn:iso:15118:2:2016:MsgBody":eMAID, urn:iso:15118:2:2016:MsgDataTypes,eMAIDType */
	struct {
		exi_string_character_t characters[iso2PaymentDetailsReqType_eMAID_CHARACTERS_SIZE];
		uint16_t charactersLen;
	}  eMAID ;
	/* element: "urn:iso:15118:2:2016:MsgBody":ContractSignatureCertChain, Complex type name='urn:iso:15118:2:2016:MsgDataTypes,CertificateChainType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgDataTypes":Certificate,"urn:iso:15118:2:2016:MsgDataTypes":SubCertificates{0-1})',  derivedBy='RESTRICTION'.  */
	struct iso2CertificateChainType ContractSignatureCertChain ;
};

/* Complex type name='urn:iso:15118:2:2016:MsgDataTypes,Generic_EVFinePositioningParametersType',  base type name='EVFinePositioningParametersType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgDataTypes":GenericParameters)',  derivedBy='EXTENSION'.  */
struct iso2Generic_EVFinePositioningParametersType {
	/* element: "urn:iso:15118:2:2016:MsgDataTypes":GenericParameters, Complex type name='urn:iso:15118:2:2016:MsgDataTypes,ParameterSetType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgDataTypes":ParameterSetID,"urn:iso:15118:2:2016:MsgDataTypes":Parameter{1-16})',  derivedBy='RESTRICTION'.  */
	struct iso2ParameterSetType GenericParameters ;
};

/* Complex type name='urn:iso:15118:2:2016:MsgBody,ConnectChargingDeviceReqType',  base type name='BodyBaseType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgBody":EVElectricalChargingDeviceStatus,"urn:iso:15118:2:2016:MsgBody":EVMechanicalChargingDeviceStatus)',  derivedBy='EXTENSION'.  */
struct iso2ConnectChargingDeviceReqType {
	/* element: "urn:iso:15118:2:2016:MsgBody":EVElectricalChargingDeviceStatus, urn:iso:15118:2:2016:MsgDataTypes,electricalChargingDeviceStatusType */
	iso2electricalChargingDeviceStatusType EVElectricalChargingDeviceStatus ;
	/* element: "urn:iso:15118:2:2016:MsgBody":EVMechanicalChargingDeviceStatus, urn:iso:15118:2:2016:MsgDataTypes,mechanicalChargingDeviceStatusType */
	iso2mechanicalChargingDeviceStatusType EVMechanicalChargingDeviceStatus ;
};

/* Complex type name='urn:iso:15118:2:2016:MsgDataTypes,AC_EVSEChargeParameterType',  base type name='EVSEEnergyTransferParameterType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgDataTypes":EVSEMaximumChargeCurrent,"urn:iso:15118:2:2016:MsgDataTypes":EVSENominalVoltage,"urn:iso:15118:2:2016:MsgDataTypes":EVSENominalFrequency)',  derivedBy='EXTENSION'.  */
struct iso2AC_EVSEChargeParameterType {
	/* element: "urn:iso:15118:2:2016:MsgDataTypes":EVSEMaximumChargeCurrent, Complex type name='urn:iso:15118:2:2016:MsgDataTypes,PhysicalValueType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgDataTypes":Exponent,"urn:iso:15118:2:2016:MsgDataTypes":Value)',  derivedBy='RESTRICTION'.  */
	struct iso2PhysicalValueType EVSEMaximumChargeCurrent ;
	/* element: "urn:iso:15118:2:2016:MsgDataTypes":EVSENominalVoltage, Complex type name='urn:iso:15118:2:2016:MsgDataTypes,PhysicalValueType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgDataTypes":Exponent,"urn:iso:15118:2:2016:MsgDataTypes":Value)',  derivedBy='RESTRICTION'.  */
	struct iso2PhysicalValueType EVSENominalVoltage ;
	/* element: "urn:iso:15118:2:2016:MsgDataTypes":EVSENominalFrequency, Complex type name='urn:iso:15118:2:2016:MsgDataTypes,PhysicalValueType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgDataTypes":Exponent,"urn:iso:15118:2:2016:MsgDataTypes":Value)',  derivedBy='RESTRICTION'.  */
	struct iso2PhysicalValueType EVSENominalFrequency ;
};

/* Complex type name='urn:iso:15118:2:2016:MsgDataTypes,SalesTariffEntryType',  base type name='EntryType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='(("urn:iso:15118:2:2016:MsgDataTypes":RelativeTimeInterval),("urn:iso:15118:2:2016:MsgDataTypes":EPriceLevel{0-1},"urn:iso:15118:2:2016:MsgDataTypes":ConsumptionCost{0-3}))',  derivedBy='EXTENSION'.  */
#define iso2SalesTariffEntryType_ConsumptionCost_ARRAY_SIZE 3
struct iso2SalesTariffEntryType {
	/* element: "urn:iso:15118:2:2016:MsgDataTypes":RelativeTimeInterval, Complex type name='urn:iso:15118:2:2016:MsgDataTypes,RelativeTimeIntervalType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgDataTypes":start,"urn:iso:15118:2:2016:MsgDataTypes":duration{0-1})',  derivedBy='RESTRICTION'.  */
	struct iso2RelativeTimeIntervalType RelativeTimeInterval ;
	/* element: "urn:iso:15118:2:2016:MsgDataTypes":EPriceLevel, http://www.w3.org/2001/XMLSchema,unsignedByte */
	uint8_t EPriceLevel ;
	unsigned int EPriceLevel_isUsed:1;
	/* element: "urn:iso:15118:2:2016:MsgDataTypes":ConsumptionCost, Complex type name='urn:iso:15118:2:2016:MsgDataTypes,ConsumptionCostType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgDataTypes":startValue,"urn:iso:15118:2:2016:MsgDataTypes":Cost{1-3})',  derivedBy='RESTRICTION'.  */
	struct {
		struct iso2ConsumptionCostType array[iso2SalesTariffEntryType_ConsumptionCost_ARRAY_SIZE];
		uint16_t arrayLen;
	} ConsumptionCost;
};

/* Complex type name='urn:iso:15118:2:2016:MsgDataTypes,DC_EVSEBidirectionalParameterType',  base type name='DC_EVSEChargeParameterType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='(("urn:iso:15118:2:2016:MsgDataTypes":EVSEMaximumChargePower,"urn:iso:15118:2:2016:MsgDataTypes":EVSEMaximumChargeCurrent,"urn:iso:15118:2:2016:MsgDataTypes":EVSEMinimumChargeCurrent,"urn:iso:15118:2:2016:MsgDataTypes":EVSEMaximumVoltage,"urn:iso:15118:2:2016:MsgDataTypes":EVSEMinimumVoltage,"urn:iso:15118:2:2016:MsgDataTypes":EVSECurrentRegulationTolerance{0-1},"urn:iso:15118:2:2016:MsgDataTypes":EVSEPeakCurrentRipple,"urn:iso:15118:2:2016:MsgDataTypes":EVSEEnergyToBeDelivered{0-1}),("urn:iso:15118:2:2016:MsgDataTypes":EVSEMaximumDischargePower,"urn:iso:15118:2:2016:MsgDataTypes":EVSEMaximumDischargeCurrent,"urn:iso:15118:2:2016:MsgDataTypes":EVSEMinimumDischargeCurrent))',  derivedBy='EXTENSION'.  */
struct iso2DC_EVSEBidirectionalParameterType {
	/* element: "urn:iso:15118:2:2016:MsgDataTypes":EVSEMaximumChargePower, Complex type name='urn:iso:15118:2:2016:MsgDataTypes,PhysicalValueType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgDataTypes":Exponent,"urn:iso:15118:2:2016:MsgDataTypes":Value)',  derivedBy='RESTRICTION'.  */
	struct iso2PhysicalValueType EVSEMaximumChargePower ;
	/* element: "urn:iso:15118:2:2016:MsgDataTypes":EVSEMaximumChargeCurrent, Complex type name='urn:iso:15118:2:2016:MsgDataTypes,PhysicalValueType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgDataTypes":Exponent,"urn:iso:15118:2:2016:MsgDataTypes":Value)',  derivedBy='RESTRICTION'.  */
	struct iso2PhysicalValueType EVSEMaximumChargeCurrent ;
	/* element: "urn:iso:15118:2:2016:MsgDataTypes":EVSEMinimumChargeCurrent, Complex type name='urn:iso:15118:2:2016:MsgDataTypes,PhysicalValueType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgDataTypes":Exponent,"urn:iso:15118:2:2016:MsgDataTypes":Value)',  derivedBy='RESTRICTION'.  */
	struct iso2PhysicalValueType EVSEMinimumChargeCurrent ;
	/* element: "urn:iso:15118:2:2016:MsgDataTypes":EVSEMaximumVoltage, Complex type name='urn:iso:15118:2:2016:MsgDataTypes,PhysicalValueType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgDataTypes":Exponent,"urn:iso:15118:2:2016:MsgDataTypes":Value)',  derivedBy='RESTRICTION'.  */
	struct iso2PhysicalValueType EVSEMaximumVoltage ;
	/* element: "urn:iso:15118:2:2016:MsgDataTypes":EVSEMinimumVoltage, Complex type name='urn:iso:15118:2:2016:MsgDataTypes,PhysicalValueType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgDataTypes":Exponent,"urn:iso:15118:2:2016:MsgDataTypes":Value)',  derivedBy='RESTRICTION'.  */
	struct iso2PhysicalValueType EVSEMinimumVoltage ;
	/* element: "urn:iso:15118:2:2016:MsgDataTypes":EVSECurrentRegulationTolerance, Complex type name='urn:iso:15118:2:2016:MsgDataTypes,PhysicalValueType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgDataTypes":Exponent,"urn:iso:15118:2:2016:MsgDataTypes":Value)',  derivedBy='RESTRICTION'.  */
	struct iso2PhysicalValueType EVSECurrentRegulationTolerance ;
	unsigned int EVSECurrentRegulationTolerance_isUsed:1;
	/* element: "urn:iso:15118:2:2016:MsgDataTypes":EVSEPeakCurrentRipple, Complex type name='urn:iso:15118:2:2016:MsgDataTypes,PhysicalValueType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgDataTypes":Exponent,"urn:iso:15118:2:2016:MsgDataTypes":Value)',  derivedBy='RESTRICTION'.  */
	struct iso2PhysicalValueType EVSEPeakCurrentRipple ;
	/* element: "urn:iso:15118:2:2016:MsgDataTypes":EVSEEnergyToBeDelivered, Complex type name='urn:iso:15118:2:2016:MsgDataTypes,PhysicalValueType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgDataTypes":Exponent,"urn:iso:15118:2:2016:MsgDataTypes":Value)',  derivedBy='RESTRICTION'.  */
	struct iso2PhysicalValueType EVSEEnergyToBeDelivered ;
	unsigned int EVSEEnergyToBeDelivered_isUsed:1;
	/* element: "urn:iso:15118:2:2016:MsgDataTypes":EVSEMaximumDischargePower, Complex type name='urn:iso:15118:2:2016:MsgDataTypes,PhysicalValueType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgDataTypes":Exponent,"urn:iso:15118:2:2016:MsgDataTypes":Value)',  derivedBy='RESTRICTION'.  */
	struct iso2PhysicalValueType EVSEMaximumDischargePower ;
	/* element: "urn:iso:15118:2:2016:MsgDataTypes":EVSEMaximumDischargeCurrent, Complex type name='urn:iso:15118:2:2016:MsgDataTypes,PhysicalValueType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgDataTypes":Exponent,"urn:iso:15118:2:2016:MsgDataTypes":Value)',  derivedBy='RESTRICTION'.  */
	struct iso2PhysicalValueType EVSEMaximumDischargeCurrent ;
	/* element: "urn:iso:15118:2:2016:MsgDataTypes":EVSEMinimumDischargeCurrent, Complex type name='urn:iso:15118:2:2016:MsgDataTypes,PhysicalValueType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgDataTypes":Exponent,"urn:iso:15118:2:2016:MsgDataTypes":Value)',  derivedBy='RESTRICTION'.  */
	struct iso2PhysicalValueType EVSEMinimumDischargeCurrent ;
};

/* Complex type name='urn:iso:15118:2:2016:MsgDataTypes,DisplayParametersType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgDataTypes":CurrentRange{0-1},"urn:iso:15118:2:2016:MsgDataTypes":CurrentSOC{0-1},"urn:iso:15118:2:2016:MsgDataTypes":TargetSOC{0-1},"urn:iso:15118:2:2016:MsgDataTypes":BulkSOC{0-1},"urn:iso:15118:2:2016:MsgDataTypes":MinimumSOC{0-1},"urn:iso:15118:2:2016:MsgDataTypes":ChargingPerformance{0-1},"urn:iso:15118:2:2016:MsgDataTypes":RemainingTimeToTargetSOC{0-1},"urn:iso:15118:2:2016:MsgDataTypes":RemainingTimeToBulkSOC{0-1},"urn:iso:15118:2:2016:MsgDataTypes":RemainingTimeToMinimumSOC{0-1},"urn:iso:15118:2:2016:MsgDataTypes":ChargingComplete{0-1},"urn:iso:15118:2:2016:MsgDataTypes":BulkChargingComplete{0-1},"urn:iso:15118:2:2016:MsgDataTypes":InletHot{0-1})',  derivedBy='RESTRICTION'.  */
struct iso2DisplayParametersType {
	/* element: "urn:iso:15118:2:2016:MsgDataTypes":CurrentRange, http://www.w3.org/2001/XMLSchema,unsignedShort */
	uint16_t CurrentRange ;
	unsigned int CurrentRange_isUsed:1;
	/* element: "urn:iso:15118:2:2016:MsgDataTypes":CurrentSOC, urn:iso:15118:2:2016:MsgDataTypes,percentValueType */
	int8_t CurrentSOC ;
	unsigned int CurrentSOC_isUsed:1;
	/* element: "urn:iso:15118:2:2016:MsgDataTypes":TargetSOC, urn:iso:15118:2:2016:MsgDataTypes,percentValueType */
	int8_t TargetSOC ;
	unsigned int TargetSOC_isUsed:1;
	/* element: "urn:iso:15118:2:2016:MsgDataTypes":BulkSOC, urn:iso:15118:2:2016:MsgDataTypes,percentValueType */
	int8_t BulkSOC ;
	unsigned int BulkSOC_isUsed:1;
	/* element: "urn:iso:15118:2:2016:MsgDataTypes":MinimumSOC, urn:iso:15118:2:2016:MsgDataTypes,percentValueType */
	int8_t MinimumSOC ;
	unsigned int MinimumSOC_isUsed:1;
	/* element: "urn:iso:15118:2:2016:MsgDataTypes":ChargingPerformance, Complex type name='urn:iso:15118:2:2016:MsgDataTypes,PhysicalValueType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgDataTypes":Exponent,"urn:iso:15118:2:2016:MsgDataTypes":Value)',  derivedBy='RESTRICTION'.  */
	struct iso2PhysicalValueType ChargingPerformance ;
	unsigned int ChargingPerformance_isUsed:1;
	/* element: "urn:iso:15118:2:2016:MsgDataTypes":RemainingTimeToTargetSOC, urn:iso:15118:2:2016:MsgDataTypes,percentValueType */
	int8_t RemainingTimeToTargetSOC ;
	unsigned int RemainingTimeToTargetSOC_isUsed:1;
	/* element: "urn:iso:15118:2:2016:MsgDataTypes":RemainingTimeToBulkSOC, urn:iso:15118:2:2016:MsgDataTypes,percentValueType */
	int8_t RemainingTimeToBulkSOC ;
	unsigned int RemainingTimeToBulkSOC_isUsed:1;
	/* element: "urn:iso:15118:2:2016:MsgDataTypes":RemainingTimeToMinimumSOC, urn:iso:15118:2:2016:MsgDataTypes,percentValueType */
	int8_t RemainingTimeToMinimumSOC ;
	unsigned int RemainingTimeToMinimumSOC_isUsed:1;
	/* element: "urn:iso:15118:2:2016:MsgDataTypes":ChargingComplete, http://www.w3.org/2001/XMLSchema,boolean */
	int ChargingComplete ;
	unsigned int ChargingComplete_isUsed:1;
	/* element: "urn:iso:15118:2:2016:MsgDataTypes":BulkChargingComplete, http://www.w3.org/2001/XMLSchema,boolean */
	int BulkChargingComplete ;
	unsigned int BulkChargingComplete_isUsed:1;
	/* element: "urn:iso:15118:2:2016:MsgDataTypes":InletHot, http://www.w3.org/2001/XMLSchema,boolean */
	int InletHot ;
	unsigned int InletHot_isUsed:1;
};

/* Complex type name='urn:iso:15118:2:2016:MsgDataTypes,DC_EVBidirectionalParameterType',  base type name='DC_EVChargeParameterType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='((("urn:iso:15118:2:2016:MsgDataTypes":DepartureTime),("urn:iso:15118:2:2016:MsgDataTypes":EVMaximumChargePower{0-1},"urn:iso:15118:2:2016:MsgDataTypes":EVMinimumChargePower{0-1},"urn:iso:15118:2:2016:MsgDataTypes":EVMaximumChargeCurrent,"urn:iso:15118:2:2016:MsgDataTypes":EVMinimumChargeCurrent,"urn:iso:15118:2:2016:MsgDataTypes":EVMaximumVoltage,"urn:iso:15118:2:2016:MsgDataTypes":EVTargetEnergyRequest{0-1},"urn:iso:15118:2:2016:MsgDataTypes":EVMaximumEnergyRequest{0-1},"urn:iso:15118:2:2016:MsgDataTypes":EVMinimumEnergyRequest{0-1},"urn:iso:15118:2:2016:MsgDataTypes":CurrentSOC{0-1},"urn:iso:15118:2:2016:MsgDataTypes":TargetSOC{0-1},"urn:iso:15118:2:2016:MsgDataTypes":BulkSOC{0-1})),("urn:iso:15118:2:2016:MsgDataTypes":EVMaximumDischargePower{0-1},"urn:iso:15118:2:2016:MsgDataTypes":EVMinimumDischargePower{0-1},"urn:iso:15118:2:2016:MsgDataTypes":EVMaximumDischargeCurrent,"urn:iso:15118:2:2016:MsgDataTypes":EVMinimumDischargeCurrent,"urn:iso:15118:2:2016:MsgDataTypes":EVMinimumVoltage,"urn:iso:15118:2:2016:MsgDataTypes":MinimumSOC{0-1}))',  derivedBy='EXTENSION'.  */
struct iso2DC_EVBidirectionalParameterType {
	/* element: "urn:iso:15118:2:2016:MsgDataTypes":DepartureTime, http://www.w3.org/2001/XMLSchema,unsignedInt */
	uint32_t DepartureTime ;
	/* element: "urn:iso:15118:2:2016:MsgDataTypes":EVMaximumChargePower, Complex type name='urn:iso:15118:2:2016:MsgDataTypes,PhysicalValueType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgDataTypes":Exponent,"urn:iso:15118:2:2016:MsgDataTypes":Value)',  derivedBy='RESTRICTION'.  */
	struct iso2PhysicalValueType EVMaximumChargePower ;
	unsigned int EVMaximumChargePower_isUsed:1;
	/* element: "urn:iso:15118:2:2016:MsgDataTypes":EVMinimumChargePower, Complex type name='urn:iso:15118:2:2016:MsgDataTypes,PhysicalValueType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgDataTypes":Exponent,"urn:iso:15118:2:2016:MsgDataTypes":Value)',  derivedBy='RESTRICTION'.  */
	struct iso2PhysicalValueType EVMinimumChargePower ;
	unsigned int EVMinimumChargePower_isUsed:1;
	/* element: "urn:iso:15118:2:2016:MsgDataTypes":EVMaximumChargeCurrent, Complex type name='urn:iso:15118:2:2016:MsgDataTypes,PhysicalValueType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgDataTypes":Exponent,"urn:iso:15118:2:2016:MsgDataTypes":Value)',  derivedBy='RESTRICTION'.  */
	struct iso2PhysicalValueType EVMaximumChargeCurrent ;
	/* element: "urn:iso:15118:2:2016:MsgDataTypes":EVMinimumChargeCurrent, Complex type name='urn:iso:15118:2:2016:MsgDataTypes,PhysicalValueType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgDataTypes":Exponent,"urn:iso:15118:2:2016:MsgDataTypes":Value)',  derivedBy='RESTRICTION'.  */
	struct iso2PhysicalValueType EVMinimumChargeCurrent ;
	/* element: "urn:iso:15118:2:2016:MsgDataTypes":EVMaximumVoltage, Complex type name='urn:iso:15118:2:2016:MsgDataTypes,PhysicalValueType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgDataTypes":Exponent,"urn:iso:15118:2:2016:MsgDataTypes":Value)',  derivedBy='RESTRICTION'.  */
	struct iso2PhysicalValueType EVMaximumVoltage ;
	/* element: "urn:iso:15118:2:2016:MsgDataTypes":EVTargetEnergyRequest, Complex type name='urn:iso:15118:2:2016:MsgDataTypes,PhysicalValueType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgDataTypes":Exponent,"urn:iso:15118:2:2016:MsgDataTypes":Value)',  derivedBy='RESTRICTION'.  */
	struct iso2PhysicalValueType EVTargetEnergyRequest ;
	unsigned int EVTargetEnergyRequest_isUsed:1;
	/* element: "urn:iso:15118:2:2016:MsgDataTypes":EVMaximumEnergyRequest, Complex type name='urn:iso:15118:2:2016:MsgDataTypes,PhysicalValueType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgDataTypes":Exponent,"urn:iso:15118:2:2016:MsgDataTypes":Value)',  derivedBy='RESTRICTION'.  */
	struct iso2PhysicalValueType EVMaximumEnergyRequest ;
	unsigned int EVMaximumEnergyRequest_isUsed:1;
	/* element: "urn:iso:15118:2:2016:MsgDataTypes":EVMinimumEnergyRequest, Complex type name='urn:iso:15118:2:2016:MsgDataTypes,PhysicalValueType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgDataTypes":Exponent,"urn:iso:15118:2:2016:MsgDataTypes":Value)',  derivedBy='RESTRICTION'.  */
	struct iso2PhysicalValueType EVMinimumEnergyRequest ;
	unsigned int EVMinimumEnergyRequest_isUsed:1;
	/* element: "urn:iso:15118:2:2016:MsgDataTypes":CurrentSOC, urn:iso:15118:2:2016:MsgDataTypes,percentValueType */
	int8_t CurrentSOC ;
	unsigned int CurrentSOC_isUsed:1;
	/* element: "urn:iso:15118:2:2016:MsgDataTypes":TargetSOC, urn:iso:15118:2:2016:MsgDataTypes,percentValueType */
	int8_t TargetSOC ;
	unsigned int TargetSOC_isUsed:1;
	/* element: "urn:iso:15118:2:2016:MsgDataTypes":BulkSOC, urn:iso:15118:2:2016:MsgDataTypes,percentValueType */
	int8_t BulkSOC ;
	unsigned int BulkSOC_isUsed:1;
	/* element: "urn:iso:15118:2:2016:MsgDataTypes":EVMaximumDischargePower, Complex type name='urn:iso:15118:2:2016:MsgDataTypes,PhysicalValueType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgDataTypes":Exponent,"urn:iso:15118:2:2016:MsgDataTypes":Value)',  derivedBy='RESTRICTION'.  */
	struct iso2PhysicalValueType EVMaximumDischargePower ;
	unsigned int EVMaximumDischargePower_isUsed:1;
	/* element: "urn:iso:15118:2:2016:MsgDataTypes":EVMinimumDischargePower, Complex type name='urn:iso:15118:2:2016:MsgDataTypes,PhysicalValueType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgDataTypes":Exponent,"urn:iso:15118:2:2016:MsgDataTypes":Value)',  derivedBy='RESTRICTION'.  */
	struct iso2PhysicalValueType EVMinimumDischargePower ;
	unsigned int EVMinimumDischargePower_isUsed:1;
	/* element: "urn:iso:15118:2:2016:MsgDataTypes":EVMaximumDischargeCurrent, Complex type name='urn:iso:15118:2:2016:MsgDataTypes,PhysicalValueType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgDataTypes":Exponent,"urn:iso:15118:2:2016:MsgDataTypes":Value)',  derivedBy='RESTRICTION'.  */
	struct iso2PhysicalValueType EVMaximumDischargeCurrent ;
	/* element: "urn:iso:15118:2:2016:MsgDataTypes":EVMinimumDischargeCurrent, Complex type name='urn:iso:15118:2:2016:MsgDataTypes,PhysicalValueType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgDataTypes":Exponent,"urn:iso:15118:2:2016:MsgDataTypes":Value)',  derivedBy='RESTRICTION'.  */
	struct iso2PhysicalValueType EVMinimumDischargeCurrent ;
	/* element: "urn:iso:15118:2:2016:MsgDataTypes":EVMinimumVoltage, Complex type name='urn:iso:15118:2:2016:MsgDataTypes,PhysicalValueType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgDataTypes":Exponent,"urn:iso:15118:2:2016:MsgDataTypes":Value)',  derivedBy='RESTRICTION'.  */
	struct iso2PhysicalValueType EVMinimumVoltage ;
	/* element: "urn:iso:15118:2:2016:MsgDataTypes":MinimumSOC, urn:iso:15118:2:2016:MsgDataTypes,percentValueType */
	int8_t MinimumSOC ;
	unsigned int MinimumSOC_isUsed:1;
};

/* Complex type name='urn:iso:15118:2:2016:MsgDataTypes,MagneticVectorType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgDataTypes":GAID,"urn:iso:15118:2:2016:MsgDataTypes":Distance,"urn:iso:15118:2:2016:MsgDataTypes":AngleGAtoVA,"urn:iso:15118:2:2016:MsgDataTypes":RotationVAtoGA,"urn:iso:15118:2:2016:MsgDataTypes":FODStatus)',  derivedBy='RESTRICTION'.  */
#define iso2MagneticVectorType_GAID_CHARACTERS_SIZE 50 + EXTRA_CHAR 
struct iso2MagneticVectorType {
	/* element: "urn:iso:15118:2:2016:MsgDataTypes":GAID, http://www.w3.org/2001/XMLSchema,ID */
	struct {
		exi_string_character_t characters[iso2MagneticVectorType_GAID_CHARACTERS_SIZE];
		uint16_t charactersLen;
	}  GAID ;
	/* element: "urn:iso:15118:2:2016:MsgDataTypes":Distance, http://www.w3.org/2001/XMLSchema,unsignedShort */
	uint16_t Distance ;
	/* element: "urn:iso:15118:2:2016:MsgDataTypes":AngleGAtoVA, Complex type name='urn:iso:15118:2:2016:MsgDataTypes,PhysicalValueType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgDataTypes":Exponent,"urn:iso:15118:2:2016:MsgDataTypes":Value)',  derivedBy='RESTRICTION'.  */
	struct iso2PhysicalValueType AngleGAtoVA ;
	/* element: "urn:iso:15118:2:2016:MsgDataTypes":RotationVAtoGA, Complex type name='urn:iso:15118:2:2016:MsgDataTypes,PhysicalValueType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgDataTypes":Exponent,"urn:iso:15118:2:2016:MsgDataTypes":Value)',  derivedBy='RESTRICTION'.  */
	struct iso2PhysicalValueType RotationVAtoGA ;
	/* element: "urn:iso:15118:2:2016:MsgDataTypes":FODStatus, urn:iso:15118:2:2016:MsgDataTypes,FODStatusType */
	iso2FODStatusType FODStatus ;
};

/* Complex type name='urn:iso:15118:2:2016:MsgBody,SystemStatusResType',  base type name='V2GResponseType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='(("urn:iso:15118:2:2016:MsgBody":ResponseCode,"urn:iso:15118:2:2016:MsgBody":EVSEStatus{0-1}),("urn:iso:15118:2:2016:MsgBody":OperationMode,"urn:iso:15118:2:2016:MsgBody":EVSEMechanicalChargingDeviceStatus))',  derivedBy='EXTENSION'.  */
struct iso2SystemStatusResType {
	/* element: "urn:iso:15118:2:2016:MsgBody":ResponseCode, urn:iso:15118:2:2016:MsgDataTypes,responseCodeType */
	iso2responseCodeType ResponseCode ;
	/* element: "urn:iso:15118:2:2016:MsgBody":EVSEStatus, Complex type name='urn:iso:15118:2:2016:MsgDataTypes,EVSEStatusType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgDataTypes":NotificationMaxDelay,"urn:iso:15118:2:2016:MsgDataTypes":EVSENotification)',  derivedBy='RESTRICTION'.  */
	struct iso2EVSEStatusType EVSEStatus ;
	unsigned int EVSEStatus_isUsed:1;
	/* element: "urn:iso:15118:2:2016:MsgBody":OperationMode, urn:iso:15118:2:2016:MsgDataTypes,operationModeType */
	iso2operationModeType OperationMode ;
	/* element: "urn:iso:15118:2:2016:MsgBody":EVSEMechanicalChargingDeviceStatus, urn:iso:15118:2:2016:MsgDataTypes,mechanicalChargingDeviceStatusType */
	iso2mechanicalChargingDeviceStatusType EVSEMechanicalChargingDeviceStatus ;
};

/* Complex type name='urn:iso:15118:2:2016:MsgBody,V2GResponseType',  base type name='BodyBaseType',  content type='ELEMENT',  isAbstract='true',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgBody":ResponseCode,"urn:iso:15118:2:2016:MsgBody":EVSEStatus{0-1})',  derivedBy='EXTENSION'.  */
struct iso2V2GResponseType {
	/* element: "urn:iso:15118:2:2016:MsgBody":ResponseCode, urn:iso:15118:2:2016:MsgDataTypes,responseCodeType */
	iso2responseCodeType ResponseCode ;
	/* element: "urn:iso:15118:2:2016:MsgBody":EVSEStatus, Complex type name='urn:iso:15118:2:2016:MsgDataTypes,EVSEStatusType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgDataTypes":NotificationMaxDelay,"urn:iso:15118:2:2016:MsgDataTypes":EVSENotification)',  derivedBy='RESTRICTION'.  */
	struct iso2EVSEStatusType EVSEStatus ;
	unsigned int EVSEStatus_isUsed:1;
};

/* Complex type name='urn:iso:15118:2:2016:MsgBody,PreChargeResType',  base type name='V2GResponseType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='(("urn:iso:15118:2:2016:MsgBody":ResponseCode,"urn:iso:15118:2:2016:MsgBody":EVSEStatus{0-1}),("urn:iso:15118:2:2016:MsgBody":EVSEPresentVoltage))',  derivedBy='EXTENSION'.  */
struct iso2PreChargeResType {
	/* element: "urn:iso:15118:2:2016:MsgBody":ResponseCode, urn:iso:15118:2:2016:MsgDataTypes,responseCodeType */
	iso2responseCodeType ResponseCode ;
	/* element: "urn:iso:15118:2:2016:MsgBody":EVSEStatus, Complex type name='urn:iso:15118:2:2016:MsgDataTypes,EVSEStatusType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgDataTypes":NotificationMaxDelay,"urn:iso:15118:2:2016:MsgDataTypes":EVSENotification)',  derivedBy='RESTRICTION'.  */
	struct iso2EVSEStatusType EVSEStatus ;
	unsigned int EVSEStatus_isUsed:1;
	/* element: "urn:iso:15118:2:2016:MsgBody":EVSEPresentVoltage, Complex type name='urn:iso:15118:2:2016:MsgDataTypes,PhysicalValueType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgDataTypes":Exponent,"urn:iso:15118:2:2016:MsgDataTypes":Value)',  derivedBy='RESTRICTION'.  */
	struct iso2PhysicalValueType EVSEPresentVoltage ;
};

/* Complex type name='urn:iso:15118:2:2016:MsgBody,PaymentServiceSelectionResType',  base type name='V2GResponseType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgBody":ResponseCode,"urn:iso:15118:2:2016:MsgBody":EVSEStatus{0-1})',  derivedBy='EXTENSION'.  */
struct iso2PaymentServiceSelectionResType {
	/* element: "urn:iso:15118:2:2016:MsgBody":ResponseCode, urn:iso:15118:2:2016:MsgDataTypes,responseCodeType */
	iso2responseCodeType ResponseCode ;
	/* element: "urn:iso:15118:2:2016:MsgBody":EVSEStatus, Complex type name='urn:iso:15118:2:2016:MsgDataTypes,EVSEStatusType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgDataTypes":NotificationMaxDelay,"urn:iso:15118:2:2016:MsgDataTypes":EVSENotification)',  derivedBy='RESTRICTION'.  */
	struct iso2EVSEStatusType EVSEStatus ;
	unsigned int EVSEStatus_isUsed:1;
};

/* Complex type name='http://www.w3.org/2000/09/xmldsig#,ManifestType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("http://www.w3.org/2000/09/xmldsig#":Reference{1-UNBOUNDED})',  derivedBy='RESTRICTION'.  */
#define iso2ManifestType_Id_CHARACTERS_SIZE 50 + EXTRA_CHAR 
#define iso2ManifestType_Reference_ARRAY_SIZE 1
struct iso2ManifestType {
	/* attribute: Id {http://www.w3.org/2001/XMLSchema,ID} */
	struct {
		exi_string_character_t characters[iso2ManifestType_Id_CHARACTERS_SIZE];
		uint16_t charactersLen;
	}  Id ;
	unsigned int Id_isUsed:1;
	/* element: "http://www.w3.org/2000/09/xmldsig#":Reference, Complex type name='http://www.w3.org/2000/09/xmldsig#,ReferenceType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("http://www.w3.org/2000/09/xmldsig#":Transforms{0-1},"http://www.w3.org/2000/09/xmldsig#":DigestMethod,"http://www.w3.org/2000/09/xmldsig#":DigestValue)',  derivedBy='RESTRICTION'.  */
	struct {
		struct iso2ReferenceType array[iso2ManifestType_Reference_ARRAY_SIZE];
		uint16_t arrayLen;
	} Reference;
};

/* Complex type name='urn:iso:15118:2:2016:MsgDataTypes,SelectedServiceListType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgDataTypes":SelectedService{1-16})',  derivedBy='RESTRICTION'.  */
#define iso2SelectedServiceListType_SelectedService_ARRAY_SIZE 16
struct iso2SelectedServiceListType {
	/* element: "urn:iso:15118:2:2016:MsgDataTypes":SelectedService, Complex type name='urn:iso:15118:2:2016:MsgDataTypes,SelectedServiceType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgDataTypes":ServiceID,"urn:iso:15118:2:2016:MsgDataTypes":ParameterSetID)',  derivedBy='RESTRICTION'.  */
	struct {
		struct iso2SelectedServiceType array[iso2SelectedServiceListType_SelectedService_ARRAY_SIZE];
		uint16_t arrayLen;
	} SelectedService;
};

/* Complex type name='urn:iso:15118:2:2016:MsgDataTypes,Generic_EVSEFinePositioningParametersType',  base type name='EVSEFinePositioningParametersType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgDataTypes":GenericParameters)',  derivedBy='EXTENSION'.  */
struct iso2Generic_EVSEFinePositioningParametersType {
	/* element: "urn:iso:15118:2:2016:MsgDataTypes":GenericParameters, Complex type name='urn:iso:15118:2:2016:MsgDataTypes,ParameterSetType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgDataTypes":ParameterSetID,"urn:iso:15118:2:2016:MsgDataTypes":Parameter{1-16})',  derivedBy='RESTRICTION'.  */
	struct iso2ParameterSetType GenericParameters ;
};

/* Complex type name='urn:iso:15118:2:2016:MsgDataTypes,ListOfRootCertificateIDsType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgDataTypes":RootCertificateID{1-20})',  derivedBy='RESTRICTION'.  */
#define iso2ListOfRootCertificateIDsType_RootCertificateID_ARRAY_SIZE 20
struct iso2ListOfRootCertificateIDsType {
	/* element: "urn:iso:15118:2:2016:MsgDataTypes":RootCertificateID, Complex type name='http://www.w3.org/2000/09/xmldsig#,X509IssuerSerialType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("http://www.w3.org/2000/09/xmldsig#":X509IssuerName,"http://www.w3.org/2000/09/xmldsig#":X509SerialNumber)',  derivedBy='RESTRICTION'.  */
	struct {
		struct iso2X509IssuerSerialType array[iso2ListOfRootCertificateIDsType_RootCertificateID_ARRAY_SIZE];
		uint16_t arrayLen;
	} RootCertificateID;
};

/* Complex type name='urn:iso:15118:2:2016:MsgBody,PairingReqType',  base type name='BodyBaseType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgBody":EVProcessing,"urn:iso:15118:2:2016:MsgBody":PairingParameters{0-1})',  derivedBy='EXTENSION'.  */
struct iso2PairingReqType {
	/* element: "urn:iso:15118:2:2016:MsgBody":EVProcessing, urn:iso:15118:2:2016:MsgDataTypes,EVSEProcessingType */
	iso2EVSEProcessingType EVProcessing ;
	/* element: "urn:iso:15118:2:2016:MsgBody":PairingParameters, Complex type name='urn:iso:15118:2:2016:MsgDataTypes,ParameterSetType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgDataTypes":ParameterSetID,"urn:iso:15118:2:2016:MsgDataTypes":Parameter{1-16})',  derivedBy='RESTRICTION'.  */
	struct iso2ParameterSetType PairingParameters ;
	unsigned int PairingParameters_isUsed:1;
};

/* Complex type name='urn:iso:15118:2:2016:MsgBody,CurrentDemandResType',  base type name='V2GResponseType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='(("urn:iso:15118:2:2016:MsgBody":ResponseCode,"urn:iso:15118:2:2016:MsgBody":EVSEStatus{0-1}),("urn:iso:15118:2:2016:MsgBody":EVSEPresentCurrent,"urn:iso:15118:2:2016:MsgBody":EVSEPresentVoltage,"urn:iso:15118:2:2016:MsgBody":EVSEPowerLimitAchieved,"urn:iso:15118:2:2016:MsgBody":EVSECurrentLimitAchieved,"urn:iso:15118:2:2016:MsgBody":EVSEVoltageLimitAchieved,"urn:iso:15118:2:2016:MsgBody":EVSEMaximumPower{0-1},"urn:iso:15118:2:2016:MsgBody":EVSEMaximumCurrent{0-1},"urn:iso:15118:2:2016:MsgBody":EVSEMaximumVoltage{0-1},"urn:iso:15118:2:2016:MsgBody":EVSEID,"urn:iso:15118:2:2016:MsgBody":SAScheduleTupleID{0-1},"urn:iso:15118:2:2016:MsgBody":MeterInfo{0-1},"urn:iso:15118:2:2016:MsgBody":ReceiptRequired{0-1}))',  derivedBy='EXTENSION'.  */
#define iso2CurrentDemandResType_EVSEID_CHARACTERS_SIZE 37 + EXTRA_CHAR /* XML schema facet maxLength for urn:iso:15118:2:2016:MsgDataTypes,evseIDType is 37 */
struct iso2CurrentDemandResType {
	/* element: "urn:iso:15118:2:2016:MsgBody":ResponseCode, urn:iso:15118:2:2016:MsgDataTypes,responseCodeType */
	iso2responseCodeType ResponseCode ;
	/* element: "urn:iso:15118:2:2016:MsgBody":EVSEStatus, Complex type name='urn:iso:15118:2:2016:MsgDataTypes,EVSEStatusType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgDataTypes":NotificationMaxDelay,"urn:iso:15118:2:2016:MsgDataTypes":EVSENotification)',  derivedBy='RESTRICTION'.  */
	struct iso2EVSEStatusType EVSEStatus ;
	unsigned int EVSEStatus_isUsed:1;
	/* element: "urn:iso:15118:2:2016:MsgBody":EVSEPresentCurrent, Complex type name='urn:iso:15118:2:2016:MsgDataTypes,PhysicalValueType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgDataTypes":Exponent,"urn:iso:15118:2:2016:MsgDataTypes":Value)',  derivedBy='RESTRICTION'.  */
	struct iso2PhysicalValueType EVSEPresentCurrent ;
	/* element: "urn:iso:15118:2:2016:MsgBody":EVSEPresentVoltage, Complex type name='urn:iso:15118:2:2016:MsgDataTypes,PhysicalValueType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgDataTypes":Exponent,"urn:iso:15118:2:2016:MsgDataTypes":Value)',  derivedBy='RESTRICTION'.  */
	struct iso2PhysicalValueType EVSEPresentVoltage ;
	/* element: "urn:iso:15118:2:2016:MsgBody":EVSEPowerLimitAchieved, http://www.w3.org/2001/XMLSchema,boolean */
	int EVSEPowerLimitAchieved ;
	/* element: "urn:iso:15118:2:2016:MsgBody":EVSECurrentLimitAchieved, http://www.w3.org/2001/XMLSchema,boolean */
	int EVSECurrentLimitAchieved ;
	/* element: "urn:iso:15118:2:2016:MsgBody":EVSEVoltageLimitAchieved, http://www.w3.org/2001/XMLSchema,boolean */
	int EVSEVoltageLimitAchieved ;
	/* element: "urn:iso:15118:2:2016:MsgBody":EVSEMaximumPower, Complex type name='urn:iso:15118:2:2016:MsgDataTypes,PhysicalValueType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgDataTypes":Exponent,"urn:iso:15118:2:2016:MsgDataTypes":Value)',  derivedBy='RESTRICTION'.  */
	struct iso2PhysicalValueType EVSEMaximumPower ;
	unsigned int EVSEMaximumPower_isUsed:1;
	/* element: "urn:iso:15118:2:2016:MsgBody":EVSEMaximumCurrent, Complex type name='urn:iso:15118:2:2016:MsgDataTypes,PhysicalValueType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgDataTypes":Exponent,"urn:iso:15118:2:2016:MsgDataTypes":Value)',  derivedBy='RESTRICTION'.  */
	struct iso2PhysicalValueType EVSEMaximumCurrent ;
	unsigned int EVSEMaximumCurrent_isUsed:1;
	/* element: "urn:iso:15118:2:2016:MsgBody":EVSEMaximumVoltage, Complex type name='urn:iso:15118:2:2016:MsgDataTypes,PhysicalValueType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgDataTypes":Exponent,"urn:iso:15118:2:2016:MsgDataTypes":Value)',  derivedBy='RESTRICTION'.  */
	struct iso2PhysicalValueType EVSEMaximumVoltage ;
	unsigned int EVSEMaximumVoltage_isUsed:1;
	/* element: "urn:iso:15118:2:2016:MsgBody":EVSEID, urn:iso:15118:2:2016:MsgDataTypes,evseIDType */
	struct {
		exi_string_character_t characters[iso2CurrentDemandResType_EVSEID_CHARACTERS_SIZE];
		uint16_t charactersLen;
	}  EVSEID ;
	/* element: "urn:iso:15118:2:2016:MsgBody":SAScheduleTupleID, urn:iso:15118:2:2016:MsgDataTypes,SAIDType */
	uint8_t SAScheduleTupleID ;
	unsigned int SAScheduleTupleID_isUsed:1;
	/* element: "urn:iso:15118:2:2016:MsgBody":MeterInfo, Complex type name='urn:iso:15118:2:2016:MsgDataTypes,MeterInfoType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgDataTypes":MeterID,"urn:iso:15118:2:2016:MsgDataTypes":MeterReadingCharged{0-1},"urn:iso:15118:2:2016:MsgDataTypes":MeterReadingDischarged{0-1},"urn:iso:15118:2:2016:MsgDataTypes":SigMeterReading{0-1},"urn:iso:15118:2:2016:MsgDataTypes":MeterStatus{0-1},"urn:iso:15118:2:2016:MsgDataTypes":TMeter{0-1})',  derivedBy='RESTRICTION'.  */
	struct iso2MeterInfoType MeterInfo ;
	unsigned int MeterInfo_isUsed:1;
	/* element: "urn:iso:15118:2:2016:MsgBody":ReceiptRequired, http://www.w3.org/2001/XMLSchema,boolean */
	int ReceiptRequired ;
	unsigned int ReceiptRequired_isUsed:1;
};

/* Complex type name='urn:iso:15118:2:2016:MsgBody,ChargingStatusReqType',  base type name='ChargeLoopReqType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='(("urn:iso:15118:2:2016:MsgBody":EVTargetEnergyRequest,"urn:iso:15118:2:2016:MsgBody":EVMaximumEnergyRequest{0-1},"urn:iso:15118:2:2016:MsgBody":EVMinimumEnergyRequest{0-1},"urn:iso:15118:2:2016:MsgBody":DisplayParameters{0-1}),("urn:iso:15118:2:2016:MsgBody":EVMaximumChargePower{0-1},"urn:iso:15118:2:2016:MsgBody":EVMaximumChargeCurrent{0-1},"urn:iso:15118:2:2016:MsgBody":EVMinimumChargeCurrent{0-1}))',  derivedBy='EXTENSION'.  */
struct iso2ChargingStatusReqType {
	/* element: "urn:iso:15118:2:2016:MsgBody":EVTargetEnergyRequest, Complex type name='urn:iso:15118:2:2016:MsgDataTypes,PhysicalValueType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgDataTypes":Exponent,"urn:iso:15118:2:2016:MsgDataTypes":Value)',  derivedBy='RESTRICTION'.  */
	struct iso2PhysicalValueType EVTargetEnergyRequest ;
	/* element: "urn:iso:15118:2:2016:MsgBody":EVMaximumEnergyRequest, Complex type name='urn:iso:15118:2:2016:MsgDataTypes,PhysicalValueType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgDataTypes":Exponent,"urn:iso:15118:2:2016:MsgDataTypes":Value)',  derivedBy='RESTRICTION'.  */
	struct iso2PhysicalValueType EVMaximumEnergyRequest ;
	unsigned int EVMaximumEnergyRequest_isUsed:1;
	/* element: "urn:iso:15118:2:2016:MsgBody":EVMinimumEnergyRequest, Complex type name='urn:iso:15118:2:2016:MsgDataTypes,PhysicalValueType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgDataTypes":Exponent,"urn:iso:15118:2:2016:MsgDataTypes":Value)',  derivedBy='RESTRICTION'.  */
	struct iso2PhysicalValueType EVMinimumEnergyRequest ;
	unsigned int EVMinimumEnergyRequest_isUsed:1;
	/* element: "urn:iso:15118:2:2016:MsgBody":DisplayParameters, Complex type name='urn:iso:15118:2:2016:MsgDataTypes,DisplayParametersType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgDataTypes":CurrentRange{0-1},"urn:iso:15118:2:2016:MsgDataTypes":CurrentSOC{0-1},"urn:iso:15118:2:2016:MsgDataTypes":TargetSOC{0-1},"urn:iso:15118:2:2016:MsgDataTypes":BulkSOC{0-1},"urn:iso:15118:2:2016:MsgDataTypes":MinimumSOC{0-1},"urn:iso:15118:2:2016:MsgDataTypes":ChargingPerformance{0-1},"urn:iso:15118:2:2016:MsgDataTypes":RemainingTimeToTargetSOC{0-1},"urn:iso:15118:2:2016:MsgDataTypes":RemainingTimeToBulkSOC{0-1},"urn:iso:15118:2:2016:MsgDataTypes":RemainingTimeToMinimumSOC{0-1},"urn:iso:15118:2:2016:MsgDataTypes":ChargingComplete{0-1},"urn:iso:15118:2:2016:MsgDataTypes":BulkChargingComplete{0-1},"urn:iso:15118:2:2016:MsgDataTypes":InletHot{0-1})',  derivedBy='RESTRICTION'.  */
	struct iso2DisplayParametersType DisplayParameters ;
	unsigned int DisplayParameters_isUsed:1;
	/* element: "urn:iso:15118:2:2016:MsgBody":EVMaximumChargePower, Complex type name='urn:iso:15118:2:2016:MsgDataTypes,PhysicalValueType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgDataTypes":Exponent,"urn:iso:15118:2:2016:MsgDataTypes":Value)',  derivedBy='RESTRICTION'.  */
	struct iso2PhysicalValueType EVMaximumChargePower ;
	unsigned int EVMaximumChargePower_isUsed:1;
	/* element: "urn:iso:15118:2:2016:MsgBody":EVMaximumChargeCurrent, Complex type name='urn:iso:15118:2:2016:MsgDataTypes,PhysicalValueType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgDataTypes":Exponent,"urn:iso:15118:2:2016:MsgDataTypes":Value)',  derivedBy='RESTRICTION'.  */
	struct iso2PhysicalValueType EVMaximumChargeCurrent ;
	unsigned int EVMaximumChargeCurrent_isUsed:1;
	/* element: "urn:iso:15118:2:2016:MsgBody":EVMinimumChargeCurrent, Complex type name='urn:iso:15118:2:2016:MsgDataTypes,PhysicalValueType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgDataTypes":Exponent,"urn:iso:15118:2:2016:MsgDataTypes":Value)',  derivedBy='RESTRICTION'.  */
	struct iso2PhysicalValueType EVMinimumChargeCurrent ;
	unsigned int EVMinimumChargeCurrent_isUsed:1;
};

/* Complex type name='urn:iso:15118:2:2016:MsgBody,CertificateInstallationResType',  base type name='V2GResponseType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='(("urn:iso:15118:2:2016:MsgBody":ResponseCode,"urn:iso:15118:2:2016:MsgBody":EVSEStatus{0-1}),("urn:iso:15118:2:2016:MsgBody":SAProvisioningCertificateChain,"urn:iso:15118:2:2016:MsgBody":ContractSignatureCertChain,"urn:iso:15118:2:2016:MsgBody":ContractSignatureEncryptedPrivateKey,"urn:iso:15118:2:2016:MsgBody":DHpublickey,"urn:iso:15118:2:2016:MsgBody":eMAID))',  derivedBy='EXTENSION'.  */
struct iso2CertificateInstallationResType {
	/* element: "urn:iso:15118:2:2016:MsgBody":ResponseCode, urn:iso:15118:2:2016:MsgDataTypes,responseCodeType */
	iso2responseCodeType ResponseCode ;
	/* element: "urn:iso:15118:2:2016:MsgBody":EVSEStatus, Complex type name='urn:iso:15118:2:2016:MsgDataTypes,EVSEStatusType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgDataTypes":NotificationMaxDelay,"urn:iso:15118:2:2016:MsgDataTypes":EVSENotification)',  derivedBy='RESTRICTION'.  */
	struct iso2EVSEStatusType EVSEStatus ;
	unsigned int EVSEStatus_isUsed:1;
	/* element: "urn:iso:15118:2:2016:MsgBody":SAProvisioningCertificateChain, Complex type name='urn:iso:15118:2:2016:MsgDataTypes,CertificateChainType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgDataTypes":Certificate,"urn:iso:15118:2:2016:MsgDataTypes":SubCertificates{0-1})',  derivedBy='RESTRICTION'.  */
	struct iso2CertificateChainType SAProvisioningCertificateChain ;
	/* element: "urn:iso:15118:2:2016:MsgBody":ContractSignatureCertChain, Complex type name='urn:iso:15118:2:2016:MsgDataTypes,CertificateChainType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgDataTypes":Certificate,"urn:iso:15118:2:2016:MsgDataTypes":SubCertificates{0-1})',  derivedBy='RESTRICTION'.  */
	struct iso2CertificateChainType ContractSignatureCertChain ;
	/* element: "urn:iso:15118:2:2016:MsgBody":ContractSignatureEncryptedPrivateKey, Complex type name='urn:iso:15118:2:2016:MsgDataTypes,ContractSignatureEncryptedPrivateKeyType',  base type name='encryptedPrivateKeyType',  content type='SIMPLE',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  derivedBy='EXTENSION'.  */
	struct iso2ContractSignatureEncryptedPrivateKeyType ContractSignatureEncryptedPrivateKey ;
	/* element: "urn:iso:15118:2:2016:MsgBody":DHpublickey, Complex type name='urn:iso:15118:2:2016:MsgDataTypes,DiffieHellmanPublickeyType',  base type name='dHpublickeyType',  content type='SIMPLE',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  derivedBy='EXTENSION'.  */
	struct iso2DiffieHellmanPublickeyType DHpublickey ;
	/* element: "urn:iso:15118:2:2016:MsgBody":eMAID, Complex type name='urn:iso:15118:2:2016:MsgDataTypes,EMAIDType',  base type name='eMAIDType',  content type='SIMPLE',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  derivedBy='EXTENSION'.  */
	struct iso2EMAIDType eMAID ;
};

/* Complex type name='urn:iso:15118:2:2016:MsgDataTypes,SensorPackageType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgDataTypes":PackageIndex,"urn:iso:15118:2:2016:MsgDataTypes":SensorMeasurements{1-255})',  derivedBy='RESTRICTION'.  */
#define iso2SensorPackageType_SensorMeasurements_ARRAY_SIZE 5
struct iso2SensorPackageType {
	/* element: "urn:iso:15118:2:2016:MsgDataTypes":PackageIndex, http://www.w3.org/2001/XMLSchema,unsignedInt */
	uint32_t PackageIndex ;
	/* element: "urn:iso:15118:2:2016:MsgDataTypes":SensorMeasurements, Complex type name='urn:iso:15118:2:2016:MsgDataTypes,SensorMeasurementsType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgDataTypes":SensorID,"urn:iso:15118:2:2016:MsgDataTypes":EffectiveRadiatedPower,"urn:iso:15118:2:2016:MsgDataTypes":MeasurementDataList)',  derivedBy='RESTRICTION'.  */
	struct {
		struct iso2SensorMeasurementsType array[iso2SensorPackageType_SensorMeasurements_ARRAY_SIZE];
		uint16_t arrayLen;
	} SensorMeasurements;
};

/* Complex type name='urn:iso:15118:2:2016:MsgBody,ServiceDiscoveryResType',  base type name='V2GResponseType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='(("urn:iso:15118:2:2016:MsgBody":ResponseCode,"urn:iso:15118:2:2016:MsgBody":EVSEStatus{0-1}),("urn:iso:15118:2:2016:MsgBody":PaymentOptionList,"urn:iso:15118:2:2016:MsgBody":EnergyTransferServiceList,"urn:iso:15118:2:2016:MsgBody":VASList{0-1}))',  derivedBy='EXTENSION'.  */
struct iso2ServiceDiscoveryResType {
	/* element: "urn:iso:15118:2:2016:MsgBody":ResponseCode, urn:iso:15118:2:2016:MsgDataTypes,responseCodeType */
	iso2responseCodeType ResponseCode ;
	/* element: "urn:iso:15118:2:2016:MsgBody":EVSEStatus, Complex type name='urn:iso:15118:2:2016:MsgDataTypes,EVSEStatusType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgDataTypes":NotificationMaxDelay,"urn:iso:15118:2:2016:MsgDataTypes":EVSENotification)',  derivedBy='RESTRICTION'.  */
	struct iso2EVSEStatusType EVSEStatus ;
	unsigned int EVSEStatus_isUsed:1;
	/* element: "urn:iso:15118:2:2016:MsgBody":PaymentOptionList, Complex type name='urn:iso:15118:2:2016:MsgDataTypes,PaymentOptionListType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgDataTypes":PaymentOption{1-2})',  derivedBy='RESTRICTION'.  */
	struct iso2PaymentOptionListType PaymentOptionList ;
	/* element: "urn:iso:15118:2:2016:MsgBody":EnergyTransferServiceList, Complex type name='urn:iso:15118:2:2016:MsgDataTypes,ServiceListType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgDataTypes":Service{1-8})',  derivedBy='RESTRICTION'.  */
	struct iso2ServiceListType EnergyTransferServiceList ;
	/* element: "urn:iso:15118:2:2016:MsgBody":VASList, Complex type name='urn:iso:15118:2:2016:MsgDataTypes,ServiceListType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgDataTypes":Service{1-8})',  derivedBy='RESTRICTION'.  */
	struct iso2ServiceListType VASList ;
	unsigned int VASList_isUsed:1;
};

/* Complex type name='urn:iso:15118:2:2016:MsgBody,PowerDemandResType',  base type name='V2GResponseType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='(("urn:iso:15118:2:2016:MsgBody":ResponseCode,"urn:iso:15118:2:2016:MsgBody":EVSEStatus{0-1}),("urn:iso:15118:2:2016:MsgBody":EVSEOutputPower,"urn:iso:15118:2:2016:MsgBody":EVSEID,"urn:iso:15118:2:2016:MsgBody":SAScheduleTupleID{0-1},"urn:iso:15118:2:2016:MsgBody":MeterInfo{0-1},"urn:iso:15118:2:2016:MsgBody":ReceiptRequired{0-1},"urn:iso:15118:2:2016:MsgBody":PowerDemandParameters{0-1}))',  derivedBy='EXTENSION'.  */
#define iso2PowerDemandResType_EVSEID_CHARACTERS_SIZE 37 + EXTRA_CHAR /* XML schema facet maxLength for urn:iso:15118:2:2016:MsgDataTypes,evseIDType is 37 */
struct iso2PowerDemandResType {
	/* element: "urn:iso:15118:2:2016:MsgBody":ResponseCode, urn:iso:15118:2:2016:MsgDataTypes,responseCodeType */
	iso2responseCodeType ResponseCode ;
	/* element: "urn:iso:15118:2:2016:MsgBody":EVSEStatus, Complex type name='urn:iso:15118:2:2016:MsgDataTypes,EVSEStatusType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgDataTypes":NotificationMaxDelay,"urn:iso:15118:2:2016:MsgDataTypes":EVSENotification)',  derivedBy='RESTRICTION'.  */
	struct iso2EVSEStatusType EVSEStatus ;
	unsigned int EVSEStatus_isUsed:1;
	/* element: "urn:iso:15118:2:2016:MsgBody":EVSEOutputPower, Complex type name='urn:iso:15118:2:2016:MsgDataTypes,PhysicalValueType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgDataTypes":Exponent,"urn:iso:15118:2:2016:MsgDataTypes":Value)',  derivedBy='RESTRICTION'.  */
	struct iso2PhysicalValueType EVSEOutputPower ;
	/* element: "urn:iso:15118:2:2016:MsgBody":EVSEID, urn:iso:15118:2:2016:MsgDataTypes,evseIDType */
	struct {
		exi_string_character_t characters[iso2PowerDemandResType_EVSEID_CHARACTERS_SIZE];
		uint16_t charactersLen;
	}  EVSEID ;
	/* element: "urn:iso:15118:2:2016:MsgBody":SAScheduleTupleID, urn:iso:15118:2:2016:MsgDataTypes,SAIDType */
	uint8_t SAScheduleTupleID ;
	unsigned int SAScheduleTupleID_isUsed:1;
	/* element: "urn:iso:15118:2:2016:MsgBody":MeterInfo, Complex type name='urn:iso:15118:2:2016:MsgDataTypes,MeterInfoType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgDataTypes":MeterID,"urn:iso:15118:2:2016:MsgDataTypes":MeterReadingCharged{0-1},"urn:iso:15118:2:2016:MsgDataTypes":MeterReadingDischarged{0-1},"urn:iso:15118:2:2016:MsgDataTypes":SigMeterReading{0-1},"urn:iso:15118:2:2016:MsgDataTypes":MeterStatus{0-1},"urn:iso:15118:2:2016:MsgDataTypes":TMeter{0-1})',  derivedBy='RESTRICTION'.  */
	struct iso2MeterInfoType MeterInfo ;
	unsigned int MeterInfo_isUsed:1;
	/* element: "urn:iso:15118:2:2016:MsgBody":ReceiptRequired, http://www.w3.org/2001/XMLSchema,boolean */
	int ReceiptRequired ;
	unsigned int ReceiptRequired_isUsed:1;
	/* element: "urn:iso:15118:2:2016:MsgBody":PowerDemandParameters, Complex type name='urn:iso:15118:2:2016:MsgDataTypes,ParameterSetType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgDataTypes":ParameterSetID,"urn:iso:15118:2:2016:MsgDataTypes":Parameter{1-16})',  derivedBy='RESTRICTION'.  */
	struct iso2ParameterSetType PowerDemandParameters ;
	unsigned int PowerDemandParameters_isUsed:1;
};

/* Complex type name='urn:iso:15118:2:2016:MsgDataTypes,ChargingProfileType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgDataTypes":ProfileEntry{1-UNBOUNDED})',  derivedBy='RESTRICTION'.  */
#define iso2ChargingProfileType_ProfileEntry_ARRAY_SIZE 24
struct iso2ChargingProfileType {
	/* element: "urn:iso:15118:2:2016:MsgDataTypes":ProfileEntry, Complex type name='urn:iso:15118:2:2016:MsgDataTypes,PMaxScheduleEntryType',  base type name='EntryType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='(("urn:iso:15118:2:2016:MsgDataTypes":RelativeTimeInterval),("urn:iso:15118:2:2016:MsgDataTypes":PMax{1-3}))',  derivedBy='EXTENSION'.  */
	struct {
		struct iso2PMaxScheduleEntryType array[iso2ChargingProfileType_ProfileEntry_ARRAY_SIZE];
		uint16_t arrayLen;
	} ProfileEntry;
};

/* Complex type name='urn:iso:15118:2:2016:MsgDataTypes,SalesTariffType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgDataTypes":SalesTariffID,"urn:iso:15118:2:2016:MsgDataTypes":SalesTariffDescription{0-1},"urn:iso:15118:2:2016:MsgDataTypes":NumEPriceLevels{0-1},"urn:iso:15118:2:2016:MsgDataTypes":SalesTariffEntry{1-UNBOUNDED})',  derivedBy='RESTRICTION'.  */
#define iso2SalesTariffType_Id_CHARACTERS_SIZE 50 + EXTRA_CHAR 
#define iso2SalesTariffType_SalesTariffDescription_CHARACTERS_SIZE 32 + EXTRA_CHAR /* XML schema facet maxLength for urn:iso:15118:2:2016:MsgDataTypes,tariffDescriptionType is 32 */
#define iso2SalesTariffType_SalesTariffEntry_ARRAY_SIZE 5
struct iso2SalesTariffType {
	/* attribute: Id {http://www.w3.org/2001/XMLSchema,ID} */
	struct {
		exi_string_character_t characters[iso2SalesTariffType_Id_CHARACTERS_SIZE];
		uint16_t charactersLen;
	}  Id ;
	/* element: "urn:iso:15118:2:2016:MsgDataTypes":SalesTariffID, urn:iso:15118:2:2016:MsgDataTypes,SAIDType */
	uint8_t SalesTariffID ;
	/* element: "urn:iso:15118:2:2016:MsgDataTypes":SalesTariffDescription, urn:iso:15118:2:2016:MsgDataTypes,tariffDescriptionType */
	struct {
		exi_string_character_t characters[iso2SalesTariffType_SalesTariffDescription_CHARACTERS_SIZE];
		uint16_t charactersLen;
	}  SalesTariffDescription ;
	unsigned int SalesTariffDescription_isUsed:1;
	/* element: "urn:iso:15118:2:2016:MsgDataTypes":NumEPriceLevels, http://www.w3.org/2001/XMLSchema,unsignedByte */
	uint8_t NumEPriceLevels ;
	unsigned int NumEPriceLevels_isUsed:1;
	/* element: "urn:iso:15118:2:2016:MsgDataTypes":SalesTariffEntry, Complex type name='urn:iso:15118:2:2016:MsgDataTypes,SalesTariffEntryType',  base type name='EntryType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='(("urn:iso:15118:2:2016:MsgDataTypes":RelativeTimeInterval),("urn:iso:15118:2:2016:MsgDataTypes":EPriceLevel{0-1},"urn:iso:15118:2:2016:MsgDataTypes":ConsumptionCost{0-3}))',  derivedBy='EXTENSION'.  */
	struct {
		struct iso2SalesTariffEntryType array[iso2SalesTariffType_SalesTariffEntry_ARRAY_SIZE];
		uint16_t arrayLen;
	} SalesTariffEntry;
};

/* Complex type name='http://www.w3.org/2000/09/xmldsig#,SignedInfoType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("http://www.w3.org/2000/09/xmldsig#":CanonicalizationMethod,"http://www.w3.org/2000/09/xmldsig#":SignatureMethod,"http://www.w3.org/2000/09/xmldsig#":Reference{1-UNBOUNDED})',  derivedBy='RESTRICTION'.  */
#define iso2SignedInfoType_Id_CHARACTERS_SIZE 50 + EXTRA_CHAR 
#define iso2SignedInfoType_Reference_ARRAY_SIZE 1
struct iso2SignedInfoType {
	/* attribute: Id {http://www.w3.org/2001/XMLSchema,ID} */
	struct {
		exi_string_character_t characters[iso2SignedInfoType_Id_CHARACTERS_SIZE];
		uint16_t charactersLen;
	}  Id ;
	unsigned int Id_isUsed:1;
	/* element: "http://www.w3.org/2000/09/xmldsig#":CanonicalizationMethod, Complex type name='http://www.w3.org/2000/09/xmldsig#,CanonicalizationMethodType',  base type name='anyType',  content type='MIXED',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='((WC[##any]){0-UNBOUNDED})',  derivedBy='RESTRICTION'.  */
	struct iso2CanonicalizationMethodType CanonicalizationMethod ;
	/* element: "http://www.w3.org/2000/09/xmldsig#":SignatureMethod, Complex type name='http://www.w3.org/2000/09/xmldsig#,SignatureMethodType',  base type name='anyType',  content type='MIXED',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("http://www.w3.org/2000/09/xmldsig#":HMACOutputLength{0-1},(WC[##other:"http://www.w3.org/2000/09/xmldsig#"]){0-UNBOUNDED})',  derivedBy='RESTRICTION'.  */
	struct iso2SignatureMethodType SignatureMethod ;
	/* element: "http://www.w3.org/2000/09/xmldsig#":Reference, Complex type name='http://www.w3.org/2000/09/xmldsig#,ReferenceType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("http://www.w3.org/2000/09/xmldsig#":Transforms{0-1},"http://www.w3.org/2000/09/xmldsig#":DigestMethod,"http://www.w3.org/2000/09/xmldsig#":DigestValue)',  derivedBy='RESTRICTION'.  */
	struct {
		struct iso2ReferenceType array[iso2SignedInfoType_Reference_ARRAY_SIZE];
		uint16_t arrayLen;
	} Reference;
};

/* Complex type name='urn:iso:15118:2:2016:MsgBody,PowerDeliveryResType',  base type name='V2GResponseType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='(("urn:iso:15118:2:2016:MsgBody":ResponseCode,"urn:iso:15118:2:2016:MsgBody":EVSEStatus{0-1}),("urn:iso:15118:2:2016:MsgBody":EVSEProcessing))',  derivedBy='EXTENSION'.  */
struct iso2PowerDeliveryResType {
	/* element: "urn:iso:15118:2:2016:MsgBody":ResponseCode, urn:iso:15118:2:2016:MsgDataTypes,responseCodeType */
	iso2responseCodeType ResponseCode ;
	/* element: "urn:iso:15118:2:2016:MsgBody":EVSEStatus, Complex type name='urn:iso:15118:2:2016:MsgDataTypes,EVSEStatusType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgDataTypes":NotificationMaxDelay,"urn:iso:15118:2:2016:MsgDataTypes":EVSENotification)',  derivedBy='RESTRICTION'.  */
	struct iso2EVSEStatusType EVSEStatus ;
	unsigned int EVSEStatus_isUsed:1;
	/* element: "urn:iso:15118:2:2016:MsgBody":EVSEProcessing, urn:iso:15118:2:2016:MsgDataTypes,EVSEProcessingType */
	iso2EVSEProcessingType EVSEProcessing ;
};

/* Complex type name='http://www.w3.org/2000/09/xmldsig#,RetrievalMethodType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("http://www.w3.org/2000/09/xmldsig#":Transforms{0-1})',  derivedBy='RESTRICTION'.  */
#define iso2RetrievalMethodType_URI_CHARACTERS_SIZE 50 + EXTRA_CHAR 
#define iso2RetrievalMethodType_Type_CHARACTERS_SIZE 50 + EXTRA_CHAR 
struct iso2RetrievalMethodType {
	/* attribute: URI {http://www.w3.org/2001/XMLSchema,anyURI} */
	struct {
		exi_string_character_t characters[iso2RetrievalMethodType_URI_CHARACTERS_SIZE];
		uint16_t charactersLen;
	}  URI ;
	unsigned int URI_isUsed:1;
	/* attribute: Type {http://www.w3.org/2001/XMLSchema,anyURI} */
	struct {
		exi_string_character_t characters[iso2RetrievalMethodType_Type_CHARACTERS_SIZE];
		uint16_t charactersLen;
	}  Type ;
	unsigned int Type_isUsed:1;
	/* element: "http://www.w3.org/2000/09/xmldsig#":Transforms, Complex type name='http://www.w3.org/2000/09/xmldsig#,TransformsType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("http://www.w3.org/2000/09/xmldsig#":Transform{1-UNBOUNDED})',  derivedBy='RESTRICTION'.  */
	struct iso2TransformsType Transforms ;
	unsigned int Transforms_isUsed:1;
};

/* Complex type name='urn:iso:15118:2:2016:MsgDataTypes,MagneticVectorListType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgDataTypes":MagneticVector{1-255})',  derivedBy='RESTRICTION'.  */
#define iso2MagneticVectorListType_MagneticVector_ARRAY_SIZE 5
struct iso2MagneticVectorListType {
	/* element: "urn:iso:15118:2:2016:MsgDataTypes":MagneticVector, Complex type name='urn:iso:15118:2:2016:MsgDataTypes,MagneticVectorType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgDataTypes":GAID,"urn:iso:15118:2:2016:MsgDataTypes":Distance,"urn:iso:15118:2:2016:MsgDataTypes":AngleGAtoVA,"urn:iso:15118:2:2016:MsgDataTypes":RotationVAtoGA,"urn:iso:15118:2:2016:MsgDataTypes":FODStatus)',  derivedBy='RESTRICTION'.  */
	struct {
		struct iso2MagneticVectorType array[iso2MagneticVectorListType_MagneticVector_ARRAY_SIZE];
		uint16_t arrayLen;
	} MagneticVector;
};

/* Complex type name='urn:iso:15118:2:2016:MsgDataTypes,ServiceParameterListType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgDataTypes":ParameterSet{1-255})',  derivedBy='RESTRICTION'.  */
#define iso2ServiceParameterListType_ParameterSet_ARRAY_SIZE 5
struct iso2ServiceParameterListType {
	/* element: "urn:iso:15118:2:2016:MsgDataTypes":ParameterSet, Complex type name='urn:iso:15118:2:2016:MsgDataTypes,ParameterSetType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgDataTypes":ParameterSetID,"urn:iso:15118:2:2016:MsgDataTypes":Parameter{1-16})',  derivedBy='RESTRICTION'.  */
	struct {
		struct iso2ParameterSetType array[iso2ServiceParameterListType_ParameterSet_ARRAY_SIZE];
		uint16_t arrayLen;
	} ParameterSet;
};

/* Complex type name='urn:iso:15118:2:2016:MsgDataTypes,PMaxScheduleType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgDataTypes":PMaxScheduleEntry{1-UNBOUNDED})',  derivedBy='RESTRICTION'.  */
#define iso2PMaxScheduleType_PMaxScheduleEntry_ARRAY_SIZE 5
struct iso2PMaxScheduleType {
	/* element: "urn:iso:15118:2:2016:MsgDataTypes":PMaxScheduleEntry, Complex type name='urn:iso:15118:2:2016:MsgDataTypes,PMaxScheduleEntryType',  base type name='EntryType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='(("urn:iso:15118:2:2016:MsgDataTypes":RelativeTimeInterval),("urn:iso:15118:2:2016:MsgDataTypes":PMax{1-3}))',  derivedBy='EXTENSION'.  */
	struct {
		struct iso2PMaxScheduleEntryType array[iso2PMaxScheduleType_PMaxScheduleEntry_ARRAY_SIZE];
		uint16_t arrayLen;
	} PMaxScheduleEntry;
};

/* Complex type name='urn:iso:15118:2:2016:MsgBody,CertificateUpdateResType',  base type name='V2GResponseType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='(("urn:iso:15118:2:2016:MsgBody":ResponseCode,"urn:iso:15118:2:2016:MsgBody":EVSEStatus{0-1}),("urn:iso:15118:2:2016:MsgBody":SAProvisioningCertificateChain,"urn:iso:15118:2:2016:MsgBody":ContractSignatureCertChain,"urn:iso:15118:2:2016:MsgBody":ContractSignatureEncryptedPrivateKey,"urn:iso:15118:2:2016:MsgBody":DHpublickey,"urn:iso:15118:2:2016:MsgBody":eMAID,"urn:iso:15118:2:2016:MsgBody":RetryCounter{0-1}))',  derivedBy='EXTENSION'.  */
struct iso2CertificateUpdateResType {
	/* element: "urn:iso:15118:2:2016:MsgBody":ResponseCode, urn:iso:15118:2:2016:MsgDataTypes,responseCodeType */
	iso2responseCodeType ResponseCode ;
	/* element: "urn:iso:15118:2:2016:MsgBody":EVSEStatus, Complex type name='urn:iso:15118:2:2016:MsgDataTypes,EVSEStatusType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgDataTypes":NotificationMaxDelay,"urn:iso:15118:2:2016:MsgDataTypes":EVSENotification)',  derivedBy='RESTRICTION'.  */
	struct iso2EVSEStatusType EVSEStatus ;
	unsigned int EVSEStatus_isUsed:1;
	/* element: "urn:iso:15118:2:2016:MsgBody":SAProvisioningCertificateChain, Complex type name='urn:iso:15118:2:2016:MsgDataTypes,CertificateChainType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgDataTypes":Certificate,"urn:iso:15118:2:2016:MsgDataTypes":SubCertificates{0-1})',  derivedBy='RESTRICTION'.  */
	struct iso2CertificateChainType SAProvisioningCertificateChain ;
	/* element: "urn:iso:15118:2:2016:MsgBody":ContractSignatureCertChain, Complex type name='urn:iso:15118:2:2016:MsgDataTypes,CertificateChainType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgDataTypes":Certificate,"urn:iso:15118:2:2016:MsgDataTypes":SubCertificates{0-1})',  derivedBy='RESTRICTION'.  */
	struct iso2CertificateChainType ContractSignatureCertChain ;
	/* element: "urn:iso:15118:2:2016:MsgBody":ContractSignatureEncryptedPrivateKey, Complex type name='urn:iso:15118:2:2016:MsgDataTypes,ContractSignatureEncryptedPrivateKeyType',  base type name='encryptedPrivateKeyType',  content type='SIMPLE',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  derivedBy='EXTENSION'.  */
	struct iso2ContractSignatureEncryptedPrivateKeyType ContractSignatureEncryptedPrivateKey ;
	/* element: "urn:iso:15118:2:2016:MsgBody":DHpublickey, Complex type name='urn:iso:15118:2:2016:MsgDataTypes,DiffieHellmanPublickeyType',  base type name='dHpublickeyType',  content type='SIMPLE',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  derivedBy='EXTENSION'.  */
	struct iso2DiffieHellmanPublickeyType DHpublickey ;
	/* element: "urn:iso:15118:2:2016:MsgBody":eMAID, Complex type name='urn:iso:15118:2:2016:MsgDataTypes,EMAIDType',  base type name='eMAIDType',  content type='SIMPLE',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  derivedBy='EXTENSION'.  */
	struct iso2EMAIDType eMAID ;
	/* element: "urn:iso:15118:2:2016:MsgBody":RetryCounter, http://www.w3.org/2001/XMLSchema,short */
	int16_t RetryCounter ;
	unsigned int RetryCounter_isUsed:1;
};

/* Complex type name='urn:iso:15118:2:2016:MsgBody,DC_BidirectionalControlReqType',  base type name='ChargeLoopReqType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='(("urn:iso:15118:2:2016:MsgBody":EVTargetEnergyRequest,"urn:iso:15118:2:2016:MsgBody":EVMaximumEnergyRequest{0-1},"urn:iso:15118:2:2016:MsgBody":EVMinimumEnergyRequest{0-1},"urn:iso:15118:2:2016:MsgBody":DisplayParameters{0-1}),("urn:iso:15118:2:2016:MsgBody":EVTargetCurrent,"urn:iso:15118:2:2016:MsgBody":EVTargetVoltage,"urn:iso:15118:2:2016:MsgBody":EVMaximumVoltage,"urn:iso:15118:2:2016:MsgBody":EVMinimumVoltage,"urn:iso:15118:2:2016:MsgBody":EVMaximumChargeCurrent,"urn:iso:15118:2:2016:MsgBody":EVMaximumDischargeCurrent{0-1},"urn:iso:15118:2:2016:MsgBody":EVMaximumChargePower{0-1},"urn:iso:15118:2:2016:MsgBody":EVMaximumDischargePower{0-1}))',  derivedBy='EXTENSION'.  */
struct iso2DC_BidirectionalControlReqType {
	/* element: "urn:iso:15118:2:2016:MsgBody":EVTargetEnergyRequest, Complex type name='urn:iso:15118:2:2016:MsgDataTypes,PhysicalValueType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgDataTypes":Exponent,"urn:iso:15118:2:2016:MsgDataTypes":Value)',  derivedBy='RESTRICTION'.  */
	struct iso2PhysicalValueType EVTargetEnergyRequest ;
	/* element: "urn:iso:15118:2:2016:MsgBody":EVMaximumEnergyRequest, Complex type name='urn:iso:15118:2:2016:MsgDataTypes,PhysicalValueType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgDataTypes":Exponent,"urn:iso:15118:2:2016:MsgDataTypes":Value)',  derivedBy='RESTRICTION'.  */
	struct iso2PhysicalValueType EVMaximumEnergyRequest ;
	unsigned int EVMaximumEnergyRequest_isUsed:1;
	/* element: "urn:iso:15118:2:2016:MsgBody":EVMinimumEnergyRequest, Complex type name='urn:iso:15118:2:2016:MsgDataTypes,PhysicalValueType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgDataTypes":Exponent,"urn:iso:15118:2:2016:MsgDataTypes":Value)',  derivedBy='RESTRICTION'.  */
	struct iso2PhysicalValueType EVMinimumEnergyRequest ;
	unsigned int EVMinimumEnergyRequest_isUsed:1;
	/* element: "urn:iso:15118:2:2016:MsgBody":DisplayParameters, Complex type name='urn:iso:15118:2:2016:MsgDataTypes,DisplayParametersType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgDataTypes":CurrentRange{0-1},"urn:iso:15118:2:2016:MsgDataTypes":CurrentSOC{0-1},"urn:iso:15118:2:2016:MsgDataTypes":TargetSOC{0-1},"urn:iso:15118:2:2016:MsgDataTypes":BulkSOC{0-1},"urn:iso:15118:2:2016:MsgDataTypes":MinimumSOC{0-1},"urn:iso:15118:2:2016:MsgDataTypes":ChargingPerformance{0-1},"urn:iso:15118:2:2016:MsgDataTypes":RemainingTimeToTargetSOC{0-1},"urn:iso:15118:2:2016:MsgDataTypes":RemainingTimeToBulkSOC{0-1},"urn:iso:15118:2:2016:MsgDataTypes":RemainingTimeToMinimumSOC{0-1},"urn:iso:15118:2:2016:MsgDataTypes":ChargingComplete{0-1},"urn:iso:15118:2:2016:MsgDataTypes":BulkChargingComplete{0-1},"urn:iso:15118:2:2016:MsgDataTypes":InletHot{0-1})',  derivedBy='RESTRICTION'.  */
	struct iso2DisplayParametersType DisplayParameters ;
	unsigned int DisplayParameters_isUsed:1;
	/* element: "urn:iso:15118:2:2016:MsgBody":EVTargetCurrent, Complex type name='urn:iso:15118:2:2016:MsgDataTypes,PhysicalValueType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgDataTypes":Exponent,"urn:iso:15118:2:2016:MsgDataTypes":Value)',  derivedBy='RESTRICTION'.  */
	struct iso2PhysicalValueType EVTargetCurrent ;
	/* element: "urn:iso:15118:2:2016:MsgBody":EVTargetVoltage, Complex type name='urn:iso:15118:2:2016:MsgDataTypes,PhysicalValueType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgDataTypes":Exponent,"urn:iso:15118:2:2016:MsgDataTypes":Value)',  derivedBy='RESTRICTION'.  */
	struct iso2PhysicalValueType EVTargetVoltage ;
	/* element: "urn:iso:15118:2:2016:MsgBody":EVMaximumVoltage, Complex type name='urn:iso:15118:2:2016:MsgDataTypes,PhysicalValueType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgDataTypes":Exponent,"urn:iso:15118:2:2016:MsgDataTypes":Value)',  derivedBy='RESTRICTION'.  */
	struct iso2PhysicalValueType EVMaximumVoltage ;
	/* element: "urn:iso:15118:2:2016:MsgBody":EVMinimumVoltage, Complex type name='urn:iso:15118:2:2016:MsgDataTypes,PhysicalValueType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgDataTypes":Exponent,"urn:iso:15118:2:2016:MsgDataTypes":Value)',  derivedBy='RESTRICTION'.  */
	struct iso2PhysicalValueType EVMinimumVoltage ;
	/* element: "urn:iso:15118:2:2016:MsgBody":EVMaximumChargeCurrent, Complex type name='urn:iso:15118:2:2016:MsgDataTypes,PhysicalValueType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgDataTypes":Exponent,"urn:iso:15118:2:2016:MsgDataTypes":Value)',  derivedBy='RESTRICTION'.  */
	struct iso2PhysicalValueType EVMaximumChargeCurrent ;
	/* element: "urn:iso:15118:2:2016:MsgBody":EVMaximumDischargeCurrent, Complex type name='urn:iso:15118:2:2016:MsgDataTypes,PhysicalValueType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgDataTypes":Exponent,"urn:iso:15118:2:2016:MsgDataTypes":Value)',  derivedBy='RESTRICTION'.  */
	struct iso2PhysicalValueType EVMaximumDischargeCurrent ;
	unsigned int EVMaximumDischargeCurrent_isUsed:1;
	/* element: "urn:iso:15118:2:2016:MsgBody":EVMaximumChargePower, Complex type name='urn:iso:15118:2:2016:MsgDataTypes,PhysicalValueType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgDataTypes":Exponent,"urn:iso:15118:2:2016:MsgDataTypes":Value)',  derivedBy='RESTRICTION'.  */
	struct iso2PhysicalValueType EVMaximumChargePower ;
	unsigned int EVMaximumChargePower_isUsed:1;
	/* element: "urn:iso:15118:2:2016:MsgBody":EVMaximumDischargePower, Complex type name='urn:iso:15118:2:2016:MsgDataTypes,PhysicalValueType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgDataTypes":Exponent,"urn:iso:15118:2:2016:MsgDataTypes":Value)',  derivedBy='RESTRICTION'.  */
	struct iso2PhysicalValueType EVMaximumDischargePower ;
	unsigned int EVMaximumDischargePower_isUsed:1;
};

/* Complex type name='urn:iso:15118:2:2016:MsgBody,CertificateUpdateReqType',  base type name='BodyBaseType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgBody":ContractSignatureCertChain,"urn:iso:15118:2:2016:MsgBody":eMAID,"urn:iso:15118:2:2016:MsgBody":ListOfRootCertificateIDs)',  derivedBy='EXTENSION'.  */
#define iso2CertificateUpdateReqType_Id_CHARACTERS_SIZE 50 + EXTRA_CHAR 
#define iso2CertificateUpdateReqType_eMAID_CHARACTERS_SIZE 15 + EXTRA_CHAR /* XML schema facet maxLength for urn:iso:15118:2:2016:MsgDataTypes,eMAIDType is 15 */
struct iso2CertificateUpdateReqType {
	/* attribute: Id {http://www.w3.org/2001/XMLSchema,ID} */
	struct {
		exi_string_character_t characters[iso2CertificateUpdateReqType_Id_CHARACTERS_SIZE];
		uint16_t charactersLen;
	}  Id ;
	/* element: "urn:iso:15118:2:2016:MsgBody":ContractSignatureCertChain, Complex type name='urn:iso:15118:2:2016:MsgDataTypes,CertificateChainType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgDataTypes":Certificate,"urn:iso:15118:2:2016:MsgDataTypes":SubCertificates{0-1})',  derivedBy='RESTRICTION'.  */
	struct iso2CertificateChainType ContractSignatureCertChain ;
	/* element: "urn:iso:15118:2:2016:MsgBody":eMAID, urn:iso:15118:2:2016:MsgDataTypes,eMAIDType */
	struct {
		exi_string_character_t characters[iso2CertificateUpdateReqType_eMAID_CHARACTERS_SIZE];
		uint16_t charactersLen;
	}  eMAID ;
	/* element: "urn:iso:15118:2:2016:MsgBody":ListOfRootCertificateIDs, Complex type name='urn:iso:15118:2:2016:MsgDataTypes,ListOfRootCertificateIDsType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgDataTypes":RootCertificateID{1-20})',  derivedBy='RESTRICTION'.  */
	struct iso2ListOfRootCertificateIDsType ListOfRootCertificateIDs ;
};

/* Complex type name='urn:iso:15118:2:2016:MsgDataTypes,LFA_EVSEFinePositioningSetupParametersType',  base type name='EVSEFinePositioningSetupParametersType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgDataTypes":NumberOfSensors,"urn:iso:15118:2:2016:MsgDataTypes":SensorList,"urn:iso:15118:2:2016:MsgDataTypes":SensorOrder,"urn:iso:15118:2:2016:MsgDataTypes":SignalPulseDuration,"urn:iso:15118:2:2016:MsgDataTypes":SignalSeparationTime,"urn:iso:15118:2:2016:MsgDataTypes":PackageSeparationTime,"urn:iso:15118:2:2016:MsgDataTypes":AlignmentOffset,"urn:iso:15118:2:2016:MsgDataTypes":SignalFrequency)',  derivedBy='EXTENSION'.  */
struct iso2LFA_EVSEFinePositioningSetupParametersType {
	/* element: "urn:iso:15118:2:2016:MsgDataTypes":NumberOfSensors, http://www.w3.org/2001/XMLSchema,unsignedByte */
	uint8_t NumberOfSensors ;
	/* element: "urn:iso:15118:2:2016:MsgDataTypes":SensorList, Complex type name='urn:iso:15118:2:2016:MsgDataTypes,SensorListType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgDataTypes":Sensor{1-255})',  derivedBy='RESTRICTION'.  */
	struct iso2SensorListType SensorList ;
	/* element: "urn:iso:15118:2:2016:MsgDataTypes":SensorOrder, Complex type name='urn:iso:15118:2:2016:MsgDataTypes,SensorOrderListType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgDataTypes":SensorPosition{1-255})',  derivedBy='RESTRICTION'.  */
	struct iso2SensorOrderListType SensorOrder ;
	/* element: "urn:iso:15118:2:2016:MsgDataTypes":SignalPulseDuration, http://www.w3.org/2001/XMLSchema,unsignedByte */
	uint8_t SignalPulseDuration ;
	/* element: "urn:iso:15118:2:2016:MsgDataTypes":SignalSeparationTime, http://www.w3.org/2001/XMLSchema,unsignedByte */
	uint8_t SignalSeparationTime ;
	/* element: "urn:iso:15118:2:2016:MsgDataTypes":PackageSeparationTime, http://www.w3.org/2001/XMLSchema,unsignedByte */
	uint8_t PackageSeparationTime ;
	/* element: "urn:iso:15118:2:2016:MsgDataTypes":AlignmentOffset, http://www.w3.org/2001/XMLSchema,unsignedShort */
	uint16_t AlignmentOffset ;
	/* element: "urn:iso:15118:2:2016:MsgDataTypes":SignalFrequency, http://www.w3.org/2001/XMLSchema,unsignedShort */
	uint16_t SignalFrequency ;
};

/* Complex type name='urn:iso:15118:2:2016:MsgBody,AlignmentCheckReqType',  base type name='BodyBaseType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgBody":EVProcessing,"urn:iso:15118:2:2016:MsgBody":AlignmentCheckParameters{0-1})',  derivedBy='EXTENSION'.  */
struct iso2AlignmentCheckReqType {
	/* element: "urn:iso:15118:2:2016:MsgBody":EVProcessing, urn:iso:15118:2:2016:MsgDataTypes,EVSEProcessingType */
	iso2EVSEProcessingType EVProcessing ;
	/* element: "urn:iso:15118:2:2016:MsgBody":AlignmentCheckParameters, Complex type name='urn:iso:15118:2:2016:MsgDataTypes,ParameterSetType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgDataTypes":ParameterSetID,"urn:iso:15118:2:2016:MsgDataTypes":Parameter{1-16})',  derivedBy='RESTRICTION'.  */
	struct iso2ParameterSetType AlignmentCheckParameters ;
	unsigned int AlignmentCheckParameters_isUsed:1;
};

/* Complex type name='urn:iso:15118:2:2016:MsgBody,CertificateInstallationReqType',  base type name='BodyBaseType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgBody":OEMProvisioningCert,"urn:iso:15118:2:2016:MsgBody":ListOfRootCertificateIDs)',  derivedBy='EXTENSION'.  */
#define iso2CertificateInstallationReqType_Id_CHARACTERS_SIZE 50 + EXTRA_CHAR 
#define iso2CertificateInstallationReqType_OEMProvisioningCert_BYTES_SIZE 800 /* XML schema facet maxLength for urn:iso:15118:2:2016:MsgDataTypes,certificateType is 800 */
struct iso2CertificateInstallationReqType {
	/* attribute: Id {http://www.w3.org/2001/XMLSchema,ID} */
	struct {
		exi_string_character_t characters[iso2CertificateInstallationReqType_Id_CHARACTERS_SIZE];
		uint16_t charactersLen;
	}  Id ;
	/* element: "urn:iso:15118:2:2016:MsgBody":OEMProvisioningCert, urn:iso:15118:2:2016:MsgDataTypes,certificateType */
	struct {
		uint8_t bytes[iso2CertificateInstallationReqType_OEMProvisioningCert_BYTES_SIZE];
		uint16_t bytesLen;
	}  OEMProvisioningCert ;
	/* element: "urn:iso:15118:2:2016:MsgBody":ListOfRootCertificateIDs, Complex type name='urn:iso:15118:2:2016:MsgDataTypes,ListOfRootCertificateIDsType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgDataTypes":RootCertificateID{1-20})',  derivedBy='RESTRICTION'.  */
	struct iso2ListOfRootCertificateIDsType ListOfRootCertificateIDs ;
};

/* Complex type name='urn:iso:15118:2:2016:MsgBody,ChargeParameterDiscoveryReqType',  base type name='BodyBaseType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgBody":MaxSupportingPoints{0-1},"urn:iso:15118:2:2016:MsgDataTypes":EVEnergyTransferParameter,"urn:iso:15118:2:2016:MsgBody":MinimumPMaxRequest{0-1})',  derivedBy='EXTENSION'.  */
struct iso2ChargeParameterDiscoveryReqType {
	/* element: "urn:iso:15118:2:2016:MsgBody":MaxSupportingPoints, urn:iso:15118:2:2016:MsgDataTypes,maxSupportingPointsSAScheduleTuple */
	uint16_t MaxSupportingPoints ;
	unsigned int MaxSupportingPoints_isUsed:1;
	/* element: "urn:iso:15118:2:2016:MsgDataTypes":EVEnergyTransferParameter, Complex type name='urn:iso:15118:2:2016:MsgDataTypes,EVEnergyTransferParameterType',  base type name='anyType',  content type='ELEMENT',  isAbstract='true',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgDataTypes":DepartureTime)',  derivedBy='RESTRICTION'.  */
	struct iso2EVEnergyTransferParameterType EVEnergyTransferParameter ;
	unsigned int EVEnergyTransferParameter_isUsed:1;
	/* element: "urn:iso:15118:2:2016:MsgDataTypes":AC_EVChargeParameter, Complex type name='urn:iso:15118:2:2016:MsgDataTypes,AC_EVChargeParameterType',  base type name='EVEnergyTransferParameterType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='(("urn:iso:15118:2:2016:MsgDataTypes":DepartureTime),("urn:iso:15118:2:2016:MsgDataTypes":EVMaximumChargePower,"urn:iso:15118:2:2016:MsgDataTypes":EVMaximumChargeCurrent,"urn:iso:15118:2:2016:MsgDataTypes":EVMinimumChargeCurrent,"urn:iso:15118:2:2016:MsgDataTypes":EVTargetEnergyRequest{0-1},"urn:iso:15118:2:2016:MsgDataTypes":EVMaximumEnergyRequest{0-1},"urn:iso:15118:2:2016:MsgDataTypes":EVMinimumEnergyRequest{0-1},"urn:iso:15118:2:2016:MsgDataTypes":EVMaximumVoltage))',  derivedBy='EXTENSION'.  */
	struct iso2AC_EVChargeParameterType AC_EVChargeParameter ;
	unsigned int AC_EVChargeParameter_isUsed:1;
	/* element: "urn:iso:15118:2:2016:MsgDataTypes":AC_EVBidirectionalParameter, Complex type name='urn:iso:15118:2:2016:MsgDataTypes,AC_EVBidirectionalParameterType',  base type name='AC_EVChargeParameterType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='((("urn:iso:15118:2:2016:MsgDataTypes":DepartureTime),("urn:iso:15118:2:2016:MsgDataTypes":EVMaximumChargePower,"urn:iso:15118:2:2016:MsgDataTypes":EVMaximumChargeCurrent,"urn:iso:15118:2:2016:MsgDataTypes":EVMinimumChargeCurrent,"urn:iso:15118:2:2016:MsgDataTypes":EVTargetEnergyRequest{0-1},"urn:iso:15118:2:2016:MsgDataTypes":EVMaximumEnergyRequest{0-1},"urn:iso:15118:2:2016:MsgDataTypes":EVMinimumEnergyRequest{0-1},"urn:iso:15118:2:2016:MsgDataTypes":EVMaximumVoltage)),("urn:iso:15118:2:2016:MsgDataTypes":EVMaximumDischargePower,"urn:iso:15118:2:2016:MsgDataTypes":EVMaximumDischargeCurrent,"urn:iso:15118:2:2016:MsgDataTypes":EVMinimumDischargeCurrent))',  derivedBy='EXTENSION'.  */
	struct iso2AC_EVBidirectionalParameterType AC_EVBidirectionalParameter ;
	unsigned int AC_EVBidirectionalParameter_isUsed:1;
	/* element: "urn:iso:15118:2:2016:MsgDataTypes":DC_EVChargeParameter, Complex type name='urn:iso:15118:2:2016:MsgDataTypes,DC_EVChargeParameterType',  base type name='EVEnergyTransferParameterType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='(("urn:iso:15118:2:2016:MsgDataTypes":DepartureTime),("urn:iso:15118:2:2016:MsgDataTypes":EVMaximumChargePower{0-1},"urn:iso:15118:2:2016:MsgDataTypes":EVMinimumChargePower{0-1},"urn:iso:15118:2:2016:MsgDataTypes":EVMaximumChargeCurrent,"urn:iso:15118:2:2016:MsgDataTypes":EVMinimumChargeCurrent,"urn:iso:15118:2:2016:MsgDataTypes":EVMaximumVoltage,"urn:iso:15118:2:2016:MsgDataTypes":EVTargetEnergyRequest{0-1},"urn:iso:15118:2:2016:MsgDataTypes":EVMaximumEnergyRequest{0-1},"urn:iso:15118:2:2016:MsgDataTypes":EVMinimumEnergyRequest{0-1},"urn:iso:15118:2:2016:MsgDataTypes":CurrentSOC{0-1},"urn:iso:15118:2:2016:MsgDataTypes":TargetSOC{0-1},"urn:iso:15118:2:2016:MsgDataTypes":BulkSOC{0-1}))',  derivedBy='EXTENSION'.  */
	struct iso2DC_EVChargeParameterType DC_EVChargeParameter ;
	unsigned int DC_EVChargeParameter_isUsed:1;
	/* element: "urn:iso:15118:2:2016:MsgDataTypes":DC_EVBidirectionalParameter, Complex type name='urn:iso:15118:2:2016:MsgDataTypes,DC_EVBidirectionalParameterType',  base type name='DC_EVChargeParameterType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='((("urn:iso:15118:2:2016:MsgDataTypes":DepartureTime),("urn:iso:15118:2:2016:MsgDataTypes":EVMaximumChargePower{0-1},"urn:iso:15118:2:2016:MsgDataTypes":EVMinimumChargePower{0-1},"urn:iso:15118:2:2016:MsgDataTypes":EVMaximumChargeCurrent,"urn:iso:15118:2:2016:MsgDataTypes":EVMinimumChargeCurrent,"urn:iso:15118:2:2016:MsgDataTypes":EVMaximumVoltage,"urn:iso:15118:2:2016:MsgDataTypes":EVTargetEnergyRequest{0-1},"urn:iso:15118:2:2016:MsgDataTypes":EVMaximumEnergyRequest{0-1},"urn:iso:15118:2:2016:MsgDataTypes":EVMinimumEnergyRequest{0-1},"urn:iso:15118:2:2016:MsgDataTypes":CurrentSOC{0-1},"urn:iso:15118:2:2016:MsgDataTypes":TargetSOC{0-1},"urn:iso:15118:2:2016:MsgDataTypes":BulkSOC{0-1})),("urn:iso:15118:2:2016:MsgDataTypes":EVMaximumDischargePower{0-1},"urn:iso:15118:2:2016:MsgDataTypes":EVMinimumDischargePower{0-1},"urn:iso:15118:2:2016:MsgDataTypes":EVMaximumDischargeCurrent,"urn:iso:15118:2:2016:MsgDataTypes":EVMinimumDischargeCurrent,"urn:iso:15118:2:2016:MsgDataTypes":EVMinimumVoltage,"urn:iso:15118:2:2016:MsgDataTypes":MinimumSOC{0-1}))',  derivedBy='EXTENSION'.  */
	struct iso2DC_EVBidirectionalParameterType DC_EVBidirectionalParameter ;
	unsigned int DC_EVBidirectionalParameter_isUsed:1;
	/* element: "urn:iso:15118:2:2016:MsgDataTypes":WPT_EVChargeParameter, Complex type name='urn:iso:15118:2:2016:MsgDataTypes,WPT_EVChargeParameterType',  base type name='EVEnergyTransferParameterType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='(("urn:iso:15118:2:2016:MsgDataTypes":DepartureTime),("urn:iso:15118:2:2016:MsgDataTypes":EVMaximumPower,"urn:iso:15118:2:2016:MsgDataTypes":EVMinimumPower,"urn:iso:15118:2:2016:MsgDataTypes":EVTargetEnergyRequest{0-1},"urn:iso:15118:2:2016:MsgDataTypes":EVMaximumEnergyRequest{0-1},"urn:iso:15118:2:2016:MsgDataTypes":EVMinimumEnergyRequest{0-1}))',  derivedBy='EXTENSION'.  */
	struct iso2WPT_EVChargeParameterType WPT_EVChargeParameter ;
	unsigned int WPT_EVChargeParameter_isUsed:1;
	/* element: "urn:iso:15118:2:2016:MsgBody":MinimumPMaxRequest, Complex type name='urn:iso:15118:2:2016:MsgDataTypes,MinimumPMaxRequestType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgDataTypes":MinimumPMaxScheduleEntry{1-3})',  derivedBy='RESTRICTION'.  */
	struct iso2MinimumPMaxRequestType MinimumPMaxRequest ;
	unsigned int MinimumPMaxRequest_isUsed:1;
};

/* Complex type name='urn:iso:15118:2:2016:MsgDataTypes,SensorPackageListType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgDataTypes":SensorPackage{1-255})',  derivedBy='RESTRICTION'.  */
#define iso2SensorPackageListType_SensorPackage_ARRAY_SIZE 5
struct iso2SensorPackageListType {
	/* element: "urn:iso:15118:2:2016:MsgDataTypes":SensorPackage, Complex type name='urn:iso:15118:2:2016:MsgDataTypes,SensorPackageType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgDataTypes":PackageIndex,"urn:iso:15118:2:2016:MsgDataTypes":SensorMeasurements{1-255})',  derivedBy='RESTRICTION'.  */
	struct {
		struct iso2SensorPackageType array[iso2SensorPackageListType_SensorPackage_ARRAY_SIZE];
		uint16_t arrayLen;
	} SensorPackage;
};

/* Complex type name='urn:iso:15118:2:2016:MsgBody,ChargeLoopReqType',  base type name='BodyBaseType',  content type='ELEMENT',  isAbstract='true',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgBody":EVTargetEnergyRequest,"urn:iso:15118:2:2016:MsgBody":EVMaximumEnergyRequest{0-1},"urn:iso:15118:2:2016:MsgBody":EVMinimumEnergyRequest{0-1},"urn:iso:15118:2:2016:MsgBody":DisplayParameters{0-1})',  derivedBy='EXTENSION'.  */
struct iso2ChargeLoopReqType {
	/* element: "urn:iso:15118:2:2016:MsgBody":EVTargetEnergyRequest, Complex type name='urn:iso:15118:2:2016:MsgDataTypes,PhysicalValueType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgDataTypes":Exponent,"urn:iso:15118:2:2016:MsgDataTypes":Value)',  derivedBy='RESTRICTION'.  */
	struct iso2PhysicalValueType EVTargetEnergyRequest ;
	/* element: "urn:iso:15118:2:2016:MsgBody":EVMaximumEnergyRequest, Complex type name='urn:iso:15118:2:2016:MsgDataTypes,PhysicalValueType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgDataTypes":Exponent,"urn:iso:15118:2:2016:MsgDataTypes":Value)',  derivedBy='RESTRICTION'.  */
	struct iso2PhysicalValueType EVMaximumEnergyRequest ;
	unsigned int EVMaximumEnergyRequest_isUsed:1;
	/* element: "urn:iso:15118:2:2016:MsgBody":EVMinimumEnergyRequest, Complex type name='urn:iso:15118:2:2016:MsgDataTypes,PhysicalValueType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgDataTypes":Exponent,"urn:iso:15118:2:2016:MsgDataTypes":Value)',  derivedBy='RESTRICTION'.  */
	struct iso2PhysicalValueType EVMinimumEnergyRequest ;
	unsigned int EVMinimumEnergyRequest_isUsed:1;
	/* element: "urn:iso:15118:2:2016:MsgBody":DisplayParameters, Complex type name='urn:iso:15118:2:2016:MsgDataTypes,DisplayParametersType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgDataTypes":CurrentRange{0-1},"urn:iso:15118:2:2016:MsgDataTypes":CurrentSOC{0-1},"urn:iso:15118:2:2016:MsgDataTypes":TargetSOC{0-1},"urn:iso:15118:2:2016:MsgDataTypes":BulkSOC{0-1},"urn:iso:15118:2:2016:MsgDataTypes":MinimumSOC{0-1},"urn:iso:15118:2:2016:MsgDataTypes":ChargingPerformance{0-1},"urn:iso:15118:2:2016:MsgDataTypes":RemainingTimeToTargetSOC{0-1},"urn:iso:15118:2:2016:MsgDataTypes":RemainingTimeToBulkSOC{0-1},"urn:iso:15118:2:2016:MsgDataTypes":RemainingTimeToMinimumSOC{0-1},"urn:iso:15118:2:2016:MsgDataTypes":ChargingComplete{0-1},"urn:iso:15118:2:2016:MsgDataTypes":BulkChargingComplete{0-1},"urn:iso:15118:2:2016:MsgDataTypes":InletHot{0-1})',  derivedBy='RESTRICTION'.  */
	struct iso2DisplayParametersType DisplayParameters ;
	unsigned int DisplayParameters_isUsed:1;
};

/* Complex type name='urn:iso:15118:2:2016:MsgBody,AC_BidirectionalControlReqType',  base type name='ChargeLoopReqType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='(("urn:iso:15118:2:2016:MsgBody":EVTargetEnergyRequest,"urn:iso:15118:2:2016:MsgBody":EVMaximumEnergyRequest{0-1},"urn:iso:15118:2:2016:MsgBody":EVMinimumEnergyRequest{0-1},"urn:iso:15118:2:2016:MsgBody":DisplayParameters{0-1}),("urn:iso:15118:2:2016:MsgBody":EVOperation{0-1},"urn:iso:15118:2:2016:MsgBody":EVMaximumChargePower,"urn:iso:15118:2:2016:MsgBody":EVMaximumDischargePower{0-1},"urn:iso:15118:2:2016:MsgBody":EVMaximumChargeCurrent,"urn:iso:15118:2:2016:MsgBody":EVMaximumDischargeCurrent{0-1},"urn:iso:15118:2:2016:MsgBody":EVMinimumChargeCurrent,"urn:iso:15118:2:2016:MsgBody":EVMinimumDischargeCurrent{0-1},"urn:iso:15118:2:2016:MsgBody":EVPresentActivePower,"urn:iso:15118:2:2016:MsgBody":EVPresentReactivePower))',  derivedBy='EXTENSION'.  */
struct iso2AC_BidirectionalControlReqType {
	/* element: "urn:iso:15118:2:2016:MsgBody":EVTargetEnergyRequest, Complex type name='urn:iso:15118:2:2016:MsgDataTypes,PhysicalValueType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgDataTypes":Exponent,"urn:iso:15118:2:2016:MsgDataTypes":Value)',  derivedBy='RESTRICTION'.  */
	struct iso2PhysicalValueType EVTargetEnergyRequest ;
	/* element: "urn:iso:15118:2:2016:MsgBody":EVMaximumEnergyRequest, Complex type name='urn:iso:15118:2:2016:MsgDataTypes,PhysicalValueType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgDataTypes":Exponent,"urn:iso:15118:2:2016:MsgDataTypes":Value)',  derivedBy='RESTRICTION'.  */
	struct iso2PhysicalValueType EVMaximumEnergyRequest ;
	unsigned int EVMaximumEnergyRequest_isUsed:1;
	/* element: "urn:iso:15118:2:2016:MsgBody":EVMinimumEnergyRequest, Complex type name='urn:iso:15118:2:2016:MsgDataTypes,PhysicalValueType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgDataTypes":Exponent,"urn:iso:15118:2:2016:MsgDataTypes":Value)',  derivedBy='RESTRICTION'.  */
	struct iso2PhysicalValueType EVMinimumEnergyRequest ;
	unsigned int EVMinimumEnergyRequest_isUsed:1;
	/* element: "urn:iso:15118:2:2016:MsgBody":DisplayParameters, Complex type name='urn:iso:15118:2:2016:MsgDataTypes,DisplayParametersType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgDataTypes":CurrentRange{0-1},"urn:iso:15118:2:2016:MsgDataTypes":CurrentSOC{0-1},"urn:iso:15118:2:2016:MsgDataTypes":TargetSOC{0-1},"urn:iso:15118:2:2016:MsgDataTypes":BulkSOC{0-1},"urn:iso:15118:2:2016:MsgDataTypes":MinimumSOC{0-1},"urn:iso:15118:2:2016:MsgDataTypes":ChargingPerformance{0-1},"urn:iso:15118:2:2016:MsgDataTypes":RemainingTimeToTargetSOC{0-1},"urn:iso:15118:2:2016:MsgDataTypes":RemainingTimeToBulkSOC{0-1},"urn:iso:15118:2:2016:MsgDataTypes":RemainingTimeToMinimumSOC{0-1},"urn:iso:15118:2:2016:MsgDataTypes":ChargingComplete{0-1},"urn:iso:15118:2:2016:MsgDataTypes":BulkChargingComplete{0-1},"urn:iso:15118:2:2016:MsgDataTypes":InletHot{0-1})',  derivedBy='RESTRICTION'.  */
	struct iso2DisplayParametersType DisplayParameters ;
	unsigned int DisplayParameters_isUsed:1;
	/* element: "urn:iso:15118:2:2016:MsgBody":EVOperation, urn:iso:15118:2:2016:MsgDataTypes,EVOperationType */
	iso2EVOperationType EVOperation ;
	unsigned int EVOperation_isUsed:1;
	/* element: "urn:iso:15118:2:2016:MsgBody":EVMaximumChargePower, Complex type name='urn:iso:15118:2:2016:MsgDataTypes,PhysicalValueType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgDataTypes":Exponent,"urn:iso:15118:2:2016:MsgDataTypes":Value)',  derivedBy='RESTRICTION'.  */
	struct iso2PhysicalValueType EVMaximumChargePower ;
	/* element: "urn:iso:15118:2:2016:MsgBody":EVMaximumDischargePower, Complex type name='urn:iso:15118:2:2016:MsgDataTypes,PhysicalValueType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgDataTypes":Exponent,"urn:iso:15118:2:2016:MsgDataTypes":Value)',  derivedBy='RESTRICTION'.  */
	struct iso2PhysicalValueType EVMaximumDischargePower ;
	unsigned int EVMaximumDischargePower_isUsed:1;
	/* element: "urn:iso:15118:2:2016:MsgBody":EVMaximumChargeCurrent, Complex type name='urn:iso:15118:2:2016:MsgDataTypes,PhysicalValueType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgDataTypes":Exponent,"urn:iso:15118:2:2016:MsgDataTypes":Value)',  derivedBy='RESTRICTION'.  */
	struct iso2PhysicalValueType EVMaximumChargeCurrent ;
	/* element: "urn:iso:15118:2:2016:MsgBody":EVMaximumDischargeCurrent, Complex type name='urn:iso:15118:2:2016:MsgDataTypes,PhysicalValueType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgDataTypes":Exponent,"urn:iso:15118:2:2016:MsgDataTypes":Value)',  derivedBy='RESTRICTION'.  */
	struct iso2PhysicalValueType EVMaximumDischargeCurrent ;
	unsigned int EVMaximumDischargeCurrent_isUsed:1;
	/* element: "urn:iso:15118:2:2016:MsgBody":EVMinimumChargeCurrent, Complex type name='urn:iso:15118:2:2016:MsgDataTypes,PhysicalValueType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgDataTypes":Exponent,"urn:iso:15118:2:2016:MsgDataTypes":Value)',  derivedBy='RESTRICTION'.  */
	struct iso2PhysicalValueType EVMinimumChargeCurrent ;
	/* element: "urn:iso:15118:2:2016:MsgBody":EVMinimumDischargeCurrent, Complex type name='urn:iso:15118:2:2016:MsgDataTypes,PhysicalValueType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgDataTypes":Exponent,"urn:iso:15118:2:2016:MsgDataTypes":Value)',  derivedBy='RESTRICTION'.  */
	struct iso2PhysicalValueType EVMinimumDischargeCurrent ;
	unsigned int EVMinimumDischargeCurrent_isUsed:1;
	/* element: "urn:iso:15118:2:2016:MsgBody":EVPresentActivePower, Complex type name='urn:iso:15118:2:2016:MsgDataTypes,PhysicalValueType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgDataTypes":Exponent,"urn:iso:15118:2:2016:MsgDataTypes":Value)',  derivedBy='RESTRICTION'.  */
	struct iso2PhysicalValueType EVPresentActivePower ;
	/* element: "urn:iso:15118:2:2016:MsgBody":EVPresentReactivePower, Complex type name='urn:iso:15118:2:2016:MsgDataTypes,PhysicalValueType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgDataTypes":Exponent,"urn:iso:15118:2:2016:MsgDataTypes":Value)',  derivedBy='RESTRICTION'.  */
	struct iso2PhysicalValueType EVPresentReactivePower ;
};

/* Complex type name='urn:iso:15118:2:2016:MsgDataTypes,MV_EVSEFinePositioningParametersType',  base type name='EVSEFinePositioningParametersType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgDataTypes":MagneticVectorList)',  derivedBy='EXTENSION'.  */
struct iso2MV_EVSEFinePositioningParametersType {
	/* element: "urn:iso:15118:2:2016:MsgDataTypes":MagneticVectorList, Complex type name='urn:iso:15118:2:2016:MsgDataTypes,MagneticVectorListType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgDataTypes":MagneticVector{1-255})',  derivedBy='RESTRICTION'.  */
	struct iso2MagneticVectorListType MagneticVectorList ;
};

/* Complex type name='urn:iso:15118:2:2016:MsgBody,CurrentDemandReqType',  base type name='ChargeLoopReqType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='(("urn:iso:15118:2:2016:MsgBody":EVTargetEnergyRequest,"urn:iso:15118:2:2016:MsgBody":EVMaximumEnergyRequest{0-1},"urn:iso:15118:2:2016:MsgBody":EVMinimumEnergyRequest{0-1},"urn:iso:15118:2:2016:MsgBody":DisplayParameters{0-1}),("urn:iso:15118:2:2016:MsgBody":EVTargetCurrent,"urn:iso:15118:2:2016:MsgBody":EVTargetVoltage,"urn:iso:15118:2:2016:MsgBody":EVMaximumCurrent{0-1},"urn:iso:15118:2:2016:MsgBody":EVMaximumPower{0-1},"urn:iso:15118:2:2016:MsgBody":EVMaximumVoltage{0-1}))',  derivedBy='EXTENSION'.  */
struct iso2CurrentDemandReqType {
	/* element: "urn:iso:15118:2:2016:MsgBody":EVTargetEnergyRequest, Complex type name='urn:iso:15118:2:2016:MsgDataTypes,PhysicalValueType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgDataTypes":Exponent,"urn:iso:15118:2:2016:MsgDataTypes":Value)',  derivedBy='RESTRICTION'.  */
	struct iso2PhysicalValueType EVTargetEnergyRequest ;
	/* element: "urn:iso:15118:2:2016:MsgBody":EVMaximumEnergyRequest, Complex type name='urn:iso:15118:2:2016:MsgDataTypes,PhysicalValueType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgDataTypes":Exponent,"urn:iso:15118:2:2016:MsgDataTypes":Value)',  derivedBy='RESTRICTION'.  */
	struct iso2PhysicalValueType EVMaximumEnergyRequest ;
	unsigned int EVMaximumEnergyRequest_isUsed:1;
	/* element: "urn:iso:15118:2:2016:MsgBody":EVMinimumEnergyRequest, Complex type name='urn:iso:15118:2:2016:MsgDataTypes,PhysicalValueType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgDataTypes":Exponent,"urn:iso:15118:2:2016:MsgDataTypes":Value)',  derivedBy='RESTRICTION'.  */
	struct iso2PhysicalValueType EVMinimumEnergyRequest ;
	unsigned int EVMinimumEnergyRequest_isUsed:1;
	/* element: "urn:iso:15118:2:2016:MsgBody":DisplayParameters, Complex type name='urn:iso:15118:2:2016:MsgDataTypes,DisplayParametersType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgDataTypes":CurrentRange{0-1},"urn:iso:15118:2:2016:MsgDataTypes":CurrentSOC{0-1},"urn:iso:15118:2:2016:MsgDataTypes":TargetSOC{0-1},"urn:iso:15118:2:2016:MsgDataTypes":BulkSOC{0-1},"urn:iso:15118:2:2016:MsgDataTypes":MinimumSOC{0-1},"urn:iso:15118:2:2016:MsgDataTypes":ChargingPerformance{0-1},"urn:iso:15118:2:2016:MsgDataTypes":RemainingTimeToTargetSOC{0-1},"urn:iso:15118:2:2016:MsgDataTypes":RemainingTimeToBulkSOC{0-1},"urn:iso:15118:2:2016:MsgDataTypes":RemainingTimeToMinimumSOC{0-1},"urn:iso:15118:2:2016:MsgDataTypes":ChargingComplete{0-1},"urn:iso:15118:2:2016:MsgDataTypes":BulkChargingComplete{0-1},"urn:iso:15118:2:2016:MsgDataTypes":InletHot{0-1})',  derivedBy='RESTRICTION'.  */
	struct iso2DisplayParametersType DisplayParameters ;
	unsigned int DisplayParameters_isUsed:1;
	/* element: "urn:iso:15118:2:2016:MsgBody":EVTargetCurrent, Complex type name='urn:iso:15118:2:2016:MsgDataTypes,PhysicalValueType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgDataTypes":Exponent,"urn:iso:15118:2:2016:MsgDataTypes":Value)',  derivedBy='RESTRICTION'.  */
	struct iso2PhysicalValueType EVTargetCurrent ;
	/* element: "urn:iso:15118:2:2016:MsgBody":EVTargetVoltage, Complex type name='urn:iso:15118:2:2016:MsgDataTypes,PhysicalValueType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgDataTypes":Exponent,"urn:iso:15118:2:2016:MsgDataTypes":Value)',  derivedBy='RESTRICTION'.  */
	struct iso2PhysicalValueType EVTargetVoltage ;
	/* element: "urn:iso:15118:2:2016:MsgBody":EVMaximumCurrent, Complex type name='urn:iso:15118:2:2016:MsgDataTypes,PhysicalValueType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgDataTypes":Exponent,"urn:iso:15118:2:2016:MsgDataTypes":Value)',  derivedBy='RESTRICTION'.  */
	struct iso2PhysicalValueType EVMaximumCurrent ;
	unsigned int EVMaximumCurrent_isUsed:1;
	/* element: "urn:iso:15118:2:2016:MsgBody":EVMaximumPower, Complex type name='urn:iso:15118:2:2016:MsgDataTypes,PhysicalValueType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgDataTypes":Exponent,"urn:iso:15118:2:2016:MsgDataTypes":Value)',  derivedBy='RESTRICTION'.  */
	struct iso2PhysicalValueType EVMaximumPower ;
	unsigned int EVMaximumPower_isUsed:1;
	/* element: "urn:iso:15118:2:2016:MsgBody":EVMaximumVoltage, Complex type name='urn:iso:15118:2:2016:MsgDataTypes,PhysicalValueType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgDataTypes":Exponent,"urn:iso:15118:2:2016:MsgDataTypes":Value)',  derivedBy='RESTRICTION'.  */
	struct iso2PhysicalValueType EVMaximumVoltage ;
	unsigned int EVMaximumVoltage_isUsed:1;
};

/* Complex type name='urn:iso:15118:2:2016:MsgBody,FinePositioningSetupReqType',  base type name='BodyBaseType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgDataTypes":EVFinePositioningSetupParameters{0-1})',  derivedBy='EXTENSION'.  */
struct iso2FinePositioningSetupReqType {
	/* substitutionGroup */
#if SAVE_MEMORY_WITH_UNNAMED_UNION == UNION_YES
	union {
#endif /* SAVE_MEMORY_WITH_UNNAMED_UNION == UNION_YES */ 
		/* element: "urn:iso:15118:2:2016:MsgDataTypes":EVFinePositioningSetupParameters, Complex type name='urn:iso:15118:2:2016:MsgDataTypes,EVFinePositioningSetupParametersType',  base type name='anyType',  content type='EMPTY',  isAbstract='true',  hasTypeId='false',  final='0',  block='0',  derivedBy='RESTRICTION'.  */
		struct iso2EVFinePositioningSetupParametersType EVFinePositioningSetupParameters ;
		/* element: "urn:iso:15118:2:2016:MsgDataTypes":LFA_EVFinePositioningSetupParameters, Complex type name='urn:iso:15118:2:2016:MsgDataTypes,LFA_EVFinePositioningSetupParametersType',  base type name='EVFinePositioningSetupParametersType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgDataTypes":NumberOfSensors,"urn:iso:15118:2:2016:MsgDataTypes":SensorList,"urn:iso:15118:2:2016:MsgDataTypes":SensorOrder,"urn:iso:15118:2:2016:MsgDataTypes":SignalPulseDuration,"urn:iso:15118:2:2016:MsgDataTypes":SignalSeparationTime,"urn:iso:15118:2:2016:MsgDataTypes":PackageSeparationTime,"urn:iso:15118:2:2016:MsgDataTypes":AlignmentOffset)',  derivedBy='EXTENSION'.  */
		struct iso2LFA_EVFinePositioningSetupParametersType LFA_EVFinePositioningSetupParameters ;
#if SAVE_MEMORY_WITH_UNNAMED_UNION == UNION_YES
	};
#endif /* SAVE_MEMORY_WITH_UNNAMED_UNION == UNION_YES */ 
		unsigned int EVFinePositioningSetupParameters_isUsed:1;
		unsigned int LFA_EVFinePositioningSetupParameters_isUsed:1;
};

/* Complex type name='urn:iso:15118:2:2016:MsgDataTypes,SAScheduleTupleType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgDataTypes":SAScheduleTupleID,"urn:iso:15118:2:2016:MsgDataTypes":PMaxSchedule,"urn:iso:15118:2:2016:MsgDataTypes":PMaxDischargeSchedule{0-1},"urn:iso:15118:2:2016:MsgDataTypes":SalesTariff{0-1},"urn:iso:15118:2:2016:MsgDataTypes":BuyBackTariff{0-1})',  derivedBy='RESTRICTION'.  */
struct iso2SAScheduleTupleType {
	/* element: "urn:iso:15118:2:2016:MsgDataTypes":SAScheduleTupleID, urn:iso:15118:2:2016:MsgDataTypes,SAIDType */
	uint8_t SAScheduleTupleID ;
	/* element: "urn:iso:15118:2:2016:MsgDataTypes":PMaxSchedule, Complex type name='urn:iso:15118:2:2016:MsgDataTypes,PMaxScheduleType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgDataTypes":PMaxScheduleEntry{1-UNBOUNDED})',  derivedBy='RESTRICTION'.  */
	struct iso2PMaxScheduleType PMaxSchedule ;
	/* element: "urn:iso:15118:2:2016:MsgDataTypes":PMaxDischargeSchedule, Complex type name='urn:iso:15118:2:2016:MsgDataTypes,PMaxScheduleType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgDataTypes":PMaxScheduleEntry{1-UNBOUNDED})',  derivedBy='RESTRICTION'.  */
	struct iso2PMaxScheduleType PMaxDischargeSchedule ;
	unsigned int PMaxDischargeSchedule_isUsed:1;
	/* element: "urn:iso:15118:2:2016:MsgDataTypes":SalesTariff, Complex type name='urn:iso:15118:2:2016:MsgDataTypes,SalesTariffType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgDataTypes":SalesTariffID,"urn:iso:15118:2:2016:MsgDataTypes":SalesTariffDescription{0-1},"urn:iso:15118:2:2016:MsgDataTypes":NumEPriceLevels{0-1},"urn:iso:15118:2:2016:MsgDataTypes":SalesTariffEntry{1-UNBOUNDED})',  derivedBy='RESTRICTION'.  */
	struct iso2SalesTariffType SalesTariff ;
	unsigned int SalesTariff_isUsed:1;
	/* element: "urn:iso:15118:2:2016:MsgDataTypes":BuyBackTariff, Complex type name='urn:iso:15118:2:2016:MsgDataTypes,SalesTariffType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgDataTypes":SalesTariffID,"urn:iso:15118:2:2016:MsgDataTypes":SalesTariffDescription{0-1},"urn:iso:15118:2:2016:MsgDataTypes":NumEPriceLevels{0-1},"urn:iso:15118:2:2016:MsgDataTypes":SalesTariffEntry{1-UNBOUNDED})',  derivedBy='RESTRICTION'.  */
	struct iso2SalesTariffType BuyBackTariff ;
	unsigned int BuyBackTariff_isUsed:1;
};

/* Complex type name='urn:iso:15118:2:2016:MsgBody,ServiceDetailResType',  base type name='V2GResponseType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='(("urn:iso:15118:2:2016:MsgBody":ResponseCode,"urn:iso:15118:2:2016:MsgBody":EVSEStatus{0-1}),("urn:iso:15118:2:2016:MsgBody":ServiceID,"urn:iso:15118:2:2016:MsgBody":ServiceParameterList{0-1}))',  derivedBy='EXTENSION'.  */
struct iso2ServiceDetailResType {
	/* element: "urn:iso:15118:2:2016:MsgBody":ResponseCode, urn:iso:15118:2:2016:MsgDataTypes,responseCodeType */
	iso2responseCodeType ResponseCode ;
	/* element: "urn:iso:15118:2:2016:MsgBody":EVSEStatus, Complex type name='urn:iso:15118:2:2016:MsgDataTypes,EVSEStatusType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgDataTypes":NotificationMaxDelay,"urn:iso:15118:2:2016:MsgDataTypes":EVSENotification)',  derivedBy='RESTRICTION'.  */
	struct iso2EVSEStatusType EVSEStatus ;
	unsigned int EVSEStatus_isUsed:1;
	/* element: "urn:iso:15118:2:2016:MsgBody":ServiceID, urn:iso:15118:2:2016:MsgDataTypes,serviceIDType */
	uint16_t ServiceID ;
	/* element: "urn:iso:15118:2:2016:MsgBody":ServiceParameterList, Complex type name='urn:iso:15118:2:2016:MsgDataTypes,ServiceParameterListType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgDataTypes":ParameterSet{1-255})',  derivedBy='RESTRICTION'.  */
	struct iso2ServiceParameterListType ServiceParameterList ;
	unsigned int ServiceParameterList_isUsed:1;
};

/* Complex type name='urn:iso:15118:2:2016:MsgBody,PowerDeliveryReqType',  base type name='BodyBaseType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgBody":ChargeProgress,"urn:iso:15118:2:2016:MsgBody":EVOperation{0-1},"urn:iso:15118:2:2016:MsgBody":SAScheduleTupleID{0-1},"urn:iso:15118:2:2016:MsgBody":ChargingProfile{0-1})',  derivedBy='EXTENSION'.  */
struct iso2PowerDeliveryReqType {
	/* element: "urn:iso:15118:2:2016:MsgBody":ChargeProgress, urn:iso:15118:2:2016:MsgDataTypes,chargeProgressType */
	iso2chargeProgressType ChargeProgress ;
	/* element: "urn:iso:15118:2:2016:MsgBody":EVOperation, urn:iso:15118:2:2016:MsgDataTypes,EVOperationType */
	iso2EVOperationType EVOperation ;
	unsigned int EVOperation_isUsed:1;
	/* element: "urn:iso:15118:2:2016:MsgBody":SAScheduleTupleID, urn:iso:15118:2:2016:MsgDataTypes,SAIDType */
	uint8_t SAScheduleTupleID ;
	unsigned int SAScheduleTupleID_isUsed:1;
	/* element: "urn:iso:15118:2:2016:MsgBody":ChargingProfile, Complex type name='urn:iso:15118:2:2016:MsgDataTypes,ChargingProfileType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgDataTypes":ProfileEntry{1-UNBOUNDED})',  derivedBy='RESTRICTION'.  */
	struct iso2ChargingProfileType ChargingProfile ;
	unsigned int ChargingProfile_isUsed:1;
};

/* Complex type name='urn:iso:15118:2:2016:MsgBody,PairingResType',  base type name='V2GResponseType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='(("urn:iso:15118:2:2016:MsgBody":ResponseCode,"urn:iso:15118:2:2016:MsgBody":EVSEStatus{0-1}),("urn:iso:15118:2:2016:MsgBody":EVSEProcessing,"urn:iso:15118:2:2016:MsgBody":PairingParameters{0-1}))',  derivedBy='EXTENSION'.  */
struct iso2PairingResType {
	/* element: "urn:iso:15118:2:2016:MsgBody":ResponseCode, urn:iso:15118:2:2016:MsgDataTypes,responseCodeType */
	iso2responseCodeType ResponseCode ;
	/* element: "urn:iso:15118:2:2016:MsgBody":EVSEStatus, Complex type name='urn:iso:15118:2:2016:MsgDataTypes,EVSEStatusType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgDataTypes":NotificationMaxDelay,"urn:iso:15118:2:2016:MsgDataTypes":EVSENotification)',  derivedBy='RESTRICTION'.  */
	struct iso2EVSEStatusType EVSEStatus ;
	unsigned int EVSEStatus_isUsed:1;
	/* element: "urn:iso:15118:2:2016:MsgBody":EVSEProcessing, urn:iso:15118:2:2016:MsgDataTypes,EVSEProcessingType */
	iso2EVSEProcessingType EVSEProcessing ;
	/* element: "urn:iso:15118:2:2016:MsgBody":PairingParameters, Complex type name='urn:iso:15118:2:2016:MsgDataTypes,ParameterSetType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgDataTypes":ParameterSetID,"urn:iso:15118:2:2016:MsgDataTypes":Parameter{1-16})',  derivedBy='RESTRICTION'.  */
	struct iso2ParameterSetType PairingParameters ;
	unsigned int PairingParameters_isUsed:1;
};

/* Complex type name='urn:iso:15118:2:2016:MsgBody,PowerDemandReqType',  base type name='ChargeLoopReqType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='(("urn:iso:15118:2:2016:MsgBody":EVTargetEnergyRequest,"urn:iso:15118:2:2016:MsgBody":EVMaximumEnergyRequest{0-1},"urn:iso:15118:2:2016:MsgBody":EVMinimumEnergyRequest{0-1},"urn:iso:15118:2:2016:MsgBody":DisplayParameters{0-1}),("urn:iso:15118:2:2016:MsgBody":EVTargetPower,"urn:iso:15118:2:2016:MsgBody":EVInputPower,"urn:iso:15118:2:2016:MsgBody":PowerDemandParameters{0-1}))',  derivedBy='EXTENSION'.  */
struct iso2PowerDemandReqType {
	/* element: "urn:iso:15118:2:2016:MsgBody":EVTargetEnergyRequest, Complex type name='urn:iso:15118:2:2016:MsgDataTypes,PhysicalValueType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgDataTypes":Exponent,"urn:iso:15118:2:2016:MsgDataTypes":Value)',  derivedBy='RESTRICTION'.  */
	struct iso2PhysicalValueType EVTargetEnergyRequest ;
	/* element: "urn:iso:15118:2:2016:MsgBody":EVMaximumEnergyRequest, Complex type name='urn:iso:15118:2:2016:MsgDataTypes,PhysicalValueType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgDataTypes":Exponent,"urn:iso:15118:2:2016:MsgDataTypes":Value)',  derivedBy='RESTRICTION'.  */
	struct iso2PhysicalValueType EVMaximumEnergyRequest ;
	unsigned int EVMaximumEnergyRequest_isUsed:1;
	/* element: "urn:iso:15118:2:2016:MsgBody":EVMinimumEnergyRequest, Complex type name='urn:iso:15118:2:2016:MsgDataTypes,PhysicalValueType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgDataTypes":Exponent,"urn:iso:15118:2:2016:MsgDataTypes":Value)',  derivedBy='RESTRICTION'.  */
	struct iso2PhysicalValueType EVMinimumEnergyRequest ;
	unsigned int EVMinimumEnergyRequest_isUsed:1;
	/* element: "urn:iso:15118:2:2016:MsgBody":DisplayParameters, Complex type name='urn:iso:15118:2:2016:MsgDataTypes,DisplayParametersType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgDataTypes":CurrentRange{0-1},"urn:iso:15118:2:2016:MsgDataTypes":CurrentSOC{0-1},"urn:iso:15118:2:2016:MsgDataTypes":TargetSOC{0-1},"urn:iso:15118:2:2016:MsgDataTypes":BulkSOC{0-1},"urn:iso:15118:2:2016:MsgDataTypes":MinimumSOC{0-1},"urn:iso:15118:2:2016:MsgDataTypes":ChargingPerformance{0-1},"urn:iso:15118:2:2016:MsgDataTypes":RemainingTimeToTargetSOC{0-1},"urn:iso:15118:2:2016:MsgDataTypes":RemainingTimeToBulkSOC{0-1},"urn:iso:15118:2:2016:MsgDataTypes":RemainingTimeToMinimumSOC{0-1},"urn:iso:15118:2:2016:MsgDataTypes":ChargingComplete{0-1},"urn:iso:15118:2:2016:MsgDataTypes":BulkChargingComplete{0-1},"urn:iso:15118:2:2016:MsgDataTypes":InletHot{0-1})',  derivedBy='RESTRICTION'.  */
	struct iso2DisplayParametersType DisplayParameters ;
	unsigned int DisplayParameters_isUsed:1;
	/* element: "urn:iso:15118:2:2016:MsgBody":EVTargetPower, Complex type name='urn:iso:15118:2:2016:MsgDataTypes,PhysicalValueType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgDataTypes":Exponent,"urn:iso:15118:2:2016:MsgDataTypes":Value)',  derivedBy='RESTRICTION'.  */
	struct iso2PhysicalValueType EVTargetPower ;
	/* element: "urn:iso:15118:2:2016:MsgBody":EVInputPower, Complex type name='urn:iso:15118:2:2016:MsgDataTypes,PhysicalValueType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgDataTypes":Exponent,"urn:iso:15118:2:2016:MsgDataTypes":Value)',  derivedBy='RESTRICTION'.  */
	struct iso2PhysicalValueType EVInputPower ;
	/* element: "urn:iso:15118:2:2016:MsgBody":PowerDemandParameters, Complex type name='urn:iso:15118:2:2016:MsgDataTypes,ParameterSetType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgDataTypes":ParameterSetID,"urn:iso:15118:2:2016:MsgDataTypes":Parameter{1-16})',  derivedBy='RESTRICTION'.  */
	struct iso2ParameterSetType PowerDemandParameters ;
	unsigned int PowerDemandParameters_isUsed:1;
};

/* Complex type name='urn:iso:15118:2:2016:MsgBody,PaymentServiceSelectionReqType',  base type name='BodyBaseType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgBody":SelectedPaymentOption,"urn:iso:15118:2:2016:MsgBody":SelectedEnergyTransferService,"urn:iso:15118:2:2016:MsgBody":SelectedVASList{0-1})',  derivedBy='EXTENSION'.  */
struct iso2PaymentServiceSelectionReqType {
	/* element: "urn:iso:15118:2:2016:MsgBody":SelectedPaymentOption, urn:iso:15118:2:2016:MsgDataTypes,paymentOptionType */
	iso2paymentOptionType SelectedPaymentOption ;
	/* element: "urn:iso:15118:2:2016:MsgBody":SelectedEnergyTransferService, Complex type name='urn:iso:15118:2:2016:MsgDataTypes,SelectedServiceType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgDataTypes":ServiceID,"urn:iso:15118:2:2016:MsgDataTypes":ParameterSetID)',  derivedBy='RESTRICTION'.  */
	struct iso2SelectedServiceType SelectedEnergyTransferService ;
	/* element: "urn:iso:15118:2:2016:MsgBody":SelectedVASList, Complex type name='urn:iso:15118:2:2016:MsgDataTypes,SelectedServiceListType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgDataTypes":SelectedService{1-16})',  derivedBy='RESTRICTION'.  */
	struct iso2SelectedServiceListType SelectedVASList ;
	unsigned int SelectedVASList_isUsed:1;
};

/* Complex type name='urn:iso:15118:2:2016:MsgDataTypes,LFA_EVFinePositioningParametersType',  base type name='EVFinePositioningParametersType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgDataTypes":NumberOfSignalPackages,"urn:iso:15118:2:2016:MsgDataTypes":SensorPackageList)',  derivedBy='EXTENSION'.  */
struct iso2LFA_EVFinePositioningParametersType {
	/* element: "urn:iso:15118:2:2016:MsgDataTypes":NumberOfSignalPackages, http://www.w3.org/2001/XMLSchema,unsignedByte */
	uint8_t NumberOfSignalPackages ;
	/* element: "urn:iso:15118:2:2016:MsgDataTypes":SensorPackageList, Complex type name='urn:iso:15118:2:2016:MsgDataTypes,SensorPackageListType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgDataTypes":SensorPackage{1-255})',  derivedBy='RESTRICTION'.  */
	struct iso2SensorPackageListType SensorPackageList ;
};

/* Complex type name='http://www.w3.org/2000/09/xmldsig#,KeyInfoType',  base type name='anyType',  content type='MIXED',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("http://www.w3.org/2000/09/xmldsig#":KeyName|"http://www.w3.org/2000/09/xmldsig#":KeyValue|"http://www.w3.org/2000/09/xmldsig#":RetrievalMethod|"http://www.w3.org/2000/09/xmldsig#":X509Data|"http://www.w3.org/2000/09/xmldsig#":PGPData|"http://www.w3.org/2000/09/xmldsig#":SPKIData|"http://www.w3.org/2000/09/xmldsig#":MgmtData|(WC[##other:"http://www.w3.org/2000/09/xmldsig#"])){1-UNBOUNDED}',  derivedBy='RESTRICTION'.  */
#define iso2KeyInfoType_Id_CHARACTERS_SIZE 50 + EXTRA_CHAR 
#define iso2KeyInfoType_KeyName_CHARACTERS_SIZE 50 + EXTRA_CHAR 
#define iso2KeyInfoType_KeyName_ARRAY_SIZE 1
#define iso2KeyInfoType_KeyValue_ARRAY_SIZE 1
#define iso2KeyInfoType_RetrievalMethod_ARRAY_SIZE 1
#define iso2KeyInfoType_X509Data_ARRAY_SIZE 1
#define iso2KeyInfoType_PGPData_ARRAY_SIZE 1
#define iso2KeyInfoType_SPKIData_ARRAY_SIZE 1
#define iso2KeyInfoType_MgmtData_CHARACTERS_SIZE 50 + EXTRA_CHAR 
#define iso2KeyInfoType_MgmtData_ARRAY_SIZE 1
#define iso2KeyInfoType_ANY_CHARACTERS_SIZE 50 + EXTRA_CHAR 
struct iso2KeyInfoType {
	/* attribute: Id {http://www.w3.org/2001/XMLSchema,ID} */
	struct {
		exi_string_character_t characters[iso2KeyInfoType_Id_CHARACTERS_SIZE];
		uint16_t charactersLen;
	}  Id ;
	unsigned int Id_isUsed:1;
	/* element: "http://www.w3.org/2000/09/xmldsig#":KeyName, http://www.w3.org/2001/XMLSchema,string */
	struct {
		struct {
			exi_string_character_t characters[iso2KeyInfoType_KeyName_CHARACTERS_SIZE];
			uint16_t charactersLen;
		}  array[iso2KeyInfoType_KeyName_ARRAY_SIZE];
		uint16_t arrayLen;
	} KeyName;
	/* element: "http://www.w3.org/2000/09/xmldsig#":KeyValue, Complex type name='http://www.w3.org/2000/09/xmldsig#,KeyValueType',  base type name='anyType',  content type='MIXED',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("http://www.w3.org/2000/09/xmldsig#":DSAKeyValue|"http://www.w3.org/2000/09/xmldsig#":RSAKeyValue|(WC[##other:"http://www.w3.org/2000/09/xmldsig#"]))',  derivedBy='RESTRICTION'.  */
	struct {
		struct iso2KeyValueType array[iso2KeyInfoType_KeyValue_ARRAY_SIZE];
		uint16_t arrayLen;
	} KeyValue;
	/* element: "http://www.w3.org/2000/09/xmldsig#":RetrievalMethod, Complex type name='http://www.w3.org/2000/09/xmldsig#,RetrievalMethodType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("http://www.w3.org/2000/09/xmldsig#":Transforms{0-1})',  derivedBy='RESTRICTION'.  */
	struct {
		struct iso2RetrievalMethodType array[iso2KeyInfoType_RetrievalMethod_ARRAY_SIZE];
		uint16_t arrayLen;
	} RetrievalMethod;
	/* element: "http://www.w3.org/2000/09/xmldsig#":X509Data, Complex type name='http://www.w3.org/2000/09/xmldsig#,X509DataType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='(("http://www.w3.org/2000/09/xmldsig#":X509IssuerSerial|"http://www.w3.org/2000/09/xmldsig#":X509SKI|"http://www.w3.org/2000/09/xmldsig#":X509SubjectName|"http://www.w3.org/2000/09/xmldsig#":X509Certificate|"http://www.w3.org/2000/09/xmldsig#":X509CRL|(WC[##other:"http://www.w3.org/2000/09/xmldsig#"]))){1-UNBOUNDED}',  derivedBy='RESTRICTION'.  */
	struct {
		struct iso2X509DataType array[iso2KeyInfoType_X509Data_ARRAY_SIZE];
		uint16_t arrayLen;
	} X509Data;
	/* element: "http://www.w3.org/2000/09/xmldsig#":PGPData, Complex type name='http://www.w3.org/2000/09/xmldsig#,PGPDataType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='(("http://www.w3.org/2000/09/xmldsig#":PGPKeyID,"http://www.w3.org/2000/09/xmldsig#":PGPKeyPacket{0-1},(WC[##other:"http://www.w3.org/2000/09/xmldsig#"]){0-UNBOUNDED})|("http://www.w3.org/2000/09/xmldsig#":PGPKeyPacket,(WC[##other:"http://www.w3.org/2000/09/xmldsig#"]){0-UNBOUNDED}))',  derivedBy='RESTRICTION'.  */
	struct {
		struct iso2PGPDataType array[iso2KeyInfoType_PGPData_ARRAY_SIZE];
		uint16_t arrayLen;
	} PGPData;
	/* element: "http://www.w3.org/2000/09/xmldsig#":SPKIData, Complex type name='http://www.w3.org/2000/09/xmldsig#,SPKIDataType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("http://www.w3.org/2000/09/xmldsig#":SPKISexp,(WC[##other:"http://www.w3.org/2000/09/xmldsig#"]){0-1}){1-UNBOUNDED}',  derivedBy='RESTRICTION'.  */
	struct {
		struct iso2SPKIDataType array[iso2KeyInfoType_SPKIData_ARRAY_SIZE];
		uint16_t arrayLen;
	} SPKIData;
	/* element: "http://www.w3.org/2000/09/xmldsig#":MgmtData, http://www.w3.org/2001/XMLSchema,string */
	struct {
		struct {
			exi_string_character_t characters[iso2KeyInfoType_MgmtData_CHARACTERS_SIZE];
			uint16_t charactersLen;
		}  array[iso2KeyInfoType_MgmtData_ARRAY_SIZE];
		uint16_t arrayLen;
	} MgmtData;
	/* element: WC[##other:"http://www.w3.org/2000/09/xmldsig#"] */
	struct {
		exi_string_character_t characters[iso2KeyInfoType_ANY_CHARACTERS_SIZE];
		uint16_t charactersLen;
	}  ANY ;
	unsigned int ANY_isUsed:1;
};

/* Complex type name='urn:iso:15118:2:2016:MsgBody,FinePositioningReqType',  base type name='BodyBaseType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgBody":EVProcessing,"urn:iso:15118:2:2016:MsgDataTypes":EVFinePositioningParameters{0-1})',  derivedBy='EXTENSION'.  */
struct iso2FinePositioningReqType {
	/* element: "urn:iso:15118:2:2016:MsgBody":EVProcessing, urn:iso:15118:2:2016:MsgDataTypes,EVSEProcessingType */
	iso2EVSEProcessingType EVProcessing ;
	/* element: "urn:iso:15118:2:2016:MsgDataTypes":EVFinePositioningParameters, Complex type name='urn:iso:15118:2:2016:MsgDataTypes,EVFinePositioningParametersType',  base type name='anyType',  content type='EMPTY',  isAbstract='true',  hasTypeId='false',  final='0',  block='0',  derivedBy='RESTRICTION'.  */
	struct iso2EVFinePositioningParametersType EVFinePositioningParameters ;
	unsigned int EVFinePositioningParameters_isUsed:1;
	/* element: "urn:iso:15118:2:2016:MsgDataTypes":Generic_EVFinePositioningParameters, Complex type name='urn:iso:15118:2:2016:MsgDataTypes,Generic_EVFinePositioningParametersType',  base type name='EVFinePositioningParametersType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgDataTypes":GenericParameters)',  derivedBy='EXTENSION'.  */
	struct iso2Generic_EVFinePositioningParametersType Generic_EVFinePositioningParameters ;
	unsigned int Generic_EVFinePositioningParameters_isUsed:1;
	/* element: "urn:iso:15118:2:2016:MsgDataTypes":LFA_EVFinePositioningParameters, Complex type name='urn:iso:15118:2:2016:MsgDataTypes,LFA_EVFinePositioningParametersType',  base type name='EVFinePositioningParametersType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgDataTypes":NumberOfSignalPackages,"urn:iso:15118:2:2016:MsgDataTypes":SensorPackageList)',  derivedBy='EXTENSION'.  */
	struct iso2LFA_EVFinePositioningParametersType LFA_EVFinePositioningParameters ;
	unsigned int LFA_EVFinePositioningParameters_isUsed:1;
};

/* Complex type name='http://www.w3.org/2000/09/xmldsig#,SignatureType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("http://www.w3.org/2000/09/xmldsig#":SignedInfo,"http://www.w3.org/2000/09/xmldsig#":SignatureValue,"http://www.w3.org/2000/09/xmldsig#":KeyInfo{0-1},"http://www.w3.org/2000/09/xmldsig#":Object{0-UNBOUNDED})',  derivedBy='RESTRICTION'.  */
#define iso2SignatureType_Id_CHARACTERS_SIZE 50 + EXTRA_CHAR 
#define iso2SignatureType_Object_ARRAY_SIZE 1
struct iso2SignatureType {
	/* attribute: Id {http://www.w3.org/2001/XMLSchema,ID} */
	struct {
		exi_string_character_t characters[iso2SignatureType_Id_CHARACTERS_SIZE];
		uint16_t charactersLen;
	}  Id ;
	unsigned int Id_isUsed:1;
	/* element: "http://www.w3.org/2000/09/xmldsig#":SignedInfo, Complex type name='http://www.w3.org/2000/09/xmldsig#,SignedInfoType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("http://www.w3.org/2000/09/xmldsig#":CanonicalizationMethod,"http://www.w3.org/2000/09/xmldsig#":SignatureMethod,"http://www.w3.org/2000/09/xmldsig#":Reference{1-UNBOUNDED})',  derivedBy='RESTRICTION'.  */
	struct iso2SignedInfoType SignedInfo ;
	/* element: "http://www.w3.org/2000/09/xmldsig#":SignatureValue, Complex type name='http://www.w3.org/2000/09/xmldsig#,SignatureValueType',  base type name='base64Binary',  content type='SIMPLE',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  derivedBy='EXTENSION'.  */
	struct iso2SignatureValueType SignatureValue ;
	/* element: "http://www.w3.org/2000/09/xmldsig#":KeyInfo, Complex type name='http://www.w3.org/2000/09/xmldsig#,KeyInfoType',  base type name='anyType',  content type='MIXED',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("http://www.w3.org/2000/09/xmldsig#":KeyName|"http://www.w3.org/2000/09/xmldsig#":KeyValue|"http://www.w3.org/2000/09/xmldsig#":RetrievalMethod|"http://www.w3.org/2000/09/xmldsig#":X509Data|"http://www.w3.org/2000/09/xmldsig#":PGPData|"http://www.w3.org/2000/09/xmldsig#":SPKIData|"http://www.w3.org/2000/09/xmldsig#":MgmtData|(WC[##other:"http://www.w3.org/2000/09/xmldsig#"])){1-UNBOUNDED}',  derivedBy='RESTRICTION'.  */
	struct iso2KeyInfoType KeyInfo ;
	unsigned int KeyInfo_isUsed:1;
	/* element: "http://www.w3.org/2000/09/xmldsig#":Object, Complex type name='http://www.w3.org/2000/09/xmldsig#,ObjectType',  base type name='anyType',  content type='MIXED',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='((WC[##any])){0-UNBOUNDED}',  derivedBy='RESTRICTION'.  */
	struct {
		struct iso2ObjectType array[iso2SignatureType_Object_ARRAY_SIZE];
		uint16_t arrayLen;
	} Object;
};

/* Complex type name='urn:iso:15118:2:2016:MsgBody,FinePositioningSetupResType',  base type name='V2GResponseType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='(("urn:iso:15118:2:2016:MsgBody":ResponseCode,"urn:iso:15118:2:2016:MsgBody":EVSEStatus{0-1}),("urn:iso:15118:2:2016:MsgDataTypes":EVSEFinePositioningSetupParameters{0-1}))',  derivedBy='EXTENSION'.  */
struct iso2FinePositioningSetupResType {
	/* element: "urn:iso:15118:2:2016:MsgBody":ResponseCode, urn:iso:15118:2:2016:MsgDataTypes,responseCodeType */
	iso2responseCodeType ResponseCode ;
	/* element: "urn:iso:15118:2:2016:MsgBody":EVSEStatus, Complex type name='urn:iso:15118:2:2016:MsgDataTypes,EVSEStatusType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgDataTypes":NotificationMaxDelay,"urn:iso:15118:2:2016:MsgDataTypes":EVSENotification)',  derivedBy='RESTRICTION'.  */
	struct iso2EVSEStatusType EVSEStatus ;
	unsigned int EVSEStatus_isUsed:1;
	/* element: "urn:iso:15118:2:2016:MsgDataTypes":EVSEFinePositioningSetupParameters, Complex type name='urn:iso:15118:2:2016:MsgDataTypes,EVSEFinePositioningSetupParametersType',  base type name='anyType',  content type='EMPTY',  isAbstract='true',  hasTypeId='false',  final='0',  block='0',  derivedBy='RESTRICTION'.  */
	struct iso2EVSEFinePositioningSetupParametersType EVSEFinePositioningSetupParameters ;
	unsigned int EVSEFinePositioningSetupParameters_isUsed:1;
	/* element: "urn:iso:15118:2:2016:MsgDataTypes":LFA_EVSEFinePositioningSetupParameters, Complex type name='urn:iso:15118:2:2016:MsgDataTypes,LFA_EVSEFinePositioningSetupParametersType',  base type name='EVSEFinePositioningSetupParametersType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgDataTypes":NumberOfSensors,"urn:iso:15118:2:2016:MsgDataTypes":SensorList,"urn:iso:15118:2:2016:MsgDataTypes":SensorOrder,"urn:iso:15118:2:2016:MsgDataTypes":SignalPulseDuration,"urn:iso:15118:2:2016:MsgDataTypes":SignalSeparationTime,"urn:iso:15118:2:2016:MsgDataTypes":PackageSeparationTime,"urn:iso:15118:2:2016:MsgDataTypes":AlignmentOffset,"urn:iso:15118:2:2016:MsgDataTypes":SignalFrequency)',  derivedBy='EXTENSION'.  */
	struct iso2LFA_EVSEFinePositioningSetupParametersType LFA_EVSEFinePositioningSetupParameters ;
	unsigned int LFA_EVSEFinePositioningSetupParameters_isUsed:1;
	/* element: "urn:iso:15118:2:2016:MsgDataTypes":MV_EVSEFinePositioningSetupParameters, Complex type name='urn:iso:15118:2:2016:MsgDataTypes,MV_EVSEFinePositioningSetupParametersType',  base type name='EVSEFinePositioningSetupParametersType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgDataTypes":FrequencyChannel{0-1},"urn:iso:15118:2:2016:MsgDataTypes":MagneticVectorSetupList{0-1})',  derivedBy='EXTENSION'.  */
	struct iso2MV_EVSEFinePositioningSetupParametersType MV_EVSEFinePositioningSetupParameters ;
	unsigned int MV_EVSEFinePositioningSetupParameters_isUsed:1;
};

/* Complex type name='urn:iso:15118:2:2016:MsgDataTypes,SAScheduleListType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgDataTypes":SAScheduleTuple{1-3})',  derivedBy='RESTRICTION'.  */
#define iso2SAScheduleListType_SAScheduleTuple_ARRAY_SIZE 3
struct iso2SAScheduleListType {
	/* element: "urn:iso:15118:2:2016:MsgDataTypes":SAScheduleTuple, Complex type name='urn:iso:15118:2:2016:MsgDataTypes,SAScheduleTupleType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgDataTypes":SAScheduleTupleID,"urn:iso:15118:2:2016:MsgDataTypes":PMaxSchedule,"urn:iso:15118:2:2016:MsgDataTypes":PMaxDischargeSchedule{0-1},"urn:iso:15118:2:2016:MsgDataTypes":SalesTariff{0-1},"urn:iso:15118:2:2016:MsgDataTypes":BuyBackTariff{0-1})',  derivedBy='RESTRICTION'.  */
	struct {
		struct iso2SAScheduleTupleType array[iso2SAScheduleListType_SAScheduleTuple_ARRAY_SIZE];
		uint16_t arrayLen;
	} SAScheduleTuple;
};

/* Complex type name='urn:iso:15118:2:2016:MsgDataTypes,LFA_EVSEFinePositioningParametersType',  base type name='EVSEFinePositioningParametersType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgDataTypes":NumberOfSignalPackages,"urn:iso:15118:2:2016:MsgDataTypes":SensorPackageList)',  derivedBy='EXTENSION'.  */
struct iso2LFA_EVSEFinePositioningParametersType {
	/* element: "urn:iso:15118:2:2016:MsgDataTypes":NumberOfSignalPackages, http://www.w3.org/2001/XMLSchema,unsignedByte */
	uint8_t NumberOfSignalPackages ;
	/* element: "urn:iso:15118:2:2016:MsgDataTypes":SensorPackageList, Complex type name='urn:iso:15118:2:2016:MsgDataTypes,SensorPackageListType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgDataTypes":SensorPackage{1-255})',  derivedBy='RESTRICTION'.  */
	struct iso2SensorPackageListType SensorPackageList ;
};

/* Complex type name='urn:iso:15118:2:2016:MsgHeader,MessageHeaderType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgHeader":SessionID,"http://www.w3.org/2000/09/xmldsig#":Signature{0-1})',  derivedBy='RESTRICTION'.  */
#define iso2MessageHeaderType_SessionID_BYTES_SIZE 8 /* XML schema facet maxLength for urn:iso:15118:2:2016:MsgDataTypes,sessionIDType is 8 */
struct iso2MessageHeaderType {
	/* element: "urn:iso:15118:2:2016:MsgHeader":SessionID, urn:iso:15118:2:2016:MsgDataTypes,sessionIDType */
	struct {
		uint8_t bytes[iso2MessageHeaderType_SessionID_BYTES_SIZE];
		uint16_t bytesLen;
	}  SessionID ;
	/* element: "http://www.w3.org/2000/09/xmldsig#":Signature, Complex type name='http://www.w3.org/2000/09/xmldsig#,SignatureType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("http://www.w3.org/2000/09/xmldsig#":SignedInfo,"http://www.w3.org/2000/09/xmldsig#":SignatureValue,"http://www.w3.org/2000/09/xmldsig#":KeyInfo{0-1},"http://www.w3.org/2000/09/xmldsig#":Object{0-UNBOUNDED})',  derivedBy='RESTRICTION'.  */
	struct iso2SignatureType Signature ;
	unsigned int Signature_isUsed:1;
};

/* Complex type name='urn:iso:15118:2:2016:MsgBody,FinePositioningResType',  base type name='V2GResponseType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='(("urn:iso:15118:2:2016:MsgBody":ResponseCode,"urn:iso:15118:2:2016:MsgBody":EVSEStatus{0-1}),("urn:iso:15118:2:2016:MsgBody":EVSEProcessing,"urn:iso:15118:2:2016:MsgDataTypes":EVSEFinePositioningParameters{0-1}))',  derivedBy='EXTENSION'.  */
struct iso2FinePositioningResType {
	/* element: "urn:iso:15118:2:2016:MsgBody":ResponseCode, urn:iso:15118:2:2016:MsgDataTypes,responseCodeType */
	iso2responseCodeType ResponseCode ;
	/* element: "urn:iso:15118:2:2016:MsgBody":EVSEStatus, Complex type name='urn:iso:15118:2:2016:MsgDataTypes,EVSEStatusType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgDataTypes":NotificationMaxDelay,"urn:iso:15118:2:2016:MsgDataTypes":EVSENotification)',  derivedBy='RESTRICTION'.  */
	struct iso2EVSEStatusType EVSEStatus ;
	unsigned int EVSEStatus_isUsed:1;
	/* element: "urn:iso:15118:2:2016:MsgBody":EVSEProcessing, urn:iso:15118:2:2016:MsgDataTypes,EVSEProcessingType */
	iso2EVSEProcessingType EVSEProcessing ;
	/* element: "urn:iso:15118:2:2016:MsgDataTypes":EVSEFinePositioningParameters, Complex type name='urn:iso:15118:2:2016:MsgDataTypes,EVSEFinePositioningParametersType',  base type name='anyType',  content type='EMPTY',  isAbstract='true',  hasTypeId='false',  final='0',  block='0',  derivedBy='RESTRICTION'.  */
	struct iso2EVSEFinePositioningParametersType EVSEFinePositioningParameters ;
	unsigned int EVSEFinePositioningParameters_isUsed:1;
	/* element: "urn:iso:15118:2:2016:MsgDataTypes":Generic_EVSEFinePositioningParameters, Complex type name='urn:iso:15118:2:2016:MsgDataTypes,Generic_EVSEFinePositioningParametersType',  base type name='EVSEFinePositioningParametersType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgDataTypes":GenericParameters)',  derivedBy='EXTENSION'.  */
	struct iso2Generic_EVSEFinePositioningParametersType Generic_EVSEFinePositioningParameters ;
	unsigned int Generic_EVSEFinePositioningParameters_isUsed:1;
	/* element: "urn:iso:15118:2:2016:MsgDataTypes":LFA_EVSEFinePositioningParameters, Complex type name='urn:iso:15118:2:2016:MsgDataTypes,LFA_EVSEFinePositioningParametersType',  base type name='EVSEFinePositioningParametersType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgDataTypes":NumberOfSignalPackages,"urn:iso:15118:2:2016:MsgDataTypes":SensorPackageList)',  derivedBy='EXTENSION'.  */
	struct iso2LFA_EVSEFinePositioningParametersType LFA_EVSEFinePositioningParameters ;
	unsigned int LFA_EVSEFinePositioningParameters_isUsed:1;
	/* element: "urn:iso:15118:2:2016:MsgDataTypes":MV_EVSEFinePositioningParameters, Complex type name='urn:iso:15118:2:2016:MsgDataTypes,MV_EVSEFinePositioningParametersType',  base type name='EVSEFinePositioningParametersType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgDataTypes":MagneticVectorList)',  derivedBy='EXTENSION'.  */
	struct iso2MV_EVSEFinePositioningParametersType MV_EVSEFinePositioningParameters ;
	unsigned int MV_EVSEFinePositioningParameters_isUsed:1;
};

/* Complex type name='urn:iso:15118:2:2016:MsgBody,ChargeParameterDiscoveryResType',  base type name='V2GResponseType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='(("urn:iso:15118:2:2016:MsgBody":ResponseCode,"urn:iso:15118:2:2016:MsgBody":EVSEStatus{0-1}),("urn:iso:15118:2:2016:MsgBody":EVSEProcessing,"urn:iso:15118:2:2016:MsgBody":SAScheduleList{0-1},"urn:iso:15118:2:2016:MsgDataTypes":EVSEEnergyTransferParameter))',  derivedBy='EXTENSION'.  */
struct iso2ChargeParameterDiscoveryResType {
	/* element: "urn:iso:15118:2:2016:MsgBody":ResponseCode, urn:iso:15118:2:2016:MsgDataTypes,responseCodeType */
	iso2responseCodeType ResponseCode ;
	/* element: "urn:iso:15118:2:2016:MsgBody":EVSEStatus, Complex type name='urn:iso:15118:2:2016:MsgDataTypes,EVSEStatusType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgDataTypes":NotificationMaxDelay,"urn:iso:15118:2:2016:MsgDataTypes":EVSENotification)',  derivedBy='RESTRICTION'.  */
	struct iso2EVSEStatusType EVSEStatus ;
	unsigned int EVSEStatus_isUsed:1;
	/* element: "urn:iso:15118:2:2016:MsgBody":EVSEProcessing, urn:iso:15118:2:2016:MsgDataTypes,EVSEProcessingType */
	iso2EVSEProcessingType EVSEProcessing ;
	/* element: "urn:iso:15118:2:2016:MsgBody":SAScheduleList, Complex type name='urn:iso:15118:2:2016:MsgDataTypes,SAScheduleListType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgDataTypes":SAScheduleTuple{1-3})',  derivedBy='RESTRICTION'.  */
	struct iso2SAScheduleListType SAScheduleList ;
	unsigned int SAScheduleList_isUsed:1;
	/* element: "urn:iso:15118:2:2016:MsgDataTypes":EVSEEnergyTransferParameter, Complex type name='urn:iso:15118:2:2016:MsgDataTypes,EVSEEnergyTransferParameterType',  base type name='anyType',  content type='EMPTY',  isAbstract='true',  hasTypeId='false',  final='0',  block='0',  derivedBy='RESTRICTION'.  */
	struct iso2EVSEEnergyTransferParameterType EVSEEnergyTransferParameter ;
	unsigned int EVSEEnergyTransferParameter_isUsed:1;
	/* element: "urn:iso:15118:2:2016:MsgDataTypes":AC_EVSEChargeParameter, Complex type name='urn:iso:15118:2:2016:MsgDataTypes,AC_EVSEChargeParameterType',  base type name='EVSEEnergyTransferParameterType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgDataTypes":EVSEMaximumChargeCurrent,"urn:iso:15118:2:2016:MsgDataTypes":EVSENominalVoltage,"urn:iso:15118:2:2016:MsgDataTypes":EVSENominalFrequency)',  derivedBy='EXTENSION'.  */
	struct iso2AC_EVSEChargeParameterType AC_EVSEChargeParameter ;
	unsigned int AC_EVSEChargeParameter_isUsed:1;
	/* element: "urn:iso:15118:2:2016:MsgDataTypes":AC_EVSEBidirectionalParameter, Complex type name='urn:iso:15118:2:2016:MsgDataTypes,AC_EVSEBidirectionalParameterType',  base type name='AC_EVSEChargeParameterType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='(("urn:iso:15118:2:2016:MsgDataTypes":EVSEMaximumChargeCurrent,"urn:iso:15118:2:2016:MsgDataTypes":EVSENominalVoltage,"urn:iso:15118:2:2016:MsgDataTypes":EVSENominalFrequency),("urn:iso:15118:2:2016:MsgDataTypes":EVSEMaximumDischargeCurrent,"urn:iso:15118:2:2016:MsgDataTypes":EVSENominalFrequency))',  derivedBy='EXTENSION'.  */
	struct iso2AC_EVSEBidirectionalParameterType AC_EVSEBidirectionalParameter ;
	unsigned int AC_EVSEBidirectionalParameter_isUsed:1;
	/* element: "urn:iso:15118:2:2016:MsgDataTypes":DC_EVSEChargeParameter, Complex type name='urn:iso:15118:2:2016:MsgDataTypes,DC_EVSEChargeParameterType',  base type name='EVSEEnergyTransferParameterType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgDataTypes":EVSEMaximumChargePower,"urn:iso:15118:2:2016:MsgDataTypes":EVSEMaximumChargeCurrent,"urn:iso:15118:2:2016:MsgDataTypes":EVSEMinimumChargeCurrent,"urn:iso:15118:2:2016:MsgDataTypes":EVSEMaximumVoltage,"urn:iso:15118:2:2016:MsgDataTypes":EVSEMinimumVoltage,"urn:iso:15118:2:2016:MsgDataTypes":EVSECurrentRegulationTolerance{0-1},"urn:iso:15118:2:2016:MsgDataTypes":EVSEPeakCurrentRipple,"urn:iso:15118:2:2016:MsgDataTypes":EVSEEnergyToBeDelivered{0-1})',  derivedBy='EXTENSION'.  */
	struct iso2DC_EVSEChargeParameterType DC_EVSEChargeParameter ;
	unsigned int DC_EVSEChargeParameter_isUsed:1;
	/* element: "urn:iso:15118:2:2016:MsgDataTypes":DC_EVSEBidirectionalParameter, Complex type name='urn:iso:15118:2:2016:MsgDataTypes,DC_EVSEBidirectionalParameterType',  base type name='DC_EVSEChargeParameterType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='(("urn:iso:15118:2:2016:MsgDataTypes":EVSEMaximumChargePower,"urn:iso:15118:2:2016:MsgDataTypes":EVSEMaximumChargeCurrent,"urn:iso:15118:2:2016:MsgDataTypes":EVSEMinimumChargeCurrent,"urn:iso:15118:2:2016:MsgDataTypes":EVSEMaximumVoltage,"urn:iso:15118:2:2016:MsgDataTypes":EVSEMinimumVoltage,"urn:iso:15118:2:2016:MsgDataTypes":EVSECurrentRegulationTolerance{0-1},"urn:iso:15118:2:2016:MsgDataTypes":EVSEPeakCurrentRipple,"urn:iso:15118:2:2016:MsgDataTypes":EVSEEnergyToBeDelivered{0-1}),("urn:iso:15118:2:2016:MsgDataTypes":EVSEMaximumDischargePower,"urn:iso:15118:2:2016:MsgDataTypes":EVSEMaximumDischargeCurrent,"urn:iso:15118:2:2016:MsgDataTypes":EVSEMinimumDischargeCurrent))',  derivedBy='EXTENSION'.  */
	struct iso2DC_EVSEBidirectionalParameterType DC_EVSEBidirectionalParameter ;
	unsigned int DC_EVSEBidirectionalParameter_isUsed:1;
	/* element: "urn:iso:15118:2:2016:MsgDataTypes":WPT_EVSEChargeParameter, Complex type name='urn:iso:15118:2:2016:MsgDataTypes,WPT_EVSEChargeParameterType',  base type name='EVSEEnergyTransferParameterType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgDataTypes":EVSEMaximumPower,"urn:iso:15118:2:2016:MsgDataTypes":EVSEMinimumPower)',  derivedBy='EXTENSION'.  */
	struct iso2WPT_EVSEChargeParameterType WPT_EVSEChargeParameter ;
	unsigned int WPT_EVSEChargeParameter_isUsed:1;
};

/* Complex type name='urn:iso:15118:2:2016:MsgBody,BodyType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgBody":BodyElement)',  derivedBy='RESTRICTION'.  */
struct iso2BodyType {
	/* substitutionGroup */
#if SAVE_MEMORY_WITH_UNNAMED_UNION == UNION_YES
	union {
#endif /* SAVE_MEMORY_WITH_UNNAMED_UNION == UNION_YES */ 
		/* element: "urn:iso:15118:2:2016:MsgBody":BodyElement, Complex type name='urn:iso:15118:2:2016:MsgBody,BodyBaseType',  base type name='anyType',  content type='EMPTY',  isAbstract='true',  hasTypeId='false',  final='0',  block='0',  derivedBy='RESTRICTION'.  */
		struct iso2BodyBaseType BodyElement ;
		/* element: "urn:iso:15118:2:2016:MsgBody":V2GRequest, Complex type name='urn:iso:15118:2:2016:MsgBody,BodyBaseType',  base type name='anyType',  content type='EMPTY',  isAbstract='true',  hasTypeId='false',  final='0',  block='0',  derivedBy='RESTRICTION'.  */
		struct iso2BodyBaseType V2GRequest ;
		/* element: "urn:iso:15118:2:2016:MsgBody":DisconnectChargingDeviceReq, Complex type name='urn:iso:15118:2:2016:MsgBody,DisconnectChargingDeviceReqType',  base type name='BodyBaseType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgBody":EVElectricalChargingDeviceStatus,"urn:iso:15118:2:2016:MsgBody":EVMechanicalChargingDeviceStatus)',  derivedBy='EXTENSION'.  */
		struct iso2DisconnectChargingDeviceReqType DisconnectChargingDeviceReq ;
		/* element: "urn:iso:15118:2:2016:MsgBody":ConnectChargingDeviceReq, Complex type name='urn:iso:15118:2:2016:MsgBody,ConnectChargingDeviceReqType',  base type name='BodyBaseType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgBody":EVElectricalChargingDeviceStatus,"urn:iso:15118:2:2016:MsgBody":EVMechanicalChargingDeviceStatus)',  derivedBy='EXTENSION'.  */
		struct iso2ConnectChargingDeviceReqType ConnectChargingDeviceReq ;
		/* element: "urn:iso:15118:2:2016:MsgBody":SystemStatusReq, Complex type name='urn:iso:15118:2:2016:MsgBody,SystemStatusReqType',  base type name='BodyBaseType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgBody":OperationMode,"urn:iso:15118:2:2016:MsgBody":EVMechanicalChargingDeviceStatus)',  derivedBy='EXTENSION'.  */
		struct iso2SystemStatusReqType SystemStatusReq ;
		/* element: "urn:iso:15118:2:2016:MsgBody":DC_BidirectionalControlReq, Complex type name='urn:iso:15118:2:2016:MsgBody,DC_BidirectionalControlReqType',  base type name='ChargeLoopReqType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='(("urn:iso:15118:2:2016:MsgBody":EVTargetEnergyRequest,"urn:iso:15118:2:2016:MsgBody":EVMaximumEnergyRequest{0-1},"urn:iso:15118:2:2016:MsgBody":EVMinimumEnergyRequest{0-1},"urn:iso:15118:2:2016:MsgBody":DisplayParameters{0-1}),("urn:iso:15118:2:2016:MsgBody":EVTargetCurrent,"urn:iso:15118:2:2016:MsgBody":EVTargetVoltage,"urn:iso:15118:2:2016:MsgBody":EVMaximumVoltage,"urn:iso:15118:2:2016:MsgBody":EVMinimumVoltage,"urn:iso:15118:2:2016:MsgBody":EVMaximumChargeCurrent,"urn:iso:15118:2:2016:MsgBody":EVMaximumDischargeCurrent{0-1},"urn:iso:15118:2:2016:MsgBody":EVMaximumChargePower{0-1},"urn:iso:15118:2:2016:MsgBody":EVMaximumDischargePower{0-1}))',  derivedBy='EXTENSION'.  */
		struct iso2DC_BidirectionalControlReqType DC_BidirectionalControlReq ;
		/* element: "urn:iso:15118:2:2016:MsgBody":AC_BidirectionalControlReq, Complex type name='urn:iso:15118:2:2016:MsgBody,AC_BidirectionalControlReqType',  base type name='ChargeLoopReqType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='(("urn:iso:15118:2:2016:MsgBody":EVTargetEnergyRequest,"urn:iso:15118:2:2016:MsgBody":EVMaximumEnergyRequest{0-1},"urn:iso:15118:2:2016:MsgBody":EVMinimumEnergyRequest{0-1},"urn:iso:15118:2:2016:MsgBody":DisplayParameters{0-1}),("urn:iso:15118:2:2016:MsgBody":EVOperation{0-1},"urn:iso:15118:2:2016:MsgBody":EVMaximumChargePower,"urn:iso:15118:2:2016:MsgBody":EVMaximumDischargePower{0-1},"urn:iso:15118:2:2016:MsgBody":EVMaximumChargeCurrent,"urn:iso:15118:2:2016:MsgBody":EVMaximumDischargeCurrent{0-1},"urn:iso:15118:2:2016:MsgBody":EVMinimumChargeCurrent,"urn:iso:15118:2:2016:MsgBody":EVMinimumDischargeCurrent{0-1},"urn:iso:15118:2:2016:MsgBody":EVPresentActivePower,"urn:iso:15118:2:2016:MsgBody":EVPresentReactivePower))',  derivedBy='EXTENSION'.  */
		struct iso2AC_BidirectionalControlReqType AC_BidirectionalControlReq ;
		/* element: "urn:iso:15118:2:2016:MsgBody":VehicleCheckOutReq, Complex type name='urn:iso:15118:2:2016:MsgBody,VehicleCheckOutReqType',  base type name='BodyBaseType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgBody":EVCheckOutStatus,"urn:iso:15118:2:2016:MsgBody":CheckOutTime)',  derivedBy='EXTENSION'.  */
		struct iso2VehicleCheckOutReqType VehicleCheckOutReq ;
		/* element: "urn:iso:15118:2:2016:MsgBody":VehicleCheckInReq, Complex type name='urn:iso:15118:2:2016:MsgBody,VehicleCheckInReqType',  base type name='BodyBaseType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgBody":EVCheckInStatus,"urn:iso:15118:2:2016:MsgBody":ParkingMethod{0-1})',  derivedBy='EXTENSION'.  */
		struct iso2VehicleCheckInReqType VehicleCheckInReq ;
		/* element: "urn:iso:15118:2:2016:MsgBody":PowerDemandReq, Complex type name='urn:iso:15118:2:2016:MsgBody,PowerDemandReqType',  base type name='ChargeLoopReqType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='(("urn:iso:15118:2:2016:MsgBody":EVTargetEnergyRequest,"urn:iso:15118:2:2016:MsgBody":EVMaximumEnergyRequest{0-1},"urn:iso:15118:2:2016:MsgBody":EVMinimumEnergyRequest{0-1},"urn:iso:15118:2:2016:MsgBody":DisplayParameters{0-1}),("urn:iso:15118:2:2016:MsgBody":EVTargetPower,"urn:iso:15118:2:2016:MsgBody":EVInputPower,"urn:iso:15118:2:2016:MsgBody":PowerDemandParameters{0-1}))',  derivedBy='EXTENSION'.  */
		struct iso2PowerDemandReqType PowerDemandReq ;
		/* element: "urn:iso:15118:2:2016:MsgBody":PairingReq, Complex type name='urn:iso:15118:2:2016:MsgBody,PairingReqType',  base type name='BodyBaseType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgBody":EVProcessing,"urn:iso:15118:2:2016:MsgBody":PairingParameters{0-1})',  derivedBy='EXTENSION'.  */
		struct iso2PairingReqType PairingReq ;
		/* element: "urn:iso:15118:2:2016:MsgBody":AlignmentCheckReq, Complex type name='urn:iso:15118:2:2016:MsgBody,AlignmentCheckReqType',  base type name='BodyBaseType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgBody":EVProcessing,"urn:iso:15118:2:2016:MsgBody":AlignmentCheckParameters{0-1})',  derivedBy='EXTENSION'.  */
		struct iso2AlignmentCheckReqType AlignmentCheckReq ;
		/* element: "urn:iso:15118:2:2016:MsgBody":FinePositioningReq, Complex type name='urn:iso:15118:2:2016:MsgBody,FinePositioningReqType',  base type name='BodyBaseType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgBody":EVProcessing,"urn:iso:15118:2:2016:MsgDataTypes":EVFinePositioningParameters{0-1})',  derivedBy='EXTENSION'.  */
		struct iso2FinePositioningReqType FinePositioningReq ;
		/* element: "urn:iso:15118:2:2016:MsgBody":FinePositioningSetupReq, Complex type name='urn:iso:15118:2:2016:MsgBody,FinePositioningSetupReqType',  base type name='BodyBaseType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgDataTypes":EVFinePositioningSetupParameters{0-1})',  derivedBy='EXTENSION'.  */
		struct iso2FinePositioningSetupReqType FinePositioningSetupReq ;
		/* element: "urn:iso:15118:2:2016:MsgBody":WeldingDetectionReq, Complex type name='urn:iso:15118:2:2016:MsgBody,WeldingDetectionReqType',  base type name='BodyBaseType',  content type='EMPTY',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  derivedBy='EXTENSION'.  */
		struct iso2WeldingDetectionReqType WeldingDetectionReq ;
		/* element: "urn:iso:15118:2:2016:MsgBody":CurrentDemandReq, Complex type name='urn:iso:15118:2:2016:MsgBody,CurrentDemandReqType',  base type name='ChargeLoopReqType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='(("urn:iso:15118:2:2016:MsgBody":EVTargetEnergyRequest,"urn:iso:15118:2:2016:MsgBody":EVMaximumEnergyRequest{0-1},"urn:iso:15118:2:2016:MsgBody":EVMinimumEnergyRequest{0-1},"urn:iso:15118:2:2016:MsgBody":DisplayParameters{0-1}),("urn:iso:15118:2:2016:MsgBody":EVTargetCurrent,"urn:iso:15118:2:2016:MsgBody":EVTargetVoltage,"urn:iso:15118:2:2016:MsgBody":EVMaximumCurrent{0-1},"urn:iso:15118:2:2016:MsgBody":EVMaximumPower{0-1},"urn:iso:15118:2:2016:MsgBody":EVMaximumVoltage{0-1}))',  derivedBy='EXTENSION'.  */
		struct iso2CurrentDemandReqType CurrentDemandReq ;
		/* element: "urn:iso:15118:2:2016:MsgBody":PreChargeReq, Complex type name='urn:iso:15118:2:2016:MsgBody,PreChargeReqType',  base type name='BodyBaseType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgBody":EVTargetVoltage,"urn:iso:15118:2:2016:MsgBody":EVTargetCurrent)',  derivedBy='EXTENSION'.  */
		struct iso2PreChargeReqType PreChargeReq ;
		/* element: "urn:iso:15118:2:2016:MsgBody":CableCheckReq, Complex type name='urn:iso:15118:2:2016:MsgBody,CableCheckReqType',  base type name='BodyBaseType',  content type='EMPTY',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  derivedBy='EXTENSION'.  */
		struct iso2CableCheckReqType CableCheckReq ;
		/* element: "urn:iso:15118:2:2016:MsgBody":ChargingStatusReq, Complex type name='urn:iso:15118:2:2016:MsgBody,ChargingStatusReqType',  base type name='ChargeLoopReqType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='(("urn:iso:15118:2:2016:MsgBody":EVTargetEnergyRequest,"urn:iso:15118:2:2016:MsgBody":EVMaximumEnergyRequest{0-1},"urn:iso:15118:2:2016:MsgBody":EVMinimumEnergyRequest{0-1},"urn:iso:15118:2:2016:MsgBody":DisplayParameters{0-1}),("urn:iso:15118:2:2016:MsgBody":EVMaximumChargePower{0-1},"urn:iso:15118:2:2016:MsgBody":EVMaximumChargeCurrent{0-1},"urn:iso:15118:2:2016:MsgBody":EVMinimumChargeCurrent{0-1}))',  derivedBy='EXTENSION'.  */
		struct iso2ChargingStatusReqType ChargingStatusReq ;
		/* element: "urn:iso:15118:2:2016:MsgBody":CertificateInstallationReq, Complex type name='urn:iso:15118:2:2016:MsgBody,CertificateInstallationReqType',  base type name='BodyBaseType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgBody":OEMProvisioningCert,"urn:iso:15118:2:2016:MsgBody":ListOfRootCertificateIDs)',  derivedBy='EXTENSION'.  */
		struct iso2CertificateInstallationReqType CertificateInstallationReq ;
		/* element: "urn:iso:15118:2:2016:MsgBody":CertificateUpdateReq, Complex type name='urn:iso:15118:2:2016:MsgBody,CertificateUpdateReqType',  base type name='BodyBaseType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgBody":ContractSignatureCertChain,"urn:iso:15118:2:2016:MsgBody":eMAID,"urn:iso:15118:2:2016:MsgBody":ListOfRootCertificateIDs)',  derivedBy='EXTENSION'.  */
		struct iso2CertificateUpdateReqType CertificateUpdateReq ;
		/* element: "urn:iso:15118:2:2016:MsgBody":SessionStopReq, Complex type name='urn:iso:15118:2:2016:MsgBody,SessionStopReqType',  base type name='BodyBaseType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgBody":ChargingSession)',  derivedBy='EXTENSION'.  */
		struct iso2SessionStopReqType SessionStopReq ;
		/* element: "urn:iso:15118:2:2016:MsgBody":MeteringReceiptReq, Complex type name='urn:iso:15118:2:2016:MsgBody,MeteringReceiptReqType',  base type name='BodyBaseType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgBody":SessionID,"urn:iso:15118:2:2016:MsgBody":SAScheduleTupleID{0-1},"urn:iso:15118:2:2016:MsgBody":MeterInfo)',  derivedBy='EXTENSION'.  */
		struct iso2MeteringReceiptReqType MeteringReceiptReq ;
		/* element: "urn:iso:15118:2:2016:MsgBody":PowerDeliveryReq, Complex type name='urn:iso:15118:2:2016:MsgBody,PowerDeliveryReqType',  base type name='BodyBaseType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgBody":ChargeProgress,"urn:iso:15118:2:2016:MsgBody":EVOperation{0-1},"urn:iso:15118:2:2016:MsgBody":SAScheduleTupleID{0-1},"urn:iso:15118:2:2016:MsgBody":ChargingProfile{0-1})',  derivedBy='EXTENSION'.  */
		struct iso2PowerDeliveryReqType PowerDeliveryReq ;
		/* element: "urn:iso:15118:2:2016:MsgBody":ChargeParameterDiscoveryReq, Complex type name='urn:iso:15118:2:2016:MsgBody,ChargeParameterDiscoveryReqType',  base type name='BodyBaseType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgBody":MaxSupportingPoints{0-1},"urn:iso:15118:2:2016:MsgDataTypes":EVEnergyTransferParameter,"urn:iso:15118:2:2016:MsgBody":MinimumPMaxRequest{0-1})',  derivedBy='EXTENSION'.  */
		struct iso2ChargeParameterDiscoveryReqType ChargeParameterDiscoveryReq ;
		/* element: "urn:iso:15118:2:2016:MsgBody":AuthorizationReq, Complex type name='urn:iso:15118:2:2016:MsgBody,AuthorizationReqType',  base type name='BodyBaseType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgBody":GenChallenge{0-1})',  derivedBy='EXTENSION'.  */
		struct iso2AuthorizationReqType AuthorizationReq ;
		/* element: "urn:iso:15118:2:2016:MsgBody":PaymentDetailsReq, Complex type name='urn:iso:15118:2:2016:MsgBody,PaymentDetailsReqType',  base type name='BodyBaseType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgBody":eMAID,"urn:iso:15118:2:2016:MsgBody":ContractSignatureCertChain)',  derivedBy='EXTENSION'.  */
		struct iso2PaymentDetailsReqType PaymentDetailsReq ;
		/* element: "urn:iso:15118:2:2016:MsgBody":PaymentServiceSelectionReq, Complex type name='urn:iso:15118:2:2016:MsgBody,PaymentServiceSelectionReqType',  base type name='BodyBaseType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgBody":SelectedPaymentOption,"urn:iso:15118:2:2016:MsgBody":SelectedEnergyTransferService,"urn:iso:15118:2:2016:MsgBody":SelectedVASList{0-1})',  derivedBy='EXTENSION'.  */
		struct iso2PaymentServiceSelectionReqType PaymentServiceSelectionReq ;
		/* element: "urn:iso:15118:2:2016:MsgBody":ServiceDetailReq, Complex type name='urn:iso:15118:2:2016:MsgBody,ServiceDetailReqType',  base type name='BodyBaseType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgBody":ServiceID)',  derivedBy='EXTENSION'.  */
		struct iso2ServiceDetailReqType ServiceDetailReq ;
		/* element: "urn:iso:15118:2:2016:MsgBody":ServiceDiscoveryReq, Complex type name='urn:iso:15118:2:2016:MsgBody,ServiceDiscoveryReqType',  base type name='BodyBaseType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgBody":SupportedServiceIDs{0-1})',  derivedBy='EXTENSION'.  */
		struct iso2ServiceDiscoveryReqType ServiceDiscoveryReq ;
		/* element: "urn:iso:15118:2:2016:MsgBody":SessionSetupReq, Complex type name='urn:iso:15118:2:2016:MsgBody,SessionSetupReqType',  base type name='BodyBaseType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgBody":EVCCID)',  derivedBy='EXTENSION'.  */
		struct iso2SessionSetupReqType SessionSetupReq ;
		/* element: "urn:iso:15118:2:2016:MsgBody":V2GResponse, Complex type name='urn:iso:15118:2:2016:MsgBody,V2GResponseType',  base type name='BodyBaseType',  content type='ELEMENT',  isAbstract='true',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgBody":ResponseCode,"urn:iso:15118:2:2016:MsgBody":EVSEStatus{0-1})',  derivedBy='EXTENSION'.  */
		struct iso2V2GResponseType V2GResponse ;
		/* element: "urn:iso:15118:2:2016:MsgBody":DisconnectChargingDeviceRes, Complex type name='urn:iso:15118:2:2016:MsgBody,DisconnectChargingDeviceResType',  base type name='V2GResponseType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='(("urn:iso:15118:2:2016:MsgBody":ResponseCode,"urn:iso:15118:2:2016:MsgBody":EVSEStatus{0-1}),("urn:iso:15118:2:2016:MsgBody":EVSEProcessing,"urn:iso:15118:2:2016:MsgBody":EVSEElectricalChargingDeviceStatus,"urn:iso:15118:2:2016:MsgBody":EVSEMechanicalChargingDeviceStatus))',  derivedBy='EXTENSION'.  */
		struct iso2DisconnectChargingDeviceResType DisconnectChargingDeviceRes ;
		/* element: "urn:iso:15118:2:2016:MsgBody":ConnectChargingDeviceRes, Complex type name='urn:iso:15118:2:2016:MsgBody,ConnectChargingDeviceResType',  base type name='V2GResponseType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='(("urn:iso:15118:2:2016:MsgBody":ResponseCode,"urn:iso:15118:2:2016:MsgBody":EVSEStatus{0-1}),("urn:iso:15118:2:2016:MsgBody":EVSEProcessing,"urn:iso:15118:2:2016:MsgBody":EVSEElectricalChargingDeviceStatus,"urn:iso:15118:2:2016:MsgBody":EVSEMechanicalChargingDeviceStatus))',  derivedBy='EXTENSION'.  */
		struct iso2ConnectChargingDeviceResType ConnectChargingDeviceRes ;
		/* element: "urn:iso:15118:2:2016:MsgBody":SystemStatusRes, Complex type name='urn:iso:15118:2:2016:MsgBody,SystemStatusResType',  base type name='V2GResponseType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='(("urn:iso:15118:2:2016:MsgBody":ResponseCode,"urn:iso:15118:2:2016:MsgBody":EVSEStatus{0-1}),("urn:iso:15118:2:2016:MsgBody":OperationMode,"urn:iso:15118:2:2016:MsgBody":EVSEMechanicalChargingDeviceStatus))',  derivedBy='EXTENSION'.  */
		struct iso2SystemStatusResType SystemStatusRes ;
		/* element: "urn:iso:15118:2:2016:MsgBody":DC_BidirectionalControlRes, Complex type name='urn:iso:15118:2:2016:MsgBody,DC_BidirectionalControlResType',  base type name='V2GResponseType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='(("urn:iso:15118:2:2016:MsgBody":ResponseCode,"urn:iso:15118:2:2016:MsgBody":EVSEStatus{0-1}),("urn:iso:15118:2:2016:MsgBody":EVSEPresentCurrent,"urn:iso:15118:2:2016:MsgBody":EVSEPresentVoltage,"urn:iso:15118:2:2016:MsgBody":EVSEPowerLimitAchieved,"urn:iso:15118:2:2016:MsgBody":EVSECurrentLimitAchieved,"urn:iso:15118:2:2016:MsgBody":EVSEVoltageLimitAchieved,"urn:iso:15118:2:2016:MsgBody":EVSEMaximumChargePower{0-1},"urn:iso:15118:2:2016:MsgBody":EVSEMaximumDischargePower{0-1},"urn:iso:15118:2:2016:MsgBody":EVSEMaximumChargeCurrent{0-1},"urn:iso:15118:2:2016:MsgBody":EVSEMaximumDischargeCurrent{0-1},"urn:iso:15118:2:2016:MsgBody":EVSEMaximumVoltage{0-1},"urn:iso:15118:2:2016:MsgBody":EVSEMinimumVoltage{0-1},"urn:iso:15118:2:2016:MsgBody":EVSEID,"urn:iso:15118:2:2016:MsgBody":SAScheduleTupleID{0-1},"urn:iso:15118:2:2016:MsgBody":MeterInfo{0-1},"urn:iso:15118:2:2016:MsgBody":ReceiptRequired{0-1}))',  derivedBy='EXTENSION'.  */
		struct iso2DC_BidirectionalControlResType DC_BidirectionalControlRes ;
		/* element: "urn:iso:15118:2:2016:MsgBody":AC_BidirectionalControlRes, Complex type name='urn:iso:15118:2:2016:MsgBody,AC_BidirectionalControlResType',  base type name='V2GResponseType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='(("urn:iso:15118:2:2016:MsgBody":ResponseCode,"urn:iso:15118:2:2016:MsgBody":EVSEStatus{0-1}),("urn:iso:15118:2:2016:MsgBody":EVSEProcessing,"urn:iso:15118:2:2016:MsgBody":EVSETargetPower,"urn:iso:15118:2:2016:MsgBody":EVSETargetReactivePower,"urn:iso:15118:2:2016:MsgBody":EVSEID,"urn:iso:15118:2:2016:MsgBody":SAScheduleTupleID{0-1},"urn:iso:15118:2:2016:MsgBody":MeterInfo{0-1},"urn:iso:15118:2:2016:MsgBody":ReceiptRequired{0-1}))',  derivedBy='EXTENSION'.  */
		struct iso2AC_BidirectionalControlResType AC_BidirectionalControlRes ;
		/* element: "urn:iso:15118:2:2016:MsgBody":VehicleCheckOutRes, Complex type name='urn:iso:15118:2:2016:MsgBody,VehicleCheckOutResType',  base type name='V2GResponseType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='(("urn:iso:15118:2:2016:MsgBody":ResponseCode,"urn:iso:15118:2:2016:MsgBody":EVSEStatus{0-1}),("urn:iso:15118:2:2016:MsgBody":EVSECheckOutStatus))',  derivedBy='EXTENSION'.  */
		struct iso2VehicleCheckOutResType VehicleCheckOutRes ;
		/* element: "urn:iso:15118:2:2016:MsgBody":VehicleCheckInRes, Complex type name='urn:iso:15118:2:2016:MsgBody,VehicleCheckInResType',  base type name='V2GResponseType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='(("urn:iso:15118:2:2016:MsgBody":ResponseCode,"urn:iso:15118:2:2016:MsgBody":EVSEStatus{0-1}),("urn:iso:15118:2:2016:MsgBody":VehicleSpace,"urn:iso:15118:2:2016:MsgBody":TargetOffset{0-1}))',  derivedBy='EXTENSION'.  */
		struct iso2VehicleCheckInResType VehicleCheckInRes ;
		/* element: "urn:iso:15118:2:2016:MsgBody":PowerDemandRes, Complex type name='urn:iso:15118:2:2016:MsgBody,PowerDemandResType',  base type name='V2GResponseType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='(("urn:iso:15118:2:2016:MsgBody":ResponseCode,"urn:iso:15118:2:2016:MsgBody":EVSEStatus{0-1}),("urn:iso:15118:2:2016:MsgBody":EVSEOutputPower,"urn:iso:15118:2:2016:MsgBody":EVSEID,"urn:iso:15118:2:2016:MsgBody":SAScheduleTupleID{0-1},"urn:iso:15118:2:2016:MsgBody":MeterInfo{0-1},"urn:iso:15118:2:2016:MsgBody":ReceiptRequired{0-1},"urn:iso:15118:2:2016:MsgBody":PowerDemandParameters{0-1}))',  derivedBy='EXTENSION'.  */
		struct iso2PowerDemandResType PowerDemandRes ;
		/* element: "urn:iso:15118:2:2016:MsgBody":PairingRes, Complex type name='urn:iso:15118:2:2016:MsgBody,PairingResType',  base type name='V2GResponseType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='(("urn:iso:15118:2:2016:MsgBody":ResponseCode,"urn:iso:15118:2:2016:MsgBody":EVSEStatus{0-1}),("urn:iso:15118:2:2016:MsgBody":EVSEProcessing,"urn:iso:15118:2:2016:MsgBody":PairingParameters{0-1}))',  derivedBy='EXTENSION'.  */
		struct iso2PairingResType PairingRes ;
		/* element: "urn:iso:15118:2:2016:MsgBody":AlignmentCheckRes, Complex type name='urn:iso:15118:2:2016:MsgBody,AlignmentCheckResType',  base type name='V2GResponseType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='(("urn:iso:15118:2:2016:MsgBody":ResponseCode,"urn:iso:15118:2:2016:MsgBody":EVSEStatus{0-1}),("urn:iso:15118:2:2016:MsgBody":EVSEProcessing,"urn:iso:15118:2:2016:MsgBody":AlignmentCheckParameters{0-1}))',  derivedBy='EXTENSION'.  */
		struct iso2AlignmentCheckResType AlignmentCheckRes ;
		/* element: "urn:iso:15118:2:2016:MsgBody":FinePositioningRes, Complex type name='urn:iso:15118:2:2016:MsgBody,FinePositioningResType',  base type name='V2GResponseType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='(("urn:iso:15118:2:2016:MsgBody":ResponseCode,"urn:iso:15118:2:2016:MsgBody":EVSEStatus{0-1}),("urn:iso:15118:2:2016:MsgBody":EVSEProcessing,"urn:iso:15118:2:2016:MsgDataTypes":EVSEFinePositioningParameters{0-1}))',  derivedBy='EXTENSION'.  */
		struct iso2FinePositioningResType FinePositioningRes ;
		/* element: "urn:iso:15118:2:2016:MsgBody":FinePositioningSetupRes, Complex type name='urn:iso:15118:2:2016:MsgBody,FinePositioningSetupResType',  base type name='V2GResponseType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='(("urn:iso:15118:2:2016:MsgBody":ResponseCode,"urn:iso:15118:2:2016:MsgBody":EVSEStatus{0-1}),("urn:iso:15118:2:2016:MsgDataTypes":EVSEFinePositioningSetupParameters{0-1}))',  derivedBy='EXTENSION'.  */
		struct iso2FinePositioningSetupResType FinePositioningSetupRes ;
		/* element: "urn:iso:15118:2:2016:MsgBody":WeldingDetectionRes, Complex type name='urn:iso:15118:2:2016:MsgBody,WeldingDetectionResType',  base type name='V2GResponseType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='(("urn:iso:15118:2:2016:MsgBody":ResponseCode,"urn:iso:15118:2:2016:MsgBody":EVSEStatus{0-1}),("urn:iso:15118:2:2016:MsgBody":EVSEPresentVoltage))',  derivedBy='EXTENSION'.  */
		struct iso2WeldingDetectionResType WeldingDetectionRes ;
		/* element: "urn:iso:15118:2:2016:MsgBody":CurrentDemandRes, Complex type name='urn:iso:15118:2:2016:MsgBody,CurrentDemandResType',  base type name='V2GResponseType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='(("urn:iso:15118:2:2016:MsgBody":ResponseCode,"urn:iso:15118:2:2016:MsgBody":EVSEStatus{0-1}),("urn:iso:15118:2:2016:MsgBody":EVSEPresentCurrent,"urn:iso:15118:2:2016:MsgBody":EVSEPresentVoltage,"urn:iso:15118:2:2016:MsgBody":EVSEPowerLimitAchieved,"urn:iso:15118:2:2016:MsgBody":EVSECurrentLimitAchieved,"urn:iso:15118:2:2016:MsgBody":EVSEVoltageLimitAchieved,"urn:iso:15118:2:2016:MsgBody":EVSEMaximumPower{0-1},"urn:iso:15118:2:2016:MsgBody":EVSEMaximumCurrent{0-1},"urn:iso:15118:2:2016:MsgBody":EVSEMaximumVoltage{0-1},"urn:iso:15118:2:2016:MsgBody":EVSEID,"urn:iso:15118:2:2016:MsgBody":SAScheduleTupleID{0-1},"urn:iso:15118:2:2016:MsgBody":MeterInfo{0-1},"urn:iso:15118:2:2016:MsgBody":ReceiptRequired{0-1}))',  derivedBy='EXTENSION'.  */
		struct iso2CurrentDemandResType CurrentDemandRes ;
		/* element: "urn:iso:15118:2:2016:MsgBody":PreChargeRes, Complex type name='urn:iso:15118:2:2016:MsgBody,PreChargeResType',  base type name='V2GResponseType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='(("urn:iso:15118:2:2016:MsgBody":ResponseCode,"urn:iso:15118:2:2016:MsgBody":EVSEStatus{0-1}),("urn:iso:15118:2:2016:MsgBody":EVSEPresentVoltage))',  derivedBy='EXTENSION'.  */
		struct iso2PreChargeResType PreChargeRes ;
		/* element: "urn:iso:15118:2:2016:MsgBody":CableCheckRes, Complex type name='urn:iso:15118:2:2016:MsgBody,CableCheckResType',  base type name='V2GResponseType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='(("urn:iso:15118:2:2016:MsgBody":ResponseCode,"urn:iso:15118:2:2016:MsgBody":EVSEStatus{0-1}),("urn:iso:15118:2:2016:MsgBody":EVSEProcessing))',  derivedBy='EXTENSION'.  */
		struct iso2CableCheckResType CableCheckRes ;
		/* element: "urn:iso:15118:2:2016:MsgBody":ChargingStatusRes, Complex type name='urn:iso:15118:2:2016:MsgBody,ChargingStatusResType',  base type name='V2GResponseType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='(("urn:iso:15118:2:2016:MsgBody":ResponseCode,"urn:iso:15118:2:2016:MsgBody":EVSEStatus{0-1}),("urn:iso:15118:2:2016:MsgBody":EVSEID,"urn:iso:15118:2:2016:MsgBody":SAScheduleTupleID{0-1},"urn:iso:15118:2:2016:MsgBody":MeterInfo{0-1},"urn:iso:15118:2:2016:MsgBody":ReceiptRequired{0-1},"urn:iso:15118:2:2016:MsgBody":EVSETargetPower{0-1}))',  derivedBy='EXTENSION'.  */
		struct iso2ChargingStatusResType ChargingStatusRes ;
		/* element: "urn:iso:15118:2:2016:MsgBody":CertificateInstallationRes, Complex type name='urn:iso:15118:2:2016:MsgBody,CertificateInstallationResType',  base type name='V2GResponseType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='(("urn:iso:15118:2:2016:MsgBody":ResponseCode,"urn:iso:15118:2:2016:MsgBody":EVSEStatus{0-1}),("urn:iso:15118:2:2016:MsgBody":SAProvisioningCertificateChain,"urn:iso:15118:2:2016:MsgBody":ContractSignatureCertChain,"urn:iso:15118:2:2016:MsgBody":ContractSignatureEncryptedPrivateKey,"urn:iso:15118:2:2016:MsgBody":DHpublickey,"urn:iso:15118:2:2016:MsgBody":eMAID))',  derivedBy='EXTENSION'.  */
		struct iso2CertificateInstallationResType CertificateInstallationRes ;
		/* element: "urn:iso:15118:2:2016:MsgBody":CertificateUpdateRes, Complex type name='urn:iso:15118:2:2016:MsgBody,CertificateUpdateResType',  base type name='V2GResponseType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='(("urn:iso:15118:2:2016:MsgBody":ResponseCode,"urn:iso:15118:2:2016:MsgBody":EVSEStatus{0-1}),("urn:iso:15118:2:2016:MsgBody":SAProvisioningCertificateChain,"urn:iso:15118:2:2016:MsgBody":ContractSignatureCertChain,"urn:iso:15118:2:2016:MsgBody":ContractSignatureEncryptedPrivateKey,"urn:iso:15118:2:2016:MsgBody":DHpublickey,"urn:iso:15118:2:2016:MsgBody":eMAID,"urn:iso:15118:2:2016:MsgBody":RetryCounter{0-1}))',  derivedBy='EXTENSION'.  */
		struct iso2CertificateUpdateResType CertificateUpdateRes ;
		/* element: "urn:iso:15118:2:2016:MsgBody":SessionStopRes, Complex type name='urn:iso:15118:2:2016:MsgBody,SessionStopResType',  base type name='V2GResponseType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgBody":ResponseCode,"urn:iso:15118:2:2016:MsgBody":EVSEStatus{0-1})',  derivedBy='EXTENSION'.  */
		struct iso2SessionStopResType SessionStopRes ;
		/* element: "urn:iso:15118:2:2016:MsgBody":MeteringReceiptRes, Complex type name='urn:iso:15118:2:2016:MsgBody,MeteringReceiptResType',  base type name='V2GResponseType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgBody":ResponseCode,"urn:iso:15118:2:2016:MsgBody":EVSEStatus{0-1})',  derivedBy='EXTENSION'.  */
		struct iso2MeteringReceiptResType MeteringReceiptRes ;
		/* element: "urn:iso:15118:2:2016:MsgBody":PowerDeliveryRes, Complex type name='urn:iso:15118:2:2016:MsgBody,PowerDeliveryResType',  base type name='V2GResponseType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='(("urn:iso:15118:2:2016:MsgBody":ResponseCode,"urn:iso:15118:2:2016:MsgBody":EVSEStatus{0-1}),("urn:iso:15118:2:2016:MsgBody":EVSEProcessing))',  derivedBy='EXTENSION'.  */
		struct iso2PowerDeliveryResType PowerDeliveryRes ;
		/* element: "urn:iso:15118:2:2016:MsgBody":ChargeParameterDiscoveryRes, Complex type name='urn:iso:15118:2:2016:MsgBody,ChargeParameterDiscoveryResType',  base type name='V2GResponseType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='(("urn:iso:15118:2:2016:MsgBody":ResponseCode,"urn:iso:15118:2:2016:MsgBody":EVSEStatus{0-1}),("urn:iso:15118:2:2016:MsgBody":EVSEProcessing,"urn:iso:15118:2:2016:MsgBody":SAScheduleList{0-1},"urn:iso:15118:2:2016:MsgDataTypes":EVSEEnergyTransferParameter))',  derivedBy='EXTENSION'.  */
		struct iso2ChargeParameterDiscoveryResType ChargeParameterDiscoveryRes ;
		/* element: "urn:iso:15118:2:2016:MsgBody":AuthorizationRes, Complex type name='urn:iso:15118:2:2016:MsgBody,AuthorizationResType',  base type name='V2GResponseType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='(("urn:iso:15118:2:2016:MsgBody":ResponseCode,"urn:iso:15118:2:2016:MsgBody":EVSEStatus{0-1}),("urn:iso:15118:2:2016:MsgBody":EVSEProcessing))',  derivedBy='EXTENSION'.  */
		struct iso2AuthorizationResType AuthorizationRes ;
		/* element: "urn:iso:15118:2:2016:MsgBody":PaymentDetailsRes, Complex type name='urn:iso:15118:2:2016:MsgBody,PaymentDetailsResType',  base type name='V2GResponseType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='(("urn:iso:15118:2:2016:MsgBody":ResponseCode,"urn:iso:15118:2:2016:MsgBody":EVSEStatus{0-1}),("urn:iso:15118:2:2016:MsgBody":GenChallenge,"urn:iso:15118:2:2016:MsgBody":EVSETimeStamp))',  derivedBy='EXTENSION'.  */
		struct iso2PaymentDetailsResType PaymentDetailsRes ;
		/* element: "urn:iso:15118:2:2016:MsgBody":PaymentServiceSelectionRes, Complex type name='urn:iso:15118:2:2016:MsgBody,PaymentServiceSelectionResType',  base type name='V2GResponseType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgBody":ResponseCode,"urn:iso:15118:2:2016:MsgBody":EVSEStatus{0-1})',  derivedBy='EXTENSION'.  */
		struct iso2PaymentServiceSelectionResType PaymentServiceSelectionRes ;
		/* element: "urn:iso:15118:2:2016:MsgBody":ServiceDetailRes, Complex type name='urn:iso:15118:2:2016:MsgBody,ServiceDetailResType',  base type name='V2GResponseType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='(("urn:iso:15118:2:2016:MsgBody":ResponseCode,"urn:iso:15118:2:2016:MsgBody":EVSEStatus{0-1}),("urn:iso:15118:2:2016:MsgBody":ServiceID,"urn:iso:15118:2:2016:MsgBody":ServiceParameterList{0-1}))',  derivedBy='EXTENSION'.  */
		struct iso2ServiceDetailResType ServiceDetailRes ;
		/* element: "urn:iso:15118:2:2016:MsgBody":ServiceDiscoveryRes, Complex type name='urn:iso:15118:2:2016:MsgBody,ServiceDiscoveryResType',  base type name='V2GResponseType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='(("urn:iso:15118:2:2016:MsgBody":ResponseCode,"urn:iso:15118:2:2016:MsgBody":EVSEStatus{0-1}),("urn:iso:15118:2:2016:MsgBody":PaymentOptionList,"urn:iso:15118:2:2016:MsgBody":EnergyTransferServiceList,"urn:iso:15118:2:2016:MsgBody":VASList{0-1}))',  derivedBy='EXTENSION'.  */
		struct iso2ServiceDiscoveryResType ServiceDiscoveryRes ;
		/* element: "urn:iso:15118:2:2016:MsgBody":SessionSetupRes, Complex type name='urn:iso:15118:2:2016:MsgBody,SessionSetupResType',  base type name='V2GResponseType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='(("urn:iso:15118:2:2016:MsgBody":ResponseCode,"urn:iso:15118:2:2016:MsgBody":EVSEStatus{0-1}),("urn:iso:15118:2:2016:MsgBody":EVSEID,"urn:iso:15118:2:2016:MsgBody":EVSETimeStamp{0-1}))',  derivedBy='EXTENSION'.  */
		struct iso2SessionSetupResType SessionSetupRes ;
#if SAVE_MEMORY_WITH_UNNAMED_UNION == UNION_YES
	};
#endif /* SAVE_MEMORY_WITH_UNNAMED_UNION == UNION_YES */ 
		unsigned int BodyElement_isUsed:1;
		unsigned int V2GRequest_isUsed:1;
		unsigned int DisconnectChargingDeviceReq_isUsed:1;
		unsigned int ConnectChargingDeviceReq_isUsed:1;
		unsigned int SystemStatusReq_isUsed:1;
		unsigned int DC_BidirectionalControlReq_isUsed:1;
		unsigned int AC_BidirectionalControlReq_isUsed:1;
		unsigned int VehicleCheckOutReq_isUsed:1;
		unsigned int VehicleCheckInReq_isUsed:1;
		unsigned int PowerDemandReq_isUsed:1;
		unsigned int PairingReq_isUsed:1;
		unsigned int AlignmentCheckReq_isUsed:1;
		unsigned int FinePositioningReq_isUsed:1;
		unsigned int FinePositioningSetupReq_isUsed:1;
		unsigned int WeldingDetectionReq_isUsed:1;
		unsigned int CurrentDemandReq_isUsed:1;
		unsigned int PreChargeReq_isUsed:1;
		unsigned int CableCheckReq_isUsed:1;
		unsigned int ChargingStatusReq_isUsed:1;
		unsigned int CertificateInstallationReq_isUsed:1;
		unsigned int CertificateUpdateReq_isUsed:1;
		unsigned int SessionStopReq_isUsed:1;
		unsigned int MeteringReceiptReq_isUsed:1;
		unsigned int PowerDeliveryReq_isUsed:1;
		unsigned int ChargeParameterDiscoveryReq_isUsed:1;
		unsigned int AuthorizationReq_isUsed:1;
		unsigned int PaymentDetailsReq_isUsed:1;
		unsigned int PaymentServiceSelectionReq_isUsed:1;
		unsigned int ServiceDetailReq_isUsed:1;
		unsigned int ServiceDiscoveryReq_isUsed:1;
		unsigned int SessionSetupReq_isUsed:1;
		unsigned int V2GResponse_isUsed:1;
		unsigned int DisconnectChargingDeviceRes_isUsed:1;
		unsigned int ConnectChargingDeviceRes_isUsed:1;
		unsigned int SystemStatusRes_isUsed:1;
		unsigned int DC_BidirectionalControlRes_isUsed:1;
		unsigned int AC_BidirectionalControlRes_isUsed:1;
		unsigned int VehicleCheckOutRes_isUsed:1;
		unsigned int VehicleCheckInRes_isUsed:1;
		unsigned int PowerDemandRes_isUsed:1;
		unsigned int PairingRes_isUsed:1;
		unsigned int AlignmentCheckRes_isUsed:1;
		unsigned int FinePositioningRes_isUsed:1;
		unsigned int FinePositioningSetupRes_isUsed:1;
		unsigned int WeldingDetectionRes_isUsed:1;
		unsigned int CurrentDemandRes_isUsed:1;
		unsigned int PreChargeRes_isUsed:1;
		unsigned int CableCheckRes_isUsed:1;
		unsigned int ChargingStatusRes_isUsed:1;
		unsigned int CertificateInstallationRes_isUsed:1;
		unsigned int CertificateUpdateRes_isUsed:1;
		unsigned int SessionStopRes_isUsed:1;
		unsigned int MeteringReceiptRes_isUsed:1;
		unsigned int PowerDeliveryRes_isUsed:1;
		unsigned int ChargeParameterDiscoveryRes_isUsed:1;
		unsigned int AuthorizationRes_isUsed:1;
		unsigned int PaymentDetailsRes_isUsed:1;
		unsigned int PaymentServiceSelectionRes_isUsed:1;
		unsigned int ServiceDetailRes_isUsed:1;
		unsigned int ServiceDiscoveryRes_isUsed:1;
		unsigned int SessionSetupRes_isUsed:1;
};

/* Complex type name='urn:iso:15118:2:2016:MsgDef,#AnonType_V2G_Message',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgDef":Header,"urn:iso:15118:2:2016:MsgDef":Body)',  derivedBy='RESTRICTION'.  */
struct iso2AnonType_V2G_Message {
	/* element: "urn:iso:15118:2:2016:MsgDef":Header, Complex type name='urn:iso:15118:2:2016:MsgHeader,MessageHeaderType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgHeader":SessionID,"http://www.w3.org/2000/09/xmldsig#":Signature{0-1})',  derivedBy='RESTRICTION'.  */
	struct iso2MessageHeaderType Header ;
	/* element: "urn:iso:15118:2:2016:MsgDef":Body, Complex type name='urn:iso:15118:2:2016:MsgBody,BodyType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2016:MsgBody":BodyElement)',  derivedBy='RESTRICTION'.  */
	struct iso2BodyType Body ;
};



#define EXIDocument_MgmtData_CHARACTERS_SIZE 50 + EXTRA_CHAR 
#define EXIDocument_KeyName_CHARACTERS_SIZE 50 + EXTRA_CHAR 
#define EXIDocument_DigestValue_BYTES_SIZE 350 
#define EXIFragment_stringValue_CHARACTERS_SIZE 50 + EXTRA_CHAR 
#define EXIFragment_PgenCounter_BYTES_SIZE 350 
#define EXIFragment_SalesTariffDescription_CHARACTERS_SIZE 32 + EXTRA_CHAR /* XML schema facet maxLength for urn:iso:15118:2:2016:MsgDataTypes,tariffDescriptionType is 32 */
#define EXIFragment_SessionID_BYTES_SIZE 8 /* XML schema facet maxLength for urn:iso:15118:2:2016:MsgDataTypes,sessionIDType is 8 */
#define EXIFragment_XPath_CHARACTERS_SIZE 50 + EXTRA_CHAR 
#define EXIFragment_MgmtData_CHARACTERS_SIZE 50 + EXTRA_CHAR 
#define EXIFragment_OEMProvisioningCert_BYTES_SIZE 800 /* XML schema facet maxLength for urn:iso:15118:2:2016:MsgDataTypes,certificateType is 800 */
#define EXIFragment_P_BYTES_SIZE 350 
#define EXIFragment_Q_BYTES_SIZE 350 
#define EXIFragment_X509SubjectName_CHARACTERS_SIZE 50 + EXTRA_CHAR 
#define EXIFragment_G_BYTES_SIZE 350 
#define EXIFragment_J_BYTES_SIZE 350 
#define EXIFragment_Y_BYTES_SIZE 350 
#define EXIFragment_DigestValue_BYTES_SIZE 350 
#define EXIFragment_EVCCID_BYTES_SIZE 6 /* XML schema facet maxLength for urn:iso:15118:2:2016:MsgDataTypes,evccIDType is 6 */
#define EXIFragment_PGPKeyID_BYTES_SIZE 350 
#define EXIFragment_KeyName_CHARACTERS_SIZE 50 + EXTRA_CHAR 
#define EXIFragment_X509SKI_BYTES_SIZE 350 
#define EXIFragment_Certificate_BYTES_SIZE 800 /* XML schema facet maxLength for urn:iso:15118:2:2016:MsgDataTypes,certificateType is 800 */
#define EXIFragment_Modulus_BYTES_SIZE 350 
#define EXIFragment_SigMeterReading_BYTES_SIZE 64 /* XML schema facet maxLength for urn:iso:15118:2:2016:MsgDataTypes,sigMeterReadingType is 64 */
#define EXIFragment_Exponent_BYTES_SIZE 350 
#define EXIFragment_PGPKeyPacket_BYTES_SIZE 350 
#define EXIFragment_Seed_BYTES_SIZE 350 
#define EXIFragment_MeterID_CHARACTERS_SIZE 32 + EXTRA_CHAR /* XML schema facet maxLength for urn:iso:15118:2:2016:MsgDataTypes,meterIDType is 32 */
#define EXIFragment_X509CRL_BYTES_SIZE 350 
#define EXIFragment_SPKISexp_BYTES_SIZE 350 
#define EXIFragment_X509Certificate_BYTES_SIZE 350 
#define EXIFragment_EVSEID_CHARACTERS_SIZE 37 + EXTRA_CHAR /* XML schema facet maxLength for urn:iso:15118:2:2016:MsgDataTypes,evseIDType is 37 */
#define EXIFragment_GenChallenge_BYTES_SIZE 16 /* XML schema facet length for urn:iso:15118:2:2016:MsgDataTypes,genChallengeType is 16 */
#define EXIFragment_GAID_CHARACTERS_SIZE 50 + EXTRA_CHAR 
#define EXIFragment_X509IssuerName_CHARACTERS_SIZE 50 + EXTRA_CHAR 


/* Global elements of EXI Document */
struct iso2EXIDocument {
#if SAVE_MEMORY_WITH_UNNAMED_UNION == UNION_YES
	union {
#endif /* SAVE_MEMORY_WITH_UNNAMED_UNION == UNION_YES */ 
	struct iso2AnonType_V2G_Message V2G_Message ;
	struct iso2ServiceDiscoveryReqType ServiceDiscoveryReq ;
	struct iso2ServiceDiscoveryResType ServiceDiscoveryRes ;
	struct iso2FinePositioningReqType FinePositioningReq ;
	struct iso2FinePositioningResType FinePositioningRes ;
	struct iso2DisconnectChargingDeviceReqType DisconnectChargingDeviceReq ;
	struct iso2DisconnectChargingDeviceResType DisconnectChargingDeviceRes ;
	struct iso2PowerDemandReqType PowerDemandReq ;
	struct iso2MeteringReceiptReqType MeteringReceiptReq ;
	struct iso2PaymentDetailsReqType PaymentDetailsReq ;
	struct iso2PowerDemandResType PowerDemandRes ;
	struct iso2MeteringReceiptResType MeteringReceiptRes ;
	struct iso2PaymentDetailsResType PaymentDetailsRes ;
	struct iso2SessionSetupReqType SessionSetupReq ;
	struct iso2SessionSetupResType SessionSetupRes ;
	struct iso2CableCheckReqType CableCheckReq ;
	struct iso2CableCheckResType CableCheckRes ;
	struct iso2CertificateInstallationReqType CertificateInstallationReq ;
	struct iso2CertificateInstallationResType CertificateInstallationRes ;
	struct iso2SystemStatusReqType SystemStatusReq ;
	struct iso2SystemStatusResType SystemStatusRes ;
	struct iso2PairingReqType PairingReq ;
	struct iso2WeldingDetectionReqType WeldingDetectionReq ;
	struct iso2ConnectChargingDeviceReqType ConnectChargingDeviceReq ;
	struct iso2PairingResType PairingRes ;
	struct iso2WeldingDetectionResType WeldingDetectionRes ;
	struct iso2ConnectChargingDeviceResType ConnectChargingDeviceRes ;
	struct iso2CertificateUpdateReqType CertificateUpdateReq ;
	struct iso2CertificateUpdateResType CertificateUpdateRes ;
	struct iso2PaymentServiceSelectionReqType PaymentServiceSelectionReq ;
	struct iso2PowerDeliveryReqType PowerDeliveryReq ;
	struct iso2PaymentServiceSelectionResType PaymentServiceSelectionRes ;
	struct iso2PowerDeliveryResType PowerDeliveryRes ;
	struct iso2ChargingStatusReqType ChargingStatusReq ;
	struct iso2ChargingStatusResType ChargingStatusRes ;
	struct iso2BodyBaseType BodyElement ;
	struct iso2AC_BidirectionalControlReqType AC_BidirectionalControlReq ;
	struct iso2AC_BidirectionalControlResType AC_BidirectionalControlRes ;
	struct iso2VehicleCheckInReqType VehicleCheckInReq ;
	struct iso2CurrentDemandReqType CurrentDemandReq ;
	struct iso2VehicleCheckInResType VehicleCheckInRes ;
	struct iso2PreChargeReqType PreChargeReq ;
	struct iso2CurrentDemandResType CurrentDemandRes ;
	struct iso2PreChargeResType PreChargeRes ;
	struct iso2AlignmentCheckReqType AlignmentCheckReq ;
	struct iso2BodyBaseType V2GRequest ;
	struct iso2SessionStopReqType SessionStopReq ;
	struct iso2AuthorizationReqType AuthorizationReq ;
	struct iso2AlignmentCheckResType AlignmentCheckRes ;
	struct iso2SessionStopResType SessionStopRes ;
	struct iso2AuthorizationResType AuthorizationRes ;
	struct iso2VehicleCheckOutReqType VehicleCheckOutReq ;
	struct iso2ChargeParameterDiscoveryReqType ChargeParameterDiscoveryReq ;
	struct iso2VehicleCheckOutResType VehicleCheckOutRes ;
	struct iso2ChargeParameterDiscoveryResType ChargeParameterDiscoveryRes ;
	struct iso2V2GResponseType V2GResponse ;
	struct iso2FinePositioningSetupReqType FinePositioningSetupReq ;
	struct iso2FinePositioningSetupResType FinePositioningSetupRes ;
	struct iso2ServiceDetailReqType ServiceDetailReq ;
	struct iso2DC_BidirectionalControlReqType DC_BidirectionalControlReq ;
	struct iso2ServiceDetailResType ServiceDetailRes ;
	struct iso2DC_BidirectionalControlResType DC_BidirectionalControlRes ;
	struct iso2LFA_EVFinePositioningSetupParametersType LFA_EVFinePositioningSetupParameters ;
	struct iso2MV_EVSEFinePositioningParametersType MV_EVSEFinePositioningParameters ;
	struct iso2RelativeTimeIntervalType RelativeTimeInterval ;
	struct iso2SalesTariffEntryType SalesTariffEntry ;
	struct iso2LFA_EVSEFinePositioningSetupParametersType LFA_EVSEFinePositioningSetupParameters ;
	struct iso2AC_EVChargeParameterType AC_EVChargeParameter ;
	struct iso2MV_EVSEFinePositioningSetupParametersType MV_EVSEFinePositioningSetupParameters ;
	struct iso2EVEnergyTransferParameterType EVEnergyTransferParameter ;
	struct iso2DC_EVSEBidirectionalParameterType DC_EVSEBidirectionalParameter ;
	struct iso2SAScheduleListType SAScheduleList ;
	struct iso2EVSEFinePositioningSetupParametersType EVSEFinePositioningSetupParameters ;
	struct iso2Generic_EVSEFinePositioningParametersType Generic_EVSEFinePositioningParameters ;
	struct iso2DC_EVChargeParameterType DC_EVChargeParameter ;
	struct iso2DC_EVSEChargeParameterType DC_EVSEChargeParameter ;
	struct iso2LFA_EVFinePositioningParametersType LFA_EVFinePositioningParameters ;
	struct iso2EVFinePositioningSetupParametersType EVFinePositioningSetupParameters ;
	struct iso2AC_EVSEBidirectionalParameterType AC_EVSEBidirectionalParameter ;
	struct iso2EVFinePositioningParametersType EVFinePositioningParameters ;
	struct iso2WPT_EVChargeParameterType WPT_EVChargeParameter ;
	struct iso2LFA_EVSEFinePositioningParametersType LFA_EVSEFinePositioningParameters ;
	struct iso2EVSEEnergyTransferParameterType EVSEEnergyTransferParameter ;
	struct iso2AC_EVBidirectionalParameterType AC_EVBidirectionalParameter ;
	struct iso2EVSEFinePositioningParametersType EVSEFinePositioningParameters ;
	struct iso2WPT_EVSEChargeParameterType WPT_EVSEChargeParameter ;
	struct iso2AC_EVSEChargeParameterType AC_EVSEChargeParameter ;
	struct iso2PMaxScheduleEntryType PMaxScheduleEntry ;
	struct iso2Generic_EVFinePositioningParametersType Generic_EVFinePositioningParameters ;
	struct iso2DC_EVBidirectionalParameterType DC_EVBidirectionalParameter ;
	struct iso2SignaturePropertyType SignatureProperty ;
	struct iso2DSAKeyValueType DSAKeyValue ;
	struct iso2SignaturePropertiesType SignatureProperties ;
	struct iso2KeyValueType KeyValue ;
	struct iso2TransformsType Transforms ;
	struct iso2DigestMethodType DigestMethod ;
	struct iso2SignatureType Signature ;
	struct iso2RetrievalMethodType RetrievalMethod ;
	struct iso2ManifestType Manifest ;
	struct iso2ReferenceType Reference ;
	struct iso2CanonicalizationMethodType CanonicalizationMethod ;
	struct iso2RSAKeyValueType RSAKeyValue ;
	struct iso2TransformType Transform ;
	struct iso2PGPDataType PGPData ;
	struct {
		exi_string_character_t characters[EXIDocument_MgmtData_CHARACTERS_SIZE];
		uint16_t charactersLen;
	}  MgmtData ;
	struct iso2SignatureMethodType SignatureMethod ;
	struct iso2KeyInfoType KeyInfo ;
	struct iso2SPKIDataType SPKIData ;
	struct iso2X509DataType X509Data ;
	struct iso2SignatureValueType SignatureValue ;
	struct {
		exi_string_character_t characters[EXIDocument_KeyName_CHARACTERS_SIZE];
		uint16_t charactersLen;
	}  KeyName ;
	struct {
		uint8_t bytes[EXIDocument_DigestValue_BYTES_SIZE];
		uint16_t bytesLen;
	}  DigestValue ;
	struct iso2SignedInfoType SignedInfo ;
	struct iso2ObjectType Object ;
#if SAVE_MEMORY_WITH_UNNAMED_UNION == UNION_YES
	};
#endif /* SAVE_MEMORY_WITH_UNNAMED_UNION == UNION_YES */ 
	unsigned int V2G_Message_isUsed:1;
	unsigned int ServiceDiscoveryReq_isUsed:1;
	unsigned int ServiceDiscoveryRes_isUsed:1;
	unsigned int FinePositioningReq_isUsed:1;
	unsigned int FinePositioningRes_isUsed:1;
	unsigned int DisconnectChargingDeviceReq_isUsed:1;
	unsigned int DisconnectChargingDeviceRes_isUsed:1;
	unsigned int PowerDemandReq_isUsed:1;
	unsigned int MeteringReceiptReq_isUsed:1;
	unsigned int PaymentDetailsReq_isUsed:1;
	unsigned int PowerDemandRes_isUsed:1;
	unsigned int MeteringReceiptRes_isUsed:1;
	unsigned int PaymentDetailsRes_isUsed:1;
	unsigned int SessionSetupReq_isUsed:1;
	unsigned int SessionSetupRes_isUsed:1;
	unsigned int CableCheckReq_isUsed:1;
	unsigned int CableCheckRes_isUsed:1;
	unsigned int CertificateInstallationReq_isUsed:1;
	unsigned int CertificateInstallationRes_isUsed:1;
	unsigned int SystemStatusReq_isUsed:1;
	unsigned int SystemStatusRes_isUsed:1;
	unsigned int PairingReq_isUsed:1;
	unsigned int WeldingDetectionReq_isUsed:1;
	unsigned int ConnectChargingDeviceReq_isUsed:1;
	unsigned int PairingRes_isUsed:1;
	unsigned int WeldingDetectionRes_isUsed:1;
	unsigned int ConnectChargingDeviceRes_isUsed:1;
	unsigned int CertificateUpdateReq_isUsed:1;
	unsigned int CertificateUpdateRes_isUsed:1;
	unsigned int PaymentServiceSelectionReq_isUsed:1;
	unsigned int PowerDeliveryReq_isUsed:1;
	unsigned int PaymentServiceSelectionRes_isUsed:1;
	unsigned int PowerDeliveryRes_isUsed:1;
	unsigned int ChargingStatusReq_isUsed:1;
	unsigned int ChargingStatusRes_isUsed:1;
	unsigned int BodyElement_isUsed:1;
	unsigned int AC_BidirectionalControlReq_isUsed:1;
	unsigned int AC_BidirectionalControlRes_isUsed:1;
	unsigned int VehicleCheckInReq_isUsed:1;
	unsigned int CurrentDemandReq_isUsed:1;
	unsigned int VehicleCheckInRes_isUsed:1;
	unsigned int PreChargeReq_isUsed:1;
	unsigned int CurrentDemandRes_isUsed:1;
	unsigned int PreChargeRes_isUsed:1;
	unsigned int AlignmentCheckReq_isUsed:1;
	unsigned int V2GRequest_isUsed:1;
	unsigned int SessionStopReq_isUsed:1;
	unsigned int AuthorizationReq_isUsed:1;
	unsigned int AlignmentCheckRes_isUsed:1;
	unsigned int SessionStopRes_isUsed:1;
	unsigned int AuthorizationRes_isUsed:1;
	unsigned int VehicleCheckOutReq_isUsed:1;
	unsigned int ChargeParameterDiscoveryReq_isUsed:1;
	unsigned int VehicleCheckOutRes_isUsed:1;
	unsigned int ChargeParameterDiscoveryRes_isUsed:1;
	unsigned int V2GResponse_isUsed:1;
	unsigned int FinePositioningSetupReq_isUsed:1;
	unsigned int FinePositioningSetupRes_isUsed:1;
	unsigned int ServiceDetailReq_isUsed:1;
	unsigned int DC_BidirectionalControlReq_isUsed:1;
	unsigned int ServiceDetailRes_isUsed:1;
	unsigned int DC_BidirectionalControlRes_isUsed:1;
	unsigned int LFA_EVFinePositioningSetupParameters_isUsed:1;
	unsigned int MV_EVSEFinePositioningParameters_isUsed:1;
	unsigned int RelativeTimeInterval_isUsed:1;
	unsigned int SalesTariffEntry_isUsed:1;
	unsigned int LFA_EVSEFinePositioningSetupParameters_isUsed:1;
	unsigned int AC_EVChargeParameter_isUsed:1;
	unsigned int MV_EVSEFinePositioningSetupParameters_isUsed:1;
	unsigned int EVEnergyTransferParameter_isUsed:1;
	unsigned int DC_EVSEBidirectionalParameter_isUsed:1;
	unsigned int SAScheduleList_isUsed:1;
	unsigned int EVSEFinePositioningSetupParameters_isUsed:1;
	unsigned int Generic_EVSEFinePositioningParameters_isUsed:1;
	unsigned int DC_EVChargeParameter_isUsed:1;
	unsigned int DC_EVSEChargeParameter_isUsed:1;
	unsigned int LFA_EVFinePositioningParameters_isUsed:1;
	unsigned int EVFinePositioningSetupParameters_isUsed:1;
	unsigned int AC_EVSEBidirectionalParameter_isUsed:1;
	unsigned int EVFinePositioningParameters_isUsed:1;
	unsigned int WPT_EVChargeParameter_isUsed:1;
	unsigned int LFA_EVSEFinePositioningParameters_isUsed:1;
	unsigned int EVSEEnergyTransferParameter_isUsed:1;
	unsigned int AC_EVBidirectionalParameter_isUsed:1;
	unsigned int EVSEFinePositioningParameters_isUsed:1;
	unsigned int WPT_EVSEChargeParameter_isUsed:1;
	unsigned int AC_EVSEChargeParameter_isUsed:1;
	unsigned int PMaxScheduleEntry_isUsed:1;
	unsigned int Generic_EVFinePositioningParameters_isUsed:1;
	unsigned int DC_EVBidirectionalParameter_isUsed:1;
	unsigned int SignatureProperty_isUsed:1;
	unsigned int DSAKeyValue_isUsed:1;
	unsigned int SignatureProperties_isUsed:1;
	unsigned int KeyValue_isUsed:1;
	unsigned int Transforms_isUsed:1;
	unsigned int DigestMethod_isUsed:1;
	unsigned int Signature_isUsed:1;
	unsigned int RetrievalMethod_isUsed:1;
	unsigned int Manifest_isUsed:1;
	unsigned int Reference_isUsed:1;
	unsigned int CanonicalizationMethod_isUsed:1;
	unsigned int RSAKeyValue_isUsed:1;
	unsigned int Transform_isUsed:1;
	unsigned int PGPData_isUsed:1;
	unsigned int MgmtData_isUsed:1;
	unsigned int SignatureMethod_isUsed:1;
	unsigned int KeyInfo_isUsed:1;
	unsigned int SPKIData_isUsed:1;
	unsigned int X509Data_isUsed:1;
	unsigned int SignatureValue_isUsed:1;
	unsigned int KeyName_isUsed:1;
	unsigned int DigestValue_isUsed:1;
	unsigned int SignedInfo_isUsed:1;
	unsigned int Object_isUsed:1;


	int _warning_;
};


#if DEPLOY_ISO2_CODEC_FRAGMENT == SUPPORT_YES
/* Possible elements of EXI Fragment */
struct iso2EXIFragment {
#if SAVE_MEMORY_WITH_UNNAMED_UNION == UNION_YES
	union {
#endif /* SAVE_MEMORY_WITH_UNNAMED_UNION == UNION_YES */ 
	struct iso2PhysicalValueType EVMaximumVoltage ;
	uint32_t FrequencyChannel ;
	iso2EVSEProcessingType EVProcessing ;
	int BulkChargingComplete ;
	iso2parkingMethodType ParkingMethod ;
	uint8_t SAScheduleTupleID ;
	uint16_t Distance ;
	struct iso2ParameterSetType ParameterSet ;
	struct iso2PhysicalValueType EVMinimumDischargeCurrent ;
	uint8_t SignalSeparationTime ;
	struct iso2EVSEEnergyTransferParameterType EVSEEnergyTransferParameter ;
	struct iso2PhysicalValueType EVSEMaximumVoltage ;
	struct iso2DC_EVSEBidirectionalParameterType DC_EVSEBidirectionalParameter ;
	iso2chargingSessionType ChargingSession ;
	struct iso2SubCertificatesType SubCertificates ;
	struct iso2RetrievalMethodType RetrievalMethod ;
	struct iso2MagneticVectorSetupListType MagneticVectorSetupList ;
	struct iso2ParameterSetType PairingParameters ;
	struct iso2PhysicalValueType EVSEMinimumPower ;
	struct iso2AC_BidirectionalControlReqType AC_BidirectionalControlReq ;
	struct iso2CostType Cost ;
	struct iso2AC_BidirectionalControlResType AC_BidirectionalControlRes ;
	struct iso2SalesTariffType BuyBackTariff ;
	int16_t XCoordinate ;
	iso2EVCheckOutStatusType EVSECheckOutStatus ;
	struct {
		exi_string_character_t characters[EXIFragment_stringValue_CHARACTERS_SIZE];
		uint16_t charactersLen;
	}  stringValue ;
	int16_t RetryCounter ;
	struct iso2PhysicalValueType EVSEMaximumDischargeCurrent ;
	struct iso2SensorType Sensor ;
	uint64_t MeterReadingCharged ;
	int64_t HMACOutputLength ;
	struct iso2V2GResponseType V2GResponse ;
	struct iso2PhysicalValueType EVMinimumVoltage ;
	struct iso2PhysicalValueType EVMinimumEnergyRequest ;
	struct iso2RelativeTimeIntervalType RelativeTimeInterval ;
	struct iso2WPT_EVChargeParameterType WPT_EVChargeParameter ;
	struct iso2SAScheduleTupleType SAScheduleTuple ;
	uint16_t ServiceID ;
	struct {
		uint8_t bytes[EXIFragment_PgenCounter_BYTES_SIZE];
		uint16_t bytesLen;
	}  PgenCounter ;
	struct {
		exi_string_character_t characters[EXIFragment_SalesTariffDescription_CHARACTERS_SIZE];
		uint16_t charactersLen;
	}  SalesTariffDescription ;
	struct iso2PhysicalValueType AngleGAtoVA ;
	int boolValue ;
	struct iso2PhysicalValueType EVMaximumDischargeCurrent ;
	uint16_t NotificationMaxDelay ;
	struct iso2PhysicalValueType EVSEMaximumDischargePower ;
	struct iso2PGPDataType PGPData ;
	struct iso2PhysicalValueType EVSEMaximumChargePower ;
	struct {
		uint8_t bytes[EXIFragment_SessionID_BYTES_SIZE];
		uint16_t bytesLen;
	}  SessionID ;
	struct iso2PhysicalValueType EVSEEnergyToBeDelivered ;
	struct iso2PhysicalValueType EVMaximumPower ;
	struct iso2PhysicalValueType EVMaximumCurrent ;
	struct iso2RSAKeyValueType RSAKeyValue ;
	struct iso2PhysicalValueType EVSENominalVoltage ;
	struct iso2MagneticVectorType MagneticVector ;
	struct {
		exi_string_character_t characters[EXIFragment_XPath_CHARACTERS_SIZE];
		uint16_t charactersLen;
	}  XPath ;
	struct iso2SignatureType Signature ;
	iso2electricalChargingDeviceStatusType EVElectricalChargingDeviceStatus ;
	iso2EVSEProcessingType EVSEProcessing ;
	iso2FODStatusType FODStatus ;
	struct iso2PowerDeliveryResType PowerDeliveryRes ;
	struct iso2SessionStopResType SessionStopRes ;
	struct iso2WPT_EVSEChargeParameterType WPT_EVSEChargeParameter ;
	iso2responseCodeType ResponseCode ;
	struct iso2PhysicalValueType EVTargetEnergyRequest ;
	struct iso2FinePositioningSetupReqType FinePositioningSetupReq ;
	struct iso2PhysicalValueType EVSEPresentCurrent ;
	struct iso2FinePositioningSetupResType FinePositioningSetupRes ;
	struct iso2PMaxScheduleEntryType ProfileEntry ;
	struct {
		exi_string_character_t characters[EXIFragment_MgmtData_CHARACTERS_SIZE];
		uint16_t charactersLen;
	}  MgmtData ;
	struct iso2CertificateChainType SAProvisioningCertificateChain ;
	struct iso2PowerDeliveryReqType PowerDeliveryReq ;
	struct iso2SessionStopReqType SessionStopReq ;
	int ReceiptRequired ;
	struct iso2ChargingProfileType ChargingProfile ;
	uint16_t MaxSupportingPoints ;
	uint32_t start ;
	struct iso2PhysicalValueType EVMinimumChargePower ;
	struct iso2PhysicalValueType amount ;
	struct iso2PreChargeReqType PreChargeReq ;
	struct {
		uint8_t bytes[EXIFragment_OEMProvisioningCert_BYTES_SIZE];
		uint16_t bytesLen;
	}  OEMProvisioningCert ;
	uint32_t PackageIndex ;
	struct iso2PreChargeResType PreChargeRes ;
	struct {
		uint8_t bytes[EXIFragment_P_BYTES_SIZE];
		uint16_t bytesLen;
	}  P ;
	struct {
		uint8_t bytes[EXIFragment_Q_BYTES_SIZE];
		uint16_t bytesLen;
	}  Q ;
	struct {
		exi_string_character_t characters[EXIFragment_X509SubjectName_CHARACTERS_SIZE];
		uint16_t charactersLen;
	}  X509SubjectName ;
	struct {
		uint8_t bytes[EXIFragment_G_BYTES_SIZE];
		uint16_t bytesLen;
	}  G ;
	struct {
		uint8_t bytes[EXIFragment_J_BYTES_SIZE];
		uint16_t bytesLen;
	}  J ;
	struct iso2CertificateChainType ContractSignatureCertChain ;
	struct iso2MV_EVSEFinePositioningSetupParametersType MV_EVSEFinePositioningSetupParameters ;
	struct iso2PhysicalValueType EVSEMinimumDischargeCurrent ;
	struct iso2PhysicalValueType EVMaximumChargeCurrent ;
	uint16_t AlignmentOffset ;
	struct {
		uint8_t bytes[EXIFragment_Y_BYTES_SIZE];
		uint16_t bytesLen;
	}  Y ;
	int8_t RemainingTimeToTargetSOC ;
	struct {
		uint8_t bytes[EXIFragment_DigestValue_BYTES_SIZE];
		uint16_t bytesLen;
	}  DigestValue ;
	struct iso2SensorMeasurementsType SensorMeasurements ;
	struct iso2SalesTariffType SalesTariff ;
	struct {
		uint8_t bytes[EXIFragment_EVCCID_BYTES_SIZE];
		uint16_t bytesLen;
	}  EVCCID ;
	struct iso2PhysicalValueType EVSEMaximumPower ;
	struct iso2TargetPositionType TargetOffset ;
	struct iso2ParameterSetType PowerDemandParameters ;
	struct {
		uint8_t bytes[EXIFragment_PGPKeyID_BYTES_SIZE];
		uint16_t bytesLen;
	}  PGPKeyID ;
	struct iso2DisconnectChargingDeviceReqType DisconnectChargingDeviceReq ;
	struct iso2DisconnectChargingDeviceResType DisconnectChargingDeviceRes ;
	struct iso2DSAKeyValueType DSAKeyValue ;
	struct iso2SalesTariffEntryType SalesTariffEntry ;
	struct iso2CertificateInstallationResType CertificateInstallationRes ;
	struct iso2CanonicalizationMethodType CanonicalizationMethod ;
	struct iso2Generic_EVFinePositioningParametersType Generic_EVFinePositioningParameters ;
	struct iso2PhysicalValueType EVSEMinimumVoltage ;
	struct iso2SystemStatusResType SystemStatusRes ;
	struct iso2PhysicalValueType EVSEOutputPower ;
	struct iso2SignedInfoType SignedInfo ;
	struct iso2PhysicalValueType EVMinimumChargeCurrent ;
	iso2costKindType costKind ;
	struct iso2SystemStatusReqType SystemStatusReq ;
	struct iso2CableCheckReqType CableCheckReq ;
	uint8_t NumEPriceLevels ;
	int EVSEVoltageLimitAchieved ;
	uint8_t PackageSeparationTime ;
	struct iso2CableCheckResType CableCheckRes ;
	iso2EVCheckInStatusType EVCheckInStatus ;
	struct iso2PMaxScheduleType PMaxDischargeSchedule ;
	struct iso2PhysicalValueType EVMinimumPower ;
	struct iso2PhysicalValueType ChargingPerformance ;
	struct iso2AlignmentCheckReqType AlignmentCheckReq ;
	iso2mechanicalChargingDeviceStatusType EVMechanicalChargingDeviceStatus ;
	uint16_t VehicleSpace ;
	struct iso2AlignmentCheckResType AlignmentCheckRes ;
	struct iso2PhysicalValueType EVMinimumDischargePower ;
	int8_t RemainingTimeToMinimumSOC ;
	struct iso2AuthorizationResType AuthorizationRes ;
	struct iso2CertificateInstallationReqType CertificateInstallationReq ;
	struct iso2PaymentDetailsReqType PaymentDetailsReq ;
	struct iso2PaymentDetailsResType PaymentDetailsRes ;
	struct iso2AuthorizationReqType AuthorizationReq ;
	struct iso2PhysicalValueType EVTargetCurrent ;
	struct iso2SessionSetupReqType SessionSetupReq ;
	struct iso2SessionSetupResType SessionSetupRes ;
	struct iso2PhysicalValueType EVSENominalFrequency ;
	struct iso2MessageHeaderType Header ;
	uint8_t NumberOfSensors ;
	int64_t EVSETimeStamp ;
	int16_t MeterStatus ;
	struct iso2MV_EVSEFinePositioningParametersType MV_EVSEFinePositioningParameters ;
	iso2chargeProgressType ChargeProgress ;
	struct {
		exi_string_character_t characters[EXIFragment_KeyName_CHARACTERS_SIZE];
		uint16_t charactersLen;
	}  KeyName ;
	struct iso2PMaxScheduleType PMaxSchedule ;
	uint32_t duration ;
	int8_t RemainingTimeToBulkSOC ;
	struct iso2CartesianCoordinatesType SensorOrientation ;
	struct iso2PhysicalValueType EVSEMaximumChargeCurrent ;
	struct iso2LFA_EVSEFinePositioningParametersType LFA_EVSEFinePositioningParameters ;
	struct iso2VehicleCheckInResType VehicleCheckInRes ;
	struct iso2PMaxScheduleEntryType PMaxScheduleEntry ;
	struct iso2SAScheduleListType SAScheduleList ;
	struct {
		uint8_t bytes[EXIFragment_X509SKI_BYTES_SIZE];
		uint16_t bytesLen;
	}  X509SKI ;
	struct iso2PaymentOptionListType PaymentOptionList ;
	struct iso2ContractSignatureEncryptedPrivateKeyType ContractSignatureEncryptedPrivateKey ;
	struct iso2VehicleCheckInReqType VehicleCheckInReq ;
	struct {
		uint8_t bytes[EXIFragment_Certificate_BYTES_SIZE];
		uint16_t bytesLen;
	}  Certificate ;
	uint64_t CheckOutTime ;
	int8_t CurrentSOC ;
	int16_t ZCoordinate ;
	uint16_t MeasurementData ;
	struct iso2PairingResType PairingRes ;
	struct iso2PhysicalValueType EVSEMaximumCurrent ;
	struct iso2LFA_EVFinePositioningParametersType LFA_EVFinePositioningParameters ;
	struct iso2ParameterSetType AlignmentCheckParameters ;
	int8_t EffectiveRadiatedPower ;
	struct iso2PairingReqType PairingReq ;
	int16_t Value ;
	int8_t byteValue ;
	struct iso2CurrentDemandReqType CurrentDemandReq ;
	struct iso2Generic_EVSEFinePositioningParametersType Generic_EVSEFinePositioningParameters ;
	struct iso2CurrentDemandResType CurrentDemandRes ;
	struct iso2AC_EVBidirectionalParameterType AC_EVBidirectionalParameter ;
	struct {
		uint8_t bytes[EXIFragment_Modulus_BYTES_SIZE];
		uint16_t bytesLen;
	}  Modulus ;
	struct iso2SelectedServiceType SelectedEnergyTransferService ;
	struct iso2PhysicalValueType startValue ;
	struct iso2SelectedServiceListType SelectedVASList ;
	struct iso2ChargeParameterDiscoveryReqType ChargeParameterDiscoveryReq ;
	struct iso2ChargeParameterDiscoveryResType ChargeParameterDiscoveryRes ;
	struct {
		uint8_t bytes[EXIFragment_SigMeterReading_BYTES_SIZE];
		uint16_t bytesLen;
	}  SigMeterReading ;
	int8_t TargetSOC ;
	struct iso2EVSEStatusType EVSEStatus ;
	struct iso2PhysicalValueType EVSEMinimumChargeCurrent ;
	iso2electricalChargingDeviceStatusType EVSEElectricalChargingDeviceStatus ;
	int64_t X509SerialNumber ;
	iso2paymentOptionType PaymentOption ;
	struct iso2TransformsType Transforms ;
	struct iso2PhysicalValueType EVSEPeakCurrentRipple ;
	struct iso2ConsumptionCostType ConsumptionCost ;
	struct iso2EVSEFinePositioningSetupParametersType EVSEFinePositioningSetupParameters ;
	uint8_t EPriceLevel ;
	struct {
		uint8_t bytes[EXIFragment_Exponent_BYTES_SIZE];
		uint16_t bytesLen;
	}  Exponent ;
	struct iso2X509IssuerSerialType X509IssuerSerial ;
	struct iso2SPKIDataType SPKIData ;
	struct iso2MagneticVectorListType MagneticVectorList ;
	struct iso2EVSEFinePositioningParametersType EVSEFinePositioningParameters ;
	struct iso2PhysicalValueType EVTargetPower ;
	struct iso2SensorPackageListType SensorPackageList ;
	uint32_t DepartureTime ;
	int InletHot ;
	struct iso2PhysicalValueType EVPresentActivePower ;
	struct iso2X509DataType X509Data ;
	int16_t YCoordinate ;
	struct iso2KeyValueType KeyValue ;
	struct iso2DisplayParametersType DisplayParameters ;
	int EVSEPowerLimitAchieved ;
	struct iso2BodyType Body ;
	struct iso2DC_EVChargeParameterType DC_EVChargeParameter ;
	struct iso2ServiceType Service ;
	struct iso2SignaturePropertyType SignatureProperty ;
	struct {
		uint8_t bytes[EXIFragment_PGPKeyPacket_BYTES_SIZE];
		uint16_t bytesLen;
	}  PGPKeyPacket ;
	struct {
		uint8_t bytes[EXIFragment_Seed_BYTES_SIZE];
		uint16_t bytesLen;
	}  Seed ;
	struct iso2LFA_EVFinePositioningSetupParametersType LFA_EVFinePositioningSetupParameters ;
	struct iso2MinimumPMaxRequestType MinimumPMaxRequest ;
	struct iso2FinePositioningReqType FinePositioningReq ;
	struct iso2ServiceListType EnergyTransferServiceList ;
	struct iso2FinePositioningResType FinePositioningRes ;
	struct iso2AC_EVSEBidirectionalParameterType AC_EVSEBidirectionalParameter ;
	int FreeService ;
	struct iso2AC_EVSEChargeParameterType AC_EVSEChargeParameter ;
	uint8_t SensorID ;
	struct iso2PhysicalValueType EVSECurrentRegulationTolerance ;
	iso2mechanicalChargingDeviceStatusType EVSEMechanicalChargingDeviceStatus ;
	struct iso2EVEnergyTransferParameterType EVEnergyTransferParameter ;
	uint8_t SignalPulseDuration ;
	int16_t shortValue ;
	struct iso2ManifestType Manifest ;
	struct iso2DC_EVSEChargeParameterType DC_EVSEChargeParameter ;
	struct iso2MeteringReceiptReqType MeteringReceiptReq ;
	struct {
		exi_string_character_t characters[EXIFragment_MeterID_CHARACTERS_SIZE];
		uint16_t charactersLen;
	}  MeterID ;
	struct iso2MeteringReceiptResType MeteringReceiptRes ;
	struct iso2ServiceDiscoveryReqType ServiceDiscoveryReq ;
	uint8_t SalesTariffID ;
	struct iso2ServiceDiscoveryResType ServiceDiscoveryRes ;
	struct {
		uint8_t bytes[EXIFragment_X509CRL_BYTES_SIZE];
		uint16_t bytesLen;
	}  X509CRL ;
	struct iso2MagneticVectorSetupType MagneticVectorSetup ;
	struct iso2DigestMethodType DigestMethod ;
	struct {
		uint8_t bytes[EXIFragment_SPKISexp_BYTES_SIZE];
		uint16_t bytesLen;
	}  SPKISexp ;
	uint64_t MeterReadingDischarged ;
	struct iso2MeasurementDataListType MeasurementDataList ;
	struct iso2SignaturePropertiesType SignatureProperties ;
	struct iso2CartesianCoordinatesType SensorPosition ;
	struct iso2LFA_EVSEFinePositioningSetupParametersType LFA_EVSEFinePositioningSetupParameters ;
	struct iso2EMAIDType eMAID ;
	struct iso2SensorPackageType SensorPackage ;
	iso2EVCheckOutStatusType EVCheckOutStatus ;
	struct {
		uint8_t bytes[EXIFragment_X509Certificate_BYTES_SIZE];
		uint16_t bytesLen;
	}  X509Certificate ;
	struct iso2X509IssuerSerialType RootCertificateID ;
	struct iso2DC_BidirectionalControlReqType DC_BidirectionalControlReq ;
	struct iso2PhysicalValueType EVSEPresentVoltage ;
	struct iso2DC_BidirectionalControlResType DC_BidirectionalControlRes ;
	struct iso2ServiceListType VASList ;
	struct iso2MeterInfoType MeterInfo ;
	struct iso2PhysicalValueType EVSETargetReactivePower ;
	struct iso2ChargingStatusReqType ChargingStatusReq ;
	struct iso2ParameterSetType GenericParameters ;
	struct iso2ChargingStatusResType ChargingStatusRes ;
	struct iso2PhysicalValueType EVMaximumChargePower ;
	int8_t BulkSOC ;
	uint8_t NumberOfSignalPackages ;
	uint16_t ParameterSetID ;
	struct iso2PhysicalValueType PMax ;
	struct iso2PhysicalValueType EVMaximumEnergyRequest ;
	iso2EVOperationType EVOperation ;
	struct iso2CertificateUpdateResType CertificateUpdateRes ;
	int ChargingComplete ;
	struct iso2ListOfRootCertificateIDsType ListOfRootCertificateIDs ;
	struct iso2PhysicalValueType RotationVAtoGA ;
	struct iso2PhysicalValueType EVTargetVoltage ;
	struct iso2CertificateUpdateReqType CertificateUpdateReq ;
	struct iso2ConnectChargingDeviceResType ConnectChargingDeviceRes ;
	struct iso2DiffieHellmanPublickeyType DHpublickey ;
	struct iso2ServiceParameterListType ServiceParameterList ;
	struct iso2SignatureValueType SignatureValue ;
	struct iso2PhysicalValueType physicalValue ;
	iso2operationModeType OperationMode ;
	int EVSECurrentLimitAchieved ;
	struct iso2ServiceDetailReqType ServiceDetailReq ;
	struct iso2ServiceDetailResType ServiceDetailRes ;
	int32_t intValue ;
	struct iso2PhysicalValueType EVMaximumDischargePower ;
	int8_t MinimumSOC ;
	iso2paymentOptionType SelectedPaymentOption ;
	struct iso2AnonType_V2G_Message V2G_Message ;
	struct {
		exi_string_character_t characters[EXIFragment_EVSEID_CHARACTERS_SIZE];
		uint16_t charactersLen;
	}  EVSEID ;
	int64_t TMeter ;
	struct iso2SensorOrderListType SensorOrder ;
	struct iso2ServiceIDListType SupportedServiceIDs ;
	struct {
		uint8_t bytes[EXIFragment_GenChallenge_BYTES_SIZE];
		uint16_t bytesLen;
	}  GenChallenge ;
	struct iso2EVFinePositioningParametersType EVFinePositioningParameters ;
	struct iso2SensorListType SensorList ;
	struct iso2KeyInfoType KeyInfo ;
	struct iso2ConnectChargingDeviceReqType ConnectChargingDeviceReq ;
	struct iso2AC_EVChargeParameterType AC_EVChargeParameter ;
	struct iso2ParameterType Parameter ;
	struct iso2WeldingDetectionResType WeldingDetectionRes ;
	struct {
		exi_string_character_t characters[EXIFragment_GAID_CHARACTERS_SIZE];
		uint16_t charactersLen;
	}  GAID ;
	uint16_t SignalFrequency ;
	struct iso2PhysicalValueType EVSETargetPower ;
	struct iso2DC_EVBidirectionalParameterType DC_EVBidirectionalParameter ;
	struct iso2SignatureMethodType SignatureMethod ;
	struct iso2WeldingDetectionReqType WeldingDetectionReq ;
	struct iso2SelectedServiceType SelectedService ;
	struct iso2PhysicalValueType EVInputPower ;
	struct iso2VehicleCheckOutReqType VehicleCheckOutReq ;
	struct iso2PowerDemandReqType PowerDemandReq ;
	struct iso2VehicleCheckOutResType VehicleCheckOutRes ;
	uint16_t CurrentRange ;
	struct iso2PhysicalValueType EVPresentReactivePower ;
	struct {
		exi_string_character_t characters[EXIFragment_X509IssuerName_CHARACTERS_SIZE];
		uint16_t charactersLen;
	}  X509IssuerName ;
	struct iso2BodyBaseType V2GRequest ;
	struct iso2ReferenceType Reference ;
	struct iso2BodyBaseType BodyElement ;
	struct iso2PMaxScheduleEntryType MinimumPMaxScheduleEntry ;
	struct iso2EVFinePositioningSetupParametersType EVFinePositioningSetupParameters ;
	iso2EVSENotificationType EVSENotification ;
	struct iso2PaymentServiceSelectionReqType PaymentServiceSelectionReq ;
	struct iso2PaymentServiceSelectionResType PaymentServiceSelectionRes ;
	struct iso2TransformType Transform ;
	struct iso2ObjectType Object ;
	uint16_t TargetOffsetY ;
	struct iso2PowerDemandResType PowerDemandRes ;
	uint16_t TargetOffsetX ;
#if SAVE_MEMORY_WITH_UNNAMED_UNION == UNION_YES
	};
#endif /* SAVE_MEMORY_WITH_UNNAMED_UNION == UNION_YES */ 
	unsigned int EVMaximumVoltage_isUsed:1;
	unsigned int FrequencyChannel_isUsed:1;
	unsigned int EVProcessing_isUsed:1;
	unsigned int BulkChargingComplete_isUsed:1;
	unsigned int ParkingMethod_isUsed:1;
	unsigned int SAScheduleTupleID_isUsed:1;
	unsigned int Distance_isUsed:1;
	unsigned int ParameterSet_isUsed:1;
	unsigned int EVMinimumDischargeCurrent_isUsed:1;
	unsigned int SignalSeparationTime_isUsed:1;
	unsigned int EVSEEnergyTransferParameter_isUsed:1;
	unsigned int EVSEMaximumVoltage_isUsed:1;
	unsigned int DC_EVSEBidirectionalParameter_isUsed:1;
	unsigned int ChargingSession_isUsed:1;
	unsigned int SubCertificates_isUsed:1;
	unsigned int RetrievalMethod_isUsed:1;
	unsigned int MagneticVectorSetupList_isUsed:1;
	unsigned int PairingParameters_isUsed:1;
	unsigned int EVSEMinimumPower_isUsed:1;
	unsigned int AC_BidirectionalControlReq_isUsed:1;
	unsigned int Cost_isUsed:1;
	unsigned int AC_BidirectionalControlRes_isUsed:1;
	unsigned int BuyBackTariff_isUsed:1;
	unsigned int XCoordinate_isUsed:1;
	unsigned int EVSECheckOutStatus_isUsed:1;
	unsigned int stringValue_isUsed:1;
	unsigned int RetryCounter_isUsed:1;
	unsigned int EVSEMaximumDischargeCurrent_isUsed:1;
	unsigned int Sensor_isUsed:1;
	unsigned int MeterReadingCharged_isUsed:1;
	unsigned int HMACOutputLength_isUsed:1;
	unsigned int V2GResponse_isUsed:1;
	unsigned int EVMinimumVoltage_isUsed:1;
	unsigned int EVMinimumEnergyRequest_isUsed:1;
	unsigned int RelativeTimeInterval_isUsed:1;
	unsigned int WPT_EVChargeParameter_isUsed:1;
	unsigned int SAScheduleTuple_isUsed:1;
	unsigned int ServiceID_isUsed:1;
	unsigned int PgenCounter_isUsed:1;
	unsigned int SalesTariffDescription_isUsed:1;
	unsigned int AngleGAtoVA_isUsed:1;
	unsigned int boolValue_isUsed:1;
	unsigned int EVMaximumDischargeCurrent_isUsed:1;
	unsigned int NotificationMaxDelay_isUsed:1;
	unsigned int EVSEMaximumDischargePower_isUsed:1;
	unsigned int PGPData_isUsed:1;
	unsigned int EVSEMaximumChargePower_isUsed:1;
	unsigned int SessionID_isUsed:1;
	unsigned int EVSEEnergyToBeDelivered_isUsed:1;
	unsigned int EVMaximumPower_isUsed:1;
	unsigned int EVMaximumCurrent_isUsed:1;
	unsigned int RSAKeyValue_isUsed:1;
	unsigned int EVSENominalVoltage_isUsed:1;
	unsigned int MagneticVector_isUsed:1;
	unsigned int XPath_isUsed:1;
	unsigned int Signature_isUsed:1;
	unsigned int EVElectricalChargingDeviceStatus_isUsed:1;
	unsigned int EVSEProcessing_isUsed:1;
	unsigned int FODStatus_isUsed:1;
	unsigned int PowerDeliveryRes_isUsed:1;
	unsigned int SessionStopRes_isUsed:1;
	unsigned int WPT_EVSEChargeParameter_isUsed:1;
	unsigned int ResponseCode_isUsed:1;
	unsigned int EVTargetEnergyRequest_isUsed:1;
	unsigned int FinePositioningSetupReq_isUsed:1;
	unsigned int EVSEPresentCurrent_isUsed:1;
	unsigned int FinePositioningSetupRes_isUsed:1;
	unsigned int ProfileEntry_isUsed:1;
	unsigned int MgmtData_isUsed:1;
	unsigned int SAProvisioningCertificateChain_isUsed:1;
	unsigned int PowerDeliveryReq_isUsed:1;
	unsigned int SessionStopReq_isUsed:1;
	unsigned int ReceiptRequired_isUsed:1;
	unsigned int ChargingProfile_isUsed:1;
	unsigned int MaxSupportingPoints_isUsed:1;
	unsigned int start_isUsed:1;
	unsigned int EVMinimumChargePower_isUsed:1;
	unsigned int amount_isUsed:1;
	unsigned int PreChargeReq_isUsed:1;
	unsigned int OEMProvisioningCert_isUsed:1;
	unsigned int PackageIndex_isUsed:1;
	unsigned int PreChargeRes_isUsed:1;
	unsigned int P_isUsed:1;
	unsigned int Q_isUsed:1;
	unsigned int X509SubjectName_isUsed:1;
	unsigned int G_isUsed:1;
	unsigned int J_isUsed:1;
	unsigned int ContractSignatureCertChain_isUsed:1;
	unsigned int MV_EVSEFinePositioningSetupParameters_isUsed:1;
	unsigned int EVSEMinimumDischargeCurrent_isUsed:1;
	unsigned int EVMaximumChargeCurrent_isUsed:1;
	unsigned int AlignmentOffset_isUsed:1;
	unsigned int Y_isUsed:1;
	unsigned int RemainingTimeToTargetSOC_isUsed:1;
	unsigned int DigestValue_isUsed:1;
	unsigned int SensorMeasurements_isUsed:1;
	unsigned int SalesTariff_isUsed:1;
	unsigned int EVCCID_isUsed:1;
	unsigned int EVSEMaximumPower_isUsed:1;
	unsigned int TargetOffset_isUsed:1;
	unsigned int PowerDemandParameters_isUsed:1;
	unsigned int PGPKeyID_isUsed:1;
	unsigned int DisconnectChargingDeviceReq_isUsed:1;
	unsigned int DisconnectChargingDeviceRes_isUsed:1;
	unsigned int DSAKeyValue_isUsed:1;
	unsigned int SalesTariffEntry_isUsed:1;
	unsigned int CertificateInstallationRes_isUsed:1;
	unsigned int CanonicalizationMethod_isUsed:1;
	unsigned int Generic_EVFinePositioningParameters_isUsed:1;
	unsigned int EVSEMinimumVoltage_isUsed:1;
	unsigned int SystemStatusRes_isUsed:1;
	unsigned int EVSEOutputPower_isUsed:1;
	unsigned int SignedInfo_isUsed:1;
	unsigned int EVMinimumChargeCurrent_isUsed:1;
	unsigned int costKind_isUsed:1;
	unsigned int SystemStatusReq_isUsed:1;
	unsigned int CableCheckReq_isUsed:1;
	unsigned int NumEPriceLevels_isUsed:1;
	unsigned int EVSEVoltageLimitAchieved_isUsed:1;
	unsigned int PackageSeparationTime_isUsed:1;
	unsigned int CableCheckRes_isUsed:1;
	unsigned int EVCheckInStatus_isUsed:1;
	unsigned int PMaxDischargeSchedule_isUsed:1;
	unsigned int EVMinimumPower_isUsed:1;
	unsigned int ChargingPerformance_isUsed:1;
	unsigned int AlignmentCheckReq_isUsed:1;
	unsigned int EVMechanicalChargingDeviceStatus_isUsed:1;
	unsigned int VehicleSpace_isUsed:1;
	unsigned int AlignmentCheckRes_isUsed:1;
	unsigned int EVMinimumDischargePower_isUsed:1;
	unsigned int RemainingTimeToMinimumSOC_isUsed:1;
	unsigned int AuthorizationRes_isUsed:1;
	unsigned int CertificateInstallationReq_isUsed:1;
	unsigned int PaymentDetailsReq_isUsed:1;
	unsigned int PaymentDetailsRes_isUsed:1;
	unsigned int AuthorizationReq_isUsed:1;
	unsigned int EVTargetCurrent_isUsed:1;
	unsigned int SessionSetupReq_isUsed:1;
	unsigned int SessionSetupRes_isUsed:1;
	unsigned int EVSENominalFrequency_isUsed:1;
	unsigned int Header_isUsed:1;
	unsigned int NumberOfSensors_isUsed:1;
	unsigned int EVSETimeStamp_isUsed:1;
	unsigned int MeterStatus_isUsed:1;
	unsigned int MV_EVSEFinePositioningParameters_isUsed:1;
	unsigned int ChargeProgress_isUsed:1;
	unsigned int KeyName_isUsed:1;
	unsigned int PMaxSchedule_isUsed:1;
	unsigned int duration_isUsed:1;
	unsigned int RemainingTimeToBulkSOC_isUsed:1;
	unsigned int SensorOrientation_isUsed:1;
	unsigned int EVSEMaximumChargeCurrent_isUsed:1;
	unsigned int LFA_EVSEFinePositioningParameters_isUsed:1;
	unsigned int VehicleCheckInRes_isUsed:1;
	unsigned int PMaxScheduleEntry_isUsed:1;
	unsigned int SAScheduleList_isUsed:1;
	unsigned int X509SKI_isUsed:1;
	unsigned int PaymentOptionList_isUsed:1;
	unsigned int ContractSignatureEncryptedPrivateKey_isUsed:1;
	unsigned int VehicleCheckInReq_isUsed:1;
	unsigned int Certificate_isUsed:1;
	unsigned int CheckOutTime_isUsed:1;
	unsigned int CurrentSOC_isUsed:1;
	unsigned int ZCoordinate_isUsed:1;
	unsigned int MeasurementData_isUsed:1;
	unsigned int PairingRes_isUsed:1;
	unsigned int EVSEMaximumCurrent_isUsed:1;
	unsigned int LFA_EVFinePositioningParameters_isUsed:1;
	unsigned int AlignmentCheckParameters_isUsed:1;
	unsigned int EffectiveRadiatedPower_isUsed:1;
	unsigned int PairingReq_isUsed:1;
	unsigned int Value_isUsed:1;
	unsigned int byteValue_isUsed:1;
	unsigned int CurrentDemandReq_isUsed:1;
	unsigned int Generic_EVSEFinePositioningParameters_isUsed:1;
	unsigned int CurrentDemandRes_isUsed:1;
	unsigned int AC_EVBidirectionalParameter_isUsed:1;
	unsigned int Modulus_isUsed:1;
	unsigned int SelectedEnergyTransferService_isUsed:1;
	unsigned int startValue_isUsed:1;
	unsigned int SelectedVASList_isUsed:1;
	unsigned int ChargeParameterDiscoveryReq_isUsed:1;
	unsigned int ChargeParameterDiscoveryRes_isUsed:1;
	unsigned int SigMeterReading_isUsed:1;
	unsigned int TargetSOC_isUsed:1;
	unsigned int EVSEStatus_isUsed:1;
	unsigned int EVSEMinimumChargeCurrent_isUsed:1;
	unsigned int EVSEElectricalChargingDeviceStatus_isUsed:1;
	unsigned int X509SerialNumber_isUsed:1;
	unsigned int PaymentOption_isUsed:1;
	unsigned int Transforms_isUsed:1;
	unsigned int EVSEPeakCurrentRipple_isUsed:1;
	unsigned int ConsumptionCost_isUsed:1;
	unsigned int EVSEFinePositioningSetupParameters_isUsed:1;
	unsigned int EPriceLevel_isUsed:1;
	unsigned int Exponent_isUsed:1;
	unsigned int X509IssuerSerial_isUsed:1;
	unsigned int SPKIData_isUsed:1;
	unsigned int MagneticVectorList_isUsed:1;
	unsigned int EVSEFinePositioningParameters_isUsed:1;
	unsigned int EVTargetPower_isUsed:1;
	unsigned int SensorPackageList_isUsed:1;
	unsigned int DepartureTime_isUsed:1;
	unsigned int InletHot_isUsed:1;
	unsigned int EVPresentActivePower_isUsed:1;
	unsigned int X509Data_isUsed:1;
	unsigned int YCoordinate_isUsed:1;
	unsigned int KeyValue_isUsed:1;
	unsigned int DisplayParameters_isUsed:1;
	unsigned int EVSEPowerLimitAchieved_isUsed:1;
	unsigned int Body_isUsed:1;
	unsigned int DC_EVChargeParameter_isUsed:1;
	unsigned int Service_isUsed:1;
	unsigned int SignatureProperty_isUsed:1;
	unsigned int PGPKeyPacket_isUsed:1;
	unsigned int Seed_isUsed:1;
	unsigned int LFA_EVFinePositioningSetupParameters_isUsed:1;
	unsigned int MinimumPMaxRequest_isUsed:1;
	unsigned int FinePositioningReq_isUsed:1;
	unsigned int EnergyTransferServiceList_isUsed:1;
	unsigned int FinePositioningRes_isUsed:1;
	unsigned int AC_EVSEBidirectionalParameter_isUsed:1;
	unsigned int FreeService_isUsed:1;
	unsigned int AC_EVSEChargeParameter_isUsed:1;
	unsigned int SensorID_isUsed:1;
	unsigned int EVSECurrentRegulationTolerance_isUsed:1;
	unsigned int EVSEMechanicalChargingDeviceStatus_isUsed:1;
	unsigned int EVEnergyTransferParameter_isUsed:1;
	unsigned int SignalPulseDuration_isUsed:1;
	unsigned int shortValue_isUsed:1;
	unsigned int Manifest_isUsed:1;
	unsigned int DC_EVSEChargeParameter_isUsed:1;
	unsigned int MeteringReceiptReq_isUsed:1;
	unsigned int MeterID_isUsed:1;
	unsigned int MeteringReceiptRes_isUsed:1;
	unsigned int ServiceDiscoveryReq_isUsed:1;
	unsigned int SalesTariffID_isUsed:1;
	unsigned int ServiceDiscoveryRes_isUsed:1;
	unsigned int X509CRL_isUsed:1;
	unsigned int MagneticVectorSetup_isUsed:1;
	unsigned int DigestMethod_isUsed:1;
	unsigned int SPKISexp_isUsed:1;
	unsigned int MeterReadingDischarged_isUsed:1;
	unsigned int MeasurementDataList_isUsed:1;
	unsigned int SignatureProperties_isUsed:1;
	unsigned int SensorPosition_isUsed:1;
	unsigned int LFA_EVSEFinePositioningSetupParameters_isUsed:1;
	unsigned int eMAID_isUsed:1;
	unsigned int SensorPackage_isUsed:1;
	unsigned int EVCheckOutStatus_isUsed:1;
	unsigned int X509Certificate_isUsed:1;
	unsigned int RootCertificateID_isUsed:1;
	unsigned int DC_BidirectionalControlReq_isUsed:1;
	unsigned int EVSEPresentVoltage_isUsed:1;
	unsigned int DC_BidirectionalControlRes_isUsed:1;
	unsigned int VASList_isUsed:1;
	unsigned int MeterInfo_isUsed:1;
	unsigned int EVSETargetReactivePower_isUsed:1;
	unsigned int ChargingStatusReq_isUsed:1;
	unsigned int GenericParameters_isUsed:1;
	unsigned int ChargingStatusRes_isUsed:1;
	unsigned int EVMaximumChargePower_isUsed:1;
	unsigned int BulkSOC_isUsed:1;
	unsigned int NumberOfSignalPackages_isUsed:1;
	unsigned int ParameterSetID_isUsed:1;
	unsigned int PMax_isUsed:1;
	unsigned int EVMaximumEnergyRequest_isUsed:1;
	unsigned int EVOperation_isUsed:1;
	unsigned int CertificateUpdateRes_isUsed:1;
	unsigned int ChargingComplete_isUsed:1;
	unsigned int ListOfRootCertificateIDs_isUsed:1;
	unsigned int RotationVAtoGA_isUsed:1;
	unsigned int EVTargetVoltage_isUsed:1;
	unsigned int CertificateUpdateReq_isUsed:1;
	unsigned int ConnectChargingDeviceRes_isUsed:1;
	unsigned int DHpublickey_isUsed:1;
	unsigned int ServiceParameterList_isUsed:1;
	unsigned int SignatureValue_isUsed:1;
	unsigned int physicalValue_isUsed:1;
	unsigned int OperationMode_isUsed:1;
	unsigned int EVSECurrentLimitAchieved_isUsed:1;
	unsigned int ServiceDetailReq_isUsed:1;
	unsigned int ServiceDetailRes_isUsed:1;
	unsigned int intValue_isUsed:1;
	unsigned int EVMaximumDischargePower_isUsed:1;
	unsigned int MinimumSOC_isUsed:1;
	unsigned int SelectedPaymentOption_isUsed:1;
	unsigned int V2G_Message_isUsed:1;
	unsigned int EVSEID_isUsed:1;
	unsigned int TMeter_isUsed:1;
	unsigned int SensorOrder_isUsed:1;
	unsigned int SupportedServiceIDs_isUsed:1;
	unsigned int GenChallenge_isUsed:1;
	unsigned int EVFinePositioningParameters_isUsed:1;
	unsigned int SensorList_isUsed:1;
	unsigned int KeyInfo_isUsed:1;
	unsigned int ConnectChargingDeviceReq_isUsed:1;
	unsigned int AC_EVChargeParameter_isUsed:1;
	unsigned int Parameter_isUsed:1;
	unsigned int WeldingDetectionRes_isUsed:1;
	unsigned int GAID_isUsed:1;
	unsigned int SignalFrequency_isUsed:1;
	unsigned int EVSETargetPower_isUsed:1;
	unsigned int DC_EVBidirectionalParameter_isUsed:1;
	unsigned int SignatureMethod_isUsed:1;
	unsigned int WeldingDetectionReq_isUsed:1;
	unsigned int SelectedService_isUsed:1;
	unsigned int EVInputPower_isUsed:1;
	unsigned int VehicleCheckOutReq_isUsed:1;
	unsigned int PowerDemandReq_isUsed:1;
	unsigned int VehicleCheckOutRes_isUsed:1;
	unsigned int CurrentRange_isUsed:1;
	unsigned int EVPresentReactivePower_isUsed:1;
	unsigned int X509IssuerName_isUsed:1;
	unsigned int V2GRequest_isUsed:1;
	unsigned int Reference_isUsed:1;
	unsigned int BodyElement_isUsed:1;
	unsigned int MinimumPMaxScheduleEntry_isUsed:1;
	unsigned int EVFinePositioningSetupParameters_isUsed:1;
	unsigned int EVSENotification_isUsed:1;
	unsigned int PaymentServiceSelectionReq_isUsed:1;
	unsigned int PaymentServiceSelectionRes_isUsed:1;
	unsigned int Transform_isUsed:1;
	unsigned int Object_isUsed:1;
	unsigned int TargetOffsetY_isUsed:1;
	unsigned int PowerDemandRes_isUsed:1;
	unsigned int TargetOffsetX_isUsed:1;


	int _warning_;
};
#endif /* DEPLOY_ISO2_CODEC_FRAGMENT */


/* Initialization methods for structs */

void init_iso2EXIDocument(struct iso2EXIDocument* exiDoc);
#if DEPLOY_ISO2_CODEC_FRAGMENT == SUPPORT_YES
void init_iso2EXIFragment(struct iso2EXIFragment* exiFrag);
#endif /* DEPLOY_ISO2_CODEC_FRAGMENT */
void init_iso2RetrievalMethodType(struct iso2RetrievalMethodType* iso2RetrievalMethodType);
void init_iso2AuthorizationResType(struct iso2AuthorizationResType* iso2AuthorizationResType);
void init_iso2MV_EVSEFinePositioningSetupParametersType(struct iso2MV_EVSEFinePositioningSetupParametersType* iso2MV_EVSEFinePositioningSetupParametersType);
void init_iso2X509DataType(struct iso2X509DataType* iso2X509DataType);
void init_iso2RSAKeyValueType(struct iso2RSAKeyValueType* iso2RSAKeyValueType);
void init_iso2DC_BidirectionalControlResType(struct iso2DC_BidirectionalControlResType* iso2DC_BidirectionalControlResType);
void init_iso2CostType(struct iso2CostType* iso2CostType);
void init_iso2ChargingStatusResType(struct iso2ChargingStatusResType* iso2ChargingStatusResType);
void init_iso2MeterInfoType(struct iso2MeterInfoType* iso2MeterInfoType);
void init_iso2AC_EVChargeParameterType(struct iso2AC_EVChargeParameterType* iso2AC_EVChargeParameterType);
void init_iso2AC_EVSEBidirectionalParameterType(struct iso2AC_EVSEBidirectionalParameterType* iso2AC_EVSEBidirectionalParameterType);
void init_iso2VehicleCheckOutResType(struct iso2VehicleCheckOutResType* iso2VehicleCheckOutResType);
void init_iso2MagneticVectorListType(struct iso2MagneticVectorListType* iso2MagneticVectorListType);
void init_iso2CableCheckResType(struct iso2CableCheckResType* iso2CableCheckResType);
void init_iso2ServiceDiscoveryReqType(struct iso2ServiceDiscoveryReqType* iso2ServiceDiscoveryReqType);
void init_iso2ServiceType(struct iso2ServiceType* iso2ServiceType);
void init_iso2ServiceParameterListType(struct iso2ServiceParameterListType* iso2ServiceParameterListType);
void init_iso2PMaxScheduleType(struct iso2PMaxScheduleType* iso2PMaxScheduleType);
void init_iso2SignaturePropertiesType(struct iso2SignaturePropertiesType* iso2SignaturePropertiesType);
void init_iso2PMaxScheduleEntryType(struct iso2PMaxScheduleEntryType* iso2PMaxScheduleEntryType);
void init_iso2SignatureType(struct iso2SignatureType* iso2SignatureType);
void init_iso2VehicleCheckInReqType(struct iso2VehicleCheckInReqType* iso2VehicleCheckInReqType);
void init_iso2ConnectChargingDeviceResType(struct iso2ConnectChargingDeviceResType* iso2ConnectChargingDeviceResType);
void init_iso2WeldingDetectionResType(struct iso2WeldingDetectionResType* iso2WeldingDetectionResType);
void init_iso2SessionStopResType(struct iso2SessionStopResType* iso2SessionStopResType);
void init_iso2VehicleCheckInResType(struct iso2VehicleCheckInResType* iso2VehicleCheckInResType);
void init_iso2ServiceListType(struct iso2ServiceListType* iso2ServiceListType);
void init_iso2CertificateUpdateResType(struct iso2CertificateUpdateResType* iso2CertificateUpdateResType);
void init_iso2FinePositioningSetupResType(struct iso2FinePositioningSetupResType* iso2FinePositioningSetupResType);
void init_iso2AC_EVBidirectionalParameterType(struct iso2AC_EVBidirectionalParameterType* iso2AC_EVBidirectionalParameterType);
void init_iso2DC_BidirectionalControlReqType(struct iso2DC_BidirectionalControlReqType* iso2DC_BidirectionalControlReqType);
void init_iso2CertificateUpdateReqType(struct iso2CertificateUpdateReqType* iso2CertificateUpdateReqType);
void init_iso2ConsumptionCostType(struct iso2ConsumptionCostType* iso2ConsumptionCostType);
void init_iso2SAScheduleListType(struct iso2SAScheduleListType* iso2SAScheduleListType);
void init_iso2MagneticVectorSetupType(struct iso2MagneticVectorSetupType* iso2MagneticVectorSetupType);
void init_iso2LFA_EVSEFinePositioningSetupParametersType(struct iso2LFA_EVSEFinePositioningSetupParametersType* iso2LFA_EVSEFinePositioningSetupParametersType);
void init_iso2PaymentOptionListType(struct iso2PaymentOptionListType* iso2PaymentOptionListType);
void init_iso2LFA_EVSEFinePositioningParametersType(struct iso2LFA_EVSEFinePositioningParametersType* iso2LFA_EVSEFinePositioningParametersType);
void init_iso2RelativeTimeIntervalType(struct iso2RelativeTimeIntervalType* iso2RelativeTimeIntervalType);
void init_iso2EVFinePositioningParametersType(struct iso2EVFinePositioningParametersType* iso2EVFinePositioningParametersType);
void init_iso2AlignmentCheckReqType(struct iso2AlignmentCheckReqType* iso2AlignmentCheckReqType);
void init_iso2CertificateInstallationReqType(struct iso2CertificateInstallationReqType* iso2CertificateInstallationReqType);
void init_iso2TransformsType(struct iso2TransformsType* iso2TransformsType);
void init_iso2ObjectType(struct iso2ObjectType* iso2ObjectType);
void init_iso2SensorOrderListType(struct iso2SensorOrderListType* iso2SensorOrderListType);
void init_iso2ChargeParameterDiscoveryReqType(struct iso2ChargeParameterDiscoveryReqType* iso2ChargeParameterDiscoveryReqType);
void init_iso2ParameterType(struct iso2ParameterType* iso2ParameterType);
void init_iso2SessionStopReqType(struct iso2SessionStopReqType* iso2SessionStopReqType);
void init_iso2SensorMeasurementsType(struct iso2SensorMeasurementsType* iso2SensorMeasurementsType);
void init_iso2DC_EVSEChargeParameterType(struct iso2DC_EVSEChargeParameterType* iso2DC_EVSEChargeParameterType);
void init_iso2SensorPackageListType(struct iso2SensorPackageListType* iso2SensorPackageListType);
void init_iso2MeasurementDataListType(struct iso2MeasurementDataListType* iso2MeasurementDataListType);
void init_iso2CertificateChainType(struct iso2CertificateChainType* iso2CertificateChainType);
void init_iso2SignaturePropertyType(struct iso2SignaturePropertyType* iso2SignaturePropertyType);
void init_iso2TransformType(struct iso2TransformType* iso2TransformType);
void init_iso2EMAIDType(struct iso2EMAIDType* iso2EMAIDType);
void init_iso2DSAKeyValueType(struct iso2DSAKeyValueType* iso2DSAKeyValueType);
void init_iso2EntryType(struct iso2EntryType* iso2EntryType);
void init_iso2MessageHeaderType(struct iso2MessageHeaderType* iso2MessageHeaderType);
void init_iso2WPT_EVChargeParameterType(struct iso2WPT_EVChargeParameterType* iso2WPT_EVChargeParameterType);
void init_iso2DisconnectChargingDeviceReqType(struct iso2DisconnectChargingDeviceReqType* iso2DisconnectChargingDeviceReqType);
void init_iso2ChargeLoopReqType(struct iso2ChargeLoopReqType* iso2ChargeLoopReqType);
void init_iso2V2GRequestType(struct iso2V2GRequestType* iso2V2GRequestType);
void init_iso2MeteringReceiptResType(struct iso2MeteringReceiptResType* iso2MeteringReceiptResType);
void init_iso2SessionSetupResType(struct iso2SessionSetupResType* iso2SessionSetupResType);
void init_iso2AC_BidirectionalControlReqType(struct iso2AC_BidirectionalControlReqType* iso2AC_BidirectionalControlReqType);
void init_iso2MV_EVSEFinePositioningParametersType(struct iso2MV_EVSEFinePositioningParametersType* iso2MV_EVSEFinePositioningParametersType);
void init_iso2ReferenceType(struct iso2ReferenceType* iso2ReferenceType);
void init_iso2EVSEEnergyTransferParameterType(struct iso2EVSEEnergyTransferParameterType* iso2EVSEEnergyTransferParameterType);
void init_iso2MeteringReceiptReqType(struct iso2MeteringReceiptReqType* iso2MeteringReceiptReqType);
void init_iso2KeyValueType(struct iso2KeyValueType* iso2KeyValueType);
void init_iso2SensorListType(struct iso2SensorListType* iso2SensorListType);
void init_iso2CurrentDemandReqType(struct iso2CurrentDemandReqType* iso2CurrentDemandReqType);
void init_iso2FinePositioningSetupReqType(struct iso2FinePositioningSetupReqType* iso2FinePositioningSetupReqType);
void init_iso2LFA_EVFinePositioningSetupParametersType(struct iso2LFA_EVFinePositioningSetupParametersType* iso2LFA_EVFinePositioningSetupParametersType);
void init_iso2SAScheduleTupleType(struct iso2SAScheduleTupleType* iso2SAScheduleTupleType);
void init_iso2WPT_EVSEChargeParameterType(struct iso2WPT_EVSEChargeParameterType* iso2WPT_EVSEChargeParameterType);
void init_iso2FinePositioningResType(struct iso2FinePositioningResType* iso2FinePositioningResType);
void init_iso2BodyBaseType(struct iso2BodyBaseType* iso2BodyBaseType);
void init_iso2ServiceDetailResType(struct iso2ServiceDetailResType* iso2ServiceDetailResType);
void init_iso2PowerDeliveryReqType(struct iso2PowerDeliveryReqType* iso2PowerDeliveryReqType);
void init_iso2PairingResType(struct iso2PairingResType* iso2PairingResType);
void init_iso2AuthorizationReqType(struct iso2AuthorizationReqType* iso2AuthorizationReqType);
void init_iso2ParameterSetType(struct iso2ParameterSetType* iso2ParameterSetType);
void init_iso2SPKIDataType(struct iso2SPKIDataType* iso2SPKIDataType);
void init_iso2PaymentDetailsResType(struct iso2PaymentDetailsResType* iso2PaymentDetailsResType);
void init_iso2SignatureMethodType(struct iso2SignatureMethodType* iso2SignatureMethodType);
void init_iso2AC_BidirectionalControlResType(struct iso2AC_BidirectionalControlResType* iso2AC_BidirectionalControlResType);
void init_iso2VehicleCheckOutReqType(struct iso2VehicleCheckOutReqType* iso2VehicleCheckOutReqType);
void init_iso2WeldingDetectionReqType(struct iso2WeldingDetectionReqType* iso2WeldingDetectionReqType);
void init_iso2AlignmentCheckResType(struct iso2AlignmentCheckResType* iso2AlignmentCheckResType);
void init_iso2PowerDemandReqType(struct iso2PowerDemandReqType* iso2PowerDemandReqType);
void init_iso2MinimumPMaxRequestType(struct iso2MinimumPMaxRequestType* iso2MinimumPMaxRequestType);
void init_iso2DisconnectChargingDeviceResType(struct iso2DisconnectChargingDeviceResType* iso2DisconnectChargingDeviceResType);
void init_iso2SessionSetupReqType(struct iso2SessionSetupReqType* iso2SessionSetupReqType);
void init_iso2PaymentDetailsReqType(struct iso2PaymentDetailsReqType* iso2PaymentDetailsReqType);
void init_iso2Generic_EVFinePositioningParametersType(struct iso2Generic_EVFinePositioningParametersType* iso2Generic_EVFinePositioningParametersType);
void init_iso2ConnectChargingDeviceReqType(struct iso2ConnectChargingDeviceReqType* iso2ConnectChargingDeviceReqType);
void init_iso2AC_EVSEChargeParameterType(struct iso2AC_EVSEChargeParameterType* iso2AC_EVSEChargeParameterType);
void init_iso2SalesTariffEntryType(struct iso2SalesTariffEntryType* iso2SalesTariffEntryType);
void init_iso2DC_EVSEBidirectionalParameterType(struct iso2DC_EVSEBidirectionalParameterType* iso2DC_EVSEBidirectionalParameterType);
void init_iso2CanonicalizationMethodType(struct iso2CanonicalizationMethodType* iso2CanonicalizationMethodType);
void init_iso2DisplayParametersType(struct iso2DisplayParametersType* iso2DisplayParametersType);
void init_iso2DC_EVBidirectionalParameterType(struct iso2DC_EVBidirectionalParameterType* iso2DC_EVBidirectionalParameterType);
void init_iso2PaymentServiceSelectionReqType(struct iso2PaymentServiceSelectionReqType* iso2PaymentServiceSelectionReqType);
void init_iso2MagneticVectorType(struct iso2MagneticVectorType* iso2MagneticVectorType);
void init_iso2PhysicalValueType(struct iso2PhysicalValueType* iso2PhysicalValueType);
void init_iso2SystemStatusReqType(struct iso2SystemStatusReqType* iso2SystemStatusReqType);
void init_iso2SystemStatusResType(struct iso2SystemStatusResType* iso2SystemStatusResType);
void init_iso2EVSEFinePositioningSetupParametersType(struct iso2EVSEFinePositioningSetupParametersType* iso2EVSEFinePositioningSetupParametersType);
void init_iso2V2GResponseType(struct iso2V2GResponseType* iso2V2GResponseType);
void init_iso2BodyType(struct iso2BodyType* iso2BodyType);
void init_iso2PreChargeResType(struct iso2PreChargeResType* iso2PreChargeResType);
void init_iso2EVSEFinePositioningParametersType(struct iso2EVSEFinePositioningParametersType* iso2EVSEFinePositioningParametersType);
void init_iso2PaymentServiceSelectionResType(struct iso2PaymentServiceSelectionResType* iso2PaymentServiceSelectionResType);
void init_iso2DigestMethodType(struct iso2DigestMethodType* iso2DigestMethodType);
void init_iso2TargetPositionType(struct iso2TargetPositionType* iso2TargetPositionType);
void init_iso2LFA_EVFinePositioningParametersType(struct iso2LFA_EVFinePositioningParametersType* iso2LFA_EVFinePositioningParametersType);
void init_iso2DC_EVChargeParameterType(struct iso2DC_EVChargeParameterType* iso2DC_EVChargeParameterType);
void init_iso2ServiceDetailReqType(struct iso2ServiceDetailReqType* iso2ServiceDetailReqType);
void init_iso2PreChargeReqType(struct iso2PreChargeReqType* iso2PreChargeReqType);
void init_iso2ManifestType(struct iso2ManifestType* iso2ManifestType);
void init_iso2AnonType_V2G_Message(struct iso2AnonType_V2G_Message* iso2AnonType_V2G_Message);
void init_iso2SelectedServiceListType(struct iso2SelectedServiceListType* iso2SelectedServiceListType);
void init_iso2Generic_EVSEFinePositioningParametersType(struct iso2Generic_EVSEFinePositioningParametersType* iso2Generic_EVSEFinePositioningParametersType);
void init_iso2CartesianCoordinatesType(struct iso2CartesianCoordinatesType* iso2CartesianCoordinatesType);
void init_iso2KeyInfoType(struct iso2KeyInfoType* iso2KeyInfoType);
void init_iso2SubCertificatesType(struct iso2SubCertificatesType* iso2SubCertificatesType);
void init_iso2ListOfRootCertificateIDsType(struct iso2ListOfRootCertificateIDsType* iso2ListOfRootCertificateIDsType);
void init_iso2EVEnergyTransferParameterType(struct iso2EVEnergyTransferParameterType* iso2EVEnergyTransferParameterType);
void init_iso2ContractSignatureEncryptedPrivateKeyType(struct iso2ContractSignatureEncryptedPrivateKeyType* iso2ContractSignatureEncryptedPrivateKeyType);
void init_iso2MagneticVectorSetupListType(struct iso2MagneticVectorSetupListType* iso2MagneticVectorSetupListType);
void init_iso2PairingReqType(struct iso2PairingReqType* iso2PairingReqType);
void init_iso2CurrentDemandResType(struct iso2CurrentDemandResType* iso2CurrentDemandResType);
void init_iso2X509IssuerSerialType(struct iso2X509IssuerSerialType* iso2X509IssuerSerialType);
void init_iso2ChargingStatusReqType(struct iso2ChargingStatusReqType* iso2ChargingStatusReqType);
void init_iso2CertificateInstallationResType(struct iso2CertificateInstallationResType* iso2CertificateInstallationResType);
void init_iso2SensorPackageType(struct iso2SensorPackageType* iso2SensorPackageType);
void init_iso2PGPDataType(struct iso2PGPDataType* iso2PGPDataType);
void init_iso2ServiceDiscoveryResType(struct iso2ServiceDiscoveryResType* iso2ServiceDiscoveryResType);
void init_iso2ServiceIDListType(struct iso2ServiceIDListType* iso2ServiceIDListType);
void init_iso2EVFinePositioningSetupParametersType(struct iso2EVFinePositioningSetupParametersType* iso2EVFinePositioningSetupParametersType);
void init_iso2ChargeParameterDiscoveryResType(struct iso2ChargeParameterDiscoveryResType* iso2ChargeParameterDiscoveryResType);
void init_iso2PowerDemandResType(struct iso2PowerDemandResType* iso2PowerDemandResType);
void init_iso2ChargingProfileType(struct iso2ChargingProfileType* iso2ChargingProfileType);
void init_iso2FinePositioningReqType(struct iso2FinePositioningReqType* iso2FinePositioningReqType);
void init_iso2SalesTariffType(struct iso2SalesTariffType* iso2SalesTariffType);
void init_iso2SensorType(struct iso2SensorType* iso2SensorType);
void init_iso2SignatureValueType(struct iso2SignatureValueType* iso2SignatureValueType);
void init_iso2SignedInfoType(struct iso2SignedInfoType* iso2SignedInfoType);
void init_iso2PowerDeliveryResType(struct iso2PowerDeliveryResType* iso2PowerDeliveryResType);
void init_iso2CableCheckReqType(struct iso2CableCheckReqType* iso2CableCheckReqType);
void init_iso2SelectedServiceType(struct iso2SelectedServiceType* iso2SelectedServiceType);
void init_iso2DiffieHellmanPublickeyType(struct iso2DiffieHellmanPublickeyType* iso2DiffieHellmanPublickeyType);
void init_iso2EVSEStatusType(struct iso2EVSEStatusType* iso2EVSEStatusType);


#endif /* DEPLOY_ISO2_CODEC */

#ifdef __cplusplus
}
#endif

#endif
