/*
 * Copyright (C) 2007-2018 Siemens AG
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published
 * by the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

/*******************************************************************
 *
 * @author Daniel.Peintner.EXT@siemens.com
 * @version 2017-03-02 
 * @contact Richard.Kuntschke@siemens.com
 *
 * <p>Code generated by EXIdizer</p>
 * <p>Schema: V2G_CI_MsgDef.xsd</p>
 *
 *
 ********************************************************************/



/**
 * \file 	BitOutputStream.h
 * \brief 	Bit Output Stream
 *
 * 			Write bits and bytes to an underlying output stream.
 *
 */

#ifndef BIT_OUTPUT_STREAM_H
#define BIT_OUTPUT_STREAM_H

#ifdef __cplusplus
extern "C" {
#endif

#include <stdint.h>

#include "EXITypes.h"

/**
 * \brief 		Write bits
 *
 * 				Write the n least significant bits of parameter b starting
 * 				with the most significant, i.e. from left to right.
 *
 * \param       stream   		Output Stream
 * \param       nbits			Number of bits
 * \param       bits		   	value
 * \return                  	Error-Code <> 0
 *
 */
int writeBits(bitstream_t* stream, size_t nbits, uint32_t bits);


/**
 * \brief 		Flush output
 *
 * 				If there are some unwritten bits, pad them if necessary and
 * 				write them out. Note that this method does flush the
 * 				underlying stream.
 *
 * \param       stream   		Output Stream
 * \return                  	Error-Code <> 0
 *
 */
int flush(bitstream_t* stream);


#ifdef __cplusplus
}
#endif

#endif

