/*
 * Copyright (C) 2007-2018 Siemens AG
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published
 * by the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

/*******************************************************************
 *
 * @author Daniel.Peintner.EXT@siemens.com
 * @version 0.9.4 
 * @contact Richard.Kuntschke@siemens.com
 *
 * <p>Code generated by EXIdizer</p>
 * <p>Schema: xmldsig-core-schema.xsd</p>
 *
 *
 ********************************************************************/



/**
 * \file 	EXIDatatypes.h
 * \brief 	Datatype definitions and structs for given XML Schema definitions and initialization methods
 *
 */

#ifndef EXI_xmldsig_DATATYPES_H
#define EXI_xmldsig_DATATYPES_H

#ifdef __cplusplus
extern "C" {
#endif

#define SUPPORT_YES 1
#define SUPPORT_NO 2
#define DEPLOY_XMLDSIG_CODEC SUPPORT_YES
#define DEPLOY_XMLDSIG_CODEC_FRAGMENT SUPPORT_YES

#if DEPLOY_XMLDSIG_CODEC == SUPPORT_YES

#include <stdint.h>

#include "EXITypes.h"


/* Datatype definitions and structs for given XML Schema definitions */

#define UNION_YES 1
#define UNION_NO 2
#define SAVE_MEMORY_WITH_UNNAMED_UNION UNION_YES

/* Complex type name='http://www.w3.org/2000/09/xmldsig#,CanonicalizationMethodType',  base type name='anyType',  content type='MIXED',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='((WC[##any]){0-UNBOUNDED})',  derivedBy='RESTRICTION'.  */
#define xmldsigCanonicalizationMethodType_Algorithm_CHARACTERS_SIZE 65 + EXTRA_CHAR 
#define xmldsigCanonicalizationMethodType_ANY_CHARACTERS_SIZE 50 + EXTRA_CHAR 
struct xmldsigCanonicalizationMethodType {
	/* attribute: Algorithm {http://www.w3.org/2001/XMLSchema,anyURI} */
	struct {
		exi_string_character_t characters[xmldsigCanonicalizationMethodType_Algorithm_CHARACTERS_SIZE];
		uint16_t charactersLen;
	}  Algorithm ;
	/* element: WC[##any] */
	struct {
		exi_string_character_t characters[xmldsigCanonicalizationMethodType_ANY_CHARACTERS_SIZE];
		uint16_t charactersLen;
	}  ANY ;
	unsigned int ANY_isUsed:1;
};

/* Complex type name='http://www.w3.org/2000/09/xmldsig#,ObjectType',  base type name='anyType',  content type='MIXED',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='((WC[##any])){0-UNBOUNDED}',  derivedBy='RESTRICTION'.  */
#define xmldsigObjectType_Id_CHARACTERS_SIZE 50 + EXTRA_CHAR 
#define xmldsigObjectType_MimeType_CHARACTERS_SIZE 50 + EXTRA_CHAR 
#define xmldsigObjectType_Encoding_CHARACTERS_SIZE 50 + EXTRA_CHAR 
#define xmldsigObjectType_ANY_CHARACTERS_SIZE 50 + EXTRA_CHAR 
struct xmldsigObjectType {
	/* attribute: Id {http://www.w3.org/2001/XMLSchema,ID} */
	struct {
		exi_string_character_t characters[xmldsigObjectType_Id_CHARACTERS_SIZE];
		uint16_t charactersLen;
	}  Id ;
	unsigned int Id_isUsed:1;
	/* attribute: MimeType {http://www.w3.org/2001/XMLSchema,string} */
	struct {
		exi_string_character_t characters[xmldsigObjectType_MimeType_CHARACTERS_SIZE];
		uint16_t charactersLen;
	}  MimeType ;
	unsigned int MimeType_isUsed:1;
	/* attribute: Encoding {http://www.w3.org/2001/XMLSchema,anyURI} */
	struct {
		exi_string_character_t characters[xmldsigObjectType_Encoding_CHARACTERS_SIZE];
		uint16_t charactersLen;
	}  Encoding ;
	unsigned int Encoding_isUsed:1;
	/* element: WC[##any] */
	struct {
		exi_string_character_t characters[xmldsigObjectType_ANY_CHARACTERS_SIZE];
		uint16_t charactersLen;
	}  ANY ;
	unsigned int ANY_isUsed:1;
};

/* Complex type name='http://www.w3.org/2000/09/xmldsig#,TransformType',  base type name='anyType',  content type='MIXED',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='((WC[##other:"http://www.w3.org/2000/09/xmldsig#"])|"http://www.w3.org/2000/09/xmldsig#":XPath){0-UNBOUNDED}',  derivedBy='RESTRICTION'.  */
#define xmldsigTransformType_Algorithm_CHARACTERS_SIZE 65 + EXTRA_CHAR 
#define xmldsigTransformType_ANY_CHARACTERS_SIZE 50 + EXTRA_CHAR 
#define xmldsigTransformType_XPath_CHARACTERS_SIZE 50 + EXTRA_CHAR 
#define xmldsigTransformType_XPath_ARRAY_SIZE 1
struct xmldsigTransformType {
	/* attribute: Algorithm {http://www.w3.org/2001/XMLSchema,anyURI} */
	struct {
		exi_string_character_t characters[xmldsigTransformType_Algorithm_CHARACTERS_SIZE];
		uint16_t charactersLen;
	}  Algorithm ;
	/* element: WC[##other:"http://www.w3.org/2000/09/xmldsig#"] */
	struct {
		exi_string_character_t characters[xmldsigTransformType_ANY_CHARACTERS_SIZE];
		uint16_t charactersLen;
	}  ANY ;
	unsigned int ANY_isUsed:1;
	/* element: "http://www.w3.org/2000/09/xmldsig#":XPath, http://www.w3.org/2001/XMLSchema,string */
	struct {
		struct {
			exi_string_character_t characters[xmldsigTransformType_XPath_CHARACTERS_SIZE];
			uint16_t charactersLen;
		}  array[xmldsigTransformType_XPath_ARRAY_SIZE];
		uint16_t arrayLen;
	} XPath;
};

/* Complex type name='http://www.w3.org/2000/09/xmldsig#,SignatureMethodType',  base type name='anyType',  content type='MIXED',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("http://www.w3.org/2000/09/xmldsig#":HMACOutputLength{0-1},(WC[##other:"http://www.w3.org/2000/09/xmldsig#"]){0-UNBOUNDED})',  derivedBy='RESTRICTION'.  */
#define xmldsigSignatureMethodType_Algorithm_CHARACTERS_SIZE 65 + EXTRA_CHAR 
#define xmldsigSignatureMethodType_ANY_CHARACTERS_SIZE 50 + EXTRA_CHAR 
struct xmldsigSignatureMethodType {
	/* attribute: Algorithm {http://www.w3.org/2001/XMLSchema,anyURI} */
	struct {
		exi_string_character_t characters[xmldsigSignatureMethodType_Algorithm_CHARACTERS_SIZE];
		uint16_t charactersLen;
	}  Algorithm ;
	/* element: "http://www.w3.org/2000/09/xmldsig#":HMACOutputLength, http://www.w3.org/2000/09/xmldsig#,HMACOutputLengthType */
	int64_t HMACOutputLength ;
	unsigned int HMACOutputLength_isUsed:1;
	/* element: WC[##other:"http://www.w3.org/2000/09/xmldsig#"] */
	struct {
		exi_string_character_t characters[xmldsigSignatureMethodType_ANY_CHARACTERS_SIZE];
		uint16_t charactersLen;
	}  ANY ;
	unsigned int ANY_isUsed:1;
};

/* Complex type name='http://www.w3.org/2000/09/xmldsig#,DigestMethodType',  base type name='anyType',  content type='MIXED',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='((WC[##other:"http://www.w3.org/2000/09/xmldsig#"]){0-UNBOUNDED})',  derivedBy='RESTRICTION'.  */
#define xmldsigDigestMethodType_Algorithm_CHARACTERS_SIZE 65 + EXTRA_CHAR 
#define xmldsigDigestMethodType_ANY_CHARACTERS_SIZE 50 + EXTRA_CHAR 
struct xmldsigDigestMethodType {
	/* attribute: Algorithm {http://www.w3.org/2001/XMLSchema,anyURI} */
	struct {
		exi_string_character_t characters[xmldsigDigestMethodType_Algorithm_CHARACTERS_SIZE];
		uint16_t charactersLen;
	}  Algorithm ;
	/* element: WC[##other:"http://www.w3.org/2000/09/xmldsig#"] */
	struct {
		exi_string_character_t characters[xmldsigDigestMethodType_ANY_CHARACTERS_SIZE];
		uint16_t charactersLen;
	}  ANY ;
	unsigned int ANY_isUsed:1;
};

/* Complex type name='http://www.w3.org/2000/09/xmldsig#,SignatureValueType',  base type name='base64Binary',  content type='SIMPLE',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  derivedBy='EXTENSION'.  */
#define xmldsigSignatureValueType_Id_CHARACTERS_SIZE 50 + EXTRA_CHAR 
#define xmldsigSignatureValueType_CONTENT_BYTES_SIZE 350
struct xmldsigSignatureValueType {
	/* attribute: Id {http://www.w3.org/2001/XMLSchema,ID} */
	struct {
		exi_string_character_t characters[xmldsigSignatureValueType_Id_CHARACTERS_SIZE];
		uint16_t charactersLen;
	}  Id ;
	unsigned int Id_isUsed:1;
	/* simple content: http://www.w3.org/2001/XMLSchema,base64Binary */
	struct {
		uint8_t bytes[xmldsigSignatureValueType_CONTENT_BYTES_SIZE];
		uint16_t bytesLen;
	}  CONTENT ;
};

/* Complex type name='http://www.w3.org/2000/09/xmldsig#,X509IssuerSerialType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("http://www.w3.org/2000/09/xmldsig#":X509IssuerName,"http://www.w3.org/2000/09/xmldsig#":X509SerialNumber)',  derivedBy='RESTRICTION'.  */
#define xmldsigX509IssuerSerialType_X509IssuerName_CHARACTERS_SIZE 50 + EXTRA_CHAR 
struct xmldsigX509IssuerSerialType {
	/* element: "http://www.w3.org/2000/09/xmldsig#":X509IssuerName, http://www.w3.org/2001/XMLSchema,string */
	struct {
		exi_string_character_t characters[xmldsigX509IssuerSerialType_X509IssuerName_CHARACTERS_SIZE];
		uint16_t charactersLen;
	}  X509IssuerName ;
	/* element: "http://www.w3.org/2000/09/xmldsig#":X509SerialNumber, http://www.w3.org/2001/XMLSchema,integer */
	int64_t X509SerialNumber ;
};

/* Complex type name='http://www.w3.org/2000/09/xmldsig#,SignaturePropertyType',  base type name='anyType',  content type='MIXED',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='((WC[##other:"http://www.w3.org/2000/09/xmldsig#"])){1-UNBOUNDED}',  derivedBy='RESTRICTION'.  */
#define xmldsigSignaturePropertyType_Target_CHARACTERS_SIZE 50 + EXTRA_CHAR 
#define xmldsigSignaturePropertyType_Id_CHARACTERS_SIZE 50 + EXTRA_CHAR 
#define xmldsigSignaturePropertyType_ANY_CHARACTERS_SIZE 50 + EXTRA_CHAR 
struct xmldsigSignaturePropertyType {
	/* attribute: Target {http://www.w3.org/2001/XMLSchema,anyURI} */
	struct {
		exi_string_character_t characters[xmldsigSignaturePropertyType_Target_CHARACTERS_SIZE];
		uint16_t charactersLen;
	}  Target ;
	/* attribute: Id {http://www.w3.org/2001/XMLSchema,ID} */
	struct {
		exi_string_character_t characters[xmldsigSignaturePropertyType_Id_CHARACTERS_SIZE];
		uint16_t charactersLen;
	}  Id ;
	unsigned int Id_isUsed:1;
	/* element: WC[##other:"http://www.w3.org/2000/09/xmldsig#"] */
	struct {
		exi_string_character_t characters[xmldsigSignaturePropertyType_ANY_CHARACTERS_SIZE];
		uint16_t charactersLen;
	}  ANY ;
	unsigned int ANY_isUsed:1;
};

/* Complex type name='http://www.w3.org/2000/09/xmldsig#,RSAKeyValueType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("http://www.w3.org/2000/09/xmldsig#":Modulus,"http://www.w3.org/2000/09/xmldsig#":Exponent)',  derivedBy='RESTRICTION'.  */
#define xmldsigRSAKeyValueType_Modulus_BYTES_SIZE 350 
#define xmldsigRSAKeyValueType_Exponent_BYTES_SIZE 350 
struct xmldsigRSAKeyValueType {
	/* element: "http://www.w3.org/2000/09/xmldsig#":Modulus, http://www.w3.org/2000/09/xmldsig#,CryptoBinary */
	struct {
		uint8_t bytes[xmldsigRSAKeyValueType_Modulus_BYTES_SIZE];
		uint16_t bytesLen;
	}  Modulus ;
	/* element: "http://www.w3.org/2000/09/xmldsig#":Exponent, http://www.w3.org/2000/09/xmldsig#,CryptoBinary */
	struct {
		uint8_t bytes[xmldsigRSAKeyValueType_Exponent_BYTES_SIZE];
		uint16_t bytesLen;
	}  Exponent ;
};

/* Complex type name='http://www.w3.org/2000/09/xmldsig#,PGPDataType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='(("http://www.w3.org/2000/09/xmldsig#":PGPKeyID,"http://www.w3.org/2000/09/xmldsig#":PGPKeyPacket{0-1},(WC[##other:"http://www.w3.org/2000/09/xmldsig#"]){0-UNBOUNDED})|("http://www.w3.org/2000/09/xmldsig#":PGPKeyPacket,(WC[##other:"http://www.w3.org/2000/09/xmldsig#"]){0-UNBOUNDED}))',  derivedBy='RESTRICTION'.  */
#define xmldsigPGPDataType_PGPKeyID_BYTES_SIZE 350 
#define xmldsigPGPDataType_PGPKeyPacket_BYTES_SIZE 350 
#define xmldsigPGPDataType_ANY_CHARACTERS_SIZE 50 + EXTRA_CHAR 
struct xmldsigPGPDataType {
	/* element: "http://www.w3.org/2000/09/xmldsig#":PGPKeyID, http://www.w3.org/2001/XMLSchema,base64Binary */
	struct {
		uint8_t bytes[xmldsigPGPDataType_PGPKeyID_BYTES_SIZE];
		uint16_t bytesLen;
	}  PGPKeyID ;
	unsigned int PGPKeyID_isUsed:1;
	/* element: "http://www.w3.org/2000/09/xmldsig#":PGPKeyPacket, http://www.w3.org/2001/XMLSchema,base64Binary */
	struct {
		uint8_t bytes[xmldsigPGPDataType_PGPKeyPacket_BYTES_SIZE];
		uint16_t bytesLen;
	}  PGPKeyPacket ;
	unsigned int PGPKeyPacket_isUsed:1;
	/* element: WC[##other:"http://www.w3.org/2000/09/xmldsig#"] */
	struct {
		exi_string_character_t characters[xmldsigPGPDataType_ANY_CHARACTERS_SIZE];
		uint16_t charactersLen;
	}  ANY ;
	unsigned int ANY_isUsed:1;
};

/* Complex type name='http://www.w3.org/2000/09/xmldsig#,TransformsType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("http://www.w3.org/2000/09/xmldsig#":Transform{1-UNBOUNDED})',  derivedBy='RESTRICTION'.  */
#define xmldsigTransformsType_Transform_ARRAY_SIZE 1
struct xmldsigTransformsType {
	/* element: "http://www.w3.org/2000/09/xmldsig#":Transform, Complex type name='http://www.w3.org/2000/09/xmldsig#,TransformType',  base type name='anyType',  content type='MIXED',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='((WC[##other:"http://www.w3.org/2000/09/xmldsig#"])|"http://www.w3.org/2000/09/xmldsig#":XPath){0-UNBOUNDED}',  derivedBy='RESTRICTION'.  */
	struct {
		struct xmldsigTransformType array[xmldsigTransformsType_Transform_ARRAY_SIZE];
		uint16_t arrayLen;
	} Transform;
};

/* Complex type name='http://www.w3.org/2000/09/xmldsig#,X509DataType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='(("http://www.w3.org/2000/09/xmldsig#":X509IssuerSerial|"http://www.w3.org/2000/09/xmldsig#":X509SKI|"http://www.w3.org/2000/09/xmldsig#":X509SubjectName|"http://www.w3.org/2000/09/xmldsig#":X509Certificate|"http://www.w3.org/2000/09/xmldsig#":X509CRL|(WC[##other:"http://www.w3.org/2000/09/xmldsig#"]))){1-UNBOUNDED}',  derivedBy='RESTRICTION'.  */
#define xmldsigX509DataType_X509IssuerSerial_ARRAY_SIZE 1
#define xmldsigX509DataType_X509SKI_BYTES_SIZE 350 
#define xmldsigX509DataType_X509SKI_ARRAY_SIZE 1
#define xmldsigX509DataType_X509SubjectName_CHARACTERS_SIZE 50 + EXTRA_CHAR 
#define xmldsigX509DataType_X509SubjectName_ARRAY_SIZE 1
#define xmldsigX509DataType_X509Certificate_BYTES_SIZE 350 
#define xmldsigX509DataType_X509Certificate_ARRAY_SIZE 1
#define xmldsigX509DataType_X509CRL_BYTES_SIZE 350 
#define xmldsigX509DataType_X509CRL_ARRAY_SIZE 1
#define xmldsigX509DataType_ANY_CHARACTERS_SIZE 50 + EXTRA_CHAR 
struct xmldsigX509DataType {
	/* element: "http://www.w3.org/2000/09/xmldsig#":X509IssuerSerial, Complex type name='http://www.w3.org/2000/09/xmldsig#,X509IssuerSerialType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("http://www.w3.org/2000/09/xmldsig#":X509IssuerName,"http://www.w3.org/2000/09/xmldsig#":X509SerialNumber)',  derivedBy='RESTRICTION'.  */
	struct {
		struct xmldsigX509IssuerSerialType array[xmldsigX509DataType_X509IssuerSerial_ARRAY_SIZE];
		uint16_t arrayLen;
	} X509IssuerSerial;
	/* element: "http://www.w3.org/2000/09/xmldsig#":X509SKI, http://www.w3.org/2001/XMLSchema,base64Binary */
	struct {
		struct {
			uint8_t bytes[xmldsigX509DataType_X509SKI_BYTES_SIZE];
			uint16_t bytesLen;
		}  array[xmldsigX509DataType_X509SKI_ARRAY_SIZE];
		uint16_t arrayLen;
	} X509SKI;
	/* element: "http://www.w3.org/2000/09/xmldsig#":X509SubjectName, http://www.w3.org/2001/XMLSchema,string */
	struct {
		struct {
			exi_string_character_t characters[xmldsigX509DataType_X509SubjectName_CHARACTERS_SIZE];
			uint16_t charactersLen;
		}  array[xmldsigX509DataType_X509SubjectName_ARRAY_SIZE];
		uint16_t arrayLen;
	} X509SubjectName;
	/* element: "http://www.w3.org/2000/09/xmldsig#":X509Certificate, http://www.w3.org/2001/XMLSchema,base64Binary */
	struct {
		struct {
			uint8_t bytes[xmldsigX509DataType_X509Certificate_BYTES_SIZE];
			uint16_t bytesLen;
		}  array[xmldsigX509DataType_X509Certificate_ARRAY_SIZE];
		uint16_t arrayLen;
	} X509Certificate;
	/* element: "http://www.w3.org/2000/09/xmldsig#":X509CRL, http://www.w3.org/2001/XMLSchema,base64Binary */
	struct {
		struct {
			uint8_t bytes[xmldsigX509DataType_X509CRL_BYTES_SIZE];
			uint16_t bytesLen;
		}  array[xmldsigX509DataType_X509CRL_ARRAY_SIZE];
		uint16_t arrayLen;
	} X509CRL;
	/* element: WC[##other:"http://www.w3.org/2000/09/xmldsig#"] */
	struct {
		exi_string_character_t characters[xmldsigX509DataType_ANY_CHARACTERS_SIZE];
		uint16_t charactersLen;
	}  ANY ;
	unsigned int ANY_isUsed:1;
};

/* Complex type name='http://www.w3.org/2000/09/xmldsig#,DSAKeyValueType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='(("http://www.w3.org/2000/09/xmldsig#":P,"http://www.w3.org/2000/09/xmldsig#":Q){0-1},"http://www.w3.org/2000/09/xmldsig#":G{0-1},"http://www.w3.org/2000/09/xmldsig#":Y,"http://www.w3.org/2000/09/xmldsig#":J{0-1},("http://www.w3.org/2000/09/xmldsig#":Seed,"http://www.w3.org/2000/09/xmldsig#":PgenCounter){0-1})',  derivedBy='RESTRICTION'.  */
#define xmldsigDSAKeyValueType_P_BYTES_SIZE 350 
#define xmldsigDSAKeyValueType_Q_BYTES_SIZE 350 
#define xmldsigDSAKeyValueType_G_BYTES_SIZE 350 
#define xmldsigDSAKeyValueType_Y_BYTES_SIZE 350 
#define xmldsigDSAKeyValueType_J_BYTES_SIZE 350 
#define xmldsigDSAKeyValueType_Seed_BYTES_SIZE 350 
#define xmldsigDSAKeyValueType_PgenCounter_BYTES_SIZE 350 
struct xmldsigDSAKeyValueType {
	/* element: "http://www.w3.org/2000/09/xmldsig#":P, http://www.w3.org/2000/09/xmldsig#,CryptoBinary */
	struct {
		uint8_t bytes[xmldsigDSAKeyValueType_P_BYTES_SIZE];
		uint16_t bytesLen;
	}  P ;
	unsigned int P_isUsed:1;
	/* element: "http://www.w3.org/2000/09/xmldsig#":Q, http://www.w3.org/2000/09/xmldsig#,CryptoBinary */
	struct {
		uint8_t bytes[xmldsigDSAKeyValueType_Q_BYTES_SIZE];
		uint16_t bytesLen;
	}  Q ;
	unsigned int Q_isUsed:1;
	/* element: "http://www.w3.org/2000/09/xmldsig#":G, http://www.w3.org/2000/09/xmldsig#,CryptoBinary */
	struct {
		uint8_t bytes[xmldsigDSAKeyValueType_G_BYTES_SIZE];
		uint16_t bytesLen;
	}  G ;
	unsigned int G_isUsed:1;
	/* element: "http://www.w3.org/2000/09/xmldsig#":Y, http://www.w3.org/2000/09/xmldsig#,CryptoBinary */
	struct {
		uint8_t bytes[xmldsigDSAKeyValueType_Y_BYTES_SIZE];
		uint16_t bytesLen;
	}  Y ;
	/* element: "http://www.w3.org/2000/09/xmldsig#":J, http://www.w3.org/2000/09/xmldsig#,CryptoBinary */
	struct {
		uint8_t bytes[xmldsigDSAKeyValueType_J_BYTES_SIZE];
		uint16_t bytesLen;
	}  J ;
	unsigned int J_isUsed:1;
	/* element: "http://www.w3.org/2000/09/xmldsig#":Seed, http://www.w3.org/2000/09/xmldsig#,CryptoBinary */
	struct {
		uint8_t bytes[xmldsigDSAKeyValueType_Seed_BYTES_SIZE];
		uint16_t bytesLen;
	}  Seed ;
	unsigned int Seed_isUsed:1;
	/* element: "http://www.w3.org/2000/09/xmldsig#":PgenCounter, http://www.w3.org/2000/09/xmldsig#,CryptoBinary */
	struct {
		uint8_t bytes[xmldsigDSAKeyValueType_PgenCounter_BYTES_SIZE];
		uint16_t bytesLen;
	}  PgenCounter ;
	unsigned int PgenCounter_isUsed:1;
};

/* Complex type name='http://www.w3.org/2000/09/xmldsig#,ReferenceType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("http://www.w3.org/2000/09/xmldsig#":Transforms{0-1},"http://www.w3.org/2000/09/xmldsig#":DigestMethod,"http://www.w3.org/2000/09/xmldsig#":DigestValue)',  derivedBy='RESTRICTION'.  */
#define xmldsigReferenceType_Id_CHARACTERS_SIZE 50 + EXTRA_CHAR 
#define xmldsigReferenceType_URI_CHARACTERS_SIZE 50 + EXTRA_CHAR 
#define xmldsigReferenceType_Type_CHARACTERS_SIZE 50 + EXTRA_CHAR 
#define xmldsigReferenceType_DigestValue_BYTES_SIZE 350 
struct xmldsigReferenceType {
	/* attribute: Id {http://www.w3.org/2001/XMLSchema,ID} */
	struct {
		exi_string_character_t characters[xmldsigReferenceType_Id_CHARACTERS_SIZE];
		uint16_t charactersLen;
	}  Id ;
	unsigned int Id_isUsed:1;
	/* attribute: URI {http://www.w3.org/2001/XMLSchema,anyURI} */
	struct {
		exi_string_character_t characters[xmldsigReferenceType_URI_CHARACTERS_SIZE];
		uint16_t charactersLen;
	}  URI ;
	unsigned int URI_isUsed:1;
	/* attribute: Type {http://www.w3.org/2001/XMLSchema,anyURI} */
	struct {
		exi_string_character_t characters[xmldsigReferenceType_Type_CHARACTERS_SIZE];
		uint16_t charactersLen;
	}  Type ;
	unsigned int Type_isUsed:1;
	/* element: "http://www.w3.org/2000/09/xmldsig#":Transforms, Complex type name='http://www.w3.org/2000/09/xmldsig#,TransformsType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("http://www.w3.org/2000/09/xmldsig#":Transform{1-UNBOUNDED})',  derivedBy='RESTRICTION'.  */
	struct xmldsigTransformsType Transforms ;
	unsigned int Transforms_isUsed:1;
	/* element: "http://www.w3.org/2000/09/xmldsig#":DigestMethod, Complex type name='http://www.w3.org/2000/09/xmldsig#,DigestMethodType',  base type name='anyType',  content type='MIXED',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='((WC[##other:"http://www.w3.org/2000/09/xmldsig#"]){0-UNBOUNDED})',  derivedBy='RESTRICTION'.  */
	struct xmldsigDigestMethodType DigestMethod ;
	/* element: "http://www.w3.org/2000/09/xmldsig#":DigestValue, http://www.w3.org/2000/09/xmldsig#,DigestValueType */
	struct {
		uint8_t bytes[xmldsigReferenceType_DigestValue_BYTES_SIZE];
		uint16_t bytesLen;
	}  DigestValue ;
};

/* Complex type name='http://www.w3.org/2000/09/xmldsig#,SPKIDataType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("http://www.w3.org/2000/09/xmldsig#":SPKISexp,(WC[##other:"http://www.w3.org/2000/09/xmldsig#"]){0-1}){1-UNBOUNDED}',  derivedBy='RESTRICTION'.  */
#define xmldsigSPKIDataType_SPKISexp_BYTES_SIZE 350 
#define xmldsigSPKIDataType_SPKISexp_ARRAY_SIZE 1
#define xmldsigSPKIDataType_ANY_CHARACTERS_SIZE 50 + EXTRA_CHAR 
struct xmldsigSPKIDataType {
	/* element: "http://www.w3.org/2000/09/xmldsig#":SPKISexp, http://www.w3.org/2001/XMLSchema,base64Binary */
	struct {
		struct {
			uint8_t bytes[xmldsigSPKIDataType_SPKISexp_BYTES_SIZE];
			uint16_t bytesLen;
		}  array[xmldsigSPKIDataType_SPKISexp_ARRAY_SIZE];
		uint16_t arrayLen;
	} SPKISexp;
	/* element: WC[##other:"http://www.w3.org/2000/09/xmldsig#"] */
	struct {
		exi_string_character_t characters[xmldsigSPKIDataType_ANY_CHARACTERS_SIZE];
		uint16_t charactersLen;
	}  ANY ;
	unsigned int ANY_isUsed:1;
};

/* Complex type name='http://www.w3.org/2000/09/xmldsig#,ManifestType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("http://www.w3.org/2000/09/xmldsig#":Reference{1-UNBOUNDED})',  derivedBy='RESTRICTION'.  */
#define xmldsigManifestType_Id_CHARACTERS_SIZE 50 + EXTRA_CHAR 
#define xmldsigManifestType_Reference_ARRAY_SIZE 1
struct xmldsigManifestType {
	/* attribute: Id {http://www.w3.org/2001/XMLSchema,ID} */
	struct {
		exi_string_character_t characters[xmldsigManifestType_Id_CHARACTERS_SIZE];
		uint16_t charactersLen;
	}  Id ;
	unsigned int Id_isUsed:1;
	/* element: "http://www.w3.org/2000/09/xmldsig#":Reference, Complex type name='http://www.w3.org/2000/09/xmldsig#,ReferenceType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("http://www.w3.org/2000/09/xmldsig#":Transforms{0-1},"http://www.w3.org/2000/09/xmldsig#":DigestMethod,"http://www.w3.org/2000/09/xmldsig#":DigestValue)',  derivedBy='RESTRICTION'.  */
	struct {
		struct xmldsigReferenceType array[xmldsigManifestType_Reference_ARRAY_SIZE];
		uint16_t arrayLen;
	} Reference;
};

/* Complex type name='http://www.w3.org/2000/09/xmldsig#,RetrievalMethodType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("http://www.w3.org/2000/09/xmldsig#":Transforms{0-1})',  derivedBy='RESTRICTION'.  */
#define xmldsigRetrievalMethodType_URI_CHARACTERS_SIZE 50 + EXTRA_CHAR 
#define xmldsigRetrievalMethodType_Type_CHARACTERS_SIZE 50 + EXTRA_CHAR 
struct xmldsigRetrievalMethodType {
	/* attribute: URI {http://www.w3.org/2001/XMLSchema,anyURI} */
	struct {
		exi_string_character_t characters[xmldsigRetrievalMethodType_URI_CHARACTERS_SIZE];
		uint16_t charactersLen;
	}  URI ;
	unsigned int URI_isUsed:1;
	/* attribute: Type {http://www.w3.org/2001/XMLSchema,anyURI} */
	struct {
		exi_string_character_t characters[xmldsigRetrievalMethodType_Type_CHARACTERS_SIZE];
		uint16_t charactersLen;
	}  Type ;
	unsigned int Type_isUsed:1;
	/* element: "http://www.w3.org/2000/09/xmldsig#":Transforms, Complex type name='http://www.w3.org/2000/09/xmldsig#,TransformsType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("http://www.w3.org/2000/09/xmldsig#":Transform{1-UNBOUNDED})',  derivedBy='RESTRICTION'.  */
	struct xmldsigTransformsType Transforms ;
	unsigned int Transforms_isUsed:1;
};

/* Complex type name='http://www.w3.org/2000/09/xmldsig#,SignedInfoType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("http://www.w3.org/2000/09/xmldsig#":CanonicalizationMethod,"http://www.w3.org/2000/09/xmldsig#":SignatureMethod,"http://www.w3.org/2000/09/xmldsig#":Reference{1-UNBOUNDED})',  derivedBy='RESTRICTION'.  */
#define xmldsigSignedInfoType_Id_CHARACTERS_SIZE 50 + EXTRA_CHAR 
#define xmldsigSignedInfoType_Reference_ARRAY_SIZE 1
struct xmldsigSignedInfoType {
	/* attribute: Id {http://www.w3.org/2001/XMLSchema,ID} */
	struct {
		exi_string_character_t characters[xmldsigSignedInfoType_Id_CHARACTERS_SIZE];
		uint16_t charactersLen;
	}  Id ;
	unsigned int Id_isUsed:1;
	/* element: "http://www.w3.org/2000/09/xmldsig#":CanonicalizationMethod, Complex type name='http://www.w3.org/2000/09/xmldsig#,CanonicalizationMethodType',  base type name='anyType',  content type='MIXED',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='((WC[##any]){0-UNBOUNDED})',  derivedBy='RESTRICTION'.  */
	struct xmldsigCanonicalizationMethodType CanonicalizationMethod ;
	/* element: "http://www.w3.org/2000/09/xmldsig#":SignatureMethod, Complex type name='http://www.w3.org/2000/09/xmldsig#,SignatureMethodType',  base type name='anyType',  content type='MIXED',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("http://www.w3.org/2000/09/xmldsig#":HMACOutputLength{0-1},(WC[##other:"http://www.w3.org/2000/09/xmldsig#"]){0-UNBOUNDED})',  derivedBy='RESTRICTION'.  */
	struct xmldsigSignatureMethodType SignatureMethod ;
	/* element: "http://www.w3.org/2000/09/xmldsig#":Reference, Complex type name='http://www.w3.org/2000/09/xmldsig#,ReferenceType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("http://www.w3.org/2000/09/xmldsig#":Transforms{0-1},"http://www.w3.org/2000/09/xmldsig#":DigestMethod,"http://www.w3.org/2000/09/xmldsig#":DigestValue)',  derivedBy='RESTRICTION'.  */
	struct {
		struct xmldsigReferenceType array[xmldsigSignedInfoType_Reference_ARRAY_SIZE];
		uint16_t arrayLen;
	} Reference;
};

/* Complex type name='http://www.w3.org/2000/09/xmldsig#,SignaturePropertiesType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("http://www.w3.org/2000/09/xmldsig#":SignatureProperty{1-UNBOUNDED})',  derivedBy='RESTRICTION'.  */
#define xmldsigSignaturePropertiesType_Id_CHARACTERS_SIZE 50 + EXTRA_CHAR 
#define xmldsigSignaturePropertiesType_SignatureProperty_ARRAY_SIZE 1
struct xmldsigSignaturePropertiesType {
	/* attribute: Id {http://www.w3.org/2001/XMLSchema,ID} */
	struct {
		exi_string_character_t characters[xmldsigSignaturePropertiesType_Id_CHARACTERS_SIZE];
		uint16_t charactersLen;
	}  Id ;
	unsigned int Id_isUsed:1;
	/* element: "http://www.w3.org/2000/09/xmldsig#":SignatureProperty, Complex type name='http://www.w3.org/2000/09/xmldsig#,SignaturePropertyType',  base type name='anyType',  content type='MIXED',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='((WC[##other:"http://www.w3.org/2000/09/xmldsig#"])){1-UNBOUNDED}',  derivedBy='RESTRICTION'.  */
	struct {
		struct xmldsigSignaturePropertyType array[xmldsigSignaturePropertiesType_SignatureProperty_ARRAY_SIZE];
		uint16_t arrayLen;
	} SignatureProperty;
};

/* Complex type name='http://www.w3.org/2000/09/xmldsig#,KeyValueType',  base type name='anyType',  content type='MIXED',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("http://www.w3.org/2000/09/xmldsig#":DSAKeyValue|"http://www.w3.org/2000/09/xmldsig#":RSAKeyValue|(WC[##other:"http://www.w3.org/2000/09/xmldsig#"]))',  derivedBy='RESTRICTION'.  */
#define xmldsigKeyValueType_ANY_CHARACTERS_SIZE 50 + EXTRA_CHAR 
struct xmldsigKeyValueType {
	/* element: "http://www.w3.org/2000/09/xmldsig#":DSAKeyValue, Complex type name='http://www.w3.org/2000/09/xmldsig#,DSAKeyValueType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='(("http://www.w3.org/2000/09/xmldsig#":P,"http://www.w3.org/2000/09/xmldsig#":Q){0-1},"http://www.w3.org/2000/09/xmldsig#":G{0-1},"http://www.w3.org/2000/09/xmldsig#":Y,"http://www.w3.org/2000/09/xmldsig#":J{0-1},("http://www.w3.org/2000/09/xmldsig#":Seed,"http://www.w3.org/2000/09/xmldsig#":PgenCounter){0-1})',  derivedBy='RESTRICTION'.  */
	struct xmldsigDSAKeyValueType DSAKeyValue ;
	unsigned int DSAKeyValue_isUsed:1;
	/* element: "http://www.w3.org/2000/09/xmldsig#":RSAKeyValue, Complex type name='http://www.w3.org/2000/09/xmldsig#,RSAKeyValueType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("http://www.w3.org/2000/09/xmldsig#":Modulus,"http://www.w3.org/2000/09/xmldsig#":Exponent)',  derivedBy='RESTRICTION'.  */
	struct xmldsigRSAKeyValueType RSAKeyValue ;
	unsigned int RSAKeyValue_isUsed:1;
	/* element: WC[##other:"http://www.w3.org/2000/09/xmldsig#"] */
	struct {
		exi_string_character_t characters[xmldsigKeyValueType_ANY_CHARACTERS_SIZE];
		uint16_t charactersLen;
	}  ANY ;
	unsigned int ANY_isUsed:1;
};

/* Complex type name='http://www.w3.org/2000/09/xmldsig#,KeyInfoType',  base type name='anyType',  content type='MIXED',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("http://www.w3.org/2000/09/xmldsig#":KeyName|"http://www.w3.org/2000/09/xmldsig#":KeyValue|"http://www.w3.org/2000/09/xmldsig#":RetrievalMethod|"http://www.w3.org/2000/09/xmldsig#":X509Data|"http://www.w3.org/2000/09/xmldsig#":PGPData|"http://www.w3.org/2000/09/xmldsig#":SPKIData|"http://www.w3.org/2000/09/xmldsig#":MgmtData|(WC[##other:"http://www.w3.org/2000/09/xmldsig#"])){1-UNBOUNDED}',  derivedBy='RESTRICTION'.  */
#define xmldsigKeyInfoType_Id_CHARACTERS_SIZE 50 + EXTRA_CHAR 
#define xmldsigKeyInfoType_KeyName_CHARACTERS_SIZE 50 + EXTRA_CHAR 
#define xmldsigKeyInfoType_KeyName_ARRAY_SIZE 1
#define xmldsigKeyInfoType_KeyValue_ARRAY_SIZE 1
#define xmldsigKeyInfoType_RetrievalMethod_ARRAY_SIZE 1
#define xmldsigKeyInfoType_X509Data_ARRAY_SIZE 1
#define xmldsigKeyInfoType_PGPData_ARRAY_SIZE 1
#define xmldsigKeyInfoType_SPKIData_ARRAY_SIZE 1
#define xmldsigKeyInfoType_MgmtData_CHARACTERS_SIZE 50 + EXTRA_CHAR 
#define xmldsigKeyInfoType_MgmtData_ARRAY_SIZE 1
#define xmldsigKeyInfoType_ANY_CHARACTERS_SIZE 50 + EXTRA_CHAR 
struct xmldsigKeyInfoType {
	/* attribute: Id {http://www.w3.org/2001/XMLSchema,ID} */
	struct {
		exi_string_character_t characters[xmldsigKeyInfoType_Id_CHARACTERS_SIZE];
		uint16_t charactersLen;
	}  Id ;
	unsigned int Id_isUsed:1;
	/* element: "http://www.w3.org/2000/09/xmldsig#":KeyName, http://www.w3.org/2001/XMLSchema,string */
	struct {
		struct {
			exi_string_character_t characters[xmldsigKeyInfoType_KeyName_CHARACTERS_SIZE];
			uint16_t charactersLen;
		}  array[xmldsigKeyInfoType_KeyName_ARRAY_SIZE];
		uint16_t arrayLen;
	} KeyName;
	/* element: "http://www.w3.org/2000/09/xmldsig#":KeyValue, Complex type name='http://www.w3.org/2000/09/xmldsig#,KeyValueType',  base type name='anyType',  content type='MIXED',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("http://www.w3.org/2000/09/xmldsig#":DSAKeyValue|"http://www.w3.org/2000/09/xmldsig#":RSAKeyValue|(WC[##other:"http://www.w3.org/2000/09/xmldsig#"]))',  derivedBy='RESTRICTION'.  */
	struct {
		struct xmldsigKeyValueType array[xmldsigKeyInfoType_KeyValue_ARRAY_SIZE];
		uint16_t arrayLen;
	} KeyValue;
	/* element: "http://www.w3.org/2000/09/xmldsig#":RetrievalMethod, Complex type name='http://www.w3.org/2000/09/xmldsig#,RetrievalMethodType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("http://www.w3.org/2000/09/xmldsig#":Transforms{0-1})',  derivedBy='RESTRICTION'.  */
	struct {
		struct xmldsigRetrievalMethodType array[xmldsigKeyInfoType_RetrievalMethod_ARRAY_SIZE];
		uint16_t arrayLen;
	} RetrievalMethod;
	/* element: "http://www.w3.org/2000/09/xmldsig#":X509Data, Complex type name='http://www.w3.org/2000/09/xmldsig#,X509DataType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='(("http://www.w3.org/2000/09/xmldsig#":X509IssuerSerial|"http://www.w3.org/2000/09/xmldsig#":X509SKI|"http://www.w3.org/2000/09/xmldsig#":X509SubjectName|"http://www.w3.org/2000/09/xmldsig#":X509Certificate|"http://www.w3.org/2000/09/xmldsig#":X509CRL|(WC[##other:"http://www.w3.org/2000/09/xmldsig#"]))){1-UNBOUNDED}',  derivedBy='RESTRICTION'.  */
	struct {
		struct xmldsigX509DataType array[xmldsigKeyInfoType_X509Data_ARRAY_SIZE];
		uint16_t arrayLen;
	} X509Data;
	/* element: "http://www.w3.org/2000/09/xmldsig#":PGPData, Complex type name='http://www.w3.org/2000/09/xmldsig#,PGPDataType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='(("http://www.w3.org/2000/09/xmldsig#":PGPKeyID,"http://www.w3.org/2000/09/xmldsig#":PGPKeyPacket{0-1},(WC[##other:"http://www.w3.org/2000/09/xmldsig#"]){0-UNBOUNDED})|("http://www.w3.org/2000/09/xmldsig#":PGPKeyPacket,(WC[##other:"http://www.w3.org/2000/09/xmldsig#"]){0-UNBOUNDED}))',  derivedBy='RESTRICTION'.  */
	struct {
		struct xmldsigPGPDataType array[xmldsigKeyInfoType_PGPData_ARRAY_SIZE];
		uint16_t arrayLen;
	} PGPData;
	/* element: "http://www.w3.org/2000/09/xmldsig#":SPKIData, Complex type name='http://www.w3.org/2000/09/xmldsig#,SPKIDataType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("http://www.w3.org/2000/09/xmldsig#":SPKISexp,(WC[##other:"http://www.w3.org/2000/09/xmldsig#"]){0-1}){1-UNBOUNDED}',  derivedBy='RESTRICTION'.  */
	struct {
		struct xmldsigSPKIDataType array[xmldsigKeyInfoType_SPKIData_ARRAY_SIZE];
		uint16_t arrayLen;
	} SPKIData;
	/* element: "http://www.w3.org/2000/09/xmldsig#":MgmtData, http://www.w3.org/2001/XMLSchema,string */
	struct {
		struct {
			exi_string_character_t characters[xmldsigKeyInfoType_MgmtData_CHARACTERS_SIZE];
			uint16_t charactersLen;
		}  array[xmldsigKeyInfoType_MgmtData_ARRAY_SIZE];
		uint16_t arrayLen;
	} MgmtData;
	/* element: WC[##other:"http://www.w3.org/2000/09/xmldsig#"] */
	struct {
		exi_string_character_t characters[xmldsigKeyInfoType_ANY_CHARACTERS_SIZE];
		uint16_t charactersLen;
	}  ANY ;
	unsigned int ANY_isUsed:1;
};

/* Complex type name='http://www.w3.org/2000/09/xmldsig#,SignatureType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("http://www.w3.org/2000/09/xmldsig#":SignedInfo,"http://www.w3.org/2000/09/xmldsig#":SignatureValue,"http://www.w3.org/2000/09/xmldsig#":KeyInfo{0-1},"http://www.w3.org/2000/09/xmldsig#":Object{0-UNBOUNDED})',  derivedBy='RESTRICTION'.  */
#define xmldsigSignatureType_Id_CHARACTERS_SIZE 50 + EXTRA_CHAR 
#define xmldsigSignatureType_Object_ARRAY_SIZE 1
struct xmldsigSignatureType {
	/* attribute: Id {http://www.w3.org/2001/XMLSchema,ID} */
	struct {
		exi_string_character_t characters[xmldsigSignatureType_Id_CHARACTERS_SIZE];
		uint16_t charactersLen;
	}  Id ;
	unsigned int Id_isUsed:1;
	/* element: "http://www.w3.org/2000/09/xmldsig#":SignedInfo, Complex type name='http://www.w3.org/2000/09/xmldsig#,SignedInfoType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("http://www.w3.org/2000/09/xmldsig#":CanonicalizationMethod,"http://www.w3.org/2000/09/xmldsig#":SignatureMethod,"http://www.w3.org/2000/09/xmldsig#":Reference{1-UNBOUNDED})',  derivedBy='RESTRICTION'.  */
	struct xmldsigSignedInfoType SignedInfo ;
	/* element: "http://www.w3.org/2000/09/xmldsig#":SignatureValue, Complex type name='http://www.w3.org/2000/09/xmldsig#,SignatureValueType',  base type name='base64Binary',  content type='SIMPLE',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  derivedBy='EXTENSION'.  */
	struct xmldsigSignatureValueType SignatureValue ;
	/* element: "http://www.w3.org/2000/09/xmldsig#":KeyInfo, Complex type name='http://www.w3.org/2000/09/xmldsig#,KeyInfoType',  base type name='anyType',  content type='MIXED',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("http://www.w3.org/2000/09/xmldsig#":KeyName|"http://www.w3.org/2000/09/xmldsig#":KeyValue|"http://www.w3.org/2000/09/xmldsig#":RetrievalMethod|"http://www.w3.org/2000/09/xmldsig#":X509Data|"http://www.w3.org/2000/09/xmldsig#":PGPData|"http://www.w3.org/2000/09/xmldsig#":SPKIData|"http://www.w3.org/2000/09/xmldsig#":MgmtData|(WC[##other:"http://www.w3.org/2000/09/xmldsig#"])){1-UNBOUNDED}',  derivedBy='RESTRICTION'.  */
	struct xmldsigKeyInfoType KeyInfo ;
	unsigned int KeyInfo_isUsed:1;
	/* element: "http://www.w3.org/2000/09/xmldsig#":Object, Complex type name='http://www.w3.org/2000/09/xmldsig#,ObjectType',  base type name='anyType',  content type='MIXED',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='((WC[##any])){0-UNBOUNDED}',  derivedBy='RESTRICTION'.  */
	struct {
		struct xmldsigObjectType array[xmldsigSignatureType_Object_ARRAY_SIZE];
		uint16_t arrayLen;
	} Object;
};



#define EXIDocument_MgmtData_CHARACTERS_SIZE 50 + EXTRA_CHAR 
#define EXIDocument_KeyName_CHARACTERS_SIZE 50 + EXTRA_CHAR 
#define EXIDocument_DigestValue_BYTES_SIZE 350 
#define EXIFragment_DigestValue_BYTES_SIZE 350 
#define EXIFragment_SPKISexp_BYTES_SIZE 350 
#define EXIFragment_KeyName_CHARACTERS_SIZE 50 + EXTRA_CHAR 
#define EXIFragment_X509IssuerName_CHARACTERS_SIZE 50 + EXTRA_CHAR 
#define EXIFragment_MgmtData_CHARACTERS_SIZE 50 + EXTRA_CHAR 
#define EXIFragment_PGPKeyID_BYTES_SIZE 350 
#define EXIFragment_PGPKeyPacket_BYTES_SIZE 350 
#define EXIFragment_Exponent_BYTES_SIZE 350 
#define EXIFragment_P_BYTES_SIZE 350 
#define EXIFragment_Q_BYTES_SIZE 350 
#define EXIFragment_Seed_BYTES_SIZE 350 
#define EXIFragment_X509SubjectName_CHARACTERS_SIZE 50 + EXTRA_CHAR 
#define EXIFragment_X509Certificate_BYTES_SIZE 350 
#define EXIFragment_G_BYTES_SIZE 350 
#define EXIFragment_J_BYTES_SIZE 350 
#define EXIFragment_X509SKI_BYTES_SIZE 350 
#define EXIFragment_XPath_CHARACTERS_SIZE 50 + EXTRA_CHAR 
#define EXIFragment_Modulus_BYTES_SIZE 350 
#define EXIFragment_X509CRL_BYTES_SIZE 350 
#define EXIFragment_Y_BYTES_SIZE 350 
#define EXIFragment_PgenCounter_BYTES_SIZE 350 


/* Global elements of EXI Document */
struct xmldsigEXIDocument {
#if SAVE_MEMORY_WITH_UNNAMED_UNION == UNION_YES
	union {
#endif /* SAVE_MEMORY_WITH_UNNAMED_UNION == UNION_YES */ 
	struct xmldsigSignaturePropertyType SignatureProperty ;
	struct xmldsigDSAKeyValueType DSAKeyValue ;
	struct xmldsigSignaturePropertiesType SignatureProperties ;
	struct xmldsigKeyValueType KeyValue ;
	struct xmldsigTransformsType Transforms ;
	struct xmldsigDigestMethodType DigestMethod ;
	struct xmldsigSignatureType Signature ;
	struct xmldsigRetrievalMethodType RetrievalMethod ;
	struct xmldsigManifestType Manifest ;
	struct xmldsigReferenceType Reference ;
	struct xmldsigCanonicalizationMethodType CanonicalizationMethod ;
	struct xmldsigRSAKeyValueType RSAKeyValue ;
	struct xmldsigTransformType Transform ;
	struct xmldsigPGPDataType PGPData ;
	struct {
		exi_string_character_t characters[EXIDocument_MgmtData_CHARACTERS_SIZE];
		uint16_t charactersLen;
	}  MgmtData ;
	struct xmldsigSignatureMethodType SignatureMethod ;
	struct xmldsigKeyInfoType KeyInfo ;
	struct xmldsigSPKIDataType SPKIData ;
	struct xmldsigX509DataType X509Data ;
	struct xmldsigSignatureValueType SignatureValue ;
	struct {
		exi_string_character_t characters[EXIDocument_KeyName_CHARACTERS_SIZE];
		uint16_t charactersLen;
	}  KeyName ;
	struct {
		uint8_t bytes[EXIDocument_DigestValue_BYTES_SIZE];
		uint16_t bytesLen;
	}  DigestValue ;
	struct xmldsigSignedInfoType SignedInfo ;
	struct xmldsigObjectType Object ;
#if SAVE_MEMORY_WITH_UNNAMED_UNION == UNION_YES
	};
#endif /* SAVE_MEMORY_WITH_UNNAMED_UNION == UNION_YES */ 
	unsigned int SignatureProperty_isUsed:1;
	unsigned int DSAKeyValue_isUsed:1;
	unsigned int SignatureProperties_isUsed:1;
	unsigned int KeyValue_isUsed:1;
	unsigned int Transforms_isUsed:1;
	unsigned int DigestMethod_isUsed:1;
	unsigned int Signature_isUsed:1;
	unsigned int RetrievalMethod_isUsed:1;
	unsigned int Manifest_isUsed:1;
	unsigned int Reference_isUsed:1;
	unsigned int CanonicalizationMethod_isUsed:1;
	unsigned int RSAKeyValue_isUsed:1;
	unsigned int Transform_isUsed:1;
	unsigned int PGPData_isUsed:1;
	unsigned int MgmtData_isUsed:1;
	unsigned int SignatureMethod_isUsed:1;
	unsigned int KeyInfo_isUsed:1;
	unsigned int SPKIData_isUsed:1;
	unsigned int X509Data_isUsed:1;
	unsigned int SignatureValue_isUsed:1;
	unsigned int KeyName_isUsed:1;
	unsigned int DigestValue_isUsed:1;
	unsigned int SignedInfo_isUsed:1;
	unsigned int Object_isUsed:1;


	int _warning_;
};


#if DEPLOY_XMLDSIG_CODEC_FRAGMENT == SUPPORT_YES
/* Possible elements of EXI Fragment */
struct xmldsigEXIFragment {
#if SAVE_MEMORY_WITH_UNNAMED_UNION == UNION_YES
	union {
#endif /* SAVE_MEMORY_WITH_UNNAMED_UNION == UNION_YES */ 
	struct {
		uint8_t bytes[EXIFragment_DigestValue_BYTES_SIZE];
		uint16_t bytesLen;
	}  DigestValue ;
	struct xmldsigX509DataType X509Data ;
	struct xmldsigKeyValueType KeyValue ;
	struct xmldsigDigestMethodType DigestMethod ;
	struct {
		uint8_t bytes[EXIFragment_SPKISexp_BYTES_SIZE];
		uint16_t bytesLen;
	}  SPKISexp ;
	struct xmldsigTransformsType Transforms ;
	struct {
		exi_string_character_t characters[EXIFragment_KeyName_CHARACTERS_SIZE];
		uint16_t charactersLen;
	}  KeyName ;
	struct {
		exi_string_character_t characters[EXIFragment_X509IssuerName_CHARACTERS_SIZE];
		uint16_t charactersLen;
	}  X509IssuerName ;
	struct {
		exi_string_character_t characters[EXIFragment_MgmtData_CHARACTERS_SIZE];
		uint16_t charactersLen;
	}  MgmtData ;
	struct xmldsigReferenceType Reference ;
	struct xmldsigSignaturePropertiesType SignatureProperties ;
	struct {
		uint8_t bytes[EXIFragment_PGPKeyID_BYTES_SIZE];
		uint16_t bytesLen;
	}  PGPKeyID ;
	struct xmldsigPGPDataType PGPData ;
	struct xmldsigDSAKeyValueType DSAKeyValue ;
	struct xmldsigSignatureValueType SignatureValue ;
	struct xmldsigKeyInfoType KeyInfo ;
	struct xmldsigSignaturePropertyType SignatureProperty ;
	struct {
		uint8_t bytes[EXIFragment_PGPKeyPacket_BYTES_SIZE];
		uint16_t bytesLen;
	}  PGPKeyPacket ;
	int64_t HMACOutputLength ;
	struct {
		uint8_t bytes[EXIFragment_Exponent_BYTES_SIZE];
		uint16_t bytesLen;
	}  Exponent ;
	struct xmldsigManifestType Manifest ;
	struct {
		uint8_t bytes[EXIFragment_P_BYTES_SIZE];
		uint16_t bytesLen;
	}  P ;
	struct xmldsigCanonicalizationMethodType CanonicalizationMethod ;
	struct {
		uint8_t bytes[EXIFragment_Q_BYTES_SIZE];
		uint16_t bytesLen;
	}  Q ;
	struct {
		uint8_t bytes[EXIFragment_Seed_BYTES_SIZE];
		uint16_t bytesLen;
	}  Seed ;
	struct {
		exi_string_character_t characters[EXIFragment_X509SubjectName_CHARACTERS_SIZE];
		uint16_t charactersLen;
	}  X509SubjectName ;
	struct {
		uint8_t bytes[EXIFragment_X509Certificate_BYTES_SIZE];
		uint16_t bytesLen;
	}  X509Certificate ;
	struct xmldsigRSAKeyValueType RSAKeyValue ;
	struct xmldsigX509IssuerSerialType X509IssuerSerial ;
	struct xmldsigSPKIDataType SPKIData ;
	struct {
		uint8_t bytes[EXIFragment_G_BYTES_SIZE];
		uint16_t bytesLen;
	}  G ;
	struct {
		uint8_t bytes[EXIFragment_J_BYTES_SIZE];
		uint16_t bytesLen;
	}  J ;
	struct xmldsigSignedInfoType SignedInfo ;
	struct {
		uint8_t bytes[EXIFragment_X509SKI_BYTES_SIZE];
		uint16_t bytesLen;
	}  X509SKI ;
	struct xmldsigTransformType Transform ;
	struct {
		exi_string_character_t characters[EXIFragment_XPath_CHARACTERS_SIZE];
		uint16_t charactersLen;
	}  XPath ;
	struct xmldsigObjectType Object ;
	int64_t X509SerialNumber ;
	struct xmldsigRetrievalMethodType RetrievalMethod ;
	struct {
		uint8_t bytes[EXIFragment_Modulus_BYTES_SIZE];
		uint16_t bytesLen;
	}  Modulus ;
	struct {
		uint8_t bytes[EXIFragment_X509CRL_BYTES_SIZE];
		uint16_t bytesLen;
	}  X509CRL ;
	struct xmldsigSignatureType Signature ;
	struct {
		uint8_t bytes[EXIFragment_Y_BYTES_SIZE];
		uint16_t bytesLen;
	}  Y ;
	struct xmldsigSignatureMethodType SignatureMethod ;
	struct {
		uint8_t bytes[EXIFragment_PgenCounter_BYTES_SIZE];
		uint16_t bytesLen;
	}  PgenCounter ;
#if SAVE_MEMORY_WITH_UNNAMED_UNION == UNION_YES
	};
#endif /* SAVE_MEMORY_WITH_UNNAMED_UNION == UNION_YES */ 
	unsigned int DigestValue_isUsed:1;
	unsigned int X509Data_isUsed:1;
	unsigned int KeyValue_isUsed:1;
	unsigned int DigestMethod_isUsed:1;
	unsigned int SPKISexp_isUsed:1;
	unsigned int Transforms_isUsed:1;
	unsigned int KeyName_isUsed:1;
	unsigned int X509IssuerName_isUsed:1;
	unsigned int MgmtData_isUsed:1;
	unsigned int Reference_isUsed:1;
	unsigned int SignatureProperties_isUsed:1;
	unsigned int PGPKeyID_isUsed:1;
	unsigned int PGPData_isUsed:1;
	unsigned int DSAKeyValue_isUsed:1;
	unsigned int SignatureValue_isUsed:1;
	unsigned int KeyInfo_isUsed:1;
	unsigned int SignatureProperty_isUsed:1;
	unsigned int PGPKeyPacket_isUsed:1;
	unsigned int HMACOutputLength_isUsed:1;
	unsigned int Exponent_isUsed:1;
	unsigned int Manifest_isUsed:1;
	unsigned int P_isUsed:1;
	unsigned int CanonicalizationMethod_isUsed:1;
	unsigned int Q_isUsed:1;
	unsigned int Seed_isUsed:1;
	unsigned int X509SubjectName_isUsed:1;
	unsigned int X509Certificate_isUsed:1;
	unsigned int RSAKeyValue_isUsed:1;
	unsigned int X509IssuerSerial_isUsed:1;
	unsigned int SPKIData_isUsed:1;
	unsigned int G_isUsed:1;
	unsigned int J_isUsed:1;
	unsigned int SignedInfo_isUsed:1;
	unsigned int X509SKI_isUsed:1;
	unsigned int Transform_isUsed:1;
	unsigned int XPath_isUsed:1;
	unsigned int Object_isUsed:1;
	unsigned int X509SerialNumber_isUsed:1;
	unsigned int RetrievalMethod_isUsed:1;
	unsigned int Modulus_isUsed:1;
	unsigned int X509CRL_isUsed:1;
	unsigned int Signature_isUsed:1;
	unsigned int Y_isUsed:1;
	unsigned int SignatureMethod_isUsed:1;
	unsigned int PgenCounter_isUsed:1;


	int _warning_;
};
#endif /* DEPLOY_XMLDSIG_CODEC_FRAGMENT */


/* Initialization methods for structs */

void init_xmldsigEXIDocument(struct xmldsigEXIDocument* exiDoc);
#if DEPLOY_XMLDSIG_CODEC_FRAGMENT == SUPPORT_YES
void init_xmldsigEXIFragment(struct xmldsigEXIFragment* exiFrag);
#endif /* DEPLOY_XMLDSIG_CODEC_FRAGMENT */
void init_xmldsigCanonicalizationMethodType(struct xmldsigCanonicalizationMethodType* xmldsigCanonicalizationMethodType);
void init_xmldsigManifestType(struct xmldsigManifestType* xmldsigManifestType);
void init_xmldsigObjectType(struct xmldsigObjectType* xmldsigObjectType);
void init_xmldsigTransformType(struct xmldsigTransformType* xmldsigTransformType);
void init_xmldsigSignatureMethodType(struct xmldsigSignatureMethodType* xmldsigSignatureMethodType);
void init_xmldsigDigestMethodType(struct xmldsigDigestMethodType* xmldsigDigestMethodType);
void init_xmldsigRetrievalMethodType(struct xmldsigRetrievalMethodType* xmldsigRetrievalMethodType);
void init_xmldsigSignatureValueType(struct xmldsigSignatureValueType* xmldsigSignatureValueType);
void init_xmldsigX509IssuerSerialType(struct xmldsigX509IssuerSerialType* xmldsigX509IssuerSerialType);
void init_xmldsigSignedInfoType(struct xmldsigSignedInfoType* xmldsigSignedInfoType);
void init_xmldsigSignaturePropertiesType(struct xmldsigSignaturePropertiesType* xmldsigSignaturePropertiesType);
void init_xmldsigSignaturePropertyType(struct xmldsigSignaturePropertyType* xmldsigSignaturePropertyType);
void init_xmldsigKeyValueType(struct xmldsigKeyValueType* xmldsigKeyValueType);
void init_xmldsigRSAKeyValueType(struct xmldsigRSAKeyValueType* xmldsigRSAKeyValueType);
void init_xmldsigPGPDataType(struct xmldsigPGPDataType* xmldsigPGPDataType);
void init_xmldsigTransformsType(struct xmldsigTransformsType* xmldsigTransformsType);
void init_xmldsigX509DataType(struct xmldsigX509DataType* xmldsigX509DataType);
void init_xmldsigSignatureType(struct xmldsigSignatureType* xmldsigSignatureType);
void init_xmldsigDSAKeyValueType(struct xmldsigDSAKeyValueType* xmldsigDSAKeyValueType);
void init_xmldsigReferenceType(struct xmldsigReferenceType* xmldsigReferenceType);
void init_xmldsigSPKIDataType(struct xmldsigSPKIDataType* xmldsigSPKIDataType);
void init_xmldsigKeyInfoType(struct xmldsigKeyInfoType* xmldsigKeyInfoType);


#endif /* DEPLOY_XMLDSIG_CODEC */

#ifdef __cplusplus
}
#endif

#endif
