/*
 * Copyright (C) 2007-2018 Siemens AG
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published
 * by the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

/*******************************************************************
 *
 * @author Daniel.Peintner.EXT@siemens.com
 * @version 0.9.4 
 * @contact Richard.Kuntschke@siemens.com
 *
 * <p>Code generated by EXIdizer</p>
 * <p>Schema: V2G_CI_MsgDef.xsd</p>
 *
 *
 ********************************************************************/



/**
 * \file 	EXIDatatypes.h
 * \brief 	Datatype definitions and structs for given XML Schema definitions and initialization methods
 *
 */

#ifndef EXI_iso1_DATATYPES_H
#define EXI_iso1_DATATYPES_H

#ifdef __cplusplus
extern "C" {
#endif

#define SUPPORT_YES 1
#define SUPPORT_NO 2
#define DEPLOY_ISO1_CODEC SUPPORT_YES
#define DEPLOY_ISO1_CODEC_FRAGMENT SUPPORT_YES

#if DEPLOY_ISO1_CODEC == SUPPORT_YES

#include <stdint.h>

#include "EXITypes.h"


/* Datatype definitions and structs for given XML Schema definitions */

#define UNION_YES 1
#define UNION_NO 2
#define SAVE_MEMORY_WITH_UNNAMED_UNION UNION_YES

/* Note: Please find below a list of occurrence limits that have been applied */
/* Limit occurrence of element "http://www.w3.org/2000/09/xmldsig#":X509IssuerSerial from unbounded to 1 (see #define iso1X509DataType_X509IssuerSerial_ARRAY_SIZE) */
/* Limit occurrence of element "http://www.w3.org/2000/09/xmldsig#":X509SKI from unbounded to 1 (see #define iso1X509DataType_X509SKI_ARRAY_SIZE) */
/* Limit occurrence of element "http://www.w3.org/2000/09/xmldsig#":X509SubjectName from unbounded to 1 (see #define iso1X509DataType_X509SubjectName_ARRAY_SIZE) */
/* Limit occurrence of element "http://www.w3.org/2000/09/xmldsig#":X509Certificate from unbounded to 1 (see #define iso1X509DataType_X509Certificate_ARRAY_SIZE) */
/* Limit occurrence of element "http://www.w3.org/2000/09/xmldsig#":X509CRL from unbounded to 1 (see #define iso1X509DataType_X509CRL_ARRAY_SIZE) */
/* Limit occurrence of element "http://www.w3.org/2000/09/xmldsig#":XPath from unbounded to 1 (see #define iso1TransformType_XPath_ARRAY_SIZE) */
/* Limit occurrence of element "http://www.w3.org/2000/09/xmldsig#":SPKISexp from unbounded to 1 (see #define iso1SPKIDataType_SPKISexp_ARRAY_SIZE) */
/* Limit occurrence of element "urn:iso:15118:2:2013:MsgDataTypes":RootCertificateID from unbounded to 5 (see #define iso1ListOfRootCertificateIDsType_RootCertificateID_ARRAY_SIZE) */
/* Limit occurrence of element "http://www.w3.org/2000/09/xmldsig#":Transform from unbounded to 1 (see #define iso1TransformsType_Transform_ARRAY_SIZE) */
/* Limit occurrence of element "http://www.w3.org/2000/09/xmldsig#":SignatureProperty from unbounded to 1 (see #define iso1SignaturePropertiesType_SignatureProperty_ARRAY_SIZE) */
/* Limit occurrence of element "http://www.w3.org/2000/09/xmldsig#":Reference from unbounded to 1 (see #define iso1SignedInfoType_Reference_ARRAY_SIZE) */
/* Limit occurrence of element "http://www.w3.org/2000/09/xmldsig#":Reference from unbounded to 1 (see #define iso1ManifestType_Reference_ARRAY_SIZE) */
/* Limit occurrence of element "urn:iso:15118:2:2013:MsgDataTypes":PMaxScheduleEntry from unbounded to 5 (see #define iso1PMaxScheduleType_PMaxScheduleEntry_ARRAY_SIZE) */
/* Limit occurrence of element "http://www.w3.org/2000/09/xmldsig#":KeyName from unbounded to 1 (see #define iso1KeyInfoType_KeyName_ARRAY_SIZE) */
/* Limit occurrence of element "http://www.w3.org/2000/09/xmldsig#":KeyValue from unbounded to 1 (see #define iso1KeyInfoType_KeyValue_ARRAY_SIZE) */
/* Limit occurrence of element "http://www.w3.org/2000/09/xmldsig#":RetrievalMethod from unbounded to 1 (see #define iso1KeyInfoType_RetrievalMethod_ARRAY_SIZE) */
/* Limit occurrence of element "http://www.w3.org/2000/09/xmldsig#":X509Data from unbounded to 1 (see #define iso1KeyInfoType_X509Data_ARRAY_SIZE) */
/* Limit occurrence of element "http://www.w3.org/2000/09/xmldsig#":PGPData from unbounded to 1 (see #define iso1KeyInfoType_PGPData_ARRAY_SIZE) */
/* Limit occurrence of element "http://www.w3.org/2000/09/xmldsig#":SPKIData from unbounded to 1 (see #define iso1KeyInfoType_SPKIData_ARRAY_SIZE) */
/* Limit occurrence of element "http://www.w3.org/2000/09/xmldsig#":MgmtData from unbounded to 1 (see #define iso1KeyInfoType_MgmtData_ARRAY_SIZE) */
/* Limit occurrence of element "urn:iso:15118:2:2013:MsgDataTypes":SalesTariffEntry from unbounded to 5 (see #define iso1SalesTariffType_SalesTariffEntry_ARRAY_SIZE) */
/* Limit occurrence of element "http://www.w3.org/2000/09/xmldsig#":Object from unbounded to 1 (see #define iso1SignatureType_Object_ARRAY_SIZE) */
/* Limit occurrence of element "urn:iso:15118:2:2013:MsgDataTypes":ParameterSet from unbounded to 5 (see #define iso1ServiceParameterListType_ParameterSet_ARRAY_SIZE) */


/* Complex type name='urn:iso:15118:2:2013:MsgDataTypes,EVChargeParameterType',  base type name='anyType',  content type='ELEMENT',  isAbstract='true',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2013:MsgDataTypes":DepartureTime{0-1})',  derivedBy='RESTRICTION'.  */
struct iso1EVChargeParameterType {
	/* element: "urn:iso:15118:2:2013:MsgDataTypes":DepartureTime, http://www.w3.org/2001/XMLSchema,unsignedInt */
	uint32_t DepartureTime ;
	unsigned int DepartureTime_isUsed:1;
};

/* Complex type name='urn:iso:15118:2:2013:MsgDataTypes,DiffieHellmanPublickeyType',  base type name='dHpublickeyType',  content type='SIMPLE',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  derivedBy='EXTENSION'.  */
#define iso1DiffieHellmanPublickeyType_Id_CHARACTERS_SIZE 50 + EXTRA_CHAR 
#define iso1DiffieHellmanPublickeyType_CONTENT_BYTES_SIZE 350
struct iso1DiffieHellmanPublickeyType {
	/* attribute: Id {http://www.w3.org/2001/XMLSchema,ID} */
	struct {
		exi_string_character_t characters[iso1DiffieHellmanPublickeyType_Id_CHARACTERS_SIZE];
		uint16_t charactersLen;
	}  Id ;
	/* simple content: urn:iso:15118:2:2013:MsgDataTypes,dHpublickeyType */
	struct {
		uint8_t bytes[iso1DiffieHellmanPublickeyType_CONTENT_BYTES_SIZE];
		uint16_t bytesLen;
	}  CONTENT ;
};

/* Complex type name='urn:iso:15118:2:2013:MsgDataTypes,SASchedulesType',  base type name='anyType',  content type='EMPTY',  isAbstract='true',  hasTypeId='false',  final='0',  block='0',  derivedBy='RESTRICTION'.  */
struct iso1SASchedulesType {
	int noContent; /* avoid warning */
};

typedef enum {
	iso1DC_EVErrorCodeType_NO_ERROR = 0,
	iso1DC_EVErrorCodeType_FAILED_RESSTemperatureInhibit = 1,
	iso1DC_EVErrorCodeType_FAILED_EVShiftPosition = 2,
	iso1DC_EVErrorCodeType_FAILED_ChargerConnectorLockFault = 3,
	iso1DC_EVErrorCodeType_FAILED_EVRESSMalfunction = 4,
	iso1DC_EVErrorCodeType_FAILED_ChargingCurrentdifferential = 5,
	iso1DC_EVErrorCodeType_FAILED_ChargingVoltageOutOfRange = 6,
	iso1DC_EVErrorCodeType_Reserved_A = 7,
	iso1DC_EVErrorCodeType_Reserved_B = 8,
	iso1DC_EVErrorCodeType_Reserved_C = 9,
	iso1DC_EVErrorCodeType_FAILED_ChargingSystemIncompatibility = 10,
	iso1DC_EVErrorCodeType_NoData = 11
} iso1DC_EVErrorCodeType;

typedef enum {
	iso1EVSENotificationType_None = 0,
	iso1EVSENotificationType_StopCharging = 1,
	iso1EVSENotificationType_ReNegotiation = 2
} iso1EVSENotificationType;

typedef enum {
	iso1responseCodeType_OK = 0,
	iso1responseCodeType_OK_NewSessionEstablished = 1,
	iso1responseCodeType_OK_OldSessionJoined = 2,
	iso1responseCodeType_OK_CertificateExpiresSoon = 3,
	iso1responseCodeType_FAILED = 4,
	iso1responseCodeType_FAILED_SequenceError = 5,
	iso1responseCodeType_FAILED_ServiceIDInvalid = 6,
	iso1responseCodeType_FAILED_UnknownSession = 7,
	iso1responseCodeType_FAILED_ServiceSelectionInvalid = 8,
	iso1responseCodeType_FAILED_PaymentSelectionInvalid = 9,
	iso1responseCodeType_FAILED_CertificateExpired = 10,
	iso1responseCodeType_FAILED_SignatureError = 11,
	iso1responseCodeType_FAILED_NoCertificateAvailable = 12,
	iso1responseCodeType_FAILED_CertChainError = 13,
	iso1responseCodeType_FAILED_ChallengeInvalid = 14,
	iso1responseCodeType_FAILED_ContractCanceled = 15,
	iso1responseCodeType_FAILED_WrongChargeParameter = 16,
	iso1responseCodeType_FAILED_PowerDeliveryNotApplied = 17,
	iso1responseCodeType_FAILED_TariffSelectionInvalid = 18,
	iso1responseCodeType_FAILED_ChargingProfileInvalid = 19,
	iso1responseCodeType_FAILED_MeteringSignatureNotValid = 20,
	iso1responseCodeType_FAILED_NoChargeServiceSelected = 21,
	iso1responseCodeType_FAILED_WrongEnergyTransferMode = 22,
	iso1responseCodeType_FAILED_ContactorError = 23,
	iso1responseCodeType_FAILED_CertificateNotAllowedAtThisEVSE = 24,
	iso1responseCodeType_FAILED_CertificateRevoked = 25
} iso1responseCodeType;

/* Complex type name='urn:iso:15118:2:2013:MsgBody,ServiceDetailReqType',  base type name='BodyBaseType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2013:MsgBody":ServiceID)',  derivedBy='EXTENSION'.  */
struct iso1ServiceDetailReqType {
	/* element: "urn:iso:15118:2:2013:MsgBody":ServiceID, urn:iso:15118:2:2013:MsgDataTypes,serviceIDType */
	uint16_t ServiceID ;
};

/* Complex type name='urn:iso:15118:2:2013:MsgDataTypes,RelativeTimeIntervalType',  base type name='IntervalType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2013:MsgDataTypes":start,"urn:iso:15118:2:2013:MsgDataTypes":duration{0-1})',  derivedBy='EXTENSION'.  */
struct iso1RelativeTimeIntervalType {
	/* element: "urn:iso:15118:2:2013:MsgDataTypes":start, urn:iso:15118:2:2013:MsgDataTypes,#AnonType_startRelativeTimeIntervalType */
	uint32_t start ;
	/* element: "urn:iso:15118:2:2013:MsgDataTypes":duration, urn:iso:15118:2:2013:MsgDataTypes,#AnonType_durationRelativeTimeIntervalType */
	uint32_t duration ;
	unsigned int duration_isUsed:1;
};

/* Complex type name='urn:iso:15118:2:2013:MsgDataTypes,EMAIDType',  base type name='eMAIDType',  content type='SIMPLE',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  derivedBy='EXTENSION'.  */
#define iso1EMAIDType_Id_CHARACTERS_SIZE 50 + EXTRA_CHAR 
#define iso1EMAIDType_CONTENT_CHARACTERS_SIZE 50 + EXTRA_CHAR 
struct iso1EMAIDType {
	/* attribute: Id {http://www.w3.org/2001/XMLSchema,ID} */
	struct {
		exi_string_character_t characters[iso1EMAIDType_Id_CHARACTERS_SIZE];
		uint16_t charactersLen;
	}  Id ;
	/* simple content: urn:iso:15118:2:2013:MsgDataTypes,eMAIDType */
	struct {
		exi_string_character_t characters[iso1EMAIDType_CONTENT_CHARACTERS_SIZE];
		uint16_t charactersLen;
	}  CONTENT ;
};

/* Complex type name='urn:iso:15118:2:2013:MsgDataTypes,EVStatusType',  base type name='anyType',  content type='EMPTY',  isAbstract='true',  hasTypeId='false',  final='0',  block='0',  derivedBy='RESTRICTION'.  */
struct iso1EVStatusType {
	int noContent; /* avoid warning */
};

/* Complex type name='urn:iso:15118:2:2013:MsgDataTypes,EVSEChargeParameterType',  base type name='anyType',  content type='EMPTY',  isAbstract='true',  hasTypeId='false',  final='0',  block='0',  derivedBy='RESTRICTION'.  */
struct iso1EVSEChargeParameterType {
	int noContent; /* avoid warning */
};

/* Complex type name='urn:iso:15118:2:2013:MsgDataTypes,EVPowerDeliveryParameterType',  base type name='anyType',  content type='EMPTY',  isAbstract='true',  hasTypeId='false',  final='0',  block='0',  derivedBy='RESTRICTION'.  */
struct iso1EVPowerDeliveryParameterType {
	int noContent; /* avoid warning */
};

/* Complex type name='urn:iso:15118:2:2013:MsgBody,AuthorizationReqType',  base type name='BodyBaseType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2013:MsgBody":GenChallenge{0-1})',  derivedBy='EXTENSION'.  */
#define iso1AuthorizationReqType_Id_CHARACTERS_SIZE 50 + EXTRA_CHAR 
#define iso1AuthorizationReqType_GenChallenge_BYTES_SIZE 16 /* XML schema facet length for urn:iso:15118:2:2013:MsgDataTypes,genChallengeType is 16 */
struct iso1AuthorizationReqType {
	/* attribute: Id {http://www.w3.org/2001/XMLSchema,ID} */
	struct {
		exi_string_character_t characters[iso1AuthorizationReqType_Id_CHARACTERS_SIZE];
		uint16_t charactersLen;
	}  Id ;
	unsigned int Id_isUsed:1;
	/* element: "urn:iso:15118:2:2013:MsgBody":GenChallenge, urn:iso:15118:2:2013:MsgDataTypes,genChallengeType */
	struct {
		uint8_t bytes[iso1AuthorizationReqType_GenChallenge_BYTES_SIZE];
		uint16_t bytesLen;
	}  GenChallenge ;
	unsigned int GenChallenge_isUsed:1;
};

/* Complex type name='urn:iso:15118:2:2013:MsgDataTypes,MeterInfoType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2013:MsgDataTypes":MeterID,"urn:iso:15118:2:2013:MsgDataTypes":MeterReading{0-1},"urn:iso:15118:2:2013:MsgDataTypes":SigMeterReading{0-1},"urn:iso:15118:2:2013:MsgDataTypes":MeterStatus{0-1},"urn:iso:15118:2:2013:MsgDataTypes":TMeter{0-1})',  derivedBy='RESTRICTION'.  */
#define iso1MeterInfoType_MeterID_CHARACTERS_SIZE 32 + EXTRA_CHAR /* XML schema facet maxLength for urn:iso:15118:2:2013:MsgDataTypes,meterIDType is 32 */
#define iso1MeterInfoType_SigMeterReading_BYTES_SIZE 64 /* XML schema facet maxLength for urn:iso:15118:2:2013:MsgDataTypes,sigMeterReadingType is 64 */
struct iso1MeterInfoType {
	/* element: "urn:iso:15118:2:2013:MsgDataTypes":MeterID, urn:iso:15118:2:2013:MsgDataTypes,meterIDType */
	struct {
		exi_string_character_t characters[iso1MeterInfoType_MeterID_CHARACTERS_SIZE];
		uint16_t charactersLen;
	}  MeterID ;
	/* element: "urn:iso:15118:2:2013:MsgDataTypes":MeterReading, http://www.w3.org/2001/XMLSchema,unsignedLong */
	uint64_t MeterReading ;
	unsigned int MeterReading_isUsed:1;
	/* element: "urn:iso:15118:2:2013:MsgDataTypes":SigMeterReading, urn:iso:15118:2:2013:MsgDataTypes,sigMeterReadingType */
	struct {
		uint8_t bytes[iso1MeterInfoType_SigMeterReading_BYTES_SIZE];
		uint16_t bytesLen;
	}  SigMeterReading ;
	unsigned int SigMeterReading_isUsed:1;
	/* element: "urn:iso:15118:2:2013:MsgDataTypes":MeterStatus, urn:iso:15118:2:2013:MsgDataTypes,meterStatusType */
	int16_t MeterStatus ;
	unsigned int MeterStatus_isUsed:1;
	/* element: "urn:iso:15118:2:2013:MsgDataTypes":TMeter, http://www.w3.org/2001/XMLSchema,long */
	int64_t TMeter ;
	unsigned int TMeter_isUsed:1;
};

/* Complex type name='http://www.w3.org/2000/09/xmldsig#,ObjectType',  base type name='anyType',  content type='MIXED',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='((WC[##any])){0-UNBOUNDED}',  derivedBy='RESTRICTION'.  */
#define iso1ObjectType_Id_CHARACTERS_SIZE 50 + EXTRA_CHAR 
#define iso1ObjectType_MimeType_CHARACTERS_SIZE 50 + EXTRA_CHAR 
#define iso1ObjectType_Encoding_CHARACTERS_SIZE 50 + EXTRA_CHAR 
#define iso1ObjectType_ANY_CHARACTERS_SIZE 50 + EXTRA_CHAR 
struct iso1ObjectType {
	/* attribute: Id {http://www.w3.org/2001/XMLSchema,ID} */
	struct {
		exi_string_character_t characters[iso1ObjectType_Id_CHARACTERS_SIZE];
		uint16_t charactersLen;
	}  Id ;
	unsigned int Id_isUsed:1;
	/* attribute: MimeType {http://www.w3.org/2001/XMLSchema,string} */
	struct {
		exi_string_character_t characters[iso1ObjectType_MimeType_CHARACTERS_SIZE];
		uint16_t charactersLen;
	}  MimeType ;
	unsigned int MimeType_isUsed:1;
	/* attribute: Encoding {http://www.w3.org/2001/XMLSchema,anyURI} */
	struct {
		exi_string_character_t characters[iso1ObjectType_Encoding_CHARACTERS_SIZE];
		uint16_t charactersLen;
	}  Encoding ;
	unsigned int Encoding_isUsed:1;
	/* element: WC[##any] */
	struct {
		exi_string_character_t characters[iso1ObjectType_ANY_CHARACTERS_SIZE];
		uint16_t charactersLen;
	}  ANY ;
	unsigned int ANY_isUsed:1;
};

/* Complex type name='http://www.w3.org/2000/09/xmldsig#,RSAKeyValueType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("http://www.w3.org/2000/09/xmldsig#":Modulus,"http://www.w3.org/2000/09/xmldsig#":Exponent)',  derivedBy='RESTRICTION'.  */
#define iso1RSAKeyValueType_Modulus_BYTES_SIZE 350 
#define iso1RSAKeyValueType_Exponent_BYTES_SIZE 350 
struct iso1RSAKeyValueType {
	/* element: "http://www.w3.org/2000/09/xmldsig#":Modulus, http://www.w3.org/2000/09/xmldsig#,CryptoBinary */
	struct {
		uint8_t bytes[iso1RSAKeyValueType_Modulus_BYTES_SIZE];
		uint16_t bytesLen;
	}  Modulus ;
	/* element: "http://www.w3.org/2000/09/xmldsig#":Exponent, http://www.w3.org/2000/09/xmldsig#,CryptoBinary */
	struct {
		uint8_t bytes[iso1RSAKeyValueType_Exponent_BYTES_SIZE];
		uint16_t bytesLen;
	}  Exponent ;
};

/* Complex type name='urn:iso:15118:2:2013:MsgBody,SessionStopResType',  base type name='BodyBaseType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2013:MsgBody":ResponseCode)',  derivedBy='EXTENSION'.  */
struct iso1SessionStopResType {
	/* element: "urn:iso:15118:2:2013:MsgBody":ResponseCode, urn:iso:15118:2:2013:MsgDataTypes,responseCodeType */
	iso1responseCodeType ResponseCode ;
};

/* Complex type name='http://www.w3.org/2000/09/xmldsig#,SignatureValueType',  base type name='base64Binary',  content type='SIMPLE',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  derivedBy='EXTENSION'.  */
#define iso1SignatureValueType_Id_CHARACTERS_SIZE 50 + EXTRA_CHAR 
#define iso1SignatureValueType_CONTENT_BYTES_SIZE 350
struct iso1SignatureValueType {
	/* attribute: Id {http://www.w3.org/2001/XMLSchema,ID} */
	struct {
		exi_string_character_t characters[iso1SignatureValueType_Id_CHARACTERS_SIZE];
		uint16_t charactersLen;
	}  Id ;
	unsigned int Id_isUsed:1;
	/* simple content: http://www.w3.org/2001/XMLSchema,base64Binary */
	struct {
		uint8_t bytes[iso1SignatureValueType_CONTENT_BYTES_SIZE];
		uint16_t bytesLen;
	}  CONTENT ;
};

/* Complex type name='urn:iso:15118:2:2013:MsgDataTypes,SubCertificatesType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2013:MsgDataTypes":Certificate{1-4})',  derivedBy='RESTRICTION'.  */
#define iso1SubCertificatesType_Certificate_BYTES_SIZE 800 /* XML schema facet maxLength for urn:iso:15118:2:2013:MsgDataTypes,certificateType is 800 */
#define iso1SubCertificatesType_Certificate_ARRAY_SIZE 4
struct iso1SubCertificatesType {
	/* element: "urn:iso:15118:2:2013:MsgDataTypes":Certificate, urn:iso:15118:2:2013:MsgDataTypes,certificateType */
	struct {
		struct {
		uint8_t bytes[iso1SubCertificatesType_Certificate_BYTES_SIZE];
		uint16_t bytesLen;
	}  array[iso1SubCertificatesType_Certificate_ARRAY_SIZE];
		uint16_t arrayLen;
	} Certificate;
};

typedef enum {
	iso1faultCodeType_ParsingError = 0,
	iso1faultCodeType_NoTLSRootCertificatAvailable = 1,
	iso1faultCodeType_UnknownError = 2
} iso1faultCodeType;

typedef enum {
	iso1DC_EVSEStatusCodeType_EVSE_NotReady = 0,
	iso1DC_EVSEStatusCodeType_EVSE_Ready = 1,
	iso1DC_EVSEStatusCodeType_EVSE_Shutdown = 2,
	iso1DC_EVSEStatusCodeType_EVSE_UtilityInterruptEvent = 3,
	iso1DC_EVSEStatusCodeType_EVSE_IsolationMonitoringActive = 4,
	iso1DC_EVSEStatusCodeType_EVSE_EmergencyShutdown = 5,
	iso1DC_EVSEStatusCodeType_EVSE_Malfunction = 6,
	iso1DC_EVSEStatusCodeType_Reserved_8 = 7,
	iso1DC_EVSEStatusCodeType_Reserved_9 = 8,
	iso1DC_EVSEStatusCodeType_Reserved_A = 9,
	iso1DC_EVSEStatusCodeType_Reserved_B = 10,
	iso1DC_EVSEStatusCodeType_Reserved_C = 11
} iso1DC_EVSEStatusCodeType;

/* Complex type name='http://www.w3.org/2000/09/xmldsig#,DSAKeyValueType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='(("http://www.w3.org/2000/09/xmldsig#":P,"http://www.w3.org/2000/09/xmldsig#":Q){0-1},"http://www.w3.org/2000/09/xmldsig#":G{0-1},"http://www.w3.org/2000/09/xmldsig#":Y,"http://www.w3.org/2000/09/xmldsig#":J{0-1},("http://www.w3.org/2000/09/xmldsig#":Seed,"http://www.w3.org/2000/09/xmldsig#":PgenCounter){0-1})',  derivedBy='RESTRICTION'.  */
#define iso1DSAKeyValueType_P_BYTES_SIZE 350 
#define iso1DSAKeyValueType_Q_BYTES_SIZE 350 
#define iso1DSAKeyValueType_G_BYTES_SIZE 350 
#define iso1DSAKeyValueType_Y_BYTES_SIZE 350 
#define iso1DSAKeyValueType_J_BYTES_SIZE 350 
#define iso1DSAKeyValueType_Seed_BYTES_SIZE 350 
#define iso1DSAKeyValueType_PgenCounter_BYTES_SIZE 350 
struct iso1DSAKeyValueType {
	/* element: "http://www.w3.org/2000/09/xmldsig#":P, http://www.w3.org/2000/09/xmldsig#,CryptoBinary */
	struct {
		uint8_t bytes[iso1DSAKeyValueType_P_BYTES_SIZE];
		uint16_t bytesLen;
	}  P ;
	unsigned int P_isUsed:1;
	/* element: "http://www.w3.org/2000/09/xmldsig#":Q, http://www.w3.org/2000/09/xmldsig#,CryptoBinary */
	struct {
		uint8_t bytes[iso1DSAKeyValueType_Q_BYTES_SIZE];
		uint16_t bytesLen;
	}  Q ;
	unsigned int Q_isUsed:1;
	/* element: "http://www.w3.org/2000/09/xmldsig#":G, http://www.w3.org/2000/09/xmldsig#,CryptoBinary */
	struct {
		uint8_t bytes[iso1DSAKeyValueType_G_BYTES_SIZE];
		uint16_t bytesLen;
	}  G ;
	unsigned int G_isUsed:1;
	/* element: "http://www.w3.org/2000/09/xmldsig#":Y, http://www.w3.org/2000/09/xmldsig#,CryptoBinary */
	struct {
		uint8_t bytes[iso1DSAKeyValueType_Y_BYTES_SIZE];
		uint16_t bytesLen;
	}  Y ;
	/* element: "http://www.w3.org/2000/09/xmldsig#":J, http://www.w3.org/2000/09/xmldsig#,CryptoBinary */
	struct {
		uint8_t bytes[iso1DSAKeyValueType_J_BYTES_SIZE];
		uint16_t bytesLen;
	}  J ;
	unsigned int J_isUsed:1;
	/* element: "http://www.w3.org/2000/09/xmldsig#":Seed, http://www.w3.org/2000/09/xmldsig#,CryptoBinary */
	struct {
		uint8_t bytes[iso1DSAKeyValueType_Seed_BYTES_SIZE];
		uint16_t bytesLen;
	}  Seed ;
	unsigned int Seed_isUsed:1;
	/* element: "http://www.w3.org/2000/09/xmldsig#":PgenCounter, http://www.w3.org/2000/09/xmldsig#,CryptoBinary */
	struct {
		uint8_t bytes[iso1DSAKeyValueType_PgenCounter_BYTES_SIZE];
		uint16_t bytesLen;
	}  PgenCounter ;
	unsigned int PgenCounter_isUsed:1;
};

typedef enum {
	iso1EVSEProcessingType_Finished = 0,
	iso1EVSEProcessingType_Ongoing = 1,
	iso1EVSEProcessingType_Ongoing_WaitingForCustomerInteraction = 2
} iso1EVSEProcessingType;

/* Complex type name='urn:iso:15118:2:2013:MsgDataTypes,IntervalType',  base type name='anyType',  content type='EMPTY',  isAbstract='true',  hasTypeId='false',  final='0',  block='0',  derivedBy='RESTRICTION'.  */
struct iso1IntervalType {
	int noContent; /* avoid warning */
};

/* Complex type name='urn:iso:15118:2:2013:MsgBody,MeteringReceiptReqType',  base type name='BodyBaseType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2013:MsgBody":SessionID,"urn:iso:15118:2:2013:MsgBody":SAScheduleTupleID{0-1},"urn:iso:15118:2:2013:MsgBody":MeterInfo)',  derivedBy='EXTENSION'.  */
#define iso1MeteringReceiptReqType_Id_CHARACTERS_SIZE 50 + EXTRA_CHAR 
#define iso1MeteringReceiptReqType_SessionID_BYTES_SIZE 8 /* XML schema facet maxLength for urn:iso:15118:2:2013:MsgDataTypes,sessionIDType is 8 */
struct iso1MeteringReceiptReqType {
	/* attribute: Id {http://www.w3.org/2001/XMLSchema,ID} */
	struct {
		exi_string_character_t characters[iso1MeteringReceiptReqType_Id_CHARACTERS_SIZE];
		uint16_t charactersLen;
	}  Id ;
	unsigned int Id_isUsed:1;
	/* element: "urn:iso:15118:2:2013:MsgBody":SessionID, urn:iso:15118:2:2013:MsgDataTypes,sessionIDType */
	struct {
		uint8_t bytes[iso1MeteringReceiptReqType_SessionID_BYTES_SIZE];
		uint16_t bytesLen;
	}  SessionID ;
	/* element: "urn:iso:15118:2:2013:MsgBody":SAScheduleTupleID, urn:iso:15118:2:2013:MsgDataTypes,SAIDType */
	uint8_t SAScheduleTupleID ;
	unsigned int SAScheduleTupleID_isUsed:1;
	/* element: "urn:iso:15118:2:2013:MsgBody":MeterInfo, Complex type name='urn:iso:15118:2:2013:MsgDataTypes,MeterInfoType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2013:MsgDataTypes":MeterID,"urn:iso:15118:2:2013:MsgDataTypes":MeterReading{0-1},"urn:iso:15118:2:2013:MsgDataTypes":SigMeterReading{0-1},"urn:iso:15118:2:2013:MsgDataTypes":MeterStatus{0-1},"urn:iso:15118:2:2013:MsgDataTypes":TMeter{0-1})',  derivedBy='RESTRICTION'.  */
	struct iso1MeterInfoType MeterInfo ;
};

/* Complex type name='http://www.w3.org/2000/09/xmldsig#,KeyValueType',  base type name='anyType',  content type='MIXED',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("http://www.w3.org/2000/09/xmldsig#":DSAKeyValue|"http://www.w3.org/2000/09/xmldsig#":RSAKeyValue|(WC[##other:"http://www.w3.org/2000/09/xmldsig#"]))',  derivedBy='RESTRICTION'.  */
#define iso1KeyValueType_ANY_CHARACTERS_SIZE 50 + EXTRA_CHAR 
struct iso1KeyValueType {
	/* element: "http://www.w3.org/2000/09/xmldsig#":DSAKeyValue, Complex type name='http://www.w3.org/2000/09/xmldsig#,DSAKeyValueType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='(("http://www.w3.org/2000/09/xmldsig#":P,"http://www.w3.org/2000/09/xmldsig#":Q){0-1},"http://www.w3.org/2000/09/xmldsig#":G{0-1},"http://www.w3.org/2000/09/xmldsig#":Y,"http://www.w3.org/2000/09/xmldsig#":J{0-1},("http://www.w3.org/2000/09/xmldsig#":Seed,"http://www.w3.org/2000/09/xmldsig#":PgenCounter){0-1})',  derivedBy='RESTRICTION'.  */
	struct iso1DSAKeyValueType DSAKeyValue ;
	unsigned int DSAKeyValue_isUsed:1;
	/* element: "http://www.w3.org/2000/09/xmldsig#":RSAKeyValue, Complex type name='http://www.w3.org/2000/09/xmldsig#,RSAKeyValueType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("http://www.w3.org/2000/09/xmldsig#":Modulus,"http://www.w3.org/2000/09/xmldsig#":Exponent)',  derivedBy='RESTRICTION'.  */
	struct iso1RSAKeyValueType RSAKeyValue ;
	unsigned int RSAKeyValue_isUsed:1;
	/* element: WC[##other:"http://www.w3.org/2000/09/xmldsig#"] */
	struct {
		exi_string_character_t characters[iso1KeyValueType_ANY_CHARACTERS_SIZE];
		uint16_t charactersLen;
	}  ANY ;
	unsigned int ANY_isUsed:1;
};

/* Complex type name='http://www.w3.org/2000/09/xmldsig#,X509IssuerSerialType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("http://www.w3.org/2000/09/xmldsig#":X509IssuerName,"http://www.w3.org/2000/09/xmldsig#":X509SerialNumber)',  derivedBy='RESTRICTION'.  */
#define iso1X509IssuerSerialType_X509IssuerName_CHARACTERS_SIZE 50 + EXTRA_CHAR 
struct iso1X509IssuerSerialType {
	/* element: "http://www.w3.org/2000/09/xmldsig#":X509IssuerName, http://www.w3.org/2001/XMLSchema,string */
	struct {
		exi_string_character_t characters[iso1X509IssuerSerialType_X509IssuerName_CHARACTERS_SIZE];
		uint16_t charactersLen;
	}  X509IssuerName ;
	/* element: "http://www.w3.org/2000/09/xmldsig#":X509SerialNumber, http://www.w3.org/2001/XMLSchema,integer */
	int64_t X509SerialNumber ;
};

typedef enum {
	iso1chargingSessionType_Terminate = 0,
	iso1chargingSessionType_Pause = 1
} iso1chargingSessionType;

/* Complex type name='urn:iso:15118:2:2013:MsgDataTypes,EVSEStatusType',  base type name='anyType',  content type='ELEMENT',  isAbstract='true',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2013:MsgDataTypes":NotificationMaxDelay,"urn:iso:15118:2:2013:MsgDataTypes":EVSENotification)',  derivedBy='RESTRICTION'.  */
struct iso1EVSEStatusType {
	/* element: "urn:iso:15118:2:2013:MsgDataTypes":NotificationMaxDelay, http://www.w3.org/2001/XMLSchema,unsignedShort */
	uint16_t NotificationMaxDelay ;
	/* element: "urn:iso:15118:2:2013:MsgDataTypes":EVSENotification, urn:iso:15118:2:2013:MsgDataTypes,EVSENotificationType */
	iso1EVSENotificationType EVSENotification ;
};

/* Complex type name='http://www.w3.org/2000/09/xmldsig#,SignatureMethodType',  base type name='anyType',  content type='MIXED',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("http://www.w3.org/2000/09/xmldsig#":HMACOutputLength{0-1},(WC[##other:"http://www.w3.org/2000/09/xmldsig#"]){0-UNBOUNDED})',  derivedBy='RESTRICTION'.  */
#define iso1SignatureMethodType_Algorithm_CHARACTERS_SIZE 65 + EXTRA_CHAR 
#define iso1SignatureMethodType_ANY_CHARACTERS_SIZE 50 + EXTRA_CHAR 
struct iso1SignatureMethodType {
	/* attribute: Algorithm {http://www.w3.org/2001/XMLSchema,anyURI} */
	struct {
		exi_string_character_t characters[iso1SignatureMethodType_Algorithm_CHARACTERS_SIZE];
		uint16_t charactersLen;
	}  Algorithm ;
	/* element: "http://www.w3.org/2000/09/xmldsig#":HMACOutputLength, http://www.w3.org/2000/09/xmldsig#,HMACOutputLengthType */
	int64_t HMACOutputLength ;
	unsigned int HMACOutputLength_isUsed:1;
	/* element: WC[##other:"http://www.w3.org/2000/09/xmldsig#"] */
	struct {
		exi_string_character_t characters[iso1SignatureMethodType_ANY_CHARACTERS_SIZE];
		uint16_t charactersLen;
	}  ANY ;
	unsigned int ANY_isUsed:1;
};

/* Complex type name='http://www.w3.org/2000/09/xmldsig#,X509DataType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='(("http://www.w3.org/2000/09/xmldsig#":X509IssuerSerial|"http://www.w3.org/2000/09/xmldsig#":X509SKI|"http://www.w3.org/2000/09/xmldsig#":X509SubjectName|"http://www.w3.org/2000/09/xmldsig#":X509Certificate|"http://www.w3.org/2000/09/xmldsig#":X509CRL|(WC[##other:"http://www.w3.org/2000/09/xmldsig#"]))){1-UNBOUNDED}',  derivedBy='RESTRICTION'.  */
#define iso1X509DataType_X509IssuerSerial_ARRAY_SIZE 1
#define iso1X509DataType_X509SKI_BYTES_SIZE 350 
#define iso1X509DataType_X509SKI_ARRAY_SIZE 1
#define iso1X509DataType_X509SubjectName_CHARACTERS_SIZE 50 + EXTRA_CHAR 
#define iso1X509DataType_X509SubjectName_ARRAY_SIZE 1
#define iso1X509DataType_X509Certificate_BYTES_SIZE 350 
#define iso1X509DataType_X509Certificate_ARRAY_SIZE 1
#define iso1X509DataType_X509CRL_BYTES_SIZE 350 
#define iso1X509DataType_X509CRL_ARRAY_SIZE 1
#define iso1X509DataType_ANY_CHARACTERS_SIZE 50 + EXTRA_CHAR 
struct iso1X509DataType {
	/* element: "http://www.w3.org/2000/09/xmldsig#":X509IssuerSerial, Complex type name='http://www.w3.org/2000/09/xmldsig#,X509IssuerSerialType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("http://www.w3.org/2000/09/xmldsig#":X509IssuerName,"http://www.w3.org/2000/09/xmldsig#":X509SerialNumber)',  derivedBy='RESTRICTION'.  */
	struct {
		struct iso1X509IssuerSerialType array[iso1X509DataType_X509IssuerSerial_ARRAY_SIZE];
		uint16_t arrayLen;
	} X509IssuerSerial;
	/* element: "http://www.w3.org/2000/09/xmldsig#":X509SKI, http://www.w3.org/2001/XMLSchema,base64Binary */
	struct {
		struct {
			uint8_t bytes[iso1X509DataType_X509SKI_BYTES_SIZE];
			uint16_t bytesLen;
		}  array[iso1X509DataType_X509SKI_ARRAY_SIZE];
		uint16_t arrayLen;
	} X509SKI;
	/* element: "http://www.w3.org/2000/09/xmldsig#":X509SubjectName, http://www.w3.org/2001/XMLSchema,string */
	struct {
		struct {
			exi_string_character_t characters[iso1X509DataType_X509SubjectName_CHARACTERS_SIZE];
			uint16_t charactersLen;
		}  array[iso1X509DataType_X509SubjectName_ARRAY_SIZE];
		uint16_t arrayLen;
	} X509SubjectName;
	/* element: "http://www.w3.org/2000/09/xmldsig#":X509Certificate, http://www.w3.org/2001/XMLSchema,base64Binary */
	struct {
		struct {
			uint8_t bytes[iso1X509DataType_X509Certificate_BYTES_SIZE];
			uint16_t bytesLen;
		}  array[iso1X509DataType_X509Certificate_ARRAY_SIZE];
		uint16_t arrayLen;
	} X509Certificate;
	/* element: "http://www.w3.org/2000/09/xmldsig#":X509CRL, http://www.w3.org/2001/XMLSchema,base64Binary */
	struct {
		struct {
			uint8_t bytes[iso1X509DataType_X509CRL_BYTES_SIZE];
			uint16_t bytesLen;
		}  array[iso1X509DataType_X509CRL_ARRAY_SIZE];
		uint16_t arrayLen;
	} X509CRL;
	/* element: WC[##other:"http://www.w3.org/2000/09/xmldsig#"] */
	struct {
		exi_string_character_t characters[iso1X509DataType_ANY_CHARACTERS_SIZE];
		uint16_t charactersLen;
	}  ANY ;
	unsigned int ANY_isUsed:1;
};

typedef enum {
	iso1serviceCategoryType_EVCharging = 0,
	iso1serviceCategoryType_Internet = 1,
	iso1serviceCategoryType_ContractCertificate = 2,
	iso1serviceCategoryType_OtherCustom = 3
} iso1serviceCategoryType;

typedef enum {
	iso1paymentOptionType_Contract = 0,
	iso1paymentOptionType_ExternalPayment = 1
} iso1paymentOptionType;

typedef enum {
	iso1EnergyTransferModeType_AC_single_phase_core = 0,
	iso1EnergyTransferModeType_AC_three_phase_core = 1,
	iso1EnergyTransferModeType_DC_core = 2,
	iso1EnergyTransferModeType_DC_extended = 3,
	iso1EnergyTransferModeType_DC_combo_core = 4,
	iso1EnergyTransferModeType_DC_unique = 5
} iso1EnergyTransferModeType;

/* Complex type name='urn:iso:15118:2:2013:MsgDataTypes,NotificationType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2013:MsgDataTypes":FaultCode,"urn:iso:15118:2:2013:MsgDataTypes":FaultMsg{0-1})',  derivedBy='RESTRICTION'.  */
#define iso1NotificationType_FaultMsg_CHARACTERS_SIZE 64 + EXTRA_CHAR /* XML schema facet maxLength for urn:iso:15118:2:2013:MsgDataTypes,faultMsgType is 64 */
struct iso1NotificationType {
	/* element: "urn:iso:15118:2:2013:MsgDataTypes":FaultCode, urn:iso:15118:2:2013:MsgDataTypes,faultCodeType */
	iso1faultCodeType FaultCode ;
	/* element: "urn:iso:15118:2:2013:MsgDataTypes":FaultMsg, urn:iso:15118:2:2013:MsgDataTypes,faultMsgType */
	struct {
		exi_string_character_t characters[iso1NotificationType_FaultMsg_CHARACTERS_SIZE];
		uint16_t charactersLen;
	}  FaultMsg ;
	unsigned int FaultMsg_isUsed:1;
};

/* Complex type name='http://www.w3.org/2000/09/xmldsig#,TransformType',  base type name='anyType',  content type='MIXED',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='((WC[##other:"http://www.w3.org/2000/09/xmldsig#"])|"http://www.w3.org/2000/09/xmldsig#":XPath){0-UNBOUNDED}',  derivedBy='RESTRICTION'.  */
#define iso1TransformType_Algorithm_CHARACTERS_SIZE 65 + EXTRA_CHAR 
#define iso1TransformType_ANY_CHARACTERS_SIZE 50 + EXTRA_CHAR 
#define iso1TransformType_XPath_CHARACTERS_SIZE 50 + EXTRA_CHAR 
#define iso1TransformType_XPath_ARRAY_SIZE 1
struct iso1TransformType {
	/* attribute: Algorithm {http://www.w3.org/2001/XMLSchema,anyURI} */
	struct {
		exi_string_character_t characters[iso1TransformType_Algorithm_CHARACTERS_SIZE];
		uint16_t charactersLen;
	}  Algorithm ;
	/* element: WC[##other:"http://www.w3.org/2000/09/xmldsig#"] */
	struct {
		exi_string_character_t characters[iso1TransformType_ANY_CHARACTERS_SIZE];
		uint16_t charactersLen;
	}  ANY ;
	unsigned int ANY_isUsed:1;
	/* element: "http://www.w3.org/2000/09/xmldsig#":XPath, http://www.w3.org/2001/XMLSchema,string */
	struct {
		struct {
			exi_string_character_t characters[iso1TransformType_XPath_CHARACTERS_SIZE];
			uint16_t charactersLen;
		}  array[iso1TransformType_XPath_ARRAY_SIZE];
		uint16_t arrayLen;
	} XPath;
};

/* Complex type name='urn:iso:15118:2:2013:MsgBody,PaymentDetailsResType',  base type name='BodyBaseType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2013:MsgBody":ResponseCode,"urn:iso:15118:2:2013:MsgBody":GenChallenge,"urn:iso:15118:2:2013:MsgBody":EVSETimeStamp)',  derivedBy='EXTENSION'.  */
#define iso1PaymentDetailsResType_GenChallenge_BYTES_SIZE 16 /* XML schema facet length for urn:iso:15118:2:2013:MsgDataTypes,genChallengeType is 16 */
struct iso1PaymentDetailsResType {
	/* element: "urn:iso:15118:2:2013:MsgBody":ResponseCode, urn:iso:15118:2:2013:MsgDataTypes,responseCodeType */
	iso1responseCodeType ResponseCode ;
	/* element: "urn:iso:15118:2:2013:MsgBody":GenChallenge, urn:iso:15118:2:2013:MsgDataTypes,genChallengeType */
	struct {
		uint8_t bytes[iso1PaymentDetailsResType_GenChallenge_BYTES_SIZE];
		uint16_t bytesLen;
	}  GenChallenge ;
	/* element: "urn:iso:15118:2:2013:MsgBody":EVSETimeStamp, http://www.w3.org/2001/XMLSchema,long */
	int64_t EVSETimeStamp ;
};

/* Complex type name='urn:iso:15118:2:2013:MsgDataTypes,ContractSignatureEncryptedPrivateKeyType',  base type name='privateKeyType',  content type='SIMPLE',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  derivedBy='EXTENSION'.  */
#define iso1ContractSignatureEncryptedPrivateKeyType_Id_CHARACTERS_SIZE 50 + EXTRA_CHAR 
#define iso1ContractSignatureEncryptedPrivateKeyType_CONTENT_BYTES_SIZE 350
struct iso1ContractSignatureEncryptedPrivateKeyType {
	/* attribute: Id {http://www.w3.org/2001/XMLSchema,ID} */
	struct {
		exi_string_character_t characters[iso1ContractSignatureEncryptedPrivateKeyType_Id_CHARACTERS_SIZE];
		uint16_t charactersLen;
	}  Id ;
	/* simple content: urn:iso:15118:2:2013:MsgDataTypes,privateKeyType */
	struct {
		uint8_t bytes[iso1ContractSignatureEncryptedPrivateKeyType_CONTENT_BYTES_SIZE];
		uint16_t bytesLen;
	}  CONTENT ;
};

/* Complex type name='http://www.w3.org/2000/09/xmldsig#,SPKIDataType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("http://www.w3.org/2000/09/xmldsig#":SPKISexp,(WC[##other:"http://www.w3.org/2000/09/xmldsig#"]){0-1}){1-UNBOUNDED}',  derivedBy='RESTRICTION'.  */
#define iso1SPKIDataType_SPKISexp_BYTES_SIZE 350 
#define iso1SPKIDataType_SPKISexp_ARRAY_SIZE 1
#define iso1SPKIDataType_ANY_CHARACTERS_SIZE 50 + EXTRA_CHAR 
struct iso1SPKIDataType {
	/* element: "http://www.w3.org/2000/09/xmldsig#":SPKISexp, http://www.w3.org/2001/XMLSchema,base64Binary */
	struct {
		struct {
			uint8_t bytes[iso1SPKIDataType_SPKISexp_BYTES_SIZE];
			uint16_t bytesLen;
		}  array[iso1SPKIDataType_SPKISexp_ARRAY_SIZE];
		uint16_t arrayLen;
	} SPKISexp;
	/* element: WC[##other:"http://www.w3.org/2000/09/xmldsig#"] */
	struct {
		exi_string_character_t characters[iso1SPKIDataType_ANY_CHARACTERS_SIZE];
		uint16_t charactersLen;
	}  ANY ;
	unsigned int ANY_isUsed:1;
};

/* Complex type name='urn:iso:15118:2:2013:MsgBody,SessionStopReqType',  base type name='BodyBaseType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2013:MsgBody":ChargingSession)',  derivedBy='EXTENSION'.  */
struct iso1SessionStopReqType {
	/* element: "urn:iso:15118:2:2013:MsgBody":ChargingSession, urn:iso:15118:2:2013:MsgDataTypes,chargingSessionType */
	iso1chargingSessionType ChargingSession ;
};

/* Complex type name='urn:iso:15118:2:2013:MsgDataTypes,EntryType',  base type name='anyType',  content type='ELEMENT',  isAbstract='true',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2013:MsgDataTypes":TimeInterval)',  derivedBy='RESTRICTION'.  */
struct iso1EntryType {
	/* substitutionGroup */
#if SAVE_MEMORY_WITH_UNNAMED_UNION == UNION_YES
	union {
#endif /* SAVE_MEMORY_WITH_UNNAMED_UNION == UNION_YES */ 
		/* element: "urn:iso:15118:2:2013:MsgDataTypes":TimeInterval, Complex type name='urn:iso:15118:2:2013:MsgDataTypes,IntervalType',  base type name='anyType',  content type='EMPTY',  isAbstract='true',  hasTypeId='false',  final='0',  block='0',  derivedBy='RESTRICTION'.  */
		struct iso1IntervalType TimeInterval ;
		/* element: "urn:iso:15118:2:2013:MsgDataTypes":RelativeTimeInterval, Complex type name='urn:iso:15118:2:2013:MsgDataTypes,RelativeTimeIntervalType',  base type name='IntervalType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2013:MsgDataTypes":start,"urn:iso:15118:2:2013:MsgDataTypes":duration{0-1})',  derivedBy='EXTENSION'.  */
		struct iso1RelativeTimeIntervalType RelativeTimeInterval ;
#if SAVE_MEMORY_WITH_UNNAMED_UNION == UNION_YES
	};
#endif /* SAVE_MEMORY_WITH_UNNAMED_UNION == UNION_YES */ 
		unsigned int TimeInterval_isUsed:1;
		unsigned int RelativeTimeInterval_isUsed:1;
};

/* Complex type name='urn:iso:15118:2:2013:MsgBody,SessionSetupReqType',  base type name='BodyBaseType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2013:MsgBody":EVCCID)',  derivedBy='EXTENSION'.  */
#define iso1SessionSetupReqType_EVCCID_BYTES_SIZE 6 /* XML schema facet maxLength for urn:iso:15118:2:2013:MsgDataTypes,evccIDType is 6 */
struct iso1SessionSetupReqType {
	/* element: "urn:iso:15118:2:2013:MsgBody":EVCCID, urn:iso:15118:2:2013:MsgDataTypes,evccIDType */
	struct {
		uint8_t bytes[iso1SessionSetupReqType_EVCCID_BYTES_SIZE];
		uint16_t bytesLen;
	}  EVCCID ;
};

typedef enum {
	iso1isolationLevelType_Invalid = 0,
	iso1isolationLevelType_Valid = 1,
	iso1isolationLevelType_Warning = 2,
	iso1isolationLevelType_Fault = 3,
	iso1isolationLevelType_No_IMD = 4
} iso1isolationLevelType;

/* Complex type name='http://www.w3.org/2000/09/xmldsig#,CanonicalizationMethodType',  base type name='anyType',  content type='MIXED',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='((WC[##any]){0-UNBOUNDED})',  derivedBy='RESTRICTION'.  */
#define iso1CanonicalizationMethodType_Algorithm_CHARACTERS_SIZE 65 + EXTRA_CHAR 
#define iso1CanonicalizationMethodType_ANY_CHARACTERS_SIZE 50 + EXTRA_CHAR 
struct iso1CanonicalizationMethodType {
	/* attribute: Algorithm {http://www.w3.org/2001/XMLSchema,anyURI} */
	struct {
		exi_string_character_t characters[iso1CanonicalizationMethodType_Algorithm_CHARACTERS_SIZE];
		uint16_t charactersLen;
	}  Algorithm ;
	/* element: WC[##any] */
	struct {
		exi_string_character_t characters[iso1CanonicalizationMethodType_ANY_CHARACTERS_SIZE];
		uint16_t charactersLen;
	}  ANY ;
	unsigned int ANY_isUsed:1;
};

/* Complex type name='urn:iso:15118:2:2013:MsgDataTypes,DC_EVStatusType',  base type name='EVStatusType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2013:MsgDataTypes":EVReady,"urn:iso:15118:2:2013:MsgDataTypes":EVErrorCode,"urn:iso:15118:2:2013:MsgDataTypes":EVRESSSOC)',  derivedBy='EXTENSION'.  */
struct iso1DC_EVStatusType {
	/* element: "urn:iso:15118:2:2013:MsgDataTypes":EVReady, http://www.w3.org/2001/XMLSchema,boolean */
	int EVReady ;
	/* element: "urn:iso:15118:2:2013:MsgDataTypes":EVErrorCode, urn:iso:15118:2:2013:MsgDataTypes,DC_EVErrorCodeType */
	iso1DC_EVErrorCodeType EVErrorCode ;
	/* element: "urn:iso:15118:2:2013:MsgDataTypes":EVRESSSOC, urn:iso:15118:2:2013:MsgDataTypes,percentValueType */
	int8_t EVRESSSOC ;
};

typedef enum {
	iso1costKindType_relativePricePercentage = 0,
	iso1costKindType_RenewableGenerationPercentage = 1,
	iso1costKindType_CarbonDioxideEmission = 2
} iso1costKindType;

/* Complex type name='urn:iso:15118:2:2013:MsgDataTypes,ServiceType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2013:MsgDataTypes":ServiceID,"urn:iso:15118:2:2013:MsgDataTypes":ServiceName{0-1},"urn:iso:15118:2:2013:MsgDataTypes":ServiceCategory,"urn:iso:15118:2:2013:MsgDataTypes":ServiceScope{0-1},"urn:iso:15118:2:2013:MsgDataTypes":FreeService)',  derivedBy='RESTRICTION'.  */
#define iso1ServiceType_ServiceName_CHARACTERS_SIZE 32 + EXTRA_CHAR /* XML schema facet maxLength for urn:iso:15118:2:2013:MsgDataTypes,serviceNameType is 32 */
#define iso1ServiceType_ServiceScope_CHARACTERS_SIZE 64 + EXTRA_CHAR /* XML schema facet maxLength for urn:iso:15118:2:2013:MsgDataTypes,serviceScopeType is 64 */
struct iso1ServiceType {
	/* element: "urn:iso:15118:2:2013:MsgDataTypes":ServiceID, urn:iso:15118:2:2013:MsgDataTypes,serviceIDType */
	uint16_t ServiceID ;
	/* element: "urn:iso:15118:2:2013:MsgDataTypes":ServiceName, urn:iso:15118:2:2013:MsgDataTypes,serviceNameType */
	struct {
		exi_string_character_t characters[iso1ServiceType_ServiceName_CHARACTERS_SIZE];
		uint16_t charactersLen;
	}  ServiceName ;
	unsigned int ServiceName_isUsed:1;
	/* element: "urn:iso:15118:2:2013:MsgDataTypes":ServiceCategory, urn:iso:15118:2:2013:MsgDataTypes,serviceCategoryType */
	iso1serviceCategoryType ServiceCategory ;
	/* element: "urn:iso:15118:2:2013:MsgDataTypes":ServiceScope, urn:iso:15118:2:2013:MsgDataTypes,serviceScopeType */
	struct {
		exi_string_character_t characters[iso1ServiceType_ServiceScope_CHARACTERS_SIZE];
		uint16_t charactersLen;
	}  ServiceScope ;
	unsigned int ServiceScope_isUsed:1;
	/* element: "urn:iso:15118:2:2013:MsgDataTypes":FreeService, http://www.w3.org/2001/XMLSchema,boolean */
	int FreeService ;
};

/* Complex type name='urn:iso:15118:2:2013:MsgBody,ServiceDiscoveryReqType',  base type name='BodyBaseType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2013:MsgBody":ServiceScope{0-1},"urn:iso:15118:2:2013:MsgBody":ServiceCategory{0-1})',  derivedBy='EXTENSION'.  */
#define iso1ServiceDiscoveryReqType_ServiceScope_CHARACTERS_SIZE 64 + EXTRA_CHAR /* XML schema facet maxLength for urn:iso:15118:2:2013:MsgDataTypes,serviceScopeType is 64 */
struct iso1ServiceDiscoveryReqType {
	/* element: "urn:iso:15118:2:2013:MsgBody":ServiceScope, urn:iso:15118:2:2013:MsgDataTypes,serviceScopeType */
	struct {
		exi_string_character_t characters[iso1ServiceDiscoveryReqType_ServiceScope_CHARACTERS_SIZE];
		uint16_t charactersLen;
	}  ServiceScope ;
	unsigned int ServiceScope_isUsed:1;
	/* element: "urn:iso:15118:2:2013:MsgBody":ServiceCategory, urn:iso:15118:2:2013:MsgDataTypes,serviceCategoryType */
	iso1serviceCategoryType ServiceCategory ;
	unsigned int ServiceCategory_isUsed:1;
};

typedef enum {
	iso1chargeProgressType_Start = 0,
	iso1chargeProgressType_Stop = 1,
	iso1chargeProgressType_Renegotiate = 2
} iso1chargeProgressType;

typedef enum {
	iso1valueType_bool = 0,
	iso1valueType_byte = 1,
	iso1valueType_short = 2,
	iso1valueType_int = 3,
	iso1valueType_physicalValue = 4,
	iso1valueType_string = 5
} iso1valueType;

/* Complex type name='urn:iso:15118:2:2013:MsgBody,CableCheckReqType',  base type name='BodyBaseType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2013:MsgBody":DC_EVStatus)',  derivedBy='EXTENSION'.  */
struct iso1CableCheckReqType {
	/* element: "urn:iso:15118:2:2013:MsgBody":DC_EVStatus, Complex type name='urn:iso:15118:2:2013:MsgDataTypes,DC_EVStatusType',  base type name='EVStatusType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2013:MsgDataTypes":EVReady,"urn:iso:15118:2:2013:MsgDataTypes":EVErrorCode,"urn:iso:15118:2:2013:MsgDataTypes":EVRESSSOC)',  derivedBy='EXTENSION'.  */
	struct iso1DC_EVStatusType DC_EVStatus ;
};

/* Complex type name='urn:iso:15118:2:2013:MsgDataTypes,SelectedServiceType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2013:MsgDataTypes":ServiceID,"urn:iso:15118:2:2013:MsgDataTypes":ParameterSetID{0-1})',  derivedBy='RESTRICTION'.  */
struct iso1SelectedServiceType {
	/* element: "urn:iso:15118:2:2013:MsgDataTypes":ServiceID, urn:iso:15118:2:2013:MsgDataTypes,serviceIDType */
	uint16_t ServiceID ;
	/* element: "urn:iso:15118:2:2013:MsgDataTypes":ParameterSetID, http://www.w3.org/2001/XMLSchema,short */
	int16_t ParameterSetID ;
	unsigned int ParameterSetID_isUsed:1;
};

/* Complex type name='urn:iso:15118:2:2013:MsgDataTypes,AC_EVSEStatusType',  base type name='EVSEStatusType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='(("urn:iso:15118:2:2013:MsgDataTypes":NotificationMaxDelay,"urn:iso:15118:2:2013:MsgDataTypes":EVSENotification),("urn:iso:15118:2:2013:MsgDataTypes":RCD))',  derivedBy='EXTENSION'.  */
struct iso1AC_EVSEStatusType {
	/* element: "urn:iso:15118:2:2013:MsgDataTypes":NotificationMaxDelay, http://www.w3.org/2001/XMLSchema,unsignedShort */
	uint16_t NotificationMaxDelay ;
	/* element: "urn:iso:15118:2:2013:MsgDataTypes":EVSENotification, urn:iso:15118:2:2013:MsgDataTypes,EVSENotificationType */
	iso1EVSENotificationType EVSENotification ;
	/* element: "urn:iso:15118:2:2013:MsgDataTypes":RCD, http://www.w3.org/2001/XMLSchema,boolean */
	int RCD ;
};

/* Complex type name='urn:iso:15118:2:2013:MsgBody,BodyBaseType',  base type name='anyType',  content type='EMPTY',  isAbstract='true',  hasTypeId='false',  final='0',  block='0',  derivedBy='RESTRICTION'.  */
struct iso1BodyBaseType {
	int noContent; /* avoid warning */
};

/* Complex type name='urn:iso:15118:2:2013:MsgDataTypes,SupportedEnergyTransferModeType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2013:MsgDataTypes":EnergyTransferMode{1-6})',  derivedBy='RESTRICTION'.  */
#define iso1SupportedEnergyTransferModeType_EnergyTransferMode_ARRAY_SIZE 6
struct iso1SupportedEnergyTransferModeType {
	/* element: "urn:iso:15118:2:2013:MsgDataTypes":EnergyTransferMode, urn:iso:15118:2:2013:MsgDataTypes,EnergyTransferModeType */
	struct {
		iso1EnergyTransferModeType array[iso1SupportedEnergyTransferModeType_EnergyTransferMode_ARRAY_SIZE];
		uint16_t arrayLen;
	} EnergyTransferMode;
};

/* Complex type name='urn:iso:15118:2:2013:MsgBody,ChargingStatusReqType',  base type name='BodyBaseType',  content type='EMPTY',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  derivedBy='EXTENSION'.  */
struct iso1ChargingStatusReqType {
	int noContent; /* avoid warning */
};

/* Complex type name='urn:iso:15118:2:2013:MsgBody,PaymentServiceSelectionResType',  base type name='BodyBaseType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2013:MsgBody":ResponseCode)',  derivedBy='EXTENSION'.  */
struct iso1PaymentServiceSelectionResType {
	/* element: "urn:iso:15118:2:2013:MsgBody":ResponseCode, urn:iso:15118:2:2013:MsgDataTypes,responseCodeType */
	iso1responseCodeType ResponseCode ;
};

/* Complex type name='http://www.w3.org/2000/09/xmldsig#,DigestMethodType',  base type name='anyType',  content type='MIXED',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='((WC[##other:"http://www.w3.org/2000/09/xmldsig#"]){0-UNBOUNDED})',  derivedBy='RESTRICTION'.  */
#define iso1DigestMethodType_Algorithm_CHARACTERS_SIZE 65 + EXTRA_CHAR 
#define iso1DigestMethodType_ANY_CHARACTERS_SIZE 50 + EXTRA_CHAR 
struct iso1DigestMethodType {
	/* attribute: Algorithm {http://www.w3.org/2001/XMLSchema,anyURI} */
	struct {
		exi_string_character_t characters[iso1DigestMethodType_Algorithm_CHARACTERS_SIZE];
		uint16_t charactersLen;
	}  Algorithm ;
	/* element: WC[##other:"http://www.w3.org/2000/09/xmldsig#"] */
	struct {
		exi_string_character_t characters[iso1DigestMethodType_ANY_CHARACTERS_SIZE];
		uint16_t charactersLen;
	}  ANY ;
	unsigned int ANY_isUsed:1;
};

/* Complex type name='http://www.w3.org/2000/09/xmldsig#,SignaturePropertyType',  base type name='anyType',  content type='MIXED',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='((WC[##other:"http://www.w3.org/2000/09/xmldsig#"])){1-UNBOUNDED}',  derivedBy='RESTRICTION'.  */
#define iso1SignaturePropertyType_Target_CHARACTERS_SIZE 50 + EXTRA_CHAR 
#define iso1SignaturePropertyType_Id_CHARACTERS_SIZE 50 + EXTRA_CHAR 
#define iso1SignaturePropertyType_ANY_CHARACTERS_SIZE 50 + EXTRA_CHAR 
struct iso1SignaturePropertyType {
	/* attribute: Target {http://www.w3.org/2001/XMLSchema,anyURI} */
	struct {
		exi_string_character_t characters[iso1SignaturePropertyType_Target_CHARACTERS_SIZE];
		uint16_t charactersLen;
	}  Target ;
	/* attribute: Id {http://www.w3.org/2001/XMLSchema,ID} */
	struct {
		exi_string_character_t characters[iso1SignaturePropertyType_Id_CHARACTERS_SIZE];
		uint16_t charactersLen;
	}  Id ;
	unsigned int Id_isUsed:1;
	/* element: WC[##other:"http://www.w3.org/2000/09/xmldsig#"] */
	struct {
		exi_string_character_t characters[iso1SignaturePropertyType_ANY_CHARACTERS_SIZE];
		uint16_t charactersLen;
	}  ANY ;
	unsigned int ANY_isUsed:1;
};

typedef enum {
	iso1unitSymbolType_h = 0,
	iso1unitSymbolType_m = 1,
	iso1unitSymbolType_s = 2,
	iso1unitSymbolType_A = 3,
	iso1unitSymbolType_V = 4,
	iso1unitSymbolType_W = 5,
	iso1unitSymbolType_Wh = 6
} iso1unitSymbolType;

/* Complex type name='http://www.w3.org/2000/09/xmldsig#,PGPDataType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='(("http://www.w3.org/2000/09/xmldsig#":PGPKeyID,"http://www.w3.org/2000/09/xmldsig#":PGPKeyPacket{0-1},(WC[##other:"http://www.w3.org/2000/09/xmldsig#"]){0-UNBOUNDED})|("http://www.w3.org/2000/09/xmldsig#":PGPKeyPacket,(WC[##other:"http://www.w3.org/2000/09/xmldsig#"]){0-UNBOUNDED}))',  derivedBy='RESTRICTION'.  */
#define iso1PGPDataType_PGPKeyID_BYTES_SIZE 350 
#define iso1PGPDataType_PGPKeyPacket_BYTES_SIZE 350 
#define iso1PGPDataType_ANY_CHARACTERS_SIZE 50 + EXTRA_CHAR 
struct iso1PGPDataType {
	/* element: "http://www.w3.org/2000/09/xmldsig#":PGPKeyID, http://www.w3.org/2001/XMLSchema,base64Binary */
	struct {
		uint8_t bytes[iso1PGPDataType_PGPKeyID_BYTES_SIZE];
		uint16_t bytesLen;
	}  PGPKeyID ;
	unsigned int PGPKeyID_isUsed:1;
	/* element: "http://www.w3.org/2000/09/xmldsig#":PGPKeyPacket, http://www.w3.org/2001/XMLSchema,base64Binary */
	struct {
		uint8_t bytes[iso1PGPDataType_PGPKeyPacket_BYTES_SIZE];
		uint16_t bytesLen;
	}  PGPKeyPacket ;
	unsigned int PGPKeyPacket_isUsed:1;
	/* element: WC[##other:"http://www.w3.org/2000/09/xmldsig#"] */
	struct {
		exi_string_character_t characters[iso1PGPDataType_ANY_CHARACTERS_SIZE];
		uint16_t charactersLen;
	}  ANY ;
	unsigned int ANY_isUsed:1;
};

/* Complex type name='urn:iso:15118:2:2013:MsgBody,SessionSetupResType',  base type name='BodyBaseType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2013:MsgBody":ResponseCode,"urn:iso:15118:2:2013:MsgBody":EVSEID,"urn:iso:15118:2:2013:MsgBody":EVSETimeStamp{0-1})',  derivedBy='EXTENSION'.  */
#define iso1SessionSetupResType_EVSEID_CHARACTERS_SIZE 37 + EXTRA_CHAR /* XML schema facet maxLength for urn:iso:15118:2:2013:MsgDataTypes,evseIDType is 37 */
struct iso1SessionSetupResType {
	/* element: "urn:iso:15118:2:2013:MsgBody":ResponseCode, urn:iso:15118:2:2013:MsgDataTypes,responseCodeType */
	iso1responseCodeType ResponseCode ;
	/* element: "urn:iso:15118:2:2013:MsgBody":EVSEID, urn:iso:15118:2:2013:MsgDataTypes,evseIDType */
	struct {
		exi_string_character_t characters[iso1SessionSetupResType_EVSEID_CHARACTERS_SIZE];
		uint16_t charactersLen;
	}  EVSEID ;
	/* element: "urn:iso:15118:2:2013:MsgBody":EVSETimeStamp, http://www.w3.org/2001/XMLSchema,long */
	int64_t EVSETimeStamp ;
	unsigned int EVSETimeStamp_isUsed:1;
};

/* Complex type name='urn:iso:15118:2:2013:MsgDataTypes,CertificateChainType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2013:MsgDataTypes":Certificate,"urn:iso:15118:2:2013:MsgDataTypes":SubCertificates{0-1})',  derivedBy='RESTRICTION'.  */
#define iso1CertificateChainType_Id_CHARACTERS_SIZE 50 + EXTRA_CHAR 
#define iso1CertificateChainType_Certificate_BYTES_SIZE 800 /* XML schema facet maxLength for urn:iso:15118:2:2013:MsgDataTypes,certificateType is 800 */
struct iso1CertificateChainType {
	/* attribute: Id {http://www.w3.org/2001/XMLSchema,ID} */
	struct {
		exi_string_character_t characters[iso1CertificateChainType_Id_CHARACTERS_SIZE];
		uint16_t charactersLen;
	}  Id ;
	unsigned int Id_isUsed:1;
	/* element: "urn:iso:15118:2:2013:MsgDataTypes":Certificate, urn:iso:15118:2:2013:MsgDataTypes,certificateType */
	struct {
		uint8_t bytes[iso1CertificateChainType_Certificate_BYTES_SIZE];
		uint16_t bytesLen;
	}  Certificate ;
	/* element: "urn:iso:15118:2:2013:MsgDataTypes":SubCertificates, Complex type name='urn:iso:15118:2:2013:MsgDataTypes,SubCertificatesType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2013:MsgDataTypes":Certificate{1-4})',  derivedBy='RESTRICTION'.  */
	struct iso1SubCertificatesType SubCertificates ;
	unsigned int SubCertificates_isUsed:1;
};

/* Complex type name='urn:iso:15118:2:2013:MsgDataTypes,DC_EVSEStatusType',  base type name='EVSEStatusType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='(("urn:iso:15118:2:2013:MsgDataTypes":NotificationMaxDelay,"urn:iso:15118:2:2013:MsgDataTypes":EVSENotification),("urn:iso:15118:2:2013:MsgDataTypes":EVSEIsolationStatus{0-1},"urn:iso:15118:2:2013:MsgDataTypes":EVSEStatusCode))',  derivedBy='EXTENSION'.  */
struct iso1DC_EVSEStatusType {
	/* element: "urn:iso:15118:2:2013:MsgDataTypes":NotificationMaxDelay, http://www.w3.org/2001/XMLSchema,unsignedShort */
	uint16_t NotificationMaxDelay ;
	/* element: "urn:iso:15118:2:2013:MsgDataTypes":EVSENotification, urn:iso:15118:2:2013:MsgDataTypes,EVSENotificationType */
	iso1EVSENotificationType EVSENotification ;
	/* element: "urn:iso:15118:2:2013:MsgDataTypes":EVSEIsolationStatus, urn:iso:15118:2:2013:MsgDataTypes,isolationLevelType */
	iso1isolationLevelType EVSEIsolationStatus ;
	unsigned int EVSEIsolationStatus_isUsed:1;
	/* element: "urn:iso:15118:2:2013:MsgDataTypes":EVSEStatusCode, urn:iso:15118:2:2013:MsgDataTypes,DC_EVSEStatusCodeType */
	iso1DC_EVSEStatusCodeType EVSEStatusCode ;
};

/* Complex type name='urn:iso:15118:2:2013:MsgDataTypes,ServiceListType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2013:MsgDataTypes":Service{1-8})',  derivedBy='RESTRICTION'.  */
#define iso1ServiceListType_Service_ARRAY_SIZE 8
struct iso1ServiceListType {
	/* element: "urn:iso:15118:2:2013:MsgDataTypes":Service, Complex type name='urn:iso:15118:2:2013:MsgDataTypes,ServiceType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2013:MsgDataTypes":ServiceID,"urn:iso:15118:2:2013:MsgDataTypes":ServiceName{0-1},"urn:iso:15118:2:2013:MsgDataTypes":ServiceCategory,"urn:iso:15118:2:2013:MsgDataTypes":ServiceScope{0-1},"urn:iso:15118:2:2013:MsgDataTypes":FreeService)',  derivedBy='RESTRICTION'.  */
	struct {
		struct iso1ServiceType array[iso1ServiceListType_Service_ARRAY_SIZE];
		uint16_t arrayLen;
	} Service;
};

/* Complex type name='urn:iso:15118:2:2013:MsgBody,PowerDeliveryResType',  base type name='BodyBaseType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2013:MsgBody":ResponseCode,"urn:iso:15118:2:2013:MsgDataTypes":EVSEStatus)',  derivedBy='EXTENSION'.  */
struct iso1PowerDeliveryResType {
	/* element: "urn:iso:15118:2:2013:MsgBody":ResponseCode, urn:iso:15118:2:2013:MsgDataTypes,responseCodeType */
	iso1responseCodeType ResponseCode ;
	/* element: "urn:iso:15118:2:2013:MsgDataTypes":EVSEStatus, Complex type name='urn:iso:15118:2:2013:MsgDataTypes,EVSEStatusType',  base type name='anyType',  content type='ELEMENT',  isAbstract='true',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2013:MsgDataTypes":NotificationMaxDelay,"urn:iso:15118:2:2013:MsgDataTypes":EVSENotification)',  derivedBy='RESTRICTION'.  */
	struct iso1EVSEStatusType EVSEStatus ;
	unsigned int EVSEStatus_isUsed:1;
	/* element: "urn:iso:15118:2:2013:MsgDataTypes":AC_EVSEStatus, Complex type name='urn:iso:15118:2:2013:MsgDataTypes,AC_EVSEStatusType',  base type name='EVSEStatusType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='(("urn:iso:15118:2:2013:MsgDataTypes":NotificationMaxDelay,"urn:iso:15118:2:2013:MsgDataTypes":EVSENotification),("urn:iso:15118:2:2013:MsgDataTypes":RCD))',  derivedBy='EXTENSION'.  */
	struct iso1AC_EVSEStatusType AC_EVSEStatus ;
	unsigned int AC_EVSEStatus_isUsed:1;
	/* element: "urn:iso:15118:2:2013:MsgDataTypes":DC_EVSEStatus, Complex type name='urn:iso:15118:2:2013:MsgDataTypes,DC_EVSEStatusType',  base type name='EVSEStatusType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='(("urn:iso:15118:2:2013:MsgDataTypes":NotificationMaxDelay,"urn:iso:15118:2:2013:MsgDataTypes":EVSENotification),("urn:iso:15118:2:2013:MsgDataTypes":EVSEIsolationStatus{0-1},"urn:iso:15118:2:2013:MsgDataTypes":EVSEStatusCode))',  derivedBy='EXTENSION'.  */
	struct iso1DC_EVSEStatusType DC_EVSEStatus ;
	unsigned int DC_EVSEStatus_isUsed:1;
};

/* Complex type name='urn:iso:15118:2:2013:MsgDataTypes,PaymentOptionListType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2013:MsgDataTypes":PaymentOption{1-2})',  derivedBy='RESTRICTION'.  */
#define iso1PaymentOptionListType_PaymentOption_ARRAY_SIZE 2
struct iso1PaymentOptionListType {
	/* element: "urn:iso:15118:2:2013:MsgDataTypes":PaymentOption, urn:iso:15118:2:2013:MsgDataTypes,paymentOptionType */
	struct {
		iso1paymentOptionType array[iso1PaymentOptionListType_PaymentOption_ARRAY_SIZE];
		uint16_t arrayLen;
	} PaymentOption;
};

/* Complex type name='urn:iso:15118:2:2013:MsgDataTypes,PhysicalValueType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2013:MsgDataTypes":Multiplier,"urn:iso:15118:2:2013:MsgDataTypes":Unit,"urn:iso:15118:2:2013:MsgDataTypes":Value)',  derivedBy='RESTRICTION'.  */
struct iso1PhysicalValueType {
	/* element: "urn:iso:15118:2:2013:MsgDataTypes":Multiplier, urn:iso:15118:2:2013:MsgDataTypes,unitMultiplierType */
	int8_t Multiplier ;
	/* element: "urn:iso:15118:2:2013:MsgDataTypes":Unit, urn:iso:15118:2:2013:MsgDataTypes,unitSymbolType */
	iso1unitSymbolType Unit ;
	/* element: "urn:iso:15118:2:2013:MsgDataTypes":Value, http://www.w3.org/2001/XMLSchema,short */
	int16_t Value ;
};

/* Complex type name='urn:iso:15118:2:2013:MsgBody,PaymentDetailsReqType',  base type name='BodyBaseType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2013:MsgBody":eMAID,"urn:iso:15118:2:2013:MsgBody":ContractSignatureCertChain)',  derivedBy='EXTENSION'.  */
#define iso1PaymentDetailsReqType_eMAID_CHARACTERS_SIZE 15 + EXTRA_CHAR /* XML schema facet maxLength for urn:iso:15118:2:2013:MsgDataTypes,eMAIDType is 15 */
struct iso1PaymentDetailsReqType {
	/* element: "urn:iso:15118:2:2013:MsgBody":eMAID, urn:iso:15118:2:2013:MsgDataTypes,eMAIDType */
	struct {
		exi_string_character_t characters[iso1PaymentDetailsReqType_eMAID_CHARACTERS_SIZE];
		uint16_t charactersLen;
	}  eMAID ;
	/* element: "urn:iso:15118:2:2013:MsgBody":ContractSignatureCertChain, Complex type name='urn:iso:15118:2:2013:MsgDataTypes,CertificateChainType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2013:MsgDataTypes":Certificate,"urn:iso:15118:2:2013:MsgDataTypes":SubCertificates{0-1})',  derivedBy='RESTRICTION'.  */
	struct iso1CertificateChainType ContractSignatureCertChain ;
};

/* Complex type name='urn:iso:15118:2:2013:MsgBody,AuthorizationResType',  base type name='BodyBaseType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2013:MsgBody":ResponseCode,"urn:iso:15118:2:2013:MsgBody":EVSEProcessing)',  derivedBy='EXTENSION'.  */
struct iso1AuthorizationResType {
	/* element: "urn:iso:15118:2:2013:MsgBody":ResponseCode, urn:iso:15118:2:2013:MsgDataTypes,responseCodeType */
	iso1responseCodeType ResponseCode ;
	/* element: "urn:iso:15118:2:2013:MsgBody":EVSEProcessing, urn:iso:15118:2:2013:MsgDataTypes,EVSEProcessingType */
	iso1EVSEProcessingType EVSEProcessing ;
};

/* Complex type name='urn:iso:15118:2:2013:MsgDataTypes,DC_EVSEChargeParameterType',  base type name='EVSEChargeParameterType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2013:MsgDataTypes":DC_EVSEStatus,"urn:iso:15118:2:2013:MsgDataTypes":EVSEMaximumCurrentLimit,"urn:iso:15118:2:2013:MsgDataTypes":EVSEMaximumPowerLimit,"urn:iso:15118:2:2013:MsgDataTypes":EVSEMaximumVoltageLimit,"urn:iso:15118:2:2013:MsgDataTypes":EVSEMinimumCurrentLimit,"urn:iso:15118:2:2013:MsgDataTypes":EVSEMinimumVoltageLimit,"urn:iso:15118:2:2013:MsgDataTypes":EVSECurrentRegulationTolerance{0-1},"urn:iso:15118:2:2013:MsgDataTypes":EVSEPeakCurrentRipple,"urn:iso:15118:2:2013:MsgDataTypes":EVSEEnergyToBeDelivered{0-1})',  derivedBy='EXTENSION'.  */
struct iso1DC_EVSEChargeParameterType {
	/* element: "urn:iso:15118:2:2013:MsgDataTypes":DC_EVSEStatus, Complex type name='urn:iso:15118:2:2013:MsgDataTypes,DC_EVSEStatusType',  base type name='EVSEStatusType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='(("urn:iso:15118:2:2013:MsgDataTypes":NotificationMaxDelay,"urn:iso:15118:2:2013:MsgDataTypes":EVSENotification),("urn:iso:15118:2:2013:MsgDataTypes":EVSEIsolationStatus{0-1},"urn:iso:15118:2:2013:MsgDataTypes":EVSEStatusCode))',  derivedBy='EXTENSION'.  */
	struct iso1DC_EVSEStatusType DC_EVSEStatus ;
	/* element: "urn:iso:15118:2:2013:MsgDataTypes":EVSEMaximumCurrentLimit, Complex type name='urn:iso:15118:2:2013:MsgDataTypes,PhysicalValueType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2013:MsgDataTypes":Multiplier,"urn:iso:15118:2:2013:MsgDataTypes":Unit,"urn:iso:15118:2:2013:MsgDataTypes":Value)',  derivedBy='RESTRICTION'.  */
	struct iso1PhysicalValueType EVSEMaximumCurrentLimit ;
	/* element: "urn:iso:15118:2:2013:MsgDataTypes":EVSEMaximumPowerLimit, Complex type name='urn:iso:15118:2:2013:MsgDataTypes,PhysicalValueType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2013:MsgDataTypes":Multiplier,"urn:iso:15118:2:2013:MsgDataTypes":Unit,"urn:iso:15118:2:2013:MsgDataTypes":Value)',  derivedBy='RESTRICTION'.  */
	struct iso1PhysicalValueType EVSEMaximumPowerLimit ;
	/* element: "urn:iso:15118:2:2013:MsgDataTypes":EVSEMaximumVoltageLimit, Complex type name='urn:iso:15118:2:2013:MsgDataTypes,PhysicalValueType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2013:MsgDataTypes":Multiplier,"urn:iso:15118:2:2013:MsgDataTypes":Unit,"urn:iso:15118:2:2013:MsgDataTypes":Value)',  derivedBy='RESTRICTION'.  */
	struct iso1PhysicalValueType EVSEMaximumVoltageLimit ;
	/* element: "urn:iso:15118:2:2013:MsgDataTypes":EVSEMinimumCurrentLimit, Complex type name='urn:iso:15118:2:2013:MsgDataTypes,PhysicalValueType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2013:MsgDataTypes":Multiplier,"urn:iso:15118:2:2013:MsgDataTypes":Unit,"urn:iso:15118:2:2013:MsgDataTypes":Value)',  derivedBy='RESTRICTION'.  */
	struct iso1PhysicalValueType EVSEMinimumCurrentLimit ;
	/* element: "urn:iso:15118:2:2013:MsgDataTypes":EVSEMinimumVoltageLimit, Complex type name='urn:iso:15118:2:2013:MsgDataTypes,PhysicalValueType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2013:MsgDataTypes":Multiplier,"urn:iso:15118:2:2013:MsgDataTypes":Unit,"urn:iso:15118:2:2013:MsgDataTypes":Value)',  derivedBy='RESTRICTION'.  */
	struct iso1PhysicalValueType EVSEMinimumVoltageLimit ;
	/* element: "urn:iso:15118:2:2013:MsgDataTypes":EVSECurrentRegulationTolerance, Complex type name='urn:iso:15118:2:2013:MsgDataTypes,PhysicalValueType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2013:MsgDataTypes":Multiplier,"urn:iso:15118:2:2013:MsgDataTypes":Unit,"urn:iso:15118:2:2013:MsgDataTypes":Value)',  derivedBy='RESTRICTION'.  */
	struct iso1PhysicalValueType EVSECurrentRegulationTolerance ;
	unsigned int EVSECurrentRegulationTolerance_isUsed:1;
	/* element: "urn:iso:15118:2:2013:MsgDataTypes":EVSEPeakCurrentRipple, Complex type name='urn:iso:15118:2:2013:MsgDataTypes,PhysicalValueType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2013:MsgDataTypes":Multiplier,"urn:iso:15118:2:2013:MsgDataTypes":Unit,"urn:iso:15118:2:2013:MsgDataTypes":Value)',  derivedBy='RESTRICTION'.  */
	struct iso1PhysicalValueType EVSEPeakCurrentRipple ;
	/* element: "urn:iso:15118:2:2013:MsgDataTypes":EVSEEnergyToBeDelivered, Complex type name='urn:iso:15118:2:2013:MsgDataTypes,PhysicalValueType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2013:MsgDataTypes":Multiplier,"urn:iso:15118:2:2013:MsgDataTypes":Unit,"urn:iso:15118:2:2013:MsgDataTypes":Value)',  derivedBy='RESTRICTION'.  */
	struct iso1PhysicalValueType EVSEEnergyToBeDelivered ;
	unsigned int EVSEEnergyToBeDelivered_isUsed:1;
};

/* Complex type name='urn:iso:15118:2:2013:MsgBody,ChargingStatusResType',  base type name='BodyBaseType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2013:MsgBody":ResponseCode,"urn:iso:15118:2:2013:MsgBody":EVSEID,"urn:iso:15118:2:2013:MsgBody":SAScheduleTupleID,"urn:iso:15118:2:2013:MsgBody":EVSEMaxCurrent{0-1},"urn:iso:15118:2:2013:MsgBody":MeterInfo{0-1},"urn:iso:15118:2:2013:MsgBody":ReceiptRequired{0-1},"urn:iso:15118:2:2013:MsgBody":AC_EVSEStatus)',  derivedBy='EXTENSION'.  */
#define iso1ChargingStatusResType_EVSEID_CHARACTERS_SIZE 37 + EXTRA_CHAR /* XML schema facet maxLength for urn:iso:15118:2:2013:MsgDataTypes,evseIDType is 37 */
struct iso1ChargingStatusResType {
	/* element: "urn:iso:15118:2:2013:MsgBody":ResponseCode, urn:iso:15118:2:2013:MsgDataTypes,responseCodeType */
	iso1responseCodeType ResponseCode ;
	/* element: "urn:iso:15118:2:2013:MsgBody":EVSEID, urn:iso:15118:2:2013:MsgDataTypes,evseIDType */
	struct {
		exi_string_character_t characters[iso1ChargingStatusResType_EVSEID_CHARACTERS_SIZE];
		uint16_t charactersLen;
	}  EVSEID ;
	/* element: "urn:iso:15118:2:2013:MsgBody":SAScheduleTupleID, urn:iso:15118:2:2013:MsgDataTypes,SAIDType */
	uint8_t SAScheduleTupleID ;
	/* element: "urn:iso:15118:2:2013:MsgBody":EVSEMaxCurrent, Complex type name='urn:iso:15118:2:2013:MsgDataTypes,PhysicalValueType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2013:MsgDataTypes":Multiplier,"urn:iso:15118:2:2013:MsgDataTypes":Unit,"urn:iso:15118:2:2013:MsgDataTypes":Value)',  derivedBy='RESTRICTION'.  */
	struct iso1PhysicalValueType EVSEMaxCurrent ;
	unsigned int EVSEMaxCurrent_isUsed:1;
	/* element: "urn:iso:15118:2:2013:MsgBody":MeterInfo, Complex type name='urn:iso:15118:2:2013:MsgDataTypes,MeterInfoType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2013:MsgDataTypes":MeterID,"urn:iso:15118:2:2013:MsgDataTypes":MeterReading{0-1},"urn:iso:15118:2:2013:MsgDataTypes":SigMeterReading{0-1},"urn:iso:15118:2:2013:MsgDataTypes":MeterStatus{0-1},"urn:iso:15118:2:2013:MsgDataTypes":TMeter{0-1})',  derivedBy='RESTRICTION'.  */
	struct iso1MeterInfoType MeterInfo ;
	unsigned int MeterInfo_isUsed:1;
	/* element: "urn:iso:15118:2:2013:MsgBody":ReceiptRequired, http://www.w3.org/2001/XMLSchema,boolean */
	int ReceiptRequired ;
	unsigned int ReceiptRequired_isUsed:1;
	/* element: "urn:iso:15118:2:2013:MsgBody":AC_EVSEStatus, Complex type name='urn:iso:15118:2:2013:MsgDataTypes,AC_EVSEStatusType',  base type name='EVSEStatusType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='(("urn:iso:15118:2:2013:MsgDataTypes":NotificationMaxDelay,"urn:iso:15118:2:2013:MsgDataTypes":EVSENotification),("urn:iso:15118:2:2013:MsgDataTypes":RCD))',  derivedBy='EXTENSION'.  */
	struct iso1AC_EVSEStatusType AC_EVSEStatus ;
};

/* Complex type name='urn:iso:15118:2:2013:MsgDataTypes,ListOfRootCertificateIDsType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2013:MsgDataTypes":RootCertificateID{1-UNBOUNDED})',  derivedBy='RESTRICTION'.  */
#define iso1ListOfRootCertificateIDsType_RootCertificateID_ARRAY_SIZE 5
struct iso1ListOfRootCertificateIDsType {
	/* element: "urn:iso:15118:2:2013:MsgDataTypes":RootCertificateID, Complex type name='http://www.w3.org/2000/09/xmldsig#,X509IssuerSerialType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("http://www.w3.org/2000/09/xmldsig#":X509IssuerName,"http://www.w3.org/2000/09/xmldsig#":X509SerialNumber)',  derivedBy='RESTRICTION'.  */
	struct {
		struct iso1X509IssuerSerialType array[iso1ListOfRootCertificateIDsType_RootCertificateID_ARRAY_SIZE];
		uint16_t arrayLen;
	} RootCertificateID;
};

/* Complex type name='urn:iso:15118:2:2013:MsgDataTypes,ChargeServiceType',  base type name='ServiceType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='(("urn:iso:15118:2:2013:MsgDataTypes":ServiceID,"urn:iso:15118:2:2013:MsgDataTypes":ServiceName{0-1},"urn:iso:15118:2:2013:MsgDataTypes":ServiceCategory,"urn:iso:15118:2:2013:MsgDataTypes":ServiceScope{0-1},"urn:iso:15118:2:2013:MsgDataTypes":FreeService),("urn:iso:15118:2:2013:MsgDataTypes":SupportedEnergyTransferMode))',  derivedBy='EXTENSION'.  */
#define iso1ChargeServiceType_ServiceName_CHARACTERS_SIZE 32 + EXTRA_CHAR /* XML schema facet maxLength for urn:iso:15118:2:2013:MsgDataTypes,serviceNameType is 32 */
#define iso1ChargeServiceType_ServiceScope_CHARACTERS_SIZE 64 + EXTRA_CHAR /* XML schema facet maxLength for urn:iso:15118:2:2013:MsgDataTypes,serviceScopeType is 64 */
struct iso1ChargeServiceType {
	/* element: "urn:iso:15118:2:2013:MsgDataTypes":ServiceID, urn:iso:15118:2:2013:MsgDataTypes,serviceIDType */
	uint16_t ServiceID ;
	/* element: "urn:iso:15118:2:2013:MsgDataTypes":ServiceName, urn:iso:15118:2:2013:MsgDataTypes,serviceNameType */
	struct {
		exi_string_character_t characters[iso1ChargeServiceType_ServiceName_CHARACTERS_SIZE];
		uint16_t charactersLen;
	}  ServiceName ;
	unsigned int ServiceName_isUsed:1;
	/* element: "urn:iso:15118:2:2013:MsgDataTypes":ServiceCategory, urn:iso:15118:2:2013:MsgDataTypes,serviceCategoryType */
	iso1serviceCategoryType ServiceCategory ;
	/* element: "urn:iso:15118:2:2013:MsgDataTypes":ServiceScope, urn:iso:15118:2:2013:MsgDataTypes,serviceScopeType */
	struct {
		exi_string_character_t characters[iso1ChargeServiceType_ServiceScope_CHARACTERS_SIZE];
		uint16_t charactersLen;
	}  ServiceScope ;
	unsigned int ServiceScope_isUsed:1;
	/* element: "urn:iso:15118:2:2013:MsgDataTypes":FreeService, http://www.w3.org/2001/XMLSchema,boolean */
	int FreeService ;
	/* element: "urn:iso:15118:2:2013:MsgDataTypes":SupportedEnergyTransferMode, Complex type name='urn:iso:15118:2:2013:MsgDataTypes,SupportedEnergyTransferModeType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2013:MsgDataTypes":EnergyTransferMode{1-6})',  derivedBy='RESTRICTION'.  */
	struct iso1SupportedEnergyTransferModeType SupportedEnergyTransferMode ;
};

/* Complex type name='urn:iso:15118:2:2013:MsgDataTypes,SelectedServiceListType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2013:MsgDataTypes":SelectedService{1-16})',  derivedBy='RESTRICTION'.  */
#define iso1SelectedServiceListType_SelectedService_ARRAY_SIZE 16
struct iso1SelectedServiceListType {
	/* element: "urn:iso:15118:2:2013:MsgDataTypes":SelectedService, Complex type name='urn:iso:15118:2:2013:MsgDataTypes,SelectedServiceType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2013:MsgDataTypes":ServiceID,"urn:iso:15118:2:2013:MsgDataTypes":ParameterSetID{0-1})',  derivedBy='RESTRICTION'.  */
	struct {
		struct iso1SelectedServiceType array[iso1SelectedServiceListType_SelectedService_ARRAY_SIZE];
		uint16_t arrayLen;
	} SelectedService;
};

/* Complex type name='urn:iso:15118:2:2013:MsgBody,CableCheckResType',  base type name='BodyBaseType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2013:MsgBody":ResponseCode,"urn:iso:15118:2:2013:MsgBody":DC_EVSEStatus,"urn:iso:15118:2:2013:MsgBody":EVSEProcessing)',  derivedBy='EXTENSION'.  */
struct iso1CableCheckResType {
	/* element: "urn:iso:15118:2:2013:MsgBody":ResponseCode, urn:iso:15118:2:2013:MsgDataTypes,responseCodeType */
	iso1responseCodeType ResponseCode ;
	/* element: "urn:iso:15118:2:2013:MsgBody":DC_EVSEStatus, Complex type name='urn:iso:15118:2:2013:MsgDataTypes,DC_EVSEStatusType',  base type name='EVSEStatusType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='(("urn:iso:15118:2:2013:MsgDataTypes":NotificationMaxDelay,"urn:iso:15118:2:2013:MsgDataTypes":EVSENotification),("urn:iso:15118:2:2013:MsgDataTypes":EVSEIsolationStatus{0-1},"urn:iso:15118:2:2013:MsgDataTypes":EVSEStatusCode))',  derivedBy='EXTENSION'.  */
	struct iso1DC_EVSEStatusType DC_EVSEStatus ;
	/* element: "urn:iso:15118:2:2013:MsgBody":EVSEProcessing, urn:iso:15118:2:2013:MsgDataTypes,EVSEProcessingType */
	iso1EVSEProcessingType EVSEProcessing ;
};

/* Complex type name='http://www.w3.org/2000/09/xmldsig#,TransformsType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("http://www.w3.org/2000/09/xmldsig#":Transform{1-UNBOUNDED})',  derivedBy='RESTRICTION'.  */
#define iso1TransformsType_Transform_ARRAY_SIZE 1
struct iso1TransformsType {
	/* element: "http://www.w3.org/2000/09/xmldsig#":Transform, Complex type name='http://www.w3.org/2000/09/xmldsig#,TransformType',  base type name='anyType',  content type='MIXED',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='((WC[##other:"http://www.w3.org/2000/09/xmldsig#"])|"http://www.w3.org/2000/09/xmldsig#":XPath){0-UNBOUNDED}',  derivedBy='RESTRICTION'.  */
	struct {
		struct iso1TransformType array[iso1TransformsType_Transform_ARRAY_SIZE];
		uint16_t arrayLen;
	} Transform;
};

/* Complex type name='urn:iso:15118:2:2013:MsgBody,PreChargeReqType',  base type name='BodyBaseType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2013:MsgBody":DC_EVStatus,"urn:iso:15118:2:2013:MsgBody":EVTargetVoltage,"urn:iso:15118:2:2013:MsgBody":EVTargetCurrent)',  derivedBy='EXTENSION'.  */
struct iso1PreChargeReqType {
	/* element: "urn:iso:15118:2:2013:MsgBody":DC_EVStatus, Complex type name='urn:iso:15118:2:2013:MsgDataTypes,DC_EVStatusType',  base type name='EVStatusType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2013:MsgDataTypes":EVReady,"urn:iso:15118:2:2013:MsgDataTypes":EVErrorCode,"urn:iso:15118:2:2013:MsgDataTypes":EVRESSSOC)',  derivedBy='EXTENSION'.  */
	struct iso1DC_EVStatusType DC_EVStatus ;
	/* element: "urn:iso:15118:2:2013:MsgBody":EVTargetVoltage, Complex type name='urn:iso:15118:2:2013:MsgDataTypes,PhysicalValueType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2013:MsgDataTypes":Multiplier,"urn:iso:15118:2:2013:MsgDataTypes":Unit,"urn:iso:15118:2:2013:MsgDataTypes":Value)',  derivedBy='RESTRICTION'.  */
	struct iso1PhysicalValueType EVTargetVoltage ;
	/* element: "urn:iso:15118:2:2013:MsgBody":EVTargetCurrent, Complex type name='urn:iso:15118:2:2013:MsgDataTypes,PhysicalValueType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2013:MsgDataTypes":Multiplier,"urn:iso:15118:2:2013:MsgDataTypes":Unit,"urn:iso:15118:2:2013:MsgDataTypes":Value)',  derivedBy='RESTRICTION'.  */
	struct iso1PhysicalValueType EVTargetCurrent ;
};

/* Complex type name='urn:iso:15118:2:2013:MsgDataTypes,AC_EVChargeParameterType',  base type name='EVChargeParameterType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='(("urn:iso:15118:2:2013:MsgDataTypes":DepartureTime{0-1}),("urn:iso:15118:2:2013:MsgDataTypes":EAmount,"urn:iso:15118:2:2013:MsgDataTypes":EVMaxVoltage,"urn:iso:15118:2:2013:MsgDataTypes":EVMaxCurrent,"urn:iso:15118:2:2013:MsgDataTypes":EVMinCurrent))',  derivedBy='EXTENSION'.  */
struct iso1AC_EVChargeParameterType {
	/* element: "urn:iso:15118:2:2013:MsgDataTypes":DepartureTime, http://www.w3.org/2001/XMLSchema,unsignedInt */
	uint32_t DepartureTime ;
	unsigned int DepartureTime_isUsed:1;
	/* element: "urn:iso:15118:2:2013:MsgDataTypes":EAmount, Complex type name='urn:iso:15118:2:2013:MsgDataTypes,PhysicalValueType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2013:MsgDataTypes":Multiplier,"urn:iso:15118:2:2013:MsgDataTypes":Unit,"urn:iso:15118:2:2013:MsgDataTypes":Value)',  derivedBy='RESTRICTION'.  */
	struct iso1PhysicalValueType EAmount ;
	/* element: "urn:iso:15118:2:2013:MsgDataTypes":EVMaxVoltage, Complex type name='urn:iso:15118:2:2013:MsgDataTypes,PhysicalValueType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2013:MsgDataTypes":Multiplier,"urn:iso:15118:2:2013:MsgDataTypes":Unit,"urn:iso:15118:2:2013:MsgDataTypes":Value)',  derivedBy='RESTRICTION'.  */
	struct iso1PhysicalValueType EVMaxVoltage ;
	/* element: "urn:iso:15118:2:2013:MsgDataTypes":EVMaxCurrent, Complex type name='urn:iso:15118:2:2013:MsgDataTypes,PhysicalValueType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2013:MsgDataTypes":Multiplier,"urn:iso:15118:2:2013:MsgDataTypes":Unit,"urn:iso:15118:2:2013:MsgDataTypes":Value)',  derivedBy='RESTRICTION'.  */
	struct iso1PhysicalValueType EVMaxCurrent ;
	/* element: "urn:iso:15118:2:2013:MsgDataTypes":EVMinCurrent, Complex type name='urn:iso:15118:2:2013:MsgDataTypes,PhysicalValueType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2013:MsgDataTypes":Multiplier,"urn:iso:15118:2:2013:MsgDataTypes":Unit,"urn:iso:15118:2:2013:MsgDataTypes":Value)',  derivedBy='RESTRICTION'.  */
	struct iso1PhysicalValueType EVMinCurrent ;
};

/* Complex type name='urn:iso:15118:2:2013:MsgDataTypes,PMaxScheduleEntryType',  base type name='EntryType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='(("urn:iso:15118:2:2013:MsgDataTypes":TimeInterval),("urn:iso:15118:2:2013:MsgDataTypes":PMax))',  derivedBy='EXTENSION'.  */
struct iso1PMaxScheduleEntryType {
	/* element: "urn:iso:15118:2:2013:MsgDataTypes":TimeInterval, Complex type name='urn:iso:15118:2:2013:MsgDataTypes,IntervalType',  base type name='anyType',  content type='EMPTY',  isAbstract='true',  hasTypeId='false',  final='0',  block='0',  derivedBy='RESTRICTION'.  */
	struct iso1IntervalType TimeInterval ;
	unsigned int TimeInterval_isUsed:1;
	/* element: "urn:iso:15118:2:2013:MsgDataTypes":RelativeTimeInterval, Complex type name='urn:iso:15118:2:2013:MsgDataTypes,RelativeTimeIntervalType',  base type name='IntervalType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2013:MsgDataTypes":start,"urn:iso:15118:2:2013:MsgDataTypes":duration{0-1})',  derivedBy='EXTENSION'.  */
	struct iso1RelativeTimeIntervalType RelativeTimeInterval ;
	unsigned int RelativeTimeInterval_isUsed:1;
	/* element: "urn:iso:15118:2:2013:MsgDataTypes":PMax, Complex type name='urn:iso:15118:2:2013:MsgDataTypes,PhysicalValueType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2013:MsgDataTypes":Multiplier,"urn:iso:15118:2:2013:MsgDataTypes":Unit,"urn:iso:15118:2:2013:MsgDataTypes":Value)',  derivedBy='RESTRICTION'.  */
	struct iso1PhysicalValueType PMax ;
};

/* Complex type name='urn:iso:15118:2:2013:MsgBody,MeteringReceiptResType',  base type name='BodyBaseType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2013:MsgBody":ResponseCode,"urn:iso:15118:2:2013:MsgDataTypes":EVSEStatus)',  derivedBy='EXTENSION'.  */
struct iso1MeteringReceiptResType {
	/* element: "urn:iso:15118:2:2013:MsgBody":ResponseCode, urn:iso:15118:2:2013:MsgDataTypes,responseCodeType */
	iso1responseCodeType ResponseCode ;
	/* element: "urn:iso:15118:2:2013:MsgDataTypes":EVSEStatus, Complex type name='urn:iso:15118:2:2013:MsgDataTypes,EVSEStatusType',  base type name='anyType',  content type='ELEMENT',  isAbstract='true',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2013:MsgDataTypes":NotificationMaxDelay,"urn:iso:15118:2:2013:MsgDataTypes":EVSENotification)',  derivedBy='RESTRICTION'.  */
	struct iso1EVSEStatusType EVSEStatus ;
	unsigned int EVSEStatus_isUsed:1;
	/* element: "urn:iso:15118:2:2013:MsgDataTypes":AC_EVSEStatus, Complex type name='urn:iso:15118:2:2013:MsgDataTypes,AC_EVSEStatusType',  base type name='EVSEStatusType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='(("urn:iso:15118:2:2013:MsgDataTypes":NotificationMaxDelay,"urn:iso:15118:2:2013:MsgDataTypes":EVSENotification),("urn:iso:15118:2:2013:MsgDataTypes":RCD))',  derivedBy='EXTENSION'.  */
	struct iso1AC_EVSEStatusType AC_EVSEStatus ;
	unsigned int AC_EVSEStatus_isUsed:1;
	/* element: "urn:iso:15118:2:2013:MsgDataTypes":DC_EVSEStatus, Complex type name='urn:iso:15118:2:2013:MsgDataTypes,DC_EVSEStatusType',  base type name='EVSEStatusType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='(("urn:iso:15118:2:2013:MsgDataTypes":NotificationMaxDelay,"urn:iso:15118:2:2013:MsgDataTypes":EVSENotification),("urn:iso:15118:2:2013:MsgDataTypes":EVSEIsolationStatus{0-1},"urn:iso:15118:2:2013:MsgDataTypes":EVSEStatusCode))',  derivedBy='EXTENSION'.  */
	struct iso1DC_EVSEStatusType DC_EVSEStatus ;
	unsigned int DC_EVSEStatus_isUsed:1;
};

/* Complex type name='urn:iso:15118:2:2013:MsgBody,WeldingDetectionResType',  base type name='BodyBaseType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2013:MsgBody":ResponseCode,"urn:iso:15118:2:2013:MsgBody":DC_EVSEStatus,"urn:iso:15118:2:2013:MsgBody":EVSEPresentVoltage)',  derivedBy='EXTENSION'.  */
struct iso1WeldingDetectionResType {
	/* element: "urn:iso:15118:2:2013:MsgBody":ResponseCode, urn:iso:15118:2:2013:MsgDataTypes,responseCodeType */
	iso1responseCodeType ResponseCode ;
	/* element: "urn:iso:15118:2:2013:MsgBody":DC_EVSEStatus, Complex type name='urn:iso:15118:2:2013:MsgDataTypes,DC_EVSEStatusType',  base type name='EVSEStatusType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='(("urn:iso:15118:2:2013:MsgDataTypes":NotificationMaxDelay,"urn:iso:15118:2:2013:MsgDataTypes":EVSENotification),("urn:iso:15118:2:2013:MsgDataTypes":EVSEIsolationStatus{0-1},"urn:iso:15118:2:2013:MsgDataTypes":EVSEStatusCode))',  derivedBy='EXTENSION'.  */
	struct iso1DC_EVSEStatusType DC_EVSEStatus ;
	/* element: "urn:iso:15118:2:2013:MsgBody":EVSEPresentVoltage, Complex type name='urn:iso:15118:2:2013:MsgDataTypes,PhysicalValueType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2013:MsgDataTypes":Multiplier,"urn:iso:15118:2:2013:MsgDataTypes":Unit,"urn:iso:15118:2:2013:MsgDataTypes":Value)',  derivedBy='RESTRICTION'.  */
	struct iso1PhysicalValueType EVSEPresentVoltage ;
};

/* Complex type name='http://www.w3.org/2000/09/xmldsig#,ReferenceType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("http://www.w3.org/2000/09/xmldsig#":Transforms{0-1},"http://www.w3.org/2000/09/xmldsig#":DigestMethod,"http://www.w3.org/2000/09/xmldsig#":DigestValue)',  derivedBy='RESTRICTION'.  */
#define iso1ReferenceType_Id_CHARACTERS_SIZE 50 + EXTRA_CHAR 
#define iso1ReferenceType_URI_CHARACTERS_SIZE 50 + EXTRA_CHAR 
#define iso1ReferenceType_Type_CHARACTERS_SIZE 50 + EXTRA_CHAR 
#define iso1ReferenceType_DigestValue_BYTES_SIZE 350 
struct iso1ReferenceType {
	/* attribute: Id {http://www.w3.org/2001/XMLSchema,ID} */
	struct {
		exi_string_character_t characters[iso1ReferenceType_Id_CHARACTERS_SIZE];
		uint16_t charactersLen;
	}  Id ;
	unsigned int Id_isUsed:1;
	/* attribute: URI {http://www.w3.org/2001/XMLSchema,anyURI} */
	struct {
		exi_string_character_t characters[iso1ReferenceType_URI_CHARACTERS_SIZE];
		uint16_t charactersLen;
	}  URI ;
	unsigned int URI_isUsed:1;
	/* attribute: Type {http://www.w3.org/2001/XMLSchema,anyURI} */
	struct {
		exi_string_character_t characters[iso1ReferenceType_Type_CHARACTERS_SIZE];
		uint16_t charactersLen;
	}  Type ;
	unsigned int Type_isUsed:1;
	/* element: "http://www.w3.org/2000/09/xmldsig#":Transforms, Complex type name='http://www.w3.org/2000/09/xmldsig#,TransformsType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("http://www.w3.org/2000/09/xmldsig#":Transform{1-UNBOUNDED})',  derivedBy='RESTRICTION'.  */
	struct iso1TransformsType Transforms ;
	unsigned int Transforms_isUsed:1;
	/* element: "http://www.w3.org/2000/09/xmldsig#":DigestMethod, Complex type name='http://www.w3.org/2000/09/xmldsig#,DigestMethodType',  base type name='anyType',  content type='MIXED',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='((WC[##other:"http://www.w3.org/2000/09/xmldsig#"]){0-UNBOUNDED})',  derivedBy='RESTRICTION'.  */
	struct iso1DigestMethodType DigestMethod ;
	/* element: "http://www.w3.org/2000/09/xmldsig#":DigestValue, http://www.w3.org/2000/09/xmldsig#,DigestValueType */
	struct {
		uint8_t bytes[iso1ReferenceType_DigestValue_BYTES_SIZE];
		uint16_t bytesLen;
	}  DigestValue ;
};

/* Complex type name='urn:iso:15118:2:2013:MsgBody,CurrentDemandReqType',  base type name='BodyBaseType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2013:MsgBody":DC_EVStatus,"urn:iso:15118:2:2013:MsgBody":EVTargetCurrent,"urn:iso:15118:2:2013:MsgBody":EVMaximumVoltageLimit{0-1},"urn:iso:15118:2:2013:MsgBody":EVMaximumCurrentLimit{0-1},"urn:iso:15118:2:2013:MsgBody":EVMaximumPowerLimit{0-1},"urn:iso:15118:2:2013:MsgBody":BulkChargingComplete{0-1},"urn:iso:15118:2:2013:MsgBody":ChargingComplete,"urn:iso:15118:2:2013:MsgBody":RemainingTimeToFullSoC{0-1},"urn:iso:15118:2:2013:MsgBody":RemainingTimeToBulkSoC{0-1},"urn:iso:15118:2:2013:MsgBody":EVTargetVoltage)',  derivedBy='EXTENSION'.  */
struct iso1CurrentDemandReqType {
	/* element: "urn:iso:15118:2:2013:MsgBody":DC_EVStatus, Complex type name='urn:iso:15118:2:2013:MsgDataTypes,DC_EVStatusType',  base type name='EVStatusType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2013:MsgDataTypes":EVReady,"urn:iso:15118:2:2013:MsgDataTypes":EVErrorCode,"urn:iso:15118:2:2013:MsgDataTypes":EVRESSSOC)',  derivedBy='EXTENSION'.  */
	struct iso1DC_EVStatusType DC_EVStatus ;
	/* element: "urn:iso:15118:2:2013:MsgBody":EVTargetCurrent, Complex type name='urn:iso:15118:2:2013:MsgDataTypes,PhysicalValueType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2013:MsgDataTypes":Multiplier,"urn:iso:15118:2:2013:MsgDataTypes":Unit,"urn:iso:15118:2:2013:MsgDataTypes":Value)',  derivedBy='RESTRICTION'.  */
	struct iso1PhysicalValueType EVTargetCurrent ;
	/* element: "urn:iso:15118:2:2013:MsgBody":EVMaximumVoltageLimit, Complex type name='urn:iso:15118:2:2013:MsgDataTypes,PhysicalValueType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2013:MsgDataTypes":Multiplier,"urn:iso:15118:2:2013:MsgDataTypes":Unit,"urn:iso:15118:2:2013:MsgDataTypes":Value)',  derivedBy='RESTRICTION'.  */
	struct iso1PhysicalValueType EVMaximumVoltageLimit ;
	unsigned int EVMaximumVoltageLimit_isUsed:1;
	/* element: "urn:iso:15118:2:2013:MsgBody":EVMaximumCurrentLimit, Complex type name='urn:iso:15118:2:2013:MsgDataTypes,PhysicalValueType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2013:MsgDataTypes":Multiplier,"urn:iso:15118:2:2013:MsgDataTypes":Unit,"urn:iso:15118:2:2013:MsgDataTypes":Value)',  derivedBy='RESTRICTION'.  */
	struct iso1PhysicalValueType EVMaximumCurrentLimit ;
	unsigned int EVMaximumCurrentLimit_isUsed:1;
	/* element: "urn:iso:15118:2:2013:MsgBody":EVMaximumPowerLimit, Complex type name='urn:iso:15118:2:2013:MsgDataTypes,PhysicalValueType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2013:MsgDataTypes":Multiplier,"urn:iso:15118:2:2013:MsgDataTypes":Unit,"urn:iso:15118:2:2013:MsgDataTypes":Value)',  derivedBy='RESTRICTION'.  */
	struct iso1PhysicalValueType EVMaximumPowerLimit ;
	unsigned int EVMaximumPowerLimit_isUsed:1;
	/* element: "urn:iso:15118:2:2013:MsgBody":BulkChargingComplete, http://www.w3.org/2001/XMLSchema,boolean */
	int BulkChargingComplete ;
	unsigned int BulkChargingComplete_isUsed:1;
	/* element: "urn:iso:15118:2:2013:MsgBody":ChargingComplete, http://www.w3.org/2001/XMLSchema,boolean */
	int ChargingComplete ;
	/* element: "urn:iso:15118:2:2013:MsgBody":RemainingTimeToFullSoC, Complex type name='urn:iso:15118:2:2013:MsgDataTypes,PhysicalValueType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2013:MsgDataTypes":Multiplier,"urn:iso:15118:2:2013:MsgDataTypes":Unit,"urn:iso:15118:2:2013:MsgDataTypes":Value)',  derivedBy='RESTRICTION'.  */
	struct iso1PhysicalValueType RemainingTimeToFullSoC ;
	unsigned int RemainingTimeToFullSoC_isUsed:1;
	/* element: "urn:iso:15118:2:2013:MsgBody":RemainingTimeToBulkSoC, Complex type name='urn:iso:15118:2:2013:MsgDataTypes,PhysicalValueType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2013:MsgDataTypes":Multiplier,"urn:iso:15118:2:2013:MsgDataTypes":Unit,"urn:iso:15118:2:2013:MsgDataTypes":Value)',  derivedBy='RESTRICTION'.  */
	struct iso1PhysicalValueType RemainingTimeToBulkSoC ;
	unsigned int RemainingTimeToBulkSoC_isUsed:1;
	/* element: "urn:iso:15118:2:2013:MsgBody":EVTargetVoltage, Complex type name='urn:iso:15118:2:2013:MsgDataTypes,PhysicalValueType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2013:MsgDataTypes":Multiplier,"urn:iso:15118:2:2013:MsgDataTypes":Unit,"urn:iso:15118:2:2013:MsgDataTypes":Value)',  derivedBy='RESTRICTION'.  */
	struct iso1PhysicalValueType EVTargetVoltage ;
};

/* Complex type name='urn:iso:15118:2:2013:MsgDataTypes,CostType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2013:MsgDataTypes":costKind,"urn:iso:15118:2:2013:MsgDataTypes":amount,"urn:iso:15118:2:2013:MsgDataTypes":amountMultiplier{0-1})',  derivedBy='RESTRICTION'.  */
struct iso1CostType {
	/* element: "urn:iso:15118:2:2013:MsgDataTypes":costKind, urn:iso:15118:2:2013:MsgDataTypes,costKindType */
	iso1costKindType costKind ;
	/* element: "urn:iso:15118:2:2013:MsgDataTypes":amount, http://www.w3.org/2001/XMLSchema,unsignedInt */
	uint32_t amount ;
	/* element: "urn:iso:15118:2:2013:MsgDataTypes":amountMultiplier, urn:iso:15118:2:2013:MsgDataTypes,unitMultiplierType */
	int8_t amountMultiplier ;
	unsigned int amountMultiplier_isUsed:1;
};

/* Complex type name='urn:iso:15118:2:2013:MsgDataTypes,DC_EVPowerDeliveryParameterType',  base type name='EVPowerDeliveryParameterType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2013:MsgDataTypes":DC_EVStatus,"urn:iso:15118:2:2013:MsgDataTypes":BulkChargingComplete{0-1},"urn:iso:15118:2:2013:MsgDataTypes":ChargingComplete)',  derivedBy='EXTENSION'.  */
struct iso1DC_EVPowerDeliveryParameterType {
	/* element: "urn:iso:15118:2:2013:MsgDataTypes":DC_EVStatus, Complex type name='urn:iso:15118:2:2013:MsgDataTypes,DC_EVStatusType',  base type name='EVStatusType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2013:MsgDataTypes":EVReady,"urn:iso:15118:2:2013:MsgDataTypes":EVErrorCode,"urn:iso:15118:2:2013:MsgDataTypes":EVRESSSOC)',  derivedBy='EXTENSION'.  */
	struct iso1DC_EVStatusType DC_EVStatus ;
	/* element: "urn:iso:15118:2:2013:MsgDataTypes":BulkChargingComplete, http://www.w3.org/2001/XMLSchema,boolean */
	int BulkChargingComplete ;
	unsigned int BulkChargingComplete_isUsed:1;
	/* element: "urn:iso:15118:2:2013:MsgDataTypes":ChargingComplete, http://www.w3.org/2001/XMLSchema,boolean */
	int ChargingComplete ;
};

/* Complex type name='http://www.w3.org/2000/09/xmldsig#,RetrievalMethodType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("http://www.w3.org/2000/09/xmldsig#":Transforms{0-1})',  derivedBy='RESTRICTION'.  */
#define iso1RetrievalMethodType_URI_CHARACTERS_SIZE 50 + EXTRA_CHAR 
#define iso1RetrievalMethodType_Type_CHARACTERS_SIZE 50 + EXTRA_CHAR 
struct iso1RetrievalMethodType {
	/* attribute: URI {http://www.w3.org/2001/XMLSchema,anyURI} */
	struct {
		exi_string_character_t characters[iso1RetrievalMethodType_URI_CHARACTERS_SIZE];
		uint16_t charactersLen;
	}  URI ;
	unsigned int URI_isUsed:1;
	/* attribute: Type {http://www.w3.org/2001/XMLSchema,anyURI} */
	struct {
		exi_string_character_t characters[iso1RetrievalMethodType_Type_CHARACTERS_SIZE];
		uint16_t charactersLen;
	}  Type ;
	unsigned int Type_isUsed:1;
	/* element: "http://www.w3.org/2000/09/xmldsig#":Transforms, Complex type name='http://www.w3.org/2000/09/xmldsig#,TransformsType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("http://www.w3.org/2000/09/xmldsig#":Transform{1-UNBOUNDED})',  derivedBy='RESTRICTION'.  */
	struct iso1TransformsType Transforms ;
	unsigned int Transforms_isUsed:1;
};

/* Complex type name='urn:iso:15118:2:2013:MsgBody,CertificateUpdateResType',  base type name='BodyBaseType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2013:MsgBody":ResponseCode,"urn:iso:15118:2:2013:MsgBody":SAProvisioningCertificateChain,"urn:iso:15118:2:2013:MsgBody":ContractSignatureCertChain,"urn:iso:15118:2:2013:MsgBody":ContractSignatureEncryptedPrivateKey,"urn:iso:15118:2:2013:MsgBody":DHpublickey,"urn:iso:15118:2:2013:MsgBody":eMAID,"urn:iso:15118:2:2013:MsgBody":RetryCounter{0-1})',  derivedBy='EXTENSION'.  */
struct iso1CertificateUpdateResType {
	/* element: "urn:iso:15118:2:2013:MsgBody":ResponseCode, urn:iso:15118:2:2013:MsgDataTypes,responseCodeType */
	iso1responseCodeType ResponseCode ;
	/* element: "urn:iso:15118:2:2013:MsgBody":SAProvisioningCertificateChain, Complex type name='urn:iso:15118:2:2013:MsgDataTypes,CertificateChainType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2013:MsgDataTypes":Certificate,"urn:iso:15118:2:2013:MsgDataTypes":SubCertificates{0-1})',  derivedBy='RESTRICTION'.  */
	struct iso1CertificateChainType SAProvisioningCertificateChain ;
	/* element: "urn:iso:15118:2:2013:MsgBody":ContractSignatureCertChain, Complex type name='urn:iso:15118:2:2013:MsgDataTypes,CertificateChainType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2013:MsgDataTypes":Certificate,"urn:iso:15118:2:2013:MsgDataTypes":SubCertificates{0-1})',  derivedBy='RESTRICTION'.  */
	struct iso1CertificateChainType ContractSignatureCertChain ;
	/* element: "urn:iso:15118:2:2013:MsgBody":ContractSignatureEncryptedPrivateKey, Complex type name='urn:iso:15118:2:2013:MsgDataTypes,ContractSignatureEncryptedPrivateKeyType',  base type name='privateKeyType',  content type='SIMPLE',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  derivedBy='EXTENSION'.  */
	struct iso1ContractSignatureEncryptedPrivateKeyType ContractSignatureEncryptedPrivateKey ;
	/* element: "urn:iso:15118:2:2013:MsgBody":DHpublickey, Complex type name='urn:iso:15118:2:2013:MsgDataTypes,DiffieHellmanPublickeyType',  base type name='dHpublickeyType',  content type='SIMPLE',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  derivedBy='EXTENSION'.  */
	struct iso1DiffieHellmanPublickeyType DHpublickey ;
	/* element: "urn:iso:15118:2:2013:MsgBody":eMAID, Complex type name='urn:iso:15118:2:2013:MsgDataTypes,EMAIDType',  base type name='eMAIDType',  content type='SIMPLE',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  derivedBy='EXTENSION'.  */
	struct iso1EMAIDType eMAID ;
	/* element: "urn:iso:15118:2:2013:MsgBody":RetryCounter, http://www.w3.org/2001/XMLSchema,short */
	int16_t RetryCounter ;
	unsigned int RetryCounter_isUsed:1;
};

/* Complex type name='urn:iso:15118:2:2013:MsgBody,CertificateInstallationResType',  base type name='BodyBaseType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2013:MsgBody":ResponseCode,"urn:iso:15118:2:2013:MsgBody":SAProvisioningCertificateChain,"urn:iso:15118:2:2013:MsgBody":ContractSignatureCertChain,"urn:iso:15118:2:2013:MsgBody":ContractSignatureEncryptedPrivateKey,"urn:iso:15118:2:2013:MsgBody":DHpublickey,"urn:iso:15118:2:2013:MsgBody":eMAID)',  derivedBy='EXTENSION'.  */
struct iso1CertificateInstallationResType {
	/* element: "urn:iso:15118:2:2013:MsgBody":ResponseCode, urn:iso:15118:2:2013:MsgDataTypes,responseCodeType */
	iso1responseCodeType ResponseCode ;
	/* element: "urn:iso:15118:2:2013:MsgBody":SAProvisioningCertificateChain, Complex type name='urn:iso:15118:2:2013:MsgDataTypes,CertificateChainType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2013:MsgDataTypes":Certificate,"urn:iso:15118:2:2013:MsgDataTypes":SubCertificates{0-1})',  derivedBy='RESTRICTION'.  */
	struct iso1CertificateChainType SAProvisioningCertificateChain ;
	/* element: "urn:iso:15118:2:2013:MsgBody":ContractSignatureCertChain, Complex type name='urn:iso:15118:2:2013:MsgDataTypes,CertificateChainType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2013:MsgDataTypes":Certificate,"urn:iso:15118:2:2013:MsgDataTypes":SubCertificates{0-1})',  derivedBy='RESTRICTION'.  */
	struct iso1CertificateChainType ContractSignatureCertChain ;
	/* element: "urn:iso:15118:2:2013:MsgBody":ContractSignatureEncryptedPrivateKey, Complex type name='urn:iso:15118:2:2013:MsgDataTypes,ContractSignatureEncryptedPrivateKeyType',  base type name='privateKeyType',  content type='SIMPLE',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  derivedBy='EXTENSION'.  */
	struct iso1ContractSignatureEncryptedPrivateKeyType ContractSignatureEncryptedPrivateKey ;
	/* element: "urn:iso:15118:2:2013:MsgBody":DHpublickey, Complex type name='urn:iso:15118:2:2013:MsgDataTypes,DiffieHellmanPublickeyType',  base type name='dHpublickeyType',  content type='SIMPLE',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  derivedBy='EXTENSION'.  */
	struct iso1DiffieHellmanPublickeyType DHpublickey ;
	/* element: "urn:iso:15118:2:2013:MsgBody":eMAID, Complex type name='urn:iso:15118:2:2013:MsgDataTypes,EMAIDType',  base type name='eMAIDType',  content type='SIMPLE',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  derivedBy='EXTENSION'.  */
	struct iso1EMAIDType eMAID ;
};

/* Complex type name='urn:iso:15118:2:2013:MsgBody,WeldingDetectionReqType',  base type name='BodyBaseType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2013:MsgBody":DC_EVStatus)',  derivedBy='EXTENSION'.  */
struct iso1WeldingDetectionReqType {
	/* element: "urn:iso:15118:2:2013:MsgBody":DC_EVStatus, Complex type name='urn:iso:15118:2:2013:MsgDataTypes,DC_EVStatusType',  base type name='EVStatusType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2013:MsgDataTypes":EVReady,"urn:iso:15118:2:2013:MsgDataTypes":EVErrorCode,"urn:iso:15118:2:2013:MsgDataTypes":EVRESSSOC)',  derivedBy='EXTENSION'.  */
	struct iso1DC_EVStatusType DC_EVStatus ;
};

/* Complex type name='urn:iso:15118:2:2013:MsgBody,CurrentDemandResType',  base type name='BodyBaseType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2013:MsgBody":ResponseCode,"urn:iso:15118:2:2013:MsgBody":DC_EVSEStatus,"urn:iso:15118:2:2013:MsgBody":EVSEPresentVoltage,"urn:iso:15118:2:2013:MsgBody":EVSEPresentCurrent,"urn:iso:15118:2:2013:MsgBody":EVSECurrentLimitAchieved,"urn:iso:15118:2:2013:MsgBody":EVSEVoltageLimitAchieved,"urn:iso:15118:2:2013:MsgBody":EVSEPowerLimitAchieved,"urn:iso:15118:2:2013:MsgBody":EVSEMaximumVoltageLimit{0-1},"urn:iso:15118:2:2013:MsgBody":EVSEMaximumCurrentLimit{0-1},"urn:iso:15118:2:2013:MsgBody":EVSEMaximumPowerLimit{0-1},"urn:iso:15118:2:2013:MsgBody":EVSEID,"urn:iso:15118:2:2013:MsgBody":SAScheduleTupleID,"urn:iso:15118:2:2013:MsgBody":MeterInfo{0-1},"urn:iso:15118:2:2013:MsgBody":ReceiptRequired{0-1})',  derivedBy='EXTENSION'.  */
#define iso1CurrentDemandResType_EVSEID_CHARACTERS_SIZE 37 + EXTRA_CHAR /* XML schema facet maxLength for urn:iso:15118:2:2013:MsgDataTypes,evseIDType is 37 */
struct iso1CurrentDemandResType {
	/* element: "urn:iso:15118:2:2013:MsgBody":ResponseCode, urn:iso:15118:2:2013:MsgDataTypes,responseCodeType */
	iso1responseCodeType ResponseCode ;
	/* element: "urn:iso:15118:2:2013:MsgBody":DC_EVSEStatus, Complex type name='urn:iso:15118:2:2013:MsgDataTypes,DC_EVSEStatusType',  base type name='EVSEStatusType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='(("urn:iso:15118:2:2013:MsgDataTypes":NotificationMaxDelay,"urn:iso:15118:2:2013:MsgDataTypes":EVSENotification),("urn:iso:15118:2:2013:MsgDataTypes":EVSEIsolationStatus{0-1},"urn:iso:15118:2:2013:MsgDataTypes":EVSEStatusCode))',  derivedBy='EXTENSION'.  */
	struct iso1DC_EVSEStatusType DC_EVSEStatus ;
	/* element: "urn:iso:15118:2:2013:MsgBody":EVSEPresentVoltage, Complex type name='urn:iso:15118:2:2013:MsgDataTypes,PhysicalValueType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2013:MsgDataTypes":Multiplier,"urn:iso:15118:2:2013:MsgDataTypes":Unit,"urn:iso:15118:2:2013:MsgDataTypes":Value)',  derivedBy='RESTRICTION'.  */
	struct iso1PhysicalValueType EVSEPresentVoltage ;
	/* element: "urn:iso:15118:2:2013:MsgBody":EVSEPresentCurrent, Complex type name='urn:iso:15118:2:2013:MsgDataTypes,PhysicalValueType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2013:MsgDataTypes":Multiplier,"urn:iso:15118:2:2013:MsgDataTypes":Unit,"urn:iso:15118:2:2013:MsgDataTypes":Value)',  derivedBy='RESTRICTION'.  */
	struct iso1PhysicalValueType EVSEPresentCurrent ;
	/* element: "urn:iso:15118:2:2013:MsgBody":EVSECurrentLimitAchieved, http://www.w3.org/2001/XMLSchema,boolean */
	int EVSECurrentLimitAchieved ;
	/* element: "urn:iso:15118:2:2013:MsgBody":EVSEVoltageLimitAchieved, http://www.w3.org/2001/XMLSchema,boolean */
	int EVSEVoltageLimitAchieved ;
	/* element: "urn:iso:15118:2:2013:MsgBody":EVSEPowerLimitAchieved, http://www.w3.org/2001/XMLSchema,boolean */
	int EVSEPowerLimitAchieved ;
	/* element: "urn:iso:15118:2:2013:MsgBody":EVSEMaximumVoltageLimit, Complex type name='urn:iso:15118:2:2013:MsgDataTypes,PhysicalValueType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2013:MsgDataTypes":Multiplier,"urn:iso:15118:2:2013:MsgDataTypes":Unit,"urn:iso:15118:2:2013:MsgDataTypes":Value)',  derivedBy='RESTRICTION'.  */
	struct iso1PhysicalValueType EVSEMaximumVoltageLimit ;
	unsigned int EVSEMaximumVoltageLimit_isUsed:1;
	/* element: "urn:iso:15118:2:2013:MsgBody":EVSEMaximumCurrentLimit, Complex type name='urn:iso:15118:2:2013:MsgDataTypes,PhysicalValueType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2013:MsgDataTypes":Multiplier,"urn:iso:15118:2:2013:MsgDataTypes":Unit,"urn:iso:15118:2:2013:MsgDataTypes":Value)',  derivedBy='RESTRICTION'.  */
	struct iso1PhysicalValueType EVSEMaximumCurrentLimit ;
	unsigned int EVSEMaximumCurrentLimit_isUsed:1;
	/* element: "urn:iso:15118:2:2013:MsgBody":EVSEMaximumPowerLimit, Complex type name='urn:iso:15118:2:2013:MsgDataTypes,PhysicalValueType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2013:MsgDataTypes":Multiplier,"urn:iso:15118:2:2013:MsgDataTypes":Unit,"urn:iso:15118:2:2013:MsgDataTypes":Value)',  derivedBy='RESTRICTION'.  */
	struct iso1PhysicalValueType EVSEMaximumPowerLimit ;
	unsigned int EVSEMaximumPowerLimit_isUsed:1;
	/* element: "urn:iso:15118:2:2013:MsgBody":EVSEID, urn:iso:15118:2:2013:MsgDataTypes,evseIDType */
	struct {
		exi_string_character_t characters[iso1CurrentDemandResType_EVSEID_CHARACTERS_SIZE];
		uint16_t charactersLen;
	}  EVSEID ;
	/* element: "urn:iso:15118:2:2013:MsgBody":SAScheduleTupleID, urn:iso:15118:2:2013:MsgDataTypes,SAIDType */
	uint8_t SAScheduleTupleID ;
	/* element: "urn:iso:15118:2:2013:MsgBody":MeterInfo, Complex type name='urn:iso:15118:2:2013:MsgDataTypes,MeterInfoType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2013:MsgDataTypes":MeterID,"urn:iso:15118:2:2013:MsgDataTypes":MeterReading{0-1},"urn:iso:15118:2:2013:MsgDataTypes":SigMeterReading{0-1},"urn:iso:15118:2:2013:MsgDataTypes":MeterStatus{0-1},"urn:iso:15118:2:2013:MsgDataTypes":TMeter{0-1})',  derivedBy='RESTRICTION'.  */
	struct iso1MeterInfoType MeterInfo ;
	unsigned int MeterInfo_isUsed:1;
	/* element: "urn:iso:15118:2:2013:MsgBody":ReceiptRequired, http://www.w3.org/2001/XMLSchema,boolean */
	int ReceiptRequired ;
	unsigned int ReceiptRequired_isUsed:1;
};

/* Complex type name='urn:iso:15118:2:2013:MsgDataTypes,AC_EVSEChargeParameterType',  base type name='EVSEChargeParameterType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2013:MsgDataTypes":AC_EVSEStatus,"urn:iso:15118:2:2013:MsgDataTypes":EVSENominalVoltage,"urn:iso:15118:2:2013:MsgDataTypes":EVSEMaxCurrent)',  derivedBy='EXTENSION'.  */
struct iso1AC_EVSEChargeParameterType {
	/* element: "urn:iso:15118:2:2013:MsgDataTypes":AC_EVSEStatus, Complex type name='urn:iso:15118:2:2013:MsgDataTypes,AC_EVSEStatusType',  base type name='EVSEStatusType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='(("urn:iso:15118:2:2013:MsgDataTypes":NotificationMaxDelay,"urn:iso:15118:2:2013:MsgDataTypes":EVSENotification),("urn:iso:15118:2:2013:MsgDataTypes":RCD))',  derivedBy='EXTENSION'.  */
	struct iso1AC_EVSEStatusType AC_EVSEStatus ;
	/* element: "urn:iso:15118:2:2013:MsgDataTypes":EVSENominalVoltage, Complex type name='urn:iso:15118:2:2013:MsgDataTypes,PhysicalValueType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2013:MsgDataTypes":Multiplier,"urn:iso:15118:2:2013:MsgDataTypes":Unit,"urn:iso:15118:2:2013:MsgDataTypes":Value)',  derivedBy='RESTRICTION'.  */
	struct iso1PhysicalValueType EVSENominalVoltage ;
	/* element: "urn:iso:15118:2:2013:MsgDataTypes":EVSEMaxCurrent, Complex type name='urn:iso:15118:2:2013:MsgDataTypes,PhysicalValueType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2013:MsgDataTypes":Multiplier,"urn:iso:15118:2:2013:MsgDataTypes":Unit,"urn:iso:15118:2:2013:MsgDataTypes":Value)',  derivedBy='RESTRICTION'.  */
	struct iso1PhysicalValueType EVSEMaxCurrent ;
};

/* Complex type name='urn:iso:15118:2:2013:MsgBody,PaymentServiceSelectionReqType',  base type name='BodyBaseType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2013:MsgBody":SelectedPaymentOption,"urn:iso:15118:2:2013:MsgBody":SelectedServiceList)',  derivedBy='EXTENSION'.  */
struct iso1PaymentServiceSelectionReqType {
	/* element: "urn:iso:15118:2:2013:MsgBody":SelectedPaymentOption, urn:iso:15118:2:2013:MsgDataTypes,paymentOptionType */
	iso1paymentOptionType SelectedPaymentOption ;
	/* element: "urn:iso:15118:2:2013:MsgBody":SelectedServiceList, Complex type name='urn:iso:15118:2:2013:MsgDataTypes,SelectedServiceListType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2013:MsgDataTypes":SelectedService{1-16})',  derivedBy='RESTRICTION'.  */
	struct iso1SelectedServiceListType SelectedServiceList ;
};

/* Complex type name='http://www.w3.org/2000/09/xmldsig#,SignaturePropertiesType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("http://www.w3.org/2000/09/xmldsig#":SignatureProperty{1-UNBOUNDED})',  derivedBy='RESTRICTION'.  */
#define iso1SignaturePropertiesType_Id_CHARACTERS_SIZE 50 + EXTRA_CHAR 
#define iso1SignaturePropertiesType_SignatureProperty_ARRAY_SIZE 1
struct iso1SignaturePropertiesType {
	/* attribute: Id {http://www.w3.org/2001/XMLSchema,ID} */
	struct {
		exi_string_character_t characters[iso1SignaturePropertiesType_Id_CHARACTERS_SIZE];
		uint16_t charactersLen;
	}  Id ;
	unsigned int Id_isUsed:1;
	/* element: "http://www.w3.org/2000/09/xmldsig#":SignatureProperty, Complex type name='http://www.w3.org/2000/09/xmldsig#,SignaturePropertyType',  base type name='anyType',  content type='MIXED',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='((WC[##other:"http://www.w3.org/2000/09/xmldsig#"])){1-UNBOUNDED}',  derivedBy='RESTRICTION'.  */
	struct {
		struct iso1SignaturePropertyType array[iso1SignaturePropertiesType_SignatureProperty_ARRAY_SIZE];
		uint16_t arrayLen;
	} SignatureProperty;
};

/* Complex type name='urn:iso:15118:2:2013:MsgDataTypes,ParameterType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2013:MsgDataTypes":boolValue|"urn:iso:15118:2:2013:MsgDataTypes":byteValue|"urn:iso:15118:2:2013:MsgDataTypes":shortValue|"urn:iso:15118:2:2013:MsgDataTypes":intValue|"urn:iso:15118:2:2013:MsgDataTypes":physicalValue|"urn:iso:15118:2:2013:MsgDataTypes":stringValue)',  derivedBy='RESTRICTION'.  */
#define iso1ParameterType_Name_CHARACTERS_SIZE 50 + EXTRA_CHAR 
#define iso1ParameterType_stringValue_CHARACTERS_SIZE 50 + EXTRA_CHAR 
struct iso1ParameterType {
	/* attribute: Name {http://www.w3.org/2001/XMLSchema,string} */
	struct {
		exi_string_character_t characters[iso1ParameterType_Name_CHARACTERS_SIZE];
		uint16_t charactersLen;
	}  Name ;
	/* element: "urn:iso:15118:2:2013:MsgDataTypes":boolValue, http://www.w3.org/2001/XMLSchema,boolean */
	int boolValue ;
	unsigned int boolValue_isUsed:1;
	/* element: "urn:iso:15118:2:2013:MsgDataTypes":byteValue, http://www.w3.org/2001/XMLSchema,byte */
	int8_t byteValue ;
	unsigned int byteValue_isUsed:1;
	/* element: "urn:iso:15118:2:2013:MsgDataTypes":shortValue, http://www.w3.org/2001/XMLSchema,short */
	int16_t shortValue ;
	unsigned int shortValue_isUsed:1;
	/* element: "urn:iso:15118:2:2013:MsgDataTypes":intValue, http://www.w3.org/2001/XMLSchema,int */
	int32_t intValue ;
	unsigned int intValue_isUsed:1;
	/* element: "urn:iso:15118:2:2013:MsgDataTypes":physicalValue, Complex type name='urn:iso:15118:2:2013:MsgDataTypes,PhysicalValueType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2013:MsgDataTypes":Multiplier,"urn:iso:15118:2:2013:MsgDataTypes":Unit,"urn:iso:15118:2:2013:MsgDataTypes":Value)',  derivedBy='RESTRICTION'.  */
	struct iso1PhysicalValueType physicalValue ;
	unsigned int physicalValue_isUsed:1;
	/* element: "urn:iso:15118:2:2013:MsgDataTypes":stringValue, http://www.w3.org/2001/XMLSchema,string */
	struct {
		exi_string_character_t characters[iso1ParameterType_stringValue_CHARACTERS_SIZE];
		uint16_t charactersLen;
	}  stringValue ;
	unsigned int stringValue_isUsed:1;
};

/* Complex type name='urn:iso:15118:2:2013:MsgBody,CertificateInstallationReqType',  base type name='BodyBaseType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2013:MsgBody":OEMProvisioningCert,"urn:iso:15118:2:2013:MsgBody":ListOfRootCertificateIDs)',  derivedBy='EXTENSION'.  */
#define iso1CertificateInstallationReqType_Id_CHARACTERS_SIZE 50 + EXTRA_CHAR 
#define iso1CertificateInstallationReqType_OEMProvisioningCert_BYTES_SIZE 800 /* XML schema facet maxLength for urn:iso:15118:2:2013:MsgDataTypes,certificateType is 800 */
struct iso1CertificateInstallationReqType {
	/* attribute: Id {http://www.w3.org/2001/XMLSchema,ID} */
	struct {
		exi_string_character_t characters[iso1CertificateInstallationReqType_Id_CHARACTERS_SIZE];
		uint16_t charactersLen;
	}  Id ;
	/* element: "urn:iso:15118:2:2013:MsgBody":OEMProvisioningCert, urn:iso:15118:2:2013:MsgDataTypes,certificateType */
	struct {
		uint8_t bytes[iso1CertificateInstallationReqType_OEMProvisioningCert_BYTES_SIZE];
		uint16_t bytesLen;
	}  OEMProvisioningCert ;
	/* element: "urn:iso:15118:2:2013:MsgBody":ListOfRootCertificateIDs, Complex type name='urn:iso:15118:2:2013:MsgDataTypes,ListOfRootCertificateIDsType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2013:MsgDataTypes":RootCertificateID{1-UNBOUNDED})',  derivedBy='RESTRICTION'.  */
	struct iso1ListOfRootCertificateIDsType ListOfRootCertificateIDs ;
};

/* Complex type name='urn:iso:15118:2:2013:MsgBody,ServiceDiscoveryResType',  base type name='BodyBaseType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2013:MsgBody":ResponseCode,"urn:iso:15118:2:2013:MsgBody":PaymentOptionList,"urn:iso:15118:2:2013:MsgBody":ChargeService,"urn:iso:15118:2:2013:MsgBody":ServiceList{0-1})',  derivedBy='EXTENSION'.  */
struct iso1ServiceDiscoveryResType {
	/* element: "urn:iso:15118:2:2013:MsgBody":ResponseCode, urn:iso:15118:2:2013:MsgDataTypes,responseCodeType */
	iso1responseCodeType ResponseCode ;
	/* element: "urn:iso:15118:2:2013:MsgBody":PaymentOptionList, Complex type name='urn:iso:15118:2:2013:MsgDataTypes,PaymentOptionListType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2013:MsgDataTypes":PaymentOption{1-2})',  derivedBy='RESTRICTION'.  */
	struct iso1PaymentOptionListType PaymentOptionList ;
	/* element: "urn:iso:15118:2:2013:MsgBody":ChargeService, Complex type name='urn:iso:15118:2:2013:MsgDataTypes,ChargeServiceType',  base type name='ServiceType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='(("urn:iso:15118:2:2013:MsgDataTypes":ServiceID,"urn:iso:15118:2:2013:MsgDataTypes":ServiceName{0-1},"urn:iso:15118:2:2013:MsgDataTypes":ServiceCategory,"urn:iso:15118:2:2013:MsgDataTypes":ServiceScope{0-1},"urn:iso:15118:2:2013:MsgDataTypes":FreeService),("urn:iso:15118:2:2013:MsgDataTypes":SupportedEnergyTransferMode))',  derivedBy='EXTENSION'.  */
	struct iso1ChargeServiceType ChargeService ;
	/* element: "urn:iso:15118:2:2013:MsgBody":ServiceList, Complex type name='urn:iso:15118:2:2013:MsgDataTypes,ServiceListType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2013:MsgDataTypes":Service{1-8})',  derivedBy='RESTRICTION'.  */
	struct iso1ServiceListType ServiceList ;
	unsigned int ServiceList_isUsed:1;
};

/* Complex type name='urn:iso:15118:2:2013:MsgBody,PreChargeResType',  base type name='BodyBaseType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2013:MsgBody":ResponseCode,"urn:iso:15118:2:2013:MsgBody":DC_EVSEStatus,"urn:iso:15118:2:2013:MsgBody":EVSEPresentVoltage)',  derivedBy='EXTENSION'.  */
struct iso1PreChargeResType {
	/* element: "urn:iso:15118:2:2013:MsgBody":ResponseCode, urn:iso:15118:2:2013:MsgDataTypes,responseCodeType */
	iso1responseCodeType ResponseCode ;
	/* element: "urn:iso:15118:2:2013:MsgBody":DC_EVSEStatus, Complex type name='urn:iso:15118:2:2013:MsgDataTypes,DC_EVSEStatusType',  base type name='EVSEStatusType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='(("urn:iso:15118:2:2013:MsgDataTypes":NotificationMaxDelay,"urn:iso:15118:2:2013:MsgDataTypes":EVSENotification),("urn:iso:15118:2:2013:MsgDataTypes":EVSEIsolationStatus{0-1},"urn:iso:15118:2:2013:MsgDataTypes":EVSEStatusCode))',  derivedBy='EXTENSION'.  */
	struct iso1DC_EVSEStatusType DC_EVSEStatus ;
	/* element: "urn:iso:15118:2:2013:MsgBody":EVSEPresentVoltage, Complex type name='urn:iso:15118:2:2013:MsgDataTypes,PhysicalValueType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2013:MsgDataTypes":Multiplier,"urn:iso:15118:2:2013:MsgDataTypes":Unit,"urn:iso:15118:2:2013:MsgDataTypes":Value)',  derivedBy='RESTRICTION'.  */
	struct iso1PhysicalValueType EVSEPresentVoltage ;
};

/* Complex type name='urn:iso:15118:2:2013:MsgDataTypes,ParameterSetType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2013:MsgDataTypes":ParameterSetID,"urn:iso:15118:2:2013:MsgDataTypes":Parameter{1-16})',  derivedBy='RESTRICTION'.  */
#define iso1ParameterSetType_Parameter_ARRAY_SIZE 16
struct iso1ParameterSetType {
	/* element: "urn:iso:15118:2:2013:MsgDataTypes":ParameterSetID, http://www.w3.org/2001/XMLSchema,short */
	int16_t ParameterSetID ;
	/* element: "urn:iso:15118:2:2013:MsgDataTypes":Parameter, Complex type name='urn:iso:15118:2:2013:MsgDataTypes,ParameterType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2013:MsgDataTypes":boolValue|"urn:iso:15118:2:2013:MsgDataTypes":byteValue|"urn:iso:15118:2:2013:MsgDataTypes":shortValue|"urn:iso:15118:2:2013:MsgDataTypes":intValue|"urn:iso:15118:2:2013:MsgDataTypes":physicalValue|"urn:iso:15118:2:2013:MsgDataTypes":stringValue)',  derivedBy='RESTRICTION'.  */
	struct {
		struct iso1ParameterType array[iso1ParameterSetType_Parameter_ARRAY_SIZE];
		uint16_t arrayLen;
	} Parameter;
};

/* Complex type name='http://www.w3.org/2000/09/xmldsig#,SignedInfoType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("http://www.w3.org/2000/09/xmldsig#":CanonicalizationMethod,"http://www.w3.org/2000/09/xmldsig#":SignatureMethod,"http://www.w3.org/2000/09/xmldsig#":Reference{1-UNBOUNDED})',  derivedBy='RESTRICTION'.  */
#define iso1SignedInfoType_Id_CHARACTERS_SIZE 50 + EXTRA_CHAR 
#define iso1SignedInfoType_Reference_ARRAY_SIZE 1
struct iso1SignedInfoType {
	/* attribute: Id {http://www.w3.org/2001/XMLSchema,ID} */
	struct {
		exi_string_character_t characters[iso1SignedInfoType_Id_CHARACTERS_SIZE];
		uint16_t charactersLen;
	}  Id ;
	unsigned int Id_isUsed:1;
	/* element: "http://www.w3.org/2000/09/xmldsig#":CanonicalizationMethod, Complex type name='http://www.w3.org/2000/09/xmldsig#,CanonicalizationMethodType',  base type name='anyType',  content type='MIXED',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='((WC[##any]){0-UNBOUNDED})',  derivedBy='RESTRICTION'.  */
	struct iso1CanonicalizationMethodType CanonicalizationMethod ;
	/* element: "http://www.w3.org/2000/09/xmldsig#":SignatureMethod, Complex type name='http://www.w3.org/2000/09/xmldsig#,SignatureMethodType',  base type name='anyType',  content type='MIXED',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("http://www.w3.org/2000/09/xmldsig#":HMACOutputLength{0-1},(WC[##other:"http://www.w3.org/2000/09/xmldsig#"]){0-UNBOUNDED})',  derivedBy='RESTRICTION'.  */
	struct iso1SignatureMethodType SignatureMethod ;
	/* element: "http://www.w3.org/2000/09/xmldsig#":Reference, Complex type name='http://www.w3.org/2000/09/xmldsig#,ReferenceType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("http://www.w3.org/2000/09/xmldsig#":Transforms{0-1},"http://www.w3.org/2000/09/xmldsig#":DigestMethod,"http://www.w3.org/2000/09/xmldsig#":DigestValue)',  derivedBy='RESTRICTION'.  */
	struct {
		struct iso1ReferenceType array[iso1SignedInfoType_Reference_ARRAY_SIZE];
		uint16_t arrayLen;
	} Reference;
};

/* Complex type name='urn:iso:15118:2:2013:MsgDataTypes,ProfileEntryType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2013:MsgDataTypes":ChargingProfileEntryStart,"urn:iso:15118:2:2013:MsgDataTypes":ChargingProfileEntryMaxPower,"urn:iso:15118:2:2013:MsgDataTypes":ChargingProfileEntryMaxNumberOfPhasesInUse{0-1})',  derivedBy='RESTRICTION'.  */
struct iso1ProfileEntryType {
	/* element: "urn:iso:15118:2:2013:MsgDataTypes":ChargingProfileEntryStart, http://www.w3.org/2001/XMLSchema,unsignedInt */
	uint32_t ChargingProfileEntryStart ;
	/* element: "urn:iso:15118:2:2013:MsgDataTypes":ChargingProfileEntryMaxPower, Complex type name='urn:iso:15118:2:2013:MsgDataTypes,PhysicalValueType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2013:MsgDataTypes":Multiplier,"urn:iso:15118:2:2013:MsgDataTypes":Unit,"urn:iso:15118:2:2013:MsgDataTypes":Value)',  derivedBy='RESTRICTION'.  */
	struct iso1PhysicalValueType ChargingProfileEntryMaxPower ;
	/* element: "urn:iso:15118:2:2013:MsgDataTypes":ChargingProfileEntryMaxNumberOfPhasesInUse, urn:iso:15118:2:2013:MsgDataTypes,maxNumPhasesType */
	int8_t ChargingProfileEntryMaxNumberOfPhasesInUse ;
	unsigned int ChargingProfileEntryMaxNumberOfPhasesInUse_isUsed:1;
};

/* Complex type name='http://www.w3.org/2000/09/xmldsig#,ManifestType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("http://www.w3.org/2000/09/xmldsig#":Reference{1-UNBOUNDED})',  derivedBy='RESTRICTION'.  */
#define iso1ManifestType_Id_CHARACTERS_SIZE 50 + EXTRA_CHAR 
#define iso1ManifestType_Reference_ARRAY_SIZE 1
struct iso1ManifestType {
	/* attribute: Id {http://www.w3.org/2001/XMLSchema,ID} */
	struct {
		exi_string_character_t characters[iso1ManifestType_Id_CHARACTERS_SIZE];
		uint16_t charactersLen;
	}  Id ;
	unsigned int Id_isUsed:1;
	/* element: "http://www.w3.org/2000/09/xmldsig#":Reference, Complex type name='http://www.w3.org/2000/09/xmldsig#,ReferenceType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("http://www.w3.org/2000/09/xmldsig#":Transforms{0-1},"http://www.w3.org/2000/09/xmldsig#":DigestMethod,"http://www.w3.org/2000/09/xmldsig#":DigestValue)',  derivedBy='RESTRICTION'.  */
	struct {
		struct iso1ReferenceType array[iso1ManifestType_Reference_ARRAY_SIZE];
		uint16_t arrayLen;
	} Reference;
};

/* Complex type name='urn:iso:15118:2:2013:MsgDataTypes,DC_EVChargeParameterType',  base type name='EVChargeParameterType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='(("urn:iso:15118:2:2013:MsgDataTypes":DepartureTime{0-1}),("urn:iso:15118:2:2013:MsgDataTypes":DC_EVStatus,"urn:iso:15118:2:2013:MsgDataTypes":EVMaximumCurrentLimit,"urn:iso:15118:2:2013:MsgDataTypes":EVMaximumPowerLimit{0-1},"urn:iso:15118:2:2013:MsgDataTypes":EVMaximumVoltageLimit,"urn:iso:15118:2:2013:MsgDataTypes":EVEnergyCapacity{0-1},"urn:iso:15118:2:2013:MsgDataTypes":EVEnergyRequest{0-1},"urn:iso:15118:2:2013:MsgDataTypes":FullSOC{0-1},"urn:iso:15118:2:2013:MsgDataTypes":BulkSOC{0-1}))',  derivedBy='EXTENSION'.  */
struct iso1DC_EVChargeParameterType {
	/* element: "urn:iso:15118:2:2013:MsgDataTypes":DepartureTime, http://www.w3.org/2001/XMLSchema,unsignedInt */
	uint32_t DepartureTime ;
	unsigned int DepartureTime_isUsed:1;
	/* element: "urn:iso:15118:2:2013:MsgDataTypes":DC_EVStatus, Complex type name='urn:iso:15118:2:2013:MsgDataTypes,DC_EVStatusType',  base type name='EVStatusType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2013:MsgDataTypes":EVReady,"urn:iso:15118:2:2013:MsgDataTypes":EVErrorCode,"urn:iso:15118:2:2013:MsgDataTypes":EVRESSSOC)',  derivedBy='EXTENSION'.  */
	struct iso1DC_EVStatusType DC_EVStatus ;
	/* element: "urn:iso:15118:2:2013:MsgDataTypes":EVMaximumCurrentLimit, Complex type name='urn:iso:15118:2:2013:MsgDataTypes,PhysicalValueType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2013:MsgDataTypes":Multiplier,"urn:iso:15118:2:2013:MsgDataTypes":Unit,"urn:iso:15118:2:2013:MsgDataTypes":Value)',  derivedBy='RESTRICTION'.  */
	struct iso1PhysicalValueType EVMaximumCurrentLimit ;
	/* element: "urn:iso:15118:2:2013:MsgDataTypes":EVMaximumPowerLimit, Complex type name='urn:iso:15118:2:2013:MsgDataTypes,PhysicalValueType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2013:MsgDataTypes":Multiplier,"urn:iso:15118:2:2013:MsgDataTypes":Unit,"urn:iso:15118:2:2013:MsgDataTypes":Value)',  derivedBy='RESTRICTION'.  */
	struct iso1PhysicalValueType EVMaximumPowerLimit ;
	unsigned int EVMaximumPowerLimit_isUsed:1;
	/* element: "urn:iso:15118:2:2013:MsgDataTypes":EVMaximumVoltageLimit, Complex type name='urn:iso:15118:2:2013:MsgDataTypes,PhysicalValueType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2013:MsgDataTypes":Multiplier,"urn:iso:15118:2:2013:MsgDataTypes":Unit,"urn:iso:15118:2:2013:MsgDataTypes":Value)',  derivedBy='RESTRICTION'.  */
	struct iso1PhysicalValueType EVMaximumVoltageLimit ;
	/* element: "urn:iso:15118:2:2013:MsgDataTypes":EVEnergyCapacity, Complex type name='urn:iso:15118:2:2013:MsgDataTypes,PhysicalValueType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2013:MsgDataTypes":Multiplier,"urn:iso:15118:2:2013:MsgDataTypes":Unit,"urn:iso:15118:2:2013:MsgDataTypes":Value)',  derivedBy='RESTRICTION'.  */
	struct iso1PhysicalValueType EVEnergyCapacity ;
	unsigned int EVEnergyCapacity_isUsed:1;
	/* element: "urn:iso:15118:2:2013:MsgDataTypes":EVEnergyRequest, Complex type name='urn:iso:15118:2:2013:MsgDataTypes,PhysicalValueType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2013:MsgDataTypes":Multiplier,"urn:iso:15118:2:2013:MsgDataTypes":Unit,"urn:iso:15118:2:2013:MsgDataTypes":Value)',  derivedBy='RESTRICTION'.  */
	struct iso1PhysicalValueType EVEnergyRequest ;
	unsigned int EVEnergyRequest_isUsed:1;
	/* element: "urn:iso:15118:2:2013:MsgDataTypes":FullSOC, urn:iso:15118:2:2013:MsgDataTypes,percentValueType */
	int8_t FullSOC ;
	unsigned int FullSOC_isUsed:1;
	/* element: "urn:iso:15118:2:2013:MsgDataTypes":BulkSOC, urn:iso:15118:2:2013:MsgDataTypes,percentValueType */
	int8_t BulkSOC ;
	unsigned int BulkSOC_isUsed:1;
};

/* Complex type name='urn:iso:15118:2:2013:MsgDataTypes,ConsumptionCostType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2013:MsgDataTypes":startValue,"urn:iso:15118:2:2013:MsgDataTypes":Cost{1-3})',  derivedBy='RESTRICTION'.  */
#define iso1ConsumptionCostType_Cost_ARRAY_SIZE 3
struct iso1ConsumptionCostType {
	/* element: "urn:iso:15118:2:2013:MsgDataTypes":startValue, Complex type name='urn:iso:15118:2:2013:MsgDataTypes,PhysicalValueType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2013:MsgDataTypes":Multiplier,"urn:iso:15118:2:2013:MsgDataTypes":Unit,"urn:iso:15118:2:2013:MsgDataTypes":Value)',  derivedBy='RESTRICTION'.  */
	struct iso1PhysicalValueType startValue ;
	/* element: "urn:iso:15118:2:2013:MsgDataTypes":Cost, Complex type name='urn:iso:15118:2:2013:MsgDataTypes,CostType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2013:MsgDataTypes":costKind,"urn:iso:15118:2:2013:MsgDataTypes":amount,"urn:iso:15118:2:2013:MsgDataTypes":amountMultiplier{0-1})',  derivedBy='RESTRICTION'.  */
	struct {
		struct iso1CostType array[iso1ConsumptionCostType_Cost_ARRAY_SIZE];
		uint16_t arrayLen;
	} Cost;
};

/* Complex type name='urn:iso:15118:2:2013:MsgDataTypes,PMaxScheduleType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2013:MsgDataTypes":PMaxScheduleEntry{1-UNBOUNDED})',  derivedBy='RESTRICTION'.  */
#define iso1PMaxScheduleType_PMaxScheduleEntry_ARRAY_SIZE 5
struct iso1PMaxScheduleType {
	/* element: "urn:iso:15118:2:2013:MsgDataTypes":PMaxScheduleEntry, Complex type name='urn:iso:15118:2:2013:MsgDataTypes,PMaxScheduleEntryType',  base type name='EntryType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='(("urn:iso:15118:2:2013:MsgDataTypes":TimeInterval),("urn:iso:15118:2:2013:MsgDataTypes":PMax))',  derivedBy='EXTENSION'.  */
	struct {
		struct iso1PMaxScheduleEntryType array[iso1PMaxScheduleType_PMaxScheduleEntry_ARRAY_SIZE];
		uint16_t arrayLen;
	} PMaxScheduleEntry;
};

/* Complex type name='urn:iso:15118:2:2013:MsgBody,CertificateUpdateReqType',  base type name='BodyBaseType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2013:MsgBody":ContractSignatureCertChain,"urn:iso:15118:2:2013:MsgBody":eMAID,"urn:iso:15118:2:2013:MsgBody":ListOfRootCertificateIDs)',  derivedBy='EXTENSION'.  */
#define iso1CertificateUpdateReqType_Id_CHARACTERS_SIZE 50 + EXTRA_CHAR 
#define iso1CertificateUpdateReqType_eMAID_CHARACTERS_SIZE 15 + EXTRA_CHAR /* XML schema facet maxLength for urn:iso:15118:2:2013:MsgDataTypes,eMAIDType is 15 */
struct iso1CertificateUpdateReqType {
	/* attribute: Id {http://www.w3.org/2001/XMLSchema,ID} */
	struct {
		exi_string_character_t characters[iso1CertificateUpdateReqType_Id_CHARACTERS_SIZE];
		uint16_t charactersLen;
	}  Id ;
	/* element: "urn:iso:15118:2:2013:MsgBody":ContractSignatureCertChain, Complex type name='urn:iso:15118:2:2013:MsgDataTypes,CertificateChainType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2013:MsgDataTypes":Certificate,"urn:iso:15118:2:2013:MsgDataTypes":SubCertificates{0-1})',  derivedBy='RESTRICTION'.  */
	struct iso1CertificateChainType ContractSignatureCertChain ;
	/* element: "urn:iso:15118:2:2013:MsgBody":eMAID, urn:iso:15118:2:2013:MsgDataTypes,eMAIDType */
	struct {
		exi_string_character_t characters[iso1CertificateUpdateReqType_eMAID_CHARACTERS_SIZE];
		uint16_t charactersLen;
	}  eMAID ;
	/* element: "urn:iso:15118:2:2013:MsgBody":ListOfRootCertificateIDs, Complex type name='urn:iso:15118:2:2013:MsgDataTypes,ListOfRootCertificateIDsType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2013:MsgDataTypes":RootCertificateID{1-UNBOUNDED})',  derivedBy='RESTRICTION'.  */
	struct iso1ListOfRootCertificateIDsType ListOfRootCertificateIDs ;
};

/* Complex type name='http://www.w3.org/2000/09/xmldsig#,KeyInfoType',  base type name='anyType',  content type='MIXED',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("http://www.w3.org/2000/09/xmldsig#":KeyName|"http://www.w3.org/2000/09/xmldsig#":KeyValue|"http://www.w3.org/2000/09/xmldsig#":RetrievalMethod|"http://www.w3.org/2000/09/xmldsig#":X509Data|"http://www.w3.org/2000/09/xmldsig#":PGPData|"http://www.w3.org/2000/09/xmldsig#":SPKIData|"http://www.w3.org/2000/09/xmldsig#":MgmtData|(WC[##other:"http://www.w3.org/2000/09/xmldsig#"])){1-UNBOUNDED}',  derivedBy='RESTRICTION'.  */
#define iso1KeyInfoType_Id_CHARACTERS_SIZE 50 + EXTRA_CHAR 
#define iso1KeyInfoType_KeyName_CHARACTERS_SIZE 50 + EXTRA_CHAR 
#define iso1KeyInfoType_KeyName_ARRAY_SIZE 1
#define iso1KeyInfoType_KeyValue_ARRAY_SIZE 1
#define iso1KeyInfoType_RetrievalMethod_ARRAY_SIZE 1
#define iso1KeyInfoType_X509Data_ARRAY_SIZE 1
#define iso1KeyInfoType_PGPData_ARRAY_SIZE 1
#define iso1KeyInfoType_SPKIData_ARRAY_SIZE 1
#define iso1KeyInfoType_MgmtData_CHARACTERS_SIZE 50 + EXTRA_CHAR 
#define iso1KeyInfoType_MgmtData_ARRAY_SIZE 1
#define iso1KeyInfoType_ANY_CHARACTERS_SIZE 50 + EXTRA_CHAR 
struct iso1KeyInfoType {
	/* attribute: Id {http://www.w3.org/2001/XMLSchema,ID} */
	struct {
		exi_string_character_t characters[iso1KeyInfoType_Id_CHARACTERS_SIZE];
		uint16_t charactersLen;
	}  Id ;
	unsigned int Id_isUsed:1;
	/* element: "http://www.w3.org/2000/09/xmldsig#":KeyName, http://www.w3.org/2001/XMLSchema,string */
	struct {
		struct {
			exi_string_character_t characters[iso1KeyInfoType_KeyName_CHARACTERS_SIZE];
			uint16_t charactersLen;
		}  array[iso1KeyInfoType_KeyName_ARRAY_SIZE];
		uint16_t arrayLen;
	} KeyName;
	/* element: "http://www.w3.org/2000/09/xmldsig#":KeyValue, Complex type name='http://www.w3.org/2000/09/xmldsig#,KeyValueType',  base type name='anyType',  content type='MIXED',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("http://www.w3.org/2000/09/xmldsig#":DSAKeyValue|"http://www.w3.org/2000/09/xmldsig#":RSAKeyValue|(WC[##other:"http://www.w3.org/2000/09/xmldsig#"]))',  derivedBy='RESTRICTION'.  */
	struct {
		struct iso1KeyValueType array[iso1KeyInfoType_KeyValue_ARRAY_SIZE];
		uint16_t arrayLen;
	} KeyValue;
	/* element: "http://www.w3.org/2000/09/xmldsig#":RetrievalMethod, Complex type name='http://www.w3.org/2000/09/xmldsig#,RetrievalMethodType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("http://www.w3.org/2000/09/xmldsig#":Transforms{0-1})',  derivedBy='RESTRICTION'.  */
	struct {
		struct iso1RetrievalMethodType array[iso1KeyInfoType_RetrievalMethod_ARRAY_SIZE];
		uint16_t arrayLen;
	} RetrievalMethod;
	/* element: "http://www.w3.org/2000/09/xmldsig#":X509Data, Complex type name='http://www.w3.org/2000/09/xmldsig#,X509DataType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='(("http://www.w3.org/2000/09/xmldsig#":X509IssuerSerial|"http://www.w3.org/2000/09/xmldsig#":X509SKI|"http://www.w3.org/2000/09/xmldsig#":X509SubjectName|"http://www.w3.org/2000/09/xmldsig#":X509Certificate|"http://www.w3.org/2000/09/xmldsig#":X509CRL|(WC[##other:"http://www.w3.org/2000/09/xmldsig#"]))){1-UNBOUNDED}',  derivedBy='RESTRICTION'.  */
	struct {
		struct iso1X509DataType array[iso1KeyInfoType_X509Data_ARRAY_SIZE];
		uint16_t arrayLen;
	} X509Data;
	/* element: "http://www.w3.org/2000/09/xmldsig#":PGPData, Complex type name='http://www.w3.org/2000/09/xmldsig#,PGPDataType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='(("http://www.w3.org/2000/09/xmldsig#":PGPKeyID,"http://www.w3.org/2000/09/xmldsig#":PGPKeyPacket{0-1},(WC[##other:"http://www.w3.org/2000/09/xmldsig#"]){0-UNBOUNDED})|("http://www.w3.org/2000/09/xmldsig#":PGPKeyPacket,(WC[##other:"http://www.w3.org/2000/09/xmldsig#"]){0-UNBOUNDED}))',  derivedBy='RESTRICTION'.  */
	struct {
		struct iso1PGPDataType array[iso1KeyInfoType_PGPData_ARRAY_SIZE];
		uint16_t arrayLen;
	} PGPData;
	/* element: "http://www.w3.org/2000/09/xmldsig#":SPKIData, Complex type name='http://www.w3.org/2000/09/xmldsig#,SPKIDataType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("http://www.w3.org/2000/09/xmldsig#":SPKISexp,(WC[##other:"http://www.w3.org/2000/09/xmldsig#"]){0-1}){1-UNBOUNDED}',  derivedBy='RESTRICTION'.  */
	struct {
		struct iso1SPKIDataType array[iso1KeyInfoType_SPKIData_ARRAY_SIZE];
		uint16_t arrayLen;
	} SPKIData;
	/* element: "http://www.w3.org/2000/09/xmldsig#":MgmtData, http://www.w3.org/2001/XMLSchema,string */
	struct {
		struct {
			exi_string_character_t characters[iso1KeyInfoType_MgmtData_CHARACTERS_SIZE];
			uint16_t charactersLen;
		}  array[iso1KeyInfoType_MgmtData_ARRAY_SIZE];
		uint16_t arrayLen;
	} MgmtData;
	/* element: WC[##other:"http://www.w3.org/2000/09/xmldsig#"] */
	struct {
		exi_string_character_t characters[iso1KeyInfoType_ANY_CHARACTERS_SIZE];
		uint16_t charactersLen;
	}  ANY ;
	unsigned int ANY_isUsed:1;
};

/* Complex type name='urn:iso:15118:2:2013:MsgBody,ChargeParameterDiscoveryReqType',  base type name='BodyBaseType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2013:MsgBody":MaxEntriesSAScheduleTuple{0-1},"urn:iso:15118:2:2013:MsgBody":RequestedEnergyTransferMode,"urn:iso:15118:2:2013:MsgDataTypes":EVChargeParameter)',  derivedBy='EXTENSION'.  */
struct iso1ChargeParameterDiscoveryReqType {
	/* element: "urn:iso:15118:2:2013:MsgBody":MaxEntriesSAScheduleTuple, http://www.w3.org/2001/XMLSchema,unsignedShort */
	uint16_t MaxEntriesSAScheduleTuple ;
	unsigned int MaxEntriesSAScheduleTuple_isUsed:1;
	/* element: "urn:iso:15118:2:2013:MsgBody":RequestedEnergyTransferMode, urn:iso:15118:2:2013:MsgDataTypes,EnergyTransferModeType */
	iso1EnergyTransferModeType RequestedEnergyTransferMode ;
	/* element: "urn:iso:15118:2:2013:MsgDataTypes":EVChargeParameter, Complex type name='urn:iso:15118:2:2013:MsgDataTypes,EVChargeParameterType',  base type name='anyType',  content type='ELEMENT',  isAbstract='true',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2013:MsgDataTypes":DepartureTime{0-1})',  derivedBy='RESTRICTION'.  */
	struct iso1EVChargeParameterType EVChargeParameter ;
	unsigned int EVChargeParameter_isUsed:1;
	/* element: "urn:iso:15118:2:2013:MsgDataTypes":AC_EVChargeParameter, Complex type name='urn:iso:15118:2:2013:MsgDataTypes,AC_EVChargeParameterType',  base type name='EVChargeParameterType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='(("urn:iso:15118:2:2013:MsgDataTypes":DepartureTime{0-1}),("urn:iso:15118:2:2013:MsgDataTypes":EAmount,"urn:iso:15118:2:2013:MsgDataTypes":EVMaxVoltage,"urn:iso:15118:2:2013:MsgDataTypes":EVMaxCurrent,"urn:iso:15118:2:2013:MsgDataTypes":EVMinCurrent))',  derivedBy='EXTENSION'.  */
	struct iso1AC_EVChargeParameterType AC_EVChargeParameter ;
	unsigned int AC_EVChargeParameter_isUsed:1;
	/* element: "urn:iso:15118:2:2013:MsgDataTypes":DC_EVChargeParameter, Complex type name='urn:iso:15118:2:2013:MsgDataTypes,DC_EVChargeParameterType',  base type name='EVChargeParameterType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='(("urn:iso:15118:2:2013:MsgDataTypes":DepartureTime{0-1}),("urn:iso:15118:2:2013:MsgDataTypes":DC_EVStatus,"urn:iso:15118:2:2013:MsgDataTypes":EVMaximumCurrentLimit,"urn:iso:15118:2:2013:MsgDataTypes":EVMaximumPowerLimit{0-1},"urn:iso:15118:2:2013:MsgDataTypes":EVMaximumVoltageLimit,"urn:iso:15118:2:2013:MsgDataTypes":EVEnergyCapacity{0-1},"urn:iso:15118:2:2013:MsgDataTypes":EVEnergyRequest{0-1},"urn:iso:15118:2:2013:MsgDataTypes":FullSOC{0-1},"urn:iso:15118:2:2013:MsgDataTypes":BulkSOC{0-1}))',  derivedBy='EXTENSION'.  */
	struct iso1DC_EVChargeParameterType DC_EVChargeParameter ;
	unsigned int DC_EVChargeParameter_isUsed:1;
};

/* Complex type name='urn:iso:15118:2:2013:MsgDataTypes,ChargingProfileType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2013:MsgDataTypes":ProfileEntry{1-24})',  derivedBy='RESTRICTION'.  */
#define iso1ChargingProfileType_ProfileEntry_ARRAY_SIZE 24
struct iso1ChargingProfileType {
	/* element: "urn:iso:15118:2:2013:MsgDataTypes":ProfileEntry, Complex type name='urn:iso:15118:2:2013:MsgDataTypes,ProfileEntryType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2013:MsgDataTypes":ChargingProfileEntryStart,"urn:iso:15118:2:2013:MsgDataTypes":ChargingProfileEntryMaxPower,"urn:iso:15118:2:2013:MsgDataTypes":ChargingProfileEntryMaxNumberOfPhasesInUse{0-1})',  derivedBy='RESTRICTION'.  */
	struct {
		struct iso1ProfileEntryType array[iso1ChargingProfileType_ProfileEntry_ARRAY_SIZE];
		uint16_t arrayLen;
	} ProfileEntry;
};

/* Complex type name='urn:iso:15118:2:2013:MsgDataTypes,SalesTariffEntryType',  base type name='EntryType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='(("urn:iso:15118:2:2013:MsgDataTypes":TimeInterval),("urn:iso:15118:2:2013:MsgDataTypes":EPriceLevel{0-1},"urn:iso:15118:2:2013:MsgDataTypes":ConsumptionCost{0-3}))',  derivedBy='EXTENSION'.  */
#define iso1SalesTariffEntryType_ConsumptionCost_ARRAY_SIZE 3
struct iso1SalesTariffEntryType {
	/* element: "urn:iso:15118:2:2013:MsgDataTypes":TimeInterval, Complex type name='urn:iso:15118:2:2013:MsgDataTypes,IntervalType',  base type name='anyType',  content type='EMPTY',  isAbstract='true',  hasTypeId='false',  final='0',  block='0',  derivedBy='RESTRICTION'.  */
	struct iso1IntervalType TimeInterval ;
	unsigned int TimeInterval_isUsed:1;
	/* element: "urn:iso:15118:2:2013:MsgDataTypes":RelativeTimeInterval, Complex type name='urn:iso:15118:2:2013:MsgDataTypes,RelativeTimeIntervalType',  base type name='IntervalType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2013:MsgDataTypes":start,"urn:iso:15118:2:2013:MsgDataTypes":duration{0-1})',  derivedBy='EXTENSION'.  */
	struct iso1RelativeTimeIntervalType RelativeTimeInterval ;
	unsigned int RelativeTimeInterval_isUsed:1;
	/* element: "urn:iso:15118:2:2013:MsgDataTypes":EPriceLevel, http://www.w3.org/2001/XMLSchema,unsignedByte */
	uint8_t EPriceLevel ;
	unsigned int EPriceLevel_isUsed:1;
	/* element: "urn:iso:15118:2:2013:MsgDataTypes":ConsumptionCost, Complex type name='urn:iso:15118:2:2013:MsgDataTypes,ConsumptionCostType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2013:MsgDataTypes":startValue,"urn:iso:15118:2:2013:MsgDataTypes":Cost{1-3})',  derivedBy='RESTRICTION'.  */
	struct {
		struct iso1ConsumptionCostType array[iso1SalesTariffEntryType_ConsumptionCost_ARRAY_SIZE];
		uint16_t arrayLen;
	} ConsumptionCost;
};

/* Complex type name='urn:iso:15118:2:2013:MsgDataTypes,SalesTariffType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2013:MsgDataTypes":SalesTariffID,"urn:iso:15118:2:2013:MsgDataTypes":SalesTariffDescription{0-1},"urn:iso:15118:2:2013:MsgDataTypes":NumEPriceLevels{0-1},"urn:iso:15118:2:2013:MsgDataTypes":SalesTariffEntry{1-UNBOUNDED})',  derivedBy='RESTRICTION'.  */
#define iso1SalesTariffType_Id_CHARACTERS_SIZE 50 + EXTRA_CHAR 
#define iso1SalesTariffType_SalesTariffDescription_CHARACTERS_SIZE 32 + EXTRA_CHAR /* XML schema facet maxLength for urn:iso:15118:2:2013:MsgDataTypes,tariffDescriptionType is 32 */
#define iso1SalesTariffType_SalesTariffEntry_ARRAY_SIZE 5
struct iso1SalesTariffType {
	/* attribute: Id {http://www.w3.org/2001/XMLSchema,ID} */
	struct {
		exi_string_character_t characters[iso1SalesTariffType_Id_CHARACTERS_SIZE];
		uint16_t charactersLen;
	}  Id ;
	unsigned int Id_isUsed:1;
	/* element: "urn:iso:15118:2:2013:MsgDataTypes":SalesTariffID, urn:iso:15118:2:2013:MsgDataTypes,SAIDType */
	uint8_t SalesTariffID ;
	/* element: "urn:iso:15118:2:2013:MsgDataTypes":SalesTariffDescription, urn:iso:15118:2:2013:MsgDataTypes,tariffDescriptionType */
	struct {
		exi_string_character_t characters[iso1SalesTariffType_SalesTariffDescription_CHARACTERS_SIZE];
		uint16_t charactersLen;
	}  SalesTariffDescription ;
	unsigned int SalesTariffDescription_isUsed:1;
	/* element: "urn:iso:15118:2:2013:MsgDataTypes":NumEPriceLevels, http://www.w3.org/2001/XMLSchema,unsignedByte */
	uint8_t NumEPriceLevels ;
	unsigned int NumEPriceLevels_isUsed:1;
	/* element: "urn:iso:15118:2:2013:MsgDataTypes":SalesTariffEntry, Complex type name='urn:iso:15118:2:2013:MsgDataTypes,SalesTariffEntryType',  base type name='EntryType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='(("urn:iso:15118:2:2013:MsgDataTypes":TimeInterval),("urn:iso:15118:2:2013:MsgDataTypes":EPriceLevel{0-1},"urn:iso:15118:2:2013:MsgDataTypes":ConsumptionCost{0-3}))',  derivedBy='EXTENSION'.  */
	struct {
		struct iso1SalesTariffEntryType array[iso1SalesTariffType_SalesTariffEntry_ARRAY_SIZE];
		uint16_t arrayLen;
	} SalesTariffEntry;
};

/* Complex type name='http://www.w3.org/2000/09/xmldsig#,SignatureType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("http://www.w3.org/2000/09/xmldsig#":SignedInfo,"http://www.w3.org/2000/09/xmldsig#":SignatureValue,"http://www.w3.org/2000/09/xmldsig#":KeyInfo{0-1},"http://www.w3.org/2000/09/xmldsig#":Object{0-UNBOUNDED})',  derivedBy='RESTRICTION'.  */
#define iso1SignatureType_Id_CHARACTERS_SIZE 50 + EXTRA_CHAR 
#define iso1SignatureType_Object_ARRAY_SIZE 1
struct iso1SignatureType {
	/* attribute: Id {http://www.w3.org/2001/XMLSchema,ID} */
	struct {
		exi_string_character_t characters[iso1SignatureType_Id_CHARACTERS_SIZE];
		uint16_t charactersLen;
	}  Id ;
	unsigned int Id_isUsed:1;
	/* element: "http://www.w3.org/2000/09/xmldsig#":SignedInfo, Complex type name='http://www.w3.org/2000/09/xmldsig#,SignedInfoType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("http://www.w3.org/2000/09/xmldsig#":CanonicalizationMethod,"http://www.w3.org/2000/09/xmldsig#":SignatureMethod,"http://www.w3.org/2000/09/xmldsig#":Reference{1-UNBOUNDED})',  derivedBy='RESTRICTION'.  */
	struct iso1SignedInfoType SignedInfo ;
	/* element: "http://www.w3.org/2000/09/xmldsig#":SignatureValue, Complex type name='http://www.w3.org/2000/09/xmldsig#,SignatureValueType',  base type name='base64Binary',  content type='SIMPLE',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  derivedBy='EXTENSION'.  */
	struct iso1SignatureValueType SignatureValue ;
	/* element: "http://www.w3.org/2000/09/xmldsig#":KeyInfo, Complex type name='http://www.w3.org/2000/09/xmldsig#,KeyInfoType',  base type name='anyType',  content type='MIXED',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("http://www.w3.org/2000/09/xmldsig#":KeyName|"http://www.w3.org/2000/09/xmldsig#":KeyValue|"http://www.w3.org/2000/09/xmldsig#":RetrievalMethod|"http://www.w3.org/2000/09/xmldsig#":X509Data|"http://www.w3.org/2000/09/xmldsig#":PGPData|"http://www.w3.org/2000/09/xmldsig#":SPKIData|"http://www.w3.org/2000/09/xmldsig#":MgmtData|(WC[##other:"http://www.w3.org/2000/09/xmldsig#"])){1-UNBOUNDED}',  derivedBy='RESTRICTION'.  */
	struct iso1KeyInfoType KeyInfo ;
	unsigned int KeyInfo_isUsed:1;
	/* element: "http://www.w3.org/2000/09/xmldsig#":Object, Complex type name='http://www.w3.org/2000/09/xmldsig#,ObjectType',  base type name='anyType',  content type='MIXED',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='((WC[##any])){0-UNBOUNDED}',  derivedBy='RESTRICTION'.  */
	struct {
		struct iso1ObjectType array[iso1SignatureType_Object_ARRAY_SIZE];
		uint16_t arrayLen;
	} Object;
};

/* Complex type name='urn:iso:15118:2:2013:MsgBody,PowerDeliveryReqType',  base type name='BodyBaseType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2013:MsgBody":ChargeProgress,"urn:iso:15118:2:2013:MsgBody":SAScheduleTupleID,"urn:iso:15118:2:2013:MsgBody":ChargingProfile{0-1},"urn:iso:15118:2:2013:MsgDataTypes":EVPowerDeliveryParameter{0-1})',  derivedBy='EXTENSION'.  */
struct iso1PowerDeliveryReqType {
	/* element: "urn:iso:15118:2:2013:MsgBody":ChargeProgress, urn:iso:15118:2:2013:MsgDataTypes,chargeProgressType */
	iso1chargeProgressType ChargeProgress ;
	/* element: "urn:iso:15118:2:2013:MsgBody":SAScheduleTupleID, urn:iso:15118:2:2013:MsgDataTypes,SAIDType */
	uint8_t SAScheduleTupleID ;
	/* element: "urn:iso:15118:2:2013:MsgBody":ChargingProfile, Complex type name='urn:iso:15118:2:2013:MsgDataTypes,ChargingProfileType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2013:MsgDataTypes":ProfileEntry{1-24})',  derivedBy='RESTRICTION'.  */
	struct iso1ChargingProfileType ChargingProfile ;
	unsigned int ChargingProfile_isUsed:1;
	/* element: "urn:iso:15118:2:2013:MsgDataTypes":EVPowerDeliveryParameter, Complex type name='urn:iso:15118:2:2013:MsgDataTypes,EVPowerDeliveryParameterType',  base type name='anyType',  content type='EMPTY',  isAbstract='true',  hasTypeId='false',  final='0',  block='0',  derivedBy='RESTRICTION'.  */
	struct iso1EVPowerDeliveryParameterType EVPowerDeliveryParameter ;
	unsigned int EVPowerDeliveryParameter_isUsed:1;
	/* element: "urn:iso:15118:2:2013:MsgDataTypes":DC_EVPowerDeliveryParameter, Complex type name='urn:iso:15118:2:2013:MsgDataTypes,DC_EVPowerDeliveryParameterType',  base type name='EVPowerDeliveryParameterType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2013:MsgDataTypes":DC_EVStatus,"urn:iso:15118:2:2013:MsgDataTypes":BulkChargingComplete{0-1},"urn:iso:15118:2:2013:MsgDataTypes":ChargingComplete)',  derivedBy='EXTENSION'.  */
	struct iso1DC_EVPowerDeliveryParameterType DC_EVPowerDeliveryParameter ;
	unsigned int DC_EVPowerDeliveryParameter_isUsed:1;
};

/* Complex type name='urn:iso:15118:2:2013:MsgDataTypes,ServiceParameterListType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2013:MsgDataTypes":ParameterSet{1-UNBOUNDED})',  derivedBy='RESTRICTION'.  */
#define iso1ServiceParameterListType_ParameterSet_ARRAY_SIZE 5
struct iso1ServiceParameterListType {
	/* element: "urn:iso:15118:2:2013:MsgDataTypes":ParameterSet, Complex type name='urn:iso:15118:2:2013:MsgDataTypes,ParameterSetType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2013:MsgDataTypes":ParameterSetID,"urn:iso:15118:2:2013:MsgDataTypes":Parameter{1-16})',  derivedBy='RESTRICTION'.  */
	struct {
		struct iso1ParameterSetType array[iso1ServiceParameterListType_ParameterSet_ARRAY_SIZE];
		uint16_t arrayLen;
	} ParameterSet;
};

/* Complex type name='urn:iso:15118:2:2013:MsgBody,ServiceDetailResType',  base type name='BodyBaseType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2013:MsgBody":ResponseCode,"urn:iso:15118:2:2013:MsgBody":ServiceID,"urn:iso:15118:2:2013:MsgBody":ServiceParameterList{0-1})',  derivedBy='EXTENSION'.  */
struct iso1ServiceDetailResType {
	/* element: "urn:iso:15118:2:2013:MsgBody":ResponseCode, urn:iso:15118:2:2013:MsgDataTypes,responseCodeType */
	iso1responseCodeType ResponseCode ;
	/* element: "urn:iso:15118:2:2013:MsgBody":ServiceID, urn:iso:15118:2:2013:MsgDataTypes,serviceIDType */
	uint16_t ServiceID ;
	/* element: "urn:iso:15118:2:2013:MsgBody":ServiceParameterList, Complex type name='urn:iso:15118:2:2013:MsgDataTypes,ServiceParameterListType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2013:MsgDataTypes":ParameterSet{1-UNBOUNDED})',  derivedBy='RESTRICTION'.  */
	struct iso1ServiceParameterListType ServiceParameterList ;
	unsigned int ServiceParameterList_isUsed:1;
};

/* Complex type name='urn:iso:15118:2:2013:MsgDataTypes,SAScheduleTupleType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2013:MsgDataTypes":SAScheduleTupleID,"urn:iso:15118:2:2013:MsgDataTypes":PMaxSchedule,"urn:iso:15118:2:2013:MsgDataTypes":SalesTariff{0-1})',  derivedBy='RESTRICTION'.  */
struct iso1SAScheduleTupleType {
	/* element: "urn:iso:15118:2:2013:MsgDataTypes":SAScheduleTupleID, urn:iso:15118:2:2013:MsgDataTypes,SAIDType */
	uint8_t SAScheduleTupleID ;
	/* element: "urn:iso:15118:2:2013:MsgDataTypes":PMaxSchedule, Complex type name='urn:iso:15118:2:2013:MsgDataTypes,PMaxScheduleType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2013:MsgDataTypes":PMaxScheduleEntry{1-UNBOUNDED})',  derivedBy='RESTRICTION'.  */
	struct iso1PMaxScheduleType PMaxSchedule ;
	/* element: "urn:iso:15118:2:2013:MsgDataTypes":SalesTariff, Complex type name='urn:iso:15118:2:2013:MsgDataTypes,SalesTariffType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2013:MsgDataTypes":SalesTariffID,"urn:iso:15118:2:2013:MsgDataTypes":SalesTariffDescription{0-1},"urn:iso:15118:2:2013:MsgDataTypes":NumEPriceLevels{0-1},"urn:iso:15118:2:2013:MsgDataTypes":SalesTariffEntry{1-UNBOUNDED})',  derivedBy='RESTRICTION'.  */
	struct iso1SalesTariffType SalesTariff ;
	unsigned int SalesTariff_isUsed:1;
};

/* Complex type name='urn:iso:15118:2:2013:MsgHeader,MessageHeaderType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2013:MsgHeader":SessionID,"urn:iso:15118:2:2013:MsgHeader":Notification{0-1},"http://www.w3.org/2000/09/xmldsig#":Signature{0-1})',  derivedBy='RESTRICTION'.  */
#define iso1MessageHeaderType_SessionID_BYTES_SIZE 8 /* XML schema facet maxLength for urn:iso:15118:2:2013:MsgDataTypes,sessionIDType is 8 */
struct iso1MessageHeaderType {
	/* element: "urn:iso:15118:2:2013:MsgHeader":SessionID, urn:iso:15118:2:2013:MsgDataTypes,sessionIDType */
	struct {
		uint8_t bytes[iso1MessageHeaderType_SessionID_BYTES_SIZE];
		uint16_t bytesLen;
	}  SessionID ;
	/* element: "urn:iso:15118:2:2013:MsgHeader":Notification, Complex type name='urn:iso:15118:2:2013:MsgDataTypes,NotificationType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2013:MsgDataTypes":FaultCode,"urn:iso:15118:2:2013:MsgDataTypes":FaultMsg{0-1})',  derivedBy='RESTRICTION'.  */
	struct iso1NotificationType Notification ;
	unsigned int Notification_isUsed:1;
	/* element: "http://www.w3.org/2000/09/xmldsig#":Signature, Complex type name='http://www.w3.org/2000/09/xmldsig#,SignatureType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("http://www.w3.org/2000/09/xmldsig#":SignedInfo,"http://www.w3.org/2000/09/xmldsig#":SignatureValue,"http://www.w3.org/2000/09/xmldsig#":KeyInfo{0-1},"http://www.w3.org/2000/09/xmldsig#":Object{0-UNBOUNDED})',  derivedBy='RESTRICTION'.  */
	struct iso1SignatureType Signature ;
	unsigned int Signature_isUsed:1;
};

/* Complex type name='urn:iso:15118:2:2013:MsgDataTypes,SAScheduleListType',  base type name='SASchedulesType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2013:MsgDataTypes":SAScheduleTuple{1-3})',  derivedBy='EXTENSION'.  */
#define iso1SAScheduleListType_SAScheduleTuple_ARRAY_SIZE 3
struct iso1SAScheduleListType {
	/* element: "urn:iso:15118:2:2013:MsgDataTypes":SAScheduleTuple, Complex type name='urn:iso:15118:2:2013:MsgDataTypes,SAScheduleTupleType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2013:MsgDataTypes":SAScheduleTupleID,"urn:iso:15118:2:2013:MsgDataTypes":PMaxSchedule,"urn:iso:15118:2:2013:MsgDataTypes":SalesTariff{0-1})',  derivedBy='RESTRICTION'.  */
	struct {
		struct iso1SAScheduleTupleType array[iso1SAScheduleListType_SAScheduleTuple_ARRAY_SIZE];
		uint16_t arrayLen;
	} SAScheduleTuple;
};

/* Complex type name='urn:iso:15118:2:2013:MsgBody,ChargeParameterDiscoveryResType',  base type name='BodyBaseType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2013:MsgBody":ResponseCode,"urn:iso:15118:2:2013:MsgBody":EVSEProcessing,"urn:iso:15118:2:2013:MsgDataTypes":SASchedules{0-1},"urn:iso:15118:2:2013:MsgDataTypes":EVSEChargeParameter)',  derivedBy='EXTENSION'.  */
struct iso1ChargeParameterDiscoveryResType {
	/* element: "urn:iso:15118:2:2013:MsgBody":ResponseCode, urn:iso:15118:2:2013:MsgDataTypes,responseCodeType */
	iso1responseCodeType ResponseCode ;
	/* element: "urn:iso:15118:2:2013:MsgBody":EVSEProcessing, urn:iso:15118:2:2013:MsgDataTypes,EVSEProcessingType */
	iso1EVSEProcessingType EVSEProcessing ;
	/* element: "urn:iso:15118:2:2013:MsgDataTypes":SASchedules, Complex type name='urn:iso:15118:2:2013:MsgDataTypes,SASchedulesType',  base type name='anyType',  content type='EMPTY',  isAbstract='true',  hasTypeId='false',  final='0',  block='0',  derivedBy='RESTRICTION'.  */
	struct iso1SASchedulesType SASchedules ;
	unsigned int SASchedules_isUsed:1;
	/* element: "urn:iso:15118:2:2013:MsgDataTypes":SAScheduleList, Complex type name='urn:iso:15118:2:2013:MsgDataTypes,SAScheduleListType',  base type name='SASchedulesType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2013:MsgDataTypes":SAScheduleTuple{1-3})',  derivedBy='EXTENSION'.  */
	struct iso1SAScheduleListType SAScheduleList ;
	unsigned int SAScheduleList_isUsed:1;
	/* element: "urn:iso:15118:2:2013:MsgDataTypes":EVSEChargeParameter, Complex type name='urn:iso:15118:2:2013:MsgDataTypes,EVSEChargeParameterType',  base type name='anyType',  content type='EMPTY',  isAbstract='true',  hasTypeId='false',  final='0',  block='0',  derivedBy='RESTRICTION'.  */
	struct iso1EVSEChargeParameterType EVSEChargeParameter ;
	unsigned int EVSEChargeParameter_isUsed:1;
	/* element: "urn:iso:15118:2:2013:MsgDataTypes":AC_EVSEChargeParameter, Complex type name='urn:iso:15118:2:2013:MsgDataTypes,AC_EVSEChargeParameterType',  base type name='EVSEChargeParameterType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2013:MsgDataTypes":AC_EVSEStatus,"urn:iso:15118:2:2013:MsgDataTypes":EVSENominalVoltage,"urn:iso:15118:2:2013:MsgDataTypes":EVSEMaxCurrent)',  derivedBy='EXTENSION'.  */
	struct iso1AC_EVSEChargeParameterType AC_EVSEChargeParameter ;
	unsigned int AC_EVSEChargeParameter_isUsed:1;
	/* element: "urn:iso:15118:2:2013:MsgDataTypes":DC_EVSEChargeParameter, Complex type name='urn:iso:15118:2:2013:MsgDataTypes,DC_EVSEChargeParameterType',  base type name='EVSEChargeParameterType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2013:MsgDataTypes":DC_EVSEStatus,"urn:iso:15118:2:2013:MsgDataTypes":EVSEMaximumCurrentLimit,"urn:iso:15118:2:2013:MsgDataTypes":EVSEMaximumPowerLimit,"urn:iso:15118:2:2013:MsgDataTypes":EVSEMaximumVoltageLimit,"urn:iso:15118:2:2013:MsgDataTypes":EVSEMinimumCurrentLimit,"urn:iso:15118:2:2013:MsgDataTypes":EVSEMinimumVoltageLimit,"urn:iso:15118:2:2013:MsgDataTypes":EVSECurrentRegulationTolerance{0-1},"urn:iso:15118:2:2013:MsgDataTypes":EVSEPeakCurrentRipple,"urn:iso:15118:2:2013:MsgDataTypes":EVSEEnergyToBeDelivered{0-1})',  derivedBy='EXTENSION'.  */
	struct iso1DC_EVSEChargeParameterType DC_EVSEChargeParameter ;
	unsigned int DC_EVSEChargeParameter_isUsed:1;
};

/* Complex type name='urn:iso:15118:2:2013:MsgBody,BodyType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2013:MsgBody":BodyElement{0-1})',  derivedBy='RESTRICTION'.  */
struct iso1BodyType {
	/* substitutionGroup */
#if SAVE_MEMORY_WITH_UNNAMED_UNION == UNION_YES
	union {
#endif /* SAVE_MEMORY_WITH_UNNAMED_UNION == UNION_YES */ 
		/* element: "urn:iso:15118:2:2013:MsgBody":BodyElement, Complex type name='urn:iso:15118:2:2013:MsgBody,BodyBaseType',  base type name='anyType',  content type='EMPTY',  isAbstract='true',  hasTypeId='false',  final='0',  block='0',  derivedBy='RESTRICTION'.  */
		struct iso1BodyBaseType BodyElement ;
		/* element: "urn:iso:15118:2:2013:MsgBody":SessionSetupReq, Complex type name='urn:iso:15118:2:2013:MsgBody,SessionSetupReqType',  base type name='BodyBaseType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2013:MsgBody":EVCCID)',  derivedBy='EXTENSION'.  */
		struct iso1SessionSetupReqType SessionSetupReq ;
		/* element: "urn:iso:15118:2:2013:MsgBody":SessionSetupRes, Complex type name='urn:iso:15118:2:2013:MsgBody,SessionSetupResType',  base type name='BodyBaseType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2013:MsgBody":ResponseCode,"urn:iso:15118:2:2013:MsgBody":EVSEID,"urn:iso:15118:2:2013:MsgBody":EVSETimeStamp{0-1})',  derivedBy='EXTENSION'.  */
		struct iso1SessionSetupResType SessionSetupRes ;
		/* element: "urn:iso:15118:2:2013:MsgBody":ServiceDiscoveryReq, Complex type name='urn:iso:15118:2:2013:MsgBody,ServiceDiscoveryReqType',  base type name='BodyBaseType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2013:MsgBody":ServiceScope{0-1},"urn:iso:15118:2:2013:MsgBody":ServiceCategory{0-1})',  derivedBy='EXTENSION'.  */
		struct iso1ServiceDiscoveryReqType ServiceDiscoveryReq ;
		/* element: "urn:iso:15118:2:2013:MsgBody":ServiceDiscoveryRes, Complex type name='urn:iso:15118:2:2013:MsgBody,ServiceDiscoveryResType',  base type name='BodyBaseType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2013:MsgBody":ResponseCode,"urn:iso:15118:2:2013:MsgBody":PaymentOptionList,"urn:iso:15118:2:2013:MsgBody":ChargeService,"urn:iso:15118:2:2013:MsgBody":ServiceList{0-1})',  derivedBy='EXTENSION'.  */
		struct iso1ServiceDiscoveryResType ServiceDiscoveryRes ;
		/* element: "urn:iso:15118:2:2013:MsgBody":ServiceDetailReq, Complex type name='urn:iso:15118:2:2013:MsgBody,ServiceDetailReqType',  base type name='BodyBaseType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2013:MsgBody":ServiceID)',  derivedBy='EXTENSION'.  */
		struct iso1ServiceDetailReqType ServiceDetailReq ;
		/* element: "urn:iso:15118:2:2013:MsgBody":ServiceDetailRes, Complex type name='urn:iso:15118:2:2013:MsgBody,ServiceDetailResType',  base type name='BodyBaseType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2013:MsgBody":ResponseCode,"urn:iso:15118:2:2013:MsgBody":ServiceID,"urn:iso:15118:2:2013:MsgBody":ServiceParameterList{0-1})',  derivedBy='EXTENSION'.  */
		struct iso1ServiceDetailResType ServiceDetailRes ;
		/* element: "urn:iso:15118:2:2013:MsgBody":PaymentServiceSelectionReq, Complex type name='urn:iso:15118:2:2013:MsgBody,PaymentServiceSelectionReqType',  base type name='BodyBaseType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2013:MsgBody":SelectedPaymentOption,"urn:iso:15118:2:2013:MsgBody":SelectedServiceList)',  derivedBy='EXTENSION'.  */
		struct iso1PaymentServiceSelectionReqType PaymentServiceSelectionReq ;
		/* element: "urn:iso:15118:2:2013:MsgBody":PaymentServiceSelectionRes, Complex type name='urn:iso:15118:2:2013:MsgBody,PaymentServiceSelectionResType',  base type name='BodyBaseType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2013:MsgBody":ResponseCode)',  derivedBy='EXTENSION'.  */
		struct iso1PaymentServiceSelectionResType PaymentServiceSelectionRes ;
		/* element: "urn:iso:15118:2:2013:MsgBody":PaymentDetailsReq, Complex type name='urn:iso:15118:2:2013:MsgBody,PaymentDetailsReqType',  base type name='BodyBaseType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2013:MsgBody":eMAID,"urn:iso:15118:2:2013:MsgBody":ContractSignatureCertChain)',  derivedBy='EXTENSION'.  */
		struct iso1PaymentDetailsReqType PaymentDetailsReq ;
		/* element: "urn:iso:15118:2:2013:MsgBody":PaymentDetailsRes, Complex type name='urn:iso:15118:2:2013:MsgBody,PaymentDetailsResType',  base type name='BodyBaseType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2013:MsgBody":ResponseCode,"urn:iso:15118:2:2013:MsgBody":GenChallenge,"urn:iso:15118:2:2013:MsgBody":EVSETimeStamp)',  derivedBy='EXTENSION'.  */
		struct iso1PaymentDetailsResType PaymentDetailsRes ;
		/* element: "urn:iso:15118:2:2013:MsgBody":AuthorizationReq, Complex type name='urn:iso:15118:2:2013:MsgBody,AuthorizationReqType',  base type name='BodyBaseType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2013:MsgBody":GenChallenge{0-1})',  derivedBy='EXTENSION'.  */
		struct iso1AuthorizationReqType AuthorizationReq ;
		/* element: "urn:iso:15118:2:2013:MsgBody":AuthorizationRes, Complex type name='urn:iso:15118:2:2013:MsgBody,AuthorizationResType',  base type name='BodyBaseType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2013:MsgBody":ResponseCode,"urn:iso:15118:2:2013:MsgBody":EVSEProcessing)',  derivedBy='EXTENSION'.  */
		struct iso1AuthorizationResType AuthorizationRes ;
		/* element: "urn:iso:15118:2:2013:MsgBody":ChargeParameterDiscoveryReq, Complex type name='urn:iso:15118:2:2013:MsgBody,ChargeParameterDiscoveryReqType',  base type name='BodyBaseType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2013:MsgBody":MaxEntriesSAScheduleTuple{0-1},"urn:iso:15118:2:2013:MsgBody":RequestedEnergyTransferMode,"urn:iso:15118:2:2013:MsgDataTypes":EVChargeParameter)',  derivedBy='EXTENSION'.  */
		struct iso1ChargeParameterDiscoveryReqType ChargeParameterDiscoveryReq ;
		/* element: "urn:iso:15118:2:2013:MsgBody":ChargeParameterDiscoveryRes, Complex type name='urn:iso:15118:2:2013:MsgBody,ChargeParameterDiscoveryResType',  base type name='BodyBaseType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2013:MsgBody":ResponseCode,"urn:iso:15118:2:2013:MsgBody":EVSEProcessing,"urn:iso:15118:2:2013:MsgDataTypes":SASchedules{0-1},"urn:iso:15118:2:2013:MsgDataTypes":EVSEChargeParameter)',  derivedBy='EXTENSION'.  */
		struct iso1ChargeParameterDiscoveryResType ChargeParameterDiscoveryRes ;
		/* element: "urn:iso:15118:2:2013:MsgBody":PowerDeliveryReq, Complex type name='urn:iso:15118:2:2013:MsgBody,PowerDeliveryReqType',  base type name='BodyBaseType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2013:MsgBody":ChargeProgress,"urn:iso:15118:2:2013:MsgBody":SAScheduleTupleID,"urn:iso:15118:2:2013:MsgBody":ChargingProfile{0-1},"urn:iso:15118:2:2013:MsgDataTypes":EVPowerDeliveryParameter{0-1})',  derivedBy='EXTENSION'.  */
		struct iso1PowerDeliveryReqType PowerDeliveryReq ;
		/* element: "urn:iso:15118:2:2013:MsgBody":PowerDeliveryRes, Complex type name='urn:iso:15118:2:2013:MsgBody,PowerDeliveryResType',  base type name='BodyBaseType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2013:MsgBody":ResponseCode,"urn:iso:15118:2:2013:MsgDataTypes":EVSEStatus)',  derivedBy='EXTENSION'.  */
		struct iso1PowerDeliveryResType PowerDeliveryRes ;
		/* element: "urn:iso:15118:2:2013:MsgBody":MeteringReceiptReq, Complex type name='urn:iso:15118:2:2013:MsgBody,MeteringReceiptReqType',  base type name='BodyBaseType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2013:MsgBody":SessionID,"urn:iso:15118:2:2013:MsgBody":SAScheduleTupleID{0-1},"urn:iso:15118:2:2013:MsgBody":MeterInfo)',  derivedBy='EXTENSION'.  */
		struct iso1MeteringReceiptReqType MeteringReceiptReq ;
		/* element: "urn:iso:15118:2:2013:MsgBody":MeteringReceiptRes, Complex type name='urn:iso:15118:2:2013:MsgBody,MeteringReceiptResType',  base type name='BodyBaseType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2013:MsgBody":ResponseCode,"urn:iso:15118:2:2013:MsgDataTypes":EVSEStatus)',  derivedBy='EXTENSION'.  */
		struct iso1MeteringReceiptResType MeteringReceiptRes ;
		/* element: "urn:iso:15118:2:2013:MsgBody":SessionStopReq, Complex type name='urn:iso:15118:2:2013:MsgBody,SessionStopReqType',  base type name='BodyBaseType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2013:MsgBody":ChargingSession)',  derivedBy='EXTENSION'.  */
		struct iso1SessionStopReqType SessionStopReq ;
		/* element: "urn:iso:15118:2:2013:MsgBody":SessionStopRes, Complex type name='urn:iso:15118:2:2013:MsgBody,SessionStopResType',  base type name='BodyBaseType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2013:MsgBody":ResponseCode)',  derivedBy='EXTENSION'.  */
		struct iso1SessionStopResType SessionStopRes ;
		/* element: "urn:iso:15118:2:2013:MsgBody":CertificateUpdateReq, Complex type name='urn:iso:15118:2:2013:MsgBody,CertificateUpdateReqType',  base type name='BodyBaseType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2013:MsgBody":ContractSignatureCertChain,"urn:iso:15118:2:2013:MsgBody":eMAID,"urn:iso:15118:2:2013:MsgBody":ListOfRootCertificateIDs)',  derivedBy='EXTENSION'.  */
		struct iso1CertificateUpdateReqType CertificateUpdateReq ;
		/* element: "urn:iso:15118:2:2013:MsgBody":CertificateUpdateRes, Complex type name='urn:iso:15118:2:2013:MsgBody,CertificateUpdateResType',  base type name='BodyBaseType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2013:MsgBody":ResponseCode,"urn:iso:15118:2:2013:MsgBody":SAProvisioningCertificateChain,"urn:iso:15118:2:2013:MsgBody":ContractSignatureCertChain,"urn:iso:15118:2:2013:MsgBody":ContractSignatureEncryptedPrivateKey,"urn:iso:15118:2:2013:MsgBody":DHpublickey,"urn:iso:15118:2:2013:MsgBody":eMAID,"urn:iso:15118:2:2013:MsgBody":RetryCounter{0-1})',  derivedBy='EXTENSION'.  */
		struct iso1CertificateUpdateResType CertificateUpdateRes ;
		/* element: "urn:iso:15118:2:2013:MsgBody":CertificateInstallationReq, Complex type name='urn:iso:15118:2:2013:MsgBody,CertificateInstallationReqType',  base type name='BodyBaseType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2013:MsgBody":OEMProvisioningCert,"urn:iso:15118:2:2013:MsgBody":ListOfRootCertificateIDs)',  derivedBy='EXTENSION'.  */
		struct iso1CertificateInstallationReqType CertificateInstallationReq ;
		/* element: "urn:iso:15118:2:2013:MsgBody":CertificateInstallationRes, Complex type name='urn:iso:15118:2:2013:MsgBody,CertificateInstallationResType',  base type name='BodyBaseType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2013:MsgBody":ResponseCode,"urn:iso:15118:2:2013:MsgBody":SAProvisioningCertificateChain,"urn:iso:15118:2:2013:MsgBody":ContractSignatureCertChain,"urn:iso:15118:2:2013:MsgBody":ContractSignatureEncryptedPrivateKey,"urn:iso:15118:2:2013:MsgBody":DHpublickey,"urn:iso:15118:2:2013:MsgBody":eMAID)',  derivedBy='EXTENSION'.  */
		struct iso1CertificateInstallationResType CertificateInstallationRes ;
		/* element: "urn:iso:15118:2:2013:MsgBody":ChargingStatusReq, Complex type name='urn:iso:15118:2:2013:MsgBody,ChargingStatusReqType',  base type name='BodyBaseType',  content type='EMPTY',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  derivedBy='EXTENSION'.  */
		struct iso1ChargingStatusReqType ChargingStatusReq ;
		/* element: "urn:iso:15118:2:2013:MsgBody":ChargingStatusRes, Complex type name='urn:iso:15118:2:2013:MsgBody,ChargingStatusResType',  base type name='BodyBaseType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2013:MsgBody":ResponseCode,"urn:iso:15118:2:2013:MsgBody":EVSEID,"urn:iso:15118:2:2013:MsgBody":SAScheduleTupleID,"urn:iso:15118:2:2013:MsgBody":EVSEMaxCurrent{0-1},"urn:iso:15118:2:2013:MsgBody":MeterInfo{0-1},"urn:iso:15118:2:2013:MsgBody":ReceiptRequired{0-1},"urn:iso:15118:2:2013:MsgBody":AC_EVSEStatus)',  derivedBy='EXTENSION'.  */
		struct iso1ChargingStatusResType ChargingStatusRes ;
		/* element: "urn:iso:15118:2:2013:MsgBody":CableCheckReq, Complex type name='urn:iso:15118:2:2013:MsgBody,CableCheckReqType',  base type name='BodyBaseType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2013:MsgBody":DC_EVStatus)',  derivedBy='EXTENSION'.  */
		struct iso1CableCheckReqType CableCheckReq ;
		/* element: "urn:iso:15118:2:2013:MsgBody":CableCheckRes, Complex type name='urn:iso:15118:2:2013:MsgBody,CableCheckResType',  base type name='BodyBaseType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2013:MsgBody":ResponseCode,"urn:iso:15118:2:2013:MsgBody":DC_EVSEStatus,"urn:iso:15118:2:2013:MsgBody":EVSEProcessing)',  derivedBy='EXTENSION'.  */
		struct iso1CableCheckResType CableCheckRes ;
		/* element: "urn:iso:15118:2:2013:MsgBody":PreChargeReq, Complex type name='urn:iso:15118:2:2013:MsgBody,PreChargeReqType',  base type name='BodyBaseType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2013:MsgBody":DC_EVStatus,"urn:iso:15118:2:2013:MsgBody":EVTargetVoltage,"urn:iso:15118:2:2013:MsgBody":EVTargetCurrent)',  derivedBy='EXTENSION'.  */
		struct iso1PreChargeReqType PreChargeReq ;
		/* element: "urn:iso:15118:2:2013:MsgBody":PreChargeRes, Complex type name='urn:iso:15118:2:2013:MsgBody,PreChargeResType',  base type name='BodyBaseType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2013:MsgBody":ResponseCode,"urn:iso:15118:2:2013:MsgBody":DC_EVSEStatus,"urn:iso:15118:2:2013:MsgBody":EVSEPresentVoltage)',  derivedBy='EXTENSION'.  */
		struct iso1PreChargeResType PreChargeRes ;
		/* element: "urn:iso:15118:2:2013:MsgBody":CurrentDemandReq, Complex type name='urn:iso:15118:2:2013:MsgBody,CurrentDemandReqType',  base type name='BodyBaseType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2013:MsgBody":DC_EVStatus,"urn:iso:15118:2:2013:MsgBody":EVTargetCurrent,"urn:iso:15118:2:2013:MsgBody":EVMaximumVoltageLimit{0-1},"urn:iso:15118:2:2013:MsgBody":EVMaximumCurrentLimit{0-1},"urn:iso:15118:2:2013:MsgBody":EVMaximumPowerLimit{0-1},"urn:iso:15118:2:2013:MsgBody":BulkChargingComplete{0-1},"urn:iso:15118:2:2013:MsgBody":ChargingComplete,"urn:iso:15118:2:2013:MsgBody":RemainingTimeToFullSoC{0-1},"urn:iso:15118:2:2013:MsgBody":RemainingTimeToBulkSoC{0-1},"urn:iso:15118:2:2013:MsgBody":EVTargetVoltage)',  derivedBy='EXTENSION'.  */
		struct iso1CurrentDemandReqType CurrentDemandReq ;
		/* element: "urn:iso:15118:2:2013:MsgBody":CurrentDemandRes, Complex type name='urn:iso:15118:2:2013:MsgBody,CurrentDemandResType',  base type name='BodyBaseType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2013:MsgBody":ResponseCode,"urn:iso:15118:2:2013:MsgBody":DC_EVSEStatus,"urn:iso:15118:2:2013:MsgBody":EVSEPresentVoltage,"urn:iso:15118:2:2013:MsgBody":EVSEPresentCurrent,"urn:iso:15118:2:2013:MsgBody":EVSECurrentLimitAchieved,"urn:iso:15118:2:2013:MsgBody":EVSEVoltageLimitAchieved,"urn:iso:15118:2:2013:MsgBody":EVSEPowerLimitAchieved,"urn:iso:15118:2:2013:MsgBody":EVSEMaximumVoltageLimit{0-1},"urn:iso:15118:2:2013:MsgBody":EVSEMaximumCurrentLimit{0-1},"urn:iso:15118:2:2013:MsgBody":EVSEMaximumPowerLimit{0-1},"urn:iso:15118:2:2013:MsgBody":EVSEID,"urn:iso:15118:2:2013:MsgBody":SAScheduleTupleID,"urn:iso:15118:2:2013:MsgBody":MeterInfo{0-1},"urn:iso:15118:2:2013:MsgBody":ReceiptRequired{0-1})',  derivedBy='EXTENSION'.  */
		struct iso1CurrentDemandResType CurrentDemandRes ;
		/* element: "urn:iso:15118:2:2013:MsgBody":WeldingDetectionReq, Complex type name='urn:iso:15118:2:2013:MsgBody,WeldingDetectionReqType',  base type name='BodyBaseType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2013:MsgBody":DC_EVStatus)',  derivedBy='EXTENSION'.  */
		struct iso1WeldingDetectionReqType WeldingDetectionReq ;
		/* element: "urn:iso:15118:2:2013:MsgBody":WeldingDetectionRes, Complex type name='urn:iso:15118:2:2013:MsgBody,WeldingDetectionResType',  base type name='BodyBaseType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2013:MsgBody":ResponseCode,"urn:iso:15118:2:2013:MsgBody":DC_EVSEStatus,"urn:iso:15118:2:2013:MsgBody":EVSEPresentVoltage)',  derivedBy='EXTENSION'.  */
		struct iso1WeldingDetectionResType WeldingDetectionRes ;
#if SAVE_MEMORY_WITH_UNNAMED_UNION == UNION_YES
	};
#endif /* SAVE_MEMORY_WITH_UNNAMED_UNION == UNION_YES */ 
		unsigned int BodyElement_isUsed:1;
		unsigned int SessionSetupReq_isUsed:1;
		unsigned int SessionSetupRes_isUsed:1;
		unsigned int ServiceDiscoveryReq_isUsed:1;
		unsigned int ServiceDiscoveryRes_isUsed:1;
		unsigned int ServiceDetailReq_isUsed:1;
		unsigned int ServiceDetailRes_isUsed:1;
		unsigned int PaymentServiceSelectionReq_isUsed:1;
		unsigned int PaymentServiceSelectionRes_isUsed:1;
		unsigned int PaymentDetailsReq_isUsed:1;
		unsigned int PaymentDetailsRes_isUsed:1;
		unsigned int AuthorizationReq_isUsed:1;
		unsigned int AuthorizationRes_isUsed:1;
		unsigned int ChargeParameterDiscoveryReq_isUsed:1;
		unsigned int ChargeParameterDiscoveryRes_isUsed:1;
		unsigned int PowerDeliveryReq_isUsed:1;
		unsigned int PowerDeliveryRes_isUsed:1;
		unsigned int MeteringReceiptReq_isUsed:1;
		unsigned int MeteringReceiptRes_isUsed:1;
		unsigned int SessionStopReq_isUsed:1;
		unsigned int SessionStopRes_isUsed:1;
		unsigned int CertificateUpdateReq_isUsed:1;
		unsigned int CertificateUpdateRes_isUsed:1;
		unsigned int CertificateInstallationReq_isUsed:1;
		unsigned int CertificateInstallationRes_isUsed:1;
		unsigned int ChargingStatusReq_isUsed:1;
		unsigned int ChargingStatusRes_isUsed:1;
		unsigned int CableCheckReq_isUsed:1;
		unsigned int CableCheckRes_isUsed:1;
		unsigned int PreChargeReq_isUsed:1;
		unsigned int PreChargeRes_isUsed:1;
		unsigned int CurrentDemandReq_isUsed:1;
		unsigned int CurrentDemandRes_isUsed:1;
		unsigned int WeldingDetectionReq_isUsed:1;
		unsigned int WeldingDetectionRes_isUsed:1;
};

/* Complex type name='urn:iso:15118:2:2013:MsgDef,#AnonType_V2G_Message',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2013:MsgDef":Header,"urn:iso:15118:2:2013:MsgDef":Body)',  derivedBy='RESTRICTION'.  */
struct iso1AnonType_V2G_Message {
	/* element: "urn:iso:15118:2:2013:MsgDef":Header, Complex type name='urn:iso:15118:2:2013:MsgHeader,MessageHeaderType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2013:MsgHeader":SessionID,"urn:iso:15118:2:2013:MsgHeader":Notification{0-1},"http://www.w3.org/2000/09/xmldsig#":Signature{0-1})',  derivedBy='RESTRICTION'.  */
	struct iso1MessageHeaderType Header ;
	/* element: "urn:iso:15118:2:2013:MsgDef":Body, Complex type name='urn:iso:15118:2:2013:MsgBody,BodyType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2013:MsgBody":BodyElement{0-1})',  derivedBy='RESTRICTION'.  */
	struct iso1BodyType Body ;
};



#define EXIDocument_MgmtData_CHARACTERS_SIZE 50 + EXTRA_CHAR 
#define EXIDocument_KeyName_CHARACTERS_SIZE 50 + EXTRA_CHAR 
#define EXIDocument_DigestValue_BYTES_SIZE 350 
#define EXIFragment_Exponent_BYTES_SIZE 350 
#define EXIFragment_PgenCounter_BYTES_SIZE 350 
#define EXIFragment_SessionID_BYTES_SIZE 8 /* XML schema facet maxLength for urn:iso:15118:2:2013:MsgDataTypes,sessionIDType is 8 */
#define EXIFragment_PGPKeyPacket_BYTES_SIZE 350 
#define EXIFragment_Seed_BYTES_SIZE 350 
#define EXIFragment_XPath_CHARACTERS_SIZE 50 + EXTRA_CHAR 
#define EXIFragment_OEMProvisioningCert_BYTES_SIZE 800 /* XML schema facet maxLength for urn:iso:15118:2:2013:MsgDataTypes,certificateType is 800 */
#define EXIFragment_SalesTariffDescription_CHARACTERS_SIZE 32 + EXTRA_CHAR /* XML schema facet maxLength for urn:iso:15118:2:2013:MsgDataTypes,tariffDescriptionType is 32 */
#define EXIFragment_EVCCID_BYTES_SIZE 6 /* XML schema facet maxLength for urn:iso:15118:2:2013:MsgDataTypes,evccIDType is 6 */
#define EXIFragment_MgmtData_CHARACTERS_SIZE 50 + EXTRA_CHAR 
#define EXIFragment_P_BYTES_SIZE 350 
#define EXIFragment_Q_BYTES_SIZE 350 
#define EXIFragment_X509SubjectName_CHARACTERS_SIZE 50 + EXTRA_CHAR 
#define EXIFragment_G_BYTES_SIZE 350 
#define EXIFragment_J_BYTES_SIZE 350 
#define EXIFragment_ServiceScope_CHARACTERS_SIZE 64 + EXTRA_CHAR /* XML schema facet maxLength for urn:iso:15118:2:2013:MsgDataTypes,serviceScopeType is 64 */
#define EXIFragment_ServiceName_CHARACTERS_SIZE 32 + EXTRA_CHAR /* XML schema facet maxLength for urn:iso:15118:2:2013:MsgDataTypes,serviceNameType is 32 */
#define EXIFragment_X509CRL_BYTES_SIZE 350 
#define EXIFragment_Y_BYTES_SIZE 350 
#define EXIFragment_DigestValue_BYTES_SIZE 350 
#define EXIFragment_SPKISexp_BYTES_SIZE 350 
#define EXIFragment_stringValue_CHARACTERS_SIZE 50 + EXTRA_CHAR 
#define EXIFragment_PGPKeyID_BYTES_SIZE 350 
#define EXIFragment_X509Certificate_BYTES_SIZE 350 
#define EXIFragment_FaultMsg_CHARACTERS_SIZE 64 + EXTRA_CHAR /* XML schema facet maxLength for urn:iso:15118:2:2013:MsgDataTypes,faultMsgType is 64 */
#define EXIFragment_EVSEID_CHARACTERS_SIZE 37 + EXTRA_CHAR /* XML schema facet maxLength for urn:iso:15118:2:2013:MsgDataTypes,evseIDType is 37 */
#define EXIFragment_SigMeterReading_BYTES_SIZE 64 /* XML schema facet maxLength for urn:iso:15118:2:2013:MsgDataTypes,sigMeterReadingType is 64 */
#define EXIFragment_MeterID_CHARACTERS_SIZE 32 + EXTRA_CHAR /* XML schema facet maxLength for urn:iso:15118:2:2013:MsgDataTypes,meterIDType is 32 */
#define EXIFragment_KeyName_CHARACTERS_SIZE 50 + EXTRA_CHAR 
#define EXIFragment_GenChallenge_BYTES_SIZE 16 /* XML schema facet length for urn:iso:15118:2:2013:MsgDataTypes,genChallengeType is 16 */
#define EXIFragment_X509SKI_BYTES_SIZE 350 
#define EXIFragment_Certificate_BYTES_SIZE 800 /* XML schema facet maxLength for urn:iso:15118:2:2013:MsgDataTypes,certificateType is 800 */
#define EXIFragment_X509IssuerName_CHARACTERS_SIZE 50 + EXTRA_CHAR 
#define EXIFragment_Modulus_BYTES_SIZE 350 
#define exiElementFrag_Id_CHARACTERS_SIZE 50 + EXTRA_CHAR 
#define exiElementFrag_CHARACTERS_GENERIC_CHARACTERS_SIZE 50 + EXTRA_CHAR 


/* Global elements of EXI Document */
struct iso1EXIDocument {
#if SAVE_MEMORY_WITH_UNNAMED_UNION == UNION_YES
	union {
#endif /* SAVE_MEMORY_WITH_UNNAMED_UNION == UNION_YES */ 
	struct iso1AnonType_V2G_Message V2G_Message ;
	struct iso1ServiceDiscoveryReqType ServiceDiscoveryReq ;
	struct iso1ServiceDiscoveryResType ServiceDiscoveryRes ;
	struct iso1MeteringReceiptReqType MeteringReceiptReq ;
	struct iso1PaymentDetailsReqType PaymentDetailsReq ;
	struct iso1MeteringReceiptResType MeteringReceiptRes ;
	struct iso1PaymentDetailsResType PaymentDetailsRes ;
	struct iso1SessionSetupReqType SessionSetupReq ;
	struct iso1SessionSetupResType SessionSetupRes ;
	struct iso1CableCheckReqType CableCheckReq ;
	struct iso1CableCheckResType CableCheckRes ;
	struct iso1CertificateInstallationReqType CertificateInstallationReq ;
	struct iso1CertificateInstallationResType CertificateInstallationRes ;
	struct iso1WeldingDetectionReqType WeldingDetectionReq ;
	struct iso1WeldingDetectionResType WeldingDetectionRes ;
	struct iso1CertificateUpdateReqType CertificateUpdateReq ;
	struct iso1CertificateUpdateResType CertificateUpdateRes ;
	struct iso1PaymentServiceSelectionReqType PaymentServiceSelectionReq ;
	struct iso1PowerDeliveryReqType PowerDeliveryReq ;
	struct iso1PaymentServiceSelectionResType PaymentServiceSelectionRes ;
	struct iso1PowerDeliveryResType PowerDeliveryRes ;
	struct iso1ChargingStatusReqType ChargingStatusReq ;
	struct iso1ChargingStatusResType ChargingStatusRes ;
	struct iso1BodyBaseType BodyElement ;
	struct iso1CurrentDemandReqType CurrentDemandReq ;
	struct iso1PreChargeReqType PreChargeReq ;
	struct iso1CurrentDemandResType CurrentDemandRes ;
	struct iso1PreChargeResType PreChargeRes ;
	struct iso1SessionStopReqType SessionStopReq ;
	struct iso1AuthorizationReqType AuthorizationReq ;
	struct iso1SessionStopResType SessionStopRes ;
	struct iso1AuthorizationResType AuthorizationRes ;
	struct iso1ChargeParameterDiscoveryReqType ChargeParameterDiscoveryReq ;
	struct iso1ChargeParameterDiscoveryResType ChargeParameterDiscoveryRes ;
	struct iso1ServiceDetailReqType ServiceDetailReq ;
	struct iso1ServiceDetailResType ServiceDetailRes ;
	struct iso1DC_EVSEStatusType DC_EVSEStatus ;
	struct iso1RelativeTimeIntervalType RelativeTimeInterval ;
	struct iso1SalesTariffEntryType SalesTariffEntry ;
	struct iso1DC_EVPowerDeliveryParameterType DC_EVPowerDeliveryParameter ;
	struct iso1SASchedulesType SASchedules ;
	struct iso1AC_EVChargeParameterType AC_EVChargeParameter ;
	struct iso1SAScheduleListType SAScheduleList ;
	struct iso1DC_EVStatusType DC_EVStatus ;
	struct iso1EVStatusType EVStatus ;
	struct iso1DC_EVChargeParameterType DC_EVChargeParameter ;
	struct iso1DC_EVSEChargeParameterType DC_EVSEChargeParameter ;
	struct iso1EVSEStatusType EVSEStatus ;
	struct iso1IntervalType TimeInterval ;
	struct iso1EVPowerDeliveryParameterType EVPowerDeliveryParameter ;
	struct iso1EVSEChargeParameterType EVSEChargeParameter ;
	struct iso1AC_EVSEStatusType AC_EVSEStatus ;
	struct iso1EntryType Entry ;
	struct iso1AC_EVSEChargeParameterType AC_EVSEChargeParameter ;
	struct iso1PMaxScheduleEntryType PMaxScheduleEntry ;
	struct iso1EVChargeParameterType EVChargeParameter ;
	struct iso1SignaturePropertyType SignatureProperty ;
	struct iso1DSAKeyValueType DSAKeyValue ;
	struct iso1SignaturePropertiesType SignatureProperties ;
	struct iso1KeyValueType KeyValue ;
	struct iso1TransformsType Transforms ;
	struct iso1DigestMethodType DigestMethod ;
	struct iso1SignatureType Signature ;
	struct iso1RetrievalMethodType RetrievalMethod ;
	struct iso1ManifestType Manifest ;
	struct iso1ReferenceType Reference ;
	struct iso1CanonicalizationMethodType CanonicalizationMethod ;
	struct iso1RSAKeyValueType RSAKeyValue ;
	struct iso1TransformType Transform ;
	struct iso1PGPDataType PGPData ;
	struct {
		exi_string_character_t characters[EXIDocument_MgmtData_CHARACTERS_SIZE];
		uint16_t charactersLen;
	}  MgmtData ;
	struct iso1SignatureMethodType SignatureMethod ;
	struct iso1KeyInfoType KeyInfo ;
	struct iso1SPKIDataType SPKIData ;
	struct iso1X509DataType X509Data ;
	struct iso1SignatureValueType SignatureValue ;
	struct {
		exi_string_character_t characters[EXIDocument_KeyName_CHARACTERS_SIZE];
		uint16_t charactersLen;
	}  KeyName ;
	struct {
		uint8_t bytes[EXIDocument_DigestValue_BYTES_SIZE];
		uint16_t bytesLen;
	}  DigestValue ;
	struct iso1SignedInfoType SignedInfo ;
	struct iso1ObjectType Object ;
#if SAVE_MEMORY_WITH_UNNAMED_UNION == UNION_YES
	};
#endif /* SAVE_MEMORY_WITH_UNNAMED_UNION == UNION_YES */ 
	unsigned int V2G_Message_isUsed:1;
	unsigned int ServiceDiscoveryReq_isUsed:1;
	unsigned int ServiceDiscoveryRes_isUsed:1;
	unsigned int MeteringReceiptReq_isUsed:1;
	unsigned int PaymentDetailsReq_isUsed:1;
	unsigned int MeteringReceiptRes_isUsed:1;
	unsigned int PaymentDetailsRes_isUsed:1;
	unsigned int SessionSetupReq_isUsed:1;
	unsigned int SessionSetupRes_isUsed:1;
	unsigned int CableCheckReq_isUsed:1;
	unsigned int CableCheckRes_isUsed:1;
	unsigned int CertificateInstallationReq_isUsed:1;
	unsigned int CertificateInstallationRes_isUsed:1;
	unsigned int WeldingDetectionReq_isUsed:1;
	unsigned int WeldingDetectionRes_isUsed:1;
	unsigned int CertificateUpdateReq_isUsed:1;
	unsigned int CertificateUpdateRes_isUsed:1;
	unsigned int PaymentServiceSelectionReq_isUsed:1;
	unsigned int PowerDeliveryReq_isUsed:1;
	unsigned int PaymentServiceSelectionRes_isUsed:1;
	unsigned int PowerDeliveryRes_isUsed:1;
	unsigned int ChargingStatusReq_isUsed:1;
	unsigned int ChargingStatusRes_isUsed:1;
	unsigned int BodyElement_isUsed:1;
	unsigned int CurrentDemandReq_isUsed:1;
	unsigned int PreChargeReq_isUsed:1;
	unsigned int CurrentDemandRes_isUsed:1;
	unsigned int PreChargeRes_isUsed:1;
	unsigned int SessionStopReq_isUsed:1;
	unsigned int AuthorizationReq_isUsed:1;
	unsigned int SessionStopRes_isUsed:1;
	unsigned int AuthorizationRes_isUsed:1;
	unsigned int ChargeParameterDiscoveryReq_isUsed:1;
	unsigned int ChargeParameterDiscoveryRes_isUsed:1;
	unsigned int ServiceDetailReq_isUsed:1;
	unsigned int ServiceDetailRes_isUsed:1;
	unsigned int DC_EVSEStatus_isUsed:1;
	unsigned int RelativeTimeInterval_isUsed:1;
	unsigned int SalesTariffEntry_isUsed:1;
	unsigned int DC_EVPowerDeliveryParameter_isUsed:1;
	unsigned int SASchedules_isUsed:1;
	unsigned int AC_EVChargeParameter_isUsed:1;
	unsigned int SAScheduleList_isUsed:1;
	unsigned int DC_EVStatus_isUsed:1;
	unsigned int EVStatus_isUsed:1;
	unsigned int DC_EVChargeParameter_isUsed:1;
	unsigned int DC_EVSEChargeParameter_isUsed:1;
	unsigned int EVSEStatus_isUsed:1;
	unsigned int TimeInterval_isUsed:1;
	unsigned int EVPowerDeliveryParameter_isUsed:1;
	unsigned int EVSEChargeParameter_isUsed:1;
	unsigned int AC_EVSEStatus_isUsed:1;
	unsigned int Entry_isUsed:1;
	unsigned int AC_EVSEChargeParameter_isUsed:1;
	unsigned int PMaxScheduleEntry_isUsed:1;
	unsigned int EVChargeParameter_isUsed:1;
	unsigned int SignatureProperty_isUsed:1;
	unsigned int DSAKeyValue_isUsed:1;
	unsigned int SignatureProperties_isUsed:1;
	unsigned int KeyValue_isUsed:1;
	unsigned int Transforms_isUsed:1;
	unsigned int DigestMethod_isUsed:1;
	unsigned int Signature_isUsed:1;
	unsigned int RetrievalMethod_isUsed:1;
	unsigned int Manifest_isUsed:1;
	unsigned int Reference_isUsed:1;
	unsigned int CanonicalizationMethod_isUsed:1;
	unsigned int RSAKeyValue_isUsed:1;
	unsigned int Transform_isUsed:1;
	unsigned int PGPData_isUsed:1;
	unsigned int MgmtData_isUsed:1;
	unsigned int SignatureMethod_isUsed:1;
	unsigned int KeyInfo_isUsed:1;
	unsigned int SPKIData_isUsed:1;
	unsigned int X509Data_isUsed:1;
	unsigned int SignatureValue_isUsed:1;
	unsigned int KeyName_isUsed:1;
	unsigned int DigestValue_isUsed:1;
	unsigned int SignedInfo_isUsed:1;
	unsigned int Object_isUsed:1;


	int _warning_;
};


#if DEPLOY_ISO1_CODEC_FRAGMENT == SUPPORT_YES
struct iso1EXISchemaInformedElementFragmentGrammar {
	/* Schema-informed Element Fragment Grammar for START_ELEMENT({urn:iso:15118:2:2013:MsgBody}eMAID) */
	/* 4 ATTRIBUTE[STRING]({urn:iso:15118:2:2013:MsgDataTypes}Id) */
	unsigned int Id_isUsed:1;
	struct {
		exi_string_character_t characters[exiElementFrag_Id_CHARACTERS_SIZE];
		uint16_t charactersLen;
	} Id ;
	/* 247 START_ELEMENT({urn:iso:15118:2:2013:MsgBody}eMAID) */
	unsigned int CHARACTERS_GENERIC_isUsed:1;
	struct {
		exi_string_character_t characters[exiElementFrag_CHARACTERS_GENERIC_CHARACTERS_SIZE];
		uint16_t charactersLen;
	} CHARACTERS_GENERIC ;


	int _warning_;
};
/* Possible elements of EXI Fragment */
struct iso1EXIFragment {
#if SAVE_MEMORY_WITH_UNNAMED_UNION == UNION_YES
	union {
#endif /* SAVE_MEMORY_WITH_UNNAMED_UNION == UNION_YES */ 
	int ChargingComplete ;
	struct iso1PhysicalValueType EVMaxVoltage ;
	uint16_t ServiceID ;
	int8_t EVRESSSOC ;
	uint64_t MeterReading ;
	struct iso1PhysicalValueType physicalValue ;
	struct iso1IntervalType TimeInterval ;
	struct iso1AC_EVSEStatusType AC_EVSEStatus ;
	struct iso1PhysicalValueType EVMaxCurrent ;
	uint32_t ChargingProfileEntryStart ;
	struct iso1PhysicalValueType EVSEMaxCurrent ;
	iso1costKindType costKind ;
	struct iso1PhysicalValueType EAmount ;
	iso1EnergyTransferModeType EnergyTransferMode ;
	int64_t X509SerialNumber ;
	uint8_t NumEPriceLevels ;
	struct iso1RetrievalMethodType RetrievalMethod ;
	struct iso1PhysicalValueType PMax ;
	int16_t ParameterSetID ;
	int8_t BulkSOC ;
	struct iso1PhysicalValueType EVSEMinimumCurrentLimit ;
	int EVSEPowerLimitAchieved ;
	struct iso1SalesTariffEntryType SalesTariffEntry ;
	struct iso1TransformsType Transforms ;
	iso1EVSEProcessingType EVSEProcessing ;
	iso1isolationLevelType EVSEIsolationStatus ;
	int BulkChargingComplete ;
	uint8_t SAScheduleTupleID ;
	iso1faultCodeType FaultCode ;
	struct iso1X509IssuerSerialType RootCertificateID ;
	int64_t HMACOutputLength ;
	struct {
		uint8_t bytes[EXIFragment_Exponent_BYTES_SIZE];
		uint16_t bytesLen;
	}  Exponent ;
	struct iso1X509IssuerSerialType X509IssuerSerial ;
	int8_t byteValue ;
	struct iso1SPKIDataType SPKIData ;
	struct iso1SAScheduleListType SAScheduleList ;
	struct iso1PhysicalValueType EVMaximumPowerLimit ;
	struct iso1DC_EVSEStatusType DC_EVSEStatus ;
	int16_t RetryCounter ;
	struct iso1PhysicalValueType EVSEMaximumCurrentLimit ;
	struct iso1SalesTariffType SalesTariff ;
	struct {
		uint8_t bytes[EXIFragment_PgenCounter_BYTES_SIZE];
		uint16_t bytesLen;
	}  PgenCounter ;
	struct iso1X509DataType X509Data ;
	struct iso1PhysicalValueType EVSECurrentRegulationTolerance ;
	struct iso1KeyValueType KeyValue ;
	struct iso1AnonType_V2G_Message V2G_Message ;
	struct iso1PhysicalValueType EVSEMinimumVoltageLimit ;
	iso1responseCodeType ResponseCode ;
	struct iso1ProfileEntryType ProfileEntry ;
	uint32_t start ;
	iso1DC_EVErrorCodeType EVErrorCode ;
	struct iso1EVChargeParameterType EVChargeParameter ;
	struct iso1CertificateChainType ContractSignatureCertChain ;
	struct iso1PhysicalValueType EVSEPresentCurrent ;
	struct iso1PGPDataType PGPData ;
	struct iso1PhysicalValueType EVMinCurrent ;
	int8_t FullSOC ;
	uint32_t amount ;
	struct iso1DC_EVSEChargeParameterType DC_EVSEChargeParameter ;
	struct iso1EntryType Entry ;
	struct iso1SessionStopResType SessionStopRes ;
	int16_t shortValue ;
	struct iso1CertificateChainType SAProvisioningCertificateChain ;
	struct iso1PowerDeliveryReqType PowerDeliveryReq ;
	struct iso1PowerDeliveryResType PowerDeliveryRes ;
	struct iso1SessionStopReqType SessionStopReq ;
	struct iso1SignaturePropertyType SignatureProperty ;
	struct {
		uint8_t bytes[EXIFragment_SessionID_BYTES_SIZE];
		uint16_t bytesLen;
	}  SessionID ;
	struct {
		uint8_t bytes[EXIFragment_PGPKeyPacket_BYTES_SIZE];
		uint16_t bytesLen;
	}  PGPKeyPacket ;
	struct iso1MessageHeaderType Header ;
	struct {
		uint8_t bytes[EXIFragment_Seed_BYTES_SIZE];
		uint16_t bytesLen;
	}  Seed ;
	struct iso1RSAKeyValueType RSAKeyValue ;
	int FreeService ;
	struct iso1PhysicalValueType EVSENominalVoltage ;
	struct {
		exi_string_character_t characters[EXIFragment_XPath_CHARACTERS_SIZE];
		uint16_t charactersLen;
	}  XPath ;
	struct iso1MeteringReceiptResType MeteringReceiptRes ;
	struct iso1ServiceDiscoveryReqType ServiceDiscoveryReq ;
	struct iso1MeteringReceiptReqType MeteringReceiptReq ;
	struct iso1PreChargeResType PreChargeRes ;
	struct {
		uint8_t bytes[EXIFragment_OEMProvisioningCert_BYTES_SIZE];
		uint16_t bytesLen;
	}  OEMProvisioningCert ;
	struct iso1PhysicalValueType EVEnergyCapacity ;
	struct iso1SignatureType Signature ;
	struct iso1AC_EVSEChargeParameterType AC_EVSEChargeParameter ;
	struct iso1ServiceDiscoveryResType ServiceDiscoveryRes ;
	struct iso1PreChargeReqType PreChargeReq ;
	uint16_t NotificationMaxDelay ;
	struct iso1CableCheckReqType CableCheckReq ;
	struct {
		exi_string_character_t characters[EXIFragment_SalesTariffDescription_CHARACTERS_SIZE];
		uint16_t charactersLen;
	}  SalesTariffDescription ;
	int EVSEVoltageLimitAchieved ;
	int boolValue ;
	struct {
		uint8_t bytes[EXIFragment_EVCCID_BYTES_SIZE];
		uint16_t bytesLen;
	}  EVCCID ;
	struct iso1DC_EVChargeParameterType DC_EVChargeParameter ;
	struct iso1ChargingStatusReqType ChargingStatusReq ;
	struct iso1CableCheckResType CableCheckRes ;
	struct {
		exi_string_character_t characters[EXIFragment_MgmtData_CHARACTERS_SIZE];
		uint16_t charactersLen;
	}  MgmtData ;
	struct iso1MeterInfoType MeterInfo ;
	struct iso1PhysicalValueType EVSEEnergyToBeDelivered ;
	struct iso1EVSEStatusType EVSEStatus ;
	struct iso1ServiceType Service ;
	struct iso1ManifestType Manifest ;
	struct iso1PhysicalValueType EVMaximumVoltageLimit ;
	struct {
		uint8_t bytes[EXIFragment_P_BYTES_SIZE];
		uint16_t bytesLen;
	}  P ;
	struct {
		uint8_t bytes[EXIFragment_Q_BYTES_SIZE];
		uint16_t bytesLen;
	}  Q ;
	struct {
		exi_string_character_t characters[EXIFragment_X509SubjectName_CHARACTERS_SIZE];
		uint16_t charactersLen;
	}  X509SubjectName ;
	int32_t intValue ;
	struct iso1ChargingProfileType ChargingProfile ;
	struct {
		uint8_t bytes[EXIFragment_G_BYTES_SIZE];
		uint16_t bytesLen;
	}  G ;
	struct {
		uint8_t bytes[EXIFragment_J_BYTES_SIZE];
		uint16_t bytesLen;
	}  J ;
	struct {
		exi_string_character_t characters[EXIFragment_ServiceScope_CHARACTERS_SIZE];
		uint16_t charactersLen;
	}  ServiceScope ;
	int ReceiptRequired ;
	struct {
		exi_string_character_t characters[EXIFragment_ServiceName_CHARACTERS_SIZE];
		uint16_t charactersLen;
	}  ServiceName ;
	int16_t MeterStatus ;
	struct iso1DC_EVStatusType DC_EVStatus ;
	struct iso1ChargingStatusResType ChargingStatusRes ;
	iso1serviceCategoryType ServiceCategory ;
	struct iso1NotificationType Notification ;
	struct {
		uint8_t bytes[EXIFragment_X509CRL_BYTES_SIZE];
		uint16_t bytesLen;
	}  X509CRL ;
	struct {
		uint8_t bytes[EXIFragment_Y_BYTES_SIZE];
		uint16_t bytesLen;
	}  Y ;
	struct iso1PhysicalValueType EVSEPresentVoltage ;
	struct {
		uint8_t bytes[EXIFragment_DigestValue_BYTES_SIZE];
		uint16_t bytesLen;
	}  DigestValue ;
	struct iso1PhysicalValueType EVSEMaximumPowerLimit ;
	int64_t EVSETimeStamp ;
	struct iso1CostType Cost ;
	struct iso1PhysicalValueType EVSEPeakCurrentRipple ;
	struct iso1ConsumptionCostType ConsumptionCost ;
	struct iso1DigestMethodType DigestMethod ;
	struct {
		uint8_t bytes[EXIFragment_SPKISexp_BYTES_SIZE];
		uint16_t bytesLen;
	}  SPKISexp ;
	struct iso1SessionSetupResType SessionSetupRes ;
	int EVSECurrentLimitAchieved ;
	struct iso1ServiceDetailReqType ServiceDetailReq ;
	struct iso1PhysicalValueType EVSEMaximumVoltageLimit ;
	struct iso1ServiceDetailResType ServiceDetailRes ;
	struct iso1SignaturePropertiesType SignatureProperties ;
	uint8_t EPriceLevel ;
	struct iso1PhysicalValueType EVTargetCurrent ;
	struct iso1PhysicalValueType RemainingTimeToBulkSoC ;
	struct {
		exi_string_character_t characters[EXIFragment_stringValue_CHARACTERS_SIZE];
		uint16_t charactersLen;
	}  stringValue ;
	struct iso1SessionSetupReqType SessionSetupReq ;
	int8_t Multiplier ;
	struct iso1CertificateUpdateResType CertificateUpdateRes ;
	struct {
		uint8_t bytes[EXIFragment_PGPKeyID_BYTES_SIZE];
		uint16_t bytesLen;
	}  PGPKeyID ;
	struct iso1PhysicalValueType EVTargetVoltage ;
	struct iso1DSAKeyValueType DSAKeyValue ;
	struct iso1CertificateUpdateReqType CertificateUpdateReq ;
	struct iso1PhysicalValueType EVMaximumCurrentLimit ;
	struct iso1CanonicalizationMethodType CanonicalizationMethod ;
	struct {
		uint8_t bytes[EXIFragment_X509Certificate_BYTES_SIZE];
		uint16_t bytesLen;
	}  X509Certificate ;
	struct iso1CertificateInstallationReqType CertificateInstallationReq ;
	struct iso1CertificateInstallationResType CertificateInstallationRes ;
	struct iso1EVStatusType EVStatus ;
	struct iso1SupportedEnergyTransferModeType SupportedEnergyTransferMode ;
	struct iso1SignedInfoType SignedInfo ;
	/* Schema-informed Element Fragment Grammar for {urn:iso:15118:2:2013:MsgBody}eMAID */
	struct iso1EXISchemaInformedElementFragmentGrammar eMAID ;
	uint16_t MaxEntriesSAScheduleTuple ;
	iso1paymentOptionType PaymentOption ;
	struct iso1SubCertificatesType SubCertificates ;
	struct iso1PaymentDetailsReqType PaymentDetailsReq ;
	struct iso1AuthorizationReqType AuthorizationReq ;
	struct iso1PaymentDetailsResType PaymentDetailsRes ;
	struct iso1AuthorizationResType AuthorizationRes ;
	iso1DC_EVSEStatusCodeType EVSEStatusCode ;
	struct iso1PaymentOptionListType PaymentOptionList ;
	struct iso1SelectedServiceListType SelectedServiceList ;
	struct iso1ContractSignatureEncryptedPrivateKeyType ContractSignatureEncryptedPrivateKey ;
	struct iso1WeldingDetectionReqType WeldingDetectionReq ;
	struct {
		exi_string_character_t characters[EXIFragment_FaultMsg_CHARACTERS_SIZE];
		uint16_t charactersLen;
	}  FaultMsg ;
	struct iso1WeldingDetectionResType WeldingDetectionRes ;
	iso1chargeProgressType ChargeProgress ;
	iso1paymentOptionType SelectedPaymentOption ;
	struct {
		exi_string_character_t characters[EXIFragment_EVSEID_CHARACTERS_SIZE];
		uint16_t charactersLen;
	}  EVSEID ;
	struct iso1ParameterSetType ParameterSet ;
	struct iso1EVSEChargeParameterType EVSEChargeParameter ;
	struct {
		uint8_t bytes[EXIFragment_SigMeterReading_BYTES_SIZE];
		uint16_t bytesLen;
	}  SigMeterReading ;
	struct iso1SignatureValueType SignatureValue ;
	struct iso1SASchedulesType SASchedules ;
	uint8_t SalesTariffID ;
	struct iso1DiffieHellmanPublickeyType DHpublickey ;
	struct iso1ServiceParameterListType ServiceParameterList ;
	struct iso1ListOfRootCertificateIDsType ListOfRootCertificateIDs ;
	struct {
		exi_string_character_t characters[EXIFragment_MeterID_CHARACTERS_SIZE];
		uint16_t charactersLen;
	}  MeterID ;
	struct iso1ChargeServiceType ChargeService ;
	int8_t amountMultiplier ;
	int RCD ;
	struct iso1PhysicalValueType startValue ;
	struct iso1CurrentDemandReqType CurrentDemandReq ;
	struct {
		exi_string_character_t characters[EXIFragment_KeyName_CHARACTERS_SIZE];
		uint16_t charactersLen;
	}  KeyName ;
	struct iso1DC_EVPowerDeliveryParameterType DC_EVPowerDeliveryParameter ;
	struct iso1BodyType Body ;
	iso1EVSENotificationType EVSENotification ;
	int16_t Value ;
	struct iso1KeyInfoType KeyInfo ;
	struct {
		uint8_t bytes[EXIFragment_GenChallenge_BYTES_SIZE];
		uint16_t bytesLen;
	}  GenChallenge ;
	struct iso1AC_EVChargeParameterType AC_EVChargeParameter ;
	struct iso1PMaxScheduleEntryType PMaxScheduleEntry ;
	struct iso1ParameterType Parameter ;
	struct {
		uint8_t bytes[EXIFragment_X509SKI_BYTES_SIZE];
		uint16_t bytesLen;
	}  X509SKI ;
	struct iso1SelectedServiceType SelectedService ;
	struct iso1PaymentServiceSelectionReqType PaymentServiceSelectionReq ;
	struct iso1PaymentServiceSelectionResType PaymentServiceSelectionRes ;
	struct {
		uint8_t bytes[EXIFragment_Certificate_BYTES_SIZE];
		uint16_t bytesLen;
	}  Certificate ;
	struct iso1CurrentDemandResType CurrentDemandRes ;
	int EVReady ;
	struct iso1SignatureMethodType SignatureMethod ;
	struct iso1PMaxScheduleType PMaxSchedule ;
	iso1unitSymbolType Unit ;
	struct {
		exi_string_character_t characters[EXIFragment_X509IssuerName_CHARACTERS_SIZE];
		uint16_t charactersLen;
	}  X509IssuerName ;
	struct iso1ReferenceType Reference ;
	int8_t ChargingProfileEntryMaxNumberOfPhasesInUse ;
	struct iso1EVPowerDeliveryParameterType EVPowerDeliveryParameter ;
	struct iso1PhysicalValueType ChargingProfileEntryMaxPower ;
	struct iso1ChargeParameterDiscoveryReqType ChargeParameterDiscoveryReq ;
	uint32_t duration ;
	int64_t TMeter ;
	struct iso1ChargeParameterDiscoveryResType ChargeParameterDiscoveryRes ;
	struct iso1ServiceListType ServiceList ;
	struct iso1SAScheduleTupleType SAScheduleTuple ;
	struct iso1BodyBaseType BodyElement ;
	struct iso1PhysicalValueType RemainingTimeToFullSoC ;
	struct iso1RelativeTimeIntervalType RelativeTimeInterval ;
	struct iso1TransformType Transform ;
	uint32_t DepartureTime ;
	struct iso1ObjectType Object ;
	struct iso1PhysicalValueType EVEnergyRequest ;
	struct {
		uint8_t bytes[EXIFragment_Modulus_BYTES_SIZE];
		uint16_t bytesLen;
	}  Modulus ;
	iso1chargingSessionType ChargingSession ;
	iso1EnergyTransferModeType RequestedEnergyTransferMode ;
#if SAVE_MEMORY_WITH_UNNAMED_UNION == UNION_YES
	};
#endif /* SAVE_MEMORY_WITH_UNNAMED_UNION == UNION_YES */ 
	unsigned int ChargingComplete_isUsed:1;
	unsigned int EVMaxVoltage_isUsed:1;
	unsigned int ServiceID_isUsed:1;
	unsigned int EVRESSSOC_isUsed:1;
	unsigned int MeterReading_isUsed:1;
	unsigned int physicalValue_isUsed:1;
	unsigned int TimeInterval_isUsed:1;
	unsigned int AC_EVSEStatus_isUsed:1;
	unsigned int EVMaxCurrent_isUsed:1;
	unsigned int ChargingProfileEntryStart_isUsed:1;
	unsigned int EVSEMaxCurrent_isUsed:1;
	unsigned int costKind_isUsed:1;
	unsigned int EAmount_isUsed:1;
	unsigned int EnergyTransferMode_isUsed:1;
	unsigned int X509SerialNumber_isUsed:1;
	unsigned int NumEPriceLevels_isUsed:1;
	unsigned int RetrievalMethod_isUsed:1;
	unsigned int PMax_isUsed:1;
	unsigned int ParameterSetID_isUsed:1;
	unsigned int BulkSOC_isUsed:1;
	unsigned int EVSEMinimumCurrentLimit_isUsed:1;
	unsigned int EVSEPowerLimitAchieved_isUsed:1;
	unsigned int SalesTariffEntry_isUsed:1;
	unsigned int Transforms_isUsed:1;
	unsigned int EVSEProcessing_isUsed:1;
	unsigned int EVSEIsolationStatus_isUsed:1;
	unsigned int BulkChargingComplete_isUsed:1;
	unsigned int SAScheduleTupleID_isUsed:1;
	unsigned int FaultCode_isUsed:1;
	unsigned int RootCertificateID_isUsed:1;
	unsigned int HMACOutputLength_isUsed:1;
	unsigned int Exponent_isUsed:1;
	unsigned int X509IssuerSerial_isUsed:1;
	unsigned int byteValue_isUsed:1;
	unsigned int SPKIData_isUsed:1;
	unsigned int SAScheduleList_isUsed:1;
	unsigned int EVMaximumPowerLimit_isUsed:1;
	unsigned int DC_EVSEStatus_isUsed:1;
	unsigned int RetryCounter_isUsed:1;
	unsigned int EVSEMaximumCurrentLimit_isUsed:1;
	unsigned int SalesTariff_isUsed:1;
	unsigned int PgenCounter_isUsed:1;
	unsigned int X509Data_isUsed:1;
	unsigned int EVSECurrentRegulationTolerance_isUsed:1;
	unsigned int KeyValue_isUsed:1;
	unsigned int V2G_Message_isUsed:1;
	unsigned int EVSEMinimumVoltageLimit_isUsed:1;
	unsigned int ResponseCode_isUsed:1;
	unsigned int ProfileEntry_isUsed:1;
	unsigned int start_isUsed:1;
	unsigned int EVErrorCode_isUsed:1;
	unsigned int EVChargeParameter_isUsed:1;
	unsigned int ContractSignatureCertChain_isUsed:1;
	unsigned int EVSEPresentCurrent_isUsed:1;
	unsigned int PGPData_isUsed:1;
	unsigned int EVMinCurrent_isUsed:1;
	unsigned int FullSOC_isUsed:1;
	unsigned int amount_isUsed:1;
	unsigned int DC_EVSEChargeParameter_isUsed:1;
	unsigned int Entry_isUsed:1;
	unsigned int SessionStopRes_isUsed:1;
	unsigned int shortValue_isUsed:1;
	unsigned int SAProvisioningCertificateChain_isUsed:1;
	unsigned int PowerDeliveryReq_isUsed:1;
	unsigned int PowerDeliveryRes_isUsed:1;
	unsigned int SessionStopReq_isUsed:1;
	unsigned int SignatureProperty_isUsed:1;
	unsigned int SessionID_isUsed:1;
	unsigned int PGPKeyPacket_isUsed:1;
	unsigned int Header_isUsed:1;
	unsigned int Seed_isUsed:1;
	unsigned int RSAKeyValue_isUsed:1;
	unsigned int FreeService_isUsed:1;
	unsigned int EVSENominalVoltage_isUsed:1;
	unsigned int XPath_isUsed:1;
	unsigned int MeteringReceiptRes_isUsed:1;
	unsigned int ServiceDiscoveryReq_isUsed:1;
	unsigned int MeteringReceiptReq_isUsed:1;
	unsigned int PreChargeRes_isUsed:1;
	unsigned int OEMProvisioningCert_isUsed:1;
	unsigned int EVEnergyCapacity_isUsed:1;
	unsigned int Signature_isUsed:1;
	unsigned int AC_EVSEChargeParameter_isUsed:1;
	unsigned int ServiceDiscoveryRes_isUsed:1;
	unsigned int PreChargeReq_isUsed:1;
	unsigned int NotificationMaxDelay_isUsed:1;
	unsigned int CableCheckReq_isUsed:1;
	unsigned int SalesTariffDescription_isUsed:1;
	unsigned int EVSEVoltageLimitAchieved_isUsed:1;
	unsigned int boolValue_isUsed:1;
	unsigned int EVCCID_isUsed:1;
	unsigned int DC_EVChargeParameter_isUsed:1;
	unsigned int ChargingStatusReq_isUsed:1;
	unsigned int CableCheckRes_isUsed:1;
	unsigned int MgmtData_isUsed:1;
	unsigned int MeterInfo_isUsed:1;
	unsigned int EVSEEnergyToBeDelivered_isUsed:1;
	unsigned int EVSEStatus_isUsed:1;
	unsigned int Service_isUsed:1;
	unsigned int Manifest_isUsed:1;
	unsigned int EVMaximumVoltageLimit_isUsed:1;
	unsigned int P_isUsed:1;
	unsigned int Q_isUsed:1;
	unsigned int X509SubjectName_isUsed:1;
	unsigned int intValue_isUsed:1;
	unsigned int ChargingProfile_isUsed:1;
	unsigned int G_isUsed:1;
	unsigned int J_isUsed:1;
	unsigned int ServiceScope_isUsed:1;
	unsigned int ReceiptRequired_isUsed:1;
	unsigned int ServiceName_isUsed:1;
	unsigned int MeterStatus_isUsed:1;
	unsigned int DC_EVStatus_isUsed:1;
	unsigned int ChargingStatusRes_isUsed:1;
	unsigned int ServiceCategory_isUsed:1;
	unsigned int Notification_isUsed:1;
	unsigned int X509CRL_isUsed:1;
	unsigned int Y_isUsed:1;
	unsigned int EVSEPresentVoltage_isUsed:1;
	unsigned int DigestValue_isUsed:1;
	unsigned int EVSEMaximumPowerLimit_isUsed:1;
	unsigned int EVSETimeStamp_isUsed:1;
	unsigned int Cost_isUsed:1;
	unsigned int EVSEPeakCurrentRipple_isUsed:1;
	unsigned int ConsumptionCost_isUsed:1;
	unsigned int DigestMethod_isUsed:1;
	unsigned int SPKISexp_isUsed:1;
	unsigned int SessionSetupRes_isUsed:1;
	unsigned int EVSECurrentLimitAchieved_isUsed:1;
	unsigned int ServiceDetailReq_isUsed:1;
	unsigned int EVSEMaximumVoltageLimit_isUsed:1;
	unsigned int ServiceDetailRes_isUsed:1;
	unsigned int SignatureProperties_isUsed:1;
	unsigned int EPriceLevel_isUsed:1;
	unsigned int EVTargetCurrent_isUsed:1;
	unsigned int RemainingTimeToBulkSoC_isUsed:1;
	unsigned int stringValue_isUsed:1;
	unsigned int SessionSetupReq_isUsed:1;
	unsigned int Multiplier_isUsed:1;
	unsigned int CertificateUpdateRes_isUsed:1;
	unsigned int PGPKeyID_isUsed:1;
	unsigned int EVTargetVoltage_isUsed:1;
	unsigned int DSAKeyValue_isUsed:1;
	unsigned int CertificateUpdateReq_isUsed:1;
	unsigned int EVMaximumCurrentLimit_isUsed:1;
	unsigned int CanonicalizationMethod_isUsed:1;
	unsigned int X509Certificate_isUsed:1;
	unsigned int CertificateInstallationReq_isUsed:1;
	unsigned int CertificateInstallationRes_isUsed:1;
	unsigned int EVStatus_isUsed:1;
	unsigned int SupportedEnergyTransferMode_isUsed:1;
	unsigned int SignedInfo_isUsed:1;
	unsigned int eMAID_isUsed:1;
	unsigned int MaxEntriesSAScheduleTuple_isUsed:1;
	unsigned int PaymentOption_isUsed:1;
	unsigned int SubCertificates_isUsed:1;
	unsigned int PaymentDetailsReq_isUsed:1;
	unsigned int AuthorizationReq_isUsed:1;
	unsigned int PaymentDetailsRes_isUsed:1;
	unsigned int AuthorizationRes_isUsed:1;
	unsigned int EVSEStatusCode_isUsed:1;
	unsigned int PaymentOptionList_isUsed:1;
	unsigned int SelectedServiceList_isUsed:1;
	unsigned int ContractSignatureEncryptedPrivateKey_isUsed:1;
	unsigned int WeldingDetectionReq_isUsed:1;
	unsigned int FaultMsg_isUsed:1;
	unsigned int WeldingDetectionRes_isUsed:1;
	unsigned int ChargeProgress_isUsed:1;
	unsigned int SelectedPaymentOption_isUsed:1;
	unsigned int EVSEID_isUsed:1;
	unsigned int ParameterSet_isUsed:1;
	unsigned int EVSEChargeParameter_isUsed:1;
	unsigned int SigMeterReading_isUsed:1;
	unsigned int SignatureValue_isUsed:1;
	unsigned int SASchedules_isUsed:1;
	unsigned int SalesTariffID_isUsed:1;
	unsigned int DHpublickey_isUsed:1;
	unsigned int ServiceParameterList_isUsed:1;
	unsigned int ListOfRootCertificateIDs_isUsed:1;
	unsigned int MeterID_isUsed:1;
	unsigned int ChargeService_isUsed:1;
	unsigned int amountMultiplier_isUsed:1;
	unsigned int RCD_isUsed:1;
	unsigned int startValue_isUsed:1;
	unsigned int CurrentDemandReq_isUsed:1;
	unsigned int KeyName_isUsed:1;
	unsigned int DC_EVPowerDeliveryParameter_isUsed:1;
	unsigned int Body_isUsed:1;
	unsigned int EVSENotification_isUsed:1;
	unsigned int Value_isUsed:1;
	unsigned int KeyInfo_isUsed:1;
	unsigned int GenChallenge_isUsed:1;
	unsigned int AC_EVChargeParameter_isUsed:1;
	unsigned int PMaxScheduleEntry_isUsed:1;
	unsigned int Parameter_isUsed:1;
	unsigned int X509SKI_isUsed:1;
	unsigned int SelectedService_isUsed:1;
	unsigned int PaymentServiceSelectionReq_isUsed:1;
	unsigned int PaymentServiceSelectionRes_isUsed:1;
	unsigned int Certificate_isUsed:1;
	unsigned int CurrentDemandRes_isUsed:1;
	unsigned int EVReady_isUsed:1;
	unsigned int SignatureMethod_isUsed:1;
	unsigned int PMaxSchedule_isUsed:1;
	unsigned int Unit_isUsed:1;
	unsigned int X509IssuerName_isUsed:1;
	unsigned int Reference_isUsed:1;
	unsigned int ChargingProfileEntryMaxNumberOfPhasesInUse_isUsed:1;
	unsigned int EVPowerDeliveryParameter_isUsed:1;
	unsigned int ChargingProfileEntryMaxPower_isUsed:1;
	unsigned int ChargeParameterDiscoveryReq_isUsed:1;
	unsigned int duration_isUsed:1;
	unsigned int TMeter_isUsed:1;
	unsigned int ChargeParameterDiscoveryRes_isUsed:1;
	unsigned int ServiceList_isUsed:1;
	unsigned int SAScheduleTuple_isUsed:1;
	unsigned int BodyElement_isUsed:1;
	unsigned int RemainingTimeToFullSoC_isUsed:1;
	unsigned int RelativeTimeInterval_isUsed:1;
	unsigned int Transform_isUsed:1;
	unsigned int DepartureTime_isUsed:1;
	unsigned int Object_isUsed:1;
	unsigned int EVEnergyRequest_isUsed:1;
	unsigned int Modulus_isUsed:1;
	unsigned int ChargingSession_isUsed:1;
	unsigned int RequestedEnergyTransferMode_isUsed:1;


	int _warning_;
};
#endif /* DEPLOY_ISO1_CODEC_FRAGMENT */


/* Initialization methods for structs */

void init_iso1EXIDocument(struct iso1EXIDocument* exiDoc);
#if DEPLOY_ISO1_CODEC_FRAGMENT == SUPPORT_YES
void init_iso1EXIFragment(struct iso1EXIFragment* exiFrag);
void init_iso1EXISchemaInformedElementFragmentGrammar(struct iso1EXISchemaInformedElementFragmentGrammar* exiFrag);
#endif /* DEPLOY_ISO1_CODEC_FRAGMENT */
void init_iso1MessageHeaderType(struct iso1MessageHeaderType* iso1MessageHeaderType);
void init_iso1SignatureType(struct iso1SignatureType* iso1SignatureType);
void init_iso1PowerDeliveryReqType(struct iso1PowerDeliveryReqType* iso1PowerDeliveryReqType);
void init_iso1ParameterType(struct iso1ParameterType* iso1ParameterType);
void init_iso1CertificateInstallationReqType(struct iso1CertificateInstallationReqType* iso1CertificateInstallationReqType);
void init_iso1SessionSetupResType(struct iso1SessionSetupResType* iso1SessionSetupResType);
void init_iso1EVChargeParameterType(struct iso1EVChargeParameterType* iso1EVChargeParameterType);
void init_iso1DiffieHellmanPublickeyType(struct iso1DiffieHellmanPublickeyType* iso1DiffieHellmanPublickeyType);
void init_iso1ServiceDiscoveryResType(struct iso1ServiceDiscoveryResType* iso1ServiceDiscoveryResType);
void init_iso1ServiceParameterListType(struct iso1ServiceParameterListType* iso1ServiceParameterListType);
void init_iso1CertificateChainType(struct iso1CertificateChainType* iso1CertificateChainType);
void init_iso1SASchedulesType(struct iso1SASchedulesType* iso1SASchedulesType);
void init_iso1DC_EVSEStatusType(struct iso1DC_EVSEStatusType* iso1DC_EVSEStatusType);
void init_iso1PreChargeResType(struct iso1PreChargeResType* iso1PreChargeResType);
void init_iso1ParameterSetType(struct iso1ParameterSetType* iso1ParameterSetType);
void init_iso1ServiceDetailReqType(struct iso1ServiceDetailReqType* iso1ServiceDetailReqType);
void init_iso1RelativeTimeIntervalType(struct iso1RelativeTimeIntervalType* iso1RelativeTimeIntervalType);
void init_iso1SignedInfoType(struct iso1SignedInfoType* iso1SignedInfoType);
void init_iso1EMAIDType(struct iso1EMAIDType* iso1EMAIDType);
void init_iso1EVStatusType(struct iso1EVStatusType* iso1EVStatusType);
void init_iso1ServiceListType(struct iso1ServiceListType* iso1ServiceListType);
void init_iso1EVSEChargeParameterType(struct iso1EVSEChargeParameterType* iso1EVSEChargeParameterType);
void init_iso1EVPowerDeliveryParameterType(struct iso1EVPowerDeliveryParameterType* iso1EVPowerDeliveryParameterType);
void init_iso1ProfileEntryType(struct iso1ProfileEntryType* iso1ProfileEntryType);
void init_iso1AuthorizationReqType(struct iso1AuthorizationReqType* iso1AuthorizationReqType);
void init_iso1MeterInfoType(struct iso1MeterInfoType* iso1MeterInfoType);
void init_iso1ManifestType(struct iso1ManifestType* iso1ManifestType);
void init_iso1ChargeParameterDiscoveryResType(struct iso1ChargeParameterDiscoveryResType* iso1ChargeParameterDiscoveryResType);
void init_iso1PowerDeliveryResType(struct iso1PowerDeliveryResType* iso1PowerDeliveryResType);
void init_iso1DC_EVChargeParameterType(struct iso1DC_EVChargeParameterType* iso1DC_EVChargeParameterType);
void init_iso1ConsumptionCostType(struct iso1ConsumptionCostType* iso1ConsumptionCostType);
void init_iso1PMaxScheduleType(struct iso1PMaxScheduleType* iso1PMaxScheduleType);
void init_iso1PaymentOptionListType(struct iso1PaymentOptionListType* iso1PaymentOptionListType);
void init_iso1ObjectType(struct iso1ObjectType* iso1ObjectType);
void init_iso1PhysicalValueType(struct iso1PhysicalValueType* iso1PhysicalValueType);
void init_iso1RSAKeyValueType(struct iso1RSAKeyValueType* iso1RSAKeyValueType);
void init_iso1SessionStopResType(struct iso1SessionStopResType* iso1SessionStopResType);
void init_iso1CertificateUpdateReqType(struct iso1CertificateUpdateReqType* iso1CertificateUpdateReqType);
void init_iso1SignatureValueType(struct iso1SignatureValueType* iso1SignatureValueType);
void init_iso1PaymentDetailsReqType(struct iso1PaymentDetailsReqType* iso1PaymentDetailsReqType);
void init_iso1AuthorizationResType(struct iso1AuthorizationResType* iso1AuthorizationResType);
void init_iso1DC_EVSEChargeParameterType(struct iso1DC_EVSEChargeParameterType* iso1DC_EVSEChargeParameterType);
void init_iso1SubCertificatesType(struct iso1SubCertificatesType* iso1SubCertificatesType);
void init_iso1ChargingStatusResType(struct iso1ChargingStatusResType* iso1ChargingStatusResType);
void init_iso1DSAKeyValueType(struct iso1DSAKeyValueType* iso1DSAKeyValueType);
void init_iso1ListOfRootCertificateIDsType(struct iso1ListOfRootCertificateIDsType* iso1ListOfRootCertificateIDsType);
void init_iso1ChargeServiceType(struct iso1ChargeServiceType* iso1ChargeServiceType);
void init_iso1IntervalType(struct iso1IntervalType* iso1IntervalType);
void init_iso1MeteringReceiptReqType(struct iso1MeteringReceiptReqType* iso1MeteringReceiptReqType);
void init_iso1ServiceDetailResType(struct iso1ServiceDetailResType* iso1ServiceDetailResType);
void init_iso1KeyValueType(struct iso1KeyValueType* iso1KeyValueType);
void init_iso1SelectedServiceListType(struct iso1SelectedServiceListType* iso1SelectedServiceListType);
void init_iso1CableCheckResType(struct iso1CableCheckResType* iso1CableCheckResType);
void init_iso1X509IssuerSerialType(struct iso1X509IssuerSerialType* iso1X509IssuerSerialType);
void init_iso1KeyInfoType(struct iso1KeyInfoType* iso1KeyInfoType);
void init_iso1TransformsType(struct iso1TransformsType* iso1TransformsType);
void init_iso1ChargeParameterDiscoveryReqType(struct iso1ChargeParameterDiscoveryReqType* iso1ChargeParameterDiscoveryReqType);
void init_iso1PreChargeReqType(struct iso1PreChargeReqType* iso1PreChargeReqType);
void init_iso1EVSEStatusType(struct iso1EVSEStatusType* iso1EVSEStatusType);
void init_iso1SignatureMethodType(struct iso1SignatureMethodType* iso1SignatureMethodType);
void init_iso1X509DataType(struct iso1X509DataType* iso1X509DataType);
void init_iso1NotificationType(struct iso1NotificationType* iso1NotificationType);
void init_iso1SAScheduleListType(struct iso1SAScheduleListType* iso1SAScheduleListType);
void init_iso1BodyType(struct iso1BodyType* iso1BodyType);
void init_iso1ChargingProfileType(struct iso1ChargingProfileType* iso1ChargingProfileType);
void init_iso1TransformType(struct iso1TransformType* iso1TransformType);
void init_iso1SAScheduleTupleType(struct iso1SAScheduleTupleType* iso1SAScheduleTupleType);
void init_iso1AC_EVChargeParameterType(struct iso1AC_EVChargeParameterType* iso1AC_EVChargeParameterType);
void init_iso1AnonType_V2G_Message(struct iso1AnonType_V2G_Message* iso1AnonType_V2G_Message);
void init_iso1PaymentDetailsResType(struct iso1PaymentDetailsResType* iso1PaymentDetailsResType);
void init_iso1ContractSignatureEncryptedPrivateKeyType(struct iso1ContractSignatureEncryptedPrivateKeyType* iso1ContractSignatureEncryptedPrivateKeyType);
void init_iso1PMaxScheduleEntryType(struct iso1PMaxScheduleEntryType* iso1PMaxScheduleEntryType);
void init_iso1SPKIDataType(struct iso1SPKIDataType* iso1SPKIDataType);
void init_iso1MeteringReceiptResType(struct iso1MeteringReceiptResType* iso1MeteringReceiptResType);
void init_iso1SessionStopReqType(struct iso1SessionStopReqType* iso1SessionStopReqType);
void init_iso1WeldingDetectionResType(struct iso1WeldingDetectionResType* iso1WeldingDetectionResType);
void init_iso1ReferenceType(struct iso1ReferenceType* iso1ReferenceType);
void init_iso1CurrentDemandReqType(struct iso1CurrentDemandReqType* iso1CurrentDemandReqType);
void init_iso1SalesTariffEntryType(struct iso1SalesTariffEntryType* iso1SalesTariffEntryType);
void init_iso1EntryType(struct iso1EntryType* iso1EntryType);
void init_iso1SessionSetupReqType(struct iso1SessionSetupReqType* iso1SessionSetupReqType);
void init_iso1CostType(struct iso1CostType* iso1CostType);
void init_iso1DC_EVPowerDeliveryParameterType(struct iso1DC_EVPowerDeliveryParameterType* iso1DC_EVPowerDeliveryParameterType);
void init_iso1RetrievalMethodType(struct iso1RetrievalMethodType* iso1RetrievalMethodType);
void init_iso1CertificateUpdateResType(struct iso1CertificateUpdateResType* iso1CertificateUpdateResType);
void init_iso1CertificateInstallationResType(struct iso1CertificateInstallationResType* iso1CertificateInstallationResType);
void init_iso1CanonicalizationMethodType(struct iso1CanonicalizationMethodType* iso1CanonicalizationMethodType);
void init_iso1WeldingDetectionReqType(struct iso1WeldingDetectionReqType* iso1WeldingDetectionReqType);
void init_iso1DC_EVStatusType(struct iso1DC_EVStatusType* iso1DC_EVStatusType);
void init_iso1CurrentDemandResType(struct iso1CurrentDemandResType* iso1CurrentDemandResType);
void init_iso1ServiceType(struct iso1ServiceType* iso1ServiceType);
void init_iso1ServiceDiscoveryReqType(struct iso1ServiceDiscoveryReqType* iso1ServiceDiscoveryReqType);
void init_iso1AC_EVSEChargeParameterType(struct iso1AC_EVSEChargeParameterType* iso1AC_EVSEChargeParameterType);
void init_iso1CableCheckReqType(struct iso1CableCheckReqType* iso1CableCheckReqType);
void init_iso1SelectedServiceType(struct iso1SelectedServiceType* iso1SelectedServiceType);
void init_iso1AC_EVSEStatusType(struct iso1AC_EVSEStatusType* iso1AC_EVSEStatusType);
void init_iso1SalesTariffType(struct iso1SalesTariffType* iso1SalesTariffType);
void init_iso1PaymentServiceSelectionReqType(struct iso1PaymentServiceSelectionReqType* iso1PaymentServiceSelectionReqType);
void init_iso1SignaturePropertiesType(struct iso1SignaturePropertiesType* iso1SignaturePropertiesType);
void init_iso1BodyBaseType(struct iso1BodyBaseType* iso1BodyBaseType);
void init_iso1SupportedEnergyTransferModeType(struct iso1SupportedEnergyTransferModeType* iso1SupportedEnergyTransferModeType);
void init_iso1ChargingStatusReqType(struct iso1ChargingStatusReqType* iso1ChargingStatusReqType);
void init_iso1PaymentServiceSelectionResType(struct iso1PaymentServiceSelectionResType* iso1PaymentServiceSelectionResType);
void init_iso1DigestMethodType(struct iso1DigestMethodType* iso1DigestMethodType);
void init_iso1SignaturePropertyType(struct iso1SignaturePropertyType* iso1SignaturePropertyType);
void init_iso1PGPDataType(struct iso1PGPDataType* iso1PGPDataType);


#endif /* DEPLOY_ISO1_CODEC */

#ifdef __cplusplus
}
#endif

#endif
