/*
 * Copyright (C) 2007-2018 Siemens AG
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published
 * by the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

/*******************************************************************
 *
 * @author Daniel.Peintner.EXT@siemens.com
 * @version 0.9.4 
 * @contact Richard.Kuntschke@siemens.com
 *
 * <p>Code generated by EXIdizer</p>
 * <p>Schema: V2G_CI_MsgDef.xsd</p>
 *
 *
 ********************************************************************/



/**
 * \file 	EXIDatatypes.h
 * \brief 	Datatype definitions and structs for given XML Schema definitions and initialization methods
 *
 */

#ifndef EXI_din_DATATYPES_H
#define EXI_din_DATATYPES_H

#ifdef __cplusplus
extern "C" {
#endif

#define SUPPORT_YES 1
#define SUPPORT_NO 2
#define DEPLOY_DIN_CODEC SUPPORT_NO
#define DEPLOY_DIN_CODEC_FRAGMENT SUPPORT_NO

#if DEPLOY_DIN_CODEC == SUPPORT_YES

#include <stdint.h>

#include "EXITypes.h"


/* Datatype definitions and structs for given XML Schema definitions */

#define UNION_YES 1
#define UNION_NO 2
#define SAVE_MEMORY_WITH_UNNAMED_UNION UNION_YES

/* Note: Please find below a list of occurrence limits that have been applied */
/* Limit occurrence of element "http://www.w3.org/2000/09/xmldsig#":SPKISexp from unbounded to 1 (see #define dinSPKIDataType_SPKISexp_ARRAY_SIZE) */
/* Limit occurrence of element "urn:iso:15118:2:2010:MsgDataTypes":RootCertificateID from unbounded to 5 (see #define dinListOfRootCertificateIDsType_RootCertificateID_ARRAY_SIZE) */
/* Limit occurrence of element "http://www.w3.org/2000/09/xmldsig#":XPath from unbounded to 1 (see #define dinTransformType_XPath_ARRAY_SIZE) */
/* Limit occurrence of element "http://www.w3.org/2000/09/xmldsig#":Transform from unbounded to 1 (see #define dinTransformsType_Transform_ARRAY_SIZE) */
/* Limit occurrence of element "http://www.w3.org/2000/09/xmldsig#":Reference from unbounded to 1 (see #define dinManifestType_Reference_ARRAY_SIZE) */
/* Limit occurrence of element "urn:iso:15118:2:2010:MsgDataTypes":PaymentOption from unbounded to 5 (see #define dinPaymentOptionsType_PaymentOption_ARRAY_SIZE) */
/* Limit occurrence of element "urn:iso:15118:2:2010:MsgDataTypes":ProfileEntry from unbounded to 24 (see #define dinChargingProfileType_ProfileEntry_ARRAY_SIZE) */
/* Limit occurrence of element "http://www.w3.org/2000/09/xmldsig#":Reference from unbounded to 1 (see #define dinSignedInfoType_Reference_ARRAY_SIZE) */
/* Limit occurrence of element "urn:iso:15118:2:2010:MsgDataTypes":Certificate from unbounded to 5 (see #define dinSubCertificatesType_Certificate_ARRAY_SIZE) */
/* Limit occurrence of element "urn:iso:15118:2:2010:MsgDataTypes":SelectedService from unbounded to 16 (see #define dinSelectedServiceListType_SelectedService_ARRAY_SIZE) */
/* Limit occurrence of element "http://www.w3.org/2000/09/xmldsig#":X509IssuerSerial from unbounded to 1 (see #define dinX509DataType_X509IssuerSerial_ARRAY_SIZE) */
/* Limit occurrence of element "http://www.w3.org/2000/09/xmldsig#":X509SKI from unbounded to 1 (see #define dinX509DataType_X509SKI_ARRAY_SIZE) */
/* Limit occurrence of element "http://www.w3.org/2000/09/xmldsig#":X509SubjectName from unbounded to 1 (see #define dinX509DataType_X509SubjectName_ARRAY_SIZE) */
/* Limit occurrence of element "http://www.w3.org/2000/09/xmldsig#":X509Certificate from unbounded to 1 (see #define dinX509DataType_X509Certificate_ARRAY_SIZE) */
/* Limit occurrence of element "http://www.w3.org/2000/09/xmldsig#":X509CRL from unbounded to 1 (see #define dinX509DataType_X509CRL_ARRAY_SIZE) */
/* Limit occurrence of element "http://www.w3.org/2000/09/xmldsig#":SignatureProperty from unbounded to 1 (see #define dinSignaturePropertiesType_SignatureProperty_ARRAY_SIZE) */
/* Limit occurrence of element "urn:iso:15118:2:2010:MsgDataTypes":PMaxScheduleEntry from unbounded to 5 (see #define dinPMaxScheduleType_PMaxScheduleEntry_ARRAY_SIZE) */
/* Limit occurrence of element "urn:iso:15118:2:2010:MsgDataTypes":Parameter from unbounded to 16 (see #define dinParameterSetType_Parameter_ARRAY_SIZE) */
/* Limit occurrence of element "urn:iso:15118:2:2010:MsgDataTypes":Cost from unbounded to 5 (see #define dinConsumptionCostType_Cost_ARRAY_SIZE) */
/* Limit occurrence of element "urn:iso:15118:2:2010:MsgDataTypes":Service from unbounded to 8 (see #define dinServiceTagListType_Service_ARRAY_SIZE) */
/* Limit occurrence of element "urn:iso:15118:2:2010:MsgDataTypes":ParameterSet from unbounded to 5 (see #define dinServiceParameterListType_ParameterSet_ARRAY_SIZE) */
/* Limit occurrence of element "http://www.w3.org/2000/09/xmldsig#":KeyName from unbounded to 1 (see #define dinKeyInfoType_KeyName_ARRAY_SIZE) */
/* Limit occurrence of element "http://www.w3.org/2000/09/xmldsig#":KeyValue from unbounded to 1 (see #define dinKeyInfoType_KeyValue_ARRAY_SIZE) */
/* Limit occurrence of element "http://www.w3.org/2000/09/xmldsig#":RetrievalMethod from unbounded to 1 (see #define dinKeyInfoType_RetrievalMethod_ARRAY_SIZE) */
/* Limit occurrence of element "http://www.w3.org/2000/09/xmldsig#":X509Data from unbounded to 1 (see #define dinKeyInfoType_X509Data_ARRAY_SIZE) */
/* Limit occurrence of element "http://www.w3.org/2000/09/xmldsig#":PGPData from unbounded to 1 (see #define dinKeyInfoType_PGPData_ARRAY_SIZE) */
/* Limit occurrence of element "http://www.w3.org/2000/09/xmldsig#":SPKIData from unbounded to 1 (see #define dinKeyInfoType_SPKIData_ARRAY_SIZE) */
/* Limit occurrence of element "http://www.w3.org/2000/09/xmldsig#":MgmtData from unbounded to 1 (see #define dinKeyInfoType_MgmtData_ARRAY_SIZE) */
/* Limit occurrence of element "urn:iso:15118:2:2010:MsgDataTypes":ConsumptionCost from unbounded to 5 (see #define dinSalesTariffEntryType_ConsumptionCost_ARRAY_SIZE) */
/* Limit occurrence of element "http://www.w3.org/2000/09/xmldsig#":Object from unbounded to 1 (see #define dinSignatureType_Object_ARRAY_SIZE) */
/* Limit occurrence of element "urn:iso:15118:2:2010:MsgDataTypes":SalesTariffEntry from unbounded to 5 (see #define dinSalesTariffType_SalesTariffEntry_ARRAY_SIZE) */
/* Limit occurrence of element "urn:iso:15118:2:2010:MsgDataTypes":SAScheduleTuple from unbounded to 5 (see #define dinSAScheduleListType_SAScheduleTuple_ARRAY_SIZE) */


typedef enum {
	dinDC_EVSEStatusCodeType_EVSE_NotReady = 0,
	dinDC_EVSEStatusCodeType_EVSE_Ready = 1,
	dinDC_EVSEStatusCodeType_EVSE_Shutdown = 2,
	dinDC_EVSEStatusCodeType_EVSE_UtilityInterruptEvent = 3,
	dinDC_EVSEStatusCodeType_EVSE_IsolationMonitoringActive = 4,
	dinDC_EVSEStatusCodeType_EVSE_EmergencyShutdown = 5,
	dinDC_EVSEStatusCodeType_EVSE_Malfunction = 6,
	dinDC_EVSEStatusCodeType_Reserved_8 = 7,
	dinDC_EVSEStatusCodeType_Reserved_9 = 8,
	dinDC_EVSEStatusCodeType_Reserved_A = 9,
	dinDC_EVSEStatusCodeType_Reserved_B = 10,
	dinDC_EVSEStatusCodeType_Reserved_C = 11
} dinDC_EVSEStatusCodeType;

/* Complex type name='urn:iso:15118:2:2010:MsgBody,SessionSetupReqType',  base type name='BodyBaseType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2010:MsgBody":EVCCID)',  derivedBy='EXTENSION'.  */
#define dinSessionSetupReqType_EVCCID_BYTES_SIZE 8 /* XML schema facet maxLength for urn:iso:15118:2:2010:MsgDataTypes,evccIDType is 8 */
struct dinSessionSetupReqType {
	/* element: "urn:iso:15118:2:2010:MsgBody":EVCCID, urn:iso:15118:2:2010:MsgDataTypes,evccIDType */
	struct {
		uint8_t bytes[dinSessionSetupReqType_EVCCID_BYTES_SIZE];
		uint16_t bytesLen;
	}  EVCCID ;
};

typedef enum {
	dinEVSEProcessingType_Finished = 0,
	dinEVSEProcessingType_Ongoing = 1
} dinEVSEProcessingType;

/* Complex type name='http://www.w3.org/2000/09/xmldsig#,CanonicalizationMethodType',  base type name='anyType',  content type='MIXED',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='((WC[##any]){0-UNBOUNDED})',  derivedBy='RESTRICTION'.  */
#define dinCanonicalizationMethodType_Algorithm_CHARACTERS_SIZE 65 + EXTRA_CHAR 
#define dinCanonicalizationMethodType_ANY_CHARACTERS_SIZE 50 + EXTRA_CHAR 
struct dinCanonicalizationMethodType {
	/* attribute: Algorithm {http://www.w3.org/2001/XMLSchema,anyURI} */
	struct {
		exi_string_character_t characters[dinCanonicalizationMethodType_Algorithm_CHARACTERS_SIZE];
		uint16_t charactersLen;
	}  Algorithm ;
	/* element: WC[##any] */
	struct {
		exi_string_character_t characters[dinCanonicalizationMethodType_ANY_CHARACTERS_SIZE];
		uint16_t charactersLen;
	}  ANY ;
	unsigned int ANY_isUsed:1;
};

/* Complex type name='http://www.w3.org/2000/09/xmldsig#,SPKIDataType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("http://www.w3.org/2000/09/xmldsig#":SPKISexp,(WC[##other:"http://www.w3.org/2000/09/xmldsig#"]){0-1}){1-UNBOUNDED}',  derivedBy='RESTRICTION'.  */
#define dinSPKIDataType_SPKISexp_BYTES_SIZE 350 
#define dinSPKIDataType_SPKISexp_ARRAY_SIZE 1
#define dinSPKIDataType_ANY_CHARACTERS_SIZE 50 + EXTRA_CHAR 
struct dinSPKIDataType {
	/* element: "http://www.w3.org/2000/09/xmldsig#":SPKISexp, http://www.w3.org/2001/XMLSchema,base64Binary */
	struct {
		struct {
			uint8_t bytes[dinSPKIDataType_SPKISexp_BYTES_SIZE];
			uint16_t bytesLen;
		}  array[dinSPKIDataType_SPKISexp_ARRAY_SIZE];
		uint16_t arrayLen;
	} SPKISexp;
	/* element: WC[##other:"http://www.w3.org/2000/09/xmldsig#"] */
	struct {
		exi_string_character_t characters[dinSPKIDataType_ANY_CHARACTERS_SIZE];
		uint16_t charactersLen;
	}  ANY ;
	unsigned int ANY_isUsed:1;
};

/* Complex type name='urn:iso:15118:2:2010:MsgDataTypes,ListOfRootCertificateIDsType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2010:MsgDataTypes":RootCertificateID{1-UNBOUNDED})',  derivedBy='RESTRICTION'.  */
#define dinListOfRootCertificateIDsType_RootCertificateID_CHARACTERS_SIZE 40 + EXTRA_CHAR /* XML schema facet maxLength for urn:iso:15118:2:2010:MsgDataTypes,rootCertificateIDType is 40 */
#define dinListOfRootCertificateIDsType_RootCertificateID_ARRAY_SIZE 5
struct dinListOfRootCertificateIDsType {
	/* element: "urn:iso:15118:2:2010:MsgDataTypes":RootCertificateID, urn:iso:15118:2:2010:MsgDataTypes,rootCertificateIDType */
	struct {
		struct {
			exi_string_character_t characters[dinListOfRootCertificateIDsType_RootCertificateID_CHARACTERS_SIZE];
			uint16_t charactersLen;
		}  array[dinListOfRootCertificateIDsType_RootCertificateID_ARRAY_SIZE];
		uint16_t arrayLen;
	} RootCertificateID;
};

/* Complex type name='http://www.w3.org/2000/09/xmldsig#,TransformType',  base type name='anyType',  content type='MIXED',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='((WC[##other:"http://www.w3.org/2000/09/xmldsig#"])|"http://www.w3.org/2000/09/xmldsig#":XPath){0-UNBOUNDED}',  derivedBy='RESTRICTION'.  */
#define dinTransformType_Algorithm_CHARACTERS_SIZE 65 + EXTRA_CHAR 
#define dinTransformType_ANY_CHARACTERS_SIZE 50 + EXTRA_CHAR 
#define dinTransformType_XPath_CHARACTERS_SIZE 50 + EXTRA_CHAR 
#define dinTransformType_XPath_ARRAY_SIZE 1
struct dinTransformType {
	/* attribute: Algorithm {http://www.w3.org/2001/XMLSchema,anyURI} */
	struct {
		exi_string_character_t characters[dinTransformType_Algorithm_CHARACTERS_SIZE];
		uint16_t charactersLen;
	}  Algorithm ;
	/* element: WC[##other:"http://www.w3.org/2000/09/xmldsig#"] */
	struct {
		exi_string_character_t characters[dinTransformType_ANY_CHARACTERS_SIZE];
		uint16_t charactersLen;
	}  ANY ;
	unsigned int ANY_isUsed:1;
	/* element: "http://www.w3.org/2000/09/xmldsig#":XPath, http://www.w3.org/2001/XMLSchema,string */
	struct {
		struct {
			exi_string_character_t characters[dinTransformType_XPath_CHARACTERS_SIZE];
			uint16_t charactersLen;
		}  array[dinTransformType_XPath_ARRAY_SIZE];
		uint16_t arrayLen;
	} XPath;
};

typedef enum {
	dinDC_EVErrorCodeType_NO_ERROR = 0,
	dinDC_EVErrorCodeType_FAILED_RESSTemperatureInhibit = 1,
	dinDC_EVErrorCodeType_FAILED_EVShiftPosition = 2,
	dinDC_EVErrorCodeType_FAILED_ChargerConnectorLockFault = 3,
	dinDC_EVErrorCodeType_FAILED_EVRESSMalfunction = 4,
	dinDC_EVErrorCodeType_FAILED_ChargingCurrentdifferential = 5,
	dinDC_EVErrorCodeType_FAILED_ChargingVoltageOutOfRange = 6,
	dinDC_EVErrorCodeType_Reserved_A = 7,
	dinDC_EVErrorCodeType_Reserved_B = 8,
	dinDC_EVErrorCodeType_Reserved_C = 9,
	dinDC_EVErrorCodeType_FAILED_ChargingSystemIncompatibility = 10,
	dinDC_EVErrorCodeType_NoData = 11
} dinDC_EVErrorCodeType;

/* Complex type name='urn:iso:15118:2:2010:MsgBody,ContractAuthenticationReqType',  base type name='BodyBaseType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2010:MsgBody":GenChallenge{0-1})',  derivedBy='EXTENSION'.  */
#define dinContractAuthenticationReqType_Id_CHARACTERS_SIZE 50 + EXTRA_CHAR 
#define dinContractAuthenticationReqType_GenChallenge_CHARACTERS_SIZE 50 + EXTRA_CHAR 
struct dinContractAuthenticationReqType {
	/* attribute: Id {http://www.w3.org/2001/XMLSchema,IDREF} */
	struct {
		exi_string_character_t characters[dinContractAuthenticationReqType_Id_CHARACTERS_SIZE];
		uint16_t charactersLen;
	}  Id ;
	unsigned int Id_isUsed:1;
	/* element: "urn:iso:15118:2:2010:MsgBody":GenChallenge, urn:iso:15118:2:2010:MsgDataTypes,genChallengeType */
	struct {
		exi_string_character_t characters[dinContractAuthenticationReqType_GenChallenge_CHARACTERS_SIZE];
		uint16_t charactersLen;
	}  GenChallenge ;
	unsigned int GenChallenge_isUsed:1;
};

/* Complex type name='urn:iso:15118:2:2010:MsgDataTypes,EVSEChargeParameterType',  base type name='anyType',  content type='EMPTY',  isAbstract='true',  hasTypeId='false',  final='0',  block='0',  derivedBy='RESTRICTION'.  */
struct dinEVSEChargeParameterType {
	int noContent; /* avoid warning */
};

/* Complex type name='urn:iso:15118:2:2010:MsgDataTypes,RelativeTimeIntervalType',  base type name='IntervalType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2010:MsgDataTypes":start,"urn:iso:15118:2:2010:MsgDataTypes":duration{0-1})',  derivedBy='EXTENSION'.  */
struct dinRelativeTimeIntervalType {
	/* element: "urn:iso:15118:2:2010:MsgDataTypes":start, http://www.w3.org/2001/XMLSchema,unsignedInt */
	uint32_t start ;
	/* element: "urn:iso:15118:2:2010:MsgDataTypes":duration, http://www.w3.org/2001/XMLSchema,unsignedInt */
	uint32_t duration ;
	unsigned int duration_isUsed:1;
};

/* Complex type name='urn:iso:15118:2:2010:MsgDataTypes,EVStatusType',  base type name='anyType',  content type='EMPTY',  isAbstract='true',  hasTypeId='false',  final='0',  block='0',  derivedBy='RESTRICTION'.  */
struct dinEVStatusType {
	int noContent; /* avoid warning */
};

/* Complex type name='http://www.w3.org/2000/09/xmldsig#,DSAKeyValueType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='(("http://www.w3.org/2000/09/xmldsig#":P,"http://www.w3.org/2000/09/xmldsig#":Q){0-1},"http://www.w3.org/2000/09/xmldsig#":G{0-1},"http://www.w3.org/2000/09/xmldsig#":Y,"http://www.w3.org/2000/09/xmldsig#":J{0-1},("http://www.w3.org/2000/09/xmldsig#":Seed,"http://www.w3.org/2000/09/xmldsig#":PgenCounter){0-1})',  derivedBy='RESTRICTION'.  */
#define dinDSAKeyValueType_P_BYTES_SIZE 350 
#define dinDSAKeyValueType_Q_BYTES_SIZE 350 
#define dinDSAKeyValueType_G_BYTES_SIZE 350 
#define dinDSAKeyValueType_Y_BYTES_SIZE 350 
#define dinDSAKeyValueType_J_BYTES_SIZE 350 
#define dinDSAKeyValueType_Seed_BYTES_SIZE 350 
#define dinDSAKeyValueType_PgenCounter_BYTES_SIZE 350 
struct dinDSAKeyValueType {
	/* element: "http://www.w3.org/2000/09/xmldsig#":P, http://www.w3.org/2000/09/xmldsig#,CryptoBinary */
	struct {
		uint8_t bytes[dinDSAKeyValueType_P_BYTES_SIZE];
		uint16_t bytesLen;
	}  P ;
	unsigned int P_isUsed:1;
	/* element: "http://www.w3.org/2000/09/xmldsig#":Q, http://www.w3.org/2000/09/xmldsig#,CryptoBinary */
	struct {
		uint8_t bytes[dinDSAKeyValueType_Q_BYTES_SIZE];
		uint16_t bytesLen;
	}  Q ;
	unsigned int Q_isUsed:1;
	/* element: "http://www.w3.org/2000/09/xmldsig#":G, http://www.w3.org/2000/09/xmldsig#,CryptoBinary */
	struct {
		uint8_t bytes[dinDSAKeyValueType_G_BYTES_SIZE];
		uint16_t bytesLen;
	}  G ;
	unsigned int G_isUsed:1;
	/* element: "http://www.w3.org/2000/09/xmldsig#":Y, http://www.w3.org/2000/09/xmldsig#,CryptoBinary */
	struct {
		uint8_t bytes[dinDSAKeyValueType_Y_BYTES_SIZE];
		uint16_t bytesLen;
	}  Y ;
	/* element: "http://www.w3.org/2000/09/xmldsig#":J, http://www.w3.org/2000/09/xmldsig#,CryptoBinary */
	struct {
		uint8_t bytes[dinDSAKeyValueType_J_BYTES_SIZE];
		uint16_t bytesLen;
	}  J ;
	unsigned int J_isUsed:1;
	/* element: "http://www.w3.org/2000/09/xmldsig#":Seed, http://www.w3.org/2000/09/xmldsig#,CryptoBinary */
	struct {
		uint8_t bytes[dinDSAKeyValueType_Seed_BYTES_SIZE];
		uint16_t bytesLen;
	}  Seed ;
	unsigned int Seed_isUsed:1;
	/* element: "http://www.w3.org/2000/09/xmldsig#":PgenCounter, http://www.w3.org/2000/09/xmldsig#,CryptoBinary */
	struct {
		uint8_t bytes[dinDSAKeyValueType_PgenCounter_BYTES_SIZE];
		uint16_t bytesLen;
	}  PgenCounter ;
	unsigned int PgenCounter_isUsed:1;
};

/* Complex type name='urn:iso:15118:2:2010:MsgDataTypes,SASchedulesType',  base type name='anyType',  content type='EMPTY',  isAbstract='true',  hasTypeId='false',  final='0',  block='0',  derivedBy='RESTRICTION'.  */
struct dinSASchedulesType {
	int noContent; /* avoid warning */
};

/* Complex type name='urn:iso:15118:2:2010:MsgDataTypes,EVChargeParameterType',  base type name='anyType',  content type='EMPTY',  isAbstract='true',  hasTypeId='false',  final='0',  block='0',  derivedBy='RESTRICTION'.  */
struct dinEVChargeParameterType {
	int noContent; /* avoid warning */
};

/* Complex type name='urn:iso:15118:2:2010:MsgDef,BodyBaseType',  base type name='anyType',  content type='EMPTY',  isAbstract='true',  hasTypeId='false',  final='0',  block='0',  derivedBy='RESTRICTION'.  */
struct dinBodyBaseType {
	int noContent; /* avoid warning */
};

typedef enum {
	dinunitSymbolType_h = 0,
	dinunitSymbolType_m = 1,
	dinunitSymbolType_s = 2,
	dinunitSymbolType_A = 3,
	dinunitSymbolType_Ah = 4,
	dinunitSymbolType_V = 5,
	dinunitSymbolType_VA = 6,
	dinunitSymbolType_W = 7,
	dinunitSymbolType_W_s = 8,
	dinunitSymbolType_Wh = 9
} dinunitSymbolType;

/* Complex type name='urn:iso:15118:2:2010:MsgDataTypes,IntervalType',  base type name='anyType',  content type='EMPTY',  isAbstract='true',  hasTypeId='false',  final='0',  block='0',  derivedBy='RESTRICTION'.  */
struct dinIntervalType {
	int noContent; /* avoid warning */
};

/* Complex type name='http://www.w3.org/2000/09/xmldsig#,TransformsType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("http://www.w3.org/2000/09/xmldsig#":Transform{1-UNBOUNDED})',  derivedBy='RESTRICTION'.  */
#define dinTransformsType_Transform_ARRAY_SIZE 1
struct dinTransformsType {
	/* element: "http://www.w3.org/2000/09/xmldsig#":Transform, Complex type name='http://www.w3.org/2000/09/xmldsig#,TransformType',  base type name='anyType',  content type='MIXED',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='((WC[##other:"http://www.w3.org/2000/09/xmldsig#"])|"http://www.w3.org/2000/09/xmldsig#":XPath){0-UNBOUNDED}',  derivedBy='RESTRICTION'.  */
	struct {
		struct dinTransformType array[dinTransformsType_Transform_ARRAY_SIZE];
		uint16_t arrayLen;
	} Transform;
};

/* Complex type name='urn:iso:15118:2:2010:MsgDataTypes,EntryType',  base type name='anyType',  content type='ELEMENT',  isAbstract='true',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2010:MsgDataTypes":TimeInterval)',  derivedBy='RESTRICTION'.  */
struct dinEntryType {
	/* substitutionGroup */
#if SAVE_MEMORY_WITH_UNNAMED_UNION == UNION_YES
	union {
#endif /* SAVE_MEMORY_WITH_UNNAMED_UNION == UNION_YES */ 
		/* element: "urn:iso:15118:2:2010:MsgDataTypes":TimeInterval, Complex type name='urn:iso:15118:2:2010:MsgDataTypes,IntervalType',  base type name='anyType',  content type='EMPTY',  isAbstract='true',  hasTypeId='false',  final='0',  block='0',  derivedBy='RESTRICTION'.  */
		struct dinIntervalType TimeInterval ;
		/* element: "urn:iso:15118:2:2010:MsgDataTypes":RelativeTimeInterval, Complex type name='urn:iso:15118:2:2010:MsgDataTypes,RelativeTimeIntervalType',  base type name='IntervalType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2010:MsgDataTypes":start,"urn:iso:15118:2:2010:MsgDataTypes":duration{0-1})',  derivedBy='EXTENSION'.  */
		struct dinRelativeTimeIntervalType RelativeTimeInterval ;
#if SAVE_MEMORY_WITH_UNNAMED_UNION == UNION_YES
	};
#endif /* SAVE_MEMORY_WITH_UNNAMED_UNION == UNION_YES */ 
		unsigned int TimeInterval_isUsed:1;
		unsigned int RelativeTimeInterval_isUsed:1;
};

/* Complex type name='urn:iso:15118:2:2010:MsgBody,SessionStopType',  base type name='BodyBaseType',  content type='EMPTY',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  derivedBy='EXTENSION'.  */
struct dinSessionStopType {
	int noContent; /* avoid warning */
};

/* Complex type name='urn:iso:15118:2:2010:MsgBody,ServiceDetailReqType',  base type name='BodyBaseType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2010:MsgBody":ServiceID)',  derivedBy='EXTENSION'.  */
struct dinServiceDetailReqType {
	/* element: "urn:iso:15118:2:2010:MsgBody":ServiceID, urn:iso:15118:2:2010:MsgDataTypes,serviceIDType */
	uint16_t ServiceID ;
};

/* Complex type name='http://www.w3.org/2000/09/xmldsig#,DigestMethodType',  base type name='anyType',  content type='MIXED',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='((WC[##other:"http://www.w3.org/2000/09/xmldsig#"]){0-UNBOUNDED})',  derivedBy='RESTRICTION'.  */
#define dinDigestMethodType_Algorithm_CHARACTERS_SIZE 65 + EXTRA_CHAR 
#define dinDigestMethodType_ANY_CHARACTERS_SIZE 50 + EXTRA_CHAR 
struct dinDigestMethodType {
	/* attribute: Algorithm {http://www.w3.org/2001/XMLSchema,anyURI} */
	struct {
		exi_string_character_t characters[dinDigestMethodType_Algorithm_CHARACTERS_SIZE];
		uint16_t charactersLen;
	}  Algorithm ;
	/* element: WC[##other:"http://www.w3.org/2000/09/xmldsig#"] */
	struct {
		exi_string_character_t characters[dinDigestMethodType_ANY_CHARACTERS_SIZE];
		uint16_t charactersLen;
	}  ANY ;
	unsigned int ANY_isUsed:1;
};

typedef enum {
	dinvalueType_bool = 0,
	dinvalueType_byte = 1,
	dinvalueType_short = 2,
	dinvalueType_int = 3,
	dinvalueType_physicalValue = 4,
	dinvalueType_string = 5
} dinvalueType;

/* Complex type name='urn:iso:15118:2:2010:MsgBody,ChargingStatusReqType',  base type name='BodyBaseType',  content type='EMPTY',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  derivedBy='EXTENSION'.  */
struct dinChargingStatusReqType {
	int noContent; /* avoid warning */
};

/* Complex type name='http://www.w3.org/2000/09/xmldsig#,SignatureMethodType',  base type name='anyType',  content type='MIXED',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("http://www.w3.org/2000/09/xmldsig#":HMACOutputLength{0-1},(WC[##other:"http://www.w3.org/2000/09/xmldsig#"]){0-UNBOUNDED})',  derivedBy='RESTRICTION'.  */
#define dinSignatureMethodType_Algorithm_CHARACTERS_SIZE 65 + EXTRA_CHAR 
#define dinSignatureMethodType_ANY_CHARACTERS_SIZE 50 + EXTRA_CHAR 
struct dinSignatureMethodType {
	/* attribute: Algorithm {http://www.w3.org/2001/XMLSchema,anyURI} */
	struct {
		exi_string_character_t characters[dinSignatureMethodType_Algorithm_CHARACTERS_SIZE];
		uint16_t charactersLen;
	}  Algorithm ;
	/* element: "http://www.w3.org/2000/09/xmldsig#":HMACOutputLength, http://www.w3.org/2000/09/xmldsig#,HMACOutputLengthType */
	int64_t HMACOutputLength ;
	unsigned int HMACOutputLength_isUsed:1;
	/* element: WC[##other:"http://www.w3.org/2000/09/xmldsig#"] */
	struct {
		exi_string_character_t characters[dinSignatureMethodType_ANY_CHARACTERS_SIZE];
		uint16_t charactersLen;
	}  ANY ;
	unsigned int ANY_isUsed:1;
};

/* Complex type name='urn:iso:15118:2:2010:MsgBody,CertificateInstallationReqType',  base type name='BodyBaseType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2010:MsgBody":OEMProvisioningCert,"urn:iso:15118:2:2010:MsgBody":ListOfRootCertificateIDs,"urn:iso:15118:2:2010:MsgBody":DHParams)',  derivedBy='EXTENSION'.  */
#define dinCertificateInstallationReqType_Id_CHARACTERS_SIZE 50 + EXTRA_CHAR 
#define dinCertificateInstallationReqType_OEMProvisioningCert_BYTES_SIZE 1200 /* XML schema facet maxLength for urn:iso:15118:2:2010:MsgDataTypes,certificateType is 1200 */
#define dinCertificateInstallationReqType_DHParams_BYTES_SIZE 256 /* XML schema facet maxLength for urn:iso:15118:2:2010:MsgDataTypes,dHParamsType is 256 */
struct dinCertificateInstallationReqType {
	/* attribute: Id {http://www.w3.org/2001/XMLSchema,IDREF} */
	struct {
		exi_string_character_t characters[dinCertificateInstallationReqType_Id_CHARACTERS_SIZE];
		uint16_t charactersLen;
	}  Id ;
	unsigned int Id_isUsed:1;
	/* element: "urn:iso:15118:2:2010:MsgBody":OEMProvisioningCert, urn:iso:15118:2:2010:MsgDataTypes,certificateType */
	struct {
		uint8_t bytes[dinCertificateInstallationReqType_OEMProvisioningCert_BYTES_SIZE];
		uint16_t bytesLen;
	}  OEMProvisioningCert ;
	/* element: "urn:iso:15118:2:2010:MsgBody":ListOfRootCertificateIDs, Complex type name='urn:iso:15118:2:2010:MsgDataTypes,ListOfRootCertificateIDsType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2010:MsgDataTypes":RootCertificateID{1-UNBOUNDED})',  derivedBy='RESTRICTION'.  */
	struct dinListOfRootCertificateIDsType ListOfRootCertificateIDs ;
	/* element: "urn:iso:15118:2:2010:MsgBody":DHParams, urn:iso:15118:2:2010:MsgDataTypes,dHParamsType */
	struct {
		uint8_t bytes[dinCertificateInstallationReqType_DHParams_BYTES_SIZE];
		uint16_t bytesLen;
	}  DHParams ;
};

typedef enum {
	dinEVRequestedEnergyTransferType_AC_single_phase_core = 0,
	dinEVRequestedEnergyTransferType_AC_three_phase_core = 1,
	dinEVRequestedEnergyTransferType_DC_core = 2,
	dinEVRequestedEnergyTransferType_DC_extended = 3,
	dinEVRequestedEnergyTransferType_DC_combo_core = 4,
	dinEVRequestedEnergyTransferType_DC_unique = 5
} dinEVRequestedEnergyTransferType;

typedef enum {
	dinpaymentOptionType_Contract = 0,
	dinpaymentOptionType_ExternalPayment = 1
} dinpaymentOptionType;

typedef enum {
	dinEVSESupportedEnergyTransferType_AC_single_phase_core = 0,
	dinEVSESupportedEnergyTransferType_AC_three_phase_core = 1,
	dinEVSESupportedEnergyTransferType_DC_core = 2,
	dinEVSESupportedEnergyTransferType_DC_extended = 3,
	dinEVSESupportedEnergyTransferType_DC_combo_core = 4,
	dinEVSESupportedEnergyTransferType_DC_dual = 5,
	dinEVSESupportedEnergyTransferType_AC_core1p_DC_extended = 6,
	dinEVSESupportedEnergyTransferType_AC_single_DC_core = 7,
	dinEVSESupportedEnergyTransferType_AC_single_phase_three_phase_core_DC_extended = 8,
	dinEVSESupportedEnergyTransferType_AC_core3p_DC_extended = 9
} dinEVSESupportedEnergyTransferType;

/* Complex type name='http://www.w3.org/2000/09/xmldsig#,ReferenceType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("http://www.w3.org/2000/09/xmldsig#":Transforms{0-1},"http://www.w3.org/2000/09/xmldsig#":DigestMethod,"http://www.w3.org/2000/09/xmldsig#":DigestValue)',  derivedBy='RESTRICTION'.  */
#define dinReferenceType_Id_CHARACTERS_SIZE 50 + EXTRA_CHAR 
#define dinReferenceType_URI_CHARACTERS_SIZE 50 + EXTRA_CHAR 
#define dinReferenceType_Type_CHARACTERS_SIZE 50 + EXTRA_CHAR 
#define dinReferenceType_DigestValue_BYTES_SIZE 350 
struct dinReferenceType {
	/* attribute: Id {http://www.w3.org/2001/XMLSchema,ID} */
	struct {
		exi_string_character_t characters[dinReferenceType_Id_CHARACTERS_SIZE];
		uint16_t charactersLen;
	}  Id ;
	unsigned int Id_isUsed:1;
	/* attribute: URI {http://www.w3.org/2001/XMLSchema,anyURI} */
	struct {
		exi_string_character_t characters[dinReferenceType_URI_CHARACTERS_SIZE];
		uint16_t charactersLen;
	}  URI ;
	unsigned int URI_isUsed:1;
	/* attribute: Type {http://www.w3.org/2001/XMLSchema,anyURI} */
	struct {
		exi_string_character_t characters[dinReferenceType_Type_CHARACTERS_SIZE];
		uint16_t charactersLen;
	}  Type ;
	unsigned int Type_isUsed:1;
	/* element: "http://www.w3.org/2000/09/xmldsig#":Transforms, Complex type name='http://www.w3.org/2000/09/xmldsig#,TransformsType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("http://www.w3.org/2000/09/xmldsig#":Transform{1-UNBOUNDED})',  derivedBy='RESTRICTION'.  */
	struct dinTransformsType Transforms ;
	unsigned int Transforms_isUsed:1;
	/* element: "http://www.w3.org/2000/09/xmldsig#":DigestMethod, Complex type name='http://www.w3.org/2000/09/xmldsig#,DigestMethodType',  base type name='anyType',  content type='MIXED',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='((WC[##other:"http://www.w3.org/2000/09/xmldsig#"]){0-UNBOUNDED})',  derivedBy='RESTRICTION'.  */
	struct dinDigestMethodType DigestMethod ;
	/* element: "http://www.w3.org/2000/09/xmldsig#":DigestValue, http://www.w3.org/2000/09/xmldsig#,DigestValueType */
	struct {
		uint8_t bytes[dinReferenceType_DigestValue_BYTES_SIZE];
		uint16_t bytesLen;
	}  DigestValue ;
};

/* Complex type name='urn:iso:15118:2:2010:MsgDataTypes,ProfileEntryType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2010:MsgDataTypes":ChargingProfileEntryStart,"urn:iso:15118:2:2010:MsgDataTypes":ChargingProfileEntryMaxPower)',  derivedBy='RESTRICTION'.  */
struct dinProfileEntryType {
	/* element: "urn:iso:15118:2:2010:MsgDataTypes":ChargingProfileEntryStart, http://www.w3.org/2001/XMLSchema,unsignedInt */
	uint32_t ChargingProfileEntryStart ;
	/* element: "urn:iso:15118:2:2010:MsgDataTypes":ChargingProfileEntryMaxPower, urn:iso:15118:2:2010:MsgDataTypes,PMaxType */
	int16_t ChargingProfileEntryMaxPower ;
};

/* Complex type name='http://www.w3.org/2000/09/xmldsig#,RSAKeyValueType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("http://www.w3.org/2000/09/xmldsig#":Modulus,"http://www.w3.org/2000/09/xmldsig#":Exponent)',  derivedBy='RESTRICTION'.  */
#define dinRSAKeyValueType_Modulus_BYTES_SIZE 350 
#define dinRSAKeyValueType_Exponent_BYTES_SIZE 350 
struct dinRSAKeyValueType {
	/* element: "http://www.w3.org/2000/09/xmldsig#":Modulus, http://www.w3.org/2000/09/xmldsig#,CryptoBinary */
	struct {
		uint8_t bytes[dinRSAKeyValueType_Modulus_BYTES_SIZE];
		uint16_t bytesLen;
	}  Modulus ;
	/* element: "http://www.w3.org/2000/09/xmldsig#":Exponent, http://www.w3.org/2000/09/xmldsig#,CryptoBinary */
	struct {
		uint8_t bytes[dinRSAKeyValueType_Exponent_BYTES_SIZE];
		uint16_t bytesLen;
	}  Exponent ;
};

typedef enum {
	dinfaultCodeType_ParsingError = 0,
	dinfaultCodeType_NoTLSRootCertificatAvailable = 1,
	dinfaultCodeType_UnknownError = 2
} dinfaultCodeType;

/* Complex type name='urn:iso:15118:2:2010:MsgDataTypes,EVSEStatusType',  base type name='anyType',  content type='EMPTY',  isAbstract='true',  hasTypeId='false',  final='0',  block='0',  derivedBy='RESTRICTION'.  */
struct dinEVSEStatusType {
	int noContent; /* avoid warning */
};

typedef enum {
	dinserviceCategoryType_EVCharging = 0,
	dinserviceCategoryType_Internet = 1,
	dinserviceCategoryType_ContractCertificate = 2,
	dinserviceCategoryType_OtherCustom = 3
} dinserviceCategoryType;

typedef enum {
	dinEVSENotificationType_None = 0,
	dinEVSENotificationType_StopCharging = 1,
	dinEVSENotificationType_ReNegotiation = 2
} dinEVSENotificationType;

/* Complex type name='urn:iso:15118:2:2010:MsgDataTypes,EVPowerDeliveryParameterType',  base type name='anyType',  content type='EMPTY',  isAbstract='true',  hasTypeId='false',  final='0',  block='0',  derivedBy='RESTRICTION'.  */
struct dinEVPowerDeliveryParameterType {
	int noContent; /* avoid warning */
};

/* Complex type name='http://www.w3.org/2000/09/xmldsig#,X509IssuerSerialType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("http://www.w3.org/2000/09/xmldsig#":X509IssuerName,"http://www.w3.org/2000/09/xmldsig#":X509SerialNumber)',  derivedBy='RESTRICTION'.  */
#define dinX509IssuerSerialType_X509IssuerName_CHARACTERS_SIZE 50 + EXTRA_CHAR 
struct dinX509IssuerSerialType {
	/* element: "http://www.w3.org/2000/09/xmldsig#":X509IssuerName, http://www.w3.org/2001/XMLSchema,string */
	struct {
		exi_string_character_t characters[dinX509IssuerSerialType_X509IssuerName_CHARACTERS_SIZE];
		uint16_t charactersLen;
	}  X509IssuerName ;
	/* element: "http://www.w3.org/2000/09/xmldsig#":X509SerialNumber, http://www.w3.org/2001/XMLSchema,integer */
	int64_t X509SerialNumber ;
};

/* Complex type name='urn:iso:15118:2:2010:MsgDataTypes,SelectedServiceType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2010:MsgDataTypes":ServiceID,"urn:iso:15118:2:2010:MsgDataTypes":ParameterSetID{0-1})',  derivedBy='RESTRICTION'.  */
struct dinSelectedServiceType {
	/* element: "urn:iso:15118:2:2010:MsgDataTypes":ServiceID, urn:iso:15118:2:2010:MsgDataTypes,serviceIDType */
	uint16_t ServiceID ;
	/* element: "urn:iso:15118:2:2010:MsgDataTypes":ParameterSetID, http://www.w3.org/2001/XMLSchema,short */
	int16_t ParameterSetID ;
	unsigned int ParameterSetID_isUsed:1;
};

/* Complex type name='urn:iso:15118:2:2010:MsgDataTypes,DC_EVStatusType',  base type name='EVStatusType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2010:MsgDataTypes":EVReady,"urn:iso:15118:2:2010:MsgDataTypes":EVCabinConditioning{0-1},"urn:iso:15118:2:2010:MsgDataTypes":EVRESSConditioning{0-1},"urn:iso:15118:2:2010:MsgDataTypes":EVErrorCode,"urn:iso:15118:2:2010:MsgDataTypes":EVRESSSOC)',  derivedBy='EXTENSION'.  */
struct dinDC_EVStatusType {
	/* element: "urn:iso:15118:2:2010:MsgDataTypes":EVReady, http://www.w3.org/2001/XMLSchema,boolean */
	int EVReady ;
	/* element: "urn:iso:15118:2:2010:MsgDataTypes":EVCabinConditioning, http://www.w3.org/2001/XMLSchema,boolean */
	int EVCabinConditioning ;
	unsigned int EVCabinConditioning_isUsed:1;
	/* element: "urn:iso:15118:2:2010:MsgDataTypes":EVRESSConditioning, http://www.w3.org/2001/XMLSchema,boolean */
	int EVRESSConditioning ;
	unsigned int EVRESSConditioning_isUsed:1;
	/* element: "urn:iso:15118:2:2010:MsgDataTypes":EVErrorCode, urn:iso:15118:2:2010:MsgDataTypes,DC_EVErrorCodeType */
	dinDC_EVErrorCodeType EVErrorCode ;
	/* element: "urn:iso:15118:2:2010:MsgDataTypes":EVRESSSOC, urn:iso:15118:2:2010:MsgDataTypes,percentValueType */
	int8_t EVRESSSOC ;
};

/* Complex type name='urn:iso:15118:2:2010:MsgDataTypes,PhysicalValueType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2010:MsgDataTypes":Multiplier,"urn:iso:15118:2:2010:MsgDataTypes":Unit{0-1},"urn:iso:15118:2:2010:MsgDataTypes":Value)',  derivedBy='RESTRICTION'.  */
struct dinPhysicalValueType {
	/* element: "urn:iso:15118:2:2010:MsgDataTypes":Multiplier, urn:iso:15118:2:2010:MsgDataTypes,unitMultiplierType */
	int8_t Multiplier ;
	/* element: "urn:iso:15118:2:2010:MsgDataTypes":Unit, urn:iso:15118:2:2010:MsgDataTypes,unitSymbolType */
	dinunitSymbolType Unit ;
	unsigned int Unit_isUsed:1;
	/* element: "urn:iso:15118:2:2010:MsgDataTypes":Value, http://www.w3.org/2001/XMLSchema,short */
	int16_t Value ;
};

/* Complex type name='http://www.w3.org/2000/09/xmldsig#,ManifestType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("http://www.w3.org/2000/09/xmldsig#":Reference{1-UNBOUNDED})',  derivedBy='RESTRICTION'.  */
#define dinManifestType_Id_CHARACTERS_SIZE 50 + EXTRA_CHAR 
#define dinManifestType_Reference_ARRAY_SIZE 1
struct dinManifestType {
	/* attribute: Id {http://www.w3.org/2001/XMLSchema,ID} */
	struct {
		exi_string_character_t characters[dinManifestType_Id_CHARACTERS_SIZE];
		uint16_t charactersLen;
	}  Id ;
	unsigned int Id_isUsed:1;
	/* element: "http://www.w3.org/2000/09/xmldsig#":Reference, Complex type name='http://www.w3.org/2000/09/xmldsig#,ReferenceType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("http://www.w3.org/2000/09/xmldsig#":Transforms{0-1},"http://www.w3.org/2000/09/xmldsig#":DigestMethod,"http://www.w3.org/2000/09/xmldsig#":DigestValue)',  derivedBy='RESTRICTION'.  */
	struct {
		struct dinReferenceType array[dinManifestType_Reference_ARRAY_SIZE];
		uint16_t arrayLen;
	} Reference;
};

typedef enum {
	dincostKindType_relativePricePercentage = 0,
	dincostKindType_RenewableGenerationPercentage = 1,
	dincostKindType_CarbonDioxideEmission = 2
} dincostKindType;

/* Complex type name='urn:iso:15118:2:2010:MsgDataTypes,PMaxScheduleEntryType',  base type name='EntryType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='(("urn:iso:15118:2:2010:MsgDataTypes":TimeInterval),("urn:iso:15118:2:2010:MsgDataTypes":PMax))',  derivedBy='EXTENSION'.  */
struct dinPMaxScheduleEntryType {
	/* element: "urn:iso:15118:2:2010:MsgDataTypes":TimeInterval, Complex type name='urn:iso:15118:2:2010:MsgDataTypes,IntervalType',  base type name='anyType',  content type='EMPTY',  isAbstract='true',  hasTypeId='false',  final='0',  block='0',  derivedBy='RESTRICTION'.  */
	struct dinIntervalType TimeInterval ;
	unsigned int TimeInterval_isUsed:1;
	/* element: "urn:iso:15118:2:2010:MsgDataTypes":RelativeTimeInterval, Complex type name='urn:iso:15118:2:2010:MsgDataTypes,RelativeTimeIntervalType',  base type name='IntervalType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2010:MsgDataTypes":start,"urn:iso:15118:2:2010:MsgDataTypes":duration{0-1})',  derivedBy='EXTENSION'.  */
	struct dinRelativeTimeIntervalType RelativeTimeInterval ;
	unsigned int RelativeTimeInterval_isUsed:1;
	/* element: "urn:iso:15118:2:2010:MsgDataTypes":PMax, urn:iso:15118:2:2010:MsgDataTypes,PMaxType */
	int16_t PMax ;
};

typedef enum {
	dinisolationLevelType_Invalid = 0,
	dinisolationLevelType_Valid = 1,
	dinisolationLevelType_Warning = 2,
	dinisolationLevelType_Fault = 3
} dinisolationLevelType;

/* Complex type name='http://www.w3.org/2000/09/xmldsig#,SignatureValueType',  base type name='base64Binary',  content type='SIMPLE',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  derivedBy='EXTENSION'.  */
#define dinSignatureValueType_Id_CHARACTERS_SIZE 50 + EXTRA_CHAR 
#define dinSignatureValueType_CONTENT_BYTES_SIZE 350
struct dinSignatureValueType {
	/* attribute: Id {http://www.w3.org/2001/XMLSchema,ID} */
	struct {
		exi_string_character_t characters[dinSignatureValueType_Id_CHARACTERS_SIZE];
		uint16_t charactersLen;
	}  Id ;
	unsigned int Id_isUsed:1;
	/* simple content: http://www.w3.org/2001/XMLSchema,base64Binary */
	struct {
		uint8_t bytes[dinSignatureValueType_CONTENT_BYTES_SIZE];
		uint16_t bytesLen;
	}  CONTENT ;
};

/* Complex type name='urn:iso:15118:2:2010:MsgDataTypes,PaymentOptionsType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2010:MsgDataTypes":PaymentOption{1-UNBOUNDED})',  derivedBy='RESTRICTION'.  */
#define dinPaymentOptionsType_PaymentOption_ARRAY_SIZE 5
struct dinPaymentOptionsType {
	/* element: "urn:iso:15118:2:2010:MsgDataTypes":PaymentOption, urn:iso:15118:2:2010:MsgDataTypes,paymentOptionType */
	struct {
		dinpaymentOptionType array[dinPaymentOptionsType_PaymentOption_ARRAY_SIZE];
		uint16_t arrayLen;
	} PaymentOption;
};

/* Complex type name='urn:iso:15118:2:2010:MsgDataTypes,ServiceTagType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2010:MsgDataTypes":ServiceID,"urn:iso:15118:2:2010:MsgDataTypes":ServiceName{0-1},"urn:iso:15118:2:2010:MsgDataTypes":ServiceCategory,"urn:iso:15118:2:2010:MsgDataTypes":ServiceScope{0-1})',  derivedBy='RESTRICTION'.  */
#define dinServiceTagType_ServiceName_CHARACTERS_SIZE 32 + EXTRA_CHAR /* XML schema facet maxLength for urn:iso:15118:2:2010:MsgDataTypes,serviceNameType is 32 */
#define dinServiceTagType_ServiceScope_CHARACTERS_SIZE 32 + EXTRA_CHAR /* XML schema facet maxLength for urn:iso:15118:2:2010:MsgDataTypes,serviceScopeType is 32 */
struct dinServiceTagType {
	/* element: "urn:iso:15118:2:2010:MsgDataTypes":ServiceID, urn:iso:15118:2:2010:MsgDataTypes,serviceIDType */
	uint16_t ServiceID ;
	/* element: "urn:iso:15118:2:2010:MsgDataTypes":ServiceName, urn:iso:15118:2:2010:MsgDataTypes,serviceNameType */
	struct {
		exi_string_character_t characters[dinServiceTagType_ServiceName_CHARACTERS_SIZE];
		uint16_t charactersLen;
	}  ServiceName ;
	unsigned int ServiceName_isUsed:1;
	/* element: "urn:iso:15118:2:2010:MsgDataTypes":ServiceCategory, urn:iso:15118:2:2010:MsgDataTypes,serviceCategoryType */
	dinserviceCategoryType ServiceCategory ;
	/* element: "urn:iso:15118:2:2010:MsgDataTypes":ServiceScope, urn:iso:15118:2:2010:MsgDataTypes,serviceScopeType */
	struct {
		exi_string_character_t characters[dinServiceTagType_ServiceScope_CHARACTERS_SIZE];
		uint16_t charactersLen;
	}  ServiceScope ;
	unsigned int ServiceScope_isUsed:1;
};

/* Complex type name='urn:iso:15118:2:2010:MsgDataTypes,AC_EVSEStatusType',  base type name='EVSEStatusType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2010:MsgDataTypes":PowerSwitchClosed,"urn:iso:15118:2:2010:MsgDataTypes":RCD,"urn:iso:15118:2:2010:MsgDataTypes":NotificationMaxDelay,"urn:iso:15118:2:2010:MsgDataTypes":EVSENotification)',  derivedBy='EXTENSION'.  */
struct dinAC_EVSEStatusType {
	/* element: "urn:iso:15118:2:2010:MsgDataTypes":PowerSwitchClosed, http://www.w3.org/2001/XMLSchema,boolean */
	int PowerSwitchClosed ;
	/* element: "urn:iso:15118:2:2010:MsgDataTypes":RCD, http://www.w3.org/2001/XMLSchema,boolean */
	int RCD ;
	/* element: "urn:iso:15118:2:2010:MsgDataTypes":NotificationMaxDelay, http://www.w3.org/2001/XMLSchema,unsignedInt */
	uint32_t NotificationMaxDelay ;
	/* element: "urn:iso:15118:2:2010:MsgDataTypes":EVSENotification, urn:iso:15118:2:2010:MsgDataTypes,EVSENotificationType */
	dinEVSENotificationType EVSENotification ;
};

/* Complex type name='urn:iso:15118:2:2010:MsgDataTypes,ChargingProfileType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2010:MsgDataTypes":SAScheduleTupleID,"urn:iso:15118:2:2010:MsgDataTypes":ProfileEntry{1-UNBOUNDED})',  derivedBy='RESTRICTION'.  */
#define dinChargingProfileType_ProfileEntry_ARRAY_SIZE 24
struct dinChargingProfileType {
	/* element: "urn:iso:15118:2:2010:MsgDataTypes":SAScheduleTupleID, urn:iso:15118:2:2010:MsgDataTypes,SAIDType */
	int16_t SAScheduleTupleID ;
	/* element: "urn:iso:15118:2:2010:MsgDataTypes":ProfileEntry, Complex type name='urn:iso:15118:2:2010:MsgDataTypes,ProfileEntryType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2010:MsgDataTypes":ChargingProfileEntryStart,"urn:iso:15118:2:2010:MsgDataTypes":ChargingProfileEntryMaxPower)',  derivedBy='RESTRICTION'.  */
	struct {
		struct dinProfileEntryType array[dinChargingProfileType_ProfileEntry_ARRAY_SIZE];
		uint16_t arrayLen;
	} ProfileEntry;
};

/* Complex type name='urn:iso:15118:2:2010:MsgBody,ServiceDiscoveryReqType',  base type name='BodyBaseType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2010:MsgBody":ServiceScope{0-1},"urn:iso:15118:2:2010:MsgBody":ServiceCategory{0-1})',  derivedBy='EXTENSION'.  */
#define dinServiceDiscoveryReqType_ServiceScope_CHARACTERS_SIZE 32 + EXTRA_CHAR /* XML schema facet maxLength for urn:iso:15118:2:2010:MsgDataTypes,serviceScopeType is 32 */
struct dinServiceDiscoveryReqType {
	/* element: "urn:iso:15118:2:2010:MsgBody":ServiceScope, urn:iso:15118:2:2010:MsgDataTypes,serviceScopeType */
	struct {
		exi_string_character_t characters[dinServiceDiscoveryReqType_ServiceScope_CHARACTERS_SIZE];
		uint16_t charactersLen;
	}  ServiceScope ;
	unsigned int ServiceScope_isUsed:1;
	/* element: "urn:iso:15118:2:2010:MsgBody":ServiceCategory, urn:iso:15118:2:2010:MsgDataTypes,serviceCategoryType */
	dinserviceCategoryType ServiceCategory ;
	unsigned int ServiceCategory_isUsed:1;
};

typedef enum {
	dinresponseCodeType_OK = 0,
	dinresponseCodeType_OK_NewSessionEstablished = 1,
	dinresponseCodeType_OK_OldSessionJoined = 2,
	dinresponseCodeType_OK_CertificateExpiresSoon = 3,
	dinresponseCodeType_FAILED = 4,
	dinresponseCodeType_FAILED_SequenceError = 5,
	dinresponseCodeType_FAILED_ServiceIDInvalid = 6,
	dinresponseCodeType_FAILED_UnknownSession = 7,
	dinresponseCodeType_FAILED_ServiceSelectionInvalid = 8,
	dinresponseCodeType_FAILED_PaymentSelectionInvalid = 9,
	dinresponseCodeType_FAILED_CertificateExpired = 10,
	dinresponseCodeType_FAILED_SignatureError = 11,
	dinresponseCodeType_FAILED_NoCertificateAvailable = 12,
	dinresponseCodeType_FAILED_CertChainError = 13,
	dinresponseCodeType_FAILED_ChallengeInvalid = 14,
	dinresponseCodeType_FAILED_ContractCanceled = 15,
	dinresponseCodeType_FAILED_WrongChargeParameter = 16,
	dinresponseCodeType_FAILED_PowerDeliveryNotApplied = 17,
	dinresponseCodeType_FAILED_TariffSelectionInvalid = 18,
	dinresponseCodeType_FAILED_ChargingProfileInvalid = 19,
	dinresponseCodeType_FAILED_EVSEPresentVoltageToLow = 20,
	dinresponseCodeType_FAILED_MeteringSignatureNotValid = 21,
	dinresponseCodeType_FAILED_WrongEnergyTransferType = 22
} dinresponseCodeType;

/* Complex type name='urn:iso:15118:2:2010:MsgDataTypes,AC_EVSEChargeParameterType',  base type name='EVSEChargeParameterType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2010:MsgDataTypes":AC_EVSEStatus,"urn:iso:15118:2:2010:MsgDataTypes":EVSEMaxVoltage,"urn:iso:15118:2:2010:MsgDataTypes":EVSEMaxCurrent,"urn:iso:15118:2:2010:MsgDataTypes":EVSEMinCurrent)',  derivedBy='EXTENSION'.  */
struct dinAC_EVSEChargeParameterType {
	/* element: "urn:iso:15118:2:2010:MsgDataTypes":AC_EVSEStatus, Complex type name='urn:iso:15118:2:2010:MsgDataTypes,AC_EVSEStatusType',  base type name='EVSEStatusType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2010:MsgDataTypes":PowerSwitchClosed,"urn:iso:15118:2:2010:MsgDataTypes":RCD,"urn:iso:15118:2:2010:MsgDataTypes":NotificationMaxDelay,"urn:iso:15118:2:2010:MsgDataTypes":EVSENotification)',  derivedBy='EXTENSION'.  */
	struct dinAC_EVSEStatusType AC_EVSEStatus ;
	/* element: "urn:iso:15118:2:2010:MsgDataTypes":EVSEMaxVoltage, Complex type name='urn:iso:15118:2:2010:MsgDataTypes,PhysicalValueType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2010:MsgDataTypes":Multiplier,"urn:iso:15118:2:2010:MsgDataTypes":Unit{0-1},"urn:iso:15118:2:2010:MsgDataTypes":Value)',  derivedBy='RESTRICTION'.  */
	struct dinPhysicalValueType EVSEMaxVoltage ;
	/* element: "urn:iso:15118:2:2010:MsgDataTypes":EVSEMaxCurrent, Complex type name='urn:iso:15118:2:2010:MsgDataTypes,PhysicalValueType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2010:MsgDataTypes":Multiplier,"urn:iso:15118:2:2010:MsgDataTypes":Unit{0-1},"urn:iso:15118:2:2010:MsgDataTypes":Value)',  derivedBy='RESTRICTION'.  */
	struct dinPhysicalValueType EVSEMaxCurrent ;
	/* element: "urn:iso:15118:2:2010:MsgDataTypes":EVSEMinCurrent, Complex type name='urn:iso:15118:2:2010:MsgDataTypes,PhysicalValueType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2010:MsgDataTypes":Multiplier,"urn:iso:15118:2:2010:MsgDataTypes":Unit{0-1},"urn:iso:15118:2:2010:MsgDataTypes":Value)',  derivedBy='RESTRICTION'.  */
	struct dinPhysicalValueType EVSEMinCurrent ;
};

/* Complex type name='http://www.w3.org/2000/09/xmldsig#,ObjectType',  base type name='anyType',  content type='MIXED',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='((WC[##any])){0-UNBOUNDED}',  derivedBy='RESTRICTION'.  */
#define dinObjectType_Id_CHARACTERS_SIZE 50 + EXTRA_CHAR 
#define dinObjectType_MimeType_CHARACTERS_SIZE 50 + EXTRA_CHAR 
#define dinObjectType_Encoding_CHARACTERS_SIZE 50 + EXTRA_CHAR 
#define dinObjectType_ANY_CHARACTERS_SIZE 50 + EXTRA_CHAR 
struct dinObjectType {
	/* attribute: Id {http://www.w3.org/2001/XMLSchema,ID} */
	struct {
		exi_string_character_t characters[dinObjectType_Id_CHARACTERS_SIZE];
		uint16_t charactersLen;
	}  Id ;
	unsigned int Id_isUsed:1;
	/* attribute: MimeType {http://www.w3.org/2001/XMLSchema,string} */
	struct {
		exi_string_character_t characters[dinObjectType_MimeType_CHARACTERS_SIZE];
		uint16_t charactersLen;
	}  MimeType ;
	unsigned int MimeType_isUsed:1;
	/* attribute: Encoding {http://www.w3.org/2001/XMLSchema,anyURI} */
	struct {
		exi_string_character_t characters[dinObjectType_Encoding_CHARACTERS_SIZE];
		uint16_t charactersLen;
	}  Encoding ;
	unsigned int Encoding_isUsed:1;
	/* element: WC[##any] */
	struct {
		exi_string_character_t characters[dinObjectType_ANY_CHARACTERS_SIZE];
		uint16_t charactersLen;
	}  ANY ;
	unsigned int ANY_isUsed:1;
};

/* Complex type name='urn:iso:15118:2:2010:MsgBody,SessionStopResType',  base type name='BodyBaseType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2010:MsgBody":ResponseCode)',  derivedBy='EXTENSION'.  */
struct dinSessionStopResType {
	/* element: "urn:iso:15118:2:2010:MsgBody":ResponseCode, urn:iso:15118:2:2010:MsgDataTypes,responseCodeType */
	dinresponseCodeType ResponseCode ;
};

/* Complex type name='http://www.w3.org/2000/09/xmldsig#,SignedInfoType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("http://www.w3.org/2000/09/xmldsig#":CanonicalizationMethod,"http://www.w3.org/2000/09/xmldsig#":SignatureMethod,"http://www.w3.org/2000/09/xmldsig#":Reference{1-UNBOUNDED})',  derivedBy='RESTRICTION'.  */
#define dinSignedInfoType_Id_CHARACTERS_SIZE 50 + EXTRA_CHAR 
#define dinSignedInfoType_Reference_ARRAY_SIZE 1
struct dinSignedInfoType {
	/* attribute: Id {http://www.w3.org/2001/XMLSchema,ID} */
	struct {
		exi_string_character_t characters[dinSignedInfoType_Id_CHARACTERS_SIZE];
		uint16_t charactersLen;
	}  Id ;
	unsigned int Id_isUsed:1;
	/* element: "http://www.w3.org/2000/09/xmldsig#":CanonicalizationMethod, Complex type name='http://www.w3.org/2000/09/xmldsig#,CanonicalizationMethodType',  base type name='anyType',  content type='MIXED',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='((WC[##any]){0-UNBOUNDED})',  derivedBy='RESTRICTION'.  */
	struct dinCanonicalizationMethodType CanonicalizationMethod ;
	/* element: "http://www.w3.org/2000/09/xmldsig#":SignatureMethod, Complex type name='http://www.w3.org/2000/09/xmldsig#,SignatureMethodType',  base type name='anyType',  content type='MIXED',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("http://www.w3.org/2000/09/xmldsig#":HMACOutputLength{0-1},(WC[##other:"http://www.w3.org/2000/09/xmldsig#"]){0-UNBOUNDED})',  derivedBy='RESTRICTION'.  */
	struct dinSignatureMethodType SignatureMethod ;
	/* element: "http://www.w3.org/2000/09/xmldsig#":Reference, Complex type name='http://www.w3.org/2000/09/xmldsig#,ReferenceType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("http://www.w3.org/2000/09/xmldsig#":Transforms{0-1},"http://www.w3.org/2000/09/xmldsig#":DigestMethod,"http://www.w3.org/2000/09/xmldsig#":DigestValue)',  derivedBy='RESTRICTION'.  */
	struct {
		struct dinReferenceType array[dinSignedInfoType_Reference_ARRAY_SIZE];
		uint16_t arrayLen;
	} Reference;
};

/* Complex type name='urn:iso:15118:2:2010:MsgDataTypes,CostType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2010:MsgDataTypes":costKind,"urn:iso:15118:2:2010:MsgDataTypes":amount,"urn:iso:15118:2:2010:MsgDataTypes":amountMultiplier{0-1})',  derivedBy='RESTRICTION'.  */
struct dinCostType {
	/* element: "urn:iso:15118:2:2010:MsgDataTypes":costKind, urn:iso:15118:2:2010:MsgDataTypes,costKindType */
	dincostKindType costKind ;
	/* element: "urn:iso:15118:2:2010:MsgDataTypes":amount, http://www.w3.org/2001/XMLSchema,unsignedInt */
	uint32_t amount ;
	/* element: "urn:iso:15118:2:2010:MsgDataTypes":amountMultiplier, urn:iso:15118:2:2010:MsgDataTypes,unitMultiplierType */
	int8_t amountMultiplier ;
	unsigned int amountMultiplier_isUsed:1;
};

/* Complex type name='urn:iso:15118:2:2010:MsgDataTypes,ServiceChargeType',  base type name='ServiceType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='(("urn:iso:15118:2:2010:MsgDataTypes":ServiceTag,"urn:iso:15118:2:2010:MsgDataTypes":FreeService),("urn:iso:15118:2:2010:MsgDataTypes":EnergyTransferType))',  derivedBy='EXTENSION'.  */
struct dinServiceChargeType {
	/* element: "urn:iso:15118:2:2010:MsgDataTypes":ServiceTag, Complex type name='urn:iso:15118:2:2010:MsgDataTypes,ServiceTagType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2010:MsgDataTypes":ServiceID,"urn:iso:15118:2:2010:MsgDataTypes":ServiceName{0-1},"urn:iso:15118:2:2010:MsgDataTypes":ServiceCategory,"urn:iso:15118:2:2010:MsgDataTypes":ServiceScope{0-1})',  derivedBy='RESTRICTION'.  */
	struct dinServiceTagType ServiceTag ;
	/* element: "urn:iso:15118:2:2010:MsgDataTypes":FreeService, http://www.w3.org/2001/XMLSchema,boolean */
	int FreeService ;
	/* element: "urn:iso:15118:2:2010:MsgDataTypes":EnergyTransferType, urn:iso:15118:2:2010:MsgDataTypes,EVSESupportedEnergyTransferType */
	dinEVSESupportedEnergyTransferType EnergyTransferType ;
};

/* Complex type name='urn:iso:15118:2:2010:MsgDataTypes,DC_EVSEStatusType',  base type name='EVSEStatusType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2010:MsgDataTypes":EVSEIsolationStatus{0-1},"urn:iso:15118:2:2010:MsgDataTypes":EVSEStatusCode,"urn:iso:15118:2:2010:MsgDataTypes":NotificationMaxDelay,"urn:iso:15118:2:2010:MsgDataTypes":EVSENotification)',  derivedBy='EXTENSION'.  */
struct dinDC_EVSEStatusType {
	/* element: "urn:iso:15118:2:2010:MsgDataTypes":EVSEIsolationStatus, urn:iso:15118:2:2010:MsgDataTypes,isolationLevelType */
	dinisolationLevelType EVSEIsolationStatus ;
	unsigned int EVSEIsolationStatus_isUsed:1;
	/* element: "urn:iso:15118:2:2010:MsgDataTypes":EVSEStatusCode, urn:iso:15118:2:2010:MsgDataTypes,DC_EVSEStatusCodeType */
	dinDC_EVSEStatusCodeType EVSEStatusCode ;
	/* element: "urn:iso:15118:2:2010:MsgDataTypes":NotificationMaxDelay, http://www.w3.org/2001/XMLSchema,unsignedInt */
	uint32_t NotificationMaxDelay ;
	/* element: "urn:iso:15118:2:2010:MsgDataTypes":EVSENotification, urn:iso:15118:2:2010:MsgDataTypes,EVSENotificationType */
	dinEVSENotificationType EVSENotification ;
};

/* Complex type name='http://www.w3.org/2000/09/xmldsig#,RetrievalMethodType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("http://www.w3.org/2000/09/xmldsig#":Transforms{0-1})',  derivedBy='RESTRICTION'.  */
#define dinRetrievalMethodType_URI_CHARACTERS_SIZE 50 + EXTRA_CHAR 
#define dinRetrievalMethodType_Type_CHARACTERS_SIZE 50 + EXTRA_CHAR 
struct dinRetrievalMethodType {
	/* attribute: URI {http://www.w3.org/2001/XMLSchema,anyURI} */
	struct {
		exi_string_character_t characters[dinRetrievalMethodType_URI_CHARACTERS_SIZE];
		uint16_t charactersLen;
	}  URI ;
	unsigned int URI_isUsed:1;
	/* attribute: Type {http://www.w3.org/2001/XMLSchema,anyURI} */
	struct {
		exi_string_character_t characters[dinRetrievalMethodType_Type_CHARACTERS_SIZE];
		uint16_t charactersLen;
	}  Type ;
	unsigned int Type_isUsed:1;
	/* element: "http://www.w3.org/2000/09/xmldsig#":Transforms, Complex type name='http://www.w3.org/2000/09/xmldsig#,TransformsType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("http://www.w3.org/2000/09/xmldsig#":Transform{1-UNBOUNDED})',  derivedBy='RESTRICTION'.  */
	struct dinTransformsType Transforms ;
	unsigned int Transforms_isUsed:1;
};

/* Complex type name='urn:iso:15118:2:2010:MsgDataTypes,NotificationType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2010:MsgDataTypes":FaultCode,"urn:iso:15118:2:2010:MsgDataTypes":FaultMsg{0-1})',  derivedBy='RESTRICTION'.  */
#define dinNotificationType_FaultMsg_CHARACTERS_SIZE 64 + EXTRA_CHAR /* XML schema facet maxLength for urn:iso:15118:2:2010:MsgDataTypes,faultMsgType is 64 */
struct dinNotificationType {
	/* element: "urn:iso:15118:2:2010:MsgDataTypes":FaultCode, urn:iso:15118:2:2010:MsgDataTypes,faultCodeType */
	dinfaultCodeType FaultCode ;
	/* element: "urn:iso:15118:2:2010:MsgDataTypes":FaultMsg, urn:iso:15118:2:2010:MsgDataTypes,faultMsgType */
	struct {
		exi_string_character_t characters[dinNotificationType_FaultMsg_CHARACTERS_SIZE];
		uint16_t charactersLen;
	}  FaultMsg ;
	unsigned int FaultMsg_isUsed:1;
};

/* Complex type name='http://www.w3.org/2000/09/xmldsig#,PGPDataType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='(("http://www.w3.org/2000/09/xmldsig#":PGPKeyID,"http://www.w3.org/2000/09/xmldsig#":PGPKeyPacket{0-1},(WC[##other:"http://www.w3.org/2000/09/xmldsig#"]){0-UNBOUNDED})|("http://www.w3.org/2000/09/xmldsig#":PGPKeyPacket,(WC[##other:"http://www.w3.org/2000/09/xmldsig#"]){0-UNBOUNDED}))',  derivedBy='RESTRICTION'.  */
#define dinPGPDataType_PGPKeyID_BYTES_SIZE 350 
#define dinPGPDataType_PGPKeyPacket_BYTES_SIZE 350 
#define dinPGPDataType_ANY_CHARACTERS_SIZE 50 + EXTRA_CHAR 
struct dinPGPDataType {
	/* element: "http://www.w3.org/2000/09/xmldsig#":PGPKeyID, http://www.w3.org/2001/XMLSchema,base64Binary */
	struct {
		uint8_t bytes[dinPGPDataType_PGPKeyID_BYTES_SIZE];
		uint16_t bytesLen;
	}  PGPKeyID ;
	unsigned int PGPKeyID_isUsed:1;
	/* element: "http://www.w3.org/2000/09/xmldsig#":PGPKeyPacket, http://www.w3.org/2001/XMLSchema,base64Binary */
	struct {
		uint8_t bytes[dinPGPDataType_PGPKeyPacket_BYTES_SIZE];
		uint16_t bytesLen;
	}  PGPKeyPacket ;
	unsigned int PGPKeyPacket_isUsed:1;
	/* element: WC[##other:"http://www.w3.org/2000/09/xmldsig#"] */
	struct {
		exi_string_character_t characters[dinPGPDataType_ANY_CHARACTERS_SIZE];
		uint16_t charactersLen;
	}  ANY ;
	unsigned int ANY_isUsed:1;
};

/* Complex type name='http://www.w3.org/2000/09/xmldsig#,SignaturePropertyType',  base type name='anyType',  content type='MIXED',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='((WC[##other:"http://www.w3.org/2000/09/xmldsig#"])){1-UNBOUNDED}',  derivedBy='RESTRICTION'.  */
#define dinSignaturePropertyType_Target_CHARACTERS_SIZE 50 + EXTRA_CHAR 
#define dinSignaturePropertyType_Id_CHARACTERS_SIZE 50 + EXTRA_CHAR 
#define dinSignaturePropertyType_ANY_CHARACTERS_SIZE 50 + EXTRA_CHAR 
struct dinSignaturePropertyType {
	/* attribute: Target {http://www.w3.org/2001/XMLSchema,anyURI} */
	struct {
		exi_string_character_t characters[dinSignaturePropertyType_Target_CHARACTERS_SIZE];
		uint16_t charactersLen;
	}  Target ;
	/* attribute: Id {http://www.w3.org/2001/XMLSchema,ID} */
	struct {
		exi_string_character_t characters[dinSignaturePropertyType_Id_CHARACTERS_SIZE];
		uint16_t charactersLen;
	}  Id ;
	unsigned int Id_isUsed:1;
	/* element: WC[##other:"http://www.w3.org/2000/09/xmldsig#"] */
	struct {
		exi_string_character_t characters[dinSignaturePropertyType_ANY_CHARACTERS_SIZE];
		uint16_t charactersLen;
	}  ANY ;
	unsigned int ANY_isUsed:1;
};

/* Complex type name='urn:iso:15118:2:2010:MsgDataTypes,MeterInfoType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2010:MsgDataTypes":MeterID,"urn:iso:15118:2:2010:MsgDataTypes":MeterReading{0-1},"urn:iso:15118:2:2010:MsgDataTypes":SigMeterReading{0-1},"urn:iso:15118:2:2010:MsgDataTypes":MeterStatus{0-1},"urn:iso:15118:2:2010:MsgDataTypes":TMeter{0-1})',  derivedBy='RESTRICTION'.  */
#define dinMeterInfoType_MeterID_CHARACTERS_SIZE 32 + EXTRA_CHAR /* XML schema facet maxLength for urn:iso:15118:2:2010:MsgDataTypes,meterIDType is 32 */
#define dinMeterInfoType_SigMeterReading_BYTES_SIZE 32 /* XML schema facet maxLength for urn:iso:15118:2:2010:MsgDataTypes,sigMeterReadingType is 32 */
struct dinMeterInfoType {
	/* element: "urn:iso:15118:2:2010:MsgDataTypes":MeterID, urn:iso:15118:2:2010:MsgDataTypes,meterIDType */
	struct {
		exi_string_character_t characters[dinMeterInfoType_MeterID_CHARACTERS_SIZE];
		uint16_t charactersLen;
	}  MeterID ;
	/* element: "urn:iso:15118:2:2010:MsgDataTypes":MeterReading, Complex type name='urn:iso:15118:2:2010:MsgDataTypes,PhysicalValueType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2010:MsgDataTypes":Multiplier,"urn:iso:15118:2:2010:MsgDataTypes":Unit{0-1},"urn:iso:15118:2:2010:MsgDataTypes":Value)',  derivedBy='RESTRICTION'.  */
	struct dinPhysicalValueType MeterReading ;
	unsigned int MeterReading_isUsed:1;
	/* element: "urn:iso:15118:2:2010:MsgDataTypes":SigMeterReading, urn:iso:15118:2:2010:MsgDataTypes,sigMeterReadingType */
	struct {
		uint8_t bytes[dinMeterInfoType_SigMeterReading_BYTES_SIZE];
		uint16_t bytesLen;
	}  SigMeterReading ;
	unsigned int SigMeterReading_isUsed:1;
	/* element: "urn:iso:15118:2:2010:MsgDataTypes":MeterStatus, urn:iso:15118:2:2010:MsgDataTypes,meterStatusType */
	int16_t MeterStatus ;
	unsigned int MeterStatus_isUsed:1;
	/* element: "urn:iso:15118:2:2010:MsgDataTypes":TMeter, http://www.w3.org/2001/XMLSchema,long */
	int64_t TMeter ;
	unsigned int TMeter_isUsed:1;
};

/* Complex type name='urn:iso:15118:2:2010:MsgDataTypes,SubCertificatesType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2010:MsgDataTypes":Certificate{1-UNBOUNDED})',  derivedBy='RESTRICTION'.  */
#define dinSubCertificatesType_Certificate_BYTES_SIZE 1200 /* XML schema facet maxLength for urn:iso:15118:2:2010:MsgDataTypes,certificateType is 1200 */
#define dinSubCertificatesType_Certificate_ARRAY_SIZE 5
struct dinSubCertificatesType {
	/* element: "urn:iso:15118:2:2010:MsgDataTypes":Certificate, urn:iso:15118:2:2010:MsgDataTypes,certificateType */
	struct {
		struct {
			uint8_t bytes[dinSubCertificatesType_Certificate_BYTES_SIZE];
			uint16_t bytesLen;
		}  array[dinSubCertificatesType_Certificate_ARRAY_SIZE];
		uint16_t arrayLen;
	} Certificate;
};

/* Complex type name='urn:iso:15118:2:2010:MsgBody,MeteringReceiptReqType',  base type name='BodyBaseType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2010:MsgBody":SessionID,"urn:iso:15118:2:2010:MsgBody":SAScheduleTupleID{0-1},"urn:iso:15118:2:2010:MsgBody":MeterInfo)',  derivedBy='EXTENSION'.  */
#define dinMeteringReceiptReqType_Id_CHARACTERS_SIZE 50 + EXTRA_CHAR 
#define dinMeteringReceiptReqType_SessionID_BYTES_SIZE 8 /* XML schema facet length for urn:iso:15118:2:2010:MsgDataTypes,sessionIDType is 8 */
struct dinMeteringReceiptReqType {
	/* attribute: Id {http://www.w3.org/2001/XMLSchema,IDREF} */
	struct {
		exi_string_character_t characters[dinMeteringReceiptReqType_Id_CHARACTERS_SIZE];
		uint16_t charactersLen;
	}  Id ;
	unsigned int Id_isUsed:1;
	/* element: "urn:iso:15118:2:2010:MsgBody":SessionID, urn:iso:15118:2:2010:MsgDataTypes,sessionIDType */
	struct {
		uint8_t bytes[dinMeteringReceiptReqType_SessionID_BYTES_SIZE];
		uint16_t bytesLen;
	}  SessionID ;
	/* element: "urn:iso:15118:2:2010:MsgBody":SAScheduleTupleID, urn:iso:15118:2:2010:MsgDataTypes,SAIDType */
	int16_t SAScheduleTupleID ;
	unsigned int SAScheduleTupleID_isUsed:1;
	/* element: "urn:iso:15118:2:2010:MsgBody":MeterInfo, Complex type name='urn:iso:15118:2:2010:MsgDataTypes,MeterInfoType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2010:MsgDataTypes":MeterID,"urn:iso:15118:2:2010:MsgDataTypes":MeterReading{0-1},"urn:iso:15118:2:2010:MsgDataTypes":SigMeterReading{0-1},"urn:iso:15118:2:2010:MsgDataTypes":MeterStatus{0-1},"urn:iso:15118:2:2010:MsgDataTypes":TMeter{0-1})',  derivedBy='RESTRICTION'.  */
	struct dinMeterInfoType MeterInfo ;
};

/* Complex type name='urn:iso:15118:2:2010:MsgBody,PowerDeliveryResType',  base type name='BodyBaseType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2010:MsgBody":ResponseCode,"urn:iso:15118:2:2010:MsgDataTypes":EVSEStatus)',  derivedBy='EXTENSION'.  */
struct dinPowerDeliveryResType {
	/* element: "urn:iso:15118:2:2010:MsgBody":ResponseCode, urn:iso:15118:2:2010:MsgDataTypes,responseCodeType */
	dinresponseCodeType ResponseCode ;
	/* element: "urn:iso:15118:2:2010:MsgDataTypes":EVSEStatus, Complex type name='urn:iso:15118:2:2010:MsgDataTypes,EVSEStatusType',  base type name='anyType',  content type='EMPTY',  isAbstract='true',  hasTypeId='false',  final='0',  block='0',  derivedBy='RESTRICTION'.  */
	struct dinEVSEStatusType EVSEStatus ;
	unsigned int EVSEStatus_isUsed:1;
	/* element: "urn:iso:15118:2:2010:MsgDataTypes":AC_EVSEStatus, Complex type name='urn:iso:15118:2:2010:MsgDataTypes,AC_EVSEStatusType',  base type name='EVSEStatusType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2010:MsgDataTypes":PowerSwitchClosed,"urn:iso:15118:2:2010:MsgDataTypes":RCD,"urn:iso:15118:2:2010:MsgDataTypes":NotificationMaxDelay,"urn:iso:15118:2:2010:MsgDataTypes":EVSENotification)',  derivedBy='EXTENSION'.  */
	struct dinAC_EVSEStatusType AC_EVSEStatus ;
	unsigned int AC_EVSEStatus_isUsed:1;
	/* element: "urn:iso:15118:2:2010:MsgDataTypes":DC_EVSEStatus, Complex type name='urn:iso:15118:2:2010:MsgDataTypes,DC_EVSEStatusType',  base type name='EVSEStatusType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2010:MsgDataTypes":EVSEIsolationStatus{0-1},"urn:iso:15118:2:2010:MsgDataTypes":EVSEStatusCode,"urn:iso:15118:2:2010:MsgDataTypes":NotificationMaxDelay,"urn:iso:15118:2:2010:MsgDataTypes":EVSENotification)',  derivedBy='EXTENSION'.  */
	struct dinDC_EVSEStatusType DC_EVSEStatus ;
	unsigned int DC_EVSEStatus_isUsed:1;
};

/* Complex type name='urn:iso:15118:2:2010:MsgBody,WeldingDetectionResType',  base type name='BodyBaseType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2010:MsgBody":ResponseCode,"urn:iso:15118:2:2010:MsgBody":DC_EVSEStatus,"urn:iso:15118:2:2010:MsgBody":EVSEPresentVoltage)',  derivedBy='EXTENSION'.  */
struct dinWeldingDetectionResType {
	/* element: "urn:iso:15118:2:2010:MsgBody":ResponseCode, urn:iso:15118:2:2010:MsgDataTypes,responseCodeType */
	dinresponseCodeType ResponseCode ;
	/* element: "urn:iso:15118:2:2010:MsgBody":DC_EVSEStatus, Complex type name='urn:iso:15118:2:2010:MsgDataTypes,DC_EVSEStatusType',  base type name='EVSEStatusType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2010:MsgDataTypes":EVSEIsolationStatus{0-1},"urn:iso:15118:2:2010:MsgDataTypes":EVSEStatusCode,"urn:iso:15118:2:2010:MsgDataTypes":NotificationMaxDelay,"urn:iso:15118:2:2010:MsgDataTypes":EVSENotification)',  derivedBy='EXTENSION'.  */
	struct dinDC_EVSEStatusType DC_EVSEStatus ;
	/* element: "urn:iso:15118:2:2010:MsgBody":EVSEPresentVoltage, Complex type name='urn:iso:15118:2:2010:MsgDataTypes,PhysicalValueType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2010:MsgDataTypes":Multiplier,"urn:iso:15118:2:2010:MsgDataTypes":Unit{0-1},"urn:iso:15118:2:2010:MsgDataTypes":Value)',  derivedBy='RESTRICTION'.  */
	struct dinPhysicalValueType EVSEPresentVoltage ;
};

/* Complex type name='urn:iso:15118:2:2010:MsgBody,ContractAuthenticationResType',  base type name='BodyBaseType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2010:MsgBody":ResponseCode,"urn:iso:15118:2:2010:MsgBody":EVSEProcessing)',  derivedBy='EXTENSION'.  */
struct dinContractAuthenticationResType {
	/* element: "urn:iso:15118:2:2010:MsgBody":ResponseCode, urn:iso:15118:2:2010:MsgDataTypes,responseCodeType */
	dinresponseCodeType ResponseCode ;
	/* element: "urn:iso:15118:2:2010:MsgBody":EVSEProcessing, urn:iso:15118:2:2010:MsgDataTypes,EVSEProcessingType */
	dinEVSEProcessingType EVSEProcessing ;
};

/* Complex type name='urn:iso:15118:2:2010:MsgDataTypes,SelectedServiceListType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2010:MsgDataTypes":SelectedService{1-UNBOUNDED})',  derivedBy='RESTRICTION'.  */
#define dinSelectedServiceListType_SelectedService_ARRAY_SIZE 16
struct dinSelectedServiceListType {
	/* element: "urn:iso:15118:2:2010:MsgDataTypes":SelectedService, Complex type name='urn:iso:15118:2:2010:MsgDataTypes,SelectedServiceType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2010:MsgDataTypes":ServiceID,"urn:iso:15118:2:2010:MsgDataTypes":ParameterSetID{0-1})',  derivedBy='RESTRICTION'.  */
	struct {
		struct dinSelectedServiceType array[dinSelectedServiceListType_SelectedService_ARRAY_SIZE];
		uint16_t arrayLen;
	} SelectedService;
};

/* Complex type name='urn:iso:15118:2:2010:MsgBody,CurrentDemandResType',  base type name='BodyBaseType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2010:MsgBody":ResponseCode,"urn:iso:15118:2:2010:MsgBody":DC_EVSEStatus,"urn:iso:15118:2:2010:MsgBody":EVSEPresentVoltage,"urn:iso:15118:2:2010:MsgBody":EVSEPresentCurrent,"urn:iso:15118:2:2010:MsgBody":EVSECurrentLimitAchieved,"urn:iso:15118:2:2010:MsgBody":EVSEVoltageLimitAchieved,"urn:iso:15118:2:2010:MsgBody":EVSEPowerLimitAchieved,"urn:iso:15118:2:2010:MsgBody":EVSEMaximumVoltageLimit{0-1},"urn:iso:15118:2:2010:MsgBody":EVSEMaximumCurrentLimit{0-1},"urn:iso:15118:2:2010:MsgBody":EVSEMaximumPowerLimit{0-1})',  derivedBy='EXTENSION'.  */
struct dinCurrentDemandResType {
	/* element: "urn:iso:15118:2:2010:MsgBody":ResponseCode, urn:iso:15118:2:2010:MsgDataTypes,responseCodeType */
	dinresponseCodeType ResponseCode ;
	/* element: "urn:iso:15118:2:2010:MsgBody":DC_EVSEStatus, Complex type name='urn:iso:15118:2:2010:MsgDataTypes,DC_EVSEStatusType',  base type name='EVSEStatusType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2010:MsgDataTypes":EVSEIsolationStatus{0-1},"urn:iso:15118:2:2010:MsgDataTypes":EVSEStatusCode,"urn:iso:15118:2:2010:MsgDataTypes":NotificationMaxDelay,"urn:iso:15118:2:2010:MsgDataTypes":EVSENotification)',  derivedBy='EXTENSION'.  */
	struct dinDC_EVSEStatusType DC_EVSEStatus ;
	/* element: "urn:iso:15118:2:2010:MsgBody":EVSEPresentVoltage, Complex type name='urn:iso:15118:2:2010:MsgDataTypes,PhysicalValueType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2010:MsgDataTypes":Multiplier,"urn:iso:15118:2:2010:MsgDataTypes":Unit{0-1},"urn:iso:15118:2:2010:MsgDataTypes":Value)',  derivedBy='RESTRICTION'.  */
	struct dinPhysicalValueType EVSEPresentVoltage ;
	/* element: "urn:iso:15118:2:2010:MsgBody":EVSEPresentCurrent, Complex type name='urn:iso:15118:2:2010:MsgDataTypes,PhysicalValueType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2010:MsgDataTypes":Multiplier,"urn:iso:15118:2:2010:MsgDataTypes":Unit{0-1},"urn:iso:15118:2:2010:MsgDataTypes":Value)',  derivedBy='RESTRICTION'.  */
	struct dinPhysicalValueType EVSEPresentCurrent ;
	/* element: "urn:iso:15118:2:2010:MsgBody":EVSECurrentLimitAchieved, http://www.w3.org/2001/XMLSchema,boolean */
	int EVSECurrentLimitAchieved ;
	/* element: "urn:iso:15118:2:2010:MsgBody":EVSEVoltageLimitAchieved, http://www.w3.org/2001/XMLSchema,boolean */
	int EVSEVoltageLimitAchieved ;
	/* element: "urn:iso:15118:2:2010:MsgBody":EVSEPowerLimitAchieved, http://www.w3.org/2001/XMLSchema,boolean */
	int EVSEPowerLimitAchieved ;
	/* element: "urn:iso:15118:2:2010:MsgBody":EVSEMaximumVoltageLimit, Complex type name='urn:iso:15118:2:2010:MsgDataTypes,PhysicalValueType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2010:MsgDataTypes":Multiplier,"urn:iso:15118:2:2010:MsgDataTypes":Unit{0-1},"urn:iso:15118:2:2010:MsgDataTypes":Value)',  derivedBy='RESTRICTION'.  */
	struct dinPhysicalValueType EVSEMaximumVoltageLimit ;
	unsigned int EVSEMaximumVoltageLimit_isUsed:1;
	/* element: "urn:iso:15118:2:2010:MsgBody":EVSEMaximumCurrentLimit, Complex type name='urn:iso:15118:2:2010:MsgDataTypes,PhysicalValueType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2010:MsgDataTypes":Multiplier,"urn:iso:15118:2:2010:MsgDataTypes":Unit{0-1},"urn:iso:15118:2:2010:MsgDataTypes":Value)',  derivedBy='RESTRICTION'.  */
	struct dinPhysicalValueType EVSEMaximumCurrentLimit ;
	unsigned int EVSEMaximumCurrentLimit_isUsed:1;
	/* element: "urn:iso:15118:2:2010:MsgBody":EVSEMaximumPowerLimit, Complex type name='urn:iso:15118:2:2010:MsgDataTypes,PhysicalValueType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2010:MsgDataTypes":Multiplier,"urn:iso:15118:2:2010:MsgDataTypes":Unit{0-1},"urn:iso:15118:2:2010:MsgDataTypes":Value)',  derivedBy='RESTRICTION'.  */
	struct dinPhysicalValueType EVSEMaximumPowerLimit ;
	unsigned int EVSEMaximumPowerLimit_isUsed:1;
};

/* Complex type name='urn:iso:15118:2:2010:MsgDataTypes,AC_EVChargeParameterType',  base type name='EVChargeParameterType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2010:MsgDataTypes":DepartureTime,"urn:iso:15118:2:2010:MsgDataTypes":EAmount,"urn:iso:15118:2:2010:MsgDataTypes":EVMaxVoltage,"urn:iso:15118:2:2010:MsgDataTypes":EVMaxCurrent,"urn:iso:15118:2:2010:MsgDataTypes":EVMinCurrent)',  derivedBy='EXTENSION'.  */
struct dinAC_EVChargeParameterType {
	/* element: "urn:iso:15118:2:2010:MsgDataTypes":DepartureTime, http://www.w3.org/2001/XMLSchema,unsignedInt */
	uint32_t DepartureTime ;
	/* element: "urn:iso:15118:2:2010:MsgDataTypes":EAmount, Complex type name='urn:iso:15118:2:2010:MsgDataTypes,PhysicalValueType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2010:MsgDataTypes":Multiplier,"urn:iso:15118:2:2010:MsgDataTypes":Unit{0-1},"urn:iso:15118:2:2010:MsgDataTypes":Value)',  derivedBy='RESTRICTION'.  */
	struct dinPhysicalValueType EAmount ;
	/* element: "urn:iso:15118:2:2010:MsgDataTypes":EVMaxVoltage, Complex type name='urn:iso:15118:2:2010:MsgDataTypes,PhysicalValueType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2010:MsgDataTypes":Multiplier,"urn:iso:15118:2:2010:MsgDataTypes":Unit{0-1},"urn:iso:15118:2:2010:MsgDataTypes":Value)',  derivedBy='RESTRICTION'.  */
	struct dinPhysicalValueType EVMaxVoltage ;
	/* element: "urn:iso:15118:2:2010:MsgDataTypes":EVMaxCurrent, Complex type name='urn:iso:15118:2:2010:MsgDataTypes,PhysicalValueType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2010:MsgDataTypes":Multiplier,"urn:iso:15118:2:2010:MsgDataTypes":Unit{0-1},"urn:iso:15118:2:2010:MsgDataTypes":Value)',  derivedBy='RESTRICTION'.  */
	struct dinPhysicalValueType EVMaxCurrent ;
	/* element: "urn:iso:15118:2:2010:MsgDataTypes":EVMinCurrent, Complex type name='urn:iso:15118:2:2010:MsgDataTypes,PhysicalValueType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2010:MsgDataTypes":Multiplier,"urn:iso:15118:2:2010:MsgDataTypes":Unit{0-1},"urn:iso:15118:2:2010:MsgDataTypes":Value)',  derivedBy='RESTRICTION'.  */
	struct dinPhysicalValueType EVMinCurrent ;
};

/* Complex type name='http://www.w3.org/2000/09/xmldsig#,X509DataType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='(("http://www.w3.org/2000/09/xmldsig#":X509IssuerSerial|"http://www.w3.org/2000/09/xmldsig#":X509SKI|"http://www.w3.org/2000/09/xmldsig#":X509SubjectName|"http://www.w3.org/2000/09/xmldsig#":X509Certificate|"http://www.w3.org/2000/09/xmldsig#":X509CRL|(WC[##other:"http://www.w3.org/2000/09/xmldsig#"]))){1-UNBOUNDED}',  derivedBy='RESTRICTION'.  */
#define dinX509DataType_X509IssuerSerial_ARRAY_SIZE 1
#define dinX509DataType_X509SKI_BYTES_SIZE 350 
#define dinX509DataType_X509SKI_ARRAY_SIZE 1
#define dinX509DataType_X509SubjectName_CHARACTERS_SIZE 50 + EXTRA_CHAR 
#define dinX509DataType_X509SubjectName_ARRAY_SIZE 1
#define dinX509DataType_X509Certificate_BYTES_SIZE 350 
#define dinX509DataType_X509Certificate_ARRAY_SIZE 1
#define dinX509DataType_X509CRL_BYTES_SIZE 350 
#define dinX509DataType_X509CRL_ARRAY_SIZE 1
#define dinX509DataType_ANY_CHARACTERS_SIZE 50 + EXTRA_CHAR 
struct dinX509DataType {
	/* element: "http://www.w3.org/2000/09/xmldsig#":X509IssuerSerial, Complex type name='http://www.w3.org/2000/09/xmldsig#,X509IssuerSerialType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("http://www.w3.org/2000/09/xmldsig#":X509IssuerName,"http://www.w3.org/2000/09/xmldsig#":X509SerialNumber)',  derivedBy='RESTRICTION'.  */
	struct {
		struct dinX509IssuerSerialType array[dinX509DataType_X509IssuerSerial_ARRAY_SIZE];
		uint16_t arrayLen;
	} X509IssuerSerial;
	/* element: "http://www.w3.org/2000/09/xmldsig#":X509SKI, http://www.w3.org/2001/XMLSchema,base64Binary */
	struct {
		struct {
			uint8_t bytes[dinX509DataType_X509SKI_BYTES_SIZE];
			uint16_t bytesLen;
		}  array[dinX509DataType_X509SKI_ARRAY_SIZE];
		uint16_t arrayLen;
	} X509SKI;
	/* element: "http://www.w3.org/2000/09/xmldsig#":X509SubjectName, http://www.w3.org/2001/XMLSchema,string */
	struct {
		struct {
			exi_string_character_t characters[dinX509DataType_X509SubjectName_CHARACTERS_SIZE];
			uint16_t charactersLen;
		}  array[dinX509DataType_X509SubjectName_ARRAY_SIZE];
		uint16_t arrayLen;
	} X509SubjectName;
	/* element: "http://www.w3.org/2000/09/xmldsig#":X509Certificate, http://www.w3.org/2001/XMLSchema,base64Binary */
	struct {
		struct {
			uint8_t bytes[dinX509DataType_X509Certificate_BYTES_SIZE];
			uint16_t bytesLen;
		}  array[dinX509DataType_X509Certificate_ARRAY_SIZE];
		uint16_t arrayLen;
	} X509Certificate;
	/* element: "http://www.w3.org/2000/09/xmldsig#":X509CRL, http://www.w3.org/2001/XMLSchema,base64Binary */
	struct {
		struct {
			uint8_t bytes[dinX509DataType_X509CRL_BYTES_SIZE];
			uint16_t bytesLen;
		}  array[dinX509DataType_X509CRL_ARRAY_SIZE];
		uint16_t arrayLen;
	} X509CRL;
	/* element: WC[##other:"http://www.w3.org/2000/09/xmldsig#"] */
	struct {
		exi_string_character_t characters[dinX509DataType_ANY_CHARACTERS_SIZE];
		uint16_t charactersLen;
	}  ANY ;
	unsigned int ANY_isUsed:1;
};

/* Complex type name='urn:iso:15118:2:2010:MsgBody,ChargingStatusResType',  base type name='BodyBaseType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2010:MsgBody":ResponseCode,"urn:iso:15118:2:2010:MsgBody":EVSEID,"urn:iso:15118:2:2010:MsgBody":SAScheduleTupleID,"urn:iso:15118:2:2010:MsgBody":EVSEMaxCurrent{0-1},"urn:iso:15118:2:2010:MsgBody":MeterInfo{0-1},"urn:iso:15118:2:2010:MsgBody":ReceiptRequired,"urn:iso:15118:2:2010:MsgBody":AC_EVSEStatus)',  derivedBy='EXTENSION'.  */
#define dinChargingStatusResType_EVSEID_BYTES_SIZE 32 /* XML schema facet maxLength for urn:iso:15118:2:2010:MsgDataTypes,evseIDType is 32 */
struct dinChargingStatusResType {
	/* element: "urn:iso:15118:2:2010:MsgBody":ResponseCode, urn:iso:15118:2:2010:MsgDataTypes,responseCodeType */
	dinresponseCodeType ResponseCode ;
	/* element: "urn:iso:15118:2:2010:MsgBody":EVSEID, urn:iso:15118:2:2010:MsgDataTypes,evseIDType */
	struct {
		uint8_t bytes[dinChargingStatusResType_EVSEID_BYTES_SIZE];
		uint16_t bytesLen;
	}  EVSEID ;
	/* element: "urn:iso:15118:2:2010:MsgBody":SAScheduleTupleID, urn:iso:15118:2:2010:MsgDataTypes,SAIDType */
	int16_t SAScheduleTupleID ;
	/* element: "urn:iso:15118:2:2010:MsgBody":EVSEMaxCurrent, Complex type name='urn:iso:15118:2:2010:MsgDataTypes,PhysicalValueType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2010:MsgDataTypes":Multiplier,"urn:iso:15118:2:2010:MsgDataTypes":Unit{0-1},"urn:iso:15118:2:2010:MsgDataTypes":Value)',  derivedBy='RESTRICTION'.  */
	struct dinPhysicalValueType EVSEMaxCurrent ;
	unsigned int EVSEMaxCurrent_isUsed:1;
	/* element: "urn:iso:15118:2:2010:MsgBody":MeterInfo, Complex type name='urn:iso:15118:2:2010:MsgDataTypes,MeterInfoType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2010:MsgDataTypes":MeterID,"urn:iso:15118:2:2010:MsgDataTypes":MeterReading{0-1},"urn:iso:15118:2:2010:MsgDataTypes":SigMeterReading{0-1},"urn:iso:15118:2:2010:MsgDataTypes":MeterStatus{0-1},"urn:iso:15118:2:2010:MsgDataTypes":TMeter{0-1})',  derivedBy='RESTRICTION'.  */
	struct dinMeterInfoType MeterInfo ;
	unsigned int MeterInfo_isUsed:1;
	/* element: "urn:iso:15118:2:2010:MsgBody":ReceiptRequired, http://www.w3.org/2001/XMLSchema,boolean */
	int ReceiptRequired ;
	/* element: "urn:iso:15118:2:2010:MsgBody":AC_EVSEStatus, Complex type name='urn:iso:15118:2:2010:MsgDataTypes,AC_EVSEStatusType',  base type name='EVSEStatusType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2010:MsgDataTypes":PowerSwitchClosed,"urn:iso:15118:2:2010:MsgDataTypes":RCD,"urn:iso:15118:2:2010:MsgDataTypes":NotificationMaxDelay,"urn:iso:15118:2:2010:MsgDataTypes":EVSENotification)',  derivedBy='EXTENSION'.  */
	struct dinAC_EVSEStatusType AC_EVSEStatus ;
};

/* Complex type name='urn:iso:15118:2:2010:MsgBody,WeldingDetectionReqType',  base type name='BodyBaseType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2010:MsgBody":DC_EVStatus)',  derivedBy='EXTENSION'.  */
struct dinWeldingDetectionReqType {
	/* element: "urn:iso:15118:2:2010:MsgBody":DC_EVStatus, Complex type name='urn:iso:15118:2:2010:MsgDataTypes,DC_EVStatusType',  base type name='EVStatusType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2010:MsgDataTypes":EVReady,"urn:iso:15118:2:2010:MsgDataTypes":EVCabinConditioning{0-1},"urn:iso:15118:2:2010:MsgDataTypes":EVRESSConditioning{0-1},"urn:iso:15118:2:2010:MsgDataTypes":EVErrorCode,"urn:iso:15118:2:2010:MsgDataTypes":EVRESSSOC)',  derivedBy='EXTENSION'.  */
	struct dinDC_EVStatusType DC_EVStatus ;
};

/* Complex type name='http://www.w3.org/2000/09/xmldsig#,SignaturePropertiesType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("http://www.w3.org/2000/09/xmldsig#":SignatureProperty{1-UNBOUNDED})',  derivedBy='RESTRICTION'.  */
#define dinSignaturePropertiesType_Id_CHARACTERS_SIZE 50 + EXTRA_CHAR 
#define dinSignaturePropertiesType_SignatureProperty_ARRAY_SIZE 1
struct dinSignaturePropertiesType {
	/* attribute: Id {http://www.w3.org/2001/XMLSchema,ID} */
	struct {
		exi_string_character_t characters[dinSignaturePropertiesType_Id_CHARACTERS_SIZE];
		uint16_t charactersLen;
	}  Id ;
	unsigned int Id_isUsed:1;
	/* element: "http://www.w3.org/2000/09/xmldsig#":SignatureProperty, Complex type name='http://www.w3.org/2000/09/xmldsig#,SignaturePropertyType',  base type name='anyType',  content type='MIXED',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='((WC[##other:"http://www.w3.org/2000/09/xmldsig#"])){1-UNBOUNDED}',  derivedBy='RESTRICTION'.  */
	struct {
		struct dinSignaturePropertyType array[dinSignaturePropertiesType_SignatureProperty_ARRAY_SIZE];
		uint16_t arrayLen;
	} SignatureProperty;
};

/* Complex type name='urn:iso:15118:2:2010:MsgDataTypes,DC_EVPowerDeliveryParameterType',  base type name='EVPowerDeliveryParameterType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2010:MsgDataTypes":DC_EVStatus,"urn:iso:15118:2:2010:MsgDataTypes":BulkChargingComplete{0-1},"urn:iso:15118:2:2010:MsgDataTypes":ChargingComplete)',  derivedBy='EXTENSION'.  */
struct dinDC_EVPowerDeliveryParameterType {
	/* element: "urn:iso:15118:2:2010:MsgDataTypes":DC_EVStatus, Complex type name='urn:iso:15118:2:2010:MsgDataTypes,DC_EVStatusType',  base type name='EVStatusType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2010:MsgDataTypes":EVReady,"urn:iso:15118:2:2010:MsgDataTypes":EVCabinConditioning{0-1},"urn:iso:15118:2:2010:MsgDataTypes":EVRESSConditioning{0-1},"urn:iso:15118:2:2010:MsgDataTypes":EVErrorCode,"urn:iso:15118:2:2010:MsgDataTypes":EVRESSSOC)',  derivedBy='EXTENSION'.  */
	struct dinDC_EVStatusType DC_EVStatus ;
	/* element: "urn:iso:15118:2:2010:MsgDataTypes":BulkChargingComplete, http://www.w3.org/2001/XMLSchema,boolean */
	int BulkChargingComplete ;
	unsigned int BulkChargingComplete_isUsed:1;
	/* element: "urn:iso:15118:2:2010:MsgDataTypes":ChargingComplete, http://www.w3.org/2001/XMLSchema,boolean */
	int ChargingComplete ;
};

/* Complex type name='urn:iso:15118:2:2010:MsgBody,CableCheckReqType',  base type name='BodyBaseType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2010:MsgBody":DC_EVStatus)',  derivedBy='EXTENSION'.  */
struct dinCableCheckReqType {
	/* element: "urn:iso:15118:2:2010:MsgBody":DC_EVStatus, Complex type name='urn:iso:15118:2:2010:MsgDataTypes,DC_EVStatusType',  base type name='EVStatusType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2010:MsgDataTypes":EVReady,"urn:iso:15118:2:2010:MsgDataTypes":EVCabinConditioning{0-1},"urn:iso:15118:2:2010:MsgDataTypes":EVRESSConditioning{0-1},"urn:iso:15118:2:2010:MsgDataTypes":EVErrorCode,"urn:iso:15118:2:2010:MsgDataTypes":EVRESSSOC)',  derivedBy='EXTENSION'.  */
	struct dinDC_EVStatusType DC_EVStatus ;
};

/* Complex type name='urn:iso:15118:2:2010:MsgDataTypes,DC_EVChargeParameterType',  base type name='EVChargeParameterType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2010:MsgDataTypes":DC_EVStatus,"urn:iso:15118:2:2010:MsgDataTypes":EVMaximumCurrentLimit,"urn:iso:15118:2:2010:MsgDataTypes":EVMaximumPowerLimit{0-1},"urn:iso:15118:2:2010:MsgDataTypes":EVMaximumVoltageLimit,"urn:iso:15118:2:2010:MsgDataTypes":EVEnergyCapacity{0-1},"urn:iso:15118:2:2010:MsgDataTypes":EVEnergyRequest{0-1},"urn:iso:15118:2:2010:MsgDataTypes":FullSOC{0-1},"urn:iso:15118:2:2010:MsgDataTypes":BulkSOC{0-1})',  derivedBy='EXTENSION'.  */
struct dinDC_EVChargeParameterType {
	/* element: "urn:iso:15118:2:2010:MsgDataTypes":DC_EVStatus, Complex type name='urn:iso:15118:2:2010:MsgDataTypes,DC_EVStatusType',  base type name='EVStatusType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2010:MsgDataTypes":EVReady,"urn:iso:15118:2:2010:MsgDataTypes":EVCabinConditioning{0-1},"urn:iso:15118:2:2010:MsgDataTypes":EVRESSConditioning{0-1},"urn:iso:15118:2:2010:MsgDataTypes":EVErrorCode,"urn:iso:15118:2:2010:MsgDataTypes":EVRESSSOC)',  derivedBy='EXTENSION'.  */
	struct dinDC_EVStatusType DC_EVStatus ;
	/* element: "urn:iso:15118:2:2010:MsgDataTypes":EVMaximumCurrentLimit, Complex type name='urn:iso:15118:2:2010:MsgDataTypes,PhysicalValueType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2010:MsgDataTypes":Multiplier,"urn:iso:15118:2:2010:MsgDataTypes":Unit{0-1},"urn:iso:15118:2:2010:MsgDataTypes":Value)',  derivedBy='RESTRICTION'.  */
	struct dinPhysicalValueType EVMaximumCurrentLimit ;
	/* element: "urn:iso:15118:2:2010:MsgDataTypes":EVMaximumPowerLimit, Complex type name='urn:iso:15118:2:2010:MsgDataTypes,PhysicalValueType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2010:MsgDataTypes":Multiplier,"urn:iso:15118:2:2010:MsgDataTypes":Unit{0-1},"urn:iso:15118:2:2010:MsgDataTypes":Value)',  derivedBy='RESTRICTION'.  */
	struct dinPhysicalValueType EVMaximumPowerLimit ;
	unsigned int EVMaximumPowerLimit_isUsed:1;
	/* element: "urn:iso:15118:2:2010:MsgDataTypes":EVMaximumVoltageLimit, Complex type name='urn:iso:15118:2:2010:MsgDataTypes,PhysicalValueType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2010:MsgDataTypes":Multiplier,"urn:iso:15118:2:2010:MsgDataTypes":Unit{0-1},"urn:iso:15118:2:2010:MsgDataTypes":Value)',  derivedBy='RESTRICTION'.  */
	struct dinPhysicalValueType EVMaximumVoltageLimit ;
	/* element: "urn:iso:15118:2:2010:MsgDataTypes":EVEnergyCapacity, Complex type name='urn:iso:15118:2:2010:MsgDataTypes,PhysicalValueType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2010:MsgDataTypes":Multiplier,"urn:iso:15118:2:2010:MsgDataTypes":Unit{0-1},"urn:iso:15118:2:2010:MsgDataTypes":Value)',  derivedBy='RESTRICTION'.  */
	struct dinPhysicalValueType EVEnergyCapacity ;
	unsigned int EVEnergyCapacity_isUsed:1;
	/* element: "urn:iso:15118:2:2010:MsgDataTypes":EVEnergyRequest, Complex type name='urn:iso:15118:2:2010:MsgDataTypes,PhysicalValueType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2010:MsgDataTypes":Multiplier,"urn:iso:15118:2:2010:MsgDataTypes":Unit{0-1},"urn:iso:15118:2:2010:MsgDataTypes":Value)',  derivedBy='RESTRICTION'.  */
	struct dinPhysicalValueType EVEnergyRequest ;
	unsigned int EVEnergyRequest_isUsed:1;
	/* element: "urn:iso:15118:2:2010:MsgDataTypes":FullSOC, urn:iso:15118:2:2010:MsgDataTypes,percentValueType */
	int8_t FullSOC ;
	unsigned int FullSOC_isUsed:1;
	/* element: "urn:iso:15118:2:2010:MsgDataTypes":BulkSOC, urn:iso:15118:2:2010:MsgDataTypes,percentValueType */
	int8_t BulkSOC ;
	unsigned int BulkSOC_isUsed:1;
};

/* Complex type name='urn:iso:15118:2:2010:MsgDataTypes,PMaxScheduleType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2010:MsgDataTypes":PMaxScheduleID,"urn:iso:15118:2:2010:MsgDataTypes":PMaxScheduleEntry{1-UNBOUNDED})',  derivedBy='RESTRICTION'.  */
#define dinPMaxScheduleType_PMaxScheduleEntry_ARRAY_SIZE 5
struct dinPMaxScheduleType {
	/* element: "urn:iso:15118:2:2010:MsgDataTypes":PMaxScheduleID, urn:iso:15118:2:2010:MsgDataTypes,SAIDType */
	int16_t PMaxScheduleID ;
	/* element: "urn:iso:15118:2:2010:MsgDataTypes":PMaxScheduleEntry, Complex type name='urn:iso:15118:2:2010:MsgDataTypes,PMaxScheduleEntryType',  base type name='EntryType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='(("urn:iso:15118:2:2010:MsgDataTypes":TimeInterval),("urn:iso:15118:2:2010:MsgDataTypes":PMax))',  derivedBy='EXTENSION'.  */
	struct {
		struct dinPMaxScheduleEntryType array[dinPMaxScheduleType_PMaxScheduleEntry_ARRAY_SIZE];
		uint16_t arrayLen;
	} PMaxScheduleEntry;
};

/* Complex type name='urn:iso:15118:2:2010:MsgBody,ServicePaymentSelectionReqType',  base type name='BodyBaseType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2010:MsgBody":SelectedPaymentOption,"urn:iso:15118:2:2010:MsgBody":SelectedServiceList)',  derivedBy='EXTENSION'.  */
struct dinServicePaymentSelectionReqType {
	/* element: "urn:iso:15118:2:2010:MsgBody":SelectedPaymentOption, urn:iso:15118:2:2010:MsgDataTypes,paymentOptionType */
	dinpaymentOptionType SelectedPaymentOption ;
	/* element: "urn:iso:15118:2:2010:MsgBody":SelectedServiceList, Complex type name='urn:iso:15118:2:2010:MsgDataTypes,SelectedServiceListType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2010:MsgDataTypes":SelectedService{1-UNBOUNDED})',  derivedBy='RESTRICTION'.  */
	struct dinSelectedServiceListType SelectedServiceList ;
};

/* Complex type name='urn:iso:15118:2:2010:MsgBody,PreChargeResType',  base type name='BodyBaseType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2010:MsgBody":ResponseCode,"urn:iso:15118:2:2010:MsgBody":DC_EVSEStatus,"urn:iso:15118:2:2010:MsgBody":EVSEPresentVoltage)',  derivedBy='EXTENSION'.  */
struct dinPreChargeResType {
	/* element: "urn:iso:15118:2:2010:MsgBody":ResponseCode, urn:iso:15118:2:2010:MsgDataTypes,responseCodeType */
	dinresponseCodeType ResponseCode ;
	/* element: "urn:iso:15118:2:2010:MsgBody":DC_EVSEStatus, Complex type name='urn:iso:15118:2:2010:MsgDataTypes,DC_EVSEStatusType',  base type name='EVSEStatusType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2010:MsgDataTypes":EVSEIsolationStatus{0-1},"urn:iso:15118:2:2010:MsgDataTypes":EVSEStatusCode,"urn:iso:15118:2:2010:MsgDataTypes":NotificationMaxDelay,"urn:iso:15118:2:2010:MsgDataTypes":EVSENotification)',  derivedBy='EXTENSION'.  */
	struct dinDC_EVSEStatusType DC_EVSEStatus ;
	/* element: "urn:iso:15118:2:2010:MsgBody":EVSEPresentVoltage, Complex type name='urn:iso:15118:2:2010:MsgDataTypes,PhysicalValueType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2010:MsgDataTypes":Multiplier,"urn:iso:15118:2:2010:MsgDataTypes":Unit{0-1},"urn:iso:15118:2:2010:MsgDataTypes":Value)',  derivedBy='RESTRICTION'.  */
	struct dinPhysicalValueType EVSEPresentVoltage ;
};

/* Complex type name='urn:iso:15118:2:2010:MsgDataTypes,DC_EVSEChargeParameterType',  base type name='EVSEChargeParameterType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2010:MsgDataTypes":DC_EVSEStatus,"urn:iso:15118:2:2010:MsgDataTypes":EVSEMaximumCurrentLimit,"urn:iso:15118:2:2010:MsgDataTypes":EVSEMaximumPowerLimit{0-1},"urn:iso:15118:2:2010:MsgDataTypes":EVSEMaximumVoltageLimit,"urn:iso:15118:2:2010:MsgDataTypes":EVSEMinimumCurrentLimit,"urn:iso:15118:2:2010:MsgDataTypes":EVSEMinimumVoltageLimit,"urn:iso:15118:2:2010:MsgDataTypes":EVSECurrentRegulationTolerance{0-1},"urn:iso:15118:2:2010:MsgDataTypes":EVSEPeakCurrentRipple,"urn:iso:15118:2:2010:MsgDataTypes":EVSEEnergyToBeDelivered{0-1})',  derivedBy='EXTENSION'.  */
struct dinDC_EVSEChargeParameterType {
	/* element: "urn:iso:15118:2:2010:MsgDataTypes":DC_EVSEStatus, Complex type name='urn:iso:15118:2:2010:MsgDataTypes,DC_EVSEStatusType',  base type name='EVSEStatusType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2010:MsgDataTypes":EVSEIsolationStatus{0-1},"urn:iso:15118:2:2010:MsgDataTypes":EVSEStatusCode,"urn:iso:15118:2:2010:MsgDataTypes":NotificationMaxDelay,"urn:iso:15118:2:2010:MsgDataTypes":EVSENotification)',  derivedBy='EXTENSION'.  */
	struct dinDC_EVSEStatusType DC_EVSEStatus ;
	/* element: "urn:iso:15118:2:2010:MsgDataTypes":EVSEMaximumCurrentLimit, Complex type name='urn:iso:15118:2:2010:MsgDataTypes,PhysicalValueType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2010:MsgDataTypes":Multiplier,"urn:iso:15118:2:2010:MsgDataTypes":Unit{0-1},"urn:iso:15118:2:2010:MsgDataTypes":Value)',  derivedBy='RESTRICTION'.  */
	struct dinPhysicalValueType EVSEMaximumCurrentLimit ;
	/* element: "urn:iso:15118:2:2010:MsgDataTypes":EVSEMaximumPowerLimit, Complex type name='urn:iso:15118:2:2010:MsgDataTypes,PhysicalValueType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2010:MsgDataTypes":Multiplier,"urn:iso:15118:2:2010:MsgDataTypes":Unit{0-1},"urn:iso:15118:2:2010:MsgDataTypes":Value)',  derivedBy='RESTRICTION'.  */
	struct dinPhysicalValueType EVSEMaximumPowerLimit ;
	unsigned int EVSEMaximumPowerLimit_isUsed:1;
	/* element: "urn:iso:15118:2:2010:MsgDataTypes":EVSEMaximumVoltageLimit, Complex type name='urn:iso:15118:2:2010:MsgDataTypes,PhysicalValueType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2010:MsgDataTypes":Multiplier,"urn:iso:15118:2:2010:MsgDataTypes":Unit{0-1},"urn:iso:15118:2:2010:MsgDataTypes":Value)',  derivedBy='RESTRICTION'.  */
	struct dinPhysicalValueType EVSEMaximumVoltageLimit ;
	/* element: "urn:iso:15118:2:2010:MsgDataTypes":EVSEMinimumCurrentLimit, Complex type name='urn:iso:15118:2:2010:MsgDataTypes,PhysicalValueType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2010:MsgDataTypes":Multiplier,"urn:iso:15118:2:2010:MsgDataTypes":Unit{0-1},"urn:iso:15118:2:2010:MsgDataTypes":Value)',  derivedBy='RESTRICTION'.  */
	struct dinPhysicalValueType EVSEMinimumCurrentLimit ;
	/* element: "urn:iso:15118:2:2010:MsgDataTypes":EVSEMinimumVoltageLimit, Complex type name='urn:iso:15118:2:2010:MsgDataTypes,PhysicalValueType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2010:MsgDataTypes":Multiplier,"urn:iso:15118:2:2010:MsgDataTypes":Unit{0-1},"urn:iso:15118:2:2010:MsgDataTypes":Value)',  derivedBy='RESTRICTION'.  */
	struct dinPhysicalValueType EVSEMinimumVoltageLimit ;
	/* element: "urn:iso:15118:2:2010:MsgDataTypes":EVSECurrentRegulationTolerance, Complex type name='urn:iso:15118:2:2010:MsgDataTypes,PhysicalValueType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2010:MsgDataTypes":Multiplier,"urn:iso:15118:2:2010:MsgDataTypes":Unit{0-1},"urn:iso:15118:2:2010:MsgDataTypes":Value)',  derivedBy='RESTRICTION'.  */
	struct dinPhysicalValueType EVSECurrentRegulationTolerance ;
	unsigned int EVSECurrentRegulationTolerance_isUsed:1;
	/* element: "urn:iso:15118:2:2010:MsgDataTypes":EVSEPeakCurrentRipple, Complex type name='urn:iso:15118:2:2010:MsgDataTypes,PhysicalValueType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2010:MsgDataTypes":Multiplier,"urn:iso:15118:2:2010:MsgDataTypes":Unit{0-1},"urn:iso:15118:2:2010:MsgDataTypes":Value)',  derivedBy='RESTRICTION'.  */
	struct dinPhysicalValueType EVSEPeakCurrentRipple ;
	/* element: "urn:iso:15118:2:2010:MsgDataTypes":EVSEEnergyToBeDelivered, Complex type name='urn:iso:15118:2:2010:MsgDataTypes,PhysicalValueType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2010:MsgDataTypes":Multiplier,"urn:iso:15118:2:2010:MsgDataTypes":Unit{0-1},"urn:iso:15118:2:2010:MsgDataTypes":Value)',  derivedBy='RESTRICTION'.  */
	struct dinPhysicalValueType EVSEEnergyToBeDelivered ;
	unsigned int EVSEEnergyToBeDelivered_isUsed:1;
};

/* Complex type name='urn:iso:15118:2:2010:MsgBody,PaymentDetailsResType',  base type name='BodyBaseType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2010:MsgBody":ResponseCode,"urn:iso:15118:2:2010:MsgBody":GenChallenge,"urn:iso:15118:2:2010:MsgBody":DateTimeNow)',  derivedBy='EXTENSION'.  */
#define dinPaymentDetailsResType_GenChallenge_CHARACTERS_SIZE 50 + EXTRA_CHAR 
struct dinPaymentDetailsResType {
	/* element: "urn:iso:15118:2:2010:MsgBody":ResponseCode, urn:iso:15118:2:2010:MsgDataTypes,responseCodeType */
	dinresponseCodeType ResponseCode ;
	/* element: "urn:iso:15118:2:2010:MsgBody":GenChallenge, urn:iso:15118:2:2010:MsgDataTypes,genChallengeType */
	struct {
		exi_string_character_t characters[dinPaymentDetailsResType_GenChallenge_CHARACTERS_SIZE];
		uint16_t charactersLen;
	}  GenChallenge ;
	/* element: "urn:iso:15118:2:2010:MsgBody":DateTimeNow, http://www.w3.org/2001/XMLSchema,long */
	int64_t DateTimeNow ;
};

/* Complex type name='http://www.w3.org/2000/09/xmldsig#,KeyValueType',  base type name='anyType',  content type='MIXED',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("http://www.w3.org/2000/09/xmldsig#":DSAKeyValue|"http://www.w3.org/2000/09/xmldsig#":RSAKeyValue|(WC[##other:"http://www.w3.org/2000/09/xmldsig#"]))',  derivedBy='RESTRICTION'.  */
#define dinKeyValueType_ANY_CHARACTERS_SIZE 50 + EXTRA_CHAR 
struct dinKeyValueType {
	/* element: "http://www.w3.org/2000/09/xmldsig#":DSAKeyValue, Complex type name='http://www.w3.org/2000/09/xmldsig#,DSAKeyValueType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='(("http://www.w3.org/2000/09/xmldsig#":P,"http://www.w3.org/2000/09/xmldsig#":Q){0-1},"http://www.w3.org/2000/09/xmldsig#":G{0-1},"http://www.w3.org/2000/09/xmldsig#":Y,"http://www.w3.org/2000/09/xmldsig#":J{0-1},("http://www.w3.org/2000/09/xmldsig#":Seed,"http://www.w3.org/2000/09/xmldsig#":PgenCounter){0-1})',  derivedBy='RESTRICTION'.  */
	struct dinDSAKeyValueType DSAKeyValue ;
	unsigned int DSAKeyValue_isUsed:1;
	/* element: "http://www.w3.org/2000/09/xmldsig#":RSAKeyValue, Complex type name='http://www.w3.org/2000/09/xmldsig#,RSAKeyValueType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("http://www.w3.org/2000/09/xmldsig#":Modulus,"http://www.w3.org/2000/09/xmldsig#":Exponent)',  derivedBy='RESTRICTION'.  */
	struct dinRSAKeyValueType RSAKeyValue ;
	unsigned int RSAKeyValue_isUsed:1;
	/* element: WC[##other:"http://www.w3.org/2000/09/xmldsig#"] */
	struct {
		exi_string_character_t characters[dinKeyValueType_ANY_CHARACTERS_SIZE];
		uint16_t charactersLen;
	}  ANY ;
	unsigned int ANY_isUsed:1;
};

/* Complex type name='urn:iso:15118:2:2010:MsgBody,PowerDeliveryReqType',  base type name='BodyBaseType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2010:MsgBody":ReadyToChargeState,"urn:iso:15118:2:2010:MsgBody":ChargingProfile{0-1},"urn:iso:15118:2:2010:MsgDataTypes":EVPowerDeliveryParameter{0-1})',  derivedBy='EXTENSION'.  */
struct dinPowerDeliveryReqType {
	/* element: "urn:iso:15118:2:2010:MsgBody":ReadyToChargeState, http://www.w3.org/2001/XMLSchema,boolean */
	int ReadyToChargeState ;
	/* element: "urn:iso:15118:2:2010:MsgBody":ChargingProfile, Complex type name='urn:iso:15118:2:2010:MsgDataTypes,ChargingProfileType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2010:MsgDataTypes":SAScheduleTupleID,"urn:iso:15118:2:2010:MsgDataTypes":ProfileEntry{1-UNBOUNDED})',  derivedBy='RESTRICTION'.  */
	struct dinChargingProfileType ChargingProfile ;
	unsigned int ChargingProfile_isUsed:1;
	/* element: "urn:iso:15118:2:2010:MsgDataTypes":EVPowerDeliveryParameter, Complex type name='urn:iso:15118:2:2010:MsgDataTypes,EVPowerDeliveryParameterType',  base type name='anyType',  content type='EMPTY',  isAbstract='true',  hasTypeId='false',  final='0',  block='0',  derivedBy='RESTRICTION'.  */
	struct dinEVPowerDeliveryParameterType EVPowerDeliveryParameter ;
	unsigned int EVPowerDeliveryParameter_isUsed:1;
	/* element: "urn:iso:15118:2:2010:MsgDataTypes":DC_EVPowerDeliveryParameter, Complex type name='urn:iso:15118:2:2010:MsgDataTypes,DC_EVPowerDeliveryParameterType',  base type name='EVPowerDeliveryParameterType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2010:MsgDataTypes":DC_EVStatus,"urn:iso:15118:2:2010:MsgDataTypes":BulkChargingComplete{0-1},"urn:iso:15118:2:2010:MsgDataTypes":ChargingComplete)',  derivedBy='EXTENSION'.  */
	struct dinDC_EVPowerDeliveryParameterType DC_EVPowerDeliveryParameter ;
	unsigned int DC_EVPowerDeliveryParameter_isUsed:1;
};

/* Complex type name='urn:iso:15118:2:2010:MsgDataTypes,CertificateChainType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2010:MsgDataTypes":Certificate,"urn:iso:15118:2:2010:MsgDataTypes":SubCertificates{0-1})',  derivedBy='RESTRICTION'.  */
#define dinCertificateChainType_Certificate_BYTES_SIZE 1200 /* XML schema facet maxLength for urn:iso:15118:2:2010:MsgDataTypes,certificateType is 1200 */
struct dinCertificateChainType {
	/* element: "urn:iso:15118:2:2010:MsgDataTypes":Certificate, urn:iso:15118:2:2010:MsgDataTypes,certificateType */
	struct {
		uint8_t bytes[dinCertificateChainType_Certificate_BYTES_SIZE];
		uint16_t bytesLen;
	}  Certificate ;
	/* element: "urn:iso:15118:2:2010:MsgDataTypes":SubCertificates, Complex type name='urn:iso:15118:2:2010:MsgDataTypes,SubCertificatesType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2010:MsgDataTypes":Certificate{1-UNBOUNDED})',  derivedBy='RESTRICTION'.  */
	struct dinSubCertificatesType SubCertificates ;
	unsigned int SubCertificates_isUsed:1;
};

/* Complex type name='urn:iso:15118:2:2010:MsgDataTypes,ParameterType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2010:MsgDataTypes":boolValue|"urn:iso:15118:2:2010:MsgDataTypes":byteValue|"urn:iso:15118:2:2010:MsgDataTypes":shortValue|"urn:iso:15118:2:2010:MsgDataTypes":intValue|"urn:iso:15118:2:2010:MsgDataTypes":physicalValue|"urn:iso:15118:2:2010:MsgDataTypes":stringValue)',  derivedBy='RESTRICTION'.  */
#define dinParameterType_Name_CHARACTERS_SIZE 50 + EXTRA_CHAR 
#define dinParameterType_stringValue_CHARACTERS_SIZE 50 + EXTRA_CHAR 
struct dinParameterType {
	/* attribute: Name {http://www.w3.org/2001/XMLSchema,string} */
	struct {
		exi_string_character_t characters[dinParameterType_Name_CHARACTERS_SIZE];
		uint16_t charactersLen;
	}  Name ;
	/* attribute: ValueType {urn:iso:15118:2:2010:MsgDataTypes,valueType} */
	dinvalueType ValueType ;
	/* element: "urn:iso:15118:2:2010:MsgDataTypes":boolValue, http://www.w3.org/2001/XMLSchema,boolean */
	int boolValue ;
	unsigned int boolValue_isUsed:1;
	/* element: "urn:iso:15118:2:2010:MsgDataTypes":byteValue, http://www.w3.org/2001/XMLSchema,byte */
	int8_t byteValue ;
	unsigned int byteValue_isUsed:1;
	/* element: "urn:iso:15118:2:2010:MsgDataTypes":shortValue, http://www.w3.org/2001/XMLSchema,short */
	int16_t shortValue ;
	unsigned int shortValue_isUsed:1;
	/* element: "urn:iso:15118:2:2010:MsgDataTypes":intValue, http://www.w3.org/2001/XMLSchema,int */
	int32_t intValue ;
	unsigned int intValue_isUsed:1;
	/* element: "urn:iso:15118:2:2010:MsgDataTypes":physicalValue, Complex type name='urn:iso:15118:2:2010:MsgDataTypes,PhysicalValueType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2010:MsgDataTypes":Multiplier,"urn:iso:15118:2:2010:MsgDataTypes":Unit{0-1},"urn:iso:15118:2:2010:MsgDataTypes":Value)',  derivedBy='RESTRICTION'.  */
	struct dinPhysicalValueType physicalValue ;
	unsigned int physicalValue_isUsed:1;
	/* element: "urn:iso:15118:2:2010:MsgDataTypes":stringValue, http://www.w3.org/2001/XMLSchema,string */
	struct {
		exi_string_character_t characters[dinParameterType_stringValue_CHARACTERS_SIZE];
		uint16_t charactersLen;
	}  stringValue ;
	unsigned int stringValue_isUsed:1;
};

/* Complex type name='urn:iso:15118:2:2010:MsgDataTypes,ParameterSetType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2010:MsgDataTypes":ParameterSetID,"urn:iso:15118:2:2010:MsgDataTypes":Parameter{1-UNBOUNDED})',  derivedBy='RESTRICTION'.  */
#define dinParameterSetType_Parameter_ARRAY_SIZE 16
struct dinParameterSetType {
	/* element: "urn:iso:15118:2:2010:MsgDataTypes":ParameterSetID, http://www.w3.org/2001/XMLSchema,short */
	int16_t ParameterSetID ;
	/* element: "urn:iso:15118:2:2010:MsgDataTypes":Parameter, Complex type name='urn:iso:15118:2:2010:MsgDataTypes,ParameterType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2010:MsgDataTypes":boolValue|"urn:iso:15118:2:2010:MsgDataTypes":byteValue|"urn:iso:15118:2:2010:MsgDataTypes":shortValue|"urn:iso:15118:2:2010:MsgDataTypes":intValue|"urn:iso:15118:2:2010:MsgDataTypes":physicalValue|"urn:iso:15118:2:2010:MsgDataTypes":stringValue)',  derivedBy='RESTRICTION'.  */
	struct {
		struct dinParameterType array[dinParameterSetType_Parameter_ARRAY_SIZE];
		uint16_t arrayLen;
	} Parameter;
};

/* Complex type name='urn:iso:15118:2:2010:MsgBody,CurrentDemandReqType',  base type name='BodyBaseType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2010:MsgBody":DC_EVStatus,"urn:iso:15118:2:2010:MsgBody":EVTargetCurrent,"urn:iso:15118:2:2010:MsgBody":EVMaximumVoltageLimit{0-1},"urn:iso:15118:2:2010:MsgBody":EVMaximumCurrentLimit{0-1},"urn:iso:15118:2:2010:MsgBody":EVMaximumPowerLimit{0-1},"urn:iso:15118:2:2010:MsgBody":BulkChargingComplete{0-1},"urn:iso:15118:2:2010:MsgBody":ChargingComplete,"urn:iso:15118:2:2010:MsgBody":RemainingTimeToFullSoC{0-1},"urn:iso:15118:2:2010:MsgBody":RemainingTimeToBulkSoC{0-1},"urn:iso:15118:2:2010:MsgBody":EVTargetVoltage)',  derivedBy='EXTENSION'.  */
struct dinCurrentDemandReqType {
	/* element: "urn:iso:15118:2:2010:MsgBody":DC_EVStatus, Complex type name='urn:iso:15118:2:2010:MsgDataTypes,DC_EVStatusType',  base type name='EVStatusType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2010:MsgDataTypes":EVReady,"urn:iso:15118:2:2010:MsgDataTypes":EVCabinConditioning{0-1},"urn:iso:15118:2:2010:MsgDataTypes":EVRESSConditioning{0-1},"urn:iso:15118:2:2010:MsgDataTypes":EVErrorCode,"urn:iso:15118:2:2010:MsgDataTypes":EVRESSSOC)',  derivedBy='EXTENSION'.  */
	struct dinDC_EVStatusType DC_EVStatus ;
	/* element: "urn:iso:15118:2:2010:MsgBody":EVTargetCurrent, Complex type name='urn:iso:15118:2:2010:MsgDataTypes,PhysicalValueType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2010:MsgDataTypes":Multiplier,"urn:iso:15118:2:2010:MsgDataTypes":Unit{0-1},"urn:iso:15118:2:2010:MsgDataTypes":Value)',  derivedBy='RESTRICTION'.  */
	struct dinPhysicalValueType EVTargetCurrent ;
	/* element: "urn:iso:15118:2:2010:MsgBody":EVMaximumVoltageLimit, Complex type name='urn:iso:15118:2:2010:MsgDataTypes,PhysicalValueType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2010:MsgDataTypes":Multiplier,"urn:iso:15118:2:2010:MsgDataTypes":Unit{0-1},"urn:iso:15118:2:2010:MsgDataTypes":Value)',  derivedBy='RESTRICTION'.  */
	struct dinPhysicalValueType EVMaximumVoltageLimit ;
	unsigned int EVMaximumVoltageLimit_isUsed:1;
	/* element: "urn:iso:15118:2:2010:MsgBody":EVMaximumCurrentLimit, Complex type name='urn:iso:15118:2:2010:MsgDataTypes,PhysicalValueType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2010:MsgDataTypes":Multiplier,"urn:iso:15118:2:2010:MsgDataTypes":Unit{0-1},"urn:iso:15118:2:2010:MsgDataTypes":Value)',  derivedBy='RESTRICTION'.  */
	struct dinPhysicalValueType EVMaximumCurrentLimit ;
	unsigned int EVMaximumCurrentLimit_isUsed:1;
	/* element: "urn:iso:15118:2:2010:MsgBody":EVMaximumPowerLimit, Complex type name='urn:iso:15118:2:2010:MsgDataTypes,PhysicalValueType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2010:MsgDataTypes":Multiplier,"urn:iso:15118:2:2010:MsgDataTypes":Unit{0-1},"urn:iso:15118:2:2010:MsgDataTypes":Value)',  derivedBy='RESTRICTION'.  */
	struct dinPhysicalValueType EVMaximumPowerLimit ;
	unsigned int EVMaximumPowerLimit_isUsed:1;
	/* element: "urn:iso:15118:2:2010:MsgBody":BulkChargingComplete, http://www.w3.org/2001/XMLSchema,boolean */
	int BulkChargingComplete ;
	unsigned int BulkChargingComplete_isUsed:1;
	/* element: "urn:iso:15118:2:2010:MsgBody":ChargingComplete, http://www.w3.org/2001/XMLSchema,boolean */
	int ChargingComplete ;
	/* element: "urn:iso:15118:2:2010:MsgBody":RemainingTimeToFullSoC, Complex type name='urn:iso:15118:2:2010:MsgDataTypes,PhysicalValueType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2010:MsgDataTypes":Multiplier,"urn:iso:15118:2:2010:MsgDataTypes":Unit{0-1},"urn:iso:15118:2:2010:MsgDataTypes":Value)',  derivedBy='RESTRICTION'.  */
	struct dinPhysicalValueType RemainingTimeToFullSoC ;
	unsigned int RemainingTimeToFullSoC_isUsed:1;
	/* element: "urn:iso:15118:2:2010:MsgBody":RemainingTimeToBulkSoC, Complex type name='urn:iso:15118:2:2010:MsgDataTypes,PhysicalValueType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2010:MsgDataTypes":Multiplier,"urn:iso:15118:2:2010:MsgDataTypes":Unit{0-1},"urn:iso:15118:2:2010:MsgDataTypes":Value)',  derivedBy='RESTRICTION'.  */
	struct dinPhysicalValueType RemainingTimeToBulkSoC ;
	unsigned int RemainingTimeToBulkSoC_isUsed:1;
	/* element: "urn:iso:15118:2:2010:MsgBody":EVTargetVoltage, Complex type name='urn:iso:15118:2:2010:MsgDataTypes,PhysicalValueType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2010:MsgDataTypes":Multiplier,"urn:iso:15118:2:2010:MsgDataTypes":Unit{0-1},"urn:iso:15118:2:2010:MsgDataTypes":Value)',  derivedBy='RESTRICTION'.  */
	struct dinPhysicalValueType EVTargetVoltage ;
};

/* Complex type name='urn:iso:15118:2:2010:MsgBody,PreChargeReqType',  base type name='BodyBaseType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2010:MsgBody":DC_EVStatus,"urn:iso:15118:2:2010:MsgBody":EVTargetVoltage,"urn:iso:15118:2:2010:MsgBody":EVTargetCurrent)',  derivedBy='EXTENSION'.  */
struct dinPreChargeReqType {
	/* element: "urn:iso:15118:2:2010:MsgBody":DC_EVStatus, Complex type name='urn:iso:15118:2:2010:MsgDataTypes,DC_EVStatusType',  base type name='EVStatusType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2010:MsgDataTypes":EVReady,"urn:iso:15118:2:2010:MsgDataTypes":EVCabinConditioning{0-1},"urn:iso:15118:2:2010:MsgDataTypes":EVRESSConditioning{0-1},"urn:iso:15118:2:2010:MsgDataTypes":EVErrorCode,"urn:iso:15118:2:2010:MsgDataTypes":EVRESSSOC)',  derivedBy='EXTENSION'.  */
	struct dinDC_EVStatusType DC_EVStatus ;
	/* element: "urn:iso:15118:2:2010:MsgBody":EVTargetVoltage, Complex type name='urn:iso:15118:2:2010:MsgDataTypes,PhysicalValueType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2010:MsgDataTypes":Multiplier,"urn:iso:15118:2:2010:MsgDataTypes":Unit{0-1},"urn:iso:15118:2:2010:MsgDataTypes":Value)',  derivedBy='RESTRICTION'.  */
	struct dinPhysicalValueType EVTargetVoltage ;
	/* element: "urn:iso:15118:2:2010:MsgBody":EVTargetCurrent, Complex type name='urn:iso:15118:2:2010:MsgDataTypes,PhysicalValueType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2010:MsgDataTypes":Multiplier,"urn:iso:15118:2:2010:MsgDataTypes":Unit{0-1},"urn:iso:15118:2:2010:MsgDataTypes":Value)',  derivedBy='RESTRICTION'.  */
	struct dinPhysicalValueType EVTargetCurrent ;
};

/* Complex type name='urn:iso:15118:2:2010:MsgBody,ChargeParameterDiscoveryReqType',  base type name='BodyBaseType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2010:MsgBody":EVRequestedEnergyTransferType,"urn:iso:15118:2:2010:MsgDataTypes":EVChargeParameter)',  derivedBy='EXTENSION'.  */
struct dinChargeParameterDiscoveryReqType {
	/* element: "urn:iso:15118:2:2010:MsgBody":EVRequestedEnergyTransferType, urn:iso:15118:2:2010:MsgDataTypes,EVRequestedEnergyTransferType */
	dinEVRequestedEnergyTransferType EVRequestedEnergyTransferType ;
	/* element: "urn:iso:15118:2:2010:MsgDataTypes":EVChargeParameter, Complex type name='urn:iso:15118:2:2010:MsgDataTypes,EVChargeParameterType',  base type name='anyType',  content type='EMPTY',  isAbstract='true',  hasTypeId='false',  final='0',  block='0',  derivedBy='RESTRICTION'.  */
	struct dinEVChargeParameterType EVChargeParameter ;
	unsigned int EVChargeParameter_isUsed:1;
	/* element: "urn:iso:15118:2:2010:MsgDataTypes":AC_EVChargeParameter, Complex type name='urn:iso:15118:2:2010:MsgDataTypes,AC_EVChargeParameterType',  base type name='EVChargeParameterType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2010:MsgDataTypes":DepartureTime,"urn:iso:15118:2:2010:MsgDataTypes":EAmount,"urn:iso:15118:2:2010:MsgDataTypes":EVMaxVoltage,"urn:iso:15118:2:2010:MsgDataTypes":EVMaxCurrent,"urn:iso:15118:2:2010:MsgDataTypes":EVMinCurrent)',  derivedBy='EXTENSION'.  */
	struct dinAC_EVChargeParameterType AC_EVChargeParameter ;
	unsigned int AC_EVChargeParameter_isUsed:1;
	/* element: "urn:iso:15118:2:2010:MsgDataTypes":DC_EVChargeParameter, Complex type name='urn:iso:15118:2:2010:MsgDataTypes,DC_EVChargeParameterType',  base type name='EVChargeParameterType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2010:MsgDataTypes":DC_EVStatus,"urn:iso:15118:2:2010:MsgDataTypes":EVMaximumCurrentLimit,"urn:iso:15118:2:2010:MsgDataTypes":EVMaximumPowerLimit{0-1},"urn:iso:15118:2:2010:MsgDataTypes":EVMaximumVoltageLimit,"urn:iso:15118:2:2010:MsgDataTypes":EVEnergyCapacity{0-1},"urn:iso:15118:2:2010:MsgDataTypes":EVEnergyRequest{0-1},"urn:iso:15118:2:2010:MsgDataTypes":FullSOC{0-1},"urn:iso:15118:2:2010:MsgDataTypes":BulkSOC{0-1})',  derivedBy='EXTENSION'.  */
	struct dinDC_EVChargeParameterType DC_EVChargeParameter ;
	unsigned int DC_EVChargeParameter_isUsed:1;
};

/* Complex type name='urn:iso:15118:2:2010:MsgDataTypes,ConsumptionCostType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2010:MsgDataTypes":startValue,"urn:iso:15118:2:2010:MsgDataTypes":Cost{0-UNBOUNDED})',  derivedBy='RESTRICTION'.  */
#define dinConsumptionCostType_Cost_ARRAY_SIZE 5
struct dinConsumptionCostType {
	/* element: "urn:iso:15118:2:2010:MsgDataTypes":startValue, http://www.w3.org/2001/XMLSchema,unsignedInt */
	uint32_t startValue ;
	/* element: "urn:iso:15118:2:2010:MsgDataTypes":Cost, Complex type name='urn:iso:15118:2:2010:MsgDataTypes,CostType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2010:MsgDataTypes":costKind,"urn:iso:15118:2:2010:MsgDataTypes":amount,"urn:iso:15118:2:2010:MsgDataTypes":amountMultiplier{0-1})',  derivedBy='RESTRICTION'.  */
	struct {
		struct dinCostType array[dinConsumptionCostType_Cost_ARRAY_SIZE];
		uint16_t arrayLen;
	} Cost;
};

/* Complex type name='urn:iso:15118:2:2010:MsgDataTypes,ServiceType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2010:MsgDataTypes":ServiceTag,"urn:iso:15118:2:2010:MsgDataTypes":FreeService)',  derivedBy='RESTRICTION'.  */
struct dinServiceType {
	/* element: "urn:iso:15118:2:2010:MsgDataTypes":ServiceTag, Complex type name='urn:iso:15118:2:2010:MsgDataTypes,ServiceTagType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2010:MsgDataTypes":ServiceID,"urn:iso:15118:2:2010:MsgDataTypes":ServiceName{0-1},"urn:iso:15118:2:2010:MsgDataTypes":ServiceCategory,"urn:iso:15118:2:2010:MsgDataTypes":ServiceScope{0-1})',  derivedBy='RESTRICTION'.  */
	struct dinServiceTagType ServiceTag ;
	/* element: "urn:iso:15118:2:2010:MsgDataTypes":FreeService, http://www.w3.org/2001/XMLSchema,boolean */
	int FreeService ;
};

/* Complex type name='urn:iso:15118:2:2010:MsgDataTypes,ServiceTagListType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2010:MsgDataTypes":Service{1-UNBOUNDED})',  derivedBy='RESTRICTION'.  */
#define dinServiceTagListType_Service_ARRAY_SIZE 8
struct dinServiceTagListType {
	/* element: "urn:iso:15118:2:2010:MsgDataTypes":Service, Complex type name='urn:iso:15118:2:2010:MsgDataTypes,ServiceType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2010:MsgDataTypes":ServiceTag,"urn:iso:15118:2:2010:MsgDataTypes":FreeService)',  derivedBy='RESTRICTION'.  */
	struct {
		struct dinServiceType array[dinServiceTagListType_Service_ARRAY_SIZE];
		uint16_t arrayLen;
	} Service;
};

/* Complex type name='urn:iso:15118:2:2010:MsgBody,SessionSetupResType',  base type name='BodyBaseType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2010:MsgBody":ResponseCode,"urn:iso:15118:2:2010:MsgBody":EVSEID,"urn:iso:15118:2:2010:MsgBody":DateTimeNow{0-1})',  derivedBy='EXTENSION'.  */
#define dinSessionSetupResType_EVSEID_BYTES_SIZE 32 /* XML schema facet maxLength for urn:iso:15118:2:2010:MsgDataTypes,evseIDType is 32 */
struct dinSessionSetupResType {
	/* element: "urn:iso:15118:2:2010:MsgBody":ResponseCode, urn:iso:15118:2:2010:MsgDataTypes,responseCodeType */
	dinresponseCodeType ResponseCode ;
	/* element: "urn:iso:15118:2:2010:MsgBody":EVSEID, urn:iso:15118:2:2010:MsgDataTypes,evseIDType */
	struct {
		uint8_t bytes[dinSessionSetupResType_EVSEID_BYTES_SIZE];
		uint16_t bytesLen;
	}  EVSEID ;
	/* element: "urn:iso:15118:2:2010:MsgBody":DateTimeNow, http://www.w3.org/2001/XMLSchema,long */
	int64_t DateTimeNow ;
	unsigned int DateTimeNow_isUsed:1;
};

/* Complex type name='urn:iso:15118:2:2010:MsgBody,MeteringReceiptResType',  base type name='BodyBaseType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2010:MsgBody":ResponseCode,"urn:iso:15118:2:2010:MsgBody":AC_EVSEStatus)',  derivedBy='EXTENSION'.  */
struct dinMeteringReceiptResType {
	/* element: "urn:iso:15118:2:2010:MsgBody":ResponseCode, urn:iso:15118:2:2010:MsgDataTypes,responseCodeType */
	dinresponseCodeType ResponseCode ;
	/* element: "urn:iso:15118:2:2010:MsgBody":AC_EVSEStatus, Complex type name='urn:iso:15118:2:2010:MsgDataTypes,AC_EVSEStatusType',  base type name='EVSEStatusType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2010:MsgDataTypes":PowerSwitchClosed,"urn:iso:15118:2:2010:MsgDataTypes":RCD,"urn:iso:15118:2:2010:MsgDataTypes":NotificationMaxDelay,"urn:iso:15118:2:2010:MsgDataTypes":EVSENotification)',  derivedBy='EXTENSION'.  */
	struct dinAC_EVSEStatusType AC_EVSEStatus ;
};

/* Complex type name='urn:iso:15118:2:2010:MsgDataTypes,ServiceParameterListType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2010:MsgDataTypes":ParameterSet{1-UNBOUNDED})',  derivedBy='RESTRICTION'.  */
#define dinServiceParameterListType_ParameterSet_ARRAY_SIZE 5
struct dinServiceParameterListType {
	/* element: "urn:iso:15118:2:2010:MsgDataTypes":ParameterSet, Complex type name='urn:iso:15118:2:2010:MsgDataTypes,ParameterSetType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2010:MsgDataTypes":ParameterSetID,"urn:iso:15118:2:2010:MsgDataTypes":Parameter{1-UNBOUNDED})',  derivedBy='RESTRICTION'.  */
	struct {
		struct dinParameterSetType array[dinServiceParameterListType_ParameterSet_ARRAY_SIZE];
		uint16_t arrayLen;
	} ParameterSet;
};

/* Complex type name='urn:iso:15118:2:2010:MsgBody,CertificateUpdateReqType',  base type name='BodyBaseType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2010:MsgBody":ContractSignatureCertChain,"urn:iso:15118:2:2010:MsgBody":ContractID,"urn:iso:15118:2:2010:MsgBody":ListOfRootCertificateIDs,"urn:iso:15118:2:2010:MsgBody":DHParams)',  derivedBy='EXTENSION'.  */
#define dinCertificateUpdateReqType_Id_CHARACTERS_SIZE 50 + EXTRA_CHAR 
#define dinCertificateUpdateReqType_ContractID_CHARACTERS_SIZE 24 + EXTRA_CHAR /* XML schema facet maxLength for urn:iso:15118:2:2010:MsgDataTypes,contractIDType is 24 */
#define dinCertificateUpdateReqType_DHParams_BYTES_SIZE 256 /* XML schema facet maxLength for urn:iso:15118:2:2010:MsgDataTypes,dHParamsType is 256 */
struct dinCertificateUpdateReqType {
	/* attribute: Id {http://www.w3.org/2001/XMLSchema,IDREF} */
	struct {
		exi_string_character_t characters[dinCertificateUpdateReqType_Id_CHARACTERS_SIZE];
		uint16_t charactersLen;
	}  Id ;
	unsigned int Id_isUsed:1;
	/* element: "urn:iso:15118:2:2010:MsgBody":ContractSignatureCertChain, Complex type name='urn:iso:15118:2:2010:MsgDataTypes,CertificateChainType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2010:MsgDataTypes":Certificate,"urn:iso:15118:2:2010:MsgDataTypes":SubCertificates{0-1})',  derivedBy='RESTRICTION'.  */
	struct dinCertificateChainType ContractSignatureCertChain ;
	/* element: "urn:iso:15118:2:2010:MsgBody":ContractID, urn:iso:15118:2:2010:MsgDataTypes,contractIDType */
	struct {
		exi_string_character_t characters[dinCertificateUpdateReqType_ContractID_CHARACTERS_SIZE];
		uint16_t charactersLen;
	}  ContractID ;
	/* element: "urn:iso:15118:2:2010:MsgBody":ListOfRootCertificateIDs, Complex type name='urn:iso:15118:2:2010:MsgDataTypes,ListOfRootCertificateIDsType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2010:MsgDataTypes":RootCertificateID{1-UNBOUNDED})',  derivedBy='RESTRICTION'.  */
	struct dinListOfRootCertificateIDsType ListOfRootCertificateIDs ;
	/* element: "urn:iso:15118:2:2010:MsgBody":DHParams, urn:iso:15118:2:2010:MsgDataTypes,dHParamsType */
	struct {
		uint8_t bytes[dinCertificateUpdateReqType_DHParams_BYTES_SIZE];
		uint16_t bytesLen;
	}  DHParams ;
};

/* Complex type name='urn:iso:15118:2:2010:MsgBody,ServicePaymentSelectionResType',  base type name='BodyBaseType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2010:MsgBody":ResponseCode)',  derivedBy='EXTENSION'.  */
struct dinServicePaymentSelectionResType {
	/* element: "urn:iso:15118:2:2010:MsgBody":ResponseCode, urn:iso:15118:2:2010:MsgDataTypes,responseCodeType */
	dinresponseCodeType ResponseCode ;
};

/* Complex type name='http://www.w3.org/2000/09/xmldsig#,KeyInfoType',  base type name='anyType',  content type='MIXED',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("http://www.w3.org/2000/09/xmldsig#":KeyName|"http://www.w3.org/2000/09/xmldsig#":KeyValue|"http://www.w3.org/2000/09/xmldsig#":RetrievalMethod|"http://www.w3.org/2000/09/xmldsig#":X509Data|"http://www.w3.org/2000/09/xmldsig#":PGPData|"http://www.w3.org/2000/09/xmldsig#":SPKIData|"http://www.w3.org/2000/09/xmldsig#":MgmtData|(WC[##other:"http://www.w3.org/2000/09/xmldsig#"])){1-UNBOUNDED}',  derivedBy='RESTRICTION'.  */
#define dinKeyInfoType_Id_CHARACTERS_SIZE 50 + EXTRA_CHAR 
#define dinKeyInfoType_KeyName_CHARACTERS_SIZE 50 + EXTRA_CHAR 
#define dinKeyInfoType_KeyName_ARRAY_SIZE 1
#define dinKeyInfoType_KeyValue_ARRAY_SIZE 1
#define dinKeyInfoType_RetrievalMethod_ARRAY_SIZE 1
#define dinKeyInfoType_X509Data_ARRAY_SIZE 1
#define dinKeyInfoType_PGPData_ARRAY_SIZE 1
#define dinKeyInfoType_SPKIData_ARRAY_SIZE 1
#define dinKeyInfoType_MgmtData_CHARACTERS_SIZE 50 + EXTRA_CHAR 
#define dinKeyInfoType_MgmtData_ARRAY_SIZE 1
#define dinKeyInfoType_ANY_CHARACTERS_SIZE 50 + EXTRA_CHAR 
struct dinKeyInfoType {
	/* attribute: Id {http://www.w3.org/2001/XMLSchema,ID} */
	struct {
		exi_string_character_t characters[dinKeyInfoType_Id_CHARACTERS_SIZE];
		uint16_t charactersLen;
	}  Id ;
	unsigned int Id_isUsed:1;
	/* element: "http://www.w3.org/2000/09/xmldsig#":KeyName, http://www.w3.org/2001/XMLSchema,string */
	struct {
		struct {
			exi_string_character_t characters[dinKeyInfoType_KeyName_CHARACTERS_SIZE];
			uint16_t charactersLen;
		}  array[dinKeyInfoType_KeyName_ARRAY_SIZE];
		uint16_t arrayLen;
	} KeyName;
	/* element: "http://www.w3.org/2000/09/xmldsig#":KeyValue, Complex type name='http://www.w3.org/2000/09/xmldsig#,KeyValueType',  base type name='anyType',  content type='MIXED',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("http://www.w3.org/2000/09/xmldsig#":DSAKeyValue|"http://www.w3.org/2000/09/xmldsig#":RSAKeyValue|(WC[##other:"http://www.w3.org/2000/09/xmldsig#"]))',  derivedBy='RESTRICTION'.  */
	struct {
		struct dinKeyValueType array[dinKeyInfoType_KeyValue_ARRAY_SIZE];
		uint16_t arrayLen;
	} KeyValue;
	/* element: "http://www.w3.org/2000/09/xmldsig#":RetrievalMethod, Complex type name='http://www.w3.org/2000/09/xmldsig#,RetrievalMethodType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("http://www.w3.org/2000/09/xmldsig#":Transforms{0-1})',  derivedBy='RESTRICTION'.  */
	struct {
		struct dinRetrievalMethodType array[dinKeyInfoType_RetrievalMethod_ARRAY_SIZE];
		uint16_t arrayLen;
	} RetrievalMethod;
	/* element: "http://www.w3.org/2000/09/xmldsig#":X509Data, Complex type name='http://www.w3.org/2000/09/xmldsig#,X509DataType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='(("http://www.w3.org/2000/09/xmldsig#":X509IssuerSerial|"http://www.w3.org/2000/09/xmldsig#":X509SKI|"http://www.w3.org/2000/09/xmldsig#":X509SubjectName|"http://www.w3.org/2000/09/xmldsig#":X509Certificate|"http://www.w3.org/2000/09/xmldsig#":X509CRL|(WC[##other:"http://www.w3.org/2000/09/xmldsig#"]))){1-UNBOUNDED}',  derivedBy='RESTRICTION'.  */
	struct {
		struct dinX509DataType array[dinKeyInfoType_X509Data_ARRAY_SIZE];
		uint16_t arrayLen;
	} X509Data;
	/* element: "http://www.w3.org/2000/09/xmldsig#":PGPData, Complex type name='http://www.w3.org/2000/09/xmldsig#,PGPDataType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='(("http://www.w3.org/2000/09/xmldsig#":PGPKeyID,"http://www.w3.org/2000/09/xmldsig#":PGPKeyPacket{0-1},(WC[##other:"http://www.w3.org/2000/09/xmldsig#"]){0-UNBOUNDED})|("http://www.w3.org/2000/09/xmldsig#":PGPKeyPacket,(WC[##other:"http://www.w3.org/2000/09/xmldsig#"]){0-UNBOUNDED}))',  derivedBy='RESTRICTION'.  */
	struct {
		struct dinPGPDataType array[dinKeyInfoType_PGPData_ARRAY_SIZE];
		uint16_t arrayLen;
	} PGPData;
	/* element: "http://www.w3.org/2000/09/xmldsig#":SPKIData, Complex type name='http://www.w3.org/2000/09/xmldsig#,SPKIDataType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("http://www.w3.org/2000/09/xmldsig#":SPKISexp,(WC[##other:"http://www.w3.org/2000/09/xmldsig#"]){0-1}){1-UNBOUNDED}',  derivedBy='RESTRICTION'.  */
	struct {
		struct dinSPKIDataType array[dinKeyInfoType_SPKIData_ARRAY_SIZE];
		uint16_t arrayLen;
	} SPKIData;
	/* element: "http://www.w3.org/2000/09/xmldsig#":MgmtData, http://www.w3.org/2001/XMLSchema,string */
	struct {
		struct {
			exi_string_character_t characters[dinKeyInfoType_MgmtData_CHARACTERS_SIZE];
			uint16_t charactersLen;
		}  array[dinKeyInfoType_MgmtData_ARRAY_SIZE];
		uint16_t arrayLen;
	} MgmtData;
	/* element: WC[##other:"http://www.w3.org/2000/09/xmldsig#"] */
	struct {
		exi_string_character_t characters[dinKeyInfoType_ANY_CHARACTERS_SIZE];
		uint16_t charactersLen;
	}  ANY ;
	unsigned int ANY_isUsed:1;
};

/* Complex type name='urn:iso:15118:2:2010:MsgBody,PaymentDetailsReqType',  base type name='BodyBaseType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2010:MsgBody":ContractID,"urn:iso:15118:2:2010:MsgBody":ContractSignatureCertChain)',  derivedBy='EXTENSION'.  */
#define dinPaymentDetailsReqType_ContractID_CHARACTERS_SIZE 24 + EXTRA_CHAR /* XML schema facet maxLength for urn:iso:15118:2:2010:MsgDataTypes,contractIDType is 24 */
struct dinPaymentDetailsReqType {
	/* element: "urn:iso:15118:2:2010:MsgBody":ContractID, urn:iso:15118:2:2010:MsgDataTypes,contractIDType */
	struct {
		exi_string_character_t characters[dinPaymentDetailsReqType_ContractID_CHARACTERS_SIZE];
		uint16_t charactersLen;
	}  ContractID ;
	/* element: "urn:iso:15118:2:2010:MsgBody":ContractSignatureCertChain, Complex type name='urn:iso:15118:2:2010:MsgDataTypes,CertificateChainType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2010:MsgDataTypes":Certificate,"urn:iso:15118:2:2010:MsgDataTypes":SubCertificates{0-1})',  derivedBy='RESTRICTION'.  */
	struct dinCertificateChainType ContractSignatureCertChain ;
};

/* Complex type name='urn:iso:15118:2:2010:MsgBody,CableCheckResType',  base type name='BodyBaseType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2010:MsgBody":ResponseCode,"urn:iso:15118:2:2010:MsgBody":DC_EVSEStatus,"urn:iso:15118:2:2010:MsgBody":EVSEProcessing)',  derivedBy='EXTENSION'.  */
struct dinCableCheckResType {
	/* element: "urn:iso:15118:2:2010:MsgBody":ResponseCode, urn:iso:15118:2:2010:MsgDataTypes,responseCodeType */
	dinresponseCodeType ResponseCode ;
	/* element: "urn:iso:15118:2:2010:MsgBody":DC_EVSEStatus, Complex type name='urn:iso:15118:2:2010:MsgDataTypes,DC_EVSEStatusType',  base type name='EVSEStatusType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2010:MsgDataTypes":EVSEIsolationStatus{0-1},"urn:iso:15118:2:2010:MsgDataTypes":EVSEStatusCode,"urn:iso:15118:2:2010:MsgDataTypes":NotificationMaxDelay,"urn:iso:15118:2:2010:MsgDataTypes":EVSENotification)',  derivedBy='EXTENSION'.  */
	struct dinDC_EVSEStatusType DC_EVSEStatus ;
	/* element: "urn:iso:15118:2:2010:MsgBody":EVSEProcessing, urn:iso:15118:2:2010:MsgDataTypes,EVSEProcessingType */
	dinEVSEProcessingType EVSEProcessing ;
};

/* Complex type name='urn:iso:15118:2:2010:MsgBody,CertificateInstallationResType',  base type name='BodyBaseType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2010:MsgBody":ResponseCode,"urn:iso:15118:2:2010:MsgBody":ContractSignatureCertChain,"urn:iso:15118:2:2010:MsgBody":ContractSignatureEncryptedPrivateKey,"urn:iso:15118:2:2010:MsgBody":DHParams,"urn:iso:15118:2:2010:MsgBody":ContractID)',  derivedBy='EXTENSION'.  */
#define dinCertificateInstallationResType_Id_CHARACTERS_SIZE 50 + EXTRA_CHAR 
#define dinCertificateInstallationResType_ContractSignatureEncryptedPrivateKey_BYTES_SIZE 128 /* XML schema facet maxLength for urn:iso:15118:2:2010:MsgDataTypes,privateKeyType is 128 */
#define dinCertificateInstallationResType_DHParams_BYTES_SIZE 256 /* XML schema facet maxLength for urn:iso:15118:2:2010:MsgDataTypes,dHParamsType is 256 */
#define dinCertificateInstallationResType_ContractID_CHARACTERS_SIZE 24 + EXTRA_CHAR /* XML schema facet maxLength for urn:iso:15118:2:2010:MsgDataTypes,contractIDType is 24 */
struct dinCertificateInstallationResType {
	/* attribute: Id {http://www.w3.org/2001/XMLSchema,IDREF} */
	struct {
		exi_string_character_t characters[dinCertificateInstallationResType_Id_CHARACTERS_SIZE];
		uint16_t charactersLen;
	}  Id ;
	/* element: "urn:iso:15118:2:2010:MsgBody":ResponseCode, urn:iso:15118:2:2010:MsgDataTypes,responseCodeType */
	dinresponseCodeType ResponseCode ;
	/* element: "urn:iso:15118:2:2010:MsgBody":ContractSignatureCertChain, Complex type name='urn:iso:15118:2:2010:MsgDataTypes,CertificateChainType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2010:MsgDataTypes":Certificate,"urn:iso:15118:2:2010:MsgDataTypes":SubCertificates{0-1})',  derivedBy='RESTRICTION'.  */
	struct dinCertificateChainType ContractSignatureCertChain ;
	/* element: "urn:iso:15118:2:2010:MsgBody":ContractSignatureEncryptedPrivateKey, urn:iso:15118:2:2010:MsgDataTypes,privateKeyType */
	struct {
		uint8_t bytes[dinCertificateInstallationResType_ContractSignatureEncryptedPrivateKey_BYTES_SIZE];
		uint16_t bytesLen;
	}  ContractSignatureEncryptedPrivateKey ;
	/* element: "urn:iso:15118:2:2010:MsgBody":DHParams, urn:iso:15118:2:2010:MsgDataTypes,dHParamsType */
	struct {
		uint8_t bytes[dinCertificateInstallationResType_DHParams_BYTES_SIZE];
		uint16_t bytesLen;
	}  DHParams ;
	/* element: "urn:iso:15118:2:2010:MsgBody":ContractID, urn:iso:15118:2:2010:MsgDataTypes,contractIDType */
	struct {
		exi_string_character_t characters[dinCertificateInstallationResType_ContractID_CHARACTERS_SIZE];
		uint16_t charactersLen;
	}  ContractID ;
};

/* Complex type name='urn:iso:15118:2:2010:MsgBody,ServiceDetailResType',  base type name='BodyBaseType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2010:MsgBody":ResponseCode,"urn:iso:15118:2:2010:MsgBody":ServiceID,"urn:iso:15118:2:2010:MsgBody":ServiceParameterList{0-1})',  derivedBy='EXTENSION'.  */
struct dinServiceDetailResType {
	/* element: "urn:iso:15118:2:2010:MsgBody":ResponseCode, urn:iso:15118:2:2010:MsgDataTypes,responseCodeType */
	dinresponseCodeType ResponseCode ;
	/* element: "urn:iso:15118:2:2010:MsgBody":ServiceID, urn:iso:15118:2:2010:MsgDataTypes,serviceIDType */
	uint16_t ServiceID ;
	/* element: "urn:iso:15118:2:2010:MsgBody":ServiceParameterList, Complex type name='urn:iso:15118:2:2010:MsgDataTypes,ServiceParameterListType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2010:MsgDataTypes":ParameterSet{1-UNBOUNDED})',  derivedBy='RESTRICTION'.  */
	struct dinServiceParameterListType ServiceParameterList ;
	unsigned int ServiceParameterList_isUsed:1;
};

/* Complex type name='urn:iso:15118:2:2010:MsgBody,CertificateUpdateResType',  base type name='BodyBaseType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2010:MsgBody":ResponseCode,"urn:iso:15118:2:2010:MsgBody":ContractSignatureCertChain,"urn:iso:15118:2:2010:MsgBody":ContractSignatureEncryptedPrivateKey,"urn:iso:15118:2:2010:MsgBody":DHParams,"urn:iso:15118:2:2010:MsgBody":ContractID,"urn:iso:15118:2:2010:MsgBody":RetryCounter)',  derivedBy='EXTENSION'.  */
#define dinCertificateUpdateResType_Id_CHARACTERS_SIZE 50 + EXTRA_CHAR 
#define dinCertificateUpdateResType_ContractSignatureEncryptedPrivateKey_BYTES_SIZE 128 /* XML schema facet maxLength for urn:iso:15118:2:2010:MsgDataTypes,privateKeyType is 128 */
#define dinCertificateUpdateResType_DHParams_BYTES_SIZE 256 /* XML schema facet maxLength for urn:iso:15118:2:2010:MsgDataTypes,dHParamsType is 256 */
#define dinCertificateUpdateResType_ContractID_CHARACTERS_SIZE 24 + EXTRA_CHAR /* XML schema facet maxLength for urn:iso:15118:2:2010:MsgDataTypes,contractIDType is 24 */
struct dinCertificateUpdateResType {
	/* attribute: Id {http://www.w3.org/2001/XMLSchema,IDREF} */
	struct {
		exi_string_character_t characters[dinCertificateUpdateResType_Id_CHARACTERS_SIZE];
		uint16_t charactersLen;
	}  Id ;
	/* element: "urn:iso:15118:2:2010:MsgBody":ResponseCode, urn:iso:15118:2:2010:MsgDataTypes,responseCodeType */
	dinresponseCodeType ResponseCode ;
	/* element: "urn:iso:15118:2:2010:MsgBody":ContractSignatureCertChain, Complex type name='urn:iso:15118:2:2010:MsgDataTypes,CertificateChainType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2010:MsgDataTypes":Certificate,"urn:iso:15118:2:2010:MsgDataTypes":SubCertificates{0-1})',  derivedBy='RESTRICTION'.  */
	struct dinCertificateChainType ContractSignatureCertChain ;
	/* element: "urn:iso:15118:2:2010:MsgBody":ContractSignatureEncryptedPrivateKey, urn:iso:15118:2:2010:MsgDataTypes,privateKeyType */
	struct {
		uint8_t bytes[dinCertificateUpdateResType_ContractSignatureEncryptedPrivateKey_BYTES_SIZE];
		uint16_t bytesLen;
	}  ContractSignatureEncryptedPrivateKey ;
	/* element: "urn:iso:15118:2:2010:MsgBody":DHParams, urn:iso:15118:2:2010:MsgDataTypes,dHParamsType */
	struct {
		uint8_t bytes[dinCertificateUpdateResType_DHParams_BYTES_SIZE];
		uint16_t bytesLen;
	}  DHParams ;
	/* element: "urn:iso:15118:2:2010:MsgBody":ContractID, urn:iso:15118:2:2010:MsgDataTypes,contractIDType */
	struct {
		exi_string_character_t characters[dinCertificateUpdateResType_ContractID_CHARACTERS_SIZE];
		uint16_t charactersLen;
	}  ContractID ;
	/* element: "urn:iso:15118:2:2010:MsgBody":RetryCounter, http://www.w3.org/2001/XMLSchema,short */
	int16_t RetryCounter ;
};

/* Complex type name='urn:iso:15118:2:2010:MsgDataTypes,SalesTariffEntryType',  base type name='EntryType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='(("urn:iso:15118:2:2010:MsgDataTypes":TimeInterval),("urn:iso:15118:2:2010:MsgDataTypes":EPriceLevel,"urn:iso:15118:2:2010:MsgDataTypes":ConsumptionCost{0-UNBOUNDED}))',  derivedBy='EXTENSION'.  */
#define dinSalesTariffEntryType_ConsumptionCost_ARRAY_SIZE 5
struct dinSalesTariffEntryType {
	/* element: "urn:iso:15118:2:2010:MsgDataTypes":TimeInterval, Complex type name='urn:iso:15118:2:2010:MsgDataTypes,IntervalType',  base type name='anyType',  content type='EMPTY',  isAbstract='true',  hasTypeId='false',  final='0',  block='0',  derivedBy='RESTRICTION'.  */
	struct dinIntervalType TimeInterval ;
	unsigned int TimeInterval_isUsed:1;
	/* element: "urn:iso:15118:2:2010:MsgDataTypes":RelativeTimeInterval, Complex type name='urn:iso:15118:2:2010:MsgDataTypes,RelativeTimeIntervalType',  base type name='IntervalType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2010:MsgDataTypes":start,"urn:iso:15118:2:2010:MsgDataTypes":duration{0-1})',  derivedBy='EXTENSION'.  */
	struct dinRelativeTimeIntervalType RelativeTimeInterval ;
	unsigned int RelativeTimeInterval_isUsed:1;
	/* element: "urn:iso:15118:2:2010:MsgDataTypes":EPriceLevel, http://www.w3.org/2001/XMLSchema,unsignedByte */
	uint8_t EPriceLevel ;
	/* element: "urn:iso:15118:2:2010:MsgDataTypes":ConsumptionCost, Complex type name='urn:iso:15118:2:2010:MsgDataTypes,ConsumptionCostType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2010:MsgDataTypes":startValue,"urn:iso:15118:2:2010:MsgDataTypes":Cost{0-UNBOUNDED})',  derivedBy='RESTRICTION'.  */
	struct {
		struct dinConsumptionCostType array[dinSalesTariffEntryType_ConsumptionCost_ARRAY_SIZE];
		uint16_t arrayLen;
	} ConsumptionCost;
};

/* Complex type name='urn:iso:15118:2:2010:MsgBody,ServiceDiscoveryResType',  base type name='BodyBaseType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2010:MsgBody":ResponseCode,"urn:iso:15118:2:2010:MsgBody":PaymentOptions,"urn:iso:15118:2:2010:MsgBody":ChargeService,"urn:iso:15118:2:2010:MsgBody":ServiceList{0-1})',  derivedBy='EXTENSION'.  */
struct dinServiceDiscoveryResType {
	/* element: "urn:iso:15118:2:2010:MsgBody":ResponseCode, urn:iso:15118:2:2010:MsgDataTypes,responseCodeType */
	dinresponseCodeType ResponseCode ;
	/* element: "urn:iso:15118:2:2010:MsgBody":PaymentOptions, Complex type name='urn:iso:15118:2:2010:MsgDataTypes,PaymentOptionsType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2010:MsgDataTypes":PaymentOption{1-UNBOUNDED})',  derivedBy='RESTRICTION'.  */
	struct dinPaymentOptionsType PaymentOptions ;
	/* element: "urn:iso:15118:2:2010:MsgBody":ChargeService, Complex type name='urn:iso:15118:2:2010:MsgDataTypes,ServiceChargeType',  base type name='ServiceType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='(("urn:iso:15118:2:2010:MsgDataTypes":ServiceTag,"urn:iso:15118:2:2010:MsgDataTypes":FreeService),("urn:iso:15118:2:2010:MsgDataTypes":EnergyTransferType))',  derivedBy='EXTENSION'.  */
	struct dinServiceChargeType ChargeService ;
	/* element: "urn:iso:15118:2:2010:MsgBody":ServiceList, Complex type name='urn:iso:15118:2:2010:MsgDataTypes,ServiceTagListType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2010:MsgDataTypes":Service{1-UNBOUNDED})',  derivedBy='RESTRICTION'.  */
	struct dinServiceTagListType ServiceList ;
	unsigned int ServiceList_isUsed:1;
};

/* Complex type name='http://www.w3.org/2000/09/xmldsig#,SignatureType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("http://www.w3.org/2000/09/xmldsig#":SignedInfo,"http://www.w3.org/2000/09/xmldsig#":SignatureValue,"http://www.w3.org/2000/09/xmldsig#":KeyInfo{0-1},"http://www.w3.org/2000/09/xmldsig#":Object{0-UNBOUNDED})',  derivedBy='RESTRICTION'.  */
#define dinSignatureType_Id_CHARACTERS_SIZE 50 + EXTRA_CHAR 
#define dinSignatureType_Object_ARRAY_SIZE 1
struct dinSignatureType {
	/* attribute: Id {http://www.w3.org/2001/XMLSchema,ID} */
	struct {
		exi_string_character_t characters[dinSignatureType_Id_CHARACTERS_SIZE];
		uint16_t charactersLen;
	}  Id ;
	unsigned int Id_isUsed:1;
	/* element: "http://www.w3.org/2000/09/xmldsig#":SignedInfo, Complex type name='http://www.w3.org/2000/09/xmldsig#,SignedInfoType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("http://www.w3.org/2000/09/xmldsig#":CanonicalizationMethod,"http://www.w3.org/2000/09/xmldsig#":SignatureMethod,"http://www.w3.org/2000/09/xmldsig#":Reference{1-UNBOUNDED})',  derivedBy='RESTRICTION'.  */
	struct dinSignedInfoType SignedInfo ;
	/* element: "http://www.w3.org/2000/09/xmldsig#":SignatureValue, Complex type name='http://www.w3.org/2000/09/xmldsig#,SignatureValueType',  base type name='base64Binary',  content type='SIMPLE',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  derivedBy='EXTENSION'.  */
	struct dinSignatureValueType SignatureValue ;
	/* element: "http://www.w3.org/2000/09/xmldsig#":KeyInfo, Complex type name='http://www.w3.org/2000/09/xmldsig#,KeyInfoType',  base type name='anyType',  content type='MIXED',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("http://www.w3.org/2000/09/xmldsig#":KeyName|"http://www.w3.org/2000/09/xmldsig#":KeyValue|"http://www.w3.org/2000/09/xmldsig#":RetrievalMethod|"http://www.w3.org/2000/09/xmldsig#":X509Data|"http://www.w3.org/2000/09/xmldsig#":PGPData|"http://www.w3.org/2000/09/xmldsig#":SPKIData|"http://www.w3.org/2000/09/xmldsig#":MgmtData|(WC[##other:"http://www.w3.org/2000/09/xmldsig#"])){1-UNBOUNDED}',  derivedBy='RESTRICTION'.  */
	struct dinKeyInfoType KeyInfo ;
	unsigned int KeyInfo_isUsed:1;
	/* element: "http://www.w3.org/2000/09/xmldsig#":Object, Complex type name='http://www.w3.org/2000/09/xmldsig#,ObjectType',  base type name='anyType',  content type='MIXED',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='((WC[##any])){0-UNBOUNDED}',  derivedBy='RESTRICTION'.  */
	struct {
		struct dinObjectType array[dinSignatureType_Object_ARRAY_SIZE];
		uint16_t arrayLen;
	} Object;
};

/* Complex type name='urn:iso:15118:2:2010:MsgDataTypes,SalesTariffType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2010:MsgDataTypes":SalesTariffID,"urn:iso:15118:2:2010:MsgDataTypes":SalesTariffDescription{0-1},"urn:iso:15118:2:2010:MsgDataTypes":NumEPriceLevels,"urn:iso:15118:2:2010:MsgDataTypes":SalesTariffEntry{1-UNBOUNDED})',  derivedBy='RESTRICTION'.  */
#define dinSalesTariffType_Id_CHARACTERS_SIZE 50 + EXTRA_CHAR 
#define dinSalesTariffType_SalesTariffDescription_CHARACTERS_SIZE 32 + EXTRA_CHAR /* XML schema facet maxLength for urn:iso:15118:2:2010:MsgDataTypes,tariffDescriptionType is 32 */
#define dinSalesTariffType_SalesTariffEntry_ARRAY_SIZE 5
struct dinSalesTariffType {
	/* attribute: Id {http://www.w3.org/2001/XMLSchema,IDREF} */
	struct {
		exi_string_character_t characters[dinSalesTariffType_Id_CHARACTERS_SIZE];
		uint16_t charactersLen;
	}  Id ;
	/* element: "urn:iso:15118:2:2010:MsgDataTypes":SalesTariffID, urn:iso:15118:2:2010:MsgDataTypes,SAIDType */
	int16_t SalesTariffID ;
	/* element: "urn:iso:15118:2:2010:MsgDataTypes":SalesTariffDescription, urn:iso:15118:2:2010:MsgDataTypes,tariffDescriptionType */
	struct {
		exi_string_character_t characters[dinSalesTariffType_SalesTariffDescription_CHARACTERS_SIZE];
		uint16_t charactersLen;
	}  SalesTariffDescription ;
	unsigned int SalesTariffDescription_isUsed:1;
	/* element: "urn:iso:15118:2:2010:MsgDataTypes":NumEPriceLevels, http://www.w3.org/2001/XMLSchema,unsignedByte */
	uint8_t NumEPriceLevels ;
	/* element: "urn:iso:15118:2:2010:MsgDataTypes":SalesTariffEntry, Complex type name='urn:iso:15118:2:2010:MsgDataTypes,SalesTariffEntryType',  base type name='EntryType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='(("urn:iso:15118:2:2010:MsgDataTypes":TimeInterval),("urn:iso:15118:2:2010:MsgDataTypes":EPriceLevel,"urn:iso:15118:2:2010:MsgDataTypes":ConsumptionCost{0-UNBOUNDED}))',  derivedBy='EXTENSION'.  */
	struct {
		struct dinSalesTariffEntryType array[dinSalesTariffType_SalesTariffEntry_ARRAY_SIZE];
		uint16_t arrayLen;
	} SalesTariffEntry;
};

/* Complex type name='urn:iso:15118:2:2010:MsgHeader,MessageHeaderType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2010:MsgHeader":SessionID,"urn:iso:15118:2:2010:MsgHeader":Notification{0-1},"http://www.w3.org/2000/09/xmldsig#":Signature{0-1})',  derivedBy='RESTRICTION'.  */
#define dinMessageHeaderType_SessionID_BYTES_SIZE 8 /* XML schema facet length for urn:iso:15118:2:2010:MsgDataTypes,sessionIDType is 8 */
struct dinMessageHeaderType {
	/* element: "urn:iso:15118:2:2010:MsgHeader":SessionID, urn:iso:15118:2:2010:MsgDataTypes,sessionIDType */
	struct {
		uint8_t bytes[dinMessageHeaderType_SessionID_BYTES_SIZE];
		uint16_t bytesLen;
	}  SessionID ;
	/* element: "urn:iso:15118:2:2010:MsgHeader":Notification, Complex type name='urn:iso:15118:2:2010:MsgDataTypes,NotificationType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2010:MsgDataTypes":FaultCode,"urn:iso:15118:2:2010:MsgDataTypes":FaultMsg{0-1})',  derivedBy='RESTRICTION'.  */
	struct dinNotificationType Notification ;
	unsigned int Notification_isUsed:1;
	/* element: "http://www.w3.org/2000/09/xmldsig#":Signature, Complex type name='http://www.w3.org/2000/09/xmldsig#,SignatureType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("http://www.w3.org/2000/09/xmldsig#":SignedInfo,"http://www.w3.org/2000/09/xmldsig#":SignatureValue,"http://www.w3.org/2000/09/xmldsig#":KeyInfo{0-1},"http://www.w3.org/2000/09/xmldsig#":Object{0-UNBOUNDED})',  derivedBy='RESTRICTION'.  */
	struct dinSignatureType Signature ;
	unsigned int Signature_isUsed:1;
};

/* Complex type name='urn:iso:15118:2:2010:MsgDataTypes,SAScheduleTupleType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2010:MsgDataTypes":SAScheduleTupleID,"urn:iso:15118:2:2010:MsgDataTypes":PMaxSchedule,"urn:iso:15118:2:2010:MsgDataTypes":SalesTariff{0-1})',  derivedBy='RESTRICTION'.  */
struct dinSAScheduleTupleType {
	/* element: "urn:iso:15118:2:2010:MsgDataTypes":SAScheduleTupleID, urn:iso:15118:2:2010:MsgDataTypes,SAIDType */
	int16_t SAScheduleTupleID ;
	/* element: "urn:iso:15118:2:2010:MsgDataTypes":PMaxSchedule, Complex type name='urn:iso:15118:2:2010:MsgDataTypes,PMaxScheduleType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2010:MsgDataTypes":PMaxScheduleID,"urn:iso:15118:2:2010:MsgDataTypes":PMaxScheduleEntry{1-UNBOUNDED})',  derivedBy='RESTRICTION'.  */
	struct dinPMaxScheduleType PMaxSchedule ;
	/* element: "urn:iso:15118:2:2010:MsgDataTypes":SalesTariff, Complex type name='urn:iso:15118:2:2010:MsgDataTypes,SalesTariffType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2010:MsgDataTypes":SalesTariffID,"urn:iso:15118:2:2010:MsgDataTypes":SalesTariffDescription{0-1},"urn:iso:15118:2:2010:MsgDataTypes":NumEPriceLevels,"urn:iso:15118:2:2010:MsgDataTypes":SalesTariffEntry{1-UNBOUNDED})',  derivedBy='RESTRICTION'.  */
	struct dinSalesTariffType SalesTariff ;
	unsigned int SalesTariff_isUsed:1;
};

/* Complex type name='urn:iso:15118:2:2010:MsgDataTypes,SAScheduleListType',  base type name='SASchedulesType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2010:MsgDataTypes":SAScheduleTuple{1-UNBOUNDED})',  derivedBy='EXTENSION'.  */
#define dinSAScheduleListType_SAScheduleTuple_ARRAY_SIZE 5
struct dinSAScheduleListType {
	/* element: "urn:iso:15118:2:2010:MsgDataTypes":SAScheduleTuple, Complex type name='urn:iso:15118:2:2010:MsgDataTypes,SAScheduleTupleType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2010:MsgDataTypes":SAScheduleTupleID,"urn:iso:15118:2:2010:MsgDataTypes":PMaxSchedule,"urn:iso:15118:2:2010:MsgDataTypes":SalesTariff{0-1})',  derivedBy='RESTRICTION'.  */
	struct {
		struct dinSAScheduleTupleType array[dinSAScheduleListType_SAScheduleTuple_ARRAY_SIZE];
		uint16_t arrayLen;
	} SAScheduleTuple;
};

/* Complex type name='urn:iso:15118:2:2010:MsgBody,ChargeParameterDiscoveryResType',  base type name='BodyBaseType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2010:MsgBody":ResponseCode,"urn:iso:15118:2:2010:MsgBody":EVSEProcessing,"urn:iso:15118:2:2010:MsgDataTypes":SASchedules,"urn:iso:15118:2:2010:MsgDataTypes":EVSEChargeParameter)',  derivedBy='EXTENSION'.  */
struct dinChargeParameterDiscoveryResType {
	/* element: "urn:iso:15118:2:2010:MsgBody":ResponseCode, urn:iso:15118:2:2010:MsgDataTypes,responseCodeType */
	dinresponseCodeType ResponseCode ;
	/* element: "urn:iso:15118:2:2010:MsgBody":EVSEProcessing, urn:iso:15118:2:2010:MsgDataTypes,EVSEProcessingType */
	dinEVSEProcessingType EVSEProcessing ;
	/* element: "urn:iso:15118:2:2010:MsgDataTypes":SASchedules, Complex type name='urn:iso:15118:2:2010:MsgDataTypes,SASchedulesType',  base type name='anyType',  content type='EMPTY',  isAbstract='true',  hasTypeId='false',  final='0',  block='0',  derivedBy='RESTRICTION'.  */
	struct dinSASchedulesType SASchedules ;
	unsigned int SASchedules_isUsed:1;
	/* element: "urn:iso:15118:2:2010:MsgDataTypes":SAScheduleList, Complex type name='urn:iso:15118:2:2010:MsgDataTypes,SAScheduleListType',  base type name='SASchedulesType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2010:MsgDataTypes":SAScheduleTuple{1-UNBOUNDED})',  derivedBy='EXTENSION'.  */
	struct dinSAScheduleListType SAScheduleList ;
	unsigned int SAScheduleList_isUsed:1;
	/* element: "urn:iso:15118:2:2010:MsgDataTypes":EVSEChargeParameter, Complex type name='urn:iso:15118:2:2010:MsgDataTypes,EVSEChargeParameterType',  base type name='anyType',  content type='EMPTY',  isAbstract='true',  hasTypeId='false',  final='0',  block='0',  derivedBy='RESTRICTION'.  */
	struct dinEVSEChargeParameterType EVSEChargeParameter ;
	unsigned int EVSEChargeParameter_isUsed:1;
	/* element: "urn:iso:15118:2:2010:MsgDataTypes":AC_EVSEChargeParameter, Complex type name='urn:iso:15118:2:2010:MsgDataTypes,AC_EVSEChargeParameterType',  base type name='EVSEChargeParameterType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2010:MsgDataTypes":AC_EVSEStatus,"urn:iso:15118:2:2010:MsgDataTypes":EVSEMaxVoltage,"urn:iso:15118:2:2010:MsgDataTypes":EVSEMaxCurrent,"urn:iso:15118:2:2010:MsgDataTypes":EVSEMinCurrent)',  derivedBy='EXTENSION'.  */
	struct dinAC_EVSEChargeParameterType AC_EVSEChargeParameter ;
	unsigned int AC_EVSEChargeParameter_isUsed:1;
	/* element: "urn:iso:15118:2:2010:MsgDataTypes":DC_EVSEChargeParameter, Complex type name='urn:iso:15118:2:2010:MsgDataTypes,DC_EVSEChargeParameterType',  base type name='EVSEChargeParameterType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2010:MsgDataTypes":DC_EVSEStatus,"urn:iso:15118:2:2010:MsgDataTypes":EVSEMaximumCurrentLimit,"urn:iso:15118:2:2010:MsgDataTypes":EVSEMaximumPowerLimit{0-1},"urn:iso:15118:2:2010:MsgDataTypes":EVSEMaximumVoltageLimit,"urn:iso:15118:2:2010:MsgDataTypes":EVSEMinimumCurrentLimit,"urn:iso:15118:2:2010:MsgDataTypes":EVSEMinimumVoltageLimit,"urn:iso:15118:2:2010:MsgDataTypes":EVSECurrentRegulationTolerance{0-1},"urn:iso:15118:2:2010:MsgDataTypes":EVSEPeakCurrentRipple,"urn:iso:15118:2:2010:MsgDataTypes":EVSEEnergyToBeDelivered{0-1})',  derivedBy='EXTENSION'.  */
	struct dinDC_EVSEChargeParameterType DC_EVSEChargeParameter ;
	unsigned int DC_EVSEChargeParameter_isUsed:1;
};

/* Complex type name='urn:iso:15118:2:2010:MsgDef,BodyType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2010:MsgDef":BodyElement{0-1})',  derivedBy='RESTRICTION'.  */
struct dinBodyType {
	/* substitutionGroup */
#if SAVE_MEMORY_WITH_UNNAMED_UNION == UNION_YES
	union {
#endif /* SAVE_MEMORY_WITH_UNNAMED_UNION == UNION_YES */ 
		/* element: "urn:iso:15118:2:2010:MsgDef":BodyElement, Complex type name='urn:iso:15118:2:2010:MsgDef,BodyBaseType',  base type name='anyType',  content type='EMPTY',  isAbstract='true',  hasTypeId='false',  final='0',  block='0',  derivedBy='RESTRICTION'.  */
		struct dinBodyBaseType BodyElement ;
		/* element: "urn:iso:15118:2:2010:MsgBody":SessionSetupReq, Complex type name='urn:iso:15118:2:2010:MsgBody,SessionSetupReqType',  base type name='BodyBaseType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2010:MsgBody":EVCCID)',  derivedBy='EXTENSION'.  */
		struct dinSessionSetupReqType SessionSetupReq ;
		/* element: "urn:iso:15118:2:2010:MsgBody":SessionSetupRes, Complex type name='urn:iso:15118:2:2010:MsgBody,SessionSetupResType',  base type name='BodyBaseType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2010:MsgBody":ResponseCode,"urn:iso:15118:2:2010:MsgBody":EVSEID,"urn:iso:15118:2:2010:MsgBody":DateTimeNow{0-1})',  derivedBy='EXTENSION'.  */
		struct dinSessionSetupResType SessionSetupRes ;
		/* element: "urn:iso:15118:2:2010:MsgBody":ServiceDiscoveryReq, Complex type name='urn:iso:15118:2:2010:MsgBody,ServiceDiscoveryReqType',  base type name='BodyBaseType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2010:MsgBody":ServiceScope{0-1},"urn:iso:15118:2:2010:MsgBody":ServiceCategory{0-1})',  derivedBy='EXTENSION'.  */
		struct dinServiceDiscoveryReqType ServiceDiscoveryReq ;
		/* element: "urn:iso:15118:2:2010:MsgBody":ServiceDiscoveryRes, Complex type name='urn:iso:15118:2:2010:MsgBody,ServiceDiscoveryResType',  base type name='BodyBaseType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2010:MsgBody":ResponseCode,"urn:iso:15118:2:2010:MsgBody":PaymentOptions,"urn:iso:15118:2:2010:MsgBody":ChargeService,"urn:iso:15118:2:2010:MsgBody":ServiceList{0-1})',  derivedBy='EXTENSION'.  */
		struct dinServiceDiscoveryResType ServiceDiscoveryRes ;
		/* element: "urn:iso:15118:2:2010:MsgBody":ServiceDetailReq, Complex type name='urn:iso:15118:2:2010:MsgBody,ServiceDetailReqType',  base type name='BodyBaseType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2010:MsgBody":ServiceID)',  derivedBy='EXTENSION'.  */
		struct dinServiceDetailReqType ServiceDetailReq ;
		/* element: "urn:iso:15118:2:2010:MsgBody":ServiceDetailRes, Complex type name='urn:iso:15118:2:2010:MsgBody,ServiceDetailResType',  base type name='BodyBaseType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2010:MsgBody":ResponseCode,"urn:iso:15118:2:2010:MsgBody":ServiceID,"urn:iso:15118:2:2010:MsgBody":ServiceParameterList{0-1})',  derivedBy='EXTENSION'.  */
		struct dinServiceDetailResType ServiceDetailRes ;
		/* element: "urn:iso:15118:2:2010:MsgBody":ServicePaymentSelectionReq, Complex type name='urn:iso:15118:2:2010:MsgBody,ServicePaymentSelectionReqType',  base type name='BodyBaseType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2010:MsgBody":SelectedPaymentOption,"urn:iso:15118:2:2010:MsgBody":SelectedServiceList)',  derivedBy='EXTENSION'.  */
		struct dinServicePaymentSelectionReqType ServicePaymentSelectionReq ;
		/* element: "urn:iso:15118:2:2010:MsgBody":ServicePaymentSelectionRes, Complex type name='urn:iso:15118:2:2010:MsgBody,ServicePaymentSelectionResType',  base type name='BodyBaseType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2010:MsgBody":ResponseCode)',  derivedBy='EXTENSION'.  */
		struct dinServicePaymentSelectionResType ServicePaymentSelectionRes ;
		/* element: "urn:iso:15118:2:2010:MsgBody":PaymentDetailsReq, Complex type name='urn:iso:15118:2:2010:MsgBody,PaymentDetailsReqType',  base type name='BodyBaseType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2010:MsgBody":ContractID,"urn:iso:15118:2:2010:MsgBody":ContractSignatureCertChain)',  derivedBy='EXTENSION'.  */
		struct dinPaymentDetailsReqType PaymentDetailsReq ;
		/* element: "urn:iso:15118:2:2010:MsgBody":PaymentDetailsRes, Complex type name='urn:iso:15118:2:2010:MsgBody,PaymentDetailsResType',  base type name='BodyBaseType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2010:MsgBody":ResponseCode,"urn:iso:15118:2:2010:MsgBody":GenChallenge,"urn:iso:15118:2:2010:MsgBody":DateTimeNow)',  derivedBy='EXTENSION'.  */
		struct dinPaymentDetailsResType PaymentDetailsRes ;
		/* element: "urn:iso:15118:2:2010:MsgBody":ContractAuthenticationReq, Complex type name='urn:iso:15118:2:2010:MsgBody,ContractAuthenticationReqType',  base type name='BodyBaseType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2010:MsgBody":GenChallenge{0-1})',  derivedBy='EXTENSION'.  */
		struct dinContractAuthenticationReqType ContractAuthenticationReq ;
		/* element: "urn:iso:15118:2:2010:MsgBody":ContractAuthenticationRes, Complex type name='urn:iso:15118:2:2010:MsgBody,ContractAuthenticationResType',  base type name='BodyBaseType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2010:MsgBody":ResponseCode,"urn:iso:15118:2:2010:MsgBody":EVSEProcessing)',  derivedBy='EXTENSION'.  */
		struct dinContractAuthenticationResType ContractAuthenticationRes ;
		/* element: "urn:iso:15118:2:2010:MsgBody":ChargeParameterDiscoveryReq, Complex type name='urn:iso:15118:2:2010:MsgBody,ChargeParameterDiscoveryReqType',  base type name='BodyBaseType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2010:MsgBody":EVRequestedEnergyTransferType,"urn:iso:15118:2:2010:MsgDataTypes":EVChargeParameter)',  derivedBy='EXTENSION'.  */
		struct dinChargeParameterDiscoveryReqType ChargeParameterDiscoveryReq ;
		/* element: "urn:iso:15118:2:2010:MsgBody":ChargeParameterDiscoveryRes, Complex type name='urn:iso:15118:2:2010:MsgBody,ChargeParameterDiscoveryResType',  base type name='BodyBaseType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2010:MsgBody":ResponseCode,"urn:iso:15118:2:2010:MsgBody":EVSEProcessing,"urn:iso:15118:2:2010:MsgDataTypes":SASchedules,"urn:iso:15118:2:2010:MsgDataTypes":EVSEChargeParameter)',  derivedBy='EXTENSION'.  */
		struct dinChargeParameterDiscoveryResType ChargeParameterDiscoveryRes ;
		/* element: "urn:iso:15118:2:2010:MsgBody":PowerDeliveryReq, Complex type name='urn:iso:15118:2:2010:MsgBody,PowerDeliveryReqType',  base type name='BodyBaseType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2010:MsgBody":ReadyToChargeState,"urn:iso:15118:2:2010:MsgBody":ChargingProfile{0-1},"urn:iso:15118:2:2010:MsgDataTypes":EVPowerDeliveryParameter{0-1})',  derivedBy='EXTENSION'.  */
		struct dinPowerDeliveryReqType PowerDeliveryReq ;
		/* element: "urn:iso:15118:2:2010:MsgBody":PowerDeliveryRes, Complex type name='urn:iso:15118:2:2010:MsgBody,PowerDeliveryResType',  base type name='BodyBaseType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2010:MsgBody":ResponseCode,"urn:iso:15118:2:2010:MsgDataTypes":EVSEStatus)',  derivedBy='EXTENSION'.  */
		struct dinPowerDeliveryResType PowerDeliveryRes ;
		/* element: "urn:iso:15118:2:2010:MsgBody":ChargingStatusReq, Complex type name='urn:iso:15118:2:2010:MsgBody,ChargingStatusReqType',  base type name='BodyBaseType',  content type='EMPTY',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  derivedBy='EXTENSION'.  */
		struct dinChargingStatusReqType ChargingStatusReq ;
		/* element: "urn:iso:15118:2:2010:MsgBody":ChargingStatusRes, Complex type name='urn:iso:15118:2:2010:MsgBody,ChargingStatusResType',  base type name='BodyBaseType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2010:MsgBody":ResponseCode,"urn:iso:15118:2:2010:MsgBody":EVSEID,"urn:iso:15118:2:2010:MsgBody":SAScheduleTupleID,"urn:iso:15118:2:2010:MsgBody":EVSEMaxCurrent{0-1},"urn:iso:15118:2:2010:MsgBody":MeterInfo{0-1},"urn:iso:15118:2:2010:MsgBody":ReceiptRequired,"urn:iso:15118:2:2010:MsgBody":AC_EVSEStatus)',  derivedBy='EXTENSION'.  */
		struct dinChargingStatusResType ChargingStatusRes ;
		/* element: "urn:iso:15118:2:2010:MsgBody":MeteringReceiptReq, Complex type name='urn:iso:15118:2:2010:MsgBody,MeteringReceiptReqType',  base type name='BodyBaseType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2010:MsgBody":SessionID,"urn:iso:15118:2:2010:MsgBody":SAScheduleTupleID{0-1},"urn:iso:15118:2:2010:MsgBody":MeterInfo)',  derivedBy='EXTENSION'.  */
		struct dinMeteringReceiptReqType MeteringReceiptReq ;
		/* element: "urn:iso:15118:2:2010:MsgBody":MeteringReceiptRes, Complex type name='urn:iso:15118:2:2010:MsgBody,MeteringReceiptResType',  base type name='BodyBaseType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2010:MsgBody":ResponseCode,"urn:iso:15118:2:2010:MsgBody":AC_EVSEStatus)',  derivedBy='EXTENSION'.  */
		struct dinMeteringReceiptResType MeteringReceiptRes ;
		/* element: "urn:iso:15118:2:2010:MsgBody":SessionStopReq, Complex type name='urn:iso:15118:2:2010:MsgBody,SessionStopType',  base type name='BodyBaseType',  content type='EMPTY',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  derivedBy='EXTENSION'.  */
		struct dinSessionStopType SessionStopReq ;
		/* element: "urn:iso:15118:2:2010:MsgBody":SessionStopRes, Complex type name='urn:iso:15118:2:2010:MsgBody,SessionStopResType',  base type name='BodyBaseType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2010:MsgBody":ResponseCode)',  derivedBy='EXTENSION'.  */
		struct dinSessionStopResType SessionStopRes ;
		/* element: "urn:iso:15118:2:2010:MsgBody":CertificateUpdateReq, Complex type name='urn:iso:15118:2:2010:MsgBody,CertificateUpdateReqType',  base type name='BodyBaseType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2010:MsgBody":ContractSignatureCertChain,"urn:iso:15118:2:2010:MsgBody":ContractID,"urn:iso:15118:2:2010:MsgBody":ListOfRootCertificateIDs,"urn:iso:15118:2:2010:MsgBody":DHParams)',  derivedBy='EXTENSION'.  */
		struct dinCertificateUpdateReqType CertificateUpdateReq ;
		/* element: "urn:iso:15118:2:2010:MsgBody":CertificateUpdateRes, Complex type name='urn:iso:15118:2:2010:MsgBody,CertificateUpdateResType',  base type name='BodyBaseType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2010:MsgBody":ResponseCode,"urn:iso:15118:2:2010:MsgBody":ContractSignatureCertChain,"urn:iso:15118:2:2010:MsgBody":ContractSignatureEncryptedPrivateKey,"urn:iso:15118:2:2010:MsgBody":DHParams,"urn:iso:15118:2:2010:MsgBody":ContractID,"urn:iso:15118:2:2010:MsgBody":RetryCounter)',  derivedBy='EXTENSION'.  */
		struct dinCertificateUpdateResType CertificateUpdateRes ;
		/* element: "urn:iso:15118:2:2010:MsgBody":CertificateInstallationReq, Complex type name='urn:iso:15118:2:2010:MsgBody,CertificateInstallationReqType',  base type name='BodyBaseType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2010:MsgBody":OEMProvisioningCert,"urn:iso:15118:2:2010:MsgBody":ListOfRootCertificateIDs,"urn:iso:15118:2:2010:MsgBody":DHParams)',  derivedBy='EXTENSION'.  */
		struct dinCertificateInstallationReqType CertificateInstallationReq ;
		/* element: "urn:iso:15118:2:2010:MsgBody":CertificateInstallationRes, Complex type name='urn:iso:15118:2:2010:MsgBody,CertificateInstallationResType',  base type name='BodyBaseType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2010:MsgBody":ResponseCode,"urn:iso:15118:2:2010:MsgBody":ContractSignatureCertChain,"urn:iso:15118:2:2010:MsgBody":ContractSignatureEncryptedPrivateKey,"urn:iso:15118:2:2010:MsgBody":DHParams,"urn:iso:15118:2:2010:MsgBody":ContractID)',  derivedBy='EXTENSION'.  */
		struct dinCertificateInstallationResType CertificateInstallationRes ;
		/* element: "urn:iso:15118:2:2010:MsgBody":CableCheckReq, Complex type name='urn:iso:15118:2:2010:MsgBody,CableCheckReqType',  base type name='BodyBaseType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2010:MsgBody":DC_EVStatus)',  derivedBy='EXTENSION'.  */
		struct dinCableCheckReqType CableCheckReq ;
		/* element: "urn:iso:15118:2:2010:MsgBody":CableCheckRes, Complex type name='urn:iso:15118:2:2010:MsgBody,CableCheckResType',  base type name='BodyBaseType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2010:MsgBody":ResponseCode,"urn:iso:15118:2:2010:MsgBody":DC_EVSEStatus,"urn:iso:15118:2:2010:MsgBody":EVSEProcessing)',  derivedBy='EXTENSION'.  */
		struct dinCableCheckResType CableCheckRes ;
		/* element: "urn:iso:15118:2:2010:MsgBody":PreChargeReq, Complex type name='urn:iso:15118:2:2010:MsgBody,PreChargeReqType',  base type name='BodyBaseType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2010:MsgBody":DC_EVStatus,"urn:iso:15118:2:2010:MsgBody":EVTargetVoltage,"urn:iso:15118:2:2010:MsgBody":EVTargetCurrent)',  derivedBy='EXTENSION'.  */
		struct dinPreChargeReqType PreChargeReq ;
		/* element: "urn:iso:15118:2:2010:MsgBody":PreChargeRes, Complex type name='urn:iso:15118:2:2010:MsgBody,PreChargeResType',  base type name='BodyBaseType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2010:MsgBody":ResponseCode,"urn:iso:15118:2:2010:MsgBody":DC_EVSEStatus,"urn:iso:15118:2:2010:MsgBody":EVSEPresentVoltage)',  derivedBy='EXTENSION'.  */
		struct dinPreChargeResType PreChargeRes ;
		/* element: "urn:iso:15118:2:2010:MsgBody":CurrentDemandReq, Complex type name='urn:iso:15118:2:2010:MsgBody,CurrentDemandReqType',  base type name='BodyBaseType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2010:MsgBody":DC_EVStatus,"urn:iso:15118:2:2010:MsgBody":EVTargetCurrent,"urn:iso:15118:2:2010:MsgBody":EVMaximumVoltageLimit{0-1},"urn:iso:15118:2:2010:MsgBody":EVMaximumCurrentLimit{0-1},"urn:iso:15118:2:2010:MsgBody":EVMaximumPowerLimit{0-1},"urn:iso:15118:2:2010:MsgBody":BulkChargingComplete{0-1},"urn:iso:15118:2:2010:MsgBody":ChargingComplete,"urn:iso:15118:2:2010:MsgBody":RemainingTimeToFullSoC{0-1},"urn:iso:15118:2:2010:MsgBody":RemainingTimeToBulkSoC{0-1},"urn:iso:15118:2:2010:MsgBody":EVTargetVoltage)',  derivedBy='EXTENSION'.  */
		struct dinCurrentDemandReqType CurrentDemandReq ;
		/* element: "urn:iso:15118:2:2010:MsgBody":CurrentDemandRes, Complex type name='urn:iso:15118:2:2010:MsgBody,CurrentDemandResType',  base type name='BodyBaseType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2010:MsgBody":ResponseCode,"urn:iso:15118:2:2010:MsgBody":DC_EVSEStatus,"urn:iso:15118:2:2010:MsgBody":EVSEPresentVoltage,"urn:iso:15118:2:2010:MsgBody":EVSEPresentCurrent,"urn:iso:15118:2:2010:MsgBody":EVSECurrentLimitAchieved,"urn:iso:15118:2:2010:MsgBody":EVSEVoltageLimitAchieved,"urn:iso:15118:2:2010:MsgBody":EVSEPowerLimitAchieved,"urn:iso:15118:2:2010:MsgBody":EVSEMaximumVoltageLimit{0-1},"urn:iso:15118:2:2010:MsgBody":EVSEMaximumCurrentLimit{0-1},"urn:iso:15118:2:2010:MsgBody":EVSEMaximumPowerLimit{0-1})',  derivedBy='EXTENSION'.  */
		struct dinCurrentDemandResType CurrentDemandRes ;
		/* element: "urn:iso:15118:2:2010:MsgBody":WeldingDetectionReq, Complex type name='urn:iso:15118:2:2010:MsgBody,WeldingDetectionReqType',  base type name='BodyBaseType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2010:MsgBody":DC_EVStatus)',  derivedBy='EXTENSION'.  */
		struct dinWeldingDetectionReqType WeldingDetectionReq ;
		/* element: "urn:iso:15118:2:2010:MsgBody":WeldingDetectionRes, Complex type name='urn:iso:15118:2:2010:MsgBody,WeldingDetectionResType',  base type name='BodyBaseType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2010:MsgBody":ResponseCode,"urn:iso:15118:2:2010:MsgBody":DC_EVSEStatus,"urn:iso:15118:2:2010:MsgBody":EVSEPresentVoltage)',  derivedBy='EXTENSION'.  */
		struct dinWeldingDetectionResType WeldingDetectionRes ;
#if SAVE_MEMORY_WITH_UNNAMED_UNION == UNION_YES
	};
#endif /* SAVE_MEMORY_WITH_UNNAMED_UNION == UNION_YES */ 
		unsigned int BodyElement_isUsed:1;
		unsigned int SessionSetupReq_isUsed:1;
		unsigned int SessionSetupRes_isUsed:1;
		unsigned int ServiceDiscoveryReq_isUsed:1;
		unsigned int ServiceDiscoveryRes_isUsed:1;
		unsigned int ServiceDetailReq_isUsed:1;
		unsigned int ServiceDetailRes_isUsed:1;
		unsigned int ServicePaymentSelectionReq_isUsed:1;
		unsigned int ServicePaymentSelectionRes_isUsed:1;
		unsigned int PaymentDetailsReq_isUsed:1;
		unsigned int PaymentDetailsRes_isUsed:1;
		unsigned int ContractAuthenticationReq_isUsed:1;
		unsigned int ContractAuthenticationRes_isUsed:1;
		unsigned int ChargeParameterDiscoveryReq_isUsed:1;
		unsigned int ChargeParameterDiscoveryRes_isUsed:1;
		unsigned int PowerDeliveryReq_isUsed:1;
		unsigned int PowerDeliveryRes_isUsed:1;
		unsigned int ChargingStatusReq_isUsed:1;
		unsigned int ChargingStatusRes_isUsed:1;
		unsigned int MeteringReceiptReq_isUsed:1;
		unsigned int MeteringReceiptRes_isUsed:1;
		unsigned int SessionStopReq_isUsed:1;
		unsigned int SessionStopRes_isUsed:1;
		unsigned int CertificateUpdateReq_isUsed:1;
		unsigned int CertificateUpdateRes_isUsed:1;
		unsigned int CertificateInstallationReq_isUsed:1;
		unsigned int CertificateInstallationRes_isUsed:1;
		unsigned int CableCheckReq_isUsed:1;
		unsigned int CableCheckRes_isUsed:1;
		unsigned int PreChargeReq_isUsed:1;
		unsigned int PreChargeRes_isUsed:1;
		unsigned int CurrentDemandReq_isUsed:1;
		unsigned int CurrentDemandRes_isUsed:1;
		unsigned int WeldingDetectionReq_isUsed:1;
		unsigned int WeldingDetectionRes_isUsed:1;
};

/* Complex type name='urn:iso:15118:2:2010:MsgDef,#AnonType_V2G_Message',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2010:MsgDef":Header,"urn:iso:15118:2:2010:MsgDef":Body)',  derivedBy='RESTRICTION'.  */
struct dinAnonType_V2G_Message {
	/* element: "urn:iso:15118:2:2010:MsgDef":Header, Complex type name='urn:iso:15118:2:2010:MsgHeader,MessageHeaderType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2010:MsgHeader":SessionID,"urn:iso:15118:2:2010:MsgHeader":Notification{0-1},"http://www.w3.org/2000/09/xmldsig#":Signature{0-1})',  derivedBy='RESTRICTION'.  */
	struct dinMessageHeaderType Header ;
	/* element: "urn:iso:15118:2:2010:MsgDef":Body, Complex type name='urn:iso:15118:2:2010:MsgDef,BodyType',  base type name='anyType',  content type='ELEMENT',  isAbstract='false',  hasTypeId='false',  final='0',  block='0',  particle='("urn:iso:15118:2:2010:MsgDef":BodyElement{0-1})',  derivedBy='RESTRICTION'.  */
	struct dinBodyType Body ;
};



#define EXIDocument_MgmtData_CHARACTERS_SIZE 50 + EXTRA_CHAR 
#define EXIDocument_KeyName_CHARACTERS_SIZE 50 + EXTRA_CHAR 
#define EXIDocument_DigestValue_BYTES_SIZE 350 
#define EXIFragment_Certificate_BYTES_SIZE 1200 /* XML schema facet maxLength for urn:iso:15118:2:2010:MsgDataTypes,certificateType is 1200 */
#define EXIFragment_stringValue_CHARACTERS_SIZE 50 + EXTRA_CHAR 
#define EXIFragment_OEMProvisioningCert_BYTES_SIZE 1200 /* XML schema facet maxLength for urn:iso:15118:2:2010:MsgDataTypes,certificateType is 1200 */
#define EXIFragment_Exponent_BYTES_SIZE 350 
#define EXIFragment_SessionID_BYTES_SIZE 8 /* XML schema facet length for urn:iso:15118:2:2010:MsgDataTypes,sessionIDType is 8 */
#define EXIFragment_PgenCounter_BYTES_SIZE 350 
#define EXIFragment_EVCCID_BYTES_SIZE 8 /* XML schema facet maxLength for urn:iso:15118:2:2010:MsgDataTypes,evccIDType is 8 */
#define EXIFragment_RootCertificateID_CHARACTERS_SIZE 40 + EXTRA_CHAR /* XML schema facet maxLength for urn:iso:15118:2:2010:MsgDataTypes,rootCertificateIDType is 40 */
#define EXIFragment_PGPKeyPacket_BYTES_SIZE 350 
#define EXIFragment_Seed_BYTES_SIZE 350 
#define EXIFragment_XPath_CHARACTERS_SIZE 50 + EXTRA_CHAR 
#define EXIFragment_ContractID_CHARACTERS_SIZE 24 + EXTRA_CHAR /* XML schema facet maxLength for urn:iso:15118:2:2010:MsgDataTypes,contractIDType is 24 */
#define EXIFragment_MgmtData_CHARACTERS_SIZE 50 + EXTRA_CHAR 
#define EXIFragment_P_BYTES_SIZE 350 
#define EXIFragment_Q_BYTES_SIZE 350 
#define EXIFragment_X509SubjectName_CHARACTERS_SIZE 50 + EXTRA_CHAR 
#define EXIFragment_G_BYTES_SIZE 350 
#define EXIFragment_J_BYTES_SIZE 350 
#define EXIFragment_X509CRL_BYTES_SIZE 350 
#define EXIFragment_Y_BYTES_SIZE 350 
#define EXIFragment_DigestValue_BYTES_SIZE 350 
#define EXIFragment_ContractSignatureEncryptedPrivateKey_BYTES_SIZE 128 /* XML schema facet maxLength for urn:iso:15118:2:2010:MsgDataTypes,privateKeyType is 128 */
#define EXIFragment_SPKISexp_BYTES_SIZE 350 
#define EXIFragment_DHParams_BYTES_SIZE 256 /* XML schema facet maxLength for urn:iso:15118:2:2010:MsgDataTypes,dHParamsType is 256 */
#define EXIFragment_PGPKeyID_BYTES_SIZE 350 
#define EXIFragment_X509Certificate_BYTES_SIZE 350 
#define EXIFragment_ServiceName_CHARACTERS_SIZE 32 + EXTRA_CHAR /* XML schema facet maxLength for urn:iso:15118:2:2010:MsgDataTypes,serviceNameType is 32 */
#define EXIFragment_EVSEID_BYTES_SIZE 32 /* XML schema facet maxLength for urn:iso:15118:2:2010:MsgDataTypes,evseIDType is 32 */
#define EXIFragment_ServiceScope_CHARACTERS_SIZE 32 + EXTRA_CHAR /* XML schema facet maxLength for urn:iso:15118:2:2010:MsgDataTypes,serviceScopeType is 32 */
#define EXIFragment_GenChallenge_CHARACTERS_SIZE 50 + EXTRA_CHAR 
#define EXIFragment_SalesTariffDescription_CHARACTERS_SIZE 32 + EXTRA_CHAR /* XML schema facet maxLength for urn:iso:15118:2:2010:MsgDataTypes,tariffDescriptionType is 32 */
#define EXIFragment_FaultMsg_CHARACTERS_SIZE 64 + EXTRA_CHAR /* XML schema facet maxLength for urn:iso:15118:2:2010:MsgDataTypes,faultMsgType is 64 */
#define EXIFragment_KeyName_CHARACTERS_SIZE 50 + EXTRA_CHAR 
#define EXIFragment_SigMeterReading_BYTES_SIZE 32 /* XML schema facet maxLength for urn:iso:15118:2:2010:MsgDataTypes,sigMeterReadingType is 32 */
#define EXIFragment_X509SKI_BYTES_SIZE 350 
#define EXIFragment_X509IssuerName_CHARACTERS_SIZE 50 + EXTRA_CHAR 
#define EXIFragment_MeterID_CHARACTERS_SIZE 32 + EXTRA_CHAR /* XML schema facet maxLength for urn:iso:15118:2:2010:MsgDataTypes,meterIDType is 32 */
#define EXIFragment_Modulus_BYTES_SIZE 350 


/* Global elements of EXI Document */
struct dinEXIDocument {
#if SAVE_MEMORY_WITH_UNNAMED_UNION == UNION_YES
	union {
#endif /* SAVE_MEMORY_WITH_UNNAMED_UNION == UNION_YES */ 
	struct dinBodyBaseType BodyElement ;
	struct dinAnonType_V2G_Message V2G_Message ;
	struct dinSignaturePropertyType SignatureProperty ;
	struct dinDSAKeyValueType DSAKeyValue ;
	struct dinSignaturePropertiesType SignatureProperties ;
	struct dinKeyValueType KeyValue ;
	struct dinTransformsType Transforms ;
	struct dinDigestMethodType DigestMethod ;
	struct dinSignatureType Signature ;
	struct dinRetrievalMethodType RetrievalMethod ;
	struct dinManifestType Manifest ;
	struct dinReferenceType Reference ;
	struct dinCanonicalizationMethodType CanonicalizationMethod ;
	struct dinRSAKeyValueType RSAKeyValue ;
	struct dinTransformType Transform ;
	struct dinPGPDataType PGPData ;
	struct {
		exi_string_character_t characters[EXIDocument_MgmtData_CHARACTERS_SIZE];
		uint16_t charactersLen;
	}  MgmtData ;
	struct dinSignatureMethodType SignatureMethod ;
	struct dinKeyInfoType KeyInfo ;
	struct dinSPKIDataType SPKIData ;
	struct dinX509DataType X509Data ;
	struct dinSignatureValueType SignatureValue ;
	struct {
		exi_string_character_t characters[EXIDocument_KeyName_CHARACTERS_SIZE];
		uint16_t charactersLen;
	}  KeyName ;
	struct {
		uint8_t bytes[EXIDocument_DigestValue_BYTES_SIZE];
		uint16_t bytesLen;
	}  DigestValue ;
	struct dinSignedInfoType SignedInfo ;
	struct dinObjectType Object ;
	struct dinDC_EVSEStatusType DC_EVSEStatus ;
	struct dinRelativeTimeIntervalType RelativeTimeInterval ;
	struct dinSalesTariffEntryType SalesTariffEntry ;
	struct dinDC_EVPowerDeliveryParameterType DC_EVPowerDeliveryParameter ;
	struct dinSASchedulesType SASchedules ;
	struct dinAC_EVChargeParameterType AC_EVChargeParameter ;
	struct dinSAScheduleListType SAScheduleList ;
	struct dinDC_EVStatusType DC_EVStatus ;
	struct dinServiceChargeType ServiceCharge ;
	struct dinEVStatusType EVStatus ;
	struct dinDC_EVChargeParameterType DC_EVChargeParameter ;
	struct dinDC_EVSEChargeParameterType DC_EVSEChargeParameter ;
	struct dinEVSEStatusType EVSEStatus ;
	struct dinIntervalType TimeInterval ;
	struct dinEVPowerDeliveryParameterType EVPowerDeliveryParameter ;
	struct dinEVSEChargeParameterType EVSEChargeParameter ;
	struct dinAC_EVSEStatusType AC_EVSEStatus ;
	struct dinEntryType Entry ;
	struct dinAC_EVSEChargeParameterType AC_EVSEChargeParameter ;
	struct dinPMaxScheduleEntryType PMaxScheduleEntry ;
	struct dinEVChargeParameterType EVChargeParameter ;
	struct dinServiceDiscoveryReqType ServiceDiscoveryReq ;
	struct dinServiceDiscoveryResType ServiceDiscoveryRes ;
	struct dinMeteringReceiptReqType MeteringReceiptReq ;
	struct dinPaymentDetailsReqType PaymentDetailsReq ;
	struct dinMeteringReceiptResType MeteringReceiptRes ;
	struct dinPaymentDetailsResType PaymentDetailsRes ;
	struct dinSessionSetupReqType SessionSetupReq ;
	struct dinSessionSetupResType SessionSetupRes ;
	struct dinCableCheckReqType CableCheckReq ;
	struct dinCableCheckResType CableCheckRes ;
	struct dinContractAuthenticationReqType ContractAuthenticationReq ;
	struct dinCertificateInstallationReqType CertificateInstallationReq ;
	struct dinContractAuthenticationResType ContractAuthenticationRes ;
	struct dinCertificateInstallationResType CertificateInstallationRes ;
	struct dinWeldingDetectionReqType WeldingDetectionReq ;
	struct dinWeldingDetectionResType WeldingDetectionRes ;
	struct dinCertificateUpdateReqType CertificateUpdateReq ;
	struct dinCertificateUpdateResType CertificateUpdateRes ;
	struct dinPowerDeliveryReqType PowerDeliveryReq ;
	struct dinPowerDeliveryResType PowerDeliveryRes ;
	struct dinChargingStatusReqType ChargingStatusReq ;
	struct dinChargingStatusResType ChargingStatusRes ;
	struct dinCurrentDemandReqType CurrentDemandReq ;
	struct dinPreChargeReqType PreChargeReq ;
	struct dinCurrentDemandResType CurrentDemandRes ;
	struct dinPreChargeResType PreChargeRes ;
	struct dinServicePaymentSelectionReqType ServicePaymentSelectionReq ;
	struct dinSessionStopType SessionStopReq ;
	struct dinServicePaymentSelectionResType ServicePaymentSelectionRes ;
	struct dinSessionStopResType SessionStopRes ;
	struct dinChargeParameterDiscoveryReqType ChargeParameterDiscoveryReq ;
	struct dinChargeParameterDiscoveryResType ChargeParameterDiscoveryRes ;
	struct dinServiceDetailReqType ServiceDetailReq ;
	struct dinServiceDetailResType ServiceDetailRes ;
#if SAVE_MEMORY_WITH_UNNAMED_UNION == UNION_YES
	};
#endif /* SAVE_MEMORY_WITH_UNNAMED_UNION == UNION_YES */ 
	unsigned int BodyElement_isUsed:1;
	unsigned int V2G_Message_isUsed:1;
	unsigned int SignatureProperty_isUsed:1;
	unsigned int DSAKeyValue_isUsed:1;
	unsigned int SignatureProperties_isUsed:1;
	unsigned int KeyValue_isUsed:1;
	unsigned int Transforms_isUsed:1;
	unsigned int DigestMethod_isUsed:1;
	unsigned int Signature_isUsed:1;
	unsigned int RetrievalMethod_isUsed:1;
	unsigned int Manifest_isUsed:1;
	unsigned int Reference_isUsed:1;
	unsigned int CanonicalizationMethod_isUsed:1;
	unsigned int RSAKeyValue_isUsed:1;
	unsigned int Transform_isUsed:1;
	unsigned int PGPData_isUsed:1;
	unsigned int MgmtData_isUsed:1;
	unsigned int SignatureMethod_isUsed:1;
	unsigned int KeyInfo_isUsed:1;
	unsigned int SPKIData_isUsed:1;
	unsigned int X509Data_isUsed:1;
	unsigned int SignatureValue_isUsed:1;
	unsigned int KeyName_isUsed:1;
	unsigned int DigestValue_isUsed:1;
	unsigned int SignedInfo_isUsed:1;
	unsigned int Object_isUsed:1;
	unsigned int DC_EVSEStatus_isUsed:1;
	unsigned int RelativeTimeInterval_isUsed:1;
	unsigned int SalesTariffEntry_isUsed:1;
	unsigned int DC_EVPowerDeliveryParameter_isUsed:1;
	unsigned int SASchedules_isUsed:1;
	unsigned int AC_EVChargeParameter_isUsed:1;
	unsigned int SAScheduleList_isUsed:1;
	unsigned int DC_EVStatus_isUsed:1;
	unsigned int ServiceCharge_isUsed:1;
	unsigned int EVStatus_isUsed:1;
	unsigned int DC_EVChargeParameter_isUsed:1;
	unsigned int DC_EVSEChargeParameter_isUsed:1;
	unsigned int EVSEStatus_isUsed:1;
	unsigned int TimeInterval_isUsed:1;
	unsigned int EVPowerDeliveryParameter_isUsed:1;
	unsigned int EVSEChargeParameter_isUsed:1;
	unsigned int AC_EVSEStatus_isUsed:1;
	unsigned int Entry_isUsed:1;
	unsigned int AC_EVSEChargeParameter_isUsed:1;
	unsigned int PMaxScheduleEntry_isUsed:1;
	unsigned int EVChargeParameter_isUsed:1;
	unsigned int ServiceDiscoveryReq_isUsed:1;
	unsigned int ServiceDiscoveryRes_isUsed:1;
	unsigned int MeteringReceiptReq_isUsed:1;
	unsigned int PaymentDetailsReq_isUsed:1;
	unsigned int MeteringReceiptRes_isUsed:1;
	unsigned int PaymentDetailsRes_isUsed:1;
	unsigned int SessionSetupReq_isUsed:1;
	unsigned int SessionSetupRes_isUsed:1;
	unsigned int CableCheckReq_isUsed:1;
	unsigned int CableCheckRes_isUsed:1;
	unsigned int ContractAuthenticationReq_isUsed:1;
	unsigned int CertificateInstallationReq_isUsed:1;
	unsigned int ContractAuthenticationRes_isUsed:1;
	unsigned int CertificateInstallationRes_isUsed:1;
	unsigned int WeldingDetectionReq_isUsed:1;
	unsigned int WeldingDetectionRes_isUsed:1;
	unsigned int CertificateUpdateReq_isUsed:1;
	unsigned int CertificateUpdateRes_isUsed:1;
	unsigned int PowerDeliveryReq_isUsed:1;
	unsigned int PowerDeliveryRes_isUsed:1;
	unsigned int ChargingStatusReq_isUsed:1;
	unsigned int ChargingStatusRes_isUsed:1;
	unsigned int CurrentDemandReq_isUsed:1;
	unsigned int PreChargeReq_isUsed:1;
	unsigned int CurrentDemandRes_isUsed:1;
	unsigned int PreChargeRes_isUsed:1;
	unsigned int ServicePaymentSelectionReq_isUsed:1;
	unsigned int SessionStopReq_isUsed:1;
	unsigned int ServicePaymentSelectionRes_isUsed:1;
	unsigned int SessionStopRes_isUsed:1;
	unsigned int ChargeParameterDiscoveryReq_isUsed:1;
	unsigned int ChargeParameterDiscoveryRes_isUsed:1;
	unsigned int ServiceDetailReq_isUsed:1;
	unsigned int ServiceDetailRes_isUsed:1;


	int _warning_;
};


#if DEPLOY_DIN_CODEC_FRAGMENT == SUPPORT_YES
/* Possible elements of EXI Fragment */
struct dinEXIFragment {
#if SAVE_MEMORY_WITH_UNNAMED_UNION == UNION_YES
	union {
#endif /* SAVE_MEMORY_WITH_UNNAMED_UNION == UNION_YES */ 
	dinunitSymbolType Unit ;
	struct dinPhysicalValueType EVSEMaximumCurrentLimit ;
	struct dinEVPowerDeliveryParameterType EVPowerDeliveryParameter ;
	int16_t ChargingProfileEntryMaxPower ;
	int64_t TMeter ;
	int EVSEPowerLimitAchieved ;
	uint32_t duration ;
	struct dinPhysicalValueType EVMaximumCurrentLimit ;
	struct dinParameterType Parameter ;
	dinEVSEProcessingType EVSEProcessing ;
	struct dinAC_EVChargeParameterType AC_EVChargeParameter ;
	struct dinPMaxScheduleEntryType PMaxScheduleEntry ;
	struct dinPhysicalValueType EVSEMaximumVoltageLimit ;
	struct dinSelectedServiceType SelectedService ;
	struct {
		uint8_t bytes[EXIFragment_Certificate_BYTES_SIZE];
		uint16_t bytesLen;
	}  Certificate ;
	struct dinPhysicalValueType EVSEMaximumPowerLimit ;
	int EVReady ;
	int64_t X509SerialNumber ;
	struct dinRetrievalMethodType RetrievalMethod ;
	int16_t RetryCounter ;
	struct dinDC_EVSEStatusType DC_EVSEStatus ;
	struct dinMeteringReceiptReqType MeteringReceiptReq ;
	int ReadyToChargeState ;
	int8_t Multiplier ;
	uint8_t EPriceLevel ;
	struct {
		exi_string_character_t characters[EXIFragment_stringValue_CHARACTERS_SIZE];
		uint16_t charactersLen;
	}  stringValue ;
	struct dinServiceDiscoveryReqType ServiceDiscoveryReq ;
	struct dinTransformsType Transforms ;
	struct dinMeteringReceiptResType MeteringReceiptRes ;
	struct dinPreChargeReqType PreChargeReq ;
	struct {
		uint8_t bytes[EXIFragment_OEMProvisioningCert_BYTES_SIZE];
		uint16_t bytesLen;
	}  OEMProvisioningCert ;
	struct dinServiceDiscoveryResType ServiceDiscoveryRes ;
	dinresponseCodeType ResponseCode ;
	struct dinContractAuthenticationReqType ContractAuthenticationReq ;
	struct dinCertificateChainType ContractSignatureCertChain ;
	struct dinContractAuthenticationResType ContractAuthenticationRes ;
	int64_t HMACOutputLength ;
	int BulkChargingComplete ;
	struct {
		uint8_t bytes[EXIFragment_Exponent_BYTES_SIZE];
		uint16_t bytesLen;
	}  Exponent ;
	struct dinDC_EVStatusType DC_EVStatus ;
	struct dinSAScheduleTupleType SAScheduleTuple ;
	uint32_t DepartureTime ;
	struct dinX509IssuerSerialType X509IssuerSerial ;
	int16_t SAScheduleTupleID ;
	struct dinSPKIDataType SPKIData ;
	struct dinRelativeTimeIntervalType RelativeTimeInterval ;
	struct dinPhysicalValueType EVEnergyRequest ;
	struct dinPreChargeResType PreChargeRes ;
	struct {
		uint8_t bytes[EXIFragment_SessionID_BYTES_SIZE];
		uint16_t bytesLen;
	}  SessionID ;
	struct dinPMaxScheduleType PMaxSchedule ;
	struct dinServiceChargeType ServiceCharge ;
	struct {
		uint8_t bytes[EXIFragment_PgenCounter_BYTES_SIZE];
		uint16_t bytesLen;
	}  PgenCounter ;
	struct dinChargingStatusReqType ChargingStatusReq ;
	struct dinX509DataType X509Data ;
	struct dinSalesTariffEntryType SalesTariffEntry ;
	struct dinKeyValueType KeyValue ;
	struct dinChargingStatusResType ChargingStatusRes ;
	struct dinAnonType_V2G_Message V2G_Message ;
	struct dinServicePaymentSelectionReqType ServicePaymentSelectionReq ;
	dinisolationLevelType EVSEIsolationStatus ;
	struct dinServicePaymentSelectionResType ServicePaymentSelectionRes ;
	struct dinPhysicalValueType EVSEPresentVoltage ;
	struct dinBodyBaseType BodyElement ;
	struct {
		uint8_t bytes[EXIFragment_EVCCID_BYTES_SIZE];
		uint16_t bytesLen;
	}  EVCCID ;
	struct dinPGPDataType PGPData ;
	struct {
		exi_string_character_t characters[EXIFragment_RootCertificateID_CHARACTERS_SIZE];
		uint16_t charactersLen;
	}  RootCertificateID ;
	dinfaultCodeType FaultCode ;
	struct dinCableCheckReqType CableCheckReq ;
	int EVSEVoltageLimitAchieved ;
	int EVRESSConditioning ;
	struct dinMeterInfoType MeterInfo ;
	struct dinCableCheckResType CableCheckRes ;
	uint32_t ChargingProfileEntryStart ;
	struct dinSignaturePropertyType SignatureProperty ;
	struct dinPhysicalValueType EVMaxCurrent ;
	struct {
		uint8_t bytes[EXIFragment_PGPKeyPacket_BYTES_SIZE];
		uint16_t bytesLen;
	}  PGPKeyPacket ;
	struct {
		uint8_t bytes[EXIFragment_Seed_BYTES_SIZE];
		uint16_t bytesLen;
	}  Seed ;
	struct dinRSAKeyValueType RSAKeyValue ;
	dincostKindType costKind ;
	struct dinPhysicalValueType EAmount ;
	struct dinPhysicalValueType EVSEPresentCurrent ;
	struct dinPowerDeliveryResType PowerDeliveryRes ;
	uint8_t NumEPriceLevels ;
	struct dinSessionStopResType SessionStopRes ;
	struct dinPowerDeliveryReqType PowerDeliveryReq ;
	struct dinSessionStopType SessionStopReq ;
	struct {
		exi_string_character_t characters[EXIFragment_XPath_CHARACTERS_SIZE];
		uint16_t charactersLen;
	}  XPath ;
	int8_t BulkSOC ;
	int16_t PMax ;
	int16_t ParameterSetID ;
	struct {
		exi_string_character_t characters[EXIFragment_ContractID_CHARACTERS_SIZE];
		uint16_t charactersLen;
	}  ContractID ;
	struct dinSignatureType Signature ;
	struct dinPhysicalValueType EVMaxVoltage ;
	int ReceiptRequired ;
	int ChargingComplete ;
	struct dinChargingProfileType ChargingProfile ;
	struct dinPaymentOptionsType PaymentOptions ;
	struct dinSessionSetupResType SessionSetupRes ;
	struct dinServiceDetailResType ServiceDetailRes ;
	struct dinDC_EVPowerDeliveryParameterType DC_EVPowerDeliveryParameter ;
	struct dinPaymentDetailsResType PaymentDetailsRes ;
	struct dinPaymentDetailsReqType PaymentDetailsReq ;
	struct {
		exi_string_character_t characters[EXIFragment_MgmtData_CHARACTERS_SIZE];
		uint16_t charactersLen;
	}  MgmtData ;
	int16_t Value ;
	dinEVSENotificationType EVSENotification ;
	struct dinPhysicalValueType EVTargetCurrent ;
	struct dinPhysicalValueType RemainingTimeToBulkSoC ;
	struct dinSessionSetupReqType SessionSetupReq ;
	int EVSECurrentLimitAchieved ;
	struct dinServiceDetailReqType ServiceDetailReq ;
	int8_t byteValue ;
	struct dinPhysicalValueType EVMaximumPowerLimit ;
	int PowerSwitchClosed ;
	struct dinManifestType Manifest ;
	struct {
		uint8_t bytes[EXIFragment_P_BYTES_SIZE];
		uint16_t bytesLen;
	}  P ;
	struct dinSAScheduleListType SAScheduleList ;
	struct {
		uint8_t bytes[EXIFragment_Q_BYTES_SIZE];
		uint16_t bytesLen;
	}  Q ;
	struct {
		exi_string_character_t characters[EXIFragment_X509SubjectName_CHARACTERS_SIZE];
		uint16_t charactersLen;
	}  X509SubjectName ;
	struct {
		uint8_t bytes[EXIFragment_G_BYTES_SIZE];
		uint16_t bytesLen;
	}  G ;
	struct {
		uint8_t bytes[EXIFragment_J_BYTES_SIZE];
		uint16_t bytesLen;
	}  J ;
	struct dinCertificateInstallationResType CertificateInstallationRes ;
	struct dinCertificateInstallationReqType CertificateInstallationReq ;
	struct dinSalesTariffType SalesTariff ;
	struct dinMessageHeaderType Header ;
	struct dinPhysicalValueType EVSEMinimumCurrentLimit ;
	struct {
		uint8_t bytes[EXIFragment_X509CRL_BYTES_SIZE];
		uint16_t bytesLen;
	}  X509CRL ;
	struct {
		uint8_t bytes[EXIFragment_Y_BYTES_SIZE];
		uint16_t bytesLen;
	}  Y ;
	struct {
		uint8_t bytes[EXIFragment_DigestValue_BYTES_SIZE];
		uint16_t bytesLen;
	}  DigestValue ;
	struct dinDC_EVChargeParameterType DC_EVChargeParameter ;
	struct {
		uint8_t bytes[EXIFragment_ContractSignatureEncryptedPrivateKey_BYTES_SIZE];
		uint16_t bytesLen;
	}  ContractSignatureEncryptedPrivateKey ;
	struct dinDigestMethodType DigestMethod ;
	struct {
		uint8_t bytes[EXIFragment_SPKISexp_BYTES_SIZE];
		uint16_t bytesLen;
	}  SPKISexp ;
	struct dinServiceChargeType ChargeService ;
	struct dinPhysicalValueType EVSEEnergyToBeDelivered ;
	struct dinSignaturePropertiesType SignatureProperties ;
	struct dinPhysicalValueType EVSEMaxCurrent ;
	struct dinEVSEStatusType EVSEStatus ;
	struct dinServiceType Service ;
	struct {
		uint8_t bytes[EXIFragment_DHParams_BYTES_SIZE];
		uint16_t bytesLen;
	}  DHParams ;
	struct {
		uint8_t bytes[EXIFragment_PGPKeyID_BYTES_SIZE];
		uint16_t bytesLen;
	}  PGPKeyID ;
	struct dinDSAKeyValueType DSAKeyValue ;
	dinEVSESupportedEnergyTransferType EnergyTransferType ;
	struct dinWeldingDetectionResType WeldingDetectionRes ;
	int FreeService ;
	struct dinSelectedServiceListType SelectedServiceList ;
	struct dinWeldingDetectionReqType WeldingDetectionReq ;
	struct dinPhysicalValueType EVTargetVoltage ;
	struct dinCanonicalizationMethodType CanonicalizationMethod ;
	struct {
		uint8_t bytes[EXIFragment_X509Certificate_BYTES_SIZE];
		uint16_t bytesLen;
	}  X509Certificate ;
	struct dinCertificateUpdateResType CertificateUpdateRes ;
	struct dinCertificateUpdateReqType CertificateUpdateReq ;
	struct dinPhysicalValueType EVSEMaxVoltage ;
	struct dinSignedInfoType SignedInfo ;
	struct dinAC_EVSEChargeParameterType AC_EVSEChargeParameter ;
	struct dinPhysicalValueType EVEnergyCapacity ;
	uint16_t ServiceID ;
	struct dinPhysicalValueType EVSECurrentRegulationTolerance ;
	struct dinServiceParameterListType ServiceParameterList ;
	struct dinListOfRootCertificateIDsType ListOfRootCertificateIDs ;
	struct dinProfileEntryType ProfileEntry ;
	struct dinPhysicalValueType EVSEMinimumVoltageLimit ;
	struct dinCurrentDemandResType CurrentDemandRes ;
	int8_t EVRESSSOC ;
	struct dinPhysicalValueType MeterReading ;
	struct dinCurrentDemandReqType CurrentDemandReq ;
	struct dinPhysicalValueType physicalValue ;
	struct dinIntervalType TimeInterval ;
	struct dinAC_EVSEStatusType AC_EVSEStatus ;
	struct dinPhysicalValueType EVMaximumVoltageLimit ;
	struct dinSignatureValueType SignatureValue ;
	int64_t DateTimeNow ;
	struct dinServiceTagType ServiceTag ;
	int32_t intValue ;
	dinpaymentOptionType SelectedPaymentOption ;
	struct {
		exi_string_character_t characters[EXIFragment_ServiceName_CHARACTERS_SIZE];
		uint16_t charactersLen;
	}  ServiceName ;
	int EVCabinConditioning ;
	struct {
		uint8_t bytes[EXIFragment_EVSEID_BYTES_SIZE];
		uint16_t bytesLen;
	}  EVSEID ;
	struct {
		exi_string_character_t characters[EXIFragment_ServiceScope_CHARACTERS_SIZE];
		uint16_t charactersLen;
	}  ServiceScope ;
	int16_t MeterStatus ;
	dinEVRequestedEnergyTransferType EVRequestedEnergyTransferType ;
	dinserviceCategoryType ServiceCategory ;
	struct {
		exi_string_character_t characters[EXIFragment_GenChallenge_CHARACTERS_SIZE];
		uint16_t charactersLen;
	}  GenChallenge ;
	struct {
		exi_string_character_t characters[EXIFragment_SalesTariffDescription_CHARACTERS_SIZE];
		uint16_t charactersLen;
	}  SalesTariffDescription ;
	uint32_t NotificationMaxDelay ;
	int boolValue ;
	dinDC_EVSEStatusCodeType EVSEStatusCode ;
	struct {
		exi_string_character_t characters[EXIFragment_FaultMsg_CHARACTERS_SIZE];
		uint16_t charactersLen;
	}  FaultMsg ;
	struct {
		exi_string_character_t characters[EXIFragment_KeyName_CHARACTERS_SIZE];
		uint16_t charactersLen;
	}  KeyName ;
	struct dinParameterSetType ParameterSet ;
	struct {
		uint8_t bytes[EXIFragment_SigMeterReading_BYTES_SIZE];
		uint16_t bytesLen;
	}  SigMeterReading ;
	struct dinEVSEChargeParameterType EVSEChargeParameter ;
	struct dinBodyType Body ;
	struct dinSASchedulesType SASchedules ;
	struct dinKeyInfoType KeyInfo ;
	int16_t PMaxScheduleID ;
	struct dinPhysicalValueType RemainingTimeToFullSoC ;
	struct dinEVStatusType EVStatus ;
	struct dinSubCertificatesType SubCertificates ;
	dinpaymentOptionType PaymentOption ;
	struct {
		uint8_t bytes[EXIFragment_X509SKI_BYTES_SIZE];
		uint16_t bytesLen;
	}  X509SKI ;
	struct dinServiceTagListType ServiceList ;
	struct dinCostType Cost ;
	struct dinSignatureMethodType SignatureMethod ;
	struct dinPhysicalValueType EVSEMinCurrent ;
	struct dinConsumptionCostType ConsumptionCost ;
	struct dinPhysicalValueType EVSEPeakCurrentRipple ;
	dinDC_EVErrorCodeType EVErrorCode ;
	struct dinEVChargeParameterType EVChargeParameter ;
	uint32_t start ;
	struct {
		exi_string_character_t characters[EXIFragment_X509IssuerName_CHARACTERS_SIZE];
		uint16_t charactersLen;
	}  X509IssuerName ;
	struct dinReferenceType Reference ;
	struct dinPhysicalValueType EVMinCurrent ;
	int8_t FullSOC ;
	uint32_t amount ;
	int16_t shortValue ;
	struct dinDC_EVSEChargeParameterType DC_EVSEChargeParameter ;
	struct dinEntryType Entry ;
	int16_t SalesTariffID ;
	struct {
		exi_string_character_t characters[EXIFragment_MeterID_CHARACTERS_SIZE];
		uint16_t charactersLen;
	}  MeterID ;
	struct dinChargeParameterDiscoveryReqType ChargeParameterDiscoveryReq ;
	int8_t amountMultiplier ;
	struct dinChargeParameterDiscoveryResType ChargeParameterDiscoveryRes ;
	struct dinTransformType Transform ;
	struct dinObjectType Object ;
	int RCD ;
	struct dinNotificationType Notification ;
	uint32_t startValue ;
	struct {
		uint8_t bytes[EXIFragment_Modulus_BYTES_SIZE];
		uint16_t bytesLen;
	}  Modulus ;
#if SAVE_MEMORY_WITH_UNNAMED_UNION == UNION_YES
	};
#endif /* SAVE_MEMORY_WITH_UNNAMED_UNION == UNION_YES */ 
	unsigned int Unit_isUsed:1;
	unsigned int EVSEMaximumCurrentLimit_isUsed:1;
	unsigned int EVPowerDeliveryParameter_isUsed:1;
	unsigned int ChargingProfileEntryMaxPower_isUsed:1;
	unsigned int TMeter_isUsed:1;
	unsigned int EVSEPowerLimitAchieved_isUsed:1;
	unsigned int duration_isUsed:1;
	unsigned int EVMaximumCurrentLimit_isUsed:1;
	unsigned int Parameter_isUsed:1;
	unsigned int EVSEProcessing_isUsed:1;
	unsigned int AC_EVChargeParameter_isUsed:1;
	unsigned int PMaxScheduleEntry_isUsed:1;
	unsigned int EVSEMaximumVoltageLimit_isUsed:1;
	unsigned int SelectedService_isUsed:1;
	unsigned int Certificate_isUsed:1;
	unsigned int EVSEMaximumPowerLimit_isUsed:1;
	unsigned int EVReady_isUsed:1;
	unsigned int X509SerialNumber_isUsed:1;
	unsigned int RetrievalMethod_isUsed:1;
	unsigned int RetryCounter_isUsed:1;
	unsigned int DC_EVSEStatus_isUsed:1;
	unsigned int MeteringReceiptReq_isUsed:1;
	unsigned int ReadyToChargeState_isUsed:1;
	unsigned int Multiplier_isUsed:1;
	unsigned int EPriceLevel_isUsed:1;
	unsigned int stringValue_isUsed:1;
	unsigned int ServiceDiscoveryReq_isUsed:1;
	unsigned int Transforms_isUsed:1;
	unsigned int MeteringReceiptRes_isUsed:1;
	unsigned int PreChargeReq_isUsed:1;
	unsigned int OEMProvisioningCert_isUsed:1;
	unsigned int ServiceDiscoveryRes_isUsed:1;
	unsigned int ResponseCode_isUsed:1;
	unsigned int ContractAuthenticationReq_isUsed:1;
	unsigned int ContractSignatureCertChain_isUsed:1;
	unsigned int ContractAuthenticationRes_isUsed:1;
	unsigned int HMACOutputLength_isUsed:1;
	unsigned int BulkChargingComplete_isUsed:1;
	unsigned int Exponent_isUsed:1;
	unsigned int DC_EVStatus_isUsed:1;
	unsigned int SAScheduleTuple_isUsed:1;
	unsigned int DepartureTime_isUsed:1;
	unsigned int X509IssuerSerial_isUsed:1;
	unsigned int SAScheduleTupleID_isUsed:1;
	unsigned int SPKIData_isUsed:1;
	unsigned int RelativeTimeInterval_isUsed:1;
	unsigned int EVEnergyRequest_isUsed:1;
	unsigned int PreChargeRes_isUsed:1;
	unsigned int SessionID_isUsed:1;
	unsigned int PMaxSchedule_isUsed:1;
	unsigned int ServiceCharge_isUsed:1;
	unsigned int PgenCounter_isUsed:1;
	unsigned int ChargingStatusReq_isUsed:1;
	unsigned int X509Data_isUsed:1;
	unsigned int SalesTariffEntry_isUsed:1;
	unsigned int KeyValue_isUsed:1;
	unsigned int ChargingStatusRes_isUsed:1;
	unsigned int V2G_Message_isUsed:1;
	unsigned int ServicePaymentSelectionReq_isUsed:1;
	unsigned int EVSEIsolationStatus_isUsed:1;
	unsigned int ServicePaymentSelectionRes_isUsed:1;
	unsigned int EVSEPresentVoltage_isUsed:1;
	unsigned int BodyElement_isUsed:1;
	unsigned int EVCCID_isUsed:1;
	unsigned int PGPData_isUsed:1;
	unsigned int RootCertificateID_isUsed:1;
	unsigned int FaultCode_isUsed:1;
	unsigned int CableCheckReq_isUsed:1;
	unsigned int EVSEVoltageLimitAchieved_isUsed:1;
	unsigned int EVRESSConditioning_isUsed:1;
	unsigned int MeterInfo_isUsed:1;
	unsigned int CableCheckRes_isUsed:1;
	unsigned int ChargingProfileEntryStart_isUsed:1;
	unsigned int SignatureProperty_isUsed:1;
	unsigned int EVMaxCurrent_isUsed:1;
	unsigned int PGPKeyPacket_isUsed:1;
	unsigned int Seed_isUsed:1;
	unsigned int RSAKeyValue_isUsed:1;
	unsigned int costKind_isUsed:1;
	unsigned int EAmount_isUsed:1;
	unsigned int EVSEPresentCurrent_isUsed:1;
	unsigned int PowerDeliveryRes_isUsed:1;
	unsigned int NumEPriceLevels_isUsed:1;
	unsigned int SessionStopRes_isUsed:1;
	unsigned int PowerDeliveryReq_isUsed:1;
	unsigned int SessionStopReq_isUsed:1;
	unsigned int XPath_isUsed:1;
	unsigned int BulkSOC_isUsed:1;
	unsigned int PMax_isUsed:1;
	unsigned int ParameterSetID_isUsed:1;
	unsigned int ContractID_isUsed:1;
	unsigned int Signature_isUsed:1;
	unsigned int EVMaxVoltage_isUsed:1;
	unsigned int ReceiptRequired_isUsed:1;
	unsigned int ChargingComplete_isUsed:1;
	unsigned int ChargingProfile_isUsed:1;
	unsigned int PaymentOptions_isUsed:1;
	unsigned int SessionSetupRes_isUsed:1;
	unsigned int ServiceDetailRes_isUsed:1;
	unsigned int DC_EVPowerDeliveryParameter_isUsed:1;
	unsigned int PaymentDetailsRes_isUsed:1;
	unsigned int PaymentDetailsReq_isUsed:1;
	unsigned int MgmtData_isUsed:1;
	unsigned int Value_isUsed:1;
	unsigned int EVSENotification_isUsed:1;
	unsigned int EVTargetCurrent_isUsed:1;
	unsigned int RemainingTimeToBulkSoC_isUsed:1;
	unsigned int SessionSetupReq_isUsed:1;
	unsigned int EVSECurrentLimitAchieved_isUsed:1;
	unsigned int ServiceDetailReq_isUsed:1;
	unsigned int byteValue_isUsed:1;
	unsigned int EVMaximumPowerLimit_isUsed:1;
	unsigned int PowerSwitchClosed_isUsed:1;
	unsigned int Manifest_isUsed:1;
	unsigned int P_isUsed:1;
	unsigned int SAScheduleList_isUsed:1;
	unsigned int Q_isUsed:1;
	unsigned int X509SubjectName_isUsed:1;
	unsigned int G_isUsed:1;
	unsigned int J_isUsed:1;
	unsigned int CertificateInstallationRes_isUsed:1;
	unsigned int CertificateInstallationReq_isUsed:1;
	unsigned int SalesTariff_isUsed:1;
	unsigned int Header_isUsed:1;
	unsigned int EVSEMinimumCurrentLimit_isUsed:1;
	unsigned int X509CRL_isUsed:1;
	unsigned int Y_isUsed:1;
	unsigned int DigestValue_isUsed:1;
	unsigned int DC_EVChargeParameter_isUsed:1;
	unsigned int ContractSignatureEncryptedPrivateKey_isUsed:1;
	unsigned int DigestMethod_isUsed:1;
	unsigned int SPKISexp_isUsed:1;
	unsigned int ChargeService_isUsed:1;
	unsigned int EVSEEnergyToBeDelivered_isUsed:1;
	unsigned int SignatureProperties_isUsed:1;
	unsigned int EVSEMaxCurrent_isUsed:1;
	unsigned int EVSEStatus_isUsed:1;
	unsigned int Service_isUsed:1;
	unsigned int DHParams_isUsed:1;
	unsigned int PGPKeyID_isUsed:1;
	unsigned int DSAKeyValue_isUsed:1;
	unsigned int EnergyTransferType_isUsed:1;
	unsigned int WeldingDetectionRes_isUsed:1;
	unsigned int FreeService_isUsed:1;
	unsigned int SelectedServiceList_isUsed:1;
	unsigned int WeldingDetectionReq_isUsed:1;
	unsigned int EVTargetVoltage_isUsed:1;
	unsigned int CanonicalizationMethod_isUsed:1;
	unsigned int X509Certificate_isUsed:1;
	unsigned int CertificateUpdateRes_isUsed:1;
	unsigned int CertificateUpdateReq_isUsed:1;
	unsigned int EVSEMaxVoltage_isUsed:1;
	unsigned int SignedInfo_isUsed:1;
	unsigned int AC_EVSEChargeParameter_isUsed:1;
	unsigned int EVEnergyCapacity_isUsed:1;
	unsigned int ServiceID_isUsed:1;
	unsigned int EVSECurrentRegulationTolerance_isUsed:1;
	unsigned int ServiceParameterList_isUsed:1;
	unsigned int ListOfRootCertificateIDs_isUsed:1;
	unsigned int ProfileEntry_isUsed:1;
	unsigned int EVSEMinimumVoltageLimit_isUsed:1;
	unsigned int CurrentDemandRes_isUsed:1;
	unsigned int EVRESSSOC_isUsed:1;
	unsigned int MeterReading_isUsed:1;
	unsigned int CurrentDemandReq_isUsed:1;
	unsigned int physicalValue_isUsed:1;
	unsigned int TimeInterval_isUsed:1;
	unsigned int AC_EVSEStatus_isUsed:1;
	unsigned int EVMaximumVoltageLimit_isUsed:1;
	unsigned int SignatureValue_isUsed:1;
	unsigned int DateTimeNow_isUsed:1;
	unsigned int ServiceTag_isUsed:1;
	unsigned int intValue_isUsed:1;
	unsigned int SelectedPaymentOption_isUsed:1;
	unsigned int ServiceName_isUsed:1;
	unsigned int EVCabinConditioning_isUsed:1;
	unsigned int EVSEID_isUsed:1;
	unsigned int ServiceScope_isUsed:1;
	unsigned int MeterStatus_isUsed:1;
	unsigned int EVRequestedEnergyTransferType_isUsed:1;
	unsigned int ServiceCategory_isUsed:1;
	unsigned int GenChallenge_isUsed:1;
	unsigned int SalesTariffDescription_isUsed:1;
	unsigned int NotificationMaxDelay_isUsed:1;
	unsigned int boolValue_isUsed:1;
	unsigned int EVSEStatusCode_isUsed:1;
	unsigned int FaultMsg_isUsed:1;
	unsigned int KeyName_isUsed:1;
	unsigned int ParameterSet_isUsed:1;
	unsigned int SigMeterReading_isUsed:1;
	unsigned int EVSEChargeParameter_isUsed:1;
	unsigned int Body_isUsed:1;
	unsigned int SASchedules_isUsed:1;
	unsigned int KeyInfo_isUsed:1;
	unsigned int PMaxScheduleID_isUsed:1;
	unsigned int RemainingTimeToFullSoC_isUsed:1;
	unsigned int EVStatus_isUsed:1;
	unsigned int SubCertificates_isUsed:1;
	unsigned int PaymentOption_isUsed:1;
	unsigned int X509SKI_isUsed:1;
	unsigned int ServiceList_isUsed:1;
	unsigned int Cost_isUsed:1;
	unsigned int SignatureMethod_isUsed:1;
	unsigned int EVSEMinCurrent_isUsed:1;
	unsigned int ConsumptionCost_isUsed:1;
	unsigned int EVSEPeakCurrentRipple_isUsed:1;
	unsigned int EVErrorCode_isUsed:1;
	unsigned int EVChargeParameter_isUsed:1;
	unsigned int start_isUsed:1;
	unsigned int X509IssuerName_isUsed:1;
	unsigned int Reference_isUsed:1;
	unsigned int EVMinCurrent_isUsed:1;
	unsigned int FullSOC_isUsed:1;
	unsigned int amount_isUsed:1;
	unsigned int shortValue_isUsed:1;
	unsigned int DC_EVSEChargeParameter_isUsed:1;
	unsigned int Entry_isUsed:1;
	unsigned int SalesTariffID_isUsed:1;
	unsigned int MeterID_isUsed:1;
	unsigned int ChargeParameterDiscoveryReq_isUsed:1;
	unsigned int amountMultiplier_isUsed:1;
	unsigned int ChargeParameterDiscoveryRes_isUsed:1;
	unsigned int Transform_isUsed:1;
	unsigned int Object_isUsed:1;
	unsigned int RCD_isUsed:1;
	unsigned int Notification_isUsed:1;
	unsigned int startValue_isUsed:1;
	unsigned int Modulus_isUsed:1;


	int _warning_;
};
#endif /* DEPLOY_DIN_CODEC_FRAGMENT */


/* Initialization methods for structs */

void init_dinEXIDocument(struct dinEXIDocument* exiDoc);
#if DEPLOY_DIN_CODEC_FRAGMENT == SUPPORT_YES
void init_dinEXIFragment(struct dinEXIFragment* exiFrag);
#endif /* DEPLOY_DIN_CODEC_FRAGMENT */
void init_dinMeteringReceiptReqType(struct dinMeteringReceiptReqType* dinMeteringReceiptReqType);
void init_dinBodyType(struct dinBodyType* dinBodyType);
void init_dinSessionSetupReqType(struct dinSessionSetupReqType* dinSessionSetupReqType);
void init_dinPowerDeliveryResType(struct dinPowerDeliveryResType* dinPowerDeliveryResType);
void init_dinServiceDetailResType(struct dinServiceDetailResType* dinServiceDetailResType);
void init_dinWeldingDetectionResType(struct dinWeldingDetectionResType* dinWeldingDetectionResType);
void init_dinContractAuthenticationResType(struct dinContractAuthenticationResType* dinContractAuthenticationResType);
void init_dinCanonicalizationMethodType(struct dinCanonicalizationMethodType* dinCanonicalizationMethodType);
void init_dinSPKIDataType(struct dinSPKIDataType* dinSPKIDataType);
void init_dinListOfRootCertificateIDsType(struct dinListOfRootCertificateIDsType* dinListOfRootCertificateIDsType);
void init_dinSelectedServiceListType(struct dinSelectedServiceListType* dinSelectedServiceListType);
void init_dinCurrentDemandResType(struct dinCurrentDemandResType* dinCurrentDemandResType);
void init_dinTransformType(struct dinTransformType* dinTransformType);
void init_dinAC_EVChargeParameterType(struct dinAC_EVChargeParameterType* dinAC_EVChargeParameterType);
void init_dinX509DataType(struct dinX509DataType* dinX509DataType);
void init_dinChargingStatusResType(struct dinChargingStatusResType* dinChargingStatusResType);
void init_dinWeldingDetectionReqType(struct dinWeldingDetectionReqType* dinWeldingDetectionReqType);
void init_dinSignaturePropertiesType(struct dinSignaturePropertiesType* dinSignaturePropertiesType);
void init_dinContractAuthenticationReqType(struct dinContractAuthenticationReqType* dinContractAuthenticationReqType);
void init_dinDC_EVPowerDeliveryParameterType(struct dinDC_EVPowerDeliveryParameterType* dinDC_EVPowerDeliveryParameterType);
void init_dinEVSEChargeParameterType(struct dinEVSEChargeParameterType* dinEVSEChargeParameterType);
void init_dinCableCheckReqType(struct dinCableCheckReqType* dinCableCheckReqType);
void init_dinDC_EVChargeParameterType(struct dinDC_EVChargeParameterType* dinDC_EVChargeParameterType);
void init_dinSAScheduleListType(struct dinSAScheduleListType* dinSAScheduleListType);
void init_dinPMaxScheduleType(struct dinPMaxScheduleType* dinPMaxScheduleType);
void init_dinServicePaymentSelectionReqType(struct dinServicePaymentSelectionReqType* dinServicePaymentSelectionReqType);
void init_dinRelativeTimeIntervalType(struct dinRelativeTimeIntervalType* dinRelativeTimeIntervalType);
void init_dinEVStatusType(struct dinEVStatusType* dinEVStatusType);
void init_dinPreChargeResType(struct dinPreChargeResType* dinPreChargeResType);
void init_dinDC_EVSEChargeParameterType(struct dinDC_EVSEChargeParameterType* dinDC_EVSEChargeParameterType);
void init_dinPaymentDetailsResType(struct dinPaymentDetailsResType* dinPaymentDetailsResType);
void init_dinDSAKeyValueType(struct dinDSAKeyValueType* dinDSAKeyValueType);
void init_dinSASchedulesType(struct dinSASchedulesType* dinSASchedulesType);
void init_dinCertificateUpdateResType(struct dinCertificateUpdateResType* dinCertificateUpdateResType);
void init_dinEVChargeParameterType(struct dinEVChargeParameterType* dinEVChargeParameterType);
void init_dinMessageHeaderType(struct dinMessageHeaderType* dinMessageHeaderType);
void init_dinBodyBaseType(struct dinBodyBaseType* dinBodyBaseType);
void init_dinKeyValueType(struct dinKeyValueType* dinKeyValueType);
void init_dinIntervalType(struct dinIntervalType* dinIntervalType);
void init_dinChargeParameterDiscoveryResType(struct dinChargeParameterDiscoveryResType* dinChargeParameterDiscoveryResType);
void init_dinPowerDeliveryReqType(struct dinPowerDeliveryReqType* dinPowerDeliveryReqType);
void init_dinCertificateChainType(struct dinCertificateChainType* dinCertificateChainType);
void init_dinTransformsType(struct dinTransformsType* dinTransformsType);
void init_dinEntryType(struct dinEntryType* dinEntryType);
void init_dinSessionStopType(struct dinSessionStopType* dinSessionStopType);
void init_dinServiceDetailReqType(struct dinServiceDetailReqType* dinServiceDetailReqType);
void init_dinDigestMethodType(struct dinDigestMethodType* dinDigestMethodType);
void init_dinParameterType(struct dinParameterType* dinParameterType);
void init_dinChargingStatusReqType(struct dinChargingStatusReqType* dinChargingStatusReqType);
void init_dinSignatureMethodType(struct dinSignatureMethodType* dinSignatureMethodType);
void init_dinCertificateInstallationReqType(struct dinCertificateInstallationReqType* dinCertificateInstallationReqType);
void init_dinSalesTariffEntryType(struct dinSalesTariffEntryType* dinSalesTariffEntryType);
void init_dinServiceDiscoveryResType(struct dinServiceDiscoveryResType* dinServiceDiscoveryResType);
void init_dinParameterSetType(struct dinParameterSetType* dinParameterSetType);
void init_dinCurrentDemandReqType(struct dinCurrentDemandReqType* dinCurrentDemandReqType);
void init_dinPreChargeReqType(struct dinPreChargeReqType* dinPreChargeReqType);
void init_dinSignatureType(struct dinSignatureType* dinSignatureType);
void init_dinReferenceType(struct dinReferenceType* dinReferenceType);
void init_dinProfileEntryType(struct dinProfileEntryType* dinProfileEntryType);
void init_dinAnonType_V2G_Message(struct dinAnonType_V2G_Message* dinAnonType_V2G_Message);
void init_dinChargeParameterDiscoveryReqType(struct dinChargeParameterDiscoveryReqType* dinChargeParameterDiscoveryReqType);
void init_dinConsumptionCostType(struct dinConsumptionCostType* dinConsumptionCostType);
void init_dinRSAKeyValueType(struct dinRSAKeyValueType* dinRSAKeyValueType);
void init_dinServiceType(struct dinServiceType* dinServiceType);
void init_dinServiceTagListType(struct dinServiceTagListType* dinServiceTagListType);
void init_dinEVSEStatusType(struct dinEVSEStatusType* dinEVSEStatusType);
void init_dinSessionSetupResType(struct dinSessionSetupResType* dinSessionSetupResType);
void init_dinEVPowerDeliveryParameterType(struct dinEVPowerDeliveryParameterType* dinEVPowerDeliveryParameterType);
void init_dinX509IssuerSerialType(struct dinX509IssuerSerialType* dinX509IssuerSerialType);
void init_dinSelectedServiceType(struct dinSelectedServiceType* dinSelectedServiceType);
void init_dinMeteringReceiptResType(struct dinMeteringReceiptResType* dinMeteringReceiptResType);
void init_dinDC_EVStatusType(struct dinDC_EVStatusType* dinDC_EVStatusType);
void init_dinPhysicalValueType(struct dinPhysicalValueType* dinPhysicalValueType);
void init_dinManifestType(struct dinManifestType* dinManifestType);
void init_dinPMaxScheduleEntryType(struct dinPMaxScheduleEntryType* dinPMaxScheduleEntryType);
void init_dinServiceParameterListType(struct dinServiceParameterListType* dinServiceParameterListType);
void init_dinSignatureValueType(struct dinSignatureValueType* dinSignatureValueType);
void init_dinPaymentOptionsType(struct dinPaymentOptionsType* dinPaymentOptionsType);
void init_dinServiceTagType(struct dinServiceTagType* dinServiceTagType);
void init_dinAC_EVSEStatusType(struct dinAC_EVSEStatusType* dinAC_EVSEStatusType);
void init_dinCertificateUpdateReqType(struct dinCertificateUpdateReqType* dinCertificateUpdateReqType);
void init_dinServicePaymentSelectionResType(struct dinServicePaymentSelectionResType* dinServicePaymentSelectionResType);
void init_dinSAScheduleTupleType(struct dinSAScheduleTupleType* dinSAScheduleTupleType);
void init_dinChargingProfileType(struct dinChargingProfileType* dinChargingProfileType);
void init_dinServiceDiscoveryReqType(struct dinServiceDiscoveryReqType* dinServiceDiscoveryReqType);
void init_dinAC_EVSEChargeParameterType(struct dinAC_EVSEChargeParameterType* dinAC_EVSEChargeParameterType);
void init_dinKeyInfoType(struct dinKeyInfoType* dinKeyInfoType);
void init_dinPaymentDetailsReqType(struct dinPaymentDetailsReqType* dinPaymentDetailsReqType);
void init_dinCableCheckResType(struct dinCableCheckResType* dinCableCheckResType);
void init_dinObjectType(struct dinObjectType* dinObjectType);
void init_dinSessionStopResType(struct dinSessionStopResType* dinSessionStopResType);
void init_dinSignedInfoType(struct dinSignedInfoType* dinSignedInfoType);
void init_dinSalesTariffType(struct dinSalesTariffType* dinSalesTariffType);
void init_dinCostType(struct dinCostType* dinCostType);
void init_dinServiceChargeType(struct dinServiceChargeType* dinServiceChargeType);
void init_dinDC_EVSEStatusType(struct dinDC_EVSEStatusType* dinDC_EVSEStatusType);
void init_dinRetrievalMethodType(struct dinRetrievalMethodType* dinRetrievalMethodType);
void init_dinNotificationType(struct dinNotificationType* dinNotificationType);
void init_dinPGPDataType(struct dinPGPDataType* dinPGPDataType);
void init_dinCertificateInstallationResType(struct dinCertificateInstallationResType* dinCertificateInstallationResType);
void init_dinSignaturePropertyType(struct dinSignaturePropertyType* dinSignaturePropertyType);
void init_dinMeterInfoType(struct dinMeterInfoType* dinMeterInfoType);
void init_dinSubCertificatesType(struct dinSubCertificatesType* dinSubCertificatesType);


#endif /* DEPLOY_DIN_CODEC */

#ifdef __cplusplus
}
#endif

#endif
