/*
 * Copyright (C) 2007-2018 Siemens AG
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published
 * by the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

/*******************************************************************
 *
 * @author Daniel.Peintner.EXT@siemens.com
 * @version 2017-03-23
 * @contact Richard.Kuntschke@siemens.com
 *
 * <p>Code generated by EXIdizer</p>
 * <p>Schema: V2G_CI_MsgDef.xsd</p>
 *
 *
 ********************************************************************/



/**
 * \file 	EXIConfig.h
 * \brief 	EXI Configurations for the EXI Codec
 *
 */

#ifndef EXI_CONFIG_H
#define EXI_CONFIG_H

#ifdef __cplusplus
extern "C" {
#endif


/** EXI stream - Option Byte Array */
#define BYTE_ARRAY 1
/** EXI stream - Option File */
#define FILE_STREAM 2
/** \brief 	EXI stream
 *
 * 			Byte array or file
 * */
#define EXI_STREAM BYTE_ARRAY





/** Memory allocation - static */
#define STATIC_ALLOCATION 1
/** Memory allocation - dynamic */
#define DYNAMIC_ALLOCATION  2
/** */
/** \brief 	Memory allocation mode
 *
 * 			static or dynamic memory allocation
 * */
#define MEMORY_ALLOCATION STATIC_ALLOCATION



/** String representation ASCII */
#define STRING_REPRESENTATION_ASCII 1
/** String representation Universal Character Set (UCS) */
#define STRING_REPRESENTATION_UCS 2
/** */
/** \brief 	String representation mode
 *
 * 			ASCII or UCS
 * */
#define STRING_REPRESENTATION STRING_REPRESENTATION_ASCII


/* in the case of ASCII an extra char (null terminator) for printf and other functions is useful */
#if STRING_REPRESENTATION == STRING_REPRESENTATION_ASCII
#define EXTRA_CHAR 1
#endif /* STRING_REPRESENTATION_ASCII */
#if STRING_REPRESENTATION == STRING_REPRESENTATION_UCS
#define EXTRA_CHAR 0
#endif /* STRING_REPRESENTATION_UCS */





/** Maximum number of cascading elements, XML tree depth */
#define EXI_ELEMENT_STACK_SIZE 24


#ifdef __cplusplus
}
#endif

#endif /* EXI_CONFIG_H */

