<?php
/*
 * Bacula(R) - The Network Backup Solution
 * Baculum   - Bacula web interface
 *
 * Copyright (C) 2013-2019 Kern Sibbald
 *
 * The main author of Baculum is Marcin Haba.
 * The original author of Bacula is Kern Sibbald, with contributions
 * from many others, a complete list can be found in the file AUTHORS.
 *
 * You may use this file and others of this release according to the
 * license defined in the LICENSE file, which includes the Affero General
 * Public License, v3.0 ("AGPLv3") and some additional permissions and
 * terms pursuant to its AGPLv3 Section 7.
 *
 * This notice must be preserved when any source code is
 * conveyed and/or propagated.
 *
 * Bacula(R) is a registered trademark of Kern Sibbald.
 */

use Baculum\API\Modules\BaculumAPIServer;
use Baculum\Common\Modules\Errors\BVFSError;

/**
 * BVFS cleanup.
 *
 * @author Marcin Haba <marcin.haba@bacula.pl>
 * @category API
 * @package Baculum API
 */
class BVFSCleanUp extends BaculumAPIServer {

	public function set($id, $params) {
		$misc = $this->getModule('misc');
		$path = property_exists($params, 'path') ? $params->path : null;

		if (is_null($path) || !$misc->isValidBvfsPath($path)) {
			$this->output = BVFSError::MSG_ERROR_INVALID_RPATH;
			$this->error = BVFSError::ERROR_INVALID_RPATH;
			return;
		}

		$cmd = array('.bvfs_cleanup', 'path="' .  $path . '"');
		$result = $this->getModule('bconsole')->bconsoleCommand($this->director, $cmd);
		$this->output = $result->output;
		$this->error = $result->exitcode;
	}
}
?>
