# This file was automatically generated by SWIG (https://www.swig.org).
# Version 4.2.1
#
# Do not make changes to this file unless you know what you are doing - modify
# the SWIG interface file instead.


import json
from typing import Optional, Union



from sys import version_info as _swig_python_version_info
# Import the low-level C/C++ module
if __package__ or "." in __name__:
    from . import _verovio
else:
    import _verovio

try:
    import builtins as __builtin__
except ImportError:
    import __builtin__

def _swig_repr(self):
    try:
        strthis = "proxy of " + self.this.__repr__()
    except __builtin__.Exception:
        strthis = ""
    return "<%s.%s; %s >" % (self.__class__.__module__, self.__class__.__name__, strthis,)


def _swig_setattr_nondynamic_instance_variable(set):
    def set_instance_attr(self, name, value):
        if name == "this":
            set(self, name, value)
        elif name == "thisown":
            self.this.own(value)
        elif hasattr(self, name) and isinstance(getattr(type(self), name), property):
            set(self, name, value)
        else:
            raise AttributeError("You cannot add instance attributes to %s" % self)
    return set_instance_attr


def _swig_setattr_nondynamic_class_variable(set):
    def set_class_attr(cls, name, value):
        if hasattr(cls, name) and not isinstance(getattr(cls, name), property):
            set(cls, name, value)
        else:
            raise AttributeError("You cannot add class attributes to %s" % cls)
    return set_class_attr


def _swig_add_metaclass(metaclass):
    """Class decorator for adding a metaclass to a SWIG wrapped class - a slimmed down version of six.add_metaclass"""
    def wrapper(cls):
        return metaclass(cls.__name__, cls.__bases__, cls.__dict__.copy())
    return wrapper


class _SwigNonDynamicMeta(type):
    """Meta class to enforce nondynamic attributes (no new attributes) for a class"""
    __setattr__ = _swig_setattr_nondynamic_class_variable(type.__setattr__)


class toolkit(object):
    r"""Proxy of C++ vrv::Toolkit class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, initFont=True):
        r"""
        Constructor.

        :type initFont: boolean, optional
        :param initFont: If set to false, resource path is not initialized and SetResourcePath will have to be called
            explicitely
        """
        _verovio.toolkit_swiginit(self, _verovio.new_toolkit(initFont))
    __swig_destroy__ = _verovio.delete_toolkit

    def getID(self):
        r"""
        Return the ID of the Toolkit instance.

        Remarks: nojs

        :rtype: string
        :return: The ID as as string
        """
        return _verovio.toolkit_getID(self)

    def getResourcePath(self):
        r"""
        Get the resource path for the Toolkit instance.

        Remarks: nojs

        :rtype: string
        :return: A string with the resource path
        """
        return _verovio.toolkit_getResourcePath(self)

    def setResourcePath(self, path):
        r"""
        Set the resource path for the Toolkit instance.

        This method needs to be called if the constructor had initFont=false or if the resource path
        needs to be changed.

        Remarks: nojs

        :type path: string
        :param path: The path to the resource directory
        :rtype: boolean
        :return: True if the resources was successfully loaded
        """
        return _verovio.toolkit_setResourcePath(self, path)

    def getLog(self):
        r"""
        Get the log content for the latest operation.

        :rtype: string
        :return: The log content as a string
        """
        return _verovio.toolkit_getLog(self)

    def getVersion(self):
        r"""
        Return the version number.

        :rtype: string
        :return: the version number as a string
        """
        return _verovio.toolkit_getVersion(self)

    def resetXmlIdSeed(self, seed):
        r"""
        Reset the seed used to generate MEI @xml:id attribute values

        Passing 0 will seed the @xml:id generator with a random (time-based) seed value.
        This method will have no effect if the --xml-id-checksum option is set.

        :type seed: int
        :param seed: The seed value for generating the @xml:id values (0 for a time-based random seed)
        """
        return _verovio.toolkit_resetXmlIdSeed(self, seed)

    def loadFile(self, filename):
        r"""
        Load a file from the file system.

        Previously convert UTF16 files to UTF8 or extract files from MusicXML compressed files.

        Remarks: nojs

        :type filename: string
        :param filename: The filename to be loaded
        :rtype: boolean
        :return: True if the file was successfully loaded
        """
        return _verovio.toolkit_loadFile(self, filename)

    def loadData(self, data):
        r"""
        Load a string data with the type previously specified in the options.

        By default, the methods try to auto-detect the type.

        :type data: string
        :param data: A string with the data (e.g., MEI data) to be loaded
        :rtype: boolean
        :return: True if the data was successfully loaded
        """
        return _verovio.toolkit_loadData(self, data)

    def loadZipDataBase64(self, data):
        r"""
        Load a MusicXML compressed file passed as base64 encoded string.

        :type data: string
        :param data: A ZIP file as a base64 encoded string
        :rtype: boolean
        :return: True if the data was successfully loaded
        """
        return _verovio.toolkit_loadZipDataBase64(self, data)

    def loadZipDataBuffer(self, data, length):
        r"""
        Load a MusicXML compressed file passed as a buffer of bytes.

        :type data: unsigned char
        :param data: A ZIP file as a buffer of bytes
        :type length: int
        :param length: The size of the data buffer
        :rtype: boolean
        :return: True if the data was successfully loaded
        """
        return _verovio.toolkit_loadZipDataBuffer(self, data, length)

    def validatePAEFile(self, filename):
        r"""
        Validate the Plaine & Easie code from a file.

        The method calls Toolkit::ValidatePAE.

        Remarks: nojs

        :type filename: string
        :param filename: The filename to be validated
        :rtype: string
        :return: A stringified JSON object with the validation warnings or errors
        """
        return _verovio.toolkit_validatePAEFile(self, filename)

    def validatePAE(toolkit, data: Union[str, dict]) -> dict:
        """Validate the Plaine and Easie code passed in the string data."""
        if isinstance(data, dict):
            data = json.dumps(data);
        return json.loads(_verovio.toolkit_validatePAE(toolkit, data))



    def getPageCount(self):
        r"""
        Return the number of pages in the loaded document.

        The number of pages depends one the page size and if encoded layout was taken into account or not.

        :rtype: int
        :return: The number of pages
        """
        return _verovio.toolkit_getPageCount(self)

    def getOptions(toolkit) -> dict:
        """Return a dictionary of all the options with their current value."""
        return json.loads(_verovio.toolkit_getOptions(toolkit))



    def getDefaultOptions(toolkit) -> dict:
        """Return a dictionary of all the options with their default value."""
        return json.loads(_verovio.toolkit_getDefaultOptions(toolkit))



    def getAvailableOptions(toolkit) -> dict:
        """Return a dictionary of all the options with their default value."""
        return json.loads(_verovio.toolkit_getAvailableOptions(toolkit))



    def setOptions(toolkit, json_options: dict) -> bool:
        """Set option values."""
        return _verovio.toolkit_setOptions(toolkit, json.dumps(json_options))



    def resetOptions(self):
        r"""Reset all options to default values"""
        return _verovio.toolkit_resetOptions(self)

    def printOptionUsage(self, category, output):
        r"""Print formatted option usage for specific category (with max/min/default values) to output stream."""
        return _verovio.toolkit_printOptionUsage(self, category, output)

    def getOptionUsageString(self):
        r"""Get all usage for all option categories as string."""
        return _verovio.toolkit_getOptionUsageString(self)

    def setScale(self, scale):
        r"""
        Set the scale option.

        Remarks: nojs

        :type scale: int
        :param scale: the scale value as integer
        :rtype: boolean
        :return: True if the option was successfully set
        """
        return _verovio.toolkit_setScale(self, scale)

    def getScale(self):
        r"""
        Get the scale option.

        Remarks: nojs

        :rtype: int
        :return: the scale option as integer
        """
        return _verovio.toolkit_getScale(self)

    def setOutputTo(self, outputTo):
        r"""
        Set the output to option.

        Remarks: nojs

        :type outputTo: string
        :param outputTo: the output to value as string
        :rtype: boolean
        :return: True if the option was successfully set
        """
        return _verovio.toolkit_setOutputTo(self, outputTo)

    def select(toolkit, selection: dict) -> bool:
        """Set the value for a selection."""
        return _verovio.toolkit_select(toolkit, json.dumps(selection))



    def edit(toolkit, editor_action: dict) -> bool:
        """Edit the MEI data."""
        return _verovio.toolkit_edit(toolkit, json.dumps(editor_action))



    def editInfo(toolkit) -> dict:
        """Return the editor status."""
        return json.loads(_verovio.toolkit_editInfo(toolkit))



    def renderData(toolkit, data, options: dict) -> str:
        """Render the first page of the data to SVG."""
        return _verovio.toolkit_renderData(toolkit, data, json.dumps(options))



    def renderToSVG(self, pageNo=1, xmlDeclaration=False):
        r"""
        Render a page to SVG.

        :type pageNo: int, optional
        :param pageNo: The page to render (1-based)
        :type xmlDeclaration: boolean, optional
        :param xmlDeclaration: True for including the xml declaration in the SVG output
        :rtype: string
        :return: The SVG page as a string
        """
        return _verovio.toolkit_renderToSVG(self, pageNo, xmlDeclaration)

    def renderToSVGFile(self, filename, pageNo=1):
        r"""
        Render a page to SVG and save it to the file.

        Remarks: nojs

        :type filename: string
        :param filename: The output filename
        :type pageNo: int, optional
        :param pageNo: The page to render (1-based)
        :rtype: boolean
        :return: True if the file was successfully written
        """
        return _verovio.toolkit_renderToSVGFile(self, filename, pageNo)

    def renderToMIDI(self):
        r"""
        Render the document to MIDI.

        :rtype: string
        :return: A MIDI file as a base64 encoded string
        """
        return _verovio.toolkit_renderToMIDI(self)

    def renderToMIDIFile(self, filename):
        r"""
        Render a document to MIDI and save it to the file.

        Remarks: nojs

        :type filename: string
        :param filename: The output filename
        :rtype: boolean
        :return: True if the file was successfully written
        """
        return _verovio.toolkit_renderToMIDIFile(self, filename)

    def renderToPAE(self):
        r"""
        Render a document to Plaine & Easie code.

        Only the top staff / layer is exported.

        :rtype: string
        :return: The PAE as a string
        """
        return _verovio.toolkit_renderToPAE(self)

    def renderToPAEFile(self, filename):
        r"""
        Render a document to Plaine & Easie code and save it to the file.

        Only the top staff / layer is exported.

        Remarks: nojs

        :type filename: string
        :param filename: The output filename
        :rtype: boolean
        :return: True if the file was successfully written
        """
        return _verovio.toolkit_renderToPAEFile(self, filename)

    def renderToTimemap(toolkit, options: Optional[dict] = None) -> list:
        """Render a document to a timemap."""
        if options is None:
            options = {}
        return json.loads(_verovio.toolkit_renderToTimemap(toolkit, json.dumps(options)))



    def renderToExpansionMap(toolkit) -> list:
        """Render a document's expansion map, if existing."""
        return json.loads(_verovio.toolkit_renderToExpansionMap(toolkit))



    def renderToTimemapFile(toolkit, filename: str, options: Optional[dict] = None) -> bool:
        """Render a document to timemap and save it to the file."""
        if options is None:
            options = {}
        return _verovio.toolkit_renderToTimemapFile(toolkit, filename, json.dumps(options))



    def renderToExpansionMapFile(toolkit, filename: str) -> bool:
        """Render a document's expansion map and save it to a file."""
        return _verovio.toolkit_renderToExpansionMapFile(toolkit, filename)



    def convertMEIToHumdrum(self, meiData):
        r"""
        Convert MEI data into Humdrum data.

        :rtype: string
        :return: The Humdrum data as a string
        """
        return _verovio.toolkit_convertMEIToHumdrum(self, meiData)

    def convertHumdrumToHumdrum(self, humdrumData):
        r"""
        Filter Humdrum data.

        :rtype: string
        :return: The Humdrum data as a string
        """
        return _verovio.toolkit_convertHumdrumToHumdrum(self, humdrumData)

    def convertHumdrumToMIDI(self, humdrumData):
        r"""
        Convert Humdrum data to MIDI.

        :rtype: string
        :return: The MIDI file as a base64-encoded string
        """
        return _verovio.toolkit_convertHumdrumToMIDI(self, humdrumData)

    def getHumdrumFile(self, filename):
        r"""
        Write the humdrum buffer to the file.

        Remarks: nojs

        :type filename: string
        :param filename: The output filename
        :rtype: boolean
        :return: True if the file was successfully written
        """
        return _verovio.toolkit_getHumdrumFile(self, filename)

    def getMEI(toolkit, options: Optional[dict] = None) -> str:
        """Get the MEI as a string."""
        if options is None:
            options = {}
        return _verovio.toolkit_getMEI(toolkit, json.dumps(options))



    def saveFile(toolkit, filename: str, options: Optional[dict] = None) -> bool:
        """Get the MEI and save it to the file."""
        if options is None:
            options = {}
        return _verovio.toolkit_saveFile(toolkit, filename, json.dumps(options))



    def getDescriptiveFeatures(toolkit, options: Optional[dict] = None) -> dict:
        """Return descriptive features as dictionary."""
        if options is None:
            options = {}
        return json.loads(_verovio.toolkit_getDescriptiveFeatures(toolkit, json.dumps(options)))



    def getElementsAtTime(toolkit, millisec: int) -> dict:
        """Return array of IDs of elements being currently played."""
        return json.loads(_verovio.toolkit_getElementsAtTime(toolkit, millisec))



    def getPageWithElement(self, xmlId):
        r"""
        Return the page on which the element is the ID (@xml:id) is rendered

        This takes into account the current layout options.

        :type xmlId: string
        :param xmlId: the ID (@xml:id) of the element being looked for
        :rtype: int
        :return: the page number (1-based) where the element is (0 if not found)
        """
        return _verovio.toolkit_getPageWithElement(self, xmlId)

    def getElementAttr(toolkit, xml_id: str) -> dict:
        """Return element attributes as dictionary."""
        return json.loads(_verovio.toolkit_getElementAttr(toolkit, xml_id))



    def getNotatedIdForElement(self, xmlId):
        r"""
        Return the ID string of the notated (the original) element.

        :type xmlId: string
        :param xmlId: the ID (@xml:id) of the element being looked for
        :rtype: string
        :return: An ID string
        """
        return _verovio.toolkit_getNotatedIdForElement(self, xmlId)

    def getExpansionIdsForElement(toolkit, xml_id: str) -> dict:
        """Return a vector of ID strings of all elements (the notated and the expanded) for a given element."""
        return json.loads(_verovio.toolkit_getExpansionIdsForElement(toolkit, xml_id))



    def getTimeForElement(self, xmlId):
        r"""
        Return the time at which the element is the ID (@xml:id) is played

        RenderToMIDI() must be called prior to using this method.

        :type xmlId: string
        :param xmlId: the ID (@xml:id) of the element being looked for
        :rtype: int
        :return: The time in milliseconds
        """
        return _verovio.toolkit_getTimeForElement(self, xmlId)

    def getMIDIValuesForElement(toolkit, xml_id: str) -> dict:
        """Return MIDI values of the element with the ID (xml:id)."""
        return json.loads(_verovio.toolkit_getMIDIValuesForElement(toolkit, xml_id))



    def getTimesForElement(toolkit, xml_id: str) -> dict:
        """Return a dictionary with the following key values for a given note."""
        return json.loads(_verovio.toolkit_getTimesForElement(toolkit, xml_id))



    def redoLayout(toolkit, options: Optional[dict] = None) -> None:
        """Redo the layout of the loaded data."""
        if options is None:
            options = {}
        return _verovio.toolkit_redoLayout(toolkit, json.dumps(options))



    def redoPagePitchPosLayout(self):
        r"""
        Redo the layout of the pitch postitions of the current drawing page.

        Only the note vertical positions are recalculated with this method.
        RedoLayout() needs to be called for a full recalculation.
        """
        return _verovio.toolkit_redoPagePitchPosLayout(self)

    def renderToDeviceContext(self, pageNo, deviceContext):
        r"""
        They are marked with @ingroup nodoc


        Render the page to the deviceContext.

        Page number is 1-based.

        """
        return _verovio.toolkit_renderToDeviceContext(self, pageNo, deviceContext)

    def getHumdrum(self, *args):
        r"""
        *Overload 1:*

        Get the humdrum buffer.

        :rtype: string
        :return: The humdrum buffer as a string

        |

        *Overload 2:*

        Write the Humdrum buffer to the outputstream.

        """
        return _verovio.toolkit_getHumdrum(self, *args)

    def setHumdrumBuffer(self, contents):
        r"""
        Copy the data to the humdrum internal buffer.

        """
        return _verovio.toolkit_setHumdrumBuffer(self, contents)

    def getHumdrumBuffer(self):
        r"""
        Return the content of the humdrum internal buffer.

        Return "[empty]" if the buffer has not been allocated.

        """
        return _verovio.toolkit_getHumdrumBuffer(self)

    def clearHumdrumBuffer(self):
        r"""
        Clear the Humdrum buffer of any contents.

        """
        return _verovio.toolkit_clearHumdrumBuffer(self)

    def setInputFrom(self, *args):
        r"""
        *Overload 1:*

        Set the input from option.

        Remarks: nojs

        :type inputFrom: string
        :param inputFrom: the input from value as string
        :rtype: boolean
        :return: True if the option was successfully set

        |

        *Overload 2:*

        """
        return _verovio.toolkit_setInputFrom(self, *args)

    def getInputFrom(self):
        r"""
        Get the input format.

        :rtype: int
        :return: Input format enumeration

        """
        return _verovio.toolkit_getInputFrom(self)

    def getOutputTo(self):
        
        return _verovio.toolkit_getOutputTo(self)

    def initClock(self):
        r"""
        Measuring runtime.



        """
        return _verovio.toolkit_initClock(self)

    def resetClock(self):
        r"""resetClock(toolkit self)"""
        return _verovio.toolkit_resetClock(self)

    def getRuntimeInSeconds(self):
        r"""getRuntimeInSeconds(toolkit self) -> double"""
        return _verovio.toolkit_getRuntimeInSeconds(self)

    def logRuntime(self):
        r"""logRuntime(toolkit self)"""
        return _verovio.toolkit_logRuntime(self)

# Register toolkit in _verovio:
_verovio.toolkit_swigregister(toolkit)
UNKNOWN = _verovio.UNKNOWN

AUTO = _verovio.AUTO

MEI = _verovio.MEI

HUMDRUM = _verovio.HUMDRUM

HUMMEI = _verovio.HUMMEI

HUMMIDI = _verovio.HUMMIDI

PAE = _verovio.PAE

ABC = _verovio.ABC

DARMS = _verovio.DARMS

MUSICXML = _verovio.MUSICXML

MUSICXMLHUM = _verovio.MUSICXMLHUM

MEIHUM = _verovio.MEIHUM

MUSEDATAHUM = _verovio.MUSEDATAHUM

ESAC = _verovio.ESAC

MIDI = _verovio.MIDI

TIMEMAP = _verovio.TIMEMAP

EXPANSIONMAP = _verovio.EXPANSIONMAP

LOG_OFF = _verovio.LOG_OFF

LOG_ERROR = _verovio.LOG_ERROR

LOG_WARNING = _verovio.LOG_WARNING

LOG_INFO = _verovio.LOG_INFO

LOG_DEBUG = _verovio.LOG_DEBUG


def setDefaultResourcePath(path):
    r"""Functions defined here to be available in SWIG bindings"""
    return _verovio.setDefaultResourcePath(path)

def enableLog(level):
    r"""enableLog(vrv::LogLevel level)"""
    return _verovio.enableLog(level)

def enableLogToBuffer(value):
    r"""enableLogToBuffer(bool value)"""
    return _verovio.enableLogToBuffer(value)

