CREATE TYPE int1;

CREATE FUNCTION int1in(cstring) RETURNS int1
    IMMUTABLE
    STRICT
    LANGUAGE C
    AS '$libdir/uint', 'int1in';

CREATE FUNCTION int1out(int1) RETURNS cstring
    IMMUTABLE
    STRICT
    LANGUAGE C
    AS '$libdir/uint', 'int1out';

CREATE TYPE int1 (
    INPUT = int1in,
    OUTPUT = int1out,
    INTERNALLENGTH = 1,
    PASSEDBYVALUE,
    ALIGNMENT = char
);

CREATE CAST (double precision AS int1) WITH INOUT AS ASSIGNMENT;
CREATE CAST (numeric AS int1) WITH INOUT AS ASSIGNMENT;
CREATE CAST (real AS int1) WITH INOUT AS ASSIGNMENT;

CREATE CAST (int1 AS double precision) WITH INOUT AS IMPLICIT;
CREATE CAST (int1 AS numeric) WITH INOUT AS IMPLICIT;
CREATE CAST (int1 AS real) WITH INOUT AS IMPLICIT;


CREATE TYPE uint1;

CREATE FUNCTION uint1in(cstring) RETURNS uint1
    IMMUTABLE
    STRICT
    LANGUAGE C
    AS '$libdir/uint', 'uint1in';

CREATE FUNCTION uint1out(uint1) RETURNS cstring
    IMMUTABLE
    STRICT
    LANGUAGE C
    AS '$libdir/uint', 'uint1out';

CREATE TYPE uint1 (
    INPUT = uint1in,
    OUTPUT = uint1out,
    INTERNALLENGTH = 1,
    PASSEDBYVALUE,
    ALIGNMENT = char
);

CREATE CAST (double precision AS uint1) WITH INOUT AS ASSIGNMENT;
CREATE CAST (numeric AS uint1) WITH INOUT AS ASSIGNMENT;
CREATE CAST (real AS uint1) WITH INOUT AS ASSIGNMENT;

CREATE CAST (uint1 AS double precision) WITH INOUT AS IMPLICIT;
CREATE CAST (uint1 AS numeric) WITH INOUT AS IMPLICIT;
CREATE CAST (uint1 AS real) WITH INOUT AS IMPLICIT;


CREATE TYPE uint2;

CREATE FUNCTION uint2in(cstring) RETURNS uint2
    IMMUTABLE
    STRICT
    LANGUAGE C
    AS '$libdir/uint', 'uint2in';

CREATE FUNCTION uint2out(uint2) RETURNS cstring
    IMMUTABLE
    STRICT
    LANGUAGE C
    AS '$libdir/uint', 'uint2out';

CREATE TYPE uint2 (
    INPUT = uint2in,
    OUTPUT = uint2out,
    INTERNALLENGTH = 2,
    PASSEDBYVALUE,
    ALIGNMENT = int2
);

CREATE CAST (double precision AS uint2) WITH INOUT AS ASSIGNMENT;
CREATE CAST (numeric AS uint2) WITH INOUT AS ASSIGNMENT;
CREATE CAST (real AS uint2) WITH INOUT AS ASSIGNMENT;

CREATE CAST (uint2 AS double precision) WITH INOUT AS IMPLICIT;
CREATE CAST (uint2 AS numeric) WITH INOUT AS IMPLICIT;
CREATE CAST (uint2 AS real) WITH INOUT AS IMPLICIT;


CREATE TYPE uint4;

CREATE FUNCTION uint4in(cstring) RETURNS uint4
    IMMUTABLE
    STRICT
    LANGUAGE C
    AS '$libdir/uint', 'uint4in';

CREATE FUNCTION uint4out(uint4) RETURNS cstring
    IMMUTABLE
    STRICT
    LANGUAGE C
    AS '$libdir/uint', 'uint4out';

CREATE TYPE uint4 (
    INPUT = uint4in,
    OUTPUT = uint4out,
    INTERNALLENGTH = 4,
    PASSEDBYVALUE,
    ALIGNMENT = int4
);

CREATE CAST (double precision AS uint4) WITH INOUT AS ASSIGNMENT;
CREATE CAST (numeric AS uint4) WITH INOUT AS ASSIGNMENT;
CREATE CAST (real AS uint4) WITH INOUT AS ASSIGNMENT;

CREATE CAST (uint4 AS double precision) WITH INOUT AS IMPLICIT;
CREATE CAST (uint4 AS numeric) WITH INOUT AS IMPLICIT;
CREATE CAST (uint4 AS real) WITH INOUT AS IMPLICIT;


CREATE TYPE uint8;

CREATE FUNCTION uint8in(cstring) RETURNS uint8
    IMMUTABLE
    STRICT
    LANGUAGE C
    AS '$libdir/uint', 'uint8in';

CREATE FUNCTION uint8out(uint8) RETURNS cstring
    IMMUTABLE
    STRICT
    LANGUAGE C
    AS '$libdir/uint', 'uint8out';

CREATE TYPE uint8 (
    INPUT = uint8in,
    OUTPUT = uint8out,
    INTERNALLENGTH = 8,
    PASSEDBYVALUE,  -- requires 64-bit
    ALIGNMENT = double
);

CREATE CAST (double precision AS uint8) WITH INOUT AS ASSIGNMENT;
CREATE CAST (numeric AS uint8) WITH INOUT AS ASSIGNMENT;
CREATE CAST (real AS uint8) WITH INOUT AS ASSIGNMENT;

CREATE CAST (uint8 AS double precision) WITH INOUT AS IMPLICIT;
CREATE CAST (uint8 AS numeric) WITH INOUT AS IMPLICIT;
CREATE CAST (uint8 AS real) WITH INOUT AS IMPLICIT;


CREATE FUNCTION int1um(int1) RETURNS int1 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'int1um';

CREATE OPERATOR - (
   PROCEDURE = int1um,
   RIGHTARG = int1
);
CREATE FUNCTION hashint1(int1) RETURNS int4 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'hashint1';
CREATE FUNCTION hashuint1(uint1) RETURNS int4 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'hashuint1';
CREATE FUNCTION hashuint2(uint2) RETURNS int4 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'hashuint2';
CREATE FUNCTION hashuint4(uint4) RETURNS int4 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'hashuint4';
CREATE FUNCTION hashuint8(uint8) RETURNS int4 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'hashuint8';
CREATE FUNCTION to_hex(uint4) RETURNS text IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'to_hex_uint4';
CREATE FUNCTION to_hex(uint8) RETURNS text IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'to_hex_uint8';
CREATE FUNCTION int1int1lt(int1, int1) RETURNS boolean IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'int1int1lt';

CREATE OPERATOR < (
    LEFTARG = int1,
    RIGHTARG = int1,
    COMMUTATOR = >,
    NEGATOR = >=,
    RESTRICT = scalarltsel,
    JOIN = scalarltjoinsel,
    PROCEDURE = int1int1lt
);

CREATE FUNCTION int1int1le(int1, int1) RETURNS boolean IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'int1int1le';

CREATE OPERATOR <= (
    LEFTARG = int1,
    RIGHTARG = int1,
    COMMUTATOR = >=,
    NEGATOR = >,
    RESTRICT = scalarltsel,
    JOIN = scalarltjoinsel,
    PROCEDURE = int1int1le
);

CREATE FUNCTION int1int1eq(int1, int1) RETURNS boolean IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'int1int1eq';

CREATE OPERATOR = (
    LEFTARG = int1,
    RIGHTARG = int1,
    COMMUTATOR = =,
    NEGATOR = <>,
    RESTRICT = eqsel,
    JOIN = eqjoinsel,
    HASHES,
    MERGES,
    PROCEDURE = int1int1eq
);

CREATE FUNCTION int1int1ne(int1, int1) RETURNS boolean IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'int1int1ne';

CREATE OPERATOR <> (
    LEFTARG = int1,
    RIGHTARG = int1,
    COMMUTATOR = <>,
    NEGATOR = =,
    RESTRICT = neqsel,
    JOIN = neqjoinsel,
    PROCEDURE = int1int1ne
);

CREATE FUNCTION int1int1ge(int1, int1) RETURNS boolean IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'int1int1ge';

CREATE OPERATOR >= (
    LEFTARG = int1,
    RIGHTARG = int1,
    COMMUTATOR = <=,
    NEGATOR = <,
    RESTRICT = scalargtsel,
    JOIN = scalargtjoinsel,
    PROCEDURE = int1int1ge
);

CREATE FUNCTION int1int1gt(int1, int1) RETURNS boolean IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'int1int1gt';

CREATE OPERATOR > (
    LEFTARG = int1,
    RIGHTARG = int1,
    COMMUTATOR = <,
    NEGATOR = <=,
    RESTRICT = scalargtsel,
    JOIN = scalargtjoinsel,
    PROCEDURE = int1int1gt
);

CREATE FUNCTION btint1int1cmp(int1, int1) RETURNS integer IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'btint1int1cmp';

CREATE FUNCTION int1int1pl(int1, int1) RETURNS int1 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'int1int1pl';

CREATE OPERATOR + (
    LEFTARG = int1,
    RIGHTARG = int1,
    COMMUTATOR = +,
    PROCEDURE = int1int1pl
);

CREATE FUNCTION int1int1mi(int1, int1) RETURNS int1 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'int1int1mi';

CREATE OPERATOR - (
    LEFTARG = int1,
    RIGHTARG = int1,
    PROCEDURE = int1int1mi
);

CREATE FUNCTION int1int1mul(int1, int1) RETURNS int1 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'int1int1mul';

CREATE OPERATOR * (
    LEFTARG = int1,
    RIGHTARG = int1,
    COMMUTATOR = *,
    PROCEDURE = int1int1mul
);

CREATE FUNCTION int1int1div(int1, int1) RETURNS int1 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'int1int1div';

CREATE OPERATOR / (
    LEFTARG = int1,
    RIGHTARG = int1,
    PROCEDURE = int1int1div
);

CREATE FUNCTION mod(int1, int1) RETURNS int1 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'int1int1mod';

CREATE OPERATOR % (
    LEFTARG = int1,
    RIGHTARG = int1,
    PROCEDURE = mod
);

CREATE FUNCTION int1uint1lt(int1, uint1) RETURNS boolean IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'int1uint1lt';

CREATE OPERATOR < (
    LEFTARG = int1,
    RIGHTARG = uint1,
    COMMUTATOR = >,
    NEGATOR = >=,
    RESTRICT = scalarltsel,
    JOIN = scalarltjoinsel,
    PROCEDURE = int1uint1lt
);

CREATE FUNCTION int1uint1le(int1, uint1) RETURNS boolean IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'int1uint1le';

CREATE OPERATOR <= (
    LEFTARG = int1,
    RIGHTARG = uint1,
    COMMUTATOR = >=,
    NEGATOR = >,
    RESTRICT = scalarltsel,
    JOIN = scalarltjoinsel,
    PROCEDURE = int1uint1le
);

CREATE FUNCTION int1uint1eq(int1, uint1) RETURNS boolean IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'int1uint1eq';

CREATE OPERATOR = (
    LEFTARG = int1,
    RIGHTARG = uint1,
    COMMUTATOR = =,
    NEGATOR = <>,
    RESTRICT = eqsel,
    JOIN = eqjoinsel,
    HASHES,
    MERGES,
    PROCEDURE = int1uint1eq
);

CREATE FUNCTION int1uint1ne(int1, uint1) RETURNS boolean IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'int1uint1ne';

CREATE OPERATOR <> (
    LEFTARG = int1,
    RIGHTARG = uint1,
    COMMUTATOR = <>,
    NEGATOR = =,
    RESTRICT = neqsel,
    JOIN = neqjoinsel,
    PROCEDURE = int1uint1ne
);

CREATE FUNCTION int1uint1ge(int1, uint1) RETURNS boolean IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'int1uint1ge';

CREATE OPERATOR >= (
    LEFTARG = int1,
    RIGHTARG = uint1,
    COMMUTATOR = <=,
    NEGATOR = <,
    RESTRICT = scalargtsel,
    JOIN = scalargtjoinsel,
    PROCEDURE = int1uint1ge
);

CREATE FUNCTION int1uint1gt(int1, uint1) RETURNS boolean IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'int1uint1gt';

CREATE OPERATOR > (
    LEFTARG = int1,
    RIGHTARG = uint1,
    COMMUTATOR = <,
    NEGATOR = <=,
    RESTRICT = scalargtsel,
    JOIN = scalargtjoinsel,
    PROCEDURE = int1uint1gt
);

CREATE FUNCTION btint1uint1cmp(int1, uint1) RETURNS integer IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'btint1uint1cmp';

CREATE FUNCTION int1uint1pl(int1, uint1) RETURNS uint1 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'int1uint1pl';

CREATE OPERATOR + (
    LEFTARG = int1,
    RIGHTARG = uint1,
    COMMUTATOR = +,
    PROCEDURE = int1uint1pl
);

CREATE FUNCTION int1uint1mi(int1, uint1) RETURNS uint1 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'int1uint1mi';

CREATE OPERATOR - (
    LEFTARG = int1,
    RIGHTARG = uint1,
    PROCEDURE = int1uint1mi
);

CREATE FUNCTION int1uint1mul(int1, uint1) RETURNS uint1 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'int1uint1mul';

CREATE OPERATOR * (
    LEFTARG = int1,
    RIGHTARG = uint1,
    COMMUTATOR = *,
    PROCEDURE = int1uint1mul
);

CREATE FUNCTION int1uint1div(int1, uint1) RETURNS uint1 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'int1uint1div';

CREATE OPERATOR / (
    LEFTARG = int1,
    RIGHTARG = uint1,
    PROCEDURE = int1uint1div
);

CREATE FUNCTION mod(int1, uint1) RETURNS uint1 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'int1uint1mod';

CREATE OPERATOR % (
    LEFTARG = int1,
    RIGHTARG = uint1,
    PROCEDURE = mod
);

CREATE FUNCTION uint1(int1) RETURNS uint1 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'int1_to_uint1';

CREATE CAST (int1 AS uint1) WITH FUNCTION uint1(int1) AS ASSIGNMENT;

CREATE FUNCTION int1uint2lt(int1, uint2) RETURNS boolean IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'int1uint2lt';

CREATE OPERATOR < (
    LEFTARG = int1,
    RIGHTARG = uint2,
    COMMUTATOR = >,
    NEGATOR = >=,
    RESTRICT = scalarltsel,
    JOIN = scalarltjoinsel,
    PROCEDURE = int1uint2lt
);

CREATE FUNCTION int1uint2le(int1, uint2) RETURNS boolean IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'int1uint2le';

CREATE OPERATOR <= (
    LEFTARG = int1,
    RIGHTARG = uint2,
    COMMUTATOR = >=,
    NEGATOR = >,
    RESTRICT = scalarltsel,
    JOIN = scalarltjoinsel,
    PROCEDURE = int1uint2le
);

CREATE FUNCTION int1uint2eq(int1, uint2) RETURNS boolean IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'int1uint2eq';

CREATE OPERATOR = (
    LEFTARG = int1,
    RIGHTARG = uint2,
    COMMUTATOR = =,
    NEGATOR = <>,
    RESTRICT = eqsel,
    JOIN = eqjoinsel,
    HASHES,
    MERGES,
    PROCEDURE = int1uint2eq
);

CREATE FUNCTION int1uint2ne(int1, uint2) RETURNS boolean IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'int1uint2ne';

CREATE OPERATOR <> (
    LEFTARG = int1,
    RIGHTARG = uint2,
    COMMUTATOR = <>,
    NEGATOR = =,
    RESTRICT = neqsel,
    JOIN = neqjoinsel,
    PROCEDURE = int1uint2ne
);

CREATE FUNCTION int1uint2ge(int1, uint2) RETURNS boolean IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'int1uint2ge';

CREATE OPERATOR >= (
    LEFTARG = int1,
    RIGHTARG = uint2,
    COMMUTATOR = <=,
    NEGATOR = <,
    RESTRICT = scalargtsel,
    JOIN = scalargtjoinsel,
    PROCEDURE = int1uint2ge
);

CREATE FUNCTION int1uint2gt(int1, uint2) RETURNS boolean IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'int1uint2gt';

CREATE OPERATOR > (
    LEFTARG = int1,
    RIGHTARG = uint2,
    COMMUTATOR = <,
    NEGATOR = <=,
    RESTRICT = scalargtsel,
    JOIN = scalargtjoinsel,
    PROCEDURE = int1uint2gt
);

CREATE FUNCTION btint1uint2cmp(int1, uint2) RETURNS integer IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'btint1uint2cmp';

CREATE FUNCTION int1uint2pl(int1, uint2) RETURNS uint2 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'int1uint2pl';

CREATE OPERATOR + (
    LEFTARG = int1,
    RIGHTARG = uint2,
    COMMUTATOR = +,
    PROCEDURE = int1uint2pl
);

CREATE FUNCTION int1uint2mi(int1, uint2) RETURNS uint2 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'int1uint2mi';

CREATE OPERATOR - (
    LEFTARG = int1,
    RIGHTARG = uint2,
    PROCEDURE = int1uint2mi
);

CREATE FUNCTION int1uint2mul(int1, uint2) RETURNS uint2 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'int1uint2mul';

CREATE OPERATOR * (
    LEFTARG = int1,
    RIGHTARG = uint2,
    COMMUTATOR = *,
    PROCEDURE = int1uint2mul
);

CREATE FUNCTION int1uint2div(int1, uint2) RETURNS uint2 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'int1uint2div';

CREATE OPERATOR / (
    LEFTARG = int1,
    RIGHTARG = uint2,
    PROCEDURE = int1uint2div
);

CREATE FUNCTION mod(int1, uint2) RETURNS uint2 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'int1uint2mod';

CREATE OPERATOR % (
    LEFTARG = int1,
    RIGHTARG = uint2,
    PROCEDURE = mod
);

CREATE FUNCTION uint2(int1) RETURNS uint2 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'int1_to_uint2';

CREATE CAST (int1 AS uint2) WITH FUNCTION uint2(int1) AS IMPLICIT;

CREATE FUNCTION int1uint4lt(int1, uint4) RETURNS boolean IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'int1uint4lt';

CREATE OPERATOR < (
    LEFTARG = int1,
    RIGHTARG = uint4,
    COMMUTATOR = >,
    NEGATOR = >=,
    RESTRICT = scalarltsel,
    JOIN = scalarltjoinsel,
    PROCEDURE = int1uint4lt
);

CREATE FUNCTION int1uint4le(int1, uint4) RETURNS boolean IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'int1uint4le';

CREATE OPERATOR <= (
    LEFTARG = int1,
    RIGHTARG = uint4,
    COMMUTATOR = >=,
    NEGATOR = >,
    RESTRICT = scalarltsel,
    JOIN = scalarltjoinsel,
    PROCEDURE = int1uint4le
);

CREATE FUNCTION int1uint4eq(int1, uint4) RETURNS boolean IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'int1uint4eq';

CREATE OPERATOR = (
    LEFTARG = int1,
    RIGHTARG = uint4,
    COMMUTATOR = =,
    NEGATOR = <>,
    RESTRICT = eqsel,
    JOIN = eqjoinsel,
    HASHES,
    MERGES,
    PROCEDURE = int1uint4eq
);

CREATE FUNCTION int1uint4ne(int1, uint4) RETURNS boolean IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'int1uint4ne';

CREATE OPERATOR <> (
    LEFTARG = int1,
    RIGHTARG = uint4,
    COMMUTATOR = <>,
    NEGATOR = =,
    RESTRICT = neqsel,
    JOIN = neqjoinsel,
    PROCEDURE = int1uint4ne
);

CREATE FUNCTION int1uint4ge(int1, uint4) RETURNS boolean IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'int1uint4ge';

CREATE OPERATOR >= (
    LEFTARG = int1,
    RIGHTARG = uint4,
    COMMUTATOR = <=,
    NEGATOR = <,
    RESTRICT = scalargtsel,
    JOIN = scalargtjoinsel,
    PROCEDURE = int1uint4ge
);

CREATE FUNCTION int1uint4gt(int1, uint4) RETURNS boolean IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'int1uint4gt';

CREATE OPERATOR > (
    LEFTARG = int1,
    RIGHTARG = uint4,
    COMMUTATOR = <,
    NEGATOR = <=,
    RESTRICT = scalargtsel,
    JOIN = scalargtjoinsel,
    PROCEDURE = int1uint4gt
);

CREATE FUNCTION btint1uint4cmp(int1, uint4) RETURNS integer IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'btint1uint4cmp';

CREATE FUNCTION int1uint4pl(int1, uint4) RETURNS uint4 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'int1uint4pl';

CREATE OPERATOR + (
    LEFTARG = int1,
    RIGHTARG = uint4,
    COMMUTATOR = +,
    PROCEDURE = int1uint4pl
);

CREATE FUNCTION int1uint4mi(int1, uint4) RETURNS uint4 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'int1uint4mi';

CREATE OPERATOR - (
    LEFTARG = int1,
    RIGHTARG = uint4,
    PROCEDURE = int1uint4mi
);

CREATE FUNCTION int1uint4mul(int1, uint4) RETURNS uint4 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'int1uint4mul';

CREATE OPERATOR * (
    LEFTARG = int1,
    RIGHTARG = uint4,
    COMMUTATOR = *,
    PROCEDURE = int1uint4mul
);

CREATE FUNCTION int1uint4div(int1, uint4) RETURNS uint4 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'int1uint4div';

CREATE OPERATOR / (
    LEFTARG = int1,
    RIGHTARG = uint4,
    PROCEDURE = int1uint4div
);

CREATE FUNCTION mod(int1, uint4) RETURNS uint4 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'int1uint4mod';

CREATE OPERATOR % (
    LEFTARG = int1,
    RIGHTARG = uint4,
    PROCEDURE = mod
);

CREATE FUNCTION uint4(int1) RETURNS uint4 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'int1_to_uint4';

CREATE CAST (int1 AS uint4) WITH FUNCTION uint4(int1) AS IMPLICIT;

CREATE FUNCTION int1uint8lt(int1, uint8) RETURNS boolean IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'int1uint8lt';

CREATE OPERATOR < (
    LEFTARG = int1,
    RIGHTARG = uint8,
    COMMUTATOR = >,
    NEGATOR = >=,
    RESTRICT = scalarltsel,
    JOIN = scalarltjoinsel,
    PROCEDURE = int1uint8lt
);

CREATE FUNCTION int1uint8le(int1, uint8) RETURNS boolean IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'int1uint8le';

CREATE OPERATOR <= (
    LEFTARG = int1,
    RIGHTARG = uint8,
    COMMUTATOR = >=,
    NEGATOR = >,
    RESTRICT = scalarltsel,
    JOIN = scalarltjoinsel,
    PROCEDURE = int1uint8le
);

CREATE FUNCTION int1uint8eq(int1, uint8) RETURNS boolean IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'int1uint8eq';

CREATE OPERATOR = (
    LEFTARG = int1,
    RIGHTARG = uint8,
    COMMUTATOR = =,
    NEGATOR = <>,
    RESTRICT = eqsel,
    JOIN = eqjoinsel,
    HASHES,
    MERGES,
    PROCEDURE = int1uint8eq
);

CREATE FUNCTION int1uint8ne(int1, uint8) RETURNS boolean IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'int1uint8ne';

CREATE OPERATOR <> (
    LEFTARG = int1,
    RIGHTARG = uint8,
    COMMUTATOR = <>,
    NEGATOR = =,
    RESTRICT = neqsel,
    JOIN = neqjoinsel,
    PROCEDURE = int1uint8ne
);

CREATE FUNCTION int1uint8ge(int1, uint8) RETURNS boolean IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'int1uint8ge';

CREATE OPERATOR >= (
    LEFTARG = int1,
    RIGHTARG = uint8,
    COMMUTATOR = <=,
    NEGATOR = <,
    RESTRICT = scalargtsel,
    JOIN = scalargtjoinsel,
    PROCEDURE = int1uint8ge
);

CREATE FUNCTION int1uint8gt(int1, uint8) RETURNS boolean IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'int1uint8gt';

CREATE OPERATOR > (
    LEFTARG = int1,
    RIGHTARG = uint8,
    COMMUTATOR = <,
    NEGATOR = <=,
    RESTRICT = scalargtsel,
    JOIN = scalargtjoinsel,
    PROCEDURE = int1uint8gt
);

CREATE FUNCTION btint1uint8cmp(int1, uint8) RETURNS integer IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'btint1uint8cmp';

CREATE FUNCTION int1uint8pl(int1, uint8) RETURNS uint8 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'int1uint8pl';

CREATE OPERATOR + (
    LEFTARG = int1,
    RIGHTARG = uint8,
    COMMUTATOR = +,
    PROCEDURE = int1uint8pl
);

CREATE FUNCTION int1uint8mi(int1, uint8) RETURNS uint8 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'int1uint8mi';

CREATE OPERATOR - (
    LEFTARG = int1,
    RIGHTARG = uint8,
    PROCEDURE = int1uint8mi
);

CREATE FUNCTION int1uint8mul(int1, uint8) RETURNS uint8 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'int1uint8mul';

CREATE OPERATOR * (
    LEFTARG = int1,
    RIGHTARG = uint8,
    COMMUTATOR = *,
    PROCEDURE = int1uint8mul
);

CREATE FUNCTION int1uint8div(int1, uint8) RETURNS uint8 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'int1uint8div';

CREATE OPERATOR / (
    LEFTARG = int1,
    RIGHTARG = uint8,
    PROCEDURE = int1uint8div
);

CREATE FUNCTION mod(int1, uint8) RETURNS uint8 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'int1uint8mod';

CREATE OPERATOR % (
    LEFTARG = int1,
    RIGHTARG = uint8,
    PROCEDURE = mod
);

CREATE FUNCTION uint8(int1) RETURNS uint8 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'int1_to_uint8';

CREATE CAST (int1 AS uint8) WITH FUNCTION uint8(int1) AS IMPLICIT;

CREATE FUNCTION int1int2lt(int1, int2) RETURNS boolean IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'int1int2lt';

CREATE OPERATOR < (
    LEFTARG = int1,
    RIGHTARG = int2,
    COMMUTATOR = >,
    NEGATOR = >=,
    RESTRICT = scalarltsel,
    JOIN = scalarltjoinsel,
    PROCEDURE = int1int2lt
);

CREATE FUNCTION int1int2le(int1, int2) RETURNS boolean IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'int1int2le';

CREATE OPERATOR <= (
    LEFTARG = int1,
    RIGHTARG = int2,
    COMMUTATOR = >=,
    NEGATOR = >,
    RESTRICT = scalarltsel,
    JOIN = scalarltjoinsel,
    PROCEDURE = int1int2le
);

CREATE FUNCTION int1int2eq(int1, int2) RETURNS boolean IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'int1int2eq';

CREATE OPERATOR = (
    LEFTARG = int1,
    RIGHTARG = int2,
    COMMUTATOR = =,
    NEGATOR = <>,
    RESTRICT = eqsel,
    JOIN = eqjoinsel,
    HASHES,
    MERGES,
    PROCEDURE = int1int2eq
);

CREATE FUNCTION int1int2ne(int1, int2) RETURNS boolean IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'int1int2ne';

CREATE OPERATOR <> (
    LEFTARG = int1,
    RIGHTARG = int2,
    COMMUTATOR = <>,
    NEGATOR = =,
    RESTRICT = neqsel,
    JOIN = neqjoinsel,
    PROCEDURE = int1int2ne
);

CREATE FUNCTION int1int2ge(int1, int2) RETURNS boolean IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'int1int2ge';

CREATE OPERATOR >= (
    LEFTARG = int1,
    RIGHTARG = int2,
    COMMUTATOR = <=,
    NEGATOR = <,
    RESTRICT = scalargtsel,
    JOIN = scalargtjoinsel,
    PROCEDURE = int1int2ge
);

CREATE FUNCTION int1int2gt(int1, int2) RETURNS boolean IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'int1int2gt';

CREATE OPERATOR > (
    LEFTARG = int1,
    RIGHTARG = int2,
    COMMUTATOR = <,
    NEGATOR = <=,
    RESTRICT = scalargtsel,
    JOIN = scalargtjoinsel,
    PROCEDURE = int1int2gt
);

CREATE FUNCTION btint1int2cmp(int1, int2) RETURNS integer IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'btint1int2cmp';

CREATE FUNCTION int1int2pl(int1, int2) RETURNS int2 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'int1int2pl';

CREATE OPERATOR + (
    LEFTARG = int1,
    RIGHTARG = int2,
    COMMUTATOR = +,
    PROCEDURE = int1int2pl
);

CREATE FUNCTION int1int2mi(int1, int2) RETURNS int2 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'int1int2mi';

CREATE OPERATOR - (
    LEFTARG = int1,
    RIGHTARG = int2,
    PROCEDURE = int1int2mi
);

CREATE FUNCTION int1int2mul(int1, int2) RETURNS int2 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'int1int2mul';

CREATE OPERATOR * (
    LEFTARG = int1,
    RIGHTARG = int2,
    COMMUTATOR = *,
    PROCEDURE = int1int2mul
);

CREATE FUNCTION int1int2div(int1, int2) RETURNS int2 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'int1int2div';

CREATE OPERATOR / (
    LEFTARG = int1,
    RIGHTARG = int2,
    PROCEDURE = int1int2div
);

CREATE FUNCTION mod(int1, int2) RETURNS int2 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'int1int2mod';

CREATE OPERATOR % (
    LEFTARG = int1,
    RIGHTARG = int2,
    PROCEDURE = mod
);

CREATE FUNCTION int2(int1) RETURNS int2 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'int1_to_int2';

CREATE CAST (int1 AS int2) WITH FUNCTION int2(int1) AS IMPLICIT;

CREATE FUNCTION int1int4lt(int1, int4) RETURNS boolean IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'int1int4lt';

CREATE OPERATOR < (
    LEFTARG = int1,
    RIGHTARG = int4,
    COMMUTATOR = >,
    NEGATOR = >=,
    RESTRICT = scalarltsel,
    JOIN = scalarltjoinsel,
    PROCEDURE = int1int4lt
);

CREATE FUNCTION int1int4le(int1, int4) RETURNS boolean IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'int1int4le';

CREATE OPERATOR <= (
    LEFTARG = int1,
    RIGHTARG = int4,
    COMMUTATOR = >=,
    NEGATOR = >,
    RESTRICT = scalarltsel,
    JOIN = scalarltjoinsel,
    PROCEDURE = int1int4le
);

CREATE FUNCTION int1int4eq(int1, int4) RETURNS boolean IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'int1int4eq';

CREATE OPERATOR = (
    LEFTARG = int1,
    RIGHTARG = int4,
    COMMUTATOR = =,
    NEGATOR = <>,
    RESTRICT = eqsel,
    JOIN = eqjoinsel,
    HASHES,
    MERGES,
    PROCEDURE = int1int4eq
);

CREATE FUNCTION int1int4ne(int1, int4) RETURNS boolean IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'int1int4ne';

CREATE OPERATOR <> (
    LEFTARG = int1,
    RIGHTARG = int4,
    COMMUTATOR = <>,
    NEGATOR = =,
    RESTRICT = neqsel,
    JOIN = neqjoinsel,
    PROCEDURE = int1int4ne
);

CREATE FUNCTION int1int4ge(int1, int4) RETURNS boolean IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'int1int4ge';

CREATE OPERATOR >= (
    LEFTARG = int1,
    RIGHTARG = int4,
    COMMUTATOR = <=,
    NEGATOR = <,
    RESTRICT = scalargtsel,
    JOIN = scalargtjoinsel,
    PROCEDURE = int1int4ge
);

CREATE FUNCTION int1int4gt(int1, int4) RETURNS boolean IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'int1int4gt';

CREATE OPERATOR > (
    LEFTARG = int1,
    RIGHTARG = int4,
    COMMUTATOR = <,
    NEGATOR = <=,
    RESTRICT = scalargtsel,
    JOIN = scalargtjoinsel,
    PROCEDURE = int1int4gt
);

CREATE FUNCTION btint1int4cmp(int1, int4) RETURNS integer IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'btint1int4cmp';

CREATE FUNCTION int1int4pl(int1, int4) RETURNS int4 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'int1int4pl';

CREATE OPERATOR + (
    LEFTARG = int1,
    RIGHTARG = int4,
    COMMUTATOR = +,
    PROCEDURE = int1int4pl
);

CREATE FUNCTION int1int4mi(int1, int4) RETURNS int4 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'int1int4mi';

CREATE OPERATOR - (
    LEFTARG = int1,
    RIGHTARG = int4,
    PROCEDURE = int1int4mi
);

CREATE FUNCTION int1int4mul(int1, int4) RETURNS int4 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'int1int4mul';

CREATE OPERATOR * (
    LEFTARG = int1,
    RIGHTARG = int4,
    COMMUTATOR = *,
    PROCEDURE = int1int4mul
);

CREATE FUNCTION int1int4div(int1, int4) RETURNS int4 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'int1int4div';

CREATE OPERATOR / (
    LEFTARG = int1,
    RIGHTARG = int4,
    PROCEDURE = int1int4div
);

CREATE FUNCTION mod(int1, int4) RETURNS int4 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'int1int4mod';

CREATE OPERATOR % (
    LEFTARG = int1,
    RIGHTARG = int4,
    PROCEDURE = mod
);

CREATE FUNCTION int4(int1) RETURNS int4 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'int1_to_int4';

CREATE CAST (int1 AS int4) WITH FUNCTION int4(int1) AS IMPLICIT;

CREATE FUNCTION int1int8lt(int1, int8) RETURNS boolean IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'int1int8lt';

CREATE OPERATOR < (
    LEFTARG = int1,
    RIGHTARG = int8,
    COMMUTATOR = >,
    NEGATOR = >=,
    RESTRICT = scalarltsel,
    JOIN = scalarltjoinsel,
    PROCEDURE = int1int8lt
);

CREATE FUNCTION int1int8le(int1, int8) RETURNS boolean IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'int1int8le';

CREATE OPERATOR <= (
    LEFTARG = int1,
    RIGHTARG = int8,
    COMMUTATOR = >=,
    NEGATOR = >,
    RESTRICT = scalarltsel,
    JOIN = scalarltjoinsel,
    PROCEDURE = int1int8le
);

CREATE FUNCTION int1int8eq(int1, int8) RETURNS boolean IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'int1int8eq';

CREATE OPERATOR = (
    LEFTARG = int1,
    RIGHTARG = int8,
    COMMUTATOR = =,
    NEGATOR = <>,
    RESTRICT = eqsel,
    JOIN = eqjoinsel,
    HASHES,
    MERGES,
    PROCEDURE = int1int8eq
);

CREATE FUNCTION int1int8ne(int1, int8) RETURNS boolean IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'int1int8ne';

CREATE OPERATOR <> (
    LEFTARG = int1,
    RIGHTARG = int8,
    COMMUTATOR = <>,
    NEGATOR = =,
    RESTRICT = neqsel,
    JOIN = neqjoinsel,
    PROCEDURE = int1int8ne
);

CREATE FUNCTION int1int8ge(int1, int8) RETURNS boolean IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'int1int8ge';

CREATE OPERATOR >= (
    LEFTARG = int1,
    RIGHTARG = int8,
    COMMUTATOR = <=,
    NEGATOR = <,
    RESTRICT = scalargtsel,
    JOIN = scalargtjoinsel,
    PROCEDURE = int1int8ge
);

CREATE FUNCTION int1int8gt(int1, int8) RETURNS boolean IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'int1int8gt';

CREATE OPERATOR > (
    LEFTARG = int1,
    RIGHTARG = int8,
    COMMUTATOR = <,
    NEGATOR = <=,
    RESTRICT = scalargtsel,
    JOIN = scalargtjoinsel,
    PROCEDURE = int1int8gt
);

CREATE FUNCTION btint1int8cmp(int1, int8) RETURNS integer IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'btint1int8cmp';

CREATE FUNCTION int1int8pl(int1, int8) RETURNS int8 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'int1int8pl';

CREATE OPERATOR + (
    LEFTARG = int1,
    RIGHTARG = int8,
    COMMUTATOR = +,
    PROCEDURE = int1int8pl
);

CREATE FUNCTION int1int8mi(int1, int8) RETURNS int8 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'int1int8mi';

CREATE OPERATOR - (
    LEFTARG = int1,
    RIGHTARG = int8,
    PROCEDURE = int1int8mi
);

CREATE FUNCTION int1int8mul(int1, int8) RETURNS int8 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'int1int8mul';

CREATE OPERATOR * (
    LEFTARG = int1,
    RIGHTARG = int8,
    COMMUTATOR = *,
    PROCEDURE = int1int8mul
);

CREATE FUNCTION int1int8div(int1, int8) RETURNS int8 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'int1int8div';

CREATE OPERATOR / (
    LEFTARG = int1,
    RIGHTARG = int8,
    PROCEDURE = int1int8div
);

CREATE FUNCTION mod(int1, int8) RETURNS int8 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'int1int8mod';

CREATE OPERATOR % (
    LEFTARG = int1,
    RIGHTARG = int8,
    PROCEDURE = mod
);

CREATE FUNCTION int8(int1) RETURNS int8 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'int1_to_int8';

CREATE CAST (int1 AS int8) WITH FUNCTION int8(int1) AS IMPLICIT;

CREATE FUNCTION uint1int1lt(uint1, int1) RETURNS boolean IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint1int1lt';

CREATE OPERATOR < (
    LEFTARG = uint1,
    RIGHTARG = int1,
    COMMUTATOR = >,
    NEGATOR = >=,
    RESTRICT = scalarltsel,
    JOIN = scalarltjoinsel,
    PROCEDURE = uint1int1lt
);

CREATE FUNCTION uint1int1le(uint1, int1) RETURNS boolean IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint1int1le';

CREATE OPERATOR <= (
    LEFTARG = uint1,
    RIGHTARG = int1,
    COMMUTATOR = >=,
    NEGATOR = >,
    RESTRICT = scalarltsel,
    JOIN = scalarltjoinsel,
    PROCEDURE = uint1int1le
);

CREATE FUNCTION uint1int1eq(uint1, int1) RETURNS boolean IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint1int1eq';

CREATE OPERATOR = (
    LEFTARG = uint1,
    RIGHTARG = int1,
    COMMUTATOR = =,
    NEGATOR = <>,
    RESTRICT = eqsel,
    JOIN = eqjoinsel,
    HASHES,
    MERGES,
    PROCEDURE = uint1int1eq
);

CREATE FUNCTION uint1int1ne(uint1, int1) RETURNS boolean IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint1int1ne';

CREATE OPERATOR <> (
    LEFTARG = uint1,
    RIGHTARG = int1,
    COMMUTATOR = <>,
    NEGATOR = =,
    RESTRICT = neqsel,
    JOIN = neqjoinsel,
    PROCEDURE = uint1int1ne
);

CREATE FUNCTION uint1int1ge(uint1, int1) RETURNS boolean IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint1int1ge';

CREATE OPERATOR >= (
    LEFTARG = uint1,
    RIGHTARG = int1,
    COMMUTATOR = <=,
    NEGATOR = <,
    RESTRICT = scalargtsel,
    JOIN = scalargtjoinsel,
    PROCEDURE = uint1int1ge
);

CREATE FUNCTION uint1int1gt(uint1, int1) RETURNS boolean IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint1int1gt';

CREATE OPERATOR > (
    LEFTARG = uint1,
    RIGHTARG = int1,
    COMMUTATOR = <,
    NEGATOR = <=,
    RESTRICT = scalargtsel,
    JOIN = scalargtjoinsel,
    PROCEDURE = uint1int1gt
);

CREATE FUNCTION btuint1int1cmp(uint1, int1) RETURNS integer IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'btuint1int1cmp';

CREATE FUNCTION uint1int1pl(uint1, int1) RETURNS uint1 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint1int1pl';

CREATE OPERATOR + (
    LEFTARG = uint1,
    RIGHTARG = int1,
    COMMUTATOR = +,
    PROCEDURE = uint1int1pl
);

CREATE FUNCTION uint1int1mi(uint1, int1) RETURNS uint1 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint1int1mi';

CREATE OPERATOR - (
    LEFTARG = uint1,
    RIGHTARG = int1,
    PROCEDURE = uint1int1mi
);

CREATE FUNCTION uint1int1mul(uint1, int1) RETURNS uint1 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint1int1mul';

CREATE OPERATOR * (
    LEFTARG = uint1,
    RIGHTARG = int1,
    COMMUTATOR = *,
    PROCEDURE = uint1int1mul
);

CREATE FUNCTION uint1int1div(uint1, int1) RETURNS uint1 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint1int1div';

CREATE OPERATOR / (
    LEFTARG = uint1,
    RIGHTARG = int1,
    PROCEDURE = uint1int1div
);

CREATE FUNCTION mod(uint1, int1) RETURNS uint1 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint1int1mod';

CREATE OPERATOR % (
    LEFTARG = uint1,
    RIGHTARG = int1,
    PROCEDURE = mod
);

CREATE FUNCTION int1(uint1) RETURNS int1 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint1_to_int1';

CREATE CAST (uint1 AS int1) WITH FUNCTION int1(uint1) AS ASSIGNMENT;

CREATE FUNCTION uint1uint1lt(uint1, uint1) RETURNS boolean IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint1uint1lt';

CREATE OPERATOR < (
    LEFTARG = uint1,
    RIGHTARG = uint1,
    COMMUTATOR = >,
    NEGATOR = >=,
    RESTRICT = scalarltsel,
    JOIN = scalarltjoinsel,
    PROCEDURE = uint1uint1lt
);

CREATE FUNCTION uint1uint1le(uint1, uint1) RETURNS boolean IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint1uint1le';

CREATE OPERATOR <= (
    LEFTARG = uint1,
    RIGHTARG = uint1,
    COMMUTATOR = >=,
    NEGATOR = >,
    RESTRICT = scalarltsel,
    JOIN = scalarltjoinsel,
    PROCEDURE = uint1uint1le
);

CREATE FUNCTION uint1uint1eq(uint1, uint1) RETURNS boolean IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint1uint1eq';

CREATE OPERATOR = (
    LEFTARG = uint1,
    RIGHTARG = uint1,
    COMMUTATOR = =,
    NEGATOR = <>,
    RESTRICT = eqsel,
    JOIN = eqjoinsel,
    HASHES,
    MERGES,
    PROCEDURE = uint1uint1eq
);

CREATE FUNCTION uint1uint1ne(uint1, uint1) RETURNS boolean IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint1uint1ne';

CREATE OPERATOR <> (
    LEFTARG = uint1,
    RIGHTARG = uint1,
    COMMUTATOR = <>,
    NEGATOR = =,
    RESTRICT = neqsel,
    JOIN = neqjoinsel,
    PROCEDURE = uint1uint1ne
);

CREATE FUNCTION uint1uint1ge(uint1, uint1) RETURNS boolean IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint1uint1ge';

CREATE OPERATOR >= (
    LEFTARG = uint1,
    RIGHTARG = uint1,
    COMMUTATOR = <=,
    NEGATOR = <,
    RESTRICT = scalargtsel,
    JOIN = scalargtjoinsel,
    PROCEDURE = uint1uint1ge
);

CREATE FUNCTION uint1uint1gt(uint1, uint1) RETURNS boolean IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint1uint1gt';

CREATE OPERATOR > (
    LEFTARG = uint1,
    RIGHTARG = uint1,
    COMMUTATOR = <,
    NEGATOR = <=,
    RESTRICT = scalargtsel,
    JOIN = scalargtjoinsel,
    PROCEDURE = uint1uint1gt
);

CREATE FUNCTION btuint1uint1cmp(uint1, uint1) RETURNS integer IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'btuint1uint1cmp';

CREATE FUNCTION uint1uint1pl(uint1, uint1) RETURNS uint1 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint1uint1pl';

CREATE OPERATOR + (
    LEFTARG = uint1,
    RIGHTARG = uint1,
    COMMUTATOR = +,
    PROCEDURE = uint1uint1pl
);

CREATE FUNCTION uint1uint1mi(uint1, uint1) RETURNS uint1 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint1uint1mi';

CREATE OPERATOR - (
    LEFTARG = uint1,
    RIGHTARG = uint1,
    PROCEDURE = uint1uint1mi
);

CREATE FUNCTION uint1uint1mul(uint1, uint1) RETURNS uint1 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint1uint1mul';

CREATE OPERATOR * (
    LEFTARG = uint1,
    RIGHTARG = uint1,
    COMMUTATOR = *,
    PROCEDURE = uint1uint1mul
);

CREATE FUNCTION uint1uint1div(uint1, uint1) RETURNS uint1 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint1uint1div';

CREATE OPERATOR / (
    LEFTARG = uint1,
    RIGHTARG = uint1,
    PROCEDURE = uint1uint1div
);

CREATE FUNCTION mod(uint1, uint1) RETURNS uint1 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint1uint1mod';

CREATE OPERATOR % (
    LEFTARG = uint1,
    RIGHTARG = uint1,
    PROCEDURE = mod
);

CREATE FUNCTION uint1uint2lt(uint1, uint2) RETURNS boolean IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint1uint2lt';

CREATE OPERATOR < (
    LEFTARG = uint1,
    RIGHTARG = uint2,
    COMMUTATOR = >,
    NEGATOR = >=,
    RESTRICT = scalarltsel,
    JOIN = scalarltjoinsel,
    PROCEDURE = uint1uint2lt
);

CREATE FUNCTION uint1uint2le(uint1, uint2) RETURNS boolean IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint1uint2le';

CREATE OPERATOR <= (
    LEFTARG = uint1,
    RIGHTARG = uint2,
    COMMUTATOR = >=,
    NEGATOR = >,
    RESTRICT = scalarltsel,
    JOIN = scalarltjoinsel,
    PROCEDURE = uint1uint2le
);

CREATE FUNCTION uint1uint2eq(uint1, uint2) RETURNS boolean IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint1uint2eq';

CREATE OPERATOR = (
    LEFTARG = uint1,
    RIGHTARG = uint2,
    COMMUTATOR = =,
    NEGATOR = <>,
    RESTRICT = eqsel,
    JOIN = eqjoinsel,
    HASHES,
    MERGES,
    PROCEDURE = uint1uint2eq
);

CREATE FUNCTION uint1uint2ne(uint1, uint2) RETURNS boolean IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint1uint2ne';

CREATE OPERATOR <> (
    LEFTARG = uint1,
    RIGHTARG = uint2,
    COMMUTATOR = <>,
    NEGATOR = =,
    RESTRICT = neqsel,
    JOIN = neqjoinsel,
    PROCEDURE = uint1uint2ne
);

CREATE FUNCTION uint1uint2ge(uint1, uint2) RETURNS boolean IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint1uint2ge';

CREATE OPERATOR >= (
    LEFTARG = uint1,
    RIGHTARG = uint2,
    COMMUTATOR = <=,
    NEGATOR = <,
    RESTRICT = scalargtsel,
    JOIN = scalargtjoinsel,
    PROCEDURE = uint1uint2ge
);

CREATE FUNCTION uint1uint2gt(uint1, uint2) RETURNS boolean IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint1uint2gt';

CREATE OPERATOR > (
    LEFTARG = uint1,
    RIGHTARG = uint2,
    COMMUTATOR = <,
    NEGATOR = <=,
    RESTRICT = scalargtsel,
    JOIN = scalargtjoinsel,
    PROCEDURE = uint1uint2gt
);

CREATE FUNCTION btuint1uint2cmp(uint1, uint2) RETURNS integer IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'btuint1uint2cmp';

CREATE FUNCTION uint1uint2pl(uint1, uint2) RETURNS uint2 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint1uint2pl';

CREATE OPERATOR + (
    LEFTARG = uint1,
    RIGHTARG = uint2,
    COMMUTATOR = +,
    PROCEDURE = uint1uint2pl
);

CREATE FUNCTION uint1uint2mi(uint1, uint2) RETURNS uint2 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint1uint2mi';

CREATE OPERATOR - (
    LEFTARG = uint1,
    RIGHTARG = uint2,
    PROCEDURE = uint1uint2mi
);

CREATE FUNCTION uint1uint2mul(uint1, uint2) RETURNS uint2 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint1uint2mul';

CREATE OPERATOR * (
    LEFTARG = uint1,
    RIGHTARG = uint2,
    COMMUTATOR = *,
    PROCEDURE = uint1uint2mul
);

CREATE FUNCTION uint1uint2div(uint1, uint2) RETURNS uint2 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint1uint2div';

CREATE OPERATOR / (
    LEFTARG = uint1,
    RIGHTARG = uint2,
    PROCEDURE = uint1uint2div
);

CREATE FUNCTION mod(uint1, uint2) RETURNS uint2 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint1uint2mod';

CREATE OPERATOR % (
    LEFTARG = uint1,
    RIGHTARG = uint2,
    PROCEDURE = mod
);

CREATE FUNCTION uint2(uint1) RETURNS uint2 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint1_to_uint2';

CREATE CAST (uint1 AS uint2) WITH FUNCTION uint2(uint1) AS IMPLICIT;

CREATE FUNCTION uint1uint4lt(uint1, uint4) RETURNS boolean IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint1uint4lt';

CREATE OPERATOR < (
    LEFTARG = uint1,
    RIGHTARG = uint4,
    COMMUTATOR = >,
    NEGATOR = >=,
    RESTRICT = scalarltsel,
    JOIN = scalarltjoinsel,
    PROCEDURE = uint1uint4lt
);

CREATE FUNCTION uint1uint4le(uint1, uint4) RETURNS boolean IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint1uint4le';

CREATE OPERATOR <= (
    LEFTARG = uint1,
    RIGHTARG = uint4,
    COMMUTATOR = >=,
    NEGATOR = >,
    RESTRICT = scalarltsel,
    JOIN = scalarltjoinsel,
    PROCEDURE = uint1uint4le
);

CREATE FUNCTION uint1uint4eq(uint1, uint4) RETURNS boolean IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint1uint4eq';

CREATE OPERATOR = (
    LEFTARG = uint1,
    RIGHTARG = uint4,
    COMMUTATOR = =,
    NEGATOR = <>,
    RESTRICT = eqsel,
    JOIN = eqjoinsel,
    HASHES,
    MERGES,
    PROCEDURE = uint1uint4eq
);

CREATE FUNCTION uint1uint4ne(uint1, uint4) RETURNS boolean IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint1uint4ne';

CREATE OPERATOR <> (
    LEFTARG = uint1,
    RIGHTARG = uint4,
    COMMUTATOR = <>,
    NEGATOR = =,
    RESTRICT = neqsel,
    JOIN = neqjoinsel,
    PROCEDURE = uint1uint4ne
);

CREATE FUNCTION uint1uint4ge(uint1, uint4) RETURNS boolean IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint1uint4ge';

CREATE OPERATOR >= (
    LEFTARG = uint1,
    RIGHTARG = uint4,
    COMMUTATOR = <=,
    NEGATOR = <,
    RESTRICT = scalargtsel,
    JOIN = scalargtjoinsel,
    PROCEDURE = uint1uint4ge
);

CREATE FUNCTION uint1uint4gt(uint1, uint4) RETURNS boolean IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint1uint4gt';

CREATE OPERATOR > (
    LEFTARG = uint1,
    RIGHTARG = uint4,
    COMMUTATOR = <,
    NEGATOR = <=,
    RESTRICT = scalargtsel,
    JOIN = scalargtjoinsel,
    PROCEDURE = uint1uint4gt
);

CREATE FUNCTION btuint1uint4cmp(uint1, uint4) RETURNS integer IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'btuint1uint4cmp';

CREATE FUNCTION uint1uint4pl(uint1, uint4) RETURNS uint4 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint1uint4pl';

CREATE OPERATOR + (
    LEFTARG = uint1,
    RIGHTARG = uint4,
    COMMUTATOR = +,
    PROCEDURE = uint1uint4pl
);

CREATE FUNCTION uint1uint4mi(uint1, uint4) RETURNS uint4 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint1uint4mi';

CREATE OPERATOR - (
    LEFTARG = uint1,
    RIGHTARG = uint4,
    PROCEDURE = uint1uint4mi
);

CREATE FUNCTION uint1uint4mul(uint1, uint4) RETURNS uint4 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint1uint4mul';

CREATE OPERATOR * (
    LEFTARG = uint1,
    RIGHTARG = uint4,
    COMMUTATOR = *,
    PROCEDURE = uint1uint4mul
);

CREATE FUNCTION uint1uint4div(uint1, uint4) RETURNS uint4 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint1uint4div';

CREATE OPERATOR / (
    LEFTARG = uint1,
    RIGHTARG = uint4,
    PROCEDURE = uint1uint4div
);

CREATE FUNCTION mod(uint1, uint4) RETURNS uint4 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint1uint4mod';

CREATE OPERATOR % (
    LEFTARG = uint1,
    RIGHTARG = uint4,
    PROCEDURE = mod
);

CREATE FUNCTION uint4(uint1) RETURNS uint4 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint1_to_uint4';

CREATE CAST (uint1 AS uint4) WITH FUNCTION uint4(uint1) AS IMPLICIT;

CREATE FUNCTION uint1uint8lt(uint1, uint8) RETURNS boolean IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint1uint8lt';

CREATE OPERATOR < (
    LEFTARG = uint1,
    RIGHTARG = uint8,
    COMMUTATOR = >,
    NEGATOR = >=,
    RESTRICT = scalarltsel,
    JOIN = scalarltjoinsel,
    PROCEDURE = uint1uint8lt
);

CREATE FUNCTION uint1uint8le(uint1, uint8) RETURNS boolean IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint1uint8le';

CREATE OPERATOR <= (
    LEFTARG = uint1,
    RIGHTARG = uint8,
    COMMUTATOR = >=,
    NEGATOR = >,
    RESTRICT = scalarltsel,
    JOIN = scalarltjoinsel,
    PROCEDURE = uint1uint8le
);

CREATE FUNCTION uint1uint8eq(uint1, uint8) RETURNS boolean IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint1uint8eq';

CREATE OPERATOR = (
    LEFTARG = uint1,
    RIGHTARG = uint8,
    COMMUTATOR = =,
    NEGATOR = <>,
    RESTRICT = eqsel,
    JOIN = eqjoinsel,
    HASHES,
    MERGES,
    PROCEDURE = uint1uint8eq
);

CREATE FUNCTION uint1uint8ne(uint1, uint8) RETURNS boolean IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint1uint8ne';

CREATE OPERATOR <> (
    LEFTARG = uint1,
    RIGHTARG = uint8,
    COMMUTATOR = <>,
    NEGATOR = =,
    RESTRICT = neqsel,
    JOIN = neqjoinsel,
    PROCEDURE = uint1uint8ne
);

CREATE FUNCTION uint1uint8ge(uint1, uint8) RETURNS boolean IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint1uint8ge';

CREATE OPERATOR >= (
    LEFTARG = uint1,
    RIGHTARG = uint8,
    COMMUTATOR = <=,
    NEGATOR = <,
    RESTRICT = scalargtsel,
    JOIN = scalargtjoinsel,
    PROCEDURE = uint1uint8ge
);

CREATE FUNCTION uint1uint8gt(uint1, uint8) RETURNS boolean IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint1uint8gt';

CREATE OPERATOR > (
    LEFTARG = uint1,
    RIGHTARG = uint8,
    COMMUTATOR = <,
    NEGATOR = <=,
    RESTRICT = scalargtsel,
    JOIN = scalargtjoinsel,
    PROCEDURE = uint1uint8gt
);

CREATE FUNCTION btuint1uint8cmp(uint1, uint8) RETURNS integer IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'btuint1uint8cmp';

CREATE FUNCTION uint1uint8pl(uint1, uint8) RETURNS uint8 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint1uint8pl';

CREATE OPERATOR + (
    LEFTARG = uint1,
    RIGHTARG = uint8,
    COMMUTATOR = +,
    PROCEDURE = uint1uint8pl
);

CREATE FUNCTION uint1uint8mi(uint1, uint8) RETURNS uint8 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint1uint8mi';

CREATE OPERATOR - (
    LEFTARG = uint1,
    RIGHTARG = uint8,
    PROCEDURE = uint1uint8mi
);

CREATE FUNCTION uint1uint8mul(uint1, uint8) RETURNS uint8 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint1uint8mul';

CREATE OPERATOR * (
    LEFTARG = uint1,
    RIGHTARG = uint8,
    COMMUTATOR = *,
    PROCEDURE = uint1uint8mul
);

CREATE FUNCTION uint1uint8div(uint1, uint8) RETURNS uint8 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint1uint8div';

CREATE OPERATOR / (
    LEFTARG = uint1,
    RIGHTARG = uint8,
    PROCEDURE = uint1uint8div
);

CREATE FUNCTION mod(uint1, uint8) RETURNS uint8 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint1uint8mod';

CREATE OPERATOR % (
    LEFTARG = uint1,
    RIGHTARG = uint8,
    PROCEDURE = mod
);

CREATE FUNCTION uint8(uint1) RETURNS uint8 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint1_to_uint8';

CREATE CAST (uint1 AS uint8) WITH FUNCTION uint8(uint1) AS IMPLICIT;

CREATE FUNCTION uint1int2lt(uint1, int2) RETURNS boolean IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint1int2lt';

CREATE OPERATOR < (
    LEFTARG = uint1,
    RIGHTARG = int2,
    COMMUTATOR = >,
    NEGATOR = >=,
    RESTRICT = scalarltsel,
    JOIN = scalarltjoinsel,
    PROCEDURE = uint1int2lt
);

CREATE FUNCTION uint1int2le(uint1, int2) RETURNS boolean IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint1int2le';

CREATE OPERATOR <= (
    LEFTARG = uint1,
    RIGHTARG = int2,
    COMMUTATOR = >=,
    NEGATOR = >,
    RESTRICT = scalarltsel,
    JOIN = scalarltjoinsel,
    PROCEDURE = uint1int2le
);

CREATE FUNCTION uint1int2eq(uint1, int2) RETURNS boolean IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint1int2eq';

CREATE OPERATOR = (
    LEFTARG = uint1,
    RIGHTARG = int2,
    COMMUTATOR = =,
    NEGATOR = <>,
    RESTRICT = eqsel,
    JOIN = eqjoinsel,
    HASHES,
    MERGES,
    PROCEDURE = uint1int2eq
);

CREATE FUNCTION uint1int2ne(uint1, int2) RETURNS boolean IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint1int2ne';

CREATE OPERATOR <> (
    LEFTARG = uint1,
    RIGHTARG = int2,
    COMMUTATOR = <>,
    NEGATOR = =,
    RESTRICT = neqsel,
    JOIN = neqjoinsel,
    PROCEDURE = uint1int2ne
);

CREATE FUNCTION uint1int2ge(uint1, int2) RETURNS boolean IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint1int2ge';

CREATE OPERATOR >= (
    LEFTARG = uint1,
    RIGHTARG = int2,
    COMMUTATOR = <=,
    NEGATOR = <,
    RESTRICT = scalargtsel,
    JOIN = scalargtjoinsel,
    PROCEDURE = uint1int2ge
);

CREATE FUNCTION uint1int2gt(uint1, int2) RETURNS boolean IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint1int2gt';

CREATE OPERATOR > (
    LEFTARG = uint1,
    RIGHTARG = int2,
    COMMUTATOR = <,
    NEGATOR = <=,
    RESTRICT = scalargtsel,
    JOIN = scalargtjoinsel,
    PROCEDURE = uint1int2gt
);

CREATE FUNCTION btuint1int2cmp(uint1, int2) RETURNS integer IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'btuint1int2cmp';

CREATE FUNCTION uint1int2pl(uint1, int2) RETURNS int2 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint1int2pl';

CREATE OPERATOR + (
    LEFTARG = uint1,
    RIGHTARG = int2,
    COMMUTATOR = +,
    PROCEDURE = uint1int2pl
);

CREATE FUNCTION uint1int2mi(uint1, int2) RETURNS int2 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint1int2mi';

CREATE OPERATOR - (
    LEFTARG = uint1,
    RIGHTARG = int2,
    PROCEDURE = uint1int2mi
);

CREATE FUNCTION uint1int2mul(uint1, int2) RETURNS int2 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint1int2mul';

CREATE OPERATOR * (
    LEFTARG = uint1,
    RIGHTARG = int2,
    COMMUTATOR = *,
    PROCEDURE = uint1int2mul
);

CREATE FUNCTION uint1int2div(uint1, int2) RETURNS int2 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint1int2div';

CREATE OPERATOR / (
    LEFTARG = uint1,
    RIGHTARG = int2,
    PROCEDURE = uint1int2div
);

CREATE FUNCTION mod(uint1, int2) RETURNS int2 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint1int2mod';

CREATE OPERATOR % (
    LEFTARG = uint1,
    RIGHTARG = int2,
    PROCEDURE = mod
);

CREATE FUNCTION int2(uint1) RETURNS int2 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint1_to_int2';

CREATE CAST (uint1 AS int2) WITH FUNCTION int2(uint1) AS IMPLICIT;

CREATE FUNCTION uint1int4lt(uint1, int4) RETURNS boolean IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint1int4lt';

CREATE OPERATOR < (
    LEFTARG = uint1,
    RIGHTARG = int4,
    COMMUTATOR = >,
    NEGATOR = >=,
    RESTRICT = scalarltsel,
    JOIN = scalarltjoinsel,
    PROCEDURE = uint1int4lt
);

CREATE FUNCTION uint1int4le(uint1, int4) RETURNS boolean IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint1int4le';

CREATE OPERATOR <= (
    LEFTARG = uint1,
    RIGHTARG = int4,
    COMMUTATOR = >=,
    NEGATOR = >,
    RESTRICT = scalarltsel,
    JOIN = scalarltjoinsel,
    PROCEDURE = uint1int4le
);

CREATE FUNCTION uint1int4eq(uint1, int4) RETURNS boolean IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint1int4eq';

CREATE OPERATOR = (
    LEFTARG = uint1,
    RIGHTARG = int4,
    COMMUTATOR = =,
    NEGATOR = <>,
    RESTRICT = eqsel,
    JOIN = eqjoinsel,
    HASHES,
    MERGES,
    PROCEDURE = uint1int4eq
);

CREATE FUNCTION uint1int4ne(uint1, int4) RETURNS boolean IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint1int4ne';

CREATE OPERATOR <> (
    LEFTARG = uint1,
    RIGHTARG = int4,
    COMMUTATOR = <>,
    NEGATOR = =,
    RESTRICT = neqsel,
    JOIN = neqjoinsel,
    PROCEDURE = uint1int4ne
);

CREATE FUNCTION uint1int4ge(uint1, int4) RETURNS boolean IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint1int4ge';

CREATE OPERATOR >= (
    LEFTARG = uint1,
    RIGHTARG = int4,
    COMMUTATOR = <=,
    NEGATOR = <,
    RESTRICT = scalargtsel,
    JOIN = scalargtjoinsel,
    PROCEDURE = uint1int4ge
);

CREATE FUNCTION uint1int4gt(uint1, int4) RETURNS boolean IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint1int4gt';

CREATE OPERATOR > (
    LEFTARG = uint1,
    RIGHTARG = int4,
    COMMUTATOR = <,
    NEGATOR = <=,
    RESTRICT = scalargtsel,
    JOIN = scalargtjoinsel,
    PROCEDURE = uint1int4gt
);

CREATE FUNCTION btuint1int4cmp(uint1, int4) RETURNS integer IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'btuint1int4cmp';

CREATE FUNCTION uint1int4pl(uint1, int4) RETURNS int4 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint1int4pl';

CREATE OPERATOR + (
    LEFTARG = uint1,
    RIGHTARG = int4,
    COMMUTATOR = +,
    PROCEDURE = uint1int4pl
);

CREATE FUNCTION uint1int4mi(uint1, int4) RETURNS int4 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint1int4mi';

CREATE OPERATOR - (
    LEFTARG = uint1,
    RIGHTARG = int4,
    PROCEDURE = uint1int4mi
);

CREATE FUNCTION uint1int4mul(uint1, int4) RETURNS int4 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint1int4mul';

CREATE OPERATOR * (
    LEFTARG = uint1,
    RIGHTARG = int4,
    COMMUTATOR = *,
    PROCEDURE = uint1int4mul
);

CREATE FUNCTION uint1int4div(uint1, int4) RETURNS int4 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint1int4div';

CREATE OPERATOR / (
    LEFTARG = uint1,
    RIGHTARG = int4,
    PROCEDURE = uint1int4div
);

CREATE FUNCTION mod(uint1, int4) RETURNS int4 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint1int4mod';

CREATE OPERATOR % (
    LEFTARG = uint1,
    RIGHTARG = int4,
    PROCEDURE = mod
);

CREATE FUNCTION int4(uint1) RETURNS int4 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint1_to_int4';

CREATE CAST (uint1 AS int4) WITH FUNCTION int4(uint1) AS IMPLICIT;

CREATE FUNCTION uint1int8lt(uint1, int8) RETURNS boolean IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint1int8lt';

CREATE OPERATOR < (
    LEFTARG = uint1,
    RIGHTARG = int8,
    COMMUTATOR = >,
    NEGATOR = >=,
    RESTRICT = scalarltsel,
    JOIN = scalarltjoinsel,
    PROCEDURE = uint1int8lt
);

CREATE FUNCTION uint1int8le(uint1, int8) RETURNS boolean IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint1int8le';

CREATE OPERATOR <= (
    LEFTARG = uint1,
    RIGHTARG = int8,
    COMMUTATOR = >=,
    NEGATOR = >,
    RESTRICT = scalarltsel,
    JOIN = scalarltjoinsel,
    PROCEDURE = uint1int8le
);

CREATE FUNCTION uint1int8eq(uint1, int8) RETURNS boolean IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint1int8eq';

CREATE OPERATOR = (
    LEFTARG = uint1,
    RIGHTARG = int8,
    COMMUTATOR = =,
    NEGATOR = <>,
    RESTRICT = eqsel,
    JOIN = eqjoinsel,
    HASHES,
    MERGES,
    PROCEDURE = uint1int8eq
);

CREATE FUNCTION uint1int8ne(uint1, int8) RETURNS boolean IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint1int8ne';

CREATE OPERATOR <> (
    LEFTARG = uint1,
    RIGHTARG = int8,
    COMMUTATOR = <>,
    NEGATOR = =,
    RESTRICT = neqsel,
    JOIN = neqjoinsel,
    PROCEDURE = uint1int8ne
);

CREATE FUNCTION uint1int8ge(uint1, int8) RETURNS boolean IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint1int8ge';

CREATE OPERATOR >= (
    LEFTARG = uint1,
    RIGHTARG = int8,
    COMMUTATOR = <=,
    NEGATOR = <,
    RESTRICT = scalargtsel,
    JOIN = scalargtjoinsel,
    PROCEDURE = uint1int8ge
);

CREATE FUNCTION uint1int8gt(uint1, int8) RETURNS boolean IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint1int8gt';

CREATE OPERATOR > (
    LEFTARG = uint1,
    RIGHTARG = int8,
    COMMUTATOR = <,
    NEGATOR = <=,
    RESTRICT = scalargtsel,
    JOIN = scalargtjoinsel,
    PROCEDURE = uint1int8gt
);

CREATE FUNCTION btuint1int8cmp(uint1, int8) RETURNS integer IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'btuint1int8cmp';

CREATE FUNCTION uint1int8pl(uint1, int8) RETURNS int8 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint1int8pl';

CREATE OPERATOR + (
    LEFTARG = uint1,
    RIGHTARG = int8,
    COMMUTATOR = +,
    PROCEDURE = uint1int8pl
);

CREATE FUNCTION uint1int8mi(uint1, int8) RETURNS int8 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint1int8mi';

CREATE OPERATOR - (
    LEFTARG = uint1,
    RIGHTARG = int8,
    PROCEDURE = uint1int8mi
);

CREATE FUNCTION uint1int8mul(uint1, int8) RETURNS int8 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint1int8mul';

CREATE OPERATOR * (
    LEFTARG = uint1,
    RIGHTARG = int8,
    COMMUTATOR = *,
    PROCEDURE = uint1int8mul
);

CREATE FUNCTION uint1int8div(uint1, int8) RETURNS int8 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint1int8div';

CREATE OPERATOR / (
    LEFTARG = uint1,
    RIGHTARG = int8,
    PROCEDURE = uint1int8div
);

CREATE FUNCTION mod(uint1, int8) RETURNS int8 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint1int8mod';

CREATE OPERATOR % (
    LEFTARG = uint1,
    RIGHTARG = int8,
    PROCEDURE = mod
);

CREATE FUNCTION int8(uint1) RETURNS int8 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint1_to_int8';

CREATE CAST (uint1 AS int8) WITH FUNCTION int8(uint1) AS IMPLICIT;

CREATE FUNCTION uint2int1lt(uint2, int1) RETURNS boolean IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint2int1lt';

CREATE OPERATOR < (
    LEFTARG = uint2,
    RIGHTARG = int1,
    COMMUTATOR = >,
    NEGATOR = >=,
    RESTRICT = scalarltsel,
    JOIN = scalarltjoinsel,
    PROCEDURE = uint2int1lt
);

CREATE FUNCTION uint2int1le(uint2, int1) RETURNS boolean IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint2int1le';

CREATE OPERATOR <= (
    LEFTARG = uint2,
    RIGHTARG = int1,
    COMMUTATOR = >=,
    NEGATOR = >,
    RESTRICT = scalarltsel,
    JOIN = scalarltjoinsel,
    PROCEDURE = uint2int1le
);

CREATE FUNCTION uint2int1eq(uint2, int1) RETURNS boolean IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint2int1eq';

CREATE OPERATOR = (
    LEFTARG = uint2,
    RIGHTARG = int1,
    COMMUTATOR = =,
    NEGATOR = <>,
    RESTRICT = eqsel,
    JOIN = eqjoinsel,
    HASHES,
    MERGES,
    PROCEDURE = uint2int1eq
);

CREATE FUNCTION uint2int1ne(uint2, int1) RETURNS boolean IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint2int1ne';

CREATE OPERATOR <> (
    LEFTARG = uint2,
    RIGHTARG = int1,
    COMMUTATOR = <>,
    NEGATOR = =,
    RESTRICT = neqsel,
    JOIN = neqjoinsel,
    PROCEDURE = uint2int1ne
);

CREATE FUNCTION uint2int1ge(uint2, int1) RETURNS boolean IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint2int1ge';

CREATE OPERATOR >= (
    LEFTARG = uint2,
    RIGHTARG = int1,
    COMMUTATOR = <=,
    NEGATOR = <,
    RESTRICT = scalargtsel,
    JOIN = scalargtjoinsel,
    PROCEDURE = uint2int1ge
);

CREATE FUNCTION uint2int1gt(uint2, int1) RETURNS boolean IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint2int1gt';

CREATE OPERATOR > (
    LEFTARG = uint2,
    RIGHTARG = int1,
    COMMUTATOR = <,
    NEGATOR = <=,
    RESTRICT = scalargtsel,
    JOIN = scalargtjoinsel,
    PROCEDURE = uint2int1gt
);

CREATE FUNCTION btuint2int1cmp(uint2, int1) RETURNS integer IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'btuint2int1cmp';

CREATE FUNCTION uint2int1pl(uint2, int1) RETURNS uint2 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint2int1pl';

CREATE OPERATOR + (
    LEFTARG = uint2,
    RIGHTARG = int1,
    COMMUTATOR = +,
    PROCEDURE = uint2int1pl
);

CREATE FUNCTION uint2int1mi(uint2, int1) RETURNS uint2 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint2int1mi';

CREATE OPERATOR - (
    LEFTARG = uint2,
    RIGHTARG = int1,
    PROCEDURE = uint2int1mi
);

CREATE FUNCTION uint2int1mul(uint2, int1) RETURNS uint2 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint2int1mul';

CREATE OPERATOR * (
    LEFTARG = uint2,
    RIGHTARG = int1,
    COMMUTATOR = *,
    PROCEDURE = uint2int1mul
);

CREATE FUNCTION uint2int1div(uint2, int1) RETURNS uint2 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint2int1div';

CREATE OPERATOR / (
    LEFTARG = uint2,
    RIGHTARG = int1,
    PROCEDURE = uint2int1div
);

CREATE FUNCTION mod(uint2, int1) RETURNS uint2 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint2int1mod';

CREATE OPERATOR % (
    LEFTARG = uint2,
    RIGHTARG = int1,
    PROCEDURE = mod
);

CREATE FUNCTION int1(uint2) RETURNS int1 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint2_to_int1';

CREATE CAST (uint2 AS int1) WITH FUNCTION int1(uint2) AS ASSIGNMENT;

CREATE FUNCTION uint2uint1lt(uint2, uint1) RETURNS boolean IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint2uint1lt';

CREATE OPERATOR < (
    LEFTARG = uint2,
    RIGHTARG = uint1,
    COMMUTATOR = >,
    NEGATOR = >=,
    RESTRICT = scalarltsel,
    JOIN = scalarltjoinsel,
    PROCEDURE = uint2uint1lt
);

CREATE FUNCTION uint2uint1le(uint2, uint1) RETURNS boolean IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint2uint1le';

CREATE OPERATOR <= (
    LEFTARG = uint2,
    RIGHTARG = uint1,
    COMMUTATOR = >=,
    NEGATOR = >,
    RESTRICT = scalarltsel,
    JOIN = scalarltjoinsel,
    PROCEDURE = uint2uint1le
);

CREATE FUNCTION uint2uint1eq(uint2, uint1) RETURNS boolean IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint2uint1eq';

CREATE OPERATOR = (
    LEFTARG = uint2,
    RIGHTARG = uint1,
    COMMUTATOR = =,
    NEGATOR = <>,
    RESTRICT = eqsel,
    JOIN = eqjoinsel,
    HASHES,
    MERGES,
    PROCEDURE = uint2uint1eq
);

CREATE FUNCTION uint2uint1ne(uint2, uint1) RETURNS boolean IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint2uint1ne';

CREATE OPERATOR <> (
    LEFTARG = uint2,
    RIGHTARG = uint1,
    COMMUTATOR = <>,
    NEGATOR = =,
    RESTRICT = neqsel,
    JOIN = neqjoinsel,
    PROCEDURE = uint2uint1ne
);

CREATE FUNCTION uint2uint1ge(uint2, uint1) RETURNS boolean IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint2uint1ge';

CREATE OPERATOR >= (
    LEFTARG = uint2,
    RIGHTARG = uint1,
    COMMUTATOR = <=,
    NEGATOR = <,
    RESTRICT = scalargtsel,
    JOIN = scalargtjoinsel,
    PROCEDURE = uint2uint1ge
);

CREATE FUNCTION uint2uint1gt(uint2, uint1) RETURNS boolean IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint2uint1gt';

CREATE OPERATOR > (
    LEFTARG = uint2,
    RIGHTARG = uint1,
    COMMUTATOR = <,
    NEGATOR = <=,
    RESTRICT = scalargtsel,
    JOIN = scalargtjoinsel,
    PROCEDURE = uint2uint1gt
);

CREATE FUNCTION btuint2uint1cmp(uint2, uint1) RETURNS integer IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'btuint2uint1cmp';

CREATE FUNCTION uint2uint1pl(uint2, uint1) RETURNS uint2 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint2uint1pl';

CREATE OPERATOR + (
    LEFTARG = uint2,
    RIGHTARG = uint1,
    COMMUTATOR = +,
    PROCEDURE = uint2uint1pl
);

CREATE FUNCTION uint2uint1mi(uint2, uint1) RETURNS uint2 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint2uint1mi';

CREATE OPERATOR - (
    LEFTARG = uint2,
    RIGHTARG = uint1,
    PROCEDURE = uint2uint1mi
);

CREATE FUNCTION uint2uint1mul(uint2, uint1) RETURNS uint2 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint2uint1mul';

CREATE OPERATOR * (
    LEFTARG = uint2,
    RIGHTARG = uint1,
    COMMUTATOR = *,
    PROCEDURE = uint2uint1mul
);

CREATE FUNCTION uint2uint1div(uint2, uint1) RETURNS uint2 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint2uint1div';

CREATE OPERATOR / (
    LEFTARG = uint2,
    RIGHTARG = uint1,
    PROCEDURE = uint2uint1div
);

CREATE FUNCTION mod(uint2, uint1) RETURNS uint2 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint2uint1mod';

CREATE OPERATOR % (
    LEFTARG = uint2,
    RIGHTARG = uint1,
    PROCEDURE = mod
);

CREATE FUNCTION uint1(uint2) RETURNS uint1 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint2_to_uint1';

CREATE CAST (uint2 AS uint1) WITH FUNCTION uint1(uint2) AS ASSIGNMENT;

CREATE FUNCTION uint2uint2lt(uint2, uint2) RETURNS boolean IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint2uint2lt';

CREATE OPERATOR < (
    LEFTARG = uint2,
    RIGHTARG = uint2,
    COMMUTATOR = >,
    NEGATOR = >=,
    RESTRICT = scalarltsel,
    JOIN = scalarltjoinsel,
    PROCEDURE = uint2uint2lt
);

CREATE FUNCTION uint2uint2le(uint2, uint2) RETURNS boolean IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint2uint2le';

CREATE OPERATOR <= (
    LEFTARG = uint2,
    RIGHTARG = uint2,
    COMMUTATOR = >=,
    NEGATOR = >,
    RESTRICT = scalarltsel,
    JOIN = scalarltjoinsel,
    PROCEDURE = uint2uint2le
);

CREATE FUNCTION uint2uint2eq(uint2, uint2) RETURNS boolean IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint2uint2eq';

CREATE OPERATOR = (
    LEFTARG = uint2,
    RIGHTARG = uint2,
    COMMUTATOR = =,
    NEGATOR = <>,
    RESTRICT = eqsel,
    JOIN = eqjoinsel,
    HASHES,
    MERGES,
    PROCEDURE = uint2uint2eq
);

CREATE FUNCTION uint2uint2ne(uint2, uint2) RETURNS boolean IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint2uint2ne';

CREATE OPERATOR <> (
    LEFTARG = uint2,
    RIGHTARG = uint2,
    COMMUTATOR = <>,
    NEGATOR = =,
    RESTRICT = neqsel,
    JOIN = neqjoinsel,
    PROCEDURE = uint2uint2ne
);

CREATE FUNCTION uint2uint2ge(uint2, uint2) RETURNS boolean IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint2uint2ge';

CREATE OPERATOR >= (
    LEFTARG = uint2,
    RIGHTARG = uint2,
    COMMUTATOR = <=,
    NEGATOR = <,
    RESTRICT = scalargtsel,
    JOIN = scalargtjoinsel,
    PROCEDURE = uint2uint2ge
);

CREATE FUNCTION uint2uint2gt(uint2, uint2) RETURNS boolean IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint2uint2gt';

CREATE OPERATOR > (
    LEFTARG = uint2,
    RIGHTARG = uint2,
    COMMUTATOR = <,
    NEGATOR = <=,
    RESTRICT = scalargtsel,
    JOIN = scalargtjoinsel,
    PROCEDURE = uint2uint2gt
);

CREATE FUNCTION btuint2uint2cmp(uint2, uint2) RETURNS integer IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'btuint2uint2cmp';

CREATE FUNCTION uint2uint2pl(uint2, uint2) RETURNS uint2 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint2uint2pl';

CREATE OPERATOR + (
    LEFTARG = uint2,
    RIGHTARG = uint2,
    COMMUTATOR = +,
    PROCEDURE = uint2uint2pl
);

CREATE FUNCTION uint2uint2mi(uint2, uint2) RETURNS uint2 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint2uint2mi';

CREATE OPERATOR - (
    LEFTARG = uint2,
    RIGHTARG = uint2,
    PROCEDURE = uint2uint2mi
);

CREATE FUNCTION uint2uint2mul(uint2, uint2) RETURNS uint2 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint2uint2mul';

CREATE OPERATOR * (
    LEFTARG = uint2,
    RIGHTARG = uint2,
    COMMUTATOR = *,
    PROCEDURE = uint2uint2mul
);

CREATE FUNCTION uint2uint2div(uint2, uint2) RETURNS uint2 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint2uint2div';

CREATE OPERATOR / (
    LEFTARG = uint2,
    RIGHTARG = uint2,
    PROCEDURE = uint2uint2div
);

CREATE FUNCTION mod(uint2, uint2) RETURNS uint2 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint2uint2mod';

CREATE OPERATOR % (
    LEFTARG = uint2,
    RIGHTARG = uint2,
    PROCEDURE = mod
);

CREATE FUNCTION uint2uint4lt(uint2, uint4) RETURNS boolean IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint2uint4lt';

CREATE OPERATOR < (
    LEFTARG = uint2,
    RIGHTARG = uint4,
    COMMUTATOR = >,
    NEGATOR = >=,
    RESTRICT = scalarltsel,
    JOIN = scalarltjoinsel,
    PROCEDURE = uint2uint4lt
);

CREATE FUNCTION uint2uint4le(uint2, uint4) RETURNS boolean IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint2uint4le';

CREATE OPERATOR <= (
    LEFTARG = uint2,
    RIGHTARG = uint4,
    COMMUTATOR = >=,
    NEGATOR = >,
    RESTRICT = scalarltsel,
    JOIN = scalarltjoinsel,
    PROCEDURE = uint2uint4le
);

CREATE FUNCTION uint2uint4eq(uint2, uint4) RETURNS boolean IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint2uint4eq';

CREATE OPERATOR = (
    LEFTARG = uint2,
    RIGHTARG = uint4,
    COMMUTATOR = =,
    NEGATOR = <>,
    RESTRICT = eqsel,
    JOIN = eqjoinsel,
    HASHES,
    MERGES,
    PROCEDURE = uint2uint4eq
);

CREATE FUNCTION uint2uint4ne(uint2, uint4) RETURNS boolean IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint2uint4ne';

CREATE OPERATOR <> (
    LEFTARG = uint2,
    RIGHTARG = uint4,
    COMMUTATOR = <>,
    NEGATOR = =,
    RESTRICT = neqsel,
    JOIN = neqjoinsel,
    PROCEDURE = uint2uint4ne
);

CREATE FUNCTION uint2uint4ge(uint2, uint4) RETURNS boolean IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint2uint4ge';

CREATE OPERATOR >= (
    LEFTARG = uint2,
    RIGHTARG = uint4,
    COMMUTATOR = <=,
    NEGATOR = <,
    RESTRICT = scalargtsel,
    JOIN = scalargtjoinsel,
    PROCEDURE = uint2uint4ge
);

CREATE FUNCTION uint2uint4gt(uint2, uint4) RETURNS boolean IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint2uint4gt';

CREATE OPERATOR > (
    LEFTARG = uint2,
    RIGHTARG = uint4,
    COMMUTATOR = <,
    NEGATOR = <=,
    RESTRICT = scalargtsel,
    JOIN = scalargtjoinsel,
    PROCEDURE = uint2uint4gt
);

CREATE FUNCTION btuint2uint4cmp(uint2, uint4) RETURNS integer IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'btuint2uint4cmp';

CREATE FUNCTION uint2uint4pl(uint2, uint4) RETURNS uint4 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint2uint4pl';

CREATE OPERATOR + (
    LEFTARG = uint2,
    RIGHTARG = uint4,
    COMMUTATOR = +,
    PROCEDURE = uint2uint4pl
);

CREATE FUNCTION uint2uint4mi(uint2, uint4) RETURNS uint4 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint2uint4mi';

CREATE OPERATOR - (
    LEFTARG = uint2,
    RIGHTARG = uint4,
    PROCEDURE = uint2uint4mi
);

CREATE FUNCTION uint2uint4mul(uint2, uint4) RETURNS uint4 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint2uint4mul';

CREATE OPERATOR * (
    LEFTARG = uint2,
    RIGHTARG = uint4,
    COMMUTATOR = *,
    PROCEDURE = uint2uint4mul
);

CREATE FUNCTION uint2uint4div(uint2, uint4) RETURNS uint4 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint2uint4div';

CREATE OPERATOR / (
    LEFTARG = uint2,
    RIGHTARG = uint4,
    PROCEDURE = uint2uint4div
);

CREATE FUNCTION mod(uint2, uint4) RETURNS uint4 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint2uint4mod';

CREATE OPERATOR % (
    LEFTARG = uint2,
    RIGHTARG = uint4,
    PROCEDURE = mod
);

CREATE FUNCTION uint4(uint2) RETURNS uint4 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint2_to_uint4';

CREATE CAST (uint2 AS uint4) WITH FUNCTION uint4(uint2) AS IMPLICIT;

CREATE FUNCTION uint2uint8lt(uint2, uint8) RETURNS boolean IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint2uint8lt';

CREATE OPERATOR < (
    LEFTARG = uint2,
    RIGHTARG = uint8,
    COMMUTATOR = >,
    NEGATOR = >=,
    RESTRICT = scalarltsel,
    JOIN = scalarltjoinsel,
    PROCEDURE = uint2uint8lt
);

CREATE FUNCTION uint2uint8le(uint2, uint8) RETURNS boolean IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint2uint8le';

CREATE OPERATOR <= (
    LEFTARG = uint2,
    RIGHTARG = uint8,
    COMMUTATOR = >=,
    NEGATOR = >,
    RESTRICT = scalarltsel,
    JOIN = scalarltjoinsel,
    PROCEDURE = uint2uint8le
);

CREATE FUNCTION uint2uint8eq(uint2, uint8) RETURNS boolean IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint2uint8eq';

CREATE OPERATOR = (
    LEFTARG = uint2,
    RIGHTARG = uint8,
    COMMUTATOR = =,
    NEGATOR = <>,
    RESTRICT = eqsel,
    JOIN = eqjoinsel,
    HASHES,
    MERGES,
    PROCEDURE = uint2uint8eq
);

CREATE FUNCTION uint2uint8ne(uint2, uint8) RETURNS boolean IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint2uint8ne';

CREATE OPERATOR <> (
    LEFTARG = uint2,
    RIGHTARG = uint8,
    COMMUTATOR = <>,
    NEGATOR = =,
    RESTRICT = neqsel,
    JOIN = neqjoinsel,
    PROCEDURE = uint2uint8ne
);

CREATE FUNCTION uint2uint8ge(uint2, uint8) RETURNS boolean IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint2uint8ge';

CREATE OPERATOR >= (
    LEFTARG = uint2,
    RIGHTARG = uint8,
    COMMUTATOR = <=,
    NEGATOR = <,
    RESTRICT = scalargtsel,
    JOIN = scalargtjoinsel,
    PROCEDURE = uint2uint8ge
);

CREATE FUNCTION uint2uint8gt(uint2, uint8) RETURNS boolean IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint2uint8gt';

CREATE OPERATOR > (
    LEFTARG = uint2,
    RIGHTARG = uint8,
    COMMUTATOR = <,
    NEGATOR = <=,
    RESTRICT = scalargtsel,
    JOIN = scalargtjoinsel,
    PROCEDURE = uint2uint8gt
);

CREATE FUNCTION btuint2uint8cmp(uint2, uint8) RETURNS integer IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'btuint2uint8cmp';

CREATE FUNCTION uint2uint8pl(uint2, uint8) RETURNS uint8 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint2uint8pl';

CREATE OPERATOR + (
    LEFTARG = uint2,
    RIGHTARG = uint8,
    COMMUTATOR = +,
    PROCEDURE = uint2uint8pl
);

CREATE FUNCTION uint2uint8mi(uint2, uint8) RETURNS uint8 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint2uint8mi';

CREATE OPERATOR - (
    LEFTARG = uint2,
    RIGHTARG = uint8,
    PROCEDURE = uint2uint8mi
);

CREATE FUNCTION uint2uint8mul(uint2, uint8) RETURNS uint8 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint2uint8mul';

CREATE OPERATOR * (
    LEFTARG = uint2,
    RIGHTARG = uint8,
    COMMUTATOR = *,
    PROCEDURE = uint2uint8mul
);

CREATE FUNCTION uint2uint8div(uint2, uint8) RETURNS uint8 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint2uint8div';

CREATE OPERATOR / (
    LEFTARG = uint2,
    RIGHTARG = uint8,
    PROCEDURE = uint2uint8div
);

CREATE FUNCTION mod(uint2, uint8) RETURNS uint8 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint2uint8mod';

CREATE OPERATOR % (
    LEFTARG = uint2,
    RIGHTARG = uint8,
    PROCEDURE = mod
);

CREATE FUNCTION uint8(uint2) RETURNS uint8 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint2_to_uint8';

CREATE CAST (uint2 AS uint8) WITH FUNCTION uint8(uint2) AS IMPLICIT;

CREATE FUNCTION uint2int2lt(uint2, int2) RETURNS boolean IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint2int2lt';

CREATE OPERATOR < (
    LEFTARG = uint2,
    RIGHTARG = int2,
    COMMUTATOR = >,
    NEGATOR = >=,
    RESTRICT = scalarltsel,
    JOIN = scalarltjoinsel,
    PROCEDURE = uint2int2lt
);

CREATE FUNCTION uint2int2le(uint2, int2) RETURNS boolean IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint2int2le';

CREATE OPERATOR <= (
    LEFTARG = uint2,
    RIGHTARG = int2,
    COMMUTATOR = >=,
    NEGATOR = >,
    RESTRICT = scalarltsel,
    JOIN = scalarltjoinsel,
    PROCEDURE = uint2int2le
);

CREATE FUNCTION uint2int2eq(uint2, int2) RETURNS boolean IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint2int2eq';

CREATE OPERATOR = (
    LEFTARG = uint2,
    RIGHTARG = int2,
    COMMUTATOR = =,
    NEGATOR = <>,
    RESTRICT = eqsel,
    JOIN = eqjoinsel,
    HASHES,
    MERGES,
    PROCEDURE = uint2int2eq
);

CREATE FUNCTION uint2int2ne(uint2, int2) RETURNS boolean IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint2int2ne';

CREATE OPERATOR <> (
    LEFTARG = uint2,
    RIGHTARG = int2,
    COMMUTATOR = <>,
    NEGATOR = =,
    RESTRICT = neqsel,
    JOIN = neqjoinsel,
    PROCEDURE = uint2int2ne
);

CREATE FUNCTION uint2int2ge(uint2, int2) RETURNS boolean IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint2int2ge';

CREATE OPERATOR >= (
    LEFTARG = uint2,
    RIGHTARG = int2,
    COMMUTATOR = <=,
    NEGATOR = <,
    RESTRICT = scalargtsel,
    JOIN = scalargtjoinsel,
    PROCEDURE = uint2int2ge
);

CREATE FUNCTION uint2int2gt(uint2, int2) RETURNS boolean IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint2int2gt';

CREATE OPERATOR > (
    LEFTARG = uint2,
    RIGHTARG = int2,
    COMMUTATOR = <,
    NEGATOR = <=,
    RESTRICT = scalargtsel,
    JOIN = scalargtjoinsel,
    PROCEDURE = uint2int2gt
);

CREATE FUNCTION btuint2int2cmp(uint2, int2) RETURNS integer IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'btuint2int2cmp';

CREATE FUNCTION uint2int2pl(uint2, int2) RETURNS uint2 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint2int2pl';

CREATE OPERATOR + (
    LEFTARG = uint2,
    RIGHTARG = int2,
    COMMUTATOR = +,
    PROCEDURE = uint2int2pl
);

CREATE FUNCTION uint2int2mi(uint2, int2) RETURNS uint2 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint2int2mi';

CREATE OPERATOR - (
    LEFTARG = uint2,
    RIGHTARG = int2,
    PROCEDURE = uint2int2mi
);

CREATE FUNCTION uint2int2mul(uint2, int2) RETURNS uint2 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint2int2mul';

CREATE OPERATOR * (
    LEFTARG = uint2,
    RIGHTARG = int2,
    COMMUTATOR = *,
    PROCEDURE = uint2int2mul
);

CREATE FUNCTION uint2int2div(uint2, int2) RETURNS uint2 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint2int2div';

CREATE OPERATOR / (
    LEFTARG = uint2,
    RIGHTARG = int2,
    PROCEDURE = uint2int2div
);

CREATE FUNCTION mod(uint2, int2) RETURNS uint2 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint2int2mod';

CREATE OPERATOR % (
    LEFTARG = uint2,
    RIGHTARG = int2,
    PROCEDURE = mod
);

CREATE FUNCTION int2(uint2) RETURNS int2 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint2_to_int2';

CREATE CAST (uint2 AS int2) WITH FUNCTION int2(uint2) AS ASSIGNMENT;

CREATE FUNCTION uint2int4lt(uint2, int4) RETURNS boolean IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint2int4lt';

CREATE OPERATOR < (
    LEFTARG = uint2,
    RIGHTARG = int4,
    COMMUTATOR = >,
    NEGATOR = >=,
    RESTRICT = scalarltsel,
    JOIN = scalarltjoinsel,
    PROCEDURE = uint2int4lt
);

CREATE FUNCTION uint2int4le(uint2, int4) RETURNS boolean IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint2int4le';

CREATE OPERATOR <= (
    LEFTARG = uint2,
    RIGHTARG = int4,
    COMMUTATOR = >=,
    NEGATOR = >,
    RESTRICT = scalarltsel,
    JOIN = scalarltjoinsel,
    PROCEDURE = uint2int4le
);

CREATE FUNCTION uint2int4eq(uint2, int4) RETURNS boolean IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint2int4eq';

CREATE OPERATOR = (
    LEFTARG = uint2,
    RIGHTARG = int4,
    COMMUTATOR = =,
    NEGATOR = <>,
    RESTRICT = eqsel,
    JOIN = eqjoinsel,
    HASHES,
    MERGES,
    PROCEDURE = uint2int4eq
);

CREATE FUNCTION uint2int4ne(uint2, int4) RETURNS boolean IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint2int4ne';

CREATE OPERATOR <> (
    LEFTARG = uint2,
    RIGHTARG = int4,
    COMMUTATOR = <>,
    NEGATOR = =,
    RESTRICT = neqsel,
    JOIN = neqjoinsel,
    PROCEDURE = uint2int4ne
);

CREATE FUNCTION uint2int4ge(uint2, int4) RETURNS boolean IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint2int4ge';

CREATE OPERATOR >= (
    LEFTARG = uint2,
    RIGHTARG = int4,
    COMMUTATOR = <=,
    NEGATOR = <,
    RESTRICT = scalargtsel,
    JOIN = scalargtjoinsel,
    PROCEDURE = uint2int4ge
);

CREATE FUNCTION uint2int4gt(uint2, int4) RETURNS boolean IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint2int4gt';

CREATE OPERATOR > (
    LEFTARG = uint2,
    RIGHTARG = int4,
    COMMUTATOR = <,
    NEGATOR = <=,
    RESTRICT = scalargtsel,
    JOIN = scalargtjoinsel,
    PROCEDURE = uint2int4gt
);

CREATE FUNCTION btuint2int4cmp(uint2, int4) RETURNS integer IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'btuint2int4cmp';

CREATE FUNCTION uint2int4pl(uint2, int4) RETURNS int4 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint2int4pl';

CREATE OPERATOR + (
    LEFTARG = uint2,
    RIGHTARG = int4,
    COMMUTATOR = +,
    PROCEDURE = uint2int4pl
);

CREATE FUNCTION uint2int4mi(uint2, int4) RETURNS int4 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint2int4mi';

CREATE OPERATOR - (
    LEFTARG = uint2,
    RIGHTARG = int4,
    PROCEDURE = uint2int4mi
);

CREATE FUNCTION uint2int4mul(uint2, int4) RETURNS int4 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint2int4mul';

CREATE OPERATOR * (
    LEFTARG = uint2,
    RIGHTARG = int4,
    COMMUTATOR = *,
    PROCEDURE = uint2int4mul
);

CREATE FUNCTION uint2int4div(uint2, int4) RETURNS int4 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint2int4div';

CREATE OPERATOR / (
    LEFTARG = uint2,
    RIGHTARG = int4,
    PROCEDURE = uint2int4div
);

CREATE FUNCTION mod(uint2, int4) RETURNS int4 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint2int4mod';

CREATE OPERATOR % (
    LEFTARG = uint2,
    RIGHTARG = int4,
    PROCEDURE = mod
);

CREATE FUNCTION int4(uint2) RETURNS int4 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint2_to_int4';

CREATE CAST (uint2 AS int4) WITH FUNCTION int4(uint2) AS IMPLICIT;

CREATE FUNCTION uint2int8lt(uint2, int8) RETURNS boolean IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint2int8lt';

CREATE OPERATOR < (
    LEFTARG = uint2,
    RIGHTARG = int8,
    COMMUTATOR = >,
    NEGATOR = >=,
    RESTRICT = scalarltsel,
    JOIN = scalarltjoinsel,
    PROCEDURE = uint2int8lt
);

CREATE FUNCTION uint2int8le(uint2, int8) RETURNS boolean IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint2int8le';

CREATE OPERATOR <= (
    LEFTARG = uint2,
    RIGHTARG = int8,
    COMMUTATOR = >=,
    NEGATOR = >,
    RESTRICT = scalarltsel,
    JOIN = scalarltjoinsel,
    PROCEDURE = uint2int8le
);

CREATE FUNCTION uint2int8eq(uint2, int8) RETURNS boolean IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint2int8eq';

CREATE OPERATOR = (
    LEFTARG = uint2,
    RIGHTARG = int8,
    COMMUTATOR = =,
    NEGATOR = <>,
    RESTRICT = eqsel,
    JOIN = eqjoinsel,
    HASHES,
    MERGES,
    PROCEDURE = uint2int8eq
);

CREATE FUNCTION uint2int8ne(uint2, int8) RETURNS boolean IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint2int8ne';

CREATE OPERATOR <> (
    LEFTARG = uint2,
    RIGHTARG = int8,
    COMMUTATOR = <>,
    NEGATOR = =,
    RESTRICT = neqsel,
    JOIN = neqjoinsel,
    PROCEDURE = uint2int8ne
);

CREATE FUNCTION uint2int8ge(uint2, int8) RETURNS boolean IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint2int8ge';

CREATE OPERATOR >= (
    LEFTARG = uint2,
    RIGHTARG = int8,
    COMMUTATOR = <=,
    NEGATOR = <,
    RESTRICT = scalargtsel,
    JOIN = scalargtjoinsel,
    PROCEDURE = uint2int8ge
);

CREATE FUNCTION uint2int8gt(uint2, int8) RETURNS boolean IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint2int8gt';

CREATE OPERATOR > (
    LEFTARG = uint2,
    RIGHTARG = int8,
    COMMUTATOR = <,
    NEGATOR = <=,
    RESTRICT = scalargtsel,
    JOIN = scalargtjoinsel,
    PROCEDURE = uint2int8gt
);

CREATE FUNCTION btuint2int8cmp(uint2, int8) RETURNS integer IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'btuint2int8cmp';

CREATE FUNCTION uint2int8pl(uint2, int8) RETURNS int8 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint2int8pl';

CREATE OPERATOR + (
    LEFTARG = uint2,
    RIGHTARG = int8,
    COMMUTATOR = +,
    PROCEDURE = uint2int8pl
);

CREATE FUNCTION uint2int8mi(uint2, int8) RETURNS int8 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint2int8mi';

CREATE OPERATOR - (
    LEFTARG = uint2,
    RIGHTARG = int8,
    PROCEDURE = uint2int8mi
);

CREATE FUNCTION uint2int8mul(uint2, int8) RETURNS int8 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint2int8mul';

CREATE OPERATOR * (
    LEFTARG = uint2,
    RIGHTARG = int8,
    COMMUTATOR = *,
    PROCEDURE = uint2int8mul
);

CREATE FUNCTION uint2int8div(uint2, int8) RETURNS int8 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint2int8div';

CREATE OPERATOR / (
    LEFTARG = uint2,
    RIGHTARG = int8,
    PROCEDURE = uint2int8div
);

CREATE FUNCTION mod(uint2, int8) RETURNS int8 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint2int8mod';

CREATE OPERATOR % (
    LEFTARG = uint2,
    RIGHTARG = int8,
    PROCEDURE = mod
);

CREATE FUNCTION int8(uint2) RETURNS int8 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint2_to_int8';

CREATE CAST (uint2 AS int8) WITH FUNCTION int8(uint2) AS IMPLICIT;

CREATE FUNCTION uint4int1lt(uint4, int1) RETURNS boolean IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint4int1lt';

CREATE OPERATOR < (
    LEFTARG = uint4,
    RIGHTARG = int1,
    COMMUTATOR = >,
    NEGATOR = >=,
    RESTRICT = scalarltsel,
    JOIN = scalarltjoinsel,
    PROCEDURE = uint4int1lt
);

CREATE FUNCTION uint4int1le(uint4, int1) RETURNS boolean IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint4int1le';

CREATE OPERATOR <= (
    LEFTARG = uint4,
    RIGHTARG = int1,
    COMMUTATOR = >=,
    NEGATOR = >,
    RESTRICT = scalarltsel,
    JOIN = scalarltjoinsel,
    PROCEDURE = uint4int1le
);

CREATE FUNCTION uint4int1eq(uint4, int1) RETURNS boolean IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint4int1eq';

CREATE OPERATOR = (
    LEFTARG = uint4,
    RIGHTARG = int1,
    COMMUTATOR = =,
    NEGATOR = <>,
    RESTRICT = eqsel,
    JOIN = eqjoinsel,
    HASHES,
    MERGES,
    PROCEDURE = uint4int1eq
);

CREATE FUNCTION uint4int1ne(uint4, int1) RETURNS boolean IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint4int1ne';

CREATE OPERATOR <> (
    LEFTARG = uint4,
    RIGHTARG = int1,
    COMMUTATOR = <>,
    NEGATOR = =,
    RESTRICT = neqsel,
    JOIN = neqjoinsel,
    PROCEDURE = uint4int1ne
);

CREATE FUNCTION uint4int1ge(uint4, int1) RETURNS boolean IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint4int1ge';

CREATE OPERATOR >= (
    LEFTARG = uint4,
    RIGHTARG = int1,
    COMMUTATOR = <=,
    NEGATOR = <,
    RESTRICT = scalargtsel,
    JOIN = scalargtjoinsel,
    PROCEDURE = uint4int1ge
);

CREATE FUNCTION uint4int1gt(uint4, int1) RETURNS boolean IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint4int1gt';

CREATE OPERATOR > (
    LEFTARG = uint4,
    RIGHTARG = int1,
    COMMUTATOR = <,
    NEGATOR = <=,
    RESTRICT = scalargtsel,
    JOIN = scalargtjoinsel,
    PROCEDURE = uint4int1gt
);

CREATE FUNCTION btuint4int1cmp(uint4, int1) RETURNS integer IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'btuint4int1cmp';

CREATE FUNCTION uint4int1pl(uint4, int1) RETURNS uint4 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint4int1pl';

CREATE OPERATOR + (
    LEFTARG = uint4,
    RIGHTARG = int1,
    COMMUTATOR = +,
    PROCEDURE = uint4int1pl
);

CREATE FUNCTION uint4int1mi(uint4, int1) RETURNS uint4 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint4int1mi';

CREATE OPERATOR - (
    LEFTARG = uint4,
    RIGHTARG = int1,
    PROCEDURE = uint4int1mi
);

CREATE FUNCTION uint4int1mul(uint4, int1) RETURNS uint4 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint4int1mul';

CREATE OPERATOR * (
    LEFTARG = uint4,
    RIGHTARG = int1,
    COMMUTATOR = *,
    PROCEDURE = uint4int1mul
);

CREATE FUNCTION uint4int1div(uint4, int1) RETURNS uint4 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint4int1div';

CREATE OPERATOR / (
    LEFTARG = uint4,
    RIGHTARG = int1,
    PROCEDURE = uint4int1div
);

CREATE FUNCTION mod(uint4, int1) RETURNS uint4 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint4int1mod';

CREATE OPERATOR % (
    LEFTARG = uint4,
    RIGHTARG = int1,
    PROCEDURE = mod
);

CREATE FUNCTION int1(uint4) RETURNS int1 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint4_to_int1';

CREATE CAST (uint4 AS int1) WITH FUNCTION int1(uint4) AS ASSIGNMENT;

CREATE FUNCTION uint4uint1lt(uint4, uint1) RETURNS boolean IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint4uint1lt';

CREATE OPERATOR < (
    LEFTARG = uint4,
    RIGHTARG = uint1,
    COMMUTATOR = >,
    NEGATOR = >=,
    RESTRICT = scalarltsel,
    JOIN = scalarltjoinsel,
    PROCEDURE = uint4uint1lt
);

CREATE FUNCTION uint4uint1le(uint4, uint1) RETURNS boolean IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint4uint1le';

CREATE OPERATOR <= (
    LEFTARG = uint4,
    RIGHTARG = uint1,
    COMMUTATOR = >=,
    NEGATOR = >,
    RESTRICT = scalarltsel,
    JOIN = scalarltjoinsel,
    PROCEDURE = uint4uint1le
);

CREATE FUNCTION uint4uint1eq(uint4, uint1) RETURNS boolean IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint4uint1eq';

CREATE OPERATOR = (
    LEFTARG = uint4,
    RIGHTARG = uint1,
    COMMUTATOR = =,
    NEGATOR = <>,
    RESTRICT = eqsel,
    JOIN = eqjoinsel,
    HASHES,
    MERGES,
    PROCEDURE = uint4uint1eq
);

CREATE FUNCTION uint4uint1ne(uint4, uint1) RETURNS boolean IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint4uint1ne';

CREATE OPERATOR <> (
    LEFTARG = uint4,
    RIGHTARG = uint1,
    COMMUTATOR = <>,
    NEGATOR = =,
    RESTRICT = neqsel,
    JOIN = neqjoinsel,
    PROCEDURE = uint4uint1ne
);

CREATE FUNCTION uint4uint1ge(uint4, uint1) RETURNS boolean IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint4uint1ge';

CREATE OPERATOR >= (
    LEFTARG = uint4,
    RIGHTARG = uint1,
    COMMUTATOR = <=,
    NEGATOR = <,
    RESTRICT = scalargtsel,
    JOIN = scalargtjoinsel,
    PROCEDURE = uint4uint1ge
);

CREATE FUNCTION uint4uint1gt(uint4, uint1) RETURNS boolean IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint4uint1gt';

CREATE OPERATOR > (
    LEFTARG = uint4,
    RIGHTARG = uint1,
    COMMUTATOR = <,
    NEGATOR = <=,
    RESTRICT = scalargtsel,
    JOIN = scalargtjoinsel,
    PROCEDURE = uint4uint1gt
);

CREATE FUNCTION btuint4uint1cmp(uint4, uint1) RETURNS integer IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'btuint4uint1cmp';

CREATE FUNCTION uint4uint1pl(uint4, uint1) RETURNS uint4 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint4uint1pl';

CREATE OPERATOR + (
    LEFTARG = uint4,
    RIGHTARG = uint1,
    COMMUTATOR = +,
    PROCEDURE = uint4uint1pl
);

CREATE FUNCTION uint4uint1mi(uint4, uint1) RETURNS uint4 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint4uint1mi';

CREATE OPERATOR - (
    LEFTARG = uint4,
    RIGHTARG = uint1,
    PROCEDURE = uint4uint1mi
);

CREATE FUNCTION uint4uint1mul(uint4, uint1) RETURNS uint4 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint4uint1mul';

CREATE OPERATOR * (
    LEFTARG = uint4,
    RIGHTARG = uint1,
    COMMUTATOR = *,
    PROCEDURE = uint4uint1mul
);

CREATE FUNCTION uint4uint1div(uint4, uint1) RETURNS uint4 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint4uint1div';

CREATE OPERATOR / (
    LEFTARG = uint4,
    RIGHTARG = uint1,
    PROCEDURE = uint4uint1div
);

CREATE FUNCTION mod(uint4, uint1) RETURNS uint4 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint4uint1mod';

CREATE OPERATOR % (
    LEFTARG = uint4,
    RIGHTARG = uint1,
    PROCEDURE = mod
);

CREATE FUNCTION uint1(uint4) RETURNS uint1 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint4_to_uint1';

CREATE CAST (uint4 AS uint1) WITH FUNCTION uint1(uint4) AS ASSIGNMENT;

CREATE FUNCTION uint4uint2lt(uint4, uint2) RETURNS boolean IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint4uint2lt';

CREATE OPERATOR < (
    LEFTARG = uint4,
    RIGHTARG = uint2,
    COMMUTATOR = >,
    NEGATOR = >=,
    RESTRICT = scalarltsel,
    JOIN = scalarltjoinsel,
    PROCEDURE = uint4uint2lt
);

CREATE FUNCTION uint4uint2le(uint4, uint2) RETURNS boolean IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint4uint2le';

CREATE OPERATOR <= (
    LEFTARG = uint4,
    RIGHTARG = uint2,
    COMMUTATOR = >=,
    NEGATOR = >,
    RESTRICT = scalarltsel,
    JOIN = scalarltjoinsel,
    PROCEDURE = uint4uint2le
);

CREATE FUNCTION uint4uint2eq(uint4, uint2) RETURNS boolean IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint4uint2eq';

CREATE OPERATOR = (
    LEFTARG = uint4,
    RIGHTARG = uint2,
    COMMUTATOR = =,
    NEGATOR = <>,
    RESTRICT = eqsel,
    JOIN = eqjoinsel,
    HASHES,
    MERGES,
    PROCEDURE = uint4uint2eq
);

CREATE FUNCTION uint4uint2ne(uint4, uint2) RETURNS boolean IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint4uint2ne';

CREATE OPERATOR <> (
    LEFTARG = uint4,
    RIGHTARG = uint2,
    COMMUTATOR = <>,
    NEGATOR = =,
    RESTRICT = neqsel,
    JOIN = neqjoinsel,
    PROCEDURE = uint4uint2ne
);

CREATE FUNCTION uint4uint2ge(uint4, uint2) RETURNS boolean IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint4uint2ge';

CREATE OPERATOR >= (
    LEFTARG = uint4,
    RIGHTARG = uint2,
    COMMUTATOR = <=,
    NEGATOR = <,
    RESTRICT = scalargtsel,
    JOIN = scalargtjoinsel,
    PROCEDURE = uint4uint2ge
);

CREATE FUNCTION uint4uint2gt(uint4, uint2) RETURNS boolean IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint4uint2gt';

CREATE OPERATOR > (
    LEFTARG = uint4,
    RIGHTARG = uint2,
    COMMUTATOR = <,
    NEGATOR = <=,
    RESTRICT = scalargtsel,
    JOIN = scalargtjoinsel,
    PROCEDURE = uint4uint2gt
);

CREATE FUNCTION btuint4uint2cmp(uint4, uint2) RETURNS integer IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'btuint4uint2cmp';

CREATE FUNCTION uint4uint2pl(uint4, uint2) RETURNS uint4 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint4uint2pl';

CREATE OPERATOR + (
    LEFTARG = uint4,
    RIGHTARG = uint2,
    COMMUTATOR = +,
    PROCEDURE = uint4uint2pl
);

CREATE FUNCTION uint4uint2mi(uint4, uint2) RETURNS uint4 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint4uint2mi';

CREATE OPERATOR - (
    LEFTARG = uint4,
    RIGHTARG = uint2,
    PROCEDURE = uint4uint2mi
);

CREATE FUNCTION uint4uint2mul(uint4, uint2) RETURNS uint4 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint4uint2mul';

CREATE OPERATOR * (
    LEFTARG = uint4,
    RIGHTARG = uint2,
    COMMUTATOR = *,
    PROCEDURE = uint4uint2mul
);

CREATE FUNCTION uint4uint2div(uint4, uint2) RETURNS uint4 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint4uint2div';

CREATE OPERATOR / (
    LEFTARG = uint4,
    RIGHTARG = uint2,
    PROCEDURE = uint4uint2div
);

CREATE FUNCTION mod(uint4, uint2) RETURNS uint4 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint4uint2mod';

CREATE OPERATOR % (
    LEFTARG = uint4,
    RIGHTARG = uint2,
    PROCEDURE = mod
);

CREATE FUNCTION uint2(uint4) RETURNS uint2 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint4_to_uint2';

CREATE CAST (uint4 AS uint2) WITH FUNCTION uint2(uint4) AS ASSIGNMENT;

CREATE FUNCTION uint4uint4lt(uint4, uint4) RETURNS boolean IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint4uint4lt';

CREATE OPERATOR < (
    LEFTARG = uint4,
    RIGHTARG = uint4,
    COMMUTATOR = >,
    NEGATOR = >=,
    RESTRICT = scalarltsel,
    JOIN = scalarltjoinsel,
    PROCEDURE = uint4uint4lt
);

CREATE FUNCTION uint4uint4le(uint4, uint4) RETURNS boolean IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint4uint4le';

CREATE OPERATOR <= (
    LEFTARG = uint4,
    RIGHTARG = uint4,
    COMMUTATOR = >=,
    NEGATOR = >,
    RESTRICT = scalarltsel,
    JOIN = scalarltjoinsel,
    PROCEDURE = uint4uint4le
);

CREATE FUNCTION uint4uint4eq(uint4, uint4) RETURNS boolean IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint4uint4eq';

CREATE OPERATOR = (
    LEFTARG = uint4,
    RIGHTARG = uint4,
    COMMUTATOR = =,
    NEGATOR = <>,
    RESTRICT = eqsel,
    JOIN = eqjoinsel,
    HASHES,
    MERGES,
    PROCEDURE = uint4uint4eq
);

CREATE FUNCTION uint4uint4ne(uint4, uint4) RETURNS boolean IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint4uint4ne';

CREATE OPERATOR <> (
    LEFTARG = uint4,
    RIGHTARG = uint4,
    COMMUTATOR = <>,
    NEGATOR = =,
    RESTRICT = neqsel,
    JOIN = neqjoinsel,
    PROCEDURE = uint4uint4ne
);

CREATE FUNCTION uint4uint4ge(uint4, uint4) RETURNS boolean IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint4uint4ge';

CREATE OPERATOR >= (
    LEFTARG = uint4,
    RIGHTARG = uint4,
    COMMUTATOR = <=,
    NEGATOR = <,
    RESTRICT = scalargtsel,
    JOIN = scalargtjoinsel,
    PROCEDURE = uint4uint4ge
);

CREATE FUNCTION uint4uint4gt(uint4, uint4) RETURNS boolean IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint4uint4gt';

CREATE OPERATOR > (
    LEFTARG = uint4,
    RIGHTARG = uint4,
    COMMUTATOR = <,
    NEGATOR = <=,
    RESTRICT = scalargtsel,
    JOIN = scalargtjoinsel,
    PROCEDURE = uint4uint4gt
);

CREATE FUNCTION btuint4uint4cmp(uint4, uint4) RETURNS integer IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'btuint4uint4cmp';

CREATE FUNCTION uint4uint4pl(uint4, uint4) RETURNS uint4 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint4uint4pl';

CREATE OPERATOR + (
    LEFTARG = uint4,
    RIGHTARG = uint4,
    COMMUTATOR = +,
    PROCEDURE = uint4uint4pl
);

CREATE FUNCTION uint4uint4mi(uint4, uint4) RETURNS uint4 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint4uint4mi';

CREATE OPERATOR - (
    LEFTARG = uint4,
    RIGHTARG = uint4,
    PROCEDURE = uint4uint4mi
);

CREATE FUNCTION uint4uint4mul(uint4, uint4) RETURNS uint4 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint4uint4mul';

CREATE OPERATOR * (
    LEFTARG = uint4,
    RIGHTARG = uint4,
    COMMUTATOR = *,
    PROCEDURE = uint4uint4mul
);

CREATE FUNCTION uint4uint4div(uint4, uint4) RETURNS uint4 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint4uint4div';

CREATE OPERATOR / (
    LEFTARG = uint4,
    RIGHTARG = uint4,
    PROCEDURE = uint4uint4div
);

CREATE FUNCTION mod(uint4, uint4) RETURNS uint4 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint4uint4mod';

CREATE OPERATOR % (
    LEFTARG = uint4,
    RIGHTARG = uint4,
    PROCEDURE = mod
);

CREATE FUNCTION uint4uint8lt(uint4, uint8) RETURNS boolean IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint4uint8lt';

CREATE OPERATOR < (
    LEFTARG = uint4,
    RIGHTARG = uint8,
    COMMUTATOR = >,
    NEGATOR = >=,
    RESTRICT = scalarltsel,
    JOIN = scalarltjoinsel,
    PROCEDURE = uint4uint8lt
);

CREATE FUNCTION uint4uint8le(uint4, uint8) RETURNS boolean IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint4uint8le';

CREATE OPERATOR <= (
    LEFTARG = uint4,
    RIGHTARG = uint8,
    COMMUTATOR = >=,
    NEGATOR = >,
    RESTRICT = scalarltsel,
    JOIN = scalarltjoinsel,
    PROCEDURE = uint4uint8le
);

CREATE FUNCTION uint4uint8eq(uint4, uint8) RETURNS boolean IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint4uint8eq';

CREATE OPERATOR = (
    LEFTARG = uint4,
    RIGHTARG = uint8,
    COMMUTATOR = =,
    NEGATOR = <>,
    RESTRICT = eqsel,
    JOIN = eqjoinsel,
    HASHES,
    MERGES,
    PROCEDURE = uint4uint8eq
);

CREATE FUNCTION uint4uint8ne(uint4, uint8) RETURNS boolean IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint4uint8ne';

CREATE OPERATOR <> (
    LEFTARG = uint4,
    RIGHTARG = uint8,
    COMMUTATOR = <>,
    NEGATOR = =,
    RESTRICT = neqsel,
    JOIN = neqjoinsel,
    PROCEDURE = uint4uint8ne
);

CREATE FUNCTION uint4uint8ge(uint4, uint8) RETURNS boolean IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint4uint8ge';

CREATE OPERATOR >= (
    LEFTARG = uint4,
    RIGHTARG = uint8,
    COMMUTATOR = <=,
    NEGATOR = <,
    RESTRICT = scalargtsel,
    JOIN = scalargtjoinsel,
    PROCEDURE = uint4uint8ge
);

CREATE FUNCTION uint4uint8gt(uint4, uint8) RETURNS boolean IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint4uint8gt';

CREATE OPERATOR > (
    LEFTARG = uint4,
    RIGHTARG = uint8,
    COMMUTATOR = <,
    NEGATOR = <=,
    RESTRICT = scalargtsel,
    JOIN = scalargtjoinsel,
    PROCEDURE = uint4uint8gt
);

CREATE FUNCTION btuint4uint8cmp(uint4, uint8) RETURNS integer IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'btuint4uint8cmp';

CREATE FUNCTION uint4uint8pl(uint4, uint8) RETURNS uint8 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint4uint8pl';

CREATE OPERATOR + (
    LEFTARG = uint4,
    RIGHTARG = uint8,
    COMMUTATOR = +,
    PROCEDURE = uint4uint8pl
);

CREATE FUNCTION uint4uint8mi(uint4, uint8) RETURNS uint8 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint4uint8mi';

CREATE OPERATOR - (
    LEFTARG = uint4,
    RIGHTARG = uint8,
    PROCEDURE = uint4uint8mi
);

CREATE FUNCTION uint4uint8mul(uint4, uint8) RETURNS uint8 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint4uint8mul';

CREATE OPERATOR * (
    LEFTARG = uint4,
    RIGHTARG = uint8,
    COMMUTATOR = *,
    PROCEDURE = uint4uint8mul
);

CREATE FUNCTION uint4uint8div(uint4, uint8) RETURNS uint8 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint4uint8div';

CREATE OPERATOR / (
    LEFTARG = uint4,
    RIGHTARG = uint8,
    PROCEDURE = uint4uint8div
);

CREATE FUNCTION mod(uint4, uint8) RETURNS uint8 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint4uint8mod';

CREATE OPERATOR % (
    LEFTARG = uint4,
    RIGHTARG = uint8,
    PROCEDURE = mod
);

CREATE FUNCTION uint8(uint4) RETURNS uint8 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint4_to_uint8';

CREATE CAST (uint4 AS uint8) WITH FUNCTION uint8(uint4) AS IMPLICIT;

CREATE FUNCTION uint4int2lt(uint4, int2) RETURNS boolean IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint4int2lt';

CREATE OPERATOR < (
    LEFTARG = uint4,
    RIGHTARG = int2,
    COMMUTATOR = >,
    NEGATOR = >=,
    RESTRICT = scalarltsel,
    JOIN = scalarltjoinsel,
    PROCEDURE = uint4int2lt
);

CREATE FUNCTION uint4int2le(uint4, int2) RETURNS boolean IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint4int2le';

CREATE OPERATOR <= (
    LEFTARG = uint4,
    RIGHTARG = int2,
    COMMUTATOR = >=,
    NEGATOR = >,
    RESTRICT = scalarltsel,
    JOIN = scalarltjoinsel,
    PROCEDURE = uint4int2le
);

CREATE FUNCTION uint4int2eq(uint4, int2) RETURNS boolean IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint4int2eq';

CREATE OPERATOR = (
    LEFTARG = uint4,
    RIGHTARG = int2,
    COMMUTATOR = =,
    NEGATOR = <>,
    RESTRICT = eqsel,
    JOIN = eqjoinsel,
    HASHES,
    MERGES,
    PROCEDURE = uint4int2eq
);

CREATE FUNCTION uint4int2ne(uint4, int2) RETURNS boolean IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint4int2ne';

CREATE OPERATOR <> (
    LEFTARG = uint4,
    RIGHTARG = int2,
    COMMUTATOR = <>,
    NEGATOR = =,
    RESTRICT = neqsel,
    JOIN = neqjoinsel,
    PROCEDURE = uint4int2ne
);

CREATE FUNCTION uint4int2ge(uint4, int2) RETURNS boolean IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint4int2ge';

CREATE OPERATOR >= (
    LEFTARG = uint4,
    RIGHTARG = int2,
    COMMUTATOR = <=,
    NEGATOR = <,
    RESTRICT = scalargtsel,
    JOIN = scalargtjoinsel,
    PROCEDURE = uint4int2ge
);

CREATE FUNCTION uint4int2gt(uint4, int2) RETURNS boolean IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint4int2gt';

CREATE OPERATOR > (
    LEFTARG = uint4,
    RIGHTARG = int2,
    COMMUTATOR = <,
    NEGATOR = <=,
    RESTRICT = scalargtsel,
    JOIN = scalargtjoinsel,
    PROCEDURE = uint4int2gt
);

CREATE FUNCTION btuint4int2cmp(uint4, int2) RETURNS integer IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'btuint4int2cmp';

CREATE FUNCTION uint4int2pl(uint4, int2) RETURNS uint4 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint4int2pl';

CREATE OPERATOR + (
    LEFTARG = uint4,
    RIGHTARG = int2,
    COMMUTATOR = +,
    PROCEDURE = uint4int2pl
);

CREATE FUNCTION uint4int2mi(uint4, int2) RETURNS uint4 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint4int2mi';

CREATE OPERATOR - (
    LEFTARG = uint4,
    RIGHTARG = int2,
    PROCEDURE = uint4int2mi
);

CREATE FUNCTION uint4int2mul(uint4, int2) RETURNS uint4 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint4int2mul';

CREATE OPERATOR * (
    LEFTARG = uint4,
    RIGHTARG = int2,
    COMMUTATOR = *,
    PROCEDURE = uint4int2mul
);

CREATE FUNCTION uint4int2div(uint4, int2) RETURNS uint4 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint4int2div';

CREATE OPERATOR / (
    LEFTARG = uint4,
    RIGHTARG = int2,
    PROCEDURE = uint4int2div
);

CREATE FUNCTION mod(uint4, int2) RETURNS uint4 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint4int2mod';

CREATE OPERATOR % (
    LEFTARG = uint4,
    RIGHTARG = int2,
    PROCEDURE = mod
);

CREATE FUNCTION int2(uint4) RETURNS int2 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint4_to_int2';

CREATE CAST (uint4 AS int2) WITH FUNCTION int2(uint4) AS ASSIGNMENT;

CREATE FUNCTION uint4int4lt(uint4, int4) RETURNS boolean IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint4int4lt';

CREATE OPERATOR < (
    LEFTARG = uint4,
    RIGHTARG = int4,
    COMMUTATOR = >,
    NEGATOR = >=,
    RESTRICT = scalarltsel,
    JOIN = scalarltjoinsel,
    PROCEDURE = uint4int4lt
);

CREATE FUNCTION uint4int4le(uint4, int4) RETURNS boolean IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint4int4le';

CREATE OPERATOR <= (
    LEFTARG = uint4,
    RIGHTARG = int4,
    COMMUTATOR = >=,
    NEGATOR = >,
    RESTRICT = scalarltsel,
    JOIN = scalarltjoinsel,
    PROCEDURE = uint4int4le
);

CREATE FUNCTION uint4int4eq(uint4, int4) RETURNS boolean IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint4int4eq';

CREATE OPERATOR = (
    LEFTARG = uint4,
    RIGHTARG = int4,
    COMMUTATOR = =,
    NEGATOR = <>,
    RESTRICT = eqsel,
    JOIN = eqjoinsel,
    HASHES,
    MERGES,
    PROCEDURE = uint4int4eq
);

CREATE FUNCTION uint4int4ne(uint4, int4) RETURNS boolean IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint4int4ne';

CREATE OPERATOR <> (
    LEFTARG = uint4,
    RIGHTARG = int4,
    COMMUTATOR = <>,
    NEGATOR = =,
    RESTRICT = neqsel,
    JOIN = neqjoinsel,
    PROCEDURE = uint4int4ne
);

CREATE FUNCTION uint4int4ge(uint4, int4) RETURNS boolean IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint4int4ge';

CREATE OPERATOR >= (
    LEFTARG = uint4,
    RIGHTARG = int4,
    COMMUTATOR = <=,
    NEGATOR = <,
    RESTRICT = scalargtsel,
    JOIN = scalargtjoinsel,
    PROCEDURE = uint4int4ge
);

CREATE FUNCTION uint4int4gt(uint4, int4) RETURNS boolean IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint4int4gt';

CREATE OPERATOR > (
    LEFTARG = uint4,
    RIGHTARG = int4,
    COMMUTATOR = <,
    NEGATOR = <=,
    RESTRICT = scalargtsel,
    JOIN = scalargtjoinsel,
    PROCEDURE = uint4int4gt
);

CREATE FUNCTION btuint4int4cmp(uint4, int4) RETURNS integer IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'btuint4int4cmp';

CREATE FUNCTION uint4int4pl(uint4, int4) RETURNS uint4 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint4int4pl';

CREATE OPERATOR + (
    LEFTARG = uint4,
    RIGHTARG = int4,
    COMMUTATOR = +,
    PROCEDURE = uint4int4pl
);

CREATE FUNCTION uint4int4mi(uint4, int4) RETURNS uint4 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint4int4mi';

CREATE OPERATOR - (
    LEFTARG = uint4,
    RIGHTARG = int4,
    PROCEDURE = uint4int4mi
);

CREATE FUNCTION uint4int4mul(uint4, int4) RETURNS uint4 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint4int4mul';

CREATE OPERATOR * (
    LEFTARG = uint4,
    RIGHTARG = int4,
    COMMUTATOR = *,
    PROCEDURE = uint4int4mul
);

CREATE FUNCTION uint4int4div(uint4, int4) RETURNS uint4 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint4int4div';

CREATE OPERATOR / (
    LEFTARG = uint4,
    RIGHTARG = int4,
    PROCEDURE = uint4int4div
);

CREATE FUNCTION mod(uint4, int4) RETURNS uint4 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint4int4mod';

CREATE OPERATOR % (
    LEFTARG = uint4,
    RIGHTARG = int4,
    PROCEDURE = mod
);

CREATE FUNCTION int4(uint4) RETURNS int4 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint4_to_int4';

CREATE CAST (uint4 AS int4) WITH FUNCTION int4(uint4) AS ASSIGNMENT;

CREATE FUNCTION uint4int8lt(uint4, int8) RETURNS boolean IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint4int8lt';

CREATE OPERATOR < (
    LEFTARG = uint4,
    RIGHTARG = int8,
    COMMUTATOR = >,
    NEGATOR = >=,
    RESTRICT = scalarltsel,
    JOIN = scalarltjoinsel,
    PROCEDURE = uint4int8lt
);

CREATE FUNCTION uint4int8le(uint4, int8) RETURNS boolean IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint4int8le';

CREATE OPERATOR <= (
    LEFTARG = uint4,
    RIGHTARG = int8,
    COMMUTATOR = >=,
    NEGATOR = >,
    RESTRICT = scalarltsel,
    JOIN = scalarltjoinsel,
    PROCEDURE = uint4int8le
);

CREATE FUNCTION uint4int8eq(uint4, int8) RETURNS boolean IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint4int8eq';

CREATE OPERATOR = (
    LEFTARG = uint4,
    RIGHTARG = int8,
    COMMUTATOR = =,
    NEGATOR = <>,
    RESTRICT = eqsel,
    JOIN = eqjoinsel,
    HASHES,
    MERGES,
    PROCEDURE = uint4int8eq
);

CREATE FUNCTION uint4int8ne(uint4, int8) RETURNS boolean IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint4int8ne';

CREATE OPERATOR <> (
    LEFTARG = uint4,
    RIGHTARG = int8,
    COMMUTATOR = <>,
    NEGATOR = =,
    RESTRICT = neqsel,
    JOIN = neqjoinsel,
    PROCEDURE = uint4int8ne
);

CREATE FUNCTION uint4int8ge(uint4, int8) RETURNS boolean IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint4int8ge';

CREATE OPERATOR >= (
    LEFTARG = uint4,
    RIGHTARG = int8,
    COMMUTATOR = <=,
    NEGATOR = <,
    RESTRICT = scalargtsel,
    JOIN = scalargtjoinsel,
    PROCEDURE = uint4int8ge
);

CREATE FUNCTION uint4int8gt(uint4, int8) RETURNS boolean IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint4int8gt';

CREATE OPERATOR > (
    LEFTARG = uint4,
    RIGHTARG = int8,
    COMMUTATOR = <,
    NEGATOR = <=,
    RESTRICT = scalargtsel,
    JOIN = scalargtjoinsel,
    PROCEDURE = uint4int8gt
);

CREATE FUNCTION btuint4int8cmp(uint4, int8) RETURNS integer IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'btuint4int8cmp';

CREATE FUNCTION uint4int8pl(uint4, int8) RETURNS int8 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint4int8pl';

CREATE OPERATOR + (
    LEFTARG = uint4,
    RIGHTARG = int8,
    COMMUTATOR = +,
    PROCEDURE = uint4int8pl
);

CREATE FUNCTION uint4int8mi(uint4, int8) RETURNS int8 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint4int8mi';

CREATE OPERATOR - (
    LEFTARG = uint4,
    RIGHTARG = int8,
    PROCEDURE = uint4int8mi
);

CREATE FUNCTION uint4int8mul(uint4, int8) RETURNS int8 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint4int8mul';

CREATE OPERATOR * (
    LEFTARG = uint4,
    RIGHTARG = int8,
    COMMUTATOR = *,
    PROCEDURE = uint4int8mul
);

CREATE FUNCTION uint4int8div(uint4, int8) RETURNS int8 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint4int8div';

CREATE OPERATOR / (
    LEFTARG = uint4,
    RIGHTARG = int8,
    PROCEDURE = uint4int8div
);

CREATE FUNCTION mod(uint4, int8) RETURNS int8 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint4int8mod';

CREATE OPERATOR % (
    LEFTARG = uint4,
    RIGHTARG = int8,
    PROCEDURE = mod
);

CREATE FUNCTION int8(uint4) RETURNS int8 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint4_to_int8';

CREATE CAST (uint4 AS int8) WITH FUNCTION int8(uint4) AS IMPLICIT;

CREATE FUNCTION uint8int1lt(uint8, int1) RETURNS boolean IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint8int1lt';

CREATE OPERATOR < (
    LEFTARG = uint8,
    RIGHTARG = int1,
    COMMUTATOR = >,
    NEGATOR = >=,
    RESTRICT = scalarltsel,
    JOIN = scalarltjoinsel,
    PROCEDURE = uint8int1lt
);

CREATE FUNCTION uint8int1le(uint8, int1) RETURNS boolean IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint8int1le';

CREATE OPERATOR <= (
    LEFTARG = uint8,
    RIGHTARG = int1,
    COMMUTATOR = >=,
    NEGATOR = >,
    RESTRICT = scalarltsel,
    JOIN = scalarltjoinsel,
    PROCEDURE = uint8int1le
);

CREATE FUNCTION uint8int1eq(uint8, int1) RETURNS boolean IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint8int1eq';

CREATE OPERATOR = (
    LEFTARG = uint8,
    RIGHTARG = int1,
    COMMUTATOR = =,
    NEGATOR = <>,
    RESTRICT = eqsel,
    JOIN = eqjoinsel,
    HASHES,
    MERGES,
    PROCEDURE = uint8int1eq
);

CREATE FUNCTION uint8int1ne(uint8, int1) RETURNS boolean IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint8int1ne';

CREATE OPERATOR <> (
    LEFTARG = uint8,
    RIGHTARG = int1,
    COMMUTATOR = <>,
    NEGATOR = =,
    RESTRICT = neqsel,
    JOIN = neqjoinsel,
    PROCEDURE = uint8int1ne
);

CREATE FUNCTION uint8int1ge(uint8, int1) RETURNS boolean IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint8int1ge';

CREATE OPERATOR >= (
    LEFTARG = uint8,
    RIGHTARG = int1,
    COMMUTATOR = <=,
    NEGATOR = <,
    RESTRICT = scalargtsel,
    JOIN = scalargtjoinsel,
    PROCEDURE = uint8int1ge
);

CREATE FUNCTION uint8int1gt(uint8, int1) RETURNS boolean IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint8int1gt';

CREATE OPERATOR > (
    LEFTARG = uint8,
    RIGHTARG = int1,
    COMMUTATOR = <,
    NEGATOR = <=,
    RESTRICT = scalargtsel,
    JOIN = scalargtjoinsel,
    PROCEDURE = uint8int1gt
);

CREATE FUNCTION btuint8int1cmp(uint8, int1) RETURNS integer IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'btuint8int1cmp';

CREATE FUNCTION uint8int1pl(uint8, int1) RETURNS uint8 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint8int1pl';

CREATE OPERATOR + (
    LEFTARG = uint8,
    RIGHTARG = int1,
    COMMUTATOR = +,
    PROCEDURE = uint8int1pl
);

CREATE FUNCTION uint8int1mi(uint8, int1) RETURNS uint8 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint8int1mi';

CREATE OPERATOR - (
    LEFTARG = uint8,
    RIGHTARG = int1,
    PROCEDURE = uint8int1mi
);

CREATE FUNCTION uint8int1mul(uint8, int1) RETURNS uint8 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint8int1mul';

CREATE OPERATOR * (
    LEFTARG = uint8,
    RIGHTARG = int1,
    COMMUTATOR = *,
    PROCEDURE = uint8int1mul
);

CREATE FUNCTION uint8int1div(uint8, int1) RETURNS uint8 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint8int1div';

CREATE OPERATOR / (
    LEFTARG = uint8,
    RIGHTARG = int1,
    PROCEDURE = uint8int1div
);

CREATE FUNCTION mod(uint8, int1) RETURNS uint8 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint8int1mod';

CREATE OPERATOR % (
    LEFTARG = uint8,
    RIGHTARG = int1,
    PROCEDURE = mod
);

CREATE FUNCTION int1(uint8) RETURNS int1 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint8_to_int1';

CREATE CAST (uint8 AS int1) WITH FUNCTION int1(uint8) AS ASSIGNMENT;

CREATE FUNCTION uint8uint1lt(uint8, uint1) RETURNS boolean IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint8uint1lt';

CREATE OPERATOR < (
    LEFTARG = uint8,
    RIGHTARG = uint1,
    COMMUTATOR = >,
    NEGATOR = >=,
    RESTRICT = scalarltsel,
    JOIN = scalarltjoinsel,
    PROCEDURE = uint8uint1lt
);

CREATE FUNCTION uint8uint1le(uint8, uint1) RETURNS boolean IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint8uint1le';

CREATE OPERATOR <= (
    LEFTARG = uint8,
    RIGHTARG = uint1,
    COMMUTATOR = >=,
    NEGATOR = >,
    RESTRICT = scalarltsel,
    JOIN = scalarltjoinsel,
    PROCEDURE = uint8uint1le
);

CREATE FUNCTION uint8uint1eq(uint8, uint1) RETURNS boolean IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint8uint1eq';

CREATE OPERATOR = (
    LEFTARG = uint8,
    RIGHTARG = uint1,
    COMMUTATOR = =,
    NEGATOR = <>,
    RESTRICT = eqsel,
    JOIN = eqjoinsel,
    HASHES,
    MERGES,
    PROCEDURE = uint8uint1eq
);

CREATE FUNCTION uint8uint1ne(uint8, uint1) RETURNS boolean IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint8uint1ne';

CREATE OPERATOR <> (
    LEFTARG = uint8,
    RIGHTARG = uint1,
    COMMUTATOR = <>,
    NEGATOR = =,
    RESTRICT = neqsel,
    JOIN = neqjoinsel,
    PROCEDURE = uint8uint1ne
);

CREATE FUNCTION uint8uint1ge(uint8, uint1) RETURNS boolean IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint8uint1ge';

CREATE OPERATOR >= (
    LEFTARG = uint8,
    RIGHTARG = uint1,
    COMMUTATOR = <=,
    NEGATOR = <,
    RESTRICT = scalargtsel,
    JOIN = scalargtjoinsel,
    PROCEDURE = uint8uint1ge
);

CREATE FUNCTION uint8uint1gt(uint8, uint1) RETURNS boolean IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint8uint1gt';

CREATE OPERATOR > (
    LEFTARG = uint8,
    RIGHTARG = uint1,
    COMMUTATOR = <,
    NEGATOR = <=,
    RESTRICT = scalargtsel,
    JOIN = scalargtjoinsel,
    PROCEDURE = uint8uint1gt
);

CREATE FUNCTION btuint8uint1cmp(uint8, uint1) RETURNS integer IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'btuint8uint1cmp';

CREATE FUNCTION uint8uint1pl(uint8, uint1) RETURNS uint8 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint8uint1pl';

CREATE OPERATOR + (
    LEFTARG = uint8,
    RIGHTARG = uint1,
    COMMUTATOR = +,
    PROCEDURE = uint8uint1pl
);

CREATE FUNCTION uint8uint1mi(uint8, uint1) RETURNS uint8 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint8uint1mi';

CREATE OPERATOR - (
    LEFTARG = uint8,
    RIGHTARG = uint1,
    PROCEDURE = uint8uint1mi
);

CREATE FUNCTION uint8uint1mul(uint8, uint1) RETURNS uint8 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint8uint1mul';

CREATE OPERATOR * (
    LEFTARG = uint8,
    RIGHTARG = uint1,
    COMMUTATOR = *,
    PROCEDURE = uint8uint1mul
);

CREATE FUNCTION uint8uint1div(uint8, uint1) RETURNS uint8 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint8uint1div';

CREATE OPERATOR / (
    LEFTARG = uint8,
    RIGHTARG = uint1,
    PROCEDURE = uint8uint1div
);

CREATE FUNCTION mod(uint8, uint1) RETURNS uint8 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint8uint1mod';

CREATE OPERATOR % (
    LEFTARG = uint8,
    RIGHTARG = uint1,
    PROCEDURE = mod
);

CREATE FUNCTION uint1(uint8) RETURNS uint1 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint8_to_uint1';

CREATE CAST (uint8 AS uint1) WITH FUNCTION uint1(uint8) AS ASSIGNMENT;

CREATE FUNCTION uint8uint2lt(uint8, uint2) RETURNS boolean IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint8uint2lt';

CREATE OPERATOR < (
    LEFTARG = uint8,
    RIGHTARG = uint2,
    COMMUTATOR = >,
    NEGATOR = >=,
    RESTRICT = scalarltsel,
    JOIN = scalarltjoinsel,
    PROCEDURE = uint8uint2lt
);

CREATE FUNCTION uint8uint2le(uint8, uint2) RETURNS boolean IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint8uint2le';

CREATE OPERATOR <= (
    LEFTARG = uint8,
    RIGHTARG = uint2,
    COMMUTATOR = >=,
    NEGATOR = >,
    RESTRICT = scalarltsel,
    JOIN = scalarltjoinsel,
    PROCEDURE = uint8uint2le
);

CREATE FUNCTION uint8uint2eq(uint8, uint2) RETURNS boolean IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint8uint2eq';

CREATE OPERATOR = (
    LEFTARG = uint8,
    RIGHTARG = uint2,
    COMMUTATOR = =,
    NEGATOR = <>,
    RESTRICT = eqsel,
    JOIN = eqjoinsel,
    HASHES,
    MERGES,
    PROCEDURE = uint8uint2eq
);

CREATE FUNCTION uint8uint2ne(uint8, uint2) RETURNS boolean IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint8uint2ne';

CREATE OPERATOR <> (
    LEFTARG = uint8,
    RIGHTARG = uint2,
    COMMUTATOR = <>,
    NEGATOR = =,
    RESTRICT = neqsel,
    JOIN = neqjoinsel,
    PROCEDURE = uint8uint2ne
);

CREATE FUNCTION uint8uint2ge(uint8, uint2) RETURNS boolean IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint8uint2ge';

CREATE OPERATOR >= (
    LEFTARG = uint8,
    RIGHTARG = uint2,
    COMMUTATOR = <=,
    NEGATOR = <,
    RESTRICT = scalargtsel,
    JOIN = scalargtjoinsel,
    PROCEDURE = uint8uint2ge
);

CREATE FUNCTION uint8uint2gt(uint8, uint2) RETURNS boolean IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint8uint2gt';

CREATE OPERATOR > (
    LEFTARG = uint8,
    RIGHTARG = uint2,
    COMMUTATOR = <,
    NEGATOR = <=,
    RESTRICT = scalargtsel,
    JOIN = scalargtjoinsel,
    PROCEDURE = uint8uint2gt
);

CREATE FUNCTION btuint8uint2cmp(uint8, uint2) RETURNS integer IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'btuint8uint2cmp';

CREATE FUNCTION uint8uint2pl(uint8, uint2) RETURNS uint8 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint8uint2pl';

CREATE OPERATOR + (
    LEFTARG = uint8,
    RIGHTARG = uint2,
    COMMUTATOR = +,
    PROCEDURE = uint8uint2pl
);

CREATE FUNCTION uint8uint2mi(uint8, uint2) RETURNS uint8 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint8uint2mi';

CREATE OPERATOR - (
    LEFTARG = uint8,
    RIGHTARG = uint2,
    PROCEDURE = uint8uint2mi
);

CREATE FUNCTION uint8uint2mul(uint8, uint2) RETURNS uint8 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint8uint2mul';

CREATE OPERATOR * (
    LEFTARG = uint8,
    RIGHTARG = uint2,
    COMMUTATOR = *,
    PROCEDURE = uint8uint2mul
);

CREATE FUNCTION uint8uint2div(uint8, uint2) RETURNS uint8 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint8uint2div';

CREATE OPERATOR / (
    LEFTARG = uint8,
    RIGHTARG = uint2,
    PROCEDURE = uint8uint2div
);

CREATE FUNCTION mod(uint8, uint2) RETURNS uint8 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint8uint2mod';

CREATE OPERATOR % (
    LEFTARG = uint8,
    RIGHTARG = uint2,
    PROCEDURE = mod
);

CREATE FUNCTION uint2(uint8) RETURNS uint2 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint8_to_uint2';

CREATE CAST (uint8 AS uint2) WITH FUNCTION uint2(uint8) AS ASSIGNMENT;

CREATE FUNCTION uint8uint4lt(uint8, uint4) RETURNS boolean IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint8uint4lt';

CREATE OPERATOR < (
    LEFTARG = uint8,
    RIGHTARG = uint4,
    COMMUTATOR = >,
    NEGATOR = >=,
    RESTRICT = scalarltsel,
    JOIN = scalarltjoinsel,
    PROCEDURE = uint8uint4lt
);

CREATE FUNCTION uint8uint4le(uint8, uint4) RETURNS boolean IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint8uint4le';

CREATE OPERATOR <= (
    LEFTARG = uint8,
    RIGHTARG = uint4,
    COMMUTATOR = >=,
    NEGATOR = >,
    RESTRICT = scalarltsel,
    JOIN = scalarltjoinsel,
    PROCEDURE = uint8uint4le
);

CREATE FUNCTION uint8uint4eq(uint8, uint4) RETURNS boolean IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint8uint4eq';

CREATE OPERATOR = (
    LEFTARG = uint8,
    RIGHTARG = uint4,
    COMMUTATOR = =,
    NEGATOR = <>,
    RESTRICT = eqsel,
    JOIN = eqjoinsel,
    HASHES,
    MERGES,
    PROCEDURE = uint8uint4eq
);

CREATE FUNCTION uint8uint4ne(uint8, uint4) RETURNS boolean IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint8uint4ne';

CREATE OPERATOR <> (
    LEFTARG = uint8,
    RIGHTARG = uint4,
    COMMUTATOR = <>,
    NEGATOR = =,
    RESTRICT = neqsel,
    JOIN = neqjoinsel,
    PROCEDURE = uint8uint4ne
);

CREATE FUNCTION uint8uint4ge(uint8, uint4) RETURNS boolean IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint8uint4ge';

CREATE OPERATOR >= (
    LEFTARG = uint8,
    RIGHTARG = uint4,
    COMMUTATOR = <=,
    NEGATOR = <,
    RESTRICT = scalargtsel,
    JOIN = scalargtjoinsel,
    PROCEDURE = uint8uint4ge
);

CREATE FUNCTION uint8uint4gt(uint8, uint4) RETURNS boolean IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint8uint4gt';

CREATE OPERATOR > (
    LEFTARG = uint8,
    RIGHTARG = uint4,
    COMMUTATOR = <,
    NEGATOR = <=,
    RESTRICT = scalargtsel,
    JOIN = scalargtjoinsel,
    PROCEDURE = uint8uint4gt
);

CREATE FUNCTION btuint8uint4cmp(uint8, uint4) RETURNS integer IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'btuint8uint4cmp';

CREATE FUNCTION uint8uint4pl(uint8, uint4) RETURNS uint8 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint8uint4pl';

CREATE OPERATOR + (
    LEFTARG = uint8,
    RIGHTARG = uint4,
    COMMUTATOR = +,
    PROCEDURE = uint8uint4pl
);

CREATE FUNCTION uint8uint4mi(uint8, uint4) RETURNS uint8 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint8uint4mi';

CREATE OPERATOR - (
    LEFTARG = uint8,
    RIGHTARG = uint4,
    PROCEDURE = uint8uint4mi
);

CREATE FUNCTION uint8uint4mul(uint8, uint4) RETURNS uint8 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint8uint4mul';

CREATE OPERATOR * (
    LEFTARG = uint8,
    RIGHTARG = uint4,
    COMMUTATOR = *,
    PROCEDURE = uint8uint4mul
);

CREATE FUNCTION uint8uint4div(uint8, uint4) RETURNS uint8 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint8uint4div';

CREATE OPERATOR / (
    LEFTARG = uint8,
    RIGHTARG = uint4,
    PROCEDURE = uint8uint4div
);

CREATE FUNCTION mod(uint8, uint4) RETURNS uint8 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint8uint4mod';

CREATE OPERATOR % (
    LEFTARG = uint8,
    RIGHTARG = uint4,
    PROCEDURE = mod
);

CREATE FUNCTION uint4(uint8) RETURNS uint4 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint8_to_uint4';

CREATE CAST (uint8 AS uint4) WITH FUNCTION uint4(uint8) AS ASSIGNMENT;

CREATE FUNCTION uint8uint8lt(uint8, uint8) RETURNS boolean IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint8uint8lt';

CREATE OPERATOR < (
    LEFTARG = uint8,
    RIGHTARG = uint8,
    COMMUTATOR = >,
    NEGATOR = >=,
    RESTRICT = scalarltsel,
    JOIN = scalarltjoinsel,
    PROCEDURE = uint8uint8lt
);

CREATE FUNCTION uint8uint8le(uint8, uint8) RETURNS boolean IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint8uint8le';

CREATE OPERATOR <= (
    LEFTARG = uint8,
    RIGHTARG = uint8,
    COMMUTATOR = >=,
    NEGATOR = >,
    RESTRICT = scalarltsel,
    JOIN = scalarltjoinsel,
    PROCEDURE = uint8uint8le
);

CREATE FUNCTION uint8uint8eq(uint8, uint8) RETURNS boolean IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint8uint8eq';

CREATE OPERATOR = (
    LEFTARG = uint8,
    RIGHTARG = uint8,
    COMMUTATOR = =,
    NEGATOR = <>,
    RESTRICT = eqsel,
    JOIN = eqjoinsel,
    HASHES,
    MERGES,
    PROCEDURE = uint8uint8eq
);

CREATE FUNCTION uint8uint8ne(uint8, uint8) RETURNS boolean IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint8uint8ne';

CREATE OPERATOR <> (
    LEFTARG = uint8,
    RIGHTARG = uint8,
    COMMUTATOR = <>,
    NEGATOR = =,
    RESTRICT = neqsel,
    JOIN = neqjoinsel,
    PROCEDURE = uint8uint8ne
);

CREATE FUNCTION uint8uint8ge(uint8, uint8) RETURNS boolean IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint8uint8ge';

CREATE OPERATOR >= (
    LEFTARG = uint8,
    RIGHTARG = uint8,
    COMMUTATOR = <=,
    NEGATOR = <,
    RESTRICT = scalargtsel,
    JOIN = scalargtjoinsel,
    PROCEDURE = uint8uint8ge
);

CREATE FUNCTION uint8uint8gt(uint8, uint8) RETURNS boolean IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint8uint8gt';

CREATE OPERATOR > (
    LEFTARG = uint8,
    RIGHTARG = uint8,
    COMMUTATOR = <,
    NEGATOR = <=,
    RESTRICT = scalargtsel,
    JOIN = scalargtjoinsel,
    PROCEDURE = uint8uint8gt
);

CREATE FUNCTION btuint8uint8cmp(uint8, uint8) RETURNS integer IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'btuint8uint8cmp';

CREATE FUNCTION uint8uint8pl(uint8, uint8) RETURNS uint8 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint8uint8pl';

CREATE OPERATOR + (
    LEFTARG = uint8,
    RIGHTARG = uint8,
    COMMUTATOR = +,
    PROCEDURE = uint8uint8pl
);

CREATE FUNCTION uint8uint8mi(uint8, uint8) RETURNS uint8 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint8uint8mi';

CREATE OPERATOR - (
    LEFTARG = uint8,
    RIGHTARG = uint8,
    PROCEDURE = uint8uint8mi
);

CREATE FUNCTION uint8uint8mul(uint8, uint8) RETURNS uint8 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint8uint8mul';

CREATE OPERATOR * (
    LEFTARG = uint8,
    RIGHTARG = uint8,
    COMMUTATOR = *,
    PROCEDURE = uint8uint8mul
);

CREATE FUNCTION uint8uint8div(uint8, uint8) RETURNS uint8 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint8uint8div';

CREATE OPERATOR / (
    LEFTARG = uint8,
    RIGHTARG = uint8,
    PROCEDURE = uint8uint8div
);

CREATE FUNCTION mod(uint8, uint8) RETURNS uint8 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint8uint8mod';

CREATE OPERATOR % (
    LEFTARG = uint8,
    RIGHTARG = uint8,
    PROCEDURE = mod
);

CREATE FUNCTION uint8int2lt(uint8, int2) RETURNS boolean IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint8int2lt';

CREATE OPERATOR < (
    LEFTARG = uint8,
    RIGHTARG = int2,
    COMMUTATOR = >,
    NEGATOR = >=,
    RESTRICT = scalarltsel,
    JOIN = scalarltjoinsel,
    PROCEDURE = uint8int2lt
);

CREATE FUNCTION uint8int2le(uint8, int2) RETURNS boolean IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint8int2le';

CREATE OPERATOR <= (
    LEFTARG = uint8,
    RIGHTARG = int2,
    COMMUTATOR = >=,
    NEGATOR = >,
    RESTRICT = scalarltsel,
    JOIN = scalarltjoinsel,
    PROCEDURE = uint8int2le
);

CREATE FUNCTION uint8int2eq(uint8, int2) RETURNS boolean IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint8int2eq';

CREATE OPERATOR = (
    LEFTARG = uint8,
    RIGHTARG = int2,
    COMMUTATOR = =,
    NEGATOR = <>,
    RESTRICT = eqsel,
    JOIN = eqjoinsel,
    HASHES,
    MERGES,
    PROCEDURE = uint8int2eq
);

CREATE FUNCTION uint8int2ne(uint8, int2) RETURNS boolean IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint8int2ne';

CREATE OPERATOR <> (
    LEFTARG = uint8,
    RIGHTARG = int2,
    COMMUTATOR = <>,
    NEGATOR = =,
    RESTRICT = neqsel,
    JOIN = neqjoinsel,
    PROCEDURE = uint8int2ne
);

CREATE FUNCTION uint8int2ge(uint8, int2) RETURNS boolean IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint8int2ge';

CREATE OPERATOR >= (
    LEFTARG = uint8,
    RIGHTARG = int2,
    COMMUTATOR = <=,
    NEGATOR = <,
    RESTRICT = scalargtsel,
    JOIN = scalargtjoinsel,
    PROCEDURE = uint8int2ge
);

CREATE FUNCTION uint8int2gt(uint8, int2) RETURNS boolean IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint8int2gt';

CREATE OPERATOR > (
    LEFTARG = uint8,
    RIGHTARG = int2,
    COMMUTATOR = <,
    NEGATOR = <=,
    RESTRICT = scalargtsel,
    JOIN = scalargtjoinsel,
    PROCEDURE = uint8int2gt
);

CREATE FUNCTION btuint8int2cmp(uint8, int2) RETURNS integer IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'btuint8int2cmp';

CREATE FUNCTION uint8int2pl(uint8, int2) RETURNS uint8 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint8int2pl';

CREATE OPERATOR + (
    LEFTARG = uint8,
    RIGHTARG = int2,
    COMMUTATOR = +,
    PROCEDURE = uint8int2pl
);

CREATE FUNCTION uint8int2mi(uint8, int2) RETURNS uint8 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint8int2mi';

CREATE OPERATOR - (
    LEFTARG = uint8,
    RIGHTARG = int2,
    PROCEDURE = uint8int2mi
);

CREATE FUNCTION uint8int2mul(uint8, int2) RETURNS uint8 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint8int2mul';

CREATE OPERATOR * (
    LEFTARG = uint8,
    RIGHTARG = int2,
    COMMUTATOR = *,
    PROCEDURE = uint8int2mul
);

CREATE FUNCTION uint8int2div(uint8, int2) RETURNS uint8 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint8int2div';

CREATE OPERATOR / (
    LEFTARG = uint8,
    RIGHTARG = int2,
    PROCEDURE = uint8int2div
);

CREATE FUNCTION mod(uint8, int2) RETURNS uint8 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint8int2mod';

CREATE OPERATOR % (
    LEFTARG = uint8,
    RIGHTARG = int2,
    PROCEDURE = mod
);

CREATE FUNCTION int2(uint8) RETURNS int2 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint8_to_int2';

CREATE CAST (uint8 AS int2) WITH FUNCTION int2(uint8) AS ASSIGNMENT;

CREATE FUNCTION uint8int4lt(uint8, int4) RETURNS boolean IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint8int4lt';

CREATE OPERATOR < (
    LEFTARG = uint8,
    RIGHTARG = int4,
    COMMUTATOR = >,
    NEGATOR = >=,
    RESTRICT = scalarltsel,
    JOIN = scalarltjoinsel,
    PROCEDURE = uint8int4lt
);

CREATE FUNCTION uint8int4le(uint8, int4) RETURNS boolean IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint8int4le';

CREATE OPERATOR <= (
    LEFTARG = uint8,
    RIGHTARG = int4,
    COMMUTATOR = >=,
    NEGATOR = >,
    RESTRICT = scalarltsel,
    JOIN = scalarltjoinsel,
    PROCEDURE = uint8int4le
);

CREATE FUNCTION uint8int4eq(uint8, int4) RETURNS boolean IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint8int4eq';

CREATE OPERATOR = (
    LEFTARG = uint8,
    RIGHTARG = int4,
    COMMUTATOR = =,
    NEGATOR = <>,
    RESTRICT = eqsel,
    JOIN = eqjoinsel,
    HASHES,
    MERGES,
    PROCEDURE = uint8int4eq
);

CREATE FUNCTION uint8int4ne(uint8, int4) RETURNS boolean IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint8int4ne';

CREATE OPERATOR <> (
    LEFTARG = uint8,
    RIGHTARG = int4,
    COMMUTATOR = <>,
    NEGATOR = =,
    RESTRICT = neqsel,
    JOIN = neqjoinsel,
    PROCEDURE = uint8int4ne
);

CREATE FUNCTION uint8int4ge(uint8, int4) RETURNS boolean IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint8int4ge';

CREATE OPERATOR >= (
    LEFTARG = uint8,
    RIGHTARG = int4,
    COMMUTATOR = <=,
    NEGATOR = <,
    RESTRICT = scalargtsel,
    JOIN = scalargtjoinsel,
    PROCEDURE = uint8int4ge
);

CREATE FUNCTION uint8int4gt(uint8, int4) RETURNS boolean IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint8int4gt';

CREATE OPERATOR > (
    LEFTARG = uint8,
    RIGHTARG = int4,
    COMMUTATOR = <,
    NEGATOR = <=,
    RESTRICT = scalargtsel,
    JOIN = scalargtjoinsel,
    PROCEDURE = uint8int4gt
);

CREATE FUNCTION btuint8int4cmp(uint8, int4) RETURNS integer IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'btuint8int4cmp';

CREATE FUNCTION uint8int4pl(uint8, int4) RETURNS uint8 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint8int4pl';

CREATE OPERATOR + (
    LEFTARG = uint8,
    RIGHTARG = int4,
    COMMUTATOR = +,
    PROCEDURE = uint8int4pl
);

CREATE FUNCTION uint8int4mi(uint8, int4) RETURNS uint8 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint8int4mi';

CREATE OPERATOR - (
    LEFTARG = uint8,
    RIGHTARG = int4,
    PROCEDURE = uint8int4mi
);

CREATE FUNCTION uint8int4mul(uint8, int4) RETURNS uint8 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint8int4mul';

CREATE OPERATOR * (
    LEFTARG = uint8,
    RIGHTARG = int4,
    COMMUTATOR = *,
    PROCEDURE = uint8int4mul
);

CREATE FUNCTION uint8int4div(uint8, int4) RETURNS uint8 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint8int4div';

CREATE OPERATOR / (
    LEFTARG = uint8,
    RIGHTARG = int4,
    PROCEDURE = uint8int4div
);

CREATE FUNCTION mod(uint8, int4) RETURNS uint8 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint8int4mod';

CREATE OPERATOR % (
    LEFTARG = uint8,
    RIGHTARG = int4,
    PROCEDURE = mod
);

CREATE FUNCTION int4(uint8) RETURNS int4 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint8_to_int4';

CREATE CAST (uint8 AS int4) WITH FUNCTION int4(uint8) AS ASSIGNMENT;

CREATE FUNCTION uint8int8lt(uint8, int8) RETURNS boolean IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint8int8lt';

CREATE OPERATOR < (
    LEFTARG = uint8,
    RIGHTARG = int8,
    COMMUTATOR = >,
    NEGATOR = >=,
    RESTRICT = scalarltsel,
    JOIN = scalarltjoinsel,
    PROCEDURE = uint8int8lt
);

CREATE FUNCTION uint8int8le(uint8, int8) RETURNS boolean IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint8int8le';

CREATE OPERATOR <= (
    LEFTARG = uint8,
    RIGHTARG = int8,
    COMMUTATOR = >=,
    NEGATOR = >,
    RESTRICT = scalarltsel,
    JOIN = scalarltjoinsel,
    PROCEDURE = uint8int8le
);

CREATE FUNCTION uint8int8eq(uint8, int8) RETURNS boolean IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint8int8eq';

CREATE OPERATOR = (
    LEFTARG = uint8,
    RIGHTARG = int8,
    COMMUTATOR = =,
    NEGATOR = <>,
    RESTRICT = eqsel,
    JOIN = eqjoinsel,
    HASHES,
    MERGES,
    PROCEDURE = uint8int8eq
);

CREATE FUNCTION uint8int8ne(uint8, int8) RETURNS boolean IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint8int8ne';

CREATE OPERATOR <> (
    LEFTARG = uint8,
    RIGHTARG = int8,
    COMMUTATOR = <>,
    NEGATOR = =,
    RESTRICT = neqsel,
    JOIN = neqjoinsel,
    PROCEDURE = uint8int8ne
);

CREATE FUNCTION uint8int8ge(uint8, int8) RETURNS boolean IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint8int8ge';

CREATE OPERATOR >= (
    LEFTARG = uint8,
    RIGHTARG = int8,
    COMMUTATOR = <=,
    NEGATOR = <,
    RESTRICT = scalargtsel,
    JOIN = scalargtjoinsel,
    PROCEDURE = uint8int8ge
);

CREATE FUNCTION uint8int8gt(uint8, int8) RETURNS boolean IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint8int8gt';

CREATE OPERATOR > (
    LEFTARG = uint8,
    RIGHTARG = int8,
    COMMUTATOR = <,
    NEGATOR = <=,
    RESTRICT = scalargtsel,
    JOIN = scalargtjoinsel,
    PROCEDURE = uint8int8gt
);

CREATE FUNCTION btuint8int8cmp(uint8, int8) RETURNS integer IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'btuint8int8cmp';

CREATE FUNCTION uint8int8pl(uint8, int8) RETURNS uint8 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint8int8pl';

CREATE OPERATOR + (
    LEFTARG = uint8,
    RIGHTARG = int8,
    COMMUTATOR = +,
    PROCEDURE = uint8int8pl
);

CREATE FUNCTION uint8int8mi(uint8, int8) RETURNS uint8 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint8int8mi';

CREATE OPERATOR - (
    LEFTARG = uint8,
    RIGHTARG = int8,
    PROCEDURE = uint8int8mi
);

CREATE FUNCTION uint8int8mul(uint8, int8) RETURNS uint8 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint8int8mul';

CREATE OPERATOR * (
    LEFTARG = uint8,
    RIGHTARG = int8,
    COMMUTATOR = *,
    PROCEDURE = uint8int8mul
);

CREATE FUNCTION uint8int8div(uint8, int8) RETURNS uint8 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint8int8div';

CREATE OPERATOR / (
    LEFTARG = uint8,
    RIGHTARG = int8,
    PROCEDURE = uint8int8div
);

CREATE FUNCTION mod(uint8, int8) RETURNS uint8 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint8int8mod';

CREATE OPERATOR % (
    LEFTARG = uint8,
    RIGHTARG = int8,
    PROCEDURE = mod
);

CREATE FUNCTION int8(uint8) RETURNS int8 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint8_to_int8';

CREATE CAST (uint8 AS int8) WITH FUNCTION int8(uint8) AS ASSIGNMENT;

CREATE FUNCTION int2int1lt(int2, int1) RETURNS boolean IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'int2int1lt';

CREATE OPERATOR < (
    LEFTARG = int2,
    RIGHTARG = int1,
    COMMUTATOR = >,
    NEGATOR = >=,
    RESTRICT = scalarltsel,
    JOIN = scalarltjoinsel,
    PROCEDURE = int2int1lt
);

CREATE FUNCTION int2int1le(int2, int1) RETURNS boolean IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'int2int1le';

CREATE OPERATOR <= (
    LEFTARG = int2,
    RIGHTARG = int1,
    COMMUTATOR = >=,
    NEGATOR = >,
    RESTRICT = scalarltsel,
    JOIN = scalarltjoinsel,
    PROCEDURE = int2int1le
);

CREATE FUNCTION int2int1eq(int2, int1) RETURNS boolean IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'int2int1eq';

CREATE OPERATOR = (
    LEFTARG = int2,
    RIGHTARG = int1,
    COMMUTATOR = =,
    NEGATOR = <>,
    RESTRICT = eqsel,
    JOIN = eqjoinsel,
    HASHES,
    MERGES,
    PROCEDURE = int2int1eq
);

CREATE FUNCTION int2int1ne(int2, int1) RETURNS boolean IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'int2int1ne';

CREATE OPERATOR <> (
    LEFTARG = int2,
    RIGHTARG = int1,
    COMMUTATOR = <>,
    NEGATOR = =,
    RESTRICT = neqsel,
    JOIN = neqjoinsel,
    PROCEDURE = int2int1ne
);

CREATE FUNCTION int2int1ge(int2, int1) RETURNS boolean IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'int2int1ge';

CREATE OPERATOR >= (
    LEFTARG = int2,
    RIGHTARG = int1,
    COMMUTATOR = <=,
    NEGATOR = <,
    RESTRICT = scalargtsel,
    JOIN = scalargtjoinsel,
    PROCEDURE = int2int1ge
);

CREATE FUNCTION int2int1gt(int2, int1) RETURNS boolean IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'int2int1gt';

CREATE OPERATOR > (
    LEFTARG = int2,
    RIGHTARG = int1,
    COMMUTATOR = <,
    NEGATOR = <=,
    RESTRICT = scalargtsel,
    JOIN = scalargtjoinsel,
    PROCEDURE = int2int1gt
);

CREATE FUNCTION btint2int1cmp(int2, int1) RETURNS integer IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'btint2int1cmp';

CREATE FUNCTION int2int1pl(int2, int1) RETURNS int2 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'int2int1pl';

CREATE OPERATOR + (
    LEFTARG = int2,
    RIGHTARG = int1,
    COMMUTATOR = +,
    PROCEDURE = int2int1pl
);

CREATE FUNCTION int2int1mi(int2, int1) RETURNS int2 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'int2int1mi';

CREATE OPERATOR - (
    LEFTARG = int2,
    RIGHTARG = int1,
    PROCEDURE = int2int1mi
);

CREATE FUNCTION int2int1mul(int2, int1) RETURNS int2 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'int2int1mul';

CREATE OPERATOR * (
    LEFTARG = int2,
    RIGHTARG = int1,
    COMMUTATOR = *,
    PROCEDURE = int2int1mul
);

CREATE FUNCTION int2int1div(int2, int1) RETURNS int2 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'int2int1div';

CREATE OPERATOR / (
    LEFTARG = int2,
    RIGHTARG = int1,
    PROCEDURE = int2int1div
);

CREATE FUNCTION mod(int2, int1) RETURNS int2 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'int2int1mod';

CREATE OPERATOR % (
    LEFTARG = int2,
    RIGHTARG = int1,
    PROCEDURE = mod
);

CREATE FUNCTION int1(int2) RETURNS int1 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'int2_to_int1';

CREATE CAST (int2 AS int1) WITH FUNCTION int1(int2) AS ASSIGNMENT;

CREATE FUNCTION int2uint1lt(int2, uint1) RETURNS boolean IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'int2uint1lt';

CREATE OPERATOR < (
    LEFTARG = int2,
    RIGHTARG = uint1,
    COMMUTATOR = >,
    NEGATOR = >=,
    RESTRICT = scalarltsel,
    JOIN = scalarltjoinsel,
    PROCEDURE = int2uint1lt
);

CREATE FUNCTION int2uint1le(int2, uint1) RETURNS boolean IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'int2uint1le';

CREATE OPERATOR <= (
    LEFTARG = int2,
    RIGHTARG = uint1,
    COMMUTATOR = >=,
    NEGATOR = >,
    RESTRICT = scalarltsel,
    JOIN = scalarltjoinsel,
    PROCEDURE = int2uint1le
);

CREATE FUNCTION int2uint1eq(int2, uint1) RETURNS boolean IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'int2uint1eq';

CREATE OPERATOR = (
    LEFTARG = int2,
    RIGHTARG = uint1,
    COMMUTATOR = =,
    NEGATOR = <>,
    RESTRICT = eqsel,
    JOIN = eqjoinsel,
    HASHES,
    MERGES,
    PROCEDURE = int2uint1eq
);

CREATE FUNCTION int2uint1ne(int2, uint1) RETURNS boolean IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'int2uint1ne';

CREATE OPERATOR <> (
    LEFTARG = int2,
    RIGHTARG = uint1,
    COMMUTATOR = <>,
    NEGATOR = =,
    RESTRICT = neqsel,
    JOIN = neqjoinsel,
    PROCEDURE = int2uint1ne
);

CREATE FUNCTION int2uint1ge(int2, uint1) RETURNS boolean IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'int2uint1ge';

CREATE OPERATOR >= (
    LEFTARG = int2,
    RIGHTARG = uint1,
    COMMUTATOR = <=,
    NEGATOR = <,
    RESTRICT = scalargtsel,
    JOIN = scalargtjoinsel,
    PROCEDURE = int2uint1ge
);

CREATE FUNCTION int2uint1gt(int2, uint1) RETURNS boolean IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'int2uint1gt';

CREATE OPERATOR > (
    LEFTARG = int2,
    RIGHTARG = uint1,
    COMMUTATOR = <,
    NEGATOR = <=,
    RESTRICT = scalargtsel,
    JOIN = scalargtjoinsel,
    PROCEDURE = int2uint1gt
);

CREATE FUNCTION btint2uint1cmp(int2, uint1) RETURNS integer IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'btint2uint1cmp';

CREATE FUNCTION int2uint1pl(int2, uint1) RETURNS int2 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'int2uint1pl';

CREATE OPERATOR + (
    LEFTARG = int2,
    RIGHTARG = uint1,
    COMMUTATOR = +,
    PROCEDURE = int2uint1pl
);

CREATE FUNCTION int2uint1mi(int2, uint1) RETURNS int2 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'int2uint1mi';

CREATE OPERATOR - (
    LEFTARG = int2,
    RIGHTARG = uint1,
    PROCEDURE = int2uint1mi
);

CREATE FUNCTION int2uint1mul(int2, uint1) RETURNS int2 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'int2uint1mul';

CREATE OPERATOR * (
    LEFTARG = int2,
    RIGHTARG = uint1,
    COMMUTATOR = *,
    PROCEDURE = int2uint1mul
);

CREATE FUNCTION int2uint1div(int2, uint1) RETURNS int2 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'int2uint1div';

CREATE OPERATOR / (
    LEFTARG = int2,
    RIGHTARG = uint1,
    PROCEDURE = int2uint1div
);

CREATE FUNCTION mod(int2, uint1) RETURNS int2 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'int2uint1mod';

CREATE OPERATOR % (
    LEFTARG = int2,
    RIGHTARG = uint1,
    PROCEDURE = mod
);

CREATE FUNCTION uint1(int2) RETURNS uint1 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'int2_to_uint1';

CREATE CAST (int2 AS uint1) WITH FUNCTION uint1(int2) AS ASSIGNMENT;

CREATE FUNCTION int2uint2lt(int2, uint2) RETURNS boolean IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'int2uint2lt';

CREATE OPERATOR < (
    LEFTARG = int2,
    RIGHTARG = uint2,
    COMMUTATOR = >,
    NEGATOR = >=,
    RESTRICT = scalarltsel,
    JOIN = scalarltjoinsel,
    PROCEDURE = int2uint2lt
);

CREATE FUNCTION int2uint2le(int2, uint2) RETURNS boolean IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'int2uint2le';

CREATE OPERATOR <= (
    LEFTARG = int2,
    RIGHTARG = uint2,
    COMMUTATOR = >=,
    NEGATOR = >,
    RESTRICT = scalarltsel,
    JOIN = scalarltjoinsel,
    PROCEDURE = int2uint2le
);

CREATE FUNCTION int2uint2eq(int2, uint2) RETURNS boolean IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'int2uint2eq';

CREATE OPERATOR = (
    LEFTARG = int2,
    RIGHTARG = uint2,
    COMMUTATOR = =,
    NEGATOR = <>,
    RESTRICT = eqsel,
    JOIN = eqjoinsel,
    HASHES,
    MERGES,
    PROCEDURE = int2uint2eq
);

CREATE FUNCTION int2uint2ne(int2, uint2) RETURNS boolean IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'int2uint2ne';

CREATE OPERATOR <> (
    LEFTARG = int2,
    RIGHTARG = uint2,
    COMMUTATOR = <>,
    NEGATOR = =,
    RESTRICT = neqsel,
    JOIN = neqjoinsel,
    PROCEDURE = int2uint2ne
);

CREATE FUNCTION int2uint2ge(int2, uint2) RETURNS boolean IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'int2uint2ge';

CREATE OPERATOR >= (
    LEFTARG = int2,
    RIGHTARG = uint2,
    COMMUTATOR = <=,
    NEGATOR = <,
    RESTRICT = scalargtsel,
    JOIN = scalargtjoinsel,
    PROCEDURE = int2uint2ge
);

CREATE FUNCTION int2uint2gt(int2, uint2) RETURNS boolean IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'int2uint2gt';

CREATE OPERATOR > (
    LEFTARG = int2,
    RIGHTARG = uint2,
    COMMUTATOR = <,
    NEGATOR = <=,
    RESTRICT = scalargtsel,
    JOIN = scalargtjoinsel,
    PROCEDURE = int2uint2gt
);

CREATE FUNCTION btint2uint2cmp(int2, uint2) RETURNS integer IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'btint2uint2cmp';

CREATE FUNCTION int2uint2pl(int2, uint2) RETURNS uint2 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'int2uint2pl';

CREATE OPERATOR + (
    LEFTARG = int2,
    RIGHTARG = uint2,
    COMMUTATOR = +,
    PROCEDURE = int2uint2pl
);

CREATE FUNCTION int2uint2mi(int2, uint2) RETURNS uint2 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'int2uint2mi';

CREATE OPERATOR - (
    LEFTARG = int2,
    RIGHTARG = uint2,
    PROCEDURE = int2uint2mi
);

CREATE FUNCTION int2uint2mul(int2, uint2) RETURNS uint2 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'int2uint2mul';

CREATE OPERATOR * (
    LEFTARG = int2,
    RIGHTARG = uint2,
    COMMUTATOR = *,
    PROCEDURE = int2uint2mul
);

CREATE FUNCTION int2uint2div(int2, uint2) RETURNS uint2 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'int2uint2div';

CREATE OPERATOR / (
    LEFTARG = int2,
    RIGHTARG = uint2,
    PROCEDURE = int2uint2div
);

CREATE FUNCTION mod(int2, uint2) RETURNS uint2 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'int2uint2mod';

CREATE OPERATOR % (
    LEFTARG = int2,
    RIGHTARG = uint2,
    PROCEDURE = mod
);

CREATE FUNCTION uint2(int2) RETURNS uint2 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'int2_to_uint2';

CREATE CAST (int2 AS uint2) WITH FUNCTION uint2(int2) AS ASSIGNMENT;

CREATE FUNCTION int2uint4lt(int2, uint4) RETURNS boolean IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'int2uint4lt';

CREATE OPERATOR < (
    LEFTARG = int2,
    RIGHTARG = uint4,
    COMMUTATOR = >,
    NEGATOR = >=,
    RESTRICT = scalarltsel,
    JOIN = scalarltjoinsel,
    PROCEDURE = int2uint4lt
);

CREATE FUNCTION int2uint4le(int2, uint4) RETURNS boolean IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'int2uint4le';

CREATE OPERATOR <= (
    LEFTARG = int2,
    RIGHTARG = uint4,
    COMMUTATOR = >=,
    NEGATOR = >,
    RESTRICT = scalarltsel,
    JOIN = scalarltjoinsel,
    PROCEDURE = int2uint4le
);

CREATE FUNCTION int2uint4eq(int2, uint4) RETURNS boolean IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'int2uint4eq';

CREATE OPERATOR = (
    LEFTARG = int2,
    RIGHTARG = uint4,
    COMMUTATOR = =,
    NEGATOR = <>,
    RESTRICT = eqsel,
    JOIN = eqjoinsel,
    HASHES,
    MERGES,
    PROCEDURE = int2uint4eq
);

CREATE FUNCTION int2uint4ne(int2, uint4) RETURNS boolean IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'int2uint4ne';

CREATE OPERATOR <> (
    LEFTARG = int2,
    RIGHTARG = uint4,
    COMMUTATOR = <>,
    NEGATOR = =,
    RESTRICT = neqsel,
    JOIN = neqjoinsel,
    PROCEDURE = int2uint4ne
);

CREATE FUNCTION int2uint4ge(int2, uint4) RETURNS boolean IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'int2uint4ge';

CREATE OPERATOR >= (
    LEFTARG = int2,
    RIGHTARG = uint4,
    COMMUTATOR = <=,
    NEGATOR = <,
    RESTRICT = scalargtsel,
    JOIN = scalargtjoinsel,
    PROCEDURE = int2uint4ge
);

CREATE FUNCTION int2uint4gt(int2, uint4) RETURNS boolean IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'int2uint4gt';

CREATE OPERATOR > (
    LEFTARG = int2,
    RIGHTARG = uint4,
    COMMUTATOR = <,
    NEGATOR = <=,
    RESTRICT = scalargtsel,
    JOIN = scalargtjoinsel,
    PROCEDURE = int2uint4gt
);

CREATE FUNCTION btint2uint4cmp(int2, uint4) RETURNS integer IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'btint2uint4cmp';

CREATE FUNCTION int2uint4pl(int2, uint4) RETURNS uint4 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'int2uint4pl';

CREATE OPERATOR + (
    LEFTARG = int2,
    RIGHTARG = uint4,
    COMMUTATOR = +,
    PROCEDURE = int2uint4pl
);

CREATE FUNCTION int2uint4mi(int2, uint4) RETURNS uint4 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'int2uint4mi';

CREATE OPERATOR - (
    LEFTARG = int2,
    RIGHTARG = uint4,
    PROCEDURE = int2uint4mi
);

CREATE FUNCTION int2uint4mul(int2, uint4) RETURNS uint4 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'int2uint4mul';

CREATE OPERATOR * (
    LEFTARG = int2,
    RIGHTARG = uint4,
    COMMUTATOR = *,
    PROCEDURE = int2uint4mul
);

CREATE FUNCTION int2uint4div(int2, uint4) RETURNS uint4 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'int2uint4div';

CREATE OPERATOR / (
    LEFTARG = int2,
    RIGHTARG = uint4,
    PROCEDURE = int2uint4div
);

CREATE FUNCTION mod(int2, uint4) RETURNS uint4 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'int2uint4mod';

CREATE OPERATOR % (
    LEFTARG = int2,
    RIGHTARG = uint4,
    PROCEDURE = mod
);

CREATE FUNCTION uint4(int2) RETURNS uint4 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'int2_to_uint4';

CREATE CAST (int2 AS uint4) WITH FUNCTION uint4(int2) AS IMPLICIT;

CREATE FUNCTION int2uint8lt(int2, uint8) RETURNS boolean IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'int2uint8lt';

CREATE OPERATOR < (
    LEFTARG = int2,
    RIGHTARG = uint8,
    COMMUTATOR = >,
    NEGATOR = >=,
    RESTRICT = scalarltsel,
    JOIN = scalarltjoinsel,
    PROCEDURE = int2uint8lt
);

CREATE FUNCTION int2uint8le(int2, uint8) RETURNS boolean IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'int2uint8le';

CREATE OPERATOR <= (
    LEFTARG = int2,
    RIGHTARG = uint8,
    COMMUTATOR = >=,
    NEGATOR = >,
    RESTRICT = scalarltsel,
    JOIN = scalarltjoinsel,
    PROCEDURE = int2uint8le
);

CREATE FUNCTION int2uint8eq(int2, uint8) RETURNS boolean IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'int2uint8eq';

CREATE OPERATOR = (
    LEFTARG = int2,
    RIGHTARG = uint8,
    COMMUTATOR = =,
    NEGATOR = <>,
    RESTRICT = eqsel,
    JOIN = eqjoinsel,
    HASHES,
    MERGES,
    PROCEDURE = int2uint8eq
);

CREATE FUNCTION int2uint8ne(int2, uint8) RETURNS boolean IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'int2uint8ne';

CREATE OPERATOR <> (
    LEFTARG = int2,
    RIGHTARG = uint8,
    COMMUTATOR = <>,
    NEGATOR = =,
    RESTRICT = neqsel,
    JOIN = neqjoinsel,
    PROCEDURE = int2uint8ne
);

CREATE FUNCTION int2uint8ge(int2, uint8) RETURNS boolean IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'int2uint8ge';

CREATE OPERATOR >= (
    LEFTARG = int2,
    RIGHTARG = uint8,
    COMMUTATOR = <=,
    NEGATOR = <,
    RESTRICT = scalargtsel,
    JOIN = scalargtjoinsel,
    PROCEDURE = int2uint8ge
);

CREATE FUNCTION int2uint8gt(int2, uint8) RETURNS boolean IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'int2uint8gt';

CREATE OPERATOR > (
    LEFTARG = int2,
    RIGHTARG = uint8,
    COMMUTATOR = <,
    NEGATOR = <=,
    RESTRICT = scalargtsel,
    JOIN = scalargtjoinsel,
    PROCEDURE = int2uint8gt
);

CREATE FUNCTION btint2uint8cmp(int2, uint8) RETURNS integer IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'btint2uint8cmp';

CREATE FUNCTION int2uint8pl(int2, uint8) RETURNS uint8 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'int2uint8pl';

CREATE OPERATOR + (
    LEFTARG = int2,
    RIGHTARG = uint8,
    COMMUTATOR = +,
    PROCEDURE = int2uint8pl
);

CREATE FUNCTION int2uint8mi(int2, uint8) RETURNS uint8 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'int2uint8mi';

CREATE OPERATOR - (
    LEFTARG = int2,
    RIGHTARG = uint8,
    PROCEDURE = int2uint8mi
);

CREATE FUNCTION int2uint8mul(int2, uint8) RETURNS uint8 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'int2uint8mul';

CREATE OPERATOR * (
    LEFTARG = int2,
    RIGHTARG = uint8,
    COMMUTATOR = *,
    PROCEDURE = int2uint8mul
);

CREATE FUNCTION int2uint8div(int2, uint8) RETURNS uint8 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'int2uint8div';

CREATE OPERATOR / (
    LEFTARG = int2,
    RIGHTARG = uint8,
    PROCEDURE = int2uint8div
);

CREATE FUNCTION mod(int2, uint8) RETURNS uint8 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'int2uint8mod';

CREATE OPERATOR % (
    LEFTARG = int2,
    RIGHTARG = uint8,
    PROCEDURE = mod
);

CREATE FUNCTION uint8(int2) RETURNS uint8 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'int2_to_uint8';

CREATE CAST (int2 AS uint8) WITH FUNCTION uint8(int2) AS IMPLICIT;

CREATE FUNCTION int4int1lt(int4, int1) RETURNS boolean IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'int4int1lt';

CREATE OPERATOR < (
    LEFTARG = int4,
    RIGHTARG = int1,
    COMMUTATOR = >,
    NEGATOR = >=,
    RESTRICT = scalarltsel,
    JOIN = scalarltjoinsel,
    PROCEDURE = int4int1lt
);

CREATE FUNCTION int4int1le(int4, int1) RETURNS boolean IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'int4int1le';

CREATE OPERATOR <= (
    LEFTARG = int4,
    RIGHTARG = int1,
    COMMUTATOR = >=,
    NEGATOR = >,
    RESTRICT = scalarltsel,
    JOIN = scalarltjoinsel,
    PROCEDURE = int4int1le
);

CREATE FUNCTION int4int1eq(int4, int1) RETURNS boolean IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'int4int1eq';

CREATE OPERATOR = (
    LEFTARG = int4,
    RIGHTARG = int1,
    COMMUTATOR = =,
    NEGATOR = <>,
    RESTRICT = eqsel,
    JOIN = eqjoinsel,
    HASHES,
    MERGES,
    PROCEDURE = int4int1eq
);

CREATE FUNCTION int4int1ne(int4, int1) RETURNS boolean IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'int4int1ne';

CREATE OPERATOR <> (
    LEFTARG = int4,
    RIGHTARG = int1,
    COMMUTATOR = <>,
    NEGATOR = =,
    RESTRICT = neqsel,
    JOIN = neqjoinsel,
    PROCEDURE = int4int1ne
);

CREATE FUNCTION int4int1ge(int4, int1) RETURNS boolean IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'int4int1ge';

CREATE OPERATOR >= (
    LEFTARG = int4,
    RIGHTARG = int1,
    COMMUTATOR = <=,
    NEGATOR = <,
    RESTRICT = scalargtsel,
    JOIN = scalargtjoinsel,
    PROCEDURE = int4int1ge
);

CREATE FUNCTION int4int1gt(int4, int1) RETURNS boolean IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'int4int1gt';

CREATE OPERATOR > (
    LEFTARG = int4,
    RIGHTARG = int1,
    COMMUTATOR = <,
    NEGATOR = <=,
    RESTRICT = scalargtsel,
    JOIN = scalargtjoinsel,
    PROCEDURE = int4int1gt
);

CREATE FUNCTION btint4int1cmp(int4, int1) RETURNS integer IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'btint4int1cmp';

CREATE FUNCTION int4int1pl(int4, int1) RETURNS int4 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'int4int1pl';

CREATE OPERATOR + (
    LEFTARG = int4,
    RIGHTARG = int1,
    COMMUTATOR = +,
    PROCEDURE = int4int1pl
);

CREATE FUNCTION int4int1mi(int4, int1) RETURNS int4 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'int4int1mi';

CREATE OPERATOR - (
    LEFTARG = int4,
    RIGHTARG = int1,
    PROCEDURE = int4int1mi
);

CREATE FUNCTION int4int1mul(int4, int1) RETURNS int4 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'int4int1mul';

CREATE OPERATOR * (
    LEFTARG = int4,
    RIGHTARG = int1,
    COMMUTATOR = *,
    PROCEDURE = int4int1mul
);

CREATE FUNCTION int4int1div(int4, int1) RETURNS int4 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'int4int1div';

CREATE OPERATOR / (
    LEFTARG = int4,
    RIGHTARG = int1,
    PROCEDURE = int4int1div
);

CREATE FUNCTION mod(int4, int1) RETURNS int4 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'int4int1mod';

CREATE OPERATOR % (
    LEFTARG = int4,
    RIGHTARG = int1,
    PROCEDURE = mod
);

CREATE FUNCTION int1(int4) RETURNS int1 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'int4_to_int1';

CREATE CAST (int4 AS int1) WITH FUNCTION int1(int4) AS ASSIGNMENT;

CREATE FUNCTION int4uint1lt(int4, uint1) RETURNS boolean IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'int4uint1lt';

CREATE OPERATOR < (
    LEFTARG = int4,
    RIGHTARG = uint1,
    COMMUTATOR = >,
    NEGATOR = >=,
    RESTRICT = scalarltsel,
    JOIN = scalarltjoinsel,
    PROCEDURE = int4uint1lt
);

CREATE FUNCTION int4uint1le(int4, uint1) RETURNS boolean IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'int4uint1le';

CREATE OPERATOR <= (
    LEFTARG = int4,
    RIGHTARG = uint1,
    COMMUTATOR = >=,
    NEGATOR = >,
    RESTRICT = scalarltsel,
    JOIN = scalarltjoinsel,
    PROCEDURE = int4uint1le
);

CREATE FUNCTION int4uint1eq(int4, uint1) RETURNS boolean IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'int4uint1eq';

CREATE OPERATOR = (
    LEFTARG = int4,
    RIGHTARG = uint1,
    COMMUTATOR = =,
    NEGATOR = <>,
    RESTRICT = eqsel,
    JOIN = eqjoinsel,
    HASHES,
    MERGES,
    PROCEDURE = int4uint1eq
);

CREATE FUNCTION int4uint1ne(int4, uint1) RETURNS boolean IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'int4uint1ne';

CREATE OPERATOR <> (
    LEFTARG = int4,
    RIGHTARG = uint1,
    COMMUTATOR = <>,
    NEGATOR = =,
    RESTRICT = neqsel,
    JOIN = neqjoinsel,
    PROCEDURE = int4uint1ne
);

CREATE FUNCTION int4uint1ge(int4, uint1) RETURNS boolean IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'int4uint1ge';

CREATE OPERATOR >= (
    LEFTARG = int4,
    RIGHTARG = uint1,
    COMMUTATOR = <=,
    NEGATOR = <,
    RESTRICT = scalargtsel,
    JOIN = scalargtjoinsel,
    PROCEDURE = int4uint1ge
);

CREATE FUNCTION int4uint1gt(int4, uint1) RETURNS boolean IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'int4uint1gt';

CREATE OPERATOR > (
    LEFTARG = int4,
    RIGHTARG = uint1,
    COMMUTATOR = <,
    NEGATOR = <=,
    RESTRICT = scalargtsel,
    JOIN = scalargtjoinsel,
    PROCEDURE = int4uint1gt
);

CREATE FUNCTION btint4uint1cmp(int4, uint1) RETURNS integer IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'btint4uint1cmp';

CREATE FUNCTION int4uint1pl(int4, uint1) RETURNS int4 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'int4uint1pl';

CREATE OPERATOR + (
    LEFTARG = int4,
    RIGHTARG = uint1,
    COMMUTATOR = +,
    PROCEDURE = int4uint1pl
);

CREATE FUNCTION int4uint1mi(int4, uint1) RETURNS int4 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'int4uint1mi';

CREATE OPERATOR - (
    LEFTARG = int4,
    RIGHTARG = uint1,
    PROCEDURE = int4uint1mi
);

CREATE FUNCTION int4uint1mul(int4, uint1) RETURNS int4 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'int4uint1mul';

CREATE OPERATOR * (
    LEFTARG = int4,
    RIGHTARG = uint1,
    COMMUTATOR = *,
    PROCEDURE = int4uint1mul
);

CREATE FUNCTION int4uint1div(int4, uint1) RETURNS int4 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'int4uint1div';

CREATE OPERATOR / (
    LEFTARG = int4,
    RIGHTARG = uint1,
    PROCEDURE = int4uint1div
);

CREATE FUNCTION mod(int4, uint1) RETURNS int4 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'int4uint1mod';

CREATE OPERATOR % (
    LEFTARG = int4,
    RIGHTARG = uint1,
    PROCEDURE = mod
);

CREATE FUNCTION uint1(int4) RETURNS uint1 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'int4_to_uint1';

CREATE CAST (int4 AS uint1) WITH FUNCTION uint1(int4) AS ASSIGNMENT;

CREATE FUNCTION int4uint2lt(int4, uint2) RETURNS boolean IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'int4uint2lt';

CREATE OPERATOR < (
    LEFTARG = int4,
    RIGHTARG = uint2,
    COMMUTATOR = >,
    NEGATOR = >=,
    RESTRICT = scalarltsel,
    JOIN = scalarltjoinsel,
    PROCEDURE = int4uint2lt
);

CREATE FUNCTION int4uint2le(int4, uint2) RETURNS boolean IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'int4uint2le';

CREATE OPERATOR <= (
    LEFTARG = int4,
    RIGHTARG = uint2,
    COMMUTATOR = >=,
    NEGATOR = >,
    RESTRICT = scalarltsel,
    JOIN = scalarltjoinsel,
    PROCEDURE = int4uint2le
);

CREATE FUNCTION int4uint2eq(int4, uint2) RETURNS boolean IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'int4uint2eq';

CREATE OPERATOR = (
    LEFTARG = int4,
    RIGHTARG = uint2,
    COMMUTATOR = =,
    NEGATOR = <>,
    RESTRICT = eqsel,
    JOIN = eqjoinsel,
    HASHES,
    MERGES,
    PROCEDURE = int4uint2eq
);

CREATE FUNCTION int4uint2ne(int4, uint2) RETURNS boolean IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'int4uint2ne';

CREATE OPERATOR <> (
    LEFTARG = int4,
    RIGHTARG = uint2,
    COMMUTATOR = <>,
    NEGATOR = =,
    RESTRICT = neqsel,
    JOIN = neqjoinsel,
    PROCEDURE = int4uint2ne
);

CREATE FUNCTION int4uint2ge(int4, uint2) RETURNS boolean IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'int4uint2ge';

CREATE OPERATOR >= (
    LEFTARG = int4,
    RIGHTARG = uint2,
    COMMUTATOR = <=,
    NEGATOR = <,
    RESTRICT = scalargtsel,
    JOIN = scalargtjoinsel,
    PROCEDURE = int4uint2ge
);

CREATE FUNCTION int4uint2gt(int4, uint2) RETURNS boolean IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'int4uint2gt';

CREATE OPERATOR > (
    LEFTARG = int4,
    RIGHTARG = uint2,
    COMMUTATOR = <,
    NEGATOR = <=,
    RESTRICT = scalargtsel,
    JOIN = scalargtjoinsel,
    PROCEDURE = int4uint2gt
);

CREATE FUNCTION btint4uint2cmp(int4, uint2) RETURNS integer IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'btint4uint2cmp';

CREATE FUNCTION int4uint2pl(int4, uint2) RETURNS int4 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'int4uint2pl';

CREATE OPERATOR + (
    LEFTARG = int4,
    RIGHTARG = uint2,
    COMMUTATOR = +,
    PROCEDURE = int4uint2pl
);

CREATE FUNCTION int4uint2mi(int4, uint2) RETURNS int4 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'int4uint2mi';

CREATE OPERATOR - (
    LEFTARG = int4,
    RIGHTARG = uint2,
    PROCEDURE = int4uint2mi
);

CREATE FUNCTION int4uint2mul(int4, uint2) RETURNS int4 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'int4uint2mul';

CREATE OPERATOR * (
    LEFTARG = int4,
    RIGHTARG = uint2,
    COMMUTATOR = *,
    PROCEDURE = int4uint2mul
);

CREATE FUNCTION int4uint2div(int4, uint2) RETURNS int4 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'int4uint2div';

CREATE OPERATOR / (
    LEFTARG = int4,
    RIGHTARG = uint2,
    PROCEDURE = int4uint2div
);

CREATE FUNCTION mod(int4, uint2) RETURNS int4 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'int4uint2mod';

CREATE OPERATOR % (
    LEFTARG = int4,
    RIGHTARG = uint2,
    PROCEDURE = mod
);

CREATE FUNCTION uint2(int4) RETURNS uint2 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'int4_to_uint2';

CREATE CAST (int4 AS uint2) WITH FUNCTION uint2(int4) AS ASSIGNMENT;

CREATE FUNCTION int4uint4lt(int4, uint4) RETURNS boolean IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'int4uint4lt';

CREATE OPERATOR < (
    LEFTARG = int4,
    RIGHTARG = uint4,
    COMMUTATOR = >,
    NEGATOR = >=,
    RESTRICT = scalarltsel,
    JOIN = scalarltjoinsel,
    PROCEDURE = int4uint4lt
);

CREATE FUNCTION int4uint4le(int4, uint4) RETURNS boolean IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'int4uint4le';

CREATE OPERATOR <= (
    LEFTARG = int4,
    RIGHTARG = uint4,
    COMMUTATOR = >=,
    NEGATOR = >,
    RESTRICT = scalarltsel,
    JOIN = scalarltjoinsel,
    PROCEDURE = int4uint4le
);

CREATE FUNCTION int4uint4eq(int4, uint4) RETURNS boolean IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'int4uint4eq';

CREATE OPERATOR = (
    LEFTARG = int4,
    RIGHTARG = uint4,
    COMMUTATOR = =,
    NEGATOR = <>,
    RESTRICT = eqsel,
    JOIN = eqjoinsel,
    HASHES,
    MERGES,
    PROCEDURE = int4uint4eq
);

CREATE FUNCTION int4uint4ne(int4, uint4) RETURNS boolean IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'int4uint4ne';

CREATE OPERATOR <> (
    LEFTARG = int4,
    RIGHTARG = uint4,
    COMMUTATOR = <>,
    NEGATOR = =,
    RESTRICT = neqsel,
    JOIN = neqjoinsel,
    PROCEDURE = int4uint4ne
);

CREATE FUNCTION int4uint4ge(int4, uint4) RETURNS boolean IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'int4uint4ge';

CREATE OPERATOR >= (
    LEFTARG = int4,
    RIGHTARG = uint4,
    COMMUTATOR = <=,
    NEGATOR = <,
    RESTRICT = scalargtsel,
    JOIN = scalargtjoinsel,
    PROCEDURE = int4uint4ge
);

CREATE FUNCTION int4uint4gt(int4, uint4) RETURNS boolean IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'int4uint4gt';

CREATE OPERATOR > (
    LEFTARG = int4,
    RIGHTARG = uint4,
    COMMUTATOR = <,
    NEGATOR = <=,
    RESTRICT = scalargtsel,
    JOIN = scalargtjoinsel,
    PROCEDURE = int4uint4gt
);

CREATE FUNCTION btint4uint4cmp(int4, uint4) RETURNS integer IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'btint4uint4cmp';

CREATE FUNCTION int4uint4pl(int4, uint4) RETURNS uint4 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'int4uint4pl';

CREATE OPERATOR + (
    LEFTARG = int4,
    RIGHTARG = uint4,
    COMMUTATOR = +,
    PROCEDURE = int4uint4pl
);

CREATE FUNCTION int4uint4mi(int4, uint4) RETURNS uint4 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'int4uint4mi';

CREATE OPERATOR - (
    LEFTARG = int4,
    RIGHTARG = uint4,
    PROCEDURE = int4uint4mi
);

CREATE FUNCTION int4uint4mul(int4, uint4) RETURNS uint4 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'int4uint4mul';

CREATE OPERATOR * (
    LEFTARG = int4,
    RIGHTARG = uint4,
    COMMUTATOR = *,
    PROCEDURE = int4uint4mul
);

CREATE FUNCTION int4uint4div(int4, uint4) RETURNS uint4 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'int4uint4div';

CREATE OPERATOR / (
    LEFTARG = int4,
    RIGHTARG = uint4,
    PROCEDURE = int4uint4div
);

CREATE FUNCTION mod(int4, uint4) RETURNS uint4 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'int4uint4mod';

CREATE OPERATOR % (
    LEFTARG = int4,
    RIGHTARG = uint4,
    PROCEDURE = mod
);

CREATE FUNCTION uint4(int4) RETURNS uint4 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'int4_to_uint4';

CREATE CAST (int4 AS uint4) WITH FUNCTION uint4(int4) AS ASSIGNMENT;

CREATE FUNCTION int4uint8lt(int4, uint8) RETURNS boolean IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'int4uint8lt';

CREATE OPERATOR < (
    LEFTARG = int4,
    RIGHTARG = uint8,
    COMMUTATOR = >,
    NEGATOR = >=,
    RESTRICT = scalarltsel,
    JOIN = scalarltjoinsel,
    PROCEDURE = int4uint8lt
);

CREATE FUNCTION int4uint8le(int4, uint8) RETURNS boolean IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'int4uint8le';

CREATE OPERATOR <= (
    LEFTARG = int4,
    RIGHTARG = uint8,
    COMMUTATOR = >=,
    NEGATOR = >,
    RESTRICT = scalarltsel,
    JOIN = scalarltjoinsel,
    PROCEDURE = int4uint8le
);

CREATE FUNCTION int4uint8eq(int4, uint8) RETURNS boolean IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'int4uint8eq';

CREATE OPERATOR = (
    LEFTARG = int4,
    RIGHTARG = uint8,
    COMMUTATOR = =,
    NEGATOR = <>,
    RESTRICT = eqsel,
    JOIN = eqjoinsel,
    HASHES,
    MERGES,
    PROCEDURE = int4uint8eq
);

CREATE FUNCTION int4uint8ne(int4, uint8) RETURNS boolean IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'int4uint8ne';

CREATE OPERATOR <> (
    LEFTARG = int4,
    RIGHTARG = uint8,
    COMMUTATOR = <>,
    NEGATOR = =,
    RESTRICT = neqsel,
    JOIN = neqjoinsel,
    PROCEDURE = int4uint8ne
);

CREATE FUNCTION int4uint8ge(int4, uint8) RETURNS boolean IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'int4uint8ge';

CREATE OPERATOR >= (
    LEFTARG = int4,
    RIGHTARG = uint8,
    COMMUTATOR = <=,
    NEGATOR = <,
    RESTRICT = scalargtsel,
    JOIN = scalargtjoinsel,
    PROCEDURE = int4uint8ge
);

CREATE FUNCTION int4uint8gt(int4, uint8) RETURNS boolean IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'int4uint8gt';

CREATE OPERATOR > (
    LEFTARG = int4,
    RIGHTARG = uint8,
    COMMUTATOR = <,
    NEGATOR = <=,
    RESTRICT = scalargtsel,
    JOIN = scalargtjoinsel,
    PROCEDURE = int4uint8gt
);

CREATE FUNCTION btint4uint8cmp(int4, uint8) RETURNS integer IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'btint4uint8cmp';

CREATE FUNCTION int4uint8pl(int4, uint8) RETURNS uint8 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'int4uint8pl';

CREATE OPERATOR + (
    LEFTARG = int4,
    RIGHTARG = uint8,
    COMMUTATOR = +,
    PROCEDURE = int4uint8pl
);

CREATE FUNCTION int4uint8mi(int4, uint8) RETURNS uint8 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'int4uint8mi';

CREATE OPERATOR - (
    LEFTARG = int4,
    RIGHTARG = uint8,
    PROCEDURE = int4uint8mi
);

CREATE FUNCTION int4uint8mul(int4, uint8) RETURNS uint8 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'int4uint8mul';

CREATE OPERATOR * (
    LEFTARG = int4,
    RIGHTARG = uint8,
    COMMUTATOR = *,
    PROCEDURE = int4uint8mul
);

CREATE FUNCTION int4uint8div(int4, uint8) RETURNS uint8 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'int4uint8div';

CREATE OPERATOR / (
    LEFTARG = int4,
    RIGHTARG = uint8,
    PROCEDURE = int4uint8div
);

CREATE FUNCTION mod(int4, uint8) RETURNS uint8 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'int4uint8mod';

CREATE OPERATOR % (
    LEFTARG = int4,
    RIGHTARG = uint8,
    PROCEDURE = mod
);

CREATE FUNCTION uint8(int4) RETURNS uint8 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'int4_to_uint8';

CREATE CAST (int4 AS uint8) WITH FUNCTION uint8(int4) AS IMPLICIT;

CREATE FUNCTION int8int1lt(int8, int1) RETURNS boolean IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'int8int1lt';

CREATE OPERATOR < (
    LEFTARG = int8,
    RIGHTARG = int1,
    COMMUTATOR = >,
    NEGATOR = >=,
    RESTRICT = scalarltsel,
    JOIN = scalarltjoinsel,
    PROCEDURE = int8int1lt
);

CREATE FUNCTION int8int1le(int8, int1) RETURNS boolean IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'int8int1le';

CREATE OPERATOR <= (
    LEFTARG = int8,
    RIGHTARG = int1,
    COMMUTATOR = >=,
    NEGATOR = >,
    RESTRICT = scalarltsel,
    JOIN = scalarltjoinsel,
    PROCEDURE = int8int1le
);

CREATE FUNCTION int8int1eq(int8, int1) RETURNS boolean IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'int8int1eq';

CREATE OPERATOR = (
    LEFTARG = int8,
    RIGHTARG = int1,
    COMMUTATOR = =,
    NEGATOR = <>,
    RESTRICT = eqsel,
    JOIN = eqjoinsel,
    HASHES,
    MERGES,
    PROCEDURE = int8int1eq
);

CREATE FUNCTION int8int1ne(int8, int1) RETURNS boolean IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'int8int1ne';

CREATE OPERATOR <> (
    LEFTARG = int8,
    RIGHTARG = int1,
    COMMUTATOR = <>,
    NEGATOR = =,
    RESTRICT = neqsel,
    JOIN = neqjoinsel,
    PROCEDURE = int8int1ne
);

CREATE FUNCTION int8int1ge(int8, int1) RETURNS boolean IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'int8int1ge';

CREATE OPERATOR >= (
    LEFTARG = int8,
    RIGHTARG = int1,
    COMMUTATOR = <=,
    NEGATOR = <,
    RESTRICT = scalargtsel,
    JOIN = scalargtjoinsel,
    PROCEDURE = int8int1ge
);

CREATE FUNCTION int8int1gt(int8, int1) RETURNS boolean IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'int8int1gt';

CREATE OPERATOR > (
    LEFTARG = int8,
    RIGHTARG = int1,
    COMMUTATOR = <,
    NEGATOR = <=,
    RESTRICT = scalargtsel,
    JOIN = scalargtjoinsel,
    PROCEDURE = int8int1gt
);

CREATE FUNCTION btint8int1cmp(int8, int1) RETURNS integer IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'btint8int1cmp';

CREATE FUNCTION int8int1pl(int8, int1) RETURNS int8 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'int8int1pl';

CREATE OPERATOR + (
    LEFTARG = int8,
    RIGHTARG = int1,
    COMMUTATOR = +,
    PROCEDURE = int8int1pl
);

CREATE FUNCTION int8int1mi(int8, int1) RETURNS int8 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'int8int1mi';

CREATE OPERATOR - (
    LEFTARG = int8,
    RIGHTARG = int1,
    PROCEDURE = int8int1mi
);

CREATE FUNCTION int8int1mul(int8, int1) RETURNS int8 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'int8int1mul';

CREATE OPERATOR * (
    LEFTARG = int8,
    RIGHTARG = int1,
    COMMUTATOR = *,
    PROCEDURE = int8int1mul
);

CREATE FUNCTION int8int1div(int8, int1) RETURNS int8 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'int8int1div';

CREATE OPERATOR / (
    LEFTARG = int8,
    RIGHTARG = int1,
    PROCEDURE = int8int1div
);

CREATE FUNCTION mod(int8, int1) RETURNS int8 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'int8int1mod';

CREATE OPERATOR % (
    LEFTARG = int8,
    RIGHTARG = int1,
    PROCEDURE = mod
);

CREATE FUNCTION int1(int8) RETURNS int1 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'int8_to_int1';

CREATE CAST (int8 AS int1) WITH FUNCTION int1(int8) AS ASSIGNMENT;

CREATE FUNCTION int8uint1lt(int8, uint1) RETURNS boolean IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'int8uint1lt';

CREATE OPERATOR < (
    LEFTARG = int8,
    RIGHTARG = uint1,
    COMMUTATOR = >,
    NEGATOR = >=,
    RESTRICT = scalarltsel,
    JOIN = scalarltjoinsel,
    PROCEDURE = int8uint1lt
);

CREATE FUNCTION int8uint1le(int8, uint1) RETURNS boolean IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'int8uint1le';

CREATE OPERATOR <= (
    LEFTARG = int8,
    RIGHTARG = uint1,
    COMMUTATOR = >=,
    NEGATOR = >,
    RESTRICT = scalarltsel,
    JOIN = scalarltjoinsel,
    PROCEDURE = int8uint1le
);

CREATE FUNCTION int8uint1eq(int8, uint1) RETURNS boolean IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'int8uint1eq';

CREATE OPERATOR = (
    LEFTARG = int8,
    RIGHTARG = uint1,
    COMMUTATOR = =,
    NEGATOR = <>,
    RESTRICT = eqsel,
    JOIN = eqjoinsel,
    HASHES,
    MERGES,
    PROCEDURE = int8uint1eq
);

CREATE FUNCTION int8uint1ne(int8, uint1) RETURNS boolean IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'int8uint1ne';

CREATE OPERATOR <> (
    LEFTARG = int8,
    RIGHTARG = uint1,
    COMMUTATOR = <>,
    NEGATOR = =,
    RESTRICT = neqsel,
    JOIN = neqjoinsel,
    PROCEDURE = int8uint1ne
);

CREATE FUNCTION int8uint1ge(int8, uint1) RETURNS boolean IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'int8uint1ge';

CREATE OPERATOR >= (
    LEFTARG = int8,
    RIGHTARG = uint1,
    COMMUTATOR = <=,
    NEGATOR = <,
    RESTRICT = scalargtsel,
    JOIN = scalargtjoinsel,
    PROCEDURE = int8uint1ge
);

CREATE FUNCTION int8uint1gt(int8, uint1) RETURNS boolean IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'int8uint1gt';

CREATE OPERATOR > (
    LEFTARG = int8,
    RIGHTARG = uint1,
    COMMUTATOR = <,
    NEGATOR = <=,
    RESTRICT = scalargtsel,
    JOIN = scalargtjoinsel,
    PROCEDURE = int8uint1gt
);

CREATE FUNCTION btint8uint1cmp(int8, uint1) RETURNS integer IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'btint8uint1cmp';

CREATE FUNCTION int8uint1pl(int8, uint1) RETURNS int8 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'int8uint1pl';

CREATE OPERATOR + (
    LEFTARG = int8,
    RIGHTARG = uint1,
    COMMUTATOR = +,
    PROCEDURE = int8uint1pl
);

CREATE FUNCTION int8uint1mi(int8, uint1) RETURNS int8 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'int8uint1mi';

CREATE OPERATOR - (
    LEFTARG = int8,
    RIGHTARG = uint1,
    PROCEDURE = int8uint1mi
);

CREATE FUNCTION int8uint1mul(int8, uint1) RETURNS int8 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'int8uint1mul';

CREATE OPERATOR * (
    LEFTARG = int8,
    RIGHTARG = uint1,
    COMMUTATOR = *,
    PROCEDURE = int8uint1mul
);

CREATE FUNCTION int8uint1div(int8, uint1) RETURNS int8 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'int8uint1div';

CREATE OPERATOR / (
    LEFTARG = int8,
    RIGHTARG = uint1,
    PROCEDURE = int8uint1div
);

CREATE FUNCTION mod(int8, uint1) RETURNS int8 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'int8uint1mod';

CREATE OPERATOR % (
    LEFTARG = int8,
    RIGHTARG = uint1,
    PROCEDURE = mod
);

CREATE FUNCTION uint1(int8) RETURNS uint1 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'int8_to_uint1';

CREATE CAST (int8 AS uint1) WITH FUNCTION uint1(int8) AS ASSIGNMENT;

CREATE FUNCTION int8uint2lt(int8, uint2) RETURNS boolean IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'int8uint2lt';

CREATE OPERATOR < (
    LEFTARG = int8,
    RIGHTARG = uint2,
    COMMUTATOR = >,
    NEGATOR = >=,
    RESTRICT = scalarltsel,
    JOIN = scalarltjoinsel,
    PROCEDURE = int8uint2lt
);

CREATE FUNCTION int8uint2le(int8, uint2) RETURNS boolean IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'int8uint2le';

CREATE OPERATOR <= (
    LEFTARG = int8,
    RIGHTARG = uint2,
    COMMUTATOR = >=,
    NEGATOR = >,
    RESTRICT = scalarltsel,
    JOIN = scalarltjoinsel,
    PROCEDURE = int8uint2le
);

CREATE FUNCTION int8uint2eq(int8, uint2) RETURNS boolean IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'int8uint2eq';

CREATE OPERATOR = (
    LEFTARG = int8,
    RIGHTARG = uint2,
    COMMUTATOR = =,
    NEGATOR = <>,
    RESTRICT = eqsel,
    JOIN = eqjoinsel,
    HASHES,
    MERGES,
    PROCEDURE = int8uint2eq
);

CREATE FUNCTION int8uint2ne(int8, uint2) RETURNS boolean IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'int8uint2ne';

CREATE OPERATOR <> (
    LEFTARG = int8,
    RIGHTARG = uint2,
    COMMUTATOR = <>,
    NEGATOR = =,
    RESTRICT = neqsel,
    JOIN = neqjoinsel,
    PROCEDURE = int8uint2ne
);

CREATE FUNCTION int8uint2ge(int8, uint2) RETURNS boolean IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'int8uint2ge';

CREATE OPERATOR >= (
    LEFTARG = int8,
    RIGHTARG = uint2,
    COMMUTATOR = <=,
    NEGATOR = <,
    RESTRICT = scalargtsel,
    JOIN = scalargtjoinsel,
    PROCEDURE = int8uint2ge
);

CREATE FUNCTION int8uint2gt(int8, uint2) RETURNS boolean IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'int8uint2gt';

CREATE OPERATOR > (
    LEFTARG = int8,
    RIGHTARG = uint2,
    COMMUTATOR = <,
    NEGATOR = <=,
    RESTRICT = scalargtsel,
    JOIN = scalargtjoinsel,
    PROCEDURE = int8uint2gt
);

CREATE FUNCTION btint8uint2cmp(int8, uint2) RETURNS integer IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'btint8uint2cmp';

CREATE FUNCTION int8uint2pl(int8, uint2) RETURNS int8 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'int8uint2pl';

CREATE OPERATOR + (
    LEFTARG = int8,
    RIGHTARG = uint2,
    COMMUTATOR = +,
    PROCEDURE = int8uint2pl
);

CREATE FUNCTION int8uint2mi(int8, uint2) RETURNS int8 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'int8uint2mi';

CREATE OPERATOR - (
    LEFTARG = int8,
    RIGHTARG = uint2,
    PROCEDURE = int8uint2mi
);

CREATE FUNCTION int8uint2mul(int8, uint2) RETURNS int8 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'int8uint2mul';

CREATE OPERATOR * (
    LEFTARG = int8,
    RIGHTARG = uint2,
    COMMUTATOR = *,
    PROCEDURE = int8uint2mul
);

CREATE FUNCTION int8uint2div(int8, uint2) RETURNS int8 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'int8uint2div';

CREATE OPERATOR / (
    LEFTARG = int8,
    RIGHTARG = uint2,
    PROCEDURE = int8uint2div
);

CREATE FUNCTION mod(int8, uint2) RETURNS int8 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'int8uint2mod';

CREATE OPERATOR % (
    LEFTARG = int8,
    RIGHTARG = uint2,
    PROCEDURE = mod
);

CREATE FUNCTION uint2(int8) RETURNS uint2 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'int8_to_uint2';

CREATE CAST (int8 AS uint2) WITH FUNCTION uint2(int8) AS ASSIGNMENT;

CREATE FUNCTION int8uint4lt(int8, uint4) RETURNS boolean IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'int8uint4lt';

CREATE OPERATOR < (
    LEFTARG = int8,
    RIGHTARG = uint4,
    COMMUTATOR = >,
    NEGATOR = >=,
    RESTRICT = scalarltsel,
    JOIN = scalarltjoinsel,
    PROCEDURE = int8uint4lt
);

CREATE FUNCTION int8uint4le(int8, uint4) RETURNS boolean IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'int8uint4le';

CREATE OPERATOR <= (
    LEFTARG = int8,
    RIGHTARG = uint4,
    COMMUTATOR = >=,
    NEGATOR = >,
    RESTRICT = scalarltsel,
    JOIN = scalarltjoinsel,
    PROCEDURE = int8uint4le
);

CREATE FUNCTION int8uint4eq(int8, uint4) RETURNS boolean IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'int8uint4eq';

CREATE OPERATOR = (
    LEFTARG = int8,
    RIGHTARG = uint4,
    COMMUTATOR = =,
    NEGATOR = <>,
    RESTRICT = eqsel,
    JOIN = eqjoinsel,
    HASHES,
    MERGES,
    PROCEDURE = int8uint4eq
);

CREATE FUNCTION int8uint4ne(int8, uint4) RETURNS boolean IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'int8uint4ne';

CREATE OPERATOR <> (
    LEFTARG = int8,
    RIGHTARG = uint4,
    COMMUTATOR = <>,
    NEGATOR = =,
    RESTRICT = neqsel,
    JOIN = neqjoinsel,
    PROCEDURE = int8uint4ne
);

CREATE FUNCTION int8uint4ge(int8, uint4) RETURNS boolean IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'int8uint4ge';

CREATE OPERATOR >= (
    LEFTARG = int8,
    RIGHTARG = uint4,
    COMMUTATOR = <=,
    NEGATOR = <,
    RESTRICT = scalargtsel,
    JOIN = scalargtjoinsel,
    PROCEDURE = int8uint4ge
);

CREATE FUNCTION int8uint4gt(int8, uint4) RETURNS boolean IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'int8uint4gt';

CREATE OPERATOR > (
    LEFTARG = int8,
    RIGHTARG = uint4,
    COMMUTATOR = <,
    NEGATOR = <=,
    RESTRICT = scalargtsel,
    JOIN = scalargtjoinsel,
    PROCEDURE = int8uint4gt
);

CREATE FUNCTION btint8uint4cmp(int8, uint4) RETURNS integer IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'btint8uint4cmp';

CREATE FUNCTION int8uint4pl(int8, uint4) RETURNS int8 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'int8uint4pl';

CREATE OPERATOR + (
    LEFTARG = int8,
    RIGHTARG = uint4,
    COMMUTATOR = +,
    PROCEDURE = int8uint4pl
);

CREATE FUNCTION int8uint4mi(int8, uint4) RETURNS int8 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'int8uint4mi';

CREATE OPERATOR - (
    LEFTARG = int8,
    RIGHTARG = uint4,
    PROCEDURE = int8uint4mi
);

CREATE FUNCTION int8uint4mul(int8, uint4) RETURNS int8 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'int8uint4mul';

CREATE OPERATOR * (
    LEFTARG = int8,
    RIGHTARG = uint4,
    COMMUTATOR = *,
    PROCEDURE = int8uint4mul
);

CREATE FUNCTION int8uint4div(int8, uint4) RETURNS int8 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'int8uint4div';

CREATE OPERATOR / (
    LEFTARG = int8,
    RIGHTARG = uint4,
    PROCEDURE = int8uint4div
);

CREATE FUNCTION mod(int8, uint4) RETURNS int8 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'int8uint4mod';

CREATE OPERATOR % (
    LEFTARG = int8,
    RIGHTARG = uint4,
    PROCEDURE = mod
);

CREATE FUNCTION uint4(int8) RETURNS uint4 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'int8_to_uint4';

CREATE CAST (int8 AS uint4) WITH FUNCTION uint4(int8) AS ASSIGNMENT;

CREATE FUNCTION int8uint8lt(int8, uint8) RETURNS boolean IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'int8uint8lt';

CREATE OPERATOR < (
    LEFTARG = int8,
    RIGHTARG = uint8,
    COMMUTATOR = >,
    NEGATOR = >=,
    RESTRICT = scalarltsel,
    JOIN = scalarltjoinsel,
    PROCEDURE = int8uint8lt
);

CREATE FUNCTION int8uint8le(int8, uint8) RETURNS boolean IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'int8uint8le';

CREATE OPERATOR <= (
    LEFTARG = int8,
    RIGHTARG = uint8,
    COMMUTATOR = >=,
    NEGATOR = >,
    RESTRICT = scalarltsel,
    JOIN = scalarltjoinsel,
    PROCEDURE = int8uint8le
);

CREATE FUNCTION int8uint8eq(int8, uint8) RETURNS boolean IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'int8uint8eq';

CREATE OPERATOR = (
    LEFTARG = int8,
    RIGHTARG = uint8,
    COMMUTATOR = =,
    NEGATOR = <>,
    RESTRICT = eqsel,
    JOIN = eqjoinsel,
    HASHES,
    MERGES,
    PROCEDURE = int8uint8eq
);

CREATE FUNCTION int8uint8ne(int8, uint8) RETURNS boolean IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'int8uint8ne';

CREATE OPERATOR <> (
    LEFTARG = int8,
    RIGHTARG = uint8,
    COMMUTATOR = <>,
    NEGATOR = =,
    RESTRICT = neqsel,
    JOIN = neqjoinsel,
    PROCEDURE = int8uint8ne
);

CREATE FUNCTION int8uint8ge(int8, uint8) RETURNS boolean IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'int8uint8ge';

CREATE OPERATOR >= (
    LEFTARG = int8,
    RIGHTARG = uint8,
    COMMUTATOR = <=,
    NEGATOR = <,
    RESTRICT = scalargtsel,
    JOIN = scalargtjoinsel,
    PROCEDURE = int8uint8ge
);

CREATE FUNCTION int8uint8gt(int8, uint8) RETURNS boolean IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'int8uint8gt';

CREATE OPERATOR > (
    LEFTARG = int8,
    RIGHTARG = uint8,
    COMMUTATOR = <,
    NEGATOR = <=,
    RESTRICT = scalargtsel,
    JOIN = scalargtjoinsel,
    PROCEDURE = int8uint8gt
);

CREATE FUNCTION btint8uint8cmp(int8, uint8) RETURNS integer IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'btint8uint8cmp';

CREATE FUNCTION int8uint8pl(int8, uint8) RETURNS uint8 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'int8uint8pl';

CREATE OPERATOR + (
    LEFTARG = int8,
    RIGHTARG = uint8,
    COMMUTATOR = +,
    PROCEDURE = int8uint8pl
);

CREATE FUNCTION int8uint8mi(int8, uint8) RETURNS uint8 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'int8uint8mi';

CREATE OPERATOR - (
    LEFTARG = int8,
    RIGHTARG = uint8,
    PROCEDURE = int8uint8mi
);

CREATE FUNCTION int8uint8mul(int8, uint8) RETURNS uint8 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'int8uint8mul';

CREATE OPERATOR * (
    LEFTARG = int8,
    RIGHTARG = uint8,
    COMMUTATOR = *,
    PROCEDURE = int8uint8mul
);

CREATE FUNCTION int8uint8div(int8, uint8) RETURNS uint8 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'int8uint8div';

CREATE OPERATOR / (
    LEFTARG = int8,
    RIGHTARG = uint8,
    PROCEDURE = int8uint8div
);

CREATE FUNCTION mod(int8, uint8) RETURNS uint8 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'int8uint8mod';

CREATE OPERATOR % (
    LEFTARG = int8,
    RIGHTARG = uint8,
    PROCEDURE = mod
);

CREATE FUNCTION uint8(int8) RETURNS uint8 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'int8_to_uint8';

CREATE CAST (int8 AS uint8) WITH FUNCTION uint8(int8) AS ASSIGNMENT;

CREATE FUNCTION int1int1and(int1, int1) RETURNS int1 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'int1int1and';

CREATE OPERATOR & (
    LEFTARG = int1,
    RIGHTARG = int1,
    COMMUTATOR = &,
    PROCEDURE = int1int1and
);

CREATE FUNCTION int1int1or(int1, int1) RETURNS int1 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'int1int1or';

CREATE OPERATOR | (
    LEFTARG = int1,
    RIGHTARG = int1,
    COMMUTATOR = |,
    PROCEDURE = int1int1or
);

CREATE FUNCTION int1int1xor(int1, int1) RETURNS int1 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'int1int1xor';

CREATE OPERATOR # (
    LEFTARG = int1,
    RIGHTARG = int1,
    COMMUTATOR = #,
    PROCEDURE = int1int1xor
);

CREATE FUNCTION int1not(int1) RETURNS int1 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'int1not';

CREATE OPERATOR ~ (
    RIGHTARG = int1,
    PROCEDURE = int1not
);

CREATE FUNCTION int1int4shl(int1, int4) RETURNS int1 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'int1int4shl';

CREATE OPERATOR << (
    LEFTARG = int1,
    RIGHTARG = int4,
    PROCEDURE = int1int4shl
);

CREATE FUNCTION int1int4shr(int1, int4) RETURNS int1 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'int1int4shr';

CREATE OPERATOR >> (
    LEFTARG = int1,
    RIGHTARG = int4,
    PROCEDURE = int1int4shr
);

CREATE FUNCTION btint1sortsupport(internal) RETURNS void IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'btint1sortsupport';

CREATE OPERATOR CLASS int1_ops
    DEFAULT FOR TYPE int1 USING btree FAMILY integer_ops AS
        OPERATOR        1       < ,
        OPERATOR        2       <= ,
        OPERATOR        3       = ,
        OPERATOR        4       >= ,
        OPERATOR        5       > ,
        FUNCTION        1       btint1int1cmp(int1, int1),
        FUNCTION        2       btint1sortsupport(internal);

CREATE OPERATOR CLASS int1_ops
    DEFAULT FOR TYPE int1 USING hash FAMILY integer_ops AS
        OPERATOR        1       =,
        FUNCTION        1       hashint1(int1);

CREATE FUNCTION int1smaller(int1, int1) RETURNS int1 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'int1smaller';

CREATE AGGREGATE min(int1) (SFUNC = int1smaller, STYPE = int1, SORTOP = <);

CREATE FUNCTION int1larger(int1, int1) RETURNS int1 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'int1larger';

CREATE AGGREGATE max(int1) (SFUNC = int1larger, STYPE = int1, SORTOP = >);

CREATE AGGREGATE bit_and(int1) (SFUNC = int1int1and, STYPE = int1);

CREATE AGGREGATE bit_or(int1) (SFUNC = int1int1or, STYPE = int1);

CREATE FUNCTION int1_sum(int4, int1) RETURNS int4 IMMUTABLE LANGUAGE C AS '$libdir/uint', 'int1_sum';

CREATE AGGREGATE sum(int1) (SFUNC = int1_sum, STYPE = int4);

CREATE FUNCTION int1_avg_accum(_int8, int1) RETURNS _int8 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'int1_avg_accum';

CREATE AGGREGATE avg(int1) (SFUNC = int1_avg_accum, STYPE = _int8, FINALFUNC = int8_avg, INITCOND = '{0,0}');

CREATE FUNCTION uint1uint1and(uint1, uint1) RETURNS uint1 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint1uint1and';

CREATE OPERATOR & (
    LEFTARG = uint1,
    RIGHTARG = uint1,
    COMMUTATOR = &,
    PROCEDURE = uint1uint1and
);

CREATE FUNCTION uint1uint1or(uint1, uint1) RETURNS uint1 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint1uint1or';

CREATE OPERATOR | (
    LEFTARG = uint1,
    RIGHTARG = uint1,
    COMMUTATOR = |,
    PROCEDURE = uint1uint1or
);

CREATE FUNCTION uint1uint1xor(uint1, uint1) RETURNS uint1 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint1uint1xor';

CREATE OPERATOR # (
    LEFTARG = uint1,
    RIGHTARG = uint1,
    COMMUTATOR = #,
    PROCEDURE = uint1uint1xor
);

CREATE FUNCTION uint1not(uint1) RETURNS uint1 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint1not';

CREATE OPERATOR ~ (
    RIGHTARG = uint1,
    PROCEDURE = uint1not
);

CREATE FUNCTION uint1int4shl(uint1, int4) RETURNS uint1 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint1int4shl';

CREATE OPERATOR << (
    LEFTARG = uint1,
    RIGHTARG = int4,
    PROCEDURE = uint1int4shl
);

CREATE FUNCTION uint1int4shr(uint1, int4) RETURNS uint1 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint1int4shr';

CREATE OPERATOR >> (
    LEFTARG = uint1,
    RIGHTARG = int4,
    PROCEDURE = uint1int4shr
);

CREATE FUNCTION btuint1sortsupport(internal) RETURNS void IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'btuint1sortsupport';

CREATE OPERATOR CLASS uint1_ops
    DEFAULT FOR TYPE uint1 USING btree FAMILY integer_ops AS
        OPERATOR        1       < ,
        OPERATOR        2       <= ,
        OPERATOR        3       = ,
        OPERATOR        4       >= ,
        OPERATOR        5       > ,
        FUNCTION        1       btuint1uint1cmp(uint1, uint1),
        FUNCTION        2       btuint1sortsupport(internal);

CREATE OPERATOR CLASS uint1_ops
    DEFAULT FOR TYPE uint1 USING hash FAMILY integer_ops AS
        OPERATOR        1       =,
        FUNCTION        1       hashuint1(uint1);

CREATE FUNCTION uint1smaller(uint1, uint1) RETURNS uint1 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint1smaller';

CREATE AGGREGATE min(uint1) (SFUNC = uint1smaller, STYPE = uint1, SORTOP = <);

CREATE FUNCTION uint1larger(uint1, uint1) RETURNS uint1 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint1larger';

CREATE AGGREGATE max(uint1) (SFUNC = uint1larger, STYPE = uint1, SORTOP = >);

CREATE AGGREGATE bit_and(uint1) (SFUNC = uint1uint1and, STYPE = uint1);

CREATE AGGREGATE bit_or(uint1) (SFUNC = uint1uint1or, STYPE = uint1);

CREATE FUNCTION uint1_sum(uint4, uint1) RETURNS uint4 IMMUTABLE LANGUAGE C AS '$libdir/uint', 'uint1_sum';

CREATE AGGREGATE sum(uint1) (SFUNC = uint1_sum, STYPE = uint4);

CREATE FUNCTION uint1_avg_accum(_int8, uint1) RETURNS _int8 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint1_avg_accum';

CREATE AGGREGATE avg(uint1) (SFUNC = uint1_avg_accum, STYPE = _int8, FINALFUNC = int8_avg, INITCOND = '{0,0}');

CREATE FUNCTION uint2uint2and(uint2, uint2) RETURNS uint2 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint2uint2and';

CREATE OPERATOR & (
    LEFTARG = uint2,
    RIGHTARG = uint2,
    COMMUTATOR = &,
    PROCEDURE = uint2uint2and
);

CREATE FUNCTION uint2uint2or(uint2, uint2) RETURNS uint2 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint2uint2or';

CREATE OPERATOR | (
    LEFTARG = uint2,
    RIGHTARG = uint2,
    COMMUTATOR = |,
    PROCEDURE = uint2uint2or
);

CREATE FUNCTION uint2uint2xor(uint2, uint2) RETURNS uint2 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint2uint2xor';

CREATE OPERATOR # (
    LEFTARG = uint2,
    RIGHTARG = uint2,
    COMMUTATOR = #,
    PROCEDURE = uint2uint2xor
);

CREATE FUNCTION uint2not(uint2) RETURNS uint2 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint2not';

CREATE OPERATOR ~ (
    RIGHTARG = uint2,
    PROCEDURE = uint2not
);

CREATE FUNCTION uint2int4shl(uint2, int4) RETURNS uint2 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint2int4shl';

CREATE OPERATOR << (
    LEFTARG = uint2,
    RIGHTARG = int4,
    PROCEDURE = uint2int4shl
);

CREATE FUNCTION uint2int4shr(uint2, int4) RETURNS uint2 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint2int4shr';

CREATE OPERATOR >> (
    LEFTARG = uint2,
    RIGHTARG = int4,
    PROCEDURE = uint2int4shr
);

CREATE FUNCTION btuint2sortsupport(internal) RETURNS void IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'btuint2sortsupport';

CREATE OPERATOR CLASS uint2_ops
    DEFAULT FOR TYPE uint2 USING btree FAMILY integer_ops AS
        OPERATOR        1       < ,
        OPERATOR        2       <= ,
        OPERATOR        3       = ,
        OPERATOR        4       >= ,
        OPERATOR        5       > ,
        FUNCTION        1       btuint2uint2cmp(uint2, uint2),
        FUNCTION        2       btuint2sortsupport(internal);

CREATE OPERATOR CLASS uint2_ops
    DEFAULT FOR TYPE uint2 USING hash FAMILY integer_ops AS
        OPERATOR        1       =,
        FUNCTION        1       hashuint2(uint2);

CREATE FUNCTION uint2smaller(uint2, uint2) RETURNS uint2 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint2smaller';

CREATE AGGREGATE min(uint2) (SFUNC = uint2smaller, STYPE = uint2, SORTOP = <);

CREATE FUNCTION uint2larger(uint2, uint2) RETURNS uint2 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint2larger';

CREATE AGGREGATE max(uint2) (SFUNC = uint2larger, STYPE = uint2, SORTOP = >);

CREATE AGGREGATE bit_and(uint2) (SFUNC = uint2uint2and, STYPE = uint2);

CREATE AGGREGATE bit_or(uint2) (SFUNC = uint2uint2or, STYPE = uint2);

CREATE FUNCTION uint2_sum(uint8, uint2) RETURNS uint8 IMMUTABLE LANGUAGE C AS '$libdir/uint', 'uint2_sum';

CREATE AGGREGATE sum(uint2) (SFUNC = uint2_sum, STYPE = uint8);

CREATE FUNCTION uint2_avg_accum(_int8, uint2) RETURNS _int8 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint2_avg_accum';

CREATE AGGREGATE avg(uint2) (SFUNC = uint2_avg_accum, STYPE = _int8, FINALFUNC = int8_avg, INITCOND = '{0,0}');

CREATE FUNCTION uint4uint4and(uint4, uint4) RETURNS uint4 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint4uint4and';

CREATE OPERATOR & (
    LEFTARG = uint4,
    RIGHTARG = uint4,
    COMMUTATOR = &,
    PROCEDURE = uint4uint4and
);

CREATE FUNCTION uint4uint4or(uint4, uint4) RETURNS uint4 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint4uint4or';

CREATE OPERATOR | (
    LEFTARG = uint4,
    RIGHTARG = uint4,
    COMMUTATOR = |,
    PROCEDURE = uint4uint4or
);

CREATE FUNCTION uint4uint4xor(uint4, uint4) RETURNS uint4 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint4uint4xor';

CREATE OPERATOR # (
    LEFTARG = uint4,
    RIGHTARG = uint4,
    COMMUTATOR = #,
    PROCEDURE = uint4uint4xor
);

CREATE FUNCTION uint4not(uint4) RETURNS uint4 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint4not';

CREATE OPERATOR ~ (
    RIGHTARG = uint4,
    PROCEDURE = uint4not
);

CREATE FUNCTION uint4int4shl(uint4, int4) RETURNS uint4 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint4int4shl';

CREATE OPERATOR << (
    LEFTARG = uint4,
    RIGHTARG = int4,
    PROCEDURE = uint4int4shl
);

CREATE FUNCTION uint4int4shr(uint4, int4) RETURNS uint4 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint4int4shr';

CREATE OPERATOR >> (
    LEFTARG = uint4,
    RIGHTARG = int4,
    PROCEDURE = uint4int4shr
);

CREATE FUNCTION btuint4sortsupport(internal) RETURNS void IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'btuint4sortsupport';

CREATE OPERATOR CLASS uint4_ops
    DEFAULT FOR TYPE uint4 USING btree FAMILY integer_ops AS
        OPERATOR        1       < ,
        OPERATOR        2       <= ,
        OPERATOR        3       = ,
        OPERATOR        4       >= ,
        OPERATOR        5       > ,
        FUNCTION        1       btuint4uint4cmp(uint4, uint4),
        FUNCTION        2       btuint4sortsupport(internal);

CREATE OPERATOR CLASS uint4_ops
    DEFAULT FOR TYPE uint4 USING hash FAMILY integer_ops AS
        OPERATOR        1       =,
        FUNCTION        1       hashuint4(uint4);

CREATE FUNCTION uint4smaller(uint4, uint4) RETURNS uint4 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint4smaller';

CREATE AGGREGATE min(uint4) (SFUNC = uint4smaller, STYPE = uint4, SORTOP = <);

CREATE FUNCTION uint4larger(uint4, uint4) RETURNS uint4 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint4larger';

CREATE AGGREGATE max(uint4) (SFUNC = uint4larger, STYPE = uint4, SORTOP = >);

CREATE AGGREGATE bit_and(uint4) (SFUNC = uint4uint4and, STYPE = uint4);

CREATE AGGREGATE bit_or(uint4) (SFUNC = uint4uint4or, STYPE = uint4);

CREATE FUNCTION uint4_sum(uint8, uint4) RETURNS uint8 IMMUTABLE LANGUAGE C AS '$libdir/uint', 'uint4_sum';

CREATE AGGREGATE sum(uint4) (SFUNC = uint4_sum, STYPE = uint8);

CREATE FUNCTION uint4_avg_accum(_int8, uint4) RETURNS _int8 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint4_avg_accum';

CREATE AGGREGATE avg(uint4) (SFUNC = uint4_avg_accum, STYPE = _int8, FINALFUNC = int8_avg, INITCOND = '{0,0}');

CREATE FUNCTION uint8uint8and(uint8, uint8) RETURNS uint8 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint8uint8and';

CREATE OPERATOR & (
    LEFTARG = uint8,
    RIGHTARG = uint8,
    COMMUTATOR = &,
    PROCEDURE = uint8uint8and
);

CREATE FUNCTION uint8uint8or(uint8, uint8) RETURNS uint8 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint8uint8or';

CREATE OPERATOR | (
    LEFTARG = uint8,
    RIGHTARG = uint8,
    COMMUTATOR = |,
    PROCEDURE = uint8uint8or
);

CREATE FUNCTION uint8uint8xor(uint8, uint8) RETURNS uint8 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint8uint8xor';

CREATE OPERATOR # (
    LEFTARG = uint8,
    RIGHTARG = uint8,
    COMMUTATOR = #,
    PROCEDURE = uint8uint8xor
);

CREATE FUNCTION uint8not(uint8) RETURNS uint8 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint8not';

CREATE OPERATOR ~ (
    RIGHTARG = uint8,
    PROCEDURE = uint8not
);

CREATE FUNCTION uint8int4shl(uint8, int4) RETURNS uint8 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint8int4shl';

CREATE OPERATOR << (
    LEFTARG = uint8,
    RIGHTARG = int4,
    PROCEDURE = uint8int4shl
);

CREATE FUNCTION uint8int4shr(uint8, int4) RETURNS uint8 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint8int4shr';

CREATE OPERATOR >> (
    LEFTARG = uint8,
    RIGHTARG = int4,
    PROCEDURE = uint8int4shr
);

CREATE FUNCTION btuint8sortsupport(internal) RETURNS void IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'btuint8sortsupport';

CREATE OPERATOR CLASS uint8_ops
    DEFAULT FOR TYPE uint8 USING btree FAMILY integer_ops AS
        OPERATOR        1       < ,
        OPERATOR        2       <= ,
        OPERATOR        3       = ,
        OPERATOR        4       >= ,
        OPERATOR        5       > ,
        FUNCTION        1       btuint8uint8cmp(uint8, uint8),
        FUNCTION        2       btuint8sortsupport(internal);

CREATE OPERATOR CLASS uint8_ops
    DEFAULT FOR TYPE uint8 USING hash FAMILY integer_ops AS
        OPERATOR        1       =,
        FUNCTION        1       hashuint8(uint8);

CREATE FUNCTION uint8smaller(uint8, uint8) RETURNS uint8 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint8smaller';

CREATE AGGREGATE min(uint8) (SFUNC = uint8smaller, STYPE = uint8, SORTOP = <);

CREATE FUNCTION uint8larger(uint8, uint8) RETURNS uint8 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint8larger';

CREATE AGGREGATE max(uint8) (SFUNC = uint8larger, STYPE = uint8, SORTOP = >);

CREATE AGGREGATE bit_and(uint8) (SFUNC = uint8uint8and, STYPE = uint8);

CREATE AGGREGATE bit_or(uint8) (SFUNC = uint8uint8or, STYPE = uint8);

CREATE FUNCTION uint8_sum(uint8, uint8) RETURNS uint8 IMMUTABLE LANGUAGE C AS '$libdir/uint', 'uint8_sum';

CREATE AGGREGATE sum(uint8) (SFUNC = uint8_sum, STYPE = uint8);

CREATE FUNCTION uint8_avg_accum(_int8, uint8) RETURNS _int8 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'uint8_avg_accum';

CREATE AGGREGATE avg(uint8) (SFUNC = uint8_avg_accum, STYPE = _int8, FINALFUNC = int8_avg, INITCOND = '{0,0}');

ALTER OPERATOR FAMILY integer_ops USING btree ADD
OPERATOR 1 <  (int1, uint1),
OPERATOR 2 <= (int1, uint1),
OPERATOR 3 =  (int1, uint1),
OPERATOR 4 >= (int1, uint1),
OPERATOR 5 >  (int1, uint1),
FUNCTION 1 btint1uint1cmp(int1, uint1),
OPERATOR 1 <  (int1, uint2),
OPERATOR 2 <= (int1, uint2),
OPERATOR 3 =  (int1, uint2),
OPERATOR 4 >= (int1, uint2),
OPERATOR 5 >  (int1, uint2),
FUNCTION 1 btint1uint2cmp(int1, uint2),
OPERATOR 1 <  (int1, uint4),
OPERATOR 2 <= (int1, uint4),
OPERATOR 3 =  (int1, uint4),
OPERATOR 4 >= (int1, uint4),
OPERATOR 5 >  (int1, uint4),
FUNCTION 1 btint1uint4cmp(int1, uint4),
OPERATOR 1 <  (int1, uint8),
OPERATOR 2 <= (int1, uint8),
OPERATOR 3 =  (int1, uint8),
OPERATOR 4 >= (int1, uint8),
OPERATOR 5 >  (int1, uint8),
FUNCTION 1 btint1uint8cmp(int1, uint8),
OPERATOR 1 <  (int1, int2),
OPERATOR 2 <= (int1, int2),
OPERATOR 3 =  (int1, int2),
OPERATOR 4 >= (int1, int2),
OPERATOR 5 >  (int1, int2),
FUNCTION 1 btint1int2cmp(int1, int2),
OPERATOR 1 <  (int1, int4),
OPERATOR 2 <= (int1, int4),
OPERATOR 3 =  (int1, int4),
OPERATOR 4 >= (int1, int4),
OPERATOR 5 >  (int1, int4),
FUNCTION 1 btint1int4cmp(int1, int4),
OPERATOR 1 <  (int1, int8),
OPERATOR 2 <= (int1, int8),
OPERATOR 3 =  (int1, int8),
OPERATOR 4 >= (int1, int8),
OPERATOR 5 >  (int1, int8),
FUNCTION 1 btint1int8cmp(int1, int8),
OPERATOR 1 <  (uint1, int1),
OPERATOR 2 <= (uint1, int1),
OPERATOR 3 =  (uint1, int1),
OPERATOR 4 >= (uint1, int1),
OPERATOR 5 >  (uint1, int1),
FUNCTION 1 btuint1int1cmp(uint1, int1),
OPERATOR 1 <  (uint1, uint2),
OPERATOR 2 <= (uint1, uint2),
OPERATOR 3 =  (uint1, uint2),
OPERATOR 4 >= (uint1, uint2),
OPERATOR 5 >  (uint1, uint2),
FUNCTION 1 btuint1uint2cmp(uint1, uint2),
OPERATOR 1 <  (uint1, uint4),
OPERATOR 2 <= (uint1, uint4),
OPERATOR 3 =  (uint1, uint4),
OPERATOR 4 >= (uint1, uint4),
OPERATOR 5 >  (uint1, uint4),
FUNCTION 1 btuint1uint4cmp(uint1, uint4),
OPERATOR 1 <  (uint1, uint8),
OPERATOR 2 <= (uint1, uint8),
OPERATOR 3 =  (uint1, uint8),
OPERATOR 4 >= (uint1, uint8),
OPERATOR 5 >  (uint1, uint8),
FUNCTION 1 btuint1uint8cmp(uint1, uint8),
OPERATOR 1 <  (uint1, int2),
OPERATOR 2 <= (uint1, int2),
OPERATOR 3 =  (uint1, int2),
OPERATOR 4 >= (uint1, int2),
OPERATOR 5 >  (uint1, int2),
FUNCTION 1 btuint1int2cmp(uint1, int2),
OPERATOR 1 <  (uint1, int4),
OPERATOR 2 <= (uint1, int4),
OPERATOR 3 =  (uint1, int4),
OPERATOR 4 >= (uint1, int4),
OPERATOR 5 >  (uint1, int4),
FUNCTION 1 btuint1int4cmp(uint1, int4),
OPERATOR 1 <  (uint1, int8),
OPERATOR 2 <= (uint1, int8),
OPERATOR 3 =  (uint1, int8),
OPERATOR 4 >= (uint1, int8),
OPERATOR 5 >  (uint1, int8),
FUNCTION 1 btuint1int8cmp(uint1, int8),
OPERATOR 1 <  (uint2, int1),
OPERATOR 2 <= (uint2, int1),
OPERATOR 3 =  (uint2, int1),
OPERATOR 4 >= (uint2, int1),
OPERATOR 5 >  (uint2, int1),
FUNCTION 1 btuint2int1cmp(uint2, int1),
OPERATOR 1 <  (uint2, uint1),
OPERATOR 2 <= (uint2, uint1),
OPERATOR 3 =  (uint2, uint1),
OPERATOR 4 >= (uint2, uint1),
OPERATOR 5 >  (uint2, uint1),
FUNCTION 1 btuint2uint1cmp(uint2, uint1),
OPERATOR 1 <  (uint2, uint4),
OPERATOR 2 <= (uint2, uint4),
OPERATOR 3 =  (uint2, uint4),
OPERATOR 4 >= (uint2, uint4),
OPERATOR 5 >  (uint2, uint4),
FUNCTION 1 btuint2uint4cmp(uint2, uint4),
OPERATOR 1 <  (uint2, uint8),
OPERATOR 2 <= (uint2, uint8),
OPERATOR 3 =  (uint2, uint8),
OPERATOR 4 >= (uint2, uint8),
OPERATOR 5 >  (uint2, uint8),
FUNCTION 1 btuint2uint8cmp(uint2, uint8),
OPERATOR 1 <  (uint2, int2),
OPERATOR 2 <= (uint2, int2),
OPERATOR 3 =  (uint2, int2),
OPERATOR 4 >= (uint2, int2),
OPERATOR 5 >  (uint2, int2),
FUNCTION 1 btuint2int2cmp(uint2, int2),
OPERATOR 1 <  (uint2, int4),
OPERATOR 2 <= (uint2, int4),
OPERATOR 3 =  (uint2, int4),
OPERATOR 4 >= (uint2, int4),
OPERATOR 5 >  (uint2, int4),
FUNCTION 1 btuint2int4cmp(uint2, int4),
OPERATOR 1 <  (uint2, int8),
OPERATOR 2 <= (uint2, int8),
OPERATOR 3 =  (uint2, int8),
OPERATOR 4 >= (uint2, int8),
OPERATOR 5 >  (uint2, int8),
FUNCTION 1 btuint2int8cmp(uint2, int8),
OPERATOR 1 <  (uint4, int1),
OPERATOR 2 <= (uint4, int1),
OPERATOR 3 =  (uint4, int1),
OPERATOR 4 >= (uint4, int1),
OPERATOR 5 >  (uint4, int1),
FUNCTION 1 btuint4int1cmp(uint4, int1),
OPERATOR 1 <  (uint4, uint1),
OPERATOR 2 <= (uint4, uint1),
OPERATOR 3 =  (uint4, uint1),
OPERATOR 4 >= (uint4, uint1),
OPERATOR 5 >  (uint4, uint1),
FUNCTION 1 btuint4uint1cmp(uint4, uint1),
OPERATOR 1 <  (uint4, uint2),
OPERATOR 2 <= (uint4, uint2),
OPERATOR 3 =  (uint4, uint2),
OPERATOR 4 >= (uint4, uint2),
OPERATOR 5 >  (uint4, uint2),
FUNCTION 1 btuint4uint2cmp(uint4, uint2),
OPERATOR 1 <  (uint4, uint8),
OPERATOR 2 <= (uint4, uint8),
OPERATOR 3 =  (uint4, uint8),
OPERATOR 4 >= (uint4, uint8),
OPERATOR 5 >  (uint4, uint8),
FUNCTION 1 btuint4uint8cmp(uint4, uint8),
OPERATOR 1 <  (uint4, int2),
OPERATOR 2 <= (uint4, int2),
OPERATOR 3 =  (uint4, int2),
OPERATOR 4 >= (uint4, int2),
OPERATOR 5 >  (uint4, int2),
FUNCTION 1 btuint4int2cmp(uint4, int2),
OPERATOR 1 <  (uint4, int4),
OPERATOR 2 <= (uint4, int4),
OPERATOR 3 =  (uint4, int4),
OPERATOR 4 >= (uint4, int4),
OPERATOR 5 >  (uint4, int4),
FUNCTION 1 btuint4int4cmp(uint4, int4),
OPERATOR 1 <  (uint4, int8),
OPERATOR 2 <= (uint4, int8),
OPERATOR 3 =  (uint4, int8),
OPERATOR 4 >= (uint4, int8),
OPERATOR 5 >  (uint4, int8),
FUNCTION 1 btuint4int8cmp(uint4, int8),
OPERATOR 1 <  (uint8, int1),
OPERATOR 2 <= (uint8, int1),
OPERATOR 3 =  (uint8, int1),
OPERATOR 4 >= (uint8, int1),
OPERATOR 5 >  (uint8, int1),
FUNCTION 1 btuint8int1cmp(uint8, int1),
OPERATOR 1 <  (uint8, uint1),
OPERATOR 2 <= (uint8, uint1),
OPERATOR 3 =  (uint8, uint1),
OPERATOR 4 >= (uint8, uint1),
OPERATOR 5 >  (uint8, uint1),
FUNCTION 1 btuint8uint1cmp(uint8, uint1),
OPERATOR 1 <  (uint8, uint2),
OPERATOR 2 <= (uint8, uint2),
OPERATOR 3 =  (uint8, uint2),
OPERATOR 4 >= (uint8, uint2),
OPERATOR 5 >  (uint8, uint2),
FUNCTION 1 btuint8uint2cmp(uint8, uint2),
OPERATOR 1 <  (uint8, uint4),
OPERATOR 2 <= (uint8, uint4),
OPERATOR 3 =  (uint8, uint4),
OPERATOR 4 >= (uint8, uint4),
OPERATOR 5 >  (uint8, uint4),
FUNCTION 1 btuint8uint4cmp(uint8, uint4),
OPERATOR 1 <  (uint8, int2),
OPERATOR 2 <= (uint8, int2),
OPERATOR 3 =  (uint8, int2),
OPERATOR 4 >= (uint8, int2),
OPERATOR 5 >  (uint8, int2),
FUNCTION 1 btuint8int2cmp(uint8, int2),
OPERATOR 1 <  (uint8, int4),
OPERATOR 2 <= (uint8, int4),
OPERATOR 3 =  (uint8, int4),
OPERATOR 4 >= (uint8, int4),
OPERATOR 5 >  (uint8, int4),
FUNCTION 1 btuint8int4cmp(uint8, int4),
OPERATOR 1 <  (uint8, int8),
OPERATOR 2 <= (uint8, int8),
OPERATOR 3 =  (uint8, int8),
OPERATOR 4 >= (uint8, int8),
OPERATOR 5 >  (uint8, int8),
FUNCTION 1 btuint8int8cmp(uint8, int8),
OPERATOR 1 <  (int2, int1),
OPERATOR 2 <= (int2, int1),
OPERATOR 3 =  (int2, int1),
OPERATOR 4 >= (int2, int1),
OPERATOR 5 >  (int2, int1),
FUNCTION 1 btint2int1cmp(int2, int1),
OPERATOR 1 <  (int2, uint1),
OPERATOR 2 <= (int2, uint1),
OPERATOR 3 =  (int2, uint1),
OPERATOR 4 >= (int2, uint1),
OPERATOR 5 >  (int2, uint1),
FUNCTION 1 btint2uint1cmp(int2, uint1),
OPERATOR 1 <  (int2, uint2),
OPERATOR 2 <= (int2, uint2),
OPERATOR 3 =  (int2, uint2),
OPERATOR 4 >= (int2, uint2),
OPERATOR 5 >  (int2, uint2),
FUNCTION 1 btint2uint2cmp(int2, uint2),
OPERATOR 1 <  (int2, uint4),
OPERATOR 2 <= (int2, uint4),
OPERATOR 3 =  (int2, uint4),
OPERATOR 4 >= (int2, uint4),
OPERATOR 5 >  (int2, uint4),
FUNCTION 1 btint2uint4cmp(int2, uint4),
OPERATOR 1 <  (int2, uint8),
OPERATOR 2 <= (int2, uint8),
OPERATOR 3 =  (int2, uint8),
OPERATOR 4 >= (int2, uint8),
OPERATOR 5 >  (int2, uint8),
FUNCTION 1 btint2uint8cmp(int2, uint8),
OPERATOR 1 <  (int4, int1),
OPERATOR 2 <= (int4, int1),
OPERATOR 3 =  (int4, int1),
OPERATOR 4 >= (int4, int1),
OPERATOR 5 >  (int4, int1),
FUNCTION 1 btint4int1cmp(int4, int1),
OPERATOR 1 <  (int4, uint1),
OPERATOR 2 <= (int4, uint1),
OPERATOR 3 =  (int4, uint1),
OPERATOR 4 >= (int4, uint1),
OPERATOR 5 >  (int4, uint1),
FUNCTION 1 btint4uint1cmp(int4, uint1),
OPERATOR 1 <  (int4, uint2),
OPERATOR 2 <= (int4, uint2),
OPERATOR 3 =  (int4, uint2),
OPERATOR 4 >= (int4, uint2),
OPERATOR 5 >  (int4, uint2),
FUNCTION 1 btint4uint2cmp(int4, uint2),
OPERATOR 1 <  (int4, uint4),
OPERATOR 2 <= (int4, uint4),
OPERATOR 3 =  (int4, uint4),
OPERATOR 4 >= (int4, uint4),
OPERATOR 5 >  (int4, uint4),
FUNCTION 1 btint4uint4cmp(int4, uint4),
OPERATOR 1 <  (int4, uint8),
OPERATOR 2 <= (int4, uint8),
OPERATOR 3 =  (int4, uint8),
OPERATOR 4 >= (int4, uint8),
OPERATOR 5 >  (int4, uint8),
FUNCTION 1 btint4uint8cmp(int4, uint8),
OPERATOR 1 <  (int8, int1),
OPERATOR 2 <= (int8, int1),
OPERATOR 3 =  (int8, int1),
OPERATOR 4 >= (int8, int1),
OPERATOR 5 >  (int8, int1),
FUNCTION 1 btint8int1cmp(int8, int1),
OPERATOR 1 <  (int8, uint1),
OPERATOR 2 <= (int8, uint1),
OPERATOR 3 =  (int8, uint1),
OPERATOR 4 >= (int8, uint1),
OPERATOR 5 >  (int8, uint1),
FUNCTION 1 btint8uint1cmp(int8, uint1),
OPERATOR 1 <  (int8, uint2),
OPERATOR 2 <= (int8, uint2),
OPERATOR 3 =  (int8, uint2),
OPERATOR 4 >= (int8, uint2),
OPERATOR 5 >  (int8, uint2),
FUNCTION 1 btint8uint2cmp(int8, uint2),
OPERATOR 1 <  (int8, uint4),
OPERATOR 2 <= (int8, uint4),
OPERATOR 3 =  (int8, uint4),
OPERATOR 4 >= (int8, uint4),
OPERATOR 5 >  (int8, uint4),
FUNCTION 1 btint8uint4cmp(int8, uint4),
OPERATOR 1 <  (int8, uint8),
OPERATOR 2 <= (int8, uint8),
OPERATOR 3 =  (int8, uint8),
OPERATOR 4 >= (int8, uint8),
OPERATOR 5 >  (int8, uint8),
FUNCTION 1 btint8uint8cmp(int8, uint8);

ALTER OPERATOR FAMILY integer_ops USING hash ADD
OPERATOR 1 = (int1, uint1),
OPERATOR 1 = (int1, uint2),
OPERATOR 1 = (int1, uint4),
OPERATOR 1 = (int1, uint8),
OPERATOR 1 = (int1, int2),
OPERATOR 1 = (int1, int4),
OPERATOR 1 = (int1, int8),
OPERATOR 1 = (uint1, int1),
OPERATOR 1 = (uint1, uint2),
OPERATOR 1 = (uint1, uint4),
OPERATOR 1 = (uint1, uint8),
OPERATOR 1 = (uint1, int2),
OPERATOR 1 = (uint1, int4),
OPERATOR 1 = (uint1, int8),
OPERATOR 1 = (uint2, int1),
OPERATOR 1 = (uint2, uint1),
OPERATOR 1 = (uint2, uint4),
OPERATOR 1 = (uint2, uint8),
OPERATOR 1 = (uint2, int2),
OPERATOR 1 = (uint2, int4),
OPERATOR 1 = (uint2, int8),
OPERATOR 1 = (uint4, int1),
OPERATOR 1 = (uint4, uint1),
OPERATOR 1 = (uint4, uint2),
OPERATOR 1 = (uint4, uint8),
OPERATOR 1 = (uint4, int2),
OPERATOR 1 = (uint4, int4),
OPERATOR 1 = (uint4, int8),
OPERATOR 1 = (uint8, int1),
OPERATOR 1 = (uint8, uint1),
OPERATOR 1 = (uint8, uint2),
OPERATOR 1 = (uint8, uint4),
OPERATOR 1 = (uint8, int2),
OPERATOR 1 = (uint8, int4),
OPERATOR 1 = (uint8, int8),
OPERATOR 1 = (int2, int1),
OPERATOR 1 = (int2, uint1),
OPERATOR 1 = (int2, uint2),
OPERATOR 1 = (int2, uint4),
OPERATOR 1 = (int2, uint8),
OPERATOR 1 = (int4, int1),
OPERATOR 1 = (int4, uint1),
OPERATOR 1 = (int4, uint2),
OPERATOR 1 = (int4, uint4),
OPERATOR 1 = (int4, uint8),
OPERATOR 1 = (int8, int1),
OPERATOR 1 = (int8, uint1),
OPERATOR 1 = (int8, uint2),
OPERATOR 1 = (int8, uint4),
OPERATOR 1 = (int8, uint8);

CREATE FUNCTION mod(int2, int4) RETURNS int4 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'int2int4mod';

CREATE OPERATOR % (
    LEFTARG = int2,
    RIGHTARG = int4,
    PROCEDURE = mod
);

CREATE FUNCTION mod(int4, int2) RETURNS int4 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'int4int2mod';

CREATE OPERATOR % (
    LEFTARG = int4,
    RIGHTARG = int2,
    PROCEDURE = mod
);

CREATE FUNCTION mod(int8, int2) RETURNS int8 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'int8int2mod';

CREATE OPERATOR % (
    LEFTARG = int8,
    RIGHTARG = int2,
    PROCEDURE = mod
);

CREATE FUNCTION mod(int8, int4) RETURNS int8 IMMUTABLE STRICT LANGUAGE C AS '$libdir/uint', 'int8int4mod';

CREATE OPERATOR % (
    LEFTARG = int8,
    RIGHTARG = int4,
    PROCEDURE = mod
);

