--
-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- --
--
--  NagiosQL
--
-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- --
--
--  (c) 2008, 2009 by Martin Willisegger
--
--  Project   : NagiosQL
--  Component : Import samples build from Nagios 3.0.5 configuration samples
--  Website   : www.nagiosql.org
--  Date      : LastChangedDate: 2008-11-24 12:28:32 +0100 (Mo, 24 Nov 2008) 
--  Author    : LastChangedBy: rouven 
--  Version   : 3.0.3
--  Revision  : LastChangedRevision: 514 
--  SVN-ID    : Id: update_200_202.sql 514 2008-11-24 11:28:32Z rouven 
--
-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- --
--

--
-- Import table `tbl_command`
--
INSERT INTO `tbl_command` (`id`, `command_name`, `command_line`, `command_type`, `active`, `last_modified`, `access_rights`, `config_id`) VALUES(1, 'notify-host-by-email', '/usr/bin/printf "%b" "***** Nagios *****\\n\\nNotification Type: $NOTIFICATIONTYPE$\\nHost: $HOSTNAME$\\nState: $HOSTSTATE$\\nAddress: $HOSTADDRESS$\\nInfo: $HOSTOUTPUT$\\n\\nDate/Time: $LONGDATETIME$\\n" | /usr/bin/mail -s "** $NOTIFICATIONTYPE$ Host Alert: $HOSTNAME$ is $HOSTSTATE$ **" $CONTACTEMAIL$', 2, '1', '2008-12-09 14:56:23', NULL, 1);
INSERT INTO `tbl_command` (`id`, `command_name`, `command_line`, `command_type`, `active`, `last_modified`, `access_rights`, `config_id`) VALUES(2, 'notify-service-by-email', '/usr/bin/printf "%b" "***** Nagios *****\\n\\nNotification Type: $NOTIFICATIONTYPE$\\n\\nService: $SERVICEDESC$\\nHost: $HOSTALIAS$\\nAddress: $HOSTADDRESS$\\nState: $SERVICESTATE$\\n\\nDate/Time: $LONGDATETIME$\\n\\nAdditional Info:\\n\\n$SERVICEOUTPUT$" | /usr/bin/mail -s "** $NOTIFICATIONTYPE$ Service Alert: $HOSTALIAS$/$SERVICEDESC$ is $SERVICESTATE$ **" $CONTACTEMAIL$', 2, '1', '2008-12-09 14:56:23', NULL, 1);
INSERT INTO `tbl_command` (`id`, `command_name`, `command_line`, `command_type`, `active`, `last_modified`, `access_rights`, `config_id`) VALUES(3, 'check-host-alive', '$USER1$/check_ping -H $HOSTADDRESS$ -w 3000.0,80% -c 5000.0,100% -p 5', 1, '1', '2008-12-09 14:56:23', NULL, 1);
INSERT INTO `tbl_command` (`id`, `command_name`, `command_line`, `command_type`, `active`, `last_modified`, `access_rights`, `config_id`) VALUES(4, 'check_local_disk', '$USER1$/check_disk -w $ARG1$ -c $ARG2$ -p $ARG3$', 1, '1', '2008-12-09 14:56:23', NULL, 1);
INSERT INTO `tbl_command` (`id`, `command_name`, `command_line`, `command_type`, `active`, `last_modified`, `access_rights`, `config_id`) VALUES(5, 'check_local_load', '$USER1$/check_load -w $ARG1$ -c $ARG2$', 1, '1', '2008-12-09 14:56:23', NULL, 1);
INSERT INTO `tbl_command` (`id`, `command_name`, `command_line`, `command_type`, `active`, `last_modified`, `access_rights`, `config_id`) VALUES(6, 'check_local_procs', '$USER1$/check_procs -w $ARG1$ -c $ARG2$ -s $ARG3$', 1, '1', '2008-12-09 14:56:23', NULL, 1);
INSERT INTO `tbl_command` (`id`, `command_name`, `command_line`, `command_type`, `active`, `last_modified`, `access_rights`, `config_id`) VALUES(7, 'check_local_users', '$USER1$/check_users -w $ARG1$ -c $ARG2$', 1, '1', '2008-12-09 14:56:23', NULL, 1);
INSERT INTO `tbl_command` (`id`, `command_name`, `command_line`, `command_type`, `active`, `last_modified`, `access_rights`, `config_id`) VALUES(8, 'check_local_swap', '$USER1$/check_swap -w $ARG1$ -c $ARG2$', 1, '1', '2008-12-09 14:56:23', NULL, 1);
INSERT INTO `tbl_command` (`id`, `command_name`, `command_line`, `command_type`, `active`, `last_modified`, `access_rights`, `config_id`) VALUES(9, 'check_local_mrtgtraf', '$USER1$/check_mrtgtraf -F $ARG1$ -a $ARG2$ -w $ARG3$ -c $ARG4$ -e $ARG5$', 1, '1', '2008-12-09 14:56:23', NULL, 1);
INSERT INTO `tbl_command` (`id`, `command_name`, `command_line`, `command_type`, `active`, `last_modified`, `access_rights`, `config_id`) VALUES(10, 'check_ftp', '$USER1$/check_ftp -H $HOSTADDRESS$ $ARG1$', 1, '1', '2008-12-09 14:56:23', NULL, 1);
INSERT INTO `tbl_command` (`id`, `command_name`, `command_line`, `command_type`, `active`, `last_modified`, `access_rights`, `config_id`) VALUES(11, 'check_hpjd', '$USER1$/check_hpjd -H $HOSTADDRESS$ $ARG1$', 1, '1', '2008-12-09 14:56:23', NULL, 1);
INSERT INTO `tbl_command` (`id`, `command_name`, `command_line`, `command_type`, `active`, `last_modified`, `access_rights`, `config_id`) VALUES(12, 'check_snmp', '$USER1$/check_snmp -H $HOSTADDRESS$ $ARG1$', 1, '1', '2008-12-09 14:56:23', NULL, 1);
INSERT INTO `tbl_command` (`id`, `command_name`, `command_line`, `command_type`, `active`, `last_modified`, `access_rights`, `config_id`) VALUES(13, 'check_http', '$USER1$/check_http -I $HOSTADDRESS$ $ARG1$', 1, '1', '2008-12-09 14:56:23', NULL, 1);
INSERT INTO `tbl_command` (`id`, `command_name`, `command_line`, `command_type`, `active`, `last_modified`, `access_rights`, `config_id`) VALUES(14, 'check_ssh', '$USER1$/check_ssh $ARG1$ $HOSTADDRESS$', 1, '1', '2008-12-09 14:56:23', NULL, 1);
INSERT INTO `tbl_command` (`id`, `command_name`, `command_line`, `command_type`, `active`, `last_modified`, `access_rights`, `config_id`) VALUES(15, 'check_dhcp', '$USER1$/check_dhcp $ARG1$', 1, '1', '2008-12-09 14:56:23', NULL, 1);
INSERT INTO `tbl_command` (`id`, `command_name`, `command_line`, `command_type`, `active`, `last_modified`, `access_rights`, `config_id`) VALUES(16, 'check_ping', '$USER1$/check_ping -H $HOSTADDRESS$ -w $ARG1$ -c $ARG2$ -p 5', 1, '1', '2008-12-09 14:56:23', NULL, 1);
INSERT INTO `tbl_command` (`id`, `command_name`, `command_line`, `command_type`, `active`, `last_modified`, `access_rights`, `config_id`) VALUES(17, 'check_pop', '$USER1$/check_pop -H $HOSTADDRESS$ $ARG1$', 1, '1', '2008-12-09 14:56:23', NULL, 1);
INSERT INTO `tbl_command` (`id`, `command_name`, `command_line`, `command_type`, `active`, `last_modified`, `access_rights`, `config_id`) VALUES(18, 'check_imap', '$USER1$/check_imap -H $HOSTADDRESS$ $ARG1$', 1, '1', '2008-12-09 14:56:23', NULL, 1);
INSERT INTO `tbl_command` (`id`, `command_name`, `command_line`, `command_type`, `active`, `last_modified`, `access_rights`, `config_id`) VALUES(19, 'check_smtp', '$USER1$/check_smtp -H $HOSTADDRESS$ $ARG1$', 1, '1', '2008-12-09 14:56:23', NULL, 1);
INSERT INTO `tbl_command` (`id`, `command_name`, `command_line`, `command_type`, `active`, `last_modified`, `access_rights`, `config_id`) VALUES(20, 'check_tcp', '$USER1$/check_tcp -H $HOSTADDRESS$ -p $ARG1$ $ARG2$', 1, '1', '2008-12-09 14:56:23', NULL, 1);
INSERT INTO `tbl_command` (`id`, `command_name`, `command_line`, `command_type`, `active`, `last_modified`, `access_rights`, `config_id`) VALUES(21, 'check_udp', '$USER1$/check_udp -H $HOSTADDRESS$ -p $ARG1$ $ARG2$', 1, '1', '2008-12-09 14:56:23', NULL, 1);
INSERT INTO `tbl_command` (`id`, `command_name`, `command_line`, `command_type`, `active`, `last_modified`, `access_rights`, `config_id`) VALUES(22, 'check_nt', '$USER1$/check_nt -H $HOSTADDRESS$ -p 12489 -v $ARG1$ $ARG2$', 1, '1', '2008-12-09 14:56:23', NULL, 1);
INSERT INTO `tbl_command` (`id`, `command_name`, `command_line`, `command_type`, `active`, `last_modified`, `access_rights`, `config_id`) VALUES(23, 'process-host-perfdata', '/usr/bin/printf "%b" "$LASTHOSTCHECK$\\t$HOSTNAME$\\t$HOSTSTATE$\\t$HOSTATTEMPT$\\t$HOSTSTATETYPE$\\t$HOSTEXECUTIONTIME$\\t$HOSTOUTPUT$\\t$HOSTPERFDATA$\\n" >> /usr/local/nagios/var//host-perfdata.out', 2, '1', '2008-12-09 14:56:23', NULL, 1);
INSERT INTO `tbl_command` (`id`, `command_name`, `command_line`, `command_type`, `active`, `last_modified`, `access_rights`, `config_id`) VALUES(24, 'process-service-perfdata', '/usr/bin/printf "%b" "$LASTSERVICECHECK$\\t$HOSTNAME$\\t$SERVICEDESC$\\t$SERVICESTATE$\\t$SERVICEATTEMPT$\\t$SERVICESTATETYPE$\\t$SERVICEEXECUTIONTIME$\\t$SERVICELATENCY$\\t$SERVICEOUTPUT$\\t$SERVICEPERFDATA$\\n" >> /usr/local/nagios/var//service-perfdata.out', 2, '1', '2008-12-09 14:56:23', NULL, 1);
--
-- Import table `tbl_contact`
--
INSERT INTO `tbl_contact` (`id`, `contact_name`, `alias`, `contactgroups`, `contactgroups_tploptions`, `host_notifications_enabled`, `service_notifications_enabled`, `host_notification_period`, `service_notification_period`, `host_notification_options`, `service_notification_options`, `host_notification_commands`, `host_notification_commands_tploptions`, `service_notification_commands`, `service_notification_commands_tploptions`, `can_submit_commands`, `retain_status_information`, `retain_nonstatus_information`, `email`, `pager`, `address1`, `address2`, `address3`, `address4`, `address5`, `address6`, `name`, `use_variables`, `use_template`, `use_template_tploptions`, `active`, `last_modified`, `access_rights`, `config_id`) VALUES(1, 'nagiosadmin', 'Nagios Admin', 0, 2, 2, 2, 0, 0, '', '', 0, 2, 0, 2, 2, 2, 2, 'nagiosadmin@localhost', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', 0, 1, 2, '1', '2008-11-28 13:58:46', NULL, 1);
--
-- Import table `tbl_contactgroup`
--
INSERT INTO `tbl_contactgroup` (`id`, `contactgroup_name`, `alias`, `members`, `contactgroup_members`, `active`, `last_modified`, `access_rights`, `config_id`) VALUES(1, 'admins', 'Nagios Administrators', 1, 0, '1', '2008-11-28 13:58:46', NULL, 1);
--
-- Import table `tbl_contacttemplate`
--
INSERT INTO `tbl_contacttemplate` (`id`, `template_name`, `alias`, `contactgroups`, `contactgroups_tploptions`, `host_notifications_enabled`, `service_notifications_enabled`, `host_notification_period`, `service_notification_period`, `host_notification_options`, `service_notification_options`, `host_notification_commands`, `host_notification_commands_tploptions`, `service_notification_commands`, `service_notification_commands_tploptions`, `can_submit_commands`, `retain_status_information`, `retain_nonstatus_information`, `email`, `pager`, `address1`, `address2`, `address3`, `address4`, `address5`, `address6`, `use_variables`, `use_template`, `use_template_tploptions`, `active`, `last_modified`, `access_rights`, `config_id`) VALUES(1, 'generic-contact', '', 0, 2, 2, 2, 1, 1, 'd,u,r,f,s', 'w,u,c,r,f,s', 1, 2, 1, 2, 2, 2, 2, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 2, '1', '2008-11-28 14:10:01', NULL, 1);
--
-- Import table `tbl_host`
--
INSERT INTO `tbl_host` (`id`, `host_name`, `alias`, `display_name`, `address`, `parents`, `parents_tploptions`, `hostgroups`, `hostgroups_tploptions`, `check_command`, `use_template`, `use_template_tploptions`, `initial_state`, `max_check_attempts`, `check_interval`, `retry_interval`, `active_checks_enabled`, `passive_checks_enabled`, `check_period`, `obsess_over_host`, `check_freshness`, `freshness_threshold`, `event_handler`, `event_handler_enabled`, `low_flap_threshold`, `high_flap_threshold`, `flap_detection_enabled`, `flap_detection_options`, `process_perf_data`, `retain_status_information`, `retain_nonstatus_information`, `contacts`, `contacts_tploptions`, `contact_groups`, `contact_groups_tploptions`, `notification_interval`, `notification_period`, `first_notification_delay`, `notification_options`, `notifications_enabled`, `stalking_options`, `notes`, `notes_url`, `action_url`, `icon_image`, `icon_image_alt`, `vrml_image`, `statusmap_image`, `2d_coords`, `3d_coords`, `use_variables`, `name`, `active`, `last_modified`, `access_rights`, `config_id`) VALUES(1, 'localhost', 'localhost', '', '127.0.0.1', 0, 2, 0, 2, NULL, 1, 2, '', NULL, NULL, NULL, 2, 2, 0, 2, 2, NULL, 0, 2, NULL, NULL, 2, '', 2, 2, 2, 0, 2, 0, 2, NULL, 0, NULL, '', 2, '', '', '', '', '', '', '', '', '', '', 1, '', '1', '2008-11-28 14:10:01', NULL, 1);
INSERT INTO `tbl_host` (`id`, `host_name`, `alias`, `display_name`, `address`, `parents`, `parents_tploptions`, `hostgroups`, `hostgroups_tploptions`, `check_command`, `use_template`, `use_template_tploptions`, `initial_state`, `max_check_attempts`, `check_interval`, `retry_interval`, `active_checks_enabled`, `passive_checks_enabled`, `check_period`, `obsess_over_host`, `check_freshness`, `freshness_threshold`, `event_handler`, `event_handler_enabled`, `low_flap_threshold`, `high_flap_threshold`, `flap_detection_enabled`, `flap_detection_options`, `process_perf_data`, `retain_status_information`, `retain_nonstatus_information`, `contacts`, `contacts_tploptions`, `contact_groups`, `contact_groups_tploptions`, `notification_interval`, `notification_period`, `first_notification_delay`, `notification_options`, `notifications_enabled`, `stalking_options`, `notes`, `notes_url`, `action_url`, `icon_image`, `icon_image_alt`, `vrml_image`, `statusmap_image`, `2d_coords`, `3d_coords`, `use_variables`, `name`, `active`, `last_modified`, `access_rights`, `config_id`) VALUES(2, 'hplj2605dn', 'HP LaserJet 2605dn', '', '192.168.1.30', 0, 2, 1, 2, NULL, 1, 2, '', NULL, NULL, NULL, 2, 2, 0, 2, 2, NULL, 0, 2, NULL, NULL, 2, '', 2, 2, 2, 0, 2, 0, 2, NULL, 0, NULL, '', 2, '', '', '', '', '', '', '', '', '', '', 0, '', '1', '2008-11-28 14:10:01', NULL, 1);
INSERT INTO `tbl_host` (`id`, `host_name`, `alias`, `display_name`, `address`, `parents`, `parents_tploptions`, `hostgroups`, `hostgroups_tploptions`, `check_command`, `use_template`, `use_template_tploptions`, `initial_state`, `max_check_attempts`, `check_interval`, `retry_interval`, `active_checks_enabled`, `passive_checks_enabled`, `check_period`, `obsess_over_host`, `check_freshness`, `freshness_threshold`, `event_handler`, `event_handler_enabled`, `low_flap_threshold`, `high_flap_threshold`, `flap_detection_enabled`, `flap_detection_options`, `process_perf_data`, `retain_status_information`, `retain_nonstatus_information`, `contacts`, `contacts_tploptions`, `contact_groups`, `contact_groups_tploptions`, `notification_interval`, `notification_period`, `first_notification_delay`, `notification_options`, `notifications_enabled`, `stalking_options`, `notes`, `notes_url`, `action_url`, `icon_image`, `icon_image_alt`, `vrml_image`, `statusmap_image`, `2d_coords`, `3d_coords`, `use_variables`, `name`, `active`, `last_modified`, `access_rights`, `config_id`) VALUES(3, 'linksys-srw224p', 'Linksys SRW224P Switch', '', '192.168.1.253', 0, 2, 1, 2, NULL, 1, 2, '', NULL, NULL, NULL, 2, 2, 0, 2, 2, NULL, 0, 2, NULL, NULL, 2, '', 2, 2, 2, 0, 2, 0, 2, NULL, 0, NULL, '', 2, '', '', '', '', '', '', '', '', '', '', 0, '', '1', '2008-11-28 14:10:01', NULL, 1);
INSERT INTO `tbl_host` (`id`, `host_name`, `alias`, `display_name`, `address`, `parents`, `parents_tploptions`, `hostgroups`, `hostgroups_tploptions`, `check_command`, `use_template`, `use_template_tploptions`, `initial_state`, `max_check_attempts`, `check_interval`, `retry_interval`, `active_checks_enabled`, `passive_checks_enabled`, `check_period`, `obsess_over_host`, `check_freshness`, `freshness_threshold`, `event_handler`, `event_handler_enabled`, `low_flap_threshold`, `high_flap_threshold`, `flap_detection_enabled`, `flap_detection_options`, `process_perf_data`, `retain_status_information`, `retain_nonstatus_information`, `contacts`, `contacts_tploptions`, `contact_groups`, `contact_groups_tploptions`, `notification_interval`, `notification_period`, `first_notification_delay`, `notification_options`, `notifications_enabled`, `stalking_options`, `notes`, `notes_url`, `action_url`, `icon_image`, `icon_image_alt`, `vrml_image`, `statusmap_image`, `2d_coords`, `3d_coords`, `use_variables`, `name`, `active`, `last_modified`, `access_rights`, `config_id`) VALUES(4, 'winserver', 'My Windows Server', '', '192.168.1.2', 0, 2, 0, 2, NULL, 1, 2, '', NULL, NULL, NULL, 2, 2, 0, 2, 2, NULL, 0, 2, NULL, NULL, 2, '', 2, 2, 2, 0, 2, 0, 2, NULL, 0, NULL, '', 2, '', '', '', '', '', '', '', '', '', '', 0, '', '1', '2008-11-28 14:10:01', NULL, 1);
--
-- Import table `tbl_hostgroup`
--
INSERT INTO `tbl_hostgroup` (`id`, `hostgroup_name`, `alias`, `members`, `hostgroup_members`, `notes`, `notes_url`, `action_url`, `active`, `last_modified`, `access_rights`, `config_id`) VALUES(1, 'linux-servers', 'Linux Servers', 1, 0, NULL, NULL, NULL, '1', '2008-11-28 14:10:01', NULL, 1);
INSERT INTO `tbl_hostgroup` (`id`, `hostgroup_name`, `alias`, `members`, `hostgroup_members`, `notes`, `notes_url`, `action_url`, `active`, `last_modified`, `access_rights`, `config_id`) VALUES(2, 'network-printers', 'Network Printers', 0, 0, NULL, NULL, NULL, '1', '2008-11-28 14:10:01', NULL, 1);
INSERT INTO `tbl_hostgroup` (`id`, `hostgroup_name`, `alias`, `members`, `hostgroup_members`, `notes`, `notes_url`, `action_url`, `active`, `last_modified`, `access_rights`, `config_id`) VALUES(3, 'switches', 'Network Switches', 0, 0, NULL, NULL, NULL, '1', '2008-11-28 14:10:01', NULL, 1);
INSERT INTO `tbl_hostgroup` (`id`, `hostgroup_name`, `alias`, `members`, `hostgroup_members`, `notes`, `notes_url`, `action_url`, `active`, `last_modified`, `access_rights`, `config_id`) VALUES(4, 'windows-servers', 'Windows Servers', 0, 0, NULL, NULL, NULL, '1', '2008-11-28 14:10:01', NULL, 1);
--
-- Import table `tbl_hosttemplate`
--
INSERT INTO `tbl_hosttemplate` (`id`, `template_name`, `alias`, `parents`, `parents_tploptions`, `hostgroups`, `hostgroups_tploptions`, `check_command`, `use_template`, `use_template_tploptions`, `initial_state`, `max_check_attempts`, `check_interval`, `retry_interval`, `active_checks_enabled`, `passive_checks_enabled`, `check_period`, `obsess_over_host`, `check_freshness`, `freshness_threshold`, `event_handler`, `event_handler_enabled`, `low_flap_threshold`, `high_flap_threshold`, `flap_detection_enabled`, `flap_detection_options`, `process_perf_data`, `retain_status_information`, `retain_nonstatus_information`, `contacts`, `contacts_tploptions`, `contact_groups`, `contact_groups_tploptions`, `notification_interval`, `notification_period`, `first_notification_delay`, `notification_options`, `notifications_enabled`, `stalking_options`, `notes`, `notes_url`, `action_url`, `icon_image`, `icon_image_alt`, `vrml_image`, `statusmap_image`, `2d_coords`, `3d_coords`, `use_variables`, `active`, `last_modified`, `access_rights`, `config_id`) VALUES(1, 'linux-server', '', 0, 2, 0, 2, '3', 1, 2, '', 10, 5, 1, 2, 2, 1, 2, 2, NULL, 0, 2, NULL, NULL, 2, '', 2, 2, 2, 0, 2, 1, 2, 120, 2, NULL, 'd,u,r', 2, '', '', '', '', '', '', '', '', '', '', 1, '1', '2008-11-28 14:10:01', NULL, 1);
INSERT INTO `tbl_hosttemplate` (`id`, `template_name`, `alias`, `parents`, `parents_tploptions`, `hostgroups`, `hostgroups_tploptions`, `check_command`, `use_template`, `use_template_tploptions`, `initial_state`, `max_check_attempts`, `check_interval`, `retry_interval`, `active_checks_enabled`, `passive_checks_enabled`, `check_period`, `obsess_over_host`, `check_freshness`, `freshness_threshold`, `event_handler`, `event_handler_enabled`, `low_flap_threshold`, `high_flap_threshold`, `flap_detection_enabled`, `flap_detection_options`, `process_perf_data`, `retain_status_information`, `retain_nonstatus_information`, `contacts`, `contacts_tploptions`, `contact_groups`, `contact_groups_tploptions`, `notification_interval`, `notification_period`, `first_notification_delay`, `notification_options`, `notifications_enabled`, `stalking_options`, `notes`, `notes_url`, `action_url`, `icon_image`, `icon_image_alt`, `vrml_image`, `statusmap_image`, `2d_coords`, `3d_coords`, `use_variables`, `active`, `last_modified`, `access_rights`, `config_id`) VALUES(2, 'generic-printer', '', 0, 2, 0, 2, '3', 1, 2, '', 10, 5, 1, 2, 2, 1, 2, 2, NULL, 0, 2, NULL, NULL, 2, '', 2, 2, 2, 0, 2, 1, 2, 30, 2, NULL, 'd,r', 2, '', '', '', '', '', '', '', '', '', '', 0, '1', '2008-11-28 14:10:01', NULL, 1);
INSERT INTO `tbl_hosttemplate` (`id`, `template_name`, `alias`, `parents`, `parents_tploptions`, `hostgroups`, `hostgroups_tploptions`, `check_command`, `use_template`, `use_template_tploptions`, `initial_state`, `max_check_attempts`, `check_interval`, `retry_interval`, `active_checks_enabled`, `passive_checks_enabled`, `check_period`, `obsess_over_host`, `check_freshness`, `freshness_threshold`, `event_handler`, `event_handler_enabled`, `low_flap_threshold`, `high_flap_threshold`, `flap_detection_enabled`, `flap_detection_options`, `process_perf_data`, `retain_status_information`, `retain_nonstatus_information`, `contacts`, `contacts_tploptions`, `contact_groups`, `contact_groups_tploptions`, `notification_interval`, `notification_period`, `first_notification_delay`, `notification_options`, `notifications_enabled`, `stalking_options`, `notes`, `notes_url`, `action_url`, `icon_image`, `icon_image_alt`, `vrml_image`, `statusmap_image`, `2d_coords`, `3d_coords`, `use_variables`, `active`, `last_modified`, `access_rights`, `config_id`) VALUES(3, 'generic-switch', '', 0, 2, 0, 2, '3', 1, 2, '', 10, 5, 1, 2, 2, 1, 2, 2, NULL, 0, 2, NULL, NULL, 2, '', 2, 2, 2, 0, 2, 1, 2, 30, 1, NULL, 'd,r', 2, '', '', '', '', '', '', '', '', '', '', 0, '1', '2008-11-28 14:10:01', NULL, 1);
INSERT INTO `tbl_hosttemplate` (`id`, `template_name`, `alias`, `parents`, `parents_tploptions`, `hostgroups`, `hostgroups_tploptions`, `check_command`, `use_template`, `use_template_tploptions`, `initial_state`, `max_check_attempts`, `check_interval`, `retry_interval`, `active_checks_enabled`, `passive_checks_enabled`, `check_period`, `obsess_over_host`, `check_freshness`, `freshness_threshold`, `event_handler`, `event_handler_enabled`, `low_flap_threshold`, `high_flap_threshold`, `flap_detection_enabled`, `flap_detection_options`, `process_perf_data`, `retain_status_information`, `retain_nonstatus_information`, `contacts`, `contacts_tploptions`, `contact_groups`, `contact_groups_tploptions`, `notification_interval`, `notification_period`, `first_notification_delay`, `notification_options`, `notifications_enabled`, `stalking_options`, `notes`, `notes_url`, `action_url`, `icon_image`, `icon_image_alt`, `vrml_image`, `statusmap_image`, `2d_coords`, `3d_coords`, `use_variables`, `active`, `last_modified`, `access_rights`, `config_id`) VALUES(4, 'generic-host', '', 0, 2, 0, 2, NULL, 0, 2, '', NULL, NULL, NULL, 2, 2, 0, 2, 2, NULL, 0, 1, NULL, NULL, 1, '', 1, 1, 1, 0, 2, 0, 2, NULL, 1, NULL, '', 1, '', '', '', '', '', '', '', '', '', '', 1, '1', '2008-11-28 14:10:01', NULL, 1);
INSERT INTO `tbl_hosttemplate` (`id`, `template_name`, `alias`, `parents`, `parents_tploptions`, `hostgroups`, `hostgroups_tploptions`, `check_command`, `use_template`, `use_template_tploptions`, `initial_state`, `max_check_attempts`, `check_interval`, `retry_interval`, `active_checks_enabled`, `passive_checks_enabled`, `check_period`, `obsess_over_host`, `check_freshness`, `freshness_threshold`, `event_handler`, `event_handler_enabled`, `low_flap_threshold`, `high_flap_threshold`, `flap_detection_enabled`, `flap_detection_options`, `process_perf_data`, `retain_status_information`, `retain_nonstatus_information`, `contacts`, `contacts_tploptions`, `contact_groups`, `contact_groups_tploptions`, `notification_interval`, `notification_period`, `first_notification_delay`, `notification_options`, `notifications_enabled`, `stalking_options`, `notes`, `notes_url`, `action_url`, `icon_image`, `icon_image_alt`, `vrml_image`, `statusmap_image`, `2d_coords`, `3d_coords`, `use_variables`, `active`, `last_modified`, `access_rights`, `config_id`) VALUES(5, 'windows-server', '', 0, 2, 1, 2, '3', 1, 2, '', 10, 5, 1, 2, 2, 1, 2, 2, NULL, 0, 2, NULL, NULL, 2, '', 2, 2, 2, 0, 2, 1, 2, 30, 1, NULL, 'd,r', 2, '', '', '', '', '', '', '', '', '', '', 0, '1', '2008-11-28 14:10:01', NULL, 1);
--
-- Import table `tbl_lnkContactgroupToContact`
--
INSERT INTO `tbl_lnkContactgroupToContact` (`idMaster`, `idSlave`) VALUES(1, 1);
--
-- Import table `tbl_lnkContacttemplateToCommandHost`
--
INSERT INTO `tbl_lnkContacttemplateToCommandHost` (`idMaster`, `idSlave`) VALUES(1, 1);
--
-- Import table `tbl_lnkContacttemplateToCommandService`
--
INSERT INTO `tbl_lnkContacttemplateToCommandService` (`idMaster`, `idSlave`) VALUES(1, 2);
--
-- Import table `tbl_lnkContactToContacttemplate`
--
INSERT INTO `tbl_lnkContactToContacttemplate` (`idMaster`, `idSlave`, `idSort`, `idTable`) VALUES(1, 1, 1, 1);
--
-- Import table `tbl_lnkHostgroupToHost`
--
INSERT INTO `tbl_lnkHostgroupToHost` (`idMaster`, `idSlave`) VALUES(1, 1);
--
-- Import table `tbl_lnkHosttemplateToContactgroup`
--
INSERT INTO `tbl_lnkHosttemplateToContactgroup` (`idMaster`, `idSlave`) VALUES(1, 1);
INSERT INTO `tbl_lnkHosttemplateToContactgroup` (`idMaster`, `idSlave`) VALUES(2, 1);
INSERT INTO `tbl_lnkHosttemplateToContactgroup` (`idMaster`, `idSlave`) VALUES(3, 1);
INSERT INTO `tbl_lnkHosttemplateToContactgroup` (`idMaster`, `idSlave`) VALUES(5, 1);
--
-- Import table `tbl_lnkHosttemplateToHostgroup`
--
INSERT INTO `tbl_lnkHosttemplateToHostgroup` (`idMaster`, `idSlave`) VALUES(5, 4);
--
-- Import table `tbl_lnkHosttemplateToHosttemplate`
--
INSERT INTO `tbl_lnkHosttemplateToHosttemplate` (`idMaster`, `idSlave`, `idSort`, `idTable`) VALUES(1, 4, 1, 1);
INSERT INTO `tbl_lnkHosttemplateToHosttemplate` (`idMaster`, `idSlave`, `idSort`, `idTable`) VALUES(5, 4, 1, 1);
INSERT INTO `tbl_lnkHosttemplateToHosttemplate` (`idMaster`, `idSlave`, `idSort`, `idTable`) VALUES(2, 4, 1, 1);
INSERT INTO `tbl_lnkHosttemplateToHosttemplate` (`idMaster`, `idSlave`, `idSort`, `idTable`) VALUES(3, 4, 1, 1);
--
-- Import table `tbl_lnkHosttemplateToVariabledefinition`
--
INSERT INTO `tbl_lnkHosttemplateToVariabledefinition` (`idMaster`, `idSlave`) VALUES(1, 3);
INSERT INTO `tbl_lnkHosttemplateToVariabledefinition` (`idMaster`, `idSlave`) VALUES(4, 2);
--
-- Import table `tbl_lnkHostToHostgroup`
--
INSERT INTO `tbl_lnkHostToHostgroup` (`idMaster`, `idSlave`) VALUES(2, 2);
INSERT INTO `tbl_lnkHostToHostgroup` (`idMaster`, `idSlave`) VALUES(3, 3);
--
-- Import table `tbl_lnkHostToHosttemplate`
--
INSERT INTO `tbl_lnkHostToHosttemplate` (`idMaster`, `idSlave`, `idSort`, `idTable`) VALUES(1, 1, 1, 1);
INSERT INTO `tbl_lnkHostToHosttemplate` (`idMaster`, `idSlave`, `idSort`, `idTable`) VALUES(2, 2, 1, 1);
INSERT INTO `tbl_lnkHostToHosttemplate` (`idMaster`, `idSlave`, `idSort`, `idTable`) VALUES(3, 3, 1, 1);
INSERT INTO `tbl_lnkHostToHosttemplate` (`idMaster`, `idSlave`, `idSort`, `idTable`) VALUES(4, 5, 1, 1);
--
-- Import table `tbl_lnkHostToVariabledefinition`
--
INSERT INTO `tbl_lnkHostToVariabledefinition` (`idMaster`, `idSlave`) VALUES(1, 1);
--
-- Import table `tbl_lnkServicetemplateToContactgroup`
--
INSERT INTO `tbl_lnkServicetemplateToContactgroup` (`idMaster`, `idSlave`) VALUES(2, 1);
--
-- Import table `tbl_lnkServicetemplateToServicetemplate`
--
INSERT INTO `tbl_lnkServicetemplateToServicetemplate` (`idMaster`, `idSlave`, `idSort`, `idTable`) VALUES(1, 2, 1, 1);
--
-- Import table `tbl_lnkServicetemplateToVariabledefinition`
--
INSERT INTO `tbl_lnkServicetemplateToVariabledefinition` (`idMaster`, `idSlave`) VALUES(2, 4);
--
-- Import table `tbl_lnkServiceToHost`
--
INSERT INTO `tbl_lnkServiceToHost` (`idMaster`, `idSlave`) VALUES(1, 1);
INSERT INTO `tbl_lnkServiceToHost` (`idMaster`, `idSlave`) VALUES(2, 1);
INSERT INTO `tbl_lnkServiceToHost` (`idMaster`, `idSlave`) VALUES(3, 1);
INSERT INTO `tbl_lnkServiceToHost` (`idMaster`, `idSlave`) VALUES(4, 1);
INSERT INTO `tbl_lnkServiceToHost` (`idMaster`, `idSlave`) VALUES(5, 1);
INSERT INTO `tbl_lnkServiceToHost` (`idMaster`, `idSlave`) VALUES(6, 1);
INSERT INTO `tbl_lnkServiceToHost` (`idMaster`, `idSlave`) VALUES(7, 1);
INSERT INTO `tbl_lnkServiceToHost` (`idMaster`, `idSlave`) VALUES(8, 1);
INSERT INTO `tbl_lnkServiceToHost` (`idMaster`, `idSlave`) VALUES(9, 2);
INSERT INTO `tbl_lnkServiceToHost` (`idMaster`, `idSlave`) VALUES(10, 2);
INSERT INTO `tbl_lnkServiceToHost` (`idMaster`, `idSlave`) VALUES(11, 3);
INSERT INTO `tbl_lnkServiceToHost` (`idMaster`, `idSlave`) VALUES(12, 3);
INSERT INTO `tbl_lnkServiceToHost` (`idMaster`, `idSlave`) VALUES(13, 3);
INSERT INTO `tbl_lnkServiceToHost` (`idMaster`, `idSlave`) VALUES(14, 3);
INSERT INTO `tbl_lnkServiceToHost` (`idMaster`, `idSlave`) VALUES(15, 4);
INSERT INTO `tbl_lnkServiceToHost` (`idMaster`, `idSlave`) VALUES(16, 4);
INSERT INTO `tbl_lnkServiceToHost` (`idMaster`, `idSlave`) VALUES(17, 4);
INSERT INTO `tbl_lnkServiceToHost` (`idMaster`, `idSlave`) VALUES(18, 4);
INSERT INTO `tbl_lnkServiceToHost` (`idMaster`, `idSlave`) VALUES(19, 4);
INSERT INTO `tbl_lnkServiceToHost` (`idMaster`, `idSlave`) VALUES(20, 4);
INSERT INTO `tbl_lnkServiceToHost` (`idMaster`, `idSlave`) VALUES(21, 4);
--
-- Import table `tbl_lnkServiceToServicetemplate`
--
INSERT INTO `tbl_lnkServiceToServicetemplate` (`idMaster`, `idSlave`, `idSort`, `idTable`) VALUES(1, 1, 1, 1);
INSERT INTO `tbl_lnkServiceToServicetemplate` (`idMaster`, `idSlave`, `idSort`, `idTable`) VALUES(2, 1, 1, 1);
INSERT INTO `tbl_lnkServiceToServicetemplate` (`idMaster`, `idSlave`, `idSort`, `idTable`) VALUES(3, 1, 1, 1);
INSERT INTO `tbl_lnkServiceToServicetemplate` (`idMaster`, `idSlave`, `idSort`, `idTable`) VALUES(4, 1, 1, 1);
INSERT INTO `tbl_lnkServiceToServicetemplate` (`idMaster`, `idSlave`, `idSort`, `idTable`) VALUES(5, 1, 1, 1);
INSERT INTO `tbl_lnkServiceToServicetemplate` (`idMaster`, `idSlave`, `idSort`, `idTable`) VALUES(6, 1, 1, 1);
INSERT INTO `tbl_lnkServiceToServicetemplate` (`idMaster`, `idSlave`, `idSort`, `idTable`) VALUES(7, 1, 1, 1);
INSERT INTO `tbl_lnkServiceToServicetemplate` (`idMaster`, `idSlave`, `idSort`, `idTable`) VALUES(8, 1, 1, 1);
INSERT INTO `tbl_lnkServiceToServicetemplate` (`idMaster`, `idSlave`, `idSort`, `idTable`) VALUES(9, 2, 1, 1);
INSERT INTO `tbl_lnkServiceToServicetemplate` (`idMaster`, `idSlave`, `idSort`, `idTable`) VALUES(10, 2, 1, 1);
INSERT INTO `tbl_lnkServiceToServicetemplate` (`idMaster`, `idSlave`, `idSort`, `idTable`) VALUES(11, 2, 1, 1);
INSERT INTO `tbl_lnkServiceToServicetemplate` (`idMaster`, `idSlave`, `idSort`, `idTable`) VALUES(12, 2, 1, 1);
INSERT INTO `tbl_lnkServiceToServicetemplate` (`idMaster`, `idSlave`, `idSort`, `idTable`) VALUES(13, 2, 1, 1);
INSERT INTO `tbl_lnkServiceToServicetemplate` (`idMaster`, `idSlave`, `idSort`, `idTable`) VALUES(14, 2, 1, 1);
INSERT INTO `tbl_lnkServiceToServicetemplate` (`idMaster`, `idSlave`, `idSort`, `idTable`) VALUES(15, 2, 1, 1);
INSERT INTO `tbl_lnkServiceToServicetemplate` (`idMaster`, `idSlave`, `idSort`, `idTable`) VALUES(16, 2, 1, 1);
INSERT INTO `tbl_lnkServiceToServicetemplate` (`idMaster`, `idSlave`, `idSort`, `idTable`) VALUES(17, 2, 1, 1);
INSERT INTO `tbl_lnkServiceToServicetemplate` (`idMaster`, `idSlave`, `idSort`, `idTable`) VALUES(18, 2, 1, 1);
INSERT INTO `tbl_lnkServiceToServicetemplate` (`idMaster`, `idSlave`, `idSort`, `idTable`) VALUES(19, 2, 1, 1);
INSERT INTO `tbl_lnkServiceToServicetemplate` (`idMaster`, `idSlave`, `idSort`, `idTable`) VALUES(20, 2, 1, 1);
INSERT INTO `tbl_lnkServiceToServicetemplate` (`idMaster`, `idSlave`, `idSort`, `idTable`) VALUES(21, 2, 1, 1);
--
-- Import table `tbl_service`
--
INSERT INTO `tbl_service` (`id`, `config_name`, `host_name`, `host_name_tploptions`, `hostgroup_name`, `hostgroup_name_tploptions`, `service_description`, `display_name`, `servicegroups`, `servicegroups_tploptions`, `use_template`, `use_template_tploptions`, `check_command`, `is_volatile`, `initial_state`, `max_check_attempts`, `check_interval`, `retry_interval`, `active_checks_enabled`, `passive_checks_enabled`, `check_period`, `parallelize_check`, `obsess_over_service`, `check_freshness`, `freshness_threshold`, `event_handler`, `event_handler_enabled`, `low_flap_threshold`, `high_flap_threshold`, `flap_detection_enabled`, `flap_detection_options`, `process_perf_data`, `retain_status_information`, `retain_nonstatus_information`, `notification_interval`, `first_notification_delay`, `notification_period`, `notification_options`, `notifications_enabled`, `contacts`, `contacts_tploptions`, `contact_groups`, `contact_groups_tploptions`, `stalking_options`, `notes`, `notes_url`, `action_url`, `icon_image`, `icon_image_alt`, `use_variables`, `name`, `active`, `last_modified`, `access_rights`, `config_id`) VALUES(1, 'localhost', 1, 2, 0, 2, 'PING', '', 0, 2, 1, 2, '16!100.0,20%!500.0,60%', 2, '', NULL, NULL, NULL, 2, 2, 0, 2, 2, 2, NULL, 0, 2, NULL, NULL, 2, '', 2, 2, 2, NULL, NULL, 0, '', 2, 0, 2, 0, 2, '', '', '', '', '', '', 0, '', '1', '2008-11-28 14:10:01', NULL, 1);
INSERT INTO `tbl_service` (`id`, `config_name`, `host_name`, `host_name_tploptions`, `hostgroup_name`, `hostgroup_name_tploptions`, `service_description`, `display_name`, `servicegroups`, `servicegroups_tploptions`, `use_template`, `use_template_tploptions`, `check_command`, `is_volatile`, `initial_state`, `max_check_attempts`, `check_interval`, `retry_interval`, `active_checks_enabled`, `passive_checks_enabled`, `check_period`, `parallelize_check`, `obsess_over_service`, `check_freshness`, `freshness_threshold`, `event_handler`, `event_handler_enabled`, `low_flap_threshold`, `high_flap_threshold`, `flap_detection_enabled`, `flap_detection_options`, `process_perf_data`, `retain_status_information`, `retain_nonstatus_information`, `notification_interval`, `first_notification_delay`, `notification_period`, `notification_options`, `notifications_enabled`, `contacts`, `contacts_tploptions`, `contact_groups`, `contact_groups_tploptions`, `stalking_options`, `notes`, `notes_url`, `action_url`, `icon_image`, `icon_image_alt`, `use_variables`, `name`, `active`, `last_modified`, `access_rights`, `config_id`) VALUES(2, 'localhost', 1, 2, 0, 2, 'Root Partition', '', 0, 2, 1, 2, '4!20%!10%!/', 2, '', NULL, NULL, NULL, 2, 2, 0, 2, 2, 2, NULL, 0, 2, NULL, NULL, 2, '', 2, 2, 2, NULL, NULL, 0, '', 2, 0, 2, 0, 2, '', '', '', '', '', '', 0, '', '1', '2008-11-28 14:10:01', NULL, 1);
INSERT INTO `tbl_service` (`id`, `config_name`, `host_name`, `host_name_tploptions`, `hostgroup_name`, `hostgroup_name_tploptions`, `service_description`, `display_name`, `servicegroups`, `servicegroups_tploptions`, `use_template`, `use_template_tploptions`, `check_command`, `is_volatile`, `initial_state`, `max_check_attempts`, `check_interval`, `retry_interval`, `active_checks_enabled`, `passive_checks_enabled`, `check_period`, `parallelize_check`, `obsess_over_service`, `check_freshness`, `freshness_threshold`, `event_handler`, `event_handler_enabled`, `low_flap_threshold`, `high_flap_threshold`, `flap_detection_enabled`, `flap_detection_options`, `process_perf_data`, `retain_status_information`, `retain_nonstatus_information`, `notification_interval`, `first_notification_delay`, `notification_period`, `notification_options`, `notifications_enabled`, `contacts`, `contacts_tploptions`, `contact_groups`, `contact_groups_tploptions`, `stalking_options`, `notes`, `notes_url`, `action_url`, `icon_image`, `icon_image_alt`, `use_variables`, `name`, `active`, `last_modified`, `access_rights`, `config_id`) VALUES(3, 'localhost', 1, 2, 0, 2, 'Current Users', '', 0, 2, 1, 2, '7!20!50', 2, '', NULL, NULL, NULL, 2, 2, 0, 2, 2, 2, NULL, 0, 2, NULL, NULL, 2, '', 2, 2, 2, NULL, NULL, 0, '', 2, 0, 2, 0, 2, '', '', '', '', '', '', 0, '', '1', '2008-11-28 14:10:01', NULL, 1);
INSERT INTO `tbl_service` (`id`, `config_name`, `host_name`, `host_name_tploptions`, `hostgroup_name`, `hostgroup_name_tploptions`, `service_description`, `display_name`, `servicegroups`, `servicegroups_tploptions`, `use_template`, `use_template_tploptions`, `check_command`, `is_volatile`, `initial_state`, `max_check_attempts`, `check_interval`, `retry_interval`, `active_checks_enabled`, `passive_checks_enabled`, `check_period`, `parallelize_check`, `obsess_over_service`, `check_freshness`, `freshness_threshold`, `event_handler`, `event_handler_enabled`, `low_flap_threshold`, `high_flap_threshold`, `flap_detection_enabled`, `flap_detection_options`, `process_perf_data`, `retain_status_information`, `retain_nonstatus_information`, `notification_interval`, `first_notification_delay`, `notification_period`, `notification_options`, `notifications_enabled`, `contacts`, `contacts_tploptions`, `contact_groups`, `contact_groups_tploptions`, `stalking_options`, `notes`, `notes_url`, `action_url`, `icon_image`, `icon_image_alt`, `use_variables`, `name`, `active`, `last_modified`, `access_rights`, `config_id`) VALUES(4, 'localhost', 1, 2, 0, 2, 'Total Processes', '', 0, 2, 1, 2, '6!250!400!RSZDT', 2, '', NULL, NULL, NULL, 2, 2, 0, 2, 2, 2, NULL, 0, 2, NULL, NULL, 2, '', 2, 2, 2, NULL, NULL, 0, '', 2, 0, 2, 0, 2, '', '', '', '', '', '', 0, '', '1', '2008-11-28 14:10:01', NULL, 1);
INSERT INTO `tbl_service` (`id`, `config_name`, `host_name`, `host_name_tploptions`, `hostgroup_name`, `hostgroup_name_tploptions`, `service_description`, `display_name`, `servicegroups`, `servicegroups_tploptions`, `use_template`, `use_template_tploptions`, `check_command`, `is_volatile`, `initial_state`, `max_check_attempts`, `check_interval`, `retry_interval`, `active_checks_enabled`, `passive_checks_enabled`, `check_period`, `parallelize_check`, `obsess_over_service`, `check_freshness`, `freshness_threshold`, `event_handler`, `event_handler_enabled`, `low_flap_threshold`, `high_flap_threshold`, `flap_detection_enabled`, `flap_detection_options`, `process_perf_data`, `retain_status_information`, `retain_nonstatus_information`, `notification_interval`, `first_notification_delay`, `notification_period`, `notification_options`, `notifications_enabled`, `contacts`, `contacts_tploptions`, `contact_groups`, `contact_groups_tploptions`, `stalking_options`, `notes`, `notes_url`, `action_url`, `icon_image`, `icon_image_alt`, `use_variables`, `name`, `active`, `last_modified`, `access_rights`, `config_id`) VALUES(5, 'localhost', 1, 2, 0, 2, 'Current Load', '', 0, 2, 1, 2, '5!5.0,4.0,3.0!10.0,6.0,4.0', 2, '', NULL, NULL, NULL, 2, 2, 0, 2, 2, 2, NULL, 0, 2, NULL, NULL, 2, '', 2, 2, 2, NULL, NULL, 0, '', 2, 0, 2, 0, 2, '', '', '', '', '', '', 0, '', '1', '2008-11-28 14:10:01', NULL, 1);
INSERT INTO `tbl_service` (`id`, `config_name`, `host_name`, `host_name_tploptions`, `hostgroup_name`, `hostgroup_name_tploptions`, `service_description`, `display_name`, `servicegroups`, `servicegroups_tploptions`, `use_template`, `use_template_tploptions`, `check_command`, `is_volatile`, `initial_state`, `max_check_attempts`, `check_interval`, `retry_interval`, `active_checks_enabled`, `passive_checks_enabled`, `check_period`, `parallelize_check`, `obsess_over_service`, `check_freshness`, `freshness_threshold`, `event_handler`, `event_handler_enabled`, `low_flap_threshold`, `high_flap_threshold`, `flap_detection_enabled`, `flap_detection_options`, `process_perf_data`, `retain_status_information`, `retain_nonstatus_information`, `notification_interval`, `first_notification_delay`, `notification_period`, `notification_options`, `notifications_enabled`, `contacts`, `contacts_tploptions`, `contact_groups`, `contact_groups_tploptions`, `stalking_options`, `notes`, `notes_url`, `action_url`, `icon_image`, `icon_image_alt`, `use_variables`, `name`, `active`, `last_modified`, `access_rights`, `config_id`) VALUES(6, 'localhost', 1, 2, 0, 2, 'Swap Usage', '', 0, 2, 1, 2, '8!20!10', 2, '', NULL, NULL, NULL, 2, 2, 0, 2, 2, 2, NULL, 0, 2, NULL, NULL, 2, '', 2, 2, 2, NULL, NULL, 0, '', 2, 0, 2, 0, 2, '', '', '', '', '', '', 0, '', '1', '2008-11-28 14:10:01', NULL, 1);
INSERT INTO `tbl_service` (`id`, `config_name`, `host_name`, `host_name_tploptions`, `hostgroup_name`, `hostgroup_name_tploptions`, `service_description`, `display_name`, `servicegroups`, `servicegroups_tploptions`, `use_template`, `use_template_tploptions`, `check_command`, `is_volatile`, `initial_state`, `max_check_attempts`, `check_interval`, `retry_interval`, `active_checks_enabled`, `passive_checks_enabled`, `check_period`, `parallelize_check`, `obsess_over_service`, `check_freshness`, `freshness_threshold`, `event_handler`, `event_handler_enabled`, `low_flap_threshold`, `high_flap_threshold`, `flap_detection_enabled`, `flap_detection_options`, `process_perf_data`, `retain_status_information`, `retain_nonstatus_information`, `notification_interval`, `first_notification_delay`, `notification_period`, `notification_options`, `notifications_enabled`, `contacts`, `contacts_tploptions`, `contact_groups`, `contact_groups_tploptions`, `stalking_options`, `notes`, `notes_url`, `action_url`, `icon_image`, `icon_image_alt`, `use_variables`, `name`, `active`, `last_modified`, `access_rights`, `config_id`) VALUES(7, 'localhost', 1, 2, 0, 2, 'SSH', '', 0, 2, 1, 2, '14', 2, '', NULL, NULL, NULL, 2, 2, 0, 2, 2, 2, NULL, 0, 2, NULL, NULL, 2, '', 2, 2, 2, NULL, NULL, 0, '', 0, 0, 2, 0, 2, '', '', '', '', '', '', 0, '', '1', '2008-11-28 14:10:01', NULL, 1);
INSERT INTO `tbl_service` (`id`, `config_name`, `host_name`, `host_name_tploptions`, `hostgroup_name`, `hostgroup_name_tploptions`, `service_description`, `display_name`, `servicegroups`, `servicegroups_tploptions`, `use_template`, `use_template_tploptions`, `check_command`, `is_volatile`, `initial_state`, `max_check_attempts`, `check_interval`, `retry_interval`, `active_checks_enabled`, `passive_checks_enabled`, `check_period`, `parallelize_check`, `obsess_over_service`, `check_freshness`, `freshness_threshold`, `event_handler`, `event_handler_enabled`, `low_flap_threshold`, `high_flap_threshold`, `flap_detection_enabled`, `flap_detection_options`, `process_perf_data`, `retain_status_information`, `retain_nonstatus_information`, `notification_interval`, `first_notification_delay`, `notification_period`, `notification_options`, `notifications_enabled`, `contacts`, `contacts_tploptions`, `contact_groups`, `contact_groups_tploptions`, `stalking_options`, `notes`, `notes_url`, `action_url`, `icon_image`, `icon_image_alt`, `use_variables`, `name`, `active`, `last_modified`, `access_rights`, `config_id`) VALUES(8, 'localhost', 1, 2, 0, 2, 'HTTP', '', 0, 2, 1, 2, '13', 2, '', NULL, NULL, NULL, 2, 2, 0, 2, 2, 2, NULL, 0, 2, NULL, NULL, 2, '', 2, 2, 2, NULL, NULL, 0, '', 0, 0, 2, 0, 2, '', '', '', '', '', '', 0, '', '1', '2008-11-28 14:10:01', NULL, 1);
INSERT INTO `tbl_service` (`id`, `config_name`, `host_name`, `host_name_tploptions`, `hostgroup_name`, `hostgroup_name_tploptions`, `service_description`, `display_name`, `servicegroups`, `servicegroups_tploptions`, `use_template`, `use_template_tploptions`, `check_command`, `is_volatile`, `initial_state`, `max_check_attempts`, `check_interval`, `retry_interval`, `active_checks_enabled`, `passive_checks_enabled`, `check_period`, `parallelize_check`, `obsess_over_service`, `check_freshness`, `freshness_threshold`, `event_handler`, `event_handler_enabled`, `low_flap_threshold`, `high_flap_threshold`, `flap_detection_enabled`, `flap_detection_options`, `process_perf_data`, `retain_status_information`, `retain_nonstatus_information`, `notification_interval`, `first_notification_delay`, `notification_period`, `notification_options`, `notifications_enabled`, `contacts`, `contacts_tploptions`, `contact_groups`, `contact_groups_tploptions`, `stalking_options`, `notes`, `notes_url`, `action_url`, `icon_image`, `icon_image_alt`, `use_variables`, `name`, `active`, `last_modified`, `access_rights`, `config_id`) VALUES(9, 'hplj2605dn', 1, 2, 0, 2, 'Printer Status', '', 0, 2, 1, 2, '11!-C public', 2, '', NULL, 10, 1, 2, 2, 0, 2, 2, 2, NULL, 0, 2, NULL, NULL, 2, '', 2, 2, 2, NULL, NULL, 0, '', 2, 0, 2, 0, 2, '', '', '', '', '', '', 0, '', '1', '2008-11-28 14:10:01', NULL, 1);
INSERT INTO `tbl_service` (`id`, `config_name`, `host_name`, `host_name_tploptions`, `hostgroup_name`, `hostgroup_name_tploptions`, `service_description`, `display_name`, `servicegroups`, `servicegroups_tploptions`, `use_template`, `use_template_tploptions`, `check_command`, `is_volatile`, `initial_state`, `max_check_attempts`, `check_interval`, `retry_interval`, `active_checks_enabled`, `passive_checks_enabled`, `check_period`, `parallelize_check`, `obsess_over_service`, `check_freshness`, `freshness_threshold`, `event_handler`, `event_handler_enabled`, `low_flap_threshold`, `high_flap_threshold`, `flap_detection_enabled`, `flap_detection_options`, `process_perf_data`, `retain_status_information`, `retain_nonstatus_information`, `notification_interval`, `first_notification_delay`, `notification_period`, `notification_options`, `notifications_enabled`, `contacts`, `contacts_tploptions`, `contact_groups`, `contact_groups_tploptions`, `stalking_options`, `notes`, `notes_url`, `action_url`, `icon_image`, `icon_image_alt`, `use_variables`, `name`, `active`, `last_modified`, `access_rights`, `config_id`) VALUES(10, 'hplj2605dn', 1, 2, 0, 2, 'PING', '', 0, 2, 1, 2, '16!3000.0,80%!5000.0,100%', 2, '', NULL, 10, 1, 2, 2, 0, 2, 2, 2, NULL, 0, 2, NULL, NULL, 2, '', 2, 2, 2, NULL, NULL, 0, '', 2, 0, 2, 0, 2, '', '', '', '', '', '', 0, '', '1', '2008-11-28 14:10:01', NULL, 1);
INSERT INTO `tbl_service` (`id`, `config_name`, `host_name`, `host_name_tploptions`, `hostgroup_name`, `hostgroup_name_tploptions`, `service_description`, `display_name`, `servicegroups`, `servicegroups_tploptions`, `use_template`, `use_template_tploptions`, `check_command`, `is_volatile`, `initial_state`, `max_check_attempts`, `check_interval`, `retry_interval`, `active_checks_enabled`, `passive_checks_enabled`, `check_period`, `parallelize_check`, `obsess_over_service`, `check_freshness`, `freshness_threshold`, `event_handler`, `event_handler_enabled`, `low_flap_threshold`, `high_flap_threshold`, `flap_detection_enabled`, `flap_detection_options`, `process_perf_data`, `retain_status_information`, `retain_nonstatus_information`, `notification_interval`, `first_notification_delay`, `notification_period`, `notification_options`, `notifications_enabled`, `contacts`, `contacts_tploptions`, `contact_groups`, `contact_groups_tploptions`, `stalking_options`, `notes`, `notes_url`, `action_url`, `icon_image`, `icon_image_alt`, `use_variables`, `name`, `active`, `last_modified`, `access_rights`, `config_id`) VALUES(11, 'linksys-srw224p', 1, 2, 0, 2, 'PING', '', 0, 2, 1, 2, '16!200.0,20%!600.0,60%', 2, '', NULL, 5, 1, 2, 2, 0, 2, 2, 2, NULL, 0, 2, NULL, NULL, 2, '', 2, 2, 2, NULL, NULL, 0, '', 2, 0, 2, 0, 2, '', '', '', '', '', '', 0, '', '1', '2008-11-28 14:10:01', NULL, 1);
INSERT INTO `tbl_service` (`id`, `config_name`, `host_name`, `host_name_tploptions`, `hostgroup_name`, `hostgroup_name_tploptions`, `service_description`, `display_name`, `servicegroups`, `servicegroups_tploptions`, `use_template`, `use_template_tploptions`, `check_command`, `is_volatile`, `initial_state`, `max_check_attempts`, `check_interval`, `retry_interval`, `active_checks_enabled`, `passive_checks_enabled`, `check_period`, `parallelize_check`, `obsess_over_service`, `check_freshness`, `freshness_threshold`, `event_handler`, `event_handler_enabled`, `low_flap_threshold`, `high_flap_threshold`, `flap_detection_enabled`, `flap_detection_options`, `process_perf_data`, `retain_status_information`, `retain_nonstatus_information`, `notification_interval`, `first_notification_delay`, `notification_period`, `notification_options`, `notifications_enabled`, `contacts`, `contacts_tploptions`, `contact_groups`, `contact_groups_tploptions`, `stalking_options`, `notes`, `notes_url`, `action_url`, `icon_image`, `icon_image_alt`, `use_variables`, `name`, `active`, `last_modified`, `access_rights`, `config_id`) VALUES(12, 'linksys-srw224p', 1, 2, 0, 2, 'Uptime', '', 0, 2, 1, 2, '12!-C public -o sysUpTime.0', 2, '', NULL, NULL, NULL, 2, 2, 0, 2, 2, 2, NULL, 0, 2, NULL, NULL, 2, '', 2, 2, 2, NULL, NULL, 0, '', 2, 0, 2, 0, 2, '', '', '', '', '', '', 0, '', '1', '2008-11-28 14:10:01', NULL, 1);
INSERT INTO `tbl_service` (`id`, `config_name`, `host_name`, `host_name_tploptions`, `hostgroup_name`, `hostgroup_name_tploptions`, `service_description`, `display_name`, `servicegroups`, `servicegroups_tploptions`, `use_template`, `use_template_tploptions`, `check_command`, `is_volatile`, `initial_state`, `max_check_attempts`, `check_interval`, `retry_interval`, `active_checks_enabled`, `passive_checks_enabled`, `check_period`, `parallelize_check`, `obsess_over_service`, `check_freshness`, `freshness_threshold`, `event_handler`, `event_handler_enabled`, `low_flap_threshold`, `high_flap_threshold`, `flap_detection_enabled`, `flap_detection_options`, `process_perf_data`, `retain_status_information`, `retain_nonstatus_information`, `notification_interval`, `first_notification_delay`, `notification_period`, `notification_options`, `notifications_enabled`, `contacts`, `contacts_tploptions`, `contact_groups`, `contact_groups_tploptions`, `stalking_options`, `notes`, `notes_url`, `action_url`, `icon_image`, `icon_image_alt`, `use_variables`, `name`, `active`, `last_modified`, `access_rights`, `config_id`) VALUES(13, 'linksys-srw224p', 1, 2, 0, 2, 'Port 1 Link Status', '', 0, 2, 1, 2, '12!-C public -o ifOperStatus.1 -r 1 -m RFC1213-MIB', 2, '', NULL, NULL, NULL, 2, 2, 0, 2, 2, 2, NULL, 0, 2, NULL, NULL, 2, '', 2, 2, 2, NULL, NULL, 0, '', 2, 0, 2, 0, 2, '', '', '', '', '', '', 0, '', '1', '2008-11-28 14:10:01', NULL, 1);
INSERT INTO `tbl_service` (`id`, `config_name`, `host_name`, `host_name_tploptions`, `hostgroup_name`, `hostgroup_name_tploptions`, `service_description`, `display_name`, `servicegroups`, `servicegroups_tploptions`, `use_template`, `use_template_tploptions`, `check_command`, `is_volatile`, `initial_state`, `max_check_attempts`, `check_interval`, `retry_interval`, `active_checks_enabled`, `passive_checks_enabled`, `check_period`, `parallelize_check`, `obsess_over_service`, `check_freshness`, `freshness_threshold`, `event_handler`, `event_handler_enabled`, `low_flap_threshold`, `high_flap_threshold`, `flap_detection_enabled`, `flap_detection_options`, `process_perf_data`, `retain_status_information`, `retain_nonstatus_information`, `notification_interval`, `first_notification_delay`, `notification_period`, `notification_options`, `notifications_enabled`, `contacts`, `contacts_tploptions`, `contact_groups`, `contact_groups_tploptions`, `stalking_options`, `notes`, `notes_url`, `action_url`, `icon_image`, `icon_image_alt`, `use_variables`, `name`, `active`, `last_modified`, `access_rights`, `config_id`) VALUES(14, 'linksys-srw224p', 1, 2, 0, 2, 'Port 1 Bandwidth Usage', '', 0, 2, 1, 2, '9!/var/lib/mrtg/192.168.1.253_1.log!AVG!1000000,1000000!5000000,5000000!10', 2, '', NULL, NULL, NULL, 2, 2, 0, 2, 2, 2, NULL, 0, 2, NULL, NULL, 2, '', 2, 2, 2, NULL, NULL, 0, '', 2, 0, 2, 0, 2, '', '', '', '', '', '', 0, '', '1', '2008-11-28 14:10:01', NULL, 1);
INSERT INTO `tbl_service` (`id`, `config_name`, `host_name`, `host_name_tploptions`, `hostgroup_name`, `hostgroup_name_tploptions`, `service_description`, `display_name`, `servicegroups`, `servicegroups_tploptions`, `use_template`, `use_template_tploptions`, `check_command`, `is_volatile`, `initial_state`, `max_check_attempts`, `check_interval`, `retry_interval`, `active_checks_enabled`, `passive_checks_enabled`, `check_period`, `parallelize_check`, `obsess_over_service`, `check_freshness`, `freshness_threshold`, `event_handler`, `event_handler_enabled`, `low_flap_threshold`, `high_flap_threshold`, `flap_detection_enabled`, `flap_detection_options`, `process_perf_data`, `retain_status_information`, `retain_nonstatus_information`, `notification_interval`, `first_notification_delay`, `notification_period`, `notification_options`, `notifications_enabled`, `contacts`, `contacts_tploptions`, `contact_groups`, `contact_groups_tploptions`, `stalking_options`, `notes`, `notes_url`, `action_url`, `icon_image`, `icon_image_alt`, `use_variables`, `name`, `active`, `last_modified`, `access_rights`, `config_id`) VALUES(15, 'winserver', 1, 2, 0, 2, 'NSClient++ Version', '', 0, 2, 1, 2, '22!CLIENTVERSION', 2, '', NULL, NULL, NULL, 2, 2, 0, 2, 2, 2, NULL, 0, 2, NULL, NULL, 2, '', 2, 2, 2, NULL, NULL, 0, '', 2, 0, 2, 0, 2, '', '', '', '', '', '', 0, '', '1', '2008-11-28 14:10:01', NULL, 1);
INSERT INTO `tbl_service` (`id`, `config_name`, `host_name`, `host_name_tploptions`, `hostgroup_name`, `hostgroup_name_tploptions`, `service_description`, `display_name`, `servicegroups`, `servicegroups_tploptions`, `use_template`, `use_template_tploptions`, `check_command`, `is_volatile`, `initial_state`, `max_check_attempts`, `check_interval`, `retry_interval`, `active_checks_enabled`, `passive_checks_enabled`, `check_period`, `parallelize_check`, `obsess_over_service`, `check_freshness`, `freshness_threshold`, `event_handler`, `event_handler_enabled`, `low_flap_threshold`, `high_flap_threshold`, `flap_detection_enabled`, `flap_detection_options`, `process_perf_data`, `retain_status_information`, `retain_nonstatus_information`, `notification_interval`, `first_notification_delay`, `notification_period`, `notification_options`, `notifications_enabled`, `contacts`, `contacts_tploptions`, `contact_groups`, `contact_groups_tploptions`, `stalking_options`, `notes`, `notes_url`, `action_url`, `icon_image`, `icon_image_alt`, `use_variables`, `name`, `active`, `last_modified`, `access_rights`, `config_id`) VALUES(16, 'winserver', 1, 2, 0, 2, 'Uptime', '', 0, 2, 1, 2, '22!UPTIME', 2, '', NULL, NULL, NULL, 2, 2, 0, 2, 2, 2, NULL, 0, 2, NULL, NULL, 2, '', 2, 2, 2, NULL, NULL, 0, '', 2, 0, 2, 0, 2, '', '', '', '', '', '', 0, '', '1', '2008-11-28 14:10:01', NULL, 1);
INSERT INTO `tbl_service` (`id`, `config_name`, `host_name`, `host_name_tploptions`, `hostgroup_name`, `hostgroup_name_tploptions`, `service_description`, `display_name`, `servicegroups`, `servicegroups_tploptions`, `use_template`, `use_template_tploptions`, `check_command`, `is_volatile`, `initial_state`, `max_check_attempts`, `check_interval`, `retry_interval`, `active_checks_enabled`, `passive_checks_enabled`, `check_period`, `parallelize_check`, `obsess_over_service`, `check_freshness`, `freshness_threshold`, `event_handler`, `event_handler_enabled`, `low_flap_threshold`, `high_flap_threshold`, `flap_detection_enabled`, `flap_detection_options`, `process_perf_data`, `retain_status_information`, `retain_nonstatus_information`, `notification_interval`, `first_notification_delay`, `notification_period`, `notification_options`, `notifications_enabled`, `contacts`, `contacts_tploptions`, `contact_groups`, `contact_groups_tploptions`, `stalking_options`, `notes`, `notes_url`, `action_url`, `icon_image`, `icon_image_alt`, `use_variables`, `name`, `active`, `last_modified`, `access_rights`, `config_id`) VALUES(17, 'winserver', 1, 2, 0, 2, 'CPU Load', '', 0, 2, 1, 2, '22!CPULOAD!-l 5,80,90', 2, '', NULL, NULL, NULL, 2, 2, 0, 2, 2, 2, NULL, 0, 2, NULL, NULL, 2, '', 2, 2, 2, NULL, NULL, 0, '', 2, 0, 2, 0, 2, '', '', '', '', '', '', 0, '', '1', '2008-11-28 14:10:01', NULL, 1);
INSERT INTO `tbl_service` (`id`, `config_name`, `host_name`, `host_name_tploptions`, `hostgroup_name`, `hostgroup_name_tploptions`, `service_description`, `display_name`, `servicegroups`, `servicegroups_tploptions`, `use_template`, `use_template_tploptions`, `check_command`, `is_volatile`, `initial_state`, `max_check_attempts`, `check_interval`, `retry_interval`, `active_checks_enabled`, `passive_checks_enabled`, `check_period`, `parallelize_check`, `obsess_over_service`, `check_freshness`, `freshness_threshold`, `event_handler`, `event_handler_enabled`, `low_flap_threshold`, `high_flap_threshold`, `flap_detection_enabled`, `flap_detection_options`, `process_perf_data`, `retain_status_information`, `retain_nonstatus_information`, `notification_interval`, `first_notification_delay`, `notification_period`, `notification_options`, `notifications_enabled`, `contacts`, `contacts_tploptions`, `contact_groups`, `contact_groups_tploptions`, `stalking_options`, `notes`, `notes_url`, `action_url`, `icon_image`, `icon_image_alt`, `use_variables`, `name`, `active`, `last_modified`, `access_rights`, `config_id`) VALUES(18, 'winserver', 1, 2, 0, 2, 'Memory Usage', '', 0, 2, 1, 2, '22!MEMUSE!-w 80 -c 90', 2, '', NULL, NULL, NULL, 2, 2, 0, 2, 2, 2, NULL, 0, 2, NULL, NULL, 2, '', 2, 2, 2, NULL, NULL, 0, '', 2, 0, 2, 0, 2, '', '', '', '', '', '', 0, '', '1', '2008-11-28 14:10:01', NULL, 1);
INSERT INTO `tbl_service` (`id`, `config_name`, `host_name`, `host_name_tploptions`, `hostgroup_name`, `hostgroup_name_tploptions`, `service_description`, `display_name`, `servicegroups`, `servicegroups_tploptions`, `use_template`, `use_template_tploptions`, `check_command`, `is_volatile`, `initial_state`, `max_check_attempts`, `check_interval`, `retry_interval`, `active_checks_enabled`, `passive_checks_enabled`, `check_period`, `parallelize_check`, `obsess_over_service`, `check_freshness`, `freshness_threshold`, `event_handler`, `event_handler_enabled`, `low_flap_threshold`, `high_flap_threshold`, `flap_detection_enabled`, `flap_detection_options`, `process_perf_data`, `retain_status_information`, `retain_nonstatus_information`, `notification_interval`, `first_notification_delay`, `notification_period`, `notification_options`, `notifications_enabled`, `contacts`, `contacts_tploptions`, `contact_groups`, `contact_groups_tploptions`, `stalking_options`, `notes`, `notes_url`, `action_url`, `icon_image`, `icon_image_alt`, `use_variables`, `name`, `active`, `last_modified`, `access_rights`, `config_id`) VALUES(19, 'winserver', 1, 2, 0, 2, 'C:\\ Drive Space', '', 0, 2, 1, 2, '22!USEDDISKSPACE!-l c -w 80 -c 90', 2, '', NULL, NULL, NULL, 2, 2, 0, 2, 2, 2, NULL, 0, 2, NULL, NULL, 2, '', 2, 2, 2, NULL, NULL, 0, '', 2, 0, 2, 0, 2, '', '', '', '', '', '', 0, '', '1', '2008-11-28 14:10:01', NULL, 1);
INSERT INTO `tbl_service` (`id`, `config_name`, `host_name`, `host_name_tploptions`, `hostgroup_name`, `hostgroup_name_tploptions`, `service_description`, `display_name`, `servicegroups`, `servicegroups_tploptions`, `use_template`, `use_template_tploptions`, `check_command`, `is_volatile`, `initial_state`, `max_check_attempts`, `check_interval`, `retry_interval`, `active_checks_enabled`, `passive_checks_enabled`, `check_period`, `parallelize_check`, `obsess_over_service`, `check_freshness`, `freshness_threshold`, `event_handler`, `event_handler_enabled`, `low_flap_threshold`, `high_flap_threshold`, `flap_detection_enabled`, `flap_detection_options`, `process_perf_data`, `retain_status_information`, `retain_nonstatus_information`, `notification_interval`, `first_notification_delay`, `notification_period`, `notification_options`, `notifications_enabled`, `contacts`, `contacts_tploptions`, `contact_groups`, `contact_groups_tploptions`, `stalking_options`, `notes`, `notes_url`, `action_url`, `icon_image`, `icon_image_alt`, `use_variables`, `name`, `active`, `last_modified`, `access_rights`, `config_id`) VALUES(20, 'winserver', 1, 2, 0, 2, 'W3SVC', '', 0, 2, 1, 2, '22!SERVICESTATE!-d SHOWALL -l W3SVC', 2, '', NULL, NULL, NULL, 2, 2, 0, 2, 2, 2, NULL, 0, 2, NULL, NULL, 2, '', 2, 2, 2, NULL, NULL, 0, '', 2, 0, 2, 0, 2, '', '', '', '', '', '', 0, '', '1', '2008-11-28 14:10:01', NULL, 1);
INSERT INTO `tbl_service` (`id`, `config_name`, `host_name`, `host_name_tploptions`, `hostgroup_name`, `hostgroup_name_tploptions`, `service_description`, `display_name`, `servicegroups`, `servicegroups_tploptions`, `use_template`, `use_template_tploptions`, `check_command`, `is_volatile`, `initial_state`, `max_check_attempts`, `check_interval`, `retry_interval`, `active_checks_enabled`, `passive_checks_enabled`, `check_period`, `parallelize_check`, `obsess_over_service`, `check_freshness`, `freshness_threshold`, `event_handler`, `event_handler_enabled`, `low_flap_threshold`, `high_flap_threshold`, `flap_detection_enabled`, `flap_detection_options`, `process_perf_data`, `retain_status_information`, `retain_nonstatus_information`, `notification_interval`, `first_notification_delay`, `notification_period`, `notification_options`, `notifications_enabled`, `contacts`, `contacts_tploptions`, `contact_groups`, `contact_groups_tploptions`, `stalking_options`, `notes`, `notes_url`, `action_url`, `icon_image`, `icon_image_alt`, `use_variables`, `name`, `active`, `last_modified`, `access_rights`, `config_id`) VALUES(21, 'winserver', 1, 2, 0, 2, 'Explorer', '', 0, 2, 1, 2, '22!PROCSTATE!-d SHOWALL -l Explorer.exe', 2, '', NULL, NULL, NULL, 2, 2, 0, 2, 2, 2, NULL, 0, 2, NULL, NULL, 2, '', 2, 2, 2, NULL, NULL, 0, '', 2, 0, 2, 0, 2, '', '', '', '', '', '', 0, '', '1', '2008-11-28 14:10:01', NULL, 1);
--
-- Import table `tbl_servicetemplate`
--
INSERT INTO `tbl_servicetemplate` (`id`, `template_name`, `host_name`, `host_name_tploptions`, `hostgroup_name`, `hostgroup_name_tploptions`, `service_description`, `display_name`, `servicegroups`, `servicegroups_tploptions`, `use_template`, `use_template_tploptions`, `check_command`, `is_volatile`, `initial_state`, `max_check_attempts`, `check_interval`, `retry_interval`, `active_checks_enabled`, `passive_checks_enabled`, `check_period`, `parallelize_check`, `obsess_over_service`, `check_freshness`, `freshness_threshold`, `event_handler`, `event_handler_enabled`, `low_flap_threshold`, `high_flap_threshold`, `flap_detection_enabled`, `flap_detection_options`, `process_perf_data`, `retain_status_information`, `retain_nonstatus_information`, `notification_interval`, `first_notification_delay`, `notification_period`, `notification_options`, `notifications_enabled`, `contacts`, `contacts_tploptions`, `contact_groups`, `contact_groups_tploptions`, `stalking_options`, `notes`, `notes_url`, `action_url`, `icon_image`, `icon_image_alt`, `use_variables`, `active`, `last_modified`, `access_rights`, `config_id`) VALUES(1, 'local-service', 0, 2, 0, 2, '', '', 0, 2, 1, 2, '', 2, '', 4, 5, 1, 2, 2, 0, 2, 2, 2, NULL, 0, 2, NULL, NULL, 2, '', 2, 2, 2, NULL, NULL, 0, '', 2, 0, 2, 0, 2, '', '', '', '', '', '', 0, '1', '2008-11-28 14:10:01', NULL, 1);
INSERT INTO `tbl_servicetemplate` (`id`, `template_name`, `host_name`, `host_name_tploptions`, `hostgroup_name`, `hostgroup_name_tploptions`, `service_description`, `display_name`, `servicegroups`, `servicegroups_tploptions`, `use_template`, `use_template_tploptions`, `check_command`, `is_volatile`, `initial_state`, `max_check_attempts`, `check_interval`, `retry_interval`, `active_checks_enabled`, `passive_checks_enabled`, `check_period`, `parallelize_check`, `obsess_over_service`, `check_freshness`, `freshness_threshold`, `event_handler`, `event_handler_enabled`, `low_flap_threshold`, `high_flap_threshold`, `flap_detection_enabled`, `flap_detection_options`, `process_perf_data`, `retain_status_information`, `retain_nonstatus_information`, `notification_interval`, `first_notification_delay`, `notification_period`, `notification_options`, `notifications_enabled`, `contacts`, `contacts_tploptions`, `contact_groups`, `contact_groups_tploptions`, `stalking_options`, `notes`, `notes_url`, `action_url`, `icon_image`, `icon_image_alt`, `use_variables`, `active`, `last_modified`, `access_rights`, `config_id`) VALUES(2, 'generic-service', 0, 2, 0, 2, '', '', 0, 2, 0, 2, '', 0, '', 3, 10, 2, 1, 1, 1, 1, 1, 0, NULL, 0, 1, NULL, NULL, 1, '', 1, 1, 1, 60, NULL, 1, 'w,u,c,r', 1, 0, 2, 1, 2, '', '', '', '', '', '', 1, '1', '2008-11-28 14:10:01', NULL, 1);
--
-- Import table `tbl_timedefinition`
--
INSERT INTO `tbl_timedefinition` (`id`, `tipId`, `definition`, `range`, `last_modified`) VALUES(1, 1, 'sunday', '00:00-24:00', '2008-11-28 12:59:53');
INSERT INTO `tbl_timedefinition` (`id`, `tipId`, `definition`, `range`, `last_modified`) VALUES(2, 1, 'monday', '00:00-24:00', '2008-11-28 12:59:53');
INSERT INTO `tbl_timedefinition` (`id`, `tipId`, `definition`, `range`, `last_modified`) VALUES(3, 1, 'tuesday', '00:00-24:00', '2008-11-28 12:59:53');
INSERT INTO `tbl_timedefinition` (`id`, `tipId`, `definition`, `range`, `last_modified`) VALUES(4, 1, 'wednesday', '00:00-24:00', '2008-11-28 12:59:53');
INSERT INTO `tbl_timedefinition` (`id`, `tipId`, `definition`, `range`, `last_modified`) VALUES(5, 1, 'thursday', '00:00-24:00', '2008-11-28 12:59:53');
INSERT INTO `tbl_timedefinition` (`id`, `tipId`, `definition`, `range`, `last_modified`) VALUES(6, 1, 'friday', '00:00-24:00', '2008-11-28 12:59:53');
INSERT INTO `tbl_timedefinition` (`id`, `tipId`, `definition`, `range`, `last_modified`) VALUES(7, 1, 'saturday', '00:00-24:00', '2008-11-28 12:59:53');
INSERT INTO `tbl_timedefinition` (`id`, `tipId`, `definition`, `range`, `last_modified`) VALUES(8, 2, 'monday', '09:00-17:00', '2008-11-28 12:59:53');
INSERT INTO `tbl_timedefinition` (`id`, `tipId`, `definition`, `range`, `last_modified`) VALUES(9, 2, 'tuesday', '09:00-17:00', '2008-11-28 12:59:53');
INSERT INTO `tbl_timedefinition` (`id`, `tipId`, `definition`, `range`, `last_modified`) VALUES(10, 2, 'wednesday', '09:00-17:00', '2008-11-28 12:59:53');
INSERT INTO `tbl_timedefinition` (`id`, `tipId`, `definition`, `range`, `last_modified`) VALUES(11, 2, 'thursday', '09:00-17:00', '2008-11-28 12:59:53');
INSERT INTO `tbl_timedefinition` (`id`, `tipId`, `definition`, `range`, `last_modified`) VALUES(12, 2, 'friday', '09:00-17:00', '2008-11-28 12:59:53');
INSERT INTO `tbl_timedefinition` (`id`, `tipId`, `definition`, `range`, `last_modified`) VALUES(13, 4, 'january 1', '00:00-00:00', '2008-11-28 12:59:53');
INSERT INTO `tbl_timedefinition` (`id`, `tipId`, `definition`, `range`, `last_modified`) VALUES(14, 4, 'monday 1 september', '00:00-00:00', '2008-11-28 12:59:53');
INSERT INTO `tbl_timedefinition` (`id`, `tipId`, `definition`, `range`, `last_modified`) VALUES(15, 4, 'july 4', '00:00-00:00', '2008-11-28 12:59:53');
INSERT INTO `tbl_timedefinition` (`id`, `tipId`, `definition`, `range`, `last_modified`) VALUES(16, 4, 'thursday -1 november', '00:00-00:00', '2008-11-28 12:59:53');
INSERT INTO `tbl_timedefinition` (`id`, `tipId`, `definition`, `range`, `last_modified`) VALUES(17, 4, 'december 25', '00:00-00:00', '2008-11-28 12:59:53');
INSERT INTO `tbl_timedefinition` (`id`, `tipId`, `definition`, `range`, `last_modified`) VALUES(18, 5, 'use', 'us-holidays', '2008-11-28 12:59:53');
INSERT INTO `tbl_timedefinition` (`id`, `tipId`, `definition`, `range`, `last_modified`) VALUES(19, 5, 'sunday', '00:00-24:00', '2008-11-28 12:59:53');
INSERT INTO `tbl_timedefinition` (`id`, `tipId`, `definition`, `range`, `last_modified`) VALUES(20, 5, 'monday', '00:00-24:00', '2008-11-28 12:59:53');
INSERT INTO `tbl_timedefinition` (`id`, `tipId`, `definition`, `range`, `last_modified`) VALUES(21, 5, 'tuesday', '00:00-24:00', '2008-11-28 12:59:53');
INSERT INTO `tbl_timedefinition` (`id`, `tipId`, `definition`, `range`, `last_modified`) VALUES(22, 5, 'wednesday', '00:00-24:00', '2008-11-28 12:59:53');
INSERT INTO `tbl_timedefinition` (`id`, `tipId`, `definition`, `range`, `last_modified`) VALUES(23, 5, 'thursday', '00:00-24:00', '2008-11-28 12:59:53');
INSERT INTO `tbl_timedefinition` (`id`, `tipId`, `definition`, `range`, `last_modified`) VALUES(24, 5, 'friday', '00:00-24:00', '2008-11-28 12:59:53');
INSERT INTO `tbl_timedefinition` (`id`, `tipId`, `definition`, `range`, `last_modified`) VALUES(25, 5, 'saturday', '00:00-24:00', '2008-11-28 12:59:53');
--
-- Import table `tbl_timeperiod`
--
INSERT INTO `tbl_timeperiod` (`id`, `timeperiod_name`, `alias`, `exclude`, `name`, `active`, `last_modified`, `access_rights`, `config_id`) VALUES(1, '24x7', '24 Hours A Day, 7 Days A Week', 0, '', '1', '2008-11-28 12:59:53', NULL, 1);
INSERT INTO `tbl_timeperiod` (`id`, `timeperiod_name`, `alias`, `exclude`, `name`, `active`, `last_modified`, `access_rights`, `config_id`) VALUES(2, 'workhours', 'Normal Work Hours', 0, '', '1', '2008-11-28 12:59:53', NULL, 1);
INSERT INTO `tbl_timeperiod` (`id`, `timeperiod_name`, `alias`, `exclude`, `name`, `active`, `last_modified`, `access_rights`, `config_id`) VALUES(3, 'none', 'No Time Is A Good Time', 0, '', '1', '2008-11-28 12:59:53', NULL, 1);
INSERT INTO `tbl_timeperiod` (`id`, `timeperiod_name`, `alias`, `exclude`, `name`, `active`, `last_modified`, `access_rights`, `config_id`) VALUES(4, 'us-holidays', 'U.S. Holidays', 0, 'us-holidays', '1', '2008-11-28 12:59:53', NULL, 1);
INSERT INTO `tbl_timeperiod` (`id`, `timeperiod_name`, `alias`, `exclude`, `name`, `active`, `last_modified`, `access_rights`, `config_id`) VALUES(5, '24x7_sans_holidays', '24x7 Sans Holidays', 0, '', '1', '2008-11-28 12:59:53', NULL, 1);
--
-- Import table `tbl_variabledefinition`
--
INSERT INTO `tbl_variabledefinition` (`id`, `name`, `value`, `last_modified`) VALUES(1, ';', '', '2008-11-28 14:10:01');
INSERT INTO `tbl_variabledefinition` (`id`, `name`, `value`, `last_modified`) VALUES(2, 'failure_prediction_enabled', '1', '2008-11-28 14:10:01');
INSERT INTO `tbl_variabledefinition` (`id`, `name`, `value`, `last_modified`) VALUES(3, ';', '', '2008-11-28 14:10:01');
INSERT INTO `tbl_variabledefinition` (`id`, `name`, `value`, `last_modified`) VALUES(4, 'failure_prediction_enabled', '1', '2008-11-28 14:10:01');
