<% local view, viewlibrary, page_info, session = ... 
htmlviewfunctions = require("htmlviewfunctions")
html = require("acf.html")
%>

<%
function convertsize(size)
	if string.find(size, "k$") then
		return tonumber(string.match(size, "[%d.]*")) * 1024.0
	elseif string.find(size, "M$") then
		return tonumber(string.match(size, "[%d.]*")) * 1024.0 * 1024.0
	elseif string.find(size, "G$") then
		return tonumber(string.match(size, "[%d.]*")) + 1024.0 * 1024.0 * 1024.0
	else
		return tonumber(string.match(size, "[%d.]*"))
	end
end
%>

<script type="text/javascript">
	if (typeof jQuery == 'undefined') {
		document.write('<script type="text/javascript" src="<%= html.html_escape(page_info.wwwprefix) %>/js/jquery-latest.js"><\/script>');
	}
</script>
	
<script type="text/javascript">
	if (typeof $.tablesorter == 'undefined') {
		document.write('<script type="text/javascript" src="<%= html.html_escape(page_info.wwwprefix) %>/js/jquery.tablesorter.js"><\/script>');
	}
</script>
	
<script type="text/javascript">
	$(document).ready(function() {
		$("#list").tablesorter({headers: {0:{sorter: false}}, widgets: ['zebra']});
	});
</script>


<% htmlviewfunctions.displaycommandresults({"edit"}, session) %>

<% if viewlibrary and viewlibrary.dispatch_component then 
	viewlibrary.dispatch_component("status")
end %>

<% local header_level = htmlviewfunctions.displaysectionstart(cfe({label="Configuration"}), page_info) %>
<table id="list" class="tablesorter"><thead>
	<tr>
		<th>Action</th>
		<th>File</th>
		<th>Size</th>
		<th>Last Modified</th>
	</tr>		
</thead><tbody>
<% local filename = cfe({ type="hidden", value="" }) %>
<% local redir = cfe({ type="hidden", value=page_info.orig_action }) %>
<% for i,file in ipairs( view.value ) do %>
	<% filename.value = file.filename %>
	<tr>
		<td><% htmlviewfunctions.displayitem(cfe({type="link", value={filename=filename, redir=redir}, label="", option="Edit", action="edit"}), page_info, -1) %></td>
		<td><%= html.html_escape(file.filename) %></td>
		<td><span class="hide"><%= convertsize(file.size) %>b</span><%= html.html_escape(file.size) %></td>
		<td><%= html.html_escape(file.mtime) %></td>
	</tr>
<% end %>
</tbody></table>
<% htmlviewfunctions.displaysectionend(header_level) %>
