/*! TableSorter (FORK) v2.31.1 *//*
* Client-side table sorting with ease!
* @requires jQuery v1.2.6+
*
* Copyright (c) 2007 Christian Bach
* fork maintained by Rob Garrison
*
* Examples and original docs at: http://tablesorter.com
* Dual licensed under the MIT and GPL licenses:
* http://www.opensource.org/licenses/mit-license.php
* http://www.gnu.org/licenses/gpl.html
*
* @type jQuery
* @name tablesorter (FORK)
* @cat Plugins/Tablesorter
* @author Christian Bach - christian.bach@polyester.se
* @contributor Rob Garrison - https://github.com/Mottie/tablesorter
* @docs (fork) - https://mottie.github.io/tablesorter/docs/
*/
/*jshint browser:true, jquery:true, unused:false, expr: true */
!function(e){"use strict";var t=e.tablesorter={version:"2.31.1",parsers:[],widgets:[],defaults:{theme:"default",widthFixed:!1,showProcessing:!1,headerTemplate:"{content}",onRenderTemplate:null,onRenderHeader:null,cancelSelection:!0,tabIndex:!0,dateFormat:"mmddyyyy",sortMultiSortKey:"shiftKey",sortResetKey:"ctrlKey",usNumberFormat:!0,delayInit:!1,serverSideSorting:!1,resort:!0,headers:{},ignoreCase:!0,sortForce:null,sortList:[],sortAppend:null,sortStable:!1,sortInitialOrder:"asc",sortLocaleCompare:!1,sortReset:!1,sortRestart:!1,emptyTo:"bottom",stringTo:"max",duplicateSpan:!0,textExtraction:"basic",textAttribute:"data-text",textSorter:null,numberSorter:null,initWidgets:!0,widgetClass:"widget-{name}",widgets:[],widgetOptions:{zebra:["even","odd"]},initialized:null,tableClass:"",cssAsc:"",cssDesc:"",cssNone:"",cssHeader:"",cssHeaderRow:"",cssProcessing:"",cssChildRow:"tablesorter-childRow",cssInfoBlock:"tablesorter-infoOnly",cssNoSort:"tablesorter-noSort",cssIgnoreRow:"tablesorter-ignoreRow",cssIcon:"tablesorter-icon",cssIconNone:"",cssIconAsc:"",cssIconDesc:"",cssIconDisabled:"",pointerClick:"click",pointerDown:"mousedown",pointerUp:"mouseup",selectorHeaders:"> thead th, > thead td",selectorSort:"th, td",selectorRemove:".remove-me",debug:!1,headerList:[],empties:{},strings:{},parsers:[],globalize:0,imgAttr:0},css:{table:"tablesorter",cssHasChild:"tablesorter-hasChildRow",childRow:"tablesorter-childRow",colgroup:"tablesorter-colgroup",header:"tablesorter-header",headerRow:"tablesorter-headerRow",headerIn:"tablesorter-header-inner",icon:"tablesorter-icon",processing:"tablesorter-processing",sortAsc:"tablesorter-headerAsc",sortDesc:"tablesorter-headerDesc",sortNone:"tablesorter-headerUnSorted"},language:{sortAsc:"Ascending sort applied, ",sortDesc:"Descending sort applied, ",sortNone:"No sort applied, ",sortDisabled:"sorting is disabled",nextAsc:"activate to apply an ascending sort",nextDesc:"activate to apply a descending sort",nextNone:"activate to remove the sort"},regex:{templateContent:/\{content\}/g,templateIcon:/\{icon\}/g,templateName:/\{name\}/i,spaces:/\s+/g,nonWord:/\W/g,formElements:/(input|select|button|textarea)/i,chunk:/(^([+\-]?(?:\d*)(?:\.\d*)?(?:[eE][+\-]?\d+)?)?$|^0x[0-9a-f]+$|\d+)/gi,chunks:/(^\\0|\\0$)/,hex:/^0x[0-9a-f]+$/i,comma:/,/g,digitNonUS:/[\s|\.]/g,digitNegativeTest:/^\s*\([.\d]+\)/,digitNegativeReplace:/^\s*\(([.\d]+)\)/,digitTest:/^[\-+(]?\d+[)]?$/,digitReplace:/[,.'"\s]/g},string:{max:1,min:-1,emptymin:1,emptymax:-1,zero:0,none:0,null:0,top:!0,bottom:!1},keyCodes:{enter:13},dates:{},instanceMethods:{},setup:function(r,s){if(r&&r.tHead&&0!==r.tBodies.length&&!0!==r.hasInitialized){var o,a="",n=e(r),i=e.metadata;r.hasInitialized=!1,r.isProcessing=!0,r.config=s,e.data(r,"tablesorter",s),t.debug(s,"core")&&(console[console.group?"group":"log"]("Initializing tablesorter v"+t.version),e.data(r,"startoveralltimer",new Date)),s.supportsDataObject=((o=e.fn.jquery.split("."))[0]=parseInt(o[0],10),o[0]>1||1===o[0]&&parseInt(o[1],10)>=4),s.emptyTo=s.emptyTo.toLowerCase(),s.stringTo=s.stringTo.toLowerCase(),s.last={sortList:[],clickedIndex:-1},/tablesorter\-/.test(n.attr("class"))||(a=""!==s.theme?" tablesorter-"+s.theme:""),s.namespace?s.namespace="."+s.namespace.replace(t.regex.nonWord,""):s.namespace=".tablesorter"+Math.random().toString(16).slice(2),s.table=r,s.$table=n.addClass(t.css.table+" "+s.tableClass+a+" "+s.namespace.slice(1)).attr("role","grid"),s.$headers=n.find(s.selectorHeaders),s.$table.children().children("tr").attr("role","row"),s.$tbodies=n.children("tbody:not(."+s.cssInfoBlock+")").attr({"aria-live":"polite","aria-relevant":"all"}),s.$table.children("caption").length&&((a=s.$table.children("caption")[0]).id||(a.id=s.namespace.slice(1)+"caption"),s.$table.attr("aria-labelledby",a.id)),s.widgetInit={},s.textExtraction=s.$table.attr("data-text-extraction")||s.textExtraction||"basic",t.buildHeaders(s),t.fixColumnWidth(r),t.addWidgetFromClass(r),t.applyWidgetOptions(r),t.setupParsers(s),s.totalRows=0,s.debug&&t.validateOptions(s),s.delayInit||t.buildCache(s),t.bindEvents(r,s.$headers,!0),t.bindMethods(s),s.supportsDataObject&&void 0!==n.data().sortlist?s.sortList=n.data().sortlist:i&&n.metadata()&&n.metadata().sortlist&&(s.sortList=n.metadata().sortlist),t.applyWidget(r,!0),s.sortList.length>0?(s.last.sortList=s.sortList,t.sortOn(s,s.sortList,{},!s.initWidgets)):(t.setHeadersCss(s),s.initWidgets&&t.applyWidget(r,!1)),s.showProcessing&&n.unbind("sortBegin"+s.namespace+" sortEnd"+s.namespace).bind("sortBegin"+s.namespace+" sortEnd"+s.namespace,function(e){clearTimeout(s.timerProcessing),t.isProcessing(r),"sortBegin"===e.type&&(s.timerProcessing=setTimeout(function(){t.isProcessing(r,!0)},500))}),r.hasInitialized=!0,r.isProcessing=!1,t.debug(s,"core")&&(console.log("Overall initialization time:"+t.benchmark(e.data(r,"startoveralltimer"))),t.debug(s,"core")&&console.groupEnd&&console.groupEnd()),n.triggerHandler("tablesorter-initialized",r),"function"==typeof s.initialized&&s.initialized(r)}else t.debug(s,"core")&&(r.hasInitialized?console.warn("Stopping initialization. Tablesorter has already been initialized"):console.error("Stopping initialization! No table, thead or tbody",r))},bindMethods:function(r){var s=r.$table,o=r.namespace,a="sortReset update updateRows updateAll updateHeaders addRows updateCell updateComplete sorton appendCache updateCache applyWidgetId applyWidgets refreshWidgets destroy mouseup mouseleave ".split(" ").join(o+" ");s.unbind(a.replace(t.regex.spaces," ")).bind("sortReset"+o,function(e,r){e.stopPropagation(),t.sortReset(this.config,function(e){e.isApplyingWidgets?setTimeout(function(){t.applyWidget(e,"",r)},100):t.applyWidget(e,"",r)})}).bind("updateAll"+o,function(e,r,s){e.stopPropagation(),t.updateAll(this.config,r,s)}).bind("update"+o+" updateRows"+o,function(e,r,s){e.stopPropagation(),t.update(this.config,r,s)}).bind("updateHeaders"+o,function(e,r){e.stopPropagation(),t.updateHeaders(this.config,r)}).bind("updateCell"+o,function(e,r,s,o){e.stopPropagation(),t.updateCell(this.config,r,s,o)}).bind("addRows"+o,function(e,r,s,o){e.stopPropagation(),t.addRows(this.config,r,s,o)}).bind("updateComplete"+o,function(){this.isUpdating=!1}).bind("sorton"+o,function(e,r,s,o){e.stopPropagation(),t.sortOn(this.config,r,s,o)}).bind("appendCache"+o,function(r,s,o){r.stopPropagation(),t.appendCache(this.config,o),e.isFunction(s)&&s(this)}).bind("updateCache"+o,function(e,r,s){e.stopPropagation(),t.updateCache(this.config,r,s)}).bind("applyWidgetId"+o,function(e,r){e.stopPropagation(),t.applyWidgetId(this,r)}).bind("applyWidgets"+o,function(e,r){e.stopPropagation(),t.applyWidget(this,!1,r)}).bind("refreshWidgets"+o,function(e,r,s){e.stopPropagation(),t.refreshWidgets(this,r,s)}).bind("removeWidget"+o,function(e,r,s){e.stopPropagation(),t.removeWidget(this,r,s)}).bind("destroy"+o,function(e,r,s){e.stopPropagation(),t.destroy(this,r,s)}).bind("resetToLoadState"+o,function(s){s.stopPropagation(),t.removeWidget(this,!0,!1);var o=e.extend(!0,{},r.originalSettings);(r=e.extend(!0,{},t.defaults,o)).originalSettings=o,this.hasInitialized=!1,t.setup(this,r)})},bindEvents:function(r,s,o){var a,n=(r=e(r)[0]).config,i=n.namespace,l=null;!0!==o&&(s.addClass(i.slice(1)+"_extra_headers"),(a=t.getClosest(s,"table")).length&&"TABLE"===a[0].nodeName&&a[0]!==r&&e(a[0]).addClass(i.slice(1)+"_extra_table")),a=(n.pointerDown+" "+n.pointerUp+" "+n.pointerClick+" sort keyup ").replace(t.regex.spaces," ").split(" ").join(i+" "),s.find(n.selectorSort).add(s.filter(n.selectorSort)).unbind(a).bind(a,function(r,s){var o,a,i,d=e(r.target),c=" "+r.type+" ";if(!(1!==(r.which||r.button)&&!c.match(" "+n.pointerClick+" | sort | keyup ")||" keyup "===c&&r.which!==t.keyCodes.enter||c.match(" "+n.pointerClick+" ")&&void 0!==r.which||c.match(" "+n.pointerUp+" ")&&l!==r.target&&!0!==s)){if(c.match(" "+n.pointerDown+" "))return l=r.target,void("1"===(i=d.jquery.split("."))[0]&&i[1]<4&&r.preventDefault());if(l=null,o=t.getClosest(e(this),"."+t.css.header),t.regex.formElements.test(r.target.nodeName)||d.hasClass(n.cssNoSort)||d.parents("."+n.cssNoSort).length>0||o.hasClass("sorter-false")||d.parents("button").length>0)return!n.cancelSelection;n.delayInit&&t.isEmptyObject(n.cache)&&t.buildCache(n),n.last.clickedIndex=o.attr("data-column")||o.index(),(a=n.$headerIndexed[n.last.clickedIndex][0])&&!a.sortDisabled&&t.initSort(n,a,r)}}),n.cancelSelection&&s.attr("unselectable","on").bind("selectstart",!1).css({"user-select":"none",MozUserSelect:"none"})},buildHeaders:function(r){var s,o,a,n;for(r.headerList=[],r.headerContent=[],r.sortVars=[],t.debug(r,"core")&&(a=new Date),r.columns=t.computeColumnIndex(r.$table.children("thead, tfoot").children("tr")),o=r.cssIcon?'<i class="'+(r.cssIcon===t.css.icon?t.css.icon:r.cssIcon+" "+t.css.icon)+'"></i>':"",r.$headers=e(e.map(r.$table.find(r.selectorHeaders),function(s,a){var n,i,l,d,c,g=e(s);if(!t.getClosest(g,"tr").hasClass(r.cssIgnoreRow))return/(th|td)/i.test(s.nodeName)||(c=t.getClosest(g,"th, td"),g.attr("data-column",c.attr("data-column"))),n=t.getColumnData(r.table,r.headers,a,!0),r.headerContent[a]=g.html(),""===r.headerTemplate||g.find("."+t.css.headerIn).length||(d=r.headerTemplate.replace(t.regex.templateContent,g.html()).replace(t.regex.templateIcon,g.find("."+t.css.icon).length?"":o),r.onRenderTemplate&&(i=r.onRenderTemplate.apply(g,[a,d]))&&"string"==typeof i&&(d=i),g.html('<div class="'+t.css.headerIn+'">'+d+"</div>")),r.onRenderHeader&&r.onRenderHeader.apply(g,[a,r,r.$table]),l=parseInt(g.attr("data-column"),10),s.column=l,c=t.getOrder(t.getData(g,n,"sortInitialOrder")||r.sortInitialOrder),r.sortVars[l]={count:-1,order:c?r.sortReset?[1,0,2]:[1,0]:r.sortReset?[0,1,2]:[0,1],lockedOrder:!1,sortedBy:""},void 0!==(c=t.getData(g,n,"lockedOrder")||!1)&&!1!==c&&(r.sortVars[l].lockedOrder=!0,r.sortVars[l].order=t.getOrder(c)?[1,1]:[0,0]),r.headerList[a]=s,g.addClass(t.css.header+" "+r.cssHeader),t.getClosest(g,"tr").addClass(t.css.headerRow+" "+r.cssHeaderRow).attr("role","row"),r.tabIndex&&g.attr("tabindex",0),s})),r.$headerIndexed=[],n=0;n<r.columns;n++)t.isEmptyObject(r.sortVars[n])&&(r.sortVars[n]={}),s=r.$headers.filter('[data-column="'+n+'"]'),r.$headerIndexed[n]=s.length?s.not(".sorter-false").length?s.not(".sorter-false").filter(":last"):s.filter(":last"):e();r.$table.find(r.selectorHeaders).attr({scope:"col",role:"columnheader"}),t.updateHeader(r),t.debug(r,"core")&&(console.log("Built headers:"+t.benchmark(a)),console.log(r.$headers))},addInstanceMethods:function(r){e.extend(t.instanceMethods,r)},setupParsers:function(e,r){var s,o,a,n,i,l,d,c,g,p,u,f,h,m,b=e.table,y=0,w=t.debug(e,"core"),x={};if(e.$tbodies=e.$table.children("tbody:not(."+e.cssInfoBlock+")"),0===(m=(h=void 0===r?e.$tbodies:r).length))return w?console.warn("Warning: *Empty table!* Not building a parser cache"):"";for(w&&(f=new Date,console[console.group?"group":"log"]("Detecting parsers for each column")),o={extractors:[],parsers:[]};y<m;){if((s=h[y].rows).length)for(i=0,n=e.columns,l=0;l<n;l++){if((d=e.$headerIndexed[i])&&d.length&&(c=t.getColumnData(b,e.headers,i),u=t.getParserById(t.getData(d,c,"extractor")),p=t.getParserById(t.getData(d,c,"sorter")),g="false"===t.getData(d,c,"parser"),e.empties[i]=(t.getData(d,c,"empty")||e.emptyTo||(e.emptyToBottom?"bottom":"top")).toLowerCase(),e.strings[i]=(t.getData(d,c,"string")||e.stringTo||"max").toLowerCase(),g&&(p=t.getParserById("no-parser")),u||(u=!1),p||(p=t.detectParserForColumn(e,s,-1,i)),w&&(x["("+i+") "+d.text()]={parser:p.id,extractor:u?u.id:"none",string:e.strings[i],empty:e.empties[i]}),o.parsers[i]=p,o.extractors[i]=u,(a=d[0].colSpan-1)>0))for(i+=a,n+=a;a+1>0;)o.parsers[i-a]=p,o.extractors[i-a]=u,a--;i++}y+=o.parsers.length?m:1}w&&(t.isEmptyObject(x)?console.warn("  No parsers detected!"):console[console.table?"table":"log"](x),console.log("Completed detecting parsers"+t.benchmark(f)),console.groupEnd&&console.groupEnd()),e.parsers=o.parsers,e.extractors=o.extractors},addParser:function(e){var r,s=t.parsers.length,o=!0;for(r=0;r<s;r++)t.parsers[r].id.toLowerCase()===e.id.toLowerCase()&&(o=!1);o&&(t.parsers[t.parsers.length]=e)},getParserById:function(e){if("false"==e)return!1;var r,s=t.parsers.length;for(r=0;r<s;r++)if(t.parsers[r].id.toLowerCase()===e.toString().toLowerCase())return t.parsers[r];return!1},detectParserForColumn:function(r,s,o,a){for(var n,i,l,d=t.parsers.length,c=!1,g="",p=t.debug(r,"core"),u=!0;""===g&&u;)(l=s[++o])&&o<50?l.className.indexOf(t.cssIgnoreRow)<0&&(c=s[o].cells[a],g=t.getElementText(r,c,a),i=e(c),p&&console.log("Checking if value was empty on row "+o+", column: "+a+': "'+g+'"')):u=!1;for(;--d>=0;)if((n=t.parsers[d])&&"text"!==n.id&&n.is&&n.is(g,r.table,c,i))return n;return t.getParserById("text")},getElementText:function(r,s,o){if(!s)return"";var a,n=r.textExtraction||"",i=s.jquery?s:e(s);return"string"==typeof n?"basic"===n&&void 0!==(a=i.attr(r.textAttribute))?e.trim(a):e.trim(s.textContent||i.text()):"function"==typeof n?e.trim(n(i[0],r.table,o)):"function"==typeof(a=t.getColumnData(r.table,n,o))?e.trim(a(i[0],r.table,o)):e.trim(i[0].textContent||i.text())},getParsedText:function(e,r,s,o){void 0===o&&(o=t.getElementText(e,r,s));var a=""+o,n=e.parsers[s],i=e.extractors[s];return n&&(i&&"function"==typeof i.format&&(o=i.format(o,e.table,r,s)),a="no-parser"===n.id?"":n.format(""+o,e.table,r,s),e.ignoreCase&&"string"==typeof a&&(a=a.toLowerCase())),a},buildCache:function(r,s,o){var a,n,i,l,d,c,g,p,u,f,h,m,b,y,w,x,v,C,$,I,D,R,T=r.table,A=r.parsers,L=t.debug(r,"core");if(r.$tbodies=r.$table.children("tbody:not(."+r.cssInfoBlock+")"),g=void 0===o?r.$tbodies:o,r.cache={},r.totalRows=0,!A)return L?console.warn("Warning: *Empty table!* Not building a cache"):"";for(L&&(m=new Date),r.showProcessing&&t.isProcessing(T,!0),c=0;c<g.length;c++){for(x=[],a=r.cache[c]={normalized:[]},b=g[c]&&g[c].rows.length||0,l=0;l<b;++l)if(y={child:[],raw:[]},u=[],!(p=e(g[c].rows[l])).hasClass(r.selectorRemove.slice(1)))if(p.hasClass(r.cssChildRow)&&0!==l)for(D=a.normalized.length-1,(w=a.normalized[D][r.columns]).$row=w.$row.add(p),p.prev().hasClass(r.cssChildRow)||p.prev().addClass(t.css.cssHasChild),f=p.children("th, td"),D=w.child.length,w.child[D]=[],C=0,I=r.columns,d=0;d<I;d++)(h=f[d])&&(w.child[D][d]=t.getParsedText(r,h,d),(v=f[d].colSpan-1)>0&&(C+=v,I+=v)),C++;else{for(y.$row=p,y.order=l,C=0,I=r.columns,d=0;d<I;++d){if((h=p[0].cells[d])&&C<r.columns&&(!($=void 0!==A[C])&&L&&console.warn("No parser found for row: "+l+", column: "+d+'; cell containing: "'+e(h).text()+'"; does it have a header?'),n=t.getElementText(r,h,C),y.raw[C]=n,i=t.getParsedText(r,h,C,n),u[C]=i,$&&"numeric"===(A[C].type||"").toLowerCase()&&(x[C]=Math.max(Math.abs(i)||0,x[C]||0)),(v=h.colSpan-1)>0)){for(R=0;R<=v;)i=r.duplicateSpan||0===R?n:"string"!=typeof r.textExtraction&&t.getElementText(r,h,C+R)||"",y.raw[C+R]=i,u[C+R]=i,R++;C+=v,I+=v}C++}u[r.columns]=y,a.normalized[a.normalized.length]=u}a.colMax=x,r.totalRows+=a.normalized.length}if(r.showProcessing&&t.isProcessing(T),L){for(D=Math.min(5,r.cache[0].normalized.length),console[console.group?"group":"log"]("Building cache for "+r.totalRows+" rows (showing "+D+" rows in log) and "+r.columns+" columns"+t.benchmark(m)),n={},d=0;d<r.columns;d++)for(C=0;C<D;C++)n["row: "+C]||(n["row: "+C]={}),n["row: "+C][r.$headerIndexed[d].text()]=r.cache[0].normalized[C][d];console[console.table?"table":"log"](n),console.groupEnd&&console.groupEnd()}e.isFunction(s)&&s(T)},getColumnText:function(r,s,o,a){var n,i,l,d,c,g,p,u,f,h,m="function"==typeof o,b="all"===s,y={raw:[],parsed:[],$cell:[]},w=(r=e(r)[0]).config;if(!t.isEmptyObject(w)){for(c=w.$tbodies.length,n=0;n<c;n++)for(g=(l=w.cache[n].normalized).length,i=0;i<g;i++)d=l[i],a&&!d[w.columns].$row.is(a)||(h=!0,u=b?d.slice(0,w.columns):d[s],d=d[w.columns],p=b?d.raw:d.raw[s],f=b?d.$row.children():d.$row.children().eq(s),m&&(h=o({tbodyIndex:n,rowIndex:i,parsed:u,raw:p,$row:d.$row,$cell:f})),!1!==h&&(y.parsed[y.parsed.length]=u,y.raw[y.raw.length]=p,y.$cell[y.$cell.length]=f));return y}t.debug(w,"core")&&console.warn("No cache found - aborting getColumnText function!")},setHeadersCss:function(r){var s,o,a=r.sortList,n=a.length,i=t.css.sortNone+" "+r.cssNone,l=[t.css.sortAsc+" "+r.cssAsc,t.css.sortDesc+" "+r.cssDesc],d=[r.cssIconAsc,r.cssIconDesc,r.cssIconNone],c=["ascending","descending"],g=function(e,r){e.removeClass(i).addClass(l[r]).attr("aria-sort",c[r]).find("."+t.css.icon).removeClass(d[2]).addClass(d[r])},p=r.$table.find("tfoot tr").children("td, th").add(e(r.namespace+"_extra_headers")).removeClass(l.join(" ")),u=r.$headers.add(e("thead "+r.namespace+"_extra_headers")).removeClass(l.join(" ")).addClass(i).attr("aria-sort","none").find("."+t.css.icon).removeClass(d.join(" ")).end();for(u.not(".sorter-false").find("."+t.css.icon).addClass(d[2]),r.cssIconDisabled&&u.filter(".sorter-false").find("."+t.css.icon).addClass(r.cssIconDisabled),s=0;s<n;s++)if(2!==a[s][1]){if((u=(u=r.$headers.filter(function(e){for(var s=!0,o=r.$headers.eq(e),a=parseInt(o.attr("data-column"),10),n=a+t.getClosest(o,"th, td")[0].colSpan;a<n;a++)s=!!s&&(s||t.isValueInArray(a,r.sortList)>-1);return s})).not(".sorter-false").filter('[data-column="'+a[s][0]+'"]'+(1===n?":last":""))).length)for(o=0;o<u.length;o++)u[o].sortDisabled||g(u.eq(o),a[s][1]);p.length&&g(p.filter('[data-column="'+a[s][0]+'"]'),a[s][1])}for(n=r.$headers.length,s=0;s<n;s++)t.setColumnAriaLabel(r,r.$headers.eq(s))},getClosest:function(t,r){return e.fn.closest?t.closest(r):t.is(r)?t:t.parents(r).filter(":first")},setColumnAriaLabel:function(r,s,o){if(s.length){var a=parseInt(s.attr("data-column"),10),n=r.sortVars[a],i=s.hasClass(t.css.sortAsc)?"sortAsc":s.hasClass(t.css.sortDesc)?"sortDesc":"sortNone",l=e.trim(s.text())+": "+t.language[i];s.hasClass("sorter-false")||!1===o?l+=t.language.sortDisabled:(i=(n.count+1)%n.order.length,o=n.order[i],l+=t.language[0===o?"nextAsc":1===o?"nextDesc":"nextNone"]),s.attr("aria-label",l),n.sortedBy?s.attr("data-sortedBy",n.sortedBy):s.removeAttr("data-sortedBy")}},updateHeader:function(e){var r,s,o,a,n=e.table,i=e.$headers.length;for(r=0;r<i;r++)o=e.$headers.eq(r),a=t.getColumnData(n,e.headers,r,!0),s="false"===t.getData(o,a,"sorter")||"false"===t.getData(o,a,"parser"),t.setColumnSort(e,o,s)},setColumnSort:function(e,t,r){var s=e.table.id;t[0].sortDisabled=r,t[r?"addClass":"removeClass"]("sorter-false").attr("aria-disabled",""+r),e.tabIndex&&(r?t.removeAttr("tabindex"):t.attr("tabindex","0")),s&&(r?t.removeAttr("aria-controls"):t.attr("aria-controls",s))},updateHeaderSortCount:function(r,s){var o,a,n,i,l,d,c,g,p=s||r.sortList,u=p.length;for(r.sortList=[],i=0;i<u;i++)if(c=p[i],(o=parseInt(c[0],10))<r.columns){switch(r.sortVars[o].order||(g=t.getOrder(r.sortInitialOrder)?r.sortReset?[1,0,2]:[1,0]:r.sortReset?[0,1,2]:[0,1],r.sortVars[o].order=g,r.sortVars[o].count=0),g=r.sortVars[o].order,a=(a=(""+c[1]).match(/^(1|d|s|o|n)/))?a[0]:""){case"1":case"d":a=1;break;case"s":a=l||0;break;case"o":a=0===(d=g[(l||0)%g.length])?1:1===d?0:2;break;case"n":a=g[++r.sortVars[o].count%g.length];break;default:a=0}l=0===i?a:l,n=[o,parseInt(a,10)||0],r.sortList[r.sortList.length]=n,a=e.inArray(n[1],g),r.sortVars[o].count=a>=0?a:n[1]%g.length}},updateAll:function(e,r,s){var o=e.table;o.isUpdating=!0,t.refreshWidgets(o,!0,!0),t.buildHeaders(e),t.bindEvents(o,e.$headers,!0),t.bindMethods(e),t.commonUpdate(e,r,s)},update:function(e,r,s){e.table.isUpdating=!0,t.updateHeader(e),t.commonUpdate(e,r,s)},updateHeaders:function(e,r){e.table.isUpdating=!0,t.buildHeaders(e),t.bindEvents(e.table,e.$headers,!0),t.resortComplete(e,r)},updateCell:function(r,s,o,a){if(e(s).closest("tr").hasClass(r.cssChildRow))console.warn('Tablesorter Warning! "updateCell" for child row content has been disabled, use "update" instead');else{if(t.isEmptyObject(r.cache))return t.updateHeader(r),void t.commonUpdate(r,o,a);r.table.isUpdating=!0,r.$table.find(r.selectorRemove).remove();var n,i,l,d,c,g,p=r.$tbodies,u=e(s),f=p.index(t.getClosest(u,"tbody")),h=r.cache[f],m=t.getClosest(u,"tr");if(s=u[0],p.length&&f>=0){if(l=p.eq(f).find("tr").not("."+r.cssChildRow).index(m),c=h.normalized[l],(g=m[0].cells.length)!==r.columns)for(d=0,n=!1,i=0;i<g;i++)n||m[0].cells[i]===s?n=!0:d+=m[0].cells[i].colSpan;else d=u.index();n=t.getElementText(r,s,d),c[r.columns].raw[d]=n,n=t.getParsedText(r,s,d,n),c[d]=n,"numeric"===(r.parsers[d].type||"").toLowerCase()&&(h.colMax[d]=Math.max(Math.abs(n)||0,h.colMax[d]||0)),!1!==(n="undefined"!==o?o:r.resort)?t.checkResort(r,n,a):t.resortComplete(r,a)}else t.debug(r,"core")&&console.error("updateCell aborted, tbody missing or not within the indicated table"),r.table.isUpdating=!1}},addRows:function(r,s,o,a){var n,i,l,d,c,g,p,u,f,h,m,b,y,w="string"==typeof s&&1===r.$tbodies.length&&/<tr/.test(s||""),x=r.table;if(w)s=e(s),r.$tbodies.append(s);else if(!(s&&s instanceof e&&t.getClosest(s,"table")[0]===r.table))return t.debug(r,"core")&&console.error("addRows method requires (1) a jQuery selector reference to rows that have already been added to the table, or (2) row HTML string to be added to a table with only one tbody"),!1;if(x.isUpdating=!0,t.isEmptyObject(r.cache))t.updateHeader(r),t.commonUpdate(r,o,a);else{for(c=s.filter("tr").attr("role","row").length,l=r.$tbodies.index(s.parents("tbody").filter(":first")),r.parsers&&r.parsers.length||t.setupParsers(r),d=0;d<c;d++){for(f=0,p=s[d].cells.length,u=r.cache[l].normalized.length,m=[],h={child:[],raw:[],$row:s.eq(d),order:u},g=0;g<p;g++)b=s[d].cells[g],n=t.getElementText(r,b,f),h.raw[f]=n,i=t.getParsedText(r,b,f,n),m[f]=i,"numeric"===(r.parsers[f].type||"").toLowerCase()&&(r.cache[l].colMax[f]=Math.max(Math.abs(i)||0,r.cache[l].colMax[f]||0)),(y=b.colSpan-1)>0&&(f+=y),f++;m[r.columns]=h,r.cache[l].normalized[u]=m}t.checkResort(r,o,a)}},updateCache:function(e,r,s){e.parsers&&e.parsers.length||t.setupParsers(e,s),t.buildCache(e,r,s)},appendCache:function(e,r){var s,o,a,n,i,l,d,c=e.table,g=e.$tbodies,p=[],u=e.cache;if(t.isEmptyObject(u))return e.appender?e.appender(c,p):c.isUpdating?e.$table.triggerHandler("updateComplete",c):"";for(t.debug(e,"core")&&(d=new Date),l=0;l<g.length;l++)if((a=g.eq(l)).length){for(n=t.processTbody(c,a,!0),o=(s=u[l].normalized).length,i=0;i<o;i++)p[p.length]=s[i][e.columns].$row,e.appender&&(!e.pager||e.pager.removeRows||e.pager.ajax)||n.append(s[i][e.columns].$row);t.processTbody(c,n,!1)}e.appender&&e.appender(c,p),t.debug(e,"core")&&console.log("Rebuilt table"+t.benchmark(d)),r||e.appender||t.applyWidget(c),c.isUpdating&&e.$table.triggerHandler("updateComplete",c)},commonUpdate:function(e,r,s){e.$table.find(e.selectorRemove).remove(),t.setupParsers(e),t.buildCache(e),t.checkResort(e,r,s)},initSort:function(r,s,o){if(r.table.isUpdating)return setTimeout(function(){t.initSort(r,s,o)},50);var a,n,i,l,d,c,g,p=!o[r.sortMultiSortKey],u=r.table,f=r.$headers.length,h=t.getClosest(e(s),"th, td"),m=parseInt(h.attr("data-column"),10),b="mouseup"===o.type?"user":o.type,y=r.sortVars[m].order;if(h=h[0],r.$table.triggerHandler("sortStart",u),c=(r.sortVars[m].count+1)%y.length,r.sortVars[m].count=o[r.sortResetKey]?2:c,r.sortRestart)for(i=0;i<f;i++)g=r.$headers.eq(i),m!==(c=parseInt(g.attr("data-column"),10))&&(p||g.hasClass(t.css.sortNone))&&(r.sortVars[c].count=-1);if(p){if(e.each(r.sortVars,function(e){r.sortVars[e].sortedBy=""}),r.sortList=[],r.last.sortList=[],null!==r.sortForce)for(a=r.sortForce,n=0;n<a.length;n++)a[n][0]!==m&&(r.sortList[r.sortList.length]=a[n],r.sortVars[a[n][0]].sortedBy="sortForce");if((l=y[r.sortVars[m].count])<2&&(r.sortList[r.sortList.length]=[m,l],r.sortVars[m].sortedBy=b,h.colSpan>1))for(n=1;n<h.colSpan;n++)r.sortList[r.sortList.length]=[m+n,l],r.sortVars[m+n].count=e.inArray(l,y),r.sortVars[m+n].sortedBy=b}else if(r.sortList=e.extend([],r.last.sortList),t.isValueInArray(m,r.sortList)>=0)for(r.sortVars[m].sortedBy=b,n=0;n<r.sortList.length;n++)(c=r.sortList[n])[0]===m&&(c[1]=y[r.sortVars[m].count],2===c[1]&&(r.sortList.splice(n,1),r.sortVars[m].count=-1));else if(l=y[r.sortVars[m].count],r.sortVars[m].sortedBy=b,l<2&&(r.sortList[r.sortList.length]=[m,l],h.colSpan>1))for(n=1;n<h.colSpan;n++)r.sortList[r.sortList.length]=[m+n,l],r.sortVars[m+n].count=e.inArray(l,y),r.sortVars[m+n].sortedBy=b;if(r.last.sortList=e.extend([],r.sortList),r.sortList.length&&r.sortAppend&&(a=e.isArray(r.sortAppend)?r.sortAppend:r.sortAppend[r.sortList[0][0]],!t.isEmptyObject(a)))for(n=0;n<a.length;n++)if(a[n][0]!==m&&t.isValueInArray(a[n][0],r.sortList)<0){if(d=(""+(l=a[n][1])).match(/^(a|d|s|o|n)/))switch(c=r.sortList[0][1],d[0]){case"d":l=1;break;case"s":l=c;break;case"o":l=0===c?1:0;break;case"n":l=(c+1)%y.length;break;default:l=0}r.sortList[r.sortList.length]=[a[n][0],l],r.sortVars[a[n][0]].sortedBy="sortAppend"}r.$table.triggerHandler("sortBegin",u),setTimeout(function(){t.setHeadersCss(r),t.multisort(r),t.appendCache(r),r.$table.triggerHandler("sortBeforeEnd",u),r.$table.triggerHandler("sortEnd",u)},1)},multisort:function(e){var r,s,o,a,n=e.table,i=[],l=0,d=e.textSorter||"",c=e.sortList,g=c.length,p=e.$tbodies.length;if(!e.serverSideSorting&&!t.isEmptyObject(e.cache)){if(t.debug(e,"core")&&(s=new Date),"object"==typeof d)for(o=e.columns;o--;)"function"==typeof(a=t.getColumnData(n,d,o))&&(i[o]=a);for(r=0;r<p;r++)o=e.cache[r].colMax,e.cache[r].normalized.sort(function(r,s){var a,p,u,f,h,m,b;for(a=0;a<g;a++){if(u=c[a][0],f=c[a][1],l=0===f,e.sortStable&&r[u]===s[u]&&1===g)return r[e.columns].order-s[e.columns].order;if((p=/n/i.test(t.getSortType(e.parsers,u)))&&e.strings[u]?(p="boolean"==typeof t.string[e.strings[u]]?(l?1:-1)*(t.string[e.strings[u]]?-1:1):e.strings[u]&&t.string[e.strings[u]]||0,h=e.numberSorter?e.numberSorter(r[u],s[u],l,o[u],n):t["sortNumeric"+(l?"Asc":"Desc")](r[u],s[u],p,o[u],u,e)):(m=l?r:s,b=l?s:r,h="function"==typeof d?d(m[u],b[u],l,u,n):"function"==typeof i[u]?i[u](m[u],b[u],l,u,n):t["sortNatural"+(l?"Asc":"Desc")](r[u]||"",s[u]||"",u,e)),h)return h}return r[e.columns].order-s[e.columns].order});t.debug(e,"core")&&console.log("Applying sort "+c.toString()+t.benchmark(s))}},resortComplete:function(t,r){t.table.isUpdating&&t.$table.triggerHandler("updateComplete",t.table),e.isFunction(r)&&r(t.table)},checkResort:function(r,s,o){var a=e.isArray(s)?s:r.sortList;!1===(void 0===s?r.resort:s)||r.serverSideSorting||r.table.isProcessing?(t.resortComplete(r,o),t.applyWidget(r.table,!1)):a.length?t.sortOn(r,a,function(){t.resortComplete(r,o)},!0):t.sortReset(r,function(){t.resortComplete(r,o),t.applyWidget(r.table,!1)})},sortOn:function(r,s,o,a){var n,i=r.table;for(r.$table.triggerHandler("sortStart",i),n=0;n<r.columns;n++)r.sortVars[n].sortedBy=t.isValueInArray(n,s)>-1?"sorton":"";t.updateHeaderSortCount(r,s),t.setHeadersCss(r),r.delayInit&&t.isEmptyObject(r.cache)&&t.buildCache(r),r.$table.triggerHandler("sortBegin",i),t.multisort(r),t.appendCache(r,a),r.$table.triggerHandler("sortBeforeEnd",i),r.$table.triggerHandler("sortEnd",i),t.applyWidget(i),e.isFunction(o)&&o(i)},sortReset:function(r,s){var o;for(r.sortList=[],o=0;o<r.columns;o++)r.sortVars[o].count=-1,r.sortVars[o].sortedBy="";t.setHeadersCss(r),t.multisort(r),t.appendCache(r),e.isFunction(s)&&s(r.table)},getSortType:function(e,t){return e&&e[t]&&e[t].type||""},getOrder:function(e){return/^d/i.test(e)||1===e},sortNatural:function(e,r){if(e===r)return 0;e=(e||"").toString(),r=(r||"").toString();var s,o,a,n,i,l,d=t.regex;if(d.hex.test(r)){if((s=parseInt(e.match(d.hex),16))<(o=parseInt(r.match(d.hex),16)))return-1;if(s>o)return 1}for(s=e.replace(d.chunk,"\\0$1\\0").replace(d.chunks,"").split("\\0"),o=r.replace(d.chunk,"\\0$1\\0").replace(d.chunks,"").split("\\0"),l=Math.max(s.length,o.length),i=0;i<l;i++){if(a=isNaN(s[i])?s[i]||0:parseFloat(s[i])||0,n=isNaN(o[i])?o[i]||0:parseFloat(o[i])||0,isNaN(a)!==isNaN(n))return isNaN(a)?1:-1;if(typeof a!=typeof n&&(a+="",n+=""),a<n)return-1;if(a>n)return 1}return 0},sortNaturalAsc:function(e,r,s,o){if(e===r)return 0;var a=t.string[o.empties[s]||o.emptyTo];return""===e&&0!==a?"boolean"==typeof a?a?-1:1:-a||-1:""===r&&0!==a?"boolean"==typeof a?a?1:-1:a||1:t.sortNatural(e,r)},sortNaturalDesc:function(e,r,s,o){if(e===r)return 0;var a=t.string[o.empties[s]||o.emptyTo];return""===e&&0!==a?"boolean"==typeof a?a?-1:1:a||1:""===r&&0!==a?"boolean"==typeof a?a?1:-1:-a||-1:t.sortNatural(r,e)},sortText:function(e,t){return e>t?1:e<t?-1:0},getTextValue:function(e,t,r){if(r){var s,o=e?e.length:0,a=r+t;for(s=0;s<o;s++)a+=e.charCodeAt(s);return t*a}return 0},sortNumericAsc:function(e,r,s,o,a,n){if(e===r)return 0;var i=t.string[n.empties[a]||n.emptyTo];return""===e&&0!==i?"boolean"==typeof i?i?-1:1:-i||-1:""===r&&0!==i?"boolean"==typeof i?i?1:-1:i||1:(isNaN(e)&&(e=t.getTextValue(e,s,o)),isNaN(r)&&(r=t.getTextValue(r,s,o)),e-r)},sortNumericDesc:function(e,r,s,o,a,n){if(e===r)return 0;var i=t.string[n.empties[a]||n.emptyTo];return""===e&&0!==i?"boolean"==typeof i?i?-1:1:i||1:""===r&&0!==i?"boolean"==typeof i?i?1:-1:-i||-1:(isNaN(e)&&(e=t.getTextValue(e,s,o)),isNaN(r)&&(r=t.getTextValue(r,s,o)),r-e)},sortNumeric:function(e,t){return e-t},addWidget:function(e){e.id&&!t.isEmptyObject(t.getWidgetById(e.id))&&console.warn('"'+e.id+'" widget was loaded more than once!'),t.widgets[t.widgets.length]=e},hasWidget:function(t,r){return(t=e(t)).length&&t[0].config&&t[0].config.widgetInit[r]||!1},getWidgetById:function(e){var r,s,o=t.widgets.length;for(r=0;r<o;r++)if((s=t.widgets[r])&&s.id&&s.id.toLowerCase()===e.toLowerCase())return s},applyWidgetOptions:function(r){var s,o,a,n=r.config,i=n.widgets.length;if(i)for(s=0;s<i;s++)(o=t.getWidgetById(n.widgets[s]))&&o.options&&(a=e.extend(!0,{},o.options),n.widgetOptions=e.extend(!0,a,n.widgetOptions),e.extend(!0,t.defaults.widgetOptions,o.options))},addWidgetFromClass:function(e){var r,s,o=e.config,a="^"+o.widgetClass.replace(t.regex.templateName,"(\\S+)+")+"$",n=new RegExp(a,"g"),i=(e.className||"").split(t.regex.spaces);if(i.length)for(r=i.length,s=0;s<r;s++)i[s].match(n)&&(o.widgets[o.widgets.length]=i[s].replace(n,"$1"))},applyWidgetId:function(r,s,o){var a,n,i,l=(r=e(r)[0]).config,d=l.widgetOptions,c=t.debug(l,"core"),g=t.getWidgetById(s);g&&(i=g.id,a=!1,e.inArray(i,l.widgets)<0&&(l.widgets[l.widgets.length]=i),c&&(n=new Date),!o&&l.widgetInit[i]||(l.widgetInit[i]=!0,r.hasInitialized&&t.applyWidgetOptions(r),"function"==typeof g.init&&(a=!0,c&&console[console.group?"group":"log"]("Initializing "+i+" widget"),g.init(r,g,l,d))),o||"function"!=typeof g.format||(a=!0,c&&console[console.group?"group":"log"]("Updating "+i+" widget"),g.format(r,l,d,!1)),c&&a&&(console.log("Completed "+(o?"initializing ":"applying ")+i+" widget"+t.benchmark(n)),console.groupEnd&&console.groupEnd()))},applyWidget:function(r,s,o){var a,n,i,l,d,c=(r=e(r)[0]).config,g=t.debug(c,"core"),p=[];if(!1===s||!r.hasInitialized||!r.isApplyingWidgets&&!r.isUpdating){if(g&&(d=new Date),t.addWidgetFromClass(r),clearTimeout(c.timerReady),c.widgets.length){for(r.isApplyingWidgets=!0,c.widgets=e.grep(c.widgets,function(t,r){return e.inArray(t,c.widgets)===r}),n=(i=c.widgets||[]).length,a=0;a<n;a++)(l=t.getWidgetById(i[a]))&&l.id?(l.priority||(l.priority=10),p[a]=l):g&&console.warn('"'+i[a]+'" was enabled, but the widget code has not been loaded!');for(p.sort(function(e,t){return e.priority<t.priority?-1:e.priority===t.priority?0:1}),n=p.length,g&&console[console.group?"group":"log"]("Start "+(s?"initializing":"applying")+" widgets"),a=0;a<n;a++)(l=p[a])&&l.id&&t.applyWidgetId(r,l.id,s);g&&console.groupEnd&&console.groupEnd()}c.timerReady=setTimeout(function(){r.isApplyingWidgets=!1,e.data(r,"lastWidgetApplication",new Date),c.$table.triggerHandler("tablesorter-ready"),s||"function"!=typeof o||o(r),g&&(l=c.widgets.length,console.log("Completed "+(!0===s?"initializing ":"applying ")+l+" widget"+(1!==l?"s":"")+t.benchmark(d)))},10)}},removeWidget:function(r,s,o){var a,n,i,l,d=(r=e(r)[0]).config;if(!0===s)for(s=[],l=t.widgets.length,i=0;i<l;i++)(n=t.widgets[i])&&n.id&&(s[s.length]=n.id);else s=(e.isArray(s)?s.join(","):s||"").toLowerCase().split(/[\s,]+/);for(l=s.length,a=0;a<l;a++)n=t.getWidgetById(s[a]),(i=e.inArray(s[a],d.widgets))>=0&&!0!==o&&d.widgets.splice(i,1),n&&n.remove&&(t.debug(d,"core")&&console.log((o?"Refreshing":"Removing")+' "'+s[a]+'" widget'),n.remove(r,d,d.widgetOptions,o),d.widgetInit[s[a]]=!1);d.$table.triggerHandler("widgetRemoveEnd",r)},refreshWidgets:function(r,s,o){var a,n,i=(r=e(r)[0]).config.widgets,l=t.widgets,d=l.length,c=[],g=function(t){e(t).triggerHandler("refreshComplete")};for(a=0;a<d;a++)(n=l[a])&&n.id&&(s||e.inArray(n.id,i)<0)&&(c[c.length]=n.id);t.removeWidget(r,c.join(","),!0),!0!==o?(t.applyWidget(r,s||!1,g),s&&t.applyWidget(r,!1,g)):g(r)},benchmark:function(e){return" ("+((new Date).getTime()-e.getTime())+" ms)"},log:function(){console.log(arguments)},debug:function(e,t){return e&&(!0===e.debug||"string"==typeof e.debug&&e.debug.indexOf(t)>-1)},isEmptyObject:function(e){for(var t in e)return!1;return!0},isValueInArray:function(e,t){var r,s=t&&t.length||0;for(r=0;r<s;r++)if(t[r][0]===e)return r;return-1},formatFloat:function(r,s){return"string"!=typeof r||""===r?r:(r=(s&&s.config?!1!==s.config.usNumberFormat:void 0===s||s)?r.replace(t.regex.comma,""):r.replace(t.regex.digitNonUS,"").replace(t.regex.comma,"."),t.regex.digitNegativeTest.test(r)&&(r=r.replace(t.regex.digitNegativeReplace,"-$1")),o=parseFloat(r),isNaN(o)?e.trim(r):o);var o},isDigit:function(e){return isNaN(e)?t.regex.digitTest.test(e.toString().replace(t.regex.digitReplace,"")):""!==e},computeColumnIndex:function(r,s){var o,a,n,i,l,d,c,g,p,u,f=s&&s.columns||0,h=[],m=new Array(f);for(o=0;o<r.length;o++)for(d=r[o].cells,a=0;a<d.length;a++){for(c=o,g=(l=d[a]).rowSpan||1,p=l.colSpan||1,void 0===h[c]&&(h[c]=[]),n=0;n<h[c].length+1;n++)if(void 0===h[c][n]){u=n;break}for(f&&l.cellIndex===u||(l.setAttribute?l.setAttribute("data-column",u):e(l).attr("data-column",u)),n=c;n<c+g;n++)for(void 0===h[n]&&(h[n]=[]),m=h[n],i=u;i<u+p;i++)m[i]="x"}return t.checkColumnCount(r,h,m.length),m.length},checkColumnCount:function(e,t,r){var s,o,a=!0,n=[];for(s=0;s<t.length;s++)if(t[s]&&(o=t[s].length,t[s].length!==r)){a=!1;break}a||(e.each(function(e,t){var r=t.parentElement.nodeName;n.indexOf(r)<0&&n.push(r)}),console.error("Invalid or incorrect number of columns in the "+n.join(" or ")+"; expected "+r+", but found "+o+" columns"))},fixColumnWidth:function(r){var s,o,a,n,i,l=(r=e(r)[0]).config,d=l.$table.children("colgroup");if(d.length&&d.hasClass(t.css.colgroup)&&d.remove(),l.widthFixed&&0===l.$table.children("colgroup").length){for(d=e('<colgroup class="'+t.css.colgroup+'">'),s=l.$table.width(),n=(a=l.$tbodies.find("tr:first").children(":visible")).length,i=0;i<n;i++)o=parseInt(a.eq(i).width()/s*1e3,10)/10+"%",d.append(e("<col>").css("width",o));l.$table.prepend(d)}},getData:function(t,r,s){var o,a,n="",i=e(t);return i.length?(o=!!e.metadata&&i.metadata(),a=" "+(i.attr("class")||""),void 0!==i.data(s)||void 0!==i.data(s.toLowerCase())?n+=i.data(s)||i.data(s.toLowerCase()):o&&void 0!==o[s]?n+=o[s]:r&&void 0!==r[s]?n+=r[s]:" "!==a&&a.match(" "+s+"-")&&(n=a.match(new RegExp("\\s"+s+"-([\\w-]+)"))[1]||""),e.trim(n)):""},getColumnData:function(t,r,s,o,a){if("object"!=typeof r||null===r)return r;var n,i=(t=e(t)[0]).config,l=a||i.$headers,d=i.$headerIndexed&&i.$headerIndexed[s]||l.find('[data-column="'+s+'"]:last');if(void 0!==r[s])return o?r[s]:r[l.index(d)];for(n in r)if("string"==typeof n&&d.filter(n).add(d.find(n)).length)return r[n]},isProcessing:function(r,s,o){var a=(r=e(r))[0].config,n=o||r.find("."+t.css.header);s?(void 0!==o&&a.sortList.length>0&&(n=n.filter(function(){return!this.sortDisabled&&t.isValueInArray(parseFloat(e(this).attr("data-column")),a.sortList)>=0})),r.add(n).addClass(t.css.processing+" "+a.cssProcessing)):r.add(n).removeClass(t.css.processing+" "+a.cssProcessing)},processTbody:function(t,r,s){if(t=e(t)[0],s)return t.isProcessing=!0,r.before('<colgroup class="tablesorter-savemyplace"/>'),e.fn.detach?r.detach():r.remove();var o=e(t).find("colgroup.tablesorter-savemyplace");r.insertAfter(o),o.remove(),t.isProcessing=!1},clearTableBody:function(t){e(t)[0].config.$tbodies.children().detach()},characterEquivalents:{a:"áàâãäąå",A:"ÁÀÂÃÄĄÅ",c:"çćč",C:"ÇĆČ",e:"éèêëěę",E:"ÉÈÊËĚĘ",i:"íìİîïı",I:"ÍÌİÎÏ",o:"óòôõöō",O:"ÓÒÔÕÖŌ",ss:"ß",SS:"ẞ",u:"úùûüů",U:"ÚÙÛÜŮ"},replaceAccents:function(e){var r,s="[",o=t.characterEquivalents;if(!t.characterRegex){for(r in t.characterRegexArray={},o)"string"==typeof r&&(s+=o[r],t.characterRegexArray[r]=new RegExp("["+o[r]+"]","g"));t.characterRegex=new RegExp(s+"]")}if(t.characterRegex.test(e))for(r in o)"string"==typeof r&&(e=e.replace(t.characterRegexArray[r],r));return e},validateOptions:function(r){var s,o,a,n,i="headers sortForce sortList sortAppend widgets".split(" "),l=r.originalSettings;if(l){for(s in t.debug(r,"core")&&(n=new Date),l)if("undefined"===(a=typeof t.defaults[s]))console.warn('Tablesorter Warning! "table.config.'+s+'" option not recognized');else if("object"===a)for(o in l[s])a=t.defaults[s]&&typeof t.defaults[s][o],e.inArray(s,i)<0&&"undefined"===a&&console.warn('Tablesorter Warning! "table.config.'+s+"."+o+'" option not recognized');t.debug(r,"core")&&console.log("validate options time:"+t.benchmark(n))}},restoreHeaders:function(r){var s,o,a=e(r)[0].config,n=a.$table.find(a.selectorHeaders),i=n.length;for(s=0;s<i;s++)(o=n.eq(s)).find("."+t.css.headerIn).length&&o.html(a.headerContent[s])},destroy:function(r,s,o){if((r=e(r)[0]).hasInitialized){t.removeWidget(r,!0,!1);var a,n=e(r),i=r.config,l=n.find("thead:first"),d=l.find("tr."+t.css.headerRow).removeClass(t.css.headerRow+" "+i.cssHeaderRow),c=n.find("tfoot:first > tr").children("th, td");!1===s&&e.inArray("uitheme",i.widgets)>=0&&(n.triggerHandler("applyWidgetId",["uitheme"]),n.triggerHandler("applyWidgetId",["zebra"])),l.find("tr").not(d).remove(),a="sortReset update updateRows updateAll updateHeaders updateCell addRows updateComplete sorton appendCache updateCache applyWidgetId applyWidgets refreshWidgets removeWidget destroy mouseup mouseleave "+"keypress sortBegin sortEnd resetToLoadState ".split(" ").join(i.namespace+" "),n.removeData("tablesorter").unbind(a.replace(t.regex.spaces," ")),i.$headers.add(c).removeClass([t.css.header,i.cssHeader,i.cssAsc,i.cssDesc,t.css.sortAsc,t.css.sortDesc,t.css.sortNone].join(" ")).removeAttr("data-column").removeAttr("aria-label").attr("aria-disabled","true"),d.find(i.selectorSort).unbind("mousedown mouseup keypress ".split(" ").join(i.namespace+" ").replace(t.regex.spaces," ")),t.restoreHeaders(r),n.toggleClass(t.css.table+" "+i.tableClass+" tablesorter-"+i.theme,!1===s),n.removeClass(i.namespace.slice(1)),r.hasInitialized=!1,delete r.config.cache,"function"==typeof o&&o(r),t.debug(i,"core")&&console.log("tablesorter has been removed")}}};e.fn.tablesorter=function(r){return this.each(function(){var s=e.extend(!0,{},t.defaults,r,t.instanceMethods);s.originalSettings=r,!this.hasInitialized&&t.buildTable&&"TABLE"!==this.nodeName?t.buildTable(this,s):t.setup(this,s)})},window.console&&window.console.log||(t.logs=[],console={},console.log=console.warn=console.error=console.table=function(){var e=arguments.length>1?arguments:arguments[0];t.logs[t.logs.length]={date:Date.now(),log:e}}),t.addParser({id:"no-parser",is:function(){return!1},format:function(){return""},type:"text"}),t.addParser({id:"text",is:function(){return!0},format:function(r,s){var o=s.config;return r&&(r=e.trim(o.ignoreCase?r.toLocaleLowerCase():r),r=o.sortLocaleCompare?t.replaceAccents(r):r),r},type:"text"}),t.regex.nondigit=/[^\w,. \-()]/g,t.addParser({id:"digit",is:function(e){return t.isDigit(e)},format:function(r,s){var o=t.formatFloat((r||"").replace(t.regex.nondigit,""),s);return r&&"number"==typeof o?o:r?e.trim(r&&s.config.ignoreCase?r.toLocaleLowerCase():r):r},type:"numeric"}),t.regex.currencyReplace=/[+\-,. ]/g,t.regex.currencyTest=/^\(?\d+[\u00a3$\u20ac\u00a4\u00a5\u00a2?.]|[\u00a3$\u20ac\u00a4\u00a5\u00a2?.]\d+\)?$/,t.addParser({id:"currency",is:function(e){return e=(e||"").replace(t.regex.currencyReplace,""),t.regex.currencyTest.test(e)},format:function(r,s){var o=t.formatFloat((r||"").replace(t.regex.nondigit,""),s);return r&&"number"==typeof o?o:r?e.trim(r&&s.config.ignoreCase?r.toLocaleLowerCase():r):r},type:"numeric"}),t.regex.urlProtocolTest=/^(https?|ftp|file):\/\//,t.regex.urlProtocolReplace=/(https?|ftp|file):\/\/(www\.)?/,t.addParser({id:"url",is:function(e){return t.regex.urlProtocolTest.test(e)},format:function(r){return r?e.trim(r.replace(t.regex.urlProtocolReplace,"")):r},type:"text"}),t.regex.dash=/-/g,t.regex.isoDate=/^\d{4}[\/\-]\d{1,2}[\/\-]\d{1,2}/,t.addParser({id:"isoDate",is:function(e){return t.regex.isoDate.test(e)},format:function(e){var r=e?new Date(e.replace(t.regex.dash,"/")):e;return r instanceof Date&&isFinite(r)?r.getTime():e},type:"numeric"}),t.regex.percent=/%/g,t.regex.percentTest=/(\d\s*?%|%\s*?\d)/,t.addParser({id:"percent",is:function(e){return t.regex.percentTest.test(e)&&e.length<15},format:function(e,r){return e?t.formatFloat(e.replace(t.regex.percent,""),r):e},type:"numeric"}),t.addParser({id:"image",is:function(e,t,r,s){return s.find("img").length>0},format:function(t,r,s){return e(s).find("img").attr(r.config.imgAttr||"alt")||t},parsed:!0,type:"text"}),t.regex.dateReplace=/(\S)([AP]M)$/i,t.regex.usLongDateTest1=/^[A-Z]{3,10}\.?\s+\d{1,2},?\s+(\d{4})(\s+\d{1,2}:\d{2}(:\d{2})?(\s+[AP]M)?)?$/i,t.regex.usLongDateTest2=/^\d{1,2}\s+[A-Z]{3,10}\s+\d{4}/i,t.addParser({id:"usLongDate",is:function(e){return t.regex.usLongDateTest1.test(e)||t.regex.usLongDateTest2.test(e)},format:function(e){var r=e?new Date(e.replace(t.regex.dateReplace,"$1 $2")):e;return r instanceof Date&&isFinite(r)?r.getTime():e},type:"numeric"}),t.regex.shortDateTest=/(^\d{1,2}[\/\s]\d{1,2}[\/\s]\d{4})|(^\d{4}[\/\s]\d{1,2}[\/\s]\d{1,2})/,t.regex.shortDateReplace=/[\-.,]/g,t.regex.shortDateXXY=/(\d{1,2})[\/\s](\d{1,2})[\/\s](\d{4})/,t.regex.shortDateYMD=/(\d{4})[\/\s](\d{1,2})[\/\s](\d{1,2})/,t.convertFormat=function(e,r){e=(e||"").replace(t.regex.spaces," ").replace(t.regex.shortDateReplace,"/"),"mmddyyyy"===r?e=e.replace(t.regex.shortDateXXY,"$3/$1/$2"):"ddmmyyyy"===r?e=e.replace(t.regex.shortDateXXY,"$3/$2/$1"):"yyyymmdd"===r&&(e=e.replace(t.regex.shortDateYMD,"$1/$2/$3"));var s=new Date(e);return s instanceof Date&&isFinite(s)?s.getTime():""},t.addParser({id:"shortDate",is:function(e){return e=(e||"").replace(t.regex.spaces," ").replace(t.regex.shortDateReplace,"/"),t.regex.shortDateTest.test(e)},format:function(e,r,s,o){if(e){var a=r.config,n=a.$headerIndexed[o],i=n.length&&n.data("dateFormat")||t.getData(n,t.getColumnData(r,a.headers,o),"dateFormat")||a.dateFormat;return n.length&&n.data("dateFormat",i),t.convertFormat(e,i)||e}return e},type:"numeric"}),t.regex.timeTest=/^(0?[1-9]|1[0-2]):([0-5]\d)(\s[AP]M)$|^((?:[01]\d|[2][0-4]):[0-5]\d)$/i,t.regex.timeMatch=/(0?[1-9]|1[0-2]):([0-5]\d)(\s[AP]M)|((?:[01]\d|[2][0-4]):[0-5]\d)/i,t.addParser({id:"time",is:function(e){return t.regex.timeTest.test(e)},format:function(e){var r=(e||"").match(t.regex.timeMatch),s=new Date(e),o=e&&(null!==r?r[0]:"00:00 AM"),a=o?new Date("2000/01/01 "+o.replace(t.regex.dateReplace,"$1 $2")):o;return a instanceof Date&&isFinite(a)?(s instanceof Date&&isFinite(s)?s.getTime():0)?parseFloat(a.getTime()+"."+s.getTime()):a.getTime():e},type:"numeric"}),t.addParser({id:"metadata",is:function(){return!1},format:function(t,r,s){var o=r.config,a=o.parserMetadataName?o.parserMetadataName:"sortValue";return e(s).metadata()[a]},type:"numeric"}),t.addWidget({id:"zebra",priority:90,format:function(t,r,s){var o,a,n,i,l,d,c,g=new RegExp(r.cssChildRow,"i"),p=r.$tbodies.add(e(r.namespace+"_extra_table").children("tbody:not(."+r.cssInfoBlock+")"));for(l=0;l<p.length;l++)for(n=0,c=(o=p.eq(l).children("tr:visible").not(r.selectorRemove)).length,d=0;d<c;d++)a=o.eq(d),g.test(a[0].className)||n++,i=n%2==0,a.removeClass(s.zebra[i?1:0]).addClass(s.zebra[i?0:1])},remove:function(e,r,s,o){if(!o){var a,n,i=r.$tbodies,l=(s.zebra||["even","odd"]).join(" ");for(a=0;a<i.length;a++)(n=t.processTbody(e,i.eq(a),!0)).children().removeClass(l),t.processTbody(e,n,!1)}}})}(jQuery);
