/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.jconsole;

import com.sun.tools.jconsole.JConsoleContext;
import com.sun.tools.jconsole.JConsolePlugin;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.plaf.TabbedPaneUI;
import sun.tools.jconsole.ClassTab;
import sun.tools.jconsole.ExceptionSafePlugin;
import sun.tools.jconsole.JConsole;
import sun.tools.jconsole.MBeansTab;
import sun.tools.jconsole.MemoryTab;
import sun.tools.jconsole.Messages;
import sun.tools.jconsole.OverviewTab;
import sun.tools.jconsole.ProxyClient;
import sun.tools.jconsole.Resources;
import sun.tools.jconsole.SheetDialog;
import sun.tools.jconsole.SummaryTab;
import sun.tools.jconsole.Tab;
import sun.tools.jconsole.ThreadTab;
import sun.tools.jconsole.Utilities;
import sun.tools.jconsole.VMInternalFrame;

public class VMPanel
extends JTabbedPane
implements PropertyChangeListener {
    private ProxyClient proxyClient;
    private Timer timer;
    private int updateInterval;
    private String hostName;
    private int port;
    private String userName;
    private String password;
    private String url;
    private VMInternalFrame vmIF = null;
    private static ArrayList<TabInfo> tabInfos = new ArrayList();
    private boolean wasConnected = false;
    private boolean userDisconnected = false;
    private boolean shouldUseSSL = true;
    private boolean everConnected = false;
    private boolean initialUpdate = true;
    private Map<ExceptionSafePlugin, SwingWorker<?, ?>> plugins = null;
    private boolean pluginTabsAdded = false;
    private JOptionPane optionPane;
    private JProgressBar progressBar;
    private long time0;
    private static Icon connectedIcon16;
    private static Icon connectedIcon24;
    private static Icon disconnectedIcon16;
    private static Icon disconnectedIcon24;
    private Rectangle connectedIconBounds;
    private Object lockObject = new Object();

    public static TabInfo[] getTabInfos() {
        return tabInfos.toArray(new TabInfo[tabInfos.size()]);
    }

    VMPanel(ProxyClient proxyClient, int updateInterval) {
        this.proxyClient = proxyClient;
        this.updateInterval = updateInterval;
        this.hostName = proxyClient.getHostName();
        this.port = proxyClient.getPort();
        this.userName = proxyClient.getUserName();
        this.password = proxyClient.getPassword();
        this.url = proxyClient.getUrl();
        for (TabInfo tabInfo : tabInfos) {
            if (!tabInfo.tabVisible) continue;
            this.addTab(tabInfo);
        }
        this.plugins = new LinkedHashMap();
        for (JConsolePlugin p : JConsole.getPlugins()) {
            p.setContext(proxyClient);
            this.plugins.put(new ExceptionSafePlugin(p), null);
        }
        Utilities.updateTransparency(this);
        ToolTipManager.sharedInstance().registerComponent(this);
        proxyClient.addPropertyChangeListener(this);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (VMPanel.this.connectedIconBounds != null && (e.getModifiers() & 0x10) != 0 && VMPanel.this.connectedIconBounds.contains(e.getPoint())) {
                    if (VMPanel.this.isConnected()) {
                        VMPanel.this.userDisconnected = true;
                        VMPanel.this.disconnect();
                        VMPanel.this.wasConnected = false;
                    } else {
                        VMPanel.this.connect();
                    }
                    VMPanel.this.repaint();
                }
            }
        });
    }

    @Override
    public void setUI(TabbedPaneUI ui) {
        Insets insets = (Insets)UIManager.getLookAndFeelDefaults().get("TabbedPane.tabAreaInsets");
        if (insets != null) {
            insets = (Insets)insets.clone();
            insets.right += connectedIcon24.getIconWidth() + 8;
            UIManager.put("TabbedPane.tabAreaInsets", insets);
        }
        super.setUI(ui);
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        Component c0 = this.getComponent(0);
        Icon icon = c0 != null && c0.getY() > 24 ? (this.isConnected() ? connectedIcon24 : disconnectedIcon24) : (this.isConnected() ? connectedIcon16 : disconnectedIcon16);
        Insets insets = this.getInsets();
        int x = this.getWidth() - insets.right - icon.getIconWidth() - 4;
        int y = insets.top;
        if (c0 != null) {
            y = (c0.getY() - icon.getIconHeight()) / 2;
        }
        icon.paintIcon(this, g, x, y);
        this.connectedIconBounds = new Rectangle(x, y, icon.getIconWidth(), icon.getIconHeight());
    }

    @Override
    public String getToolTipText(MouseEvent event) {
        if (this.connectedIconBounds.contains(event.getPoint())) {
            if (this.isConnected()) {
                return Messages.CONNECTED_PUNCTUATION_CLICK_TO_DISCONNECT_;
            }
            return Messages.DISCONNECTED_PUNCTUATION_CLICK_TO_CONNECT_;
        }
        return super.getToolTipText(event);
    }

    private synchronized void addTab(TabInfo tabInfo) {
        Tab tab = this.instantiate(tabInfo);
        if (tab != null) {
            this.addTab(tabInfo.name, tab);
        } else {
            tabInfo.tabVisible = false;
        }
    }

    private synchronized void insertTab(TabInfo tabInfo, int index) {
        Tab tab = this.instantiate(tabInfo);
        if (tab != null) {
            this.insertTab(tabInfo.name, null, tab, null, index);
        } else {
            tabInfo.tabVisible = false;
        }
    }

    @Override
    public synchronized void removeTabAt(int index) {
        super.removeTabAt(index);
    }

    private Tab instantiate(TabInfo tabInfo) {
        try {
            Constructor<? extends Tab> con = tabInfo.tabClass.getConstructor(VMPanel.class);
            return con.newInstance(this);
        }
        catch (Exception ex) {
            System.err.println(ex);
            return null;
        }
    }

    boolean isConnected() {
        return this.proxyClient.isConnected();
    }

    public int getUpdateInterval() {
        return this.updateInterval;
    }

    ProxyClient getProxyClient(boolean assertThread) {
        if (assertThread) {
            return this.getProxyClient();
        }
        return this.proxyClient;
    }

    public ProxyClient getProxyClient() {
        String threadClass = Thread.currentThread().getClass().getName();
        if (threadClass.equals("java.awt.EventDispatchThread")) {
            String msg = "Calling VMPanel.getProxyClient() from the Event Dispatch Thread!";
            new RuntimeException(msg).printStackTrace();
            System.exit(1);
        }
        return this.proxyClient;
    }

    public void cleanUp() {
        for (Tab tab : this.getTabs()) {
            tab.dispose();
        }
        for (JConsolePlugin jConsolePlugin : this.plugins.keySet()) {
            jConsolePlugin.dispose();
        }
        if (this.timer != null) {
            this.timer.cancel();
        }
        this.proxyClient.removePropertyChangeListener(this);
    }

    public void connect() {
        if (this.isConnected()) {
            this.createPluginTabs();
            this.fireConnectedChange(true);
            this.initialUpdate = true;
            this.startUpdateTimer();
        } else {
            new Thread("VMPanel.connect"){

                @Override
                public void run() {
                    VMPanel.this.proxyClient.connect(VMPanel.this.shouldUseSSL);
                }
            }.start();
        }
    }

    public void disconnect() {
        this.proxyClient.disconnect();
        this.updateFrameTitle();
    }

    @Override
    public void propertyChange(PropertyChangeEvent ev) {
        String prop = ev.getPropertyName();
        if (prop == "connectionState") {
            JConsoleContext.ConnectionState oldState = (JConsoleContext.ConnectionState)((Object)ev.getOldValue());
            JConsoleContext.ConnectionState newState = (JConsoleContext.ConnectionState)((Object)ev.getNewValue());
            switch (newState) {
                case CONNECTING: {
                    this.onConnecting();
                    break;
                }
                case CONNECTED: {
                    if (this.progressBar != null) {
                        this.progressBar.setIndeterminate(false);
                        this.progressBar.setValue(100);
                    }
                    this.closeOptionPane();
                    this.updateFrameTitle();
                    this.createPluginTabs();
                    this.repaint();
                    this.fireConnectedChange(true);
                    this.initialUpdate = true;
                    this.startUpdateTimer();
                    break;
                }
                case DISCONNECTED: {
                    if (this.progressBar != null) {
                        this.progressBar.setIndeterminate(false);
                        this.progressBar.setValue(0);
                        this.closeOptionPane();
                    }
                    this.vmPanelDied();
                    if (oldState != JConsoleContext.ConnectionState.CONNECTED) break;
                    this.fireConnectedChange(false);
                }
            }
        }
    }

    private void onConnecting() {
        this.time0 = System.currentTimeMillis();
        SwingUtilities.getWindowAncestor(this);
        String connectionName = this.getConnectionName();
        this.progressBar = new JProgressBar();
        this.progressBar.setIndeterminate(true);
        JPanel progressPanel = new JPanel(new FlowLayout(1));
        progressPanel.add(this.progressBar);
        Object[] message = new Object[]{"<html><h3>" + Resources.format(Messages.CONNECTING_TO1, connectionName) + "</h3></html>", progressPanel, "<html><b>" + Resources.format(Messages.CONNECTING_TO2, connectionName) + "</b></html>"};
        this.optionPane = SheetDialog.showOptionDialog(this, message, -1, 1, null, new String[]{Messages.CANCEL}, 0);
    }

    private void closeOptionPane() {
        if (this.optionPane != null) {
            new Thread("VMPanel.sleeper"){

                @Override
                public void run() {
                    long elapsed = System.currentTimeMillis() - VMPanel.this.time0;
                    if (elapsed < 2000L) {
                        try {
                            3.sleep(2000L - elapsed);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            VMPanel.this.optionPane.setVisible(false);
                            VMPanel.this.progressBar = null;
                        }
                    });
                }
            }.start();
        }
    }

    void updateFrameTitle() {
        VMInternalFrame vmIF = this.getFrame();
        if (vmIF != null) {
            String displayName = this.getDisplayName();
            if (!this.proxyClient.isConnected()) {
                displayName = Resources.format(Messages.CONNECTION_NAME__DISCONNECTED_, displayName);
            }
            vmIF.setTitle(displayName);
        }
    }

    private VMInternalFrame getFrame() {
        if (this.vmIF == null) {
            this.vmIF = (VMInternalFrame)SwingUtilities.getAncestorOfClass(VMInternalFrame.class, this);
        }
        return this.vmIF;
    }

    synchronized List<Tab> getTabs() {
        ArrayList<Tab> list = new ArrayList<Tab>();
        int n = this.getTabCount();
        for (int i = 0; i < n; ++i) {
            Component c = this.getComponentAt(i);
            if (!(c instanceof Tab)) continue;
            list.add((Tab)c);
        }
        return list;
    }

    private void startUpdateTimer() {
        if (this.timer != null) {
            this.timer.cancel();
        }
        TimerTask timerTask = new TimerTask(){

            @Override
            public void run() {
                VMPanel.this.update();
            }
        };
        String timerName = "Timer-" + this.getConnectionName();
        this.timer = new Timer(timerName, true);
        this.timer.schedule(timerTask, 0L, (long)this.updateInterval);
    }

    private void vmPanelDied() {
        String buttonStr;
        String msgExplanation;
        String msgTitle;
        this.disconnect();
        if (this.userDisconnected) {
            this.userDisconnected = false;
            return;
        }
        if (this.wasConnected) {
            this.wasConnected = false;
            msgTitle = Messages.CONNECTION_LOST1;
            msgExplanation = Resources.format(Messages.CONNECTING_TO2, this.getConnectionName());
            buttonStr = Messages.RECONNECT;
        } else if (this.shouldUseSSL) {
            msgTitle = Messages.CONNECTION_FAILED_SSL1;
            msgExplanation = Resources.format(Messages.CONNECTION_FAILED_SSL2, this.getConnectionName());
            buttonStr = Messages.INSECURE;
        } else {
            msgTitle = Messages.CONNECTION_FAILED1;
            msgExplanation = Resources.format(Messages.CONNECTION_FAILED2, this.getConnectionName());
            buttonStr = Messages.CONNECT;
        }
        JOptionPane optionPane = SheetDialog.showOptionDialog(this, "<html><h3>" + msgTitle + "</h3><b>" + msgExplanation + "</b>", -1, 2, null, new String[]{buttonStr, Messages.CANCEL}, 0);
        optionPane.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent event) {
                if (event.getPropertyName().equals("value")) {
                    Object value = event.getNewValue();
                    if (value == Messages.RECONNECT || value == Messages.CONNECT) {
                        VMPanel.this.connect();
                    } else if (value == Messages.INSECURE) {
                        VMPanel.this.shouldUseSSL = false;
                        VMPanel.this.connect();
                    } else if (!VMPanel.this.everConnected) {
                        try {
                            VMPanel.this.getFrame().setClosed(true);
                        }
                        catch (PropertyVetoException propertyVetoException) {
                            // empty catch block
                        }
                    }
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void update() {
        Object object = this.lockObject;
        synchronized (object) {
            if (!this.isConnected()) {
                if (this.wasConnected) {
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            VMPanel.this.vmPanelDied();
                        }
                    });
                }
                this.wasConnected = false;
                return;
            }
            this.wasConnected = true;
            this.everConnected = true;
            this.proxyClient.flush();
            List<Tab> tabs = this.getTabs();
            final int n = tabs.size();
            for (int i = 0; i < n; ++i) {
                final int index = i;
                try {
                    if (this.proxyClient.isDead()) continue;
                    tabs.get(index).update();
                    if (!this.initialUpdate) continue;
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            VMPanel.this.setEnabledAt(index, true);
                        }
                    });
                    continue;
                }
                catch (Exception e) {
                    if (!this.initialUpdate) continue;
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            VMPanel.this.setEnabledAt(index, false);
                        }
                    });
                }
            }
            for (ExceptionSafePlugin p : this.plugins.keySet()) {
                SwingWorker<?, ?> sw = p.newSwingWorker();
                SwingWorker<?, ?> prevSW = this.plugins.get(p);
                if (prevSW != null && !prevSW.isDone() || sw != null && sw.getState() != SwingWorker.StateValue.PENDING) continue;
                this.plugins.put(p, sw);
                if (sw == null) continue;
                p.executeSwingWorker(sw);
            }
            if (this.initialUpdate) {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        int index = VMPanel.this.getSelectedIndex();
                        if (index < 0 || !VMPanel.this.isEnabledAt(index)) {
                            for (int i = 0; i < n; ++i) {
                                if (!VMPanel.this.isEnabledAt(i)) continue;
                                VMPanel.this.setSelectedIndex(i);
                                break;
                            }
                        }
                    }
                });
                this.initialUpdate = false;
            }
        }
    }

    public String getHostName() {
        return this.hostName;
    }

    public int getPort() {
        return this.port;
    }

    public String getUserName() {
        return this.userName;
    }

    public String getUrl() {
        return this.url;
    }

    public String getPassword() {
        return this.password;
    }

    public String getConnectionName() {
        return this.proxyClient.connectionName();
    }

    public String getDisplayName() {
        return this.proxyClient.getDisplayName();
    }

    private void createPluginTabs() {
        if (!this.pluginTabsAdded) {
            for (JConsolePlugin jConsolePlugin : this.plugins.keySet()) {
                Map<String, JPanel> tabs = jConsolePlugin.getTabs();
                for (Map.Entry<String, JPanel> e : tabs.entrySet()) {
                    this.addTab(e.getKey(), e.getValue());
                }
            }
            this.pluginTabsAdded = true;
        }
    }

    private void fireConnectedChange(boolean connected) {
        for (Tab tab : this.getTabs()) {
            tab.firePropertyChange("connectionState", !connected, connected);
        }
    }

    static {
        tabInfos.add(new TabInfo(OverviewTab.class, OverviewTab.getTabName(), true));
        tabInfos.add(new TabInfo(MemoryTab.class, MemoryTab.getTabName(), true));
        tabInfos.add(new TabInfo(ThreadTab.class, ThreadTab.getTabName(), true));
        tabInfos.add(new TabInfo(ClassTab.class, ClassTab.getTabName(), true));
        tabInfos.add(new TabInfo(SummaryTab.class, SummaryTab.getTabName(), true));
        tabInfos.add(new TabInfo(MBeansTab.class, MBeansTab.getTabName(), true));
        connectedIcon16 = new ImageIcon(VMPanel.class.getResource("resources/connected16.png"));
        connectedIcon24 = new ImageIcon(VMPanel.class.getResource("resources/connected24.png"));
        disconnectedIcon16 = new ImageIcon(VMPanel.class.getResource("resources/disconnected16.png"));
        disconnectedIcon24 = new ImageIcon(VMPanel.class.getResource("resources/disconnected24.png"));
    }

    static class TabInfo {
        Class<? extends Tab> tabClass;
        String name;
        boolean tabVisible;

        TabInfo(Class<? extends Tab> tabClass, String name, boolean tabVisible) {
            this.tabClass = tabClass;
            this.name = name;
            this.tabVisible = tabVisible;
        }
    }
}

