//Anime4K v3.0 GLSL

// MIT License

// Copyright (c) 2019-2020 bloc97
// All rights reserved.

// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:

// The above copyright notice and this permission notice shall be included in all
// copies or substantial portions of the Software.

// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.

//!DESC Anime4K-v3.0-Upscale(x2)+Denoise-CNN(M)-Conv-4x3x3x1
//!HOOK NATIVE
//!BIND HOOKED
//!WHEN OUTPUT.w NATIVE.w / 1.200 > OUTPUT.h NATIVE.h / 1.200 > *
//!SAVE LUMAN0
//!COMPONENTS 4


vec4 hook() {
	vec2 dp = HOOKED_pt;
	float a = HOOKED_tex(HOOKED_pos + vec2(-dp.x, -dp.y)).x;
	float b = HOOKED_tex(HOOKED_pos + vec2(-dp.x, 0)).x;
	float c = HOOKED_tex(HOOKED_pos + vec2(-dp.x, dp.y)).x;
	float d = HOOKED_tex(HOOKED_pos + vec2(0, -dp.y)).x;
	float e = HOOKED_tex(HOOKED_pos + vec2(0, 0)).x;
	float f = HOOKED_tex(HOOKED_pos + vec2(0, dp.y)).x;
	float g = HOOKED_tex(HOOKED_pos + vec2(dp.x, -dp.y)).x;
	float h = HOOKED_tex(HOOKED_pos + vec2(dp.x, 0)).x;
	float i = HOOKED_tex(HOOKED_pos + vec2(dp.x, dp.y)).x;

	float s = -0.096334584*a + 0.4884673*b + -0.03821645*c + 0.025493674*d + 0.6071791*e + -0.97234*f + 0.099867396*g + -0.20816612*h + 0.08195157*i;
	float o = s+-0.008229233;
	s = 0.0356221*a + -0.8889586*b + -0.041130573*c + 0.15342546*d + 0.8915476*e + -0.12391313*f + -0.069834635*g + -0.04377315*h + 0.080039404*i;
	float p = s+-0.023339543;
	s = 0.47696692*a + -1.1180642*b + 0.09315012*c + 0.6659025*d + -0.06723025*e + 0.020558799*f + -0.03196199*g + -0.003144155*h + -0.005075667*i;
	float q = s+-0.045330495;
	s = -0.035183977*a + 0.00825989*b + -0.07498109*c + 0.109649256*d + 0.5719336*e + -0.1938904*f + -0.137681*g + -0.1617649*h + -0.032986585*i;
	float r = s+-0.019567212;

	return vec4(o, p, q, r);
}


//!DESC Anime4K-v3.0-Upscale(x2)+Denoise-CNN(M)-Conv-4x3x3x8
//!HOOK NATIVE
//!BIND HOOKED
//!WHEN OUTPUT.w NATIVE.w / 1.200 > OUTPUT.h NATIVE.h / 1.200 > *
//!BIND LUMAN0
//!SAVE LUMAN1
//!COMPONENTS 4

#define L_tex LUMAN0_tex

vec4 hook() {
	vec2 dp = HOOKED_pt;
	vec4 a = L_tex(HOOKED_pos + vec2(-dp.x, -dp.y));
	vec4 b = L_tex(HOOKED_pos + vec2(-dp.x, 0));
	vec4 c = L_tex(HOOKED_pos + vec2(-dp.x, dp.y));
	vec4 d = L_tex(HOOKED_pos + vec2(0, -dp.y));
	vec4 e = L_tex(HOOKED_pos + vec2(0, 0));
	vec4 f = L_tex(HOOKED_pos + vec2(0, dp.y));
	vec4 g = L_tex(HOOKED_pos + vec2(dp.x, -dp.y));
	vec4 h = L_tex(HOOKED_pos + vec2(dp.x, 0));
	vec4 i = L_tex(HOOKED_pos + vec2(dp.x, dp.y));
	
	vec4 na = -min(a, 0);
	vec4 nb = -min(b, 0);
	vec4 nc = -min(c, 0);
	vec4 nd = -min(d, 0);
	vec4 ne = -min(e, 0);
	vec4 nf = -min(f, 0);
	vec4 ng = -min(g, 0);
	vec4 nh = -min(h, 0);
	vec4 ni = -min(i, 0);
	
	a = max(a, 0);
	b = max(b, 0);
	c = max(c, 0);
	d = max(d, 0);
	e = max(e, 0);
	f = max(f, 0);
	g = max(g, 0);
	h = max(h, 0);
	i = max(i, 0);
	
	float s = -0.015687061*a.x + -0.005086804*b.x + -0.08009774*c.x + 0.4036132*d.x + -0.55772984*e.x + -0.2755099*f.x + -0.1277555*g.x + 0.48264486*h.x + -0.039350368*i.x;
	float t = -0.1956287*a.y + 0.24631155*b.y + -0.1362055*c.y + -0.017237768*d.y + -0.31328484*e.y + 0.32078618*f.y + 0.17252642*g.y + 1.288781*h.y + 0.6368975*i.y;
	float u = 0.02843324*a.z + -0.18332094*b.z + 0.049802452*c.z + -0.010743182*d.z + 0.17832276*e.z + -0.2522149*f.z + -0.099589445*g.z + 0.37256712*h.z + -0.28898144*i.z;
	float v = 0.30594558*a.w + 0.3486534*b.w + 0.26476768*c.w + -0.076578766*d.w + -0.3232688*e.w + -0.14864787*f.w + -0.6317181*g.w + -0.06437228*h.w + 0.640803*i.w;
	float w = 0.17802098*na.x + 0.05835295*nb.x + -0.058673255*nc.x + -0.014066361*nd.x + 0.33812046*ne.x + 0.25138128*nf.x + -0.072104186*ng.x + -0.36128563*nh.x + 0.07699219*ni.x;
	float x = 0.16941643*na.y + -0.15021013*nb.y + 0.15018505*nc.y + -0.05500566*nd.y + 0.15511088*ne.y + -0.2458257*nf.y + -0.5108843*ng.y + -1.476235*nh.y + -0.71722806*ni.y;
	float y = 0.00975281*na.z + 0.19094622*nb.z + 0.021969974*nc.z + -0.04512019*nd.z + -0.044636417*ne.z + 0.21892478*nf.z + 0.070494205*ng.z + 0.0051582125*nh.z + 0.103034526*ni.z;
	float z = -0.31174728*na.w + -0.52086604*nb.w + -0.13394079*nc.w + 0.19892856*nd.w + 0.36054957*ne.w + 0.09852359*nf.w + 0.51038855*ng.w + -0.1278927*nh.w + -0.4340372*ni.w;
	float o = s+t+u+v+w+x+y+z+0.035186045;
	s = -0.09755112*a.x + 0.007670719*b.x + 0.015862316*c.x + -0.074987575*d.x + 0.15913595*e.x + -0.021152943*f.x + 0.18060294*g.x + 0.022476852*h.x + 0.029400269*i.x;
	t = 0.13646232*a.y + -0.41485998*b.y + 0.017277138*c.y + -0.38909444*d.y + -0.1432292*e.y + 0.15183213*f.y + -0.34036225*g.y + 0.210981*h.y + -0.14121912*i.y;
	u = -0.0792608*a.z + 0.27101266*b.z + 0.009590067*c.z + 0.12913375*d.z + -0.07959797*e.z + -0.048253924*f.z + 0.047642067*g.z + 0.2640562*h.z + 0.11656182*i.z;
	v = -0.059286937*a.w + -0.27622*b.w + -0.042677224*c.w + 0.03761667*d.w + 0.029374314*e.w + -0.099095084*f.w + 0.109775394*g.w + -0.27415258*h.w + 0.07044724*i.w;
	w = 0.24230115*na.x + 0.17628567*nb.x + 0.0020990286*nc.x + 0.96724355*nd.x + 0.02996021*ne.x + 0.019217826*nf.x + 0.1365564*ng.x + 0.071021535*nh.x + -0.06381019*ni.x;
	x = -0.20798545*na.y + 0.34536365*nb.y + -0.02818564*nc.y + 0.18876718*nd.y + 0.15433654*ne.y + -0.18622455*nf.y + 0.11045272*ng.y + -0.2562474*nh.y + 0.04179886*ni.y;
	y = 0.10773426*na.z + -0.28337282*nb.z + -0.08160168*nc.z + -0.06236418*nd.z + 0.312426*ne.z + -0.03483054*nf.z + -0.09783074*ng.z + 0.013053401*nh.z + -0.09047153*ni.z;
	z = 0.12738748*na.w + 0.32590875*nb.w + 0.017520528*nc.w + 0.28071648*nd.w + -0.78307766*ne.w + 0.078845695*nf.w + -0.2234345*ng.w + 0.11153006*nh.w + -0.044529624*ni.w;
	float p = s+t+u+v+w+x+y+z+-0.038306642;
	s = -0.035723098*a.x + -0.68245345*b.x + -0.002786794*c.x + 0.122930825*d.x + 0.62216485*e.x + -0.009912186*f.x + 0.028877307*g.x + -0.16926426*h.x + 0.06577198*i.x;
	t = 0.05365136*a.y + 0.25071046*b.y + -0.098311916*c.y + -0.6723615*d.y + 0.008480647*e.y + 0.12375723*f.y + -0.3281113*g.y + -0.27574605*h.y + -0.6595807*i.y;
	u = -0.13840118*a.z + -0.44505855*b.z + 0.030087678*c.z + 0.2731763*d.z + 0.5879375*e.z + 0.41888592*f.z + -0.26414788*g.z + -0.5527709*h.z + 0.8234306*i.z;
	v = -0.6976394*a.w + 0.1321562*b.w + 0.060074754*c.w + -1.0131954*d.w + 0.7812007*e.w + 0.09399807*f.w + 0.20834799*g.w + -0.25666532*h.w + 0.10436948*i.w;
	w = -0.11991033*na.x + 0.5989035*nb.x + -0.008915402*nc.x + -0.25999224*nd.x + -0.24793556*ne.x + 0.08827613*nf.x + -0.014217819*ng.x + 0.41833654*nh.x + 0.011899245*ni.x;
	x = -0.058299407*na.y + -0.2646685*nb.y + 0.0028501004*nc.y + 0.5013734*nd.y + 0.18170716*ne.y + -0.32118702*nf.y + 0.18985182*ng.y + -0.6646725*nh.y + 0.66861767*ni.y;
	y = 0.09095102*na.z + 0.4223372*nb.z + -0.017415347*nc.z + -0.30837548*nd.z + -0.57201403*ne.z + -0.21062538*nf.z + 0.22605824*ng.z + 0.11097055*nh.z + -0.47204867*ni.z;
	z = 0.77669513*na.w + -0.19212194*nb.w + 0.07572081*nc.w + 0.97353625*nd.w + -0.5117217*ne.w + -0.5606905*nf.w + -0.20132294*ng.w + 0.22203396*nh.w + -0.38304013*ni.w;
	float q = s+t+u+v+w+x+y+z+-0.0053037074;
	s = 0.013148909*a.x + -0.018101854*b.x + -0.02898365*c.x + -0.3221552*d.x + 0.041935045*e.x + -0.09236182*f.x + -0.1982523*g.x + 0.07636514*h.x + 0.011796842*i.x;
	t = -0.011906759*a.y + 0.0047230097*b.y + 0.2781825*c.y + -0.03722119*d.y + -0.18879256*e.y + 0.20578861*f.y + -0.024139037*g.y + 0.12750165*h.y + 0.5047841*i.y;
	u = 0.033963*a.z + 0.027810164*b.z + -0.07853949*c.z + -0.13363425*d.z + 0.030586613*e.z + -0.07423147*f.z + 0.042373702*g.z + 0.0150760105*h.z + -0.26815572*i.z;
	v = -0.25720397*a.w + -0.38199362*b.w + -0.3775784*c.w + -0.14141917*d.w + 0.42101896*e.w + 0.3119284*f.w + 0.37579316*g.w + -0.14884286*h.w + -0.20396978*i.w;
	w = -0.07763323*na.x + -0.2494878*nb.x + -0.05896541*nc.x + 0.06702383*nd.x + -0.1958453*ne.x + 0.10558022*nf.x + 0.23849143*ng.x + -0.027347537*nh.x + -0.092861*ni.x;
	x = 0.059992112*na.y + 0.0670551*nb.y + -0.2532366*nc.y + 0.21315406*nd.y + 0.5451952*ne.y + -0.17559859*nf.y + 0.31270707*ng.y + 1.1990402*nh.y + -0.2656133*ni.y;
	y = -0.06375488*na.z + 0.03755093*nb.z + 0.1775088*nc.z + 0.074394844*nd.z + -0.21401094*ne.z + 0.093671985*nf.z + -0.068302386*ng.z + 0.057559006*nh.z + 0.4602701*ni.z;
	z = 0.07200058*na.w + 0.2625209*nb.w + 0.2245587*nc.w + -0.032449882*nd.w + -0.9196903*ne.w + -0.27814385*nf.w + -0.544985*ng.w + -0.10481027*nh.w + 0.4820764*ni.w;
	float r = s+t+u+v+w+x+y+z+-0.09481775;

	return vec4(o, p, q, r);
}

//!DESC Anime4K-v3.0-Upscale(x2)+Denoise-CNN(M)-Conv-4x3x3x8
//!HOOK NATIVE
//!BIND HOOKED
//!WHEN OUTPUT.w NATIVE.w / 1.200 > OUTPUT.h NATIVE.h / 1.200 > *
//!BIND LUMAN1
//!SAVE LUMAN2
//!COMPONENTS 4

#define L_tex LUMAN1_tex

vec4 hook() {
	vec2 dp = HOOKED_pt;
	vec4 a = L_tex(HOOKED_pos + vec2(-dp.x, -dp.y));
	vec4 b = L_tex(HOOKED_pos + vec2(-dp.x, 0));
	vec4 c = L_tex(HOOKED_pos + vec2(-dp.x, dp.y));
	vec4 d = L_tex(HOOKED_pos + vec2(0, -dp.y));
	vec4 e = L_tex(HOOKED_pos + vec2(0, 0));
	vec4 f = L_tex(HOOKED_pos + vec2(0, dp.y));
	vec4 g = L_tex(HOOKED_pos + vec2(dp.x, -dp.y));
	vec4 h = L_tex(HOOKED_pos + vec2(dp.x, 0));
	vec4 i = L_tex(HOOKED_pos + vec2(dp.x, dp.y));
	
	vec4 na = -min(a, 0);
	vec4 nb = -min(b, 0);
	vec4 nc = -min(c, 0);
	vec4 nd = -min(d, 0);
	vec4 ne = -min(e, 0);
	vec4 nf = -min(f, 0);
	vec4 ng = -min(g, 0);
	vec4 nh = -min(h, 0);
	vec4 ni = -min(i, 0);
	
	a = max(a, 0);
	b = max(b, 0);
	c = max(c, 0);
	d = max(d, 0);
	e = max(e, 0);
	f = max(f, 0);
	g = max(g, 0);
	h = max(h, 0);
	i = max(i, 0);

	float s = 0.018682314*a.x + 0.44203937*b.x + 0.011201117*c.x + 0.1707163*d.x + -0.13163331*e.x + 0.10832957*f.x + -0.25094667*g.x + -0.37710962*h.x + -0.099689476*i.x;
	float t = -0.0066981018*a.y + 0.26694995*b.y + 0.057795994*c.y + 0.045658633*d.y + 0.86929697*e.y + -0.8076145*f.y + 0.048658714*g.y + -0.082118966*h.y + -0.45287862*i.y;
	float u = -0.27032706*a.z + 0.15319459*b.z + -0.18298155*c.z + 0.39646947*d.z + 0.44529167*e.z + -0.03776809*f.z + -0.23567463*g.z + -0.088091925*h.z + -0.060605783*i.z;
	float v = -0.17260903*a.w + 0.29680675*b.w + -0.11133945*c.w + 0.7379717*d.w + 0.57794976*e.w + 0.15571105*f.w + 0.032278296*g.w + -0.45364308*h.w + 0.011278548*i.w;
	float w = 0.23664898*na.x + -0.20770212*nb.x + 0.08866236*nc.x + -0.3988166*nd.x + -0.06265793*ne.x + -0.23789996*nf.x + -0.073015444*ng.x + 0.3039035*nh.x + 0.022692805*ni.x;
	float x = 0.08930171*na.y + -0.58211017*nb.y + -0.1497316*nc.y + -0.476922*nd.y + 0.16330953*ne.y + -0.24215609*nf.y + 0.022338377*ng.y + -0.24107097*nh.y + 0.1570652*ni.y;
	float y = 0.008214529*na.z + 0.16042182*nb.z + -0.14862658*nc.z + -0.3509392*nd.z + -0.9592652*ne.z + -0.24547556*nf.z + 0.3663963*ng.z + 0.72054815*nh.z + 0.29660952*ni.z;
	float z = 0.28773922*na.w + -0.4086489*nb.w + 0.20410532*nc.w + -0.36254752*nd.w + -0.44383284*ne.w + -0.047999498*nf.w + -0.038450666*ng.w + 0.49856558*nh.w + 0.14509656*ni.w;
	float o = s+t+u+v+w+x+y+z+0.047628842;
	s = 0.1842036*a.x + 0.69354624*b.x + 0.2072707*c.x + 0.2558653*d.x + 0.9648104*e.x + 0.51031196*f.x + -0.107327186*g.x + 0.0013468182*h.x + -0.019195512*i.x;
	t = -0.28576428*a.y + -0.42089957*b.y + -0.47228622*c.y + -0.098811954*d.y + -1.2135493*e.y + 0.59586686*f.y + -0.002664521*g.y + -0.3705708*h.y + -0.37632635*i.y;
	u = -0.3551953*a.z + 0.4631558*b.z + -0.49070838*c.z + 0.286012*d.z + -0.3025882*e.z + -0.44014844*f.z + -0.1937611*g.z + 0.3830139*h.z + 0.36162966*i.z;
	v = -0.3278485*a.w + 0.75486267*b.w + 0.43210003*c.w + -0.0147996545*d.w + -0.23216681*e.w + 0.2740509*f.w + 0.042906776*g.w + 0.05781658*h.w + -0.0086696*i.w;
	w = 0.28949758*na.x + 0.90602577*nb.x + 0.5258729*nc.x + 0.03663859*nd.x + -0.5505775*ne.x + -0.29051554*nf.x + -0.076815076*ng.x + 0.19885658*nh.x + -0.087935984*ni.x;
	x = 0.70628744*na.y + -0.22958279*nb.y + 0.08402731*nc.y + 0.15837549*nd.y + 0.39830247*ne.y + 1.1849017*nf.y + 0.35547593*ng.y + -0.202646*nh.y + -0.24137132*ni.y;
	y = 0.08127177*na.z + -0.7835795*nb.z + -0.78620285*nc.z + -0.48470613*nd.z + 0.4768066*ne.z + -0.87363476*nf.z + 0.11905553*ng.z + -0.11505627*nh.z + -0.110398*ni.z;
	z = -0.062861845*na.w + 0.56250936*nb.w + -0.08572646*nc.w + -0.03632719*nd.w + -0.31594795*ne.w + -0.17919087*nf.w + -0.13694055*ng.w + 0.27909452*nh.w + 0.19670367*ni.w;
	float p = s+t+u+v+w+x+y+z+-0.07143907;
	s = 0.05651364*a.x + 0.24637659*b.x + -0.16196722*c.x + 0.25773972*d.x + 0.33928764*e.x + 0.30295405*f.x + 0.25079685*g.x + -0.026224324*h.x + 0.10382699*i.x;
	t = -0.03018759*a.y + -0.32138908*b.y + -0.22939964*c.y + -0.06819758*d.y + 0.60410833*e.y + 0.6038164*f.y + -0.062554374*g.y + -0.22067818*h.y + -0.33446926*i.y;
	u = -0.11069349*a.z + 0.22467056*b.z + -0.22629468*c.z + -0.036879618*d.z + 0.24277517*e.z + 0.013148594*f.z + 0.17209497*g.z + 0.1183592*h.z + -0.018353969*i.z;
	v = -0.0933339*a.w + -0.36371025*b.w + -0.41810217*c.w + 0.065053195*d.w + 0.23782931*e.w + 0.3557887*f.w + 0.011487943*g.w + -0.32776782*h.w + -0.22873801*i.w;
	w = 0.07554202*na.x + -0.09785583*nb.x + 0.39642334*nc.x + -0.14174528*nd.x + 0.40234557*ne.x + 0.10772596*nf.x + -0.100343354*ng.x + 0.3403603*nh.x + 0.08025647*ni.x;
	x = 0.14248708*na.y + -0.16136892*nb.y + 0.52202225*nc.y + -0.26288292*nd.y + -0.7474859*ne.y + -0.7591303*nf.y + 0.16527072*ng.y + 0.2446596*nh.y + -0.1825532*ni.y;
	y = 0.09868614*na.z + -0.10381665*nb.z + -0.25812206*nc.z + -0.08914129*nd.z + -0.5686791*ne.z + -0.9652397*nf.z + -0.30101392*ng.z + -0.4405244*nh.z + -0.17934786*ni.z;
	z = -0.05868854*na.w + 0.6854232*nb.w + -0.17763789*nc.w + -0.2133866*nd.w + 0.0042767767*ne.w + -0.501675*nf.w + -0.23358314*ng.w + 0.032784555*nh.w + 0.060270388*ni.w;
	float q = s+t+u+v+w+x+y+z+0.011247989;
	s = 0.03503288*a.x + 0.2845259*b.x + 0.16413508*c.x + -0.34577143*d.x + 0.44561076*e.x + 0.030196154*f.x + -0.0065472857*g.x + -0.042291068*h.x + 0.06683734*i.x;
	t = 0.059763495*a.y + -0.25460613*b.y + -0.041759964*c.y + 0.11462825*d.y + 0.24414043*e.y + -0.541063*f.y + -0.004890282*g.y + 0.42774653*h.y + -0.07330144*i.y;
	u = 0.019507758*a.z + -0.04953541*b.z + -0.007673771*c.z + -0.6131209*d.z + 0.7618412*e.z + -0.48944667*f.z + -0.00863334*g.z + 0.29244134*h.z + 0.15565501*i.z;
	v = 0.23191626*a.w + -0.18614769*b.w + 0.2090005*c.w + -0.3833056*d.w + -0.3266635*e.w + -0.4969288*f.w + 0.017049763*g.w + 0.0011545217*h.w + 0.037597295*i.w;
	w = -0.09295784*na.x + -0.22808313*nb.x + 0.1440326*nc.x + 0.44798684*nd.x + -0.20869905*ne.x + 0.29082736*nf.x + 0.053629175*ng.x + 0.10080793*nh.x + 0.097120985*ni.x;
	x = -0.21155189*na.y + -0.057156052*nb.y + -0.43517458*nc.y + -0.30298027*nd.y + 0.034714725*ne.y + 2.3735354*nf.y + 0.16829175*ng.y + 0.025805125*nh.y + -0.70330936*ni.y;
	y = 0.012663191*na.z + -0.116386354*nb.z + -0.09403862*nc.z + 0.3583474*nd.z + -0.67109364*ne.z + 1.4337319*nf.z + -0.04739808*ng.z + 0.053359438*nh.z + -0.24203655*ni.z;
	z = -0.24584045*na.w + 0.21607958*nb.w + 0.61612964*nc.w + 0.15417401*nd.w + 0.39434698*ne.w + 0.91960156*nf.w + -0.32311833*ng.w + -0.040789135*nh.w + 0.25973907*ni.w;
	float r = s+t+u+v+w+x+y+z+-0.08489115;
		
	return vec4(o, p, q, r);
}

//!DESC Anime4K-v3.0-Upscale(x2)+Denoise-CNN(M)-Conv-4x3x3x8
//!HOOK NATIVE
//!BIND HOOKED
//!WHEN OUTPUT.w NATIVE.w / 1.200 > OUTPUT.h NATIVE.h / 1.200 > *
//!BIND LUMAN2
//!SAVE LUMAN3
//!COMPONENTS 4

#define L_tex LUMAN2_tex

vec4 hook() {
	vec2 dp = HOOKED_pt;
	vec4 a = L_tex(HOOKED_pos + vec2(-dp.x, -dp.y));
	vec4 b = L_tex(HOOKED_pos + vec2(-dp.x, 0));
	vec4 c = L_tex(HOOKED_pos + vec2(-dp.x, dp.y));
	vec4 d = L_tex(HOOKED_pos + vec2(0, -dp.y));
	vec4 e = L_tex(HOOKED_pos + vec2(0, 0));
	vec4 f = L_tex(HOOKED_pos + vec2(0, dp.y));
	vec4 g = L_tex(HOOKED_pos + vec2(dp.x, -dp.y));
	vec4 h = L_tex(HOOKED_pos + vec2(dp.x, 0));
	vec4 i = L_tex(HOOKED_pos + vec2(dp.x, dp.y));
	
	vec4 na = -min(a, 0);
	vec4 nb = -min(b, 0);
	vec4 nc = -min(c, 0);
	vec4 nd = -min(d, 0);
	vec4 ne = -min(e, 0);
	vec4 nf = -min(f, 0);
	vec4 ng = -min(g, 0);
	vec4 nh = -min(h, 0);
	vec4 ni = -min(i, 0);
	
	a = max(a, 0);
	b = max(b, 0);
	c = max(c, 0);
	d = max(d, 0);
	e = max(e, 0);
	f = max(f, 0);
	g = max(g, 0);
	h = max(h, 0);
	i = max(i, 0);

	float s = -0.11332997*a.x + -0.030096909*b.x + 0.08148866*c.x + -0.010003128*d.x + -0.3719025*e.x + 0.42076835*f.x + -0.054107253*g.x + 0.38734847*h.x + -0.11231825*i.x;
	float t = 0.025680946*a.y + -0.024454257*b.y + 0.014810714*c.y + 0.036770396*d.y + -0.0070939185*e.y + -0.0018907397*f.y + -0.0069138035*g.y + 0.042922944*h.y + -0.026554981*i.y;
	float u = 0.17945814*a.z + 0.013098164*b.z + 0.054402053*c.z + -0.36088273*d.z + 0.2196976*e.z + -0.14696789*f.z + -0.1504518*g.z + -0.07471018*h.z + 0.09389284*i.z;
	float v = -0.03949051*a.w + -0.3112672*b.w + 0.03312816*c.w + -0.15758176*d.w + 0.012970425*e.w + -0.032173485*f.w + 0.0059135878*g.w + -0.018274516*h.w + 0.006665848*i.w;
	float w = 0.060758714*na.x + 0.119630076*nb.x + -0.055826433*nc.x + 0.024306111*nd.x + -0.17980659*ne.x + 0.06985393*nf.x + 0.12661703*ng.x + -0.19770502*nh.x + 0.13595854*ni.x;
	float x = 0.029055506*na.y + -0.12881005*nb.y + 0.036180172*nc.y + 0.08952762*nd.y + 0.043251947*ne.y + 0.0309519*nf.y + -0.027306352*ng.y + 0.090683386*nh.y + 0.02579988*ni.y;
	float y = -0.085502416*na.z + -0.112721406*nb.z + 0.097885445*nc.z + 0.37216458*nd.z + -0.96167123*ne.z + 0.18936911*nf.z + 0.2518813*ng.z + -0.34743145*nh.z + -0.042477675*ni.z;
	float z = -0.1021104*na.w + -0.0024531253*nb.w + -0.05186199*nc.w + -0.10294499*nd.w + -0.40830356*ne.w + 0.08315621*nf.w + -0.16157012*ng.w + -0.21950066*nh.w + -0.1614427*ni.w;
	float o = s+t+u+v+w+x+y+z+-0.002265523;
	s = 0.021600334*a.x + 0.10832676*b.x + -0.024148826*c.x + 0.13570073*d.x + -0.21699049*e.x + -0.06750743*f.x + -0.029798364*g.x + -0.09693352*h.x + 0.0147330705*i.x;
	t = -0.013208378*a.y + -0.048681907*b.y + 0.008304722*c.y + 0.02060466*d.y + 0.060887072*e.y + -0.029299827*f.y + 0.026754655*g.y + -0.021247081*h.y + -0.0038295237*i.y;
	u = -0.03708045*a.z + -0.21871905*b.z + -0.021733213*c.z + -0.2442365*d.z + -0.13438821*e.z + 0.010540137*f.z + 0.0020230296*g.z + 0.03257546*h.z + -0.021659117*i.z;
	v = 0.072284244*a.w + -0.0068167807*b.w + -0.039564237*c.w + 0.08290029*d.w + -0.023164112*e.w + 0.05348939*f.w + 0.0016720649*g.w + 0.012663401*h.w + -0.02184872*i.w;
	w = -0.07998153*na.x + -0.18709537*nb.x + -0.005292238*nc.x + -0.1348702*nd.x + 0.49248907*ne.x + -0.05204193*nf.x + -0.06340117*ng.x + 0.007885183*nh.x + -0.029052222*ni.x;
	x = -0.05064604*na.y + -0.035637096*nb.y + 0.013302106*nc.y + 0.01650534*nd.y + -0.1477934*ne.y + 0.043521415*nf.y + -0.030470217*ng.y + -0.031236814*nh.y + -0.0046578054*ni.y;
	y = 0.07605579*na.z + 0.15499325*nb.z + 0.029893741*nc.z + -0.03078108*nd.z + 0.19679599*ne.z + 0.0116642965*nf.z + 0.024839424*ng.z + 0.055510025*nh.z + 0.0051100547*ni.z;
	z = 0.16119163*na.w + 0.114809826*nb.w + 0.07049681*nc.w + -0.133776*nd.w + 0.32676715*ne.w + -0.048946135*nf.w + 0.030700788*ng.w + 0.009784126*nh.w + 0.08081439*ni.w;
	float p = s+t+u+v+w+x+y+z+-0.008238084;
	s = -0.11814972*a.x + -0.22662362*b.x + -0.32331735*c.x + -0.32201746*d.x + 0.36564782*e.x + 0.4426983*f.x + 0.07923639*g.x + -0.021336399*h.x + 0.20492047*i.x;
	t = 0.023790328*a.y + 0.21819559*b.y + -0.0030968755*c.y + 0.008919413*d.y + -0.05898664*e.y + -0.01876806*f.y + -0.023788428*g.y + 0.3268361*h.y + 0.20320326*i.y;
	u = 0.3627926*a.z + 0.24333648*b.z + 0.36114886*c.z + -0.22440743*d.z + -0.33366778*e.z + -0.2563366*f.z + 0.17747861*g.z + -0.036596447*h.z + -0.14797947*i.z;
	v = 0.044698503*a.w + -0.08930945*b.w + 0.003949861*c.w + 0.06074132*d.w + 0.033413503*e.w + 0.031703018*f.w + -0.12555575*g.w + -0.17760313*h.w + -0.023225365*i.w;
	w = 0.2835165*na.x + 0.5397253*nb.x + 0.43220985*nc.x + 0.21800578*nd.x + -0.49878022*ne.x + -0.14049673*nf.x + 0.0635294*ng.x + -0.061934207*nh.x + -0.09326524*ni.x;
	x = 0.12654181*na.y + 0.17621928*nb.y + -0.008198183*nc.y + 0.104607224*nd.y + -0.33173743*ne.y + -0.09671909*nf.y + 0.048836842*ng.y + -0.33907175*nh.y + -0.106737114*ni.y;
	y = -0.5081512*na.z + -0.380074*nb.z + -0.37692118*nc.z + -0.24946907*nd.z + 0.040042657*ne.z + 0.14976257*nf.z + -0.1887001*ng.z + -0.08455224*nh.z + -0.057611104*ni.z;
	z = -0.64085907*na.w + -0.8459774*nb.w + -0.2510755*nc.w + 0.42802453*nd.w + 0.91313195*ne.w + 0.13899519*nf.w + 0.06350987*ng.w + -0.18764617*nh.w + 0.02081424*ni.w;
	float q = s+t+u+v+w+x+y+z+0.027070472;
	s = 0.085782826*a.x + -0.1726551*b.x + 0.043658435*c.x + -0.19243051*d.x + -0.15005304*e.x + 0.4900343*f.x + -0.10336709*g.x + 0.18312618*h.x + -0.27707884*i.x;
	t = -0.004284496*a.y + 0.037800293*b.y + -0.064419575*c.y + -0.09865947*d.y + 0.080926254*e.y + -0.08812109*f.y + -0.03724518*g.y + -0.3518894*h.y + 0.006982196*i.y;
	u = 0.27069104*a.z + 0.50021005*b.z + 0.36097506*c.z + 0.6951922*d.z + -0.037900347*e.z + 0.2528657*f.z + 0.05860036*g.z + 0.27981114*h.z + 0.3613525*i.z;
	v = -0.05924939*a.w + -0.22080211*b.w + 0.09578901*c.w + -0.10867603*d.w + -0.5372019*e.w + -0.35316542*f.w + 0.10804751*g.w + 0.15515941*h.w + -0.0054505514*i.w;
	w = 0.010304433*na.x + 0.1640876*nb.x + -0.17266113*nc.x + 0.21446994*nd.x + 0.23574792*ne.x + 0.5137865*nf.x + 0.21062104*ng.x + 0.17340744*nh.x + 0.15868759*ni.x;
	x = 0.06865077*na.y + 0.04066122*nb.y + 0.07871106*nc.y + 0.04974146*nd.y + 0.24277933*ne.y + -0.13853991*nf.y + -0.0046235975*ng.y + 0.3110683*nh.y + -0.055814896*ni.y;
	y = 0.18448246*na.z + 0.23644273*nb.z + 0.1740395*nc.z + 0.056280363*nd.z + 0.321761*ne.z + 0.3599845*nf.z + 0.049847838*ng.z + 0.12761155*nh.z + 0.25527006*ni.z;
	z = -0.40113544*na.w + -0.5755716*nb.w + -0.45964563*nc.w + -0.47008777*nd.w + -0.5389698*ne.w + 0.04141921*nf.w + -0.35219887*ng.w + -0.5849454*nh.w + -0.5195555*ni.w;
	float r = s+t+u+v+w+x+y+z+0.04324416;
		
	return vec4(o, p, q, r);
}

//!DESC Anime4K-v3.0-Upscale(x2)+Denoise-CNN(M)-Conv-4x3x3x8
//!HOOK NATIVE
//!BIND HOOKED
//!WHEN OUTPUT.w NATIVE.w / 1.200 > OUTPUT.h NATIVE.h / 1.200 > *
//!BIND LUMAN3
//!SAVE LUMAN4
//!COMPONENTS 4

#define L_tex LUMAN3_tex

vec4 hook() {
	vec2 dp = HOOKED_pt;
	vec4 a = L_tex(HOOKED_pos + vec2(-dp.x, -dp.y));
	vec4 b = L_tex(HOOKED_pos + vec2(-dp.x, 0));
	vec4 c = L_tex(HOOKED_pos + vec2(-dp.x, dp.y));
	vec4 d = L_tex(HOOKED_pos + vec2(0, -dp.y));
	vec4 e = L_tex(HOOKED_pos + vec2(0, 0));
	vec4 f = L_tex(HOOKED_pos + vec2(0, dp.y));
	vec4 g = L_tex(HOOKED_pos + vec2(dp.x, -dp.y));
	vec4 h = L_tex(HOOKED_pos + vec2(dp.x, 0));
	vec4 i = L_tex(HOOKED_pos + vec2(dp.x, dp.y));
	
	vec4 na = -min(a, 0);
	vec4 nb = -min(b, 0);
	vec4 nc = -min(c, 0);
	vec4 nd = -min(d, 0);
	vec4 ne = -min(e, 0);
	vec4 nf = -min(f, 0);
	vec4 ng = -min(g, 0);
	vec4 nh = -min(h, 0);
	vec4 ni = -min(i, 0);
	
	a = max(a, 0);
	b = max(b, 0);
	c = max(c, 0);
	d = max(d, 0);
	e = max(e, 0);
	f = max(f, 0);
	g = max(g, 0);
	h = max(h, 0);
	i = max(i, 0);
	
	float s = -0.11336011*a.x + -0.5546093*b.x + -0.1980563*c.x + -0.09243965*d.x + -0.30328315*e.x + 0.002288521*f.x + -0.1719883*g.x + -0.25393653*h.x + -0.106638394*i.x;
	float t = 0.060408574*a.y + -0.4343821*b.y + -0.09417895*c.y + 0.04474836*d.y + 0.66423136*e.y + -0.16684487*f.y + -0.046044365*g.y + 0.1707526*h.y + 0.13041699*i.y;
	float u = -0.062083997*a.z + 0.036378354*b.z + -0.053244796*c.z + -0.07462912*d.z + 0.009707783*e.z + -0.007606468*f.z + -0.14536221*g.z + 0.12193374*h.z + 0.08321257*i.z;
	float v = 0.13822994*a.w + -0.16968055*b.w + -0.029302116*c.w + -0.36366686*d.w + 0.12202857*e.w + -0.04416427*f.w + -0.101989016*g.w + 0.0015375882*h.w + 0.05370286*i.w;
	float w = 0.009522841*na.x + 0.0050035953*nb.x + 0.047815464*nc.x + 0.13878924*nd.x + -0.12706435*ne.x + -0.17028658*nf.x + 0.03381212*ng.x + 0.04619007*nh.x + 0.040886693*ni.x;
	float x = -0.21648684*na.y + 0.4527824*nb.y + 0.062216494*nc.y + -0.0760834*nd.y + -0.6288988*ne.y + -0.07717104*nf.y + 0.031264722*ng.y + -0.1372035*nh.y + -0.24431548*ni.y;
	float y = 0.12201707*na.z + 0.1075342*nb.z + 0.064964525*nc.z + 0.24627735*nd.z + -0.20334174*ne.z + 0.17362922*nf.z + 0.14341247*ng.z + -0.10367405*nh.z + 0.018187301*ni.z;
	float z = 0.29656824*na.w + 0.36550194*nb.w + 0.08121883*nc.w + 0.5109051*nd.w + 0.15495986*ne.w + 0.14060786*nf.w + 0.16695265*ng.w + 0.08530239*nh.w + -0.012310244*ni.w;
	float o = s+t+u+v+w+x+y+z+-0.016565753;
	s = -0.005542627*a.x + -0.4815576*b.x + -0.16739582*c.x + -0.17829932*d.x + 0.16477403*e.x + -0.13324437*f.x + -0.18502134*g.x + -0.29108498*h.x + 0.05097406*i.x;
	t = -0.005128074*a.y + 0.07065858*b.y + -0.10661442*c.y + 0.0008864973*d.y + 0.10546469*e.y + 0.014007102*f.y + -0.008473495*g.y + 0.10157764*h.y + 0.08799642*i.y;
	u = 0.032889523*a.z + 0.031691857*b.z + 0.012797057*c.z + -0.047379013*d.z + 0.035736393*e.z + 0.091394894*f.z + 0.039340183*g.z + 0.02964313*h.z + 0.0028917622*i.z;
	v = -0.02029337*a.w + 0.094220296*b.w + -0.069206014*c.w + 0.07011055*d.w + -0.14635274*e.w + 0.026304023*f.w + -0.0646385*g.w + 0.041667704*h.w + 0.042158034*i.w;
	w = 0.04289771*na.x + -0.011802231*nb.x + -0.03529944*nc.x + 0.03370418*nd.x + -0.5103195*ne.x + -0.014530308*nf.x + 0.029903982*ng.x + 0.029009927*nh.x + 0.03932113*ni.x;
	x = -0.058687404*na.y + -0.032492165*nb.y + 0.039978307*nc.y + 0.0805997*nd.y + 0.16392574*ne.y + -0.26796678*nf.y + 0.05706328*ng.y + -0.026416704*nh.y + -0.009198004*ni.y;
	y = 0.036424693*na.z + 0.076260746*nb.z + 0.039109852*nc.z + 0.06012574*nd.z + 0.029961608*ne.z + 0.000601677*nf.z + 0.08278338*ng.z + -0.104361504*nh.z + -0.010410115*ni.z;
	z = 0.045120504*na.w + 0.15542893*nb.w + 0.018970646*nc.w + -0.040475003*nd.w + 0.41810912*ne.w + 0.046625525*nf.w + 0.11266217*ng.w + 0.03605587*nh.w + 0.010441441*ni.w;
	float p = s+t+u+v+w+x+y+z+0.026173912;
	s = -0.01932058*a.x + -0.15786819*b.x + 0.34817162*c.x + -0.085794635*d.x + 0.61148757*e.x + 0.1997698*f.x + 0.04283192*g.x + -0.40659058*h.x + 0.031031879*i.x;
	t = -0.14110667*a.y + 0.09737822*b.y + 0.2136361*c.y + 0.21648659*d.y + 0.057102222*e.y + -0.32274124*f.y + -0.041056994*g.y + 0.062500246*h.y + 0.058675725*i.y;
	u = -0.05310352*a.z + 0.06363739*b.z + -0.02352861*c.z + -0.19859853*d.z + -0.6924276*e.z + -0.052719172*f.z + -0.022153398*g.z + 0.022755368*h.z + 0.044493068*i.z;
	v = -0.020281073*a.w + 0.049738068*b.w + 0.05115416*c.w + 0.1943825*d.w + -0.15483907*e.w + -0.13703728*f.w + -0.21366403*g.w + 0.12213289*h.w + 0.07315763*i.w;
	w = -0.01340149*na.x + 0.039190706*nb.x + -0.06010495*nc.x + -0.031242317*nd.x + -0.3344305*ne.x + -0.15759717*nf.x + 0.035195023*ng.x + 0.09947819*nh.x + 0.06487847*ni.x;
	x = 0.100255184*na.y + 0.16374993*nb.y + -0.26901463*nc.y + -0.088238806*nd.y + 0.9469761*ne.y + 0.20339924*nf.y + 0.013781394*ng.y + -0.40143126*nh.y + -0.3224882*ni.y;
	y = 0.06307512*na.z + 0.103746325*nb.z + 0.07068691*nc.z + 0.21719252*nd.z + 0.643172*ne.z + 0.044743262*nf.z + 0.02847355*ng.z + -0.044767838*nh.z + 0.026216555*ni.z;
	z = -0.04675472*na.w + 0.09125546*nb.w + -0.015525009*nc.w + 0.7057314*nd.w + 0.37025008*ne.w + 0.27427557*nf.w + -0.03265264*ng.w + -0.06721917*nh.w + -0.0419604*ni.w;
	float q = s+t+u+v+w+x+y+z+0.024316467;
	s = -0.00033182523*a.x + 0.047188014*b.x + 0.29892203*c.x + 0.09357643*d.x + 0.030232515*e.x + 0.19758245*f.x + 0.13172227*g.x + -0.12781778*h.x + 0.02373677*i.x;
	t = -0.03755632*a.y + 0.093976915*b.y + 0.070628785*c.y + 0.05336897*d.y + 0.85352725*e.y + -0.10880546*f.y + 0.051450137*g.y + 0.09816019*h.y + 0.07808459*i.y;
	u = 0.011919896*a.z + -0.020400822*b.z + 0.04710827*c.z + 0.08461272*d.z + -0.11439534*e.z + 0.037500232*f.z + 0.113371514*g.z + 0.086692594*h.z + 0.06414449*i.z;
	v = 0.011173226*a.w + 0.049693275*b.w + 0.03778407*c.w + 0.16974896*d.w + 0.30079946*e.w + -0.060604237*f.w + -0.0018831388*g.w + 0.07333319*h.w + 0.014693669*i.w;
	w = -0.11176503*na.x + -0.0652572*nb.x + -0.08387277*nc.x + -0.07379581*nd.x + -0.07855383*ne.x + -0.14641859*nf.x + -0.02941203*ng.x + -0.06744651*nh.x + -0.052957434*ni.x;
	x = 0.03692434*na.y + 0.06360258*nb.y + -0.031729735*nc.y + -0.10867498*nd.y + -0.3276245*ne.y + 0.17300029*nf.y + 0.036537584*ng.y + -0.025287196*nh.y + -0.1810677*ni.y;
	y = 0.006600475*na.z + -0.00840068*nb.z + 0.0028671592*nc.z + -0.14595534*nd.z + 0.20311914*ne.z + -0.023778193*nf.z + -0.05664581*ng.z + 0.09111506*nh.z + -0.051484156*ni.z;
	z = 0.07922705*na.w + -0.011248128*nb.w + 0.011819444*nc.w + -0.11729043*nd.w + -0.28706518*ne.w + 0.07792864*nf.w + -0.013736298*ng.w + -0.15252969*nh.w + 0.0014625692*ni.w;
	float r = s+t+u+v+w+x+y+z+-0.017528493;
		
	return vec4(o, p, q, r);
}
//!DESC Anime4K-v3.0-Upscale(x2)+Denoise-CNN(M)-Conv-4x3x3x8
//!HOOK NATIVE
//!BIND HOOKED
//!WHEN OUTPUT.w NATIVE.w / 1.200 > OUTPUT.h NATIVE.h / 1.200 > *
//!BIND LUMAN4
//!SAVE LUMAN5
//!COMPONENTS 4

#define L_tex LUMAN4_tex

vec4 hook() {
	vec2 dp = HOOKED_pt;
	vec4 a = L_tex(HOOKED_pos + vec2(-dp.x, -dp.y));
	vec4 b = L_tex(HOOKED_pos + vec2(-dp.x, 0));
	vec4 c = L_tex(HOOKED_pos + vec2(-dp.x, dp.y));
	vec4 d = L_tex(HOOKED_pos + vec2(0, -dp.y));
	vec4 e = L_tex(HOOKED_pos + vec2(0, 0));
	vec4 f = L_tex(HOOKED_pos + vec2(0, dp.y));
	vec4 g = L_tex(HOOKED_pos + vec2(dp.x, -dp.y));
	vec4 h = L_tex(HOOKED_pos + vec2(dp.x, 0));
	vec4 i = L_tex(HOOKED_pos + vec2(dp.x, dp.y));
	
	vec4 na = -min(a, 0);
	vec4 nb = -min(b, 0);
	vec4 nc = -min(c, 0);
	vec4 nd = -min(d, 0);
	vec4 ne = -min(e, 0);
	vec4 nf = -min(f, 0);
	vec4 ng = -min(g, 0);
	vec4 nh = -min(h, 0);
	vec4 ni = -min(i, 0);
	
	a = max(a, 0);
	b = max(b, 0);
	c = max(c, 0);
	d = max(d, 0);
	e = max(e, 0);
	f = max(f, 0);
	g = max(g, 0);
	h = max(h, 0);
	i = max(i, 0);
	
	float s = 0.038567036*a.x + 0.0705653*b.x + -0.08456429*c.x + 0.17830919*d.x + 0.15700413*e.x + -0.48310483*f.x + -0.13568404*g.x + 0.38844487*h.x + -0.24666616*i.x;
	float t = -0.022864863*a.y + -0.09708212*b.y + 0.080999635*c.y + 0.10234689*d.y + -0.9441054*e.y + 0.37205943*f.y + 0.023142772*g.y + -0.30508518*h.y + 0.23074047*i.y;
	float u = 0.026479473*a.z + -0.21789004*b.z + 0.16894147*c.z + 0.24001078*d.z + -0.5764876*e.z + 0.37745288*f.z + -0.08588339*g.z + 0.09972613*h.z + 0.09875314*i.z;
	float v = 0.23032863*a.w + -0.0054795295*b.w + -0.29228735*c.w + 0.49698094*d.w + -1.3256943*e.w + -0.029346323*f.w + 0.15363467*g.w + -0.23334587*h.w + -0.020885304*i.w;
	float w = -0.08072811*na.x + -0.12015889*nb.x + 0.08035302*nc.x + -0.2672039*nd.x + -0.11779888*ne.x + 0.2646977*nf.x + -0.37465525*ng.x + 0.29485774*nh.x + -0.02784101*ni.x;
	float x = -0.19388446*na.y + 0.057232708*nb.y + 0.11700054*nc.y + 0.7411195*nd.y + 0.07168483*ne.y + 0.03476339*nf.y + 0.606746*ng.y + -0.6688325*nh.y + -0.0019025522*ni.y;
	float y = -0.19526717*na.z + 0.3453801*nb.z + -0.26843297*nc.z + 0.29258463*nd.z + -0.9860014*ne.z + -0.029417401*nf.z + -0.1935398*ng.z + 0.3000599*nh.z + -0.13897806*ni.z;
	float z = -1.1220787*na.w + 0.79593414*nb.w + 0.08730238*nc.w + -0.56224525*nd.w + 0.2729329*ne.w + -0.028041862*nf.w + -0.08895821*ng.w + 0.07971253*nh.w + -0.1097084*ni.w;
	float o = s+t+u+v+w+x+y+z+-0.053113442;
	s = 0.04177622*a.x + -0.0036336621*b.x + -0.031431884*c.x + -0.13659629*d.x + -0.059160918*e.x + 0.031841677*f.x + 0.07246833*g.x + 0.112269066*h.x + -0.242079*i.x;
	t = 0.019453337*a.y + -0.060118888*b.y + -0.0056063943*c.y + 0.37430856*d.y + 0.66169596*e.y + 0.22895052*f.y + -0.116621315*g.y + 0.019051338*h.y + 0.2796385*i.y;
	u = 0.025202444*a.z + -0.063063145*b.z + 0.03306231*c.z + -0.087987594*d.z + -0.15086448*e.z + 0.015091712*f.z + -0.016382191*g.z + -0.2719014*h.z + -0.1213443*i.z;
	v = 0.15685205*a.w + 0.16103153*b.w + 0.12104904*c.w + -0.31669632*d.w + -0.5131755*e.w + -0.2940805*f.w + 0.03922636*g.w + 0.10866127*h.w + 0.08225846*i.w;
	w = 0.027171694*na.x + -0.19411181*nb.x + -0.17554177*nc.x + -0.06920469*nd.x + 0.35313594*ne.x + 0.5729236*nf.x + 0.15976419*ng.x + -0.22865002*nh.x + -0.14128903*ni.x;
	x = 0.06538863*na.y + 0.3888246*nb.y + -0.06093744*nc.y + -0.0021450054*nd.y + -0.7144259*ne.y + 0.19505557*nf.y + 0.017545538*ng.y + 0.27564743*nh.y + -0.1891801*ni.y;
	y = -0.04018616*na.z + 0.3965399*nb.z + 0.03547221*nc.z + -0.10051028*nd.z + 0.5457805*ne.z + -0.058937907*nf.z + 0.24849786*ng.z + 0.29411504*nh.z + 0.09580802*ni.z;
	z = -0.2584023*na.w + -0.06644846*nb.w + -0.0073378505*nc.w + 0.59547085*nd.w + 0.14581262*ne.w + -0.025333082*nf.w + -0.105372205*ng.w + -0.14488424*nh.w + 0.10319663*ni.w;
	float p = s+t+u+v+w+x+y+z+-0.030240078;
	s = -0.024701372*a.x + 0.025341522*b.x + 0.06547468*c.x + -0.1478955*d.x + -0.48662245*e.x + 0.29320917*f.x + 0.119131036*g.x + -0.44793203*h.x + 0.4688749*i.x;
	t = -0.108995534*a.y + 0.070233956*b.y + -0.13956581*c.y + -0.21479332*d.y + -0.12898977*e.y + -0.40991426*f.y + 0.020437365*g.y + 0.17140286*h.y + -0.40149483*i.y;
	u = -0.00905909*a.z + 0.10485684*b.z + -0.08578809*c.z + -0.17500319*d.z + 0.4865422*e.z + -0.38730884*f.z + 0.061339755*g.z + 0.034676336*h.z + -0.020573441*i.z;
	v = -0.2025594*a.w + 0.0911606*b.w + 0.082284346*c.w + -0.35355926*d.w + -0.61544394*e.w + 0.32040882*f.w + -0.14619522*g.w + 0.2941107*h.w + -0.078201585*i.w;
	w = 0.0495746*na.x + 0.08055962*nb.x + -0.078246616*nc.x + 0.26895896*nd.x + -0.52850366*ne.x + -0.28460968*nf.x + 0.21908188*ng.x + -0.14934134*nh.x + -0.022079289*ni.x;
	x = 0.18326212*na.y + -0.1183244*nb.y + -0.026135176*nc.y + -0.63453907*nd.y + 1.6052349*ne.y + -0.3253275*nf.y + -0.51091814*ng.y + 0.42029953*nh.y + 0.1379729*ni.y;
	y = 0.13548519*na.z + -0.28737086*nb.z + 0.19119221*nc.z + -0.2149449*nd.z + -0.9226876*ne.z + 0.033711042*nf.z + 0.10450268*ng.z + -0.4635861*nh.z + 0.120921664*ni.z;
	z = 0.95850354*na.w + -0.86698693*nb.w + 0.13464972*nc.w + 0.46481287*nd.w + -0.6893183*ne.w + -0.12460651*nf.w + 0.10310439*ng.w + -0.067780524*nh.w + 0.06973546*ni.w;
	float q = s+t+u+v+w+x+y+z+-0.03733598;
	s = 0.0053327214*a.x + 0.06828431*b.x + 0.017400311*c.x + -0.022229843*d.x + 0.021846429*e.x + 0.17038181*f.x + -0.0036154294*g.x + -0.0076043517*h.x + 0.03144882*i.x;
	t = -0.09128217*a.y + -0.019056903*b.y + -0.10658804*c.y + -0.07005582*d.y + 1.0119812*e.y + -0.18679373*f.y + 0.0014865986*g.y + -0.13718273*h.y + 0.011373519*i.y;
	u = 0.007684441*a.z + -0.0024304984*b.z + -0.0005824064*c.z + -0.046654146*d.z + -0.18832356*e.z + -0.06836408*f.z + 0.03383738*g.z + 0.0031701874*h.z + -0.045616426*i.z;
	v = -0.07080597*a.w + 0.12452656*b.w + 0.055096764*c.w + -0.11060644*d.w + 0.16163704*e.w + -0.028699806*f.w + -0.02837693*g.w + 0.057780527*h.w + 0.01604268*i.w;
	w = 0.031746984*na.x + 0.037449647*nb.x + -0.17273042*nc.x + 0.13193378*nd.x + -0.083798654*ne.x + 0.2653949*nf.x + -0.022535313*ng.x + 0.0860065*nh.x + -0.15048456*ni.x;
	x = 0.039347745*na.y + 0.10379977*nb.y + -0.062039107*nc.y + -0.32586884*nd.y + -0.3929803*ne.y + -0.021611424*nf.y + 0.06064707*ng.y + -0.28440315*nh.y + 0.025921293*ni.y;
	y = -0.016964613*na.z + -0.0066489074*nb.z + 0.13551117*nc.z + 0.12154996*nd.z + -0.104811326*ne.z + -0.18939951*nf.z + -0.08372982*ng.z + 0.055679534*nh.z + -0.0070043216*ni.z;
	z = 0.3667913*na.w + -0.73069835*nb.w + 0.06653495*nc.w + -0.045829143*nd.w + 0.84753215*ne.w + -0.011205747*nf.w + 0.062056217*ng.w + -0.083614476*nh.w + -0.05290749*ni.w;
	float r = s+t+u+v+w+x+y+z+-0.066139325;
		
	return vec4(o, p, q, r);
}

//!DESC Anime4K-v3.0-Upscale(x2)+Denoise-CNN(M)-Conv-Reduce
//!HOOK NATIVE
//!BIND HOOKED
//!WHEN OUTPUT.w NATIVE.w / 1.200 > OUTPUT.h NATIVE.h / 1.200 > *
//!BIND LUMAN0
//!BIND LUMAN1
//!BIND LUMAN2
//!BIND LUMAN3
//!BIND LUMAN4
//!BIND LUMAN5
//!SAVE LUMAN0
//!COMPONENTS 4

vec4 hook() {
	vec2 dp = HOOKED_pt;
	vec4 a = LUMAN1_tex(HOOKED_pos);
	vec4 b = LUMAN2_tex(HOOKED_pos);
	vec4 c = LUMAN3_tex(HOOKED_pos);
	vec4 d = LUMAN4_tex(HOOKED_pos);
	vec4 e = LUMAN5_tex(HOOKED_pos);
	
	vec4 na = -min(a, 0);
	vec4 nb = -min(b, 0);
	vec4 nc = -min(c, 0);
	vec4 nd = -min(d, 0);
	vec4 ne = -min(e, 0);
	
	a = max(a, 0);
	b = max(b, 0);
	c = max(c, 0);
	d = max(d, 0);
	e = max(e, 0);

	float o = 0.048128415*a.x + -0.10200983*a.y + 0.0026888845*a.z + 0.03718083*a.w + 0.0038677044*na.x + 0.19192158*na.y + -0.07810309*na.z + 0.010487845*na.w + 0.03670921*b.x + -0.038882297*b.y + -0.037679777*b.z + -0.012084925*b.w + 0.090262465*nb.x + -0.004547179*nb.y + 0.0059687584*nb.z + 0.051256124*nb.w + -0.11432519*c.x + -0.25872356*c.y + 0.0054702796*c.z + -0.012581099*c.w + 0.015949834*nc.x + 0.21601027*nc.y + 0.035843574*nc.z + 0.017208261*nc.w + -0.056919403*d.x + -0.18486539*d.y + -0.02737798*d.z + -0.3186765*d.w + -0.13511881*nd.x + 0.35757625*nd.y + -0.07571729*nd.z + -0.11691222*nd.w + -0.2406404*e.x + -0.18846813*e.y + -0.090694115*e.z + 0.08896013*e.w + 0.16347*ne.x + 0.099284545*ne.y + 0.16371554*ne.z + -0.042760517*ne.w + -0.014356738;
	float p = 0.034463048*a.x + -0.10106072*a.y + 0.0153113*a.z + 0.013266783*a.w + -0.0050172983*na.x + 0.15015306*na.y + -0.1432366*na.z + -0.0013678991*na.w + 0.008594857*b.x + 0.004623611*b.y + -0.059459336*b.z + -0.013174561*b.w + 0.021199493*nb.x + -0.025345081*nb.y + 0.083974496*nb.z + 0.08165798*nb.w + -0.09537475*c.x + -0.08943068*c.y + -0.02914935*c.z + 0.010825835*c.w + -0.04871495*nc.x + 0.21459627*nc.y + -0.0050241314*nc.z + -0.008088038*nc.w + -0.0045245662*d.x + -0.053880397*d.y + 0.04765565*d.z + -0.06589436*d.w + 0.031551003*nd.x + -0.02856088*nd.y + -0.21330751*nd.z + 0.14608456*nd.w + -0.12683192*e.x + 0.15810186*e.y + 0.11550806*e.z + -0.058062166*e.w + 0.037682347*ne.x + -0.03632457*ne.y + -0.021607846*ne.z + 0.09143093*ne.w + -0.0076093744;
	float q = 0.026701592*a.x + -0.078241214*a.y + 0.118998125*a.z + 0.06534085*a.w + -0.018886134*na.x + 0.11944017*na.y + 0.06824227*na.z + 0.013486396*na.w + 0.020998007*b.x + -0.055520564*b.y + 0.002212575*b.z + -0.00065796264*b.w + -0.081669435*nb.x + 0.014998951*nb.y + -0.026731629*nb.z + -0.057044547*nb.w + 0.06701295*c.x + 0.084943585*c.y + 0.07812323*c.z + 0.027192006*c.w + -0.025491228*nc.x + 0.058227003*nc.y + 0.007927143*nc.z + 0.0028146622*nc.w + -0.070682466*d.x + -0.08310049*d.y + -0.0860419*d.z + -0.4338729*d.w + -0.09763112*nd.x + 0.18996777*nd.y + -0.24132325*nd.z + 0.0043926323*nd.w + -0.10540394*e.x + -0.19668445*e.y + -0.30052847*e.z + -0.14361969*e.w + 0.20132412*ne.x + 0.08645794*ne.y + 0.21893042*ne.z + 0.110118836*ne.w + -0.032480482;
	float r = -0.012988379*a.x + 0.01449243*a.y + 0.1186362*a.z + 0.021411385*a.w + -0.02190659*na.x + 0.08573852*na.y + 0.029420571*na.z + 0.04271885*na.w + 0.020516774*b.x + -0.008869406*b.y + 0.06774458*b.z + -0.02412687*b.w + -0.06278506*nb.x + 0.0015959308*nb.y + 0.06922979*nb.z + -0.014656813*nb.w + 0.13683714*c.x + 0.0055245673*c.y + -0.039630424*c.z + 0.023636617*c.w + -0.031803787*nc.x + -0.01460251*nc.y + 0.015318757*nc.z + -0.0058491337*nc.w + -0.120180495*d.x + -0.28844154*d.y + 0.0075656036*d.z + -0.446147*d.w + -0.108871296*nd.x + 0.28307307*nd.y + -0.47336864*nd.z + 0.0047260863*nd.w + -0.10478753*e.x + 0.082965665*e.y + -0.30823767*e.z + 0.11182321*e.w + 0.16890883*ne.x + 0.042257413*ne.y + 0.22344704*ne.z + -0.07987242*ne.w + -0.017264554;

	return vec4(o, p, q, r);
}

//!DESC Anime4K-v3.0-Upscale(x2)+Denoise-CNN(M)
//!HOOK NATIVE
//!BIND HOOKED
//!WHEN OUTPUT.w NATIVE.w / 1.200 > OUTPUT.h NATIVE.h / 1.200 > *
//!BIND LUMAN0
//!WIDTH LUMA.w 2 *
//!HEIGHT LUMA.h 2 *


vec4 hook() {
	vec2 f = fract(LUMAN0_pos * LUMAN0_size);
	ivec2 i = ivec2(f * vec2(2));
	float c = LUMAN0_tex((vec2(0.5) - f) * LUMAN0_pt + LUMAN0_pos)[i.y * 2 + i.x];
	return vec4(c + HOOKED_tex(HOOKED_pos).x, HOOKED_tex(HOOKED_pos).yz, 0);
}
