/*
 * Decompiled with CFR 0.152.
 */
package sun.security.util;

import java.security.CodeSigner;
import java.security.Key;
import java.security.Timestamp;
import java.security.cert.CertPath;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import sun.security.util.AnchorCertificates;
import sun.security.util.ConstraintsParameters;

public class JarConstraintsParameters
implements ConstraintsParameters {
    private boolean anchorIsJdkCA;
    private boolean anchorIsJdkCASet;
    private Date timestamp;
    private final Set<Key> keys = new HashSet<Key>();
    private final Set<X509Certificate> certsIssuedByAnchor = new HashSet<X509Certificate>();
    private String message;

    public JarConstraintsParameters(CodeSigner[] signers) {
        Date latestTimestamp = null;
        boolean skipTimestamp = false;
        for (CodeSigner signer : signers) {
            this.init(signer.getSignerCertPath());
            Timestamp timestamp = signer.getTimestamp();
            if (timestamp == null) {
                latestTimestamp = null;
                skipTimestamp = true;
                continue;
            }
            this.init(timestamp.getSignerCertPath());
            if (skipTimestamp) continue;
            Date timestampDate = timestamp.getTimestamp();
            if (latestTimestamp == null) {
                latestTimestamp = timestampDate;
                continue;
            }
            if (!latestTimestamp.before(timestampDate)) continue;
            latestTimestamp = timestampDate;
        }
        this.timestamp = latestTimestamp;
    }

    private void init(CertPath cp) {
        List<? extends Certificate> chain = cp.getCertificates();
        if (!chain.isEmpty()) {
            this.certsIssuedByAnchor.add((X509Certificate)chain.get(chain.size() - 1));
            this.keys.add(((X509Certificate)chain.get(0)).getPublicKey());
        }
    }

    @Override
    public String getVariant() {
        return "generic";
    }

    @Override
    public boolean anchorIsJdkCA() {
        if (this.anchorIsJdkCASet) {
            return this.anchorIsJdkCA;
        }
        for (X509Certificate cert : this.certsIssuedByAnchor) {
            if (!AnchorCertificates.issuerOf(cert)) continue;
            this.anchorIsJdkCA = true;
            break;
        }
        this.anchorIsJdkCASet = true;
        return this.anchorIsJdkCA;
    }

    @Override
    public Date getDate() {
        return this.timestamp;
    }

    @Override
    public Set<Key> getKeys() {
        return this.keys;
    }

    public void setExtendedExceptionMsg(String file, String target) {
        this.message = " used" + (target != null ? " with " + target : "") + " in " + file + " file.";
    }

    @Override
    public String extendedExceptionMsg() {
        return this.message;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("[\n");
        sb.append("\n  Variant: ").append(this.getVariant());
        sb.append("\n  Certs Issued by Anchor:");
        for (X509Certificate cert : this.certsIssuedByAnchor) {
            sb.append("\n    Cert Issuer: ").append(cert.getIssuerX500Principal());
            sb.append("\n    Cert Subject: ").append(cert.getSubjectX500Principal());
        }
        for (Key key : this.keys) {
            sb.append("\n  Key: ").append(key.getAlgorithm());
        }
        if (this.timestamp != null) {
            sb.append("\n  Timestamp: ").append(this.timestamp);
        }
        sb.append("\n]");
        return sb.toString();
    }
}

