/*
 * Decompiled with CFR 0.152.
 */
package sun.security.util;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.security.AlgorithmParameters;
import java.security.CryptoPrimitive;
import java.security.Key;
import java.security.cert.CertPathValidatorException;
import java.security.interfaces.ECKey;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import java.security.spec.MGF1ParameterSpec;
import java.security.spec.PSSParameterSpec;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import sun.misc.JavaUtilCalendarAccess;
import sun.misc.SharedSecrets;
import sun.security.util.AbstractAlgorithmConstraints;
import sun.security.util.AlgorithmDecomposer;
import sun.security.util.ConstraintsParameters;
import sun.security.util.CurveDB;
import sun.security.util.Debug;
import sun.security.util.KeyUtil;
import sun.security.util.NamedCurve;

public class DisabledAlgorithmConstraints
extends AbstractAlgorithmConstraints {
    private static final Debug debug = Debug.getInstance("certpath");
    public static final String PROPERTY_CERTPATH_DISABLED_ALGS = "jdk.certpath.disabledAlgorithms";
    public static final String PROPERTY_TLS_DISABLED_ALGS = "jdk.tls.disabledAlgorithms";
    public static final String PROPERTY_JAR_DISABLED_ALGS = "jdk.jar.disabledAlgorithms";
    private static final String PROPERTY_DISABLED_EC_CURVES = "jdk.disabled.namedCurves";
    private final List<String> disabledAlgorithms;
    private final Constraints algorithmConstraints;

    public static DisabledAlgorithmConstraints certPathConstraints() {
        return CertPathHolder.CONSTRAINTS;
    }

    public static DisabledAlgorithmConstraints jarConstraints() {
        return JarHolder.CONSTRAINTS;
    }

    public DisabledAlgorithmConstraints(String propertyName) {
        this(propertyName, new AlgorithmDecomposer());
    }

    public DisabledAlgorithmConstraints(String propertyName, AlgorithmDecomposer decomposer) {
        super(decomposer);
        this.disabledAlgorithms = DisabledAlgorithmConstraints.getAlgorithms(propertyName);
        int ecindex = -1;
        int i = 0;
        for (String s : this.disabledAlgorithms) {
            if (s.regionMatches(true, 0, "include ", 0, 8) && s.regionMatches(true, 8, PROPERTY_DISABLED_EC_CURVES, 0, PROPERTY_DISABLED_EC_CURVES.length())) {
                ecindex = i;
                break;
            }
            ++i;
        }
        if (ecindex > -1) {
            this.disabledAlgorithms.remove(ecindex);
            this.disabledAlgorithms.addAll(ecindex, DisabledAlgorithmConstraints.getAlgorithms(PROPERTY_DISABLED_EC_CURVES));
        }
        this.algorithmConstraints = new Constraints(propertyName, this.disabledAlgorithms);
    }

    @Override
    public final boolean permits(Set<CryptoPrimitive> primitives, String algorithm, AlgorithmParameters parameters) {
        if (!DisabledAlgorithmConstraints.checkAlgorithm(this.disabledAlgorithms, algorithm, this.decomposer)) {
            return false;
        }
        if (parameters != null) {
            return this.algorithmConstraints.permits(algorithm, parameters);
        }
        return true;
    }

    @Override
    public final boolean permits(Set<CryptoPrimitive> primitives, Key key) {
        return this.checkConstraints(primitives, "", key, null);
    }

    @Override
    public final boolean permits(Set<CryptoPrimitive> primitives, String algorithm, Key key, AlgorithmParameters parameters) {
        if (algorithm == null || algorithm.length() == 0) {
            throw new IllegalArgumentException("No algorithm name specified");
        }
        return this.checkConstraints(primitives, algorithm, key, parameters);
    }

    public final void permits(String algorithm, AlgorithmParameters ap, ConstraintsParameters cp) throws CertPathValidatorException {
        this.permits(algorithm, cp);
        if (ap != null) {
            this.permits(ap, cp);
        }
    }

    private void permits(AlgorithmParameters ap, ConstraintsParameters cp) throws CertPathValidatorException {
        switch (ap.getAlgorithm().toUpperCase(Locale.ENGLISH)) {
            case "RSASSA-PSS": {
                this.permitsPSSParams(ap, cp);
                break;
            }
        }
    }

    private void permitsPSSParams(AlgorithmParameters ap, ConstraintsParameters cp) throws CertPathValidatorException {
        try {
            String mgfDigestAlg;
            PSSParameterSpec pssParams = ap.getParameterSpec(PSSParameterSpec.class);
            String digestAlg = pssParams.getDigestAlgorithm();
            this.permits(digestAlg, cp);
            AlgorithmParameterSpec mgfParams = pssParams.getMGFParameters();
            if (mgfParams instanceof MGF1ParameterSpec && !(mgfDigestAlg = ((MGF1ParameterSpec)mgfParams).getDigestAlgorithm()).equalsIgnoreCase(digestAlg)) {
                this.permits(mgfDigestAlg, cp);
            }
        }
        catch (InvalidParameterSpecException invalidParameterSpecException) {
            // empty catch block
        }
    }

    public final void permits(String algorithm, ConstraintsParameters cp) throws CertPathValidatorException {
        for (Key key : cp.getKeys()) {
            for (String curve : DisabledAlgorithmConstraints.getNamedCurveFromKey(key)) {
                if (DisabledAlgorithmConstraints.checkAlgorithm(this.disabledAlgorithms, curve, this.decomposer)) continue;
                throw new CertPathValidatorException("Algorithm constraints check failed on disabled algorithm: " + curve, null, null, -1, CertPathValidatorException.BasicReason.ALGORITHM_CONSTRAINED);
            }
        }
        this.algorithmConstraints.permits(algorithm, cp);
    }

    private static List<String> getNamedCurveFromKey(Key key) {
        if (key instanceof ECKey) {
            NamedCurve nc = CurveDB.lookup(((ECKey)((Object)key)).getParams());
            return nc == null ? Collections.emptyList() : Arrays.asList(CurveDB.getNamesByOID(nc.getObjectId()));
        }
        return Collections.emptyList();
    }

    private boolean checkConstraints(Set<CryptoPrimitive> primitives, String algorithm, Key key, AlgorithmParameters parameters) {
        if (key == null) {
            throw new IllegalArgumentException("The key cannot be null");
        }
        if (algorithm != null && algorithm.length() != 0 && !this.permits(primitives, algorithm, parameters)) {
            return false;
        }
        if (!this.permits(primitives, key.getAlgorithm(), null)) {
            return false;
        }
        for (String curve : DisabledAlgorithmConstraints.getNamedCurveFromKey(key)) {
            if (this.permits(primitives, curve, null)) continue;
            return false;
        }
        return this.algorithmConstraints.permits(key);
    }

    private static class AvailableCalendarTypes {
        private static final Set<String> SET;

        private AvailableCalendarTypes() {
        }

        static {
            HashSet<String> set = new HashSet<String>(3);
            set.add("gregory");
            set.add("buddhist");
            set.add("japanese");
            SET = Collections.unmodifiableSet(set);
        }
    }

    private static class CalendarBuilder {
        private static final int NFIELDS = 18;
        private static final int WEEK_YEAR = 17;
        private static final int UNSET = 0;
        private static final int COMPUTED = 1;
        private static final int MINIMUM_USER_STAMP = 2;
        private long instant;
        private int[] fields;
        private int nextStamp;
        private int maxFieldIndex;
        private String type;
        private TimeZone zone;
        private boolean lenient = true;
        private Locale locale;
        private int firstDayOfWeek;
        private int minimalDaysInFirstWeek;

        public CalendarBuilder setInstant(long instant) {
            if (this.fields != null) {
                throw new IllegalStateException();
            }
            this.instant = instant;
            this.nextStamp = 1;
            return this;
        }

        public CalendarBuilder setInstant(Date instant) {
            return this.setInstant(instant.getTime());
        }

        public CalendarBuilder set(int field, int value) {
            if (field < 0 || field >= 17) {
                throw new IllegalArgumentException("field is invalid");
            }
            if (this.isInstantSet()) {
                throw new IllegalStateException("instant has been set");
            }
            this.allocateFields();
            this.internalSet(field, value);
            return this;
        }

        public CalendarBuilder setFields(int ... fieldValuePairs) {
            int len = fieldValuePairs.length;
            if (len % 2 != 0) {
                throw new IllegalArgumentException();
            }
            if (this.isInstantSet()) {
                throw new IllegalStateException("instant has been set");
            }
            if (this.nextStamp + len / 2 < 0) {
                throw new IllegalStateException("stamp counter overflow");
            }
            this.allocateFields();
            int i = 0;
            while (i < len) {
                int field;
                if ((field = fieldValuePairs[i++]) < 0 || field >= 17) {
                    throw new IllegalArgumentException("field is invalid");
                }
                this.internalSet(field, fieldValuePairs[i++]);
            }
            return this;
        }

        public CalendarBuilder setDate(int year, int month, int dayOfMonth) {
            return this.setFields(1, year, 2, month, 5, dayOfMonth);
        }

        public CalendarBuilder setTimeOfDay(int hourOfDay, int minute, int second) {
            return this.setTimeOfDay(hourOfDay, minute, second, 0);
        }

        public CalendarBuilder setTimeOfDay(int hourOfDay, int minute, int second, int millis) {
            return this.setFields(11, hourOfDay, 12, minute, 13, second, 14, millis);
        }

        public CalendarBuilder setWeekDate(int weekYear, int weekOfYear, int dayOfWeek) {
            this.allocateFields();
            this.internalSet(17, weekYear);
            this.internalSet(3, weekOfYear);
            this.internalSet(7, dayOfWeek);
            return this;
        }

        public CalendarBuilder setTimeZone(TimeZone zone) {
            if (zone == null) {
                throw new NullPointerException();
            }
            this.zone = zone;
            return this;
        }

        public CalendarBuilder setLenient(boolean lenient) {
            this.lenient = lenient;
            return this;
        }

        public CalendarBuilder setCalendarType(String type) {
            if (type.equals("gregorian")) {
                type = "gregory";
            }
            if (!AvailableCalendarTypes.SET.contains(type) && !type.equals("iso8601")) {
                throw new IllegalArgumentException("unknown calendar type: " + type);
            }
            if (this.type == null) {
                this.type = type;
            } else if (!this.type.equals(type)) {
                throw new IllegalStateException("calendar type override");
            }
            return this;
        }

        public CalendarBuilder setLocale(Locale locale) {
            if (locale == null) {
                throw new NullPointerException();
            }
            this.locale = locale;
            return this;
        }

        public CalendarBuilder setWeekDefinition(int firstDayOfWeek, int minimalDaysInFirstWeek) {
            if (!this.isValidWeekParameter(firstDayOfWeek) || !this.isValidWeekParameter(minimalDaysInFirstWeek)) {
                throw new IllegalArgumentException();
            }
            this.firstDayOfWeek = firstDayOfWeek;
            this.minimalDaysInFirstWeek = minimalDaysInFirstWeek;
            return this;
        }

        public Calendar build() {
            GregorianCalendar cal;
            if (this.locale == null) {
                this.locale = Locale.getDefault();
            }
            if (this.zone == null) {
                this.zone = TimeZone.getDefault();
            }
            JavaUtilCalendarAccess access = SharedSecrets.getJavaUtilCalendarAccess();
            if (this.type == null) {
                this.type = this.locale.getUnicodeLocaleType("ca");
            }
            if (this.type == null) {
                this.type = this.locale.getCountry() == "TH" && this.locale.getLanguage() == "th" ? "buddhist" : "gregory";
            }
            switch (this.type) {
                case "gregory": {
                    cal = access.createCalendar(this.zone, this.locale);
                    break;
                }
                case "iso8601": {
                    GregorianCalendar gcal = access.createCalendar(this.zone, this.locale);
                    gcal.setGregorianChange(new Date(Long.MIN_VALUE));
                    this.setWeekDefinition(2, 4);
                    cal = gcal;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("unknown calendar type: " + this.type);
                }
            }
            cal.setLenient(this.lenient);
            if (this.firstDayOfWeek != 0) {
                cal.setFirstDayOfWeek(this.firstDayOfWeek);
                cal.setMinimalDaysInFirstWeek(this.minimalDaysInFirstWeek);
            }
            if (this.isInstantSet()) {
                cal.setTimeInMillis(this.instant);
                access.complete(cal);
                return cal;
            }
            if (this.fields != null) {
                boolean weekDate;
                boolean bl = weekDate = this.isSet(17) && this.fields[17] > this.fields[1];
                if (weekDate && !((Calendar)cal).isWeekDateSupported()) {
                    throw new IllegalArgumentException("week date is unsupported by " + this.type);
                }
                block8: for (int stamp = 2; stamp < this.nextStamp; ++stamp) {
                    for (int index = 0; index <= this.maxFieldIndex; ++index) {
                        if (this.fields[index] != stamp) continue;
                        cal.set(index, this.fields[18 + index]);
                        continue block8;
                    }
                }
                if (weekDate) {
                    int weekOfYear = this.isSet(3) ? this.fields[21] : 1;
                    int dayOfWeek = this.isSet(7) ? this.fields[25] : cal.getFirstDayOfWeek();
                    ((Calendar)cal).setWeekDate(this.fields[35], weekOfYear, dayOfWeek);
                }
                access.complete(cal);
            }
            return cal;
        }

        private void allocateFields() {
            if (this.fields == null) {
                this.fields = new int[36];
                this.nextStamp = 2;
                this.maxFieldIndex = -1;
            }
        }

        private void internalSet(int field, int value) {
            ++this.nextStamp;
            if (this.nextStamp < 0) {
                throw new IllegalStateException("stamp counter overflow");
            }
            this.fields[18 + field] = value;
            if (field > this.maxFieldIndex && field < 17) {
                this.maxFieldIndex = field;
            }
        }

        private boolean isInstantSet() {
            return this.nextStamp == 1;
        }

        private boolean isSet(int index) {
            return this.fields != null && this.fields[index] > 0;
        }

        private boolean isValidWeekParameter(int value) {
            return value > 0 && value <= 7;
        }
    }

    private static class DisabledConstraint
    extends Constraint {
        DisabledConstraint(String algo) {
            this.algorithm = algo;
        }

        @Override
        public void permits(ConstraintsParameters cp) throws CertPathValidatorException {
            throw new CertPathValidatorException("Algorithm constraints check failed on disabled algorithm: " + this.algorithm + cp.extendedExceptionMsg(), null, null, -1, CertPathValidatorException.BasicReason.ALGORITHM_CONSTRAINED);
        }

        @Override
        public boolean permits(Key key) {
            return false;
        }
    }

    private static class KeySizeConstraint
    extends Constraint {
        private int minSize;
        private int maxSize;
        private int prohibitedSize = -1;

        public KeySizeConstraint(String algo, Constraint.Operator operator, int length) {
            this.algorithm = algo;
            switch (operator) {
                case EQ: {
                    this.minSize = 0;
                    this.maxSize = Integer.MAX_VALUE;
                    this.prohibitedSize = length;
                    break;
                }
                case NE: {
                    this.minSize = length;
                    this.maxSize = length;
                    break;
                }
                case LT: {
                    this.minSize = length;
                    this.maxSize = Integer.MAX_VALUE;
                    break;
                }
                case LE: {
                    this.minSize = length + 1;
                    this.maxSize = Integer.MAX_VALUE;
                    break;
                }
                case GT: {
                    this.minSize = 0;
                    this.maxSize = length;
                    break;
                }
                case GE: {
                    this.minSize = 0;
                    this.maxSize = length > 1 ? length - 1 : 0;
                    break;
                }
                default: {
                    this.minSize = Integer.MAX_VALUE;
                    this.maxSize = -1;
                }
            }
        }

        @Override
        public void permits(ConstraintsParameters cp) throws CertPathValidatorException {
            for (Key key : cp.getKeys()) {
                if (this.permitsImpl(key)) continue;
                if (this.nextConstraint != null) {
                    this.nextConstraint.permits(cp);
                    continue;
                }
                throw new CertPathValidatorException("Algorithm constraints check failed on keysize limits: " + this.algorithm + " " + KeyUtil.getKeySize(key) + " bit key" + cp.extendedExceptionMsg(), null, null, -1, CertPathValidatorException.BasicReason.ALGORITHM_CONSTRAINED);
            }
        }

        @Override
        public boolean permits(Key key) {
            if (this.nextConstraint != null && this.nextConstraint.permits(key)) {
                return true;
            }
            if (debug != null) {
                debug.println("KeySizeConstraints.permits(): " + this.algorithm);
            }
            return this.permitsImpl(key);
        }

        @Override
        public boolean permits(AlgorithmParameters parameters) {
            Collection<String> aliases;
            String paramAlg = parameters.getAlgorithm();
            if (!this.algorithm.equalsIgnoreCase(parameters.getAlgorithm()) && !(aliases = AlgorithmDecomposer.getAliases(this.algorithm)).contains(paramAlg)) {
                return true;
            }
            int keySize = KeyUtil.getKeySize(parameters);
            if (keySize == 0) {
                return false;
            }
            if (keySize > 0) {
                return keySize >= this.minSize && keySize <= this.maxSize && this.prohibitedSize != keySize;
            }
            return true;
        }

        private boolean permitsImpl(Key key) {
            if (this.algorithm.compareToIgnoreCase(key.getAlgorithm()) != 0) {
                return true;
            }
            int size = KeyUtil.getKeySize(key);
            if (size == 0) {
                return false;
            }
            if (size > 0) {
                return size >= this.minSize && size <= this.maxSize && this.prohibitedSize != size;
            }
            return true;
        }
    }

    private static class UsageConstraint
    extends Constraint {
        String[] usages;

        UsageConstraint(String algorithm, String[] usages) {
            this.algorithm = algorithm;
            this.usages = usages;
        }

        @Override
        public void permits(ConstraintsParameters cp) throws CertPathValidatorException {
            String variant = cp.getVariant();
            for (String usage : this.usages) {
                boolean match = false;
                switch (usage.toLowerCase()) {
                    case "tlsserver": {
                        match = variant.equals("tls server");
                        break;
                    }
                    case "tlsclient": {
                        match = variant.equals("tls client");
                        break;
                    }
                    case "signedjar": {
                        boolean bl = match = variant.equals("plugin code signing") || variant.equals("code signing") || variant.equals("tsa server");
                    }
                }
                if (debug != null) {
                    debug.println("Checking if usage constraint \"" + usage + "\" matches \"" + cp.getVariant() + "\"");
                    ByteArrayOutputStream ba = new ByteArrayOutputStream();
                    PrintStream ps = new PrintStream(ba);
                    new Exception().printStackTrace(ps);
                    debug.println(ba.toString());
                }
                if (!match) continue;
                if (this.next(cp)) {
                    return;
                }
                throw new CertPathValidatorException("Usage constraint " + usage + " check failed: " + this.algorithm + cp.extendedExceptionMsg(), null, null, -1, CertPathValidatorException.BasicReason.ALGORITHM_CONSTRAINED);
            }
        }
    }

    private static class DenyAfterConstraint
    extends Constraint {
        private Date denyAfterDate;
        private static final SimpleDateFormat dateFormat = new SimpleDateFormat("EEE, MMM d HH:mm:ss z yyyy");

        DenyAfterConstraint(String algo, int year, int month, int day) {
            Calendar c;
            this.algorithm = algo;
            if (debug != null) {
                debug.println("DenyAfterConstraint read in as:  year " + year + ", month = " + month + ", day = " + day);
            }
            if (year > (c = new CalendarBuilder().setTimeZone(TimeZone.getTimeZone("GMT")).setDate(year, month - 1, day).build()).getActualMaximum(1) || year < c.getActualMinimum(1)) {
                throw new IllegalArgumentException("Invalid year given in constraint: " + year);
            }
            if (month - 1 > c.getActualMaximum(2) || month - 1 < c.getActualMinimum(2)) {
                throw new IllegalArgumentException("Invalid month given in constraint: " + month);
            }
            if (day > c.getActualMaximum(5) || day < c.getActualMinimum(5)) {
                throw new IllegalArgumentException("Invalid Day of Month given in constraint: " + day);
            }
            this.denyAfterDate = c.getTime();
            if (debug != null) {
                debug.println("DenyAfterConstraint date set to: " + dateFormat.format(this.denyAfterDate));
            }
        }

        @Override
        public void permits(ConstraintsParameters cp) throws CertPathValidatorException {
            Date currentDate = cp.getDate() != null ? cp.getDate() : new Date();
            if (!this.denyAfterDate.after(currentDate)) {
                if (this.next(cp)) {
                    return;
                }
                throw new CertPathValidatorException("denyAfter constraint check failed: " + this.algorithm + " used with Constraint date: " + dateFormat.format(this.denyAfterDate) + "; params date: " + dateFormat.format(currentDate) + cp.extendedExceptionMsg(), null, null, -1, CertPathValidatorException.BasicReason.ALGORITHM_CONSTRAINED);
            }
        }

        @Override
        public boolean permits(Key key) {
            if (this.next(key)) {
                return true;
            }
            if (debug != null) {
                debug.println("DenyAfterConstraints.permits(): " + this.algorithm);
            }
            return this.denyAfterDate.after(new Date());
        }
    }

    private static class jdkCAConstraint
    extends Constraint {
        jdkCAConstraint(String algo) {
            this.algorithm = algo;
        }

        @Override
        public void permits(ConstraintsParameters cp) throws CertPathValidatorException {
            if (debug != null) {
                debug.println("jdkCAConstraints.permits(): " + this.algorithm);
            }
            if (cp.anchorIsJdkCA()) {
                if (this.next(cp)) {
                    return;
                }
                throw new CertPathValidatorException("Algorithm constraints check failed on certificate anchor limits. " + this.algorithm + cp.extendedExceptionMsg(), null, null, -1, CertPathValidatorException.BasicReason.ALGORITHM_CONSTRAINED);
            }
        }
    }

    private static abstract class Constraint {
        String algorithm;
        Constraint nextConstraint = null;

        private Constraint() {
        }

        public boolean permits(Key key) {
            return true;
        }

        public boolean permits(AlgorithmParameters parameters) {
            return true;
        }

        public abstract void permits(ConstraintsParameters var1) throws CertPathValidatorException;

        boolean next(ConstraintsParameters cp) throws CertPathValidatorException {
            if (this.nextConstraint != null) {
                this.nextConstraint.permits(cp);
                return true;
            }
            return false;
        }

        boolean next(Key key) {
            return this.nextConstraint != null && this.nextConstraint.permits(key);
        }

        static enum Operator {
            EQ,
            NE,
            LT,
            LE,
            GT,
            GE;


            static Operator of(String s) {
                switch (s) {
                    case "==": {
                        return EQ;
                    }
                    case "!=": {
                        return NE;
                    }
                    case "<": {
                        return LT;
                    }
                    case "<=": {
                        return LE;
                    }
                    case ">": {
                        return GT;
                    }
                    case ">=": {
                        return GE;
                    }
                }
                throw new IllegalArgumentException("Error in security property. " + s + " is not a legal Operator");
            }
        }
    }

    private static class Constraints {
        private Map<String, List<Constraint>> constraintsMap = new HashMap<String, List<Constraint>>();

        public Constraints(String propertyName, List<String> constraintArray) {
            for (String constraintEntry : constraintArray) {
                int space;
                String algorithm;
                List<Constraint> constraintList;
                if (constraintEntry == null || constraintEntry.isEmpty()) continue;
                constraintEntry = constraintEntry.trim();
                if (debug != null) {
                    debug.println("Constraints: " + constraintEntry);
                }
                if ((constraintList = this.constraintsMap.get((algorithm = AlgorithmDecomposer.hashName((space = constraintEntry.indexOf(32)) > 0 ? constraintEntry.substring(0, space) : constraintEntry)).toUpperCase(Locale.ENGLISH))) == null) {
                    constraintList = new ArrayList<Constraint>(1);
                }
                for (String alias : AlgorithmDecomposer.getAliases(algorithm)) {
                    List<Constraint> aliasList = this.constraintsMap.get(alias);
                    if (aliasList != null) continue;
                    this.constraintsMap.put(alias.toUpperCase(Locale.ENGLISH), constraintList);
                }
                if (space <= 0 || CurveDB.lookup(constraintEntry) != null) {
                    constraintList.add(new DisabledConstraint(algorithm));
                    continue;
                }
                String policy = constraintEntry.substring(space + 1);
                jdkCAConstraint lastConstraint = null;
                boolean jdkCALimit = false;
                boolean denyAfterLimit = false;
                for (String entry : policy.split("&")) {
                    Matcher matcher;
                    Constraint c;
                    if ((entry = entry.trim()).startsWith("keySize")) {
                        StringTokenizer tokens;
                        if (debug != null) {
                            debug.println("Constraints set to keySize: " + entry);
                        }
                        if (!"keySize".equals((tokens = new StringTokenizer(entry)).nextToken())) {
                            throw new IllegalArgumentException("Error in security property. Constraint unknown: " + entry);
                        }
                        c = new KeySizeConstraint(algorithm, Constraint.Operator.of(tokens.nextToken()), Integer.parseInt(tokens.nextToken()));
                    } else if (entry.equalsIgnoreCase("jdkCA")) {
                        if (debug != null) {
                            debug.println("Constraints set to jdkCA.");
                        }
                        if (jdkCALimit) {
                            throw new IllegalArgumentException("Only one jdkCA entry allowed in property. Constraint: " + constraintEntry);
                        }
                        c = new jdkCAConstraint(algorithm);
                        jdkCALimit = true;
                    } else if (entry.startsWith("denyAfter") && (matcher = Holder.DENY_AFTER_PATTERN.matcher(entry)).matches()) {
                        if (debug != null) {
                            debug.println("Constraints set to denyAfter");
                        }
                        if (denyAfterLimit) {
                            throw new IllegalArgumentException("Only one denyAfter entry allowed in property. Constraint: " + constraintEntry);
                        }
                        int year = Integer.parseInt(matcher.group(1));
                        int month = Integer.parseInt(matcher.group(2));
                        int day = Integer.parseInt(matcher.group(3));
                        c = new DenyAfterConstraint(algorithm, year, month, day);
                        denyAfterLimit = true;
                    } else if (entry.startsWith("usage")) {
                        String[] s = entry.substring(5).trim().split(" ");
                        c = new UsageConstraint(algorithm, s);
                        if (debug != null) {
                            debug.println("Constraints usage length is " + s.length);
                        }
                    } else {
                        throw new IllegalArgumentException("Error in security property. Constraint unknown: " + entry);
                    }
                    if (lastConstraint == null) {
                        constraintList.add(c);
                    } else {
                        lastConstraint.nextConstraint = c;
                    }
                    lastConstraint = c;
                }
            }
        }

        private List<Constraint> getConstraints(String algorithm) {
            return this.constraintsMap.get(algorithm.toUpperCase(Locale.ENGLISH));
        }

        public boolean permits(Key key) {
            List<Constraint> list = this.getConstraints(key.getAlgorithm());
            if (list == null) {
                return true;
            }
            for (Constraint constraint : list) {
                if (constraint.permits(key)) continue;
                if (debug != null) {
                    debug.println("Constraints: failed key sizeconstraint check " + KeyUtil.getKeySize(key));
                }
                return false;
            }
            return true;
        }

        public boolean permits(String algorithm, AlgorithmParameters aps) {
            List<Constraint> list = this.getConstraints(algorithm);
            if (list == null) {
                return true;
            }
            for (Constraint constraint : list) {
                if (constraint.permits(aps)) continue;
                if (debug != null) {
                    debug.println("Constraints: failed algorithm parameters constraint check " + aps);
                }
                return false;
            }
            return true;
        }

        public void permits(String algorithm, ConstraintsParameters cp) throws CertPathValidatorException {
            if (debug != null) {
                debug.println("Constraints.permits(): " + algorithm + ", " + cp.toString());
            }
            HashSet<String> algorithms = new HashSet<String>();
            if (algorithm != null) {
                algorithms.addAll(AlgorithmDecomposer.decomposeOneHash(algorithm));
                algorithms.add(algorithm);
            }
            for (Key key : cp.getKeys()) {
                algorithms.add(key.getAlgorithm());
            }
            for (String alg : algorithms) {
                List<Constraint> list = this.getConstraints(alg);
                if (list == null) continue;
                for (Constraint constraint : list) {
                    constraint.permits(cp);
                }
            }
        }

        private static class Holder {
            private static final Pattern DENY_AFTER_PATTERN = Pattern.compile("denyAfter\\s+(\\d{4})-(\\d{2})-(\\d{2})");

            private Holder() {
            }
        }
    }

    private static class JarHolder {
        static final DisabledAlgorithmConstraints CONSTRAINTS = new DisabledAlgorithmConstraints("jdk.jar.disabledAlgorithms");

        private JarHolder() {
        }
    }

    private static class CertPathHolder {
        static final DisabledAlgorithmConstraints CONSTRAINTS = new DisabledAlgorithmConstraints("jdk.certpath.disabledAlgorithms");

        private CertPathHolder() {
        }
    }
}

