/*
 * Decompiled with CFR 0.152.
 */
package sun.security.pkcs12;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.KeyStoreSpi;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.UnrecoverableEntryException;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.InvalidParameterSpecException;
import java.security.spec.KeySpec;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.crypto.Cipher;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import javax.security.auth.x500.X500Principal;
import sun.misc.JavaSecurityKeyStoreAccess;
import sun.misc.SharedSecrets;
import sun.security.pkcs.ContentInfo;
import sun.security.pkcs.EncryptedPrivateKeyInfo;
import sun.security.pkcs12.MacData;
import sun.security.pkcs12.PKCS12Attribute;
import sun.security.util.Debug;
import sun.security.util.DerInputStream;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;
import sun.security.util.ObjectIdentifier;
import sun.security.x509.AlgorithmId;

public final class PKCS12KeyStore
extends KeyStoreSpi {
    public static final int VERSION_3 = 3;
    private static final int MAX_ITERATION_COUNT = 5000000;
    private static final int PBE_ITERATION_COUNT = 50000;
    private static final int MAC_ITERATION_COUNT = 100000;
    private static final int SALT_LEN = 20;
    private static final String[] CORE_ATTRIBUTES = new String[]{"1.2.840.113549.1.9.20", "1.2.840.113549.1.9.21", "2.16.840.1.113894.746875.1.1"};
    private static final Debug debug = Debug.getInstance("pkcs12");
    private static final int[] keyBag = new int[]{1, 2, 840, 113549, 1, 12, 10, 1, 2};
    private static final int[] certBag = new int[]{1, 2, 840, 113549, 1, 12, 10, 1, 3};
    private static final int[] secretBag = new int[]{1, 2, 840, 113549, 1, 12, 10, 1, 5};
    private static final int[] pkcs9Name = new int[]{1, 2, 840, 113549, 1, 9, 20};
    private static final int[] pkcs9KeyId = new int[]{1, 2, 840, 113549, 1, 9, 21};
    private static final int[] pkcs9certType = new int[]{1, 2, 840, 113549, 1, 9, 22, 1};
    private static final int[] pbeWithSHAAnd40BitRC2CBC = new int[]{1, 2, 840, 113549, 1, 12, 1, 6};
    private static final int[] pbeWithSHAAnd3KeyTripleDESCBC = new int[]{1, 2, 840, 113549, 1, 12, 1, 3};
    private static final int[] TrustedKeyUsage = new int[]{2, 16, 840, 1, 113894, 746875, 1, 1};
    private static final int[] AnyExtendedKeyUsage = new int[]{2, 5, 29, 37, 0};
    private static ObjectIdentifier PKCS8ShroudedKeyBag_OID;
    private static ObjectIdentifier CertBag_OID;
    private static ObjectIdentifier SecretBag_OID;
    private static ObjectIdentifier PKCS9FriendlyName_OID;
    private static ObjectIdentifier PKCS9LocalKeyId_OID;
    private static ObjectIdentifier PKCS9CertType_OID;
    private static ObjectIdentifier pbeWithSHAAnd40BitRC2CBC_OID;
    private static ObjectIdentifier pbeWithSHAAnd3KeyTripleDESCBC_OID;
    private static ObjectIdentifier TrustedKeyUsage_OID;
    private static ObjectIdentifier[] AnyUsage;
    private int counter = 0;
    private int privateKeyCount = 0;
    private int secretKeyCount = 0;
    private int certificateCount = 0;
    private SecureRandom random;
    private Map<String, Entry> entries = Collections.synchronizedMap(new LinkedHashMap());
    private ArrayList<KeyEntry> keyList = new ArrayList();
    private LinkedHashMap<X500Principal, X509Certificate> certsMap = new LinkedHashMap();
    private ArrayList<CertEntry> certEntries = new ArrayList();

    @Override
    public Key engineGetKey(String alias, char[] password) throws NoSuchAlgorithmException, UnrecoverableKeyException {
        AlgorithmParameters algParams;
        ObjectIdentifier algOid;
        byte[] encryptedKey;
        Entry entry = this.entries.get(alias.toLowerCase(Locale.ENGLISH));
        Key key = null;
        if (entry == null || !(entry instanceof KeyEntry)) {
            return null;
        }
        byte[] encrBytes = null;
        if (entry instanceof PrivateKeyEntry) {
            encrBytes = ((PrivateKeyEntry)entry).protectedPrivKey;
        } else if (entry instanceof SecretKeyEntry) {
            encrBytes = ((SecretKeyEntry)entry).protectedSecretKey;
        } else {
            throw new UnrecoverableKeyException("Error locating key");
        }
        try {
            EncryptedPrivateKeyInfo encrInfo = new EncryptedPrivateKeyInfo(encrBytes);
            encryptedKey = encrInfo.getEncryptedData();
            DerValue val = new DerValue(encrInfo.getAlgorithm().encode());
            DerInputStream in = val.toDerInputStream();
            algOid = in.getOID();
            algParams = this.parseAlgParameters(in);
        }
        catch (IOException ioe) {
            UnrecoverableKeyException uke = new UnrecoverableKeyException("Private key not stored as PKCS#8 EncryptedPrivateKeyInfo: " + ioe);
            uke.initCause(ioe);
            throw uke;
        }
        try {
            byte[] keyInfo;
            int ic = 0;
            if (algParams != null) {
                PBEParameterSpec pbeSpec;
                try {
                    pbeSpec = algParams.getParameterSpec(PBEParameterSpec.class);
                }
                catch (InvalidParameterSpecException ipse) {
                    throw new IOException("Invalid PBE algorithm parameters");
                }
                ic = pbeSpec.getIterationCount();
                if (ic > 5000000) {
                    throw new IOException("PBE iteration count too large");
                }
            }
            while (true) {
                try {
                    SecretKey skey = this.getPBEKey(password);
                    Cipher cipher = Cipher.getInstance(algOid.toString());
                    cipher.init(2, (Key)skey, algParams);
                    keyInfo = cipher.doFinal(encryptedKey);
                }
                catch (Exception e) {
                    if (password.length == 0) {
                        password = new char[1];
                        continue;
                    }
                    throw e;
                }
                break;
            }
            DerValue val = new DerValue(keyInfo);
            DerInputStream in = val.toDerInputStream();
            int i = in.getInteger();
            DerValue[] value = in.getSequence(2);
            if (value.length < 1 || value.length > 2) {
                throw new IOException("Invalid length for AlgorithmIdentifier");
            }
            AlgorithmId algId = new AlgorithmId(value[0].getOID());
            String keyAlgo = algId.getName();
            if (entry instanceof PrivateKeyEntry) {
                KeyFactory kfac = KeyFactory.getInstance(keyAlgo);
                PKCS8EncodedKeySpec kspec = new PKCS8EncodedKeySpec(keyInfo);
                key = kfac.generatePrivate(kspec);
                if (debug != null) {
                    debug.println("Retrieved a protected private key at alias '" + alias + "' (" + new AlgorithmId(algOid).getName() + " iterations: " + ic + ")");
                }
            } else {
                byte[] keyBytes = in.getOctetString();
                SecretKeySpec secretKeySpec = new SecretKeySpec(keyBytes, keyAlgo);
                if (keyAlgo.startsWith("PBE")) {
                    SecretKeyFactory sKeyFactory = SecretKeyFactory.getInstance(keyAlgo);
                    KeySpec pbeKeySpec = sKeyFactory.getKeySpec(secretKeySpec, PBEKeySpec.class);
                    key = sKeyFactory.generateSecret(pbeKeySpec);
                } else {
                    key = secretKeySpec;
                }
                if (debug != null) {
                    debug.println("Retrieved a protected secret key at alias '" + alias + "' (" + new AlgorithmId(algOid).getName() + " iterations: " + ic + ")");
                }
            }
        }
        catch (Exception e) {
            UnrecoverableKeyException uke = new UnrecoverableKeyException("Get Key failed: " + e.getMessage());
            uke.initCause(e);
            throw uke;
        }
        return key;
    }

    @Override
    public Certificate[] engineGetCertificateChain(String alias) {
        Entry entry = this.entries.get(alias.toLowerCase(Locale.ENGLISH));
        if (entry != null && entry instanceof PrivateKeyEntry) {
            if (((PrivateKeyEntry)entry).chain == null) {
                return null;
            }
            if (debug != null) {
                debug.println("Retrieved a " + ((PrivateKeyEntry)entry).chain.length + "-certificate chain at alias '" + alias + "'");
            }
            return (Certificate[])((PrivateKeyEntry)entry).chain.clone();
        }
        return null;
    }

    @Override
    public Certificate engineGetCertificate(String alias) {
        Entry entry = this.entries.get(alias.toLowerCase(Locale.ENGLISH));
        if (entry == null) {
            return null;
        }
        if (entry instanceof CertEntry && ((CertEntry)entry).trustedKeyUsage != null) {
            if (debug != null) {
                if (Arrays.equals(AnyUsage, ((CertEntry)entry).trustedKeyUsage)) {
                    debug.println("Retrieved a certificate at alias '" + alias + "' (trusted for any purpose)");
                } else {
                    debug.println("Retrieved a certificate at alias '" + alias + "' (trusted for limited purposes)");
                }
            }
            return ((CertEntry)entry).cert;
        }
        if (entry instanceof PrivateKeyEntry) {
            if (((PrivateKeyEntry)entry).chain == null) {
                return null;
            }
            if (debug != null) {
                debug.println("Retrieved a certificate at alias '" + alias + "'");
            }
            return ((PrivateKeyEntry)entry).chain[0];
        }
        return null;
    }

    @Override
    public Date engineGetCreationDate(String alias) {
        Entry entry = this.entries.get(alias.toLowerCase(Locale.ENGLISH));
        if (entry != null) {
            return new Date(entry.date.getTime());
        }
        return null;
    }

    @Override
    public synchronized void engineSetKeyEntry(String alias, Key key, char[] password, Certificate[] chain) throws KeyStoreException {
        this.setKeyEntry(alias, key, password, chain, null);
    }

    private void setKeyEntry(String alias, Key key, char[] password, Certificate[] chain, Set<PKCS12Attribute> attributes) throws KeyStoreException {
        try {
            KeyEntry entry;
            if (key instanceof PrivateKey) {
                PrivateKeyEntry keyEntry = new PrivateKeyEntry();
                keyEntry.date = new Date();
                if (key.getFormat().equals("PKCS#8") || key.getFormat().equals("PKCS8")) {
                    if (debug != null) {
                        debug.println("Setting a protected private key at alias '" + alias + "'");
                    }
                } else {
                    throw new KeyStoreException("Private key is not encodedas PKCS#8");
                }
                keyEntry.protectedPrivKey = this.encryptPrivateKey(key.getEncoded(), password);
                if (chain != null) {
                    if (chain.length > 1 && !this.validateChain(chain)) {
                        throw new KeyStoreException("Certificate chain is not valid");
                    }
                    keyEntry.chain = (Certificate[])chain.clone();
                    this.certificateCount += chain.length;
                    if (debug != null) {
                        debug.println("Setting a " + chain.length + "-certificate chain at alias '" + alias + "'");
                    }
                }
                ++this.privateKeyCount;
                entry = keyEntry;
            } else if (key instanceof SecretKey) {
                SecretKeyEntry keyEntry = new SecretKeyEntry();
                keyEntry.date = new Date();
                DerOutputStream pkcs8 = new DerOutputStream();
                DerOutputStream secretKeyInfo = new DerOutputStream();
                secretKeyInfo.putInteger(0);
                AlgorithmId algId = AlgorithmId.get(key.getAlgorithm());
                algId.encode(secretKeyInfo);
                secretKeyInfo.putOctetString(key.getEncoded());
                pkcs8.write((byte)48, secretKeyInfo);
                keyEntry.protectedSecretKey = this.encryptPrivateKey(pkcs8.toByteArray(), password);
                if (debug != null) {
                    debug.println("Setting a protected secret key at alias '" + alias + "'");
                }
                ++this.secretKeyCount;
                entry = keyEntry;
            } else {
                throw new KeyStoreException("Unsupported Key type");
            }
            entry.attributes = new HashSet<PKCS12Attribute>();
            if (attributes != null) {
                entry.attributes.addAll(attributes);
            }
            entry.keyId = ("Time " + entry.date.getTime()).getBytes("UTF8");
            entry.alias = alias.toLowerCase(Locale.ENGLISH);
            this.entries.put(alias.toLowerCase(Locale.ENGLISH), entry);
        }
        catch (Exception nsae) {
            throw new KeyStoreException("Key protection  algorithm not found: " + nsae, nsae);
        }
    }

    @Override
    public synchronized void engineSetKeyEntry(String alias, byte[] key, Certificate[] chain) throws KeyStoreException {
        try {
            new EncryptedPrivateKeyInfo(key);
        }
        catch (IOException ioe) {
            throw new KeyStoreException("Private key is not stored as PKCS#8 EncryptedPrivateKeyInfo: " + ioe, ioe);
        }
        PrivateKeyEntry entry = new PrivateKeyEntry();
        entry.date = new Date();
        if (debug != null) {
            debug.println("Setting a protected private key at alias '" + alias + "'");
        }
        try {
            entry.keyId = ("Time " + entry.date.getTime()).getBytes("UTF8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        entry.alias = alias.toLowerCase(Locale.ENGLISH);
        entry.protectedPrivKey = (byte[])key.clone();
        if (chain != null) {
            if (chain.length > 1 && !this.validateChain(chain)) {
                throw new KeyStoreException("Certificate chain is not valid");
            }
            entry.chain = (Certificate[])chain.clone();
            this.certificateCount += chain.length;
            if (debug != null) {
                debug.println("Setting a " + entry.chain.length + "-certificate chain at alias '" + alias + "'");
            }
        }
        ++this.privateKeyCount;
        this.entries.put(alias.toLowerCase(Locale.ENGLISH), entry);
    }

    private byte[] getSalt() {
        byte[] salt = new byte[20];
        if (this.random == null) {
            this.random = new SecureRandom();
        }
        this.random.nextBytes(salt);
        return salt;
    }

    private AlgorithmParameters getPBEAlgorithmParameters(String algorithm) throws IOException {
        AlgorithmParameters algParams = null;
        PBEParameterSpec paramSpec = new PBEParameterSpec(this.getSalt(), 50000);
        try {
            algParams = AlgorithmParameters.getInstance(algorithm);
            algParams.init(paramSpec);
        }
        catch (Exception e) {
            throw new IOException("getPBEAlgorithmParameters failed: " + e.getMessage(), e);
        }
        return algParams;
    }

    private AlgorithmParameters parseAlgParameters(DerInputStream in) throws IOException {
        AlgorithmParameters algParams = null;
        try {
            DerValue params;
            if (in.available() == 0) {
                params = null;
            } else {
                params = in.getDerValue();
                if (params.tag == 5) {
                    params = null;
                }
            }
            if (params != null) {
                algParams = AlgorithmParameters.getInstance("PBE");
                algParams.init(params.toByteArray());
            }
        }
        catch (Exception e) {
            throw new IOException("parseAlgParameters failed: " + e.getMessage(), e);
        }
        return algParams;
    }

    private SecretKey getPBEKey(char[] password) throws IOException {
        SecretKey skey = null;
        try {
            PBEKeySpec keySpec = new PBEKeySpec(password);
            SecretKeyFactory skFac = SecretKeyFactory.getInstance("PBE");
            skey = skFac.generateSecret(keySpec);
            keySpec.clearPassword();
        }
        catch (Exception e) {
            throw new IOException("getSecretKey failed: " + e.getMessage(), e);
        }
        return skey;
    }

    private byte[] encryptPrivateKey(byte[] data, char[] password) throws IOException, NoSuchAlgorithmException, UnrecoverableKeyException {
        byte[] key = null;
        try {
            AlgorithmParameters algParams = this.getPBEAlgorithmParameters("PBEWithSHA1AndDESede");
            SecretKey skey = this.getPBEKey(password);
            Cipher cipher = Cipher.getInstance("PBEWithSHA1AndDESede");
            cipher.init(1, (Key)skey, algParams);
            byte[] encryptedKey = cipher.doFinal(data);
            if (debug != null) {
                debug.println("  (Cipher algorithm: " + cipher.getAlgorithm() + ")");
            }
            AlgorithmId algid = new AlgorithmId(pbeWithSHAAnd3KeyTripleDESCBC_OID, algParams);
            EncryptedPrivateKeyInfo encrInfo = new EncryptedPrivateKeyInfo(algid, encryptedKey);
            key = encrInfo.getEncoded();
        }
        catch (Exception e) {
            UnrecoverableKeyException uke = new UnrecoverableKeyException("Encrypt Private Key failed: " + e.getMessage());
            uke.initCause(e);
            throw uke;
        }
        return key;
    }

    @Override
    public synchronized void engineSetCertificateEntry(String alias, Certificate cert) throws KeyStoreException {
        this.setCertEntry(alias, cert, null);
    }

    private void setCertEntry(String alias, Certificate cert, Set<PKCS12Attribute> attributes) throws KeyStoreException {
        Entry entry = this.entries.get(alias.toLowerCase(Locale.ENGLISH));
        if (entry != null && entry instanceof KeyEntry) {
            throw new KeyStoreException("Cannot overwrite own certificate");
        }
        CertEntry certEntry = new CertEntry((X509Certificate)cert, null, alias, AnyUsage, attributes);
        ++this.certificateCount;
        this.entries.put(alias, certEntry);
        if (debug != null) {
            debug.println("Setting a trusted certificate at alias '" + alias + "'");
        }
    }

    @Override
    public synchronized void engineDeleteEntry(String alias) throws KeyStoreException {
        Entry entry;
        if (debug != null) {
            debug.println("Removing entry at alias '" + alias + "'");
        }
        if ((entry = this.entries.get(alias.toLowerCase(Locale.ENGLISH))) instanceof PrivateKeyEntry) {
            PrivateKeyEntry keyEntry = (PrivateKeyEntry)entry;
            if (keyEntry.chain != null) {
                this.certificateCount -= keyEntry.chain.length;
            }
            --this.privateKeyCount;
        } else if (entry instanceof CertEntry) {
            --this.certificateCount;
        } else if (entry instanceof SecretKeyEntry) {
            --this.secretKeyCount;
        }
        this.entries.remove(alias.toLowerCase(Locale.ENGLISH));
    }

    @Override
    public Enumeration<String> engineAliases() {
        return Collections.enumeration(this.entries.keySet());
    }

    @Override
    public boolean engineContainsAlias(String alias) {
        return this.entries.containsKey(alias.toLowerCase(Locale.ENGLISH));
    }

    @Override
    public int engineSize() {
        return this.entries.size();
    }

    @Override
    public boolean engineIsKeyEntry(String alias) {
        Entry entry = this.entries.get(alias.toLowerCase(Locale.ENGLISH));
        return entry != null && entry instanceof KeyEntry;
    }

    @Override
    public boolean engineIsCertificateEntry(String alias) {
        Entry entry = this.entries.get(alias.toLowerCase(Locale.ENGLISH));
        return entry != null && entry instanceof CertEntry && ((CertEntry)entry).trustedKeyUsage != null;
    }

    @Override
    public boolean engineEntryInstanceOf(String alias, Class<? extends KeyStore.Entry> entryClass) {
        if (entryClass == KeyStore.TrustedCertificateEntry.class) {
            return this.engineIsCertificateEntry(alias);
        }
        Entry entry = this.entries.get(alias.toLowerCase(Locale.ENGLISH));
        if (entryClass == KeyStore.PrivateKeyEntry.class) {
            return entry != null && entry instanceof PrivateKeyEntry;
        }
        if (entryClass == KeyStore.SecretKeyEntry.class) {
            return entry != null && entry instanceof SecretKeyEntry;
        }
        return false;
    }

    @Override
    public String engineGetCertificateAlias(Certificate cert) {
        Certificate certElem = null;
        Enumeration<String> e = this.engineAliases();
        while (e.hasMoreElements()) {
            String alias = e.nextElement();
            Entry entry = this.entries.get(alias);
            if (entry instanceof PrivateKeyEntry) {
                if (((PrivateKeyEntry)entry).chain != null) {
                    certElem = ((PrivateKeyEntry)entry).chain[0];
                }
            } else {
                if (!(entry instanceof CertEntry) || ((CertEntry)entry).trustedKeyUsage == null) continue;
                certElem = ((CertEntry)entry).cert;
            }
            if (certElem == null || !certElem.equals(cert)) continue;
            return alias;
        }
        return null;
    }

    @Override
    public synchronized void engineStore(OutputStream stream, char[] password) throws IOException, NoSuchAlgorithmException, CertificateException {
        if (password == null) {
            throw new IllegalArgumentException("password can't be null");
        }
        DerOutputStream pfx = new DerOutputStream();
        DerOutputStream version = new DerOutputStream();
        version.putInteger(3);
        byte[] pfxVersion = version.toByteArray();
        pfx.write(pfxVersion);
        DerOutputStream authSafe = new DerOutputStream();
        DerOutputStream authSafeContentInfo = new DerOutputStream();
        if (this.privateKeyCount > 0 || this.secretKeyCount > 0) {
            if (debug != null) {
                debug.println("Storing " + (this.privateKeyCount + this.secretKeyCount) + " protected key(s) in a PKCS#7 data");
            }
            byte[] safeContentData = this.createSafeContent();
            ContentInfo dataContentInfo = new ContentInfo(safeContentData);
            dataContentInfo.encode(authSafeContentInfo);
        }
        if (this.certificateCount > 0) {
            if (debug != null) {
                debug.println("Storing " + this.certificateCount + " certificate(s) in a PKCS#7 encryptedData");
            }
            byte[] encrData = this.createEncryptedData(password);
            ContentInfo encrContentInfo = new ContentInfo(ContentInfo.ENCRYPTED_DATA_OID, new DerValue(encrData));
            encrContentInfo.encode(authSafeContentInfo);
        }
        DerOutputStream cInfo = new DerOutputStream();
        cInfo.write((byte)48, authSafeContentInfo);
        byte[] authenticatedSafe = cInfo.toByteArray();
        ContentInfo contentInfo = new ContentInfo(authenticatedSafe);
        contentInfo.encode(authSafe);
        byte[] authSafeData = authSafe.toByteArray();
        pfx.write(authSafeData);
        byte[] macData = this.calculateMac(password, authenticatedSafe);
        pfx.write(macData);
        DerOutputStream pfxout = new DerOutputStream();
        pfxout.write((byte)48, pfx);
        byte[] pfxData = pfxout.toByteArray();
        stream.write(pfxData);
        stream.flush();
    }

    @Override
    public KeyStore.Entry engineGetEntry(String alias, KeyStore.ProtectionParameter protParam) throws KeyStoreException, NoSuchAlgorithmException, UnrecoverableEntryException {
        if (!this.engineContainsAlias(alias)) {
            return null;
        }
        Entry entry = this.entries.get(alias.toLowerCase(Locale.ENGLISH));
        JavaSecurityKeyStoreAccess jsksa = SharedSecrets.getJavaSecurityKeyStoreAccess();
        if (protParam == null) {
            if (this.engineIsCertificateEntry(alias)) {
                if (entry instanceof CertEntry && ((CertEntry)entry).trustedKeyUsage != null) {
                    if (debug != null) {
                        debug.println("Retrieved a trusted certificate at alias '" + alias + "'");
                    }
                    return jsksa.constructTrustedCertificateEntry(((CertEntry)entry).cert, this.getAttributes(entry));
                }
            } else {
                throw new UnrecoverableKeyException("requested entry requires a password");
            }
        }
        if (protParam instanceof KeyStore.PasswordProtection) {
            if (this.engineIsCertificateEntry(alias)) {
                throw new UnsupportedOperationException("trusted certificate entries are not password-protected");
            }
            if (this.engineIsKeyEntry(alias)) {
                KeyStore.PasswordProtection pp = (KeyStore.PasswordProtection)protParam;
                char[] password = pp.getPassword();
                Key key = this.engineGetKey(alias, password);
                if (key instanceof PrivateKey) {
                    Certificate[] chain = this.engineGetCertificateChain(alias);
                    return jsksa.constructPrivateKeyEntry((PrivateKey)key, chain, this.getAttributes(entry));
                }
                if (key instanceof SecretKey) {
                    return jsksa.constructSecretKeyEntry((SecretKey)key, this.getAttributes(entry));
                }
            } else if (!this.engineIsKeyEntry(alias)) {
                throw new UnsupportedOperationException("untrusted certificate entries are not password-protected");
            }
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public synchronized void engineSetEntry(String alias, KeyStore.Entry entry, KeyStore.ProtectionParameter protParam) throws KeyStoreException {
        if (protParam != null && !(protParam instanceof KeyStore.PasswordProtection)) {
            throw new KeyStoreException("unsupported protection parameter");
        }
        KeyStore.PasswordProtection pProtect = null;
        if (protParam != null) {
            pProtect = (KeyStore.PasswordProtection)protParam;
        }
        JavaSecurityKeyStoreAccess jsksa = SharedSecrets.getJavaSecurityKeyStoreAccess();
        if (entry instanceof KeyStore.TrustedCertificateEntry) {
            if (protParam != null && pProtect.getPassword() != null) {
                throw new KeyStoreException("trusted certificate entries are not password-protected");
            }
            KeyStore.TrustedCertificateEntry tce = (KeyStore.TrustedCertificateEntry)entry;
            this.setCertEntry(alias, tce.getTrustedCertificate(), jsksa.getTrustedCertificateEntryAttributes(tce));
            return;
        }
        if (entry instanceof KeyStore.PrivateKeyEntry) {
            if (pProtect == null || pProtect.getPassword() == null) {
                throw new KeyStoreException("non-null password required to create PrivateKeyEntry");
            }
            KeyStore.PrivateKeyEntry pke = (KeyStore.PrivateKeyEntry)entry;
            this.setKeyEntry(alias, pke.getPrivateKey(), pProtect.getPassword(), pke.getCertificateChain(), jsksa.getPrivateKeyEntryAttributes(pke));
            return;
        }
        if (entry instanceof KeyStore.SecretKeyEntry) {
            if (pProtect == null || pProtect.getPassword() == null) {
                throw new KeyStoreException("non-null password required to create SecretKeyEntry");
            }
            KeyStore.SecretKeyEntry ske = (KeyStore.SecretKeyEntry)entry;
            this.setKeyEntry(alias, ske.getSecretKey(), pProtect.getPassword(), null, jsksa.getSecretKeyEntryAttributes(ske));
            return;
        }
        throw new KeyStoreException("unsupported entry type: " + entry.getClass().getName());
    }

    private Set<PKCS12Attribute> getAttributes(Entry entry) {
        Object[] trustedKeyUsageValue;
        if (entry.attributes == null) {
            entry.attributes = new HashSet<PKCS12Attribute>();
        }
        entry.attributes.add(new PKCS12Attribute(PKCS9FriendlyName_OID.toString(), entry.alias));
        byte[] keyIdValue = entry.keyId;
        if (keyIdValue != null) {
            entry.attributes.add(new PKCS12Attribute(PKCS9LocalKeyId_OID.toString(), Debug.toString(keyIdValue)));
        }
        if (entry instanceof CertEntry && (trustedKeyUsageValue = ((CertEntry)entry).trustedKeyUsage) != null) {
            if (trustedKeyUsageValue.length == 1) {
                entry.attributes.add(new PKCS12Attribute(TrustedKeyUsage_OID.toString(), ((ObjectIdentifier)trustedKeyUsageValue[0]).toString()));
            } else {
                entry.attributes.add(new PKCS12Attribute(TrustedKeyUsage_OID.toString(), Arrays.toString(trustedKeyUsageValue)));
            }
        }
        return entry.attributes;
    }

    private byte[] generateHash(byte[] data) throws IOException {
        byte[] digest = null;
        try {
            MessageDigest md = MessageDigest.getInstance("SHA1");
            md.update(data);
            digest = md.digest();
        }
        catch (Exception e) {
            throw new IOException("generateHash failed: " + e, e);
        }
        return digest;
    }

    private byte[] calculateMac(char[] passwd, byte[] data) throws IOException {
        byte[] mData = null;
        String algName = "SHA1";
        try {
            byte[] salt = this.getSalt();
            Mac m = Mac.getInstance("HmacPBESHA1");
            PBEParameterSpec params = new PBEParameterSpec(salt, 100000);
            SecretKey key = this.getPBEKey(passwd);
            m.init(key, params);
            m.update(data);
            byte[] macResult = m.doFinal();
            MacData macData = new MacData(algName, macResult, salt, 100000);
            DerOutputStream bytes = new DerOutputStream();
            bytes.write(macData.getEncoded());
            mData = bytes.toByteArray();
        }
        catch (Exception e) {
            throw new IOException("calculateMac failed: " + e, e);
        }
        return mData;
    }

    private boolean validateChain(Certificate[] certChain) {
        for (int i = 0; i < certChain.length - 1; ++i) {
            X500Principal subjectDN;
            X500Principal issuerDN = ((X509Certificate)certChain[i]).getIssuerX500Principal();
            if (issuerDN.equals(subjectDN = ((X509Certificate)certChain[i + 1]).getSubjectX500Principal())) continue;
            return false;
        }
        HashSet<Certificate> set = new HashSet<Certificate>(Arrays.asList(certChain));
        return set.size() == certChain.length;
    }

    private byte[] getBagAttributes(String alias, byte[] keyId, Set<PKCS12Attribute> attributes) throws IOException {
        return this.getBagAttributes(alias, keyId, null, attributes);
    }

    private byte[] getBagAttributes(String alias, byte[] keyId, ObjectIdentifier[] trustedUsage, Set<PKCS12Attribute> attributes) throws IOException {
        byte[] localKeyID = null;
        byte[] friendlyName = null;
        byte[] trustedKeyUsage = null;
        if (alias == null && keyId == null && trustedKeyUsage == null) {
            return null;
        }
        DerOutputStream bagAttrs = new DerOutputStream();
        if (alias != null) {
            DerOutputStream bagAttr1 = new DerOutputStream();
            bagAttr1.putOID(PKCS9FriendlyName_OID);
            DerOutputStream bagAttrContent1 = new DerOutputStream();
            DerOutputStream bagAttrValue1 = new DerOutputStream();
            bagAttrContent1.putBMPString(alias);
            bagAttr1.write((byte)49, bagAttrContent1);
            bagAttrValue1.write((byte)48, bagAttr1);
            friendlyName = bagAttrValue1.toByteArray();
        }
        if (keyId != null) {
            DerOutputStream bagAttr2 = new DerOutputStream();
            bagAttr2.putOID(PKCS9LocalKeyId_OID);
            DerOutputStream bagAttrContent2 = new DerOutputStream();
            DerOutputStream bagAttrValue2 = new DerOutputStream();
            bagAttrContent2.putOctetString(keyId);
            bagAttr2.write((byte)49, bagAttrContent2);
            bagAttrValue2.write((byte)48, bagAttr2);
            localKeyID = bagAttrValue2.toByteArray();
        }
        if (trustedUsage != null) {
            DerOutputStream bagAttr3 = new DerOutputStream();
            bagAttr3.putOID(TrustedKeyUsage_OID);
            DerOutputStream bagAttrContent3 = new DerOutputStream();
            DerOutputStream bagAttrValue3 = new DerOutputStream();
            for (ObjectIdentifier usage : trustedUsage) {
                bagAttrContent3.putOID(usage);
            }
            bagAttr3.write((byte)49, bagAttrContent3);
            bagAttrValue3.write((byte)48, bagAttr3);
            trustedKeyUsage = bagAttrValue3.toByteArray();
        }
        DerOutputStream attrs = new DerOutputStream();
        if (friendlyName != null) {
            attrs.write(friendlyName);
        }
        if (localKeyID != null) {
            attrs.write(localKeyID);
        }
        if (trustedKeyUsage != null) {
            attrs.write(trustedKeyUsage);
        }
        if (attributes != null) {
            for (PKCS12Attribute attribute : attributes) {
                String attributeName = attribute.getName();
                if (CORE_ATTRIBUTES[0].equals(attributeName) || CORE_ATTRIBUTES[1].equals(attributeName) || CORE_ATTRIBUTES[2].equals(attributeName)) continue;
                attrs.write(attribute.getEncoded());
            }
        }
        bagAttrs.write((byte)49, attrs);
        return bagAttrs.toByteArray();
    }

    private byte[] createEncryptedData(char[] password) throws CertificateException, IOException {
        DerOutputStream out = new DerOutputStream();
        Enumeration<String> e = this.engineAliases();
        while (e.hasMoreElements()) {
            Certificate[] certs;
            String alias = e.nextElement();
            Entry entry = this.entries.get(alias);
            if (entry instanceof PrivateKeyEntry) {
                PrivateKeyEntry keyEntry = (PrivateKeyEntry)entry;
                certs = keyEntry.chain != null ? keyEntry.chain : new Certificate[]{};
            } else {
                certs = entry instanceof CertEntry ? new Certificate[]{((CertEntry)entry).cert} : new Certificate[]{};
            }
            for (int i = 0; i < certs.length; ++i) {
                DerOutputStream safeBag = new DerOutputStream();
                safeBag.putOID(CertBag_OID);
                DerOutputStream certBag = new DerOutputStream();
                certBag.putOID(PKCS9CertType_OID);
                DerOutputStream certValue = new DerOutputStream();
                X509Certificate cert = (X509Certificate)certs[i];
                certValue.putOctetString(cert.getEncoded());
                certBag.write(DerValue.createTag((byte)-128, true, (byte)0), certValue);
                DerOutputStream certout = new DerOutputStream();
                certout.write((byte)48, certBag);
                byte[] certBagValue = certout.toByteArray();
                DerOutputStream bagValue = new DerOutputStream();
                bagValue.write(certBagValue);
                safeBag.write(DerValue.createTag((byte)-128, true, (byte)0), bagValue);
                byte[] bagAttrs = null;
                if (i == 0) {
                    if (entry instanceof KeyEntry) {
                        KeyEntry keyEntry = (KeyEntry)entry;
                        bagAttrs = this.getBagAttributes(keyEntry.alias, keyEntry.keyId, keyEntry.attributes);
                    } else {
                        CertEntry certEntry = (CertEntry)entry;
                        bagAttrs = this.getBagAttributes(certEntry.alias, certEntry.keyId, certEntry.trustedKeyUsage, certEntry.attributes);
                    }
                } else {
                    bagAttrs = this.getBagAttributes(cert.getSubjectX500Principal().getName(), null, entry.attributes);
                }
                if (bagAttrs != null) {
                    safeBag.write(bagAttrs);
                }
                out.write((byte)48, safeBag);
            }
        }
        DerOutputStream safeBagValue = new DerOutputStream();
        safeBagValue.write((byte)48, out);
        byte[] safeBagData = safeBagValue.toByteArray();
        byte[] encrContentInfo = this.encryptContent(safeBagData, password);
        DerOutputStream encrData = new DerOutputStream();
        DerOutputStream encrDataContent = new DerOutputStream();
        encrData.putInteger(0);
        encrData.write(encrContentInfo);
        encrDataContent.write((byte)48, encrData);
        return encrDataContent.toByteArray();
    }

    private byte[] createSafeContent() throws CertificateException, IOException {
        DerOutputStream out = new DerOutputStream();
        Enumeration<String> e = this.engineAliases();
        while (e.hasMoreElements()) {
            String alias = e.nextElement();
            Entry entry = this.entries.get(alias);
            if (entry == null || !(entry instanceof KeyEntry)) continue;
            DerOutputStream safeBag = new DerOutputStream();
            KeyEntry keyEntry = (KeyEntry)entry;
            if (keyEntry instanceof PrivateKeyEntry) {
                safeBag.putOID(PKCS8ShroudedKeyBag_OID);
                byte[] encrBytes = ((PrivateKeyEntry)keyEntry).protectedPrivKey;
                EncryptedPrivateKeyInfo encrInfo = null;
                try {
                    encrInfo = new EncryptedPrivateKeyInfo(encrBytes);
                }
                catch (IOException ioe) {
                    throw new IOException("Private key not stored as PKCS#8 EncryptedPrivateKeyInfo" + ioe.getMessage());
                }
                DerOutputStream bagValue = new DerOutputStream();
                bagValue.write(encrInfo.getEncoded());
                safeBag.write(DerValue.createTag((byte)-128, true, (byte)0), bagValue);
            } else {
                if (!(keyEntry instanceof SecretKeyEntry)) continue;
                safeBag.putOID(SecretBag_OID);
                DerOutputStream secretBag = new DerOutputStream();
                secretBag.putOID(PKCS8ShroudedKeyBag_OID);
                DerOutputStream secretKeyValue = new DerOutputStream();
                secretKeyValue.putOctetString(((SecretKeyEntry)keyEntry).protectedSecretKey);
                secretBag.write(DerValue.createTag((byte)-128, true, (byte)0), secretKeyValue);
                DerOutputStream secretBagSeq = new DerOutputStream();
                secretBagSeq.write((byte)48, secretBag);
                byte[] secretBagValue = secretBagSeq.toByteArray();
                DerOutputStream bagValue = new DerOutputStream();
                bagValue.write(secretBagValue);
                safeBag.write(DerValue.createTag((byte)-128, true, (byte)0), bagValue);
            }
            byte[] bagAttrs = this.getBagAttributes(alias, entry.keyId, entry.attributes);
            safeBag.write(bagAttrs);
            out.write((byte)48, safeBag);
        }
        DerOutputStream safeBagValue = new DerOutputStream();
        safeBagValue.write((byte)48, out);
        return safeBagValue.toByteArray();
    }

    private byte[] encryptContent(byte[] data, char[] password) throws IOException {
        byte[] encryptedData = null;
        AlgorithmParameters algParams = this.getPBEAlgorithmParameters("PBEWithSHA1AndRC2_40");
        DerOutputStream bytes = new DerOutputStream();
        AlgorithmId algId = new AlgorithmId(pbeWithSHAAnd40BitRC2CBC_OID, algParams);
        algId.encode(bytes);
        byte[] encodedAlgId = bytes.toByteArray();
        try {
            SecretKey skey = this.getPBEKey(password);
            Cipher cipher = Cipher.getInstance("PBEWithSHA1AndRC2_40");
            cipher.init(1, (Key)skey, algParams);
            encryptedData = cipher.doFinal(data);
            if (debug != null) {
                debug.println("  (Cipher algorithm: " + cipher.getAlgorithm() + ")");
            }
        }
        catch (Exception e) {
            throw new IOException("Failed to encrypt safe contents entry: " + e, e);
        }
        DerOutputStream bytes2 = new DerOutputStream();
        bytes2.putOID(ContentInfo.DATA_OID);
        bytes2.write(encodedAlgId);
        DerOutputStream tmpout2 = new DerOutputStream();
        tmpout2.putOctetString(encryptedData);
        bytes2.writeImplicit(DerValue.createTag((byte)-128, false, (byte)0), tmpout2);
        DerOutputStream out = new DerOutputStream();
        out.write((byte)48, bytes2);
        return out.toByteArray();
    }

    @Override
    public synchronized void engineLoad(InputStream stream, char[] password) throws IOException, NoSuchAlgorithmException, CertificateException {
        Object cf = null;
        Object bais = null;
        Object encoded = null;
        if (stream == null) {
            return;
        }
        this.counter = 0;
        DerValue val = new DerValue(stream);
        DerInputStream s = val.toDerInputStream();
        int version = s.getInteger();
        if (version != 3) {
            throw new IOException("PKCS12 keystore not in version 3 format");
        }
        this.entries.clear();
        ContentInfo authSafe = new ContentInfo(s);
        ObjectIdentifier contentType = authSafe.getContentType();
        if (contentType.equals((Object)ContentInfo.DATA_OID)) {
            if (debug != null) {
                debug.println("Loading PKCS#7 data");
            }
        } else {
            throw new IOException("public key protected PKCS12 not supported");
        }
        byte[] authSafeData = authSafe.getData();
        DerInputStream as = new DerInputStream(authSafeData);
        DerValue[] safeContentsArray = as.getSequence(2);
        int count = safeContentsArray.length;
        this.privateKeyCount = 0;
        this.secretKeyCount = 0;
        this.certificateCount = 0;
        for (int i = 0; i < count; ++i) {
            byte[] safeContentsData;
            block36: {
                byte[] eAlgId = null;
                DerInputStream sci = new DerInputStream(safeContentsArray[i].toByteArray());
                ContentInfo safeContents = new ContentInfo(sci);
                contentType = safeContents.getContentType();
                safeContentsData = null;
                if (contentType.equals((Object)ContentInfo.DATA_OID)) {
                    safeContentsData = safeContents.getData();
                } else {
                    if (contentType.equals(ContentInfo.ENCRYPTED_DATA_OID)) {
                        if (password == null) {
                            if (debug == null) continue;
                            debug.println("Warning: skipping PKCS#7 encryptedData - no password was supplied");
                            continue;
                        }
                        DerInputStream edi = safeContents.getContent().toDerInputStream();
                        int edVersion = edi.getInteger();
                        DerValue[] seq = edi.getSequence(3);
                        if (seq.length != 3) {
                            throw new IOException("Invalid length for EncryptedContentInfo");
                        }
                        ObjectIdentifier edContentType = seq[0].getOID();
                        eAlgId = seq[1].toByteArray();
                        if (!seq[2].isContextSpecific((byte)0)) {
                            throw new IOException("unsupported encrypted content type " + seq[2].tag);
                        }
                        byte newTag = 4;
                        if (seq[2].isConstructed()) {
                            newTag = (byte)(newTag | 0x20);
                        }
                        seq[2].resetTag(newTag);
                        safeContentsData = seq[2].getOctetString();
                        DerInputStream in = seq[1].toDerInputStream();
                        ObjectIdentifier algOid = in.getOID();
                        AlgorithmParameters algParams = this.parseAlgParameters(in);
                        int ic = 0;
                        if (algParams != null) {
                            PBEParameterSpec pbeSpec;
                            try {
                                pbeSpec = algParams.getParameterSpec(PBEParameterSpec.class);
                            }
                            catch (InvalidParameterSpecException ipse) {
                                throw new IOException("Invalid PBE algorithm parameters");
                            }
                            ic = pbeSpec.getIterationCount();
                            if (ic > 5000000) {
                                throw new IOException("PBE iteration count too large");
                            }
                        }
                        if (debug != null) {
                            debug.println("Loading PKCS#7 encryptedData (" + new AlgorithmId(algOid).getName() + " iterations: " + ic + ")");
                        }
                        while (true) {
                            try {
                                SecretKey skey = this.getPBEKey(password);
                                Cipher cipher = Cipher.getInstance(algOid.toString());
                                cipher.init(2, (Key)skey, algParams);
                                safeContentsData = cipher.doFinal(safeContentsData);
                                break block36;
                            }
                            catch (Exception e) {
                                if (password.length == 0) {
                                    password = new char[1];
                                    continue;
                                }
                                throw new IOException("keystore password was incorrect", new UnrecoverableKeyException("failed to decrypt safe contents entry: " + e));
                            }
                            break;
                        }
                    }
                    throw new IOException("public key protected PKCS12 not supported");
                }
            }
            DerInputStream sc = new DerInputStream(safeContentsData);
            this.loadSafeContents(sc, password);
        }
        if (password != null && s.available() > 0) {
            MacData macData = new MacData(s);
            int ic = macData.getIterations();
            try {
                if (ic > 5000000) {
                    throw new InvalidAlgorithmParameterException("MAC iteration count too large: " + ic);
                }
                String algName = macData.getDigestAlgName().toUpperCase(Locale.ENGLISH);
                algName = algName.replace("-", "");
                Mac m = Mac.getInstance("HmacPBE" + algName);
                PBEParameterSpec params = new PBEParameterSpec(macData.getSalt(), ic);
                SecretKey key = this.getPBEKey(password);
                m.init(key, params);
                m.update(authSafeData);
                byte[] macResult = m.doFinal();
                if (debug != null) {
                    debug.println("Checking keystore integrity (" + m.getAlgorithm() + " iterations: " + ic + ")");
                }
                if (!MessageDigest.isEqual(macData.getDigest(), macResult)) {
                    throw new UnrecoverableKeyException("Failed PKCS12 integrity checking");
                }
            }
            catch (Exception e) {
                throw new IOException("Integrity check failed: " + e, e);
            }
        }
        PrivateKeyEntry[] list = this.keyList.toArray(new PrivateKeyEntry[this.keyList.size()]);
        for (int m = 0; m < list.length; ++m) {
            PrivateKeyEntry entry = list[m];
            if (entry.keyId == null) continue;
            ArrayList<X509Certificate> chain = new ArrayList<X509Certificate>();
            X509Certificate cert = this.findMatchedCertificate(entry);
            block9: while (cert != null) {
                if (!chain.isEmpty()) {
                    for (X509Certificate chainCert : chain) {
                        if (!cert.equals(chainCert)) continue;
                        if (debug == null) break block9;
                        debug.println("Loop detected in certificate chain. Skip adding repeated cert to chain. Subject: " + cert.getSubjectX500Principal().toString());
                        break block9;
                    }
                }
                chain.add(cert);
                X500Principal issuerDN = cert.getIssuerX500Principal();
                if (issuerDN.equals(cert.getSubjectX500Principal())) break;
                cert = this.certsMap.get(issuerDN);
            }
            if (chain.size() <= 0) continue;
            entry.chain = chain.toArray(new Certificate[chain.size()]);
        }
        if (debug != null) {
            if (this.privateKeyCount > 0) {
                debug.println("Loaded " + this.privateKeyCount + " protected private key(s)");
            }
            if (this.secretKeyCount > 0) {
                debug.println("Loaded " + this.secretKeyCount + " protected secret key(s)");
            }
            if (this.certificateCount > 0) {
                debug.println("Loaded " + this.certificateCount + " certificate(s)");
            }
        }
        this.certEntries.clear();
        this.certsMap.clear();
        this.keyList.clear();
    }

    private X509Certificate findMatchedCertificate(PrivateKeyEntry entry) {
        CertEntry keyIdMatch = null;
        CertEntry aliasMatch = null;
        for (CertEntry ce : this.certEntries) {
            if (Arrays.equals(entry.keyId, ce.keyId)) {
                keyIdMatch = ce;
                if (!entry.alias.equalsIgnoreCase(ce.alias)) continue;
                return ce.cert;
            }
            if (!entry.alias.equalsIgnoreCase(ce.alias)) continue;
            aliasMatch = ce;
        }
        if (keyIdMatch != null) {
            return keyIdMatch.cert;
        }
        if (aliasMatch != null) {
            return aliasMatch.cert;
        }
        return null;
    }

    private void loadSafeContents(DerInputStream stream, char[] password) throws IOException, NoSuchAlgorithmException, CertificateException {
        DerValue[] safeBags = stream.getSequence(2);
        int count = safeBags.length;
        for (int i = 0; i < count; ++i) {
            DerValue[] attrSet;
            Object bagItem = null;
            DerInputStream sbi = safeBags[i].toDerInputStream();
            ObjectIdentifier bagId = sbi.getOID();
            DerValue bagValue = sbi.getDerValue();
            if (!bagValue.isContextSpecific((byte)0)) {
                throw new IOException("unsupported PKCS12 bag value type " + bagValue.tag);
            }
            bagValue = bagValue.data.getDerValue();
            if (bagId.equals((Object)PKCS8ShroudedKeyBag_OID)) {
                PrivateKeyEntry kEntry = new PrivateKeyEntry();
                kEntry.protectedPrivKey = bagValue.toByteArray();
                bagItem = kEntry;
                ++this.privateKeyCount;
            } else if (bagId.equals((Object)CertBag_OID)) {
                DerInputStream cs = new DerInputStream(bagValue.toByteArray());
                DerValue[] certValues = cs.getSequence(2);
                if (certValues.length != 2) {
                    throw new IOException("Invalid length for CertBag");
                }
                ObjectIdentifier certId = certValues[0].getOID();
                if (!certValues[1].isContextSpecific((byte)0)) {
                    throw new IOException("unsupported PKCS12 cert value type " + certValues[1].tag);
                }
                DerValue certValue = certValues[1].data.getDerValue();
                CertificateFactory cf = CertificateFactory.getInstance("X509");
                X509Certificate cert = (X509Certificate)cf.generateCertificate(new ByteArrayInputStream(certValue.getOctetString()));
                bagItem = cert;
                ++this.certificateCount;
            } else if (bagId.equals((Object)SecretBag_OID)) {
                DerInputStream ss = new DerInputStream(bagValue.toByteArray());
                DerValue[] secretValues = ss.getSequence(2);
                if (secretValues.length != 2) {
                    throw new IOException("Invalid length for SecretBag");
                }
                ObjectIdentifier secretId = secretValues[0].getOID();
                if (!secretValues[1].isContextSpecific((byte)0)) {
                    throw new IOException("unsupported PKCS12 secret value type " + secretValues[1].tag);
                }
                DerValue secretValue = secretValues[1].data.getDerValue();
                SecretKeyEntry kEntry = new SecretKeyEntry();
                kEntry.protectedSecretKey = secretValue.getOctetString();
                bagItem = kEntry;
                ++this.secretKeyCount;
            } else if (debug != null) {
                debug.println("Unsupported PKCS12 bag type: " + bagId);
            }
            try {
                attrSet = sbi.getSet(3);
            }
            catch (IOException e) {
                attrSet = null;
            }
            String alias = null;
            byte[] keyId = null;
            ObjectIdentifier[] trustedKeyUsage = null;
            HashSet<PKCS12Attribute> attributes = new HashSet<PKCS12Attribute>();
            if (attrSet != null) {
                for (int j = 0; j < attrSet.length; ++j) {
                    DerValue[] valSet;
                    byte[] encoded = attrSet[j].toByteArray();
                    DerInputStream as = new DerInputStream(encoded);
                    DerValue[] attrSeq = as.getSequence(2);
                    if (attrSeq.length != 2) {
                        throw new IOException("Invalid length for Attribute");
                    }
                    ObjectIdentifier attrId = attrSeq[0].getOID();
                    DerInputStream vs = new DerInputStream(attrSeq[1].toByteArray());
                    try {
                        valSet = vs.getSet(1);
                    }
                    catch (IOException e) {
                        throw new IOException("Attribute " + attrId + " should have a value " + e.getMessage());
                    }
                    if (attrId.equals((Object)PKCS9FriendlyName_OID)) {
                        alias = valSet[0].getBMPString();
                        continue;
                    }
                    if (attrId.equals((Object)PKCS9LocalKeyId_OID)) {
                        keyId = valSet[0].getOctetString();
                        continue;
                    }
                    if (attrId.equals((Object)TrustedKeyUsage_OID)) {
                        trustedKeyUsage = new ObjectIdentifier[valSet.length];
                        for (int k = 0; k < valSet.length; ++k) {
                            trustedKeyUsage[k] = valSet[k].getOID();
                        }
                        continue;
                    }
                    attributes.add(new PKCS12Attribute(encoded));
                }
            }
            if (bagItem instanceof KeyEntry) {
                KeyEntry entry = (KeyEntry)bagItem;
                if (bagItem instanceof PrivateKeyEntry && keyId == null) {
                    if (this.privateKeyCount != 1) continue;
                    keyId = "01".getBytes("UTF8");
                }
                entry.keyId = keyId;
                String keyIdStr = new String(keyId, "UTF8");
                Date date = null;
                if (keyIdStr.startsWith("Time ")) {
                    try {
                        date = new Date(Long.parseLong(keyIdStr.substring(5)));
                    }
                    catch (Exception e) {
                        date = null;
                    }
                }
                if (date == null) {
                    date = new Date();
                }
                entry.date = date;
                if (bagItem instanceof PrivateKeyEntry) {
                    this.keyList.add((PrivateKeyEntry)entry);
                }
                if (entry.attributes == null) {
                    entry.attributes = new HashSet();
                }
                entry.attributes.addAll(attributes);
                if (alias == null) {
                    alias = this.getUnfriendlyName();
                }
                entry.alias = alias;
                this.entries.put(alias.toLowerCase(Locale.ENGLISH), entry);
                continue;
            }
            if (!(bagItem instanceof X509Certificate)) continue;
            X509Certificate cert = (X509Certificate)bagItem;
            if (keyId == null && this.privateKeyCount == 1 && i == 0) {
                keyId = "01".getBytes("UTF8");
            }
            if (trustedKeyUsage != null) {
                if (alias == null) {
                    alias = this.getUnfriendlyName();
                }
                CertEntry certEntry = new CertEntry(cert, keyId, alias, trustedKeyUsage, attributes);
                this.entries.put(alias.toLowerCase(Locale.ENGLISH), certEntry);
            } else {
                this.certEntries.add(new CertEntry(cert, keyId, alias));
            }
            X500Principal subjectDN = cert.getSubjectX500Principal();
            if (subjectDN == null || this.certsMap.containsKey(subjectDN)) continue;
            this.certsMap.put(subjectDN, cert);
        }
    }

    private String getUnfriendlyName() {
        ++this.counter;
        return String.valueOf(this.counter);
    }

    static {
        try {
            PKCS8ShroudedKeyBag_OID = new ObjectIdentifier(keyBag);
            CertBag_OID = new ObjectIdentifier(certBag);
            SecretBag_OID = new ObjectIdentifier(secretBag);
            PKCS9FriendlyName_OID = new ObjectIdentifier(pkcs9Name);
            PKCS9LocalKeyId_OID = new ObjectIdentifier(pkcs9KeyId);
            PKCS9CertType_OID = new ObjectIdentifier(pkcs9certType);
            pbeWithSHAAnd40BitRC2CBC_OID = new ObjectIdentifier(pbeWithSHAAnd40BitRC2CBC);
            pbeWithSHAAnd3KeyTripleDESCBC_OID = new ObjectIdentifier(pbeWithSHAAnd3KeyTripleDESCBC);
            TrustedKeyUsage_OID = new ObjectIdentifier(TrustedKeyUsage);
            AnyUsage = new ObjectIdentifier[]{new ObjectIdentifier(AnyExtendedKeyUsage)};
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static class CertEntry
    extends Entry {
        final X509Certificate cert;
        ObjectIdentifier[] trustedKeyUsage;

        CertEntry(X509Certificate cert, byte[] keyId, String alias) {
            this(cert, keyId, alias, null, null);
        }

        CertEntry(X509Certificate cert, byte[] keyId, String alias, ObjectIdentifier[] trustedKeyUsage, Set<? extends PKCS12Attribute> attributes) {
            this.date = new Date();
            this.cert = cert;
            this.keyId = keyId;
            this.alias = alias;
            this.trustedKeyUsage = trustedKeyUsage;
            this.attributes = new HashSet();
            if (attributes != null) {
                this.attributes.addAll(attributes);
            }
        }
    }

    private static class SecretKeyEntry
    extends KeyEntry {
        byte[] protectedSecretKey;

        private SecretKeyEntry() {
        }
    }

    private static class PrivateKeyEntry
    extends KeyEntry {
        byte[] protectedPrivKey;
        Certificate[] chain;

        private PrivateKeyEntry() {
        }
    }

    private static class KeyEntry
    extends Entry {
        private KeyEntry() {
        }
    }

    private static class Entry {
        Date date;
        String alias;
        byte[] keyId;
        Set<PKCS12Attribute> attributes;

        private Entry() {
        }
    }
}

