/*
 * Decompiled with CFR 0.152.
 */
package sun.security.pkcs12;

import java.io.IOException;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.regex.Pattern;
import sun.security.util.Debug;
import sun.security.util.DerInputStream;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;
import sun.security.util.ObjectIdentifier;

public final class PKCS12Attribute {
    private static final Pattern COLON_SEPARATED_HEX_PAIRS = Pattern.compile("^[0-9a-fA-F]{2}(:[0-9a-fA-F]{2})+$");
    private String name;
    private String value;
    private byte[] encoded;
    private int hashValue = -1;

    public PKCS12Attribute(String name, String value) {
        ObjectIdentifier type;
        if (name == null || value == null) {
            throw new NullPointerException();
        }
        try {
            type = new ObjectIdentifier(name);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Incorrect format: name", e);
        }
        this.name = name;
        int length = value.length();
        String[] values = value.charAt(0) == '[' && value.charAt(length - 1) == ']' ? value.substring(1, length - 1).split(", ") : new String[]{value};
        this.value = value;
        try {
            this.encoded = this.encode(type, values);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Incorrect format: value", e);
        }
    }

    public PKCS12Attribute(byte[] encoded) {
        if (encoded == null) {
            throw new NullPointerException();
        }
        this.encoded = (byte[])encoded.clone();
        try {
            this.parse(encoded);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Incorrect format: encoded", e);
        }
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    public byte[] getEncoded() {
        return (byte[])this.encoded.clone();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof PKCS12Attribute)) {
            return false;
        }
        return Arrays.equals(this.encoded, ((PKCS12Attribute)obj).getEncoded());
    }

    public int hashCode() {
        if (this.hashValue == -1) {
            Arrays.hashCode(this.encoded);
        }
        return this.hashValue;
    }

    public String toString() {
        return this.name + "=" + this.value;
    }

    private byte[] encode(ObjectIdentifier type, String[] values) throws IOException {
        DerOutputStream attribute = new DerOutputStream();
        attribute.putOID(type);
        DerOutputStream attrContent = new DerOutputStream();
        for (String value : values) {
            if (COLON_SEPARATED_HEX_PAIRS.matcher(value).matches()) {
                byte[] bytes = new BigInteger(value.replace(":", ""), 16).toByteArray();
                if (bytes[0] == 0) {
                    bytes = Arrays.copyOfRange(bytes, 1, bytes.length);
                }
                attrContent.putOctetString(bytes);
                continue;
            }
            attrContent.putUTF8String(value);
        }
        attribute.write((byte)49, attrContent);
        DerOutputStream attributeValue = new DerOutputStream();
        attributeValue.write((byte)48, attribute);
        return attributeValue.toByteArray();
    }

    private void parse(byte[] encoded) throws IOException {
        DerInputStream attributeValue = new DerInputStream(encoded);
        DerValue[] attrSeq = attributeValue.getSequence(2);
        if (attrSeq.length != 2) {
            throw new IOException("Invalid length for PKCS12Attribute");
        }
        ObjectIdentifier type = attrSeq[0].getOID();
        DerInputStream attrContent = new DerInputStream(attrSeq[1].toByteArray());
        DerValue[] attrValueSet = attrContent.getSet(1);
        Object[] values = new String[attrValueSet.length];
        for (int i = 0; i < attrValueSet.length; ++i) {
            String printableString;
            values[i] = attrValueSet[i].tag == 4 ? Debug.toString(attrValueSet[i].getOctetString()) : ((printableString = attrValueSet[i].getAsString()) != null ? printableString : (attrValueSet[i].tag == 6 ? attrValueSet[i].getOID().toString() : (attrValueSet[i].tag == 24 ? attrValueSet[i].getGeneralizedTime().toString() : (attrValueSet[i].tag == 23 ? attrValueSet[i].getUTCTime().toString() : (attrValueSet[i].tag == 2 ? attrValueSet[i].getBigInteger().toString() : (attrValueSet[i].tag == 1 ? String.valueOf(attrValueSet[i].getBoolean()) : Debug.toString(attrValueSet[i].getDataBytes())))))));
        }
        this.name = type.toString();
        this.value = values.length == 1 ? values[0] : Arrays.toString(values);
    }
}

