/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import java.nio.Buffer;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteOrder;
import java.nio.HeapDoubleBuffer;
import java.nio.ReadOnlyBufferException;

public abstract class DoubleBuffer
extends Buffer
implements Comparable<DoubleBuffer> {
    final double[] hb;
    final int offset;
    boolean isReadOnly;

    DoubleBuffer(int mark, int pos, int lim, int cap, double[] hb, int offset) {
        super(mark, pos, lim, cap);
        this.hb = hb;
        this.offset = offset;
    }

    DoubleBuffer(int mark, int pos, int lim, int cap) {
        this(mark, pos, lim, cap, null, 0);
    }

    public static DoubleBuffer allocate(int capacity) {
        if (capacity < 0) {
            throw new IllegalArgumentException();
        }
        return new HeapDoubleBuffer(capacity, capacity);
    }

    public static DoubleBuffer wrap(double[] array, int offset, int length) {
        try {
            return new HeapDoubleBuffer(array, offset, length);
        }
        catch (IllegalArgumentException x) {
            throw new IndexOutOfBoundsException();
        }
    }

    public static DoubleBuffer wrap(double[] array) {
        return DoubleBuffer.wrap(array, 0, array.length);
    }

    public abstract DoubleBuffer slice();

    public abstract DoubleBuffer duplicate();

    public abstract DoubleBuffer asReadOnlyBuffer();

    public abstract double get();

    public abstract DoubleBuffer put(double var1);

    public abstract double get(int var1);

    public abstract DoubleBuffer put(int var1, double var2);

    public DoubleBuffer get(double[] dst, int offset, int length) {
        DoubleBuffer.checkBounds(offset, length, dst.length);
        if (length > this.remaining()) {
            throw new BufferUnderflowException();
        }
        int end = offset + length;
        for (int i = offset; i < end; ++i) {
            dst[i] = this.get();
        }
        return this;
    }

    public DoubleBuffer get(double[] dst) {
        return this.get(dst, 0, dst.length);
    }

    public DoubleBuffer put(DoubleBuffer src) {
        if (src == this) {
            throw new IllegalArgumentException();
        }
        int n = src.remaining();
        if (n > this.remaining()) {
            throw new BufferOverflowException();
        }
        for (int i = 0; i < n; ++i) {
            this.put(src.get());
        }
        return this;
    }

    public DoubleBuffer put(double[] src, int offset, int length) {
        DoubleBuffer.checkBounds(offset, length, src.length);
        if (length > this.remaining()) {
            throw new BufferOverflowException();
        }
        int end = offset + length;
        for (int i = offset; i < end; ++i) {
            this.put(src[i]);
        }
        return this;
    }

    public final DoubleBuffer put(double[] src) {
        return this.put(src, 0, src.length);
    }

    @Override
    public final boolean hasArray() {
        return this.hb != null && !this.isReadOnly;
    }

    public final double[] array() {
        if (this.hb == null) {
            throw new UnsupportedOperationException();
        }
        if (this.isReadOnly) {
            throw new ReadOnlyBufferException();
        }
        return this.hb;
    }

    @Override
    public final int arrayOffset() {
        if (this.hb == null) {
            throw new UnsupportedOperationException();
        }
        if (this.isReadOnly) {
            throw new ReadOnlyBufferException();
        }
        return this.offset;
    }

    public abstract DoubleBuffer compact();

    @Override
    public abstract boolean isDirect();

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getClass().getName());
        sb.append("[pos=");
        sb.append(this.position());
        sb.append(" lim=");
        sb.append(this.limit());
        sb.append(" cap=");
        sb.append(this.capacity());
        sb.append("]");
        return sb.toString();
    }

    public int hashCode() {
        int h = 1;
        int p = this.position();
        for (int i = this.limit() - 1; i >= p; --i) {
            h = 31 * h + (int)this.get(i);
        }
        return h;
    }

    public boolean equals(Object ob) {
        if (this == ob) {
            return true;
        }
        if (!(ob instanceof DoubleBuffer)) {
            return false;
        }
        DoubleBuffer that = (DoubleBuffer)ob;
        int thisPos = this.position();
        int thisLim = this.limit();
        int thatPos = that.position();
        int thatLim = that.limit();
        int thisRem = thisLim - thisPos;
        int thatRem = thatLim - thatPos;
        if (thisRem < 0 || thisRem != thatRem) {
            return false;
        }
        int i = thisLim - 1;
        int j = thatLim - 1;
        while (i >= thisPos) {
            if (!DoubleBuffer.equals(this.get(i), that.get(j))) {
                return false;
            }
            --i;
            --j;
        }
        return true;
    }

    private static boolean equals(double x, double y) {
        return x == y || Double.isNaN(x) && Double.isNaN(y);
    }

    @Override
    public int compareTo(DoubleBuffer that) {
        int thisPos = this.position();
        int thisRem = this.limit() - thisPos;
        int thatPos = that.position();
        int thatRem = that.limit() - thatPos;
        int length = Math.min(thisRem, thatRem);
        if (length < 0) {
            return -1;
        }
        int n = thisPos + Math.min(thisRem, thatRem);
        int i = thisPos;
        int j = thatPos;
        while (i < n) {
            int cmp = DoubleBuffer.compare(this.get(i), that.get(j));
            if (cmp != 0) {
                return cmp;
            }
            ++i;
            ++j;
        }
        return thisRem - thatRem;
    }

    private static int compare(double x, double y) {
        return x < y ? -1 : (x > y ? 1 : (x == y ? 0 : (Double.isNaN(x) ? (Double.isNaN(y) ? 0 : 1) : -1)));
    }

    public abstract ByteOrder order();
}

