/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import java.io.IOException;
import java.nio.Buffer;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteOrder;
import java.nio.HeapCharBuffer;
import java.nio.ReadOnlyBufferException;
import java.nio.StringCharBuffer;

public abstract class CharBuffer
extends Buffer
implements Comparable<CharBuffer>,
Appendable,
CharSequence,
Readable {
    final char[] hb;
    final int offset;
    boolean isReadOnly;

    CharBuffer(int mark, int pos, int lim, int cap, char[] hb, int offset) {
        super(mark, pos, lim, cap);
        this.hb = hb;
        this.offset = offset;
    }

    CharBuffer(int mark, int pos, int lim, int cap) {
        this(mark, pos, lim, cap, null, 0);
    }

    public static CharBuffer allocate(int capacity) {
        if (capacity < 0) {
            throw new IllegalArgumentException();
        }
        return new HeapCharBuffer(capacity, capacity);
    }

    public static CharBuffer wrap(char[] array, int offset, int length) {
        try {
            return new HeapCharBuffer(array, offset, length);
        }
        catch (IllegalArgumentException x) {
            throw new IndexOutOfBoundsException();
        }
    }

    public static CharBuffer wrap(char[] array) {
        return CharBuffer.wrap(array, 0, array.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read(CharBuffer target) throws IOException {
        int limit = this.limit();
        int pos = this.position();
        int remaining = limit - pos;
        assert (remaining >= 0);
        if (remaining <= 0) {
            return -1;
        }
        int targetRemaining = target.remaining();
        assert (targetRemaining >= 0);
        if (targetRemaining <= 0) {
            return 0;
        }
        int n = Math.min(remaining, targetRemaining);
        if (targetRemaining < remaining) {
            this.limit(pos + n);
        }
        try {
            if (n > 0) {
                target.put(this);
            }
        }
        finally {
            this.limit(limit);
        }
        return n;
    }

    public static CharBuffer wrap(CharSequence csq, int start, int end) {
        try {
            return new StringCharBuffer(csq, start, end);
        }
        catch (IllegalArgumentException x) {
            throw new IndexOutOfBoundsException();
        }
    }

    public static CharBuffer wrap(CharSequence csq) {
        return CharBuffer.wrap(csq, 0, csq.length());
    }

    public abstract CharBuffer slice();

    public abstract CharBuffer duplicate();

    public abstract CharBuffer asReadOnlyBuffer();

    public abstract char get();

    public abstract CharBuffer put(char var1);

    public abstract char get(int var1);

    public abstract CharBuffer put(int var1, char var2);

    public CharBuffer get(char[] dst, int offset, int length) {
        CharBuffer.checkBounds(offset, length, dst.length);
        if (length > this.remaining()) {
            throw new BufferUnderflowException();
        }
        int end = offset + length;
        for (int i = offset; i < end; ++i) {
            dst[i] = this.get();
        }
        return this;
    }

    public CharBuffer get(char[] dst) {
        return this.get(dst, 0, dst.length);
    }

    public CharBuffer put(CharBuffer src) {
        if (src == this) {
            throw new IllegalArgumentException();
        }
        int n = src.remaining();
        if (n > this.remaining()) {
            throw new BufferOverflowException();
        }
        for (int i = 0; i < n; ++i) {
            this.put(src.get());
        }
        return this;
    }

    public CharBuffer put(char[] src, int offset, int length) {
        CharBuffer.checkBounds(offset, length, src.length);
        if (length > this.remaining()) {
            throw new BufferOverflowException();
        }
        int end = offset + length;
        for (int i = offset; i < end; ++i) {
            this.put(src[i]);
        }
        return this;
    }

    public final CharBuffer put(char[] src) {
        return this.put(src, 0, src.length);
    }

    public CharBuffer put(String src, int start, int end) {
        CharBuffer.checkBounds(start, end - start, src.length());
        for (int i = start; i < end; ++i) {
            this.put(src.charAt(i));
        }
        return this;
    }

    public final CharBuffer put(String src) {
        return this.put(src, 0, src.length());
    }

    @Override
    public final boolean hasArray() {
        return this.hb != null && !this.isReadOnly;
    }

    public final char[] array() {
        if (this.hb == null) {
            throw new UnsupportedOperationException();
        }
        if (this.isReadOnly) {
            throw new ReadOnlyBufferException();
        }
        return this.hb;
    }

    @Override
    public final int arrayOffset() {
        if (this.hb == null) {
            throw new UnsupportedOperationException();
        }
        if (this.isReadOnly) {
            throw new ReadOnlyBufferException();
        }
        return this.offset;
    }

    public abstract CharBuffer compact();

    @Override
    public abstract boolean isDirect();

    public int hashCode() {
        int h = 1;
        int p = this.position();
        for (int i = this.limit() - 1; i >= p; --i) {
            h = 31 * h + this.get(i);
        }
        return h;
    }

    public boolean equals(Object ob) {
        if (this == ob) {
            return true;
        }
        if (!(ob instanceof CharBuffer)) {
            return false;
        }
        CharBuffer that = (CharBuffer)ob;
        int thisPos = this.position();
        int thisLim = this.limit();
        int thatPos = that.position();
        int thatLim = that.limit();
        int thisRem = thisLim - thisPos;
        int thatRem = thatLim - thatPos;
        if (thisRem < 0 || thisRem != thatRem) {
            return false;
        }
        int i = thisLim - 1;
        int j = thatLim - 1;
        while (i >= thisPos) {
            if (!CharBuffer.equals(this.get(i), that.get(j))) {
                return false;
            }
            --i;
            --j;
        }
        return true;
    }

    private static boolean equals(char x, char y) {
        return x == y;
    }

    @Override
    public int compareTo(CharBuffer that) {
        int thisPos = this.position();
        int thisRem = this.limit() - thisPos;
        int thatPos = that.position();
        int thatRem = that.limit() - thatPos;
        int length = Math.min(thisRem, thatRem);
        if (length < 0) {
            return -1;
        }
        int n = thisPos + Math.min(thisRem, thatRem);
        int i = thisPos;
        int j = thatPos;
        while (i < n) {
            int cmp = CharBuffer.compare(this.get(i), that.get(j));
            if (cmp != 0) {
                return cmp;
            }
            ++i;
            ++j;
        }
        return thisRem - thatRem;
    }

    private static int compare(char x, char y) {
        return Character.compare(x, y);
    }

    @Override
    public String toString() {
        return this.toString(this.position(), this.limit());
    }

    abstract String toString(int var1, int var2);

    @Override
    public final int length() {
        return this.remaining();
    }

    @Override
    public final char charAt(int index) {
        return this.get(this.position() + this.checkIndex(index, 1));
    }

    @Override
    public abstract CharBuffer subSequence(int var1, int var2);

    @Override
    public CharBuffer append(CharSequence csq) {
        if (csq == null) {
            return this.put("null");
        }
        return this.put(csq.toString());
    }

    @Override
    public CharBuffer append(CharSequence csq, int start, int end) {
        CharSequence cs = csq == null ? "null" : csq;
        return this.put(cs.subSequence(start, end).toString());
    }

    @Override
    public CharBuffer append(char c) {
        return this.put(c);
    }

    public abstract ByteOrder order();
}

