/*
 * Decompiled with CFR 0.152.
 */
package com.sun.naming.internal;

import sun.misc.ObjectInputFilter;
import sun.security.util.SecurityProperties;

public final class ObjectFactoriesFilter {
    private static final String FACTORIES_FILTER_PROPNAME = "jdk.jndi.object.factoriesFilter";
    private static final String DEFAULT_SP_VALUE = "*";
    private static final ObjectInputFilter GLOBAL = ObjectInputFilter.Config.createFilter(ObjectFactoriesFilter.getFilterPropertyValue());

    public static boolean canInstantiateObjectsFactory(Class<?> factoryClass) {
        return ObjectFactoriesFilter.checkInput(new FactoryInfo(factoryClass));
    }

    private static boolean checkInput(FactoryInfo factoryInfo) {
        ObjectInputFilter.Status result = GLOBAL.checkInput(factoryInfo);
        return result != ObjectInputFilter.Status.REJECTED;
    }

    private ObjectFactoriesFilter() {
        throw new InternalError("Not instantiable");
    }

    private static String getFilterPropertyValue() {
        String propVal = SecurityProperties.privilegedGetOverridable(FACTORIES_FILTER_PROPNAME);
        return propVal != null ? propVal : DEFAULT_SP_VALUE;
    }

    private static class FactoryInfo
    implements ObjectInputFilter.FilterInfo {
        private final Class<?> factoryClass;

        private FactoryInfo(Class<?> factoryClass) {
            this.factoryClass = factoryClass;
        }

        @Override
        public Class<?> serialClass() {
            return this.factoryClass;
        }

        @Override
        public long arrayLength() {
            return -1L;
        }

        @Override
        public long depth() {
            return 1L;
        }

        @Override
        public long references() {
            return 0L;
        }

        @Override
        public long streamBytes() {
            return 0L;
        }
    }
}

