/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jndi.ldap.ext;

import com.sun.jndi.ldap.Connection;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.Principal;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.naming.ldap.StartTlsResponse;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import sun.security.util.HostnameChecker;

public final class StartTlsResponseImpl
extends StartTlsResponse {
    private static final boolean debug = false;
    private static final int DNSNAME_TYPE = 2;
    private transient String hostname = null;
    private transient Connection ldapConnection = null;
    private transient InputStream originalInputStream = null;
    private transient OutputStream originalOutputStream = null;
    private transient SSLSocket sslSocket = null;
    private transient SSLSocketFactory defaultFactory = null;
    private transient SSLSocketFactory currentFactory = null;
    private transient String[] suites = null;
    private transient HostnameVerifier verifier = null;
    private transient boolean isClosed = true;
    private static final long serialVersionUID = -1126624615143411328L;

    @Override
    public void setEnabledCipherSuites(String[] suites) {
        this.suites = suites;
    }

    @Override
    public void setHostnameVerifier(HostnameVerifier verifier) {
        this.verifier = verifier;
    }

    @Override
    public SSLSession negotiate() throws IOException {
        return this.negotiate(null);
    }

    @Override
    public SSLSession negotiate(SSLSocketFactory factory) throws IOException {
        if (this.isClosed && this.sslSocket != null) {
            throw new IOException("TLS connection is closed.");
        }
        if (factory == null) {
            factory = this.getDefaultFactory();
        }
        SSLSession sslSession = this.startHandshake(factory).getSession();
        SSLPeerUnverifiedException verifExcep = null;
        try {
            if (this.verify(this.hostname, sslSession)) {
                this.isClosed = false;
                return sslSession;
            }
        }
        catch (SSLPeerUnverifiedException e) {
            verifExcep = e;
        }
        if (this.verifier != null && this.verifier.verify(this.hostname, sslSession)) {
            this.isClosed = false;
            return sslSession;
        }
        this.close();
        sslSession.invalidate();
        if (verifExcep == null) {
            verifExcep = new SSLPeerUnverifiedException("hostname of the server '" + this.hostname + "' does not match the hostname in the " + "server's certificate.");
        }
        throw verifExcep;
    }

    @Override
    public void close() throws IOException {
        if (this.isClosed) {
            return;
        }
        this.ldapConnection.replaceStreams(this.originalInputStream, this.originalOutputStream, false);
        this.sslSocket.close();
        this.isClosed = true;
    }

    public void setConnection(Connection ldapConnection, String hostname) {
        this.ldapConnection = ldapConnection;
        this.hostname = hostname != null ? hostname : ldapConnection.host;
        this.originalInputStream = ldapConnection.inStream;
        this.originalOutputStream = ldapConnection.outStream;
    }

    private SSLSocketFactory getDefaultFactory() throws IOException {
        if (this.defaultFactory != null) {
            return this.defaultFactory;
        }
        this.defaultFactory = (SSLSocketFactory)SSLSocketFactory.getDefault();
        return this.defaultFactory;
    }

    private SSLSocket startHandshake(SSLSocketFactory factory) throws IOException {
        if (this.ldapConnection == null) {
            throw new IllegalStateException("LDAP connection has not been set. TLS requires an existing LDAP connection.");
        }
        if (factory != this.currentFactory) {
            this.sslSocket = (SSLSocket)factory.createSocket(this.ldapConnection.sock, this.ldapConnection.host, this.ldapConnection.port, false);
            this.currentFactory = factory;
        }
        if (this.suites != null) {
            this.sslSocket.setEnabledCipherSuites(this.suites);
        }
        try {
            this.sslSocket.startHandshake();
            this.ldapConnection.replaceStreams(this.sslSocket.getInputStream(), this.sslSocket.getOutputStream(), true);
        }
        catch (IOException e) {
            this.sslSocket.close();
            this.isClosed = true;
            throw e;
        }
        return this.sslSocket;
    }

    private boolean verify(String hostname, SSLSession session) throws SSLPeerUnverifiedException {
        Certificate[] certs = null;
        if (hostname != null && hostname.startsWith("[") && hostname.endsWith("]")) {
            hostname = hostname.substring(1, hostname.length() - 1);
        }
        try {
            HostnameChecker checker = HostnameChecker.getInstance((byte)2);
            if (session.getCipherSuite().startsWith("TLS_KRB5")) {
                Principal principal = StartTlsResponseImpl.getPeerPrincipal(session);
                if (!HostnameChecker.match(hostname, principal)) {
                    throw new SSLPeerUnverifiedException("hostname of the kerberos principal:" + principal + " does not match the hostname:" + hostname);
                }
            } else {
                certs = session.getPeerCertificates();
                if (!(certs[0] instanceof X509Certificate)) {
                    throw new SSLPeerUnverifiedException("Received a non X509Certificate from the server");
                }
                X509Certificate peerCert = (X509Certificate)certs[0];
                checker.match(hostname, peerCert);
            }
            return true;
        }
        catch (SSLPeerUnverifiedException e) {
            String cipher = session.getCipherSuite();
            if (cipher != null && cipher.indexOf("_anon_") != -1) {
                return true;
            }
            throw e;
        }
        catch (CertificateException e) {
            throw (SSLPeerUnverifiedException)new SSLPeerUnverifiedException("hostname of the server '" + hostname + "' does not match the hostname in the " + "server's certificate.").initCause(e);
        }
    }

    private static Principal getPeerPrincipal(SSLSession session) throws SSLPeerUnverifiedException {
        Principal principal;
        try {
            principal = session.getPeerPrincipal();
        }
        catch (AbstractMethodError e) {
            principal = null;
        }
        return principal;
    }
}

